/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins;
import com.oracle.graal.python.builtins.modules.io.PFileIO;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.thread.PLock;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;

public final class PBuffered
extends PythonBuiltinObject {
    private Object raw;
    private boolean ok = false;
    private boolean detached = false;
    private final boolean readable;
    private final boolean writable;
    private boolean finalizing;
    private PFileIO fileioRaw;
    private long absPos;
    private byte[] buffer;
    private int pos;
    private long rawPos;
    private int readEnd;
    private int writePos;
    private int writeEnd;
    private PLock lock;
    private long owner;
    @CompilerDirectives.CompilationFinal
    private int bufferSize;
    @CompilerDirectives.CompilationFinal
    private int bufferMask;

    public PBuffered(Object cls, Shape instanceShape, boolean readable, boolean writable) {
        super(cls, instanceShape);
        this.readable = readable;
        this.writable = writable;
        this.finalizing = false;
    }

    public void setBufferMask(int bufferMask) {
        this.bufferMask = bufferMask;
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public Object getRaw() {
        return this.raw;
    }

    public void setRaw(Object newRaw, boolean isFileIO) {
        this.raw = newRaw;
        this.fileioRaw = isFileIO ? (PFileIO)newRaw : null;
    }

    public void clearRaw() {
        this.raw = null;
        this.fileioRaw = null;
    }

    public boolean isOK() {
        return this.ok;
    }

    public void setOK(boolean ok) {
        this.ok = ok;
    }

    public boolean isDetached() {
        return this.detached;
    }

    public void setDetached(boolean detached) {
        this.detached = detached;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isFinalizing() {
        return this.finalizing;
    }

    public void setFinalizing(boolean finalizing) {
        this.finalizing = finalizing;
    }

    public boolean isFastClosedChecks() {
        return this.fileioRaw != null;
    }

    public PFileIO getFileIORaw() {
        assert (this.fileioRaw != null);
        return this.fileioRaw;
    }

    public long getAbsPos() {
        return this.absPos;
    }

    public void setAbsPos(long absPos) {
        this.absPos = absPos;
    }

    public void incAbsPos(long n) {
        this.absPos += n;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public void incPos(int n) {
        this.pos += n;
    }

    public long getRawPos() {
        return this.rawPos;
    }

    public void setRawPos(long n) {
        this.rawPos = n;
    }

    public void incRawPos(long n) {
        this.rawPos += n;
    }

    public int getReadEnd() {
        return this.readEnd;
    }

    public void resetRead() {
        this.readEnd = -1;
    }

    public void setReadEnd(int n) {
        this.readEnd = n;
    }

    public void incReadEnd(int n) {
        this.readEnd += n;
    }

    public int getWritePos() {
        return this.writePos;
    }

    public void setWritePos(int n) {
        this.writePos = n;
    }

    public void incWritePos(int n) {
        this.writePos += n;
    }

    public int getWriteEnd() {
        return this.writeEnd;
    }

    public void setWriteEnd(int n) {
        this.writeEnd = n;
    }

    public void incWriteEnd(int n) {
        this.writeEnd += n;
    }

    public void resetWrite() {
        this.writePos = 0;
        this.writeEnd = -1;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void initBuffer(int bufSize) {
        this.bufferSize = bufSize;
        this.buffer = new byte[bufSize];
    }

    public int getBufferMask() {
        return this.bufferMask;
    }

    public PLock getLock() {
        return this.lock;
    }

    public void setLock(PLock lock) {
        this.lock = lock;
    }

    public long getOwner() {
        return this.owner;
    }

    public void setOwner(long owner) {
        this.owner = owner;
    }

    public boolean isOwn() {
        return ThreadModuleBuiltins.GetCurrentThreadIdNode.getId() == this.owner;
    }
}

