/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.nfi.backend.libffi.ClosureNativePointer;
import com.oracle.truffle.nfi.backend.libffi.LibFFIClosure;
import com.oracle.truffle.nfi.backend.libffi.LibFFILanguage;
import com.oracle.truffle.nfi.backend.libffi.LibFFILibrary;
import com.oracle.truffle.nfi.backend.libffi.LibFFISignature;
import com.oracle.truffle.nfi.backend.libffi.LibFFISymbol;
import com.oracle.truffle.nfi.backend.libffi.LibFFIType;
import com.oracle.truffle.nfi.backend.libffi.LibNFIResource;
import com.oracle.truffle.nfi.backend.libffi.LoadFlags;
import com.oracle.truffle.nfi.backend.libffi.NativeAllocation;
import com.oracle.truffle.nfi.backend.libffi.NativeLibVersion;
import com.oracle.truffle.nfi.backend.spi.NFIState;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;
import java.io.IOException;
import java.util.HashMap;
import java.util.function.Supplier;

class LibFFIContext {
    final LibFFILanguage language;
    @CompilerDirectives.CompilationFinal
    TruffleLanguage.Env env;
    final TruffleLogger attachThreadLogger;
    private long nativeContext;
    private final ThreadLocal<NativeEnv> nativeEnv = ThreadLocal.withInitial(new NativeEnvSupplier());
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final LibFFIType[] simpleTypeMap = new LibFFIType[NativeSimpleType.values().length];
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final LibFFIType[] arrayTypeMap = new LibFFIType[NativeSimpleType.values().length];
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final LibFFIType[] varargsTypeMap = new LibFFIType[NativeSimpleType.values().length];
    @CompilerDirectives.CompilationFinal
    LibFFIType cachedEnvType;
    private final HashMap<Long, ClosureNativePointer> nativePointerMap = new HashMap();
    final LoadFlags platformLoadFlags = LoadFlags.initLoadFlags(this);
    @CompilerDirectives.CompilationFinal
    int RTLD_GLOBAL;
    @CompilerDirectives.CompilationFinal
    int RTLD_LOCAL;
    @CompilerDirectives.CompilationFinal
    int RTLD_LAZY;
    @CompilerDirectives.CompilationFinal
    int RTLD_NOW;
    @CompilerDirectives.CompilationFinal
    int ISOLATED_NAMESPACE;
    private volatile long isolatedNamespaceId;
    private static final TruffleLanguage.ContextReference<LibFFIContext> REFERENCE = TruffleLanguage.ContextReference.create(LibFFILanguage.class);

    LibFFIContext(LibFFILanguage language, TruffleLanguage.Env env) {
        this.language = language;
        this.env = env;
        this.attachThreadLogger = env.getLogger("attachCurrentThread");
    }

    void patchEnv(TruffleLanguage.Env newEnv) {
        this.env = newEnv;
    }

    long getNativeEnv() {
        return this.nativeEnv.get().pointer;
    }

    boolean attachThread() {
        try {
            Object ret = this.env.getContext().enter(null);
            assert (ret == null) : "thread already entered";
            return true;
        }
        catch (Throwable t) {
            this.attachThreadLogger.severe(t.getMessage());
            return false;
        }
    }

    void detachThread() {
        this.env.getContext().leave(null, null);
    }

    void initialize() {
        this.loadNFILib();
        NativeAllocation.ensureGCThreadRunning();
        this.nativeContext = this.initializeNativeContext();
        this.initializeVarargsPromotedType(NativeSimpleType.UINT8, NativeSimpleType.UINT32);
        this.initializeVarargsPromotedType(NativeSimpleType.UINT16, NativeSimpleType.UINT32);
        this.initializeVarargsPromotedType(NativeSimpleType.SINT8, NativeSimpleType.SINT32);
        this.initializeVarargsPromotedType(NativeSimpleType.SINT16, NativeSimpleType.SINT32);
        this.initializeVarargsPromotedType(NativeSimpleType.FLOAT, NativeSimpleType.DOUBLE);
        this.nativeEnv.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        if (this.nativeContext != 0L) {
            LibFFIContext.disposeNativeContext(this.nativeContext);
            this.nativeContext = 0L;
        }
        this.nativeEnv.set(null);
        HashMap<Long, ClosureNativePointer> hashMap = this.nativePointerMap;
        synchronized (hashMap) {
            this.nativePointerMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClosureNativePointer getClosureNativePointer(long codePointer) {
        HashMap<Long, ClosureNativePointer> hashMap = this.nativePointerMap;
        synchronized (hashMap) {
            return this.nativePointerMap.get(codePointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClosureNativePointer(long codePointer) {
        HashMap<Long, ClosureNativePointer> hashMap = this.nativePointerMap;
        synchronized (hashMap) {
            this.nativePointerMap.remove(codePointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClosureNativePointer createClosureNativePointer(long nativeClosure, long codePointer, CallTarget callTarget, LibFFISignature signature, Object receiver) {
        ClosureNativePointer ret = ClosureNativePointer.create(this, nativeClosure, codePointer, callTarget, signature, receiver);
        HashMap<Long, ClosureNativePointer> hashMap = this.nativePointerMap;
        synchronized (hashMap) {
            this.nativePointerMap.put(codePointer, ret);
        }
        return ret;
    }

    void newClosureRef(long codePointer) {
        this.getClosureNativePointer(codePointer).addRef();
    }

    void releaseClosureRef(long codePointer) {
        this.getClosureNativePointer(codePointer).releaseRef();
    }

    Object getClosureObject(long codePointer) {
        return LibFFIClosure.newClosureWrapper(this.getClosureNativePointer(codePointer));
    }

    @CompilerDirectives.TruffleBoundary
    LibFFILibrary loadLibrary(String name, int flags) {
        return LibFFILibrary.create(LibFFIContext.loadLibrary(this.nativeContext, name, flags), name);
    }

    Object lookupSymbol(LibFFILibrary library, String name) {
        return LibFFISymbol.create(library, name, LibFFIContext.lookup(this.nativeContext, library.handle, name));
    }

    LibFFIType lookupSimpleType(NativeSimpleType type) {
        return this.simpleTypeMap[type.ordinal()];
    }

    LibFFIType lookupArrayType(NativeSimpleType type) {
        return this.arrayTypeMap[type.ordinal()];
    }

    LibFFIType lookupVarargsType(NativeSimpleType type) {
        return this.varargsTypeMap[type.ordinal()];
    }

    @CompilerDirectives.TruffleBoundary
    LibFFIType lookupEnvType() {
        return this.cachedEnvType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeSimpleType(NativeSimpleType simpleType, int size, int alignment, long ffiType) {
        int idx = simpleType.ordinal();
        int pointerIdx = NativeSimpleType.POINTER.ordinal();
        assert (this.simpleTypeMap[idx] == null) : "initializeSimpleType called twice for " + String.valueOf(simpleType);
        LibFFILanguage libFFILanguage = this.language;
        synchronized (libFFILanguage) {
            if (this.language.simpleTypeMap[idx] == null) {
                assert (this.language.arrayTypeMap[idx] == null);
                this.language.simpleTypeMap[idx] = LibFFIType.createSimpleTypeInfo(simpleType, size, alignment);
                this.language.arrayTypeMap[idx] = LibFFIType.createArrayTypeInfo(this.language.simpleTypeMap[pointerIdx], simpleType);
                if (idx == pointerIdx) {
                    this.language.cachedEnvType = new LibFFIType.EnvType(this.language.simpleTypeMap[pointerIdx]);
                }
            }
        }
        this.simpleTypeMap[idx] = new LibFFIType(this.language.simpleTypeMap[idx], ffiType);
        if (this.language.arrayTypeMap[idx] != null) {
            this.arrayTypeMap[idx] = new LibFFIType(this.language.arrayTypeMap[idx], this.simpleTypeMap[pointerIdx].type);
        }
        if (idx == pointerIdx) {
            this.cachedEnvType = new LibFFIType(this.language.cachedEnvType, this.simpleTypeMap[pointerIdx].type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeVarargsPromotedType(NativeSimpleType simpleType, NativeSimpleType promotedType) {
        int idx = simpleType.ordinal();
        LibFFIType promoted = this.simpleTypeMap[promotedType.ordinal()];
        assert (this.varargsTypeMap[idx] == null) : "initializeVarargsType called twice for " + String.valueOf(simpleType);
        LibFFILanguage libFFILanguage = this.language;
        synchronized (libFFILanguage) {
            if (this.language.varargsTypeMap[idx] == null) {
                this.language.varargsTypeMap[idx] = LibFFIType.createVarargsPromotedTypeInfo(simpleType, promoted.typeInfo);
            }
        }
        this.varargsTypeMap[idx] = new LibFFIType(this.language.varargsTypeMap[idx], promoted.type);
    }

    private native long initializeNativeContext();

    private static native void disposeNativeContext(long var0);

    private static native long initializeNativeEnvV2(long var0, NFIState var2);

    private static native void disposeNativeEnvV2(long var0);

    private static native long initializeNativeEnv(long var0);

    private void loadNFILib() {
        String nfiLib = System.getProperty("truffle.nfi.library");
        if (nfiLib == null) {
            try {
                TruffleFile libNFIResources = this.env.getInternalResource(LibNFIResource.class);
                TruffleFile libNFI = libNFIResources.resolve("bin").resolve(System.mapLibraryName("trufflenfi"));
                nfiLib = libNFI.getAbsoluteFile().getPath();
            }
            catch (IOException ioe) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ioe);
            }
        }
        System.load(nfiLib);
    }

    ClosureNativePointer allocateClosureObjectRet(LibFFISignature signature, CallTarget callTarget, Object receiver) {
        return LibFFIContext.allocateClosureObjectRet(this.nativeContext, signature, callTarget, receiver);
    }

    ClosureNativePointer allocateClosureStringRet(LibFFISignature signature, CallTarget callTarget, Object receiver) {
        return LibFFIContext.allocateClosureStringRet(this.nativeContext, signature, callTarget, receiver);
    }

    ClosureNativePointer allocateClosureBufferRet(LibFFISignature signature, CallTarget callTarget, Object receiver) {
        return LibFFIContext.allocateClosureBufferRet(this.nativeContext, signature, callTarget, receiver);
    }

    ClosureNativePointer allocateClosureVoidRet(LibFFISignature signature, CallTarget callTarget, Object receiver) {
        return LibFFIContext.allocateClosureVoidRet(this.nativeContext, signature, callTarget, receiver);
    }

    @CompilerDirectives.TruffleBoundary
    private static native ClosureNativePointer allocateClosureObjectRet(long var0, LibFFISignature var2, CallTarget var3, Object var4);

    @CompilerDirectives.TruffleBoundary
    private static native ClosureNativePointer allocateClosureStringRet(long var0, LibFFISignature var2, CallTarget var3, Object var4);

    @CompilerDirectives.TruffleBoundary
    private static native ClosureNativePointer allocateClosureBufferRet(long var0, LibFFISignature var2, CallTarget var3, Object var4);

    @CompilerDirectives.TruffleBoundary
    private static native ClosureNativePointer allocateClosureVoidRet(long var0, LibFFISignature var2, CallTarget var3, Object var4);

    long prepareSignature(LibFFIType retType, int argCount, LibFFIType ... args) {
        assert (args.length >= argCount);
        return LibFFIContext.prepareSignature(this.nativeContext, retType, argCount, args);
    }

    long prepareSignatureVarargs(LibFFIType retType, int argCount, int nFixedArgs, LibFFIType ... args) {
        assert (args.length >= argCount);
        return LibFFIContext.prepareSignatureVarargs(this.nativeContext, retType, argCount, nFixedArgs, args);
    }

    private static native long prepareSignature(long var0, LibFFIType var2, int var3, LibFFIType ... var4);

    private static native long prepareSignatureVarargs(long var0, LibFFIType var2, int var3, int var4, LibFFIType ... var5);

    void executeNative(long cif, long functionPointer, byte[] primArgs, int patchCount, int[] patchOffsets, Object[] objArgs, byte[] ret) {
        LibFFIContext.executeNative(this.nativeContext, this.language.getNFIState(), cif, functionPointer, primArgs, patchCount, patchOffsets, objArgs, ret);
    }

    long executePrimitive(long cif, long functionPointer, byte[] primArgs, int patchCount, int[] patchOffsets, Object[] objArgs) {
        return LibFFIContext.executePrimitive(this.nativeContext, this.language.getNFIState(), cif, functionPointer, primArgs, patchCount, patchOffsets, objArgs);
    }

    Object executeObject(long cif, long functionPointer, byte[] primArgs, int patchCount, int[] patchOffsets, Object[] objArgs) {
        return LibFFIContext.executeObject(this.nativeContext, this.language.getNFIState(), cif, functionPointer, primArgs, patchCount, patchOffsets, objArgs);
    }

    @CompilerDirectives.TruffleBoundary
    private static native void executeNative(long var0, NFIState var2, long var3, long var5, byte[] var7, int var8, int[] var9, Object[] var10, byte[] var11);

    @CompilerDirectives.TruffleBoundary
    private static native long executePrimitive(long var0, NFIState var2, long var3, long var5, byte[] var7, int var8, int[] var9, Object[] var10);

    @CompilerDirectives.TruffleBoundary
    private static native Object executeObject(long var0, NFIState var2, long var3, long var5, byte[] var7, int var8, int[] var9, Object[] var10);

    private static native long loadLibrary(long var0, String var2, int var3);

    @CompilerDirectives.TruffleBoundary
    private static native long lookup(long var0, long var2, String var4);

    static native void freeLibrary(long var0);

    static LibFFIContext get(Node node) {
        return (LibFFIContext)REFERENCE.get(node);
    }

    private final class NativeEnvSupplier
    implements Supplier<NativeEnv> {
        private NativeEnvSupplier() {
        }

        @Override
        public NativeEnv get() {
            NativeAllocation.Destructor destructor;
            long envPtr;
            if (NativeLibVersion.get() < 2) {
                envPtr = LibFFIContext.initializeNativeEnv(LibFFIContext.this.nativeContext);
                destructor = new NativeAllocation.FreeDestructor(envPtr);
            } else {
                envPtr = LibFFIContext.initializeNativeEnvV2(LibFFIContext.this.nativeContext, LibFFIContext.this.language.getNFIState());
                destructor = new NativeEnvDestructor(envPtr);
            }
            NativeEnv ret = new NativeEnv(envPtr);
            NativeAllocation.getGlobalQueue().registerNativeAllocation(ret, destructor);
            return ret;
        }
    }

    private static class NativeEnv {
        private final long pointer;

        NativeEnv(long pointer) {
            this.pointer = pointer;
        }
    }

    private static class NativeEnvDestructor
    extends NativeAllocation.Destructor {
        private final long pointer;

        NativeEnvDestructor(long pointer) {
            this.pointer = pointer;
        }

        @Override
        public void destroy() {
            LibFFIContext.disposeNativeEnvV2(this.pointer);
        }
    }
}

