/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.std;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.ValueInstantiator;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.type.LogicalType;
import tools.jackson.databind.util.AccessPattern;

public abstract class ReferenceTypeDeserializer<T>
extends StdDeserializer<T> {
    protected final JavaType _fullType;
    protected final ValueInstantiator _valueInstantiator;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final ValueDeserializer<Object> _valueDeserializer;

    public ReferenceTypeDeserializer(JavaType fullType, ValueInstantiator vi, TypeDeserializer typeDeser, ValueDeserializer<?> deser) {
        super(fullType);
        this._valueInstantiator = vi;
        this._fullType = fullType;
        this._valueDeserializer = deser;
        this._valueTypeDeserializer = typeDeser;
    }

    @Override
    public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        ValueDeserializer<Object> deser = this._valueDeserializer;
        deser = (deser = this.findConvertingContentDeserializer(ctxt, property, deser)) == null ? ctxt.findContextualValueDeserializer(this._fullType.getReferencedType(), property) : ctxt.handleSecondaryContextualization(deser, property, this._fullType.getReferencedType());
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        if (deser == this._valueDeserializer && typeDeser == this._valueTypeDeserializer) {
            return this;
        }
        return this.withResolved(typeDeser, deser);
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    protected abstract ReferenceTypeDeserializer<T> withResolved(TypeDeserializer var1, ValueDeserializer<?> var2);

    @Override
    public abstract T getNullValue(DeserializationContext var1);

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) {
        return this.getNullValue(ctxt);
    }

    @Override
    public Object getAbsentValue(DeserializationContext ctxt) {
        return this.getNullValue(ctxt);
    }

    public abstract T referenceValue(Object var1);

    public abstract T updateReference(T var1, Object var2);

    public abstract Object getReferenced(T var1);

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public JavaType getValueType() {
        return this._fullType;
    }

    @Override
    public LogicalType logicalType() {
        if (this._valueDeserializer != null) {
            return this._valueDeserializer.logicalType();
        }
        return super.logicalType();
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig config) {
        return this._valueDeserializer == null ? null : this._valueDeserializer.supportsUpdate(config);
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (this._valueInstantiator != null) {
            Object value = this._valueInstantiator.createUsingDefault(ctxt);
            return (T)this.deserialize(p, ctxt, value);
        }
        Object contents = this._valueTypeDeserializer == null ? this._valueDeserializer.deserialize(p, ctxt) : this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        return this.referenceValue(contents);
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt, T reference) throws JacksonException {
        Object contents;
        Boolean B = this._valueDeserializer.supportsUpdate(ctxt.getConfig());
        if (B.equals(Boolean.FALSE) || this._valueTypeDeserializer != null) {
            contents = this._valueTypeDeserializer == null ? this._valueDeserializer.deserialize(p, ctxt) : this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        } else {
            contents = this.getReferenced(reference);
            if (contents == null) {
                contents = this._valueTypeDeserializer == null ? this._valueDeserializer.deserialize(p, ctxt) : this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
                return this.referenceValue(contents);
            }
            contents = this._valueDeserializer.deserialize(p, ctxt, contents);
        }
        return this.updateReference(reference, contents);
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws JacksonException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_NULL) {
            return this.getNullValue(ctxt);
        }
        if (this._valueTypeDeserializer == null) {
            return this.deserialize(p, ctxt);
        }
        return this.referenceValue(this._valueTypeDeserializer.deserializeTypedFromAny(p, ctxt));
    }
}

