//===---------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// SPDX-FileCopyrightText: Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES.
//
//===---------------------------------------------------------------------===//

#ifndef _CUDA_STD___FWD_IOS_H
#define _CUDA_STD___FWD_IOS_H

#include <cuda/std/detail/__config>

#if defined(_CCCL_IMPLICIT_SYSTEM_HEADER_GCC)
#  pragma GCC system_header
#elif defined(_CCCL_IMPLICIT_SYSTEM_HEADER_CLANG)
#  pragma clang system_header
#elif defined(_CCCL_IMPLICIT_SYSTEM_HEADER_MSVC)
#  pragma system_header
#endif // no system header

#include <cuda/std/__fwd/allocator.h>
#include <cuda/std/__fwd/char_traits.h>

#include <cuda/std/__cccl/prologue.h>

_CCCL_BEGIN_NAMESPACE_CUDA_STD

class _CCCL_TYPE_VISIBILITY_DEFAULT ios_base;

template <class _CharT, class _Traits = char_traits<_CharT>>
class _CCCL_TYPE_VISIBILITY_DEFAULT basic_ios;

template <class _CharT, class _Traits = char_traits<_CharT>>
class _CCCL_TYPE_VISIBILITY_DEFAULT basic_streambuf;
template <class _CharT, class _Traits = char_traits<_CharT>>
class _CCCL_TYPE_VISIBILITY_DEFAULT basic_istream;
template <class _CharT, class _Traits = char_traits<_CharT>>
class _CCCL_TYPE_VISIBILITY_DEFAULT basic_ostream;
template <class _CharT, class _Traits = char_traits<_CharT>>
class _CCCL_TYPE_VISIBILITY_DEFAULT basic_iostream;

template <class _CharT, class _Traits = char_traits<_CharT>, class _Allocator = allocator<_CharT>>
class _CCCL_TYPE_VISIBILITY_DEFAULT basic_stringbuf;
template <class _CharT, class _Traits = char_traits<_CharT>, class _Allocator = allocator<_CharT>>
class _CCCL_TYPE_VISIBILITY_DEFAULT basic_istringstream;
template <class _CharT, class _Traits = char_traits<_CharT>, class _Allocator = allocator<_CharT>>
class _CCCL_TYPE_VISIBILITY_DEFAULT basic_ostringstream;
template <class _CharT, class _Traits = char_traits<_CharT>, class _Allocator = allocator<_CharT>>
class _CCCL_TYPE_VISIBILITY_DEFAULT basic_stringstream;

template <class _CharT, class _Traits = char_traits<_CharT>>
class _CCCL_TYPE_VISIBILITY_DEFAULT basic_filebuf;
template <class _CharT, class _Traits = char_traits<_CharT>>
class _CCCL_TYPE_VISIBILITY_DEFAULT basic_ifstream;
template <class _CharT, class _Traits = char_traits<_CharT>>
class _CCCL_TYPE_VISIBILITY_DEFAULT basic_ofstream;
template <class _CharT, class _Traits = char_traits<_CharT>>
class _CCCL_TYPE_VISIBILITY_DEFAULT basic_fstream;

template <class _CharT, class _Traits = char_traits<_CharT>>
class _CCCL_TYPE_VISIBILITY_DEFAULT istreambuf_iterator;
template <class _CharT, class _Traits = char_traits<_CharT>>
class _CCCL_TYPE_VISIBILITY_DEFAULT ostreambuf_iterator;

using ios  = basic_ios<char>;
using wios = basic_ios<wchar_t>;

using streambuf = basic_streambuf<char>;
using istream   = basic_istream<char>;
using ostream   = basic_ostream<char>;
using iostream  = basic_iostream<char>;

using stringbuf     = basic_stringbuf<char>;
using istringstream = basic_istringstream<char>;
using ostringstream = basic_ostringstream<char>;
using stringstream  = basic_stringstream<char>;

using filebuf  = basic_filebuf<char>;
using ifstream = basic_ifstream<char>;
using ofstream = basic_ofstream<char>;
using fstream  = basic_fstream<char>;

using wstreambuf = basic_streambuf<wchar_t>;
using wistream   = basic_istream<wchar_t>;
using wostream   = basic_ostream<wchar_t>;
using wiostream  = basic_iostream<wchar_t>;

using wstringbuf     = basic_stringbuf<wchar_t>;
using wistringstream = basic_istringstream<wchar_t>;
using wostringstream = basic_ostringstream<wchar_t>;
using wstringstream  = basic_stringstream<wchar_t>;

using wfilebuf  = basic_filebuf<wchar_t>;
using wifstream = basic_ifstream<wchar_t>;
using wofstream = basic_ofstream<wchar_t>;
using wfstream  = basic_fstream<wchar_t>;

#if _CCCL_HAS_WCHAR_T()
template <class _State>
class _CCCL_TYPE_VISIBILITY_DEFAULT fpos;
using streampos  = fpos<mbstate_t>;
using wstreampos = fpos<mbstate_t>;
#  if _CCCL_HAS_CHAR8_T()
using u8streampos = fpos<mbstate_t>;
#  endif // _CCCL_HAS_CHAR8_T()
using u16streampos = fpos<mbstate_t>;
using u32streampos = fpos<mbstate_t>;
#endif // _CCCL_HAS_WCHAR_T()

#if defined(_NEWLIB_VERSION)
// On newlib, off_t is 'long int'
using streamoff = long int; // for char_traits in <string>
#else
using streamoff = long long; // for char_traits in <string>
#endif

_CCCL_END_NAMESPACE_CUDA_STD

#include <cuda/std/__cccl/epilogue.h>

#endif // _CUDA_STD___FWD_IOS_H
