/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.internal.BasicAgreement;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.params.DhParameters;
import org.bouncycastle.crypto.internal.params.DhPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.DhPublicKeyParameters;

class DhBasicAgreement
implements BasicAgreement {
    private DhPrivateKeyParameters key;
    private DhParameters dhParams;

    DhBasicAgreement() {
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        DhPrivateKeyParameters dhPrivateKeyParameters;
        this.key = dhPrivateKeyParameters = (DhPrivateKeyParameters)cipherParameters;
        this.dhParams = this.key.getParameters();
    }

    @Override
    public int getFieldSize() {
        return (this.key.getParameters().getP().bitLength() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        DhPublicKeyParameters dhPublicKeyParameters = (DhPublicKeyParameters)cipherParameters;
        DhParameters dhParameters = dhPublicKeyParameters.getParameters();
        if (!dhParameters.getG().equals(this.dhParams.getG()) || !dhParameters.getP().equals(this.dhParams.getP())) {
            throw new IllegalKeyException("DH public key has wrong domain parameters");
        }
        return dhPublicKeyParameters.getY().modPow(this.key.getX(), this.dhParams.getP());
    }
}

