/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.navigation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.navigation.CSLNavigatorScheduler;
import org.netbeans.modules.csl.navigation.ClassMemberFilters;
import org.netbeans.modules.csl.navigation.ElementNode;
import org.netbeans.modules.csl.navigation.ElementScanningTask;
import org.netbeans.modules.csl.navigation.actions.FilterSubmenuAction;
import org.netbeans.modules.csl.navigation.actions.SortActionSupport;
import org.netbeans.modules.csl.navigation.base.FiltersManager;
import org.netbeans.modules.csl.navigation.base.TapPanel;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ClassMemberPanelUI
extends JPanel
implements ExplorerManager.Provider,
FiltersManager.FilterChangeListener {
    private static RequestProcessor RP = new RequestProcessor(ClassMemberPanelUI.class);
    private ExplorerManager manager = new ExplorerManager();
    private MyBeanTreeView elementView;
    private TapPanel filtersPanel;
    private JLabel filtersLbl;
    private Lookup lookup;
    private ClassMemberFilters filters;
    private Action[] actions = new Action[0];
    private Map<FileObject, Integer> positionRequests = new WeakHashMap<FileObject, Integer>();

    public ClassMemberPanelUI(Language language) {
        this.initComponents();
        this.elementView = this.createBeanTreeView();
        this.add((Component)((Object)this.elementView), "Center");
        this.filters = new ClassMemberFilters(this);
        this.filters.getInstance().hookChangeListener(this);
        RP.post((Runnable)new UpdateFilterState(language));
        this.filtersPanel = new TapPanel();
        this.filtersLbl = new JLabel(NbBundle.getMessage(ClassMemberPanelUI.class, (String)"LBL_Filter"));
        this.filtersLbl.setBorder(new EmptyBorder(0, 5, 5, 0));
        this.filtersPanel.add(this.filtersLbl);
        this.filtersPanel.setOrientation(2);
        KeyStroke toggleKey = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        String keyText = Utilities.keyToString((KeyStroke)toggleKey);
        this.filtersPanel.setToolTipText(NbBundle.getMessage(ClassMemberPanelUI.class, (String)"TIP_TapPanel", (Object)keyText));
        this.filtersPanel.add(this.filters.getComponent());
        this.add((Component)this.filtersPanel, "South");
        this.manager.setRootContext(ElementNode.getWaitNode());
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)this.getActionMap());
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean result = super.requestFocusInWindow();
        this.elementView.requestFocusInWindow();
        return result;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.elementView.requestFocus();
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public ElementScanningTask getTask() {
        return new ElementScanningTask(){

            public int getPriority() {
                return 20000;
            }

            public Class<? extends Scheduler> getSchedulerClass() {
                return CSLNavigatorScheduler.class;
            }

            public void run(final ParserResult result, SchedulerEvent event) {
                this.runWithCancelService(new Runnable(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.resume();
                        StructureItem root = this.this$1.computeStructureRoot(result.getSnapshot().getSource());
                        FileObject file = result.getSnapshot().getSource().getFileObject();
                        if (root != null && file != null) {
                            Document doc = result.getSnapshot().getSource().getDocument(false);
                            BaseDocument bd = doc instanceof BaseDocument ? (BaseDocument)doc : null;
                            this.this$1.ClassMemberPanelUI.this.refresh(root, file, bd);
                        }
                    }
                });
            }
        };
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClassMemberPanelUI.this.elementView.setRootVisible(true);
                ClassMemberPanelUI.this.manager.setRootContext(ElementNode.getWaitNode());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectElementNode(ParserResult info, int offset) {
        ElementNode root = this.getRootNode();
        if (root == null) {
            return;
        }
        FileObject rootFo = root.getFileObject();
        FileObject sourceFo = info.getSnapshot().getSource().getFileObject();
        if (sourceFo != null && !sourceFo.equals(rootFo)) {
            ClassMemberPanelUI classMemberPanelUI = this;
            synchronized (classMemberPanelUI) {
                this.positionRequests.put(sourceFo, offset);
            }
        } else {
            this.doSelectNodes(info, null, offset);
        }
    }

    private void doSelectNodes(final ParserResult info, final BaseDocument bd, final int offset) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ ClassMemberPanelUI this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.doSelectNodes0(info, bd, offset);
            }
        });
    }

    private void doSelectNodes0(ParserResult info, BaseDocument bd, int offset) {
        ElementNode node;
        ElementNode rootNode = this.getRootNode();
        if (info != null && rootNode != null) {
            node = rootNode.getMimeRootNodeForOffset(info, offset);
        } else if (bd != null && rootNode != null) {
            node = rootNode.getMimeRootNodeForOffset(bd, offset);
        } else {
            return;
        }
        Node[] selectedNodes = this.manager.getSelectedNodes();
        if (selectedNodes == null || selectedNodes.length != 1 || selectedNodes[0] != node) {
            try {
                this.manager.setSelectedNodes(new Node[]{node == null ? this.getRootNode() : node});
            }
            catch (PropertyVetoException propertyVetoException) {
                Exceptions.printStackTrace((Throwable)propertyVetoException);
            }
        }
    }

    public void refresh(final StructureItem description, final FileObject fileObject, final BaseDocument bd) {
        final ElementNode rootNode = this.getRootNode();
        if (rootNode != null && rootNode.getFileObject().equals(fileObject)) {
            Runnable r = new Runnable(){
                final /* synthetic */ ClassMemberPanelUI this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    long startTime = System.currentTimeMillis();
                    rootNode.updateRecursively(description);
                    long endTime = System.currentTimeMillis();
                    Logger.getLogger("TIMER").log(Level.FINE, "Navigator Merge", new Object[]{fileObject, endTime - startTime});
                }
            };
            RP.post(r);
        } else {
            Runnable r = new Runnable(){
                final /* synthetic */ ClassMemberPanelUI this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Integer offset;
                    StructureScanner scanner;
                    StructureScanner.Configuration configuration;
                    long startTime = System.currentTimeMillis();
                    this.this$0.elementView.setRootVisible(false);
                    this.this$0.manager.setRootContext((Node)new ElementNode(description, this.this$0, fileObject));
                    int expandDepth = -1;
                    Language language = LanguageRegistry.getInstance().getLanguageByMimeType(fileObject.getMIMEType());
                    if (language != null && language.getStructure() != null && (configuration = (scanner = language.getStructure()).getConfiguration()) != null) {
                        expandDepth = configuration.getExpandDepth();
                    }
                    this.this$0.new UpdateFilterState(language).run();
                    final boolean scrollOnExpand = this.this$0.elementView.getScrollOnExpand();
                    this.this$0.elementView.setScrollOnExpand(false);
                    this.this$0.expandNodeByDefaultRecursively(this.this$0.manager.getRootContext(), 0, expandDepth);
                    Mutex.EVENT.writeAccess(new Runnable(){
                        final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            this.this$1.this$0.elementView.setScrollOnExpand(scrollOnExpand);
                        }
                    });
                    long endTime = System.currentTimeMillis();
                    Logger.getLogger("TIMER").log(Level.FINE, "Navigator Initialization", new Object[]{fileObject, endTime - startTime});
                    ClassMemberPanelUI classMemberPanelUI = this.this$0;
                    synchronized (classMemberPanelUI) {
                        offset = this.this$0.positionRequests.remove(fileObject);
                    }
                    if (offset != null) {
                        this.this$0.doSelectNodes(null, bd, offset);
                    }
                }
            };
            RP.post(r);
        }
    }

    public void sort() {
        this.refreshRootRecursively();
    }

    public ClassMemberFilters getFilters() {
        return this.filters;
    }

    public void expandNode(Node n) {
        this.elementView.expandNode(n);
    }

    private void expandNodeByDefaultRecursively(Node node) {
        this.expandNodeByDefaultRecursively(node, 0, -1);
    }

    private void expandNodeByDefaultRecursively(Node node, int currentDepth, int maxDepth) {
        if (maxDepth >= 0 && currentDepth >= maxDepth) {
            return;
        }
        if (!this.expandNodeByDefault(node)) {
            return;
        }
        this.expandNode(node);
        for (Node subNode : node.getChildren().getNodes()) {
            this.expandNodeByDefaultRecursively(subNode, currentDepth + 1, maxDepth);
        }
    }

    private boolean expandNodeByDefault(Node node) {
        if (this.isExpandedByDefault(node)) {
            this.expandNode(node);
            return true;
        }
        return false;
    }

    void performExpansion(final Collection<Node> expand, final Collection<Node> expandRec) {
        Runnable r = new Runnable(){
            final /* synthetic */ ClassMemberPanelUI this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                for (Node n : expand) {
                    this.this$0.expandNode(n);
                }
                for (Node n : expandRec) {
                    this.this$0.expandNodeByDefaultRecursively(n);
                }
            }
        };
        RP.post(r);
    }

    boolean isExpandedByDefault(Node node) {
        StructureItem item;
        return !(node instanceof ElementNode) || !((item = ((ElementNode)node).getDescription()) instanceof StructureItem.CollapsedDefault) || !((StructureItem.CollapsedDefault)item).isCollapsedByDefault();
    }

    public Action[] getActions() {
        return this.actions;
    }

    public FileObject getFileObject() {
        return this.getRootNode().getFileObject();
    }

    @Override
    public void filterStateChanged(ChangeEvent e) {
        this.refreshRootRecursively();
    }

    private void refreshRootRecursively() {
        final ElementNode root = this.getRootNode();
        if (root != null) {
            RP.post(new Runnable(){
                final /* synthetic */ ClassMemberPanelUI this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    root.refreshRecursively();
                }
            });
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private ElementNode getRootNode() {
        Node n = this.manager.getRootContext();
        if (n instanceof ElementNode) {
            return (ElementNode)n;
        }
        return null;
    }

    private MyBeanTreeView createBeanTreeView() {
        MyBeanTreeView btv = new MyBeanTreeView();
        btv.setAutoWaitCursor(false);
        return btv;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private class MyBeanTreeView
    extends BeanTreeView {
        private MyBeanTreeView() {
        }

        public boolean getScrollOnExpand() {
            return this.tree.getScrollsOnExpand();
        }

        public void setScrollOnExpand(boolean scroll) {
            this.tree.setScrollsOnExpand(scroll);
        }
    }

    private class UpdateFilterState
    implements Runnable {
        private final Language language;

        public UpdateFilterState(Language language) {
            this.language = language;
        }

        @Override
        public void run() {
            StructureScanner scanner;
            StructureScanner.Configuration configuration;
            boolean includeFilters = true;
            if (this.language != null && this.language.getStructure() != null && (configuration = (scanner = this.language.getStructure()).getConfiguration()) != null) {
                includeFilters = configuration.isFilterable();
                ArrayList<AbstractAction> newActions = new ArrayList<AbstractAction>();
                if (configuration.isSortable()) {
                    newActions.add(new SortActionSupport.SortByNameAction(ClassMemberPanelUI.this.filters));
                    newActions.add(new SortActionSupport.SortBySourceAction(ClassMemberPanelUI.this.filters));
                }
                if (!includeFilters) {
                    ClassMemberPanelUI.this.filters.disableFiltering = true;
                } else {
                    ClassMemberPanelUI.this.filters.disableFiltering = false;
                    if (!newActions.isEmpty()) {
                        newActions.add(null);
                        newActions.add(new FilterSubmenuAction(ClassMemberPanelUI.this.filters));
                    }
                }
                ClassMemberPanelUI.this.actions = newActions.toArray(new Action[0]);
            }
            final boolean finalIncludeFilters = includeFilters;
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ UpdateFilterState this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    this.this$1.ClassMemberPanelUI.this.filtersPanel.setVisible(finalIncludeFilters);
                }
            });
        }
    }
}

