/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDrgRouteDistributionRequest
extends BmcRequest<Void> {
    private String drgRouteDistributionId;

    public String getDrgRouteDistributionId() {
        return this.drgRouteDistributionId;
    }

    public Builder toBuilder() {
        return new Builder().drgRouteDistributionId(this.drgRouteDistributionId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",drgRouteDistributionId=").append(String.valueOf(this.drgRouteDistributionId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDrgRouteDistributionRequest)) {
            return false;
        }
        GetDrgRouteDistributionRequest other = (GetDrgRouteDistributionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.drgRouteDistributionId, other.drgRouteDistributionId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.drgRouteDistributionId == null ? 43 : this.drgRouteDistributionId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDrgRouteDistributionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String drgRouteDistributionId = null;

        public Builder drgRouteDistributionId(String drgRouteDistributionId) {
            this.drgRouteDistributionId = drgRouteDistributionId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDrgRouteDistributionRequest o) {
            this.drgRouteDistributionId(o.getDrgRouteDistributionId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDrgRouteDistributionRequest build() {
            GetDrgRouteDistributionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDrgRouteDistributionRequest buildWithoutInvocationCallback() {
            GetDrgRouteDistributionRequest request = new GetDrgRouteDistributionRequest();
            request.drgRouteDistributionId = this.drgRouteDistributionId;
            return request;
        }
    }
}

