/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring.plugins;

import com.sun.source.tree.Tree;
import java.io.IOException;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.beans.refactoring.Occurrences;
import org.netbeans.modules.spring.beans.refactoring.SpringRefactoringElement;
import org.netbeans.modules.spring.beans.refactoring.SpringRefactorings;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class SpringFindUsagesPlugin
implements RefactoringPlugin {
    private final WhereUsedQuery refactoring;

    SpringFindUsagesPlugin(WhereUsedQuery query) {
        this.refactoring = query;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (!this.refactoring.getBooleanValue((Object)"FIND_REFERENCES")) {
            return null;
        }
        TreePathHandle treePathHandle = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (treePathHandle != null && treePathHandle.getKind() == Tree.Kind.METHOD) {
            return this.prepareMethodRefactoring(refactoringElementsBag, treePathHandle);
        }
        if (treePathHandle != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)treePathHandle.getKind())) {
            return this.prepareClassRefactoring(refactoringElementsBag, treePathHandle);
        }
        return null;
    }

    private Problem prepareClassRefactoring(RefactoringElementsBag refactoringElementsBag, final TreePathHandle treePathHandle) {
        FileObject fo = treePathHandle.getFileObject();
        SpringScope scope = SpringScope.getSpringScope(fo);
        if (scope == null) {
            return null;
        }
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)fo);
            if (source == null) {
                return null;
            }
            final String[] className = new String[]{null};
            source.runUserActionTask((Task)new Task<CompilationController>(){
                final /* synthetic */ SpringFindUsagesPlugin this$0;
                {
                    this.this$0 = this$0;
                }

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    TypeElement type = (TypeElement)treePathHandle.resolveElement((CompilationInfo)compilationController);
                    if (type != null) {
                        className[0] = ElementUtilities.getBinaryName((TypeElement)type);
                    }
                }
            }, true);
            if (className[0] != null) {
                for (Occurrences.Occurrence item : Occurrences.getJavaClassOccurrences(className[0], scope)) {
                    refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)SpringRefactoringElement.create(item));
                }
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    private Problem prepareMethodRefactoring(RefactoringElementsBag refactoringElements, TreePathHandle treePathHandle) {
        FileObject fo = treePathHandle.getFileObject();
        try {
            String oldName;
            SpringScope scope;
            SpringRefactorings.RenamedProperty prop = null;
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            if (js != null) {
                prop = SpringRefactorings.getRenamedProperty(treePathHandle, js, null);
            }
            if ((scope = SpringScope.getSpringScope(fo)) == null) {
                return null;
            }
            if (prop != null && (oldName = prop.getOldName()) != null) {
                for (Occurrences.Occurrence occurrence : Occurrences.getPropertyOccurrences(prop, js, scope)) {
                    refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)SpringRefactoringElement.create(occurrence));
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }
}

