/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpProjectValidator;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.SourceRoots;
import org.netbeans.modules.php.project.ui.wizards.NewFileNamespacePanel;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public final class NewFileWizardIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator<WizardDescriptor> {
    private static final long serialVersionUID = 5846231213213L;
    private static final Logger LOGGER = Logger.getLogger(NewFileWizardIterator.class.getName());
    private final BottomPanel bottomPanel;
    private WizardDescriptor wizard;
    private PhpProject phpProject;
    private WizardDescriptor.Panel<WizardDescriptor>[] wizardPanels;
    private int index;

    private NewFileWizardIterator(BottomPanel bottomPanel) {
        this.bottomPanel = bottomPanel;
    }

    public static NewFileWizardIterator simple() {
        return new NewFileWizardIterator(null);
    }

    public static NewFileWizardIterator withNamespace() {
        return new NewFileWizardIterator(new NewFileNamespacePanel());
    }

    public Set<FileObject> instantiate() throws IOException {
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wizard);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)dir);
        DataObject dataTemplate = DataObject.find((FileObject)template);
        DataObject createdFile = dataTemplate.createFromTemplate(dataFolder, Templates.getTargetName((WizardDescriptor)this.wizard), this.getTemplateParams());
        try {
            FileUtils.reformatFile((DataObject)createdFile);
        }
        catch (IOException exc) {
            LOGGER.log(Level.WARNING, exc.getMessage(), exc);
        }
        return Collections.singleton(createdFile.getPrimaryFile());
    }

    private Map<String, Object> getTemplateParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("freeFileExtension", true);
        params.put("namespace", this.wizard.getProperty("NAMESPACE"));
        return params;
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        this.phpProject = this.getPhpProject();
        this.checkPhpProject();
        this.setTargetFolder();
        this.wizardPanels = this.getPanels();
        String[] beforeSteps = (String[])wizard.getProperty("WizardPanel_contentData");
        int beforeStepLength = beforeSteps.length - 1;
        String[] steps = this.createSteps(beforeSteps);
        for (int i = 0; i < this.wizardPanels.length; ++i) {
            Component c = this.wizardPanels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i + beforeStepLength - 1);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    private void checkPhpProject() {
        if (this.phpProject == null) {
            return;
        }
        if (PhpProjectValidator.isFatallyBroken(this.phpProject)) {
            UiUtils.warnBrokenProject((PhpModule)this.phpProject.getPhpModule());
        }
    }

    private void setTargetFolder() {
        if (Templates.getTargetFolder((WizardDescriptor)this.wizard) != null) {
            return;
        }
        if (this.phpProject == null) {
            return;
        }
        FileObject srcDir = ProjectPropertiesSupport.getSourcesDirectory(this.phpProject);
        if (srcDir != null && srcDir.isValid()) {
            Templates.setTargetFolder((WizardDescriptor)this.wizard, (FileObject)srcDir);
        }
    }

    private PhpProject getPhpProject() {
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        if (project == null) {
            return null;
        }
        if (!(project instanceof PhpProject)) {
            LOGGER.log(Level.WARNING, "PHP project expected but found {0}", project.getClass().getName());
            return null;
        }
        return (PhpProject)project;
    }

    private String[] createSteps(String[] beforeSteps) {
        int beforeStepLength = beforeSteps.length - 1;
        String[] res = new String[beforeStepLength + this.wizardPanels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeStepLength ? beforeSteps[i] : this.wizardPanels[i - beforeStepLength].getComponent().getName();
        }
        return res;
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.wizardPanels = null;
    }

    public String name() {
        return "";
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.wizardPanels[this.index];
    }

    public boolean hasNext() {
        return this.index < this.wizardPanels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
        BottomPanel bottomPanelForPhpProject = this.getBottomPanelForPhpProject();
        if (bottomPanelForPhpProject != null) {
            bottomPanelForPhpProject.addChangeListener(l);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        BottomPanel bottomPanelForPhpProject = this.getBottomPanelForPhpProject();
        if (bottomPanelForPhpProject != null) {
            bottomPanelForPhpProject.removeChangeListener(l);
        }
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] getPanels() {
        assert (EventQueue.isDispatchThread());
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        SourceGroup[] groups = PhpProjectUtils.getSourceGroups(project);
        if (this.phpProject != null && groups.length == 0 && !PhpProjectValidator.isFatallyBroken(this.phpProject)) {
            FileObject sources = ProjectPropertiesSupport.getSourcesDirectory(this.phpProject);
            List<FileObject> tests = ProjectPropertiesSupport.getTestDirectories(this.phpProject, false);
            FileObject selenium = ProjectPropertiesSupport.getSeleniumDirectory(this.phpProject, false);
            SourceRoots sourceRoots = this.phpProject.getSourceRoots();
            SourceRoots testRoots = this.phpProject.getTestRoots();
            SourceRoots seleniumRoots = this.phpProject.getSeleniumRoots();
            StringBuilder sb = new StringBuilder(200);
            this.addDiagnosticForDirs(sb, this.phpProject, sources, tests, selenium);
            this.addDiagnosticForRoots(sb, sourceRoots, testRoots, seleniumRoots);
            LOGGER.log(Level.WARNING, sb.toString(), new IllegalStateException("No source roots found (attach your IDE log to https://netbeans.org/bugzilla/show_bug.cgi?id=218437)"));
            sourceRoots.refresh();
            testRoots.refresh();
            seleniumRoots.refresh();
            sb = new StringBuilder(200);
            this.addDiagnosticForRoots(sb, sourceRoots, testRoots, seleniumRoots);
            LOGGER.log(Level.WARNING, sb.toString(), new IllegalStateException("Trying to fire changes for all source roots"));
            groups = PhpProjectUtils.getSourceGroups(project);
        }
        if (groups.length == 0) {
            groups = ProjectUtils.getSources((Project)project).getSourceGroups("generic");
        }
        final BottomPanel bottomPanelForPhpProject = this.getBottomPanelForPhpProject();
        Templates.SimpleTargetChooserBuilder targetChooserBuilder = Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])groups);
        if (bottomPanelForPhpProject != null) {
            targetChooserBuilder.bottomPanel((WizardDescriptor.Panel)bottomPanelForPhpProject);
        }
        final WizardDescriptor.Panel simpleTargetChooserPanel = targetChooserBuilder.freeFileExtension().create();
        if (bottomPanelForPhpProject != null) {
            simpleTargetChooserPanel.addChangeListener(new ChangeListener(){
                final /* synthetic */ NewFileWizardIterator this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    Component component = simpleTargetChooserPanel.getComponent();
                    if (component instanceof JPanel) {
                        JPanel panel = (JPanel)component;
                        for (Component c : panel.getComponents()) {
                            String text;
                            JTextField textField;
                            if (!(c instanceof JTextField) || (textField = (JTextField)c).isEditable() || (text = textField.getText()) == null || !text.endsWith(".php")) continue;
                            File file = new File(text);
                            File parent = file.getParentFile();
                            if (parent != null && parent.exists()) break;
                            return;
                        }
                    }
                    DummyWizardDescriptor descriptor = new DummyWizardDescriptor();
                    simpleTargetChooserPanel.storeSettings((Object)descriptor);
                    bottomPanelForPhpProject.targetFolderChanged(Templates.getTargetFolder((WizardDescriptor)descriptor));
                }
            });
        }
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{simpleTargetChooserPanel};
        return panels;
    }

    @CheckForNull
    private BottomPanel getBottomPanelForPhpProject() {
        if (this.bottomPanel == null) {
            return null;
        }
        if (this.phpProject == null) {
            return this.bottomPanel;
        }
        if (this.bottomPanel.isPresentForProject(this.phpProject)) {
            return this.bottomPanel;
        }
        return null;
    }

    private void addDiagnosticForDirs(StringBuilder sb, PhpProject project, FileObject sources, List<FileObject> tests, FileObject selenium) {
        sb.append("project directory equals sources: ");
        sb.append(project.getProjectDirectory().equals(sources));
        sb.append(";\n sources (not null, valid): ");
        sb.append(sources != null);
        sb.append(", ");
        sb.append(sources != null && sources.isValid());
        sb.append(";\n tests (not null, valid): ");
        for (FileObject test : tests) {
            sb.append("[");
            sb.append(test != null);
            sb.append(", ");
            sb.append(test != null && test.isValid());
            sb.append("]");
        }
        sb.append(";\n selenium (not null, valid): ");
        sb.append(selenium != null);
        sb.append(", ");
        sb.append(selenium != null && selenium.isValid());
    }

    private void addDiagnosticForRoots(StringBuilder sb, SourceRoots sourceRoots, SourceRoots testRoots, SourceRoots seleniumRoots) {
        sb.append(";\n sourceRoots (fired changes): ");
        sb.append(Arrays.asList(sourceRoots.getRoots()));
        sb.append(" (");
        sb.append(sourceRoots.getFiredChanges());
        sb.append(");\n testRoots (fired changes): ");
        sb.append(Arrays.asList(testRoots.getRoots()));
        sb.append(" (");
        sb.append(testRoots.getFiredChanges());
        sb.append(");\n seleniumRoots (fired changes): ");
        sb.append(Arrays.asList(seleniumRoots.getRoots()));
        sb.append(" (");
        sb.append(seleniumRoots.getFiredChanges());
        sb.append(")");
    }

    static interface BottomPanel
    extends WizardDescriptor.Panel<WizardDescriptor> {
        public void targetFolderChanged(@NullAllowed FileObject var1);

        public boolean isPresentForProject(PhpProject var1);
    }

    private static final class DummyWizardDescriptor
    extends WizardDescriptor {
    }
}

