/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.explorer.dlg.AddConnectionWizard;
import org.netbeans.modules.db.explorer.dlg.AddDriverDialog;
import org.netbeans.modules.db.explorer.dlg.ChoosingDriverPanel;
import org.netbeans.modules.db.util.DatabaseExplorerInternalUIs;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ChoosingDriverUI
extends JPanel {
    private AddDriverDialog customizeDriverPanel;
    private JDBCDriver drv;
    private ActionListener actionListener;
    private ChoosingDriverPanel wp;
    private AddConnectionWizard wizard;
    private JComboBox cbDrivers;
    private JLabel lDrivers;
    private JPanel pInter;

    public ChoosingDriverUI(ChoosingDriverPanel panel, JDBCDriver driver, AddConnectionWizard wizard) {
        this.drv = driver;
        this.wp = panel;
        this.wizard = wizard;
        this.initComponents();
        DatabaseExplorerInternalUIs.connect(this.cbDrivers, JDBCDriverManager.getDefault(), false);
        if (this.drv == null) {
            this.cbDrivers.setSelectedIndex(0);
        } else {
            this.cbDrivers.setSelectedItem(this.drv);
        }
        this.customizeDriverPanel = new AddDriverDialog(this.drv, this, wizard);
        this.pInter.add((Component)this.customizeDriverPanel, "Center");
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChoosingDriverUI.this.updateState();
            }
        };
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.cbDrivers.addActionListener(this.actionListener);
        this.updateState();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.cbDrivers.removeActionListener(this.actionListener);
    }

    private void updateState() {
        Object drvO = this.cbDrivers.getSelectedItem();
        if (drvO instanceof JDBCDriver) {
            JDBCDriver current;
            this.drv = (JDBCDriver)drvO;
            if (this.customizeDriverPanel.getDriver() != null && !Arrays.equals((current = this.customizeDriverPanel.getDriver()).getURLs(), this.customizeDriverPanel.getDriverURLs())) {
                JDBCDriver modified = JDBCDriver.create(current.getName(), current.getDisplayName(), current.getClassName(), this.customizeDriverPanel.getDriverURLs());
                try {
                    JDBCDriverManager.getDefault().removeDriver(current);
                    JDBCDriverManager.getDefault().addDriver(modified);
                    this.drv = modified;
                    this.cbDrivers.getModel().setSelectedItem(modified);
                }
                catch (DatabaseException ex) {
                    Logger.getLogger(ChoosingDriverUI.class.getName()).log(Level.WARNING, "Unable to modify driver " + current.getName() + " and add driver jar files " + Arrays.asList(this.customizeDriverPanel.getDriverURLs()) + ": can not convert to URL", ex);
                }
            }
            this.wizard.setDriver(this.drv);
            this.customizeDriverPanel.setDriver(this.drv);
        } else {
            this.wizard.setDriver(this.drv);
            this.customizeDriverPanel.setDriver(null);
        }
        this.wp.fireChangeEvent();
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ChoosingDriverUI.class, (String)"ChoosingDriverUI.Name");
    }

    private void initComponents() {
        this.lDrivers = new JLabel();
        this.cbDrivers = new JComboBox();
        this.pInter = new JPanel();
        Mnemonics.setLocalizedText((JLabel)this.lDrivers, (String)NbBundle.getMessage(ChoosingDriverUI.class, (String)"ChoosingDriverUI.lDrivers.text"));
        this.pInter.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.lDrivers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbDrivers, 0, 322, Short.MAX_VALUE).addContainerGap()).addComponent(this.pInter, -1, 404, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lDrivers).addComponent(this.cbDrivers, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pInter, -1, 243, Short.MAX_VALUE).addContainerGap()));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ChoosingDriverUI.class, (String)"ACD_ChoosingDriverUI"));
    }

    boolean driverFound() {
        return this.customizeDriverPanel.getDriverURLs().length > 0;
    }

    JDBCDriver getDriver() {
        return this.customizeDriverPanel.getDriver();
    }

    void fireChangeEvent() {
        this.updateState();
    }
}

