/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.action.RefreshAction;
import org.netbeans.modules.db.explorer.dlg.AddTableColumnDialog;
import org.netbeans.modules.db.explorer.node.TableNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class AddColumnAction
extends BaseAction {
    private static final Logger LOGGER = Logger.getLogger(AddColumnAction.class.getName());

    public String getName() {
        return NbBundle.getMessage(AddColumnAction.class, (String)"AddColumn");
    }

    protected boolean enable(Node[] activatedNodes) {
        TableNode tn;
        boolean result = false;
        if (activatedNodes.length == 1 && (tn = (TableNode)activatedNodes[0].getLookup().lookup(TableNode.class)) != null && !tn.isSystem()) {
            result = true;
        }
        return result;
    }

    protected void performAction(final Node[] activatedNodes) {
        RequestProcessor.getDefault().post(new Runnable(){
            final /* synthetic */ AddColumnAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                TableNode node = (TableNode)activatedNodes[0].getLookup().lookup(TableNode.class);
                DatabaseConnection connection = (DatabaseConnection)node.getLookup().lookup(DatabaseConnection.class);
                try {
                    boolean columnAdded = AddTableColumnDialog.showDialogAndCreate(connection.getConnector().getDatabaseSpecification(), node);
                    if (columnAdded) {
                        ((RefreshAction)SystemAction.get(RefreshAction.class)).performAction(new Node[]{node});
                    }
                }
                catch (Exception exc) {
                    LOGGER.log(Level.WARNING, exc.getLocalizedMessage(), exc);
                    DbUtilities.reportError(NbBundle.getMessage(AddColumnAction.class, (String)"ERR_UnableToAddColumn"), exc.getMessage());
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(AddColumnAction.class);
    }
}

