/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.PreferredVMParser;
import org.netbeans.modules.projectimport.eclipse.core.ProjectFactory;
import org.netbeans.modules.projectimport.eclipse.core.ProjectImporterException;
import org.netbeans.modules.projectimport.eclipse.core.UserLibraryParser;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.spi.LaunchConfiguration;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class WorkspaceParser {
    private static final Logger logger = Logger.getLogger(WorkspaceParser.class.getName());
    private static final String VM_XML = "org.eclipse.jdt.launching.PREF_VM_XML";
    private static final String IGNORED_CP_ENTRY = "##<cp entry ignore>##";
    private static final String VARIABLE_PREFIX = "org.eclipse.jdt.core.classpathVariable.";
    private static final int VARIABLE_PREFIX_LENGTH = "org.eclipse.jdt.core.classpathVariable.".length();
    private static final String RESOURCES_VARIABLE_PREFIX = "pathvariable.";
    private static final int RESOURCES_VARIABLE_PREFIX_LENGTH = "pathvariable.".length();
    private static final String USER_LIBRARY_PREFIX = "org.eclipse.jdt.core.userLibrary.";
    private static final int USER_LIBRARY_PREFIX_LENGTH = "org.eclipse.jdt.core.userLibrary.".length();
    private static final String JSF_LIB_NS = "http://www.eclipse.org/webtools/jsf/schema/jsflibraryregistry.xsd";
    private final Workspace workspace;

    WorkspaceParser(Workspace workspace) {
        this.workspace = workspace;
    }

    void parse() throws ProjectImporterException {
        try {
            this.parseLaunchingPreferences();
            this.parseCorePreferences();
            this.parseResourcesPreferences();
            this.parseWorkspaceProjects();
            this.parseJSFLibraryRegistryV2();
            this.parseLaunchConfigurations();
        }
        catch (IOException e) {
            throw new ProjectImporterException("Cannot load workspace properties", e);
        }
    }

    private void parseLaunchingPreferences() throws IOException, ProjectImporterException {
        if (!this.workspace.getLaunchingPrefsFile().exists()) {
            this.workspace.setJREContainers(new HashMap<String, String>());
            return;
        }
        for (Map.Entry<String, String> entry : EclipseUtils.loadProperties(this.workspace.getLaunchingPrefsFile()).entrySet()) {
            if (!entry.getKey().equals(VM_XML)) continue;
            Map<String, String> vmMap = PreferredVMParser.parse(entry.getValue());
            this.workspace.setJREContainers(vmMap);
        }
    }

    private void parseCorePreferences() throws IOException, ProjectImporterException {
        for (Map.Entry<String, String> entry : EclipseUtils.loadProperties(this.workspace.getCorePreferenceFile()).entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.startsWith(VARIABLE_PREFIX)) {
                Workspace.Variable var = new Workspace.Variable(key.substring(VARIABLE_PREFIX_LENGTH), value);
                this.workspace.addVariable(var);
                continue;
            }
            if (!key.startsWith(USER_LIBRARY_PREFIX) || value.startsWith(IGNORED_CP_ENTRY)) continue;
            String libName = key.substring(USER_LIBRARY_PREFIX_LENGTH);
            ArrayList<String> jars = new ArrayList<String>();
            ArrayList<String> javadocs = new ArrayList<String>();
            ArrayList<String> sources = new ArrayList<String>();
            UserLibraryParser.getJars(libName, value, jars, javadocs, sources);
            this.workspace.addUserLibrary(libName, jars, javadocs, sources);
        }
    }

    void parseJSFLibraryRegistryV2() throws IOException {
        Document xml;
        if (!this.workspace.getUserJSFLibraries().exists()) {
            return;
        }
        try {
            xml = XMLUtil.parse((InputSource)new InputSource(Utilities.toURI((File)this.workspace.getUserJSFLibraries()).toString()), (boolean)false, (boolean)true, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
        }
        catch (SAXException e) {
            IOException ioe = (IOException)new IOException(this.workspace.getUserJSFLibraries() + ": " + e.toString()).initCause(e);
            throw ioe;
        }
        Element root = xml.getDocumentElement();
        if (!"JSFLibraryRegistry".equals(root.getLocalName()) || !JSF_LIB_NS.equals(root.getNamespaceURI())) {
            return;
        }
        for (Element el : XMLUtil.findSubElements((Element)root)) {
            String libraryName = el.getAttribute("Name");
            ArrayList<String> jars = new ArrayList<String>();
            for (Element file : XMLUtil.findSubElements((Element)el)) {
                String path = file.getAttribute("SourceLocation");
                if (!"false".equals(file.getAttribute("RelativeToWorkspace"))) {
                    path = new File(this.workspace.getDirectory(), path).getPath();
                }
                jars.add(path);
            }
            this.workspace.addUserLibrary(libraryName, jars, null, null);
        }
    }

    private void parseResourcesPreferences() throws IOException, ProjectImporterException {
        if (!this.workspace.getResourcesPreferenceFile().exists()) {
            return;
        }
        for (Map.Entry<String, String> entry : EclipseUtils.loadProperties(this.workspace.getResourcesPreferenceFile()).entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(RESOURCES_VARIABLE_PREFIX)) continue;
            Workspace.Variable var = new Workspace.Variable(key.substring(RESOURCES_VARIABLE_PREFIX_LENGTH), entry.getValue());
            this.workspace.addResourcesVariable(var);
        }
    }

    private void parseWorkspaceProjects() throws ProjectImporterException {
        FileFilter dirFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        HashSet<File> projectsDirs = new HashSet<File>();
        File[] innerDirs = this.workspace.getDirectory().listFiles(dirFilter);
        for (int i = 0; i < innerDirs.length; ++i) {
            File prjDir = innerDirs[i];
            if (!EclipseUtils.isRegularProject(prjDir)) continue;
            logger.finest("Found a regular Eclipse Project in: " + prjDir.getAbsolutePath());
            if (!projectsDirs.contains(prjDir)) {
                this.addLightProject(projectsDirs, prjDir, true);
                continue;
            }
            logger.finest("Trying to add the same project twice: " + prjDir.getAbsolutePath());
        }
        File[] resourceDirs = this.workspace.getResourceProjectsDir().listFiles(dirFilter);
        for (int i = 0; i < resourceDirs.length; ++i) {
            File resDir = resourceDirs[i];
            File location = WorkspaceParser.getLocation(resDir);
            if (location == null) continue;
            if (EclipseUtils.isRegularProject(location)) {
                logger.finest("Found a regular Eclipse Project in: " + location.getAbsolutePath());
                if (!projectsDirs.contains(location)) {
                    this.addLightProject(projectsDirs, location, false);
                    continue;
                }
                logger.finest("Trying to add the same project twice: " + location.getAbsolutePath());
                continue;
            }
            logger.finest(location.getAbsolutePath() + " does not contain regular project");
        }
        for (EclipseProject project : this.workspace.getProjects()) {
            project.setWorkspace(this.workspace);
            ProjectFactory.getInstance().loadDotProject(project);
        }
        for (EclipseProject project : this.workspace.getProjects()) {
            ProjectFactory.getInstance().loadDotClassPath(project);
        }
        for (EclipseProject project : this.workspace.getProjects()) {
            project.replaceContainers();
        }
    }

    private void addLightProject(Set<File> projectsDirs, File prjDir, boolean internal) {
        EclipseProject project = EclipseProject.createProject(prjDir);
        if (project != null) {
            project.setName(prjDir.getName());
            project.setInternal(internal);
            this.workspace.addProject(project);
            projectsDirs.add(prjDir);
        }
    }

    private static File getLocation(File prjDir) throws ProjectImporterException {
        if (".org.eclipse.jdt.core.external.folders".equals(prjDir.getName())) {
            return null;
        }
        File locationFile = new File(prjDir, ".location");
        if (locationFile.isFile()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(locationFile);
                File file = WorkspaceParser.getLocation(fis);
                return file;
            }
            catch (IOException e) {
                throw new ProjectImporterException("Error during reading .location file", e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        throw new ProjectImporterException(e);
                    }
                }
            }
        }
        return null;
    }

    static File getLocation(InputStream is) throws IOException {
        for (long toSkip = 17L; toSkip != 0L; toSkip -= is.skip(toSkip)) {
        }
        int pathLength = is.read();
        byte[] path = new byte[pathLength];
        int read = is.read(path);
        assert (read == pathLength);
        String pathS = new String(path, StandardCharsets.ISO_8859_1);
        if (pathS.startsWith("URI//")) {
            pathS = pathS.substring(pathS.indexOf(58) + 1);
        }
        if (pathS.length() == 0) {
            return null;
        }
        return new File(pathS);
    }

    private void parseLaunchConfigurations() throws IOException, ProjectImporterException {
        ArrayList<LaunchConfiguration> configs = new ArrayList<LaunchConfiguration>();
        File[] launches = new File(this.workspace.getDirectory(), ".metadata/.plugins/org.eclipse.debug.core/.launches").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".launch");
            }
        });
        if (launches != null) {
            for (File launch : launches) {
                Document doc;
                try {
                    doc = XMLUtil.parse((InputSource)new InputSource(Utilities.toURI((File)launch).toString()), (boolean)false, (boolean)false, null, null);
                }
                catch (SAXException x) {
                    throw new ProjectImporterException("Could not parse " + launch, x);
                }
                Element launchConfiguration = doc.getDocumentElement();
                String type = launchConfiguration.getAttribute("type");
                HashMap<String, String> attrs = new HashMap<String, String>();
                NodeList nl = launchConfiguration.getElementsByTagName("stringAttribute");
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element stringAttribute = (Element)nl.item(i);
                    attrs.put(stringAttribute.getAttribute("key"), stringAttribute.getAttribute("value"));
                }
                configs.add(new LaunchConfiguration(launch.getName().replaceFirst("\\.launch$", ""), type, (String)attrs.get("org.eclipse.jdt.launching.PROJECT_ATTR"), (String)attrs.get("org.eclipse.jdt.launching.MAIN_TYPE"), (String)attrs.get("org.eclipse.jdt.launching.PROGRAM_ARGUMENTS"), (String)attrs.get("org.eclipse.jdt.launching.VM_ARGUMENTS")));
            }
        }
        this.workspace.setLaunchConfigurations(configs);
    }
}

