/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.jsch;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.Authentication;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.netbeans.modules.nativeexecution.api.util.RemoteStatistics;
import org.netbeans.modules.nativeexecution.jsch.ConnectingProgressHandle;
import org.netbeans.modules.nativeexecution.jsch.MeasurableSocketFactory;
import org.netbeans.modules.nativeexecution.jsch.PortForwarding;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.RemoteUserInfo;
import org.openide.util.Cancellable;

public final class JSchChannelsSupport {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final int JSCH_CONNECTION_RETRY = Integer.getInteger("jsch.connection.retry", 3);
    private static final int JSCH_SESSIONS_PER_ENV = Integer.getInteger("jsch.sessions.per.env", 10);
    private static final int JSCH_CHANNELS_PER_SESSION = Integer.getInteger("jsch.channels.per.session", 10);
    private static final boolean UNIT_TEST_MODE = Boolean.getBoolean("nativeexecution.mode.unittest");
    private static final boolean USE_JZLIB = Boolean.getBoolean("jzlib");
    private static final HashMap<String, String> jschSessionConfig = new HashMap();
    private final JSch jsch;
    private final RemoteUserInfo userInfo;
    private final ExecutionEnvironment env;
    private final ReentrantLock sessionsLock = new ReentrantLock();
    private final Condition sessionAvailable = this.sessionsLock.newCondition();
    private final ConcurrentHashMap<Session, AtomicInteger> sessions = new ConcurrentHashMap();
    private final Set<Channel> knownChannels = new HashSet<Channel>();
    private final PortForwarding portForwarding = new PortForwarding();

    public JSchChannelsSupport(JSch jsch, ExecutionEnvironment env) {
        this.jsch = jsch;
        this.env = env;
        this.userInfo = new RemoteUserInfo(env, !UNIT_TEST_MODE);
    }

    public ChannelShell getShellChannel(boolean waitIfNoAvailable) throws JSchException, IOException, InterruptedException {
        return (ChannelShell)this.acquireChannel("shell", waitIfNoAvailable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Channel acquireChannel(String type, boolean waitIfNoAvailable) throws JSchException, IOException, InterruptedException {
        JSchException exception = null;
        for (int i = 0; i < JSCH_CONNECTION_RETRY; ++i) {
            Session session = this.findFreeSession();
            if (session == null && this.sessions.size() >= JSCH_SESSIONS_PER_ENV) {
                if (waitIfNoAvailable) {
                    try {
                        this.sessionsLock.lock();
                        while (session == null) {
                            this.sessionAvailable.await();
                            session = this.findFreeSession();
                        }
                    }
                    finally {
                        this.sessionsLock.unlock();
                    }
                } else {
                    throw new IOException("All " + JSCH_SESSIONS_PER_ENV + " sessions for " + this.env.getDisplayName() + " are fully loaded");
                }
            }
            try {
                Channel result;
                if (session == null) {
                    session = this.startNewSession(true);
                }
                if ((result = session.openChannel(type)) != null) {
                    log.log(Level.FINE, "Acquired channel [{0}] from session [{1}].", new Object[]{System.identityHashCode(result), System.identityHashCode(session)});
                    this.knownChannels.add(result);
                    return result;
                }
            }
            catch (JSchException ex) {
                exception = ex;
            }
            if (session == null || session.isConnected()) continue;
            this.sessions.remove(session);
        }
        assert (exception != null);
        throw exception;
    }

    public boolean isConnected() {
        for (Session s : this.sessions.keySet()) {
            if (!s.isConnected()) continue;
            return true;
        }
        return false;
    }

    public synchronized void reconnect(ExecutionEnvironment env) throws IOException, JSchException, InterruptedException {
        this.disconnect();
        this.connect();
    }

    private Session findFreeSession() {
        for (Map.Entry<Session, AtomicInteger> entry : this.sessions.entrySet()) {
            Session s = entry.getKey();
            AtomicInteger availableChannels = entry.getValue();
            if (!s.isConnected() || availableChannels.get() <= 0) continue;
            log.log(Level.FINE, "availableChannels == {0}", new Object[]{availableChannels.get()});
            int remains = availableChannels.decrementAndGet();
            log.log(Level.FINE, "Reuse session [{0}]. {1} channels remain...", new Object[]{System.identityHashCode(s), remains});
            return s;
        }
        return null;
    }

    public synchronized void connect() throws JSchException, InterruptedException {
        if (this.isConnected()) {
            return;
        }
        this.startNewSession(false);
    }

    public synchronized void disconnect() {
        for (Session s : this.sessions.keySet()) {
            s.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session startNewSession(boolean acquireChannel) throws JSchException, InterruptedException {
        Session newSession = null;
        final AtomicBoolean cancelled = new AtomicBoolean(false);
        ConnectingProgressHandle.startHandle(this.env, new Cancellable(){
            final /* synthetic */ JSchChannelsSupport this$0;
            {
                this.this$0 = this$0;
            }

            public boolean cancel() {
                cancelled.set(true);
                return true;
            }
        });
        try {
            while (!cancelled.get()) {
                try {
                    String methods;
                    newSession = this.jsch.getSession(this.env.getUser(), this.env.getHostAddress(), this.env.getSSHPort());
                    int serverAliveInterval = Integer.getInteger("jsch.server.alive.interval", 0);
                    if (serverAliveInterval > 0) {
                        newSession.setServerAliveInterval(serverAliveInterval);
                        int serverAliveCount = Integer.getInteger("jsch.server.alive.count", 5);
                        newSession.setServerAliveCountMax(serverAliveCount);
                    }
                    newSession.setUserInfo((UserInfo)this.userInfo);
                    for (Map.Entry<String, String> entry : jschSessionConfig.entrySet()) {
                        newSession.setConfig(entry.getKey(), entry.getValue());
                    }
                    Authentication auth = Authentication.getFor(this.env);
                    String preferredAuthKey = "PreferredAuthentications";
                    if (!jschSessionConfig.containsKey("PreferredAuthentications") && (methods = auth.getAuthenticationMethods().toJschString()) != null) {
                        log.finest("Setting auth method list to " + methods);
                        newSession.setConfig("PreferredAuthentications", methods);
                    }
                    if (USE_JZLIB) {
                        newSession.setConfig("compression.s2c", "zlib@openssh.com,zlib,none");
                        newSession.setConfig("compression.c2s", "zlib@openssh.com,zlib,none");
                        newSession.setConfig("compression_level", "9");
                    }
                    if (RemoteStatistics.COLLECT_STATISTICS && RemoteStatistics.COLLECT_TRAFFIC) {
                        newSession.setSocketFactory((SocketFactory)MeasurableSocketFactory.getInstance());
                    }
                    newSession.connect(auth.getTimeout() * 1000);
                    break;
                }
                catch (JSchException ex) {
                    if (!UNIT_TEST_MODE) {
                        String msg = ex.getMessage();
                        if (msg == null) {
                            throw ex;
                        }
                        if (!msg.startsWith("Auth fail") && !msg.startsWith("SSH_MSG_DISCONNECT: 2")) continue;
                        PasswordManager.getInstance().clearPassword(this.env);
                        continue;
                    }
                    throw ex;
                }
                catch (CancellationException cex) {
                    cancelled.set(true);
                }
            }
            if (cancelled.get()) {
                throw new InterruptedException("StartNewSession was cancelled ...");
            }
            this.portForwarding.initSession(newSession);
            this.sessions.put(newSession, new AtomicInteger(JSCH_CHANNELS_PER_SESSION - (acquireChannel ? 1 : 0)));
            log.log(Level.FINE, "New session [{0}] started.", new Object[]{System.identityHashCode(newSession)});
        }
        finally {
            ConnectingProgressHandle.stopHandle(this.env);
        }
        return newSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void releaseChannel(Channel channel) throws JSchException {
        if (!this.knownChannels.remove(channel)) {
            return;
        }
        Session s = channel.getSession();
        log.log(Level.FINE, "Releasing channel [{0}] for session [{1}].", new Object[]{System.identityHashCode(channel), System.identityHashCode(s)});
        channel.disconnect();
        int count = this.sessions.get(s).incrementAndGet();
        ArrayList<Session> sessionsToRemove = new ArrayList<Session>();
        if (count == JSCH_CHANNELS_PER_SESSION) {
            for (Map.Entry<Session, AtomicInteger> entry : this.sessions.entrySet()) {
                if (entry.getKey() == s || entry.getValue().get() <= 0) continue;
                log.log(Level.FINE, "Found another session [{0}] with {1} free slots. Will remove this one [{2}].", new Object[]{System.identityHashCode(entry.getKey()), entry.getValue().get(), System.identityHashCode(s)});
                sessionsToRemove.add(s);
                break;
            }
        } else {
            for (Map.Entry<Session, AtomicInteger> entry : this.sessions.entrySet()) {
                if (entry.getKey() == s || entry.getValue().get() != JSCH_CHANNELS_PER_SESSION) continue;
                log.log(Level.FINE, "Found empty session [{0}] while this one is also has free slots [{1}].", new Object[]{System.identityHashCode(entry.getKey()), System.identityHashCode(s)});
                sessionsToRemove.add(entry.getKey());
            }
        }
        for (Session sr : sessionsToRemove) {
            log.log(Level.FINE, "Closing session [{0}].", new Object[]{System.identityHashCode(s)});
            sr.disconnect();
            this.sessions.remove(sr);
        }
        try {
            this.sessionsLock.lock();
            this.sessionAvailable.signalAll();
        }
        finally {
            this.sessionsLock.unlock();
        }
    }

    public String getServerVersion() {
        for (Session s : this.sessions.keySet()) {
            if (!s.isConnected()) continue;
            return s.getServerVersion();
        }
        return null;
    }

    public int setPortForwardingL(int lport, String host, int rport) throws JSchException {
        this.portForwarding.addPortForwardingInfoL(lport, host, rport);
        for (Session s : this.sessions.keySet()) {
            if (!s.isConnected()) continue;
            return s.setPortForwardingL(lport, host, rport);
        }
        return -1;
    }

    public void setPortForwardingR(String bind_address, int rport, String host, int lport) throws JSchException {
        this.portForwarding.addPortForwardingInfoR(bind_address, rport, host, lport);
        for (Session s : this.sessions.keySet()) {
            if (!s.isConnected()) continue;
            s.setPortForwardingR(bind_address, rport, host, lport);
        }
    }

    public void delPortForwardingR(int rport) throws JSchException {
        this.portForwarding.removePortForwardingInfoR(rport);
        for (Session s : this.sessions.keySet()) {
            if (!s.isConnected()) continue;
            s.delPortForwardingR(rport);
        }
    }

    public void delPortForwardingL(int lport) throws JSchException {
        this.portForwarding.removePortForwardingInfoL(lport);
        for (Session s : this.sessions.keySet()) {
            if (!s.isConnected()) continue;
            s.delPortForwardingL(lport);
        }
    }

    public String getConfig(String key) {
        for (Session s : this.sessions.keySet()) {
            if (!s.isConnected()) continue;
            return s.getConfig(key);
        }
        return null;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.env;
    }

    static {
        HashSet<Map.Entry<Object, Object>> data = new HashSet<Map.Entry<Object, Object>>(System.getProperties().entrySet());
        for (Map.Entry entry : data) {
            String var = entry.getKey().toString();
            String val = entry.getValue().toString();
            if (var == null || val == null) continue;
            if (var.startsWith("jsch.session.cfg.")) {
                jschSessionConfig.put(var.substring(17), val);
            }
            if (!var.startsWith("jsch.cfg.")) continue;
            JSch.setConfig((String)var.substring(9), (String)val);
            jschSessionConfig.put(var.substring(9), val);
        }
    }
}

