/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2sedeploy;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.java.j2sedeploy.J2SEDeployProperties;
import org.netbeans.spi.project.ant.GeneratedFilesInterceptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public class J2SEDeployGeneratedFilesInterceptor
implements GeneratedFilesInterceptor {
    private static final Logger LOG = Logger.getLogger(J2SEDeployGeneratedFilesInterceptor.class.getName());
    private final ThreadLocal<Boolean> reenter = new ThreadLocal();

    public void fileGenerated(final @NonNull Project project, @NonNull String path) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"path", (Object)path);
        if ("nbproject/build-impl.xml".equals(path)) {
            final AntBuildExtender extender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
            if (extender == null) {
                LOG.log(Level.WARNING, "The project {0} ({1}) does not support AntBuildExtender.", new Object[]{ProjectUtils.getInformation((Project)project).getDisplayName(), FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory())});
                return;
            }
            this.runDeferred(new Runnable(){
                final /* synthetic */ J2SEDeployGeneratedFilesInterceptor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.updateIfNeeded(project, extender);
                }
            });
        }
    }

    private void runDeferred(final @NonNull Runnable r) {
        Parameters.notNull((CharSequence)"r", (Object)r);
        ProjectManager.mutex().postReadRequest(new Runnable(){
            final /* synthetic */ J2SEDeployGeneratedFilesInterceptor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                ProjectManager.mutex().postWriteRequest(r);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIfNeeded(@NonNull Project project, @NonNull AntBuildExtender extender) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"extender", (Object)extender);
        if (extender.getExtension(J2SEDeployProperties.getCurrentExtensionName()) != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "The project {0} ({1}) already has a current version ({2}) of JWS extension.", new Object[]{ProjectUtils.getInformation((Project)project).getDisplayName(), FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()), J2SEDeployProperties.getCurrentExtensionName()});
            }
            return;
        }
        this.reenter.set(Boolean.TRUE);
        try {
            boolean needsUpdate = false;
            for (String oldExt : J2SEDeployProperties.getOldExtensionNames()) {
                AntBuildExtender.Extension extension = extender.getExtension(oldExt);
                if (extension == null) continue;
                extender.removeExtension(oldExt);
                needsUpdate = true;
            }
            if (needsUpdate) {
                try {
                    J2SEDeployProperties.updateJ2SEDeployExtension(project);
                    ProjectManager.getDefault().saveProject(project);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        finally {
            this.reenter.remove();
        }
    }
}

