/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Pair;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class MavenSourceLevelImpl
implements SourceLevelQueryImplementation2 {
    private static final Logger LOGGER = Logger.getLogger(MavenSourceLevelImpl.class.getName());
    static final Pattern PROFILE = Pattern.compile("-profile (compact1|compact2|compact3){1}?");
    private static final List<Pair<String, String>> SOURCE_PROPERTIES_AND_PARAM = List.of(Pair.of((Object)"maven.compiler.release", (Object)"release"), Pair.of((Object)"maven.compiler.source", (Object)"source"));
    private static final List<Pair<String, String>> TEST_PROPERTIES_AND_PARAM = List.of(Pair.of((Object)"maven.compiler.testRelease", (Object)"testRelease"), Pair.of((Object)"maven.compiler.release", (Object)"release"), Pair.of((Object)"maven.compiler.testSource", (Object)"testSource"), Pair.of((Object)"maven.compiler.source", (Object)"source"));
    private final Project project;

    public MavenSourceLevelImpl(Project proj) {
        this.project = proj;
    }

    private String getSourceLevelString(FileObject javaFile) {
        File file = FileUtil.toFile((FileObject)javaFile);
        if (file == null) {
            return null;
        }
        URI uri = Utilities.toURI((File)file);
        assert ("file".equals(uri.getScheme()));
        String goal = "compile";
        List<Pair<String, String>> propertiesAndParams = SOURCE_PROPERTIES_AND_PARAM;
        NbMavenProjectImpl nbprj = (NbMavenProjectImpl)this.project.getLookup().lookup(NbMavenProjectImpl.class);
        for (URI testuri : nbprj.getSourceRoots(true)) {
            if (!uri.getPath().startsWith(testuri.getPath())) continue;
            goal = "testCompile";
            propertiesAndParams = TEST_PROPERTIES_AND_PARAM;
        }
        for (URI testuri : nbprj.getGeneratedSourceRoots(true)) {
            if (!uri.getPath().startsWith(testuri.getPath())) continue;
            goal = "testCompile";
            propertiesAndParams = TEST_PROPERTIES_AND_PARAM;
        }
        for (Pair pair : propertiesAndParams) {
            String sourceLevel = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", (String)pair.second(), goal, (String)pair.first());
            if (sourceLevel == null) continue;
            return sourceLevel;
        }
        String version = PluginPropertyUtils.getPluginVersion(nbprj.getOriginalMavenProject(), "org.apache.maven.plugins", "maven-compiler-plugin");
        if (version == null) {
            return "1.8";
        }
        if (new DefaultArtifactVersion(version).compareTo((ArtifactVersion)new DefaultArtifactVersion("3.11.0")) >= 0) {
            return "1.8";
        }
        if (new DefaultArtifactVersion(version).compareTo((ArtifactVersion)new DefaultArtifactVersion("3.9.0")) >= 0) {
            return "1.7";
        }
        if (new DefaultArtifactVersion(version).compareTo((ArtifactVersion)new DefaultArtifactVersion("3.8.0")) >= 0) {
            return "1.6";
        }
        if (new DefaultArtifactVersion(version).compareTo((ArtifactVersion)new DefaultArtifactVersion("2.3")) >= 0) {
            return "1.5";
        }
        return "1.3";
    }

    private SourceLevelQuery.Profile getSourceProfile(FileObject javaFile) {
        Matcher match;
        File file = FileUtil.toFile((FileObject)javaFile);
        if (file == null) {
            return SourceLevelQuery.Profile.DEFAULT;
        }
        URI uri = Utilities.toURI((File)file);
        assert ("file".equals(uri.getScheme()));
        String goal = "compile";
        NbMavenProjectImpl nbprj = (NbMavenProjectImpl)this.project.getLookup().lookup(NbMavenProjectImpl.class);
        for (URI testuri : nbprj.getSourceRoots(true)) {
            if (!uri.getPath().startsWith(testuri.getPath())) continue;
            goal = "testCompile";
        }
        for (URI testuri : nbprj.getGeneratedSourceRoots(true)) {
            if (!uri.getPath().startsWith(testuri.getPath())) continue;
            goal = "testCompile";
        }
        String args = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", "compilerArgument", goal, null);
        if (args != null && (match = PROFILE.matcher(args)).find()) {
            String prof = match.group(1);
            SourceLevelQuery.Profile toRet = SourceLevelQuery.Profile.forName((String)prof);
            return toRet != null ? toRet : SourceLevelQuery.Profile.DEFAULT;
        }
        String compilerArgumentsProfile = PluginPropertyUtils.getPluginPropertyBuildable(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", goal, new ConfigBuilder());
        if (compilerArgumentsProfile != null) {
            SourceLevelQuery.Profile toRet = SourceLevelQuery.Profile.forName((String)compilerArgumentsProfile);
            return toRet != null ? toRet : SourceLevelQuery.Profile.DEFAULT;
        }
        String[] compilerArgs = PluginPropertyUtils.getPluginPropertyList(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", "compilerArgs", "arg", goal);
        if (compilerArgs != null) {
            Iterator<String> it = Arrays.asList(compilerArgs).iterator();
            while (it.hasNext()) {
                String p = it.next();
                if (!"-profile".equals(p) || !it.hasNext()) continue;
                String prof = it.next();
                SourceLevelQuery.Profile toRet = SourceLevelQuery.Profile.forName((String)prof);
                return toRet != null ? toRet : SourceLevelQuery.Profile.DEFAULT;
            }
        }
        return SourceLevelQuery.Profile.DEFAULT;
    }

    public SourceLevelQueryImplementation2.Result getSourceLevel(FileObject javaFile) {
        return new ResultImpl(javaFile);
    }

    private static class ConfigBuilder
    implements PluginPropertyUtils.ConfigurationBuilder<String> {
        private ConfigBuilder() {
        }

        @Override
        public String build(Xpp3Dom configRoot, ExpressionEvaluator eval) {
            Xpp3Dom prof;
            Xpp3Dom args;
            if (configRoot != null && (args = configRoot.getChild("compilerArguments")) != null && (prof = args.getChild("profile")) != null) {
                return prof.getValue();
            }
            return null;
        }
    }

    private class ResultImpl
    implements SourceLevelQueryImplementation2.Result2,
    PropertyChangeListener {
        private final FileObject javaFile;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final PropertyChangeListener pcl;
        private String cachedLevel;
        private SourceLevelQuery.Profile cachedProfile;
        private final Object CACHE_LOCK;

        ResultImpl(FileObject javaFile) {
            this.pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)MavenSourceLevelImpl.this.project.getLookup().lookup(NbMavenProject.class));
            this.cachedLevel = null;
            this.CACHE_LOCK = new Object();
            this.javaFile = javaFile;
            ((NbMavenProject)MavenSourceLevelImpl.this.project.getLookup().lookup(NbMavenProject.class)).addPropertyChangeListener(this.pcl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getSourceLevel() {
            Object object = this.CACHE_LOCK;
            synchronized (object) {
                if (this.cachedLevel == null) {
                    this.cachedLevel = MavenSourceLevelImpl.this.getSourceLevelString(this.javaFile);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "MavenSourceLevelQuery: {0} level {1}", new Object[]{this.javaFile.getPath(), this.cachedLevel});
                }
                return this.cachedLevel;
            }
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                Project p = (Project)evt.getSource();
                if (((NbMavenProject)p.getLookup().lookup(NbMavenProject.class)).isUnloadable()) {
                    return;
                }
                Object object = this.CACHE_LOCK;
                synchronized (object) {
                    this.cachedLevel = null;
                    this.cachedProfile = null;
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "MavenSourceLevelQuery: {0} fire change", this.javaFile.getPath());
                }
                this.cs.fireChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SourceLevelQuery.Profile getProfile() {
            Object object = this.CACHE_LOCK;
            synchronized (object) {
                if (this.cachedProfile == null) {
                    this.cachedProfile = MavenSourceLevelImpl.this.getSourceProfile(this.javaFile);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "MavenSourceLevelQuery: {0} profile {1}", new Object[]{this.javaFile.getPath(), this.cachedProfile});
                }
                return this.cachedProfile;
            }
        }
    }
}

