/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.web.indent.api.LexUtilities;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;

public class JspTypedTextInterceptor
implements TypedTextInterceptor {
    private boolean showCompletion;

    public boolean beforeInsert(TypedTextInterceptor.Context context) throws BadLocationException {
        return false;
    }

    public void insert(TypedTextInterceptor.MutableContext context) throws BadLocationException {
        this.showCompletion = this.handledELBracketsCompletion(context);
    }

    public void afterInsert(final TypedTextInterceptor.Context context) throws BadLocationException {
        char ch = context.getText().charAt(0);
        final BaseDocument doc = (BaseDocument)context.getDocument();
        if (ch == '}') {
            final AtomicReference ex = new AtomicReference();
            doc.runAtomicAsUser(new Runnable(){
                final /* synthetic */ JspTypedTextInterceptor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    int caretOffset = context.getOffset();
                    Caret caret = context.getComponent().getCaret();
                    try {
                        Token token;
                        TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)doc, (int)caretOffset, (Language)JspTokenId.language());
                        if (ts == null) {
                            return;
                        }
                        ts.move(caretOffset);
                        if (!ts.moveNext() && !ts.movePrevious()) {
                            return;
                        }
                        while ((token = ts.token()).id() != JspTokenId.EOL) {
                            if (token.id() == JspTokenId.EL) {
                                String elText = CharSequenceUtilities.toString((CharSequence)token.text());
                                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
                                int offset = token.offset(tokenHierarchy) + token.length();
                                if (elText.matches("(\\$\\{|\\#\\{).*") && offset > caretOffset) {
                                    doc.remove(caretOffset, 1);
                                    caret.setDot(caretOffset + 1);
                                    return;
                                }
                            }
                            if (ts.movePrevious()) continue;
                            break;
                        }
                    }
                    catch (BadLocationException blex) {
                        ex.set(blex);
                    }
                }
            });
            BadLocationException blex = (BadLocationException)ex.get();
            if (blex != null) {
                throw blex;
            }
            return;
        }
        if (ch == '>') {
            final AtomicReference ex = new AtomicReference();
            doc.render(new Runnable(){
                final /* synthetic */ JspTypedTextInterceptor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    int caretOffset = context.getOffset();
                    try {
                        TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)doc, (int)caretOffset, (Language)JspTokenId.language());
                        if (ts == null) {
                            return;
                        }
                        ts.move(caretOffset);
                        boolean found = false;
                        while (ts.movePrevious()) {
                            if (ts.token().id() == JspTokenId.SYMBOL && (ts.token().text().toString().equals("<") || ts.token().text().toString().equals("</"))) {
                                found = true;
                                break;
                            }
                            if ((ts.token().id() != JspTokenId.SYMBOL || !ts.token().text().toString().equals(">")) && (ts.token().id() == JspTokenId.ATTRIBUTE || ts.token().id() == JspTokenId.ATTR_VALUE || ts.token().id() == JspTokenId.TAG || ts.token().id() == JspTokenId.ENDTAG || ts.token().id() == JspTokenId.SYMBOL || ts.token().id() == JspTokenId.EOL || ts.token().id() == JspTokenId.WHITESPACE)) continue;
                        }
                        if (found) {
                            final Position from = doc.createPosition(Utilities.getRowStart((BaseDocument)doc, (int)ts.offset()));
                            final Position to = doc.createPosition(Utilities.getRowEnd((BaseDocument)doc, (int)ts.offset()));
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    final Indent indent = Indent.get((Document)doc);
                                    indent.lock();
                                    try {
                                        doc.runAtomic(new Runnable(){
                                            final /* synthetic */ 1 this$2;
                                            {
                                                this.this$2 = this$2;
                                            }

                                            @Override
                                            public void run() {
                                                try {
                                                    indent.reindent(from.getOffset(), to.getOffset());
                                                }
                                                catch (BadLocationException badLocationException) {
                                                    // empty catch block
                                                }
                                            }
                                        });
                                    }
                                    finally {
                                        indent.unlock();
                                    }
                                }
                            });
                        }
                    }
                    catch (BadLocationException blex) {
                        ex.set(blex);
                    }
                }
            });
            BadLocationException blex = (BadLocationException)ex.get();
            if (blex != null) {
                throw blex;
            }
            return;
        }
        this.showCompletion();
    }

    public void cancelled(TypedTextInterceptor.Context context) {
        this.showCompletion = false;
    }

    private boolean handledELBracketsCompletion(TypedTextInterceptor.MutableContext context) throws BadLocationException {
        BaseDocument doc = (BaseDocument)context.getDocument();
        int dotPos = context.getOffset();
        if (dotPos > 0) {
            String charPrefix = doc.getText(dotPos - 1, 1);
            String str = context.getText();
            if ("{".equals(str) && ("#".equals(charPrefix) || "$".equals(charPrefix))) {
                context.setText("{}", 1);
                return true;
            }
        }
        return false;
    }

    private void showCompletion() {
        if (this.showCompletion) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Completion.get().showCompletion();
                }
            });
        }
    }

    public static class JspFactory
    implements TypedTextInterceptor.Factory {
        public TypedTextInterceptor createTypedTextInterceptor(MimePath mimePath) {
            return new JspTypedTextInterceptor();
        }
    }
}

