/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.spi.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.actions.ActionMappingScanner;
import org.netbeans.modules.gradle.api.execute.ActionMapping;
import org.netbeans.modules.gradle.api.execute.GradleExecConfiguration;
import org.netbeans.modules.gradle.spi.actions.GradleActionsProvider;
import org.netbeans.spi.project.LookupProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.xml.sax.SAXException;

public abstract class DefaultGradleActionsProvider
implements GradleActionsProvider {
    final Set<String> supportedActions;

    public DefaultGradleActionsProvider(String ... actions) {
        HashSet<String> actionSet = new HashSet<String>(Arrays.asList(actions));
        this.supportedActions = Collections.unmodifiableSet(actionSet);
    }

    @Override
    public final Set<String> getSupportedActions() {
        return this.supportedActions;
    }

    @Override
    public boolean isActionEnabled(String action, Project project, Lookup context) {
        return this.supportedActions.contains(action);
    }

    @Override
    public final InputStream defaultActionMapConfig() {
        return this.getClass().getResourceAsStream("action-mapping.xml");
    }

    public static LookupProvider forProjectLayer(FileObject fo) throws IOException {
        Object r = fo.getAttribute("resource");
        if (!(r instanceof String)) {
            throw new IllegalArgumentException("Resource URL not found: " + String.valueOf(fo));
        }
        final URL u = new URL(r.toString());
        return new LookupProvider(){

            public Lookup createAdditionalLookup(Lookup baseContext) {
                return Lookups.fixed((Object[])new Object[]{new ResourceActionsProvider(u)});
            }
        };
    }

    private static class ResourceActionsProvider
    implements GradleActionsProvider {
        private final URL resourceURL;
        private Set<String> actions;

        public ResourceActionsProvider(URL resourceURL) {
            this.resourceURL = resourceURL;
        }

        @Override
        public boolean isActionEnabled(String action, Project project, Lookup context) {
            return this.getSupportedActions().contains(action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<String> getSupportedActions() {
            HashSet<String> ids;
            if (this.actions != null) {
                return this.actions;
            }
            try {
                HashMap<GradleExecConfiguration, Set<ActionMapping>> mapp = new HashMap<GradleExecConfiguration, Set<ActionMapping>>();
                Set<ActionMapping> def = ActionMappingScanner.loadMappings(this.defaultActionMapConfig(), mapp);
                HashSet nids = new HashSet();
                def.forEach(a -> nids.add(a.getName()));
                for (Set m : mapp.values()) {
                    m.forEach(a -> nids.add(a.getName()));
                }
                ids = nids;
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                ids = new HashSet<String>();
            }
            ResourceActionsProvider resourceActionsProvider = this;
            synchronized (resourceActionsProvider) {
                this.actions = ids;
                return ids;
            }
        }

        @Override
        public InputStream defaultActionMapConfig() {
            try {
                return this.resourceURL.openStream();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return new ByteArrayInputStream(new byte[0]);
            }
        }
    }
}

