/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.execute;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.ConfigurableLauncher;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.execute.Bundle;
import org.netbeans.modules.gradle.options.GradleExperimentalSettings;
import org.netbeans.modules.gradle.options.NetworkProxySettings;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.NotificationDisplayer;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;

public class GradleNetworkProxySupport {
    private static final Logger LOG = Logger.getLogger(GradleNetworkProxySupport.class.getName());
    private static final String PROBE_URI_STRING = "http://search.maven.org";
    private static final String FILENAME_SUFFIX_OLD = ".old";
    private static final String SYSTEMPROP_HTTPS_PROXYPORT = "systemProp.https.proxyPort";
    private static final String SYSTEMPROP_HTTP_PROXYPORT = "systemProp.http.proxyPort";
    private static final String SYSTEMPROP_HTTPS_PROXYHOST = "systemProp.https.proxyHost";
    private static final String SYSTEMPROP_HTTP_PROXYHOST = "systemProp.http.proxyHost";
    private static final String JVM_HTTPS_PROXYPORT = "https.proxyPort";
    private static final String JVM_HTTP_PROXYPORT = "http.proxyPort";
    private static final String JVM_HTTPS_PROXYHOST = "https.proxyHost";
    private static final String JVM_HTTP_PROXYHOST = "http.proxyHost";
    private static final int PORT_DEFAULT_HTTPS = 1080;
    private static final int PORT_DEFAULT_HTTP = 80;
    private static final int PROXY_PROBE_TIMEOUT = Integer.getInteger("netbeans.networkProxy.timeout", 1000);
    private final Project project;
    private static Map<String, ProxyResult> acknowledgedResults = new HashMap<String, ProxyResult>();

    public GradleNetworkProxySupport(Project project) {
        this.project = project;
    }

    public CompletableFuture<ProxyResult> checkProxySettings() {
        return new Processor().checkProxy();
    }

    private class Processor {
        Proxy publicProxy;
        String publicProxyHost;
        int publicProxyPort;
        int publicProxyNonDefaultPort;
        String proxyAuthority;
        String proxyHost;
        String publicProxySpec;
        int proxyPort;
        GradleFiles gradleFiles;

        private Processor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletableFuture<ProxyResult> checkProxy() {
            ProxyResult result;
            String userMessage;
            NetworkProxySettings action;
            boolean supportOverride;
            block36: {
                block38: {
                    Proxy probeProxy;
                    block39: {
                        block37: {
                            boolean direct;
                            supportOverride = NetworkProxySettings.allowProxyOverride();
                            action = GradleExperimentalSettings.getDefault().getNetworkProxy();
                            if (action == NetworkProxySettings.IGNORE) {
                                return CompletableFuture.completedFuture(this.createResult(Status.CONTINUE));
                            }
                            this.obtainPublicProxy();
                            this.loadProjectProxy();
                            boolean bl = direct = this.publicProxy == null || this.publicProxy.type() == Proxy.Type.DIRECT;
                            if (direct && this.proxyAuthority == null || this.gradleFiles == null) {
                                LOG.log(Level.FINE, "Project does not specify a proxy and none is needed");
                                return CompletableFuture.completedFuture(this.createResult(Status.CONTINUE));
                            }
                            if (this.publicProxy != null) {
                                if (this.publicProxyHost == null) {
                                    LOG.log(Level.WARNING, "Unable to decipher proxy: {0}", this.publicProxy);
                                    return CompletableFuture.completedFuture(new ProxyResult(Status.UNKNOWN, null));
                                }
                                if (this.publicProxyHost.equals(this.proxyHost) && this.proxyPort == this.publicProxyPort) {
                                    LOG.log(Level.FINE, "Project specifies detected proxy: {0}", this.publicProxySpec);
                                    return CompletableFuture.completedFuture(new ProxyResult(Status.CONTINUE, this.publicProxy));
                                }
                            }
                            userMessage = direct ? Bundle.MSG_ProxyMisconfiguredDirect(this.proxyAuthority) : (this.proxyAuthority == null ? Bundle.MSG_ProxyMisconfiguredMissing(this.publicProxySpec) : Bundle.MSG_ProxyMisconfiguredOther(this.publicProxySpec, this.proxyAuthority));
                            Processor processor = this;
                            synchronized (processor) {
                                result = acknowledgedResults.get(this.publicProxySpec);
                            }
                            if (result != null) {
                                LOG.log(Level.FINE, "Reusing previous decision: {0} with proxy {1}", new Object[]{result.getStatus(), result.proxySpec});
                                switch (result.getStatus().ordinal()) {
                                    case 1: {
                                        action = NetworkProxySettings.IGNORE;
                                        break;
                                    }
                                    case 3: {
                                        action = NetworkProxySettings.OVERRIDE;
                                        break;
                                    }
                                    case 2: {
                                        action = NetworkProxySettings.UPDATE;
                                    }
                                }
                            }
                            if (this.proxyHost != null) {
                                supportOverride = false;
                                if (action == NetworkProxySettings.OVERRIDE) {
                                    action = NetworkProxySettings.NOTICE;
                                }
                            }
                            if (action == NetworkProxySettings.IGNORE || PROXY_PROBE_TIMEOUT <= 0) break block36;
                            if (this.proxyHost == null) break block37;
                            LOG.log(Level.FINE, "Trying to probe with proxy {0}", this.proxyAuthority);
                            InetSocketAddress sa = new InetSocketAddress(this.proxyHost, this.proxyPort);
                            if (sa.isUnresolved()) break block38;
                            probeProxy = new Proxy(Proxy.Type.HTTP, sa);
                            break block39;
                        }
                        probeProxy = Proxy.NO_PROXY;
                    }
                    URL probeUrl = new URL(GradleNetworkProxySupport.PROBE_URI_STRING);
                    HttpURLConnection c = null;
                    try {
                        c = (HttpURLConnection)probeUrl.openConnection(probeProxy);
                        c.setReadTimeout(PROXY_PROBE_TIMEOUT);
                        c.setConnectTimeout(PROXY_PROBE_TIMEOUT);
                        c.setRequestMethod("HEAD");
                        c.connect();
                        c.getLastModified();
                        CompletableFuture<ProxyResult> completableFuture = CompletableFuture.completedFuture(new ProxyResult(Status.CONTINUE, probeProxy, this.proxyAuthority, this.publicProxySpec, this.publicProxyHost, this.publicProxyPort));
                        if (c != null) {
                            c.disconnect();
                        }
                        return completableFuture;
                    }
                    catch (IOException ex) {
                        try {
                            try {
                                LOG.log(Level.FINE, "Tool proxy {0} probe failed", this.proxyAuthority);
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (c != null) {
                                    c.disconnect();
                                }
                            }
                        }
                        catch (MalformedURLException ex2) {
                            Exceptions.printStackTrace((Throwable)ex2);
                        }
                    }
                }
                LOG.log(Level.FINE, "Tool proxy {0} probe not resolvable", this.proxyAuthority);
            }
            switch (action) {
                case IGNORE: {
                    return CompletableFuture.completedFuture(this.createResult(Status.CONTINUE));
                }
                case NOTICE: {
                    NotificationDisplayer.getDefault().notify(Bundle.TITLE_GradleProxyMismatch(), (Icon)NbGradleProject.getIcon(), userMessage, null, NotificationDisplayer.Priority.NORMAL, NotificationDisplayer.Category.WARNING);
                    return CompletableFuture.completedFuture(this.createResult(Status.CONTINUE));
                }
                case OVERRIDE: {
                    return CompletableFuture.completedFuture(this.createResult(Status.OVERRIDE));
                }
                case UPDATE: {
                    return CompletableFuture.completedFuture(this.updateGradleConfiguration(false));
                }
                case ASK: {
                    if (result != null) {
                        return CompletableFuture.completedFuture(result);
                    }
                    String promptMsg = supportOverride ? userMessage + Bundle.MSG_AppendAskUpdate() : userMessage + Bundle.MSG_AppendAskUpdate2();
                    NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)promptMsg, Bundle.TITLE_GradleProxyMismatch(), 2, 2);
                    if (supportOverride) {
                        desc.setAdditionalOptions(new Object[]{Bundle.ACTION_Continue(), Bundle.ACTION_Override()});
                    } else {
                        desc.setAdditionalOptions(new Object[]{Bundle.ACTION_Continue()});
                    }
                    desc.setValue(NotifyDescriptor.OK_OPTION);
                    return ((CompletableFuture)DialogDisplayer.getDefault().notifyFuture((NotifyDescriptor)desc).thenApply(this::processUserConfirmation)).exceptionally(t -> {
                        if (t instanceof CompletionException && t.getCause() instanceof CancellationException) {
                            return this.createResult(Status.ABORT);
                        }
                        return this.createResult(Status.UNKNOWN);
                    });
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProxyResult createResult(Status s) {
            boolean keep = false;
            switch (s.ordinal()) {
                case 3: {
                    keep = true;
                    LOG.log(Level.FINE, "Will override proxy to {0}", this.publicProxy);
                    break;
                }
                case 4: {
                    LOG.log(Level.FINE, "Will abort operation");
                    break;
                }
                case 1: {
                    keep = true;
                    LOG.log(Level.FINE, "No action will be taken");
                    break;
                }
                case 2: {
                    LOG.log(Level.FINE, "User properties were reconfigured to {0}", this.publicProxy);
                }
            }
            ProxyResult r = new ProxyResult(s, this.publicProxy, this.proxyAuthority, this.publicProxySpec, this.publicProxyHost, this.publicProxyPort);
            if (keep) {
                Processor processor = this;
                synchronized (processor) {
                    acknowledgedResults.put(this.publicProxySpec, r);
                }
            }
            return r;
        }

        ProxyResult updateGradleConfiguration(boolean interactive) {
            File userProps;
            EditableProperties eprops;
            block22: {
                eprops = new EditableProperties(true);
                userProps = this.gradleFiles.getFile(GradleFiles.Kind.USER_PROPERTIES);
                if (userProps.exists()) {
                    try (FileInputStream is = new FileInputStream(userProps);){
                        eprops.load((InputStream)is);
                        break block22;
                    }
                    catch (IOException ex) {
                        NotificationDisplayer.getDefault().notify(Bundle.TITLE_ConfigUpdateFailed(), NbGradleProject.getWarningIcon(), Bundle.ERROR_ConfigUpdateFailed(ex.getLocalizedMessage()), null, NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.ERROR);
                        return this.createResult(Status.UNKNOWN);
                    }
                }
                if (this.publicProxyHost == null) {
                    return this.createResult(Status.CONTINUE);
                }
            }
            if (this.publicProxy != null) {
                eprops.put(GradleNetworkProxySupport.SYSTEMPROP_HTTP_PROXYHOST, this.publicProxyHost);
                eprops.put(GradleNetworkProxySupport.SYSTEMPROP_HTTPS_PROXYHOST, this.publicProxyHost);
                if (this.publicProxyNonDefaultPort > 0) {
                    eprops.put(GradleNetworkProxySupport.SYSTEMPROP_HTTP_PROXYPORT, Integer.toString(this.publicProxyNonDefaultPort));
                    eprops.put(GradleNetworkProxySupport.SYSTEMPROP_HTTPS_PROXYPORT, Integer.toString(this.publicProxyNonDefaultPort));
                } else {
                    eprops.remove((Object)GradleNetworkProxySupport.SYSTEMPROP_HTTP_PROXYPORT);
                    eprops.remove((Object)GradleNetworkProxySupport.SYSTEMPROP_HTTPS_PROXYPORT);
                }
                eprops.setComment(GradleNetworkProxySupport.SYSTEMPROP_HTTP_PROXYHOST, new String[]{Bundle.COMMENT_CreatedByNetBeans(DateFormat.getDateTimeInstance().format(new Date()))}, true);
            } else {
                eprops.remove((Object)GradleNetworkProxySupport.SYSTEMPROP_HTTP_PROXYHOST);
                eprops.remove((Object)GradleNetworkProxySupport.SYSTEMPROP_HTTP_PROXYPORT);
                eprops.remove((Object)GradleNetworkProxySupport.SYSTEMPROP_HTTPS_PROXYHOST);
                eprops.remove((Object)GradleNetworkProxySupport.SYSTEMPROP_HTTPS_PROXYPORT);
            }
            if (userProps.exists()) {
                String base = userProps.getName() + GradleNetworkProxySupport.FILENAME_SUFFIX_OLD;
                File f = new File(userProps.getParentFile(), base);
                int n = 1;
                while (f.exists()) {
                    f = new File(userProps.getParentFile(), base + "." + n);
                    ++n;
                }
                userProps.renameTo(f);
            }
            try (FileOutputStream os = new FileOutputStream(userProps);){
                eprops.store((OutputStream)os);
                StatusDisplayer.getDefault().setStatusText(this.proxyHost == null ? Bundle.MSG_ProxyCleared() : Bundle.MSG_ProxySetTo(this.proxyAuthority));
            }
            catch (IOException ex) {
                NotificationDisplayer.getDefault().notify(Bundle.TITLE_ConfigUpdateFailed(), NbGradleProject.getWarningIcon(), Bundle.ERROR_ConfigUpdateFailed(ex.getLocalizedMessage()), null, NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.ERROR);
                return this.createResult(Status.ABORT);
            }
            return this.createResult(Status.RECONFIGURED);
        }

        ProxyResult processUserConfirmation(NotifyDescriptor desc) {
            Object val = desc.getValue();
            if (val == NotifyDescriptor.CANCEL_OPTION) {
                return this.createResult(Status.ABORT);
            }
            if (val == Bundle.ACTION_Continue()) {
                return this.createResult(Status.CONTINUE);
            }
            if (val == Bundle.ACTION_Override()) {
                return this.createResult(Status.OVERRIDE);
            }
            if (val == NotifyDescriptor.OK_OPTION) {
                return this.updateGradleConfiguration(true);
            }
            return this.createResult(Status.UNKNOWN);
        }

        private void obtainPublicProxy() {
            SocketAddress proxyAddress;
            URI probeUri;
            try {
                probeUri = new URI(GradleNetworkProxySupport.PROBE_URI_STRING);
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
            List<Proxy> proxies = ProxySelector.getDefault().select(probeUri);
            LOG.log(Level.FINER, "Detected proxies for URI {0}: {1}", new Object[]{probeUri, proxies});
            for (Proxy p : proxies) {
                if (p.type() == Proxy.Type.HTTP) {
                    this.publicProxy = p;
                    LOG.log(Level.FINE, "Selected HTTP proxy: {0}", p);
                    break;
                }
                if (p.type() != Proxy.Type.SOCKS || this.publicProxy != null) continue;
                LOG.log(Level.FINE, "Found SOCKS proxy: {0}", p);
                this.publicProxy = p;
            }
            if (this.publicProxy != null && (proxyAddress = this.publicProxy.address()) instanceof InetSocketAddress) {
                InetSocketAddress iaddr = (InetSocketAddress)proxyAddress;
                int port = iaddr.getPort();
                int defPort = -1;
                switch (this.publicProxy.type()) {
                    case HTTP: {
                        defPort = 80;
                        break;
                    }
                    case SOCKS: {
                        defPort = 1080;
                    }
                }
                if (port > 1) {
                    this.publicProxyPort = port;
                    if (this.publicProxyPort != defPort) {
                        this.publicProxyNonDefaultPort = port;
                    }
                }
                this.publicProxyHost = ((InetSocketAddress)proxyAddress).getHostString();
                this.publicProxySpec = this.publicProxyHost + (String)(this.publicProxyNonDefaultPort == 0 ? "" : ":" + this.publicProxyNonDefaultPort);
                LOG.log(Level.FINE, "Detected proxy: {0}", this.publicProxySpec);
            }
        }

        private boolean extractNetworkProxy(Properties props) {
            int defPort;
            String portKey;
            this.proxyHost = props.getProperty(GradleNetworkProxySupport.SYSTEMPROP_HTTP_PROXYHOST);
            if (this.proxyHost == null || this.proxyHost.isEmpty()) {
                this.proxyHost = props.getProperty(GradleNetworkProxySupport.SYSTEMPROP_HTTPS_PROXYHOST);
                if (this.proxyHost == null || this.proxyHost.isEmpty()) {
                    this.proxyHost = null;
                    this.proxyPort = -1;
                    return false;
                }
                LOG.log(Level.FINER, "Found https proxy: ", this.proxyHost);
                portKey = GradleNetworkProxySupport.SYSTEMPROP_HTTPS_PROXYPORT;
                defPort = 443;
            } else {
                LOG.log(Level.FINER, "Found http proxy: ", this.proxyHost);
                defPort = 80;
                portKey = GradleNetworkProxySupport.SYSTEMPROP_HTTP_PROXYPORT;
            }
            String port = props.getProperty(portKey);
            if (port != null && !port.trim().isEmpty()) {
                this.proxyAuthority = this.proxyHost + ":" + port;
                try {
                    this.proxyPort = Integer.parseInt(port);
                }
                catch (NumberFormatException ex) {
                    this.proxyPort = defPort;
                    this.proxyAuthority = this.proxyHost;
                }
            } else {
                this.proxyPort = defPort;
                this.proxyAuthority = this.proxyHost;
            }
            return true;
        }

        private void loadProjectProxy() {
            FileInputStream fis2;
            GradleFiles gf;
            File f = FileUtil.toFile((FileObject)GradleNetworkProxySupport.this.project.getProjectDirectory());
            if (f == null || !f.exists()) {
                LOG.log(Level.WARNING, "Project has no directory: {0}", GradleNetworkProxySupport.this.project);
                return;
            }
            this.gradleFiles = gf = new GradleFiles(f);
            File rootDir = gf.getRootDir();
            LOG.log(Level.FINE, "Project directory: {0}, root directory: {1}", new Object[]{f, rootDir});
            if (!rootDir.equals(f)) {
                gf = new GradleFiles(rootDir);
            }
            Properties props = new Properties();
            File userProperties = gf.getFile(GradleFiles.Kind.USER_PROPERTIES);
            File projectProperties = gf.getFile(GradleFiles.Kind.PROJECT_PROPERTIES);
            if (projectProperties != null && projectProperties.exists()) {
                try {
                    fis2 = new FileInputStream(projectProperties);
                    try {
                        LOG.log(Level.FINER, "Loading project properties from {0}", projectProperties);
                        props.load(fis2);
                    }
                    finally {
                        fis2.close();
                    }
                }
                catch (IOException fis2) {
                    // empty catch block
                }
            }
            if (userProperties != null && userProperties.exists()) {
                try {
                    fis2 = new FileInputStream(userProperties);
                    try {
                        LOG.log(Level.FINER, "Loading user properties from {0}", userProperties);
                        props.load(fis2);
                    }
                    finally {
                        fis2.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.extractNetworkProxy(props);
        }
    }

    public static final class ProxyResult {
        private final Status status;
        private final Proxy proxy;
        private final String toolProxy;
        private final String proxyHost;
        private final String proxySpec;
        private final int proxyPort;

        public ProxyResult(Status status, Proxy proxy) {
            this.status = status;
            this.proxy = proxy;
            this.toolProxy = null;
            this.proxySpec = null;
            this.proxyHost = null;
            this.proxyPort = -1;
        }

        public ProxyResult(Status status, Proxy proxy, String toolProxy, String proxySpec, String proxyHost, int proxyPort) {
            this.status = status;
            this.proxy = proxy;
            this.toolProxy = toolProxy;
            this.proxySpec = proxySpec;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
        }

        public Status getStatus() {
            return this.status;
        }

        public Proxy getProxy() {
            return this.proxy;
        }

        public String getToolProxy() {
            return this.toolProxy;
        }

        public String getProxySpec() {
            return this.proxySpec;
        }

        public <T> BuildActionExecuter<T> configure(BuildActionExecuter<T> executor) {
            this.configure((T)executor);
            return executor;
        }

        public <T extends ConfigurableLauncher> T configure(T executor) {
            if (this.status != Status.OVERRIDE) {
                return executor;
            }
            this.addSystemProperty(executor, GradleNetworkProxySupport.JVM_HTTP_PROXYHOST, this.proxyHost);
            this.addSystemProperty(executor, GradleNetworkProxySupport.JVM_HTTP_PROXYPORT, Integer.toString(this.proxyPort));
            this.addSystemProperty(executor, GradleNetworkProxySupport.JVM_HTTPS_PROXYHOST, this.proxyHost);
            this.addSystemProperty(executor, GradleNetworkProxySupport.JVM_HTTPS_PROXYPORT, Integer.toString(this.proxyPort));
            return executor;
        }

        private void addSystemProperty(ConfigurableLauncher<?> executer, String propName, String value) {
            executer.addJvmArguments(new String[]{"-D" + propName + "=" + (value == null ? "" : value)});
        }
    }

    public static enum Status {
        UNKNOWN,
        CONTINUE,
        RECONFIGURED,
        OVERRIDE,
        ABORT;

    }
}

