/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.properties;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.css.lib.api.properties.FixedTextGrammarElement;
import org.netbeans.modules.css.lib.api.properties.GrammarElement;
import org.netbeans.modules.css.lib.api.properties.GroupGrammarElement;
import org.netbeans.modules.css.lib.api.properties.Properties;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinition;
import org.netbeans.modules.css.lib.api.properties.TokenAcceptor;
import org.netbeans.modules.css.lib.api.properties.UnitGrammarElement;
import org.netbeans.modules.web.common.api.LexerUtils;

public class GrammarParser {
    private String propertyName;
    private String expression;

    public static GroupGrammarElement parse(String expresssion) {
        return GrammarParser.parse(expresssion, null);
    }

    public static GroupGrammarElement parse(String expression, String propertyName) {
        return new GrammarParser(expression, propertyName).parse();
    }

    public GrammarParser(String expression, String propertyName) {
        this.expression = expression;
        this.propertyName = propertyName;
    }

    private GroupGrammarElement parse() {
        AtomicInteger groupIndex = new AtomicInteger(0);
        AtomicInteger inPropertyIndex = new AtomicInteger(0);
        int openedParenthesis = 0;
        GroupGrammarElement root = new GroupGrammarElement(null, groupIndex.getAndIncrement(), this.propertyName);
        ParserInput input = new ParserInput(this.expression);
        this.parseElements(input, root, false, groupIndex, inPropertyIndex, openedParenthesis, new HashMap<PropertyGrammarElementRef, GroupGrammarElement>());
        if (openedParenthesis != 0) {
            throw new IllegalStateException(String.format("Property '%s' parsing error - bracket pairs doesn't match: ", this.propertyName, openedParenthesis));
        }
        return root;
    }

    private void parseElements(ParserInput input, GroupGrammarElement parent, boolean ignoreInherits, AtomicInteger groupIndex, AtomicInteger inPropertyIndex, int openedParenthesis, Map<PropertyGrammarElementRef, GroupGrammarElement> knownChilds) {
        GrammarElement last = null;
        char c;
        block14: while ((c = input.read()) != '\uffff') {
            StringBuilder buf;
            switch (c) {
                case '\t': 
                case ' ': {
                    continue block14;
                }
                case '&': {
                    char next = input.read();
                    if (next == '&') {
                        parent.setType(GroupGrammarElement.Type.ALL);
                        continue block14;
                    }
                    input.backup(1);
                    continue block14;
                }
                case '[': {
                    last = new GroupGrammarElement(parent, groupIndex.getAndIncrement());
                    this.parseElements(input, (GroupGrammarElement)last, false, groupIndex, inPropertyIndex, ++openedParenthesis, knownChilds);
                    parent.addElement(last);
                    continue block14;
                }
                case '|': {
                    char next = input.read();
                    if (next == '|') {
                        parent.setType(GroupGrammarElement.Type.COLLECTION);
                        continue block14;
                    }
                    input.backup(1);
                    parent.setType(GroupGrammarElement.Type.SET);
                    continue block14;
                }
                case ']': {
                    --openedParenthesis;
                    return;
                }
                case '<': {
                    buf = new StringBuilder();
                    while ((c = input.read()) != '>') {
                        buf.append(c);
                    }
                    String referredElementName = buf.toString();
                    PropertyGrammarElementRef currRef = new PropertyGrammarElementRef(parent, inPropertyIndex.incrementAndGet(), referredElementName);
                    if (knownChilds.containsKey(currRef)) {
                        last = knownChilds.get(currRef);
                        parent.addElement(last);
                        continue block14;
                    }
                    PropertyDefinition property = Properties.getPropertyDefinition(referredElementName, true);
                    if (property == null) {
                        throw new IllegalStateException(String.format("Property '%s' parsing error: No referred element '%s' found. Read input: %s", this.propertyName, referredElementName, input.readText()));
                    }
                    ParserInput pinput = new ParserInput(property.getGrammar());
                    String propName = property.getName();
                    last = new GroupGrammarElement(parent, groupIndex.getAndIncrement(), propName);
                    knownChilds.put(currRef, (GroupGrammarElement)last);
                    AtomicInteger inPropertyIndexChild = new AtomicInteger(0);
                    this.parseElements(pinput, (GroupGrammarElement)last, true, groupIndex, inPropertyIndexChild, openedParenthesis, knownChilds);
                    parent.addElement(last);
                    continue block14;
                }
                case '!': {
                    String unitName;
                    TokenAcceptor acceptor;
                    buf = new StringBuilder();
                    while ((c = input.read()) != '\uffff') {
                        if (GrammarParser.isEndOfValue(input)) {
                            input.backup(1);
                            break;
                        }
                        buf.append(c);
                    }
                    if ((acceptor = TokenAcceptor.getAcceptor(unitName = buf.toString())) == null) {
                        throw new IllegalStateException(String.format("Property '%s' parsing error - No unit property value acceptor for '%s'. Read input: '%s'", this.propertyName, unitName, input.readText()));
                    }
                    last = new UnitGrammarElement(parent, acceptor, null);
                    parent.addElement(last);
                    continue block14;
                }
                case '{': {
                    StringBuilder text = new StringBuilder();
                    while ((c = input.read()) != '}') {
                        text.append(c);
                    }
                    String[] parts = text.toString().split(",", -1);
                    if (parts.length == 1) {
                        int elements = Integer.parseInt(parts[0]);
                        last.setMinimumOccurances(elements);
                        last.setMaximumOccurances(elements);
                        continue block14;
                    }
                    if (parts.length == 2) {
                        int min = 0;
                        int max = Integer.MAX_VALUE;
                        if (!parts[0].trim().isEmpty()) {
                            min = Integer.parseInt(parts[0]);
                        }
                        if (!parts[1].trim().isEmpty()) {
                            max = Integer.parseInt(parts[1]);
                        }
                        last.setMinimumOccurances(min);
                        last.setMaximumOccurances(max);
                        continue block14;
                    }
                    throw new IllegalArgumentException("Invalid multiplicity: " + text.toString());
                }
                case '+': {
                    last.setMaximumOccurances(Integer.MAX_VALUE);
                    continue block14;
                }
                case '*': {
                    last.setMinimumOccurances(0);
                    last.setMaximumOccurances(Integer.MAX_VALUE);
                    continue block14;
                }
                case '?': {
                    last.setMinimumOccurances(0);
                    last.setMaximumOccurances(1);
                    continue block14;
                }
                case '(': {
                    char ch = input.read();
                    if (ch == '$') {
                        buf = new StringBuilder();
                        while ((ch = input.read()) != ')') {
                            buf.append(ch);
                        }
                        last.setName(buf.toString());
                        continue block14;
                    }
                    input.backup(1);
                }
            }
            buf = new StringBuilder();
            boolean quotes = GrammarParser.isQuoteChar(c);
            if (quotes) {
                c = input.read();
            }
            while (c != '\uffff') {
                if (quotes) {
                    if (GrammarParser.isQuoteChar(c)) {
                        break;
                    }
                } else if (GrammarParser.isEndOfValue(input)) {
                    input.backup(1);
                    break;
                }
                buf.append(c);
                c = input.read();
            }
            if (ignoreInherits && LexerUtils.equals((CharSequence)"inherit", (CharSequence)buf, (boolean)true, (boolean)true)) continue;
            last = new FixedTextGrammarElement(parent, buf, null);
            parent.addElement(last);
        }
        return;
    }

    private static boolean isEndOfValue(ParserInput input) {
        char c = input.LA(0);
        switch (c) {
            case ' ': 
            case '&': 
            case '*': 
            case '+': 
            case '?': 
            case '[': 
            case ']': 
            case '{': 
            case '|': {
                return true;
            }
            case '(': {
                return input.LA(1) == '$';
            }
        }
        return false;
    }

    private static boolean isQuoteChar(char c) {
        return c == '\'' || c == '\"';
    }

    private static class ParserInput {
        CharSequence text;
        private int pos = 0;

        private ParserInput(CharSequence text) {
            this.text = text;
        }

        public char read() {
            if (this.pos == this.text.length()) {
                return '\uffff';
            }
            return this.text.charAt(this.pos++);
        }

        public char LA(int lookahead) {
            int dec = this.pos == 0 ? 0 : 1;
            int la_pos = this.pos - dec + lookahead;
            if (la_pos >= this.text.length()) {
                return '\uffff';
            }
            return this.text.charAt(la_pos);
        }

        public void backup(int chars) {
            this.pos -= chars;
        }

        public CharSequence readText() {
            return this.text.subSequence(0, this.pos);
        }
    }

    private static class PropertyGrammarElementRef {
        private final GrammarElement parent;
        private final int indexInsideParent;
        private final String propertyName;

        public PropertyGrammarElementRef(GrammarElement parent, int indexInsideParent, String propertyName) {
            this.parent = parent;
            this.indexInsideParent = indexInsideParent;
            this.propertyName = propertyName;
        }

        private String getParentName() {
            for (GrammarElement p = this.parent; p != null; p = p.parent()) {
                if (p.getName() == null) continue;
                return p.getName();
            }
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + this.indexInsideParent;
            hash = 29 * hash + Objects.hashCode(this.propertyName);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyGrammarElementRef other = (PropertyGrammarElementRef)obj;
            if (this.indexInsideParent != other.indexInsideParent) {
                return false;
            }
            if (!Objects.equals(this.propertyName, other.propertyName)) {
                return false;
            }
            return Objects.equals(this.getParentName(), other.getParentName());
        }
    }
}

