/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.indexing;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.css.indexing.api.CssIndexModel;
import org.netbeans.modules.css.indexing.api.CssIndexModelFactory;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.html.editor.lib.api.SyntaxAnalyzerResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class HtmlCssIndexContributor
extends CssIndexModel {
    public static final String CLASSES_KEY = "classes";
    public static final String IDS_KEY = "ids";
    public static final char VIRTUAL_ELEMENT_MARKER = '!';
    private static final Collection<String> INDEX_KEYS = Arrays.asList(new String[0]);
    private Set<String> classes = new HashSet<String>();
    private Set<String> ids = new HashSet<String>();

    public HtmlCssIndexContributor(CssParserResult crp) {
        try {
            ParserManager.parse(Collections.singleton(crp.getSnapshot().getSource()), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    this.indexHTML(resultIterator);
                }

                private void indexHTML(ResultIterator resultIterator) {
                    try {
                        Parser.Result pr = resultIterator.getParserResult();
                        if (pr instanceof Lookup.Provider && ((Lookup.Provider)pr).getLookup().lookup(SyntaxAnalyzerResult.class) != null) {
                            TokenHierarchy th = resultIterator.getSnapshot().getTokenHierarchy();
                            TokenSequence ts = th.tokenSequence(HTMLTokenId.language());
                            while (ts.moveNext()) {
                                Token t = ts.token();
                                if (t.id() != HTMLTokenId.VALUE_CSS) continue;
                                String cssTokenType = (String)t.getProperty((Object)"valueCssType");
                                String value = WebUtils.unquotedValue((CharSequence)t.text()).replace("@@@", " ");
                                if (Objects.equals(cssTokenType, "id")) {
                                    if (value == null || value.trim().isEmpty()) continue;
                                    HtmlCssIndexContributor.this.ids.add(value);
                                    continue;
                                }
                                if (!Objects.equals(cssTokenType, "class")) continue;
                                for (String clazz : value.split("\\s+")) {
                                    if (clazz == null || clazz.trim().isEmpty()) continue;
                                    HtmlCssIndexContributor.this.classes.add(clazz);
                                }
                            }
                        }
                    }
                    catch (ParseException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    for (Embedding e : resultIterator.getEmbeddings()) {
                        this.indexHTML(resultIterator.getResultIterator(e));
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void storeToIndex(IndexDocument document) {
        for (String id : this.ids) {
            document.addPair(IDS_KEY, id + '!', true, true);
        }
        for (String clazz : this.classes) {
            document.addPair(CLASSES_KEY, clazz + '!', true, true);
        }
    }

    public static final class Factory
    extends CssIndexModelFactory {
        public HtmlCssIndexContributor getModel(CssParserResult result) {
            return new HtmlCssIndexContributor(result);
        }

        public HtmlCssIndexContributor loadFromIndex(IndexResult result) {
            return new HtmlCssIndexContributor(null);
        }

        public Collection<String> getIndexKeys() {
            return INDEX_KEYS;
        }
    }
}

