/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.api;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.javascript.cdtdebug.CDTDebugger;

public final class Connector {
    private Connector() {
    }

    public static void connect(Properties properties, @NullAllowed Runnable finishCallback) throws IOException {
        CDTDebugger.startSession(properties, finishCallback);
    }

    public static final class Properties {
        private final String hostName;
        private final int port;
        private final String targetIdentifier;
        private final List<String> localPaths;
        private final List<String> serverPaths;
        private final Collection<String> localPathExclusionFilters;

        public Properties(@NullAllowed String hostName, int port) {
            this(hostName, port, null);
        }

        public Properties(@NullAllowed String hostName, int port, @NullAllowed String targetIdentifier) {
            this(hostName, port, targetIdentifier, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_SET);
        }

        public Properties(@NullAllowed String hostName, int port, @NullAllowed String targetIdentifier, List<String> localPaths, List<String> serverPaths, Collection<String> localPathExclusionFilters) {
            this.hostName = hostName;
            this.port = port;
            this.localPaths = localPaths;
            this.serverPaths = serverPaths;
            this.localPathExclusionFilters = localPathExclusionFilters;
            this.targetIdentifier = targetIdentifier;
            if (!serverPaths.isEmpty() && localPaths.size() != serverPaths.size()) {
                throw new IllegalArgumentException("Different size of localPaths and serverPaths: localPaths = " + String.valueOf(localPaths) + ", serverPaths = " + String.valueOf(serverPaths));
            }
        }

        @CheckForNull
        public String getHostName() {
            return this.hostName;
        }

        public int getPort() {
            return this.port;
        }

        @CheckForNull
        public String getTargetIdentifier() {
            return this.targetIdentifier;
        }

        public List<String> getLocalPaths() {
            return this.localPaths;
        }

        public List<String> getServerPaths() {
            return this.serverPaths;
        }

        public Collection<String> getLocalPathExclusionFilters() {
            return this.localPathExclusionFilters;
        }
    }
}

