/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.tree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.CheckTreeNode;
import org.netbeans.lib.profiler.ui.components.tree.TreeCellRendererPersistent;

public class CheckTreeCellRenderer
extends JPanel
implements TreeCellRendererPersistent {
    private static Dimension checkBoxDimension = new JCheckBox().getPreferredSize();
    private JCheckBox checkBox = new JCheckBox();
    private ButtonModel checkBoxModel = this.checkBox.getModel();
    private Component treeRendererComponent;
    private DefaultTreeCellRenderer treeRenderer = new DefaultTreeCellRenderer();
    private boolean persistentRenderer = false;

    public CheckTreeCellRenderer() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.checkBox.setOpaque(false);
        Font f = UIManager.getFont("Label.font");
        if (f != null) {
            this.treeRenderer.setFont(f.deriveFont(f.getStyle()));
        }
        this.add((Component)this.checkBox, "West");
    }

    public static Dimension getCheckBoxDimension() {
        return checkBoxDimension;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        CheckTreeNode treeNode;
        CheckTreeNode checkTreeNode = treeNode = value instanceof CheckTreeNode ? (CheckTreeNode)value : null;
        if (this.treeRendererComponent != null) {
            this.remove(this.treeRendererComponent);
        }
        if (treeNode != null) {
            this.checkBox.setVisible(!this.persistentRenderer);
            this.setupCellRendererIcon(this.treeRenderer, treeNode.getIcon());
        } else {
            this.checkBox.setVisible(false);
            this.setupCellRendererIcon(this.treeRenderer, null);
        }
        this.treeRendererComponent = this.treeRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.add(this.treeRendererComponent, "Center");
        if (treeNode == null) {
            return this;
        }
        if (treeNode.isFullyChecked()) {
            this.setupCheckBox(Boolean.TRUE);
        } else {
            this.setupCheckBox(treeNode.isPartiallyChecked() ? null : Boolean.FALSE);
        }
        return this;
    }

    @Override
    public Component getTreeCellRendererComponentPersistent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        CheckTreeCellRenderer ctcr = new CheckTreeCellRenderer();
        ctcr.persistentRenderer = true;
        return ctcr.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    private void setupCellRendererIcon(DefaultTreeCellRenderer renderer, Icon icon) {
        renderer.setLeafIcon(icon);
        renderer.setOpenIcon(icon);
        renderer.setClosedIcon(icon);
    }

    private void setupCheckBox(Boolean state) {
        if (state == Boolean.TRUE) {
            this.checkBoxModel.setArmed(false);
            this.checkBoxModel.setPressed(false);
            this.checkBoxModel.setSelected(true);
        } else if (state == Boolean.FALSE) {
            this.checkBoxModel.setArmed(false);
            this.checkBoxModel.setPressed(false);
            this.checkBoxModel.setSelected(false);
        } else {
            this.checkBoxModel.setArmed(true);
            this.checkBoxModel.setPressed(true);
            this.checkBoxModel.setSelected(true);
        }
    }
}

