/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.j2ee.core;

import java.util.Comparator;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.util.NbBundle;

public enum Profile {
    J2EE_13("1.3"),
    J2EE_14("1.4"),
    JAVA_EE_5("1.5"),
    JAVA_EE_6_WEB("1.6", "web"),
    JAVA_EE_6_FULL("1.6"),
    JAVA_EE_7_WEB("1.7", "web"),
    JAVA_EE_7_FULL("1.7"),
    JAVA_EE_8_WEB("1.8", "web"),
    JAVA_EE_8_FULL("1.8"),
    JAKARTA_EE_8_WEB("8.0", "web"),
    JAKARTA_EE_8_FULL("8.0"),
    JAKARTA_EE_9_WEB("9.0", "web"),
    JAKARTA_EE_9_FULL("9.0"),
    JAKARTA_EE_9_1_WEB("9.1", "web"),
    JAKARTA_EE_9_1_FULL("9.1"),
    JAKARTA_EE_10_WEB("10", "web"),
    JAKARTA_EE_10_FULL("10"),
    JAKARTA_EE_11_WEB("11", "web"),
    JAKARTA_EE_11_FULL("11");

    public static final Comparator<Profile> UI_COMPARATOR;
    private final String propertiesString;

    private Profile(String canonicalName) {
        this.propertiesString = canonicalName;
    }

    private Profile(String canonicalName, String profile) {
        this.propertiesString = canonicalName + "-" + profile;
    }

    @NonNull
    public String getDisplayName() {
        return NbBundle.getMessage(Profile.class, (String)(this.name() + ".displayName"));
    }

    @NonNull
    public String toPropertiesString() {
        return this.propertiesString;
    }

    @NonNull
    public boolean isWebProfile() {
        return this.propertiesString.endsWith("web");
    }

    @NonNull
    public boolean isFullProfile() {
        return !this.propertiesString.endsWith("web");
    }

    public boolean isAtLeast(@NonNull Profile profile) {
        return this.ordinal() >= profile.ordinal();
    }

    public boolean isAtMost(@NonNull Profile profile) {
        return this.ordinal() <= profile.ordinal();
    }

    public String toString() {
        return this.toPropertiesString();
    }

    @CheckForNull
    public static Profile fromPropertiesString(@NullAllowed String value) {
        if (value == null) {
            return null;
        }
        String valueMinusQuotes = value.replace("\"", "");
        for (Profile profile : Profile.values()) {
            if (!profile.toPropertiesString().equals(valueMinusQuotes) && !profile.name().equals(valueMinusQuotes) && (!valueMinusQuotes.startsWith("EE_") || !profile.name().endsWith(valueMinusQuotes))) continue;
            return profile;
        }
        return null;
    }

    static {
        UI_COMPARATOR = (o1, o2) -> -(o1.ordinal() - o2.ordinal());
    }
}

