/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.episodes;

import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mediathek.tool.episodes.SeasonEpisode;

public class RuleBasedTitleParser {
    private final List<Pattern> patterns;

    public RuleBasedTitleParser(List<Pattern> patterns) {
        this.patterns = patterns;
    }

    public Optional<SeasonEpisode> parse(String title) {
        for (Pattern pat : this.patterns) {
            Matcher m = pat.matcher(title);
            if (!m.find()) continue;
            int season = Integer.parseInt(m.group("season"));
            int episode = Integer.parseInt(m.group("episode"));
            return Optional.of(new SeasonEpisode(season, episode));
        }
        return Optional.empty();
    }
}

