/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.suggest.scorer.editdistance;

import com.hankcs.hanlp.algorithm.EditDistance;
import com.hankcs.hanlp.suggest.scorer.ISentenceKey;

public class CharArray
implements Comparable<CharArray>,
ISentenceKey<CharArray> {
    char[] value;

    public CharArray(char[] value) {
        this.value = value;
    }

    @Override
    public int compareTo(CharArray other) {
        int len1 = this.value.length;
        int len2 = other.value.length;
        int lim = Math.min(len1, len2);
        char[] v1 = this.value;
        char[] v2 = other.value;
        for (int k = 0; k < lim; ++k) {
            char c1 = v1[k];
            char c2 = v2[k];
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    @Override
    public Double similarity(CharArray other) {
        int distance = EditDistance.compute(this.value, other.value) + 1;
        return 1.0 / (double)distance;
    }
}

