/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.binder.mpmetrics;

import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.micrometer.deployment.binder.mpmetrics.MetricAnnotationInfo;
import io.quarkus.micrometer.deployment.binder.mpmetrics.MetricDotNames;
import io.quarkus.micrometer.runtime.binder.mpmetrics.AnnotatedGaugeAdapter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashSet;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class GaugeAnnotationHandler {
    private static final Logger log = Logger.getLogger(GaugeAnnotationHandler.class);

    static void processAnnotatedGauges(IndexView index, ClassOutput classOutput) {
        HashSet<String> createdClasses = new HashSet<String>();
        for (AnnotationInstance annotation : index.getAnnotations(MetricDotNames.GAUGE_ANNOTATION)) {
            AnnotationTarget target = annotation.target();
            MethodInfo methodInfo = target.asMethod();
            ClassInfo classInfo = methodInfo.declaringClass();
            GaugeAnnotationHandler.verifyGaugeScope(target, classInfo);
            String generatedClassName = String.format("%s_%s_GaugeAdapter", classInfo.name().toString(), methodInfo.name().toString());
            if (!createdClasses.add(generatedClassName)) continue;
            GaugeAnnotationHandler.createClass(index, classOutput, generatedClassName, annotation, target, classInfo, methodInfo);
        }
    }

    static void createClass(IndexView index, ClassOutput classOutput, String generatedClassName, AnnotationInstance annotation, AnnotationTarget target, ClassInfo classInfo, MethodInfo methodInfo) {
        Class<AnnotatedGaugeAdapter> gaugeAdapter = AnnotatedGaugeAdapter.class;
        Class<AnnotatedGaugeAdapter.GaugeAdapterImpl> gaugeAdapterImpl = AnnotatedGaugeAdapter.GaugeAdapterImpl.class;
        MethodDescriptor superInit = MethodDescriptor.ofConstructor(gaugeAdapterImpl, (Class[])new Class[]{String.class, String.class, String.class, String[].class});
        MethodDescriptor superInitUnit = MethodDescriptor.ofConstructor(gaugeAdapterImpl, (Class[])new Class[]{String.class, String.class, String.class, String.class, String[].class});
        try (ClassCreator classCreator = ClassCreator.builder().classOutput(classOutput).className(generatedClassName).superClass(gaugeAdapterImpl).interfaces(new Class[]{gaugeAdapter}).build();){
            if (classInfo.annotationsMap().containsKey("Singleton")) {
                classCreator.addAnnotation(Singleton.class);
            } else {
                classCreator.addAnnotation(ApplicationScoped.class);
            }
            MetricAnnotationInfo gaugeInfo = new MetricAnnotationInfo(annotation, index, classInfo, methodInfo, null);
            FieldCreator fieldCreator = (FieldCreator)classCreator.getFieldCreator("target", classInfo.name().toString()).setModifiers(0);
            fieldCreator.addAnnotation(Inject.class);
            try (MethodCreator mc = classCreator.getMethodCreator("<init>", Void.TYPE, new Class[0]);){
                mc.setModifiers(1);
                ResultHandle tagsHandle = mc.newArray(String.class, gaugeInfo.tags.length);
                for (int i = 0; i < gaugeInfo.tags.length; ++i) {
                    mc.writeArrayValue(tagsHandle, i, mc.load(gaugeInfo.tags[i]));
                }
                if (gaugeInfo.unit == null) {
                    mc.invokeSpecialMethod(superInit, mc.getThis(), new ResultHandle[]{mc.load(gaugeInfo.name), mc.load(gaugeInfo.description), mc.load(methodInfo.toString()), tagsHandle});
                } else {
                    mc.invokeSpecialMethod(superInitUnit, mc.getThis(), new ResultHandle[]{mc.load(gaugeInfo.name), mc.load(gaugeInfo.description), mc.load(methodInfo.toString()), mc.load(gaugeInfo.unit), tagsHandle});
                }
                mc.returnValue(null);
            }
            MethodDescriptor getNumberValue = null;
            try (MethodCreator mc = classCreator.getMethodCreator("getValue", Number.class, new Class[0]);){
                mc.setModifiers(1);
                ResultHandle targetInstance = mc.readInstanceField(fieldCreator.getFieldDescriptor(), mc.getThis());
                mc.returnValue(mc.invokeVirtualMethod(target.asMethod(), targetInstance, new ResultHandle[0]));
                getNumberValue = mc.getMethodDescriptor();
            }
            try (MethodCreator generic = classCreator.getMethodCreator("getValue", Object.class, new Class[0]);){
                generic.setModifiers(1);
                generic.returnValue(generic.invokeVirtualMethod(getNumberValue, generic.getThis(), new ResultHandle[0]));
                generic.getMethodDescriptor();
            }
        }
    }

    private static void verifyGaugeScope(AnnotationTarget target, ClassInfo classInfo) {
        if (!MetricDotNames.isSingleInstance(classInfo)) {
            log.errorf("Bean %s declares a org.eclipse.microprofile.metrics.annotation.Gauge but is of a scope that may create multiple instances of a bean. @Gauge annotations establish a callback to a single instance. Only use the @Gauge annotation on @ApplicationScoped or @Singleton beans, or in JAX-RS endpoints.", (Object)classInfo.name().toString());
            throw new DeploymentException(classInfo.name().toString() + " uses a @Gauge annotation, but is not @ApplicationScoped, a @Singleton, or a REST endpoint");
        }
    }
}

