/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeometryExtracter
implements GeometryFilter {
    private String geometryType;
    private List comps;

    public static List extract(Geometry geom, Class clz, List list) {
        return GeometryExtracter.extract(geom, GeometryExtracter.toGeometryType(clz), list);
    }

    private static String toGeometryType(Class clz) {
        if (clz == null) {
            return null;
        }
        if (clz.isAssignableFrom(Point.class)) {
            return "Point";
        }
        if (clz.isAssignableFrom(LineString.class)) {
            return "LineString";
        }
        if (clz.isAssignableFrom(LinearRing.class)) {
            return "LinearRing";
        }
        if (clz.isAssignableFrom(Polygon.class)) {
            return "Polygon";
        }
        if (clz.isAssignableFrom(MultiPoint.class)) {
            return "MultiPoint";
        }
        if (clz.isAssignableFrom(MultiLineString.class)) {
            return "MultiLineString";
        }
        if (clz.isAssignableFrom(MultiPolygon.class)) {
            return "MultiPolygon";
        }
        if (clz.isAssignableFrom(GeometryCollection.class)) {
            return "GeometryCollection";
        }
        throw new RuntimeException("Unsupported class");
    }

    public static List extract(Geometry geom, String geometryType, List list) {
        if (geom.getGeometryType() == geometryType) {
            list.add(geom);
        } else if (geom instanceof GeometryCollection) {
            geom.apply(new GeometryExtracter(geometryType, list));
        }
        return list;
    }

    public static List extract(Geometry geom, Class clz) {
        return GeometryExtracter.extract(geom, clz, new ArrayList());
    }

    public static List extract(Geometry geom, String geometryType) {
        return GeometryExtracter.extract(geom, geometryType, new ArrayList());
    }

    public GeometryExtracter(Class clz, List comps) {
        this.geometryType = GeometryExtracter.toGeometryType(clz);
        this.comps = comps;
    }

    public GeometryExtracter(String geometryType, List comps) {
        this.geometryType = geometryType;
        this.comps = comps;
    }

    protected static boolean isOfType(Geometry geom, String geometryType) {
        if (geom.getGeometryType() == geometryType) {
            return true;
        }
        return geometryType == "LineString" && geom.getGeometryType() == "LinearRing";
    }

    @Override
    public void filter(Geometry geom) {
        if (this.geometryType == null || GeometryExtracter.isOfType(geom, this.geometryType)) {
            this.comps.add(geom);
        }
    }
}

