/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.python.core.ucnhashAPI;

public class ucnhash
implements ucnhashAPI {
    private static int n;
    private static int m;
    private static int minchar;
    private static int alphasz;
    private static int maxlen;
    private static int maxidx;
    private static int maxklen;
    private static short[] G;
    private static short[] T0;
    private static short[] T1;
    private static short[] T2;
    private static byte[] worddata;
    private static short[] wordoffs;
    private static short wordstart;
    private static short wordcutoff;
    private static byte[] rawdata;
    private static int[] rawindex;
    private static int[] codepoint;
    public static String[] __depends__;
    private static final char[] charmap;
    private static final int raw_block = 3;
    private static String cjkPrefix;
    private static int cjkPrefixLen;
    private static boolean initialized;
    private static boolean loaded;

    public static void loadTables() throws Exception {
        InputStream instream = ucnhash.class.getResourceAsStream("ucnhash.dat");
        if (instream == null) {
            throw new IOException("Unicode name database not found: ucnhash.dat");
        }
        DataInputStream in = new DataInputStream(new BufferedInputStream(instream));
        n = in.readShort();
        m = in.readShort();
        minchar = in.readShort();
        alphasz = in.readShort();
        maxlen = in.readShort();
        maxidx = maxlen * alphasz - minchar;
        G = ucnhash.readShortTable(in);
        if (in.readShort() != 3) {
            throw new IOException("UnicodeNameMap file corrupt, unknown dimension");
        }
        T0 = ucnhash.readShortTable(in);
        T1 = ucnhash.readShortTable(in);
        T2 = ucnhash.readShortTable(in);
        wordoffs = ucnhash.readShortTable(in);
        worddata = ucnhash.readByteTable(in);
        wordstart = in.readShort();
        wordcutoff = in.readShort();
        maxklen = in.readShort();
        rawdata = ucnhash.readByteTable(in);
        rawindex = ucnhash.readIntTable(in);
        codepoint = ucnhash.readIntTable(in);
    }

    private static short[] readShortTable(DataInputStream in) throws IOException {
        if (in.read() != 116) {
            throw new IOException("UnicodeNameMap file corrupt, shorttable");
        }
        int n = in.readInt() / 2;
        short[] table = new short[n];
        for (int i = 0; i < n; ++i) {
            table[i] = in.readShort();
        }
        return table;
    }

    private static int[] readIntTable(DataInputStream in) throws IOException {
        if (in.read() != 116) {
            throw new IOException("UnicodeNameMap file corrupt, inttable");
        }
        int n = in.readInt() / 4;
        int[] table = new int[n];
        for (int i = 0; i < n; ++i) {
            table[i] = in.readInt();
        }
        return table;
    }

    private static char[] readCharTable(DataInputStream in) throws IOException {
        if (in.read() != 116) {
            throw new IOException("UnicodeNameMap file corrupt, chartable");
        }
        int n = in.readInt() / 2;
        char[] table = new char[n];
        for (int i = 0; i < n; ++i) {
            table[i] = in.readChar();
        }
        return table;
    }

    private static byte[] readByteTable(DataInputStream in) throws IOException {
        if (in.read() != 116) {
            throw new IOException("UnicodeNameMap file corrupt, byte table");
        }
        int n = in.readInt();
        byte[] table = new byte[n];
        in.readFully(table);
        return table;
    }

    public static int hash(String key) {
        return ucnhash.hash(key, 0, key.length());
    }

    public static int hash(String key, int start, int end) {
        int i = -minchar;
        int f2 = 0;
        int f1 = 0;
        int f0 = 0;
        for (int j = start; j < end; ++j) {
            char ch = key.charAt(j);
            if (ch >= 'a' && ch <= 'z') {
                ch = (char)(ch - 97 + 65);
            }
            f0 += T0[i + ch];
            f1 += T1[i + ch];
            f2 += T2[i + ch];
            if ((i += alphasz) < maxidx) continue;
            i = -minchar;
        }
        return (G[f0 %= n] + G[f1 %= n] + G[f2 %= n]) % m;
    }

    private static String getWord(int idx) {
        int offset = wordoffs[idx];
        int end = worddata.length;
        if (idx < wordoffs.length - 1) {
            end = wordoffs[idx + 1];
        }
        StringBuilder buf = new StringBuilder();
        for (int i = offset; i < end; ++i) {
            buf.append(charmap[worddata[i]]);
        }
        return buf.toString();
    }

    private static boolean match(int idx, byte[] raw, int begin, int end) {
        short woff = wordoffs[idx];
        int wend = worddata.length;
        if (idx < wordoffs.length - 1) {
            wend = wordoffs[idx + 1];
        }
        if (end - begin != wend - woff) {
            return false;
        }
        int l = end - begin;
        for (int i = 0; i < l; ++i) {
            if (worddata[woff + i] == raw[begin + i]) continue;
            return false;
        }
        return true;
    }

    private static int compare(byte[] a1, int off1, int len1, byte[] a2, int off2, int len2) {
        for (int i = 0; i < len1 && i < len2; ++i) {
            int d = (a1[off1 + i] & 0xFF) - (a2[off2 + i] & 0xFF);
            if (d == 0) continue;
            return d;
        }
        return len1 - len2;
    }

    private static int binarysearch(byte[] rawlist, int start, int end) {
        int len;
        int off;
        int floor = 0;
        int ceiling = rawindex.length / 3;
        while (floor < ceiling - 1) {
            int middle = (floor + ceiling) / 2;
            off = rawindex[middle * 3];
            len = rawindex[middle * 3 + 3 - 1] & 0x1F;
            int d = ucnhash.compare(rawlist, start, end - start, rawdata, off, len);
            if (d < 0) {
                ceiling = middle;
                continue;
            }
            if (d > 0) {
                floor = middle;
                continue;
            }
            return middle * 12;
        }
        int tmp = floor * 3;
        off = rawindex[tmp++];
        long lengths = (long)rawindex[tmp++] << 32 | (long)rawindex[tmp++] & 0xFFFFFFFFL;
        floor *= 12;
        for (int i = 0; i < 12; ++i) {
            len = (int)(lengths >> i * 5) & 0x1F;
            if (ucnhash.compare(rawlist, start, end, rawdata, off, len) == 0) {
                return floor;
            }
            off += len;
            ++floor;
        }
        return -1;
    }

    public static int lookup(String name) {
        return ucnhash.lookup(name, 0, name.length());
    }

    private static int lookup(String name, int start, int end) {
        byte[] rawlist = new byte[32];
        int ridx = 0;
        int rbegin = 0;
        int rstart = 0;
        while (true) {
            int hash;
            int i;
            rbegin = ridx;
            int begin = start;
            block69: for (i = start; i < end; ++i) {
                int v;
                char ch = name.charAt(i);
                switch (ch) {
                    case ' ': {
                        start = i + 1;
                        break block69;
                    }
                    case 'a': {
                        v = 1;
                        break;
                    }
                    case 'b': {
                        v = 2;
                        break;
                    }
                    case 'c': {
                        v = 3;
                        break;
                    }
                    case 'd': {
                        v = 4;
                        break;
                    }
                    case 'e': {
                        v = 5;
                        break;
                    }
                    case 'f': {
                        v = 6;
                        break;
                    }
                    case 'g': {
                        v = 7;
                        break;
                    }
                    case 'h': {
                        v = 8;
                        break;
                    }
                    case 'i': {
                        v = 9;
                        break;
                    }
                    case 'j': {
                        v = 10;
                        break;
                    }
                    case 'k': {
                        v = 11;
                        break;
                    }
                    case 'l': {
                        v = 12;
                        break;
                    }
                    case 'm': {
                        v = 13;
                        break;
                    }
                    case 'n': {
                        v = 14;
                        break;
                    }
                    case 'o': {
                        v = 15;
                        break;
                    }
                    case 'p': {
                        v = 16;
                        break;
                    }
                    case 'q': {
                        v = 17;
                        break;
                    }
                    case 'r': {
                        v = 18;
                        break;
                    }
                    case 's': {
                        v = 19;
                        break;
                    }
                    case 't': {
                        v = 20;
                        break;
                    }
                    case 'u': {
                        v = 21;
                        break;
                    }
                    case 'v': {
                        v = 22;
                        break;
                    }
                    case 'w': {
                        v = 23;
                        break;
                    }
                    case 'x': {
                        v = 24;
                        break;
                    }
                    case 'y': {
                        v = 25;
                        break;
                    }
                    case 'z': {
                        v = 26;
                        break;
                    }
                    case 'A': {
                        v = 1;
                        break;
                    }
                    case 'B': {
                        v = 2;
                        break;
                    }
                    case 'C': {
                        v = 3;
                        break;
                    }
                    case 'D': {
                        v = 4;
                        break;
                    }
                    case 'E': {
                        v = 5;
                        break;
                    }
                    case 'F': {
                        v = 6;
                        break;
                    }
                    case 'G': {
                        v = 7;
                        break;
                    }
                    case 'H': {
                        v = 8;
                        break;
                    }
                    case 'I': {
                        v = 9;
                        break;
                    }
                    case 'J': {
                        v = 10;
                        break;
                    }
                    case 'K': {
                        v = 11;
                        break;
                    }
                    case 'L': {
                        v = 12;
                        break;
                    }
                    case 'M': {
                        v = 13;
                        break;
                    }
                    case 'N': {
                        v = 14;
                        break;
                    }
                    case 'O': {
                        v = 15;
                        break;
                    }
                    case 'P': {
                        v = 16;
                        break;
                    }
                    case 'Q': {
                        v = 17;
                        break;
                    }
                    case 'R': {
                        v = 18;
                        break;
                    }
                    case 'S': {
                        v = 19;
                        break;
                    }
                    case 'T': {
                        v = 20;
                        break;
                    }
                    case 'U': {
                        v = 21;
                        break;
                    }
                    case 'V': {
                        v = 22;
                        break;
                    }
                    case 'W': {
                        v = 23;
                        break;
                    }
                    case 'X': {
                        v = 24;
                        break;
                    }
                    case 'Y': {
                        v = 25;
                        break;
                    }
                    case 'Z': {
                        v = 26;
                        break;
                    }
                    case '0': {
                        v = 27;
                        break;
                    }
                    case '1': {
                        v = 28;
                        break;
                    }
                    case '2': {
                        v = 29;
                        break;
                    }
                    case '3': {
                        v = 30;
                        break;
                    }
                    case '4': {
                        v = 31;
                        break;
                    }
                    case '5': {
                        v = 32;
                        break;
                    }
                    case '6': {
                        v = 33;
                        break;
                    }
                    case '7': {
                        v = 34;
                        break;
                    }
                    case '8': {
                        v = 35;
                        break;
                    }
                    case '9': {
                        v = 36;
                        break;
                    }
                    case '-': {
                        v = 37;
                        break;
                    }
                    case '(': {
                        v = 38;
                        break;
                    }
                    case ')': {
                        v = 39;
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
                rawlist[ridx++] = v;
                if (ch != '-' || start == i) continue;
                start = ++i;
                break;
            }
            if ((hash = ucnhash.hash(name, begin, i)) >= 0 && ridx - rbegin > 1 && ucnhash.match(hash, rawlist, rbegin, ridx)) {
                ridx = rstart;
                if ((hash += wordstart) > wordcutoff) {
                    rawlist[ridx++] = (byte)((hash >> 8) + wordcutoff);
                    rawlist[ridx++] = (byte)(hash & 0xFF);
                } else {
                    rawlist[ridx++] = (byte)hash;
                }
                rstart = ridx;
                if (i < end) continue;
                break;
            }
            rstart = ridx;
            if (i >= end) break;
            rawlist[ridx++] = 0;
        }
        int idx = ucnhash.binarysearch(rawlist, 0, ridx);
        if (idx < 0) {
            return idx;
        }
        return codepoint[idx];
    }

    @Override
    public int getCchMax() {
        if (!this.initialized()) {
            return -1;
        }
        return maxklen;
    }

    @Override
    public int getValue(String s, int start, int end) {
        if (!this.initialized()) {
            return -1;
        }
        if (s.regionMatches(start, cjkPrefix, 0, cjkPrefixLen)) {
            try {
                String hex = s.substring(start + cjkPrefixLen, end);
                int v = Integer.parseInt(hex, 16);
                return v;
            }
            catch (NumberFormatException exc) {
                return -1;
            }
        }
        return ucnhash.lookup(s, start, end);
    }

    private synchronized boolean initialized() {
        if (initialized) {
            return loaded;
        }
        try {
            ucnhash.loadTables();
            loaded = true;
        }
        catch (Exception exc) {
            return false;
        }
        initialized = true;
        return true;
    }

    static {
        __depends__ = new String[]{"/org/python/modules/ucnhash.dat"};
        charmap = " ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-()".toCharArray();
        cjkPrefix = "CJK COMPATIBILITY IDEOGRAPH-";
        cjkPrefixLen = cjkPrefix.length();
        initialized = false;
        loaded = false;
    }
}

