/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth.gui;

import java.io.File;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import tim.prune.I18nManager;
import tim.prune.function.filesleuth.SearchResult;

public class ResultsTableModel
extends DefaultTableModel {
    private List<SearchResult> _results = null;

    public void setResults(List<SearchResult> list) {
        this._results = list;
        this.fireTableStructureChanged();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        return I18nManager.getText("dialog.findfile.resultscolumn." + (n == 0 ? "file" : "contents"));
    }

    @Override
    public int getRowCount() {
        return this._results == null ? 0 : this._results.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n >= this.getRowCount()) {
            return "";
        }
        if (n2 == 0) {
            return this._results.get(n).getFilename();
        }
        return this._results.get(n).getContents();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public File getFile(int n) {
        return this._results.get(n).getTrackFile().getFile();
    }
}

