/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.comparesegments;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.Distance;
import tim.prune.data.Unit;
import tim.prune.function.comparesegments.IntersectionResult;
import tim.prune.function.comparesegments.TimeCalculations;

public class DataPanel
extends JPanel {
    private final JTextArea _distanceMatchesText;
    private final JTextArea _timeMatchesText;

    public DataPanel() {
        String string = "Example text to give it some width to start with\n".repeat(10);
        this._distanceMatchesText = new JTextArea(string);
        this._timeMatchesText = new JTextArea(string);
        this.setLayout(new GridLayout(2, 1, 2, 6));
        this.add(DataPanel.makeHalfPanel("distancematches", this._distanceMatchesText));
        this.add(DataPanel.makeHalfPanel("timematches", this._timeMatchesText));
    }

    private static JPanel makeHalfPanel(String string, JTextArea jTextArea) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(4, 2));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.comparesegments.data." + string));
        jPanel.add((Component)jLabel, "North");
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(new Dimension(400, 150));
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    public void setDetails(List<IntersectionResult> list, Config config) {
        Unit unit = config.getUnitSet().getDistanceUnit();
        Unit unit2 = config.getUnitSet().getSpeedUnit();
        this._distanceMatchesText.setText(this.generateDistanceData(list, unit, unit2));
        this._timeMatchesText.setText(this.generateTimeData(list, unit));
    }

    private String generateDistanceData(List<IntersectionResult> list, Unit unit, Unit unit2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(I18nManager.getText("fieldname.distance")).append(';').append(I18nManager.getText("fieldname.time")).append(';').append(I18nManager.getText("fieldname.distance")).append(';').append(I18nManager.getText("fieldname.time")).append(';').append(I18nManager.getText("dialog.comparesegments.data.secsahead")).append(';').append(I18nManager.getText("dialog.comparesegments.data.speeddiff")).append(" (").append(I18nManager.getText(unit2.getShortnameKey())).append(");\n");
        IntersectionResult intersectionResult = null;
        for (IntersectionResult intersectionResult2 : list) {
            double d;
            long l;
            long l2;
            double d2;
            double d3;
            if (intersectionResult == null) {
                intersectionResult = intersectionResult2;
                d3 = 0.0;
                d2 = 0.0;
                l2 = 0L;
                l = 0L;
                d = 0.0;
            } else {
                d2 = intersectionResult2.getFirstDistanceRadians(intersectionResult);
                d3 = intersectionResult2.getSecondDistanceRadians(intersectionResult);
                l = intersectionResult2.getFirstDurationSeconds(intersectionResult);
                l2 = intersectionResult2.getSecondDurationSeconds(intersectionResult);
                d = intersectionResult2.getDeltaSpeedRadiansPerSec();
            }
            double d4 = Distance.convertRadiansToDistance(d, unit) * 60.0 * 60.0;
            stringBuilder.append(Distance.convertRadiansToDistance(d2, unit)).append(';').append(l).append(';').append(Distance.convertRadiansToDistance(d3, unit)).append(';').append(l2).append(';').append(l - l2).append(';').append(d4).append(";\n");
        }
        return stringBuilder.toString();
    }

    private String generateTimeData(List<IntersectionResult> list, Unit unit) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(I18nManager.getText("fieldname.distance")).append(';').append(I18nManager.getText("fieldname.time")).append(';').append(I18nManager.getText("fieldname.distance")).append(';').append(I18nManager.getText("dialog.comparesegments.data.distahead")).append(" (").append(I18nManager.getText(unit.getShortnameKey())).append(");\n");
        IntersectionResult intersectionResult = null;
        for (IntersectionResult intersectionResult2 : list) {
            long l;
            double d;
            Double d2;
            if (intersectionResult == null) {
                intersectionResult = intersectionResult2;
                d2 = 0.0;
                d = d2;
                l = 0L;
            } else {
                d = intersectionResult2.getFirstDistanceRadians(intersectionResult);
                l = intersectionResult2.getFirstDurationSeconds(intersectionResult);
                d2 = TimeCalculations.findSecondDistanceAtSameTime(list, l);
            }
            if (d2 == null) continue;
            stringBuilder.append(Distance.convertRadiansToDistance(d, unit)).append(';').append(l).append(';').append(Distance.convertRadiansToDistance(d2, unit)).append(';').append(Distance.convertRadiansToDistance(d2 - d, unit)).append(";\n");
        }
        return stringBuilder.toString();
    }
}

