/* gtd-utils.h
 *
 * Copyright 2018-2020 Georges Basile Stavracas Neto <georges.stavracas@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <gtk/gtk.h>

G_BEGIN_DECLS

gchar*               gtd_normalize_casefold_and_unaccent         (const gchar        *str);

gchar*               gtd_str_replace                             (const gchar        *source,
                                                                  const gchar        *search,
                                                                  const gchar        *replacement);

gint                 gtd_collate_compare_strings                 (const gchar        *string_a,
                                                                  const gchar        *string_b);

GdkPaintable*        gtd_create_circular_paintable              (GdkRGBA             *color,
                                                                 gint                 size);

G_END_DECLS
