/*
 *
 *  Kepas - KDE Easy Publish and Share
 *
 *  Copyright (C) 2008  Tom Patzig <tpatzig@suse.de>
 *
 *  This file is part of kepas.
 *
 *  kepas is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  kepas is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kepas; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
*/

#include "plasma-kifer.h"
#include <QPainter>
#include <QFontMetrics>
#include <QSizeF>
#include <KIcon>
 
#include <plasma/svg.h>
#include <plasma/theme.h>
#include <plasma/widgets/icon.h>
#include <plasma/containment.h>
 
PlasmaKifer::PlasmaKifer(QObject *parent, const QVariantList &args)
    : Plasma::Applet(parent, args),
//  m_svg("widgets/background", this),
//  m_size(100,100),
    m_icon(0)
{

}

void PlasmaKifer::init()
{
	buddylist = new BuddyList(this);
	avahiClient = new ServiceLocator(this);
//	connect(avahiClient, SIGNAL(serviceRuns()),this, SLOT(failedToStart()));

	m_icon = new Plasma::Icon(KIcon("folder-remote"),QString(),this);
//	m_icon->setDrawBackground(true);
	m_icon->installSceneEventFilter(this);

//	icon = (KIcon*)m_icon;
	createMenu();
	connect(m_icon, SIGNAL(pressed(bool)),this, SLOT(popup(bool)));
	connect(&m_menu, SIGNAL(aboutToHide()),m_icon, SLOT(setUnpressed()));

    	setHasConfigurationInterface(true);
	setAcceptDrops(true);
	setAcceptsHoverEvents(true);
	setDrawStandardBackground(false);
	m_svg.setContentType(Plasma::Svg::SingleImage);
	m_dialog = 0;
}
 
PlasmaKifer::~PlasmaKifer()
{
    if (failedToLaunch()) {
        // Do some cleanup here
    } else {
        // Save settings
    }

    if (m_dialog)
	delete m_dialog;
	qDebug() << "m_dialog deleted";

    if (buddylist)
	delete buddylist;
	qDebug() << "buddylist deleted";
    if (avahiClient)
	delete avahiClient;
	qDebug() << "avahiclient deleted";

     delete dbus;
}

void PlasmaKifer::failedToStart()
{
	
        m_icon->setIcon(KIcon("dialog-information"));
	m_icon->setText("Service already running");
	m_menu.clear();
}

void PlasmaKifer::constraintsUpdated(Plasma::Constraints constraints)
{
    setDrawStandardBackground(false);
    if (constraints & Plasma::FormFactorConstraint) {
        if (formFactor() == Plasma::Planar ||
            formFactor() == Plasma::MediaCenter) {
            m_icon->setText(i18n("Kepas"));
            setMinimumContentSize(m_icon->sizeFromIconSize(IconSize(KIconLoader::Desktop)));
        } else {
            m_icon->setText(0);
            m_icon->setInfoText(0);
            setMinimumContentSize(m_icon->sizeFromIconSize(IconSize(KIconLoader::Panel)));
        }
//        m_icon->setIcon(KIcon("applications-internet"));
    }
    if (constraints & Plasma::SizeConstraint && m_icon) {
        setContentSize(size());
        m_icon->resize(size());
    }

    updateGeometry();
}

 
void PlasmaKifer::setContentSize(const QSizeF& size)
{
    m_size = size;
}
 
QSizeF PlasmaKifer::contentSizeHint() const
{
    return m_size;
}

void PlasmaKifer::createMenu()
{
    QAction* buddies = new QAction(SmallIcon("user"),i18n("Buddies"), this);
    connect(buddies, SIGNAL(triggered(bool)), this , SLOT(slotBuddyList(bool)));

    QAction* sendFile = new QAction(SmallIcon("text-directory"),i18n("Send File"), this);
    connect(sendFile, SIGNAL(triggered(bool)), this , SLOT(slotFileSelect(bool)));

 

    m_menu.addTitle(i18n("Kepas"));
    m_menu.addAction(buddies);
    m_menu.addAction(sendFile);
    clipMenu = m_menu.addMenu(KIcon("klipper"),i18n("Send Clipboard"));
    addClipEntries();

}

void PlasmaKifer::popup(bool pressed)
{
    if (!pressed || m_menu.isVisible()) {
        m_menu.hide();
        return;
    }

    QPointF scenePos = mapToScene(boundingRect().topLeft());
    QGraphicsView *viewWidget = view();
    QDesktopWidget *desktop = QApplication::desktop();
    if (viewWidget) {
        QPoint viewPos = viewWidget->mapFromScene(scenePos);
        QPoint globalPos = viewWidget->mapToGlobal(viewPos);
        QRect desktopRect = desktop->availableGeometry(viewWidget);
        QRect size = mapToView(viewWidget, contentRect());

        const int menuHeight = m_menu.sizeHint().height();

        if (globalPos.y() + size.height() + menuHeight
            < desktopRect.bottom()) {
            globalPos.ry() += contentSize().height();
        }else{
            globalPos.ry() -= menuHeight;
        }
        m_menu.popup(globalPos);
        m_icon->setPressed();
    }
    addClipEntries();
}

/*
void PlasmaKifer::paintInterface(QPainter *p,
        const QStyleOptionGraphicsItem *option, const QRect &contentsRect)
{
    p->setRenderHint(QPainter::SmoothPixmapTransform);
    p->setRenderHint(QPainter::Antialiasing);
 
    m_svg.resize((int)contentsRect.width(), (int)contentsRect.height());
    m_svg.paint(p, (int)contentsRect.left(), (int)contentsRect.top());
 
    p->drawPixmap(20, 0, icon.pixmap((int)contentsRect.width() - 40));
    p->save();

    p->restore();
}
*/

void PlasmaKifer::dragEnterEvent(QGraphicsSceneDragDropEvent *event)
{
        kDebug() << event->mimeData()->formats();

        if (event->mimeData()->hasUrls()) {
                event->acceptProposedAction();
        }
        else {
         event->ignore();
        }

}

void PlasmaKifer::dropEvent(QGraphicsSceneDragDropEvent *event)
{
        KUrl droppedUrl = (KUrl::List::fromMimeData(event->mimeData())).at(0);
	QString file = droppedUrl.toLocalFile();
	
        avahiClient->browse();
        connect(avahiClient, SIGNAL(addBuddy(QMap<QString, QByteArray>)),buddylist,SLOT(addService(QMap<QString,QByteArray>)));
        connect(avahiClient, SIGNAL(delBuddy(QString)),buddylist,SLOT(delService(QString)));
        buddylist->initSendFileBuddyList(file,avahiClient->getUserName());
	
}

void PlasmaKifer::slotBuddyList(bool set)
{

	 avahiClient->browse();
	 connect(avahiClient, SIGNAL(addBuddy(QMap<QString, QByteArray>)),buddylist,SLOT(addService(QMap<QString,QByteArray>)));
	 connect(avahiClient, SIGNAL(delBuddy(QString)),buddylist,SLOT(delService(QString)));
	 
	 buddylist->initDefaultBuddyList(avahiClient->getUserName());

}

void PlasmaKifer::slotFileSelect(bool set)
{
	QString fileName = QFileDialog::getOpenFileName(&m_menu, tr("Select File"),"./","*");
	if (fileName.isEmpty())
		return;
	else {
		avahiClient->browse();
		connect(avahiClient, SIGNAL(addBuddy(QMap<QString, QByteArray>)),buddylist,SLOT(addService(QMap<QString,QByteArray>)));
		connect(avahiClient, SIGNAL(delBuddy(QString)),buddylist,SLOT(delService(QString)));
	
        	buddylist->initSendFileBuddyList(fileName,avahiClient->getUserName());
	}
}


void PlasmaKifer::showConfigurationInterface()
{
   if (m_dialog == 0) {
        m_dialog = new KDialog;
        m_dialog->setCaption( i18n("Configure Kepas") );
        ui.setupUi(m_dialog->mainWidget());
        m_dialog->setButtons( KDialog::Ok | KDialog::Cancel | KDialog::Apply );
        connect( m_dialog, SIGNAL(applyClicked()), this, SLOT(configAccepted()) );
        connect( m_dialog, SIGNAL(okClicked()), this, SLOT(configAccepted()) );
	connect( ui.saveToButton,SIGNAL(clicked()),this,SLOT(slotSelectDir()));
    }
    ui.pictureButton->setIcon(KIcon("user"));
    ui.nameLineEdit->setText(avahiClient->getUserName());
    ui.saveToLineEdit->setText(avahiClient->receiver->getTargetPath());
 
    
    m_dialog->show();
}

void PlasmaKifer::configAccepted()
{

	avahiClient->receiver->setTargetPath(ui.saveToLineEdit->text());
	avahiClient->setUserName(ui.nameLineEdit->text());
	bool OK = avahiClient->restartPublish();
        OK ? qDebug() << "Service restarted and published succesfull " : qDebug() << "Service not published";
	
}

void PlasmaKifer::slotSelectDir()
{

	QString dirname = QFileDialog::getExistingDirectory(m_dialog, tr("Select Target Directory"),"./");
	if (!dirname.isEmpty())
		ui.saveToLineEdit->setText(dirname);

}

void PlasmaKifer::addClipEntries()
{
	clipMenu->clear();
	dbus = new QDBusConnection("dbus");
	QDBusConnection dbusconn = dbus->connectToBus(QDBusConnection::SessionBus, "dbus");
	QString service = "org.kde.klipper";
	QString path = "/klipper";
	QString method = "getClipboardHistoryMenu";
	QString service2 = "org.kde.klipper.klipper";

	QDBusInterface* interface = new QDBusInterface(service,path,service2,dbusconn);
	QDBusReply<QStringList> reply = interface->call(method);
	
//	qDebug() << "klipper reply: " << reply.value();
	QStringList clipList = reply.value();

	for (int i=0; i < clipList.size(); i++){
		if (clipList.at(i).size() >= 30) {
			QString cut = clipList.at(i);
			cut.truncate(30);
			
			clipAction = clipMenu->addAction(cut + " ...");
	         } else
			clipAction = clipMenu->addAction(clipList.at(i));
		
		clipAction->setToolTip(clipList.at(i));
		
	}

 	connect(clipMenu, SIGNAL(triggered(QAction*)), this, SLOT(slotSendClipEntry(QAction*)));
}

void PlasmaKifer::slotSendClipEntry(QAction* action)
{
	avahiClient->browse();
	connect(avahiClient, SIGNAL(addBuddy(QMap<QString, QByteArray>)),buddylist,SLOT(addService(QMap<QString,QByteArray>)));
	connect(avahiClient, SIGNAL(delBuddy(QString)),buddylist,SLOT(delService(QString)));

	QString entry = action->toolTip();
	buddylist->initSendClipBuddyList(entry,avahiClient->getUserName());

}
 
#include "plasma-kifer.moc"
