include(CheckIncludeFile)
include(CheckIncludeFiles)
include(CheckSymbolExists)
include(CheckFunctionExists)
include(CheckLibraryExists)
include(CheckPrototypeExists)
include(CheckTypeSize)
include(MacroBoolTo01)
# The FindKDE4.cmake module sets _KDE4_PLATFORM_DEFINITIONS with
# definitions like _GNU_SOURCE that are needed on each platform.
set(CMAKE_REQUIRED_DEFINITIONS ${_KDE4_PLATFORM_DEFINITIONS})

#check for libz using the cmake supplied FindZLIB.cmake
macro_bool_to_01(ZLIB_FOUND HAVE_LIBZ)
macro_bool_to_01(JPEG_FOUND HAVE_LIBJPEG)
macro_bool_to_01(PNG_FOUND HAVE_LIBPNG)
macro_bool_to_01(CARBON_FOUND HAVE_CARBON)

#now check for dlfcn.h using the cmake supplied CHECK_include_FILE() macro
# If definitions like -D_GNU_SOURCE are needed for these checks they
# should be added to _KDE4_PLATFORM_DEFINITIONS when it is originally
# defined outside this file.  Here we include these definitions in
# CMAKE_REQUIRED_DEFINITIONS so they will be included in the build of
# checks below.
set(CMAKE_REQUIRED_DEFINITIONS ${_KDE4_PLATFORM_DEFINITIONS})
if (WIN32)
   set(CMAKE_REQUIRED_LIBRARIES ${KDEWIN32_LIBRARIES} )
   set(CMAKE_REQUIRED_INCLUDES  ${KDEWIN32_INCLUDES} )
endif (WIN32)

check_include_files(byteswap.h HAVE_BYTESWAP_H)
check_include_files(crt_externs.h HAVE_CRT_EXTERNS_H)
check_include_files(fcntl.h HAVE_FCNTL_H)
check_include_files(fnmatch.h HAVE_FNMATCH_H)
check_include_files(getopt.h HAVE_GETOPT_H)
check_include_files(inttypes.h HAVE_INTTYPES_H)
check_include_files(memory.h HAVE_MEMORY_H)
check_include_files(paths.h HAVE_PATHS_H)
check_include_files(stdint.h HAVE_STDINT_H)
check_include_files(stdlib.h HAVE_STDLIB_H)
check_include_files(string.h HAVE_STRING_H)
check_include_files(strings.h HAVE_STRINGS_H)
check_include_files(sys/bitypes.h HAVE_SYS_BITYPES_H)
check_include_files(sys/cdefs.h HAVE_SYS_CDEFS_H)
check_include_files(sys/file.h HAVE_SYS_FILE_H)
check_include_files(sys/param.h HAVE_SYS_PARAM_H)
check_include_files(sys/time.h HAVE_SYS_TIME_H)
check_include_files(sys/types.h HAVE_SYS_TYPES_H)
check_include_files(sysent.h      HAVE_SYSENT_H)
check_include_files(tgmath.h HAVE_TGMATH_H)
check_include_files(unistd.h      HAVE_UNISTD_H)
check_include_files(utmp.h HAVE_UTMP_H)
check_include_files("sys/time.h;time.h" TIME_WITH_SYS_TIME)

check_function_exists(_NSGetEnviron   HAVE_NSGETENVIRON)
check_function_exists(setenv     HAVE_SETENV)
check_function_exists(strlcat    HAVE_STRLCAT)
check_function_exists(strlcpy    HAVE_STRLCPY)
check_function_exists(unsetenv   HAVE_UNSETENV)
check_function_exists(usleep     HAVE_USLEEP)
check_function_exists(random     HAVE_RANDOM)
check_function_exists(srandom         HAVE_SRANDOM)
check_library_exists(crypt crypt "" HAVE_CRYPT)

check_symbol_exists(snprintf        "stdio.h"                  HAVE_SNPRINTF)
check_symbol_exists(vsnprintf       "stdio.h"                  HAVE_VSNPRINTF)

check_prototype_exists(setenv stdlib.h HAVE_SETENV_PROTO)
check_prototype_exists(strlcat string.h HAVE_STRLCAT_PROTO)
check_prototype_exists(strlcpy string.h HAVE_STRLCPY_PROTO)
check_prototype_exists(unsetenv stdlib.h HAVE_UNSETENV_PROTO)
check_prototype_exists(usleep unistd.h HAVE_USLEEP_PROTO)
check_prototype_exists(getdomainname "stdlib.h;unistd.h;netdb.h" HAVE_GETDOMAINNAME_PROTO)
check_prototype_exists(random stdlib.h HAVE_RANDOM_PROTO)
check_prototype_exists(srandom stdlib.h HAVE_SRANDOM_PROTO)

check_type_size("int" SIZEOF_INT)
check_type_size("char *"  SIZEOF_CHAR_P)
check_type_size("long" SIZEOF_LONG)
check_type_size("short" SIZEOF_SHORT)
check_type_size("size_t" SIZEOF_SIZE_T)
check_type_size("unsigned long" SIZEOF_UNSIGNED_LONG)

