/***************************************************************************
                          optionsdialog.cpp  -  description
                             -------------------
    begin                : Fri Mar 16 2001
    copyright            : (C) 2001 by Michael Heidecke
    email                : heidecke@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "options.h"
#include "dockwidget.h"
#include "ksteak.h"

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qframe.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qradiobutton.h>

#include <klocale.h>
#include <kiconloader.h>
#include <kglobalaccel.h>
#include <kcolorbutton.h>
#include <kfontdialog.h>
#include <kkeydialog.h>


OptionsDialog::OptionsDialog(KSteak *parent, const char *name, bool, WFlags)
  : KDialogBase(KDialogBase::IconList, i18n("Preferences"), Ok|Apply|Cancel, KDialogBase::Ok, parent, name, true, true)
{
  par = parent;

   //Common settings
   frame1 = addPage(i18n("General"), i18n("General"), DesktopIcon("winprops"));
   QVBoxLayout *layout1 = new QVBoxLayout(frame1, 0, spacingHint() );

   bGroup1 = new QButtonGroup(2, Qt::Vertical, i18n("Input Field:"), frame1);
   layout1->addWidget(bGroup1);
   ButtonClear = new QCheckBox(i18n("clear after search"), bGroup1);
   bGroup1->insert(ButtonClear);
   ButtonClear->setChecked(par->_fClear);

   bGroup2 = new QButtonGroup(2, Qt::Vertical, i18n("Always popup at:"), frame1);
   layout1->addWidget(bGroup2);
   rButton1 = new QRadioButton(i18n("current cursor position"), bGroup2);
   rButton2 = new QRadioButton(i18n("kicker (docking area)"), bGroup2);
   bGroup2->insert(rButton1);
   bGroup2->insert(rButton2);

  if (par->SteakDock->_fPopup)
  	rButton2->setChecked(true);
  else
	rButton1->setChecked(true);

  // colors
  frame2 = addPage(i18n("Colors"), i18n("Colors"), DesktopIcon("colors"));

  QGridLayout *layout2 = new QGridLayout(frame2, 2, 2, 10);

  QLabel *Label1 = new QLabel(i18n("Text"), frame2);
  layout2->addWidget(Label1, 0, 0);
  Button1 = new KColorButton(frame2);
  Button1->setColor(par->textColor);
  layout2->addWidget(Button1, 0, 1, AlignLeft);

  QLabel *Label2 = new QLabel(i18n("Background"), frame2);
  layout2->addWidget(Label2, 1, 0);
  Button2 = new KColorButton(frame2);
  Button2->setColor(par->bgColor);
  layout2->addWidget(Button2, 1, 1, AlignLeft);

  layout2->setColStretch( 0, 20 );
  layout2->setColStretch( 1, 20 );
  layout2->setRowStretch( 0, 10 );
  layout2->setRowStretch( 1, 10 );

  // Font Dialog
  frame3 = addPage(i18n("Fonts"), i18n("Fonts"), DesktopIcon("fonts"));
  QVBoxLayout *layout3 = new QVBoxLayout(frame3, 0, spacingHint() );
  Fontchooser = new KFontChooser( frame3, "font", false, QStringList(), false, 6 );
  Fontchooser->setFont(par->mFont);
  Fontchooser->setSampleText( i18n("KSteak Sample Text") );
  layout3->addWidget(Fontchooser);

  // Shortcut
  frame4 = addPage(i18n("Shortcut"), i18n("Shortcut"), DesktopIcon("keyboard"));
  QVBoxLayout *layout4 = new QVBoxLayout(frame4, 0, spacingHint() );
  Keychooser = new KKeyChooser( par->ga, frame4);
  layout4->addWidget(Keychooser);
}

void OptionsDialog::slotOk()
{
  slotApply();
  accept();
}

void OptionsDialog::slotApply()
{
  par->textColor = Button1->color();
  par->bgColor = Button2->color();
  par->mFont = Fontchooser->font();
  par->applyOptions();
  Keychooser->commitChanges();
  //Keychooser-save();
  par->ga->updateConnections();
  par->SteakDock->_fPopup = rButton2->isChecked();
  par->_fClear = ButtonClear->isChecked();
}
