# Copyright (c) 2002  Riverbank Computing Limited <info@riverbankcomputing.co.uk>
# Copyright (c) 2002  Jim Bublitz <jbublitz@nwinternet.com>

# This is the rebuild script for PyKDE.  It should be run in the top level
# directory of the source distribution and by the Python interpreter for which
# it is being built.  It uses either qmake or tmake to do the hard work of
# generating the platform specific Makefiles.


import sys
import os
import glob
import re
import tempfile
import shutil
import py_compile
import string
import build

FALSE = 0
TRUE  = not FALSE

# We fix up the Makefile with "rm's" instead of doing them in the
# script because of ownership/permission problems -- the user owns
# the Makefile (and source files), but root owns the libs, so we
# can't delete them directly. We have to delete them in order to
# force a relink of all downstream modules. 'make' is run as root
# in this system.

def fixupMakefile (dir, modList):
    m = open (dir + '/Makefile', 'r')
    n = open (dir + '/Makefile.tmp', 'w')

    buff = m.readlines ()
    m.close ()
    for line in buff:
       n.write (line)
       if line [0:4] == 'all:':
           print 'relink:',
           for mod in modList:
                print mod,
                n.write ('\trm -f ' + build.platPySiteDir + '/lib' + mod + 'cmodule*\n')
           print

    n.close ()
    os.remove (dir + '/Makefile')
    os.rename (dir + '/Makefile.tmp', dir + '/Makefile')


def main(argv):
    """The main function of the script.

    argv is the list of command line arguments.
    """
    import getopt

    # Parse the command line.
    build.progName = os.path.basename(argv[0])

    build.initGlobals()

    try:
        optlist, args = getopt.getopt(argv[1:],"hcd:e:g:i:k:l:m:p:q:s:t:u:v:z:")
    except getopt.GetoptError:
        build.usage ()

    if (args == '') or (len (args) > 1):
        build.usage ()

    # Look for '-z' first and process that switch
    # (command line switches override file switches)
    for opt, arg in optlist:
        if opt == "-z":
             optlist = fileOpts (arg) + optlist


    explicitMake = 0

    for opt, arg in optlist:
        if opt == "-h":
            build.usage(0)
        elif opt == "-c":
            build.catCppFiles = 1
        elif opt == "-d":
            build.modDir = arg
        elif opt == "-e":
            build.sipIncDir = arg
        elif opt == "-g":
            build.makefileGen = arg
        elif opt == "-i":
            build.qtIncDir = arg
        elif opt == "-k":
            build.kdeDir = arg
        elif opt == "-l":
            if arg in ("qt", "qt-mt"):
                build.qtLib = arg
            else:
                build.usage()
        elif opt == "-m":
            makeBin = arg
            explicitMake = 1
        elif opt == "-p":
            build.sipBin = arg
        elif opt == "-q":
            build.qtDir = arg
        elif opt == "-s":
            build.sipModuleDir = arg
        elif opt == "-t":
            build.kdeIncDir = arg
        elif opt == "-u":
            build.kdeLib = arg
        elif opt == "-v":
            build.pyQtSipDir = arg
        elif opt == "-z":
            pass

    build.installChecks()
    maindir = build.mkTempBuildDir()
    build.compileChecks()

    # Work out the platform and Qt version tags to pass to SIP to generate the
    # code we need.
    if build.qtLib == "qte":
        build.plattag = "WS_QWS"
    elif sys.platform == "win32":
        build.plattag = "WS_WIN"
    else:
        build.plattag = "WS_X11"

    qttags = {
        0x020000: "Qt_1_43",
        0x020100: "Qt_2_00",
        0x020200: "Qt_2_1_0",
        0x020300: "Qt_2_2_0",
        0x020301: "Qt_2_3_0",
        0x030000: "Qt_2_3_1",
        0x030001: "Qt_3_0_0",
        0x030002: "Qt_3_0_1",
        0x030004: "Qt_3_0_2",
        0x030005: "Qt_3_0_4",
        0x040000: "Qt_3_0_5"
    }

    qttag = None

    vl = qttags.keys()
    vl.sort()

    for v in vl:
        if build.qtVersion < v:
            qttag = qttags[v]
            break

    if qttag is None:
        build.error("Invalid Qt version: %d" % (build.qtVersion))

    # Generate the features file.
    build.generateFeatures(maindir + "/features")

    # We don't need the temporary build directory anymore.
    build.mkTempBuildDir(maindir)

    build.copySipFiles ()

    build.buildModules = build.modList [str (build.kdeVersion) [0:2]]

    subdirs = ''
    flag    = FALSE
    if not args [0] in build.buildModules:
        build.error ("%s is not a PyKDE module" % (args [0]))

    for mname in build.buildModules:
        if flag:
                subdirs = subdirs + ' ' +  mname

        if mname == args [0]:
                build.generateSource(args [0], build.plattag, qttag)
                flag = TRUE

    if flag:
        fixupMakefile (args [0], string.split (string.strip (subdirs), ' '))

    # (Don't re-)Generate the top-level Makefile.
#    build.inform("Creating top level Makefile.")
#    build.copyToFile("PyQt.pro","TEMPLATE = subdirs\nSUBDIRS =" + subdirs + "\n")
#    build.buildMakefile("PyQt.pro")

    # Tell the user what to do next.
    if explicitMake:
        mk = build.makeBin
    else:
        (mk,ignore) = os.path.splitext(os.path.basename(build.makeBin))

    msg = "The build of the PyKDE source code for your system is now complete. To compile and install PyKDE run \"%s\" and \"%s install\" with appropriate user privileges." % (mk,mk)

    build.inform(msg)

if __name__ == "__main__":
    try:
        main(sys.argv)
    except SystemExit:
        raise
    except:
        print \
"""An internal error occured.  Please report all the output from the program,
including the following traceback, to phil@riverbankcomputing.co.uk.
"""
        raise
