# Copyright (c) 2002  Riverbank Computing Limited <info@riverbankcomputing.co.uk>
# Copyright (c) 2002  Jim Bublitz <jbublitz@nwinternet.com>

# This is the build script for PyKDE.  It should be run in the top level
# directory of the source distribution and by the Python interpreter for which
# it is being built.  It uses either qmake or tmake to do the hard work of
# generating the platform specific Makefiles.


import sys
import os
import glob
import re
import tempfile
import shutil
import py_compile
import string


# Define the globals.
progName = None

qtDir           = None
qtIncDir        = None
qtVersion       = 0
qtLib           = None

kdeDir          = None
kdeIncDir       = None
kdeVersion      = 0
kdeLib          = None
pyQtSipDir      = None

platPyScriptDir = None
platPyDLLDir    = None
platPySiteDir   = None
platPyIncDir    = None
platPyLib       = None
platBinDir      = None
platMake        = None
platCopy        = None
platMkdir       = None
platQTDIRName   = None
platKDEDIRName  = None

sipModuleDir    = None
sipIncDir       = None
sipBin          = None

modDir          = None
pyFullVers      = None
makefileGen     = None
makeBin         = None
proPatches      = {}
makefilePatches = {}
tempBuildDir    = None
usingTmake      = 0
enableOldPython = 0
catCppFiles     = 0
qpeTag          = None

FALSE      = 0
TRUE       = not FALSE

Release    = "3.3rc1"
Version    = "3.3rc1"

QtVers     = ["230", "231", "232", "300", "301", "302", "304", "305"]
KDEVers    = ["211", "212", "220", "221", "222", "300", "301", "302", "303"]

modList        = {}
modList ["21"] = ["dcop", "kdecore", "kdesu", "kdeui", "kio", "kfile", "kparts", "khtml", "kjs", "kspell"]
modList ["22"] = [] + modList ["21"]
modList ["22"].append ("kdeprint")
modList ["30"] = modList ["22"][0:3] + ["kdefx"] + modList ["22"][3:]
modList ["31"] = modList ["30"] 
#modList ["31"] = ["kdecore"]

modules    = {}

modules ["dcop"]      = "dcop"
modules ["kdecore"]   = "kdecore"
modules ["kdefx"]     = "kdefx"
modules ["kdesu"]     = "kdesu"
modules ["kdeui"]     = "kdeui"
modules ["kio"]       = "kio"
modules ["kfile"]     = "kfilemod"
modules ["kparts"]    = "kparts"
modules ["khtml"]     = "khtml"
modules ["kjs"]       = "kjsmod"
modules ["kspell"]    = "kspellmod"
modules ["kdeprint"]  = "kdeprint"


def usage(rcode = 2):
    """Display a usage message and exit.

    rcode is the return code passed back to the calling process.
    """
    global progName, platBinDir, platMake, modDir, platQTDIRName, sipIncDir

    print "Usage:"
    print "    %s [-h] " % (progName)
    print "    %s [options]\n" % (progName)
    print "where:"
    print "    -h             display this help message\n"

    print "  options:\n"
    print "    -c             concatenate each module's C++ source files"
    print "    -d dir         where PyKDE will be installed [default %s]" % (modDir)
    print "    -e dir         the directory containing the SIP header files [default %s]" % (sipIncDir)
    print "    -g prog        the name of the Makefile generator"
    print "    -i dir         the directory containing the Qt header files [default %s%sinclude]" % (platQTDIRName,os.sep)
    print "    -k dir         the KDE base directory [default %s]" % (platKDEDIRName)
    print "    -l Qt-library  explicitly specify the type of Qt library, either qt, qt-mt or qte"
    print "    -m prog        the name of the Make program [default %s]" % (platMake)
    print "    -p dir         the name of the SIP code generator [default sip]"
    print "    -q dir         the Qt base directory [default %s]" % (platQTDIRName)
    print "    -s dir         the directory containing the SIP module"
    print "    -t dir         the directory containing the KDE header files [default %s/include]" % (platKDEDIRName)
    print "    -u dir         the directory containing the KDE lib files [default %s/lib]" % (platKDEDIRName)
    print "    -v dir         the directory containing the PyQt sip files\n"
    print "    -z file        the name of a file containing command line flags"

    sys.exit(rcode)


def format(mess, err = FALSE):
    """Format a message by inserting line breaks at appropriate places.

    mess is the text of the message.

    Return the formatted message.
    """
    msg = ''
    margin = 78
    curs = 0
    if err:
        msg = "*" * margin + "\n"

    for w in string.split(mess):
        l = len(w)
        if curs != 0 and curs + l > margin:
            msg = msg + "\n"
            curs = 0

        if curs > 0:
            msg = msg + " "
            curs = curs + 1

        msg = msg + w
        curs = curs + l

    if err:
        msg = msg + "\n" + ("*" * margin) + "\n"
    else:
        msg = msg + '\n'

    return msg


def error(mess):
    """Display an error message and exit.

    mess is the text of the message.
    """
    frame = sys._getframe (1)
    ln = str (frame.f_lineno)

    sys.stderr.write(format ("Error: %s -- from line %s in build.py" % (mess, ln), TRUE))
    sys.exit(1)


def inform(mess):
    """Display an information message.

    mess is the text of the message.
    """
    sys.stdout.write(format(mess))


def makeVersion (s, v):
        ver = s + '_' + v [0] + '_' + v [1] + '_' + v [2]
        return ver

def initGlobals():
    """Sets the values of globals that need more than a simple assignment.
    """
    global platMake, platCopy, platPyScriptDir, platPyDLLDir, platPySiteDir
    global platPyIncDir, platPyLib, platQTDIRName, platBinDir, platMkdir
    global modDir, pyFullVers, sipIncDir, platKDEDIRName

    pyFullVers = string.split(sys.version)[0]

    vl = string.split(pyFullVers,".")
    pyVers = vl[0] + "." + vl[1]
    pyVersNr = int(vl[0]) * 10 + int(vl[1])

    if sys.platform == "win32":
        error ("KDE not supported under Windows")
    else:
        vl = string.split(pyFullVers,".")
        pyVers = vl[0] + "." + vl[1]

        platMake = "make"
        platCopy = "cp"
        platMkdir = "mkdir"
        platPyScriptDir = sys.prefix + "/lib/python" + pyVers
        platPyDLLDir = sys.prefix + "/lib/python" + pyVers + "/lib-dynload"
        platPySiteDir = sys.prefix + "/lib/python" + pyVers + "/site-packages"
        platPyIncDir = sys.prefix + "/include/python" + pyVers
        platQTDIRName = "$QTDIR"
        platKDEDIRName = "$KDEDIR"
        platBinDir = "/usr/local/bin"

    modDir = platPySiteDir
    sipIncDir = platPyIncDir


def searchPath(prog,xtradir = None):
    """Search the PATH for a program and return it's absolute pathname.

    prog is the name of the program.
    xtradir is the name of an optional extra directory to search as well.
    """
    # Create the list of directories to search.
    try:
        path = os.environ["PATH"]
    except KeyError:
        path = os.defpath

    dlist = string.split(path,os.pathsep)

    if xtradir:
        dlist.insert(0,xtradir)

    # Create the list of files to check.
    flist = []

    for d in dlist:
        flist.append(os.path.abspath(os.path.join(d,prog)))

    # Search for the file.
    for f in flist:
        if os.access(f,os.X_OK):
            return f

    # Nothing found.
    return None


def patchFile(name,pdict,bakfile = None):
    """Apply the patches to a file.

    name is the name of the file.
    pdict is the patch dictionary.
    bakfile is the name of the optional backup file for the unpatched version.
    """
    newname = name + ".new"

    fi = open(name,"r")
    fo = open(newname,"w")

    for line in fi.readlines():
        for (pattern, repl) in pdict.values():
            line = re.sub(pattern,repl,line)

        fo.write(line)

    fi.close()
    fo.close()

    if bakfile is None:
        os.remove(name)
    else:
        os.rename(name,bakfile)

    os.rename(newname,name)


def isQtLibrary(dir,lib):
    """See if a Qt library appears in a particular directory.

    dir is the name of the directory.
    lib is the name of the library.

    Returns the basename of the library file that was found or None if nothing
    was found.
    """

    lpatt = "/lib" + lib + ".*"

    l = glob.glob(dir + lpatt)

    if len(l) == 0:
        return None

    return os.path.basename(l[0])


def copyToFile(name,text):
    """Copy a string to a file.

    name is the name of the file.
    text is the contents to copy to the file.
    """
    f = open(name,"w")
    f.write(text)
    f.close()


def mkTempBuildDir(olddir = None):
    """Create a temporary build directory for a console application called
    qttest, complete with patched Makefile.  The global tempBuildDir is set to
    the name of the directory.  The temporary directory becomes the current
    directory.

    olddir is None if the directory should be created, otherwise it is deleted.

    Returns the name of the previous current directory.
    """
    global tempBuildDir

    if olddir is None:
        tempBuildDir = tempfile.mktemp()

        try:
            os.mkdir(tempBuildDir)
        except:
            error("Unable to create temporary directory")

        newdir = pushDir(tempBuildDir)

        copyToFile("qttest.pro",
"""TEMPLATE = app
TARGET = qttest
CONFIG = qt console warn_off release @BL_THREAD@
INCLUDEPATH = @BL_INCLUDEPATH@
DEFINES = @BL_DEFINES@
SOURCES = qttest.cpp

""")

        # Create a dummy source file to suppress a qmake warning.
        copyToFile("qttest.cpp","")
        buildMakefile("qttest.pro")

    else:
        popDir(olddir)
        newdir = None

        shutil.rmtree(tempBuildDir,1)

    return newdir


def checkQtDirAndVersion():
    """Check that Qt can be found and what its version is.
    """
    # Check the Qt directory is known and valid.
    global qtVersion, qtDir

    if qtDir is None:
        try:
            qtDir = os.environ["QTDIR"]
        except KeyError:
            error("Please set the name of the Qt base directory, either by using the -q argument or setting the QTDIR environment variable")
    else:
        os.environ["QTDIR"] = qtDir

    # For lib template project files.
    makefilePatches["QTDIR_LIB"] = [re.compile("(^CC)",re.M), "QTDIR    = " + qtDir + "\n\\1"]

    # For subdir template project files.
    makefilePatches["QTDIR_SUBDIR"] = [re.compile("(^MAKEFILE)",re.M), "QTDIR    = " + qtDir + "\n\\1"]

    if not os.access(qtDir,os.F_OK):
        error("The %s Qt base directory does not seem to exist. Use the -q argument or the QTDIR environment variable to set the correct directory" % (qtDir))

    inform("%s is the Qt base directory." % (qtDir))

    # Check that the Qt header files have been installed.
    global qtIncDir

    if qtIncDir:
        qtincdir = qtIncDir
    else:
        qtincdir = qtDir + os.sep + "include"

    qglobal = qtincdir + os.sep + "qglobal.h"

    if not os.access(qglobal,os.F_OK):
        error("qglobal.h could not be found in %s. Use the -i argument to explicitly specify the correct directory" % (qtincdir))

    inform("%s contains qglobal.h." % (qtincdir))

    # Set the list of directories containing header files.
    incdirs = ". " + platPyIncDir

    if sipIncDir != platPyIncDir:
        incdirs = incdirs + " " + sipIncDir

    if qtIncDir:
        incdirs = incdirs + " " + qtIncDir

    proPatches["INCLUDEPATH"] = [re.compile("@BL_INCLUDEPATH@",re.M), incdirs]

    # Get the Qt version number.
    qtversstr = ""
    f = open(qglobal)
    l = f.readline()

    while l:
        wl = string.split(l)
        if len(wl) == 3 and wl[0] == "#define":
            if wl[1] == "QT_VERSION":
                qtv = wl[2]

                if qtv[0:2] == "0x":
                    qtVersion = int(qtv,16)
                else:
                    dec = int(qtv)
                    maj = dec / 100
                    min = (dec % 100) / 10
                    bug = (dec % 10)
                    qtVersion = (maj << 16) + (min << 8) + bug

            if wl[1] == "QT_VERSION_STR":
                qtversstr = wl[2][1:-1]

            if qtversstr != "" and qtVersion > 0:
                break

        l = f.readline()

    f.close()

    if qtversstr == "":
        error("The Qt version number could not be determined by parsing %s" % (qglobal))

    inform("Qt %s is being used." % (qtversstr))



def checkKDEDirAndVersion():
    """Check that KDE can be found and what its version is.
    """
    # Check the KDE directory is known and valid.
    global kdeVersion, kdeDir

    if kdeDir is None:
        try:
            kdeDir = os.environ["KDEDIR"]
        except KeyError:
            error("Please set the name of the KDE base directory, either by using the -j argument or setting the KDEDIR environment variable")
    else:
        os.environ["KDEDIR"] = kdeDir

    # For lib template project files.
    makefilePatches["KDEDIR_LIB"] = [re.compile("(^CC)",re.M), "KDEDIR    = " + kdeDir + "\n\\1"]

    # For subdir template project files.
    makefilePatches["KDEDIR_SUBDIR"] = [re.compile("(^MAKEFILE)",re.M), "KDEDIR    = " + kdeDir + "\n\\1"]

    if not os.access(kdeDir,os.F_OK):
        error("The %s KDE base directory does not seem to exist. Use the -k argument or the KDEDIR environment variable to set the correct directory" % (kdeDir))

    inform("%s is the KDE base directory." % (kdeDir))

    # Check that the KDE header files have been installed.
    global kdeIncDir

    if kdeIncDir:
        kdeincdir = kdeIncDir
    else:
        kdeincdir = kdeDir + os.sep + "include"

    # Get the KDE version number.

    kdeversstr = ""

    # Version info: KDE 3 - kdeversion.h; KDE 2 - kapp.h
    if os.access (kdeincdir + '/kdeversion.h', os.F_OK):
            inform("%s contains kdeversion.h." % (kdeincdir))
            f = open(kdeincdir + '/kdeversion.h')
            l = f.readline()

            # Use MAJOR/MINOR/RELEASE values because KDE_VERSION and
            # KDE_VERSION_STRING are wrong in some distributions

            major = ''
            minor = ''
            rel   = ''

            while l:
                wl = string.split(l)
                if len(wl) == 3 and wl[0] == "#define":
                        if wl[1] == "KDE_VERSION_MAJOR":
                                major = string.strip (wl[2])

                        if wl[1] == "KDE_VERSION_MINOR":
                                minor = string.strip (wl[2])

                        if wl[1] == "KDE_VERSION_RELEASE":
                                rel = string.strip (wl[2])

                if (major != '') and (minor != '') and (rel != ''):
                        break

                l = f.readline()

            f.close()

            if (major == '') or (minor == '') or (rel == ''):
                error ("Couldn't read version info from kdeversion.h in %s" % (kdeincdir))

            kdeversstr = string.join ([major, minor, rel], '.')
            kdeVersion = int (major + minor + rel)

    elif os.access (kdeincdir + '/kapp.h', os.F_OK):
            inform("%s contains kapp.h." % (kdeincdir))
            f = open(kdeincdir + '/kapp.h')
            l = f.readline()

            while l:
                wl = string.split(l)
                if len(wl) == 3 and wl[0] == "#define":
                        if wl[1] == "KDE_VERSION":
                                kdeVersion = int(wl[2])

                        if wl[1] == "KDE_VERSION_STRING":
                                kdeversstr = wl[2][1:-1]

                if kdeversstr != "" and kdeVersion > 0:
                        break

                l = f.readline()

            f.close()

    else:
        error("kapp.h (KDE2) or kdeversion.h (KDE3) could not be found in %s. Use the -i argument to explicitly specify the correct directory" % (kdeincdir))

    proPatches ["INCLUDEPATH"][1] = proPatches ["INCLUDEPATH"][1] + " " + kdeincdir
    proPatches ["KDE_INCLUDES"] = [re.compile("@KDE_INCLUDEPATH@",re.M), kdeincdir]


    if kdeversstr == "":
        error("The KDE version number could not be determined")

    inform("KDE %s is being used." % (kdeversstr))



def checkQtLibrary():
    """Check which Qt library is to be used.
    """
    global qtDir, qtLib

    qtlibdir = qtDir + os.sep + "lib"

    if qtLib is None:
        mtlib = isQtLibrary(qtlibdir,"qt-mt")
        stlib = isQtLibrary(qtlibdir,"qt")

        nrlibs = 0
        names = ""

        if stlib and (kdeVersion < 300):
            nrlibs = nrlibs + 1
            names = names + ", qt"
            qtLib = "qt"
            lib = stlib

        if mtlib and (kdeVersion >= 300):
            nrlibs = nrlibs + 1
            names = names + ", qt-mt"
            qtLib = "qt-mt"
            lib = mtlib

        if nrlibs == 0:
            error("No Qt libraries could be found in %s" % (qtlibdir))

        if nrlibs > 1:
            error("These Qt libraries were found: %s. Use the -l argument to explicitly specify which you want to use" % (names[2:]))

        inform("The %s Qt library was found." % (qtLib))
    else:
        lib = isQtLibrary(qtlibdir,qtLib)

        if not lib:
            error("The %s Qt library could not be found in %s" % (qtLib,qtlibdir))

    if qtLib == "qt-mt":
        proPatches["THREAD"] = [re.compile("@BL_THREAD@",re.M), "thread"]
        inform("Qt thread support is enabled.")
    else:
        proPatches["THREAD"] = [re.compile("@BL_THREAD@",re.M), ""]
        inform("Qt thread support is disabled.")


def checkThreading ():
        qtmodlib = modDir + '/libqtcmodule.so'
        os.system ('ldd ' + qtmodlib + ' > lddtmp')
        f = open ('lddtmp', 'r')
        buff = f.read ()
        pat = re.compile("libqt\.so" ,re.M)
        if re.search (pat, buff) is None:
                pat = re.compile("libqt-mt\.so" ,re.M)
                if re.search (pat, buff) is None:
                        error ("Can't determine if PyQt uses libqt or libqt-mt")
                else:
                        threaded = TRUE
        else:
            threaded = FALSE

        if (not threaded and (kdeVersion < 300)) or (threaded and (kdeVersion >= 300)):
                inform ("Qt and KDE use compatible libs (threading)")
        else:
                error ("PyQt linked to Qt lib which is incompatible with KDE version (threading)")

        f.close ()
#        os.remove ('lddtmp')



def checkKDELibrary():
    """Check which Qt library is being used.
    """
    global kdeDir, kdeLib

    if kdeLib is None:
        kdelibdir = kdeDir + os.sep + "lib"
    else:
        kdelibdir = kdeLib

    ml = modList [str (kdeVersion) [0:2]]

    print '\nfound libs for modules:'
    print '    ',

    for lib in ml:
        if lib == 'dcop':
            libpath = kdelibdir + '/libDCOP.so'
	elif (lib == 'kfile') and (kdeVersion >= 300):
	    print 'kfile (kio)',
	    continue
        else:
            libpath = kdelibdir + '/lib' + lib + '.so'

        if not os.access(libpath, os.F_OK):
            print
            error ("%s not found" % libpath)
        else:
            print lib,

    proPatches["KDELIBS"] = [re.compile("@BL_KDEDIR@",re.M), kdelibdir]

    print

def checkPyQt ():
        """ Get the PyQt version info and locate the PyQt/sip directory
        """

        global pyQtSipDir

        if not pyQtSipDir:

            # report the actual PyQt version (NOT Qt version)
            try:
                from qt import PYQT_VERSION
            except:
                error ("Couldn't import qt module from PyQt")

            pyqt = 'PyQt-' + str(PYQT_VERSION)
	    print pyqt

            # search theses paths
            candidates = ["../", "/usr/local/", "/usr/local/src/", "/usr/src/", "/usr/share/sip", "/usr/local/share/sip"]


            for path in candidates:
                if path [-3:] == 'sip':
                    pyqtsipdir = path
                else:
                    pyqtsipdir = path + pyqt + '/sip'

                if os.access (path, os.F_OK):
                    if not os.access (pyqtsipdir + '/qtmod.sip', os.F_OK):
                        continue
                    pyQtSipDir = pyqtsipdir
                    break

        elif not (os.access (pyQtSipDir, os.F_OK) and os.access (pyQtSipDir + '/qtmod.sip', os.F_OK)):
            pyQtSipDir = None

        if not pyQtSipDir:
            error ("Couldn't find PyQt/sip directory")
        else:
            inform ("PyQt/sip directory found at %s" % pyQtSipDir)

def copySipFiles ():
        # copy the top-level sip module files (eg dcop.sip) for this version
        inform ("Copying sip module files for version KDE%s to sip directory" % str (kdeVersion))
        runProgram ("cp -f", ['sip/kde' + str (kdeVersion) [0:2] + '/*.sip', 'sip'])

        # copy the extraH files for this version
        inform ("Copying version specific h files for KDE%s to extraH directory" % str (kdeVersion))
        runProgram ("cp -f", ['extraH/kde' + str (kdeVersion) + '/*', 'extraH'])


def installChecks():
    """Carry out basic checks about the installation.
    """
    global proPatches, makefilePatches, pyFullVers

    inform("Building PyKDE 3.3 for Python %s on %s." % (pyFullVers,sys.platform))

    # Check we are in the top level directory.
    global progName

    if not os.access(progName,os.F_OK):
        error("This program must be run from the top level directory of the package, ie. the directory containing this program")

    # Check the installation directory is valid.
    global modDir

    if not os.access(modDir,os.F_OK):
        error("The %s PyKDE destination directory does not seem to exist. Use the -d argument to set the correct directory" % (modDir))

    proPatches["DESTDIR"] = [re.compile("@BL_DESTDIR@",re.M), modDir]

    inform("%s is the PyKDE installation directory." % (modDir))

    # Check that the Python header files have been installed.
    global platPyIncDir

    if not os.access(platPyIncDir + "/Python.h",os.F_OK):
        error("Python.h could not be found in %s. Make sure Python is fully installed, including any development packages" % (platPyIncDir))

    inform("%s contains Python.h." % (platPyIncDir))

    # Check that the Python library can be found.
    global platPyLib

    if platPyLib:
        if not os.access(platPyLib,os.F_OK):
            error("%s could not be found. Make sure Python is fully installed, including any development packages" % (platPyLib))

        proPatches["PYLIB"] = [re.compile("@BL_PYLIB@",re.M), platPyLib]

        inform("%s is installed." % (platPyLib))

    # Look for the SIP binary.
    global sipBin

    if sipBin is None:
        global platBinDir

        sipBin = searchPath("sip",platBinDir)
    elif not os.access(sipBin,os.X_OK):
        sipBin = None

    if sipBin is None:
        error("The SIP code generator could not be found. Use the -p argument to set the correct program")

    inform("%s will be used as the SIP code generator." % (sipBin))

    # Check that the SIP header files have been installed.
    global sipIncDir

    if not os.access(sipIncDir + "/sipQt.h",os.F_OK):
        error("sipQt.h could not be found in %s. Use the -e argument to set the correct directory" % (sipIncDir))

    inform("%s contains sipQt.h." % (sipIncDir))

    global sipModuleDir

    if sipModuleDir is None:
		global platPyScriptDir, platPyDLLDir, platPySiteDir

		dirlist = [platPyDLLDir, platPyScriptDir, platPySiteDir]
    else:
        dirlist = [sipModuleDir]
        sipModuleDir = None

    for d in dirlist:
        if glob.glob(d + "/libsip*"):
            sipModuleDir = d
            break

    if sipModuleDir is None:
        error("The SIP module/library could not be found. Use the -s argument to set the correct directory")

    proPatches["LIBS"] = [re.compile("@BL_SIPMODDIR@",re.M), sipModuleDir]

    inform("%s contains the SIP module." % (sipModuleDir))

    # Check the Qt installation.
    checkQtDirAndVersion()
    checkKDEDirAndVersion()

    # Look for the Makefile generator.
    checkMakefileGenerator()

    defines = ""

    proPatches["DEFINES"] = [re.compile("@BL_DEFINES@",re.M), defines]

    checkQtLibrary()
    checkThreading ()
    checkKDELibrary()
    checkPyQt ()

    # Look for Make.
    global makeBin, platMake

    if makeBin is None:
        makeBin = searchPath(platMake)
    elif not os.access(makeBin,os.X_OK):
        makeBin = None

    if makeBin is None:
        error("A make program could not be found. Use the -m argument to set the correct program")

    # For lib template project files.
    makefilePatches["MAKE_LIB"] = [re.compile("(^CC)",re.M), "MAKE     = \"" + makeBin + "\"\n\\1"]

    # For subdir template project files.
    makefilePatches["MAKE_SUBDIR"] = [re.compile("(^MAKEFILE)",re.M), "MAKE     = \"" + makeBin + "\"\n\\1"]

    inform("%s will be used as the make program." % (makeBin))


def checkMakefileGenerator():
    """Check that the Makefile generator can be found.
    """
    global makefileGen, usingTmake

    if makefileGen is None:
        global qtVersion

        if qtVersion >= 0x030000:
            mfg = "qmake"
        else:
            mfg = "tmake"

        xtradir = qtDir + "/bin"

        makefileGen = searchPath(mfg,xtradir)
    elif not os.access(makefileGen,os.X_OK):
        mfg = makefileGen
        makefileGen = None

    if makefileGen is None:
        error("The Makefile generator %s could not be found. Use the -g argument to set the correct program" % (mfg))

    if os.path.basename(makefileGen) in ("tmake", "tmake.exe"):
        usingTmake = 1

        # Make sure that references to tmake use the correct absolute pathname.
        makefilePatches["TMAKE1"] = [re.compile("(^TMAKE[ \t]*=).*$",re.M), "\\1 " + makefileGen]
        makefilePatches["TMAKE2"] = [re.compile("^\ttmake(.*)$",re.M), "\t" + makefileGen + "\\1"]

        # Add the install target for Makefiles generated from the subdirs
        # template.
        makefilePatches["TMAKE3"] = [re.compile("^(clean release debug):$",re.M), "\\1 install:"]

        # Remove the invocation of the tmake_all target.
        makefilePatches["TMAKE4"] = [re.compile(" tmake_all",re.M), ""]
    else:
        # Make sure that references to qmake use the correct absolute pathname.
        makefilePatches["QMAKE1"] = [re.compile("(^QMAKE[ \t]*=).*$",re.M), "\\1 \"" + makefileGen + "\""]

        # Remove the invocation of the qmake_all target.
        makefilePatches["QMAKE2"] = [re.compile(" qmake_all",re.M), ""]

    inform("%s will be used to generate Makefiles." % (makefileGen))

    # If it is tmake then make sure TMAKEPATH is set.
    if usingTmake:
        try:
            os.environ["TMAKEPATH"]
        except:
            error("tmake requires that the TMAKEPATH environment variable is properly set")


def compileChecks():
    """Tune the compiler flags, and see which PyQt modules to build.
    """
    # See if we can re-run make with some preferred options.  Don't do it for
    # Windows because we know the options aren't supported - and MSVC only
    # issues a warning so we can't detect the result properly anyway.
    if sys.platform != "win32":
        copyToFile("qttest.cpp",
"""int main(int argc,char **argv)
{
    return 0;
}
""")

        inform("Checking to see if the C++ compiler supports -fno-exceptions.")

        tmpPatches = {"CXXFLAGS": [re.compile("(^CXXFLAGS.*)$",re.M), "\\1 -fno-exceptions\n"]}
        patchFile("Makefile",tmpPatches,"Makefile.bak")

        if runMake(None,0):
            # Restore the old working Makefile.
            os.remove("Makefile")
            os.rename("Makefile.bak","Makefile")

            inform("The C++ compiler doesn't support -fno-exceptions.")
        else:
            global makefilePatches

            os.remove("Makefile.bak")

            makefilePatches["CXXFLAGS"] = [re.compile("(^CXXFLAGS.*)$",re.M), "\\1 -fno-exceptions\n"]

            inform("The C++ compiler supports -fno-exceptions.")


def generateFeatures(featfile):
    """Generate the header file describing the Qt features that are enabled if
    it doesn't already exist.  (If it already exists then we are probably cross
    compiling and generated the file through other means.)

    featfile is the name of the features file.
    """
    if os.access(featfile,os.F_OK):
        inform("Using existing features file.")
        return

    runMake("clean")

    inform("Generating the features file.")

    # The features that a given Qt configuration may or may not support.
    flist = ["ACTION", "CLIPBOARD", "CODECS", "COLORDIALOG", "DIAL", "DNS",
             "DOM", "DRAGANDDROP", "ICONVIEW", "IMAGE_TEXT", "INPUTDIALOG",
             "FILEDIALOG", "FONTDATABASE", "FONTDIALOG", "MESSAGEBOX",
             "MIMECLIPBOARD", "NETWORKPROTOCOL", "PICTURE", "PRINTDIALOG",
             "PRINTER", "PROGRESSDIALOG", "PROPERTIES", "SEMIMODAL",
             "SIZEGRIP", "SOUND", "SPLITTER", "STYLE_CDE", "STYLE_INTERLACE",
             "STYLE_MOTIF", "STYLE_MOTIFPLUS", "STYLE_PLATINUM", "STYLE_SGI",
             "STYLE_WINDOWS", "TABDIALOG", "TABLE", "TABLEVIEW",
             "TRANSFORMATIONS", "TRANSLATION", "WIZARD", "WORKSPACE"]

    # Generate the program which will generate the features file.
    f = open("qttest.cpp","w")

    f.write(
"""#include <stdio.h>
#include <Python.h>
#include <qglobal.h>
#include <qapplication.h>

int main(int argc,char **argv)
{
    FILE *fp;
    QApplication app(argc,argv,0);

    if ((fp = fopen(\"%s\",\"w\")) == NULL)
        return 1;

#if !defined(QT_THREAD_SUPPORT) || !defined(WITH_THREAD)
    fprintf(fp,"-x Qt_THREAD_SUPPORT\\n");
#endif
""" % (featfile))

    for feat in flist:
        f.write(
"""
#if defined(QT_NO_%s)
    fprintf(fp,"-x Qt_%s\\n");
#endif
""" % (feat,feat))

    f.write(
"""
    fclose(fp);

    return 0;
}
""")

    f.close()

    runMake()
    runProgram("qttest")

    inform("Generated the features file.")


def generateSource(mname,plattag,qttag,xtrtag = None):
    """Generate the C++ source code for a particular PyQt module.

    mname is the name of the module.
    plattag is the SIP tag for the platform.
    qttag is the SIP tag for the Qt version.
    xtrtag is an optional extra SIP tag.
    """
    inform("Generating the C++ source for the %s module." % (mname))

    try:
        shutil.rmtree(mname)
    except:
        pass

    try:
        os.mkdir(mname)
    except:
        error("Unable to create the %s directory" % (mname))

    pro = mname + ".pro"

    kdetag = makeVersion ('KDE', str (kdeVersion))

    global pyQtSipDir

    argv = ["-t", plattag,
            "-t", qttag,
            "-t", kdetag,
            "-z", "features",
            "-I", "sip",
            "-I", pyQtSipDir,
            "-m", mname + "/" + pro,
            "-c", mname,
            "sip/" + modules [mname] + ".sip"]

    if xtrtag:
        argv.insert(0,xtrtag)
        argv.insert(0,"-t")

#    print qttag, kdetag

    global sipBin
    runProgram (sipBin, argv)
    runProgram ("./postproc", ['-p', mname, "-o", "tr", "*.cpp"])

    if mname == "kdeui":
        runProgram ("./postproc", ["-p ", mname, "-o", "shpix",  "sipkdeuiKSharedPixmap.cpp"])

    elif (mname == "kjs") and (str (kdeVersion) [0:2] != '22'):
        f = open ('kjs/sipkjsKJSHashEntry.cpp', 'r')
        buff = f.read ()
        f.close ()

        buff = string.replace (buff, 'sipConvertFromVoidPtr(val)', 'sipConvertFromVoidPtr((void *)val)')
        f = open ('kjs/sipkjsKJSHashEntry.tmp', 'w')
        f.write (buff)
        f.close ()

        os.remove ('kjs/sipkjsKJSHashEntry.cpp')
        os.rename ('kjs/sipkjsKJSHashEntry.tmp', 'kjs/sipkjsKJSHashEntry.cpp')

    # Python names binary modules differently on different platforms.
    global proPatches, makefilePatches

    target = mname + "cmodule"

    # Generate the Makefile.
    inform("Generating the Makefile for the %s module." % (mname))

    olddir = pushDir(mname)

    proPatches["TARGET"] = [re.compile("@BL_TARGET@",re.M), target]

    global catCppFiles
    buildMakefile(pro,catCppFiles)

    fixInstallTarget(mname)
    del proPatches["TARGET"]

    if sys.platform == "win32":
        del makefilePatches["TARGET"]

    # Compile the Python part of the module.
    pyname = mname + ".py"

    inform("Compiling %s." % (pyname))
    py_compile.compile(pyname)

    popDir(olddir)


def pushDir(newdir):
    """Change to a new directory and return the old one.

    newdir is the new directory.
    """
    olddir = os.getcwd()
    os.chdir(newdir)

    return olddir


def popDir(olddir):
    """Change back to a previous directory.

    olddir is the old directory.
    """
    os.chdir(olddir)


def runProgram(prog,argv = [],fatal = 1):
    """Execute a program.

    prog is the name of the program.
    argv is the optional list of program arguments.
    fatal is non-zero if an error is considered fatal.

    Returns the error code.
    """
    # Use the basename to avoid problems with pathnames containing spaces.
# Huh?  argv.insert(0,os.path.basename(prog))

    try:
#        rc = os.spawnv (os.P_WAIT, prog, argv) <--- didn't work
	print prog + ' ' + string.join (argv)
        rc = os.system (prog + ' ' + string.join (argv))
#    except AttributeError:
#        print string.join (argv)
#        rc = os.system (string.join(argv))
    except:
        raise

    if rc != 0 and fatal:
        error("%s failed with an exit code of %d" % (prog,rc))

    return rc


def runMake(target = None,fatal = 1):
    """Run make.

    target is the optional make target.
    fatal is non-zero if an error is considered fatal.

    Returns the error code.
    """
    global makeBin

    if target is None:
        argv = []
    else:
        argv = [target]

    return runProgram(makeBin,argv,fatal)


def buildMakefile(pro,catcpp = 0):
    """Run qmake or tmake to create a Makefile from a project file.

    pro is the name of the project file.
    catcpp is non-zero if the project file is for a module whose C++ files are
    to be concatenated.
    """
    global makefileGen, proPatches, makefilePatches

    # Preserve the original project file.
    probak = pro + ".bak"
    patchFile(pro,proPatches,probak)

    if catcpp:
        catFiles(pro)

    runProgram(makefileGen,['-o', 'Makefile', pro])
    os.remove(pro)
    os.rename(probak,pro)

    patchFile("Makefile",makefilePatches)


def catFiles(pro):
    """Concatenate a modules C++ source files.

    pro is the name of the project file.
    """
    # Extract the module name from the project file name.
    mname = os.path.splitext(pro)[0]

    inform("Concatenating the C++ files for the %s module." % (mname))

    f = open(pro,"r")
    buf = f.read()
    f.close()

    pat = re.compile("^SOURCES =.*.cpp\n",re.M | re.S)
    match = re.search(pat,buf)
    srclist = buf[match.start(0):match.end(0)]
    srclist = srclist[13:-1]
    srclist = string.replace(srclist,"\\\n\t","")
    srclist = string.split(srclist," ")

    # Concatenate the files.
    d = open(mname + "huge.cpp","w")

    for cppfile in srclist:
        f = open(cppfile,"r")
        d.write(f.read())
        f.close()

    d.close()

    # Replace the C++ file names in the project file.
    buf = re.sub(pat,"SOURCES = " + mname + "huge.cpp\n",buf)

    f = open(pro + ".new","w")
    f.write(buf)
    f.close()

    os.remove(pro)
    os.rename(pro + ".new",pro)


def fixInstallTarget(mname = None):
    """Fix the install target for a Makefile.

    mname is the name of the PyQt module, or None if the target isn't for a
    module.
    """
    f = open("Makefile","a")
    f.write("\ninstall:\n")

    if mname:
        global modDir, platCopy

        f.write("\t-%s %s.py %s\n" % (platCopy,mname,modDir))
        f.write("\t-%s %s.pyc %s\n" % (platCopy,mname,modDir))

        if sys.platform == "win32":
            f.write("\t-del %s\\lib%sc.lib\n" % (modDir,mname))
            f.write("\t-del %s\\lib%sc.exp\n" % (modDir,mname))

    f.close()

def fileOpts (fn):
    try:
        optfile = open (fn, 'r')
    except:
        error ("Could not open option file %s" % (fn))

    opts = []
    lines = optfile.readlines ()

    for line in lines:
        if (line [0] == '#') or (line == '\n'):
           continue
        elif line [0] == '-':
            opts.append ((line [0:2], string.strip (line [2:])))
        else:
            opts.append ((line [0:1], string.strip (line [1:])))

    print 'Additional options: ',
    for opt, arg in opts:
        print opt, arg,
    print

    return opts


def main(argv):
    """The main function of the script.

    argv is the list of command line arguments.
    """
    import getopt

    # Parse the command line.
    global progName
    progName = os.path.basename(argv[0])

    initGlobals()

    try:
        optlist, args = getopt.getopt(argv[1:],"hcd:e:g:i:k:l:m:p:q:s:t:u:v:z:")
    except getopt.GetoptError:
        usage()

    # Look for '-z' first and process that switch
    # (command line switches override file switches)
    for opt, arg in optlist:
        if opt == "-z":
             optlist = fileOpts (arg) + optlist

    global makeBin, platBinDir, qtLib, qpeTag

    explicitMake = 0

    for opt, arg in optlist:
        if opt == "-h":
            usage(0)
        elif opt == "-c":
            global catCppFiles
            catCppFiles = 1
        elif opt == "-d":
            global modDir
            modDir = arg
        elif opt == "-e":
            global sipIncDir
            sipIncDir = arg
        elif opt == "-g":
            global makefileGen
            makefileGen = arg
        elif opt == "-i":
            global qtIncDir
            qtIncDir = arg
        elif opt == "-k":
            global kdeDir
            kdeDir = arg
        elif opt == "-l":
            if arg in ("qt", "qt-mt"):
                qtLib = arg
            else:
                usage()
        elif opt == "-m":
            makeBin = arg
            explicitMake = 1
        elif opt == "-p":
            global sipBin
            sipBin = arg
        elif opt == "-q":
            global qtDir
            qtDir = arg
        elif opt == "-s":
            global sipModuleDir
            sipModuleDir = arg
        elif opt == "-t":
            global kdeIncDir
            kdeIncDir = arg
        elif opt == "-u":
            global kdeLib
            kdeLib = arg
        elif opt == "-v":
            global pyQtSipDir
            pyQtSipDir = arg
        elif opt == "-z":
            pass

    installChecks()
    maindir = mkTempBuildDir()
    compileChecks()

    # Work out the platform and Qt version tags to pass to SIP to generate the
    # code we need.
    if qtLib == "qte":
        plattag = "WS_QWS"
    elif sys.platform == "win32":
        plattag = "WS_WIN"
    else:
        plattag = "WS_X11"

    qttags = {
        0x020000: "Qt_1_43",
        0x020100: "Qt_2_00",
        0x020200: "Qt_2_1_0",
        0x020300: "Qt_2_2_0",
        0x020301: "Qt_2_3_0",
        0x030000: "Qt_2_3_1",
        0x030001: "Qt_3_0_0",
        0x030002: "Qt_3_0_1",
        0x030004: "Qt_3_0_2",
        0x030005: "Qt_3_0_4",
        0x040000: "Qt_3_0_5"
    }


    global qtVersion
    qttag = None

    vl = qttags.keys()
    vl.sort()

    for v in vl:
        if qtVersion < v:
            qttag = qttags[v]
            break

    if qttag is None:
        error("Invalid Qt version: %d" % (qtVersion))

    # Generate the features file.
    generateFeatures(maindir + "/features")

    # We don't need the temporary build directory anymore.
    mkTempBuildDir(maindir)

    copySipFiles ()

#    global buildModules
    buildModules = modList [str (kdeVersion) [0:2]]
    subdirs = ""
    for mname in buildModules:
        generateSource(mname, plattag, qttag)
        subdirs = subdirs + " " + mname


    # Generate the top-level Makefile.
    inform("Creating top level Makefile.")
    copyToFile("PyQt.pro","TEMPLATE = subdirs\nSUBDIRS =" + subdirs + "\n")
    buildMakefile("PyQt.pro")

    # Tell the user what to do next.
    if explicitMake:
        mk = makeBin
    else:
        (mk,ignore) = os.path.splitext(os.path.basename(makeBin))

    msg = "The build of the PyKDE source code for your system is now complete. To compile and install PyKDE run \"%s\" and \"%s install\" with appropriate user privileges." % (mk,mk)

    inform(msg)


if __name__ == "__main__":
    try:
        main(sys.argv)
    except SystemExit:
        raise
    except:
        print \
"""An internal error occured.  Please report all the output from the program,
including the following traceback, to phil@riverbankcomputing.co.uk.
"""
        raise
