/***************************************************************************
                          ktransactionlistitem.cpp  -  description
                             -------------------
    begin                : Sun Sep 8 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
    $Id: ktransactionlistitem.cpp,v 1.4 2002/09/10 17:03:07 richard Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qdatetime.h>

#include "ktransactionlistitem.h"
#include "transaction.h"
#include "klocalizer.h"

KTransactionListItem::KTransactionListItem(KListView* parent, Transaction* t, int account)
  : KListViewItem(parent), m_debits(0), m_credits(0), m_priority(0)
{
  m_transaction = t;
  if ( t ) {
    m_date = t->date();
    setText(0, m_date.toString(Qt::LocalDate));
    if ( t->from() == account ) {
      m_debits = t->value();
      setText(1, l10n.formatMoney(m_debits));
    } else if ( t->to() == account ) {
      m_credits = t->value();
      setText(2, l10n.formatMoney(m_credits));
    }
    setText(3, t->description());
    setRenameEnabled(3, true);
  }
}

KTransactionListItem::KTransactionListItem(KListView* parent, QString description)
  : KListViewItem(parent)
{
  setText(3, description);
}

KTransactionListItem::~KTransactionListItem()
{
}

void KTransactionListItem::setTotals(float debits, float credits)
{
  setText(0, i18n("Total"));
  setText(1, l10n.formatMoney(debits));
  setText(2, l10n.formatMoney(credits));
  if ( !debits && !credits )
    setText(3, i18n("<no transactions>"));
  else
    setText(3, "");
}

void KTransactionListItem::setSortPriority(int priority)
{
  m_priority = priority;
}

int KTransactionListItem::compare(QListViewItem* i, int col, bool asc) const
{
  // we have to assume this will work
  KTransactionListItem* other = (KTransactionListItem*)i;

  if ( m_priority < other->m_priority )
    return -1;
  else if ( m_priority > other->m_priority )
    return 1;

  switch ( col ) {
  case 0:
    if ( m_date < other->m_date )
      return -1;
    else if ( m_date > other->m_date )
      return 1;
    break;
  case 1:
    if ( m_debits < other->m_debits )
      return -1;
    else if ( m_debits > other->m_debits )
      return 1;
    break;
  case 2:
    if ( m_credits < other->m_credits )
      return -1;
    else if ( m_credits > other->m_credits )
      return 1;
    break;
  case 3:
    if ( text(3) < other->text(3) )
      return -1;
    else if ( text(3) > other->text(3) )
      return 1;
    break;
  }

  if ( tid() < other->tid() )
    return -1;
  else if ( tid() > other->tid() )
    return 1;

  return 0;
}

int KTransactionListItem::tid() const
{
  if ( m_transaction )
    return m_transaction->id();
  else
    return -1;
}

void KTransactionListItem::okRename(int col)
{
  QListViewItem::okRename(col);
  if ( col == 3 )
    m_transaction->setDescription(text(3));
}
