// -*- c++ -*-
/***************************************************************************
                          pluginwidgetimpl.h  -  description
                             -------------------
    begin                : Sat Jun 8 2002
    copyright            : (C) 2002 by Kevin Hessels
    email                : khessels@shaw.ca
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef PLUGINWIDGETIMPL_H
#define PLUGINWIDGETIMPL_H

#include <qtabwidget.h>
#include "pluginfactory.h"
#include "pluginwidget.h"
#include "settingsdialogpage.h"

class Kdetv;
class ConfigData;
class KConfig;

/**
 * @author Kevin Hessels, George Staikos, Dirk Ziegelmeier
 */

class PluginWidgetImpl : public PluginWidget, public SettingsDialogPage
{
    Q_OBJECT
    
    
public: 
    PluginWidgetImpl(QWidget*, Kdetv*, ConfigData*);
    ~PluginWidgetImpl();


public slots:
    virtual void setup();
    virtual void apply();
    virtual void defaults();


private slots:
    void configureMiscPlugin();
    void configureVbiPlugin();
    void miscSelectionChanged();
    void vbiSelectionChanged();


private:
    Kdetv*      _ktv;
    ConfigData* _cfg;
};

#endif
