/*
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify 
 *   it under the terms of the GNU General Public License as published by 
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

//#include <qtabwidget.h>
#include <qregexp.h>
#include <qlayout.h>
#include <qheader.h>

#include <kdebug.h>
#include <klistview.h>
//#include <khtml_part.h>
//#include <khtmlview.h>
#include <klocale.h>

#include "channeleditor.h"
#include "kdetvwidget.h"
#include "viewmanager.h"

#include "sidebar.h"
#include "sidebar.moc"

Sidebar::Sidebar( QWidget *parent, const char *name )
    : QWidget( parent, name ),
      screen(0),
      chans(0),
      listPart(0),
      lists(0),
      cfg(0)
{
    //    connect( this, SIGNAL( currentChanged(QWidget *) ), SLOT( viewChanged(QWidget *) ) );
}

Sidebar::~Sidebar()
{

}

void Sidebar::viewChanged( QWidget *view )
{
    if ( !view )
	return;

    QString s = view->caption();
    s = s.replace( QRegExp("&"), QString("") );
    setCaption( s );
}

void Sidebar::createViews()
{
    if ( !screen ) {
	kdWarning() << "Sidebar::createViews() Called when screen is 0" << endl;
	return;
    }

    //
    // Layout sidebar
    //
    createChannels();
    //    if ( chans ) addTab( chans, chans->caption() );

    if (chans) {
	QHBoxLayout* l = new QHBoxLayout(this);
	l->addWidget(chans);
    }

    /*
    // Get the configuration
    cfg = screen->views()->getConfig();
    if( !cfg ) kdDebug() << "Sidebar::createViews() unable to read config!" << endl;

    createListings();
    if ( lists ) addTab( lists, lists->caption() );

    connect( screen->views(), SIGNAL( getNewListingsURL( QString * ) ),
             this, SLOT( listingsURLChanged( QString * ) ) );
    connect( screen->views(), SIGNAL( useListingsURL( bool ) ),
             this, SLOT( useListingsURL ( bool ) ) );

    // Enable or disable the listings tab according to configuration

    setTabEnabled( lists, cfg->useListingsURL );
    */
}

ChannelEditor *Sidebar::createChannels()
{
    chans = screen->views()->createChannelEditor( this );
    chans->setCaption( i18n("&Channels") );

    chans->header()->hide();
    chans->setChannels( screen->channels() );
    connect( chans, SIGNAL( channelSelected(Channel*) ), 
             screen->driver(), SLOT( setChannel(Channel*) ) );
    connect( screen->views(), SIGNAL( showSelectedChanged(bool) ),
             chans, SLOT( slotSetShowSelectedOnly(bool) ) );

    return chans;
}

/*
QWidget *Sidebar::createListings()
{
    listPart = new KHTMLPart( this );
    if (!listPart) return NULL;
    if ( (cfg->listingsURL.isNull()) || (cfg->listingsURL.isEmpty()) ) {
        QString s("file:%1/%2");
        listPart->openURL( KURL(s.arg(QDir::currentDirPath()).arg("onechannel.html")) );
    } else {	
        listPart->openURL( KURL( cfg->listingsURL ) );
    }
    
    lists = static_cast<KHTMLView *>( listPart->widget() );
    lists->setCaption( i18n("&Listings") );
    return lists;
}

void Sidebar::useListingsURL( bool useURL )
{
   if( lists ) setTabEnabled( lists, useURL );

   if( useURL ) {
	listingsURLChanged( &screen->views()->getConfig()->listingsURL );
   }
}

void Sidebar::listingsURLChanged( QString *url )
{
   if( listPart && lists ) {
	if ( !url->isNull() && !url->isEmpty() ) {
	    listPart->openURL( KURL( *url ) );
	    lists = static_cast<KHTMLView *>( listPart->widget() );
	}
   }
}
*/
 
void Sidebar::toggleView( bool v )
{
    if ( v )
        show();
    else
        hide();
}

void Sidebar::hideEvent(QHideEvent* e)
{
    emit visibilityChanged(false);
    QWidget::hideEvent(e);
}

void Sidebar::showEvent(QShowEvent* e)
{
    emit visibilityChanged(true);
    QWidget::showEvent(e);
}
