/***************************************************************************
                           qvvbiplugin.h
                           -------------
    begin                : Sun Oct 26 2003
    copyright            : (C) 2003 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __KDETVVBIPLUGIN_H
#define __KDETVVBIPLUGIN_H

#include "kdetvpluginbase.h"

class QString;

class KdetvVbiPlugin : public KdetvPluginBase
{
    Q_OBJECT


public:
    KdetvVbiPlugin(Kdetv *ktv, const QString& cfgkey, QObject *parent, const char* name=0);
    virtual ~KdetvVbiPlugin();

    /// Restart decoder (useful if decoder has norm autodetection)
    virtual bool restart() = 0;

    /// Returns whether decoder is _running_ (!= receiving data)
    virtual bool decoding() const = 0;

    /// Returns whether a station is tuned. VBI reception may occur if broadcasted.
    virtual bool tuned() const = 0;

    /// Returns pointer to internal decoder data. Platform specific!!!
    void* decoder() const { return _dec; };


protected:
    void* _dec;
};

#endif
