//////////////////////////////////////////////////////////////////////////////
//
//    KEXIFUTILS.H
//
//    Copyright (C) 2002-2004 Renchi Raju <renchi at pooh.tam.uiuc.edu>
//                            Gilles CAULIER <caulier dot gilles at free.fr>
//                            Ralf Hoelzer <kde at ralfhoelzer.com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//////////////////////////////////////////////////////////////////////////////

#ifndef KEXIFUTILS_H
#define KEXIFUTILS_H

#include <qstring.h>

#include "kexifdata.h"

class KExifUtils {

public:

    static bool writeOrientation(const QString& filename, KExifData::ImageOrientation orientation);
    static bool writeComment(const QString& filename, const QString& comment);
    static bool writeFile(const QString& filename, const QString& comment, enum KExifData::ImageOrientation orientation); 

};

#endif
