/**
 * grouptoken.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef KONFIG_GROUPTOKEN_H
#define KONFIG_GROUPTOKEN_H

#include "token.h"

#include <qdict.h>

namespace KConfigEditor
{

    class ConfigurationView;
    class EntryToken;
    class GroupToken : public Token
    {
    public:
        GroupToken( const QString &protocol, const QString &name );
        ~GroupToken();

        EntryToken* entry( const QString &name ) const;
        EntryToken* entryContaining( const QString &str ) const;

        virtual bool isGroup() const { return true; }

        /**
         * Creates a new child entry in this group.
         */
        EntryToken *createEntry( const QString &name, const QString &type, bool hidden=false );
        /**
         * Removes an entry with the specified name.
         */
        bool removeEntry( const QString & );

        /**
         * Creates a new group which is a child of this group.
         *
         */
        GroupToken *createGroup( const QString &name );

        /**
         * Returns the group with the given name or 0 if the group
         * doesn't exist
         */
        GroupToken *group( const QString &name ) const;

        /**
         * Returns the parent of this group.
         */
        GroupToken *parent() const { return m_parent; }

        /**
         * Returns true if this group is a top level group.
         */
        bool isTopLevel() const { return !m_parent; }

        void entryModified( GroupToken *group, EntryToken *entry );
        void entryRemoved( GroupToken *group, EntryToken *entry );
        void entryRestored( GroupToken *group, EntryToken *entry );

        void propagateChanges( bool doPropagate );

        virtual bool hasPendingChanges() const {
            return m_modified;
        }

        virtual void prunePendingChanges();

        virtual void restoreToken( const KURL &entry, QStringList &paths );

        virtual void attach(  ConfigurationView *view );

        QDict<EntryToken> &childEntries() { return m_entryDict; }
        QDict<GroupToken> &childGroups() { return m_childDict; }
        QDict<EntryToken> &modifiedEntries() { return m_modifiedEntries; }
        QDict<EntryToken> &sessionModifiedEntries() { return m_sessionChanges; }

    protected:
        GroupToken( GroupToken *parent, const QString &name, bool readOnly );

    private:
        GroupToken *m_parent;
        bool        m_propagate;
        QDict<GroupToken> m_childDict;
        QDict<EntryToken> m_entryDict;

        QDict<EntryToken> m_modifiedEntries;
        QDict<EntryToken> m_removedEntries;
        QDict<EntryToken> m_sessionChanges;
        QDict<GroupToken> m_modifiedGroups;
    };

}


#endif
