/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.IntSequence;
import gnu.lists.SimpleVector;

public class BitVector
extends SimpleVector<Boolean>
implements Comparable {
    boolean[] data;
    protected static boolean[] empty = new boolean[0];

    public BitVector() {
        this.data = empty;
    }

    public BitVector(int size, boolean value) {
        boolean[] array = new boolean[size];
        this.data = array;
        if (value) {
            while (--size >= 0) {
                array[size] = value;
            }
        }
    }

    public BitVector(int size) {
        this(new boolean[size]);
    }

    public BitVector(boolean[] data) {
        this.data = data;
    }

    public BitVector(boolean[] data, IntSequence indexes) {
        this.data = data;
        this.indexes = indexes;
    }

    public BitVector(boolean[] values, int offset, int length) {
        this(length);
        System.arraycopy(values, offset, this.data, 0, length);
    }

    @Override
    public int getBufferLength() {
        return this.data.length;
    }

    @Override
    public void setBufferLength(int length) {
        int oldLength = this.data.length;
        if (oldLength != length) {
            boolean[] tmp = new boolean[length];
            System.arraycopy(this.data, 0, tmp, 0, oldLength < length ? oldLength : length);
            this.data = tmp;
        }
    }

    public boolean[] getBuffer() {
        return this.data;
    }

    @Override
    protected void setBuffer(Object buffer) {
        this.data = (boolean[])buffer;
    }

    public final boolean booleanAt(int index) {
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        return this.data[index];
    }

    public final boolean booleanAtBuffer(int index) {
        return this.data[index];
    }

    @Override
    public final Boolean get(int index) {
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        return this.data[index];
    }

    @Override
    public final Boolean getBuffer(int index) {
        return this.data[index];
    }

    public final void setBooleanAt(int index, boolean value) {
        this.checkCanWrite();
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        this.data[index] = value;
    }

    public final void setBooleanAtBuffer(int index, boolean value) {
        this.data[index] = value;
    }

    @Override
    public final void setBuffer(int index, Boolean value) {
        this.data[index] = value;
    }

    public void add(boolean v) {
        int sz = this.size();
        this.addSpace(sz, 1);
        this.setBooleanAt(sz, v);
    }

    @Override
    protected void clearBuffer(int start, int count) {
        boolean[] d = this.data;
        while (--count >= 0) {
            d[start++] = false;
        }
    }

    protected BitVector withIndexes(IntSequence ind) {
        return new BitVector(this.data, ind);
    }

    @Override
    public BitVector subList(int fromIx, int toIx) {
        return new BitVector(this.data, this.indexesSubList(fromIx, toIx));
    }

    public int getElementKind() {
        return 27;
    }

    @Override
    public String getTag() {
        return "b";
    }

    @Override
    public void consumePosRange(int iposStart, int iposEnd, Consumer out) {
        if (out.ignoring()) {
            return;
        }
        int end = this.nextIndex(iposEnd);
        for (int i = this.nextIndex(iposStart); i < end; ++i) {
            out.writeBoolean(this.booleanAt(i));
        }
    }

    public int compareTo(Object obj) {
        BitVector vec2 = (BitVector)obj;
        boolean[] arr1 = this.data;
        boolean[] arr2 = vec2.data;
        int n1 = this.size();
        int n2 = vec2.size();
        IntSequence inds1 = this.getIndexesForce();
        IntSequence inds2 = vec2.getIndexesForce();
        int n = n1 > n2 ? n2 : n1;
        for (int i = 0; i < n; ++i) {
            boolean v2;
            boolean v1 = arr1[inds1.intAt(i)];
            if (v1 == (v2 = arr2[inds2.intAt(i)])) continue;
            return v1 && !v2 ? 1 : -1;
        }
        return n1 - n2;
    }
}

