/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpVisitor;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushApply
extends ExpVisitor<Expression, Void> {
    public static void pushApply(Expression exp, Compilation comp) {
        PushApply visitor = new PushApply();
        visitor.setContext(comp);
        visitor.visit(exp, null);
    }

    @Override
    protected Expression update(Expression exp, Expression r) {
        return r;
    }

    @Override
    protected Expression defaultValue(Expression r, Void ignored) {
        return r;
    }

    @Override
    protected Expression visitApplyExp(ApplyExp exp, Void ignored) {
        Declaration fdecl;
        boolean isApplyFunc;
        Expression func = exp.func;
        boolean bl = isApplyFunc = this.getCompilation().isApplyFunction(func) && exp.getArgCount() > 0;
        if (isApplyFunc) {
            func = exp.getArg(0);
        }
        if (func instanceof ReferenceExp && (fdecl = ((ReferenceExp)func).getBinding()) != null && !fdecl.hasUnknownValue()) {
            fdecl.addCaller(exp);
        }
        if (func instanceof LetExp && !(func instanceof FluidLetExp)) {
            LetExp let2 = (LetExp)func;
            Expression body = let2.body;
            let2.body = exp;
            if (isApplyFunc) {
                exp.args[0] = body;
            } else {
                exp.func = body;
            }
            return (Expression)this.visit(let2, ignored);
        }
        if (func instanceof BeginExp) {
            BeginExp begin2 = (BeginExp)func;
            Expression[] stmts = begin2.exps;
            int last_index = begin2.exps.length - 1;
            if (isApplyFunc) {
                exp.args[0] = stmts[last_index];
            } else {
                exp.func = stmts[last_index];
            }
            stmts[last_index] = exp;
            return (Expression)this.visit(begin2, ignored);
        }
        exp.visitChildren(this, ignored);
        return exp;
    }

    @Override
    protected Expression visitReferenceExp(ReferenceExp exp, Void ignored) {
        Declaration decl = exp.getBinding();
        if (decl != null) {
            ++decl.numReferences;
            if (decl.context instanceof LetExp) {
                LambdaExp innerLambda;
                ScopeExp sc = innerLambda = this.getCurrentLambda();
                while (sc != null) {
                    if (sc == decl.context) {
                        exp.siblingReferencesNext = innerLambda.siblingReferences;
                        innerLambda.siblingReferences = exp;
                        break;
                    }
                    if (sc instanceof LambdaExp) {
                        innerLambda = sc;
                    }
                    sc = sc.outer;
                }
            }
        }
        return (Expression)super.visitReferenceExp(exp, ignored);
    }

    @Override
    protected Expression visitClassExp(ClassExp exp, Void ignored) {
        exp.declareParts(this.getCompilation());
        return (Expression)this.visitLambdaExp(exp, ignored);
    }
}

