/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.Type;
import gnu.expr.Declaration;
import gnu.expr.Keyword;
import gnu.expr.LambdaExp;
import gnu.expr.ScopeExp;
import gnu.expr.Special;
import gnu.lists.LList;
import gnu.mapping.CallContext;
import gnu.mapping.Location;
import gnu.mapping.MethodProc;
import java.lang.reflect.Array;

class Closure
extends MethodProc {
    Object[][] evalFrames;
    LambdaExp lambda;

    public int numArgs() {
        return this.lambda.min_args | this.lambda.max_args << 12;
    }

    public Closure(LambdaExp lexp, CallContext ctx) {
        this.lambda = lexp;
        Object[][] oldFrames = ctx.evalFrames;
        if (oldFrames != null) {
            int n;
            for (n = oldFrames.length; n > 0 && oldFrames[n - 1] == null; --n) {
            }
            this.evalFrames = new Object[n][];
            System.arraycopy(oldFrames, 0, this.evalFrames, 0, n);
        }
        this.setSymbol(this.lambda.getSymbol());
    }

    public int match0(CallContext ctx) {
        return this.matchN(new Object[0], ctx);
    }

    public int match1(Object arg1, CallContext ctx) {
        return this.matchN(new Object[]{arg1}, ctx);
    }

    public int match2(Object arg1, Object arg2, CallContext ctx) {
        return this.matchN(new Object[]{arg1, arg2}, ctx);
    }

    public int match3(Object arg1, Object arg2, Object arg3, CallContext ctx) {
        return this.matchN(new Object[]{arg1, arg2, arg3}, ctx);
    }

    public int match4(Object arg1, Object arg2, Object arg3, Object arg4, CallContext ctx) {
        return this.matchN(new Object[]{arg1, arg2, arg3, arg4}, ctx);
    }

    public int matchN(Object[] args, CallContext ctx) {
        int nargs = args.length;
        int num = this.numArgs();
        int min = num & 0xFFF;
        if (nargs < min) {
            return 0xFFF10000 | min;
        }
        int max = num >> 12;
        if (nargs > max && max >= 0) {
            return 0xFFF20000 | max;
        }
        Object[] evalFrame = new Object[this.lambda.frameSize];
        int key_args = this.lambda.keywords == null ? 0 : this.lambda.keywords.length;
        int opt_args = this.lambda.opt_args;
        int i = 0;
        int key_i = 0;
        int min_args = this.lambda.min_args;
        for (Declaration decl = this.lambda.firstDecl(); decl != null; decl = decl.nextDecl()) {
            Object value;
            if (i < min_args) {
                value = args[i++];
            } else if (i < min_args + opt_args) {
                value = i < nargs ? args[i++] : this.lambda.evalDefaultArg(decl, ctx);
            } else if (this.lambda.max_args < 0 && i == min_args + opt_args) {
                if (decl.type instanceof ArrayType) {
                    int rem = nargs - i;
                    Type elementType = ((ArrayType)decl.type).getComponentType();
                    if (elementType == Type.objectType) {
                        Object[] rest = new Object[rem];
                        System.arraycopy(args, i, rest, 0, rem);
                        value = rest;
                    } else {
                        Class elementClass = elementType.getReflectClass();
                        value = Array.newInstance(elementClass, rem);
                        for (int j = 0; j < rem; ++j) {
                            Object el;
                            try {
                                el = elementType.coerceFromObject(args[i + j]);
                            }
                            catch (ClassCastException ex) {
                                return 0xFFF40000 | i + j;
                            }
                            Array.set(value, j, el);
                        }
                    }
                } else {
                    value = LList.makeList(args, i);
                }
            } else {
                Keyword keyword;
                int key_offset = min_args + opt_args;
                if ((value = Keyword.searchForKeyword(args, key_offset, keyword = this.lambda.keywords[key_i++])) == Special.dfault) {
                    value = this.lambda.evalDefaultArg(decl, ctx);
                }
            }
            if (decl.type != null) {
                try {
                    value = decl.type.coerceFromObject(value);
                }
                catch (ClassCastException ex) {
                    return 0xFFF40000 | i;
                }
            }
            if (decl.isIndirectBinding()) {
                Location loc = decl.makeIndirectLocationFor();
                loc.set(value);
                value = loc;
            }
            evalFrame[decl.evalIndex] = value;
        }
        ctx.values = evalFrame;
        ctx.where = 0;
        ctx.next = 0;
        ctx.proc = this;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(CallContext ctx) throws Throwable {
        int numFrames;
        int level = ScopeExp.nesting(this.lambda);
        Object[] evalFrame = ctx.values;
        Object[][] saveFrames = ctx.evalFrames;
        int n = numFrames = this.evalFrames == null ? 0 : this.evalFrames.length;
        if (level >= numFrames) {
            numFrames = level;
        }
        Object[][] newFrames = new Object[numFrames += 10][];
        if (this.evalFrames != null) {
            System.arraycopy(this.evalFrames, 0, newFrames, 0, this.evalFrames.length);
        }
        newFrames[level] = evalFrame;
        ctx.evalFrames = newFrames;
        try {
            if (this.lambda.body == null) {
                StringBuffer sbuf = new StringBuffer("procedure ");
                String name = this.lambda.getName();
                if (name == null) {
                    name = "<anonymous>";
                }
                sbuf.append(name);
                int line = this.lambda.getLineNumber();
                if (line > 0) {
                    sbuf.append(" at line ");
                    sbuf.append(line);
                }
                sbuf.append(" was called before it was expanded");
                throw new RuntimeException(sbuf.toString());
            }
            this.lambda.body.apply(ctx);
        }
        finally {
            ctx.evalFrames = saveFrames;
        }
    }

    public Object getProperty(Object key, Object defaultValue) {
        Object value = super.getProperty(key, defaultValue);
        if (value == null) {
            value = this.lambda.getProperty(key, defaultValue);
        }
        return value;
    }
}

