/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.kawa.functions.Arithmetic;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.PropertySet;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RatNum;
import gnu.math.RealNum;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class DivideOp
extends ProcedureN {
    public static final int GENERIC = 0;
    public static final int DIVIDE_INEXACT = 1;
    public static final int QUOTIENT = 2;
    public static final int QUOTIENT_EXACT = 3;
    public static final int MODULO = 4;
    int op;
    int rounding_mode;
    public static final DivideOp $Sl = new DivideOp("/");
    public static final DivideOp idiv = new DivideOp("idiv");
    public static final DivideOp quotient = new DivideOp("quotient");
    public static final DivideOp remainder = new DivideOp("remainder");
    public static final DivideOp modulo = new DivideOp("modulo");
    public static final DivideOp div = new DivideOp("div");
    public static final DivideOp mod = new DivideOp("mod");
    public static final DivideOp div0 = new DivideOp("div0");
    public static final DivideOp mod0 = new DivideOp("mod0");

    public int getRoundingMode() {
        return this.rounding_mode;
    }

    public DivideOp(String name) {
        super(name);
        Procedure.inlineCallsKey.set((PropertySet)this, "*gnu.kawa.functions.CompileArith:forDiv");
        Procedure.compilerKey.set((PropertySet)this, "*gnu.kawa.functions.CompileArith:forDiv");
    }

    public Object applyN(Object[] args) throws Throwable {
        int len = args.length;
        if (len == 0) {
            return IntNum.one();
        }
        Number result = (Number)args[0];
        if (len == 1) {
            return this.apply2(IntNum.one(), result);
        }
        int code = Arithmetic.classifyValue(result);
        block51: for (int i = 1; i < len; ++i) {
            Object arg2 = args[i];
            int code2 = Arithmetic.classifyValue(arg2);
            int scode = code = code < code2 ? code2 : code;
            if (code < 4) {
                switch (this.op) {
                    case 0: 
                    case 1: {
                        code = 4;
                        scode = 4;
                        break;
                    }
                    default: {
                        if (this.rounding_mode == 3 && (code == 1 || code == 2)) break;
                        scode = 4;
                    }
                }
            }
            if (this.op == 1 && code <= 10) {
                scode = 10;
                if (code != 8 && code != 7) {
                    code = 9;
                }
            } else if (scode == 8 || scode == 7) {
                scode = 9;
                if (this.op == 3) {
                    code = scode;
                }
            }
            block3 : switch (scode) {
                case 1: {
                    int i1 = Arithmetic.asInt(result);
                    int i2 = Arithmetic.asInt(arg2);
                    switch (this.op) {
                        case 4: {
                            i1 %= i2;
                            break;
                        }
                        default: {
                            i1 /= i2;
                        }
                    }
                    result = i1;
                    break;
                }
                case 2: {
                    long l1 = Arithmetic.asLong(result);
                    long l2 = Arithmetic.asLong(arg2);
                    switch (this.op) {
                        case 4: {
                            l1 %= l2;
                            break;
                        }
                        default: {
                            l1 /= l2;
                        }
                    }
                    result = l1;
                    break;
                }
                case 4: {
                    switch (this.op) {
                        case 2: 
                        case 3: {
                            result = IntNum.quotient(Arithmetic.asIntNum(result), Arithmetic.asIntNum(arg2), this.getRoundingMode());
                            break;
                        }
                        case 4: {
                            result = IntNum.remainder(Arithmetic.asIntNum(result), Arithmetic.asIntNum(arg2), this.getRoundingMode());
                            break;
                        }
                        case 0: {
                            result = RatNum.make(Arithmetic.asIntNum(result), Arithmetic.asIntNum(arg2));
                            scode = code = result instanceof IntNum ? 4 : 6;
                        }
                    }
                    break;
                }
                case 5: {
                    RoundingMode mround;
                    BigDecimal bd1 = Arithmetic.asBigDecimal(result);
                    BigDecimal bd2 = Arithmetic.asBigDecimal(arg2);
                    int mprec = 0;
                    switch (this.getRoundingMode()) {
                        case 1: {
                            mround = RoundingMode.FLOOR;
                            break;
                        }
                        case 2: {
                            mround = RoundingMode.CEILING;
                            break;
                        }
                        case 3: {
                            mround = RoundingMode.DOWN;
                            break;
                        }
                        case 5: {
                            mround = bd2.signum() < 0 ? RoundingMode.CEILING : RoundingMode.FLOOR;
                        }
                        default: {
                            mround = RoundingMode.HALF_EVEN;
                        }
                    }
                    MathContext mcontext = new MathContext(mprec, mround);
                    switch (this.op) {
                        case 0: {
                            result = bd1.divide(bd2);
                            break;
                        }
                        case 2: {
                            result = bd1.divideToIntegralValue(bd2, mcontext);
                            break;
                        }
                        case 3: {
                            result = bd1.divideToIntegralValue(bd2, mcontext).toBigInteger();
                            scode = 3;
                            code = 3;
                            break;
                        }
                        case 4: {
                            result = bd1.remainder(bd2, mcontext);
                        }
                    }
                    break;
                }
                case 9: {
                    double d1 = Arithmetic.asDouble(result);
                    double d2 = Arithmetic.asDouble(arg2);
                    switch (this.op) {
                        case 0: 
                        case 1: {
                            result = DFloNum.make(d1 / d2);
                            break;
                        }
                        case 2: {
                            result = RealNum.toInt(d1 / d2, this.getRoundingMode());
                            break;
                        }
                        case 3: {
                            result = RealNum.toExactInt(d1 / d2, this.getRoundingMode());
                            scode = 4;
                            code = 4;
                            break;
                        }
                        case 4: {
                            if (d2 != 0.0) {
                                d1 -= RealNum.toInt(d1 / d2, this.getRoundingMode()) * d2;
                            }
                            result = DFloNum.make(d1);
                        }
                    }
                    break;
                }
                default: {
                    Numeric num1 = Arithmetic.asNumeric(result);
                    Numeric num2 = Arithmetic.asNumeric(arg2);
                    if (this.op == 4 && num2.isZero()) {
                        return num2.isExact() ? num1 : num1.toInexact();
                    }
                    Numeric numr = num1.div(num2);
                    if (this.op == 4) {
                        numr = num1.sub(((RealNum)numr).toInt(this.getRoundingMode()).mul(num2));
                    }
                    switch (this.op) {
                        case 3: {
                            result = ((RealNum)numr).toExactInt(this.rounding_mode);
                            code = 4;
                            scode = 4;
                            break block3;
                        }
                        case 2: {
                            result = ((RealNum)numr).toInt(this.rounding_mode);
                            break block3;
                        }
                        case 1: {
                            result = numr.toInexact();
                            break block3;
                        }
                    }
                    result = numr;
                }
            }
            if (code == scode) continue;
            switch (code) {
                case 1: {
                    result = result.intValue();
                    continue block51;
                }
                case 2: {
                    result = result.longValue();
                    continue block51;
                }
                case 7: {
                    result = Float.valueOf(result.floatValue());
                    continue block51;
                }
                case 8: {
                    result = result.doubleValue();
                    continue block51;
                }
                case 3: {
                    result = Arithmetic.asBigInteger(result);
                }
            }
        }
        return result;
    }

    public int numArgs() {
        return this.op == 0 ? -4095 : 8194;
    }

    static {
        DivideOp.idiv.op = 3;
        DivideOp.idiv.rounding_mode = 3;
        DivideOp.quotient.op = 2;
        DivideOp.quotient.rounding_mode = 3;
        DivideOp.remainder.op = 4;
        DivideOp.remainder.rounding_mode = 3;
        DivideOp.modulo.op = 4;
        DivideOp.modulo.rounding_mode = 1;
        DivideOp.div.op = 2;
        DivideOp.div.rounding_mode = 5;
        DivideOp.mod.op = 4;
        DivideOp.mod.rounding_mode = 5;
        DivideOp.div0.op = 2;
        DivideOp.div0.rounding_mode = 4;
        DivideOp.mod0.op = 4;
        DivideOp.mod0.rounding_mode = 4;
    }
}

