import os

ABS_WORK_DIR = os.path.join(os.getcwd(), "build")
NEW_ESR_REPO = "ssh://hg.mozilla.org/releases/mozilla-esr52"
OLD_ESR_REPO = "https://hg.mozilla.org/releases/mozilla-esr45"
OLD_ESR_CHANGESET = "d2d75f526882"

config = {
    "log_name": "relese_to_esr",
    "version_files": [
        {"file": "browser/config/version.txt", "suffix": ""},
        {"file": "browser/config/version_display.txt", "suffix": ""},
        {"file": "config/milestone.txt", "suffix": ""},
    ],
    "replacements": [
        # File, from, to
        ("browser/confvars.sh",
         "ACCEPTED_MAR_CHANNEL_IDS=icecat-mozilla-release",
         "ACCEPTED_MAR_CHANNEL_IDS=icecat-mozilla-esr"),
        ("browser/confvars.sh",
         "MAR_CHANNEL_ID=icecat-mozilla-release",
         "MAR_CHANNEL_ID=icecat-mozilla-esr"),
        ("build/mozconfig.common",
         "# Enable checking that add-ons are signed by the trusted root",
         "# Disable checking that add-ons are signed by the trusted root"),
        ("build/mozconfig.common",
         "MOZ_ADDON_SIGNING=${MOZ_ADDON_SIGNING-1}",
         "MOZ_ADDON_SIGNING=${MOZ_ADDON_SIGNING-0}"),
        ("build/mozconfig.common",
         "# Enable enforcing that add-ons are signed by the trusted root",
         "# Disable enforcing that add-ons are signed by the trusted root"),
        ("build/mozconfig.common",
         "MOZ_REQUIRE_SIGNING=${MOZ_REQUIRE_SIGNING-1}",
         "MOZ_REQUIRE_SIGNING=${MOZ_REQUIRE_SIGNING-0}"),
    ],
    "vcs_share_base": os.path.join(ABS_WORK_DIR, 'hg-shared'),
    # "hg_share_base": None,
    "tools_repo_url": "https://hg.mozilla.org/build/tools",
    "tools_repo_branch": "default",
    "from_repo_url": "ssh://hg.mozilla.org/releases/mozilla-release",
    "to_repo_url": NEW_ESR_REPO,

    "base_tag": "ICECAT_ESR_%(major_version)s_BASE",
    "end_tag": "ICECAT_ESR_%(major_version)s_END",

    "migration_behavior": "release_to_esr",
    "require_remove_locales": False,
    "transplant_patches": [
        {"repo": OLD_ESR_REPO,
         "changeset": OLD_ESR_CHANGESET},
    ],
    "requires_head_merge": False,
    "pull_all_branches": True,
}
