// Note: For maximum-speed code, see "Optimizing Code" on the Emscripten wiki, https://github.com/kripken/emscripten/wiki/Optimizing-Code
// Note: Some Emscripten settings may limit the speed of the generated code.
// The Module object: Our interface to the outside world. We import
// and export values on it, and do the work to get that through
// closure compiler if necessary. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to do an eval in order to handle the closure compiler
// case, where this code here is minified but Module was defined
// elsewhere (e.g. case 4 above). We also need to check if Module
// already exists (e.g. case 3 above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module;
if (!Module) Module = eval('(function() { try { return Module || {} } catch(e) { return {} } })()');
// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
for (var key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}
// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var printedOutput = "";
Module['print'] = function f(str) {
    printedOutput += str;
}
if (typeof printErr != 'undefined') Module['printErr'] = printErr; // not present in v8 or older sm
if (typeof read != 'undefined') {
Module['read'] = read;
} else {
Module['read'] = function() { throw 'no read() available (jsc?)' };
}
Module['readBinary'] = function(f) {
return read(f, 'binary');
};
if (typeof scriptArgs != 'undefined') {
Module['arguments'] = scriptArgs;
} else if (typeof arguments != 'undefined') {
Module['arguments'] = arguments;
}
this['Module'] = Module;
function globalEval(x) {
  eval.call(null, x);
}
if (!Module['load'] == 'undefined' && Module['read']) {
  Module['load'] = function(f) {
    globalEval(Module['read'](f));
  };
}
if (!Module['printErr']) {
  Module['printErr'] = Module['print'];
}
// *** Environment setup code ***
// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];
// Callbacks
Module['preRun'] = [];
Module['postRun'] = [];
// Merge back in the overrides
for (var key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}
// === Auto-generated preamble library stuff ===
//========================================
// Runtime code shared with compiler
//========================================
var Runtime = {
  stackSave: function () {
    return STACKTOP;
  },
  stackRestore: function (stackTop) {
    STACKTOP = stackTop;
  },
  forceAlign: function (target, quantum) {
    quantum = quantum || 4;
    if (quantum == 1) return target;
    if (isNumber(target) && isNumber(quantum)) {
      return Math.ceil(target/quantum)*quantum;
    } else if (isNumber(quantum) && isPowerOfTwo(quantum)) {
      var logg = log2(quantum);
      return '((((' +target + ')+' + (quantum-1) + ')>>' + logg + ')<<' + logg + ')';
    }
    return 'Math.ceil((' + target + ')/' + quantum + ')*' + quantum;
  },
  isNumberType: function (type) {
    return type in Runtime.INT_TYPES || type in Runtime.FLOAT_TYPES;
  },
  isPointerType: function isPointerType(type) {
  return type[type.length-1] == '*';
},
  isStructType: function isStructType(type) {
  if (isPointerType(type)) return false;
  if (isArrayType(type)) return true;
  if (/<?{ ?[^}]* ?}>?/.test(type)) return true; // { i32, i8 } etc. - anonymous struct types
  // See comment in isStructPointerType()
  return type[0] == '%';
},
  INT_TYPES: {"i1":0,"i8":0,"i16":0,"i32":0,"i64":0},
  FLOAT_TYPES: {"float":0,"double":0},
  or64: function (x, y) {
    var l = (x | 0) | (y | 0);
    var h = (Math.round(x / 4294967296) | Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  and64: function (x, y) {
    var l = (x | 0) & (y | 0);
    var h = (Math.round(x / 4294967296) & Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  xor64: function (x, y) {
    var l = (x | 0) ^ (y | 0);
    var h = (Math.round(x / 4294967296) ^ Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  getNativeTypeSize: function (type, quantumSize) {
    if (Runtime.QUANTUM_SIZE == 1) return 1;
    var size = {
      '%i1': 1,
      '%i8': 1,
      '%i16': 2,
      '%i32': 4,
      '%i64': 8,
      "%float": 4,
      "%double": 8
    }['%'+type]; // add '%' since float and double confuse Closure compiler as keys, and also spidermonkey as a compiler will remove 's from '_i8' etc
    if (!size) {
      if (type.charAt(type.length-1) == '*') {
        size = Runtime.QUANTUM_SIZE; // A pointer
      } else if (type[0] == 'i') {
        var bits = parseInt(type.substr(1));
        assert(bits % 8 == 0);
        size = bits/8;
      }
    }
    return size;
  },
  getNativeFieldSize: function (type) {
    return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE);
  },
  dedup: function dedup(items, ident) {
  var seen = {};
  if (ident) {
    return items.filter(function(item) {
      if (seen[item[ident]]) return false;
      seen[item[ident]] = true;
      return true;
    });
  } else {
    return items.filter(function(item) {
      if (seen[item]) return false;
      seen[item] = true;
      return true;
    });
  }
},
  set: function set() {
  var args = typeof arguments[0] === 'object' ? arguments[0] : arguments;
  var ret = {};
  for (var i = 0; i < args.length; i++) {
    ret[args[i]] = 0;
  }
  return ret;
},
  STACK_ALIGN: 8,
  getAlignSize: function (type, size, vararg) {
    // we align i64s and doubles on 64-bit boundaries, unlike x86
    if (type == 'i64' || type == 'double' || vararg) return 8;
    if (!type) return Math.min(size, 8); // align structures internally to 64 bits
    return Math.min(size || (type ? Runtime.getNativeFieldSize(type) : 0), Runtime.QUANTUM_SIZE);
  },
  calculateStructAlignment: function calculateStructAlignment(type) {
    type.flatSize = 0;
    type.alignSize = 0;
    var diffs = [];
    var prev = -1;
    var index = 0;
    type.flatIndexes = type.fields.map(function(field) {
      index++;
      var size, alignSize;
      if (Runtime.isNumberType(field) || Runtime.isPointerType(field)) {
        size = Runtime.getNativeTypeSize(field); // pack char; char; in structs, also char[X]s.
        alignSize = Runtime.getAlignSize(field, size);
      } else if (Runtime.isStructType(field)) {
        if (field[1] === '0') {
          // this is [0 x something]. When inside another structure like here, it must be at the end,
          // and it adds no size
          // XXX this happens in java-nbody for example... assert(index === type.fields.length, 'zero-length in the middle!');
          size = 0;
          if (Types.types[field]) {
            alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
          } else {
            alignSize = type.alignSize || QUANTUM_SIZE;
          }
        } else {
          size = Types.types[field].flatSize;
          alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
        }
      } else if (field[0] == 'b') {
        // bN, large number field, like a [N x i8]
        size = field.substr(1)|0;
        alignSize = 1;
      } else {
        throw 'Unclear type in struct: ' + field + ', in ' + type.name_ + ' :: ' + dump(Types.types[type.name_]);
      }
      if (type.packed) alignSize = 1;
      type.alignSize = Math.max(type.alignSize, alignSize);
      var curr = Runtime.alignMemory(type.flatSize, alignSize); // if necessary, place this on aligned memory
      type.flatSize = curr + size;
      if (prev >= 0) {
        diffs.push(curr-prev);
      }
      prev = curr;
      return curr;
    });
    type.flatSize = Runtime.alignMemory(type.flatSize, type.alignSize);
    if (diffs.length == 0) {
      type.flatFactor = type.flatSize;
    } else if (Runtime.dedup(diffs).length == 1) {
      type.flatFactor = diffs[0];
    }
    type.needsFlattening = (type.flatFactor != 1);
    return type.flatIndexes;
  },
  generateStructInfo: function (struct, typeName, offset) {
    var type, alignment;
    if (typeName) {
      offset = offset || 0;
      type = (typeof Types === 'undefined' ? Runtime.typeInfo : Types.types)[typeName];
      if (!type) return null;
      if (type.fields.length != struct.length) {
        printErr('Number of named fields must match the type for ' + typeName + ': possibly duplicate struct names. Cannot return structInfo');
        return null;
      }
      alignment = type.flatIndexes;
    } else {
      var type = { fields: struct.map(function(item) { return item[0] }) };
      alignment = Runtime.calculateStructAlignment(type);
    }
    var ret = {
      __size__: type.flatSize
    };
    if (typeName) {
      struct.forEach(function(item, i) {
        if (typeof item === 'string') {
          ret[item] = alignment[i] + offset;
        } else {
          // embedded struct
          var key;
          for (var k in item) key = k;
          ret[key] = Runtime.generateStructInfo(item[key], type.fields[i], alignment[i]);
        }
      });
    } else {
      struct.forEach(function(item, i) {
        ret[item[1]] = alignment[i];
      });
    }
    return ret;
  },
  dynCall: function (sig, ptr, args) {
    if (args && args.length) {
      if (!args.splice) args = Array.prototype.slice.call(args);
      args.splice(0, 0, ptr);
      return Module['dynCall_' + sig].apply(null, args);
    } else {
      return Module['dynCall_' + sig].call(null, ptr);
    }
  },
  functionPointers: [],
  addFunction: function (func) {
    for (var i = 0; i < Runtime.functionPointers.length; i++) {
      if (!Runtime.functionPointers[i]) {
        Runtime.functionPointers[i] = func;
        return 2 + 2*i;
      }
    }
    throw 'Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.';
  },
  removeFunction: function (index) {
    Runtime.functionPointers[(index-2)/2] = null;
  },
  warnOnce: function (text) {
    if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
    if (!Runtime.warnOnce.shown[text]) {
      Runtime.warnOnce.shown[text] = 1;
      Module.printErr(text);
    }
  },
  funcWrappers: {},
  getFuncWrapper: function (func, sig) {
    assert(sig);
    if (!Runtime.funcWrappers[func]) {
      Runtime.funcWrappers[func] = function() {
        return Runtime.dynCall(sig, func, arguments);
      };
    }
    return Runtime.funcWrappers[func];
  },
  UTF8Processor: function () {
    var buffer = [];
    var needed = 0;
    this.processCChar = function (code) {
      code = code & 0xFF;
      if (buffer.length == 0) {
        if ((code & 0x80) == 0x00) {        // 0xxxxxxx
          return String.fromCharCode(code);
        }
        buffer.push(code);
        if ((code & 0xE0) == 0xC0) {        // 110xxxxx
          needed = 1;
        } else if ((code & 0xF0) == 0xE0) { // 1110xxxx
          needed = 2;
        } else {                            // 11110xxx
          needed = 3;
        }
        return '';
      }
      if (needed) {
        buffer.push(code);
        needed--;
        if (needed > 0) return '';
      }
      var c1 = buffer[0];
      var c2 = buffer[1];
      var c3 = buffer[2];
      var c4 = buffer[3];
      var ret;
      if (buffer.length == 2) {
        ret = String.fromCharCode(((c1 & 0x1F) << 6)  | (c2 & 0x3F));
      } else if (buffer.length == 3) {
        ret = String.fromCharCode(((c1 & 0x0F) << 12) | ((c2 & 0x3F) << 6)  | (c3 & 0x3F));
      } else {
        // http://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
        var codePoint = ((c1 & 0x07) << 18) | ((c2 & 0x3F) << 12) |
                        ((c3 & 0x3F) << 6)  | (c4 & 0x3F);
        ret = String.fromCharCode(
          Math.floor((codePoint - 0x10000) / 0x400) + 0xD800,
          (codePoint - 0x10000) % 0x400 + 0xDC00);
      }
      buffer.length = 0;
      return ret;
    }
    this.processJSString = function(string) {
      string = unescape(encodeURIComponent(string));
      var ret = [];
      for (var i = 0; i < string.length; i++) {
        ret.push(string.charCodeAt(i));
      }
      return ret;
    }
  },
  stackAlloc: function (size) { var ret = STACKTOP;STACKTOP = (STACKTOP + size)|0;STACKTOP = ((((STACKTOP)+7)>>3)<<3); return ret; },
  staticAlloc: function (size) { var ret = STATICTOP;STATICTOP = (STATICTOP + size)|0;STATICTOP = ((((STATICTOP)+7)>>3)<<3); return ret; },
  dynamicAlloc: function (size) { var ret = DYNAMICTOP;DYNAMICTOP = (DYNAMICTOP + size)|0;DYNAMICTOP = ((((DYNAMICTOP)+7)>>3)<<3); if (DYNAMICTOP >= TOTAL_MEMORY) enlargeMemory();; return ret; },
  alignMemory: function (size,quantum) { var ret = size = Math.ceil((size)/(quantum ? quantum : 8))*(quantum ? quantum : 8); return ret; },
  makeBigInt: function (low,high,unsigned) { var ret = (unsigned ? ((+(((low)>>>(0))))+((+(((high)>>>(0))))*(+(4294967296)))) : ((+(((low)>>>(0))))+((+(((high)|(0))))*(+(4294967296))))); return ret; },
  GLOBAL_BASE: 8,
  QUANTUM_SIZE: 4,
  __dummy__: 0
}
//========================================
// Runtime essentials
//========================================
var __THREW__ = 0; // Used in checking for thrown exceptions.
var ABORT = false; // whether we are quitting the application. no code should run after this. set in exit() and abort()
var EXITSTATUS = 0;
var undef = 0;
// tempInt is used for 32-bit signed values or smaller. tempBigInt is used
// for 32-bit unsigned values or more than 32 bits. TODO: audit all uses of tempInt
var tempValue, tempInt, tempBigInt, tempInt2, tempBigInt2, tempPair, tempBigIntI, tempBigIntR, tempBigIntS, tempBigIntP, tempBigIntD;
var tempI64, tempI64b;
var tempRet0, tempRet1, tempRet2, tempRet3, tempRet4, tempRet5, tempRet6, tempRet7, tempRet8, tempRet9;
function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}
var globalScope = this;
// C calling interface. A convenient way to call C functions (in C files, or
// defined with extern "C").
//
// Note: LLVM optimizations can inline and remove functions, after which you will not be
//       able to call them. Closure can also do so. To avoid that, add your function to
//       the exports using something like
//
//         -s EXPORTED_FUNCTIONS='["_main", "_myfunc"]'
//
// @param ident      The name of the C function (note that C++ functions will be name-mangled - use extern "C")
// @param returnType The return type of the function, one of the JS types 'number', 'string' or 'array' (use 'number' for any C pointer, and
//                   'array' for JavaScript arrays and typed arrays; note that arrays are 8-bit).
// @param argTypes   An array of the types of arguments for the function (if there are no arguments, this can be ommitted). Types are as in returnType,
//                   except that 'array' is not possible (there is no way for us to know the length of the array)
// @param args       An array of the arguments to the function, as native JS values (as in returnType)
//                   Note that string arguments will be stored on the stack (the JS string will become a C string on the stack).
// @return           The return value, as a native JS value (as in returnType)
function ccall(ident, returnType, argTypes, args) {
  return ccallFunc(getCFunc(ident), returnType, argTypes, args);
}
Module["ccall"] = ccall;
// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  try {
    var func = Module['_' + ident]; // closure exported function
    if (!func) func = eval('_' + ident); // explicit lookup
  } catch(e) {
  }
  assert(func, 'Cannot call unknown function ' + ident + ' (perhaps LLVM optimizations or closure removed it?)');
  return func;
}
// Internal function that does a C call using a function, not an identifier
function ccallFunc(func, returnType, argTypes, args) {
  var stack = 0;
  function toC(value, type) {
    if (type == 'string') {
      if (value === null || value === undefined || value === 0) return 0; // null string
      if (!stack) stack = Runtime.stackSave();
      var ret = Runtime.stackAlloc(value.length+1);
      writeStringToMemory(value, ret);
      return ret;
    } else if (type == 'array') {
      if (!stack) stack = Runtime.stackSave();
      var ret = Runtime.stackAlloc(value.length);
      writeArrayToMemory(value, ret);
      return ret;
    }
    return value;
  }
  function fromC(value, type) {
    if (type == 'string') {
      return Pointer_stringify(value);
    }
    assert(type != 'array');
    return value;
  }
  var i = 0;
  var cArgs = args ? args.map(function(arg) {
    return toC(arg, argTypes[i++]);
  }) : [];
  var ret = fromC(func.apply(null, cArgs), returnType);
  if (stack) Runtime.stackRestore(stack);
  return ret;
}
// Returns a native JS wrapper for a C function. This is similar to ccall, but
// returns a function you can call repeatedly in a normal way. For example:
//
//   var my_function = cwrap('my_c_function', 'number', ['number', 'number']);
//   alert(my_function(5, 22));
//   alert(my_function(99, 12));
//
function cwrap(ident, returnType, argTypes) {
  var func = getCFunc(ident);
  return function() {
    return ccallFunc(func, returnType, argTypes, Array.prototype.slice.call(arguments));
  }
}
Module["cwrap"] = cwrap;
// Sets a value in memory in a dynamic way at run-time. Uses the
// type data. This is the same as makeSetValue, except that
// makeSetValue is done at compile-time and generates the needed
// code then, whereas this function picks the right code at
// run-time.
// Note that setValue and getValue only do *aligned* writes and reads!
// Note that ccall uses JS types as for defining types, while setValue and
// getValue need LLVM types ('i8', 'i32') - this is a lower-level operation
function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': HEAP8[(ptr)]=value; break;
      case 'i8': HEAP8[(ptr)]=value; break;
      case 'i16': HEAP16[((ptr)>>1)]=value; break;
      case 'i32': HEAP32[((ptr)>>2)]=value; break;
      case 'i64': (tempI64 = [value>>>0,(tempDouble=value,(+(Math.abs(tempDouble))) >= (+(1)) ? (tempDouble > (+(0)) ? ((Math.min((+(Math.floor((tempDouble)/(+(4294967296))))), (+(4294967295))))|0)>>>0 : (~~((+(Math.ceil((tempDouble - +(((~~(tempDouble)))>>>0))/(+(4294967296)))))))>>>0) : 0)],HEAP32[((ptr)>>2)]=tempI64[0],HEAP32[(((ptr)+(4))>>2)]=tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)]=value; break;
      case 'double': HEAPF64[((ptr)>>3)]=value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}
Module['setValue'] = setValue;
// Parallel to setValue.
function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': return HEAP8[(ptr)];
      case 'i8': return HEAP8[(ptr)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for setValue: ' + type);
    }
  return null;
}
Module['getValue'] = getValue;
var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_DYNAMIC = 3; // Cannot be freed except through sbrk
var ALLOC_NONE = 4; // Do not allocate
Module['ALLOC_NORMAL'] = ALLOC_NORMAL;
Module['ALLOC_STACK'] = ALLOC_STACK;
Module['ALLOC_STATIC'] = ALLOC_STATIC;
Module['ALLOC_DYNAMIC'] = ALLOC_DYNAMIC;
Module['ALLOC_NONE'] = ALLOC_NONE;
// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }
  var singleType = typeof types === 'string' ? types : null;
  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc, Runtime.dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
  }
  if (zeroinit) {
    var ptr = ret, stop;
    assert((ret & 3) == 0);
    stop = ret + (size & ~3);
    for (; ptr < stop; ptr += 4) {
      HEAP32[((ptr)>>2)]=0;
    }
    stop = ret + size;
    while (ptr < stop) {
      HEAP8[((ptr++)|0)]=0;
    }
    return ret;
  }
  if (singleType === 'i8') {
    if (slab.subarray || slab.slice) {
      HEAPU8.set(slab, ret);
    } else {
      HEAPU8.set(new Uint8Array(slab), ret);
    }
    return ret;
  }
  var i = 0, type, typeSize, previousType;
  while (i < size) {
    var curr = slab[i];
    if (typeof curr === 'function') {
      curr = Runtime.getFunctionIndex(curr);
    }
    type = singleType || types[i];
    if (type === 0) {
      i++;
      continue;
    }
    if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later
    setValue(ret+i, curr, type);
    // no need to look up size unless type changes, so cache it
    if (previousType !== type) {
      typeSize = Runtime.getNativeTypeSize(type);
      previousType = type;
    }
    i += typeSize;
  }
  return ret;
}
Module['allocate'] = allocate;
function Pointer_stringify(ptr, /* optional */ length) {
  // TODO: use TextDecoder
  // Find the length, and check for UTF while doing so
  var hasUtf = false;
  var t;
  var i = 0;
  while (1) {
    t = HEAPU8[(((ptr)+(i))|0)];
    if (t >= 128) hasUtf = true;
    else if (t == 0 && !length) break;
    i++;
    if (length && i == length) break;
  }
  if (!length) length = i;
  var ret = '';
  if (!hasUtf) {
    var MAX_CHUNK = 1024; // split up into chunks, because .apply on a huge string can overflow the stack
    var curr;
    while (length > 0) {
      curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
      ret = ret ? ret + curr : curr;
      ptr += MAX_CHUNK;
      length -= MAX_CHUNK;
    }
    return ret;
  }
  var utf8 = new Runtime.UTF8Processor();
  for (i = 0; i < length; i++) {
    t = HEAPU8[(((ptr)+(i))|0)];
    ret += utf8.processCChar(t);
  }
  return ret;
}
Module['Pointer_stringify'] = Pointer_stringify;
// Given a pointer 'ptr' to a null-terminated UTF16LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.
function UTF16ToString(ptr) {
  var i = 0;
  var str = '';
  while (1) {
    var codeUnit = HEAP16[(((ptr)+(i*2))>>1)];
    if (codeUnit == 0)
      return str;
    ++i;
    // fromCharCode constructs a character from a UTF-16 code unit, so we can pass the UTF16 string right through.
    str += String.fromCharCode(codeUnit);
  }
}
Module['UTF16ToString'] = UTF16ToString;
// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr', 
// null-terminated and encoded in UTF16LE form. The copy will require at most (str.length*2+1)*2 bytes of space in the HEAP.
function stringToUTF16(str, outPtr) {
  for(var i = 0; i < str.length; ++i) {
    // charCodeAt returns a UTF-16 encoded code unit, so it can be directly written to the HEAP.
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    HEAP16[(((outPtr)+(i*2))>>1)]=codeUnit
  }
  // Null-terminate the pointer to the HEAP.
  HEAP16[(((outPtr)+(str.length*2))>>1)]=0
}
Module['stringToUTF16'] = stringToUTF16;
// Given a pointer 'ptr' to a null-terminated UTF32LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.
function UTF32ToString(ptr) {
  var i = 0;
  var str = '';
  while (1) {
    var utf32 = HEAP32[(((ptr)+(i*4))>>2)];
    if (utf32 == 0)
      return str;
    ++i;
    // Gotcha: fromCharCode constructs a character from a UTF-16 encoded code (pair), not from a Unicode code point! So encode the code point to UTF-16 for constructing.
    if (utf32 >= 0x10000) {
      var ch = utf32 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    } else {
      str += String.fromCharCode(utf32);
    }
  }
}
Module['UTF32ToString'] = UTF32ToString;
// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr', 
// null-terminated and encoded in UTF32LE form. The copy will require at most (str.length+1)*4 bytes of space in the HEAP,
// but can use less, since str.length does not return the number of characters in the string, but the number of UTF-16 code units in the string.
function stringToUTF32(str, outPtr) {
  var iChar = 0;
  for(var iCodeUnit = 0; iCodeUnit < str.length; ++iCodeUnit) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    var codeUnit = str.charCodeAt(iCodeUnit); // possibly a lead surrogate
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) {
      var trailSurrogate = str.charCodeAt(++iCodeUnit);
      codeUnit = 0x10000 + ((codeUnit & 0x3FF) << 10) | (trailSurrogate & 0x3FF);
    }
    HEAP32[(((outPtr)+(iChar*4))>>2)]=codeUnit
    ++iChar;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP32[(((outPtr)+(iChar*4))>>2)]=0
}
Module['stringToUTF32'] = stringToUTF32;
// Memory management
var PAGE_SIZE = 4096;
function alignMemoryPage(x) {
  return ((x+4095)>>12)<<12;
}
var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;
var STATIC_BASE = 0, STATICTOP = 0, staticSealed = false; // static area
var STACK_BASE = 0, STACKTOP = 0, STACK_MAX = 0; // stack area
var DYNAMIC_BASE = 0, DYNAMICTOP = 0; // dynamic area handled by sbrk
function enlargeMemory() {
  abort('Cannot enlarge memory arrays in asm.js. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value ' + TOTAL_MEMORY + ', or (2) set Module.TOTAL_MEMORY before the program runs.');
}
var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 16777216;
var FAST_MEMORY = Module['FAST_MEMORY'] || 2097152;
// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(!!Int32Array && !!Float64Array && !!(new Int32Array(1)['subarray']) && !!(new Int32Array(1)['set']),
       'Cannot fallback to non-typed array case: Code is too specialized');
var buffer = new ArrayBuffer(TOTAL_MEMORY);
HEAP8 = new Int8Array(buffer);
HEAP16 = new Int16Array(buffer);
HEAP32 = new Int32Array(buffer);
HEAPU8 = new Uint8Array(buffer);
HEAPU16 = new Uint16Array(buffer);
HEAPU32 = new Uint32Array(buffer);
HEAPF32 = new Float32Array(buffer);
HEAPF64 = new Float64Array(buffer);
// Endianness check (note: assumes compiler arch was little-endian)
HEAP32[0] = 255;
assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, 'Typed arrays 2 must be run on a little-endian system');
Module['HEAP'] = HEAP;
Module['HEAP8'] = HEAP8;
Module['HEAP16'] = HEAP16;
Module['HEAP32'] = HEAP32;
Module['HEAPU8'] = HEAPU8;
Module['HEAPU16'] = HEAPU16;
Module['HEAPU32'] = HEAPU32;
Module['HEAPF32'] = HEAPF32;
Module['HEAPF64'] = HEAPF64;
function callRuntimeCallbacks(callbacks) {
  while(callbacks.length > 0) {
    var callback = callbacks.shift();
    if (typeof callback == 'function') {
      callback();
      continue;
    }
    var func = callback.func;
    if (typeof func === 'number') {
      if (callback.arg === undefined) {
        Runtime.dynCall('v', func);
      } else {
        Runtime.dynCall('vi', func, [callback.arg]);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}
var __ATPRERUN__  = []; // functions called before the runtime is initialized
var __ATINIT__    = []; // functions called during startup
var __ATMAIN__    = []; // functions called when main() is to be run
var __ATEXIT__    = []; // functions called during shutdown
var __ATPOSTRUN__ = []; // functions called after the runtime has exited
var runtimeInitialized = false;
function preRun() {
  // compatibility - merge in anything from Module['preRun'] at this time
  if (Module['preRun']) {
    if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
    while (Module['preRun'].length) {
      addOnPreRun(Module['preRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPRERUN__);
}
function ensureInitRuntime() {
  if (runtimeInitialized) return;
  runtimeInitialized = true;
  callRuntimeCallbacks(__ATINIT__);
}
function preMain() {
  callRuntimeCallbacks(__ATMAIN__);
}
function exitRuntime() {
  callRuntimeCallbacks(__ATEXIT__);
}
function postRun() {
  // compatibility - merge in anything from Module['postRun'] at this time
  if (Module['postRun']) {
    if (typeof Module['postRun'] == 'function') Module['postRun'] = [Module['postRun']];
    while (Module['postRun'].length) {
      addOnPostRun(Module['postRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPOSTRUN__);
}
function addOnPreRun(cb) {
  __ATPRERUN__.unshift(cb);
}
Module['addOnPreRun'] = Module.addOnPreRun = addOnPreRun;
function addOnInit(cb) {
  __ATINIT__.unshift(cb);
}
Module['addOnInit'] = Module.addOnInit = addOnInit;
function addOnPreMain(cb) {
  __ATMAIN__.unshift(cb);
}
Module['addOnPreMain'] = Module.addOnPreMain = addOnPreMain;
function addOnExit(cb) {
  __ATEXIT__.unshift(cb);
}
Module['addOnExit'] = Module.addOnExit = addOnExit;
function addOnPostRun(cb) {
  __ATPOSTRUN__.unshift(cb);
}
Module['addOnPostRun'] = Module.addOnPostRun = addOnPostRun;
// Tools
// This processes a JS string into a C-line array of numbers, 0-terminated.
// For LLVM-originating strings, see parser.js:parseLLVMString function
function intArrayFromString(stringy, dontAddNull, length /* optional */) {
  var ret = (new Runtime.UTF8Processor()).processJSString(stringy);
  if (length) {
    ret.length = length;
  }
  if (!dontAddNull) {
    ret.push(0);
  }
  return ret;
}
Module['intArrayFromString'] = intArrayFromString;
function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}
Module['intArrayToString'] = intArrayToString;
// Write a Javascript array to somewhere in the heap
function writeStringToMemory(string, buffer, dontAddNull) {
  var array = intArrayFromString(string, dontAddNull);
  var i = 0;
  while (i < array.length) {
    var chr = array[i];
    HEAP8[(((buffer)+(i))|0)]=chr
    i = i + 1;
  }
}
Module['writeStringToMemory'] = writeStringToMemory;
function writeArrayToMemory(array, buffer) {
  for (var i = 0; i < array.length; i++) {
    HEAP8[(((buffer)+(i))|0)]=array[i];
  }
}
Module['writeArrayToMemory'] = writeArrayToMemory;
function unSign(value, bits, ignore, sig) {
  if (value >= 0) {
    return value;
  }
  return bits <= 32 ? 2*Math.abs(1 << (bits-1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
                    : Math.pow(2, bits)         + value;
}
function reSign(value, bits, ignore, sig) {
  if (value <= 0) {
    return value;
  }
  var half = bits <= 32 ? Math.abs(1 << (bits-1)) // abs is needed if bits == 32
                        : Math.pow(2, bits-1);
  if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
                                                       // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
                                                       // TODO: In i64 mode 1, resign the two parts separately and safely
    value = -2*half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
  }
  return value;
}
if (!Math['imul']) Math['imul'] = function(a, b) {
  var ah  = a >>> 16;
  var al = a & 0xffff;
  var bh  = b >>> 16;
  var bl = b & 0xffff;
  return (al*bl + ((ah*bl + al*bh) << 16))|0;
};
Math.imul = Math['imul'];
// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyTracking = {};
var calledInit = false, calledRun = false;
var runDependencyWatcher = null;
function addRunDependency(id) {
  runDependencies++;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(!runDependencyTracking[id]);
    runDependencyTracking[id] = 1;
  } else {
    Module.printErr('warning: run dependency added without ID');
  }
}
Module['addRunDependency'] = addRunDependency;
function removeRunDependency(id) {
  runDependencies--;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(runDependencyTracking[id]);
    delete runDependencyTracking[id];
  } else {
    Module.printErr('warning: run dependency removed without ID');
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    } 
    // If run has never been called, and we should call run (INVOKE_RUN is true, and Module.noInitialRun is not false)
    if (!calledRun) run();
  }
}
Module['removeRunDependency'] = removeRunDependency;
Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data
function loadMemoryInitializer(filename) {
  function applyData(data) {
    HEAPU8.set(data, STATIC_BASE);
  }
  // always do this asynchronously, to keep shell and web as similar as possible
  addOnPreRun(function() {
    if (ENVIRONMENT_IS_NODE || ENVIRONMENT_IS_SHELL) {
      applyData(Module['readBinary'](filename));
    } else {
      Browser.asyncLoad(filename, function(data) {
        applyData(data);
      }, function(data) {
        throw 'could not load memory initializer ' + filename;
      });
    }
  });
}
// === Body ===
STATIC_BASE = 8;
STATICTOP = STATIC_BASE + 14352;
/* global initializers */ __ATINIT__.push({ func: function() { runPostSets() } },{ func: function() { __GLOBAL__I_a() } });
var ___dso_handle;
var __ZTVN10__cxxabiv120__si_class_type_infoE;
var __ZTVN10__cxxabiv117__class_type_infoE;
var __ZN23btDiscreteDynamicsWorldC1EP12btDispatcherP21btBroadphaseInterfaceP18btConstraintSolverP24btCollisionConfiguration;
var __ZN11btRigidBodyC1ERKNS_27btRigidBodyConstructionInfoE;
var __ZN11btRigidBodyC1EfP13btMotionStateP16btCollisionShapeRK9btVector3;
var __ZN35btSequentialImpulseConstraintSolverC1Ev;
var __ZN21btCollisionDispatcherC1EP24btCollisionConfiguration;
var __ZN27btContinuousConvexCollisionC1EPK13btConvexShapeS2_P22btVoronoiSimplexSolverP30btConvexPenetrationDepthSolver;
var __ZN27btContinuousConvexCollisionC1EPK13btConvexShapePK18btStaticPlaneShape;
var __ZN16btDbvtBroadphaseC1EP22btOverlappingPairCache;
var __ZN31btDefaultCollisionConfigurationC1ERK34btDefaultCollisionConstructionInfo;
var __ZN16btEmptyAlgorithmC1ERK36btCollisionAlgorithmConstructionInfo;
var __ZN17btGjkPairDetectorC1EPK13btConvexShapeS2_P22btVoronoiSimplexSolverP30btConvexPenetrationDepthSolver;
var __ZN17btGjkPairDetectorC1EPK13btConvexShapeS2_iiffP22btVoronoiSimplexSolverP30btConvexPenetrationDepthSolver;
var __ZN16btManifoldResultC1EP17btCollisionObjectS1_;
var __ZN28btHashedOverlappingPairCacheC1Ev;
var __ZN25btSimulationIslandManagerC1Ev;
var __ZN32btSphereSphereCollisionAlgorithmC1EP20btPersistentManifoldRK36btCollisionAlgorithmConstructionInfoP17btCollisionObjectS6_;
var __ZN34btSphereTriangleCollisionAlgorithmC1EP20btPersistentManifoldRK36btCollisionAlgorithmConstructionInfoP17btCollisionObjectS6_b;
var __ZN22btSubsimplexConvexCastC1EPK13btConvexShapeS2_P22btVoronoiSimplexSolver;
var __ZN11btUnionFindD1Ev;
var __ZN11btUnionFindC1Ev;
var __ZN22SphereTriangleDetectorC1EP13btSphereShapeP15btTriangleShapef;
var __ZN26btBoxBoxCollisionAlgorithmC1EP20btPersistentManifoldRK36btCollisionAlgorithmConstructionInfoP17btCollisionObjectS6_;
var __ZN16btBoxBoxDetectorC1EP10btBoxShapeS1_;
var __ZN28btCompoundCollisionAlgorithmC1ERK36btCollisionAlgorithmConstructionInfoP17btCollisionObjectS4_b;
var __ZN33btConvexConcaveCollisionAlgorithmC1ERK36btCollisionAlgorithmConstructionInfoP17btCollisionObjectS4_b;
var __ZN23btConvexConvexAlgorithm10CreateFuncC1EP22btVoronoiSimplexSolverP30btConvexPenetrationDepthSolver;
var __ZN31btConvexPlaneCollisionAlgorithmC1EP20btPersistentManifoldRK36btCollisionAlgorithmConstructionInfoP17btCollisionObjectS6_bii;
var __ZN18btConvexPolyhedronC1Ev;
var __ZN6btDbvtC1Ev;
var __ZN6btDbvtD1Ev;
var __ZN15btGjkConvexCastC1EPK13btConvexShapeS2_P22btVoronoiSimplexSolver;
__ZTVN10__cxxabiv120__si_class_type_infoE=allocate([0,0,0,0,96,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTVN10__cxxabiv117__class_type_infoE=allocate([0,0,0,0,112,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
/* memory initializer */ allocate([0,0,0,64,0,0,0,0,10,215,163,60,0,0,0,0,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,99,111,110,118,101,120,83,119,101,101,112,84,101,115,116,0,67,67,68,32,109,111,116,105,111,110,32,99,108,97,109,112,105,110,103,0,0,0,0,0,99,111,110,118,101,120,83,119,101,101,112,67,111,109,112,111,117,110,100,0,0,0,0,0,105,110,116,101,103,114,97,116,101,84,114,97,110,115,102,111,114,109,115,0,0,0,0,0,100,105,115,112,97,116,99,104,65,108,108,67,111,108,108,105,115,105,111,110,80,97,105,114,115,0,0,0,0,0,0,0,99,97,108,99,117,108,97,116,101,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,115,0,0,0,0,0,0,99,97,108,99,117,108,97,116,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,0,0,0,0,0,0,0,115,111,108,118,101,67,111,110,115,116,114,97,105,110,116,115,0,0,0,0,0,0,0,0,82,111,111,116,0,0,0,0,112,101,114,102,111,114,109,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,105,111,110,0,0,0,0,0,0,0,117,112,100,97,116,101,65,99,116,105,118,97,116,105,111,110,83,116,97,116,101,0,0,0,66,117,108,108,101,116,67,111,108,108,105,115,105,111,110,47,78,97,114,114,111,119,80,104,97,115,101,67,111,108,108,105,115,105,111,110,47,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,116,97,99,116,67,108,105,112,112,105,110,103,46,99,112,112,0,0,0,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,83,101,116,117,112,0,0,0,0,117,112,100,97,116,101,65,97,98,98,115,0,0,0,0,0,117,112,100,97,116,101,65,99,116,105,111,110,115,0,0,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,0,84,104,97,110,107,115,46,10,0,0,0,0,0,0,0,0,105,115,108,97,110,100,85,110,105,111,110,70,105,110,100,65,110,100,81,117,105,99,107,83,111,114,116,0,0,0,0,0,105,110,116,101,114,110,97,108,83,105,110,103,108,101,83,116,101,112,83,105,109,117,108,97,116,105,111,110,0,0,0,0,100,49,62,61,48,46,48,102,0,0,0,0,0,0,0,0,115,111,108,118,101,71,114,111,117,112,0,0,0,0,0,0,98,116,82,105,103,105,100,66,111,100,121,70,108,111,97,116,68,97,116,97,0,0,0,0,80,108,101,97,115,101,32,105,110,99,108,117,100,101,32,97,98,111,118,101,32,105,110,102,111,114,109,97,116,105,111,110,44,32,121,111,117,114,32,80,108,97,116,102,111,114,109,44,32,118,101,114,115,105,111,110,32,111,102,32,79,83,46,10,0,0,0,0,0,0,0,0,115,116,101,112,83,105,109,117,108,97,116,105,111,110,0,0,66,111,120,0,0,0,0,0,100,48,62,61,48,46,48,102,0,0,0,0,0,0,0,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,73,116,101,114,97,116,105,111,110,115,0,0,0,0,0,0,0,83,80,72,69,82,69,0,0,112,114,111,99,101,115,115,73,115,108,97,110,100,115,0,0,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,68,97,116,97,0,0,0,0,0,0,0,84,114,105,97,110,103,108,101,0,0,0,0,0,0,0,0,112,114,101,100,105,99,116,85,110,99,111,110,115,116,114,97,105,110,116,77,111,116,105,111,110,0,0,0,0,0,0,0,79,118,101,114,102,108,111,119,32,105,110,32,65,65,66,66,44,32,111,98,106,101,99,116,32,114,101,109,111,118,101,100,32,102,114,111,109,32,115,105,109,117,108,97,116,105,111,110,0,0,0,0,0,0,0,0,115,121,110,99,104,114,111,110,105,122,101,77,111,116,105,111,110,83,116,97,116,101,115,0,73,102,32,121,111,117,32,99,97,110,32,114,101,112,114,111,100,117,99,101,32,116,104,105,115,44,32,112,108,101,97,115,101,32,101,109,97,105,108,32,98,117,103,115,64,99,111,110,116,105,110,117,111,117,115,112,104,121,115,105,99,115,46,99,111,109,10,0,0,0,0,0,115,101,97,114,99,104,32,115,112,101,99,117,108,97,116,105,118,101,32,99,111,110,116,97,99,116,115,0,0,0,0,0,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,68,97,116,97,0,0,0,0,97,100,100,83,112,101,99,117,108,97,116,105,118,101,67,111,110,116,97,99,116,115,0,0,100,101,98,117,103,68,114,97,119,87,111,114,108,100,0,0,119,111,114,108,100,32,112,111,115,32,61,32,37,46,50,102,44,37,46,50,102,44,37,46,50,102,10,0,0,0,0,0,98,111,111,108,32,84,101,115,116,83,101,112,65,120,105,115,40,99,111,110,115,116,32,98,116,67,111,110,118,101,120,80,111,108,121,104,101,100,114,111,110,32,38,44,32,99,111,110,115,116,32,98,116,67,111,110,118,101,120,80,111,108,121,104,101,100,114,111,110,32,38,44,32,99,111,110,115,116,32,98,116,84,114,97,110,115,102,111,114,109,32,38,44,32,99,111,110,115,116,32,98,116,84,114,97,110,115,102,111,114,109,32,38,44,32,99,111,110,115,116,32,98,116,86,101,99,116,111,114,51,32,38,44,32,102,108,111,97,116,32,38,41,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,40,0,0,20,1,0,0,44,0,0,0,86,0,0,0,4,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,40,0,0,84,0,0,0,42,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,40,0,0,90,0,0,0,204,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,40,0,0,116,1,0,0,90,1,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,40,0,0,196,0,0,0,104,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,40,0,0,98,1,0,0,50,1,0,0,26,0,0,0,16,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,40,0,0,8,1,0,0,40,0,0,0,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,40,0,0,198,0,0,0,56,1,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,40,0,0,4,0,0,0,14,0,0,0,26,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,40,0,0,122,0,0,0,30,0,0,0,26,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,0,0,236,0,0,0,98,0,0,0,38,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,41,0,0,114,0,0,0,158,0,0,0,10,0,0,0,76,0,0,0,2,0,0,0,32,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,41,0,0,124,0,0,0,168,0,0,0,40,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,41,0,0,22,0,0,0,184,0,0,0,40,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,41,0,0,64,1,0,0,190,0,0,0,22,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,41,0,0,32,0,0,0,180,0,0,0,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,41,0,0,94,1,0,0,240,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,41,0,0,28,0,0,0,20,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,41,0,0,228,0,0,0,248,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,41,0,0,72,0,0,0,60,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,41,0,0,82,1,0,0,92,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,41,0,0,112,0,0,0,142,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,41,0,0,150,0,0,0,100,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,41,0,0,48,1,0,0,202,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,42,0,0,102,1,0,0,220,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,42,0,0,88,1,0,0,30,1,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,42,0,0,34,0,0,0,200,0,0,0,30,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,42,0,0,20,0,0,0,34,0,0,0,80,0,0,0,100,0,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,42,0,0,6,0,0,0,14,1,0,0,74,0,0,0,214,0,0,0,4,0,0,0,2,0,0,0,32,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,42,0,0,112,1,0,0,38,0,0,0,56,0,0,0,2,0,0,0,30,0,0,0,162,0,0,0,2,0,0,0,6,0,0,0,2,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,42,0,0,156,0,0,0,2,0,0,0,2,0,0,0,16,0,0,0,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,42,0,0,54,1,0,0,70,1,0,0,24,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,42,0,0,52,0,0,0,182,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,42,0,0,146,0,0,0,62,1,0,0,26,0,0,0,8,0,0,0,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,42,0,0,118,1,0,0,6,1,0,0,14,0,0,0,2,0,0,0,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,0,0,88,0,0,0,224,0,0,0,32,0,0,0,36,0,0,0,40,0,0,0,20,0,0,0,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,43,0,0,120,1,0,0,218,0,0,0,20,0,0,0,6,0,0,0,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,43,0,0,32,1,0,0,178,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,43,0,0,106,0,0,0,250,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,43,0,0,96,1,0,0,174,0,0,0,26,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,43,0,0,144,0,0,0,38,1,0,0,10,0,0,0,22,0,0,0,48,0,0,0,6,0,0,0,24,0,0,0,60,0,0,0,14,0,0,0,14,0,0,0,24,0,0,0,68,0,0,0,62,0,0,0,12,0,0,0,58,0,0,0,36,0,0,0,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,43,0,0,102,0,0,0,68,1,0,0,4,0,0,0,10,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,43,0,0,10,1,0,0,22,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,43,0,0,8,0,0,0,252,0,0,0,28,0,0,0,4,0,0,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,43,0,0,58,1,0,0,26,0,0,0,40,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,43,0,0,52,1,0,0,104,1,0,0,22,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,43,0,0,84,1,0,0,238,0,0,0,52,0,0,0,70,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,43,0,0,40,1,0,0,74,1,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,43,0,0,80,0,0,0,26,1,0,0,58,0,0,0,60,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,56,0,0,0,4,0,0,0,2,0,0,0,4,0,0,0,6,0,0,0,34,0,0,0,6,0,0,0,86,0,0,0,38,0,0,0,42,0,0,0,28,0,0,0,38,0,0,0,12,0,0,0,78,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,0,0,242,0,0,0,132,0,0,0,96,0,0,0,22,0,0,0,30,0,0,0,86,1,0,0,14,0,0,0,60,0,0,0,70,0,0,0,78,0,0,0,176,0,0,0,50,0,0,0,2,0,0,0,68,0,0,0,40,0,0,0,106,0,0,0,10,0,0,0,38,0,0,0,44,0,0,0,154,0,0,0,42,0,0,0,56,0,0,0,104,0,0,0,70,0,0,0,64,0,0,0,8,0,0,0,34,0,0,0,36,0,0,0,54,0,0,0,210,0,0,0,74,0,0,0,8,0,0,0,26,0,0,0,46,0,0,0,14,0,0,0,10,0,0,0,8,0,0,0,94,0,0,0,94,0,0,0,16,0,0,0,18,0,0,0,62,0,0,0,66,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,44,0,0,66,1,0,0,82,0,0,0,16,0,0,0,12,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,44,0,0,48,0,0,0,232,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,44,0,0,18,0,0,0,18,1,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,44,0,0,42,1,0,0,110,0,0,0,10,0,0,0,52,0,0,0,2,0,0,0,32,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,44,0,0,4,1,0,0,172,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,44,0,0,254,0,0,0,16,1,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,44,0,0,186,0,0,0,208,0,0,0,58,0,0,0,60,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,56,0,0,0,2,0,0,0,2,0,0,0,4,0,0,0,6,0,0,0,34,0,0,0,6,0,0,0,86,0,0,0,38,0,0,0,2,0,0,0,2,0,0,0,38,0,0,0,12,0,0,0,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,44,0,0,46,1,0,0,36,0,0,0,8,0,0,0,2,0,0,0,12,0,0,0,100,0,0,0,8,0,0,0,16,0,0,0,44,0,0,0,44,0,0,0,16,0,0,0,48,0,0,0,26,0,0,0,70,0,0,0,12,0,0,0,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,44,0,0,216,0,0,0,114,1,0,0,20,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,44,0,0,24,0,0,0,140,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,44,0,0,138,0,0,0,2,1,0,0,10,0,0,0,6,0,0,0,2,0,0,0,32,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,44,0,0,136,0,0,0,170,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,44,0,0,230,0,0,0,108,1,0,0,10,0,0,0,80,0,0,0,2,0,0,0,32,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,45,0,0,54,0,0,0,0,1,0,0,2,0,0,0,92,0,0,0,2,0,0,0,32,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,45,0,0,70,0,0,0,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,45,0,0,28,1,0,0,60,1,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,45,0,0,20,0,0,0,118,0,0,0,24,1,0,0,30,0,0,0,76,0,0,0,22,0,0,0,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,45,0,0,194,0,0,0,134,0,0,0,68,0,0,0,16,0,0,0,252,255,255,255,80,45,0,0,130,0,0,0,108,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,45,0,0,16,0,0,0,222,0,0,0,34,0,0,0,50,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,45,0,0,12,0,0,0,110,1,0,0,52,0,0,0,70,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,45,0,0,116,0,0,0,160,0,0,0,38,0,0,0,14,0,0,0,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,45,0,0,66,0,0,0,188,0,0,0,2,0,0,0,58,0,0,0,12,0,0,0,54,0,0,0,8,0,0,0,12,0,0,0,56,0,0,0,62,0,0,0,68,0,0,0,84,0,0,0,48,0,0,0,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,45,0,0,128,0,0,0,106,1,0,0,96,0,0,0,22,0,0,0,30,0,0,0,78,0,0,0,14,0,0,0,60,0,0,0,8,0,0,0,24,0,0,0,176,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,45,0,0,226,0,0,0,72,1,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,45,0,0,166,0,0,0,50,0,0,0,66,0,0,0,60,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,56,0,0,0,2,0,0,0,18,0,0,0,4,0,0,0,6,0,0,0,34,0,0,0,6,0,0,0,86,0,0,0,38,0,0,0,6,0,0,0,50,0,0,0,38,0,0,0,42,0,0,0,12,0,0,0,2,0,0,0,50,0,0,0,4,0,0,0,20,0,0,0,30,0,0,0,28,0,0,0,6,0,0,0,2,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,45,0,0,120,0,0,0,10,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,0,0,46,0,0,0,76,1,0,0,10,0,0,0,60,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,56,0,0,0,6,0,0,0,16,0,0,0,12,0,0,0,2,0,0,0,34,0,0,0,6,0,0,0,86,0,0,0,46,0,0,0,18,0,0,0,34,0,0,0,38,0,0,0,12,0,0,0,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,46,0,0,206,0,0,0,78,1,0,0,2,0,0,0,60,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,10,0,0,0,14,0,0,0,86,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,46,0,0,6,0,0,0,12,1,0,0,34,1,0,0,30,0,0,0,20,0,0,0,18,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,46,0,0,148,0,0,0,86,0,0,0,48,0,0,0,60,0,0,0,4,0,0,0,2,0,0,0,64,0,0,0,56,0,0,0,8,0,0,0,72,0,0,0,2,0,0,0,6,0,0,0,34,0,0,0,6,0,0,0,86,0,0,0,72,0,0,0,64,0,0,0,46,0,0,0,38,0,0,0,46,0,0,0,8,0,0,0,2,0,0,0,22,0,0,0,38,0,0,0,18,0,0,0,54,0,0,0,52,0,0,0,62,0,0,0,4,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,90,78,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,49,50,99,97,108,99,80,101,110,68,101,112,116,104,69,82,50,50,98,116,86,111,114,111,110,111,105,83,105,109,112,108,101,120,83,111,108,118,101,114,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,83,52,95,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,55,95,82,57,98,116,86,101,99,116,111,114,51,83,57,95,83,57,95,80,49,50,98,116,73,68,101,98,117,103,68,114,97,119,80,49,50,98,116,83,116,97,99,107,65,108,108,111,99,69,50,48,98,116,73,110,116,101,114,109,101,100,105,97,116,101,82,101,115,117,108,116,0,0,0,0,0,0,0,90,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,50,49,99,97,108,99,117,108,97,116,101,84,105,109,101,79,102,73,109,112,97,99,116,69,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,83,49,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,51,49,76,111,99,97,108,84,114,105,97,110,103,108,101,83,112,104,101,114,101,67,97,115,116,67,97,108,108,98,97,99,107,0,0,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,51,55,114,101,109,111,118,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,67,111,110,116,97,105,110,105,110,103,80,114,111,120,121,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,56,82,101,109,111,118,101,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,49,57,99,108,101,97,110,80,114,111,120,121,70,114,111,109,80,97,105,114,115,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,55,67,108,101,97,110,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,90,78,50,51,98,116,68,105,115,99,114,101,116,101,68,121,110,97,109,105,99,115,87,111,114,108,100,49,54,115,111,108,118,101,67,111,110,115,116,114,97,105,110,116,115,69,82,49,57,98,116,67,111,110,116,97,99,116,83,111,108,118,101,114,73,110,102,111,69,50,55,73,110,112,108,97,99,101,83,111,108,118,101,114,73,115,108,97,110,100,67,97,108,108,98,97,99,107,0,0,0,0,0,0,90,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,54,112,114,111,99,101,115,115,67,111,108,108,105,115,105,111,110,69,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,83,49,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,49,51,98,116,68,117,109,109,121,82,101,115,117,108,116,0,0,0,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,55,112,101,114,102,111,114,109,67,111,110,118,101,120,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,83,52,95,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,52,112,101,114,102,111,114,109,82,97,121,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,55,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,80,75,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,83,53,95,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,55,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,80,75,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,83,53,95,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,55,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,80,75,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,83,53,95,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,49,52,76,111,99,97,108,73,110,102,111,65,100,100,101,114,95,49,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,51,114,97,121,84,101,115,116,83,105,110,103,108,101,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,80,75,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,83,50,95,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,57,82,97,121,84,101,115,116,101,114,95,49,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,51,114,97,121,84,101,115,116,83,105,110,103,108,101,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,80,75,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,83,50,95,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,0,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,51,114,97,121,84,101,115,116,83,105,110,103,108,101,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,80,75,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,83,50,95,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,51,114,97,121,84,101,115,116,83,105,110,103,108,101,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,80,75,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,83,50,95,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,49,53,76,111,99,97,108,73,110,102,111,65,100,100,101,114,50,0,0,0,0,0,83,116,57,116,121,112,101,95,105,110,102,111,0,0,0,0,83,116,57,101,120,99,101,112,116,105,111,110,0,0,0,0,83,116,57,98,97,100,95,97,108,108,111,99,0,0,0,0,78,54,98,116,68,98,118,116,56,73,67,111,108,108,105,100,101,69,0,0,0,0,0,0,78,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,54,82,101,115,117,108,116,69,0,78,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,0,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,78,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,0,78,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,78,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,78,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,49,52,73,115,108,97,110,100,67,97,108,108,98,97,99,107,69,0,0,0,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,55,67,108,111,115,101,115,116,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,0,0,0,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,0,0,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,78,49,50,98,116,67,111,110,118,101,120,67,97,115,116,49,48,67,97,115,116,82,101,115,117,108,116,69,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,0,0,51,53,98,116,83,101,113,117,101,110,116,105,97,108,73,109,112,117,108,115,101,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,0,0,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,51,52,98,116,67,108,111,115,101,115,116,78,111,116,77,101,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,0,0,0,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,0,0,0,0,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,51,49,98,116,73,110,116,101,114,110,97,108,84,114,105,97,110,103,108,101,73,110,100,101,120,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,51,49,98,116,68,101,102,97,117,108,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,0,0,0,0,0,0,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,51,48,98,116,71,106,107,69,112,97,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,0,0,0,0,0,0,0,51,48,98,116,67,111,110,118,101,120,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,0,0,0,0,0,0,0,51,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,67,114,101,97,116,101,70,117,110,99,0,0,0,0,0,0,0,0,51,48,98,116,65,99,116,105,118,97,116,105,110,103,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,0,50,56,98,116,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,0,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,0,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,50,55,98,116,67,111,110,116,105,110,117,111,117,115,67,111,110,118,101,120,67,111,108,108,105,115,105,111,110,0,0,0,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,50,53,98,116,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,0,0,0,0,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,0,0,0,0,0,50,53,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,0,0,50,52,98,116,80,101,114,116,117,114,98,101,100,67,111,110,116,97,99,116,82,101,115,117,108,116,0,0,0,0,0,0,50,52,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,0,0,0,0,0,50,52,98,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,0,0,0,0,0,50,52,98,116,66,114,111,97,100,112,104,97,115,101,65,97,98,98,67,97,108,108,98,97,99,107,0,0,0,0,0,0,50,51,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,118,101,120,83,104,97,112,101,0,0,0,0,0,0,0,50,51,98,116,68,105,115,99,114,101,116,101,68,121,110,97,109,105,99,115,87,111,114,108,100,0,0,0,0,0,0,0,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,50,51,98,116,67,111,108,108,105,115,105,111,110,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,50,51,98,116,66,114,111,97,100,112,104,97,115,101,82,97,121,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,50,50,98,116,83,117,98,115,105,109,112,108,101,120,67,111,110,118,101,120,67,97,115,116,0,0,0,0,0,0,0,0,50,50,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,0,0,0,0,0,0,0,50,50,98,116,67,111,109,112,111,117,110,100,76,101,97,102,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,50,50,83,112,104,101,114,101,84,114,105,97,110,103,108,101,68,101,116,101,99,116,111,114,0,0,0,0,0,0,0,0,50,49,98,116,83,105,110,103,108,101,83,119,101,101,112,67,97,108,108,98,97,99,107,0,50,49,98,116,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,50,49,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,0,50,49,98,116,67,111,108,108,105,115,105,111,110,68,105,115,112,97,116,99,104,101,114,0,50,49,98,116,66,114,111,97,100,112,104,97,115,101,73,110,116,101,114,102,97,99,101,0,50,48,98,116,68,101,102,97,117,108,116,77,111,116,105,111,110,83,116,97,116,101,0,0,50,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,50,48,66,114,111,97,100,112,104,97,115,101,65,97,98,98,84,101,115,116,101,114,0,0,49,57,98,116,83,105,110,103,108,101,82,97,121,67,97,108,108,98,97,99,107,0,0,0,49,57,66,114,111,97,100,112,104,97,115,101,82,97,121,84,101,115,116,101,114,0,0,0,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,0,0,0,49,56,98,116,68,98,118,116,84,114,101,101,67,111,108,108,105,100,101,114,0,0,0,0,49,56,98,116,67,111,110,118,101,120,80,111,108,121,104,101,100,114,111,110,0,0,0,0,49,56,98,116,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,0,0,0,49,55,98,116,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,0,0,0,0,49,55,98,116,71,106,107,80,97,105,114,68,101,116,101,99,116,111,114,0,0,0,0,0,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,0,0,0,0,0,49,55,68,101,98,117,103,68,114,97,119,99,97,108,108,98,97,99,107,0,0,0,0,0,49,54,98,116,80,111,105,110,116,67,111,108,108,101,99,116,111,114,0,0,0,0,0,0,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,0,0,0,0,0,0,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,49,54,98,116,68,98,118,116,66,114,111,97,100,112,104,97,115,101,0,0,0,0,0,0,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,0,0,0,0,0,0,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,0,0,0,0,0,0,49,54,98,116,66,111,120,66,111,120,68,101,116,101,99,116,111,114,0,0,0,0,0,0,49,53,98,116,84,114,105,97,110,103,108,101,83,104,97,112,101,0,0,0,0,0,0,0,49,53,98,116,71,106,107,67,111,110,118,101,120,67,97,115,116,0,0,0,0,0,0,0,49,53,98,116,68,121,110,97,109,105,99,115,87,111,114,108,100,0,0,0,0,0,0,0,49,51,98,116,83,112,104,101,114,101,83,104,97,112,101,0,49,51,98,116,77,111,116,105].concat([111,110,83,116,97,116,101,0,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,0,49,50,98,116,68,105,115,112,97,116,99,104,101,114,0,0,49,50,98,116,67,111,110,118,101,120,67,97,115,116,0,0,49,49,98,116,82,105,103,105,100,66,111,100,121,0,0,0,49,48,98,116,66,111,120,83,104,97,112,101,0,0,0,0,0,0,0,0,248,19,0,0,120,41,0,0,0,0,0,0,0,0,0,0,184,20,0,0,8,45,0,0,0,0,0,0,0,0,0,0,88,21,0,0,48,45,0,0,0,0,0,0,0,0,0,0,224,21,0,0,48,45,0,0,0,0,0,0,0,0,0,0,80,22,0,0,0,42,0,0,0,0,0,0,0,0,0,0,184,22,0,0,120,41,0,0,0,0,0,0,0,0,0,0,56,23,0,0,144,44,0,0,0,0,0,0,0,0,0,0,176,23,0,0,144,44,0,0,0,0,0,0,0,0,0,0,24,24,0,0,80,43,0,0,0,0,0,0,0,0,0,0,208,24,0,0,80,43,0,0,0,0,0,0,0,0,0,0,136,25,0,0,56,42,0,0,0,0,0,0,0,0,0,0,48,26,0,0,112,41,0,0,0,0,0,0,0,0,0,0,184,26,0,0,160,43,0,0,0,0,0,0,0,0,0,0,88,27,0,0,160,43,0,0,0,0,0,0,0,0,0,0,248,27,0,0,64,42,0,0,0,0,0,0,0,0,0,0,136,28,0,0,0,0,0,0,152,28,0,0,0,0,0,0,168,28,0,0,88,41,0,0,0,0,0,0,0,0,0,0,184,28,0,0,0,0,0,0,208,28,0,0,0,0,0,0,0,29,0,0,56,43,0,0,0,0,0,0,0,0,0,0,56,29,0,0,56,43,0,0,0,0,0,0,0,0,0,0,120,29,0,0,56,43,0,0,0,0,0,0,0,0,0,0,176,29,0,0,56,43,0,0,0,0,0,0,0,0,0,0,232,29,0,0,56,43,0,0,0,0,0,0,0,0,0,0,24,30,0,0,56,43,0,0,0,0,0,0,0,0,0,0,80,30,0,0,56,43,0,0,0,0,0,0,0,0,0,0,128,30,0,0,56,43,0,0,0,0,0,0,0,0,0,0,176,30,0,0,0,0,0,0,224,30,0,0,56,43,0,0,0,0,0,0,0,0,0,0,8,31,0,0,56,43,0,0,0,0,0,0,0,0,0,0,48,31,0,0,56,42,0,0,0,0,0,0,0,0,0,0,104,31,0,0,0,0,0,0,152,31,0,0,0,0,0,0,192,31,0,0,0,0,0,0,224,31,0,0,112,42,0,0,0,0,0,0,0,0,0,0,8,32,0,0,112,42,0,0,0,0,0,0,0,0,0,0,48,32,0,0,128,42,0,0,0,0,0,0,0,0,0,0,88,32,0,0,80,41,0,0,0,0,0,0,0,0,0,0,128,32,0,0,0,0,0,0,168,32,0,0,40,45,0,0,0,0,0,0,0,0,0,0,208,32,0,0,64,43,0,0,0,0,0,0,0,0,0,0,248,32,0,0,40,42,0,0,0,0,0,0,0,0,0,0,32,33,0,0,48,43,0,0,0,0,0,0,0,0,0,0,72,33,0,0,64,43,0,0,0,0,0,0,0,0,0,0,112,33,0,0,64,43,0,0,0,0,0,0,0,0,0,0,152,33,0,0,0,0,0,0,192,33,0,0,224,43,0,0,0,0,0,0,0,0,0,0,232,33,0,0,208,44,0,0,0,0,0,0,0,0,0,0,16,34,0,0,48,43,0,0,0,0,0,0,0,0,0,0,56,34,0,0,0,0,0,0,96,34,0,0,0,0,0,0,136,34,0,0,208,44,0,0,0,0,0,0,0,0,0,0,176,34,0,0,8,45,0,0,0,0,0,0,0,0,0,0,208,34,0,0,80,44,0,0,0,0,0,0,0,0,0,0,240,34,0,0,64,43,0,0,0,0,0,0,0,0,0,0,16,35,0,0,48,46,0,0,0,0,0,0,0,0,0,0,48,35,0,0,64,43,0,0,0,0,0,0,0,0,0,0,80,35,0,0,8,45,0,0,0,0,0,0,0,0,0,0,112,35,0,0,0,0,0,0,144,35,0,0,0,0,0,0,176,35,0,0,128,45,0,0,0,0,0,0,0,0,0,0,208,35,0,0,8,45,0,0,0,0,0,0,0,0,0,0,240,35,0,0,0,0,0,0,16,36,0,0,0,0,0,0,48,36,0,0,152,44,0,0,0,0,0,0,0,0,0,0,80,36,0,0,240,45,0,0,0,0,0,0,0,0,0,0,112,36,0,0,64,43,0,0,0,0,0,0,0,0,0,0,144,36,0,0,48,45,0,0,0,0,0,0,0,0,0,0,176,36,0,0,232,43,0,0,0,0,0,0,0,0,0,0,208,36,0,0,48,46,0,0,0,0,0,0,0,0,0,0,240,36,0,0,184,43,0,0,0,0,0,0,0,0,0,0,16,37,0,0,112,41,0,0,0,0,0,0,0,0,0,0,48,37,0,0,144,42,0,0,0,0,0,0,0,0,0,0,80,37,0,0,48,44,0,0,0,0,0,0,0,0,0,0,104,37,0,0,0,0,0,0,128,37,0,0,24,46,0,0,0,0,0,0,0,0,0,0,152,37,0,0,40,46,0,0,0,0,0,0,0,0,0,0,176,37,0,0,0,0,0,0,200,37,0,0,16,46,0,0,0,0,0,0,0,0,0,0,224,37,0,0,0,0,0,0,248,37,0,0,112,41,0,0,0,0,0,0,0,0,0,0,16,38,0,0,48,44,0,0,0,0,0,0,0,0,0,0,40,38,0,0,112,41,0,0,0,0,0,0,0,0,0,0,64,38,0,0,0,0,0,0,88,38,0,0,112,41,0,0,0,0,0,0,0,0,0,0,112,38,0,0,0,0,0,0,136,38,0,0,0,0,0,0,160,38,0,0,0,0,0,0,184,38,0,0,144,42,0,0,0,0,0,0,0,0,0,0,208,38,0,0,16,9,0,0,232,38,0,0,0,0,0,0,2,0,0,0,8,45,0,0,2,0,0,0,248,42,0,0,2,4,0,0,0,0,0,0,0,39,0,0,120,41,0,0,0,0,0,0,0,0,0,0,24,39,0,0,120,41,0,0,0,0,0,0,0,0,0,0,48,39,0,0,208,44,0,0,0,0,0,0,0,0,0,0,72,39,0,0,184,44,0,0,0,0,0,0,0,0,0,0,96,39,0,0,0,0,0,0,120,39,0,0,0,0,0,0,144,39,0,0,144,42,0,0,0,0,0,0,0,0,0,0,168,39,0,0,240,43,0,0,0,0,0,0,0,0,0,0,192,39,0,0,48,46,0,0,0,0,0,0,0,0,0,0,216,39,0,0,176,45,0,0,0,0,0,0,0,0,0,0,240,39,0,0,152,44,0,0,0,0,0,0,0,0,0,0,0,40,0,0,0,0,0,0,16,40,0,0,184,45,0,0,0,0,0,0,0,0,0,0,32,40,0,0,0,0,0,0,48,40,0,0,0,0,0,0,64,40,0,0,72,45,0,0,0,0,0,0,0,0,0,0,80,40,0,0,240,43,0,0,0,0,0,0,176,55,0,0,0,0,0,0,44,1,0,0,0,0,0,0,4,0,0,0,0,0,0,0,164,0,0,0,0,0,0,0,78,0,0,0,0,0,0,0])
, "i8", ALLOC_NONE, Runtime.GLOBAL_BASE)
var tempDoublePtr = Runtime.alignMemory(allocate(12, "i8", ALLOC_STATIC), 8);
assert(tempDoublePtr % 8 == 0);
function copyTempFloat(ptr) { // functions, because inlining this code increases code size too much
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
}
function copyTempDouble(ptr) {
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
  HEAP8[tempDoublePtr+4] = HEAP8[ptr+4];
  HEAP8[tempDoublePtr+5] = HEAP8[ptr+5];
  HEAP8[tempDoublePtr+6] = HEAP8[ptr+6];
  HEAP8[tempDoublePtr+7] = HEAP8[ptr+7];
}
  function ___gxx_personality_v0() {
    }
  function __exit(status) {
      // void _exit(int status);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/exit.html
      Module.print('exit(' + status + ') called');
      Module['exit'](status);
    }function _exit(status) {
      __exit(status);
    }function __ZSt9terminatev() {
      _exit(-1234);
    }
  var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:35,EIDRM:36,ECHRNG:37,EL2NSYNC:38,EL3HLT:39,EL3RST:40,ELNRNG:41,EUNATCH:42,ENOCSI:43,EL2HLT:44,EDEADLK:45,ENOLCK:46,EBADE:50,EBADR:51,EXFULL:52,ENOANO:53,EBADRQC:54,EBADSLT:55,EDEADLOCK:56,EBFONT:57,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:74,EDOTDOT:76,EBADMSG:77,ENOTUNIQ:80,EBADFD:81,EREMCHG:82,ELIBACC:83,ELIBBAD:84,ELIBSCN:85,ELIBMAX:86,ELIBEXEC:87,ENOSYS:88,ENOTEMPTY:90,ENAMETOOLONG:91,ELOOP:92,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:106,EPROTOTYPE:107,ENOTSOCK:108,ENOPROTOOPT:109,ESHUTDOWN:110,ECONNREFUSED:111,EADDRINUSE:112,ECONNABORTED:113,ENETUNREACH:114,ENETDOWN:115,ETIMEDOUT:116,EHOSTDOWN:117,EHOSTUNREACH:118,EINPROGRESS:119,EALREADY:120,EDESTADDRREQ:121,EMSGSIZE:122,EPROTONOSUPPORT:123,ESOCKTNOSUPPORT:124,EADDRNOTAVAIL:125,ENETRESET:126,EISCONN:127,ENOTCONN:128,ETOOMANYREFS:129,EUSERS:131,EDQUOT:132,ESTALE:133,ENOTSUP:134,ENOMEDIUM:135,EILSEQ:138,EOVERFLOW:139,ECANCELED:140,ENOTRECOVERABLE:141,EOWNERDEAD:142,ESTRPIPE:143};
  var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"No message of desired type",36:"Identifier removed",37:"Channel number out of range",38:"Level 2 not synchronized",39:"Level 3 halted",40:"Level 3 reset",41:"Link number out of range",42:"Protocol driver not attached",43:"No CSI structure available",44:"Level 2 halted",45:"Deadlock condition",46:"No record locks available",50:"Invalid exchange",51:"Invalid request descriptor",52:"Exchange full",53:"No anode",54:"Invalid request code",55:"Invalid slot",56:"File locking deadlock error",57:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",74:"Multihop attempted",76:"Cross mount point (not really error)",77:"Trying to read unreadable message",80:"Given log. name not unique",81:"f.d. invalid for this operation",82:"Remote address changed",83:"Can   access a needed shared lib",84:"Accessing a corrupted shared lib",85:".lib section in a.out corrupted",86:"Attempting to link in too many libs",87:"Attempting to exec a shared library",88:"Function not implemented",90:"Directory not empty",91:"File or path name too long",92:"Too many symbolic links",95:"Operation not supported on transport endpoint",96:"Protocol family not supported",104:"Connection reset by peer",105:"No buffer space available",106:"Address family not supported by protocol family",107:"Protocol wrong type for socket",108:"Socket operation on non-socket",109:"Protocol not available",110:"Can't send after socket shutdown",111:"Connection refused",112:"Address already in use",113:"Connection aborted",114:"Network is unreachable",115:"Network interface is not configured",116:"Connection timed out",117:"Host is down",118:"Host is unreachable",119:"Connection already in progress",120:"Socket already connected",121:"Destination address required",122:"Message too long",123:"Unknown protocol",124:"Socket type not supported",125:"Address not available",126:"Connection reset by network",127:"Socket is already connected",128:"Socket is not connected",129:"Too many references",131:"Too many users",132:"Quota exceeded",133:"Stale file handle",134:"Not supported",135:"No medium (in tape drive)",138:"Illegal byte sequence",139:"Value too large for defined data type",140:"Operation canceled",141:"State not recoverable",142:"Previous owner died",143:"Streams pipe error"};
  var ___errno_state=0;function ___setErrNo(value) {
      // For convenient setting and returning of errno.
      HEAP32[((___errno_state)>>2)]=value
      return value;
    }
  var VFS=undefined;
  var PATH={splitPath:function (filename) {
        var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
        return splitPathRe.exec(filename).slice(1);
      },normalizeArray:function (parts, allowAboveRoot) {
        // if the path tries to go above the root, `up` ends up > 0
        var up = 0;
        for (var i = parts.length - 1; i >= 0; i--) {
          var last = parts[i];
          if (last === '.') {
            parts.splice(i, 1);
          } else if (last === '..') {
            parts.splice(i, 1);
            up++;
          } else if (up) {
            parts.splice(i, 1);
            up--;
          }
        }
        // if the path is allowed to go above the root, restore leading ..s
        if (allowAboveRoot) {
          for (; up--; up) {
            parts.unshift('..');
          }
        }
        return parts;
      },normalize:function (path) {
        var isAbsolute = path.charAt(0) === '/',
            trailingSlash = path.substr(-1) === '/';
        // Normalize the path
        path = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), !isAbsolute).join('/');
        if (!path && !isAbsolute) {
          path = '.';
        }
        if (path && trailingSlash) {
          path += '/';
        }
        return (isAbsolute ? '/' : '') + path;
      },dirname:function (path) {
        var result = PATH.splitPath(path),
            root = result[0],
            dir = result[1];
        if (!root && !dir) {
          // No dirname whatsoever
          return '.';
        }
        if (dir) {
          // It has a dirname, strip trailing slash
          dir = dir.substr(0, dir.length - 1);
        }
        return root + dir;
      },basename:function (path, ext) {
        // EMSCRIPTEN return '/'' for '/', not an empty string
        if (path === '/') return '/';
        var f = PATH.splitPath(path)[2];
        if (ext && f.substr(-1 * ext.length) === ext) {
          f = f.substr(0, f.length - ext.length);
        }
        return f;
      },extname:function (path) {
        return PATH.splitPath(path)[3];
      },join:function () {
        var paths = Array.prototype.slice.call(arguments, 0);
        return PATH.normalize(paths.filter(function(p, index) {
          if (typeof p !== 'string') {
            throw new TypeError('Arguments to path.join must be strings');
          }
          return p;
        }).join('/'));
      },resolve:function () {
        var resolvedPath = '',
          resolvedAbsolute = false;
        for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
          var path = (i >= 0) ? arguments[i] : FS.cwd();
          // Skip empty and invalid entries
          if (typeof path !== 'string') {
            throw new TypeError('Arguments to path.resolve must be strings');
          } else if (!path) {
            continue;
          }
          resolvedPath = path + '/' + resolvedPath;
          resolvedAbsolute = path.charAt(0) === '/';
        }
        // At this point the path should be resolved to a full absolute path, but
        // handle relative paths to be safe (might happen when process.cwd() fails)
        resolvedPath = PATH.normalizeArray(resolvedPath.split('/').filter(function(p) {
          return !!p;
        }), !resolvedAbsolute).join('/');
        return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
      },relative:function (from, to) {
        from = PATH.resolve(from).substr(1);
        to = PATH.resolve(to).substr(1);
        function trim(arr) {
          var start = 0;
          for (; start < arr.length; start++) {
            if (arr[start] !== '') break;
          }
          var end = arr.length - 1;
          for (; end >= 0; end--) {
            if (arr[end] !== '') break;
          }
          if (start > end) return [];
          return arr.slice(start, end - start + 1);
        }
        var fromParts = trim(from.split('/'));
        var toParts = trim(to.split('/'));
        var length = Math.min(fromParts.length, toParts.length);
        var samePartsLength = length;
        for (var i = 0; i < length; i++) {
          if (fromParts[i] !== toParts[i]) {
            samePartsLength = i;
            break;
          }
        }
        var outputParts = [];
        for (var i = samePartsLength; i < fromParts.length; i++) {
          outputParts.push('..');
        }
        outputParts = outputParts.concat(toParts.slice(samePartsLength));
        return outputParts.join('/');
      }};
  var TTY={ttys:[],init:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // currently, FS.init does not distinguish if process.stdin is a file or TTY
        //   // device, it always assumes it's a TTY device. because of this, we're forcing
        //   // process.stdin to UTF8 encoding to at least make stdin reading compatible
        //   // with text files until FS.init can be refactored.
        //   process['stdin']['setEncoding']('utf8');
        // }
      },shutdown:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // inolen: any idea as to why node -e 'process.stdin.read()' wouldn't exit immediately (with process.stdin being a tty)?
        //   // isaacs: because now it's reading from the stream, you've expressed interest in it, so that read() kicks off a _read() which creates a ReadReq operation
        //   // inolen: I thought read() in that case was a synchronous operation that just grabbed some amount of buffered data if it exists?
        //   // isaacs: it is. but it also triggers a _read() call, which calls readStart() on the handle
        //   // isaacs: do process.stdin.pause() and i'd think it'd probably close the pending call
        //   process['stdin']['pause']();
        // }
      },register:function (dev, ops) {
        TTY.ttys[dev] = { input: [], output: [], ops: ops };
        FS.registerDevice(dev, TTY.stream_ops);
      },stream_ops:{open:function (stream) {
          var tty = TTY.ttys[stream.node.rdev];
          if (!tty) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          stream.tty = tty;
          stream.seekable = false;
        },close:function (stream) {
          // flush any pending line data
          if (stream.tty.output.length) {
            stream.tty.ops.put_char(stream.tty, 10);
          }
        },read:function (stream, buffer, offset, length, pos /* ignored */) {
          if (!stream.tty || !stream.tty.ops.get_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          var bytesRead = 0;
          for (var i = 0; i < length; i++) {
            var result;
            try {
              result = stream.tty.ops.get_char(stream.tty);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            if (result === undefined && bytesRead === 0) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
            if (result === null || result === undefined) break;
            bytesRead++;
            buffer[offset+i] = result;
          }
          if (bytesRead) {
            stream.node.timestamp = Date.now();
          }
          return bytesRead;
        },write:function (stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.put_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          for (var i = 0; i < length; i++) {
            try {
              stream.tty.ops.put_char(stream.tty, buffer[offset+i]);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
          }
          if (length) {
            stream.node.timestamp = Date.now();
          }
          return i;
        }},default_tty_ops:{get_char:function (tty) {
          if (!tty.input.length) {
            var result = null;
            if (ENVIRONMENT_IS_NODE) {
              result = process['stdin']['read']();
              if (!result) {
                if (process['stdin']['_readableState'] && process['stdin']['_readableState']['ended']) {
                  return null;  // EOF
                }
                return undefined;  // no data available
              }
            } else if (typeof window != 'undefined' &&
              typeof window.prompt == 'function') {
              // Browser.
              result = window.prompt('Input: ');  // returns null on cancel
              if (result !== null) {
                result += '\n';
              }
            } else if (typeof readline == 'function') {
              // Command line.
              result = readline();
              if (result !== null) {
                result += '\n';
              }
            }
            if (!result) {
              return null;
            }
            tty.input = intArrayFromString(result, true);
          }
          return tty.input.shift();
        },put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['print'](tty.output.join(''));
            tty.output = [];
          } else {
            tty.output.push(TTY.utf8.processCChar(val));
          }
        }},default_tty1_ops:{put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['printErr'](tty.output.join(''));
            tty.output = [];
          } else {
            tty.output.push(TTY.utf8.processCChar(val));
          }
        }}};
  var MEMFS={CONTENT_OWNING:1,CONTENT_FLEXIBLE:2,CONTENT_FIXED:3,ensureFlexible:function (node) {
        if (node.contentMode !== MEMFS.CONTENT_FLEXIBLE) {
          var contents = node.contents;
          node.contents = Array.prototype.slice.call(contents);
          node.contentMode = MEMFS.CONTENT_FLEXIBLE;
        }
      },mount:function (mount) {
        return MEMFS.create_node(null, '/', 0040000 | 0777, 0);
      },create_node:function (parent, name, mode, dev) {
        if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
          // no supported
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        var node = FS.createNode(parent, name, mode, dev);
        if (FS.isDir(node.mode)) {
          node.node_ops = {
            getattr: MEMFS.node_ops.getattr,
            setattr: MEMFS.node_ops.setattr,
            lookup: MEMFS.node_ops.lookup,
            mknod: MEMFS.node_ops.mknod,
            mknod: MEMFS.node_ops.mknod,
            rename: MEMFS.node_ops.rename,
            unlink: MEMFS.node_ops.unlink,
            rmdir: MEMFS.node_ops.rmdir,
            readdir: MEMFS.node_ops.readdir,
            symlink: MEMFS.node_ops.symlink
          };
          node.stream_ops = {
            llseek: MEMFS.stream_ops.llseek
          };
          node.contents = {};
        } else if (FS.isFile(node.mode)) {
          node.node_ops = {
            getattr: MEMFS.node_ops.getattr,
            setattr: MEMFS.node_ops.setattr
          };
          node.stream_ops = {
            llseek: MEMFS.stream_ops.llseek,
            read: MEMFS.stream_ops.read,
            write: MEMFS.stream_ops.write,
            allocate: MEMFS.stream_ops.allocate,
            mmap: MEMFS.stream_ops.mmap
          };
          node.contents = [];
          node.contentMode = MEMFS.CONTENT_FLEXIBLE;
        } else if (FS.isLink(node.mode)) {
          node.node_ops = {
            getattr: MEMFS.node_ops.getattr,
            setattr: MEMFS.node_ops.setattr,
            readlink: MEMFS.node_ops.readlink
          };
          node.stream_ops = {};
        } else if (FS.isChrdev(node.mode)) {
          node.node_ops = {
            getattr: MEMFS.node_ops.getattr,
            setattr: MEMFS.node_ops.setattr
          };
          node.stream_ops = FS.chrdev_stream_ops;
        }
        node.timestamp = Date.now();
        // add the new node to the parent
        if (parent) {
          parent.contents[name] = node;
        }
        return node;
      },node_ops:{getattr:function (node) {
          var attr = {};
          // device numbers reuse inode numbers.
          attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
          attr.ino = node.id;
          attr.mode = node.mode;
          attr.nlink = 1;
          attr.uid = 0;
          attr.gid = 0;
          attr.rdev = node.rdev;
          if (FS.isDir(node.mode)) {
            attr.size = 4096;
          } else if (FS.isFile(node.mode)) {
            attr.size = node.contents.length;
          } else if (FS.isLink(node.mode)) {
            attr.size = node.link.length;
          } else {
            attr.size = 0;
          }
          attr.atime = new Date(node.timestamp);
          attr.mtime = new Date(node.timestamp);
          attr.ctime = new Date(node.timestamp);
          // NOTE: In our implementation, st_blocks = Math.ceil(st_size/st_blksize),
          //       but this is not required by the standard.
          attr.blksize = 4096;
          attr.blocks = Math.ceil(attr.size / attr.blksize);
          return attr;
        },setattr:function (node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp;
          }
          if (attr.size !== undefined) {
            MEMFS.ensureFlexible(node);
            var contents = node.contents;
            if (attr.size < contents.length) contents.length = attr.size;
            else while (attr.size > contents.length) contents.push(0);
          }
        },lookup:function (parent, name) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        },mknod:function (parent, name, mode, dev) {
          return MEMFS.create_node(parent, name, mode, dev);
        },rename:function (old_node, new_dir, new_name) {
          // if we're overwriting a directory at new_name, make sure it's empty.
          if (FS.isDir(old_node.mode)) {
            var new_node;
            try {
              new_node = FS.lookupNode(new_dir, new_name);
            } catch (e) {
            }
            if (new_node) {
              for (var i in new_node.contents) {
                throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
              }
            }
          }
          // do the internal rewiring
          delete old_node.parent.contents[old_node.name];
          old_node.name = new_name;
          new_dir.contents[new_name] = old_node;
        },unlink:function (parent, name) {
          delete parent.contents[name];
        },rmdir:function (parent, name) {
          var node = FS.lookupNode(parent, name);
          for (var i in node.contents) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
          }
          delete parent.contents[name];
        },readdir:function (node) {
          var entries = ['.', '..']
          for (var key in node.contents) {
            if (!node.contents.hasOwnProperty(key)) {
              continue;
            }
            entries.push(key);
          }
          return entries;
        },symlink:function (parent, newname, oldpath) {
          var node = MEMFS.create_node(parent, newname, 0777 | 0120000, 0);
          node.link = oldpath;
          return node;
        },readlink:function (node) {
          if (!FS.isLink(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return node.link;
        }},stream_ops:{read:function (stream, buffer, offset, length, position) {
          var contents = stream.node.contents;
          var size = Math.min(contents.length - position, length);
          if (size > 8 && contents.subarray) { // non-trivial, and typed array
            buffer.set(contents.subarray(position, position + size), offset);
          } else
          {
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          }
          return size;
        },write:function (stream, buffer, offset, length, position, canOwn) {
          var node = stream.node;
          node.timestamp = Date.now();
          var contents = node.contents;
          if (length && contents.length === 0 && position === 0 && buffer.subarray) {
            // just replace it with the new data
            assert(buffer.length);
            if (canOwn && buffer.buffer === HEAP8.buffer && offset === 0) {
              node.contents = buffer; // this is a subarray of the heap, and we can own it
              node.contentMode = MEMFS.CONTENT_OWNING;
            } else {
              node.contents = new Uint8Array(buffer.subarray(offset, offset+length));
              node.contentMode = MEMFS.CONTENT_FIXED;
            }
            return length;
          }
          MEMFS.ensureFlexible(node);
          var contents = node.contents;
          while (contents.length < position) contents.push(0);
          for (var i = 0; i < length; i++) {
            contents[position + i] = buffer[offset + i];
          }
          return length;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.contents.length;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          stream.ungotten = [];
          stream.position = position;
          return position;
        },allocate:function (stream, offset, length) {
          MEMFS.ensureFlexible(stream.node);
          var contents = stream.node.contents;
          var limit = offset + length;
          while (limit > contents.length) contents.push(0);
        },mmap:function (stream, buffer, offset, length, position, prot, flags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          var ptr;
          var allocated;
          var contents = stream.node.contents;
          // Only make a new copy when MAP_PRIVATE is specified.
          if ( !(flags & 0x02) &&
                (contents.buffer === buffer || contents.buffer === buffer.buffer) ) {
            // We can't emulate MAP_SHARED when the file is not backed by the buffer
            // we're mapping to (e.g. the HEAP buffer).
            allocated = false;
            ptr = contents.byteOffset;
          } else {
            // Try to avoid unnecessary slices.
            if (position > 0 || position + length < contents.length) {
              if (contents.subarray) {
                contents = contents.subarray(position, position + length);
              } else {
                contents = Array.prototype.slice.call(contents, position, position + length);
              }
            }
            allocated = true;
            ptr = _malloc(length);
            if (!ptr) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOMEM);
            }
            buffer.set(contents, ptr);
          }
          return { ptr: ptr, allocated: allocated };
        }}};
  var _stdin=allocate(1, "i32*", ALLOC_STATIC);
  var _stdout=allocate(1, "i32*", ALLOC_STATIC);
  var _stderr=allocate(1, "i32*", ALLOC_STATIC);
  function _fflush(stream) {
      // int fflush(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fflush.html
      // we don't currently perform any user-space buffering of data
    }var FS={root:null,devices:[null],streams:[null],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,ErrnoError:function ErrnoError(errno) {
          this.errno = errno;
          for (var key in ERRNO_CODES) {
            if (ERRNO_CODES[key] === errno) {
              this.code = key;
              break;
            }
          }
          this.message = ERRNO_MESSAGES[errno];
        },handleFSError:function (e) {
        if (!(e instanceof FS.ErrnoError)) throw e + ' : ' + new Error().stack;
        return ___setErrNo(e.errno);
      },cwd:function () {
        return FS.currentPath;
      },lookupPath:function (path, opts) {
        path = PATH.resolve(FS.currentPath, path);
        opts = opts || { recurse_count: 0 };
        if (opts.recurse_count > 8) {  // max recursive lookup of 8
          throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
        }
        // split the path
        var parts = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), false);
        // start at the root
        var current = FS.root;
        var current_path = '/';
        for (var i = 0; i < parts.length; i++) {
          var islast = (i === parts.length-1);
          if (islast && opts.parent) {
            // stop resolving
            break;
          }
          current = FS.lookupNode(current, parts[i]);
          current_path = PATH.join(current_path, parts[i]);
          // jump to the mount's root node if this is a mountpoint
          if (FS.isMountpoint(current)) {
            current = current.mount.root;
          }
          // follow symlinks
          // by default, lookupPath will not follow a symlink if it is the final path component.
          // setting opts.follow = true will override this behavior.
          if (!islast || opts.follow) {
            var count = 0;
            while (FS.isLink(current.mode)) {
              var link = FS.readlink(current_path);
              current_path = PATH.resolve(PATH.dirname(current_path), link);
              var lookup = FS.lookupPath(current_path, { recurse_count: opts.recurse_count });
              current = lookup.node;
              if (count++ > 40) {  // limit max consecutive symlinks to 40 (SYMLOOP_MAX).
                throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
              }
            }
          }
        }
        return { path: current_path, node: current };
      },getPath:function (node) {
        var path;
        while (true) {
          if (FS.isRoot(node)) {
            return path ? PATH.join(node.mount.mountpoint, path) : node.mount.mountpoint;
          }
          path = path ? PATH.join(node.name, path) : node.name;
          node = node.parent;
        }
      },hashName:function (parentid, name) {
        var hash = 0;
        for (var i = 0; i < name.length; i++) {
          hash = ((hash << 5) - hash + name.charCodeAt(i)) | 0;
        }
        return ((parentid + hash) >>> 0) % FS.nameTable.length;
      },hashAddNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        node.name_next = FS.nameTable[hash];
        FS.nameTable[hash] = node;
      },hashRemoveNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        if (FS.nameTable[hash] === node) {
          FS.nameTable[hash] = node.name_next;
        } else {
          var current = FS.nameTable[hash];
          while (current) {
            if (current.name_next === node) {
              current.name_next = node.name_next;
              break;
            }
            current = current.name_next;
          }
        }
      },lookupNode:function (parent, name) {
        var err = FS.mayLookup(parent);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        var hash = FS.hashName(parent.id, name);
        for (var node = FS.nameTable[hash]; node; node = node.name_next) {
          if (node.parent.id === parent.id && node.name === name) {
            return node;
          }
        }
        // if we failed to find it in the cache, call into the VFS
        return FS.lookup(parent, name);
      },createNode:function (parent, name, mode, rdev) {
        var node = {
          id: FS.nextInode++,
          name: name,
          mode: mode,
          node_ops: {},
          stream_ops: {},
          rdev: rdev,
          parent: null,
          mount: null
        };
        if (!parent) {
          parent = node;  // root node sets parent to itself
        }
        node.parent = parent;
        node.mount = parent.mount;
        // compatibility
        var readMode = 292 | 73;
        var writeMode = 146;
        // NOTE we must use Object.defineProperties instead of individual calls to
        // Object.defineProperty in order to make closure compiler happy
        Object.defineProperties(node, {
          read: {
            get: function() { return (node.mode & readMode) === readMode; },
            set: function(val) { val ? node.mode |= readMode : node.mode &= ~readMode; }
          },
          write: {
            get: function() { return (node.mode & writeMode) === writeMode; },
            set: function(val) { val ? node.mode |= writeMode : node.mode &= ~writeMode; }
          },
          isFolder: {
            get: function() { return FS.isDir(node.mode); },
          },
          isDevice: {
            get: function() { return FS.isChrdev(node.mode); },
          },
        });
        FS.hashAddNode(node);
        return node;
      },destroyNode:function (node) {
        FS.hashRemoveNode(node);
      },isRoot:function (node) {
        return node === node.parent;
      },isMountpoint:function (node) {
        return node.mounted;
      },isFile:function (mode) {
        return (mode & 0170000) === 0100000;
      },isDir:function (mode) {
        return (mode & 0170000) === 0040000;
      },isLink:function (mode) {
        return (mode & 0170000) === 0120000;
      },isChrdev:function (mode) {
        return (mode & 0170000) === 0020000;
      },isBlkdev:function (mode) {
        return (mode & 0170000) === 0060000;
      },isFIFO:function (mode) {
        return (mode & 0170000) === 0010000;
      },isSocket:function (mode) {
        return (mode & 0140000) === 0140000;
      },flagModes:{"r":0,"rs":8192,"r+":2,"w":1537,"wx":3585,"xw":3585,"w+":1538,"wx+":3586,"xw+":3586,"a":521,"ax":2569,"xa":2569,"a+":522,"ax+":2570,"xa+":2570},modeStringToFlags:function (str) {
        var flags = FS.flagModes[str];
        if (typeof flags === 'undefined') {
          throw new Error('Unknown file open mode: ' + str);
        }
        return flags;
      },flagsToPermissionString:function (flag) {
        var accmode = flag & 3;
        var perms = ['r', 'w', 'rw'][accmode];
        if ((flag & 1024)) {
          perms += 'w';
        }
        return perms;
      },nodePermissions:function (node, perms) {
        if (FS.ignorePermissions) {
          return 0;
        }
        // return 0 if any user, group or owner bits are set.
        if (perms.indexOf('r') !== -1 && !(node.mode & 292)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('w') !== -1 && !(node.mode & 146)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('x') !== -1 && !(node.mode & 73)) {
          return ERRNO_CODES.EACCES;
        }
        return 0;
      },mayLookup:function (dir) {
        return FS.nodePermissions(dir, 'x');
      },mayCreate:function (dir, name) {
        try {
          var node = FS.lookupNode(dir, name);
          return ERRNO_CODES.EEXIST;
        } catch (e) {
        }
        return FS.nodePermissions(dir, 'wx');
      },mayDelete:function (dir, name, isdir) {
        var node;
        try {
          node = FS.lookupNode(dir, name);
        } catch (e) {
          return e.errno;
        }
        var err = FS.nodePermissions(dir, 'wx');
        if (err) {
          return err;
        }
        if (isdir) {
          if (!FS.isDir(node.mode)) {
            return ERRNO_CODES.ENOTDIR;
          }
          if (FS.isRoot(node) || FS.getPath(node) === FS.currentPath) {
            return ERRNO_CODES.EBUSY;
          }
        } else {
          if (FS.isDir(node.mode)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return 0;
      },mayOpen:function (node, flags) {
        if (!node) {
          return ERRNO_CODES.ENOENT;
        }
        if (FS.isLink(node.mode)) {
          return ERRNO_CODES.ELOOP;
        } else if (FS.isDir(node.mode)) {
          if ((flags & 3) !== 0 ||  // opening for write
              (flags & 1024)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
      },MAX_OPEN_FDS:4096,nextfd:function (fd_start, fd_end) {
        fd_start = fd_start || 1;
        fd_end = fd_end || FS.MAX_OPEN_FDS;
        for (var fd = fd_start; fd <= fd_end; fd++) {
          if (!FS.streams[fd]) {
            return fd;
          }
        }
        throw new FS.ErrnoError(ERRNO_CODES.EMFILE);
      },getStream:function (fd) {
        return FS.streams[fd];
      },createStream:function (stream, fd_start, fd_end) {
        var fd = FS.nextfd(fd_start, fd_end);
        stream.fd = fd;
        // compatibility
        Object.defineProperties(stream, {
          object: {
            get: function() { return stream.node; },
            set: function(val) { stream.node = val; }
          },
          isRead: {
            get: function() { return (stream.flags & 3) !== 1; }
          },
          isWrite: {
            get: function() { return (stream.flags & 3) !== 0; }
          },
          isAppend: {
            get: function() { return (stream.flags & 8); }
          }
        });
        FS.streams[fd] = stream;
        return stream;
      },closeStream:function (fd) {
        FS.streams[fd] = null;
      },chrdev_stream_ops:{open:function (stream) {
          var device = FS.getDevice(stream.node.rdev);
          // override node's stream ops with the device's
          stream.stream_ops = device.stream_ops;
          // forward the open call
          if (stream.stream_ops.open) {
            stream.stream_ops.open(stream);
          }
        },llseek:function () {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }},major:function (dev) {
        return ((dev) >> 8);
      },minor:function (dev) {
        return ((dev) & 0xff);
      },makedev:function (ma, mi) {
        return ((ma) << 8 | (mi));
      },registerDevice:function (dev, ops) {
        FS.devices[dev] = { stream_ops: ops };
      },getDevice:function (dev) {
        return FS.devices[dev];
      },mount:function (type, opts, mountpoint) {
        var mount = {
          type: type,
          opts: opts,
          mountpoint: mountpoint,
          root: null
        };
        var lookup;
        if (mountpoint) {
          lookup = FS.lookupPath(mountpoint, { follow: false });
        }
        // create a root node for the fs
        var root = type.mount(mount);
        root.mount = mount;
        mount.root = root;
        // assign the mount info to the mountpoint's node
        if (lookup) {
          lookup.node.mount = mount;
          lookup.node.mounted = true;
          // compatibility update FS.root if we mount to /
          if (mountpoint === '/') {
            FS.root = mount.root;
          }
        }
        return root;
      },lookup:function (parent, name) {
        return parent.node_ops.lookup(parent, name);
      },mknod:function (path, mode, dev) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var err = FS.mayCreate(parent, name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.mknod) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.mknod(parent, name, mode, dev);
      },create:function (path, mode) {
        mode = mode !== undefined ? mode : 0666;
        mode &= 4095;
        mode |= 0100000;
        return FS.mknod(path, mode, 0);
      },mkdir:function (path, mode) {
        mode = mode !== undefined ? mode : 0777;
        mode &= 511 | 0001000;
        mode |= 0040000;
        return FS.mknod(path, mode, 0);
      },mkdev:function (path, mode, dev) {
        if (typeof(dev) === 'undefined') {
          dev = mode;
          mode = 0666;
        }
        mode |= 0020000;
        return FS.mknod(path, mode, dev);
      },symlink:function (oldpath, newpath) {
        var lookup = FS.lookupPath(newpath, { parent: true });
        var parent = lookup.node;
        var newname = PATH.basename(newpath);
        var err = FS.mayCreate(parent, newname);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.symlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.symlink(parent, newname, oldpath);
      },rename:function (old_path, new_path) {
        var old_dirname = PATH.dirname(old_path);
        var new_dirname = PATH.dirname(new_path);
        var old_name = PATH.basename(old_path);
        var new_name = PATH.basename(new_path);
        // parents must exist
        var lookup, old_dir, new_dir;
        try {
          lookup = FS.lookupPath(old_path, { parent: true });
          old_dir = lookup.node;
          lookup = FS.lookupPath(new_path, { parent: true });
          new_dir = lookup.node;
        } catch (e) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // need to be part of the same mount
        if (old_dir.mount !== new_dir.mount) {
          throw new FS.ErrnoError(ERRNO_CODES.EXDEV);
        }
        // source must exist
        var old_node = FS.lookupNode(old_dir, old_name);
        // old path should not be an ancestor of the new path
        var relative = PATH.relative(old_path, new_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        // new path should not be an ancestor of the old path
        relative = PATH.relative(new_path, old_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
        }
        // see if the new path already exists
        var new_node;
        try {
          new_node = FS.lookupNode(new_dir, new_name);
        } catch (e) {
          // not fatal
        }
        // early out if nothing needs to change
        if (old_node === new_node) {
          return;
        }
        // we'll need to delete the old entry
        var isdir = FS.isDir(old_node.mode);
        var err = FS.mayDelete(old_dir, old_name, isdir);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        // need delete permissions if we'll be overwriting.
        // need create permissions if new doesn't already exist.
        err = new_node ?
          FS.mayDelete(new_dir, new_name, isdir) :
          FS.mayCreate(new_dir, new_name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!old_dir.node_ops.rename) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(old_node) || (new_node && FS.isMountpoint(new_node))) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // if we are going to change the parent, check write permissions
        if (new_dir !== old_dir) {
          err = FS.nodePermissions(old_dir, 'w');
          if (err) {
            throw new FS.ErrnoError(err);
          }
        }
        // remove the node from the lookup hash
        FS.hashRemoveNode(old_node);
        // do the underlying fs rename
        try {
          old_dir.node_ops.rename(old_node, new_dir, new_name);
        } catch (e) {
          throw e;
        } finally {
          // add the node back to the hash (in case node_ops.rename
          // changed its name)
          FS.hashAddNode(old_node);
        }
      },rmdir:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, true);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.rmdir) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        parent.node_ops.rmdir(parent, name);
        FS.destroyNode(node);
      },readdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        if (!node.node_ops.readdir) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        return node.node_ops.readdir(node);
      },unlink:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, false);
        if (err) {
          // POSIX says unlink should set EPERM, not EISDIR
          if (err === ERRNO_CODES.EISDIR) err = ERRNO_CODES.EPERM;
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.unlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        parent.node_ops.unlink(parent, name);
        FS.destroyNode(node);
      },readlink:function (path) {
        var lookup = FS.lookupPath(path, { follow: false });
        var link = lookup.node;
        if (!link.node_ops.readlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        return link.node_ops.readlink(link);
      },stat:function (path, dontFollow) {
        var lookup = FS.lookupPath(path, { follow: !dontFollow });
        var node = lookup.node;
        if (!node.node_ops.getattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return node.node_ops.getattr(node);
      },lstat:function (path) {
        return FS.stat(path, true);
      },chmod:function (path, mode, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          mode: (mode & 4095) | (node.mode & ~4095),
          timestamp: Date.now()
        });
      },lchmod:function (path, mode) {
        FS.chmod(path, mode, true);
      },fchmod:function (fd, mode) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chmod(stream.node, mode);
      },chown:function (path, uid, gid, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          timestamp: Date.now()
          // we ignore the uid / gid for now
        });
      },lchown:function (path, uid, gid) {
        FS.chown(path, uid, gid, true);
      },fchown:function (fd, uid, gid) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chown(stream.node, uid, gid);
      },truncate:function (path, len) {
        if (len < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: true });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!FS.isFile(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var err = FS.nodePermissions(node, 'w');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        node.node_ops.setattr(node, {
          size: len,
          timestamp: Date.now()
        });
      },ftruncate:function (fd, len) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if ((stream.flags & 3) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        FS.truncate(stream.node, len);
      },utime:function (path, atime, mtime) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        node.node_ops.setattr(node, {
          timestamp: Math.max(atime, mtime)
        });
      },open:function (path, flags, mode, fd_start, fd_end) {
        path = PATH.normalize(path);
        flags = typeof flags === 'string' ? FS.modeStringToFlags(flags) : flags;
        mode = typeof mode === 'undefined' ? 0666 : mode;
        if ((flags & 512)) {
          mode = (mode & 4095) | 0100000;
        } else {
          mode = 0;
        }
        var node;
        try {
          var lookup = FS.lookupPath(path, {
            follow: !(flags & 0200000)
          });
          node = lookup.node;
          path = lookup.path;
        } catch (e) {
          // ignore
        }
        // perhaps we need to create the node
        if ((flags & 512)) {
          if (node) {
            // if O_CREAT and O_EXCL are set, error out if the node already exists
            if ((flags & 2048)) {
              throw new FS.ErrnoError(ERRNO_CODES.EEXIST);
            }
          } else {
            // node doesn't exist, try to create it
            node = FS.mknod(path, mode, 0);
          }
        }
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        // can't truncate a device
        if (FS.isChrdev(node.mode)) {
          flags &= ~1024;
        }
        // check permissions
        var err = FS.mayOpen(node, flags);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        // do truncation if necessary
        if ((flags & 1024)) {
          FS.truncate(node, 0);
        }
        // register the stream with the filesystem
        var stream = FS.createStream({
          path: path,
          node: node,
          flags: flags,
          seekable: true,
          position: 0,
          stream_ops: node.stream_ops,
          // used by the file family libc calls (fopen, fwrite, ferror, etc.)
          ungotten: [],
          error: false
        }, fd_start, fd_end);
        // call the new stream's open function
        if (stream.stream_ops.open) {
          stream.stream_ops.open(stream);
        }
        return stream;
      },close:function (stream) {
        try {
          if (stream.stream_ops.close) {
            stream.stream_ops.close(stream);
          }
        } catch (e) {
          throw e;
        } finally {
          FS.closeStream(stream.fd);
        }
      },llseek:function (stream, offset, whence) {
        if (!stream.seekable || !stream.stream_ops.llseek) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        return stream.stream_ops.llseek(stream, offset, whence);
      },read:function (stream, buffer, offset, length, position) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 3) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.read) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
        if (!seeking) stream.position += bytesRead;
        return bytesRead;
      },write:function (stream, buffer, offset, length, position, canOwn) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 3) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.write) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        if (stream.flags & 8) {
          // seek to the end before writing in append mode
          FS.llseek(stream, 0, 2);
        }
        var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
        if (!seeking) stream.position += bytesWritten;
        return bytesWritten;
      },allocate:function (stream, offset, length) {
        if (offset < 0 || length <= 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 3) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (!FS.isFile(stream.node.mode) && !FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        if (!stream.stream_ops.allocate) {
          throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
        }
        stream.stream_ops.allocate(stream, offset, length);
      },mmap:function (stream, buffer, offset, length, position, prot, flags) {
        // TODO if PROT is PROT_WRITE, make sure we have write access
        if ((stream.flags & 3) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EACCES);
        }
        if (!stream.stream_ops.mmap) {
          throw new FS.errnoError(ERRNO_CODES.ENODEV);
        }
        return stream.stream_ops.mmap(stream, buffer, offset, length, position, prot, flags);
      },ioctl:function (stream, cmd, arg) {
        if (!stream.stream_ops.ioctl) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTTY);
        }
        return stream.stream_ops.ioctl(stream, cmd, arg);
      },readFile:function (path, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'r';
        opts.encoding = opts.encoding || 'binary';
        var ret;
        var stream = FS.open(path, opts.flags);
        var stat = FS.stat(path);
        var length = stat.size;
        var buf = new Uint8Array(length);
        FS.read(stream, buf, 0, length, 0);
        if (opts.encoding === 'utf8') {
          ret = '';
          var utf8 = new Runtime.UTF8Processor();
          for (var i = 0; i < length; i++) {
            ret += utf8.processCChar(buf[i]);
          }
        } else if (opts.encoding === 'binary') {
          ret = buf;
        } else {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        FS.close(stream);
        return ret;
      },writeFile:function (path, data, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'w';
        opts.encoding = opts.encoding || 'utf8';
        var stream = FS.open(path, opts.flags, opts.mode);
        if (opts.encoding === 'utf8') {
          var utf8 = new Runtime.UTF8Processor();
          var buf = new Uint8Array(utf8.processJSString(data));
          FS.write(stream, buf, 0, buf.length, 0);
        } else if (opts.encoding === 'binary') {
          FS.write(stream, data, 0, data.length, 0);
        } else {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        FS.close(stream);
      },createDefaultDirectories:function () {
        FS.mkdir('/tmp');
      },createDefaultDevices:function () {
        // create /dev
        FS.mkdir('/dev');
        // setup /dev/null
        FS.registerDevice(FS.makedev(1, 3), {
          read: function() { return 0; },
          write: function() { return 0; }
        });
        FS.mkdev('/dev/null', FS.makedev(1, 3));
        // setup /dev/tty and /dev/tty1
        // stderr needs to print output using Module['printErr']
        // so we register a second tty just for it.
        TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
        TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
        FS.mkdev('/dev/tty', FS.makedev(5, 0));
        FS.mkdev('/dev/tty1', FS.makedev(6, 0));
        // we're not going to emulate the actual shm device,
        // just create the tmp dirs that reside in it commonly
        FS.mkdir('/dev/shm');
        FS.mkdir('/dev/shm/tmp');
      },createStandardStreams:function () {
        // TODO deprecate the old functionality of a single
        // input / output callback and that utilizes FS.createDevice
        // and instead require a unique set of stream ops
        // by default, we symlink the standard streams to the
        // default tty devices. however, if the standard streams
        // have been overwritten we create a unique device for
        // them instead.
        if (Module['stdin']) {
          FS.createDevice('/dev', 'stdin', Module['stdin']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdin');
        }
        if (Module['stdout']) {
          FS.createDevice('/dev', 'stdout', null, Module['stdout']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdout');
        }
        if (Module['stderr']) {
          FS.createDevice('/dev', 'stderr', null, Module['stderr']);
        } else {
          FS.symlink('/dev/tty1', '/dev/stderr');
        }
        // open default streams for the stdin, stdout and stderr devices
        var stdin = FS.open('/dev/stdin', 'r');
        HEAP32[((_stdin)>>2)]=stdin.fd;
        assert(stdin.fd === 1, 'invalid handle for stdin (' + stdin.fd + ')');
        var stdout = FS.open('/dev/stdout', 'w');
        HEAP32[((_stdout)>>2)]=stdout.fd;
        assert(stdout.fd === 2, 'invalid handle for stdout (' + stdout.fd + ')');
        var stderr = FS.open('/dev/stderr', 'w');
        HEAP32[((_stderr)>>2)]=stderr.fd;
        assert(stderr.fd === 3, 'invalid handle for stderr (' + stderr.fd + ')');
      },staticInit:function () {
        FS.nameTable = new Array(4096);
        FS.root = FS.createNode(null, '/', 0040000 | 0777, 0);
        FS.mount(MEMFS, {}, '/');
        FS.createDefaultDirectories();
        FS.createDefaultDevices();
      },init:function (input, output, error) {
        assert(!FS.init.initialized, 'FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)');
        FS.init.initialized = true;
        // Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
        Module['stdin'] = input || Module['stdin'];
        Module['stdout'] = output || Module['stdout'];
        Module['stderr'] = error || Module['stderr'];
        FS.createStandardStreams();
      },quit:function () {
        FS.init.initialized = false;
        for (var i = 0; i < FS.streams.length; i++) {
          var stream = FS.streams[i];
          if (!stream) {
            continue;
          }
          FS.close(stream);
        }
      },getMode:function (canRead, canWrite) {
        var mode = 0;
        if (canRead) mode |= 292 | 73;
        if (canWrite) mode |= 146;
        return mode;
      },joinPath:function (parts, forceRelative) {
        var path = PATH.join.apply(null, parts);
        if (forceRelative && path[0] == '/') path = path.substr(1);
        return path;
      },absolutePath:function (relative, base) {
        return PATH.resolve(base, relative);
      },standardizePath:function (path) {
        return PATH.normalize(path);
      },findObject:function (path, dontResolveLastLink) {
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
          return ret.object;
        } else {
          ___setErrNo(ret.error);
          return null;
        }
      },analyzePath:function (path, dontResolveLastLink) {
        // operate from within the context of the symlink's target
        try {
          var lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          path = lookup.path;
        } catch (e) {
        }
        var ret = {
          isRoot: false, exists: false, error: 0, name: null, path: null, object: null,
          parentExists: false, parentPath: null, parentObject: null
        };
        try {
          var lookup = FS.lookupPath(path, { parent: true });
          ret.parentExists = true;
          ret.parentPath = lookup.path;
          ret.parentObject = lookup.node;
          ret.name = PATH.basename(path);
          lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          ret.exists = true;
          ret.path = lookup.path;
          ret.object = lookup.node;
          ret.name = lookup.node.name;
          ret.isRoot = lookup.path === '/';
        } catch (e) {
          ret.error = e.errno;
        };
        return ret;
      },createFolder:function (parent, name, canRead, canWrite) {
        var path = PATH.join(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.mkdir(path, mode);
      },createPath:function (parent, path, canRead, canWrite) {
        parent = typeof parent === 'string' ? parent : FS.getPath(parent);
        var parts = path.split('/').reverse();
        while (parts.length) {
          var part = parts.pop();
          if (!part) continue;
          var current = PATH.join(parent, part);
          try {
            FS.mkdir(current);
          } catch (e) {
            // ignore EEXIST
          }
          parent = current;
        }
        return current;
      },createFile:function (parent, name, properties, canRead, canWrite) {
        var path = PATH.join(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.create(path, mode);
      },createDataFile:function (parent, name, data, canRead, canWrite, canOwn) {
        var path = name ? PATH.join(typeof parent === 'string' ? parent : FS.getPath(parent), name) : parent;
        var mode = FS.getMode(canRead, canWrite);
        var node = FS.create(path, mode);
        if (data) {
          if (typeof data === 'string') {
            var arr = new Array(data.length);
            for (var i = 0, len = data.length; i < len; ++i) arr[i] = data.charCodeAt(i);
            data = arr;
          }
          // make sure we can write to the file
          FS.chmod(path, mode | 146);
          var stream = FS.open(path, 'w');
          FS.write(stream, data, 0, data.length, 0, canOwn);
          FS.close(stream);
          FS.chmod(path, mode);
        }
        return node;
      },createDevice:function (parent, name, input, output) {
        var path = PATH.join(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(!!input, !!output);
        if (!FS.createDevice.major) FS.createDevice.major = 64;
        var dev = FS.makedev(FS.createDevice.major++, 0);
        // Create a fake device that a set of stream ops to emulate
        // the old behavior.
        FS.registerDevice(dev, {
          open: function(stream) {
            stream.seekable = false;
          },
          close: function(stream) {
            // flush any pending line data
            if (output && output.buffer && output.buffer.length) {
              output(10);
            }
          },
          read: function(stream, buffer, offset, length, pos /* ignored */) {
            var bytesRead = 0;
            for (var i = 0; i < length; i++) {
              var result;
              try {
                result = input();
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
              if (result === undefined && bytesRead === 0) {
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
              if (result === null || result === undefined) break;
              bytesRead++;
              buffer[offset+i] = result;
            }
            if (bytesRead) {
              stream.node.timestamp = Date.now();
            }
            return bytesRead;
          },
          write: function(stream, buffer, offset, length, pos) {
            for (var i = 0; i < length; i++) {
              try {
                output(buffer[offset+i]);
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
            }
            if (length) {
              stream.node.timestamp = Date.now();
            }
            return i;
          }
        });
        return FS.mkdev(path, mode, dev);
      },createLink:function (parent, name, target, canRead, canWrite) {
        var path = PATH.join(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        return FS.symlink(target, path);
      },forceLoadFile:function (obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        var success = true;
        if (typeof XMLHttpRequest !== 'undefined') {
          throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
        } else if (Module['read']) {
          // Command-line.
          try {
            // WARNING: Can't read binary files in V8's d8 or tracemonkey's js, as
            //          read() will try to parse UTF8.
            obj.contents = intArrayFromString(Module['read'](obj.url), true);
          } catch (e) {
            success = false;
          }
        } else {
          throw new Error('Cannot load without read() or XMLHttpRequest.');
        }
        if (!success) ___setErrNo(ERRNO_CODES.EIO);
        return success;
      },createLazyFile:function (parent, name, url, canRead, canWrite) {
        if (typeof XMLHttpRequest !== 'undefined') {
          if (!ENVIRONMENT_IS_WORKER) throw 'Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc';
          // Lazy chunked Uint8Array (implements get and length from Uint8Array). Actual getting is abstracted away for eventual reuse.
          var LazyUint8Array = function() {
            this.lengthKnown = false;
            this.chunks = []; // Loaded chunks. Index is the chunk number
          }
          LazyUint8Array.prototype.get = function(idx) {
            if (idx > this.length-1 || idx < 0) {
              return undefined;
            }
            var chunkOffset = idx % this.chunkSize;
            var chunkNum = Math.floor(idx / this.chunkSize);
            return this.getter(chunkNum)[chunkOffset];
          }
          LazyUint8Array.prototype.setDataGetter = function(getter) {
            this.getter = getter;
          }
          LazyUint8Array.prototype.cacheLength = function() {
              // Find length
              var xhr = new XMLHttpRequest();
              xhr.open('HEAD', url, false);
              xhr.send(null);
              if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
              var datalength = Number(xhr.getResponseHeader("Content-length"));
              var header;
              var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
              var chunkSize = 1024*1024; // Chunk size in bytes
              if (!hasByteServing) chunkSize = datalength;
              // Function to get a range from the remote URL.
              var doXHR = (function(from, to) {
                if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
                if (to > datalength-1) throw new Error("only " + datalength + " bytes available! programmer error!");
                // TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
                var xhr = new XMLHttpRequest();
                xhr.open('GET', url, false);
                if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
                // Some hints to the browser that we want binary data.
                if (typeof Uint8Array != 'undefined') xhr.responseType = 'arraybuffer';
                if (xhr.overrideMimeType) {
                  xhr.overrideMimeType('text/plain; charset=x-user-defined');
                }
                xhr.send(null);
                if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
                if (xhr.response !== undefined) {
                  return new Uint8Array(xhr.response || []);
                } else {
                  return intArrayFromString(xhr.responseText || '', true);
                }
              });
              var lazyArray = this;
              lazyArray.setDataGetter(function(chunkNum) {
                var start = chunkNum * chunkSize;
                var end = (chunkNum+1) * chunkSize - 1; // including this byte
                end = Math.min(end, datalength-1); // if datalength-1 is selected, this is the last block
                if (typeof(lazyArray.chunks[chunkNum]) === "undefined") {
                  lazyArray.chunks[chunkNum] = doXHR(start, end);
                }
                if (typeof(lazyArray.chunks[chunkNum]) === "undefined") throw new Error("doXHR failed!");
                return lazyArray.chunks[chunkNum];
              });
              this._length = datalength;
              this._chunkSize = chunkSize;
              this.lengthKnown = true;
          }
          var lazyArray = new LazyUint8Array();
          Object.defineProperty(lazyArray, "length", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._length;
              }
          });
          Object.defineProperty(lazyArray, "chunkSize", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._chunkSize;
              }
          });
          var properties = { isDevice: false, contents: lazyArray };
        } else {
          var properties = { isDevice: false, url: url };
        }
        var node = FS.createFile(parent, name, properties, canRead, canWrite);
        // This is a total hack, but I want to get this lazy file code out of the
        // core of MEMFS. If we want to keep this lazy file concept I feel it should
        // be its own thin LAZYFS proxying calls to MEMFS.
        if (properties.contents) {
          node.contents = properties.contents;
        } else if (properties.url) {
          node.contents = null;
          node.url = properties.url;
        }
        // override each stream op with one that tries to force load the lazy file first
        var stream_ops = {};
        var keys = Object.keys(node.stream_ops);
        keys.forEach(function(key) {
          var fn = node.stream_ops[key];
          stream_ops[key] = function() {
            if (!FS.forceLoadFile(node)) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            return fn.apply(null, arguments);
          };
        });
        // use a custom read function
        stream_ops.read = function(stream, buffer, offset, length, position) {
          if (!FS.forceLoadFile(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EIO);
          }
          var contents = stream.node.contents;
          var size = Math.min(contents.length - position, length);
          if (contents.slice) { // normal array
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          } else {
            for (var i = 0; i < size; i++) { // LazyUint8Array from sync binary XHR
              buffer[offset + i] = contents.get(position + i);
            }
          }
          return size;
        };
        node.stream_ops = stream_ops;
        return node;
      },createPreloadedFile:function (parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn) {
        Browser.init();
        // TODO we should allow people to just pass in a complete filename instead
        // of parent and name being that we just join them anyways
        var fullname = name ? PATH.resolve(PATH.join(parent, name)) : parent;
        function processData(byteArray) {
          function finish(byteArray) {
            if (!dontCreateFile) {
              FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn);
            }
            if (onload) onload();
            removeRunDependency('cp ' + fullname);
          }
          var handled = false;
          Module['preloadPlugins'].forEach(function(plugin) {
            if (handled) return;
            if (plugin['canHandle'](fullname)) {
              plugin['handle'](byteArray, fullname, finish, function() {
                if (onerror) onerror();
                removeRunDependency('cp ' + fullname);
              });
              handled = true;
            }
          });
          if (!handled) finish(byteArray);
        }
        addRunDependency('cp ' + fullname);
        if (typeof url == 'string') {
          Browser.asyncLoad(url, function(byteArray) {
            processData(byteArray);
          }, onerror);
        } else {
          processData(url);
        }
      },indexedDB:function () {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
      },DB_NAME:function () {
        return 'EM_FS_' + window.location.pathname;
      },DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = function() {
          console.log('creating db');
          var db = openRequest.result;
          db.createObjectStore(FS.DB_STORE_NAME);
        };
        openRequest.onsuccess = function() {
          var db = openRequest.result;
          var transaction = db.transaction([FS.DB_STORE_NAME], 'readwrite');
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var putRequest = files.put(FS.analyzePath(path).object.contents, path);
            putRequest.onsuccess = function() { ok++; if (ok + fail == total) finish() };
            putRequest.onerror = function() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      },loadFilesFromDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = onerror; // no database to load from
        openRequest.onsuccess = function() {
          var db = openRequest.result;
          try {
            var transaction = db.transaction([FS.DB_STORE_NAME], 'readonly');
          } catch(e) {
            onerror(e);
            return;
          }
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var getRequest = files.get(path);
            getRequest.onsuccess = function() {
              if (FS.analyzePath(path).exists) {
                FS.unlink(path);
              }
              FS.createDataFile(PATH.dirname(path), PATH.basename(path), getRequest.result, true, true, true);
              ok++;
              if (ok + fail == total) finish();
            };
            getRequest.onerror = function() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      }};
  var SOCKFS={mount:function (mount) {
        return FS.createNode(null, '/', 0040000 | 0777, 0);
      },nextname:function () {
        if (!SOCKFS.nextname.current) {
          SOCKFS.nextname.current = 0;
        }
        return 'socket[' + (SOCKFS.nextname.current++) + ']';
      },createSocket:function (family, type, protocol) {
        var streaming = type == 1;
        if (protocol) {
          assert(streaming == (protocol == 6)); // if SOCK_STREAM, must be tcp
        }
        // create our internal socket structure
        var sock = {
          family: family,
          type: type,
          protocol: protocol,
          server: null,
          peers: {},
          pending: [],
          recv_queue: [],
          sock_ops: SOCKFS.websocket_sock_ops
        };
        // create the filesystem node to store the socket structure
        var name = SOCKFS.nextname();
        var node = FS.createNode(SOCKFS.root, name, 0140000, 0);
        node.sock = sock;
        // and the wrapping stream that enables library functions such
        // as read and write to indirectly interact with the socket
        var stream = FS.createStream({
          path: name,
          node: node,
          flags: FS.modeStringToFlags('r+'),
          seekable: false,
          stream_ops: SOCKFS.stream_ops
        });
        // map the new stream to the socket structure (sockets have a 1:1
        // relationship with a stream)
        sock.stream = stream;
        return sock;
      },getSocket:function (fd) {
        var stream = FS.getStream(fd);
        if (!stream || !FS.isSocket(stream.node.mode)) {
          return null;
        }
        return stream.node.sock;
      },stream_ops:{poll:function (stream) {
          var sock = stream.node.sock;
          return sock.sock_ops.poll(sock);
        },ioctl:function (stream, request, varargs) {
          var sock = stream.node.sock;
          return sock.sock_ops.ioctl(sock, request, varargs);
        },read:function (stream, buffer, offset, length, position /* ignored */) {
          var sock = stream.node.sock;
          var msg = sock.sock_ops.recvmsg(sock, length);
          if (!msg) {
            // socket is closed
            return 0;
          }
          buffer.set(msg.buffer, offset);
          return msg.buffer.length;
        },write:function (stream, buffer, offset, length, position /* ignored */) {
          var sock = stream.node.sock;
          return sock.sock_ops.sendmsg(sock, buffer, offset, length);
        },close:function (stream) {
          var sock = stream.node.sock;
          sock.sock_ops.close(sock);
        }},websocket_sock_ops:{createPeer:function (sock, addr, port) {
          var ws;
          if (typeof addr === 'object') {
            ws = addr;
            addr = null;
            port = null;
          }
          if (ws) {
            // for sockets that've already connected (e.g. we're the server)
            // we can inspect the _socket property for the address
            if (ws._socket) {
              addr = ws._socket.remoteAddress;
              port = ws._socket.remotePort;
            }
            // if we're just now initializing a connection to the remote,
            // inspect the url property
            else {
              var result = /ws[s]?:\/\/([^:]+):(\d+)/.exec(ws.url);
              if (!result) {
                throw new Error('WebSocket URL must be in the format ws(s)://address:port');
              }
              addr = result[1];
              port = parseInt(result[2], 10);
            }
          } else {
            // create the actual websocket object and connect
            try {
              var url = 'ws://' + addr + ':' + port;
              // the node ws library API is slightly different than the browser's
              var opts = ENVIRONMENT_IS_NODE ? {} : ['binary'];
              ws = new WebSocket(url, opts);
              ws.binaryType = 'arraybuffer';
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EHOSTUNREACH);
            }
          }
          var peer = {
            addr: addr,
            port: port,
            socket: ws,
            dgram_send_queue: []
          };
          SOCKFS.websocket_sock_ops.addPeer(sock, peer);
          SOCKFS.websocket_sock_ops.handlePeerEvents(sock, peer);
          // if this is a bound dgram socket, send the port number first to allow
          // us to override the ephemeral port reported to us by remotePort on the
          // remote end.
          if (sock.type === 2 && typeof sock.sport !== 'undefined') {
            peer.dgram_send_queue.push(new Uint8Array([
                255, 255, 255, 255,
                'p'.charCodeAt(0), 'o'.charCodeAt(0), 'r'.charCodeAt(0), 't'.charCodeAt(0),
                ((sock.sport & 0xff00) >> 8) , (sock.sport & 0xff)
            ]));
          }
          return peer;
        },getPeer:function (sock, addr, port) {
          return sock.peers[addr + ':' + port];
        },addPeer:function (sock, peer) {
          sock.peers[peer.addr + ':' + peer.port] = peer;
        },removePeer:function (sock, peer) {
          delete sock.peers[peer.addr + ':' + peer.port];
        },handlePeerEvents:function (sock, peer) {
          var first = true;
          var handleOpen = function () {
            try {
              var queued = peer.dgram_send_queue.shift();
              while (queued) {
                peer.socket.send(queued);
                queued = peer.dgram_send_queue.shift();
              }
            } catch (e) {
              // not much we can do here in the way of proper error handling as we've already
              // lied and said this data was sent. shut it down.
              peer.socket.close();
            }
          };
          var handleMessage = function(data) {
            assert(typeof data !== 'string' && data.byteLength !== undefined);  // must receive an ArrayBuffer
            data = new Uint8Array(data);  // make a typed array view on the array buffer
            // if this is the port message, override the peer's port with it
            var wasfirst = first;
            first = false;
            if (wasfirst &&
                data.length === 10 &&
                data[0] === 255 && data[1] === 255 && data[2] === 255 && data[3] === 255 &&
                data[4] === 'p'.charCodeAt(0) && data[5] === 'o'.charCodeAt(0) && data[6] === 'r'.charCodeAt(0) && data[7] === 't'.charCodeAt(0)) {
              // update the peer's port and it's key in the peer map
              var newport = ((data[8] << 8) | data[9]);
              SOCKFS.websocket_sock_ops.removePeer(sock, peer);
              peer.port = newport;
              SOCKFS.websocket_sock_ops.addPeer(sock, peer);
              return;
            }
            sock.recv_queue.push({ addr: peer.addr, port: peer.port, data: data });
          };
          if (ENVIRONMENT_IS_NODE) {
            peer.socket.on('open', handleOpen);
            peer.socket.on('message', function(data, flags) {
              if (!flags.binary) {
                return;
              }
              handleMessage((new Uint8Array(data)).buffer);  // copy from node Buffer -> ArrayBuffer
            });
            peer.socket.on('error', function() {
              // don't throw
            });
          } else {
            peer.socket.onopen = handleOpen;
            peer.socket.onmessage = function(event) {
              handleMessage(event.data);
            };
          }
        },poll:function (sock) {
          if (sock.type === 1 && sock.server) {
            // listen sockets should only say they're available for reading
            // if there are pending clients.
            return sock.pending.length ? (0 /* XXX missing C define POLLRDNORM */ | 1) : 0;
          }
          var mask = 0;
          var dest = sock.type === 1 ?  // we only care about the socket state for connection-based sockets
            SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport) :
            null;
          if (sock.recv_queue.length ||
              !dest ||  // connection-less sockets are always ready to read
              (dest && dest.socket.readyState === dest.socket.CLOSING) ||
              (dest && dest.socket.readyState === dest.socket.CLOSED)) {  // let recv return 0 once closed
            mask |= (0 /* XXX missing C define POLLRDNORM */ | 1);
          }
          if (!dest ||  // connection-less sockets are always ready to write
              (dest && dest.socket.readyState === dest.socket.OPEN)) {
            mask |= 2;
          }
          if ((dest && dest.socket.readyState === dest.socket.CLOSING) ||
              (dest && dest.socket.readyState === dest.socket.CLOSED)) {
            mask |= 16;
          }
          return mask;
        },ioctl:function (sock, request, arg) {
          switch (request) {
            case 1:
              var bytes = 0;
              if (sock.recv_queue.length) {
                bytes = sock.recv_queue[0].data.length;
              }
              HEAP32[((arg)>>2)]=bytes;
              return 0;
            default:
              return ERRNO_CODES.EINVAL;
          }
        },close:function (sock) {
          // if we've spawned a listen server, close it
          if (sock.server) {
            try {
              sock.server.close();
            } catch (e) {
            }
            sock.server = null;
          }
          // close any peer connections
          var peers = Object.keys(sock.peers);
          for (var i = 0; i < peers.length; i++) {
            var peer = sock.peers[peers[i]];
            try {
              peer.socket.close();
            } catch (e) {
            }
            SOCKFS.websocket_sock_ops.removePeer(sock, peer);
          }
          return 0;
        },bind:function (sock, addr, port) {
          if (typeof sock.saddr !== 'undefined' || typeof sock.sport !== 'undefined') {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);  // already bound
          }
          sock.saddr = addr;
          sock.sport = port || _mkport();
          // in order to emulate dgram sockets, we need to launch a listen server when
          // binding on a connection-less socket
          // note: this is only required on the server side
          if (sock.type === 2) {
            // close the existing server if it exists
            if (sock.server) {
              sock.server.close();
              sock.server = null;
            }
            // swallow error operation not supported error that occurs when binding in the
            // browser where this isn't supported
            try {
              sock.sock_ops.listen(sock, 0);
            } catch (e) {
              if (!(e instanceof FS.ErrnoError)) throw e;
              if (e.errno !== ERRNO_CODES.EOPNOTSUPP) throw e;
            }
          }
        },connect:function (sock, addr, port) {
          if (sock.server) {
            throw new FS.ErrnoError(ERRNO_CODS.EOPNOTSUPP);
          }
          // TODO autobind
          // if (!sock.addr && sock.type == 2) {
          // }
          // early out if we're already connected / in the middle of connecting
          if (typeof sock.daddr !== 'undefined' && typeof sock.dport !== 'undefined') {
            var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
            if (dest) {
              if (dest.socket.readyState === dest.socket.CONNECTING) {
                throw new FS.ErrnoError(ERRNO_CODES.EALREADY);
              } else {
                throw new FS.ErrnoError(ERRNO_CODES.EISCONN);
              }
            }
          }
          // add the socket to our peer list and set our
          // destination address / port to match
          var peer = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
          sock.daddr = peer.addr;
          sock.dport = peer.port;
          // always "fail" in non-blocking mode
          throw new FS.ErrnoError(ERRNO_CODES.EINPROGRESS);
        },listen:function (sock, backlog) {
          if (!ENVIRONMENT_IS_NODE) {
            throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
          }
          if (sock.server) {
             throw new FS.ErrnoError(ERRNO_CODES.EINVAL);  // already listening
          }
          var WebSocketServer = require('ws').Server;
          var host = sock.saddr;
          sock.server = new WebSocketServer({
            host: host,
            port: sock.sport
            // TODO support backlog
          });
          sock.server.on('connection', function(ws) {
            if (sock.type === 1) {
              var newsock = SOCKFS.createSocket(sock.family, sock.type, sock.protocol);
              // create a peer on the new socket
              var peer = SOCKFS.websocket_sock_ops.createPeer(newsock, ws);
              newsock.daddr = peer.addr;
              newsock.dport = peer.port;
              // push to queue for accept to pick up
              sock.pending.push(newsock);
            } else {
              // create a peer on the listen socket so calling sendto
              // with the listen socket and an address will resolve
              // to the correct client
              SOCKFS.websocket_sock_ops.createPeer(sock, ws);
            }
          });
          sock.server.on('closed', function() {
            sock.server = null;
          });
          sock.server.on('error', function() {
            // don't throw
          });
        },accept:function (listensock) {
          if (!listensock.server) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          var newsock = listensock.pending.shift();
          newsock.stream.flags = listensock.stream.flags;
          return newsock;
        },getname:function (sock, peer) {
          var addr, port;
          if (peer) {
            if (sock.daddr === undefined || sock.dport === undefined) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
            }
            addr = sock.daddr;
            port = sock.dport;
          } else {
            // TODO saddr and sport will be set for bind()'d UDP sockets, but what
            // should we be returning for TCP sockets that've been connect()'d?
            addr = sock.saddr || 0;
            port = sock.sport || 0;
          }
          return { addr: addr, port: port };
        },sendmsg:function (sock, buffer, offset, length, addr, port) {
          if (sock.type === 2) {
            // connection-less sockets will honor the message address,
            // and otherwise fall back to the bound destination address
            if (addr === undefined || port === undefined) {
              addr = sock.daddr;
              port = sock.dport;
            }
            // if there was no address to fall back to, error out
            if (addr === undefined || port === undefined) {
              throw new FS.ErrnoError(ERRNO_CODES.EDESTADDRREQ);
            }
          } else {
            // connection-based sockets will only use the bound
            addr = sock.daddr;
            port = sock.dport;
          }
          // find the peer for the destination address
          var dest = SOCKFS.websocket_sock_ops.getPeer(sock, addr, port);
          // early out if not connected with a connection-based socket
          if (sock.type === 1) {
            if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
            } else if (dest.socket.readyState === dest.socket.CONNECTING) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
          }
          // create a copy of the incoming data to send, as the WebSocket API
          // doesn't work entirely with an ArrayBufferView, it'll just send
          // the entire underlying buffer
          var data;
          if (buffer instanceof Array || buffer instanceof ArrayBuffer) {
            data = buffer.slice(offset, offset + length);
          } else {  // ArrayBufferView
            data = buffer.buffer.slice(buffer.byteOffset + offset, buffer.byteOffset + offset + length);
          }
          // if we're emulating a connection-less dgram socket and don't have
          // a cached connection, queue the buffer to send upon connect and
          // lie, saying the data was sent now.
          if (sock.type === 2) {
            if (!dest || dest.socket.readyState !== dest.socket.OPEN) {
              // if we're not connected, open a new connection
              if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                dest = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
              }
              dest.dgram_send_queue.push(data);
              return length;
            }
          }
          try {
            // send the actual data
            dest.socket.send(data);
            return length;
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
        },recvmsg:function (sock, length) {
          // http://pubs.opengroup.org/onlinepubs/7908799/xns/recvmsg.html
          if (sock.type === 1 && sock.server) {
            // tcp servers should not be recv()'ing on the listen socket
            throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
          }
          var queued = sock.recv_queue.shift();
          if (!queued) {
            if (sock.type === 1) {
              var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
              if (!dest) {
                // if we have a destination address but are not connected, error out
                throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
              }
              else if (dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                // return null if the socket has closed
                return null;
              }
              else {
                // else, our socket is in a valid state but truly has nothing available
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
            } else {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
          }
          // queued.data will be an ArrayBuffer if it's unadulterated, but if it's
          // requeued TCP data it'll be an ArrayBufferView
          var queuedLength = queued.data.byteLength || queued.data.length;
          var queuedOffset = queued.data.byteOffset || 0;
          var queuedBuffer = queued.data.buffer || queued.data;
          var bytesRead = Math.min(length, queuedLength);
          var res = {
            buffer: new Uint8Array(queuedBuffer, queuedOffset, bytesRead),
            addr: queued.addr,
            port: queued.port
          };
          // push back any unread data for TCP connections
          if (sock.type === 1 && bytesRead < queuedLength) {
            var bytesRemaining = queuedLength - bytesRead;
            queued.data = new Uint8Array(queuedBuffer, queuedOffset + bytesRead, bytesRemaining);
            sock.recv_queue.unshift(queued);
          }
          return res;
        }}};function _send(fd, buf, len, flags) {
      var sock = SOCKFS.getSocket(fd);
      if (!sock) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      // TODO honor flags
      return _write(fd, buf, len);
    }
  function _pwrite(fildes, buf, nbyte, offset) {
      // ssize_t pwrite(int fildes, const void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte, offset);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _write(fildes, buf, nbyte) {
      // ssize_t write(int fildes, const void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _fwrite(ptr, size, nitems, stream) {
      // size_t fwrite(const void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fwrite.html
      var bytesToWrite = nitems * size;
      if (bytesToWrite == 0) return 0;
      var bytesWritten = _write(stream, ptr, bytesToWrite);
      if (bytesWritten == -1) {
        var streamObj = FS.getStream(stream);
        if (streamObj) streamObj.error = true;
        return 0;
      } else {
        return Math.floor(bytesWritten / size);
      }
    }
  Module["_strlen"] = _strlen;
  function __reallyNegative(x) {
      return x < 0 || (x === 0 && (1/x) === -Infinity);
    }function __formatString(format, varargs) {
      var textIndex = format;
      var argIndex = 0;
      function getNextArg(type) {
        // NOTE: Explicitly ignoring type safety. Otherwise this fails:
        //       int x = 4; printf("%c\n", (char)x);
        var ret;
        if (type === 'double') {
          ret = HEAPF64[(((varargs)+(argIndex))>>3)];
        } else if (type == 'i64') {
          ret = [HEAP32[(((varargs)+(argIndex))>>2)],
                 HEAP32[(((varargs)+(argIndex+8))>>2)]];
          argIndex += 8; // each 32-bit chunk is in a 64-bit block
        } else {
          type = 'i32'; // varargs are always i32, i64, or double
          ret = HEAP32[(((varargs)+(argIndex))>>2)];
        }
        argIndex += Math.max(Runtime.getNativeFieldSize(type), Runtime.getAlignSize(type, null, true));
        return ret;
      }
      var ret = [];
      var curr, next, currArg;
      while(1) {
        var startTextIndex = textIndex;
        curr = HEAP8[(textIndex)];
        if (curr === 0) break;
        next = HEAP8[((textIndex+1)|0)];
        if (curr == 37) {
          // Handle flags.
          var flagAlwaysSigned = false;
          var flagLeftAlign = false;
          var flagAlternative = false;
          var flagZeroPad = false;
          flagsLoop: while (1) {
            switch (next) {
              case 43:
                flagAlwaysSigned = true;
                break;
              case 45:
                flagLeftAlign = true;
                break;
              case 35:
                flagAlternative = true;
                break;
              case 48:
                if (flagZeroPad) {
                  break flagsLoop;
                } else {
                  flagZeroPad = true;
                  break;
                }
              default:
                break flagsLoop;
            }
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          }
          // Handle width.
          var width = 0;
          if (next == 42) {
            width = getNextArg('i32');
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          } else {
            while (next >= 48 && next <= 57) {
              width = width * 10 + (next - 48);
              textIndex++;
              next = HEAP8[((textIndex+1)|0)];
            }
          }
          // Handle precision.
          var precisionSet = false;
          if (next == 46) {
            var precision = 0;
            precisionSet = true;
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
            if (next == 42) {
              precision = getNextArg('i32');
              textIndex++;
            } else {
              while(1) {
                var precisionChr = HEAP8[((textIndex+1)|0)];
                if (precisionChr < 48 ||
                    precisionChr > 57) break;
                precision = precision * 10 + (precisionChr - 48);
                textIndex++;
              }
            }
            next = HEAP8[((textIndex+1)|0)];
          } else {
            var precision = 6; // Standard default.
          }
          // Handle integer sizes. WARNING: These assume a 32-bit architecture!
          var argSize;
          switch (String.fromCharCode(next)) {
            case 'h':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 104) {
                textIndex++;
                argSize = 1; // char (actually i32 in varargs)
              } else {
                argSize = 2; // short (actually i32 in varargs)
              }
              break;
            case 'l':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 108) {
                textIndex++;
                argSize = 8; // long long
              } else {
                argSize = 4; // long
              }
              break;
            case 'L': // long long
            case 'q': // int64_t
            case 'j': // intmax_t
              argSize = 8;
              break;
            case 'z': // size_t
            case 't': // ptrdiff_t
            case 'I': // signed ptrdiff_t or unsigned size_t
              argSize = 4;
              break;
            default:
              argSize = null;
          }
          if (argSize) textIndex++;
          next = HEAP8[((textIndex+1)|0)];
          // Handle type specifier.
          switch (String.fromCharCode(next)) {
            case 'd': case 'i': case 'u': case 'o': case 'x': case 'X': case 'p': {
              // Integer.
              var signed = next == 100 || next == 105;
              argSize = argSize || 4;
              var currArg = getNextArg('i' + (argSize * 8));
              var origArg = currArg;
              var argText;
              // Flatten i64-1 [low, high] into a (slightly rounded) double
              if (argSize == 8) {
                currArg = Runtime.makeBigInt(currArg[0], currArg[1], next == 117);
              }
              // Truncate to requested size.
              if (argSize <= 4) {
                var limit = Math.pow(256, argSize) - 1;
                currArg = (signed ? reSign : unSign)(currArg & limit, argSize * 8);
              }
              // Format the number.
              var currAbsArg = Math.abs(currArg);
              var prefix = '';
              if (next == 100 || next == 105) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], null); else
                argText = reSign(currArg, 8 * argSize, 1).toString(10);
              } else if (next == 117) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], true); else
                argText = unSign(currArg, 8 * argSize, 1).toString(10);
                currArg = Math.abs(currArg);
              } else if (next == 111) {
                argText = (flagAlternative ? '0' : '') + currAbsArg.toString(8);
              } else if (next == 120 || next == 88) {
                prefix = (flagAlternative && currArg != 0) ? '0x' : '';
                if (argSize == 8 && i64Math) {
                  if (origArg[1]) {
                    argText = (origArg[1]>>>0).toString(16);
                    var lower = (origArg[0]>>>0).toString(16);
                    while (lower.length < 8) lower = '0' + lower;
                    argText += lower;
                  } else {
                    argText = (origArg[0]>>>0).toString(16);
                  }
                } else
                if (currArg < 0) {
                  // Represent negative numbers in hex as 2's complement.
                  currArg = -currArg;
                  argText = (currAbsArg - 1).toString(16);
                  var buffer = [];
                  for (var i = 0; i < argText.length; i++) {
                    buffer.push((0xF - parseInt(argText[i], 16)).toString(16));
                  }
                  argText = buffer.join('');
                  while (argText.length < argSize * 2) argText = 'f' + argText;
                } else {
                  argText = currAbsArg.toString(16);
                }
                if (next == 88) {
                  prefix = prefix.toUpperCase();
                  argText = argText.toUpperCase();
                }
              } else if (next == 112) {
                if (currAbsArg === 0) {
                  argText = '(nil)';
                } else {
                  prefix = '0x';
                  argText = currAbsArg.toString(16);
                }
              }
              if (precisionSet) {
                while (argText.length < precision) {
                  argText = '0' + argText;
                }
              }
              // Add sign if needed
              if (flagAlwaysSigned) {
                if (currArg < 0) {
                  prefix = '-' + prefix;
                } else {
                  prefix = '+' + prefix;
                }
              }
              // Add padding.
              while (prefix.length + argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad) {
                    argText = '0' + argText;
                  } else {
                    prefix = ' ' + prefix;
                  }
                }
              }
              // Insert the result into the buffer.
              argText = prefix + argText;
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 'f': case 'F': case 'e': case 'E': case 'g': case 'G': {
              // Float.
              var currArg = getNextArg('double');
              var argText;
              if (isNaN(currArg)) {
                argText = 'nan';
                flagZeroPad = false;
              } else if (!isFinite(currArg)) {
                argText = (currArg < 0 ? '-' : '') + 'inf';
                flagZeroPad = false;
              } else {
                var isGeneral = false;
                var effectivePrecision = Math.min(precision, 20);
                // Convert g/G to f/F or e/E, as per:
                // http://pubs.opengroup.org/onlinepubs/9699919799/functions/printf.html
                if (next == 103 || next == 71) {
                  isGeneral = true;
                  precision = precision || 1;
                  var exponent = parseInt(currArg.toExponential(effectivePrecision).split('e')[1], 10);
                  if (precision > exponent && exponent >= -4) {
                    next = ((next == 103) ? 'f' : 'F').charCodeAt(0);
                    precision -= exponent + 1;
                  } else {
                    next = ((next == 103) ? 'e' : 'E').charCodeAt(0);
                    precision--;
                  }
                  effectivePrecision = Math.min(precision, 20);
                }
                if (next == 101 || next == 69) {
                  argText = currArg.toExponential(effectivePrecision);
                  // Make sure the exponent has at least 2 digits.
                  if (/[eE][-+]\d$/.test(argText)) {
                    argText = argText.slice(0, -1) + '0' + argText.slice(-1);
                  }
                } else if (next == 102 || next == 70) {
                  argText = currArg.toFixed(effectivePrecision);
                  if (currArg === 0 && __reallyNegative(currArg)) {
                    argText = '-' + argText;
                  }
                }
                var parts = argText.split('e');
                if (isGeneral && !flagAlternative) {
                  // Discard trailing zeros and periods.
                  while (parts[0].length > 1 && parts[0].indexOf('.') != -1 &&
                         (parts[0].slice(-1) == '0' || parts[0].slice(-1) == '.')) {
                    parts[0] = parts[0].slice(0, -1);
                  }
                } else {
                  // Make sure we have a period in alternative mode.
                  if (flagAlternative && argText.indexOf('.') == -1) parts[0] += '.';
                  // Zero pad until required precision.
                  while (precision > effectivePrecision++) parts[0] += '0';
                }
                argText = parts[0] + (parts.length > 1 ? 'e' + parts[1] : '');
                // Capitalize 'E' if needed.
                if (next == 69) argText = argText.toUpperCase();
                // Add sign.
                if (flagAlwaysSigned && currArg >= 0) {
                  argText = '+' + argText;
                }
              }
              // Add padding.
              while (argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad && (argText[0] == '-' || argText[0] == '+')) {
                    argText = argText[0] + '0' + argText.slice(1);
                  } else {
                    argText = (flagZeroPad ? '0' : ' ') + argText;
                  }
                }
              }
              // Adjust case.
              if (next < 97) argText = argText.toUpperCase();
              // Insert the result into the buffer.
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 's': {
              // String.
              var arg = getNextArg('i8*');
              var argLength = arg ? _strlen(arg) : '(null)'.length;
              if (precisionSet) argLength = Math.min(argLength, precision);
              if (!flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              if (arg) {
                for (var i = 0; i < argLength; i++) {
                  ret.push(HEAPU8[((arg++)|0)]);
                }
              } else {
                ret = ret.concat(intArrayFromString('(null)'.substr(0, argLength), true));
              }
              if (flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              break;
            }
            case 'c': {
              // Character.
              if (flagLeftAlign) ret.push(getNextArg('i8'));
              while (--width > 0) {
                ret.push(32);
              }
              if (!flagLeftAlign) ret.push(getNextArg('i8'));
              break;
            }
            case 'n': {
              // Write the length written so far to the next parameter.
              var ptr = getNextArg('i32*');
              HEAP32[((ptr)>>2)]=ret.length
              break;
            }
            case '%': {
              // Literal percent sign.
              ret.push(curr);
              break;
            }
            default: {
              // Unknown specifiers remain untouched.
              for (var i = startTextIndex; i < textIndex + 2; i++) {
                ret.push(HEAP8[(i)]);
              }
            }
          }
          textIndex += 2;
          // TODO: Support a/A (hex float) and m (last error) specifiers.
          // TODO: Support %1${specifier} for arg selection.
        } else {
          ret.push(curr);
          textIndex += 1;
        }
      }
      return ret;
    }function _fprintf(stream, format, varargs) {
      // int fprintf(FILE *restrict stream, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var result = __formatString(format, varargs);
      var stack = Runtime.stackSave();
      var ret = _fwrite(allocate(result, 'i8', ALLOC_STACK), 1, result.length, stream);
      Runtime.stackRestore(stack);
      return ret;
    }function _printf(format, varargs) {
      // int printf(const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var stdout = HEAP32[((_stdout)>>2)];
      return _fprintf(stdout, format, varargs);
    }
  Module["_memcpy"] = _memcpy;var _llvm_memcpy_p0i8_p0i8_i32=_memcpy;
  function ___cxa_guard_acquire(variable) {
      if (!HEAP8[(variable)]) { // ignore SAFE_HEAP stuff because llvm mixes i64 and i8 here
        HEAP8[(variable)]=1;
        return 1;
      }
      return 0;
    }
  function ___cxa_guard_release() {}
  Module["_memset"] = _memset;var _llvm_memset_p0i8_i64=_memset;
  var _sinf=Math.sin;
  var _cosf=Math.cos;
  var _sqrtf=Math.sqrt;
  var _fabsf=Math.abs;
  function _llvm_lifetime_start() {}
  function _llvm_lifetime_end() {}
  function _fmod(x, y) {
      return x % y;
    }var _fmodf=_fmod;
  var _atan2f=Math.atan2;
  var _llvm_pow_f32=Math.pow;
  var _acosf=Math.acos;
  var _llvm_memset_p0i8_i32=_memset;
  function _atexit(func, arg) {
      __ATEXIT__.unshift({ func: func, arg: arg });
    }var ___cxa_atexit=_atexit;
  function ___cxa_guard_abort() {}
  function ___cxa_pure_virtual() {
      ABORT = true;
      throw 'Pure virtual function called!';
    }
  function ___assert_func(filename, line, func, condition) {
      throw 'Assertion failed: ' + (condition ? Pointer_stringify(condition) : 'unknown condition') + ', at: ' + [filename ? Pointer_stringify(filename) : 'unknown filename', line, func ? Pointer_stringify(func) : 'unknown function'] + ' at ' + new Error().stack;
    }
  Module["_llvm_uadd_with_overflow_i64"] = _llvm_uadd_with_overflow_i64;
  function _gettimeofday(ptr) {
      // %struct.timeval = type { i32, i32 }
      var now = Date.now();
      HEAP32[((ptr)>>2)]=Math.floor(now/1000); // seconds
      HEAP32[(((ptr)+(4))>>2)]=Math.floor((now-1000*Math.floor(now/1000))*1000); // microseconds
      return 0;
    }
  function _abort() {
      Module['abort']();
    }
  function ___errno_location() {
      return ___errno_state;
    }var ___errno=___errno_location;
  function _sbrk(bytes) {
      // Implement a Linux-like 'memory area' for our 'process'.
      // Changes the size of the memory area by |bytes|; returns the
      // address of the previous top ('break') of the memory area
      // We control the "dynamic" memory - DYNAMIC_BASE to DYNAMICTOP
      var self = _sbrk;
      if (!self.called) {
        DYNAMICTOP = alignMemoryPage(DYNAMICTOP); // make sure we start out aligned
        self.called = true;
        assert(Runtime.dynamicAlloc);
        self.alloc = Runtime.dynamicAlloc;
        Runtime.dynamicAlloc = function() { abort('cannot dynamically allocate, sbrk now has control') };
      }
      var ret = DYNAMICTOP;
      if (bytes != 0) self.alloc(bytes);
      return ret;  // Previous break location.
    }
  function _sysconf(name) {
      // long sysconf(int name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/sysconf.html
      switch(name) {
        case 8: return PAGE_SIZE;
        case 54:
        case 56:
        case 21:
        case 61:
        case 63:
        case 22:
        case 67:
        case 23:
        case 24:
        case 25:
        case 26:
        case 27:
        case 69:
        case 28:
        case 101:
        case 70:
        case 71:
        case 29:
        case 30:
        case 199:
        case 75:
        case 76:
        case 32:
        case 43:
        case 44:
        case 80:
        case 46:
        case 47:
        case 45:
        case 48:
        case 49:
        case 42:
        case 82:
        case 33:
        case 7:
        case 108:
        case 109:
        case 107:
        case 112:
        case 119:
        case 121:
          return 200809;
        case 13:
        case 104:
        case 94:
        case 95:
        case 34:
        case 35:
        case 77:
        case 81:
        case 83:
        case 84:
        case 85:
        case 86:
        case 87:
        case 88:
        case 89:
        case 90:
        case 91:
        case 94:
        case 95:
        case 110:
        case 111:
        case 113:
        case 114:
        case 115:
        case 116:
        case 117:
        case 118:
        case 120:
        case 40:
        case 16:
        case 79:
        case 19:
          return -1;
        case 92:
        case 93:
        case 5:
        case 72:
        case 6:
        case 74:
        case 92:
        case 93:
        case 96:
        case 97:
        case 98:
        case 99:
        case 102:
        case 103:
        case 105:
          return 1;
        case 38:
        case 66:
        case 50:
        case 51:
        case 4:
          return 1024;
        case 15:
        case 64:
        case 41:
          return 32;
        case 55:
        case 37:
        case 17:
          return 2147483647;
        case 18:
        case 1:
          return 47839;
        case 59:
        case 57:
          return 99;
        case 68:
        case 58:
          return 2048;
        case 0: return 2097152;
        case 3: return 65536;
        case 14: return 32768;
        case 73: return 32767;
        case 39: return 16384;
        case 60: return 1000;
        case 106: return 700;
        case 52: return 256;
        case 62: return 255;
        case 2: return 100;
        case 65: return 64;
        case 36: return 20;
        case 100: return 16;
        case 20: return 6;
        case 53: return 4;
        case 10: return 1;
      }
      ___setErrNo(ERRNO_CODES.EINVAL);
      return -1;
    }
  function _time(ptr) {
      var ret = Math.floor(Date.now()/1000);
      if (ptr) {
        HEAP32[((ptr)>>2)]=ret
      }
      return ret;
    }
  function ___cxa_allocate_exception(size) {
      return _malloc(size);
    }
  function _llvm_eh_exception() {
      return HEAP32[((_llvm_eh_exception.buf)>>2)];
    }
  function __ZSt18uncaught_exceptionv() { // std::uncaught_exception()
      return !!__ZSt18uncaught_exceptionv.uncaught_exception;
    }
  function ___cxa_is_number_type(type) {
      var isNumber = false;
      try { if (type == __ZTIi) isNumber = true } catch(e){}
      try { if (type == __ZTIj) isNumber = true } catch(e){}
      try { if (type == __ZTIl) isNumber = true } catch(e){}
      try { if (type == __ZTIm) isNumber = true } catch(e){}
      try { if (type == __ZTIx) isNumber = true } catch(e){}
      try { if (type == __ZTIy) isNumber = true } catch(e){}
      try { if (type == __ZTIf) isNumber = true } catch(e){}
      try { if (type == __ZTId) isNumber = true } catch(e){}
      try { if (type == __ZTIe) isNumber = true } catch(e){}
      try { if (type == __ZTIc) isNumber = true } catch(e){}
      try { if (type == __ZTIa) isNumber = true } catch(e){}
      try { if (type == __ZTIh) isNumber = true } catch(e){}
      try { if (type == __ZTIs) isNumber = true } catch(e){}
      try { if (type == __ZTIt) isNumber = true } catch(e){}
      return isNumber;
    }function ___cxa_does_inherit(definiteType, possibilityType, possibility) {
      if (possibility == 0) return false;
      if (possibilityType == 0 || possibilityType == definiteType)
        return true;
      var possibility_type_info;
      if (___cxa_is_number_type(possibilityType)) {
        possibility_type_info = possibilityType;
      } else {
        var possibility_type_infoAddr = HEAP32[((possibilityType)>>2)] - 8;
        possibility_type_info = HEAP32[((possibility_type_infoAddr)>>2)];
      }
      switch (possibility_type_info) {
      case 0: // possibility is a pointer
        // See if definite type is a pointer
        var definite_type_infoAddr = HEAP32[((definiteType)>>2)] - 8;
        var definite_type_info = HEAP32[((definite_type_infoAddr)>>2)];
        if (definite_type_info == 0) {
          // Also a pointer; compare base types of pointers
          var defPointerBaseAddr = definiteType+8;
          var defPointerBaseType = HEAP32[((defPointerBaseAddr)>>2)];
          var possPointerBaseAddr = possibilityType+8;
          var possPointerBaseType = HEAP32[((possPointerBaseAddr)>>2)];
          return ___cxa_does_inherit(defPointerBaseType, possPointerBaseType, possibility);
        } else
          return false; // one pointer and one non-pointer
      case 1: // class with no base class
        return false;
      case 2: // class with base class
        var parentTypeAddr = possibilityType + 8;
        var parentType = HEAP32[((parentTypeAddr)>>2)];
        return ___cxa_does_inherit(definiteType, parentType, possibility);
      default:
        return false; // some unencountered type
      }
    }
  function ___resumeException(ptr) {
      if (HEAP32[((_llvm_eh_exception.buf)>>2)] == 0) HEAP32[((_llvm_eh_exception.buf)>>2)]=ptr;
      throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";;
    }function ___cxa_find_matching_catch(thrown, throwntype) {
      if (thrown == -1) thrown = HEAP32[((_llvm_eh_exception.buf)>>2)];
      if (throwntype == -1) throwntype = HEAP32[(((_llvm_eh_exception.buf)+(4))>>2)];
      var typeArray = Array.prototype.slice.call(arguments, 2);
      // If throwntype is a pointer, this means a pointer has been
      // thrown. When a pointer is thrown, actually what's thrown
      // is a pointer to the pointer. We'll dereference it.
      if (throwntype != 0 && !___cxa_is_number_type(throwntype)) {
        var throwntypeInfoAddr= HEAP32[((throwntype)>>2)] - 8;
        var throwntypeInfo= HEAP32[((throwntypeInfoAddr)>>2)];
        if (throwntypeInfo == 0)
          thrown = HEAP32[((thrown)>>2)];
      }
      // The different catch blocks are denoted by different types.
      // Due to inheritance, those types may not precisely match the
      // type of the thrown object. Find one which matches, and
      // return the type of the catch block which should be called.
      for (var i = 0; i < typeArray.length; i++) {
        if (___cxa_does_inherit(typeArray[i], throwntype, thrown))
          return ((asm["setTempRet0"](typeArray[i]),thrown)|0);
      }
      // Shouldn't happen unless we have bogus data in typeArray
      // or encounter a type for which emscripten doesn't have suitable
      // typeinfo defined. Best-efforts match just in case.
      return ((asm["setTempRet0"](throwntype),thrown)|0);
    }function ___cxa_throw(ptr, type, destructor) {
      if (!___cxa_throw.initialized) {
        try {
          HEAP32[((__ZTVN10__cxxabiv119__pointer_type_infoE)>>2)]=0; // Workaround for libcxxabi integration bug
        } catch(e){}
        try {
          HEAP32[((__ZTVN10__cxxabiv117__class_type_infoE)>>2)]=1; // Workaround for libcxxabi integration bug
        } catch(e){}
        try {
          HEAP32[((__ZTVN10__cxxabiv120__si_class_type_infoE)>>2)]=2; // Workaround for libcxxabi integration bug
        } catch(e){}
        ___cxa_throw.initialized = true;
      }
      HEAP32[((_llvm_eh_exception.buf)>>2)]=ptr
      HEAP32[(((_llvm_eh_exception.buf)+(4))>>2)]=type
      HEAP32[(((_llvm_eh_exception.buf)+(8))>>2)]=destructor
      if (!("uncaught_exception" in __ZSt18uncaught_exceptionv)) {
        __ZSt18uncaught_exceptionv.uncaught_exception = 1;
      } else {
        __ZSt18uncaught_exceptionv.uncaught_exception++;
      }
      throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";;
    }
  function ___cxa_call_unexpected(exception) {
      Module.printErr('Unexpected exception thrown, this is not properly supported - aborting');
      ABORT = true;
      throw exception;
    }
  var Browser={mainLoop:{scheduler:null,shouldPause:false,paused:false,queue:[],pause:function () {
          Browser.mainLoop.shouldPause = true;
        },resume:function () {
          if (Browser.mainLoop.paused) {
            Browser.mainLoop.paused = false;
            Browser.mainLoop.scheduler();
          }
          Browser.mainLoop.shouldPause = false;
        },updateStatus:function () {
          if (Module['setStatus']) {
            var message = Module['statusMessage'] || 'Please wait...';
            var remaining = Browser.mainLoop.remainingBlockers;
            var expected = Browser.mainLoop.expectedBlockers;
            if (remaining) {
              if (remaining < expected) {
                Module['setStatus'](message + ' (' + (expected - remaining) + '/' + expected + ')');
              } else {
                Module['setStatus'](message);
              }
            } else {
              Module['setStatus']('');
            }
          }
        }},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:function () {
        if (!Module["preloadPlugins"]) Module["preloadPlugins"] = []; // needs to exist even in workers
        if (Browser.initted || ENVIRONMENT_IS_WORKER) return;
        Browser.initted = true;
        try {
          new Blob();
          Browser.hasBlobConstructor = true;
        } catch(e) {
          Browser.hasBlobConstructor = false;
          console.log("warning: no blob constructor, cannot create blobs with mimetypes");
        }
        Browser.BlobBuilder = typeof MozBlobBuilder != "undefined" ? MozBlobBuilder : (typeof WebKitBlobBuilder != "undefined" ? WebKitBlobBuilder : (!Browser.hasBlobConstructor ? console.log("warning: no BlobBuilder") : null));
        Browser.URLObject = typeof window != "undefined" ? (window.URL ? window.URL : window.webkitURL) : undefined;
        if (!Module.noImageDecoding && typeof Browser.URLObject === 'undefined') {
          console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");
          Module.noImageDecoding = true;
        }
        // Support for plugins that can process preloaded files. You can add more of these to
        // your app by creating and appending to Module.preloadPlugins.
        //
        // Each plugin is asked if it can handle a file based on the file's name. If it can,
        // it is given the file's raw data. When it is done, it calls a callback with the file's
        // (possibly modified) data. For example, a plugin might decompress a file, or it
        // might create some side data structure for use later (like an Image element, etc.).
        var imagePlugin = {};
        imagePlugin['canHandle'] = function(name) {
          return !Module.noImageDecoding && /\.(jpg|jpeg|png|bmp)$/i.test(name);
        };
        imagePlugin['handle'] = function(byteArray, name, onload, onerror) {
          var b = null;
          if (Browser.hasBlobConstructor) {
            try {
              b = new Blob([byteArray], { type: Browser.getMimetype(name) });
              if (b.size !== byteArray.length) { // Safari bug #118630
                // Safari's Blob can only take an ArrayBuffer
                b = new Blob([(new Uint8Array(byteArray)).buffer], { type: Browser.getMimetype(name) });
              }
            } catch(e) {
              Runtime.warnOnce('Blob constructor present but fails: ' + e + '; falling back to blob builder');
            }
          }
          if (!b) {
            var bb = new Browser.BlobBuilder();
            bb.append((new Uint8Array(byteArray)).buffer); // we need to pass a buffer, and must copy the array to get the right data range
            b = bb.getBlob();
          }
          var url = Browser.URLObject.createObjectURL(b);
          var img = new Image();
          img.onload = function() {
            assert(img.complete, 'Image ' + name + ' could not be decoded');
            var canvas = document.createElement('canvas');
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext('2d');
            ctx.drawImage(img, 0, 0);
            Module["preloadedImages"][name] = canvas;
            Browser.URLObject.revokeObjectURL(url);
            if (onload) onload(byteArray);
          };
          img.onerror = function(event) {
            console.log('Image ' + url + ' could not be decoded');
            if (onerror) onerror();
          };
          img.src = url;
        };
        Module['preloadPlugins'].push(imagePlugin);
        var audioPlugin = {};
        audioPlugin['canHandle'] = function(name) {
          return !Module.noAudioDecoding && name.substr(-4) in { '.ogg': 1, '.wav': 1, '.mp3': 1 };
        };
        audioPlugin['handle'] = function(byteArray, name, onload, onerror) {
          var done = false;
          function finish(audio) {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = audio;
            if (onload) onload(byteArray);
          }
          function fail() {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = new Audio(); // empty shim
            if (onerror) onerror();
          }
          if (Browser.hasBlobConstructor) {
            try {
              var b = new Blob([byteArray], { type: Browser.getMimetype(name) });
            } catch(e) {
              return fail();
            }
            var url = Browser.URLObject.createObjectURL(b); // XXX we never revoke this!
            var audio = new Audio();
            audio.addEventListener('canplaythrough', function() { finish(audio) }, false); // use addEventListener due to chromium bug 124926
            audio.onerror = function(event) {
              if (done) return;
              console.log('warning: browser could not fully decode audio ' + name + ', trying slower base64 approach');
              function encode64(data) {
                var BASE = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
                var PAD = '=';
                var ret = '';
                var leftchar = 0;
                var leftbits = 0;
                for (var i = 0; i < data.length; i++) {
                  leftchar = (leftchar << 8) | data[i];
                  leftbits += 8;
                  while (leftbits >= 6) {
                    var curr = (leftchar >> (leftbits-6)) & 0x3f;
                    leftbits -= 6;
                    ret += BASE[curr];
                  }
                }
                if (leftbits == 2) {
                  ret += BASE[(leftchar&3) << 4];
                  ret += PAD + PAD;
                } else if (leftbits == 4) {
                  ret += BASE[(leftchar&0xf) << 2];
                  ret += PAD;
                }
                return ret;
              }
              audio.src = 'data:audio/x-' + name.substr(-3) + ';base64,' + encode64(byteArray);
              finish(audio); // we don't wait for confirmation this worked - but it's worth trying
            };
            audio.src = url;
            // workaround for chrome bug 124926 - we do not always get oncanplaythrough or onerror
            Browser.safeSetTimeout(function() {
              finish(audio); // try to use it even though it is not necessarily ready to play
            }, 10000);
          } else {
            return fail();
          }
        };
        Module['preloadPlugins'].push(audioPlugin);
        // Canvas event setup
        var canvas = Module['canvas'];
        canvas.requestPointerLock = canvas['requestPointerLock'] ||
                                    canvas['mozRequestPointerLock'] ||
                                    canvas['webkitRequestPointerLock'];
        canvas.exitPointerLock = document['exitPointerLock'] ||
                                 document['mozExitPointerLock'] ||
                                 document['webkitExitPointerLock'] ||
                                 function(){}; // no-op if function does not exist
        canvas.exitPointerLock = canvas.exitPointerLock.bind(document);
        function pointerLockChange() {
          Browser.pointerLock = document['pointerLockElement'] === canvas ||
                                document['mozPointerLockElement'] === canvas ||
                                document['webkitPointerLockElement'] === canvas;
        }
        document.addEventListener('pointerlockchange', pointerLockChange, false);
        document.addEventListener('mozpointerlockchange', pointerLockChange, false);
        document.addEventListener('webkitpointerlockchange', pointerLockChange, false);
        if (Module['elementPointerLock']) {
          canvas.addEventListener("click", function(ev) {
            if (!Browser.pointerLock && canvas.requestPointerLock) {
              canvas.requestPointerLock();
              ev.preventDefault();
            }
          }, false);
        }
      },createContext:function (canvas, useWebGL, setInModule) {
        var ctx;
        try {
          if (useWebGL) {
            ctx = canvas.getContext('experimental-webgl', {
              alpha: false
            });
          } else {
            ctx = canvas.getContext('2d');
          }
          if (!ctx) throw ':(';
        } catch (e) {
          Module.print('Could not create canvas - ' + e);
          return null;
        }
        if (useWebGL) {
          // Set the background of the WebGL canvas to black
          canvas.style.backgroundColor = "black";
          // Warn on context loss
          canvas.addEventListener('webglcontextlost', function(event) {
            alert('WebGL context lost. You will need to reload the page.');
          }, false);
        }
        if (setInModule) {
          Module.ctx = ctx;
          Module.useWebGL = useWebGL;
          Browser.moduleContextCreatedCallbacks.forEach(function(callback) { callback() });
          Browser.init();
        }
        return ctx;
      },destroyContext:function (canvas, useWebGL, setInModule) {},fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:function (lockPointer, resizeCanvas) {
        Browser.lockPointer = lockPointer;
        Browser.resizeCanvas = resizeCanvas;
        if (typeof Browser.lockPointer === 'undefined') Browser.lockPointer = true;
        if (typeof Browser.resizeCanvas === 'undefined') Browser.resizeCanvas = false;
        var canvas = Module['canvas'];
        function fullScreenChange() {
          Browser.isFullScreen = false;
          if ((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
               document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
               document['fullScreenElement'] || document['fullscreenElement']) === canvas) {
            canvas.cancelFullScreen = document['cancelFullScreen'] ||
                                      document['mozCancelFullScreen'] ||
                                      document['webkitCancelFullScreen'];
            canvas.cancelFullScreen = canvas.cancelFullScreen.bind(document);
            if (Browser.lockPointer) canvas.requestPointerLock();
            Browser.isFullScreen = true;
            if (Browser.resizeCanvas) Browser.setFullScreenCanvasSize();
          } else if (Browser.resizeCanvas){
            Browser.setWindowedCanvasSize();
          }
          if (Module['onFullScreen']) Module['onFullScreen'](Browser.isFullScreen);
        }
        if (!Browser.fullScreenHandlersInstalled) {
          Browser.fullScreenHandlersInstalled = true;
          document.addEventListener('fullscreenchange', fullScreenChange, false);
          document.addEventListener('mozfullscreenchange', fullScreenChange, false);
          document.addEventListener('webkitfullscreenchange', fullScreenChange, false);
        }
        canvas.requestFullScreen = canvas['requestFullScreen'] ||
                                   canvas['mozRequestFullScreen'] ||
                                   (canvas['webkitRequestFullScreen'] ? function() { canvas['webkitRequestFullScreen'](Element['ALLOW_KEYBOARD_INPUT']) } : null);
        canvas.requestFullScreen();
      },requestAnimationFrame:function (func) {
        if (!window.requestAnimationFrame) {
          window.requestAnimationFrame = window['requestAnimationFrame'] ||
                                         window['mozRequestAnimationFrame'] ||
                                         window['webkitRequestAnimationFrame'] ||
                                         window['msRequestAnimationFrame'] ||
                                         window['oRequestAnimationFrame'] ||
                                         window['setTimeout'];
        }
        window.requestAnimationFrame(func);
      },safeCallback:function (func) {
        return function() {
          if (!ABORT) return func.apply(null, arguments);
        };
      },safeRequestAnimationFrame:function (func) {
        return Browser.requestAnimationFrame(function() {
          if (!ABORT) func();
        });
      },safeSetTimeout:function (func, timeout) {
        return setTimeout(function() {
          if (!ABORT) func();
        }, timeout);
      },safeSetInterval:function (func, timeout) {
        return setInterval(function() {
          if (!ABORT) func();
        }, timeout);
      },getMimetype:function (name) {
        return {
          'jpg': 'image/jpeg',
          'jpeg': 'image/jpeg',
          'png': 'image/png',
          'bmp': 'image/bmp',
          'ogg': 'audio/ogg',
          'wav': 'audio/wav',
          'mp3': 'audio/mpeg'
        }[name.substr(name.lastIndexOf('.')+1)];
      },getUserMedia:function (func) {
        if(!window.getUserMedia) {
          window.getUserMedia = navigator['getUserMedia'] ||
                                navigator['mozGetUserMedia'];
        }
        window.getUserMedia(func);
      },getMovementX:function (event) {
        return event['movementX'] ||
               event['mozMovementX'] ||
               event['webkitMovementX'] ||
               0;
      },getMovementY:function (event) {
        return event['movementY'] ||
               event['mozMovementY'] ||
               event['webkitMovementY'] ||
               0;
      },mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,calculateMouseEvent:function (event) { // event should be mousemove, mousedown or mouseup
        if (Browser.pointerLock) {
          // When the pointer is locked, calculate the coordinates
          // based on the movement of the mouse.
          // Workaround for IceCat bug 764498
          if (event.type != 'mousemove' &&
              ('mozMovementX' in event)) {
            Browser.mouseMovementX = Browser.mouseMovementY = 0;
          } else {
            Browser.mouseMovementX = Browser.getMovementX(event);
            Browser.mouseMovementY = Browser.getMovementY(event);
          }
          // check if SDL is available
          if (typeof SDL != "undefined") {
          	Browser.mouseX = SDL.mouseX + Browser.mouseMovementX;
          	Browser.mouseY = SDL.mouseY + Browser.mouseMovementY;
          } else {
          	// just add the mouse delta to the current absolut mouse position
          	// FIXME: ideally this should be clamped against the canvas size and zero
          	Browser.mouseX += Browser.mouseMovementX;
          	Browser.mouseY += Browser.mouseMovementY;
          }        
        } else {
          // Otherwise, calculate the movement based on the changes
          // in the coordinates.
          var rect = Module["canvas"].getBoundingClientRect();
          var x, y;
          if (event.type == 'touchstart' ||
              event.type == 'touchend' ||
              event.type == 'touchmove') {
            var t = event.touches.item(0);
            if (t) {
              x = t.pageX - (window.scrollX + rect.left);
              y = t.pageY - (window.scrollY + rect.top);
            } else {
              return;
            }
          } else {
            x = event.pageX - (window.scrollX + rect.left);
            y = event.pageY - (window.scrollY + rect.top);
          }
          // the canvas might be CSS-scaled compared to its backbuffer;
          // SDL-using content will want mouse coordinates in terms
          // of backbuffer units.
          var cw = Module["canvas"].width;
          var ch = Module["canvas"].height;
          x = x * (cw / rect.width);
          y = y * (ch / rect.height);
          Browser.mouseMovementX = x - Browser.mouseX;
          Browser.mouseMovementY = y - Browser.mouseY;
          Browser.mouseX = x;
          Browser.mouseY = y;
        }
      },xhrLoad:function (url, onload, onerror) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'arraybuffer';
        xhr.onload = function() {
          if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
            onload(xhr.response);
          } else {
            onerror();
          }
        };
        xhr.onerror = onerror;
        xhr.send(null);
      },asyncLoad:function (url, onload, onerror, noRunDep) {
        Browser.xhrLoad(url, function(arrayBuffer) {
          assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
          onload(new Uint8Array(arrayBuffer));
          if (!noRunDep) removeRunDependency('al ' + url);
        }, function(event) {
          if (onerror) {
            onerror();
          } else {
            throw 'Loading data file "' + url + '" failed.';
          }
        });
        if (!noRunDep) addRunDependency('al ' + url);
      },resizeListeners:[],updateResizeListeners:function () {
        var canvas = Module['canvas'];
        Browser.resizeListeners.forEach(function(listener) {
          listener(canvas.width, canvas.height);
        });
      },setCanvasSize:function (width, height, noUpdates) {
        var canvas = Module['canvas'];
        canvas.width = width;
        canvas.height = height;
        if (!noUpdates) Browser.updateResizeListeners();
      },windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:function () {
        var canvas = Module['canvas'];
        this.windowedWidth = canvas.width;
        this.windowedHeight = canvas.height;
        canvas.width = screen.width;
        canvas.height = screen.height;
        // check if SDL is available   
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags | 0x00800000; // set SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      },setWindowedCanvasSize:function () {
        var canvas = Module['canvas'];
        canvas.width = this.windowedWidth;
        canvas.height = this.windowedHeight;
        // check if SDL is available       
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags & ~0x00800000; // clear SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      }};
FS.staticInit();__ATINIT__.unshift({ func: function() { if (!Module["noFSInit"] && !FS.init.initialized) FS.init() } });__ATMAIN__.push({ func: function() { FS.ignorePermissions = false } });__ATEXIT__.push({ func: function() { FS.quit() } });Module["FS_createFolder"] = FS.createFolder;Module["FS_createPath"] = FS.createPath;Module["FS_createDataFile"] = FS.createDataFile;Module["FS_createPreloadedFile"] = FS.createPreloadedFile;Module["FS_createLazyFile"] = FS.createLazyFile;Module["FS_createLink"] = FS.createLink;Module["FS_createDevice"] = FS.createDevice;
___errno_state = Runtime.staticAlloc(4); HEAP32[((___errno_state)>>2)]=0;
__ATINIT__.unshift({ func: function() { TTY.init() } });__ATEXIT__.push({ func: function() { TTY.shutdown() } });TTY.utf8 = new Runtime.UTF8Processor();
__ATINIT__.push({ func: function() { SOCKFS.root = FS.mount(SOCKFS, {}, null); } });
_llvm_eh_exception.buf = allocate(12, "void*", ALLOC_STATIC);
Module["requestFullScreen"] = function(lockPointer, resizeCanvas) { Browser.requestFullScreen(lockPointer, resizeCanvas) };
  Module["requestAnimationFrame"] = function(func) { Browser.requestAnimationFrame(func) };
  Module["setCanvasSize"] = function(width, height, noUpdates) { Browser.setCanvasSize(width, height, noUpdates) };
  Module["pauseMainLoop"] = function() { Browser.mainLoop.pause() };
  Module["resumeMainLoop"] = function() { Browser.mainLoop.resume() };
  Module["getUserMedia"] = function() { Browser.getUserMedia() }
STACK_BASE = STACKTOP = Runtime.alignMemory(STATICTOP);
staticSealed = true; // seal the static portion of memory
STACK_MAX = STACK_BASE + 5242880;
DYNAMIC_BASE = DYNAMICTOP = Runtime.alignMemory(STACK_MAX);
assert(DYNAMIC_BASE < TOTAL_MEMORY); // Stack must fit in TOTAL_MEMORY; allocations from here on may enlarge TOTAL_MEMORY
 var ctlz_i8 = allocate([8,7,6,6,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_DYNAMIC);
 var cttz_i8 = allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0], "i8", ALLOC_DYNAMIC);
var Math_min = Math.min;
function invoke_iiiiiiii(index,a1,a2,a3,a4,a5,a6,a7) {
  try {
    return Module["dynCall_iiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vif(index,a1,a2) {
  try {
    Module["dynCall_vif"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viifii(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_viifii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiii(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vi(index,a1) {
  try {
    Module["dynCall_vi"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vii(index,a1,a2) {
  try {
    Module["dynCall_vii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiifii(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viiifii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vifiii(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_vifiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_ii(index,a1) {
  try {
    return Module["dynCall_ii"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiffffiif(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11) {
  try {
    Module["dynCall_viiiiffffiif"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fiii(index,a1,a2,a3) {
  try {
    return Module["dynCall_fiii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiif(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_viiif"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11) {
  try {
    return Module["dynCall_fiiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fiifii(index,a1,a2,a3,a4,a5) {
  try {
    return Module["dynCall_fiifii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iii(index,a1,a2) {
  try {
    return Module["dynCall_iii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiii(index,a1,a2,a3) {
  try {
    return Module["dynCall_iiii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fif(index,a1,a2) {
  try {
    return Module["dynCall_fif"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8) {
  try {
    Module["dynCall_viiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vifi(index,a1,a2,a3) {
  try {
    Module["dynCall_vifi"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9) {
  try {
    return Module["dynCall_iiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viffiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viffiii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10) {
  try {
    return Module["dynCall_fiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fiiiii(index,a1,a2,a3,a4,a5) {
  try {
    return Module["dynCall_fiiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11) {
  try {
    return Module["dynCall_iiiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vifii(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_vifii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fi(index,a1) {
  try {
    return Module["dynCall_fi"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10) {
  try {
    Module["dynCall_viiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiifffffif(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11) {
  try {
    Module["dynCall_viiiifffffif"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiffii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9) {
  try {
    Module["dynCall_viiiiiffii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iifif(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_iifif"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiii(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_iiiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viii(index,a1,a2,a3) {
  try {
    Module["dynCall_viii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viifi(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_viifi"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_v(index) {
  try {
    Module["dynCall_v"](index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viif(index,a1,a2,a3) {
  try {
    Module["dynCall_viif"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiif(index,a1,a2,a3) {
  try {
    return Module["dynCall_iiif"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fiiifii(index,a1,a2,a3,a4,a5,a6) {
  try {
    return Module["dynCall_fiiifii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiii(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_viiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function asmPrintInt(x, y) {
  Module.print('int ' + x + ',' + y);// + ' ' + new Error().stack);
}
function asmPrintFloat(x, y) {
  Module.print('float ' + x + ',' + y);// + ' ' + new Error().stack);
}
// EMSCRIPTEN_START_ASM
var asmModule = function(global, env, buffer) {
  'use asm';
  var HEAP8 = new global.Int8Array(buffer);
  var HEAP16 = new global.Int16Array(buffer);
  var HEAP32 = new global.Int32Array(buffer);
  var HEAPU8 = new global.Uint8Array(buffer);
  var HEAPU16 = new global.Uint16Array(buffer);
  var HEAPU32 = new global.Uint32Array(buffer);
  var HEAPF32 = new global.Float32Array(buffer);
  var HEAPF64 = new global.Float64Array(buffer);
  var STACKTOP=env.STACKTOP|0;
  var STACK_MAX=env.STACK_MAX|0;
  var tempDoublePtr=env.tempDoublePtr|0;
  var ABORT=env.ABORT|0;
  var cttz_i8=env.cttz_i8|0;
  var ctlz_i8=env.ctlz_i8|0;
  var __ZTVN10__cxxabiv117__class_type_infoE=env.__ZTVN10__cxxabiv117__class_type_infoE|0;
  var __ZTVN10__cxxabiv120__si_class_type_infoE=env.__ZTVN10__cxxabiv120__si_class_type_infoE|0;
  var ___dso_handle=env.___dso_handle|0;
  var NaN=+env.NaN;
  var Infinity=+env.Infinity;
  var __THREW__ = 0;
  var threwValue = 0;
  var setjmpId = 0;
  var undef = 0;
  var tempInt = 0, tempBigInt = 0, tempBigIntP = 0, tempBigIntS = 0, tempBigIntR = 0.0, tempBigIntI = 0, tempBigIntD = 0, tempValue = 0, tempDouble = 0.0;
  var tempRet0 = 0;
  var tempRet1 = 0;
  var tempRet2 = 0;
  var tempRet3 = 0;
  var tempRet4 = 0;
  var tempRet5 = 0;
  var tempRet6 = 0;
  var tempRet7 = 0;
  var tempRet8 = 0;
  var tempRet9 = 0;
  var Math_floor=global.Math.floor;
  var Math_abs=global.Math.abs;
  var Math_sqrt=global.Math.sqrt;
  var Math_pow=global.Math.pow;
  var Math_cos=global.Math.cos;
  var Math_sin=global.Math.sin;
  var Math_tan=global.Math.tan;
  var Math_acos=global.Math.acos;
  var Math_asin=global.Math.asin;
  var Math_atan=global.Math.atan;
  var Math_atan2=global.Math.atan2;
  var Math_exp=global.Math.exp;
  var Math_log=global.Math.log;
  var Math_ceil=global.Math.ceil;
  var Math_imul=global.Math.imul;
  var abort=env.abort;
  var assert=env.assert;
  var asmPrintInt=env.asmPrintInt;
  var asmPrintFloat=env.asmPrintFloat;
  var Math_min=env.min;
  var invoke_iiiiiiii=env.invoke_iiiiiiii;
  var invoke_vif=env.invoke_vif;
  var invoke_viifii=env.invoke_viifii;
  var invoke_viiiii=env.invoke_viiiii;
  var invoke_vi=env.invoke_vi;
  var invoke_vii=env.invoke_vii;
  var invoke_viiifii=env.invoke_viiifii;
  var invoke_vifiii=env.invoke_vifiii;
  var invoke_ii=env.invoke_ii;
  var invoke_viiiiffffiif=env.invoke_viiiiffffiif;
  var invoke_fiii=env.invoke_fiii;
  var invoke_viiif=env.invoke_viiif;
  var invoke_fiiiiiiiiiii=env.invoke_fiiiiiiiiiii;
  var invoke_fiifii=env.invoke_fiifii;
  var invoke_iii=env.invoke_iii;
  var invoke_iiii=env.invoke_iiii;
  var invoke_fif=env.invoke_fif;
  var invoke_viiiiiiii=env.invoke_viiiiiiii;
  var invoke_vifi=env.invoke_vifi;
  var invoke_viiiiii=env.invoke_viiiiii;
  var invoke_iiiiiiiiii=env.invoke_iiiiiiiiii;
  var invoke_viffiii=env.invoke_viffiii;
  var invoke_iiiiiii=env.invoke_iiiiiii;
  var invoke_fiiiiiiiiii=env.invoke_fiiiiiiiiii;
  var invoke_fiiiii=env.invoke_fiiiii;
  var invoke_iiiiiiiiiiii=env.invoke_iiiiiiiiiiii;
  var invoke_vifii=env.invoke_vifii;
  var invoke_fi=env.invoke_fi;
  var invoke_viiiiiiiiii=env.invoke_viiiiiiiiii;
  var invoke_viiiifffffif=env.invoke_viiiifffffif;
  var invoke_viiiiiffii=env.invoke_viiiiiffii;
  var invoke_iifif=env.invoke_iifif;
  var invoke_iiiii=env.invoke_iiiii;
  var invoke_viii=env.invoke_viii;
  var invoke_viifi=env.invoke_viifi;
  var invoke_v=env.invoke_v;
  var invoke_viif=env.invoke_viif;
  var invoke_iiif=env.invoke_iiif;
  var invoke_fiiifii=env.invoke_fiiifii;
  var invoke_viiii=env.invoke_viiii;
  var _llvm_lifetime_end=env._llvm_lifetime_end;
  var _cosf=env._cosf;
  var _fabsf=env._fabsf;
  var _sysconf=env._sysconf;
  var ___cxa_throw=env.___cxa_throw;
  var _atexit=env._atexit;
  var _abort=env._abort;
  var _fprintf=env._fprintf;
  var _llvm_eh_exception=env._llvm_eh_exception;
  var _printf=env._printf;
  var _acosf=env._acosf;
  var _fflush=env._fflush;
  var __reallyNegative=env.__reallyNegative;
  var _sqrtf=env._sqrtf;
  var _llvm_pow_f32=env._llvm_pow_f32;
  var ___setErrNo=env.___setErrNo;
  var _fwrite=env._fwrite;
  var _send=env._send;
  var _write=env._write;
  var _exit=env._exit;
  var _atan2f=env._atan2f;
  var ___cxa_pure_virtual=env.___cxa_pure_virtual;
  var ___cxa_is_number_type=env.___cxa_is_number_type;
  var _time=env._time;
  var __formatString=env.__formatString;
  var ___cxa_does_inherit=env.___cxa_does_inherit;
  var ___cxa_guard_acquire=env.___cxa_guard_acquire;
  var __ZSt9terminatev=env.__ZSt9terminatev;
  var _gettimeofday=env._gettimeofday;
  var ___cxa_find_matching_catch=env.___cxa_find_matching_catch;
  var _sinf=env._sinf;
  var ___assert_func=env.___assert_func;
  var __ZSt18uncaught_exceptionv=env.__ZSt18uncaught_exceptionv;
  var _pwrite=env._pwrite;
  var ___cxa_call_unexpected=env.___cxa_call_unexpected;
  var _sbrk=env._sbrk;
  var ___cxa_guard_abort=env.___cxa_guard_abort;
  var ___cxa_allocate_exception=env.___cxa_allocate_exception;
  var ___errno_location=env.___errno_location;
  var ___gxx_personality_v0=env.___gxx_personality_v0;
  var _llvm_lifetime_start=env._llvm_lifetime_start;
  var _fmod=env._fmod;
  var ___cxa_guard_release=env.___cxa_guard_release;
  var __exit=env.__exit;
  var ___resumeException=env.___resumeException;
// EMSCRIPTEN_START_FUNCS
function __ZN20btConvexHullInternal9shiftFaceEPNS_4FaceEf20btAlignedObjectArrayIPNS_6VertexEE(i1, i2, d3, i4) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 d3 = +d3;
 i4 = i4 | 0;
 var i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, d15 = 0.0, d16 = 0.0, d17 = 0.0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0, i62 = 0, i63 = 0, i64 = 0, i65 = 0, i66 = 0, i67 = 0, i68 = 0, i69 = 0, i70 = 0, i71 = 0, i72 = 0, i73 = 0, i74 = 0, i75 = 0, i76 = 0, i77 = 0, i78 = 0, i79 = 0, i80 = 0, i81 = 0, i82 = 0, i83 = 0, i84 = 0, i85 = 0, i86 = 0, i87 = 0, i88 = 0, i89 = 0, i90 = 0, i91 = 0, i92 = 0, i93 = 0, i94 = 0, i95 = 0, i96 = 0, i97 = 0, i98 = 0, i99 = 0, i100 = 0, i101 = 0, i102 = 0, i103 = 0, i104 = 0, i105 = 0, i106 = 0, i107 = 0, i108 = 0, i109 = 0, i110 = 0, i111 = 0, i112 = 0, i113 = 0, i114 = 0, i115 = 0, i116 = 0, i117 = 0, i118 = 0, i119 = 0, i120 = 0, i121 = 0, i122 = 0, i123 = 0, i124 = 0, i125 = 0, i126 = 0, i127 = 0, i128 = 0, i129 = 0, i130 = 0, i131 = 0, i132 = 0, i133 = 0, i134 = 0, i135 = 0, i136 = 0, i137 = 0, i138 = 0, i139 = 0, i140 = 0, i141 = 0, i142 = 0, i143 = 0, i144 = 0, i145 = 0, i146 = 0, i147 = 0, i148 = 0, i149 = 0, i150 = 0, i151 = 0, i152 = 0, i153 = 0, i154 = 0, i155 = 0, i156 = 0, i157 = 0, i158 = 0, i159 = 0, i160 = 0, i161 = 0, i162 = 0, i163 = 0, i164 = 0, i165 = 0, i166 = 0, i167 = 0, i168 = 0, i169 = 0, i170 = 0, i171 = 0, i172 = 0, i173 = 0, i174 = 0, i175 = 0, i176 = 0, i177 = 0, i178 = 0, i179 = 0, i180 = 0, i181 = 0, i182 = 0, i183 = 0, i184 = 0, i185 = 0, i186 = 0, i187 = 0, i188 = 0, i189 = 0, i190 = 0, i191 = 0, i192 = 0, i193 = 0, i194 = 0, i195 = 0, i196 = 0, i197 = 0, i198 = 0, i199 = 0, i200 = 0, i201 = 0, i202 = 0, i203 = 0, i204 = 0, i205 = 0, i206 = 0, i207 = 0, i208 = 0, i209 = 0, i210 = 0, i211 = 0, i212 = 0, i213 = 0, i214 = 0, i215 = 0, i216 = 0, i217 = 0, i218 = 0, i219 = 0, i220 = 0, i221 = 0, i222 = 0, i223 = 0, i224 = 0, i225 = 0, i226 = 0, i227 = 0, i228 = 0, i229 = 0, i230 = 0, i231 = 0, i232 = 0, i233 = 0, i234 = 0, i235 = 0, i236 = 0, i237 = 0, i238 = 0, i239 = 0, i240 = 0, i241 = 0, i242 = 0, i243 = 0, i244 = 0, i245 = 0, i246 = 0, i247 = 0, i248 = 0, i249 = 0, i250 = 0, i251 = 0, i252 = 0, i253 = 0, i254 = 0, i255 = 0, i256 = 0, i257 = 0, i258 = 0, i259 = 0, i260 = 0, i261 = 0, i262 = 0, i263 = 0, i264 = 0, i265 = 0, i266 = 0, i267 = 0, i268 = 0, i269 = 0, i270 = 0, i271 = 0, i272 = 0, i273 = 0, i274 = 0, i275 = 0, i276 = 0, i277 = 0, i278 = 0, i279 = 0, i280 = 0, i281 = 0, i282 = 0, i283 = 0, i284 = 0, i285 = 0, i286 = 0, i287 = 0, i288 = 0, i289 = 0, i290 = 0, i291 = 0, i292 = 0, i293 = 0, i294 = 0, i295 = 0, i296 = 0, i297 = 0, i298 = 0, i299 = 0, i300 = 0, i301 = 0, i302 = 0;
 i5 = STACKTOP;
 STACKTOP = STACKTOP + 296 | 0;
 i6 = i5 | 0;
 i7 = i5 + 16 | 0;
 i8 = i5 + 32 | 0;
 i9 = i5 + 56 | 0;
 i10 = i5 + 96 | 0;
 i11 = i5 + 136 | 0;
 i12 = i5 + 176 | 0;
 i13 = i5 + 216 | 0;
 i14 = i5 + 256 | 0;
 __ZN20btConvexHullInternal11getBtNormalEPNS_4FaceE(i7, i1, i2);
 d15 = -0.0 - d3;
 d3 = +HEAPF32[i7 >> 2] * d15;
 d16 = +HEAPF32[i7 + 4 >> 2] * d15;
 d17 = +HEAPF32[i7 + 8 >> 2] * d15;
 i7 = i6 | 0;
 HEAPF32[i7 >> 2] = d3;
 i18 = i6 + 4 | 0;
 HEAPF32[i18 >> 2] = d16;
 i19 = i6 + 8 | 0;
 HEAPF32[i19 >> 2] = d17;
 HEAPF32[i6 + 12 >> 2] = 0.0;
 d15 = +HEAPF32[i1 >> 2];
 if (d15 > 0.0) {
  HEAPF32[i7 >> 2] = d3 / d15;
 }
 d15 = +HEAPF32[i1 + 4 >> 2];
 if (d15 > 0.0) {
  HEAPF32[i18 >> 2] = d16 / d15;
 }
 d15 = +HEAPF32[i1 + 8 >> 2];
 if (d15 > 0.0) {
  HEAPF32[i19 >> 2] = d17 / d15;
 }
 i19 = ~~+HEAPF32[i6 + (HEAP32[i1 + 108 >> 2] << 2) >> 2];
 i18 = ~~+HEAPF32[i6 + (HEAP32[i1 + 112 >> 2] << 2) >> 2];
 i7 = ~~+HEAPF32[i6 + (HEAP32[i1 + 104 >> 2] << 2) >> 2];
 if ((i18 | i19 | i7 | 0) == 0) {
  i20 = 1;
  STACKTOP = i5;
  return i20 | 0;
 }
 i6 = i2 + 32 | 0;
 i21 = HEAP32[i6 >> 2] | 0;
 i22 = i2 + 52 | 0;
 i23 = HEAP32[i22 >> 2] | 0;
 i24 = Math_imul(i23, i21) | 0;
 i25 = i2 + 36 | 0;
 i26 = HEAP32[i25 >> 2] | 0;
 i27 = i2 + 48 | 0;
 i28 = HEAP32[i27 >> 2] | 0;
 i29 = i24 - (Math_imul(i28, i26) | 0) | 0;
 i24 = i29;
 i30 = (i29 | 0) < 0 ? -1 : 0;
 i29 = i2 + 44 | 0;
 i31 = HEAP32[i29 >> 2] | 0;
 i32 = Math_imul(i31, i26) | 0;
 i26 = i2 + 28 | 0;
 i33 = HEAP32[i26 >> 2] | 0;
 i34 = i32 - (Math_imul(i33, i23) | 0) | 0;
 i23 = i34;
 i32 = (i34 | 0) < 0 ? -1 : 0;
 i34 = Math_imul(i33, i28) | 0;
 i28 = i34 - (Math_imul(i31, i21) | 0) | 0;
 i21 = i28;
 i31 = (i28 | 0) < 0 ? -1 : 0;
 i28 = i8 | 0;
 HEAP32[i28 >> 2] = i24;
 HEAP32[i28 + 4 >> 2] = i30;
 i28 = i8 + 8 | 0;
 HEAP32[i28 >> 2] = i23;
 HEAP32[i28 + 4 >> 2] = i32;
 i28 = i8 + 16 | 0;
 HEAP32[i28 >> 2] = i21;
 HEAP32[i28 + 4 >> 2] = i31;
 i28 = i2 + 12 | 0;
 i34 = HEAP32[i28 >> 2] | 0;
 i33 = ___muldi3(i34, (i34 | 0) < 0 ? -1 : 0, i24, i30) | 0;
 i35 = tempRet0;
 i36 = i2 + 16 | 0;
 i37 = HEAP32[i36 >> 2] | 0;
 i38 = ___muldi3(i37, (i37 | 0) < 0 ? -1 : 0, i23, i32) | 0;
 i39 = _i64Add(i38, tempRet0, i33, i35) | 0;
 i35 = tempRet0;
 i33 = i2 + 20 | 0;
 i38 = HEAP32[i33 >> 2] | 0;
 i40 = ___muldi3(i38, (i38 | 0) < 0 ? -1 : 0, i21, i31) | 0;
 i41 = _i64Add(i39, i35, i40, tempRet0) | 0;
 i40 = tempRet0;
 i35 = i34 + i19 | 0;
 i19 = i37 + i18 | 0;
 i18 = i38 + i7 | 0;
 i7 = i35;
 i38 = (i35 | 0) < 0 ? -1 : 0;
 i37 = ___muldi3(i7, i38, i24, i30) | 0;
 i30 = tempRet0;
 i24 = i19;
 i34 = (i19 | 0) < 0 ? -1 : 0;
 i39 = ___muldi3(i24, i34, i23, i32) | 0;
 i32 = _i64Add(i39, tempRet0, i37, i30) | 0;
 i30 = tempRet0;
 i37 = i18;
 i39 = (i18 | 0) < 0 ? -1 : 0;
 i23 = ___muldi3(i37, i39, i21, i31) | 0;
 i31 = _i64Add(i32, i30, i23, tempRet0) | 0;
 i23 = tempRet0;
 if (!((i23 | 0) < (i40 | 0) | (i23 | 0) == (i40 | 0) & i31 >>> 0 < i41 >>> 0)) {
  i20 = 0;
  STACKTOP = i5;
  return i20 | 0;
 }
 i41 = HEAP32[i2 + 4 >> 2] | 0;
 i40 = HEAP32[i41 + 8 >> 2] | 0;
 __ZNK20btConvexHullInternal6Vertex3dotERKNS_7Point64E(i9, i41, i8);
 i41 = __ZNK20btConvexHullInternal11Rational1287compareEx(i9, i31, i23) | 0;
 i30 = i9;
 do {
  if ((i41 | 0) > -1) {
   i32 = i10;
   i21 = i40;
   i42 = i41;
   i43 = i40;
   while (1) {
    __ZNK20btConvexHullInternal6Vertex3dotERKNS_7Point64E(i10, HEAP32[i43 + 12 >> 2] | 0, i8);
    if ((__ZNK20btConvexHullInternal11Rational1287compareERKS0_(i10, i9) | 0) < 0) {
     i44 = __ZNK20btConvexHullInternal11Rational1287compareEx(i10, i31, i23) | 0;
     HEAP32[i30 >> 2] = HEAP32[i32 >> 2];
     HEAP32[i30 + 4 >> 2] = HEAP32[i32 + 4 >> 2];
     HEAP32[i30 + 8 >> 2] = HEAP32[i32 + 8 >> 2];
     HEAP32[i30 + 12 >> 2] = HEAP32[i32 + 12 >> 2];
     HEAP32[i30 + 16 >> 2] = HEAP32[i32 + 16 >> 2];
     HEAP32[i30 + 20 >> 2] = HEAP32[i32 + 20 >> 2];
     HEAP32[i30 + 24 >> 2] = HEAP32[i32 + 24 >> 2];
     HEAP32[i30 + 28 >> 2] = HEAP32[i32 + 28 >> 2];
     HEAP32[i30 + 32 >> 2] = HEAP32[i32 + 32 >> 2];
     HEAP8[i30 + 36 | 0] = HEAP8[i32 + 36 | 0] | 0;
     i45 = HEAP32[i43 + 8 >> 2] | 0;
     if ((i44 | 0) < 0) {
      break;
     } else {
      i46 = i45;
      i47 = i44;
      i48 = i45;
     }
    } else {
     i46 = i21;
     i47 = i42;
     i48 = i43;
    }
    i44 = HEAP32[i48 + 4 >> 2] | 0;
    if ((i44 | 0) == (i46 | 0)) {
     i20 = 0;
     i49 = 1612;
     break;
    } else {
     i21 = i46;
     i42 = i47;
     i43 = i44;
    }
   }
   if ((i49 | 0) == 1612) {
    STACKTOP = i5;
    return i20 | 0;
   }
   if ((i45 | 0) == 0) {
    i20 = 0;
   } else {
    i50 = i45;
    i51 = i42;
    break;
   }
   STACKTOP = i5;
   return i20 | 0;
  } else {
   i43 = i11;
   i21 = i40;
   i32 = i40;
   while (1) {
    __ZNK20btConvexHullInternal6Vertex3dotERKNS_7Point64E(i11, HEAP32[i32 + 12 >> 2] | 0, i8);
    if ((__ZNK20btConvexHullInternal11Rational1287compareERKS0_(i11, i9) | 0) > 0) {
     i52 = __ZNK20btConvexHullInternal11Rational1287compareEx(i11, i31, i23) | 0;
     if ((i52 | 0) > -1) {
      break;
     }
     HEAP32[i30 >> 2] = HEAP32[i43 >> 2];
     HEAP32[i30 + 4 >> 2] = HEAP32[i43 + 4 >> 2];
     HEAP32[i30 + 8 >> 2] = HEAP32[i43 + 8 >> 2];
     HEAP32[i30 + 12 >> 2] = HEAP32[i43 + 12 >> 2];
     HEAP32[i30 + 16 >> 2] = HEAP32[i43 + 16 >> 2];
     HEAP32[i30 + 20 >> 2] = HEAP32[i43 + 20 >> 2];
     HEAP32[i30 + 24 >> 2] = HEAP32[i43 + 24 >> 2];
     HEAP32[i30 + 28 >> 2] = HEAP32[i43 + 28 >> 2];
     HEAP32[i30 + 32 >> 2] = HEAP32[i43 + 32 >> 2];
     HEAP8[i30 + 36 | 0] = HEAP8[i43 + 36 | 0] | 0;
     i44 = HEAP32[i32 + 8 >> 2] | 0;
     i53 = i44;
     i54 = i44;
    } else {
     i53 = i21;
     i54 = i32;
    }
    i44 = HEAP32[i54 + 4 >> 2] | 0;
    if ((i44 | 0) == (i53 | 0)) {
     i20 = 1;
     i49 = 1615;
     break;
    } else {
     i21 = i53;
     i32 = i44;
    }
   }
   if ((i49 | 0) == 1615) {
    STACKTOP = i5;
    return i20 | 0;
   }
   if ((i32 | 0) == 0) {
    i20 = 1;
   } else {
    i50 = i32;
    i51 = i52;
    break;
   }
   STACKTOP = i5;
   return i20 | 0;
  }
 } while (0);
 L1672 : do {
  if ((i51 | 0) == 0) {
   i52 = i50 + 8 | 0;
   i53 = HEAP32[HEAP32[i52 >> 2] >> 2] | 0;
   while (1) {
    __ZNK20btConvexHullInternal6Vertex3dotERKNS_7Point64E(i12, HEAP32[i53 + 12 >> 2] | 0, i8);
    if ((__ZNK20btConvexHullInternal11Rational1287compareEx(i12, i31, i23) | 0) >= 1) {
     break L1672;
    }
    i54 = HEAP32[i53 >> 2] | 0;
    if ((i54 | 0) == (HEAP32[i52 >> 2] | 0)) {
     i20 = 1;
     break;
    } else {
     i53 = i54;
    }
   }
   STACKTOP = i5;
   return i20 | 0;
  }
 } while (0);
 i12 = i1 + 32 | 0;
 i53 = i4 + 4 | 0;
 i52 = i4 + 8 | 0;
 i32 = i4 + 12 | 0;
 i54 = i4 + 16 | 0;
 i4 = i1 + 56 | 0;
 i30 = i1 + 116 | 0;
 i11 = i1 + 48 | 0;
 i9 = i1 + 100 | 0;
 i40 = i1 + 120 | 0;
 i45 = (i35 | 0) < 0;
 i47 = _i64Subtract(0, 0, i7, i38) | 0;
 i46 = tempRet0;
 i48 = (i19 | 0) < 0;
 i10 = _i64Subtract(0, 0, i24, i34) | 0;
 i41 = tempRet0;
 i21 = (i18 | 0) < 0;
 i43 = _i64Subtract(0, 0, i37, i39) | 0;
 i42 = tempRet0;
 i44 = i50;
 i50 = i51;
 i51 = 0;
 i55 = 0;
 i56 = 0;
 L1679 : while (1) {
  i57 = (i50 | 0) == 0;
  L1681 : do {
   if (i57) {
    i58 = HEAP32[HEAP32[i44 + 8 >> 2] >> 2] | 0;
    i59 = i44;
    i60 = i58;
    while (1) {
     __ZNK20btConvexHullInternal6Vertex3dotERKNS_7Point64E(i13, HEAP32[i60 + 12 >> 2] | 0, i8);
     if ((__ZNK20btConvexHullInternal11Rational1287compareEx(i13, i31, i23) | 0) > -1) {
      i61 = i59;
      break L1681;
     }
     i62 = HEAP32[i60 >> 2] | 0;
     if ((i62 | 0) == (i58 | 0)) {
      i20 = 1;
      i49 = 1618;
      break L1679;
     } else {
      i59 = HEAP32[i60 + 8 >> 2] | 0;
      i60 = i62;
     }
    }
   } else {
    i61 = i44;
   }
  } while (0);
  if ((i51 | 0) == 0) {
   i63 = i61;
  } else {
   if ((i61 | 0) == (i51 | 0)) {
    break;
   } else {
    i63 = i51;
   }
  }
  i60 = i61 + 8 | 0;
  i59 = HEAP32[i60 >> 2] | 0;
  do {
   i59 = HEAP32[(HEAP32[i59 + 8 >> 2] | 0) + 4 >> 2] | 0;
   i64 = i59 + 12 | 0;
   __ZNK20btConvexHullInternal6Vertex3dotERKNS_7Point64E(i14, HEAP32[i64 >> 2] | 0, i8);
   i65 = __ZNK20btConvexHullInternal11Rational1287compareEx(i14, i31, i23) | 0;
  } while ((i65 | 0) <= -1);
  if ((i65 | 0) > 0) {
   i58 = HEAP32[i64 >> 2] | 0;
   i62 = i59 + 8 | 0;
   i66 = HEAP32[i62 >> 2] | 0;
   i67 = i66 + 4 | 0;
   i68 = HEAP32[i67 >> 2] | 0;
   i69 = i58 + 8 | 0;
   if ((i68 | 0) == (i66 | 0)) {
    HEAP32[i69 >> 2] = 0;
   } else {
    HEAP32[i69 >> 2] = i68;
    i68 = HEAP32[i67 >> 2] | 0;
    i69 = i66 | 0;
    i70 = HEAP32[i69 >> 2] | 0;
    HEAP32[i68 >> 2] = i70;
    HEAP32[i70 + 4 >> 2] = i68;
    HEAP32[i69 >> 2] = i66;
    HEAP32[i67 >> 2] = i66;
   }
   i67 = HEAP32[i59 + 16 >> 2] | 0;
   i69 = HEAP32[i67 + 32 >> 2] | 0;
   i68 = HEAP32[i67 + 52 >> 2] | 0;
   i70 = Math_imul(i68, i69) | 0;
   i71 = HEAP32[i67 + 36 >> 2] | 0;
   i72 = HEAP32[i67 + 48 >> 2] | 0;
   i73 = i70 - (Math_imul(i72, i71) | 0) | 0;
   i70 = i73;
   i74 = (i73 | 0) < 0 ? -1 : 0;
   i73 = HEAP32[i67 + 44 >> 2] | 0;
   i75 = Math_imul(i73, i71) | 0;
   i71 = HEAP32[i67 + 28 >> 2] | 0;
   i76 = i75 - (Math_imul(i71, i68) | 0) | 0;
   i68 = i76;
   i75 = (i76 | 0) < 0 ? -1 : 0;
   i76 = Math_imul(i71, i72) | 0;
   i72 = i76 - (Math_imul(i73, i69) | 0) | 0;
   i69 = i72;
   i73 = (i72 | 0) < 0 ? -1 : 0;
   i72 = HEAP32[(HEAP32[i62 >> 2] | 0) + 16 >> 2] | 0;
   i62 = HEAP32[i72 + 32 >> 2] | 0;
   i76 = HEAP32[i72 + 52 >> 2] | 0;
   i71 = Math_imul(i76, i62) | 0;
   i77 = HEAP32[i72 + 36 >> 2] | 0;
   i78 = HEAP32[i72 + 48 >> 2] | 0;
   i79 = i71 - (Math_imul(i78, i77) | 0) | 0;
   i71 = i79;
   i80 = (i79 | 0) < 0 ? -1 : 0;
   i79 = HEAP32[i72 + 44 >> 2] | 0;
   i81 = Math_imul(i79, i77) | 0;
   i77 = HEAP32[i72 + 28 >> 2] | 0;
   i82 = i81 - (Math_imul(i77, i76) | 0) | 0;
   i76 = i82;
   i81 = (i82 | 0) < 0 ? -1 : 0;
   i82 = Math_imul(i77, i78) | 0;
   i78 = i82 - (Math_imul(i79, i62) | 0) | 0;
   i62 = i78;
   i79 = (i78 | 0) < 0 ? -1 : 0;
   i78 = HEAP32[i26 >> 2] | 0;
   i82 = i78;
   i77 = (i78 | 0) < 0 ? -1 : 0;
   i78 = ___muldi3(i82, i77, i70, i74) | 0;
   i83 = tempRet0;
   i84 = HEAP32[i6 >> 2] | 0;
   i85 = i84;
   i86 = (i84 | 0) < 0 ? -1 : 0;
   i84 = ___muldi3(i85, i86, i68, i75) | 0;
   i87 = _i64Add(i84, tempRet0, i78, i83) | 0;
   i83 = tempRet0;
   i78 = HEAP32[i25 >> 2] | 0;
   i84 = i78;
   i88 = (i78 | 0) < 0 ? -1 : 0;
   i78 = ___muldi3(i84, i88, i69, i73) | 0;
   i89 = _i64Add(i87, i83, i78, tempRet0) | 0;
   i78 = tempRet0;
   i83 = HEAP32[i29 >> 2] | 0;
   i87 = i83;
   i90 = (i83 | 0) < 0 ? -1 : 0;
   i83 = ___muldi3(i87, i90, i70, i74) | 0;
   i91 = tempRet0;
   i92 = HEAP32[i27 >> 2] | 0;
   i93 = i92;
   i94 = (i92 | 0) < 0 ? -1 : 0;
   i92 = ___muldi3(i93, i94, i68, i75) | 0;
   i95 = _i64Add(i92, tempRet0, i83, i91) | 0;
   i91 = tempRet0;
   i83 = HEAP32[i22 >> 2] | 0;
   i92 = i83;
   i96 = (i83 | 0) < 0 ? -1 : 0;
   i83 = ___muldi3(i92, i96, i69, i73) | 0;
   i97 = _i64Add(i95, i91, i83, tempRet0) | 0;
   i83 = tempRet0;
   i91 = ___muldi3(i82, i77, i71, i80) | 0;
   i77 = tempRet0;
   i82 = ___muldi3(i85, i86, i76, i81) | 0;
   i86 = _i64Add(i82, tempRet0, i91, i77) | 0;
   i77 = tempRet0;
   i91 = ___muldi3(i84, i88, i62, i79) | 0;
   i88 = _i64Add(i86, i77, i91, tempRet0) | 0;
   i91 = tempRet0;
   i77 = ___muldi3(i87, i90, i71, i80) | 0;
   i90 = tempRet0;
   i87 = ___muldi3(i93, i94, i76, i81) | 0;
   i94 = _i64Add(i87, tempRet0, i77, i90) | 0;
   i90 = tempRet0;
   i77 = ___muldi3(i92, i96, i62, i79) | 0;
   i96 = _i64Add(i94, i90, i77, tempRet0) | 0;
   i77 = tempRet0;
   i90 = (HEAP32[i67 + 12 >> 2] | 0) - i35 | 0;
   i94 = (HEAP32[i67 + 16 >> 2] | 0) - i19 | 0;
   i92 = (HEAP32[i67 + 20 >> 2] | 0) - i18 | 0;
   i67 = ___muldi3(i90, (i90 | 0) < 0 ? -1 : 0, i70, i74) | 0;
   i74 = tempRet0;
   i70 = ___muldi3(i94, (i94 | 0) < 0 ? -1 : 0, i68, i75) | 0;
   i75 = _i64Add(i70, tempRet0, i67, i74) | 0;
   i74 = tempRet0;
   i67 = ___muldi3(i92, (i92 | 0) < 0 ? -1 : 0, i69, i73) | 0;
   i73 = _i64Add(i75, i74, i67, tempRet0) | 0;
   i67 = tempRet0;
   i74 = (HEAP32[i72 + 12 >> 2] | 0) - i35 | 0;
   i75 = (HEAP32[i72 + 16 >> 2] | 0) - i19 | 0;
   i69 = (HEAP32[i72 + 20 >> 2] | 0) - i18 | 0;
   i72 = ___muldi3(i74, (i74 | 0) < 0 ? -1 : 0, i71, i80) | 0;
   i80 = tempRet0;
   i71 = ___muldi3(i75, (i75 | 0) < 0 ? -1 : 0, i76, i81) | 0;
   i81 = _i64Add(i71, tempRet0, i72, i80) | 0;
   i80 = tempRet0;
   i72 = ___muldi3(i69, (i69 | 0) < 0 ? -1 : 0, i62, i79) | 0;
   i79 = _i64Add(i81, i80, i72, tempRet0) | 0;
   i72 = tempRet0;
   i80 = 0;
   i81 = (i78 | 0) < (i80 | 0) | (i78 | 0) == (i80 | 0) & i89 >>> 0 < 0 >>> 0;
   i80 = _i64Subtract(0, 0, i89, i78) | 0;
   i62 = i81 ? tempRet0 : i78;
   i78 = 0;
   i69 = (i77 | 0) < (i78 | 0) | (i77 | 0) == (i78 | 0) & i96 >>> 0 < 0 >>> 0;
   if (i69) {
    i78 = _i64Subtract(0, 0, i96, i77) | 0;
    i98 = i81 ^ 1;
    i99 = tempRet0;
    i100 = i78;
   } else {
    i98 = i81;
    i99 = i77;
    i100 = i96;
   }
   i78 = (i81 ? i80 : i89) | 0;
   i89 = i62 & 0;
   i80 = i100 | 0;
   i71 = i99 & 0;
   i76 = ___muldi3(i80, i71, i78, i89) | 0;
   i75 = tempRet0;
   i74 = i99;
   i92 = 0;
   i70 = ___muldi3(i74, i92, i78, i89) | 0;
   i68 = tempRet0;
   i94 = i62;
   i62 = 0;
   i90 = ___muldi3(i80, i71, i94, i62) | 0;
   i71 = tempRet0;
   i80 = ___muldi3(i74, i92, i94, i62) | 0;
   i92 = tempRet0;
   i74 = _i64Add(i70 | 0, i68 & 0, i90 | 0, i71 & 0) | 0;
   i90 = tempRet0;
   i70 = _i64Add(i68, 0, i80, i92) | 0;
   i92 = _i64Add(i70, tempRet0, i71, 0) | 0;
   i71 = tempRet0;
   i70 = _llvm_uadd_with_overflow_i64(i76 | 0, i75 | 0, 0, i74 | 0) | 0;
   i74 = i70;
   i70 = tempRet0;
   i75 = _i64Add(i92, i71, tempRet1 & 1, 0) | 0;
   i71 = _i64Add(i75, tempRet0, i90, 0) | 0;
   i90 = tempRet0;
   if (i98) {
    i75 = _i64Subtract(0, 0, i74, i70) | 0;
    i92 = tempRet0;
    i76 = _i64Add((i74 | 0) == 0 & (i70 | 0) == 0 & 1, 0, ~i71, ~i90) | 0;
    i101 = i92;
    i102 = i75;
    i103 = tempRet0;
    i104 = i76;
   } else {
    i101 = i70;
    i102 = i74;
    i103 = i90;
    i104 = i71;
   }
   i71 = 0;
   i90 = (i83 | 0) < (i71 | 0) | (i83 | 0) == (i71 | 0) & i97 >>> 0 < 0 >>> 0;
   i71 = _i64Subtract(0, 0, i97, i83) | 0;
   i74 = i90 ? tempRet0 : i83;
   i83 = 0;
   i70 = (i91 | 0) < (i83 | 0) | (i91 | 0) == (i83 | 0) & i88 >>> 0 < 0 >>> 0;
   if (i70) {
    i83 = _i64Subtract(0, 0, i88, i91) | 0;
    i105 = i90 ^ 1;
    i106 = tempRet0;
    i107 = i83;
   } else {
    i105 = i90;
    i106 = i91;
    i107 = i88;
   }
   i83 = (i90 ? i71 : i97) | 0;
   i97 = i74 & 0;
   i71 = i107 | 0;
   i76 = i106 & 0;
   i75 = ___muldi3(i71, i76, i83, i97) | 0;
   i92 = tempRet0;
   i80 = i106;
   i68 = 0;
   i87 = ___muldi3(i80, i68, i83, i97) | 0;
   i93 = tempRet0;
   i86 = i74;
   i74 = 0;
   i84 = ___muldi3(i71, i76, i86, i74) | 0;
   i76 = tempRet0;
   i71 = ___muldi3(i80, i68, i86, i74) | 0;
   i68 = tempRet0;
   i80 = _i64Add(i87 | 0, i93 & 0, i84 | 0, i76 & 0) | 0;
   i84 = tempRet0;
   i87 = _i64Add(i93, 0, i71, i68) | 0;
   i68 = _i64Add(i87, tempRet0, i76, 0) | 0;
   i76 = tempRet0;
   i87 = _llvm_uadd_with_overflow_i64(i75 | 0, i92 | 0, 0, i80 | 0) | 0;
   i80 = i87;
   i87 = tempRet0;
   i92 = _i64Add(i68, i76, tempRet1 & 1, 0) | 0;
   i76 = _i64Add(i92, tempRet0, i84, 0) | 0;
   i84 = tempRet0;
   if (i105) {
    i92 = _i64Subtract(0, 0, i80, i87) | 0;
    i68 = tempRet0;
    i75 = _i64Add((i80 | 0) == 0 & (i87 | 0) == 0 & 1, 0, ~i76, ~i84) | 0;
    i108 = i68;
    i109 = i92;
    i110 = tempRet0;
    i111 = i75;
   } else {
    i108 = i87;
    i109 = i80;
    i110 = i84;
    i111 = i76;
   }
   i76 = _i64Subtract(0, 0, i109, i108) | 0;
   i84 = _llvm_uadd_with_overflow_i64(i102 | 0, i101 | 0, i76 | 0, tempRet0 | 0) | 0;
   i76 = i84;
   i84 = tempRet0;
   i80 = tempRet1 & 1;
   i87 = _i64Add(i104, i103, ~i111, ~i110) | 0;
   i75 = _i64Add(i87, tempRet0, (i109 | 0) == 0 & (i108 | 0) == 0 & 1, 0) | 0;
   i87 = _i64Add(i75, tempRet0, i80, 0) | 0;
   i80 = tempRet0;
   i75 = __ZN20btConvexHullInternal4PoolINS_6VertexEE9newObjectEv(i12) | 0;
   HEAP32[i75 + 100 >> 2] = -1;
   HEAP32[i75 + 104 >> 2] = -1;
   i92 = HEAP32[i26 >> 2] | 0;
   i68 = i92;
   i71 = (i92 | 0) < 0 ? -1 : 0;
   i92 = ___muldi3(i68, i71, i73, i67) | 0;
   i93 = tempRet0;
   i82 = 0;
   i85 = (i93 | 0) < (i82 | 0) | (i93 | 0) == (i82 | 0) & i92 >>> 0 < 0 >>> 0;
   i82 = _i64Subtract(0, 0, i92, i93) | 0;
   i95 = i85 ? tempRet0 : i93;
   if (i69) {
    i93 = _i64Subtract(0, 0, i96, i77) | 0;
    i112 = i85 ^ 1;
    i113 = tempRet0;
    i114 = i93;
   } else {
    i112 = i85;
    i113 = i77;
    i114 = i96;
   }
   i93 = (i85 ? i82 : i92) | 0;
   i92 = i95 & 0;
   i82 = i114 | 0;
   i85 = i113 & 0;
   i115 = ___muldi3(i82, i85, i93, i92) | 0;
   i116 = tempRet0;
   i117 = i113;
   i118 = 0;
   i119 = ___muldi3(i117, i118, i93, i92) | 0;
   i92 = tempRet0;
   i93 = i95;
   i95 = 0;
   i120 = ___muldi3(i82, i85, i93, i95) | 0;
   i85 = tempRet0;
   i82 = ___muldi3(i117, i118, i93, i95) | 0;
   i95 = tempRet0;
   i93 = _i64Add(i119 | 0, i92 & 0, i120 | 0, i85 & 0) | 0;
   i120 = tempRet0;
   i119 = _i64Add(i92, 0, i82, i95) | 0;
   i95 = _i64Add(i119, tempRet0, i85, 0) | 0;
   i85 = tempRet0;
   i119 = _llvm_uadd_with_overflow_i64(i115 | 0, i116 | 0, 0, i93 | 0) | 0;
   i93 = i119;
   i119 = tempRet0;
   i116 = _i64Add(i95, i85, tempRet1 & 1, 0) | 0;
   i85 = _i64Add(i116, tempRet0, i120, 0) | 0;
   i120 = tempRet0;
   if (i112) {
    i116 = _i64Subtract(0, 0, i93, i119) | 0;
    i95 = tempRet0;
    i115 = _i64Add((i93 | 0) == 0 & (i119 | 0) == 0 & 1, 0, ~i85, ~i120) | 0;
    i121 = i95;
    i122 = i116;
    i123 = tempRet0;
    i124 = i115;
   } else {
    i121 = i119;
    i122 = i93;
    i123 = i120;
    i124 = i85;
   }
   i85 = ___muldi3(i68, i71, i79, i72) | 0;
   i71 = tempRet0;
   i68 = 0;
   i120 = (i71 | 0) < (i68 | 0) | (i71 | 0) == (i68 | 0) & i85 >>> 0 < 0 >>> 0;
   i68 = _i64Subtract(0, 0, i85, i71) | 0;
   i93 = i120 ? tempRet0 : i71;
   i71 = (i120 ? i68 : i85) | 0;
   i85 = i93 & 0;
   i68 = ___muldi3(i71, i85, i83, i97) | 0;
   i119 = tempRet0;
   i115 = ___muldi3(i71, i85, i86, i74) | 0;
   i85 = tempRet0;
   i71 = i93;
   i93 = 0;
   i116 = ___muldi3(i71, i93, i83, i97) | 0;
   i95 = tempRet0;
   i82 = ___muldi3(i71, i93, i86, i74) | 0;
   i93 = tempRet0;
   i71 = _i64Add(i115 | 0, i85 & 0, i116 | 0, i95 & 0) | 0;
   i116 = tempRet0;
   i115 = _llvm_uadd_with_overflow_i64(i68 | 0, i119 | 0, 0, i71 | 0) | 0;
   i71 = i115;
   i115 = tempRet0;
   i119 = tempRet1 & 1;
   i68 = _i64Add(i85, 0, i82, i93) | 0;
   i93 = _i64Add(i68, tempRet0, i95, 0) | 0;
   i95 = _i64Add(i93, tempRet0, i116, 0) | 0;
   i116 = _i64Add(i95, tempRet0, i119, 0) | 0;
   i119 = tempRet0;
   if (i120 ^ i90) {
    i120 = _i64Subtract(0, 0, i71, i115) | 0;
    i95 = tempRet0;
    i93 = _i64Add((i71 | 0) == 0 & (i115 | 0) == 0 & 1, 0, ~i116, ~i119) | 0;
    i125 = i95;
    i126 = i120;
    i127 = tempRet0;
    i128 = i93;
   } else {
    i125 = i115;
    i126 = i71;
    i127 = i119;
    i128 = i116;
   }
   i116 = _i64Subtract(0, 0, i126, i125) | 0;
   i119 = _llvm_uadd_with_overflow_i64(i122 | 0, i121 | 0, i116 | 0, tempRet0 | 0) | 0;
   i116 = tempRet0;
   i71 = tempRet1 & 1;
   i115 = HEAP32[i29 >> 2] | 0;
   i93 = i115;
   i120 = (i115 | 0) < 0 ? -1 : 0;
   i115 = ___muldi3(i93, i120, i79, i72) | 0;
   i95 = tempRet0;
   i68 = 0;
   i82 = (i95 | 0) < (i68 | 0) | (i95 | 0) == (i68 | 0) & i115 >>> 0 < 0 >>> 0;
   i68 = _i64Subtract(0, 0, i115, i95) | 0;
   i85 = i82 ? tempRet0 : i95;
   i95 = (i82 ? i68 : i115) | 0;
   i115 = i85 & 0;
   i68 = ___muldi3(i95, i115, i78, i89) | 0;
   i92 = tempRet0;
   i118 = ___muldi3(i95, i115, i94, i62) | 0;
   i115 = tempRet0;
   i95 = i85;
   i85 = 0;
   i117 = ___muldi3(i95, i85, i78, i89) | 0;
   i129 = tempRet0;
   i130 = ___muldi3(i95, i85, i94, i62) | 0;
   i85 = tempRet0;
   i95 = _i64Add(i118 | 0, i115 & 0, i117 | 0, i129 & 0) | 0;
   i117 = tempRet0;
   i118 = _llvm_uadd_with_overflow_i64(i68 | 0, i92 | 0, 0, i95 | 0) | 0;
   i95 = i118;
   i118 = tempRet0;
   i92 = _i64Add(i130, i85, tempRet1 & 1, 0) | 0;
   i85 = _i64Add(i92, tempRet0, i115, 0) | 0;
   i115 = _i64Add(i85, tempRet0, i129, 0) | 0;
   i129 = _i64Add(i115, tempRet0, i117, 0) | 0;
   i117 = tempRet0;
   if (i82 ^ i81) {
    i82 = _i64Subtract(0, 0, i95, i118) | 0;
    i115 = tempRet0;
    i85 = _i64Add((i95 | 0) == 0 & (i118 | 0) == 0 & 1, 0, ~i129, ~i117) | 0;
    i131 = i115;
    i132 = i82;
    i133 = tempRet0;
    i134 = i85;
   } else {
    i131 = i118;
    i132 = i95;
    i133 = i117;
    i134 = i129;
   }
   i129 = _llvm_uadd_with_overflow_i64(i119 | 0, i116 | 0, i132 | 0, i131 | 0) | 0;
   i116 = tempRet0;
   i119 = tempRet1 & 1;
   i117 = ___muldi3(i93, i120, i73, i67) | 0;
   i120 = tempRet0;
   i93 = 0;
   i95 = (i120 | 0) < (i93 | 0) | (i120 | 0) == (i93 | 0) & i117 >>> 0 < 0 >>> 0;
   i93 = _i64Subtract(0, 0, i117, i120) | 0;
   i118 = i95 ? tempRet0 : i120;
   if (i70) {
    i120 = _i64Subtract(0, 0, i88, i91) | 0;
    i135 = i95 ^ 1;
    i136 = tempRet0;
    i137 = i120;
   } else {
    i135 = i95;
    i136 = i91;
    i137 = i88;
   }
   i120 = (i95 ? i93 : i117) | 0;
   i117 = i118 & 0;
   i93 = i137 | 0;
   i95 = i136 & 0;
   i85 = ___muldi3(i93, i95, i120, i117) | 0;
   i82 = tempRet0;
   i115 = i136;
   i92 = 0;
   i130 = ___muldi3(i115, i92, i120, i117) | 0;
   i117 = tempRet0;
   i120 = i118;
   i118 = 0;
   i68 = ___muldi3(i93, i95, i120, i118) | 0;
   i95 = tempRet0;
   i93 = ___muldi3(i115, i92, i120, i118) | 0;
   i118 = tempRet0;
   i120 = _i64Add(i130 | 0, i117 & 0, i68 | 0, i95 & 0) | 0;
   i68 = tempRet0;
   i130 = _i64Add(i117, 0, i93, i118) | 0;
   i118 = _i64Add(i130, tempRet0, i95, 0) | 0;
   i95 = tempRet0;
   i130 = _llvm_uadd_with_overflow_i64(i85 | 0, i82 | 0, 0, i120 | 0) | 0;
   i120 = i130;
   i130 = tempRet0;
   i82 = _i64Add(i118, i95, tempRet1 & 1, 0) | 0;
   i95 = _i64Add(i82, tempRet0, i68, 0) | 0;
   i68 = tempRet0;
   if (i135) {
    i82 = _i64Subtract(0, 0, i120, i130) | 0;
    i118 = tempRet0;
    i85 = _i64Add((i120 | 0) == 0 & (i130 | 0) == 0 & 1, 0, ~i95, ~i68) | 0;
    i138 = i118;
    i139 = i82;
    i140 = tempRet0;
    i141 = i85;
   } else {
    i138 = i130;
    i139 = i120;
    i140 = i68;
    i141 = i95;
   }
   i95 = _i64Subtract(0, 0, i139, i138) | 0;
   i68 = _llvm_uadd_with_overflow_i64(i129 | 0, i116 | 0, i95 | 0, tempRet0 | 0) | 0;
   i95 = tempRet0;
   i116 = tempRet1 & 1;
   i129 = 0;
   i120 = (i80 | 0) < (i129 | 0) | (i80 | 0) == (i129 | 0) & i87 >>> 0 < 0 >>> 0;
   if (i120) {
    i129 = _i64Subtract(0, 0, i76, i84) | 0;
    i130 = tempRet0;
    i85 = _i64Add((i76 | 0) == 0 & (i84 | 0) == 0 & 1, 0, ~i87, ~i80) | 0;
    i142 = i130;
    i143 = i129;
    i144 = tempRet0;
    i145 = i85;
   } else {
    i142 = i84;
    i143 = i76;
    i144 = i80;
    i145 = i87;
   }
   i85 = i45 ? i47 : i7;
   i129 = i45 ? i46 : i38;
   i130 = i143 | 0;
   i82 = i142 & 0;
   i118 = i85 | 0;
   i93 = i129 & 0;
   i117 = ___muldi3(i118, i93, i130, i82) | 0;
   i92 = tempRet0;
   i115 = i129;
   i146 = 0;
   i147 = ___muldi3(i115, i146, i130, i82) | 0;
   i82 = tempRet0;
   i130 = i142;
   i148 = 0;
   i149 = ___muldi3(i118, i93, i130, i148) | 0;
   i93 = tempRet0;
   i118 = ___muldi3(i115, i146, i130, i148) | 0;
   i148 = tempRet0;
   i130 = _i64Add(i147 | 0, i82 & 0, i149 | 0, i93 & 0) | 0;
   i149 = tempRet0;
   i147 = _llvm_uadd_with_overflow_i64(i117 | 0, i92 | 0, 0, i130 | 0) | 0;
   i130 = i147;
   i147 = tempRet0;
   i92 = tempRet1 & 1;
   i117 = ___muldi3(i85, i129, i145, i144) | 0;
   i129 = _i64Add(i118, i148, i117, tempRet0) | 0;
   i117 = _i64Add(i129, tempRet0, i82, 0) | 0;
   i82 = _i64Add(i117, tempRet0, i93, 0) | 0;
   i93 = _i64Add(i82, tempRet0, i92, 0) | 0;
   i92 = _i64Add(i93, tempRet0, i149, 0) | 0;
   i149 = tempRet0;
   if (i120 ^ i45) {
    i93 = _i64Subtract(0, 0, i130, i147) | 0;
    i82 = tempRet0;
    i117 = _i64Add((i130 | 0) == 0 & (i147 | 0) == 0 & 1, 0, ~i92, ~i149) | 0;
    i150 = i82;
    i151 = i93;
    i152 = tempRet0;
    i153 = i117;
   } else {
    i150 = i147;
    i151 = i130;
    i152 = i149;
    i153 = i92;
   }
   i92 = _llvm_uadd_with_overflow_i64(i68 | 0, i95 | 0, i151 | 0, i150 | 0) | 0;
   i95 = tempRet0;
   i68 = tempRet1 & 1;
   i149 = _i64Add(i124, i123, ~i128, ~i127) | 0;
   i130 = _i64Add(i149, tempRet0, (i126 | 0) == 0 & (i125 | 0) == 0 & 1, 0) | 0;
   i149 = _i64Add(i130, tempRet0, i71, 0) | 0;
   i71 = _i64Add(i149, tempRet0, i134, i133) | 0;
   i149 = _i64Add(i71, tempRet0, i119, 0) | 0;
   i119 = _i64Add(i149, tempRet0, ~i141, ~i140) | 0;
   i149 = _i64Add(i119, tempRet0, (i139 | 0) == 0 & (i138 | 0) == 0 & 1, 0) | 0;
   i119 = _i64Add(i149, tempRet0, i116, 0) | 0;
   i116 = _i64Add(i119, tempRet0, i153, i152) | 0;
   i119 = _i64Add(i116, tempRet0, i68, 0) | 0;
   i68 = tempRet0;
   i116 = HEAP32[i6 >> 2] | 0;
   i149 = i116;
   i71 = (i116 | 0) < 0 ? -1 : 0;
   i116 = ___muldi3(i149, i71, i73, i67) | 0;
   i130 = tempRet0;
   i147 = 0;
   i117 = (i130 | 0) < (i147 | 0) | (i130 | 0) == (i147 | 0) & i116 >>> 0 < 0 >>> 0;
   i147 = _i64Subtract(0, 0, i116, i130) | 0;
   i93 = i117 ? tempRet0 : i130;
   if (i69) {
    i130 = _i64Subtract(0, 0, i96, i77) | 0;
    i154 = i117 ^ 1;
    i155 = tempRet0;
    i156 = i130;
   } else {
    i154 = i117;
    i155 = i77;
    i156 = i96;
   }
   i130 = (i117 ? i147 : i116) | 0;
   i116 = i93 & 0;
   i147 = i156 | 0;
   i117 = i155 & 0;
   i82 = ___muldi3(i147, i117, i130, i116) | 0;
   i129 = tempRet0;
   i148 = i155;
   i118 = 0;
   i85 = ___muldi3(i148, i118, i130, i116) | 0;
   i116 = tempRet0;
   i130 = i93;
   i93 = 0;
   i146 = ___muldi3(i147, i117, i130, i93) | 0;
   i117 = tempRet0;
   i147 = ___muldi3(i148, i118, i130, i93) | 0;
   i93 = tempRet0;
   i130 = _i64Add(i85 | 0, i116 & 0, i146 | 0, i117 & 0) | 0;
   i146 = tempRet0;
   i85 = _i64Add(i116, 0, i147, i93) | 0;
   i93 = _i64Add(i85, tempRet0, i117, 0) | 0;
   i117 = tempRet0;
   i85 = _llvm_uadd_with_overflow_i64(i82 | 0, i129 | 0, 0, i130 | 0) | 0;
   i130 = i85;
   i85 = tempRet0;
   i129 = _i64Add(i93, i117, tempRet1 & 1, 0) | 0;
   i117 = _i64Add(i129, tempRet0, i146, 0) | 0;
   i146 = tempRet0;
   if (i154) {
    i129 = _i64Subtract(0, 0, i130, i85) | 0;
    i93 = tempRet0;
    i82 = _i64Add((i130 | 0) == 0 & (i85 | 0) == 0 & 1, 0, ~i117, ~i146) | 0;
    i157 = i93;
    i158 = i129;
    i159 = tempRet0;
    i160 = i82;
   } else {
    i157 = i85;
    i158 = i130;
    i159 = i146;
    i160 = i117;
   }
   i117 = ___muldi3(i149, i71, i79, i72) | 0;
   i71 = tempRet0;
   i149 = 0;
   i146 = (i71 | 0) < (i149 | 0) | (i71 | 0) == (i149 | 0) & i117 >>> 0 < 0 >>> 0;
   i149 = _i64Subtract(0, 0, i117, i71) | 0;
   i130 = i146 ? tempRet0 : i71;
   i71 = (i146 ? i149 : i117) | 0;
   i117 = i130 & 0;
   i149 = ___muldi3(i71, i117, i83, i97) | 0;
   i85 = tempRet0;
   i82 = ___muldi3(i71, i117, i86, i74) | 0;
   i117 = tempRet0;
   i71 = i130;
   i130 = 0;
   i129 = ___muldi3(i71, i130, i83, i97) | 0;
   i93 = tempRet0;
   i147 = ___muldi3(i71, i130, i86, i74) | 0;
   i130 = tempRet0;
   i71 = _i64Add(i82 | 0, i117 & 0, i129 | 0, i93 & 0) | 0;
   i129 = tempRet0;
   i82 = _llvm_uadd_with_overflow_i64(i149 | 0, i85 | 0, 0, i71 | 0) | 0;
   i71 = i82;
   i82 = tempRet0;
   i85 = tempRet1 & 1;
   i149 = _i64Add(i117, 0, i147, i130) | 0;
   i130 = _i64Add(i149, tempRet0, i93, 0) | 0;
   i93 = _i64Add(i130, tempRet0, i129, 0) | 0;
   i129 = _i64Add(i93, tempRet0, i85, 0) | 0;
   i85 = tempRet0;
   if (i146 ^ i90) {
    i146 = _i64Subtract(0, 0, i71, i82) | 0;
    i93 = tempRet0;
    i130 = _i64Add((i71 | 0) == 0 & (i82 | 0) == 0 & 1, 0, ~i129, ~i85) | 0;
    i161 = i93;
    i162 = i146;
    i163 = tempRet0;
    i164 = i130;
   } else {
    i161 = i82;
    i162 = i71;
    i163 = i85;
    i164 = i129;
   }
   i129 = _i64Subtract(0, 0, i162, i161) | 0;
   i85 = _llvm_uadd_with_overflow_i64(i158 | 0, i157 | 0, i129 | 0, tempRet0 | 0) | 0;
   i129 = tempRet0;
   i71 = tempRet1 & 1;
   i82 = HEAP32[i27 >> 2] | 0;
   i130 = i82;
   i146 = (i82 | 0) < 0 ? -1 : 0;
   i82 = ___muldi3(i130, i146, i79, i72) | 0;
   i93 = tempRet0;
   i149 = 0;
   i147 = (i93 | 0) < (i149 | 0) | (i93 | 0) == (i149 | 0) & i82 >>> 0 < 0 >>> 0;
   i149 = _i64Subtract(0, 0, i82, i93) | 0;
   i117 = i147 ? tempRet0 : i93;
   i93 = (i147 ? i149 : i82) | 0;
   i82 = i117 & 0;
   i149 = ___muldi3(i93, i82, i78, i89) | 0;
   i116 = tempRet0;
   i118 = ___muldi3(i93, i82, i94, i62) | 0;
   i82 = tempRet0;
   i93 = i117;
   i117 = 0;
   i148 = ___muldi3(i93, i117, i78, i89) | 0;
   i115 = tempRet0;
   i165 = ___muldi3(i93, i117, i94, i62) | 0;
   i117 = tempRet0;
   i93 = _i64Add(i118 | 0, i82 & 0, i148 | 0, i115 & 0) | 0;
   i148 = tempRet0;
   i118 = _llvm_uadd_with_overflow_i64(i149 | 0, i116 | 0, 0, i93 | 0) | 0;
   i93 = i118;
   i118 = tempRet0;
   i116 = _i64Add(i165, i117, tempRet1 & 1, 0) | 0;
   i117 = _i64Add(i116, tempRet0, i82, 0) | 0;
   i82 = _i64Add(i117, tempRet0, i115, 0) | 0;
   i115 = _i64Add(i82, tempRet0, i148, 0) | 0;
   i148 = tempRet0;
   if (i147 ^ i81) {
    i147 = _i64Subtract(0, 0, i93, i118) | 0;
    i82 = tempRet0;
    i117 = _i64Add((i93 | 0) == 0 & (i118 | 0) == 0 & 1, 0, ~i115, ~i148) | 0;
    i166 = i82;
    i167 = i147;
    i168 = tempRet0;
    i169 = i117;
   } else {
    i166 = i118;
    i167 = i93;
    i168 = i148;
    i169 = i115;
   }
   i115 = _llvm_uadd_with_overflow_i64(i85 | 0, i129 | 0, i167 | 0, i166 | 0) | 0;
   i129 = tempRet0;
   i85 = tempRet1 & 1;
   i148 = ___muldi3(i130, i146, i73, i67) | 0;
   i146 = tempRet0;
   i130 = 0;
   i93 = (i146 | 0) < (i130 | 0) | (i146 | 0) == (i130 | 0) & i148 >>> 0 < 0 >>> 0;
   i130 = _i64Subtract(0, 0, i148, i146) | 0;
   i118 = i93 ? tempRet0 : i146;
   if (i70) {
    i146 = _i64Subtract(0, 0, i88, i91) | 0;
    i170 = i93 ^ 1;
    i171 = tempRet0;
    i172 = i146;
   } else {
    i170 = i93;
    i171 = i91;
    i172 = i88;
   }
   i146 = (i93 ? i130 : i148) | 0;
   i148 = i118 & 0;
   i130 = i172 | 0;
   i93 = i171 & 0;
   i117 = ___muldi3(i130, i93, i146, i148) | 0;
   i147 = tempRet0;
   i82 = i171;
   i116 = 0;
   i165 = ___muldi3(i82, i116, i146, i148) | 0;
   i148 = tempRet0;
   i146 = i118;
   i118 = 0;
   i149 = ___muldi3(i130, i93, i146, i118) | 0;
   i93 = tempRet0;
   i130 = ___muldi3(i82, i116, i146, i118) | 0;
   i118 = tempRet0;
   i146 = _i64Add(i165 | 0, i148 & 0, i149 | 0, i93 & 0) | 0;
   i149 = tempRet0;
   i165 = _i64Add(i148, 0, i130, i118) | 0;
   i118 = _i64Add(i165, tempRet0, i93, 0) | 0;
   i93 = tempRet0;
   i165 = _llvm_uadd_with_overflow_i64(i117 | 0, i147 | 0, 0, i146 | 0) | 0;
   i146 = i165;
   i165 = tempRet0;
   i147 = _i64Add(i118, i93, tempRet1 & 1, 0) | 0;
   i93 = _i64Add(i147, tempRet0, i149, 0) | 0;
   i149 = tempRet0;
   if (i170) {
    i147 = _i64Subtract(0, 0, i146, i165) | 0;
    i118 = tempRet0;
    i117 = _i64Add((i146 | 0) == 0 & (i165 | 0) == 0 & 1, 0, ~i93, ~i149) | 0;
    i173 = i118;
    i174 = i147;
    i175 = tempRet0;
    i176 = i117;
   } else {
    i173 = i165;
    i174 = i146;
    i175 = i149;
    i176 = i93;
   }
   i93 = _i64Subtract(0, 0, i174, i173) | 0;
   i149 = _llvm_uadd_with_overflow_i64(i115 | 0, i129 | 0, i93 | 0, tempRet0 | 0) | 0;
   i93 = tempRet0;
   i129 = tempRet1 & 1;
   if (i120) {
    i115 = _i64Subtract(0, 0, i76, i84) | 0;
    i146 = tempRet0;
    i165 = _i64Add((i76 | 0) == 0 & (i84 | 0) == 0 & 1, 0, ~i87, ~i80) | 0;
    i177 = i146;
    i178 = i115;
    i179 = tempRet0;
    i180 = i165;
   } else {
    i177 = i84;
    i178 = i76;
    i179 = i80;
    i180 = i87;
   }
   i165 = i48 ? i10 : i24;
   i115 = i48 ? i41 : i34;
   i146 = i178 | 0;
   i117 = i177 & 0;
   i147 = i165 | 0;
   i118 = i115 & 0;
   i130 = ___muldi3(i147, i118, i146, i117) | 0;
   i148 = tempRet0;
   i116 = i115;
   i82 = 0;
   i181 = ___muldi3(i116, i82, i146, i117) | 0;
   i117 = tempRet0;
   i146 = i177;
   i182 = 0;
   i183 = ___muldi3(i147, i118, i146, i182) | 0;
   i118 = tempRet0;
   i147 = ___muldi3(i116, i82, i146, i182) | 0;
   i182 = tempRet0;
   i146 = _i64Add(i181 | 0, i117 & 0, i183 | 0, i118 & 0) | 0;
   i183 = tempRet0;
   i181 = _llvm_uadd_with_overflow_i64(i130 | 0, i148 | 0, 0, i146 | 0) | 0;
   i146 = i181;
   i181 = tempRet0;
   i148 = tempRet1 & 1;
   i130 = ___muldi3(i165, i115, i180, i179) | 0;
   i115 = _i64Add(i147, i182, i130, tempRet0) | 0;
   i130 = _i64Add(i115, tempRet0, i117, 0) | 0;
   i117 = _i64Add(i130, tempRet0, i118, 0) | 0;
   i118 = _i64Add(i117, tempRet0, i148, 0) | 0;
   i148 = _i64Add(i118, tempRet0, i183, 0) | 0;
   i183 = tempRet0;
   if (i120 ^ i48) {
    i118 = _i64Subtract(0, 0, i146, i181) | 0;
    i117 = tempRet0;
    i130 = _i64Add((i146 | 0) == 0 & (i181 | 0) == 0 & 1, 0, ~i148, ~i183) | 0;
    i184 = i117;
    i185 = i118;
    i186 = tempRet0;
    i187 = i130;
   } else {
    i184 = i181;
    i185 = i146;
    i186 = i183;
    i187 = i148;
   }
   i148 = _llvm_uadd_with_overflow_i64(i149 | 0, i93 | 0, i185 | 0, i184 | 0) | 0;
   i93 = tempRet0;
   i149 = tempRet1 & 1;
   i183 = _i64Add(i160, i159, ~i164, ~i163) | 0;
   i146 = _i64Add(i183, tempRet0, (i162 | 0) == 0 & (i161 | 0) == 0 & 1, 0) | 0;
   i183 = _i64Add(i146, tempRet0, i71, 0) | 0;
   i71 = _i64Add(i183, tempRet0, i169, i168) | 0;
   i183 = _i64Add(i71, tempRet0, i85, 0) | 0;
   i85 = _i64Add(i183, tempRet0, ~i176, ~i175) | 0;
   i183 = _i64Add(i85, tempRet0, (i174 | 0) == 0 & (i173 | 0) == 0 & 1, 0) | 0;
   i85 = _i64Add(i183, tempRet0, i129, 0) | 0;
   i129 = _i64Add(i85, tempRet0, i187, i186) | 0;
   i85 = _i64Add(i129, tempRet0, i149, 0) | 0;
   i149 = tempRet0;
   i129 = HEAP32[i25 >> 2] | 0;
   i183 = i129;
   i71 = (i129 | 0) < 0 ? -1 : 0;
   i129 = ___muldi3(i183, i71, i73, i67) | 0;
   i146 = tempRet0;
   i181 = 0;
   i130 = (i146 | 0) < (i181 | 0) | (i146 | 0) == (i181 | 0) & i129 >>> 0 < 0 >>> 0;
   i181 = _i64Subtract(0, 0, i129, i146) | 0;
   i118 = i130 ? tempRet0 : i146;
   if (i69) {
    i69 = _i64Subtract(0, 0, i96, i77) | 0;
    i188 = i130 ^ 1;
    i189 = tempRet0;
    i190 = i69;
   } else {
    i188 = i130;
    i189 = i77;
    i190 = i96;
   }
   i96 = (i130 ? i181 : i129) | 0;
   i129 = i118 & 0;
   i181 = i190 | 0;
   i130 = i189 & 0;
   i77 = ___muldi3(i181, i130, i96, i129) | 0;
   i69 = tempRet0;
   i146 = i189;
   i117 = 0;
   i115 = ___muldi3(i146, i117, i96, i129) | 0;
   i129 = tempRet0;
   i96 = i118;
   i118 = 0;
   i182 = ___muldi3(i181, i130, i96, i118) | 0;
   i130 = tempRet0;
   i181 = ___muldi3(i146, i117, i96, i118) | 0;
   i118 = tempRet0;
   i96 = _i64Add(i115 | 0, i129 & 0, i182 | 0, i130 & 0) | 0;
   i182 = tempRet0;
   i115 = _i64Add(i129, 0, i181, i118) | 0;
   i118 = _i64Add(i115, tempRet0, i130, 0) | 0;
   i130 = tempRet0;
   i115 = _llvm_uadd_with_overflow_i64(i77 | 0, i69 | 0, 0, i96 | 0) | 0;
   i96 = i115;
   i115 = tempRet0;
   i69 = _i64Add(i118, i130, tempRet1 & 1, 0) | 0;
   i130 = _i64Add(i69, tempRet0, i182, 0) | 0;
   i182 = tempRet0;
   if (i188) {
    i69 = _i64Subtract(0, 0, i96, i115) | 0;
    i118 = tempRet0;
    i77 = _i64Add((i96 | 0) == 0 & (i115 | 0) == 0 & 1, 0, ~i130, ~i182) | 0;
    i191 = i118;
    i192 = i69;
    i193 = tempRet0;
    i194 = i77;
   } else {
    i191 = i115;
    i192 = i96;
    i193 = i182;
    i194 = i130;
   }
   i130 = ___muldi3(i183, i71, i79, i72) | 0;
   i71 = tempRet0;
   i183 = 0;
   i182 = (i71 | 0) < (i183 | 0) | (i71 | 0) == (i183 | 0) & i130 >>> 0 < 0 >>> 0;
   i183 = _i64Subtract(0, 0, i130, i71) | 0;
   i96 = i182 ? tempRet0 : i71;
   i71 = (i182 ? i183 : i130) | 0;
   i130 = i96 & 0;
   i183 = ___muldi3(i71, i130, i83, i97) | 0;
   i115 = tempRet0;
   i77 = ___muldi3(i71, i130, i86, i74) | 0;
   i130 = tempRet0;
   i71 = i96;
   i96 = 0;
   i69 = ___muldi3(i71, i96, i83, i97) | 0;
   i97 = tempRet0;
   i83 = ___muldi3(i71, i96, i86, i74) | 0;
   i74 = tempRet0;
   i86 = _i64Add(i77 | 0, i130 & 0, i69 | 0, i97 & 0) | 0;
   i69 = tempRet0;
   i77 = _llvm_uadd_with_overflow_i64(i183 | 0, i115 | 0, 0, i86 | 0) | 0;
   i86 = i77;
   i77 = tempRet0;
   i115 = tempRet1 & 1;
   i183 = _i64Add(i130, 0, i83, i74) | 0;
   i74 = _i64Add(i183, tempRet0, i97, 0) | 0;
   i97 = _i64Add(i74, tempRet0, i69, 0) | 0;
   i69 = _i64Add(i97, tempRet0, i115, 0) | 0;
   i115 = tempRet0;
   if (i182 ^ i90) {
    i90 = _i64Subtract(0, 0, i86, i77) | 0;
    i182 = tempRet0;
    i97 = _i64Add((i86 | 0) == 0 & (i77 | 0) == 0 & 1, 0, ~i69, ~i115) | 0;
    i195 = i182;
    i196 = i90;
    i197 = tempRet0;
    i198 = i97;
   } else {
    i195 = i77;
    i196 = i86;
    i197 = i115;
    i198 = i69;
   }
   i69 = _i64Subtract(0, 0, i196, i195) | 0;
   i115 = _llvm_uadd_with_overflow_i64(i192 | 0, i191 | 0, i69 | 0, tempRet0 | 0) | 0;
   i69 = tempRet0;
   i86 = tempRet1 & 1;
   i77 = HEAP32[i22 >> 2] | 0;
   i97 = i77;
   i90 = (i77 | 0) < 0 ? -1 : 0;
   i77 = ___muldi3(i97, i90, i79, i72) | 0;
   i72 = tempRet0;
   i79 = 0;
   i182 = (i72 | 0) < (i79 | 0) | (i72 | 0) == (i79 | 0) & i77 >>> 0 < 0 >>> 0;
   i79 = _i64Subtract(0, 0, i77, i72) | 0;
   i74 = i182 ? tempRet0 : i72;
   i72 = (i182 ? i79 : i77) | 0;
   i77 = i74 & 0;
   i79 = ___muldi3(i72, i77, i78, i89) | 0;
   i183 = tempRet0;
   i83 = ___muldi3(i72, i77, i94, i62) | 0;
   i77 = tempRet0;
   i72 = i74;
   i74 = 0;
   i130 = ___muldi3(i72, i74, i78, i89) | 0;
   i89 = tempRet0;
   i78 = ___muldi3(i72, i74, i94, i62) | 0;
   i62 = tempRet0;
   i94 = _i64Add(i83 | 0, i77 & 0, i130 | 0, i89 & 0) | 0;
   i130 = tempRet0;
   i83 = _llvm_uadd_with_overflow_i64(i79 | 0, i183 | 0, 0, i94 | 0) | 0;
   i94 = i83;
   i83 = tempRet0;
   i183 = _i64Add(i78, i62, tempRet1 & 1, 0) | 0;
   i62 = _i64Add(i183, tempRet0, i77, 0) | 0;
   i77 = _i64Add(i62, tempRet0, i89, 0) | 0;
   i89 = _i64Add(i77, tempRet0, i130, 0) | 0;
   i130 = tempRet0;
   if (i182 ^ i81) {
    i81 = _i64Subtract(0, 0, i94, i83) | 0;
    i182 = tempRet0;
    i77 = _i64Add((i94 | 0) == 0 & (i83 | 0) == 0 & 1, 0, ~i89, ~i130) | 0;
    i199 = i182;
    i200 = i81;
    i201 = tempRet0;
    i202 = i77;
   } else {
    i199 = i83;
    i200 = i94;
    i201 = i130;
    i202 = i89;
   }
   i89 = _llvm_uadd_with_overflow_i64(i115 | 0, i69 | 0, i200 | 0, i199 | 0) | 0;
   i69 = tempRet0;
   i115 = tempRet1 & 1;
   i130 = ___muldi3(i97, i90, i73, i67) | 0;
   i67 = tempRet0;
   i73 = 0;
   i90 = (i67 | 0) < (i73 | 0) | (i67 | 0) == (i73 | 0) & i130 >>> 0 < 0 >>> 0;
   i73 = _i64Subtract(0, 0, i130, i67) | 0;
   i97 = i90 ? tempRet0 : i67;
   if (i70) {
    i70 = _i64Subtract(0, 0, i88, i91) | 0;
    i203 = i90 ^ 1;
    i204 = tempRet0;
    i205 = i70;
   } else {
    i203 = i90;
    i204 = i91;
    i205 = i88;
   }
   i88 = (i90 ? i73 : i130) | 0;
   i130 = i97 & 0;
   i73 = i205 | 0;
   i90 = i204 & 0;
   i91 = ___muldi3(i73, i90, i88, i130) | 0;
   i70 = tempRet0;
   i67 = i204;
   i94 = 0;
   i83 = ___muldi3(i67, i94, i88, i130) | 0;
   i130 = tempRet0;
   i88 = i97;
   i97 = 0;
   i77 = ___muldi3(i73, i90, i88, i97) | 0;
   i90 = tempRet0;
   i73 = ___muldi3(i67, i94, i88, i97) | 0;
   i97 = tempRet0;
   i88 = _i64Add(i83 | 0, i130 & 0, i77 | 0, i90 & 0) | 0;
   i77 = tempRet0;
   i83 = _i64Add(i130, 0, i73, i97) | 0;
   i97 = _i64Add(i83, tempRet0, i90, 0) | 0;
   i90 = tempRet0;
   i83 = _llvm_uadd_with_overflow_i64(i91 | 0, i70 | 0, 0, i88 | 0) | 0;
   i88 = i83;
   i83 = tempRet0;
   i70 = _i64Add(i97, i90, tempRet1 & 1, 0) | 0;
   i90 = _i64Add(i70, tempRet0, i77, 0) | 0;
   i77 = tempRet0;
   if (i203) {
    i70 = _i64Subtract(0, 0, i88, i83) | 0;
    i97 = tempRet0;
    i91 = _i64Add((i88 | 0) == 0 & (i83 | 0) == 0 & 1, 0, ~i90, ~i77) | 0;
    i206 = i97;
    i207 = i70;
    i208 = tempRet0;
    i209 = i91;
   } else {
    i206 = i83;
    i207 = i88;
    i208 = i77;
    i209 = i90;
   }
   i90 = _i64Subtract(0, 0, i207, i206) | 0;
   i77 = _llvm_uadd_with_overflow_i64(i89 | 0, i69 | 0, i90 | 0, tempRet0 | 0) | 0;
   i90 = tempRet0;
   i69 = tempRet1 & 1;
   if (i120) {
    i89 = _i64Subtract(0, 0, i76, i84) | 0;
    i88 = tempRet0;
    i83 = _i64Add((i76 | 0) == 0 & (i84 | 0) == 0 & 1, 0, ~i87, ~i80) | 0;
    i210 = i88;
    i211 = i89;
    i212 = tempRet0;
    i213 = i83;
   } else {
    i210 = i84;
    i211 = i76;
    i212 = i80;
    i213 = i87;
   }
   i83 = i21 ? i43 : i37;
   i89 = i21 ? i42 : i39;
   i88 = i211 | 0;
   i91 = i210 & 0;
   i70 = i83 | 0;
   i97 = i89 & 0;
   i73 = ___muldi3(i70, i97, i88, i91) | 0;
   i130 = tempRet0;
   i94 = i89;
   i67 = 0;
   i81 = ___muldi3(i94, i67, i88, i91) | 0;
   i91 = tempRet0;
   i88 = i210;
   i182 = 0;
   i62 = ___muldi3(i70, i97, i88, i182) | 0;
   i97 = tempRet0;
   i70 = ___muldi3(i94, i67, i88, i182) | 0;
   i182 = tempRet0;
   i88 = _i64Add(i81 | 0, i91 & 0, i62 | 0, i97 & 0) | 0;
   i62 = tempRet0;
   i81 = _llvm_uadd_with_overflow_i64(i73 | 0, i130 | 0, 0, i88 | 0) | 0;
   i88 = i81;
   i81 = tempRet0;
   i130 = tempRet1 & 1;
   i73 = ___muldi3(i83, i89, i213, i212) | 0;
   i89 = _i64Add(i70, i182, i73, tempRet0) | 0;
   i73 = _i64Add(i89, tempRet0, i91, 0) | 0;
   i91 = _i64Add(i73, tempRet0, i97, 0) | 0;
   i97 = _i64Add(i91, tempRet0, i130, 0) | 0;
   i130 = _i64Add(i97, tempRet0, i62, 0) | 0;
   i62 = tempRet0;
   if (i120 ^ i21) {
    i120 = _i64Subtract(0, 0, i88, i81) | 0;
    i97 = tempRet0;
    i91 = _i64Add((i88 | 0) == 0 & (i81 | 0) == 0 & 1, 0, ~i130, ~i62) | 0;
    i214 = i97;
    i215 = i120;
    i216 = tempRet0;
    i217 = i91;
   } else {
    i214 = i81;
    i215 = i88;
    i216 = i62;
    i217 = i130;
   }
   i130 = _llvm_uadd_with_overflow_i64(i77 | 0, i90 | 0, i215 | 0, i214 | 0) | 0;
   i90 = tempRet0;
   i77 = tempRet1 & 1;
   i62 = _i64Add(i194, i193, ~i198, ~i197) | 0;
   i88 = _i64Add(i62, tempRet0, (i196 | 0) == 0 & (i195 | 0) == 0 & 1, 0) | 0;
   i62 = _i64Add(i88, tempRet0, i86, 0) | 0;
   i86 = _i64Add(i62, tempRet0, i202, i201) | 0;
   i62 = _i64Add(i86, tempRet0, i115, 0) | 0;
   i115 = _i64Add(i62, tempRet0, ~i209, ~i208) | 0;
   i62 = _i64Add(i115, tempRet0, (i207 | 0) == 0 & (i206 | 0) == 0 & 1, 0) | 0;
   i115 = _i64Add(i62, tempRet0, i69, 0) | 0;
   i69 = _i64Add(i115, tempRet0, i217, i216) | 0;
   i115 = _i64Add(i69, tempRet0, i77, 0) | 0;
   i77 = i75 + 24 | 0;
   HEAP32[i77 >> 2] = i92;
   HEAP32[i77 + 4 >> 2] = i95;
   i95 = i75 + 32 | 0;
   HEAP32[i95 >> 2] = i119;
   HEAP32[i95 + 4 >> 2] = i68;
   i68 = i75 + 40 | 0;
   HEAP32[i68 >> 2] = i148;
   HEAP32[i68 + 4 >> 2] = i93;
   i93 = i75 + 48 | 0;
   HEAP32[i93 >> 2] = i85;
   HEAP32[i93 + 4 >> 2] = i149;
   i149 = i75 + 56 | 0;
   HEAP32[i149 >> 2] = i130;
   HEAP32[i149 + 4 >> 2] = i90;
   i90 = i75 + 64 | 0;
   HEAP32[i90 >> 2] = i115;
   HEAP32[i90 + 4 >> 2] = tempRet0;
   i90 = i75 + 72 | 0;
   i115 = i75 + 72 | 0;
   HEAP32[i115 >> 2] = i76;
   HEAP32[i115 + 4 >> 2] = i84;
   i84 = i75 + 80 | 0;
   HEAP32[i84 >> 2] = i87;
   HEAP32[i84 + 4 >> 2] = i80;
   d15 = +__ZNK20btConvexHullInternal6Int1288toScalarEv(i75 + 24 | 0);
   HEAP32[i75 + 88 >> 2] = ~~(d15 / +__ZNK20btConvexHullInternal6Int1288toScalarEv(i90));
   d15 = +__ZNK20btConvexHullInternal6Int1288toScalarEv(i75 + 40 | 0);
   HEAP32[i75 + 92 >> 2] = ~~(d15 / +__ZNK20btConvexHullInternal6Int1288toScalarEv(i90));
   d15 = +__ZNK20btConvexHullInternal6Int1288toScalarEv(i75 + 56 | 0);
   HEAP32[i75 + 96 >> 2] = ~~(d15 / +__ZNK20btConvexHullInternal6Int1288toScalarEv(i90));
   HEAP32[i64 >> 2] = i75;
   HEAP32[i75 + 8 >> 2] = i66;
   i66 = HEAP32[i53 >> 2] | 0;
   i90 = HEAP32[i52 >> 2] | 0;
   do {
    if ((i66 | 0) == (i90 | 0)) {
     i80 = (i66 | 0) == 0 ? 1 : i66 << 1;
     if ((i66 | 0) >= (i80 | 0)) {
      i218 = i66;
      i219 = i66;
      break;
     }
     if ((i80 | 0) == 0) {
      i220 = 0;
      i221 = i66;
     } else {
      i84 = __Z22btAlignedAllocInternalji(i80 << 2, 16) | 0;
      i220 = i84;
      i221 = HEAP32[i53 >> 2] | 0;
     }
     if ((i221 | 0) > 0) {
      i84 = 0;
      do {
       i87 = i220 + (i84 << 2) | 0;
       if ((i87 | 0) != 0) {
        HEAP32[i87 >> 2] = HEAP32[(HEAP32[i32 >> 2] | 0) + (i84 << 2) >> 2];
       }
       i84 = i84 + 1 | 0;
      } while ((i84 | 0) < (i221 | 0));
     }
     i84 = HEAP32[i32 >> 2] | 0;
     if ((i84 | 0) == 0) {
      i222 = i221;
     } else {
      if ((HEAP8[i54] | 0) == 0) {
       i223 = i221;
      } else {
       __Z21btAlignedFreeInternalPv(i84);
       i223 = HEAP32[i53 >> 2] | 0;
      }
      HEAP32[i32 >> 2] = 0;
      i222 = i223;
     }
     HEAP8[i54] = 1;
     HEAP32[i32 >> 2] = i220;
     HEAP32[i52 >> 2] = i80;
     i218 = i222;
     i219 = i80;
    } else {
     i218 = i66;
     i219 = i90;
    }
   } while (0);
   i90 = (HEAP32[i32 >> 2] | 0) + (i218 << 2) | 0;
   if ((i90 | 0) != 0) {
    HEAP32[i90 >> 2] = i75;
   }
   i90 = i218 + 1 | 0;
   HEAP32[i53 >> 2] = i90;
   do {
    if ((i90 | 0) == (i219 | 0)) {
     i66 = (i219 | 0) == 0 ? 1 : i219 << 1;
     if ((i219 | 0) >= (i66 | 0)) {
      i224 = i219;
      i225 = i219;
      break;
     }
     if ((i66 | 0) == 0) {
      i226 = 0;
      i227 = i219;
     } else {
      i84 = __Z22btAlignedAllocInternalji(i66 << 2, 16) | 0;
      i226 = i84;
      i227 = HEAP32[i53 >> 2] | 0;
     }
     if ((i227 | 0) > 0) {
      i84 = 0;
      do {
       i87 = i226 + (i84 << 2) | 0;
       if ((i87 | 0) != 0) {
        HEAP32[i87 >> 2] = HEAP32[(HEAP32[i32 >> 2] | 0) + (i84 << 2) >> 2];
       }
       i84 = i84 + 1 | 0;
      } while ((i84 | 0) < (i227 | 0));
     }
     i84 = HEAP32[i32 >> 2] | 0;
     if ((i84 | 0) == 0) {
      i228 = i227;
     } else {
      if ((HEAP8[i54] | 0) == 0) {
       i229 = i227;
      } else {
       __Z21btAlignedFreeInternalPv(i84);
       i229 = HEAP32[i53 >> 2] | 0;
      }
      HEAP32[i32 >> 2] = 0;
      i228 = i229;
     }
     HEAP8[i54] = 1;
     HEAP32[i32 >> 2] = i226;
     HEAP32[i52 >> 2] = i66;
     i224 = i228;
     i225 = i66;
    } else {
     i224 = i90;
     i225 = i219;
    }
   } while (0);
   i90 = (HEAP32[i32 >> 2] | 0) + (i224 << 2) | 0;
   if ((i90 | 0) != 0) {
    HEAP32[i90 >> 2] = i58;
   }
   i90 = i224 + 1 | 0;
   HEAP32[i53 >> 2] = i90;
   do {
    if ((i90 | 0) == (i225 | 0)) {
     i75 = (i225 | 0) == 0 ? 1 : i225 << 1;
     if ((i225 | 0) >= (i75 | 0)) {
      i230 = i225;
      break;
     }
     if ((i75 | 0) == 0) {
      i231 = 0;
      i232 = i225;
     } else {
      i84 = __Z22btAlignedAllocInternalji(i75 << 2, 16) | 0;
      i231 = i84;
      i232 = HEAP32[i53 >> 2] | 0;
     }
     if ((i232 | 0) > 0) {
      i84 = 0;
      do {
       i80 = i231 + (i84 << 2) | 0;
       if ((i80 | 0) != 0) {
        HEAP32[i80 >> 2] = HEAP32[(HEAP32[i32 >> 2] | 0) + (i84 << 2) >> 2];
       }
       i84 = i84 + 1 | 0;
      } while ((i84 | 0) < (i232 | 0));
     }
     i84 = HEAP32[i32 >> 2] | 0;
     if ((i84 | 0) == 0) {
      i233 = i232;
     } else {
      if ((HEAP8[i54] | 0) == 0) {
       i234 = i232;
      } else {
       __Z21btAlignedFreeInternalPv(i84);
       i234 = HEAP32[i53 >> 2] | 0;
      }
      HEAP32[i32 >> 2] = 0;
      i233 = i234;
     }
     HEAP8[i54] = 1;
     HEAP32[i32 >> 2] = i231;
     HEAP32[i52 >> 2] = i75;
     i230 = i233;
    } else {
     i230 = i90;
    }
   } while (0);
   i90 = (HEAP32[i32 >> 2] | 0) + (i230 << 2) | 0;
   if ((i90 | 0) != 0) {
    HEAP32[i90 >> 2] = 0;
   }
   HEAP32[i53 >> 2] = i230 + 1;
  }
  i90 = (i65 | 0) == 0;
  if ((i65 | i50 | 0) == 0) {
   i58 = HEAP32[HEAP32[i60 >> 2] >> 2] | 0;
   i84 = HEAP32[i64 >> 2] | 0;
   if ((HEAP32[i58 + 12 >> 2] | 0) == (i84 | 0)) {
    i235 = i58;
   } else {
    i236 = i84;
    i49 = 1401;
   }
  } else {
   i236 = HEAP32[i64 >> 2] | 0;
   i49 = 1401;
  }
  if ((i49 | 0) == 1401) {
   i49 = 0;
   i84 = HEAP32[i61 + 12 >> 2] | 0;
   i58 = __ZN20btConvexHullInternal4PoolINS_4EdgeEE9newObjectEv(i11) | 0;
   i66 = __ZN20btConvexHullInternal4PoolINS_4EdgeEE9newObjectEv(i11) | 0;
   i80 = i58 + 8 | 0;
   HEAP32[i80 >> 2] = i66;
   HEAP32[i66 + 8 >> 2] = i58;
   HEAP32[i58 + 20 >> 2] = HEAP32[i9 >> 2];
   HEAP32[i66 + 20 >> 2] = HEAP32[i9 >> 2];
   HEAP32[i58 + 12 >> 2] = i236;
   HEAP32[i66 + 12 >> 2] = i84;
   HEAP32[i58 + 16 >> 2] = 0;
   HEAP32[i66 + 16 >> 2] = 0;
   i66 = (HEAP32[i30 >> 2] | 0) + 1 | 0;
   HEAP32[i30 >> 2] = i66;
   if ((i66 | 0) > (HEAP32[i40 >> 2] | 0)) {
    HEAP32[i40 >> 2] = i66;
   }
   if (i57) {
    i66 = HEAP32[HEAP32[i60 >> 2] >> 2] | 0;
    HEAP32[i58 >> 2] = i66;
    HEAP32[i66 + 4 >> 2] = i58;
    i49 = 1406;
   } else {
    if ((i55 | 0) != 0) {
     i49 = 1406;
    }
   }
   if ((i49 | 0) == 1406) {
    i49 = 0;
    i66 = HEAP32[i60 >> 2] | 0;
    HEAP32[i66 >> 2] = i58;
    HEAP32[i58 + 4 >> 2] = i66;
   }
   i66 = i59 + 8 | 0;
   if (i90) {
    i90 = HEAP32[(HEAP32[i66 >> 2] | 0) + 4 >> 2] | 0;
    i84 = HEAP32[i80 >> 2] | 0;
    HEAP32[i90 >> 2] = i84;
    HEAP32[i84 + 4 >> 2] = i90;
   }
   i90 = HEAP32[i80 >> 2] | 0;
   i80 = HEAP32[i66 >> 2] | 0;
   HEAP32[i90 >> 2] = i80;
   HEAP32[i80 + 4 >> 2] = i90;
   i235 = i58;
  }
  do {
   if ((i55 | 0) != 0) {
    i58 = i55 + 8 | 0;
    i90 = HEAP32[i58 >> 2] | 0;
    if ((i50 | 0) > 0) {
     HEAP32[i235 >> 2] = i90;
     HEAP32[i90 + 4 >> 2] = i235;
     break;
    }
    if ((i235 | 0) == (i90 | 0)) {
     break;
    }
    i90 = i55 + 12 | 0;
    i80 = HEAP32[i53 >> 2] | 0;
    i66 = HEAP32[i52 >> 2] | 0;
    do {
     if ((i80 | 0) == (i66 | 0)) {
      i84 = (i80 | 0) == 0 ? 1 : i80 << 1;
      if ((i80 | 0) >= (i84 | 0)) {
       i237 = i80;
       i238 = i80;
       break;
      }
      if ((i84 | 0) == 0) {
       i239 = 0;
       i240 = i80;
      } else {
       i87 = __Z22btAlignedAllocInternalji(i84 << 2, 16) | 0;
       i239 = i87;
       i240 = HEAP32[i53 >> 2] | 0;
      }
      if ((i240 | 0) > 0) {
       i87 = 0;
       do {
        i115 = i239 + (i87 << 2) | 0;
        if ((i115 | 0) != 0) {
         HEAP32[i115 >> 2] = HEAP32[(HEAP32[i32 >> 2] | 0) + (i87 << 2) >> 2];
        }
        i87 = i87 + 1 | 0;
       } while ((i87 | 0) < (i240 | 0));
      }
      i87 = HEAP32[i32 >> 2] | 0;
      if ((i87 | 0) == 0) {
       i241 = i240;
      } else {
       if ((HEAP8[i54] | 0) == 0) {
        i242 = i240;
       } else {
        __Z21btAlignedFreeInternalPv(i87);
        i242 = HEAP32[i53 >> 2] | 0;
       }
       HEAP32[i32 >> 2] = 0;
       i241 = i242;
      }
      HEAP8[i54] = 1;
      HEAP32[i32 >> 2] = i239;
      HEAP32[i52 >> 2] = i84;
      i237 = i241;
      i238 = i84;
     } else {
      i237 = i80;
      i238 = i66;
     }
    } while (0);
    i66 = (HEAP32[i32 >> 2] | 0) + (i237 << 2) | 0;
    if ((i66 | 0) != 0) {
     HEAP32[i66 >> 2] = HEAP32[i90 >> 2];
    }
    i66 = i237 + 1 | 0;
    HEAP32[i53 >> 2] = i66;
    i80 = i235 | 0;
    i75 = HEAP32[i80 >> 2] | 0;
    if ((i75 | 0) == (HEAP32[i58 >> 2] | 0)) {
     i243 = i66;
     i244 = i238;
    } else {
     i66 = i75;
     while (1) {
      i75 = i66 + 12 | 0;
      i87 = HEAP32[i75 >> 2] | 0;
      i115 = i66 | 0;
      i76 = HEAP32[i115 >> 2] | 0;
      i149 = HEAP32[i66 + 8 >> 2] | 0;
      if ((i76 | 0) == (i66 | 0)) {
       HEAP32[(HEAP32[i149 + 12 >> 2] | 0) + 8 >> 2] = 0;
      } else {
       i130 = i66 + 4 | 0;
       HEAP32[i76 + 4 >> 2] = HEAP32[i130 >> 2];
       HEAP32[HEAP32[i130 >> 2] >> 2] = i76;
       HEAP32[(HEAP32[i149 + 12 >> 2] | 0) + 8 >> 2] = i76;
      }
      i76 = i149 | 0;
      i130 = HEAP32[i76 >> 2] | 0;
      if ((i130 | 0) == (i149 | 0)) {
       HEAP32[(HEAP32[i75 >> 2] | 0) + 8 >> 2] = 0;
      } else {
       i93 = i149 + 4 | 0;
       HEAP32[i130 + 4 >> 2] = HEAP32[i93 >> 2];
       HEAP32[HEAP32[i93 >> 2] >> 2] = i130;
       HEAP32[(HEAP32[i75 >> 2] | 0) + 8 >> 2] = i130;
      }
      _memset(i66 | 0, 0, 20);
      HEAP32[i115 >> 2] = HEAP32[i4 >> 2];
      HEAP32[i4 >> 2] = i66;
      _memset(i149 | 0, 0, 20);
      HEAP32[i76 >> 2] = HEAP32[i4 >> 2];
      HEAP32[i4 >> 2] = i149;
      HEAP32[i30 >> 2] = (HEAP32[i30 >> 2] | 0) - 1;
      i149 = HEAP32[i53 >> 2] | 0;
      i76 = HEAP32[i52 >> 2] | 0;
      do {
       if ((i149 | 0) == (i76 | 0)) {
        i115 = (i149 | 0) == 0 ? 1 : i149 << 1;
        if ((i149 | 0) >= (i115 | 0)) {
         i245 = i149;
         i246 = i149;
         break;
        }
        if ((i115 | 0) == 0) {
         i247 = 0;
         i248 = i149;
        } else {
         i130 = __Z22btAlignedAllocInternalji(i115 << 2, 16) | 0;
         i247 = i130;
         i248 = HEAP32[i53 >> 2] | 0;
        }
        if ((i248 | 0) > 0) {
         i130 = 0;
         do {
          i75 = i247 + (i130 << 2) | 0;
          if ((i75 | 0) != 0) {
           HEAP32[i75 >> 2] = HEAP32[(HEAP32[i32 >> 2] | 0) + (i130 << 2) >> 2];
          }
          i130 = i130 + 1 | 0;
         } while ((i130 | 0) < (i248 | 0));
        }
        i130 = HEAP32[i32 >> 2] | 0;
        if ((i130 | 0) == 0) {
         i249 = i248;
        } else {
         if ((HEAP8[i54] | 0) == 0) {
          i250 = i248;
         } else {
          __Z21btAlignedFreeInternalPv(i130);
          i250 = HEAP32[i53 >> 2] | 0;
         }
         HEAP32[i32 >> 2] = 0;
         i249 = i250;
        }
        HEAP8[i54] = 1;
        HEAP32[i32 >> 2] = i247;
        HEAP32[i52 >> 2] = i115;
        i245 = i249;
        i246 = i115;
       } else {
        i245 = i149;
        i246 = i76;
       }
      } while (0);
      i76 = (HEAP32[i32 >> 2] | 0) + (i245 << 2) | 0;
      if ((i76 | 0) != 0) {
       HEAP32[i76 >> 2] = i87;
      }
      i76 = i245 + 1 | 0;
      HEAP32[i53 >> 2] = i76;
      i149 = HEAP32[i80 >> 2] | 0;
      if ((i149 | 0) == (HEAP32[i58 >> 2] | 0)) {
       i243 = i76;
       i244 = i246;
       break;
      } else {
       i66 = i149;
      }
     }
    }
    do {
     if ((i243 | 0) == (i244 | 0)) {
      i66 = (i244 | 0) == 0 ? 1 : i244 << 1;
      if ((i244 | 0) >= (i66 | 0)) {
       i251 = i244;
       break;
      }
      if ((i66 | 0) == 0) {
       i252 = 0;
       i253 = i244;
      } else {
       i58 = __Z22btAlignedAllocInternalji(i66 << 2, 16) | 0;
       i252 = i58;
       i253 = HEAP32[i53 >> 2] | 0;
      }
      if ((i253 | 0) > 0) {
       i58 = 0;
       do {
        i80 = i252 + (i58 << 2) | 0;
        if ((i80 | 0) != 0) {
         HEAP32[i80 >> 2] = HEAP32[(HEAP32[i32 >> 2] | 0) + (i58 << 2) >> 2];
        }
        i58 = i58 + 1 | 0;
       } while ((i58 | 0) < (i253 | 0));
      }
      i58 = HEAP32[i32 >> 2] | 0;
      if ((i58 | 0) == 0) {
       i254 = i253;
      } else {
       if ((HEAP8[i54] | 0) == 0) {
        i255 = i253;
       } else {
        __Z21btAlignedFreeInternalPv(i58);
        i255 = HEAP32[i53 >> 2] | 0;
       }
       HEAP32[i32 >> 2] = 0;
       i254 = i255;
      }
      HEAP8[i54] = 1;
      HEAP32[i32 >> 2] = i252;
      HEAP32[i52 >> 2] = i66;
      i251 = i254;
     } else {
      i251 = i243;
     }
    } while (0);
    i58 = (HEAP32[i32 >> 2] | 0) + (i251 << 2) | 0;
    if ((i58 | 0) != 0) {
     HEAP32[i58 >> 2] = 0;
    }
    HEAP32[i53 >> 2] = i251 + 1;
   }
  } while (0);
  HEAP32[i235 + 16 >> 2] = i2;
  HEAP32[(HEAP32[i235 + 8 >> 2] | 0) + 16 >> 2] = HEAP32[i59 + 16 >> 2];
  i44 = i59;
  i50 = i65;
  i51 = i63;
  i55 = i235;
  i56 = (i56 | 0) == 0 ? i235 : i56;
 }
 if ((i49 | 0) == 1618) {
  STACKTOP = i5;
  return i20 | 0;
 }
 do {
  if ((i50 | 0) > 0) {
   HEAP32[(HEAP32[i56 + 8 >> 2] | 0) + 12 >> 2] = HEAP32[i55 + 12 >> 2];
   i235 = HEAP32[i51 + 8 >> 2] | 0;
   HEAP32[i235 >> 2] = i56;
   HEAP32[i56 + 4 >> 2] = i235;
   i235 = HEAP32[i55 + 8 >> 2] | 0;
   HEAP32[i56 >> 2] = i235;
   HEAP32[i235 + 4 >> 2] = i56;
  } else {
   i235 = i55 + 8 | 0;
   if ((i56 | 0) == (HEAP32[i235 >> 2] | 0)) {
    break;
   }
   i63 = i55 + 12 | 0;
   i65 = HEAP32[i53 >> 2] | 0;
   i44 = HEAP32[i52 >> 2] | 0;
   do {
    if ((i65 | 0) == (i44 | 0)) {
     i251 = (i65 | 0) == 0 ? 1 : i65 << 1;
     if ((i65 | 0) >= (i251 | 0)) {
      i256 = i65;
      i257 = i65;
      break;
     }
     if ((i251 | 0) == 0) {
      i258 = 0;
      i259 = i65;
     } else {
      i243 = __Z22btAlignedAllocInternalji(i251 << 2, 16) | 0;
      i258 = i243;
      i259 = HEAP32[i53 >> 2] | 0;
     }
     if ((i259 | 0) > 0) {
      i243 = 0;
      do {
       i254 = i258 + (i243 << 2) | 0;
       if ((i254 | 0) != 0) {
        HEAP32[i254 >> 2] = HEAP32[(HEAP32[i32 >> 2] | 0) + (i243 << 2) >> 2];
       }
       i243 = i243 + 1 | 0;
      } while ((i243 | 0) < (i259 | 0));
     }
     i243 = HEAP32[i32 >> 2] | 0;
     if ((i243 | 0) == 0) {
      i260 = i259;
     } else {
      if ((HEAP8[i54] | 0) == 0) {
       i261 = i259;
      } else {
       __Z21btAlignedFreeInternalPv(i243);
       i261 = HEAP32[i53 >> 2] | 0;
      }
      HEAP32[i32 >> 2] = 0;
      i260 = i261;
     }
     HEAP8[i54] = 1;
     HEAP32[i32 >> 2] = i258;
     HEAP32[i52 >> 2] = i251;
     i256 = i260;
     i257 = i251;
    } else {
     i256 = i65;
     i257 = i44;
    }
   } while (0);
   i44 = (HEAP32[i32 >> 2] | 0) + (i256 << 2) | 0;
   if ((i44 | 0) != 0) {
    HEAP32[i44 >> 2] = HEAP32[i63 >> 2];
   }
   i44 = i256 + 1 | 0;
   HEAP32[i53 >> 2] = i44;
   i65 = i56 | 0;
   i59 = HEAP32[i65 >> 2] | 0;
   if ((i59 | 0) == (HEAP32[i235 >> 2] | 0)) {
    i262 = i44;
    i263 = i257;
   } else {
    i44 = i59;
    while (1) {
     i59 = i44 + 12 | 0;
     i243 = HEAP32[i59 >> 2] | 0;
     i254 = i44 | 0;
     i252 = HEAP32[i254 >> 2] | 0;
     i255 = HEAP32[i44 + 8 >> 2] | 0;
     if ((i252 | 0) == (i44 | 0)) {
      HEAP32[(HEAP32[i255 + 12 >> 2] | 0) + 8 >> 2] = 0;
     } else {
      i253 = i44 + 4 | 0;
      HEAP32[i252 + 4 >> 2] = HEAP32[i253 >> 2];
      HEAP32[HEAP32[i253 >> 2] >> 2] = i252;
      HEAP32[(HEAP32[i255 + 12 >> 2] | 0) + 8 >> 2] = i252;
     }
     i252 = i255 | 0;
     i253 = HEAP32[i252 >> 2] | 0;
     if ((i253 | 0) == (i255 | 0)) {
      HEAP32[(HEAP32[i59 >> 2] | 0) + 8 >> 2] = 0;
     } else {
      i244 = i255 + 4 | 0;
      HEAP32[i253 + 4 >> 2] = HEAP32[i244 >> 2];
      HEAP32[HEAP32[i244 >> 2] >> 2] = i253;
      HEAP32[(HEAP32[i59 >> 2] | 0) + 8 >> 2] = i253;
     }
     _memset(i44 | 0, 0, 20);
     HEAP32[i254 >> 2] = HEAP32[i4 >> 2];
     HEAP32[i4 >> 2] = i44;
     _memset(i255 | 0, 0, 20);
     HEAP32[i252 >> 2] = HEAP32[i4 >> 2];
     HEAP32[i4 >> 2] = i255;
     HEAP32[i30 >> 2] = (HEAP32[i30 >> 2] | 0) - 1;
     i255 = HEAP32[i53 >> 2] | 0;
     i252 = HEAP32[i52 >> 2] | 0;
     do {
      if ((i255 | 0) == (i252 | 0)) {
       i254 = (i255 | 0) == 0 ? 1 : i255 << 1;
       if ((i255 | 0) >= (i254 | 0)) {
        i264 = i255;
        i265 = i255;
        break;
       }
       if ((i254 | 0) == 0) {
        i266 = 0;
        i267 = i255;
       } else {
        i253 = __Z22btAlignedAllocInternalji(i254 << 2, 16) | 0;
        i266 = i253;
        i267 = HEAP32[i53 >> 2] | 0;
       }
       if ((i267 | 0) > 0) {
        i253 = 0;
        do {
         i59 = i266 + (i253 << 2) | 0;
         if ((i59 | 0) != 0) {
          HEAP32[i59 >> 2] = HEAP32[(HEAP32[i32 >> 2] | 0) + (i253 << 2) >> 2];
         }
         i253 = i253 + 1 | 0;
        } while ((i253 | 0) < (i267 | 0));
       }
       i253 = HEAP32[i32 >> 2] | 0;
       if ((i253 | 0) == 0) {
        i268 = i267;
       } else {
        if ((HEAP8[i54] | 0) == 0) {
         i269 = i267;
        } else {
         __Z21btAlignedFreeInternalPv(i253);
         i269 = HEAP32[i53 >> 2] | 0;
        }
        HEAP32[i32 >> 2] = 0;
        i268 = i269;
       }
       HEAP8[i54] = 1;
       HEAP32[i32 >> 2] = i266;
       HEAP32[i52 >> 2] = i254;
       i264 = i268;
       i265 = i254;
      } else {
       i264 = i255;
       i265 = i252;
      }
     } while (0);
     i252 = (HEAP32[i32 >> 2] | 0) + (i264 << 2) | 0;
     if ((i252 | 0) != 0) {
      HEAP32[i252 >> 2] = i243;
     }
     i252 = i264 + 1 | 0;
     HEAP32[i53 >> 2] = i252;
     i255 = HEAP32[i65 >> 2] | 0;
     if ((i255 | 0) == (HEAP32[i235 >> 2] | 0)) {
      i262 = i252;
      i263 = i265;
      break;
     } else {
      i44 = i255;
     }
    }
   }
   do {
    if ((i262 | 0) == (i263 | 0)) {
     i44 = (i263 | 0) == 0 ? 1 : i263 << 1;
     if ((i263 | 0) >= (i44 | 0)) {
      i270 = i263;
      break;
     }
     if ((i44 | 0) == 0) {
      i271 = 0;
      i272 = i263;
     } else {
      i235 = __Z22btAlignedAllocInternalji(i44 << 2, 16) | 0;
      i271 = i235;
      i272 = HEAP32[i53 >> 2] | 0;
     }
     if ((i272 | 0) > 0) {
      i235 = 0;
      do {
       i65 = i271 + (i235 << 2) | 0;
       if ((i65 | 0) != 0) {
        HEAP32[i65 >> 2] = HEAP32[(HEAP32[i32 >> 2] | 0) + (i235 << 2) >> 2];
       }
       i235 = i235 + 1 | 0;
      } while ((i235 | 0) < (i272 | 0));
     }
     i235 = HEAP32[i32 >> 2] | 0;
     if ((i235 | 0) == 0) {
      i273 = i272;
     } else {
      if ((HEAP8[i54] | 0) == 0) {
       i274 = i272;
      } else {
       __Z21btAlignedFreeInternalPv(i235);
       i274 = HEAP32[i53 >> 2] | 0;
      }
      HEAP32[i32 >> 2] = 0;
      i273 = i274;
     }
     HEAP8[i54] = 1;
     HEAP32[i32 >> 2] = i271;
     HEAP32[i52 >> 2] = i44;
     i270 = i273;
    } else {
     i270 = i262;
    }
   } while (0);
   i235 = (HEAP32[i32 >> 2] | 0) + (i270 << 2) | 0;
   if ((i235 | 0) != 0) {
    HEAP32[i235 >> 2] = 0;
   }
   HEAP32[i53 >> 2] = i270 + 1;
  }
 } while (0);
 HEAP32[i1 + 124 >> 2] = HEAP32[HEAP32[i32 >> 2] >> 2];
 i1 = HEAP32[i53 >> 2] | 0;
 if ((i1 | 0) > 0) {
  i270 = 0;
  i262 = i1;
  while (1) {
   if ((i270 | 0) < (i262 | 0)) {
    i273 = i270;
    while (1) {
     i271 = HEAP32[i32 >> 2] | 0;
     i274 = HEAP32[i271 + (i273 << 2) >> 2] | 0;
     i272 = i273 + 2 | 0;
     i263 = HEAP32[i271 + (i273 + 1 << 2) >> 2] | 0;
     do {
      if ((i263 | 0) == 0) {
       i275 = i272;
      } else {
       i271 = i274 + 16 | 0;
       i265 = i274 + 12 | 0;
       i264 = 0;
       i268 = i272;
       i266 = i263;
       while (1) {
        i269 = HEAP32[i271 >> 2] | 0;
        i267 = i266 + 12 | 0;
        i257 = HEAP32[i267 >> 2] | 0;
        if ((i269 | 0) == 0) {
         HEAP32[i265 >> 2] = i257;
        } else {
         HEAP32[i269 + 8 >> 2] = i257;
        }
        i257 = i266 + 16 | 0;
        i269 = HEAP32[i257 >> 2] | 0;
        if ((i269 | 0) != 0) {
         HEAP32[i271 >> 2] = i269;
        }
        i269 = HEAP32[i267 >> 2] | 0;
        if ((i269 | 0) != 0) {
         i56 = i269;
         do {
          HEAP32[i56 + 4 >> 2] = i274;
          i56 = HEAP32[i56 + 8 >> 2] | 0;
         } while ((i56 | 0) != 0);
        }
        HEAP32[i267 >> 2] = 0;
        HEAP32[i257 >> 2] = 0;
        i56 = i266 + 8 | 0;
        i115 = HEAP32[i56 >> 2] | 0;
        if ((i115 | 0) == 0) {
         i276 = i264;
        } else {
         i269 = i264;
         i256 = i115;
         while (1) {
          i115 = HEAP32[i53 >> 2] | 0;
          i260 = HEAP32[i52 >> 2] | 0;
          if (i269) {
           i277 = i256;
           i278 = i115;
           i279 = i260;
          } else {
           do {
            if ((i115 | 0) == (i260 | 0)) {
             i258 = (i115 | 0) == 0 ? 1 : i115 << 1;
             if ((i115 | 0) >= (i258 | 0)) {
              i280 = i115;
              i281 = i115;
              break;
             }
             if ((i258 | 0) == 0) {
              i282 = 0;
              i283 = i115;
             } else {
              i261 = __Z22btAlignedAllocInternalji(i258 << 2, 16) | 0;
              i282 = i261;
              i283 = HEAP32[i53 >> 2] | 0;
             }
             if ((i283 | 0) > 0) {
              i261 = 0;
              do {
               i259 = i282 + (i261 << 2) | 0;
               if ((i259 | 0) != 0) {
                HEAP32[i259 >> 2] = HEAP32[(HEAP32[i32 >> 2] | 0) + (i261 << 2) >> 2];
               }
               i261 = i261 + 1 | 0;
              } while ((i261 | 0) < (i283 | 0));
             }
             i261 = HEAP32[i32 >> 2] | 0;
             if ((i261 | 0) == 0) {
              i284 = i283;
             } else {
              if ((HEAP8[i54] | 0) == 0) {
               i285 = i283;
              } else {
               __Z21btAlignedFreeInternalPv(i261);
               i285 = HEAP32[i53 >> 2] | 0;
              }
              HEAP32[i32 >> 2] = 0;
              i284 = i285;
             }
             HEAP8[i54] = 1;
             HEAP32[i32 >> 2] = i282;
             HEAP32[i52 >> 2] = i258;
             i280 = i284;
             i281 = i258;
            } else {
             i280 = i115;
             i281 = i260;
            }
           } while (0);
           i260 = (HEAP32[i32 >> 2] | 0) + (i280 << 2) | 0;
           if ((i260 | 0) != 0) {
            HEAP32[i260 >> 2] = i274;
           }
           i260 = i280 + 1 | 0;
           HEAP32[i53 >> 2] = i260;
           i277 = HEAP32[i56 >> 2] | 0;
           i278 = i260;
           i279 = i281;
          }
          i260 = i277 + 12 | 0;
          do {
           if ((i278 | 0) == (i279 | 0)) {
            i115 = (i279 | 0) == 0 ? 1 : i279 << 1;
            if ((i279 | 0) >= (i115 | 0)) {
             i286 = i279;
             break;
            }
            if ((i115 | 0) == 0) {
             i287 = 0;
             i288 = i279;
            } else {
             i261 = __Z22btAlignedAllocInternalji(i115 << 2, 16) | 0;
             i287 = i261;
             i288 = HEAP32[i53 >> 2] | 0;
            }
            if ((i288 | 0) > 0) {
             i261 = 0;
             do {
              i259 = i287 + (i261 << 2) | 0;
              if ((i259 | 0) != 0) {
               HEAP32[i259 >> 2] = HEAP32[(HEAP32[i32 >> 2] | 0) + (i261 << 2) >> 2];
              }
              i261 = i261 + 1 | 0;
             } while ((i261 | 0) < (i288 | 0));
            }
            i261 = HEAP32[i32 >> 2] | 0;
            if ((i261 | 0) == 0) {
             i289 = i288;
            } else {
             if ((HEAP8[i54] | 0) == 0) {
              i290 = i288;
             } else {
              __Z21btAlignedFreeInternalPv(i261);
              i290 = HEAP32[i53 >> 2] | 0;
             }
             HEAP32[i32 >> 2] = 0;
             i289 = i290;
            }
            HEAP8[i54] = 1;
            HEAP32[i32 >> 2] = i287;
            HEAP32[i52 >> 2] = i115;
            i286 = i289;
           } else {
            i286 = i278;
           }
          } while (0);
          i261 = (HEAP32[i32 >> 2] | 0) + (i286 << 2) | 0;
          if ((i261 | 0) != 0) {
           HEAP32[i261 >> 2] = HEAP32[i260 >> 2];
          }
          HEAP32[i53 >> 2] = i286 + 1;
          i261 = HEAP32[i56 >> 2] | 0;
          i258 = i261 | 0;
          i259 = HEAP32[i258 >> 2] | 0;
          i55 = HEAP32[i261 + 8 >> 2] | 0;
          if ((i259 | 0) == (i261 | 0)) {
           HEAP32[(HEAP32[i55 + 12 >> 2] | 0) + 8 >> 2] = 0;
          } else {
           i51 = i261 + 4 | 0;
           HEAP32[i259 + 4 >> 2] = HEAP32[i51 >> 2];
           HEAP32[HEAP32[i51 >> 2] >> 2] = i259;
           HEAP32[(HEAP32[i55 + 12 >> 2] | 0) + 8 >> 2] = i259;
          }
          i259 = i55 | 0;
          i51 = HEAP32[i259 >> 2] | 0;
          if ((i51 | 0) == (i55 | 0)) {
           HEAP32[(HEAP32[i261 + 12 >> 2] | 0) + 8 >> 2] = 0;
          } else {
           i50 = i55 + 4 | 0;
           HEAP32[i51 + 4 >> 2] = HEAP32[i50 >> 2];
           HEAP32[HEAP32[i50 >> 2] >> 2] = i51;
           HEAP32[(HEAP32[i261 + 12 >> 2] | 0) + 8 >> 2] = i51;
          }
          _memset(i261 | 0, 0, 20);
          HEAP32[i258 >> 2] = HEAP32[i4 >> 2];
          HEAP32[i4 >> 2] = i261;
          _memset(i55 | 0, 0, 20);
          HEAP32[i259 >> 2] = HEAP32[i4 >> 2];
          HEAP32[i4 >> 2] = i55;
          HEAP32[i30 >> 2] = (HEAP32[i30 >> 2] | 0) - 1;
          i55 = HEAP32[i56 >> 2] | 0;
          if ((i55 | 0) == 0) {
           i276 = 1;
           break;
          } else {
           i269 = 1;
           i256 = i55;
          }
         }
        }
        i291 = i268 + 1 | 0;
        i292 = HEAP32[i32 >> 2] | 0;
        i256 = HEAP32[i292 + (i268 << 2) >> 2] | 0;
        if ((i256 | 0) == 0) {
         break;
        } else {
         i264 = i276;
         i268 = i291;
         i266 = i256;
        }
       }
       if (!i276) {
        i275 = i291;
        break;
       }
       i266 = HEAP32[i53 >> 2] | 0;
       do {
        if ((i266 | 0) == (HEAP32[i52 >> 2] | 0)) {
         i268 = (i266 | 0) == 0 ? 1 : i266 << 1;
         if ((i266 | 0) >= (i268 | 0)) {
          i293 = i266;
          i294 = i292;
          break;
         }
         if ((i268 | 0) == 0) {
          i295 = 0;
          i296 = i266;
         } else {
          i264 = __Z22btAlignedAllocInternalji(i268 << 2, 16) | 0;
          i295 = i264;
          i296 = HEAP32[i53 >> 2] | 0;
         }
         if ((i296 | 0) > 0) {
          i264 = 0;
          do {
           i271 = i295 + (i264 << 2) | 0;
           if ((i271 | 0) != 0) {
            HEAP32[i271 >> 2] = HEAP32[(HEAP32[i32 >> 2] | 0) + (i264 << 2) >> 2];
           }
           i264 = i264 + 1 | 0;
          } while ((i264 | 0) < (i296 | 0));
         }
         i264 = HEAP32[i32 >> 2] | 0;
         if ((i264 | 0) == 0) {
          i297 = i296;
         } else {
          if ((HEAP8[i54] | 0) == 0) {
           i298 = i296;
          } else {
           __Z21btAlignedFreeInternalPv(i264);
           i298 = HEAP32[i53 >> 2] | 0;
          }
          HEAP32[i32 >> 2] = 0;
          i297 = i298;
         }
         HEAP8[i54] = 1;
         HEAP32[i32 >> 2] = i295;
         HEAP32[i52 >> 2] = i268;
         i293 = i297;
         i294 = i295;
        } else {
         i293 = i266;
         i294 = i292;
        }
       } while (0);
       i266 = i294 + (i293 << 2) | 0;
       if ((i266 | 0) != 0) {
        HEAP32[i266 >> 2] = 0;
       }
       HEAP32[i53 >> 2] = i293 + 1;
       i275 = i291;
      }
     } while (0);
     if ((i275 | 0) < (i262 | 0)) {
      i273 = i275;
     } else {
      break;
     }
    }
    i299 = i275;
    i300 = HEAP32[i53 >> 2] | 0;
   } else {
    i299 = i270;
    i300 = i262;
   }
   if ((i299 | 0) < (i300 | 0)) {
    i270 = i299;
    i262 = i300;
   } else {
    break;
   }
  }
  if ((i300 | 0) <= 0) {
   i301 = i300;
   i49 = 1599;
  }
 } else {
  i301 = i1;
  i49 = 1599;
 }
 do {
  if ((i49 | 0) == 1599) {
   if ((i301 | 0) >= 0) {
    break;
   }
   if ((HEAP32[i52 >> 2] | 0) < 0) {
    i1 = HEAP32[i32 >> 2] | 0;
    if ((i1 | 0) != 0) {
     if ((HEAP8[i54] | 0) != 0) {
      __Z21btAlignedFreeInternalPv(i1);
     }
     HEAP32[i32 >> 2] = 0;
    }
    HEAP8[i54] = 1;
    HEAP32[i32 >> 2] = 0;
    HEAP32[i52 >> 2] = 0;
    i302 = i301;
   } else {
    i302 = i301;
   }
   do {
    i1 = (HEAP32[i32 >> 2] | 0) + (i302 << 2) | 0;
    if ((i1 | 0) != 0) {
     HEAP32[i1 >> 2] = 0;
    }
    i302 = i302 + 1 | 0;
   } while ((i302 | 0) < 0);
  }
 } while (0);
 HEAP32[i53 >> 2] = 0;
 HEAP32[i28 >> 2] = i35;
 HEAP32[i36 >> 2] = i19;
 HEAP32[i33 >> 2] = i18;
 HEAP32[i2 + 24 >> 2] = -1;
 i20 = 1;
 STACKTOP = i5;
 return i20 | 0;
}
function _malloc(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0, i62 = 0, i63 = 0, i64 = 0, i65 = 0, i66 = 0, i67 = 0, i68 = 0, i69 = 0, i70 = 0, i71 = 0, i72 = 0, i73 = 0, i74 = 0, i75 = 0, i76 = 0, i77 = 0, i78 = 0, i79 = 0, i80 = 0, i81 = 0, i82 = 0, i83 = 0, i84 = 0, i85 = 0, i86 = 0;
 do {
  if (i1 >>> 0 < 245) {
   if (i1 >>> 0 < 11) {
    i2 = 16;
   } else {
    i2 = i1 + 11 & -8;
   }
   i3 = i2 >>> 3;
   i4 = HEAP32[3016] | 0;
   i5 = i4 >>> (i3 >>> 0);
   if ((i5 & 3 | 0) != 0) {
    i6 = (i5 & 1 ^ 1) + i3 | 0;
    i7 = i6 << 1;
    i8 = 12104 + (i7 << 2) | 0;
    i9 = 12104 + (i7 + 2 << 2) | 0;
    i7 = HEAP32[i9 >> 2] | 0;
    i10 = i7 + 8 | 0;
    i11 = HEAP32[i10 >> 2] | 0;
    do {
     if ((i8 | 0) == (i11 | 0)) {
      HEAP32[3016] = i4 & ~(1 << i6);
     } else {
      if (i11 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
       _abort();
       return 0;
      }
      i12 = i11 + 12 | 0;
      if ((HEAP32[i12 >> 2] | 0) == (i7 | 0)) {
       HEAP32[i12 >> 2] = i8;
       HEAP32[i9 >> 2] = i11;
       break;
      } else {
       _abort();
       return 0;
      }
     }
    } while (0);
    i11 = i6 << 3;
    HEAP32[i7 + 4 >> 2] = i11 | 3;
    i9 = i7 + (i11 | 4) | 0;
    HEAP32[i9 >> 2] = HEAP32[i9 >> 2] | 1;
    i13 = i10;
    return i13 | 0;
   }
   if (i2 >>> 0 <= (HEAP32[3018] | 0) >>> 0) {
    i14 = i2;
    break;
   }
   if ((i5 | 0) != 0) {
    i9 = 2 << i3;
    i11 = i5 << i3 & (i9 | -i9);
    i9 = (i11 & -i11) - 1 | 0;
    i11 = i9 >>> 12 & 16;
    i8 = i9 >>> (i11 >>> 0);
    i9 = i8 >>> 5 & 8;
    i12 = i8 >>> (i9 >>> 0);
    i8 = i12 >>> 2 & 4;
    i15 = i12 >>> (i8 >>> 0);
    i12 = i15 >>> 1 & 2;
    i16 = i15 >>> (i12 >>> 0);
    i15 = i16 >>> 1 & 1;
    i17 = (i9 | i11 | i8 | i12 | i15) + (i16 >>> (i15 >>> 0)) | 0;
    i15 = i17 << 1;
    i16 = 12104 + (i15 << 2) | 0;
    i12 = 12104 + (i15 + 2 << 2) | 0;
    i15 = HEAP32[i12 >> 2] | 0;
    i8 = i15 + 8 | 0;
    i11 = HEAP32[i8 >> 2] | 0;
    do {
     if ((i16 | 0) == (i11 | 0)) {
      HEAP32[3016] = i4 & ~(1 << i17);
     } else {
      if (i11 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
       _abort();
       return 0;
      }
      i9 = i11 + 12 | 0;
      if ((HEAP32[i9 >> 2] | 0) == (i15 | 0)) {
       HEAP32[i9 >> 2] = i16;
       HEAP32[i12 >> 2] = i11;
       break;
      } else {
       _abort();
       return 0;
      }
     }
    } while (0);
    i11 = i17 << 3;
    i12 = i11 - i2 | 0;
    HEAP32[i15 + 4 >> 2] = i2 | 3;
    i16 = i15;
    i4 = i16 + i2 | 0;
    HEAP32[i16 + (i2 | 4) >> 2] = i12 | 1;
    HEAP32[i16 + i11 >> 2] = i12;
    i11 = HEAP32[3018] | 0;
    if ((i11 | 0) != 0) {
     i16 = HEAP32[3021] | 0;
     i3 = i11 >>> 3;
     i11 = i3 << 1;
     i5 = 12104 + (i11 << 2) | 0;
     i10 = HEAP32[3016] | 0;
     i7 = 1 << i3;
     do {
      if ((i10 & i7 | 0) == 0) {
       HEAP32[3016] = i10 | i7;
       i18 = i5;
       i19 = 12104 + (i11 + 2 << 2) | 0;
      } else {
       i3 = 12104 + (i11 + 2 << 2) | 0;
       i6 = HEAP32[i3 >> 2] | 0;
       if (i6 >>> 0 >= (HEAP32[3020] | 0) >>> 0) {
        i18 = i6;
        i19 = i3;
        break;
       }
       _abort();
       return 0;
      }
     } while (0);
     HEAP32[i19 >> 2] = i16;
     HEAP32[i18 + 12 >> 2] = i16;
     HEAP32[i16 + 8 >> 2] = i18;
     HEAP32[i16 + 12 >> 2] = i5;
    }
    HEAP32[3018] = i12;
    HEAP32[3021] = i4;
    i13 = i8;
    return i13 | 0;
   }
   i11 = HEAP32[3017] | 0;
   if ((i11 | 0) == 0) {
    i14 = i2;
    break;
   }
   i7 = (i11 & -i11) - 1 | 0;
   i11 = i7 >>> 12 & 16;
   i10 = i7 >>> (i11 >>> 0);
   i7 = i10 >>> 5 & 8;
   i15 = i10 >>> (i7 >>> 0);
   i10 = i15 >>> 2 & 4;
   i17 = i15 >>> (i10 >>> 0);
   i15 = i17 >>> 1 & 2;
   i3 = i17 >>> (i15 >>> 0);
   i17 = i3 >>> 1 & 1;
   i6 = HEAP32[12368 + ((i7 | i11 | i10 | i15 | i17) + (i3 >>> (i17 >>> 0)) << 2) >> 2] | 0;
   i17 = i6;
   i3 = i6;
   i15 = (HEAP32[i6 + 4 >> 2] & -8) - i2 | 0;
   while (1) {
    i6 = HEAP32[i17 + 16 >> 2] | 0;
    if ((i6 | 0) == 0) {
     i10 = HEAP32[i17 + 20 >> 2] | 0;
     if ((i10 | 0) == 0) {
      break;
     } else {
      i20 = i10;
     }
    } else {
     i20 = i6;
    }
    i6 = (HEAP32[i20 + 4 >> 2] & -8) - i2 | 0;
    i10 = i6 >>> 0 < i15 >>> 0;
    i17 = i20;
    i3 = i10 ? i20 : i3;
    i15 = i10 ? i6 : i15;
   }
   i17 = i3;
   i8 = HEAP32[3020] | 0;
   if (i17 >>> 0 < i8 >>> 0) {
    _abort();
    return 0;
   }
   i4 = i17 + i2 | 0;
   i12 = i4;
   if (i17 >>> 0 >= i4 >>> 0) {
    _abort();
    return 0;
   }
   i4 = HEAP32[i3 + 24 >> 2] | 0;
   i5 = HEAP32[i3 + 12 >> 2] | 0;
   do {
    if ((i5 | 0) == (i3 | 0)) {
     i16 = i3 + 20 | 0;
     i6 = HEAP32[i16 >> 2] | 0;
     if ((i6 | 0) == 0) {
      i10 = i3 + 16 | 0;
      i11 = HEAP32[i10 >> 2] | 0;
      if ((i11 | 0) == 0) {
       i21 = 0;
       break;
      } else {
       i22 = i11;
       i23 = i10;
      }
     } else {
      i22 = i6;
      i23 = i16;
     }
     while (1) {
      i16 = i22 + 20 | 0;
      i6 = HEAP32[i16 >> 2] | 0;
      if ((i6 | 0) != 0) {
       i22 = i6;
       i23 = i16;
       continue;
      }
      i16 = i22 + 16 | 0;
      i6 = HEAP32[i16 >> 2] | 0;
      if ((i6 | 0) == 0) {
       break;
      } else {
       i22 = i6;
       i23 = i16;
      }
     }
     if (i23 >>> 0 < i8 >>> 0) {
      _abort();
      return 0;
     } else {
      HEAP32[i23 >> 2] = 0;
      i21 = i22;
      break;
     }
    } else {
     i16 = HEAP32[i3 + 8 >> 2] | 0;
     if (i16 >>> 0 < i8 >>> 0) {
      _abort();
      return 0;
     }
     i6 = i16 + 12 | 0;
     if ((HEAP32[i6 >> 2] | 0) != (i3 | 0)) {
      _abort();
      return 0;
     }
     i10 = i5 + 8 | 0;
     if ((HEAP32[i10 >> 2] | 0) == (i3 | 0)) {
      HEAP32[i6 >> 2] = i5;
      HEAP32[i10 >> 2] = i16;
      i21 = i5;
      break;
     } else {
      _abort();
      return 0;
     }
    }
   } while (0);
   L78 : do {
    if ((i4 | 0) != 0) {
     i5 = i3 + 28 | 0;
     i8 = 12368 + (HEAP32[i5 >> 2] << 2) | 0;
     do {
      if ((i3 | 0) == (HEAP32[i8 >> 2] | 0)) {
       HEAP32[i8 >> 2] = i21;
       if ((i21 | 0) != 0) {
        break;
       }
       HEAP32[3017] = HEAP32[3017] & ~(1 << HEAP32[i5 >> 2]);
       break L78;
      } else {
       if (i4 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
        _abort();
        return 0;
       }
       i16 = i4 + 16 | 0;
       if ((HEAP32[i16 >> 2] | 0) == (i3 | 0)) {
        HEAP32[i16 >> 2] = i21;
       } else {
        HEAP32[i4 + 20 >> 2] = i21;
       }
       if ((i21 | 0) == 0) {
        break L78;
       }
      }
     } while (0);
     if (i21 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
      _abort();
      return 0;
     }
     HEAP32[i21 + 24 >> 2] = i4;
     i5 = HEAP32[i3 + 16 >> 2] | 0;
     do {
      if ((i5 | 0) != 0) {
       if (i5 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
        _abort();
        return 0;
       } else {
        HEAP32[i21 + 16 >> 2] = i5;
        HEAP32[i5 + 24 >> 2] = i21;
        break;
       }
      }
     } while (0);
     i5 = HEAP32[i3 + 20 >> 2] | 0;
     if ((i5 | 0) == 0) {
      break;
     }
     if (i5 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
      _abort();
      return 0;
     } else {
      HEAP32[i21 + 20 >> 2] = i5;
      HEAP32[i5 + 24 >> 2] = i21;
      break;
     }
    }
   } while (0);
   if (i15 >>> 0 < 16) {
    i4 = i15 + i2 | 0;
    HEAP32[i3 + 4 >> 2] = i4 | 3;
    i5 = i17 + (i4 + 4) | 0;
    HEAP32[i5 >> 2] = HEAP32[i5 >> 2] | 1;
   } else {
    HEAP32[i3 + 4 >> 2] = i2 | 3;
    HEAP32[i17 + (i2 | 4) >> 2] = i15 | 1;
    HEAP32[i17 + (i15 + i2) >> 2] = i15;
    i5 = HEAP32[3018] | 0;
    if ((i5 | 0) != 0) {
     i4 = HEAP32[3021] | 0;
     i8 = i5 >>> 3;
     i5 = i8 << 1;
     i16 = 12104 + (i5 << 2) | 0;
     i10 = HEAP32[3016] | 0;
     i6 = 1 << i8;
     do {
      if ((i10 & i6 | 0) == 0) {
       HEAP32[3016] = i10 | i6;
       i24 = i16;
       i25 = 12104 + (i5 + 2 << 2) | 0;
      } else {
       i8 = 12104 + (i5 + 2 << 2) | 0;
       i11 = HEAP32[i8 >> 2] | 0;
       if (i11 >>> 0 >= (HEAP32[3020] | 0) >>> 0) {
        i24 = i11;
        i25 = i8;
        break;
       }
       _abort();
       return 0;
      }
     } while (0);
     HEAP32[i25 >> 2] = i4;
     HEAP32[i24 + 12 >> 2] = i4;
     HEAP32[i4 + 8 >> 2] = i24;
     HEAP32[i4 + 12 >> 2] = i16;
    }
    HEAP32[3018] = i15;
    HEAP32[3021] = i12;
   }
   i5 = i3 + 8 | 0;
   if ((i5 | 0) == 0) {
    i14 = i2;
    break;
   } else {
    i13 = i5;
   }
   return i13 | 0;
  } else {
   if (i1 >>> 0 > 4294967231) {
    i14 = -1;
    break;
   }
   i5 = i1 + 11 | 0;
   i6 = i5 & -8;
   i10 = HEAP32[3017] | 0;
   if ((i10 | 0) == 0) {
    i14 = i6;
    break;
   }
   i17 = -i6 | 0;
   i8 = i5 >>> 8;
   do {
    if ((i8 | 0) == 0) {
     i26 = 0;
    } else {
     if (i6 >>> 0 > 16777215) {
      i26 = 31;
      break;
     }
     i5 = (i8 + 1048320 | 0) >>> 16 & 8;
     i11 = i8 << i5;
     i7 = (i11 + 520192 | 0) >>> 16 & 4;
     i9 = i11 << i7;
     i11 = (i9 + 245760 | 0) >>> 16 & 2;
     i27 = 14 - (i7 | i5 | i11) + (i9 << i11 >>> 15) | 0;
     i26 = i6 >>> ((i27 + 7 | 0) >>> 0) & 1 | i27 << 1;
    }
   } while (0);
   i8 = HEAP32[12368 + (i26 << 2) >> 2] | 0;
   L126 : do {
    if ((i8 | 0) == 0) {
     i28 = 0;
     i29 = i17;
     i30 = 0;
    } else {
     if ((i26 | 0) == 31) {
      i31 = 0;
     } else {
      i31 = 25 - (i26 >>> 1) | 0;
     }
     i3 = 0;
     i12 = i17;
     i15 = i8;
     i16 = i6 << i31;
     i4 = 0;
     while (1) {
      i27 = HEAP32[i15 + 4 >> 2] & -8;
      i11 = i27 - i6 | 0;
      if (i11 >>> 0 < i12 >>> 0) {
       if ((i27 | 0) == (i6 | 0)) {
        i28 = i15;
        i29 = i11;
        i30 = i15;
        break L126;
       } else {
        i32 = i15;
        i33 = i11;
       }
      } else {
       i32 = i3;
       i33 = i12;
      }
      i11 = HEAP32[i15 + 20 >> 2] | 0;
      i27 = HEAP32[i15 + 16 + (i16 >>> 31 << 2) >> 2] | 0;
      i9 = (i11 | 0) == 0 | (i11 | 0) == (i27 | 0) ? i4 : i11;
      if ((i27 | 0) == 0) {
       i28 = i32;
       i29 = i33;
       i30 = i9;
       break;
      } else {
       i3 = i32;
       i12 = i33;
       i15 = i27;
       i16 = i16 << 1;
       i4 = i9;
      }
     }
    }
   } while (0);
   if ((i30 | 0) == 0 & (i28 | 0) == 0) {
    i8 = 2 << i26;
    i17 = i10 & (i8 | -i8);
    if ((i17 | 0) == 0) {
     i14 = i6;
     break;
    }
    i8 = (i17 & -i17) - 1 | 0;
    i17 = i8 >>> 12 & 16;
    i4 = i8 >>> (i17 >>> 0);
    i8 = i4 >>> 5 & 8;
    i16 = i4 >>> (i8 >>> 0);
    i4 = i16 >>> 2 & 4;
    i15 = i16 >>> (i4 >>> 0);
    i16 = i15 >>> 1 & 2;
    i12 = i15 >>> (i16 >>> 0);
    i15 = i12 >>> 1 & 1;
    i34 = HEAP32[12368 + ((i8 | i17 | i4 | i16 | i15) + (i12 >>> (i15 >>> 0)) << 2) >> 2] | 0;
   } else {
    i34 = i30;
   }
   if ((i34 | 0) == 0) {
    i35 = i29;
    i36 = i28;
   } else {
    i15 = i34;
    i12 = i29;
    i16 = i28;
    while (1) {
     i4 = (HEAP32[i15 + 4 >> 2] & -8) - i6 | 0;
     i17 = i4 >>> 0 < i12 >>> 0;
     i8 = i17 ? i4 : i12;
     i4 = i17 ? i15 : i16;
     i17 = HEAP32[i15 + 16 >> 2] | 0;
     if ((i17 | 0) != 0) {
      i15 = i17;
      i12 = i8;
      i16 = i4;
      continue;
     }
     i17 = HEAP32[i15 + 20 >> 2] | 0;
     if ((i17 | 0) == 0) {
      i35 = i8;
      i36 = i4;
      break;
     } else {
      i15 = i17;
      i12 = i8;
      i16 = i4;
     }
    }
   }
   if ((i36 | 0) == 0) {
    i14 = i6;
    break;
   }
   if (i35 >>> 0 >= ((HEAP32[3018] | 0) - i6 | 0) >>> 0) {
    i14 = i6;
    break;
   }
   i16 = i36;
   i12 = HEAP32[3020] | 0;
   if (i16 >>> 0 < i12 >>> 0) {
    _abort();
    return 0;
   }
   i15 = i16 + i6 | 0;
   i10 = i15;
   if (i16 >>> 0 >= i15 >>> 0) {
    _abort();
    return 0;
   }
   i4 = HEAP32[i36 + 24 >> 2] | 0;
   i8 = HEAP32[i36 + 12 >> 2] | 0;
   do {
    if ((i8 | 0) == (i36 | 0)) {
     i17 = i36 + 20 | 0;
     i3 = HEAP32[i17 >> 2] | 0;
     if ((i3 | 0) == 0) {
      i9 = i36 + 16 | 0;
      i27 = HEAP32[i9 >> 2] | 0;
      if ((i27 | 0) == 0) {
       i37 = 0;
       break;
      } else {
       i38 = i27;
       i39 = i9;
      }
     } else {
      i38 = i3;
      i39 = i17;
     }
     while (1) {
      i17 = i38 + 20 | 0;
      i3 = HEAP32[i17 >> 2] | 0;
      if ((i3 | 0) != 0) {
       i38 = i3;
       i39 = i17;
       continue;
      }
      i17 = i38 + 16 | 0;
      i3 = HEAP32[i17 >> 2] | 0;
      if ((i3 | 0) == 0) {
       break;
      } else {
       i38 = i3;
       i39 = i17;
      }
     }
     if (i39 >>> 0 < i12 >>> 0) {
      _abort();
      return 0;
     } else {
      HEAP32[i39 >> 2] = 0;
      i37 = i38;
      break;
     }
    } else {
     i17 = HEAP32[i36 + 8 >> 2] | 0;
     if (i17 >>> 0 < i12 >>> 0) {
      _abort();
      return 0;
     }
     i3 = i17 + 12 | 0;
     if ((HEAP32[i3 >> 2] | 0) != (i36 | 0)) {
      _abort();
      return 0;
     }
     i9 = i8 + 8 | 0;
     if ((HEAP32[i9 >> 2] | 0) == (i36 | 0)) {
      HEAP32[i3 >> 2] = i8;
      HEAP32[i9 >> 2] = i17;
      i37 = i8;
      break;
     } else {
      _abort();
      return 0;
     }
    }
   } while (0);
   L176 : do {
    if ((i4 | 0) != 0) {
     i8 = i36 + 28 | 0;
     i12 = 12368 + (HEAP32[i8 >> 2] << 2) | 0;
     do {
      if ((i36 | 0) == (HEAP32[i12 >> 2] | 0)) {
       HEAP32[i12 >> 2] = i37;
       if ((i37 | 0) != 0) {
        break;
       }
       HEAP32[3017] = HEAP32[3017] & ~(1 << HEAP32[i8 >> 2]);
       break L176;
      } else {
       if (i4 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
        _abort();
        return 0;
       }
       i17 = i4 + 16 | 0;
       if ((HEAP32[i17 >> 2] | 0) == (i36 | 0)) {
        HEAP32[i17 >> 2] = i37;
       } else {
        HEAP32[i4 + 20 >> 2] = i37;
       }
       if ((i37 | 0) == 0) {
        break L176;
       }
      }
     } while (0);
     if (i37 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
      _abort();
      return 0;
     }
     HEAP32[i37 + 24 >> 2] = i4;
     i8 = HEAP32[i36 + 16 >> 2] | 0;
     do {
      if ((i8 | 0) != 0) {
       if (i8 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
        _abort();
        return 0;
       } else {
        HEAP32[i37 + 16 >> 2] = i8;
        HEAP32[i8 + 24 >> 2] = i37;
        break;
       }
      }
     } while (0);
     i8 = HEAP32[i36 + 20 >> 2] | 0;
     if ((i8 | 0) == 0) {
      break;
     }
     if (i8 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
      _abort();
      return 0;
     } else {
      HEAP32[i37 + 20 >> 2] = i8;
      HEAP32[i8 + 24 >> 2] = i37;
      break;
     }
    }
   } while (0);
   do {
    if (i35 >>> 0 < 16) {
     i4 = i35 + i6 | 0;
     HEAP32[i36 + 4 >> 2] = i4 | 3;
     i8 = i16 + (i4 + 4) | 0;
     HEAP32[i8 >> 2] = HEAP32[i8 >> 2] | 1;
    } else {
     HEAP32[i36 + 4 >> 2] = i6 | 3;
     HEAP32[i16 + (i6 | 4) >> 2] = i35 | 1;
     HEAP32[i16 + (i35 + i6) >> 2] = i35;
     i8 = i35 >>> 3;
     if (i35 >>> 0 < 256) {
      i4 = i8 << 1;
      i12 = 12104 + (i4 << 2) | 0;
      i17 = HEAP32[3016] | 0;
      i9 = 1 << i8;
      do {
       if ((i17 & i9 | 0) == 0) {
        HEAP32[3016] = i17 | i9;
        i40 = i12;
        i41 = 12104 + (i4 + 2 << 2) | 0;
       } else {
        i8 = 12104 + (i4 + 2 << 2) | 0;
        i3 = HEAP32[i8 >> 2] | 0;
        if (i3 >>> 0 >= (HEAP32[3020] | 0) >>> 0) {
         i40 = i3;
         i41 = i8;
         break;
        }
        _abort();
        return 0;
       }
      } while (0);
      HEAP32[i41 >> 2] = i10;
      HEAP32[i40 + 12 >> 2] = i10;
      HEAP32[i16 + (i6 + 8) >> 2] = i40;
      HEAP32[i16 + (i6 + 12) >> 2] = i12;
      break;
     }
     i4 = i15;
     i9 = i35 >>> 8;
     do {
      if ((i9 | 0) == 0) {
       i42 = 0;
      } else {
       if (i35 >>> 0 > 16777215) {
        i42 = 31;
        break;
       }
       i17 = (i9 + 1048320 | 0) >>> 16 & 8;
       i8 = i9 << i17;
       i3 = (i8 + 520192 | 0) >>> 16 & 4;
       i27 = i8 << i3;
       i8 = (i27 + 245760 | 0) >>> 16 & 2;
       i11 = 14 - (i3 | i17 | i8) + (i27 << i8 >>> 15) | 0;
       i42 = i35 >>> ((i11 + 7 | 0) >>> 0) & 1 | i11 << 1;
      }
     } while (0);
     i9 = 12368 + (i42 << 2) | 0;
     HEAP32[i16 + (i6 + 28) >> 2] = i42;
     HEAP32[i16 + (i6 + 20) >> 2] = 0;
     HEAP32[i16 + (i6 + 16) >> 2] = 0;
     i12 = HEAP32[3017] | 0;
     i11 = 1 << i42;
     if ((i12 & i11 | 0) == 0) {
      HEAP32[3017] = i12 | i11;
      HEAP32[i9 >> 2] = i4;
      HEAP32[i16 + (i6 + 24) >> 2] = i9;
      HEAP32[i16 + (i6 + 12) >> 2] = i4;
      HEAP32[i16 + (i6 + 8) >> 2] = i4;
      break;
     }
     if ((i42 | 0) == 31) {
      i43 = 0;
     } else {
      i43 = 25 - (i42 >>> 1) | 0;
     }
     i11 = i35 << i43;
     i12 = HEAP32[i9 >> 2] | 0;
     while (1) {
      if ((HEAP32[i12 + 4 >> 2] & -8 | 0) == (i35 | 0)) {
       break;
      }
      i44 = i12 + 16 + (i11 >>> 31 << 2) | 0;
      i9 = HEAP32[i44 >> 2] | 0;
      if ((i9 | 0) == 0) {
       i45 = 151;
       break;
      } else {
       i11 = i11 << 1;
       i12 = i9;
      }
     }
     if ((i45 | 0) == 151) {
      if (i44 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
       _abort();
       return 0;
      } else {
       HEAP32[i44 >> 2] = i4;
       HEAP32[i16 + (i6 + 24) >> 2] = i12;
       HEAP32[i16 + (i6 + 12) >> 2] = i4;
       HEAP32[i16 + (i6 + 8) >> 2] = i4;
       break;
      }
     }
     i11 = i12 + 8 | 0;
     i9 = HEAP32[i11 >> 2] | 0;
     i8 = HEAP32[3020] | 0;
     if (i12 >>> 0 < i8 >>> 0) {
      _abort();
      return 0;
     }
     if (i9 >>> 0 < i8 >>> 0) {
      _abort();
      return 0;
     } else {
      HEAP32[i9 + 12 >> 2] = i4;
      HEAP32[i11 >> 2] = i4;
      HEAP32[i16 + (i6 + 8) >> 2] = i9;
      HEAP32[i16 + (i6 + 12) >> 2] = i12;
      HEAP32[i16 + (i6 + 24) >> 2] = 0;
      break;
     }
    }
   } while (0);
   i16 = i36 + 8 | 0;
   if ((i16 | 0) == 0) {
    i14 = i6;
    break;
   } else {
    i13 = i16;
   }
   return i13 | 0;
  }
 } while (0);
 i36 = HEAP32[3018] | 0;
 if (i14 >>> 0 <= i36 >>> 0) {
  i44 = i36 - i14 | 0;
  i35 = HEAP32[3021] | 0;
  if (i44 >>> 0 > 15) {
   i43 = i35;
   HEAP32[3021] = i43 + i14;
   HEAP32[3018] = i44;
   HEAP32[i43 + (i14 + 4) >> 2] = i44 | 1;
   HEAP32[i43 + i36 >> 2] = i44;
   HEAP32[i35 + 4 >> 2] = i14 | 3;
  } else {
   HEAP32[3018] = 0;
   HEAP32[3021] = 0;
   HEAP32[i35 + 4 >> 2] = i36 | 3;
   i44 = i35 + (i36 + 4) | 0;
   HEAP32[i44 >> 2] = HEAP32[i44 >> 2] | 1;
  }
  i13 = i35 + 8 | 0;
  return i13 | 0;
 }
 i35 = HEAP32[3019] | 0;
 if (i14 >>> 0 < i35 >>> 0) {
  i44 = i35 - i14 | 0;
  HEAP32[3019] = i44;
  i35 = HEAP32[3022] | 0;
  i36 = i35;
  HEAP32[3022] = i36 + i14;
  HEAP32[i36 + (i14 + 4) >> 2] = i44 | 1;
  HEAP32[i35 + 4 >> 2] = i14 | 3;
  i13 = i35 + 8 | 0;
  return i13 | 0;
 }
 do {
  if ((HEAP32[2976] | 0) == 0) {
   i35 = _sysconf(8) | 0;
   if ((i35 - 1 & i35 | 0) == 0) {
    HEAP32[2978] = i35;
    HEAP32[2977] = i35;
    HEAP32[2979] = -1;
    HEAP32[2980] = -1;
    HEAP32[2981] = 0;
    HEAP32[3127] = 0;
    HEAP32[2976] = (_time(0) | 0) & -16 ^ 1431655768;
    break;
   } else {
    _abort();
    return 0;
   }
  }
 } while (0);
 i35 = i14 + 48 | 0;
 i44 = HEAP32[2978] | 0;
 i36 = i14 + 47 | 0;
 i43 = i44 + i36 | 0;
 i42 = -i44 | 0;
 i44 = i43 & i42;
 if (i44 >>> 0 <= i14 >>> 0) {
  i13 = 0;
  return i13 | 0;
 }
 i40 = HEAP32[3126] | 0;
 do {
  if ((i40 | 0) != 0) {
   i41 = HEAP32[3124] | 0;
   i37 = i41 + i44 | 0;
   if (i37 >>> 0 <= i41 >>> 0 | i37 >>> 0 > i40 >>> 0) {
    i13 = 0;
   } else {
    break;
   }
   return i13 | 0;
  }
 } while (0);
 L268 : do {
  if ((HEAP32[3127] & 4 | 0) == 0) {
   i40 = HEAP32[3022] | 0;
   L270 : do {
    if ((i40 | 0) == 0) {
     i45 = 181;
    } else {
     i37 = i40;
     i41 = 12512;
     while (1) {
      i46 = i41 | 0;
      i38 = HEAP32[i46 >> 2] | 0;
      if (i38 >>> 0 <= i37 >>> 0) {
       i47 = i41 + 4 | 0;
       if ((i38 + (HEAP32[i47 >> 2] | 0) | 0) >>> 0 > i37 >>> 0) {
        break;
       }
      }
      i38 = HEAP32[i41 + 8 >> 2] | 0;
      if ((i38 | 0) == 0) {
       i45 = 181;
       break L270;
      } else {
       i41 = i38;
      }
     }
     if ((i41 | 0) == 0) {
      i45 = 181;
      break;
     }
     i37 = i43 - (HEAP32[3019] | 0) & i42;
     if (i37 >>> 0 >= 2147483647) {
      i48 = 0;
      break;
     }
     i12 = _sbrk(i37 | 0) | 0;
     i4 = (i12 | 0) == ((HEAP32[i46 >> 2] | 0) + (HEAP32[i47 >> 2] | 0) | 0);
     i49 = i4 ? i12 : -1;
     i50 = i4 ? i37 : 0;
     i51 = i12;
     i52 = i37;
     i45 = 190;
    }
   } while (0);
   do {
    if ((i45 | 0) == 181) {
     i40 = _sbrk(0) | 0;
     if ((i40 | 0) == -1) {
      i48 = 0;
      break;
     }
     i6 = i40;
     i37 = HEAP32[2977] | 0;
     i12 = i37 - 1 | 0;
     if ((i12 & i6 | 0) == 0) {
      i53 = i44;
     } else {
      i53 = i44 - i6 + (i12 + i6 & -i37) | 0;
     }
     i37 = HEAP32[3124] | 0;
     i6 = i37 + i53 | 0;
     if (!(i53 >>> 0 > i14 >>> 0 & i53 >>> 0 < 2147483647)) {
      i48 = 0;
      break;
     }
     i12 = HEAP32[3126] | 0;
     if ((i12 | 0) != 0) {
      if (i6 >>> 0 <= i37 >>> 0 | i6 >>> 0 > i12 >>> 0) {
       i48 = 0;
       break;
      }
     }
     i12 = _sbrk(i53 | 0) | 0;
     i6 = (i12 | 0) == (i40 | 0);
     i49 = i6 ? i40 : -1;
     i50 = i6 ? i53 : 0;
     i51 = i12;
     i52 = i53;
     i45 = 190;
    }
   } while (0);
   L290 : do {
    if ((i45 | 0) == 190) {
     i12 = -i52 | 0;
     if ((i49 | 0) != -1) {
      i54 = i50;
      i55 = i49;
      i45 = 201;
      break L268;
     }
     do {
      if ((i51 | 0) != -1 & i52 >>> 0 < 2147483647 & i52 >>> 0 < i35 >>> 0) {
       i6 = HEAP32[2978] | 0;
       i40 = i36 - i52 + i6 & -i6;
       if (i40 >>> 0 >= 2147483647) {
        i56 = i52;
        break;
       }
       if ((_sbrk(i40 | 0) | 0) == -1) {
        _sbrk(i12 | 0) | 0;
        i48 = i50;
        break L290;
       } else {
        i56 = i40 + i52 | 0;
        break;
       }
      } else {
       i56 = i52;
      }
     } while (0);
     if ((i51 | 0) == -1) {
      i48 = i50;
     } else {
      i54 = i56;
      i55 = i51;
      i45 = 201;
      break L268;
     }
    }
   } while (0);
   HEAP32[3127] = HEAP32[3127] | 4;
   i57 = i48;
   i45 = 198;
  } else {
   i57 = 0;
   i45 = 198;
  }
 } while (0);
 do {
  if ((i45 | 0) == 198) {
   if (i44 >>> 0 >= 2147483647) {
    break;
   }
   i48 = _sbrk(i44 | 0) | 0;
   i51 = _sbrk(0) | 0;
   if (!((i51 | 0) != -1 & (i48 | 0) != -1 & i48 >>> 0 < i51 >>> 0)) {
    break;
   }
   i56 = i51 - i48 | 0;
   i51 = i56 >>> 0 > (i14 + 40 | 0) >>> 0;
   i50 = i51 ? i48 : -1;
   if ((i50 | 0) != -1) {
    i54 = i51 ? i56 : i57;
    i55 = i50;
    i45 = 201;
   }
  }
 } while (0);
 do {
  if ((i45 | 0) == 201) {
   i57 = (HEAP32[3124] | 0) + i54 | 0;
   HEAP32[3124] = i57;
   if (i57 >>> 0 > (HEAP32[3125] | 0) >>> 0) {
    HEAP32[3125] = i57;
   }
   i57 = HEAP32[3022] | 0;
   L310 : do {
    if ((i57 | 0) == 0) {
     i44 = HEAP32[3020] | 0;
     if ((i44 | 0) == 0 | i55 >>> 0 < i44 >>> 0) {
      HEAP32[3020] = i55;
     }
     HEAP32[3128] = i55;
     HEAP32[3129] = i54;
     HEAP32[3131] = 0;
     HEAP32[3025] = HEAP32[2976];
     HEAP32[3024] = -1;
     i44 = 0;
     do {
      i50 = i44 << 1;
      i56 = 12104 + (i50 << 2) | 0;
      HEAP32[12104 + (i50 + 3 << 2) >> 2] = i56;
      HEAP32[12104 + (i50 + 2 << 2) >> 2] = i56;
      i44 = i44 + 1 | 0;
     } while (i44 >>> 0 < 32);
     i44 = i55 + 8 | 0;
     if ((i44 & 7 | 0) == 0) {
      i58 = 0;
     } else {
      i58 = -i44 & 7;
     }
     i44 = i54 - 40 - i58 | 0;
     HEAP32[3022] = i55 + i58;
     HEAP32[3019] = i44;
     HEAP32[i55 + (i58 + 4) >> 2] = i44 | 1;
     HEAP32[i55 + (i54 - 36) >> 2] = 40;
     HEAP32[3023] = HEAP32[2980];
    } else {
     i44 = 12512;
     while (1) {
      i59 = HEAP32[i44 >> 2] | 0;
      i60 = i44 + 4 | 0;
      i61 = HEAP32[i60 >> 2] | 0;
      if ((i55 | 0) == (i59 + i61 | 0)) {
       i45 = 213;
       break;
      }
      i56 = HEAP32[i44 + 8 >> 2] | 0;
      if ((i56 | 0) == 0) {
       break;
      } else {
       i44 = i56;
      }
     }
     do {
      if ((i45 | 0) == 213) {
       if ((HEAP32[i44 + 12 >> 2] & 8 | 0) != 0) {
        break;
       }
       i56 = i57;
       if (!(i56 >>> 0 >= i59 >>> 0 & i56 >>> 0 < i55 >>> 0)) {
        break;
       }
       HEAP32[i60 >> 2] = i61 + i54;
       i56 = HEAP32[3022] | 0;
       i50 = (HEAP32[3019] | 0) + i54 | 0;
       i51 = i56;
       i48 = i56 + 8 | 0;
       if ((i48 & 7 | 0) == 0) {
        i62 = 0;
       } else {
        i62 = -i48 & 7;
       }
       i48 = i50 - i62 | 0;
       HEAP32[3022] = i51 + i62;
       HEAP32[3019] = i48;
       HEAP32[i51 + (i62 + 4) >> 2] = i48 | 1;
       HEAP32[i51 + (i50 + 4) >> 2] = 40;
       HEAP32[3023] = HEAP32[2980];
       break L310;
      }
     } while (0);
     if (i55 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
      HEAP32[3020] = i55;
     }
     i44 = i55 + i54 | 0;
     i50 = 12512;
     while (1) {
      i63 = i50 | 0;
      if ((HEAP32[i63 >> 2] | 0) == (i44 | 0)) {
       i45 = 223;
       break;
      }
      i51 = HEAP32[i50 + 8 >> 2] | 0;
      if ((i51 | 0) == 0) {
       break;
      } else {
       i50 = i51;
      }
     }
     do {
      if ((i45 | 0) == 223) {
       if ((HEAP32[i50 + 12 >> 2] & 8 | 0) != 0) {
        break;
       }
       HEAP32[i63 >> 2] = i55;
       i44 = i50 + 4 | 0;
       HEAP32[i44 >> 2] = (HEAP32[i44 >> 2] | 0) + i54;
       i44 = i55 + 8 | 0;
       if ((i44 & 7 | 0) == 0) {
        i64 = 0;
       } else {
        i64 = -i44 & 7;
       }
       i44 = i55 + (i54 + 8) | 0;
       if ((i44 & 7 | 0) == 0) {
        i65 = 0;
       } else {
        i65 = -i44 & 7;
       }
       i44 = i55 + (i65 + i54) | 0;
       i51 = i44;
       i48 = i64 + i14 | 0;
       i56 = i55 + i48 | 0;
       i52 = i56;
       i36 = i44 - (i55 + i64) - i14 | 0;
       HEAP32[i55 + (i64 + 4) >> 2] = i14 | 3;
       do {
        if ((i51 | 0) == (HEAP32[3022] | 0)) {
         i35 = (HEAP32[3019] | 0) + i36 | 0;
         HEAP32[3019] = i35;
         HEAP32[3022] = i52;
         HEAP32[i55 + (i48 + 4) >> 2] = i35 | 1;
        } else {
         if ((i51 | 0) == (HEAP32[3021] | 0)) {
          i35 = (HEAP32[3018] | 0) + i36 | 0;
          HEAP32[3018] = i35;
          HEAP32[3021] = i52;
          HEAP32[i55 + (i48 + 4) >> 2] = i35 | 1;
          HEAP32[i55 + (i35 + i48) >> 2] = i35;
          break;
         }
         i35 = i54 + 4 | 0;
         i49 = HEAP32[i55 + (i35 + i65) >> 2] | 0;
         if ((i49 & 3 | 0) == 1) {
          i53 = i49 & -8;
          i47 = i49 >>> 3;
          L355 : do {
           if (i49 >>> 0 < 256) {
            i46 = HEAP32[i55 + ((i65 | 8) + i54) >> 2] | 0;
            i42 = HEAP32[i55 + (i54 + 12 + i65) >> 2] | 0;
            i43 = 12104 + (i47 << 1 << 2) | 0;
            do {
             if ((i46 | 0) != (i43 | 0)) {
              if (i46 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
               _abort();
               return 0;
              }
              if ((HEAP32[i46 + 12 >> 2] | 0) == (i51 | 0)) {
               break;
              }
              _abort();
              return 0;
             }
            } while (0);
            if ((i42 | 0) == (i46 | 0)) {
             HEAP32[3016] = HEAP32[3016] & ~(1 << i47);
             break;
            }
            do {
             if ((i42 | 0) == (i43 | 0)) {
              i66 = i42 + 8 | 0;
             } else {
              if (i42 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
               _abort();
               return 0;
              }
              i12 = i42 + 8 | 0;
              if ((HEAP32[i12 >> 2] | 0) == (i51 | 0)) {
               i66 = i12;
               break;
              }
              _abort();
              return 0;
             }
            } while (0);
            HEAP32[i46 + 12 >> 2] = i42;
            HEAP32[i66 >> 2] = i46;
           } else {
            i43 = i44;
            i12 = HEAP32[i55 + ((i65 | 24) + i54) >> 2] | 0;
            i41 = HEAP32[i55 + (i54 + 12 + i65) >> 2] | 0;
            do {
             if ((i41 | 0) == (i43 | 0)) {
              i40 = i65 | 16;
              i6 = i55 + (i35 + i40) | 0;
              i37 = HEAP32[i6 >> 2] | 0;
              if ((i37 | 0) == 0) {
               i4 = i55 + (i40 + i54) | 0;
               i40 = HEAP32[i4 >> 2] | 0;
               if ((i40 | 0) == 0) {
                i67 = 0;
                break;
               } else {
                i68 = i40;
                i69 = i4;
               }
              } else {
               i68 = i37;
               i69 = i6;
              }
              while (1) {
               i6 = i68 + 20 | 0;
               i37 = HEAP32[i6 >> 2] | 0;
               if ((i37 | 0) != 0) {
                i68 = i37;
                i69 = i6;
                continue;
               }
               i6 = i68 + 16 | 0;
               i37 = HEAP32[i6 >> 2] | 0;
               if ((i37 | 0) == 0) {
                break;
               } else {
                i68 = i37;
                i69 = i6;
               }
              }
              if (i69 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
               _abort();
               return 0;
              } else {
               HEAP32[i69 >> 2] = 0;
               i67 = i68;
               break;
              }
             } else {
              i6 = HEAP32[i55 + ((i65 | 8) + i54) >> 2] | 0;
              if (i6 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
               _abort();
               return 0;
              }
              i37 = i6 + 12 | 0;
              if ((HEAP32[i37 >> 2] | 0) != (i43 | 0)) {
               _abort();
               return 0;
              }
              i4 = i41 + 8 | 0;
              if ((HEAP32[i4 >> 2] | 0) == (i43 | 0)) {
               HEAP32[i37 >> 2] = i41;
               HEAP32[i4 >> 2] = i6;
               i67 = i41;
               break;
              } else {
               _abort();
               return 0;
              }
             }
            } while (0);
            if ((i12 | 0) == 0) {
             break;
            }
            i41 = i55 + (i54 + 28 + i65) | 0;
            i46 = 12368 + (HEAP32[i41 >> 2] << 2) | 0;
            do {
             if ((i43 | 0) == (HEAP32[i46 >> 2] | 0)) {
              HEAP32[i46 >> 2] = i67;
              if ((i67 | 0) != 0) {
               break;
              }
              HEAP32[3017] = HEAP32[3017] & ~(1 << HEAP32[i41 >> 2]);
              break L355;
             } else {
              if (i12 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
               _abort();
               return 0;
              }
              i42 = i12 + 16 | 0;
              if ((HEAP32[i42 >> 2] | 0) == (i43 | 0)) {
               HEAP32[i42 >> 2] = i67;
              } else {
               HEAP32[i12 + 20 >> 2] = i67;
              }
              if ((i67 | 0) == 0) {
               break L355;
              }
             }
            } while (0);
            if (i67 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
             _abort();
             return 0;
            }
            HEAP32[i67 + 24 >> 2] = i12;
            i43 = i65 | 16;
            i41 = HEAP32[i55 + (i43 + i54) >> 2] | 0;
            do {
             if ((i41 | 0) != 0) {
              if (i41 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
               _abort();
               return 0;
              } else {
               HEAP32[i67 + 16 >> 2] = i41;
               HEAP32[i41 + 24 >> 2] = i67;
               break;
              }
             }
            } while (0);
            i41 = HEAP32[i55 + (i35 + i43) >> 2] | 0;
            if ((i41 | 0) == 0) {
             break;
            }
            if (i41 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
             _abort();
             return 0;
            } else {
             HEAP32[i67 + 20 >> 2] = i41;
             HEAP32[i41 + 24 >> 2] = i67;
             break;
            }
           }
          } while (0);
          i70 = i55 + ((i53 | i65) + i54) | 0;
          i71 = i53 + i36 | 0;
         } else {
          i70 = i51;
          i71 = i36;
         }
         i35 = i70 + 4 | 0;
         HEAP32[i35 >> 2] = HEAP32[i35 >> 2] & -2;
         HEAP32[i55 + (i48 + 4) >> 2] = i71 | 1;
         HEAP32[i55 + (i71 + i48) >> 2] = i71;
         i35 = i71 >>> 3;
         if (i71 >>> 0 < 256) {
          i47 = i35 << 1;
          i49 = 12104 + (i47 << 2) | 0;
          i41 = HEAP32[3016] | 0;
          i12 = 1 << i35;
          do {
           if ((i41 & i12 | 0) == 0) {
            HEAP32[3016] = i41 | i12;
            i72 = i49;
            i73 = 12104 + (i47 + 2 << 2) | 0;
           } else {
            i35 = 12104 + (i47 + 2 << 2) | 0;
            i46 = HEAP32[i35 >> 2] | 0;
            if (i46 >>> 0 >= (HEAP32[3020] | 0) >>> 0) {
             i72 = i46;
             i73 = i35;
             break;
            }
            _abort();
            return 0;
           }
          } while (0);
          HEAP32[i73 >> 2] = i52;
          HEAP32[i72 + 12 >> 2] = i52;
          HEAP32[i55 + (i48 + 8) >> 2] = i72;
          HEAP32[i55 + (i48 + 12) >> 2] = i49;
          break;
         }
         i47 = i56;
         i12 = i71 >>> 8;
         do {
          if ((i12 | 0) == 0) {
           i74 = 0;
          } else {
           if (i71 >>> 0 > 16777215) {
            i74 = 31;
            break;
           }
           i41 = (i12 + 1048320 | 0) >>> 16 & 8;
           i53 = i12 << i41;
           i35 = (i53 + 520192 | 0) >>> 16 & 4;
           i46 = i53 << i35;
           i53 = (i46 + 245760 | 0) >>> 16 & 2;
           i42 = 14 - (i35 | i41 | i53) + (i46 << i53 >>> 15) | 0;
           i74 = i71 >>> ((i42 + 7 | 0) >>> 0) & 1 | i42 << 1;
          }
         } while (0);
         i12 = 12368 + (i74 << 2) | 0;
         HEAP32[i55 + (i48 + 28) >> 2] = i74;
         HEAP32[i55 + (i48 + 20) >> 2] = 0;
         HEAP32[i55 + (i48 + 16) >> 2] = 0;
         i49 = HEAP32[3017] | 0;
         i42 = 1 << i74;
         if ((i49 & i42 | 0) == 0) {
          HEAP32[3017] = i49 | i42;
          HEAP32[i12 >> 2] = i47;
          HEAP32[i55 + (i48 + 24) >> 2] = i12;
          HEAP32[i55 + (i48 + 12) >> 2] = i47;
          HEAP32[i55 + (i48 + 8) >> 2] = i47;
          break;
         }
         if ((i74 | 0) == 31) {
          i75 = 0;
         } else {
          i75 = 25 - (i74 >>> 1) | 0;
         }
         i42 = i71 << i75;
         i49 = HEAP32[i12 >> 2] | 0;
         while (1) {
          if ((HEAP32[i49 + 4 >> 2] & -8 | 0) == (i71 | 0)) {
           break;
          }
          i76 = i49 + 16 + (i42 >>> 31 << 2) | 0;
          i12 = HEAP32[i76 >> 2] | 0;
          if ((i12 | 0) == 0) {
           i45 = 296;
           break;
          } else {
           i42 = i42 << 1;
           i49 = i12;
          }
         }
         if ((i45 | 0) == 296) {
          if (i76 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
           _abort();
           return 0;
          } else {
           HEAP32[i76 >> 2] = i47;
           HEAP32[i55 + (i48 + 24) >> 2] = i49;
           HEAP32[i55 + (i48 + 12) >> 2] = i47;
           HEAP32[i55 + (i48 + 8) >> 2] = i47;
           break;
          }
         }
         i42 = i49 + 8 | 0;
         i12 = HEAP32[i42 >> 2] | 0;
         i53 = HEAP32[3020] | 0;
         if (i49 >>> 0 < i53 >>> 0) {
          _abort();
          return 0;
         }
         if (i12 >>> 0 < i53 >>> 0) {
          _abort();
          return 0;
         } else {
          HEAP32[i12 + 12 >> 2] = i47;
          HEAP32[i42 >> 2] = i47;
          HEAP32[i55 + (i48 + 8) >> 2] = i12;
          HEAP32[i55 + (i48 + 12) >> 2] = i49;
          HEAP32[i55 + (i48 + 24) >> 2] = 0;
          break;
         }
        }
       } while (0);
       i13 = i55 + (i64 | 8) | 0;
       return i13 | 0;
      }
     } while (0);
     i50 = i57;
     i48 = 12512;
     while (1) {
      i77 = HEAP32[i48 >> 2] | 0;
      if (i77 >>> 0 <= i50 >>> 0) {
       i78 = HEAP32[i48 + 4 >> 2] | 0;
       i79 = i77 + i78 | 0;
       if (i79 >>> 0 > i50 >>> 0) {
        break;
       }
      }
      i48 = HEAP32[i48 + 8 >> 2] | 0;
     }
     i48 = i77 + (i78 - 39) | 0;
     if ((i48 & 7 | 0) == 0) {
      i80 = 0;
     } else {
      i80 = -i48 & 7;
     }
     i48 = i77 + (i78 - 47 + i80) | 0;
     i56 = i48 >>> 0 < (i57 + 16 | 0) >>> 0 ? i50 : i48;
     i48 = i56 + 8 | 0;
     i52 = i55 + 8 | 0;
     if ((i52 & 7 | 0) == 0) {
      i81 = 0;
     } else {
      i81 = -i52 & 7;
     }
     i52 = i54 - 40 - i81 | 0;
     HEAP32[3022] = i55 + i81;
     HEAP32[3019] = i52;
     HEAP32[i55 + (i81 + 4) >> 2] = i52 | 1;
     HEAP32[i55 + (i54 - 36) >> 2] = 40;
     HEAP32[3023] = HEAP32[2980];
     HEAP32[i56 + 4 >> 2] = 27;
     HEAP32[i48 >> 2] = HEAP32[3128];
     HEAP32[i48 + 4 >> 2] = HEAP32[12516 >> 2];
     HEAP32[i48 + 8 >> 2] = HEAP32[12520 >> 2];
     HEAP32[i48 + 12 >> 2] = HEAP32[12524 >> 2];
     HEAP32[3128] = i55;
     HEAP32[3129] = i54;
     HEAP32[3131] = 0;
     HEAP32[3130] = i48;
     i48 = i56 + 28 | 0;
     HEAP32[i48 >> 2] = 7;
     if ((i56 + 32 | 0) >>> 0 < i79 >>> 0) {
      i52 = i48;
      while (1) {
       i48 = i52 + 4 | 0;
       HEAP32[i48 >> 2] = 7;
       if ((i52 + 8 | 0) >>> 0 < i79 >>> 0) {
        i52 = i48;
       } else {
        break;
       }
      }
     }
     if ((i56 | 0) == (i50 | 0)) {
      break;
     }
     i52 = i56 - i57 | 0;
     i48 = i50 + (i52 + 4) | 0;
     HEAP32[i48 >> 2] = HEAP32[i48 >> 2] & -2;
     HEAP32[i57 + 4 >> 2] = i52 | 1;
     HEAP32[i50 + i52 >> 2] = i52;
     i48 = i52 >>> 3;
     if (i52 >>> 0 < 256) {
      i36 = i48 << 1;
      i51 = 12104 + (i36 << 2) | 0;
      i44 = HEAP32[3016] | 0;
      i12 = 1 << i48;
      do {
       if ((i44 & i12 | 0) == 0) {
        HEAP32[3016] = i44 | i12;
        i82 = i51;
        i83 = 12104 + (i36 + 2 << 2) | 0;
       } else {
        i48 = 12104 + (i36 + 2 << 2) | 0;
        i42 = HEAP32[i48 >> 2] | 0;
        if (i42 >>> 0 >= (HEAP32[3020] | 0) >>> 0) {
         i82 = i42;
         i83 = i48;
         break;
        }
        _abort();
        return 0;
       }
      } while (0);
      HEAP32[i83 >> 2] = i57;
      HEAP32[i82 + 12 >> 2] = i57;
      HEAP32[i57 + 8 >> 2] = i82;
      HEAP32[i57 + 12 >> 2] = i51;
      break;
     }
     i36 = i57;
     i12 = i52 >>> 8;
     do {
      if ((i12 | 0) == 0) {
       i84 = 0;
      } else {
       if (i52 >>> 0 > 16777215) {
        i84 = 31;
        break;
       }
       i44 = (i12 + 1048320 | 0) >>> 16 & 8;
       i50 = i12 << i44;
       i56 = (i50 + 520192 | 0) >>> 16 & 4;
       i48 = i50 << i56;
       i50 = (i48 + 245760 | 0) >>> 16 & 2;
       i42 = 14 - (i56 | i44 | i50) + (i48 << i50 >>> 15) | 0;
       i84 = i52 >>> ((i42 + 7 | 0) >>> 0) & 1 | i42 << 1;
      }
     } while (0);
     i12 = 12368 + (i84 << 2) | 0;
     HEAP32[i57 + 28 >> 2] = i84;
     HEAP32[i57 + 20 >> 2] = 0;
     HEAP32[i57 + 16 >> 2] = 0;
     i51 = HEAP32[3017] | 0;
     i42 = 1 << i84;
     if ((i51 & i42 | 0) == 0) {
      HEAP32[3017] = i51 | i42;
      HEAP32[i12 >> 2] = i36;
      HEAP32[i57 + 24 >> 2] = i12;
      HEAP32[i57 + 12 >> 2] = i57;
      HEAP32[i57 + 8 >> 2] = i57;
      break;
     }
     if ((i84 | 0) == 31) {
      i85 = 0;
     } else {
      i85 = 25 - (i84 >>> 1) | 0;
     }
     i42 = i52 << i85;
     i51 = HEAP32[i12 >> 2] | 0;
     while (1) {
      if ((HEAP32[i51 + 4 >> 2] & -8 | 0) == (i52 | 0)) {
       break;
      }
      i86 = i51 + 16 + (i42 >>> 31 << 2) | 0;
      i12 = HEAP32[i86 >> 2] | 0;
      if ((i12 | 0) == 0) {
       i45 = 331;
       break;
      } else {
       i42 = i42 << 1;
       i51 = i12;
      }
     }
     if ((i45 | 0) == 331) {
      if (i86 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
       _abort();
       return 0;
      } else {
       HEAP32[i86 >> 2] = i36;
       HEAP32[i57 + 24 >> 2] = i51;
       HEAP32[i57 + 12 >> 2] = i57;
       HEAP32[i57 + 8 >> 2] = i57;
       break;
      }
     }
     i42 = i51 + 8 | 0;
     i52 = HEAP32[i42 >> 2] | 0;
     i12 = HEAP32[3020] | 0;
     if (i51 >>> 0 < i12 >>> 0) {
      _abort();
      return 0;
     }
     if (i52 >>> 0 < i12 >>> 0) {
      _abort();
      return 0;
     } else {
      HEAP32[i52 + 12 >> 2] = i36;
      HEAP32[i42 >> 2] = i36;
      HEAP32[i57 + 8 >> 2] = i52;
      HEAP32[i57 + 12 >> 2] = i51;
      HEAP32[i57 + 24 >> 2] = 0;
      break;
     }
    }
   } while (0);
   i57 = HEAP32[3019] | 0;
   if (i57 >>> 0 <= i14 >>> 0) {
    break;
   }
   i52 = i57 - i14 | 0;
   HEAP32[3019] = i52;
   i57 = HEAP32[3022] | 0;
   i42 = i57;
   HEAP32[3022] = i42 + i14;
   HEAP32[i42 + (i14 + 4) >> 2] = i52 | 1;
   HEAP32[i57 + 4 >> 2] = i14 | 3;
   i13 = i57 + 8 | 0;
   return i13 | 0;
  }
 } while (0);
 HEAP32[(___errno_location() | 0) >> 2] = 12;
 i13 = 0;
 return i13 | 0;
}
function __Z8dBoxBox2RK9btVector3PKfS1_S1_S3_S1_RS_PfPiiP12dContactGeomiRN36btDiscreteCollisionDetectorInterface6ResultE(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 i7 = i7 | 0;
 i8 = i8 | 0;
 i9 = i9 | 0;
 i10 = i10 | 0;
 i11 = i11 | 0;
 i12 = i12 | 0;
 i13 = i13 | 0;
 var i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, d37 = 0.0, i38 = 0, d39 = 0.0, i40 = 0, d41 = 0.0, d42 = 0.0, d43 = 0.0, d44 = 0.0, d45 = 0.0, i46 = 0, d47 = 0.0, i48 = 0, d49 = 0.0, i50 = 0, d51 = 0.0, d52 = 0.0, i53 = 0, d54 = 0.0, i55 = 0, d56 = 0.0, i57 = 0, d58 = 0.0, d59 = 0.0, d60 = 0.0, i61 = 0, d62 = 0.0, d63 = 0.0, d64 = 0.0, d65 = 0.0, d66 = 0.0, d67 = 0.0, d68 = 0.0, d69 = 0.0, d70 = 0.0, d71 = 0.0, i72 = 0, d73 = 0.0, i74 = 0, d75 = 0.0, d76 = 0.0, i77 = 0, d78 = 0.0, i79 = 0, d80 = 0.0, i81 = 0, d82 = 0.0, d83 = 0.0, d84 = 0.0, d85 = 0.0, d86 = 0.0, d87 = 0.0, d88 = 0.0, d89 = 0.0, d90 = 0.0, d91 = 0.0, d92 = 0.0, d93 = 0.0, i94 = 0, i95 = 0, i96 = 0, i97 = 0, d98 = 0.0, i99 = 0, i100 = 0, i101 = 0, d102 = 0.0, i103 = 0, i104 = 0, i105 = 0, d106 = 0.0, i107 = 0, i108 = 0, i109 = 0, d110 = 0.0, i111 = 0, i112 = 0, i113 = 0, d114 = 0.0, i115 = 0, i116 = 0, i117 = 0, d118 = 0.0, i119 = 0, i120 = 0, i121 = 0, d122 = 0.0, d123 = 0.0, d124 = 0.0, d125 = 0.0, i126 = 0, i127 = 0, i128 = 0, d129 = 0.0, d130 = 0.0, d131 = 0.0, d132 = 0.0, i133 = 0, i134 = 0, i135 = 0, d136 = 0.0, d137 = 0.0, d138 = 0.0, d139 = 0.0, i140 = 0, i141 = 0, i142 = 0, d143 = 0.0, d144 = 0.0, d145 = 0.0, d146 = 0.0, i147 = 0, i148 = 0, i149 = 0, d150 = 0.0, d151 = 0.0, d152 = 0.0, d153 = 0.0, i154 = 0, i155 = 0, i156 = 0, d157 = 0.0, d158 = 0.0, d159 = 0.0, d160 = 0.0, i161 = 0, i162 = 0, i163 = 0, d164 = 0.0, d165 = 0.0, d166 = 0.0, d167 = 0.0, i168 = 0, i169 = 0, i170 = 0, d171 = 0.0, d172 = 0.0, d173 = 0.0, d174 = 0.0, i175 = 0, i176 = 0, i177 = 0, d178 = 0.0, d179 = 0.0, d180 = 0.0, d181 = 0.0, i182 = 0, i183 = 0, d184 = 0.0, d185 = 0.0, d186 = 0.0, d187 = 0.0, d188 = 0.0, d189 = 0.0, d190 = 0.0, d191 = 0.0, i192 = 0, i193 = 0, i194 = 0, i195 = 0, i196 = 0, i197 = 0, i198 = 0, i199 = 0, i200 = 0, d201 = 0.0, d202 = 0.0, d203 = 0.0, i204 = 0, i205 = 0, i206 = 0, i207 = 0, i208 = 0, i209 = 0, d210 = 0.0, d211 = 0.0, i212 = 0, i213 = 0, i214 = 0, i215 = 0, i216 = 0, i217 = 0, i218 = 0, i219 = 0, i220 = 0, i221 = 0, d222 = 0.0, d223 = 0.0, i224 = 0, i225 = 0, i226 = 0, i227 = 0, i228 = 0;
 i12 = STACKTOP;
 i11 = i4;
 i14 = STACKTOP;
 STACKTOP = STACKTOP + 64 | 0;
 i15 = STACKTOP;
 STACKTOP = STACKTOP + 12 | 0;
 STACKTOP = STACKTOP + 7 >> 3 << 3;
 i16 = STACKTOP;
 STACKTOP = STACKTOP + 12 | 0;
 STACKTOP = STACKTOP + 7 >> 3 << 3;
 i17 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i18 = i17;
 i19 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i20 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i21 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i22 = STACKTOP;
 STACKTOP = STACKTOP + 8 | 0;
 i23 = STACKTOP;
 STACKTOP = STACKTOP + 64 | 0;
 i24 = STACKTOP;
 STACKTOP = STACKTOP + 96 | 0;
 i25 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i26 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i27 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i28 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i29 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i30 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i31 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i32 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i33 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i34 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i35 = i4 | 0;
 i36 = i1 | 0;
 d37 = +HEAPF32[i35 >> 2] - +HEAPF32[i36 >> 2];
 i38 = i1 + 4 | 0;
 d39 = +HEAPF32[i4 + 4 >> 2] - +HEAPF32[i38 >> 2];
 i40 = i1 + 8 | 0;
 d41 = +HEAPF32[i4 + 8 >> 2] - +HEAPF32[i40 >> 2];
 d42 = +HEAPF32[i2 >> 2];
 i4 = i2 + 16 | 0;
 d43 = +HEAPF32[i4 >> 2];
 i1 = i2 + 32 | 0;
 d44 = +HEAPF32[i1 >> 2];
 d45 = d37 * d42 + d39 * d43 + d41 * d44;
 i46 = i2 + 4 | 0;
 d47 = +HEAPF32[i46 >> 2];
 i48 = i2 + 20 | 0;
 d49 = +HEAPF32[i48 >> 2];
 i50 = i2 + 36 | 0;
 d51 = +HEAPF32[i50 >> 2];
 d52 = d37 * d47 + d39 * d49 + d41 * d51;
 i53 = i2 + 8 | 0;
 d54 = +HEAPF32[i53 >> 2];
 i55 = i2 + 24 | 0;
 d56 = +HEAPF32[i55 >> 2];
 i57 = i2 + 40 | 0;
 d58 = +HEAPF32[i57 >> 2];
 d59 = d37 * d54 + d39 * d56 + d41 * d58;
 d60 = +HEAPF32[i3 >> 2] * .5;
 i61 = i15 | 0;
 HEAPF32[i61 >> 2] = d60;
 d62 = +HEAPF32[i3 + 4 >> 2] * .5;
 HEAPF32[i15 + 4 >> 2] = d62;
 d63 = +HEAPF32[i3 + 8 >> 2] * .5;
 HEAPF32[i15 + 8 >> 2] = d63;
 d64 = +HEAPF32[i6 >> 2] * .5;
 i15 = i16 | 0;
 HEAPF32[i15 >> 2] = d64;
 d65 = +HEAPF32[i6 + 4 >> 2] * .5;
 HEAPF32[i16 + 4 >> 2] = d65;
 d66 = +HEAPF32[i6 + 8 >> 2] * .5;
 HEAPF32[i16 + 8 >> 2] = d66;
 d67 = +HEAPF32[i5 >> 2];
 i16 = i5 + 16 | 0;
 d68 = +HEAPF32[i16 >> 2];
 i6 = i5 + 32 | 0;
 d69 = +HEAPF32[i6 >> 2];
 d70 = d42 * d67 + d43 * d68 + d44 * d69;
 i3 = i5 + 4 | 0;
 d71 = +HEAPF32[i3 >> 2];
 i72 = i5 + 20 | 0;
 d73 = +HEAPF32[i72 >> 2];
 i74 = i5 + 36 | 0;
 d75 = +HEAPF32[i74 >> 2];
 d76 = d42 * d71 + d43 * d73 + d44 * d75;
 i77 = i5 + 8 | 0;
 d78 = +HEAPF32[i77 >> 2];
 i79 = i5 + 24 | 0;
 d80 = +HEAPF32[i79 >> 2];
 i81 = i5 + 40 | 0;
 d82 = +HEAPF32[i81 >> 2];
 d83 = d42 * d78 + d43 * d80 + d44 * d82;
 d44 = d47 * d67 + d49 * d68 + d51 * d69;
 d43 = d47 * d71 + d49 * d73 + d51 * d75;
 d84 = d47 * d78 + d49 * d80 + d51 * d82;
 d51 = d54 * d67 + d56 * d68 + d58 * d69;
 d49 = d54 * d71 + d56 * d73 + d58 * d75;
 d85 = d54 * d78 + d56 * d80 + d58 * d82;
 d58 = +Math_abs(+d70);
 d56 = +Math_abs(+d76);
 d86 = +Math_abs(+d83);
 d87 = +Math_abs(+d44);
 d88 = +Math_abs(+d43);
 d89 = +Math_abs(+d84);
 d90 = +Math_abs(+d51);
 d91 = +Math_abs(+d49);
 d92 = +Math_abs(+d85);
 d93 = +Math_abs(+d45) - (d66 * d86 + (d60 + d64 * d58 + d65 * d56));
 if (d93 > 0.0) {
  i94 = 0;
  STACKTOP = i12;
  return i94 | 0;
 }
 if (d93 > -3.4028234663852886e+38) {
  i95 = i2;
  i96 = 1;
  i97 = d45 < 0.0 | 0;
  d98 = d93;
 } else {
  i95 = 0;
  i96 = 0;
  i97 = 0;
  d98 = -3.4028234663852886e+38;
 }
 d93 = +Math_abs(+d52) - (d62 + d64 * d87 + d65 * d88 + d66 * d89);
 if (d93 > 0.0) {
  i94 = 0;
  STACKTOP = i12;
  return i94 | 0;
 }
 if (d93 > d98) {
  i99 = i46;
  i100 = 2;
  i101 = d52 < 0.0 | 0;
  d102 = d93;
 } else {
  i99 = i95;
  i100 = i96;
  i101 = i97;
  d102 = d98;
 }
 d98 = +Math_abs(+d59) - (d63 + d64 * d90 + d65 * d91 + d66 * d92);
 if (d98 > 0.0) {
  i94 = 0;
  STACKTOP = i12;
  return i94 | 0;
 }
 if (d98 > d102) {
  i103 = i53;
  i104 = 3;
  i105 = d59 < 0.0 | 0;
  d106 = d98;
 } else {
  i103 = i99;
  i104 = i100;
  i105 = i101;
  d106 = d102;
 }
 d102 = d37 * d67 + d39 * d68 + d41 * d69;
 d69 = +Math_abs(+d102) - (d64 + (d60 * d58 + d62 * d87 + d63 * d90));
 if (d69 > 0.0) {
  i94 = 0;
  STACKTOP = i12;
  return i94 | 0;
 }
 if (d69 > d106) {
  i107 = i5;
  i108 = 4;
  i109 = d102 < 0.0 | 0;
  d110 = d69;
 } else {
  i107 = i103;
  i108 = i104;
  i109 = i105;
  d110 = d106;
 }
 d106 = d37 * d71 + d39 * d73 + d41 * d75;
 d75 = +Math_abs(+d106) - (d65 + (d60 * d56 + d62 * d88 + d63 * d91));
 if (d75 > 0.0) {
  i94 = 0;
  STACKTOP = i12;
  return i94 | 0;
 }
 if (d75 > d110) {
  i111 = i3;
  i112 = 5;
  i113 = d106 < 0.0 | 0;
  d114 = d75;
 } else {
  i111 = i107;
  i112 = i108;
  i113 = i109;
  d114 = d110;
 }
 d110 = d37 * d78 + d39 * d80 + d41 * d82;
 d82 = +Math_abs(+d110) - (d66 + (d60 * d86 + d62 * d89 + d63 * d92));
 if (d82 > 0.0) {
  i94 = 0;
  STACKTOP = i12;
  return i94 | 0;
 }
 if (d82 > d114) {
  i115 = i77;
  i116 = 6;
  i117 = d110 < 0.0 | 0;
  d118 = d82;
 } else {
  i115 = i111;
  i116 = i112;
  i117 = i113;
  d118 = d114;
 }
 d114 = d58 + 9999999747378752.0e-21;
 d58 = d56 + 9999999747378752.0e-21;
 d56 = d86 + 9999999747378752.0e-21;
 d86 = d87 + 9999999747378752.0e-21;
 d87 = d88 + 9999999747378752.0e-21;
 d88 = d89 + 9999999747378752.0e-21;
 d89 = d90 + 9999999747378752.0e-21;
 d90 = d91 + 9999999747378752.0e-21;
 d91 = d92 + 9999999747378752.0e-21;
 d92 = d59 * d44 - d52 * d51;
 d82 = +Math_abs(+d92) - (d66 * d58 + (d65 * d56 + (d63 * d86 + d62 * d89)));
 if (d82 > 1.1920928955078125e-7) {
  i94 = 0;
  STACKTOP = i12;
  return i94 | 0;
 }
 d110 = -0.0 - d51;
 d41 = d51 * d51 + 0.0;
 d80 = d44 * d44;
 d39 = +Math_sqrt(+(d80 + d41));
 do {
  if (d39 > 1.1920928955078125e-7) {
   d78 = d82 / d39;
   if (d78 * 1.0499999523162842 <= d118) {
    i119 = i115;
    i120 = i116;
    i121 = i117;
    d122 = d118;
    d123 = 0.0;
    d124 = 0.0;
    d125 = 0.0;
    break;
   }
   i119 = 0;
   i120 = 7;
   i121 = d92 < 0.0 | 0;
   d122 = d78;
   d123 = 0.0 / d39;
   d124 = d110 / d39;
   d125 = d44 / d39;
  } else {
   i119 = i115;
   i120 = i116;
   i121 = i117;
   d122 = d118;
   d123 = 0.0;
   d124 = 0.0;
   d125 = 0.0;
  }
 } while (0);
 d118 = d59 * d43 - d52 * d49;
 d39 = +Math_abs(+d118) - (d66 * d114 + (d64 * d56 + (d63 * d87 + d62 * d90)));
 if (d39 > 1.1920928955078125e-7) {
  i94 = 0;
  STACKTOP = i12;
  return i94 | 0;
 }
 d110 = -0.0 - d49;
 d92 = d49 * d49 + 0.0;
 d82 = d43 * d43;
 d78 = +Math_sqrt(+(d82 + d92));
 do {
  if (d78 > 1.1920928955078125e-7) {
   d37 = d39 / d78;
   if (d37 * 1.0499999523162842 <= d122) {
    i126 = i119;
    i127 = i120;
    i128 = i121;
    d129 = d122;
    d130 = d123;
    d131 = d124;
    d132 = d125;
    break;
   }
   i126 = 0;
   i127 = 8;
   i128 = d118 < 0.0 | 0;
   d129 = d37;
   d130 = 0.0 / d78;
   d131 = d110 / d78;
   d132 = d43 / d78;
  } else {
   i126 = i119;
   i127 = i120;
   i128 = i121;
   d129 = d122;
   d130 = d123;
   d131 = d124;
   d132 = d125;
  }
 } while (0);
 d125 = d59 * d84 - d52 * d85;
 d124 = +Math_abs(+d125) - (d65 * d114 + (d64 * d58 + (d63 * d88 + d62 * d91)));
 if (d124 > 1.1920928955078125e-7) {
  i94 = 0;
  STACKTOP = i12;
  return i94 | 0;
 }
 d123 = -0.0 - d85;
 d122 = d85 * d85 + 0.0;
 d78 = d84 * d84;
 d110 = +Math_sqrt(+(d78 + d122));
 do {
  if (d110 > 1.1920928955078125e-7) {
   d118 = d124 / d110;
   if (d118 * 1.0499999523162842 <= d129) {
    i133 = i126;
    i134 = i127;
    i135 = i128;
    d136 = d129;
    d137 = d130;
    d138 = d131;
    d139 = d132;
    break;
   }
   i133 = 0;
   i134 = 9;
   i135 = d125 < 0.0 | 0;
   d136 = d118;
   d137 = 0.0 / d110;
   d138 = d123 / d110;
   d139 = d84 / d110;
  } else {
   i133 = i126;
   i134 = i127;
   i135 = i128;
   d136 = d129;
   d137 = d130;
   d138 = d131;
   d139 = d132;
  }
 } while (0);
 d132 = d45 * d51 - d59 * d70;
 d131 = +Math_abs(+d132) - (d66 * d87 + (d65 * d88 + (d63 * d114 + d60 * d89)));
 if (d131 > 1.1920928955078125e-7) {
  i94 = 0;
  STACKTOP = i12;
  return i94 | 0;
 }
 d130 = -0.0 - d70;
 d129 = d70 * d70;
 d110 = +Math_sqrt(+(d129 + d41));
 do {
  if (d110 > 1.1920928955078125e-7) {
   d41 = d131 / d110;
   if (d41 * 1.0499999523162842 <= d136) {
    i140 = i133;
    i141 = i134;
    i142 = i135;
    d143 = d136;
    d144 = d137;
    d145 = d138;
    d146 = d139;
    break;
   }
   i140 = 0;
   i141 = 10;
   i142 = d132 < 0.0 | 0;
   d143 = d41;
   d144 = d51 / d110;
   d145 = 0.0 / d110;
   d146 = d130 / d110;
  } else {
   i140 = i133;
   i141 = i134;
   i142 = i135;
   d143 = d136;
   d144 = d137;
   d145 = d138;
   d146 = d139;
  }
 } while (0);
 d139 = d45 * d49 - d59 * d76;
 d138 = +Math_abs(+d139) - (d66 * d86 + (d64 * d88 + (d63 * d58 + d60 * d90)));
 if (d138 > 1.1920928955078125e-7) {
  i94 = 0;
  STACKTOP = i12;
  return i94 | 0;
 }
 d137 = -0.0 - d76;
 d136 = d76 * d76;
 d110 = +Math_sqrt(+(d136 + d92));
 do {
  if (d110 > 1.1920928955078125e-7) {
   d92 = d138 / d110;
   if (d92 * 1.0499999523162842 <= d143) {
    i147 = i140;
    i148 = i141;
    i149 = i142;
    d150 = d143;
    d151 = d144;
    d152 = d145;
    d153 = d146;
    break;
   }
   i147 = 0;
   i148 = 11;
   i149 = d139 < 0.0 | 0;
   d150 = d92;
   d151 = d49 / d110;
   d152 = 0.0 / d110;
   d153 = d137 / d110;
  } else {
   i147 = i140;
   i148 = i141;
   i149 = i142;
   d150 = d143;
   d151 = d144;
   d152 = d145;
   d153 = d146;
  }
 } while (0);
 d146 = d45 * d85 - d59 * d83;
 d59 = +Math_abs(+d146) - (d65 * d86 + (d64 * d87 + (d63 * d56 + d60 * d91)));
 if (d59 > 1.1920928955078125e-7) {
  i94 = 0;
  STACKTOP = i12;
  return i94 | 0;
 }
 d145 = -0.0 - d83;
 d144 = d83 * d83;
 d143 = +Math_sqrt(+(d144 + d122));
 do {
  if (d143 > 1.1920928955078125e-7) {
   d122 = d59 / d143;
   if (d122 * 1.0499999523162842 <= d150) {
    i154 = i147;
    i155 = i148;
    i156 = i149;
    d157 = d150;
    d158 = d151;
    d159 = d152;
    d160 = d153;
    break;
   }
   i154 = 0;
   i155 = 12;
   i156 = d146 < 0.0 | 0;
   d157 = d122;
   d158 = d85 / d143;
   d159 = 0.0 / d143;
   d160 = d145 / d143;
  } else {
   i154 = i147;
   i155 = i148;
   i156 = i149;
   d157 = d150;
   d158 = d151;
   d159 = d152;
   d160 = d153;
  }
 } while (0);
 d153 = d52 * d70 - d45 * d44;
 d152 = +Math_abs(+d153) - (d66 * d90 + (d62 * d114 + d60 * d86 + d65 * d91));
 if (d152 > 1.1920928955078125e-7) {
  i94 = 0;
  STACKTOP = i12;
  return i94 | 0;
 }
 d86 = -0.0 - d44;
 d44 = +Math_sqrt(+(d129 + d80 + 0.0));
 do {
  if (d44 > 1.1920928955078125e-7) {
   d80 = d152 / d44;
   if (d80 * 1.0499999523162842 <= d157) {
    i161 = i154;
    i162 = i155;
    i163 = i156;
    d164 = d157;
    d165 = d158;
    d166 = d159;
    d167 = d160;
    break;
   }
   i161 = 0;
   i162 = 13;
   i163 = d153 < 0.0 | 0;
   d164 = d80;
   d165 = d86 / d44;
   d166 = d70 / d44;
   d167 = 0.0 / d44;
  } else {
   i161 = i154;
   i162 = i155;
   i163 = i156;
   d164 = d157;
   d165 = d158;
   d166 = d159;
   d167 = d160;
  }
 } while (0);
 d160 = d52 * d76 - d45 * d43;
 d159 = +Math_abs(+d160) - (d66 * d89 + (d62 * d58 + d60 * d87 + d64 * d91));
 if (d159 > 1.1920928955078125e-7) {
  i94 = 0;
  STACKTOP = i12;
  return i94 | 0;
 }
 d91 = -0.0 - d43;
 d43 = +Math_sqrt(+(d136 + d82 + 0.0));
 do {
  if (d43 > 1.1920928955078125e-7) {
   d82 = d159 / d43;
   if (d82 * 1.0499999523162842 <= d164) {
    i168 = i161;
    i169 = i162;
    i170 = i163;
    d171 = d164;
    d172 = d165;
    d173 = d166;
    d174 = d167;
    break;
   }
   i168 = 0;
   i169 = 14;
   i170 = d160 < 0.0 | 0;
   d171 = d82;
   d172 = d91 / d43;
   d173 = d76 / d43;
   d174 = 0.0 / d43;
  } else {
   i168 = i161;
   i169 = i162;
   i170 = i163;
   d171 = d164;
   d172 = d165;
   d173 = d166;
   d174 = d167;
  }
 } while (0);
 d167 = d52 * d83 - d45 * d84;
 d45 = +Math_abs(+d167) - (d65 * d89 + (d62 * d56 + d60 * d88 + d64 * d90));
 if (d45 > 1.1920928955078125e-7) {
  i94 = 0;
  STACKTOP = i12;
  return i94 | 0;
 }
 d90 = -0.0 - d84;
 d84 = +Math_sqrt(+(d144 + d78 + 0.0));
 do {
  if (d84 > 1.1920928955078125e-7) {
   d78 = d45 / d84;
   if (d78 * 1.0499999523162842 <= d171) {
    i175 = 899;
    break;
   }
   i176 = 15;
   i177 = d167 < 0.0 | 0;
   d178 = d78;
   d179 = d90 / d84;
   d180 = d83 / d84;
   d181 = 0.0 / d84;
   i175 = 902;
  } else {
   i175 = 899;
  }
 } while (0);
 do {
  if ((i175 | 0) == 899) {
   if ((i169 | 0) == 0) {
    i94 = 0;
    STACKTOP = i12;
    return i94 | 0;
   }
   if ((i168 | 0) == 0) {
    i176 = i169;
    i177 = i170;
    d178 = d171;
    d179 = d172;
    d180 = d173;
    d181 = d174;
    i175 = 902;
    break;
   }
   d84 = +HEAPF32[i168 >> 2];
   HEAPF32[i7 >> 2] = d84;
   d83 = +HEAPF32[i168 + 16 >> 2];
   HEAPF32[i7 + 4 >> 2] = d83;
   d90 = +HEAPF32[i168 + 32 >> 2];
   HEAPF32[i7 + 8 >> 2] = d90;
   i182 = i169;
   i183 = i170;
   d184 = d171;
   d185 = d84;
   d186 = d83;
   d187 = d90;
  }
 } while (0);
 if ((i175 | 0) == 902) {
  d171 = d54 * d181 + (d47 * d180 + d42 * d179);
  HEAPF32[i7 >> 2] = d171;
  d42 = d179 * +HEAPF32[i4 >> 2] + d180 * +HEAPF32[i48 >> 2] + d181 * +HEAPF32[i55 >> 2];
  HEAPF32[i7 + 4 >> 2] = d42;
  d47 = d179 * +HEAPF32[i1 >> 2] + d180 * +HEAPF32[i50 >> 2] + d181 * +HEAPF32[i57 >> 2];
  HEAPF32[i7 + 8 >> 2] = d47;
  i182 = i176;
  i183 = i177;
  d184 = d178;
  d185 = d171;
  d186 = d42;
  d187 = d47;
 }
 if ((i183 | 0) != 0) {
  HEAPF32[i7 >> 2] = -0.0 - d185;
  HEAPF32[i7 + 4 >> 2] = -0.0 - d186;
  HEAPF32[i7 + 8 >> 2] = -0.0 - d187;
 }
 HEAPF32[i8 >> 2] = -0.0 - d184;
 if ((i182 | 0) > 6) {
  d187 = +HEAPF32[i7 >> 2];
  d186 = +HEAPF32[i7 + 4 >> 2];
  d185 = +HEAPF32[i7 + 8 >> 2];
  d47 = +HEAPF32[i2 >> 2];
  d42 = +HEAPF32[i4 >> 2];
  d171 = +HEAPF32[i1 >> 2];
  d178 = d60 * (d187 * d47 + d186 * d42 + d185 * d171 > 0.0 ? 1.0 : -1.0);
  d60 = +HEAPF32[i46 >> 2];
  d181 = +HEAPF32[i48 >> 2];
  d180 = +HEAPF32[i50 >> 2];
  d179 = d62 * (d187 * d60 + d186 * d181 + d185 * d180 > 0.0 ? 1.0 : -1.0);
  d62 = +HEAPF32[i53 >> 2];
  d54 = +HEAPF32[i55 >> 2];
  d174 = +HEAPF32[i57 >> 2];
  d173 = d63 * (d187 * d62 + d186 * d54 + d185 * d174 > 0.0 ? 1.0 : -1.0);
  d63 = +HEAPF32[i36 >> 2] + d47 * d178 + d60 * d179 + d62 * d173;
  d62 = +HEAPF32[i38 >> 2] + d42 * d178 + d181 * d179 + d54 * d173;
  d54 = +HEAPF32[i40 >> 2] + d171 * d178 + d180 * d179 + d174 * d173;
  HEAP32[i18 >> 2] = HEAP32[i11 >> 2];
  HEAP32[i18 + 4 >> 2] = HEAP32[i11 + 4 >> 2];
  HEAP32[i18 + 8 >> 2] = HEAP32[i11 + 8 >> 2];
  d173 = +HEAPF32[i5 >> 2];
  d174 = +HEAPF32[i16 >> 2];
  d179 = +HEAPF32[i6 >> 2];
  d180 = d64 * (d187 * d173 + d186 * d174 + d185 * d179 > 0.0 ? -1.0 : 1.0);
  i6 = i17 | 0;
  i16 = i17 + 4 | 0;
  i11 = i17 + 8 | 0;
  d64 = +HEAPF32[i3 >> 2];
  d178 = +HEAPF32[i72 >> 2];
  d171 = +HEAPF32[i74 >> 2];
  d181 = d65 * (d187 * d64 + d186 * d178 + d185 * d171 > 0.0 ? -1.0 : 1.0);
  d65 = +HEAPF32[i16 >> 2] + d174 * d180 + d178 * d181;
  d178 = +HEAPF32[i11 >> 2] + d179 * d180 + d171 * d181;
  d171 = +HEAPF32[i77 >> 2];
  d179 = +HEAPF32[i79 >> 2];
  d174 = +HEAPF32[i81 >> 2];
  d42 = d66 * (d187 * d171 + d186 * d179 + d185 * d174 > 0.0 ? -1.0 : 1.0);
  d66 = +HEAPF32[i6 >> 2] + d173 * d180 + d64 * d181 + d171 * d42;
  HEAPF32[i6 >> 2] = d66;
  d171 = d65 + d179 * d42;
  HEAPF32[i16 >> 2] = d171;
  d179 = d178 + d174 * d42;
  HEAPF32[i11 >> 2] = d179;
  i81 = i182 - 7 | 0;
  i79 = (i81 | 0) / 3 | 0;
  d42 = +HEAPF32[i2 + (i79 << 2) >> 2];
  d174 = +HEAPF32[i2 + (i79 + 4 << 2) >> 2];
  d178 = +HEAPF32[i2 + (i79 + 8 << 2) >> 2];
  i79 = (i81 | 0) % 3 | 0;
  d65 = +HEAPF32[i5 + (i79 << 2) >> 2];
  d181 = +HEAPF32[i5 + (i79 + 4 << 2) >> 2];
  d64 = +HEAPF32[i5 + (i79 + 8 << 2) >> 2];
  d180 = d66 - d63;
  d63 = d171 - d62;
  d62 = d179 - d54;
  d54 = d42 * d65 + d174 * d181 + d178 * d64;
  d173 = 1.0 - d54 * d54;
  if (d173 > 9999999747378752.0e-20) {
   d188 = (d54 * (d178 * d62 + (d42 * d180 + d174 * d63)) - (d62 * d64 + (d65 * d180 + d181 * d63))) * (1.0 / d173);
  } else {
   d188 = 0.0;
  }
  HEAPF32[i6 >> 2] = d66 + d65 * d188;
  HEAPF32[i16 >> 2] = d171 + d181 * d188;
  HEAPF32[i11 >> 2] = d179 + d64 * d188;
  i11 = HEAP32[(HEAP32[i13 >> 2] | 0) + 16 >> 2] | 0;
  HEAPF32[i19 >> 2] = -0.0 - d187;
  HEAPF32[i19 + 4 >> 2] = -0.0 - d186;
  HEAPF32[i19 + 8 >> 2] = -0.0 - d185;
  HEAPF32[i19 + 12 >> 2] = 0.0;
  FUNCTION_TABLE_viiif[i11 & 15](i13, i19, i17, d184);
  HEAP32[i9 >> 2] = i182;
  i94 = 1;
  STACKTOP = i12;
  return i94 | 0;
 }
 i17 = (i182 | 0) < 4;
 i19 = i7 | 0;
 d184 = +HEAPF32[i19 >> 2];
 if (i17) {
  d189 = d184;
  d190 = +HEAPF32[i7 + 4 >> 2];
  d191 = +HEAPF32[i7 + 8 >> 2];
  i192 = i2;
  i193 = i5;
  i194 = i36;
  i195 = i35;
  i196 = i61;
  i197 = i15;
 } else {
  d189 = -0.0 - d184;
  d190 = -0.0 - +HEAPF32[i7 + 4 >> 2];
  d191 = -0.0 - +HEAPF32[i7 + 8 >> 2];
  i192 = i5;
  i193 = i2;
  i194 = i35;
  i195 = i36;
  i196 = i15;
  i197 = i61;
 }
 d184 = d189 * +HEAPF32[i193 >> 2] + d190 * +HEAPF32[i193 + 16 >> 2] + d191 * +HEAPF32[i193 + 32 >> 2];
 HEAPF32[i20 >> 2] = d184;
 d185 = d189 * +HEAPF32[i193 + 4 >> 2] + d190 * +HEAPF32[i193 + 20 >> 2] + d191 * +HEAPF32[i193 + 36 >> 2];
 HEAPF32[i20 + 4 >> 2] = d185;
 d186 = d189 * +HEAPF32[i193 + 8 >> 2] + d190 * +HEAPF32[i193 + 24 >> 2] + d191 * +HEAPF32[i193 + 40 >> 2];
 HEAPF32[i20 + 8 >> 2] = d186;
 d187 = +Math_abs(+d184);
 d184 = +Math_abs(+d185);
 d185 = +Math_abs(+d186);
 if (d184 > d187) {
  i61 = d184 > d185;
  i198 = 0;
  i199 = i61 ? 1 : 2;
  i200 = i61;
 } else {
  i61 = d187 > d185;
  i198 = i61 & 1;
  i199 = i61 ? 0 : 2;
  i200 = i61;
 }
 i61 = i200 ? 2 : 1;
 d185 = +HEAPF32[i197 + (i199 << 2) >> 2];
 d187 = +HEAPF32[i195 >> 2] - +HEAPF32[i194 >> 2];
 d184 = d185 * +HEAPF32[i193 + (i199 << 2) >> 2];
 if (+HEAPF32[i20 + (i199 << 2) >> 2] < 0.0) {
  d201 = d187 + d184;
  d202 = +HEAPF32[i195 + 4 >> 2] - +HEAPF32[i194 + 4 >> 2] + d185 * +HEAPF32[i193 + ((i199 | 4) << 2) >> 2];
  d203 = +HEAPF32[i195 + 8 >> 2] - +HEAPF32[i194 + 8 >> 2] + d185 * +HEAPF32[i193 + ((i199 | 8) << 2) >> 2];
 } else {
  d201 = d187 - d184;
  d202 = +HEAPF32[i195 + 4 >> 2] - +HEAPF32[i194 + 4 >> 2] - d185 * +HEAPF32[i193 + ((i199 | 4) << 2) >> 2];
  d203 = +HEAPF32[i195 + 8 >> 2] - +HEAPF32[i194 + 8 >> 2] - d185 * +HEAPF32[i193 + ((i199 | 8) << 2) >> 2];
 }
 i199 = (i17 ? -1 : -4) + i182 | 0;
 if ((i199 | 0) == 1) {
  i204 = 2;
  i205 = 0;
 } else if ((i199 | 0) == 0) {
  i204 = 2;
  i205 = 1;
 } else {
  i204 = 1;
  i205 = 0;
 }
 d185 = +HEAPF32[i192 + (i205 << 2) >> 2];
 d184 = +HEAPF32[i192 + ((i205 | 4) << 2) >> 2];
 d187 = +HEAPF32[i192 + ((i205 | 8) << 2) >> 2];
 d186 = d201 * d185 + d202 * d184 + d203 * d187;
 d188 = +HEAPF32[i192 + (i204 << 2) >> 2];
 d64 = +HEAPF32[i192 + ((i204 | 4) << 2) >> 2];
 d179 = +HEAPF32[i192 + ((i204 | 8) << 2) >> 2];
 d181 = d201 * d188 + d202 * d64 + d203 * d179;
 i192 = i193 + (i198 << 2) | 0;
 d171 = +HEAPF32[i192 >> 2];
 i195 = i193 + ((i198 | 4) << 2) | 0;
 d65 = +HEAPF32[i195 >> 2];
 i20 = i193 + ((i198 | 8) << 2) | 0;
 d66 = +HEAPF32[i20 >> 2];
 d173 = d185 * d171 + d184 * d65 + d187 * d66;
 i200 = i193 + (i61 << 2) | 0;
 d63 = +HEAPF32[i200 >> 2];
 i15 = i193 + ((i61 | 4) << 2) | 0;
 d180 = +HEAPF32[i15 >> 2];
 i36 = i193 + ((i61 | 8) << 2) | 0;
 d62 = +HEAPF32[i36 >> 2];
 d174 = d185 * d63 + d184 * d180 + d187 * d62;
 d187 = d188 * d171 + d64 * d65 + d179 * d66;
 d66 = d188 * d63 + d64 * d180 + d179 * d62;
 d62 = +HEAPF32[i197 + (i198 << 2) >> 2];
 d179 = d173 * d62;
 d180 = d187 * d62;
 d62 = +HEAPF32[i197 + (i61 << 2) >> 2];
 d64 = d174 * d62;
 d63 = d66 * d62;
 d62 = d186 - d179;
 i61 = i21 | 0;
 HEAPF32[i61 >> 2] = d62 - d64;
 d188 = d181 - d180;
 HEAPF32[i21 + 4 >> 2] = d188 - d63;
 HEAPF32[i21 + 8 >> 2] = d62 + d64;
 HEAPF32[i21 + 12 >> 2] = d188 + d63;
 d188 = d186 + d179;
 HEAPF32[i21 + 16 >> 2] = d188 + d64;
 d179 = d181 + d180;
 HEAPF32[i21 + 20 >> 2] = d179 + d63;
 HEAPF32[i21 + 24 >> 2] = d188 - d64;
 HEAPF32[i21 + 28 >> 2] = d179 - d63;
 HEAPF32[i22 >> 2] = +HEAPF32[i196 + (i205 << 2) >> 2];
 HEAPF32[i22 + 4 >> 2] = +HEAPF32[i196 + (i204 << 2) >> 2];
 i204 = i23 | 0;
 i205 = i14 | 0;
 i14 = i61;
 i61 = i204;
 i21 = 0;
 i197 = 4;
 L1130 : while (1) {
  i198 = i22 + (i21 << 2) | 0;
  i193 = 1 - i21 | 0;
  do {
   if ((i197 | 0) > 0) {
    i35 = 0;
    i2 = i14;
    i5 = i61;
    i11 = i197;
    while (1) {
     i16 = i2 + (i21 << 2) | 0;
     d63 = +HEAPF32[i16 >> 2];
     d179 = +HEAPF32[i198 >> 2];
     if (d63 * -1.0 < d179) {
      HEAPF32[i5 >> 2] = +HEAPF32[i2 >> 2];
      HEAPF32[i5 + 4 >> 2] = +HEAPF32[i2 + 4 >> 2];
      i6 = i35 + 1 | 0;
      if ((i6 & 8 | 0) != 0) {
       i206 = i6;
       i207 = i61;
       break L1130;
      }
      i208 = i5 + 8 | 0;
      i209 = i6;
      d210 = +HEAPF32[i16 >> 2];
      d211 = +HEAPF32[i198 >> 2];
     } else {
      i208 = i5;
      i209 = i35;
      d210 = d63;
      d211 = d179;
     }
     i16 = i2 + 8 | 0;
     i6 = (i11 | 0) > 1 ? i16 : i14;
     d179 = +HEAPF32[i6 + (i21 << 2) >> 2];
     if (d210 * -1.0 < d211 ^ d179 * -1.0 < d211) {
      d63 = +HEAPF32[i2 + (i193 << 2) >> 2];
      HEAPF32[i208 + (i193 << 2) >> 2] = d63 + (d211 * -1.0 - d210) * ((+HEAPF32[i6 + (i193 << 2) >> 2] - d63) / (d179 - d210));
      HEAPF32[i208 + (i21 << 2) >> 2] = +HEAPF32[i198 >> 2] * -1.0;
      i6 = i209 + 1 | 0;
      if ((i6 & 8 | 0) == 0) {
       i212 = i208 + 8 | 0;
       i213 = i6;
      } else {
       i206 = i6;
       i207 = i61;
       break L1130;
      }
     } else {
      i212 = i208;
      i213 = i209;
     }
     i6 = i11 - 1 | 0;
     if ((i6 | 0) > 0) {
      i35 = i213;
      i2 = i16;
      i5 = i212;
      i11 = i6;
     } else {
      break;
     }
    }
    i11 = (i61 | 0) == (i204 | 0) ? i205 : i204;
    if ((i213 | 0) > 0) {
     i214 = 0;
     i215 = i61;
     i216 = i11;
     i217 = i213;
    } else {
     i218 = 0;
     i219 = i11;
     break;
    }
    while (1) {
     i5 = i215 + (i21 << 2) | 0;
     d179 = +HEAPF32[i5 >> 2];
     d63 = +HEAPF32[i198 >> 2];
     if (d179 < d63) {
      HEAPF32[i216 >> 2] = +HEAPF32[i215 >> 2];
      HEAPF32[i216 + 4 >> 2] = +HEAPF32[i215 + 4 >> 2];
      i2 = i214 + 1 | 0;
      if ((i2 & 8 | 0) != 0) {
       i206 = i2;
       i207 = i11;
       break L1130;
      }
      i220 = i216 + 8 | 0;
      i221 = i2;
      d222 = +HEAPF32[i5 >> 2];
      d223 = +HEAPF32[i198 >> 2];
     } else {
      i220 = i216;
      i221 = i214;
      d222 = d179;
      d223 = d63;
     }
     i5 = i215 + 8 | 0;
     i2 = (i217 | 0) > 1 ? i5 : i61;
     d63 = +HEAPF32[i2 + (i21 << 2) >> 2];
     if (d222 < d223 ^ d63 < d223) {
      d179 = +HEAPF32[i215 + (i193 << 2) >> 2];
      HEAPF32[i220 + (i193 << 2) >> 2] = d179 + (d223 - d222) * ((+HEAPF32[i2 + (i193 << 2) >> 2] - d179) / (d63 - d222));
      HEAPF32[i220 + (i21 << 2) >> 2] = +HEAPF32[i198 >> 2];
      i2 = i221 + 1 | 0;
      if ((i2 & 8 | 0) == 0) {
       i224 = i220 + 8 | 0;
       i225 = i2;
      } else {
       i206 = i2;
       i207 = i11;
       break L1130;
      }
     } else {
      i224 = i220;
      i225 = i221;
     }
     i2 = i217 - 1 | 0;
     if ((i2 | 0) > 0) {
      i214 = i225;
      i215 = i5;
      i216 = i224;
      i217 = i2;
     } else {
      i218 = i225;
      i219 = i11;
      break;
     }
    }
   } else {
    i218 = 0;
    i219 = (i61 | 0) == (i204 | 0) ? i205 : i204;
   }
  } while (0);
  i198 = i21 + 1 | 0;
  if ((i198 | 0) < 2) {
   i14 = i219;
   i61 = (i219 | 0) == (i204 | 0) ? i205 : i204;
   i21 = i198;
   i197 = i218;
  } else {
   i206 = i218;
   i207 = i219;
   break;
  }
 }
 if ((i207 | 0) != (i204 | 0)) {
  i219 = i23;
  i218 = i207;
  i207 = i206 << 3;
  _memcpy(i219 | 0, i218 | 0, i207) | 0;
 }
 if ((i206 | 0) < 1) {
  i94 = 0;
  STACKTOP = i12;
  return i94 | 0;
 }
 d222 = 1.0 / (d173 * d66 - d187 * d174);
 d223 = d173 * d222;
 d173 = d174 * d222;
 d174 = d66 * d222;
 d66 = -0.0 - d187 * d222;
 d222 = +HEAPF32[i196 + (i199 << 2) >> 2];
 d187 = +HEAPF32[i192 >> 2];
 d210 = +HEAPF32[i200 >> 2];
 d211 = +HEAPF32[i195 >> 2];
 d63 = +HEAPF32[i15 >> 2];
 d179 = +HEAPF32[i20 >> 2];
 d64 = +HEAPF32[i36 >> 2];
 i36 = 0;
 i20 = 0;
 while (1) {
  i15 = i36 << 1;
  d188 = +HEAPF32[i23 + (i15 << 2) >> 2];
  d180 = d188 - d186;
  d62 = +HEAPF32[i23 + ((i15 | 1) << 2) >> 2];
  d65 = d62 - d181;
  d171 = d174 * d180 - d173 * d65;
  d184 = d180 * d66 + d223 * d65;
  i15 = i20 * 3 | 0;
  d65 = d210 * d184 + (d201 + d187 * d171);
  HEAPF32[i24 + (i15 << 2) >> 2] = d65;
  d180 = d63 * d184 + (d202 + d211 * d171);
  HEAPF32[i24 + (i15 + 1 << 2) >> 2] = d180;
  d185 = d64 * d184 + (d203 + d179 * d171);
  HEAPF32[i24 + (i15 + 2 << 2) >> 2] = d185;
  d171 = d222 - (d189 * d65 + d190 * d180 + d191 * d185);
  HEAPF32[i25 + (i20 << 2) >> 2] = d171;
  if (d171 < 0.0) {
   i226 = i20;
  } else {
   i15 = i20 << 1;
   HEAPF32[i23 + (i15 << 2) >> 2] = d188;
   HEAPF32[i23 + ((i15 | 1) << 2) >> 2] = d62;
   i226 = i20 + 1 | 0;
  }
  i15 = i36 + 1 | 0;
  if ((i15 | 0) < (i206 | 0)) {
   i36 = i15;
   i20 = i226;
  } else {
   break;
  }
 }
 if ((i226 | 0) < 1) {
  i94 = 0;
  STACKTOP = i12;
  return i94 | 0;
 }
 i20 = (i226 | 0) < (i10 | 0) ? i226 : i10;
 i10 = (i20 | 0) < 1 ? 1 : i20;
 do {
  if ((i226 | 0) > (i10 | 0)) {
   if ((i226 | 0) > 1) {
    i20 = 1;
    i36 = 0;
    d191 = +HEAPF32[i25 >> 2];
    while (1) {
     d190 = +HEAPF32[i25 + (i20 << 2) >> 2];
     i206 = d190 > d191;
     i23 = i206 ? i20 : i36;
     i15 = i20 + 1 | 0;
     if ((i15 | 0) < (i226 | 0)) {
      i20 = i15;
      i36 = i23;
      d191 = i206 ? d190 : d191;
     } else {
      i227 = i23;
      break;
     }
    }
   } else {
    i227 = 0;
   }
   __Z11cullPoints2iPfiiPi(i226, i204, i10, i227, i30 | 0);
   if ((i10 | 0) <= 0) {
    i228 = i10;
    break;
   }
   i36 = i13;
   i20 = i7 + 4 | 0;
   i23 = i7 + 8 | 0;
   i206 = i32 | 0;
   i15 = i32 + 4 | 0;
   i195 = i32 + 8 | 0;
   i200 = i32 + 12 | 0;
   i192 = i33 | 0;
   i199 = i33 + 4 | 0;
   i196 = i33 + 8 | 0;
   i207 = i33 + 12 | 0;
   i218 = i31 | 0;
   i219 = i31 + 4 | 0;
   i197 = i31 + 8 | 0;
   i21 = i34 | 0;
   i205 = i34 + 4 | 0;
   i61 = i34 + 8 | 0;
   i14 = i34 + 12 | 0;
   i225 = i194 + 4 | 0;
   i217 = i194 + 8 | 0;
   if (i17) {
    i224 = 0;
    while (1) {
     i216 = HEAP32[i30 + (i224 << 2) >> 2] | 0;
     i215 = i216 * 3 | 0;
     HEAPF32[i218 >> 2] = +HEAPF32[i24 + (i215 << 2) >> 2] + +HEAPF32[i194 >> 2];
     HEAPF32[i219 >> 2] = +HEAPF32[i24 + (i215 + 1 << 2) >> 2] + +HEAPF32[i225 >> 2];
     HEAPF32[i197 >> 2] = +HEAPF32[i24 + (i215 + 2 << 2) >> 2] + +HEAPF32[i217 >> 2];
     d191 = -0.0 - +HEAPF32[i23 >> 2];
     d190 = -0.0 - +HEAPF32[i20 >> 2];
     i215 = HEAP32[(HEAP32[i36 >> 2] | 0) + 16 >> 2] | 0;
     HEAPF32[i206 >> 2] = -0.0 - +HEAPF32[i19 >> 2];
     HEAPF32[i15 >> 2] = d190;
     HEAPF32[i195 >> 2] = d191;
     HEAPF32[i200 >> 2] = 0.0;
     FUNCTION_TABLE_viiif[i215 & 15](i13, i32, i31, -0.0 - +HEAPF32[i25 + (i216 << 2) >> 2]);
     i216 = i224 + 1 | 0;
     if ((i216 | 0) < (i10 | 0)) {
      i224 = i216;
     } else {
      i228 = i10;
      break;
     }
    }
   } else {
    i224 = 0;
    while (1) {
     i200 = HEAP32[i30 + (i224 << 2) >> 2] | 0;
     i195 = i200 * 3 | 0;
     d191 = +HEAPF32[i24 + (i195 << 2) >> 2] + +HEAPF32[i194 >> 2];
     HEAPF32[i218 >> 2] = d191;
     d190 = +HEAPF32[i24 + (i195 + 1 << 2) >> 2] + +HEAPF32[i225 >> 2];
     HEAPF32[i219 >> 2] = d190;
     d189 = +HEAPF32[i24 + (i195 + 2 << 2) >> 2] + +HEAPF32[i217 >> 2];
     HEAPF32[i197 >> 2] = d189;
     d222 = +HEAPF32[i19 >> 2];
     d179 = +HEAPF32[i20 >> 2];
     d203 = +HEAPF32[i23 >> 2];
     i195 = HEAP32[(HEAP32[i36 >> 2] | 0) + 16 >> 2] | 0;
     HEAPF32[i192 >> 2] = -0.0 - d222;
     HEAPF32[i199 >> 2] = -0.0 - d179;
     HEAPF32[i196 >> 2] = -0.0 - d203;
     HEAPF32[i207 >> 2] = 0.0;
     d64 = +HEAPF32[i25 + (i200 << 2) >> 2];
     HEAPF32[i21 >> 2] = d191 - d222 * d64;
     HEAPF32[i205 >> 2] = d190 - d179 * d64;
     HEAPF32[i61 >> 2] = d189 - d203 * d64;
     HEAPF32[i14 >> 2] = 0.0;
     FUNCTION_TABLE_viiif[i195 & 15](i13, i33, i34, -0.0 - d64);
     i195 = i224 + 1 | 0;
     if ((i195 | 0) < (i10 | 0)) {
      i224 = i195;
     } else {
      i228 = i10;
      break;
     }
    }
   }
  } else {
   i224 = (i226 | 0) > 0;
   if (i17) {
    if (!i224) {
     i228 = i226;
     break;
    }
    i14 = i13;
    i61 = i7 + 4 | 0;
    i205 = i7 + 8 | 0;
    i21 = i27 | 0;
    i207 = i27 + 4 | 0;
    i196 = i27 + 8 | 0;
    i199 = i27 + 12 | 0;
    i192 = i26 | 0;
    i36 = i194 + 4 | 0;
    i23 = i26 + 4 | 0;
    i20 = i194 + 8 | 0;
    i197 = i26 + 8 | 0;
    i217 = 0;
    while (1) {
     i219 = i217 * 3 | 0;
     HEAPF32[i192 >> 2] = +HEAPF32[i24 + (i219 << 2) >> 2] + +HEAPF32[i194 >> 2];
     HEAPF32[i23 >> 2] = +HEAPF32[i24 + (i219 + 1 << 2) >> 2] + +HEAPF32[i36 >> 2];
     HEAPF32[i197 >> 2] = +HEAPF32[i24 + (i219 + 2 << 2) >> 2] + +HEAPF32[i20 >> 2];
     i219 = HEAP32[(HEAP32[i14 >> 2] | 0) + 16 >> 2] | 0;
     d64 = -0.0 - +HEAPF32[i61 >> 2];
     d203 = -0.0 - +HEAPF32[i205 >> 2];
     HEAPF32[i21 >> 2] = -0.0 - +HEAPF32[i19 >> 2];
     HEAPF32[i207 >> 2] = d64;
     HEAPF32[i196 >> 2] = d203;
     HEAPF32[i199 >> 2] = 0.0;
     FUNCTION_TABLE_viiif[i219 & 15](i13, i27, i26, -0.0 - +HEAPF32[i25 + (i217 << 2) >> 2]);
     i219 = i217 + 1 | 0;
     if ((i219 | 0) < (i226 | 0)) {
      i217 = i219;
     } else {
      i228 = i226;
      break;
     }
    }
   } else {
    if (!i224) {
     i228 = i226;
     break;
    }
    i217 = i13;
    i199 = i7 + 4 | 0;
    i196 = i7 + 8 | 0;
    i207 = i29 | 0;
    i21 = i29 + 4 | 0;
    i205 = i29 + 8 | 0;
    i61 = i29 + 12 | 0;
    i14 = i28 | 0;
    i20 = i194 + 4 | 0;
    i197 = i28 + 4 | 0;
    i36 = i194 + 8 | 0;
    i23 = i28 + 8 | 0;
    i192 = 0;
    while (1) {
     i219 = i192 * 3 | 0;
     d203 = +HEAPF32[i25 + (i192 << 2) >> 2];
     d64 = +HEAPF32[i19 >> 2];
     HEAPF32[i14 >> 2] = +HEAPF32[i24 + (i219 << 2) >> 2] + +HEAPF32[i194 >> 2] - d203 * d64;
     d189 = +HEAPF32[i199 >> 2];
     HEAPF32[i197 >> 2] = +HEAPF32[i24 + (i219 + 1 << 2) >> 2] + +HEAPF32[i20 >> 2] - d203 * d189;
     d179 = +HEAPF32[i196 >> 2];
     HEAPF32[i23 >> 2] = +HEAPF32[i24 + (i219 + 2 << 2) >> 2] + +HEAPF32[i36 >> 2] - d203 * d179;
     i219 = HEAP32[(HEAP32[i217 >> 2] | 0) + 16 >> 2] | 0;
     HEAPF32[i207 >> 2] = -0.0 - d64;
     HEAPF32[i21 >> 2] = -0.0 - d189;
     HEAPF32[i205 >> 2] = -0.0 - d179;
     HEAPF32[i61 >> 2] = 0.0;
     FUNCTION_TABLE_viiif[i219 & 15](i13, i29, i28, -0.0 - d203);
     i219 = i192 + 1 | 0;
     if ((i219 | 0) < (i226 | 0)) {
      i192 = i219;
     } else {
      i228 = i226;
      break;
     }
    }
   }
  }
 } while (0);
 HEAP32[i9 >> 2] = i182;
 i94 = i228;
 STACKTOP = i12;
 return i94 | 0;
}
function __ZN23btConvexConvexAlgorithm16processCollisionEP17btCollisionObjectS1_RK16btDispatcherInfoP16btManifoldResult(i1, i2, i3, i4, i5) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 var i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, d31 = 0.0, d32 = 0.0, d33 = 0.0, d34 = 0.0, d35 = 0.0, d36 = 0.0, d37 = 0.0, d38 = 0.0, d39 = 0.0, d40 = 0.0, d41 = 0.0, d42 = 0.0, d43 = 0.0, d44 = 0.0, d45 = 0.0, d46 = 0.0, d47 = 0.0, d48 = 0.0, d49 = 0.0, d50 = 0.0, d51 = 0.0, d52 = 0.0, d53 = 0.0, d54 = 0.0, d55 = 0.0, d56 = 0.0, d57 = 0.0, d58 = 0.0, d59 = 0.0, d60 = 0.0, d61 = 0.0, d62 = 0.0, d63 = 0.0, d64 = 0.0, i65 = 0, i66 = 0, i67 = 0, i68 = 0, i69 = 0, i70 = 0, i71 = 0, i72 = 0, i73 = 0, i74 = 0, i75 = 0, i76 = 0, i77 = 0, d78 = 0.0, i79 = 0, i80 = 0, i81 = 0, i82 = 0, i83 = 0, i84 = 0, i85 = 0, i86 = 0, i87 = 0, i88 = 0, i89 = 0, i90 = 0, i91 = 0, i92 = 0, i93 = 0, i94 = 0, i95 = 0, i96 = 0, i97 = 0, i98 = 0, i99 = 0, i100 = 0, i101 = 0, i102 = 0, i103 = 0, i104 = 0, i105 = 0, i106 = 0, i107 = 0, i108 = 0, i109 = 0, i110 = 0, i111 = 0, i112 = 0, d113 = 0.0, d114 = 0.0, d115 = 0.0, i116 = 0, i117 = 0, i118 = 0, i119 = 0, i120 = 0, i121 = 0, i122 = 0, i123 = 0, i124 = 0, i125 = 0, i126 = 0, i127 = 0, i128 = 0, i129 = 0, i130 = 0, i131 = 0, i132 = 0, i133 = 0, i134 = 0, i135 = 0, i136 = 0, i137 = 0, i138 = 0, i139 = 0, i140 = 0, i141 = 0, i142 = 0, i143 = 0, i144 = 0, i145 = 0, i146 = 0, i147 = 0, i148 = 0;
 i6 = STACKTOP;
 STACKTOP = STACKTOP + 744 | 0;
 i7 = i6 | 0;
 i8 = i6 + 16 | 0;
 i9 = i6 + 32 | 0;
 i10 = i6 + 168 | 0;
 i11 = i6 + 248 | 0;
 i12 = i6 + 256 | 0;
 i13 = i6 + 272 | 0;
 i14 = i6 + 288 | 0;
 i15 = i6 + 312 | 0;
 i16 = i6 + 328 | 0;
 i17 = i6 + 344 | 0;
 i18 = i6 + 360 | 0;
 i19 = i6 + 376 | 0;
 i20 = i1 + 20 | 0;
 i21 = HEAP32[i20 >> 2] | 0;
 if ((i21 | 0) == 0) {
  i22 = HEAP32[i1 + 4 >> 2] | 0;
  i23 = FUNCTION_TABLE_iiii[HEAP32[(HEAP32[i22 >> 2] | 0) + 12 >> 2] & 31](i22, i2, i3) | 0;
  HEAP32[i20 >> 2] = i23;
  HEAP8[i1 + 16 | 0] = 1;
  i24 = i23;
 } else {
  i24 = i21;
 }
 i21 = i5 + 4 | 0;
 HEAP32[i21 >> 2] = i24;
 i24 = HEAP32[i2 + 192 >> 2] | 0;
 i23 = i24;
 i22 = HEAP32[i3 + 192 >> 2] | 0;
 i25 = i22;
 i26 = i24 + 4 | 0;
 do {
  if ((HEAP32[i26 >> 2] | 0) == 10) {
   if ((HEAP32[i22 + 4 >> 2] | 0) != 10) {
    break;
   }
   i27 = i24;
   i28 = i22;
   i29 = i24;
   i30 = HEAP32[(HEAP32[i24 >> 2] | 0) + 28 >> 2] | 0;
   FUNCTION_TABLE_ii[i30 & 127](i29) | 0;
   i29 = i22;
   i30 = HEAP32[(HEAP32[i22 >> 2] | 0) + 28 >> 2] | 0;
   FUNCTION_TABLE_ii[i30 & 127](i29) | 0;
   d31 = +__ZNK20btPersistentManifold27getContactBreakingThresholdEv(HEAP32[i20 >> 2] | 0);
   i29 = HEAP32[i24 + 52 >> 2] | 0;
   d32 = +HEAPF32[i27 + 28 + (i29 << 2) >> 2];
   d33 = +HEAPF32[i27 + 28 + (((i29 + 2 | 0) % 3 | 0) << 2) >> 2];
   i27 = HEAP32[i22 + 52 >> 2] | 0;
   d34 = +HEAPF32[i28 + 28 + (i27 << 2) >> 2];
   d35 = +HEAPF32[i28 + 28 + (((i27 + 2 | 0) % 3 | 0) << 2) >> 2];
   d36 = +HEAPF32[i2 + 4 + (i29 << 2) >> 2];
   d37 = +HEAPF32[i2 + 20 + (i29 << 2) >> 2];
   d38 = +HEAPF32[i2 + 36 + (i29 << 2) >> 2];
   d39 = +HEAPF32[i3 + 4 + (i27 << 2) >> 2];
   d40 = +HEAPF32[i3 + 20 + (i27 << 2) >> 2];
   d41 = +HEAPF32[i3 + 36 + (i27 << 2) >> 2];
   d42 = +HEAPF32[i3 + 52 >> 2];
   d43 = +HEAPF32[i3 + 56 >> 2];
   d44 = +HEAPF32[i3 + 60 >> 2];
   d45 = d42 - +HEAPF32[i2 + 52 >> 2];
   d46 = d43 - +HEAPF32[i2 + 56 >> 2];
   d47 = d44 - +HEAPF32[i2 + 60 >> 2];
   d48 = d36 * d39 + d37 * d40 + d38 * d41;
   d49 = d36 * d45 + d37 * d46 + d38 * d47;
   d50 = d39 * d45 + d40 * d46 + d41 * d47;
   d51 = 1.0 - d48 * d48;
   do {
    if (d51 == 0.0) {
     d52 = 0.0;
    } else {
     d53 = (d49 - d48 * d50) / d51;
     d54 = -0.0 - d32;
     if (d53 < d54) {
      d52 = d54;
      break;
     }
     if (d53 <= d32) {
      d52 = d53;
      break;
     }
     d52 = d32;
    }
   } while (0);
   d51 = d48 * d52 - d50;
   d53 = -0.0 - d34;
   do {
    if (d51 < d53) {
     d54 = d48 * d53 + d49;
     d55 = -0.0 - d32;
     if (d54 < d55) {
      d56 = d55;
      d57 = d53;
      break;
     }
     if (d54 <= d32) {
      d56 = d54;
      d57 = d53;
      break;
     }
     d56 = d32;
     d57 = d53;
    } else {
     if (d51 <= d34) {
      d56 = d52;
      d57 = d51;
      break;
     }
     d54 = d34 * d48 + d49;
     d55 = -0.0 - d32;
     if (d54 < d55) {
      d56 = d55;
      d57 = d34;
      break;
     }
     if (d54 <= d32) {
      d56 = d54;
      d57 = d34;
      break;
     }
     d56 = d32;
     d57 = d34;
    }
   } while (0);
   d34 = d39 * d57;
   d32 = d40 * d57;
   d49 = d41 * d57;
   d48 = d34 + (d45 - d36 * d56);
   d51 = d32 + (d46 - d37 * d56);
   d53 = d49 + (d47 - d38 * d56);
   d50 = d53 * d53 + (d48 * d48 + d51 * d51);
   d54 = +Math_sqrt(+d50);
   d55 = d54 - d33 - d35;
   if (d55 <= d31) {
    do {
     if (d50 > 1.4210854715202004e-14) {
      d58 = -0.0 - 1.0 / d54;
      d59 = d48 * d58;
      d60 = d51 * d58;
      d61 = d53 * d58;
      HEAPF32[i7 >> 2] = d59;
      HEAPF32[i7 + 4 >> 2] = d60;
      HEAPF32[i7 + 8 >> 2] = d61;
      HEAPF32[i7 + 12 >> 2] = 0.0;
      d62 = d59;
      d63 = d60;
      d64 = d61;
     } else {
      if (+Math_abs(+d38) > .7071067690849304) {
       d61 = 1.0 / +Math_sqrt(+(d37 * d37 + d38 * d38));
       HEAPF32[i7 >> 2] = 0.0;
       d60 = d61 * (-0.0 - d38);
       HEAPF32[i7 + 4 >> 2] = d60;
       d59 = d37 * d61;
       HEAPF32[i7 + 8 >> 2] = d59;
       d62 = 0.0;
       d63 = d60;
       d64 = d59;
       break;
      } else {
       d59 = 1.0 / +Math_sqrt(+(d36 * d36 + d37 * d37));
       d60 = d59 * (-0.0 - d37);
       HEAPF32[i7 >> 2] = d60;
       d61 = d36 * d59;
       HEAPF32[i7 + 4 >> 2] = d61;
       HEAPF32[i7 + 8 >> 2] = 0.0;
       d62 = d60;
       d63 = d61;
       d64 = 0.0;
       break;
      }
     }
    } while (0);
    HEAPF32[i8 >> 2] = d42 + d34 + d35 * d62;
    HEAPF32[i8 + 4 >> 2] = d43 + d32 + d35 * d63;
    HEAPF32[i8 + 8 >> 2] = d44 + d49 + d35 * d64;
    HEAPF32[i8 + 12 >> 2] = 0.0;
   }
   if (d55 < d31) {
    FUNCTION_TABLE_viiif[HEAP32[(HEAP32[i5 >> 2] | 0) + 16 >> 2] & 15](i5, i7, i8, d55);
   }
   i27 = HEAP32[i21 >> 2] | 0;
   if ((HEAP32[i27 + 1116 >> 2] | 0) == 0) {
    STACKTOP = i6;
    return;
   }
   if ((HEAP32[i27 + 1108 >> 2] | 0) == (HEAP32[i5 + 136 >> 2] | 0)) {
    __ZN20btPersistentManifold20refreshContactPointsERK11btTransformS2_(i27, i5 + 8 | 0, i5 + 72 | 0);
    STACKTOP = i6;
    return;
   } else {
    __ZN20btPersistentManifold20refreshContactPointsERK11btTransformS2_(i27, i5 + 72 | 0, i5 + 8 | 0);
    STACKTOP = i6;
    return;
   }
  }
 } while (0);
 i8 = i9 + 128 | 0;
 HEAPF32[i8 >> 2] = 999999984306749400.0;
 i7 = i9 + 132 | 0;
 HEAP32[i7 >> 2] = 0;
 __ZN17btGjkPairDetectorC2EPK13btConvexShapeS2_P22btVoronoiSimplexSolverP30btConvexPenetrationDepthSolver(i10, i23, i25, HEAP32[i1 + 8 >> 2] | 0, HEAP32[i1 + 12 >> 2] | 0);
 HEAP32[i10 + 28 >> 2] = i23;
 HEAP32[i10 + 32 >> 2] = i25;
 d64 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i24 >> 2] | 0) + 44 >> 2] & 7](i23);
 d63 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i22 >> 2] | 0) + 44 >> 2] & 7](i25);
 d62 = d64 + d63 + +__ZNK20btPersistentManifold27getContactBreakingThresholdEv(HEAP32[i20 >> 2] | 0);
 HEAPF32[i8 >> 2] = d62 * d62;
 HEAP32[i7 >> 2] = HEAP32[i4 + 40 >> 2];
 i7 = i2 + 4 | 0;
 i8 = i9;
 i25 = i7;
 HEAP32[i8 >> 2] = HEAP32[i25 >> 2];
 HEAP32[i8 + 4 >> 2] = HEAP32[i25 + 4 >> 2];
 HEAP32[i8 + 8 >> 2] = HEAP32[i25 + 8 >> 2];
 HEAP32[i8 + 12 >> 2] = HEAP32[i25 + 12 >> 2];
 i23 = i9 + 16 | 0;
 i27 = i2 + 20 | 0;
 HEAP32[i23 >> 2] = HEAP32[i27 >> 2];
 HEAP32[i23 + 4 >> 2] = HEAP32[i27 + 4 >> 2];
 HEAP32[i23 + 8 >> 2] = HEAP32[i27 + 8 >> 2];
 HEAP32[i23 + 12 >> 2] = HEAP32[i27 + 12 >> 2];
 i29 = i9 + 32 | 0;
 i28 = i2 + 36 | 0;
 HEAP32[i29 >> 2] = HEAP32[i28 >> 2];
 HEAP32[i29 + 4 >> 2] = HEAP32[i28 + 4 >> 2];
 HEAP32[i29 + 8 >> 2] = HEAP32[i28 + 8 >> 2];
 HEAP32[i29 + 12 >> 2] = HEAP32[i28 + 12 >> 2];
 i30 = i9 + 48 | 0;
 i65 = i2 + 52 | 0;
 HEAP32[i30 >> 2] = HEAP32[i65 >> 2];
 HEAP32[i30 + 4 >> 2] = HEAP32[i65 + 4 >> 2];
 HEAP32[i30 + 8 >> 2] = HEAP32[i65 + 8 >> 2];
 HEAP32[i30 + 12 >> 2] = HEAP32[i65 + 12 >> 2];
 i66 = i3 + 4 | 0;
 i67 = i9 + 64 | 0;
 i68 = i66;
 HEAP32[i67 >> 2] = HEAP32[i68 >> 2];
 HEAP32[i67 + 4 >> 2] = HEAP32[i68 + 4 >> 2];
 HEAP32[i67 + 8 >> 2] = HEAP32[i68 + 8 >> 2];
 HEAP32[i67 + 12 >> 2] = HEAP32[i68 + 12 >> 2];
 i69 = i9 + 80 | 0;
 i70 = i3 + 20 | 0;
 HEAP32[i69 >> 2] = HEAP32[i70 >> 2];
 HEAP32[i69 + 4 >> 2] = HEAP32[i70 + 4 >> 2];
 HEAP32[i69 + 8 >> 2] = HEAP32[i70 + 8 >> 2];
 HEAP32[i69 + 12 >> 2] = HEAP32[i70 + 12 >> 2];
 i71 = i9 + 96 | 0;
 i72 = i3 + 36 | 0;
 HEAP32[i71 >> 2] = HEAP32[i72 >> 2];
 HEAP32[i71 + 4 >> 2] = HEAP32[i72 + 4 >> 2];
 HEAP32[i71 + 8 >> 2] = HEAP32[i72 + 8 >> 2];
 HEAP32[i71 + 12 >> 2] = HEAP32[i72 + 12 >> 2];
 i73 = i9 + 112 | 0;
 i74 = i3 + 52 | 0;
 HEAP32[i73 >> 2] = HEAP32[i74 >> 2];
 HEAP32[i73 + 4 >> 2] = HEAP32[i74 + 4 >> 2];
 HEAP32[i73 + 8 >> 2] = HEAP32[i74 + 8 >> 2];
 HEAP32[i73 + 12 >> 2] = HEAP32[i74 + 12 >> 2];
 do {
  if ((HEAP32[i26 >> 2] | 0) < 7) {
   i75 = HEAP32[i22 + 4 >> 2] | 0;
   if ((i75 | 0) >= 7) {
    break;
   }
   HEAP32[i11 >> 2] = 1552;
   i76 = i24 + 52 | 0;
   if ((HEAP32[i76 >> 2] | 0) == 0) {
    break;
   }
   i77 = i22 + 52 | 0;
   if ((HEAP32[i77 >> 2] | 0) != 0) {
    __ZN17btGjkPairDetector16getClosestPointsERKN36btDiscreteCollisionDetectorInterface17ClosestPointInputERNS0_6ResultEP12btIDebugDrawb(i10, i9, i11 | 0, HEAP32[i4 + 20 >> 2] | 0, 0);
    d62 = +__ZNK20btPersistentManifold27getContactBreakingThresholdEv(HEAP32[i20 >> 2] | 0);
    if ((HEAP8[i4 + 24 | 0] | 0) == 0) {
     d63 = +HEAPF32[i10 + 4 >> 2];
     d64 = +HEAPF32[i10 + 8 >> 2];
     d56 = +HEAPF32[i10 + 12 >> 2];
     d57 = 1.0 / +Math_sqrt(+(d63 * d63 + d64 * d64 + d56 * d56));
     HEAPF32[i12 >> 2] = d63 * d57;
     HEAPF32[i12 + 4 >> 2] = d64 * d57;
     HEAPF32[i12 + 8 >> 2] = d56 * d57;
     HEAPF32[i12 + 12 >> 2] = 0.0;
     d78 = +HEAPF32[i10 + 56 >> 2];
     i79 = 1404;
    } else {
     if (__ZN27btPolyhedralContactClipping18findSeparatingAxisERK18btConvexPolyhedronS2_RK11btTransformS5_R9btVector3(HEAP32[i76 >> 2] | 0, HEAP32[i77 >> 2] | 0, i7, i66, i12) | 0) {
      d78 = 0.0;
      i79 = 1404;
     }
    }
    if ((i79 | 0) == 1404) {
     __ZN27btPolyhedralContactClipping19clipHullAgainstHullERK9btVector3RK18btConvexPolyhedronS5_RK11btTransformS8_ffRN36btDiscreteCollisionDetectorInterface6ResultE(i12, HEAP32[i76 >> 2] | 0, HEAP32[i77 >> 2] | 0, i7, i66, d78 - d62, d62, i5 | 0);
    }
    if ((HEAP8[i1 + 16 | 0] | 0) == 0) {
     STACKTOP = i6;
     return;
    }
    i77 = HEAP32[i21 >> 2] | 0;
    if ((HEAP32[i77 + 1116 >> 2] | 0) == 0) {
     STACKTOP = i6;
     return;
    }
    if ((HEAP32[i77 + 1108 >> 2] | 0) == (HEAP32[i5 + 136 >> 2] | 0)) {
     __ZN20btPersistentManifold20refreshContactPointsERK11btTransformS2_(i77, i5 + 8 | 0, i5 + 72 | 0);
     STACKTOP = i6;
     return;
    } else {
     __ZN20btPersistentManifold20refreshContactPointsERK11btTransformS2_(i77, i5 + 72 | 0, i5 + 8 | 0);
     STACKTOP = i6;
     return;
    }
   }
   if ((i75 | 0) != 1) {
    break;
   }
   __ZN17btGjkPairDetector16getClosestPointsERKN36btDiscreteCollisionDetectorInterface17ClosestPointInputERNS0_6ResultEP12btIDebugDrawb(i10, i9, i11 | 0, HEAP32[i4 + 20 >> 2] | 0, 0);
   d62 = +HEAPF32[i10 + 4 >> 2];
   d57 = +HEAPF32[i10 + 8 >> 2];
   d56 = +HEAPF32[i10 + 12 >> 2];
   d64 = 1.0 / +Math_sqrt(+(d62 * d62 + d57 * d57 + d56 * d56));
   HEAPF32[i13 >> 2] = d62 * d64;
   HEAPF32[i13 + 4 >> 2] = d57 * d64;
   HEAPF32[i13 + 8 >> 2] = d56 * d64;
   HEAPF32[i13 + 12 >> 2] = 0.0;
   i75 = i14 + 16 | 0;
   HEAP8[i75] = 1;
   i77 = i14 + 12 | 0;
   HEAP32[i77 >> 2] = 0;
   i80 = i14 + 4 | 0;
   HEAP32[i80 >> 2] = 0;
   i81 = i14 + 8 | 0;
   HEAP32[i81 >> 2] = 0;
   i82 = i22 + 56 | 0;
   i83 = i66 | 0;
   d64 = +HEAPF32[i82 >> 2];
   i84 = i3 + 8 | 0;
   d56 = +HEAPF32[i82 + 4 >> 2];
   i85 = i3 + 12 | 0;
   d57 = +HEAPF32[i82 + 8 >> 2];
   i86 = i3 + 52 | 0;
   d62 = +HEAPF32[i86 >> 2] + (+HEAPF32[i83 >> 2] * d64 + +HEAPF32[i84 >> 2] * d56 + +HEAPF32[i85 >> 2] * d57);
   i87 = i3 + 20 | 0;
   i88 = i3 + 24 | 0;
   i89 = i3 + 28 | 0;
   i90 = i3 + 56 | 0;
   d63 = +HEAPF32[i90 >> 2] + (d64 * +HEAPF32[i87 >> 2] + d56 * +HEAPF32[i88 >> 2] + d57 * +HEAPF32[i89 >> 2]);
   i91 = i3 + 36 | 0;
   i92 = i3 + 40 | 0;
   i93 = i3 + 44 | 0;
   i94 = i3 + 60 | 0;
   d52 = +HEAPF32[i94 >> 2] + (d64 * +HEAPF32[i91 >> 2] + d56 * +HEAPF32[i92 >> 2] + d57 * +HEAPF32[i93 >> 2]);
   i95 = __Z22btAlignedAllocInternalji(16, 16) | 0;
   HEAP8[i75] = 1;
   HEAP32[i77 >> 2] = i95;
   HEAP32[i81 >> 2] = 1;
   i96 = HEAP32[i80 >> 2] | 0;
   i97 = i95 + (i96 << 4) | 0;
   if ((i97 | 0) == 0) {
    i98 = i96;
    i99 = 1;
   } else {
    HEAPF32[i97 >> 2] = d62;
    HEAPF32[i95 + (i96 << 4) + 4 >> 2] = d63;
    HEAPF32[i95 + (i96 << 4) + 8 >> 2] = d52;
    HEAPF32[i95 + (i96 << 4) + 12 >> 2] = 0.0;
    i98 = HEAP32[i80 >> 2] | 0;
    i99 = HEAP32[i81 >> 2] | 0;
   }
   i96 = i98 + 1 | 0;
   HEAP32[i80 >> 2] = i96;
   d52 = +HEAPF32[i82 + 16 >> 2];
   d63 = +HEAPF32[i82 + 20 >> 2];
   d62 = +HEAPF32[i82 + 24 >> 2];
   d57 = +HEAPF32[i86 >> 2] + (+HEAPF32[i83 >> 2] * d52 + +HEAPF32[i84 >> 2] * d63 + +HEAPF32[i85 >> 2] * d62);
   d56 = +HEAPF32[i90 >> 2] + (d52 * +HEAPF32[i87 >> 2] + d63 * +HEAPF32[i88 >> 2] + d62 * +HEAPF32[i89 >> 2]);
   d64 = +HEAPF32[i94 >> 2] + (d52 * +HEAPF32[i91 >> 2] + d63 * +HEAPF32[i92 >> 2] + d62 * +HEAPF32[i93 >> 2]);
   do {
    if ((i96 | 0) == (i99 | 0)) {
     i95 = (i99 | 0) == 0 ? 1 : i99 << 1;
     if ((i99 | 0) >= (i95 | 0)) {
      i100 = i99;
      i101 = i99;
      break;
     }
     if ((i95 | 0) == 0) {
      i102 = 0;
      i103 = i99;
     } else {
      i97 = __Z22btAlignedAllocInternalji(i95 << 4, 16) | 0;
      i102 = i97;
      i103 = HEAP32[i80 >> 2] | 0;
     }
     if ((i103 | 0) > 0) {
      i97 = 0;
      do {
       i104 = i102 + (i97 << 4) | 0;
       if ((i104 | 0) != 0) {
        i105 = i104;
        i104 = (HEAP32[i77 >> 2] | 0) + (i97 << 4) | 0;
        HEAP32[i105 >> 2] = HEAP32[i104 >> 2];
        HEAP32[i105 + 4 >> 2] = HEAP32[i104 + 4 >> 2];
        HEAP32[i105 + 8 >> 2] = HEAP32[i104 + 8 >> 2];
        HEAP32[i105 + 12 >> 2] = HEAP32[i104 + 12 >> 2];
       }
       i97 = i97 + 1 | 0;
      } while ((i97 | 0) < (i103 | 0));
     }
     i97 = HEAP32[i77 >> 2] | 0;
     if ((i97 | 0) != 0) {
      if ((HEAP8[i75] | 0) != 0) {
       __Z21btAlignedFreeInternalPv(i97);
      }
      HEAP32[i77 >> 2] = 0;
     }
     HEAP8[i75] = 1;
     HEAP32[i77 >> 2] = i102;
     HEAP32[i81 >> 2] = i95;
     i100 = HEAP32[i80 >> 2] | 0;
     i101 = i95;
    } else {
     i100 = i96;
     i101 = i99;
    }
   } while (0);
   i96 = HEAP32[i77 >> 2] | 0;
   i97 = i96 + (i100 << 4) | 0;
   if ((i97 | 0) == 0) {
    i106 = i100;
    i107 = i101;
   } else {
    HEAPF32[i97 >> 2] = d57;
    HEAPF32[i96 + (i100 << 4) + 4 >> 2] = d56;
    HEAPF32[i96 + (i100 << 4) + 8 >> 2] = d64;
    HEAPF32[i96 + (i100 << 4) + 12 >> 2] = 0.0;
    i106 = HEAP32[i80 >> 2] | 0;
    i107 = HEAP32[i81 >> 2] | 0;
   }
   i96 = i106 + 1 | 0;
   HEAP32[i80 >> 2] = i96;
   d55 = +HEAPF32[i82 + 32 >> 2];
   d31 = +HEAPF32[i82 + 36 >> 2];
   d35 = +HEAPF32[i82 + 40 >> 2];
   d49 = +HEAPF32[i86 >> 2] + (+HEAPF32[i83 >> 2] * d55 + +HEAPF32[i84 >> 2] * d31 + +HEAPF32[i85 >> 2] * d35);
   d44 = +HEAPF32[i90 >> 2] + (d55 * +HEAPF32[i87 >> 2] + d31 * +HEAPF32[i88 >> 2] + d35 * +HEAPF32[i89 >> 2]);
   d32 = +HEAPF32[i94 >> 2] + (d55 * +HEAPF32[i91 >> 2] + d31 * +HEAPF32[i92 >> 2] + d35 * +HEAPF32[i93 >> 2]);
   do {
    if ((i96 | 0) == (i107 | 0)) {
     i97 = (i107 | 0) == 0 ? 1 : i107 << 1;
     if ((i107 | 0) >= (i97 | 0)) {
      i108 = i107;
      break;
     }
     if ((i97 | 0) == 0) {
      i109 = 0;
      i110 = i107;
     } else {
      i104 = __Z22btAlignedAllocInternalji(i97 << 4, 16) | 0;
      i109 = i104;
      i110 = HEAP32[i80 >> 2] | 0;
     }
     if ((i110 | 0) > 0) {
      i104 = 0;
      do {
       i105 = i109 + (i104 << 4) | 0;
       if ((i105 | 0) != 0) {
        i111 = i105;
        i105 = (HEAP32[i77 >> 2] | 0) + (i104 << 4) | 0;
        HEAP32[i111 >> 2] = HEAP32[i105 >> 2];
        HEAP32[i111 + 4 >> 2] = HEAP32[i105 + 4 >> 2];
        HEAP32[i111 + 8 >> 2] = HEAP32[i105 + 8 >> 2];
        HEAP32[i111 + 12 >> 2] = HEAP32[i105 + 12 >> 2];
       }
       i104 = i104 + 1 | 0;
      } while ((i104 | 0) < (i110 | 0));
     }
     i104 = HEAP32[i77 >> 2] | 0;
     if ((i104 | 0) != 0) {
      if ((HEAP8[i75] | 0) != 0) {
       __Z21btAlignedFreeInternalPv(i104);
      }
      HEAP32[i77 >> 2] = 0;
     }
     HEAP8[i75] = 1;
     HEAP32[i77 >> 2] = i109;
     HEAP32[i81 >> 2] = i97;
     i108 = HEAP32[i80 >> 2] | 0;
    } else {
     i108 = i96;
    }
   } while (0);
   i96 = HEAP32[i77 >> 2] | 0;
   i93 = i96 + (i108 << 4) | 0;
   if ((i93 | 0) == 0) {
    i112 = i108;
   } else {
    HEAPF32[i93 >> 2] = d49;
    HEAPF32[i96 + (i108 << 4) + 4 >> 2] = d44;
    HEAPF32[i96 + (i108 << 4) + 8 >> 2] = d32;
    HEAPF32[i96 + (i108 << 4) + 12 >> 2] = 0.0;
    i112 = HEAP32[i80 >> 2] | 0;
   }
   HEAP32[i80 >> 2] = i112 + 1;
   d64 = +__ZNK20btPersistentManifold27getContactBreakingThresholdEv(HEAP32[i20 >> 2] | 0);
   __ZN27btPolyhedralContactClipping19clipFaceAgainstHullERK9btVector3RK18btConvexPolyhedronRK11btTransformR20btAlignedObjectArrayIS0_EffRN36btDiscreteCollisionDetectorInterface6ResultE(i13, HEAP32[i76 >> 2] | 0, i7, i14, +HEAPF32[i10 + 56 >> 2] - d64, d64, i5 | 0);
   do {
    if ((HEAP8[i1 + 16 | 0] | 0) != 0) {
     i96 = HEAP32[i21 >> 2] | 0;
     if ((HEAP32[i96 + 1116 >> 2] | 0) == 0) {
      break;
     }
     if ((HEAP32[i96 + 1108 >> 2] | 0) == (HEAP32[i5 + 136 >> 2] | 0)) {
      __ZN20btPersistentManifold20refreshContactPointsERK11btTransformS2_(i96, i5 + 8 | 0, i5 + 72 | 0);
      break;
     } else {
      __ZN20btPersistentManifold20refreshContactPointsERK11btTransformS2_(i96, i5 + 72 | 0, i5 + 8 | 0);
      break;
     }
    }
   } while (0);
   i76 = HEAP32[i77 >> 2] | 0;
   if ((i76 | 0) != 0) {
    if ((HEAP8[i75] | 0) != 0) {
     __Z21btAlignedFreeInternalPv(i76);
    }
    HEAP32[i77 >> 2] = 0;
   }
   HEAP8[i75] = 1;
   HEAP32[i77 >> 2] = 0;
   HEAP32[i80 >> 2] = 0;
   HEAP32[i81 >> 2] = 0;
   STACKTOP = i6;
   return;
  }
 } while (0);
 i14 = i4 + 20 | 0;
 __ZN17btGjkPairDetector16getClosestPointsERKN36btDiscreteCollisionDetectorInterface17ClosestPointInputERNS0_6ResultEP12btIDebugDrawb(i10, i9, i5 | 0, HEAP32[i14 >> 2] | 0, 0);
 i4 = i1 + 28 | 0;
 L1724 : do {
  if ((HEAP32[i4 >> 2] | 0) != 0) {
   if ((HEAP32[(HEAP32[i21 >> 2] | 0) + 1116 >> 2] | 0) >= (HEAP32[i1 + 32 >> 2] | 0)) {
    break;
   }
   d78 = +HEAPF32[i10 + 4 >> 2];
   d32 = +HEAPF32[i10 + 8 >> 2];
   d44 = +HEAPF32[i10 + 12 >> 2];
   d49 = 1.0 / +Math_sqrt(+(d78 * d78 + d32 * d32 + d44 * d44));
   d64 = d78 * d49;
   d78 = d32 * d49;
   d32 = d44 * d49;
   if (+Math_abs(+d32) > .7071067690849304) {
    d49 = 1.0 / +Math_sqrt(+(d32 * d32 + d78 * d78));
    d113 = 0.0;
    d114 = d49 * (-0.0 - d32);
    d115 = d78 * d49;
   } else {
    d49 = 1.0 / +Math_sqrt(+(d64 * d64 + d78 * d78));
    d113 = d49 * (-0.0 - d78);
    d114 = d64 * d49;
    d115 = 0.0;
   }
   d49 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i24 >> 2] | 0) + 16 >> 2] & 7](i24);
   d44 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i22 >> 2] | 0) + 16 >> 2] & 7](i22);
   i13 = d49 < d44;
   d56 = +HEAPF32[4] / (i13 ? d49 : d44);
   i20 = i15;
   if (i13) {
    HEAP32[i20 >> 2] = HEAP32[i8 >> 2];
    HEAP32[i20 + 4 >> 2] = HEAP32[i8 + 4 >> 2];
    HEAP32[i20 + 8 >> 2] = HEAP32[i8 + 8 >> 2];
    HEAP32[i20 + 12 >> 2] = HEAP32[i8 + 12 >> 2];
    i112 = i16;
    HEAP32[i112 >> 2] = HEAP32[i23 >> 2];
    HEAP32[i112 + 4 >> 2] = HEAP32[i23 + 4 >> 2];
    HEAP32[i112 + 8 >> 2] = HEAP32[i23 + 8 >> 2];
    HEAP32[i112 + 12 >> 2] = HEAP32[i23 + 12 >> 2];
    i112 = i17;
    HEAP32[i112 >> 2] = HEAP32[i29 >> 2];
    HEAP32[i112 + 4 >> 2] = HEAP32[i29 + 4 >> 2];
    HEAP32[i112 + 8 >> 2] = HEAP32[i29 + 8 >> 2];
    HEAP32[i112 + 12 >> 2] = HEAP32[i29 + 12 >> 2];
    i112 = i18;
    HEAP32[i112 >> 2] = HEAP32[i30 >> 2];
    HEAP32[i112 + 4 >> 2] = HEAP32[i30 + 4 >> 2];
    HEAP32[i112 + 8 >> 2] = HEAP32[i30 + 8 >> 2];
    HEAP32[i112 + 12 >> 2] = HEAP32[i30 + 12 >> 2];
   } else {
    HEAP32[i20 >> 2] = HEAP32[i67 >> 2];
    HEAP32[i20 + 4 >> 2] = HEAP32[i67 + 4 >> 2];
    HEAP32[i20 + 8 >> 2] = HEAP32[i67 + 8 >> 2];
    HEAP32[i20 + 12 >> 2] = HEAP32[i67 + 12 >> 2];
    i112 = i16;
    HEAP32[i112 >> 2] = HEAP32[i69 >> 2];
    HEAP32[i112 + 4 >> 2] = HEAP32[i69 + 4 >> 2];
    HEAP32[i112 + 8 >> 2] = HEAP32[i69 + 8 >> 2];
    HEAP32[i112 + 12 >> 2] = HEAP32[i69 + 12 >> 2];
    i112 = i17;
    HEAP32[i112 >> 2] = HEAP32[i71 >> 2];
    HEAP32[i112 + 4 >> 2] = HEAP32[i71 + 4 >> 2];
    HEAP32[i112 + 8 >> 2] = HEAP32[i71 + 8 >> 2];
    HEAP32[i112 + 12 >> 2] = HEAP32[i71 + 12 >> 2];
    i112 = i18;
    HEAP32[i112 >> 2] = HEAP32[i73 >> 2];
    HEAP32[i112 + 4 >> 2] = HEAP32[i73 + 4 >> 2];
    HEAP32[i112 + 8 >> 2] = HEAP32[i73 + 8 >> 2];
    HEAP32[i112 + 12 >> 2] = HEAP32[i73 + 12 >> 2];
   }
   i112 = HEAP32[i4 >> 2] | 0;
   if ((i112 | 0) <= 0) {
    break;
   }
   d44 = d115 * d115 + (d114 * d114 + d113 * d113);
   d49 = d56 > .39269909262657166 ? .19634954631328583 : d56 * .5;
   d56 = d32 * d32 + (d64 * d64 + d78 * d78);
   i108 = i7 | 0;
   i109 = i2 + 20 | 0;
   i110 = i2 + 36 | 0;
   i107 = i2 + 8 | 0;
   i106 = i2 + 24 | 0;
   i100 = i2 + 40 | 0;
   i101 = i2 + 12 | 0;
   i99 = i2 + 28 | 0;
   i102 = i2 + 44 | 0;
   i103 = i9 | 0;
   i98 = i9 + 4 | 0;
   i11 = i9 + 8 | 0;
   i12 = i9 + 12 | 0;
   i79 = i9 + 16 | 0;
   i26 = i9 + 20 | 0;
   i76 = i9 + 24 | 0;
   i96 = i9 + 28 | 0;
   i93 = i9 + 32 | 0;
   i92 = i9 + 36 | 0;
   i91 = i9 + 40 | 0;
   i94 = i9 + 44 | 0;
   i89 = i19 | 0;
   i88 = i19 + 144 | 0;
   i87 = i19 + 160 | 0;
   i90 = i19 + 164 | 0;
   i85 = i19 + 180 | 0;
   i84 = i19 + 196 | 0;
   i83 = i19 + 212 | 0;
   i86 = i19 + 228 | 0;
   i82 = i19 + 244 | 0;
   i104 = i19 + 260 | 0;
   i95 = i19 + 276 | 0;
   i105 = i19 + 292 | 0;
   i111 = i19 + 308 | 0;
   i116 = i16;
   i117 = i19 + 324 | 0;
   i118 = i17;
   i119 = i19 + 340 | 0;
   i120 = i18;
   i121 = i19 + 356 | 0;
   i122 = i13 & 1;
   i123 = i19 + 360 | 0;
   i124 = i19 | 0;
   i125 = i66 | 0;
   i126 = i3 + 20 | 0;
   i127 = i3 + 36 | 0;
   i128 = i3 + 8 | 0;
   i129 = i3 + 24 | 0;
   i130 = i3 + 40 | 0;
   i131 = i3 + 12 | 0;
   i132 = i3 + 28 | 0;
   i133 = i3 + 44 | 0;
   i134 = i9 + 64 | 0;
   i135 = i9 + 68 | 0;
   i136 = i9 + 72 | 0;
   i137 = i9 + 76 | 0;
   i138 = i9 + 80 | 0;
   i139 = i9 + 84 | 0;
   i140 = i9 + 88 | 0;
   i141 = i9 + 92 | 0;
   i142 = i9 + 96 | 0;
   i143 = i9 + 100 | 0;
   i144 = i9 + 104 | 0;
   i145 = i9 + 108 | 0;
   if (d44 > 1.1920928955078125e-7) {
    i146 = 0;
    i147 = i112;
   } else {
    if (i13) {
     i148 = 0;
     while (1) {
      i148 = i148 + 1 | 0;
      if ((i148 | 0) >= (i112 | 0)) {
       break L1724;
      }
     }
    } else {
     i148 = 0;
     while (1) {
      i148 = i148 + 1 | 0;
      if ((i148 | 0) >= (i112 | 0)) {
       break L1724;
      }
     }
    }
   }
   do {
    d57 = +Math_sqrt(+d44);
    d35 = +Math_sin(+d49) / d57;
    d57 = d113 * d35;
    d31 = d114 * d35;
    d55 = d115 * d35;
    d35 = +Math_cos(+d49);
    d43 = +Math_sqrt(+d56);
    d34 = +(i146 | 0) * (6.2831854820251465 / +(i147 | 0)) * .5;
    d42 = +Math_sin(+d34) / d43;
    d43 = d64 * d42;
    d62 = d78 * d42;
    d63 = d32 * d42;
    d42 = +Math_cos(+d34);
    if (i13) {
     d34 = -0.0 - d43;
     d52 = -0.0 - d62;
     d36 = -0.0 - d63;
     d37 = d55 * d52 + (d57 * d42 + d35 * d34) - d31 * d36;
     d38 = d57 * d36 + (d31 * d42 + d35 * d52) - d55 * d34;
     d53 = d31 * d34 + (d55 * d42 + d35 * d36) - d57 * d52;
     d51 = d35 * d42 - d57 * d34 - d31 * d52 - d55 * d36;
     d36 = d63 * d38 + (d43 * d51 + d42 * d37) - d62 * d53;
     d52 = d43 * d53 + (d42 * d38 + d62 * d51) - d63 * d37;
     d34 = d62 * d37 + (d63 * d51 + d42 * d53) - d43 * d38;
     d48 = d42 * d51 - d43 * d37 - d62 * d38 - d63 * d53;
     d53 = 2.0 / (d48 * d48 + (d34 * d34 + (d36 * d36 + d52 * d52)));
     d38 = d36 * d53;
     d37 = d52 * d53;
     d51 = d34 * d53;
     d53 = d48 * d38;
     d54 = d48 * d37;
     d50 = d48 * d51;
     d48 = d36 * d38;
     d38 = d36 * d37;
     d33 = d36 * d51;
     d36 = d52 * d37;
     d37 = d52 * d51;
     d52 = d34 * d51;
     d51 = 1.0 - (d36 + d52);
     d34 = d38 - d50;
     d47 = d33 + d54;
     d46 = d38 + d50;
     d50 = 1.0 - (d48 + d52);
     d52 = d37 - d53;
     d38 = d33 - d54;
     d54 = d37 + d53;
     d53 = 1.0 - (d48 + d36);
     d36 = +HEAPF32[i108 >> 2];
     d48 = +HEAPF32[i109 >> 2];
     d37 = +HEAPF32[i110 >> 2];
     d33 = +HEAPF32[i107 >> 2];
     d45 = +HEAPF32[i106 >> 2];
     d41 = +HEAPF32[i100 >> 2];
     d40 = +HEAPF32[i101 >> 2];
     d39 = +HEAPF32[i99 >> 2];
     d61 = +HEAPF32[i102 >> 2];
     HEAPF32[i103 >> 2] = d37 * d47 + (d48 * d34 + d36 * d51);
     HEAPF32[i98 >> 2] = d51 * d33 + d34 * d45 + d47 * d41;
     HEAPF32[i11 >> 2] = d51 * d40 + d34 * d39 + d47 * d61;
     HEAPF32[i12 >> 2] = 0.0;
     HEAPF32[i79 >> 2] = d37 * d52 + (d36 * d46 + d48 * d50);
     HEAPF32[i26 >> 2] = d46 * d33 + d50 * d45 + d52 * d41;
     HEAPF32[i76 >> 2] = d46 * d40 + d50 * d39 + d52 * d61;
     HEAPF32[i96 >> 2] = 0.0;
     HEAPF32[i93 >> 2] = d36 * d38 + d48 * d54 + d37 * d53;
     HEAPF32[i92 >> 2] = d38 * d33 + d54 * d45 + d53 * d41;
     HEAPF32[i91 >> 2] = d38 * d40 + d54 * d39 + d53 * d61;
     HEAPF32[i94 >> 2] = 0.0;
     HEAP32[i67 >> 2] = HEAP32[i68 >> 2];
     HEAP32[i67 + 4 >> 2] = HEAP32[i68 + 4 >> 2];
     HEAP32[i67 + 8 >> 2] = HEAP32[i68 + 8 >> 2];
     HEAP32[i67 + 12 >> 2] = HEAP32[i68 + 12 >> 2];
     HEAP32[i69 >> 2] = HEAP32[i70 >> 2];
     HEAP32[i69 + 4 >> 2] = HEAP32[i70 + 4 >> 2];
     HEAP32[i69 + 8 >> 2] = HEAP32[i70 + 8 >> 2];
     HEAP32[i69 + 12 >> 2] = HEAP32[i70 + 12 >> 2];
     HEAP32[i71 >> 2] = HEAP32[i72 >> 2];
     HEAP32[i71 + 4 >> 2] = HEAP32[i72 + 4 >> 2];
     HEAP32[i71 + 8 >> 2] = HEAP32[i72 + 8 >> 2];
     HEAP32[i71 + 12 >> 2] = HEAP32[i72 + 12 >> 2];
     HEAP32[i73 >> 2] = HEAP32[i74 >> 2];
     HEAP32[i73 + 4 >> 2] = HEAP32[i74 + 4 >> 2];
     HEAP32[i73 + 8 >> 2] = HEAP32[i74 + 8 >> 2];
     HEAP32[i73 + 12 >> 2] = HEAP32[i74 + 12 >> 2];
    } else {
     HEAP32[i8 >> 2] = HEAP32[i25 >> 2];
     HEAP32[i8 + 4 >> 2] = HEAP32[i25 + 4 >> 2];
     HEAP32[i8 + 8 >> 2] = HEAP32[i25 + 8 >> 2];
     HEAP32[i8 + 12 >> 2] = HEAP32[i25 + 12 >> 2];
     HEAP32[i23 >> 2] = HEAP32[i27 >> 2];
     HEAP32[i23 + 4 >> 2] = HEAP32[i27 + 4 >> 2];
     HEAP32[i23 + 8 >> 2] = HEAP32[i27 + 8 >> 2];
     HEAP32[i23 + 12 >> 2] = HEAP32[i27 + 12 >> 2];
     HEAP32[i29 >> 2] = HEAP32[i28 >> 2];
     HEAP32[i29 + 4 >> 2] = HEAP32[i28 + 4 >> 2];
     HEAP32[i29 + 8 >> 2] = HEAP32[i28 + 8 >> 2];
     HEAP32[i29 + 12 >> 2] = HEAP32[i28 + 12 >> 2];
     HEAP32[i30 >> 2] = HEAP32[i65 >> 2];
     HEAP32[i30 + 4 >> 2] = HEAP32[i65 + 4 >> 2];
     HEAP32[i30 + 8 >> 2] = HEAP32[i65 + 8 >> 2];
     HEAP32[i30 + 12 >> 2] = HEAP32[i65 + 12 >> 2];
     d61 = -0.0 - d43;
     d53 = -0.0 - d62;
     d39 = -0.0 - d63;
     d54 = d55 * d53 + (d57 * d42 + d35 * d61) - d31 * d39;
     d40 = d57 * d39 + (d31 * d42 + d35 * d53) - d55 * d61;
     d38 = d31 * d61 + (d55 * d42 + d35 * d39) - d57 * d53;
     d41 = d35 * d42 - d57 * d61 - d31 * d53 - d55 * d39;
     d39 = d63 * d40 + (d43 * d41 + d42 * d54) - d62 * d38;
     d55 = d43 * d38 + (d42 * d40 + d62 * d41) - d63 * d54;
     d53 = d62 * d54 + (d63 * d41 + d42 * d38) - d43 * d40;
     d31 = d42 * d41 - d43 * d54 - d62 * d40 - d63 * d38;
     d38 = 2.0 / (d31 * d31 + (d53 * d53 + (d39 * d39 + d55 * d55)));
     d63 = d39 * d38;
     d40 = d55 * d38;
     d62 = d53 * d38;
     d38 = d31 * d63;
     d54 = d31 * d40;
     d43 = d31 * d62;
     d31 = d39 * d63;
     d63 = d39 * d40;
     d41 = d39 * d62;
     d39 = d55 * d40;
     d40 = d55 * d62;
     d55 = d53 * d62;
     d62 = 1.0 - (d39 + d55);
     d53 = d63 - d43;
     d42 = d41 + d54;
     d61 = d63 + d43;
     d43 = 1.0 - (d31 + d55);
     d55 = d40 - d38;
     d63 = d41 - d54;
     d54 = d40 + d38;
     d38 = 1.0 - (d31 + d39);
     d39 = +HEAPF32[i125 >> 2];
     d31 = +HEAPF32[i126 >> 2];
     d40 = +HEAPF32[i127 >> 2];
     d41 = +HEAPF32[i128 >> 2];
     d57 = +HEAPF32[i129 >> 2];
     d35 = +HEAPF32[i130 >> 2];
     d45 = +HEAPF32[i131 >> 2];
     d33 = +HEAPF32[i132 >> 2];
     d37 = +HEAPF32[i133 >> 2];
     HEAPF32[i134 >> 2] = d40 * d42 + (d31 * d53 + d39 * d62);
     HEAPF32[i135 >> 2] = d62 * d41 + d53 * d57 + d42 * d35;
     HEAPF32[i136 >> 2] = d62 * d45 + d53 * d33 + d42 * d37;
     HEAPF32[i137 >> 2] = 0.0;
     HEAPF32[i138 >> 2] = d40 * d55 + (d39 * d61 + d31 * d43);
     HEAPF32[i139 >> 2] = d61 * d41 + d43 * d57 + d55 * d35;
     HEAPF32[i140 >> 2] = d61 * d45 + d43 * d33 + d55 * d37;
     HEAPF32[i141 >> 2] = 0.0;
     HEAPF32[i142 >> 2] = d39 * d63 + d31 * d54 + d40 * d38;
     HEAPF32[i143 >> 2] = d63 * d41 + d54 * d57 + d38 * d35;
     HEAPF32[i144 >> 2] = d63 * d45 + d54 * d33 + d38 * d37;
     HEAPF32[i145 >> 2] = 0.0;
    }
    i112 = HEAP32[i14 >> 2] | 0;
    _memset(i88 | 0, -1 | 0, 16);
    HEAP32[i89 >> 2] = 3064;
    HEAP32[i87 >> 2] = i5;
    HEAP32[i90 >> 2] = HEAP32[i8 >> 2];
    HEAP32[i90 + 4 >> 2] = HEAP32[i8 + 4 >> 2];
    HEAP32[i90 + 8 >> 2] = HEAP32[i8 + 8 >> 2];
    HEAP32[i90 + 12 >> 2] = HEAP32[i8 + 12 >> 2];
    HEAP32[i85 >> 2] = HEAP32[i23 >> 2];
    HEAP32[i85 + 4 >> 2] = HEAP32[i23 + 4 >> 2];
    HEAP32[i85 + 8 >> 2] = HEAP32[i23 + 8 >> 2];
    HEAP32[i85 + 12 >> 2] = HEAP32[i23 + 12 >> 2];
    HEAP32[i84 >> 2] = HEAP32[i29 >> 2];
    HEAP32[i84 + 4 >> 2] = HEAP32[i29 + 4 >> 2];
    HEAP32[i84 + 8 >> 2] = HEAP32[i29 + 8 >> 2];
    HEAP32[i84 + 12 >> 2] = HEAP32[i29 + 12 >> 2];
    HEAP32[i83 >> 2] = HEAP32[i30 >> 2];
    HEAP32[i83 + 4 >> 2] = HEAP32[i30 + 4 >> 2];
    HEAP32[i83 + 8 >> 2] = HEAP32[i30 + 8 >> 2];
    HEAP32[i83 + 12 >> 2] = HEAP32[i30 + 12 >> 2];
    HEAP32[i86 >> 2] = HEAP32[i67 >> 2];
    HEAP32[i86 + 4 >> 2] = HEAP32[i67 + 4 >> 2];
    HEAP32[i86 + 8 >> 2] = HEAP32[i67 + 8 >> 2];
    HEAP32[i86 + 12 >> 2] = HEAP32[i67 + 12 >> 2];
    HEAP32[i82 >> 2] = HEAP32[i69 >> 2];
    HEAP32[i82 + 4 >> 2] = HEAP32[i69 + 4 >> 2];
    HEAP32[i82 + 8 >> 2] = HEAP32[i69 + 8 >> 2];
    HEAP32[i82 + 12 >> 2] = HEAP32[i69 + 12 >> 2];
    HEAP32[i104 >> 2] = HEAP32[i71 >> 2];
    HEAP32[i104 + 4 >> 2] = HEAP32[i71 + 4 >> 2];
    HEAP32[i104 + 8 >> 2] = HEAP32[i71 + 8 >> 2];
    HEAP32[i104 + 12 >> 2] = HEAP32[i71 + 12 >> 2];
    HEAP32[i95 >> 2] = HEAP32[i73 >> 2];
    HEAP32[i95 + 4 >> 2] = HEAP32[i73 + 4 >> 2];
    HEAP32[i95 + 8 >> 2] = HEAP32[i73 + 8 >> 2];
    HEAP32[i95 + 12 >> 2] = HEAP32[i73 + 12 >> 2];
    HEAP32[i105 >> 2] = HEAP32[i20 >> 2];
    HEAP32[i105 + 4 >> 2] = HEAP32[i20 + 4 >> 2];
    HEAP32[i105 + 8 >> 2] = HEAP32[i20 + 8 >> 2];
    HEAP32[i105 + 12 >> 2] = HEAP32[i20 + 12 >> 2];
    HEAP32[i111 >> 2] = HEAP32[i116 >> 2];
    HEAP32[i111 + 4 >> 2] = HEAP32[i116 + 4 >> 2];
    HEAP32[i111 + 8 >> 2] = HEAP32[i116 + 8 >> 2];
    HEAP32[i111 + 12 >> 2] = HEAP32[i116 + 12 >> 2];
    HEAP32[i117 >> 2] = HEAP32[i118 >> 2];
    HEAP32[i117 + 4 >> 2] = HEAP32[i118 + 4 >> 2];
    HEAP32[i117 + 8 >> 2] = HEAP32[i118 + 8 >> 2];
    HEAP32[i117 + 12 >> 2] = HEAP32[i118 + 12 >> 2];
    HEAP32[i119 >> 2] = HEAP32[i120 >> 2];
    HEAP32[i119 + 4 >> 2] = HEAP32[i120 + 4 >> 2];
    HEAP32[i119 + 8 >> 2] = HEAP32[i120 + 8 >> 2];
    HEAP32[i119 + 12 >> 2] = HEAP32[i120 + 12 >> 2];
    HEAP8[i121] = i122;
    HEAP32[i123 >> 2] = i112;
    __ZN17btGjkPairDetector16getClosestPointsERKN36btDiscreteCollisionDetectorInterface17ClosestPointInputERNS0_6ResultEP12btIDebugDrawb(i10, i9, i124, i112, 0);
    i147 = HEAP32[i4 >> 2] | 0;
    i146 = i146 + 1 | 0;
   } while ((i146 | 0) < (i147 | 0));
  }
 } while (0);
 if ((HEAP8[i1 + 16 | 0] | 0) == 0) {
  STACKTOP = i6;
  return;
 }
 i1 = HEAP32[i21 >> 2] | 0;
 if ((HEAP32[i1 + 1116 >> 2] | 0) == 0) {
  STACKTOP = i6;
  return;
 }
 if ((HEAP32[i1 + 1108 >> 2] | 0) == (HEAP32[i5 + 136 >> 2] | 0)) {
  __ZN20btPersistentManifold20refreshContactPointsERK11btTransformS2_(i1, i5 + 8 | 0, i5 + 72 | 0);
  STACKTOP = i6;
  return;
 } else {
  __ZN20btPersistentManifold20refreshContactPointsERK11btTransformS2_(i1, i5 + 72 | 0, i5 + 8 | 0);
  STACKTOP = i6;
  return;
 }
}
function __ZN20btConvexHullInternal24findEdgeForCoplanarFacesEPNS_6VertexES1_RPNS_4EdgeES4_S1_S1_(i1, i2, i3, i4, i5, i6, i7) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 i7 = i7 | 0;
 var i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0, i62 = 0, i63 = 0, i64 = 0, i65 = 0, i66 = 0, i67 = 0, i68 = 0, i69 = 0, i70 = 0, i71 = 0, i72 = 0, i73 = 0, i74 = 0, i75 = 0, i76 = 0, i77 = 0, i78 = 0, i79 = 0, i80 = 0, i81 = 0, i82 = 0, i83 = 0, i84 = 0, i85 = 0, i86 = 0, i87 = 0, i88 = 0, i89 = 0, i90 = 0, i91 = 0, i92 = 0, i93 = 0, i94 = 0, i95 = 0, i96 = 0, i97 = 0, i98 = 0, i99 = 0, i100 = 0, i101 = 0, i102 = 0, i103 = 0, i104 = 0, i105 = 0, i106 = 0, i107 = 0, i108 = 0, i109 = 0, i110 = 0, i111 = 0, i112 = 0, i113 = 0, i114 = 0, i115 = 0, i116 = 0, i117 = 0, i118 = 0;
 i8 = STACKTOP;
 STACKTOP = STACKTOP + 192 | 0;
 i9 = i8 | 0;
 i10 = i8 + 24 | 0;
 i11 = i8 + 48 | 0;
 i12 = i8 + 72 | 0;
 i13 = i8 + 96 | 0;
 i14 = i8 + 120 | 0;
 i15 = i8 + 144 | 0;
 i16 = i8 + 168 | 0;
 i17 = HEAP32[i4 >> 2] | 0;
 i18 = HEAP32[i5 >> 2] | 0;
 i19 = (i17 | 0) != 0;
 if (i19) {
  i20 = HEAP32[i17 + 12 >> 2] | 0;
 } else {
  i20 = i2;
 }
 i21 = HEAP32[i20 + 88 >> 2] | 0;
 i22 = HEAP32[i20 + 92 >> 2] | 0;
 i23 = HEAP32[i20 + 96 >> 2] | 0;
 if ((i18 | 0) == 0) {
  i24 = i3;
 } else {
  i24 = HEAP32[i18 + 12 >> 2] | 0;
 }
 i20 = HEAP32[i24 + 88 >> 2] | 0;
 i25 = HEAP32[i24 + 92 >> 2] | 0;
 i26 = HEAP32[i24 + 96 >> 2] | 0;
 i24 = HEAP32[i2 + 88 >> 2] | 0;
 i27 = (HEAP32[i3 + 88 >> 2] | 0) - i24 | 0;
 i28 = HEAP32[i2 + 92 >> 2] | 0;
 i29 = (HEAP32[i3 + 92 >> 2] | 0) - i28 | 0;
 i30 = HEAP32[i2 + 96 >> 2] | 0;
 i2 = (HEAP32[i3 + 96 >> 2] | 0) - i30 | 0;
 i3 = HEAP32[(i19 ? i17 : i18) + 12 >> 2] | 0;
 i19 = (HEAP32[i3 + 88 >> 2] | 0) - i24 | 0;
 i31 = (HEAP32[i3 + 92 >> 2] | 0) - i28 | 0;
 i32 = (HEAP32[i3 + 96 >> 2] | 0) - i30 | 0;
 i3 = Math_imul(i31, i2) | 0;
 i33 = i3 - (Math_imul(i32, i29) | 0) | 0;
 i3 = i33;
 i34 = (i33 | 0) < 0 ? -1 : 0;
 i33 = Math_imul(i32, i27) | 0;
 i32 = i33 - (Math_imul(i19, i2) | 0) | 0;
 i33 = i32;
 i35 = (i32 | 0) < 0 ? -1 : 0;
 i32 = Math_imul(i19, i29) | 0;
 i19 = i32 - (Math_imul(i31, i27) | 0) | 0;
 i31 = i19;
 i32 = (i19 | 0) < 0 ? -1 : 0;
 i19 = ___muldi3(i3, i34, i24, (i24 | 0) < 0 ? -1 : 0) | 0;
 i24 = tempRet0;
 i36 = ___muldi3(i33, i35, i28, (i28 | 0) < 0 ? -1 : 0) | 0;
 i28 = tempRet0;
 i37 = ___muldi3(i31, i32, i30, (i30 | 0) < 0 ? -1 : 0) | 0;
 i30 = _i64Add(i19, i24, i37, tempRet0) | 0;
 i37 = _i64Add(i30, tempRet0, i36, i28) | 0;
 i28 = tempRet0;
 i36 = i29;
 i30 = (i29 | 0) < 0 ? -1 : 0;
 i24 = ___muldi3(i31, i32, i36, i30) | 0;
 i19 = tempRet0;
 i38 = i2;
 i39 = (i2 | 0) < 0 ? -1 : 0;
 i40 = ___muldi3(i33, i35, i38, i39) | 0;
 i41 = _i64Subtract(i24, i19, i40, tempRet0) | 0;
 i40 = tempRet0;
 i19 = ___muldi3(i3, i34, i38, i39) | 0;
 i39 = tempRet0;
 i38 = i27;
 i24 = (i27 | 0) < 0 ? -1 : 0;
 i42 = ___muldi3(i31, i32, i38, i24) | 0;
 i43 = _i64Subtract(i19, i39, i42, tempRet0) | 0;
 i42 = tempRet0;
 i39 = ___muldi3(i33, i35, i38, i24) | 0;
 i24 = tempRet0;
 i38 = ___muldi3(i3, i34, i36, i30) | 0;
 i30 = _i64Subtract(i39, i24, i38, tempRet0) | 0;
 i38 = tempRet0;
 i24 = ___muldi3(i41, i40, i21, (i21 | 0) < 0 ? -1 : 0) | 0;
 i39 = tempRet0;
 i36 = ___muldi3(i43, i42, i22, (i22 | 0) < 0 ? -1 : 0) | 0;
 i19 = _i64Add(i36, tempRet0, i24, i39) | 0;
 i39 = tempRet0;
 i24 = ___muldi3(i30, i38, i23, (i23 | 0) < 0 ? -1 : 0) | 0;
 i36 = _i64Add(i19, i39, i24, tempRet0) | 0;
 i24 = tempRet0;
 do {
  if ((i17 | 0) == 0) {
   i44 = i24;
   i45 = i36;
   i46 = i21;
   i47 = i22;
   i48 = i23;
   i49 = i18;
  } else {
   if ((HEAP32[i17 + 12 >> 2] | 0) == (i6 | 0)) {
    i44 = i24;
    i45 = i36;
    i46 = i21;
    i47 = i22;
    i48 = i23;
    i49 = i18;
    break;
   }
   i39 = i1 + 100 | 0;
   i19 = i23;
   i50 = i22;
   i51 = i21;
   i52 = i24;
   i53 = i36;
   i54 = i17;
   while (1) {
    i55 = HEAP32[(HEAP32[i54 + 8 >> 2] | 0) + 4 >> 2] | 0;
    i56 = i55 + 12 | 0;
    i57 = HEAP32[i56 >> 2] | 0;
    i58 = HEAP32[i57 + 88 >> 2] | 0;
    i59 = i58;
    i60 = (i58 | 0) < 0 ? -1 : 0;
    i58 = ___muldi3(i59, i60, i3, i34) | 0;
    i61 = tempRet0;
    i62 = HEAP32[i57 + 92 >> 2] | 0;
    i63 = i62;
    i64 = (i62 | 0) < 0 ? -1 : 0;
    i62 = ___muldi3(i63, i64, i33, i35) | 0;
    i65 = _i64Add(i62, tempRet0, i58, i61) | 0;
    i61 = tempRet0;
    i58 = HEAP32[i57 + 96 >> 2] | 0;
    i57 = i58;
    i62 = (i58 | 0) < 0 ? -1 : 0;
    i58 = ___muldi3(i57, i62, i31, i32) | 0;
    i66 = _i64Add(i65, i61, i58, tempRet0) | 0;
    i58 = tempRet0;
    if ((i58 | 0) < (i28 | 0) | (i58 | 0) == (i28 | 0) & i66 >>> 0 < i37 >>> 0) {
     i67 = i19;
     i68 = i50;
     i69 = i51;
     i70 = i52;
     i71 = i53;
     break;
    }
    if ((HEAP32[i55 + 20 >> 2] | 0) == (HEAP32[i39 >> 2] | 0)) {
     i67 = i19;
     i68 = i50;
     i69 = i51;
     i70 = i52;
     i71 = i53;
     break;
    }
    i66 = ___muldi3(i59, i60, i41, i40) | 0;
    i60 = tempRet0;
    i59 = ___muldi3(i63, i64, i43, i42) | 0;
    i64 = _i64Add(i59, tempRet0, i66, i60) | 0;
    i60 = tempRet0;
    i66 = ___muldi3(i57, i62, i30, i38) | 0;
    i62 = _i64Add(i64, i60, i66, tempRet0) | 0;
    i66 = tempRet0;
    if (!((i66 | 0) > (i52 | 0) | (i66 | 0) == (i52 | 0) & i62 >>> 0 > i53 >>> 0)) {
     i67 = i19;
     i68 = i50;
     i69 = i51;
     i70 = i52;
     i71 = i53;
     break;
    }
    HEAP32[i4 >> 2] = i55;
    i60 = HEAP32[i56 >> 2] | 0;
    i56 = HEAP32[i60 + 88 >> 2] | 0;
    i64 = HEAP32[i60 + 92 >> 2] | 0;
    i57 = HEAP32[i60 + 96 >> 2] | 0;
    if ((i60 | 0) == (i6 | 0)) {
     i67 = i57;
     i68 = i64;
     i69 = i56;
     i70 = i66;
     i71 = i62;
     break;
    } else {
     i19 = i57;
     i50 = i64;
     i51 = i56;
     i52 = i66;
     i53 = i62;
     i54 = i55;
    }
   }
   i44 = i70;
   i45 = i71;
   i46 = i69;
   i47 = i68;
   i48 = i67;
   i49 = HEAP32[i5 >> 2] | 0;
  }
 } while (0);
 i67 = ___muldi3(i41, i40, i20, (i20 | 0) < 0 ? -1 : 0) | 0;
 i68 = tempRet0;
 i69 = ___muldi3(i43, i42, i25, (i25 | 0) < 0 ? -1 : 0) | 0;
 i71 = _i64Add(i69, tempRet0, i67, i68) | 0;
 i68 = tempRet0;
 i67 = ___muldi3(i30, i38, i26, (i26 | 0) < 0 ? -1 : 0) | 0;
 i69 = _i64Add(i71, i68, i67, tempRet0) | 0;
 i67 = tempRet0;
 L1159 : do {
  if ((i49 | 0) == 0) {
   i72 = i67;
   i73 = i69;
   i74 = i20;
   i75 = i25;
   i76 = i26;
   i77 = 0;
  } else {
   if ((HEAP32[i49 + 12 >> 2] | 0) == (i7 | 0)) {
    i72 = i67;
    i73 = i69;
    i74 = i20;
    i75 = i25;
    i76 = i26;
    i77 = i49;
    break;
   }
   i68 = i1 + 100 | 0;
   i71 = i26;
   i70 = i25;
   i36 = i20;
   i24 = i67;
   i21 = i69;
   i22 = i49;
   while (1) {
    i23 = HEAP32[HEAP32[i22 + 8 >> 2] >> 2] | 0;
    i54 = i23 + 12 | 0;
    i53 = HEAP32[i54 >> 2] | 0;
    i52 = HEAP32[i53 + 88 >> 2] | 0;
    i51 = i52;
    i50 = (i52 | 0) < 0 ? -1 : 0;
    i52 = ___muldi3(i51, i50, i3, i34) | 0;
    i19 = tempRet0;
    i39 = HEAP32[i53 + 92 >> 2] | 0;
    i55 = i39;
    i62 = (i39 | 0) < 0 ? -1 : 0;
    i39 = ___muldi3(i55, i62, i33, i35) | 0;
    i66 = _i64Add(i39, tempRet0, i52, i19) | 0;
    i19 = tempRet0;
    i52 = HEAP32[i53 + 96 >> 2] | 0;
    i53 = i52;
    i39 = (i52 | 0) < 0 ? -1 : 0;
    i52 = ___muldi3(i53, i39, i31, i32) | 0;
    i56 = _i64Add(i66, i19, i52, tempRet0) | 0;
    i52 = tempRet0;
    if ((i52 | 0) < (i28 | 0) | (i52 | 0) == (i28 | 0) & i56 >>> 0 < i37 >>> 0) {
     i72 = i24;
     i73 = i21;
     i74 = i36;
     i75 = i70;
     i76 = i71;
     i77 = i22;
     break L1159;
    }
    if ((HEAP32[i23 + 20 >> 2] | 0) == (HEAP32[i68 >> 2] | 0)) {
     i72 = i24;
     i73 = i21;
     i74 = i36;
     i75 = i70;
     i76 = i71;
     i77 = i22;
     break L1159;
    }
    i56 = ___muldi3(i51, i50, i41, i40) | 0;
    i50 = tempRet0;
    i51 = ___muldi3(i55, i62, i43, i42) | 0;
    i62 = _i64Add(i51, tempRet0, i56, i50) | 0;
    i50 = tempRet0;
    i56 = ___muldi3(i53, i39, i30, i38) | 0;
    i39 = _i64Add(i62, i50, i56, tempRet0) | 0;
    i56 = tempRet0;
    if (!((i56 | 0) > (i24 | 0) | (i56 | 0) == (i24 | 0) & i39 >>> 0 > i21 >>> 0)) {
     i72 = i24;
     i73 = i21;
     i74 = i36;
     i75 = i70;
     i76 = i71;
     i77 = i22;
     break L1159;
    }
    HEAP32[i5 >> 2] = i23;
    i50 = HEAP32[i54 >> 2] | 0;
    i54 = HEAP32[i50 + 88 >> 2] | 0;
    i62 = HEAP32[i50 + 92 >> 2] | 0;
    i53 = HEAP32[i50 + 96 >> 2] | 0;
    if ((i50 | 0) == (i7 | 0)) {
     i72 = i56;
     i73 = i39;
     i74 = i54;
     i75 = i62;
     i76 = i53;
     i77 = i23;
     break;
    } else {
     i71 = i53;
     i70 = i62;
     i36 = i54;
     i24 = i56;
     i21 = i39;
     i22 = i23;
    }
   }
  }
 } while (0);
 i37 = _i64Subtract(i73, i72, i45, i44) | 0;
 i44 = tempRet0;
 i45 = 0;
 if ((i44 | 0) > (i45 | 0) | (i44 | 0) == (i45 | 0) & i37 >>> 0 > 0 >>> 0) {
  i45 = i1 + 100 | 0;
  i72 = _i64Subtract(0, 0, i31, i32) | 0;
  i73 = tempRet0;
  i28 = i11 + 16 | 0;
  i49 = i11 | 0;
  i69 = i11 + 8 | 0;
  i67 = i12 + 16 | 0;
  i20 = i12 | 0;
  i25 = i12 + 8 | 0;
  i26 = i9 + 16 | 0;
  i22 = i9 | 0;
  i21 = i9 + 8 | 0;
  i24 = i10 + 16 | 0;
  i36 = i10 | 0;
  i70 = i10 + 8 | 0;
  i71 = i44;
  i68 = i37;
  i23 = i74;
  i39 = i75;
  i56 = i76;
  i54 = i46;
  i62 = i47;
  i53 = i48;
  L1170 : while (1) {
   i50 = i71;
   i51 = i68;
   i55 = i23;
   i52 = i39;
   i19 = i56;
   L1172 : while (1) {
    i66 = Math_imul(i55 - i54 | 0, i27) | 0;
    i64 = Math_imul(i52 - i62 | 0, i29) | 0;
    i57 = i64 + (Math_imul(i19 - i53 | 0, i2) | 0) + i66 | 0;
    i66 = i57;
    i64 = (i57 | 0) < 0 ? -1 : 0;
    i78 = HEAP32[i4 >> 2] | 0;
    do {
     if ((i78 | 0) != 0) {
      if ((HEAP32[i78 + 12 >> 2] | 0) == (i6 | 0)) {
       break;
      }
      i79 = HEAP32[(HEAP32[i78 >> 2] | 0) + 8 >> 2] | 0;
      if ((HEAP32[i79 + 20 >> 2] | 0) <= (HEAP32[i45 >> 2] | 0)) {
       break;
      }
      i60 = HEAP32[i79 + 12 >> 2] | 0;
      i80 = HEAP32[i60 + 88 >> 2] | 0;
      i59 = i80 - i54 | 0;
      i81 = HEAP32[i60 + 92 >> 2] | 0;
      i63 = i81 - i62 | 0;
      i82 = HEAP32[i60 + 96 >> 2] | 0;
      i60 = i82 - i53 | 0;
      i58 = ___muldi3(i59, (i59 | 0) < 0 ? -1 : 0, i41, i40) | 0;
      i61 = tempRet0;
      i65 = ___muldi3(i63, (i63 | 0) < 0 ? -1 : 0, i43, i42) | 0;
      i83 = _i64Add(i65, tempRet0, i58, i61) | 0;
      i61 = tempRet0;
      i58 = ___muldi3(i60, (i60 | 0) < 0 ? -1 : 0, i30, i38) | 0;
      i65 = _i64Add(i83, i61, i58, tempRet0) | 0;
      i58 = tempRet0;
      i61 = Math_imul(i59, i27) | 0;
      i59 = (Math_imul(i63, i29) | 0) + i61 | 0;
      i61 = i59 + (Math_imul(i60, i2) | 0) | 0;
      i60 = i61;
      i59 = (i61 | 0) < 0 ? -1 : 0;
      if ((i65 | 0) == 0 & (i58 | 0) == 0) {
       if ((i61 | 0) < 0) {
        break L1172;
       } else {
        break;
       }
      }
      i63 = 0;
      if (!((i58 | 0) < (i63 | 0) | (i58 | 0) == (i63 | 0) & i65 >>> 0 < 0 >>> 0)) {
       break;
      }
      do {
       if ((i61 | 0) > 0) {
        HEAP32[i26 >> 2] = 1;
        HEAP32[i22 >> 2] = i60;
        HEAP32[i22 + 4 >> 2] = i59;
        i84 = 1;
       } else {
        if ((i61 | 0) < 0) {
         HEAP32[i26 >> 2] = -1;
         i63 = _i64Subtract(0, 0, i60, i59) | 0;
         HEAP32[i22 >> 2] = i63;
         HEAP32[i22 + 4 >> 2] = tempRet0;
         i84 = -1;
         break;
        } else {
         HEAP32[i26 >> 2] = 0;
         HEAP32[i22 >> 2] = 0;
         HEAP32[i22 + 4 >> 2] = 0;
         i84 = 0;
         break;
        }
       }
      } while (0);
      i59 = 0;
      if ((i58 | 0) > (i59 | 0) | (i58 | 0) == (i59 | 0) & i65 >>> 0 > 0 >>> 0) {
       i85 = i58;
       i86 = i65;
      } else {
       HEAP32[i26 >> 2] = -i84;
       i59 = _i64Subtract(0, 0, i65, i58) | 0;
       i85 = tempRet0;
       i86 = i59;
      }
      HEAP32[i21 >> 2] = i86;
      HEAP32[i21 + 4 >> 2] = i85;
      do {
       if ((i57 | 0) > 0) {
        HEAP32[i24 >> 2] = 1;
        HEAP32[i36 >> 2] = i66;
        HEAP32[i36 + 4 >> 2] = i64;
        i87 = 1;
       } else {
        if ((i57 | 0) < 0) {
         HEAP32[i24 >> 2] = -1;
         i59 = _i64Subtract(0, 0, i66, i64) | 0;
         HEAP32[i36 >> 2] = i59;
         HEAP32[i36 + 4 >> 2] = tempRet0;
         i87 = -1;
         break;
        } else {
         HEAP32[i24 >> 2] = 0;
         HEAP32[i36 >> 2] = 0;
         HEAP32[i36 + 4 >> 2] = 0;
         i87 = 0;
         break;
        }
       }
      } while (0);
      i58 = 0;
      do {
       if ((i50 | 0) > (i58 | 0) | (i50 | 0) == (i58 | 0) & i51 >>> 0 > 0 >>> 0) {
        HEAP32[i70 >> 2] = i51;
        HEAP32[i70 + 4 >> 2] = i50;
       } else {
        i65 = 0;
        if ((i50 | 0) < (i65 | 0) | (i50 | 0) == (i65 | 0) & i51 >>> 0 < 0 >>> 0) {
         HEAP32[i24 >> 2] = -i87;
         i65 = _i64Subtract(0, 0, i51, i50) | 0;
         HEAP32[i70 >> 2] = i65;
         HEAP32[i70 + 4 >> 2] = tempRet0;
         break;
        } else {
         HEAP32[i70 >> 2] = 0;
         HEAP32[i70 + 4 >> 2] = 0;
         break;
        }
       }
      } while (0);
      if ((__ZNK20btConvexHullInternal10Rational647compareERKS0_(i9, i10) | 0) > -1) {
       break L1172;
      }
     }
    } while (0);
    i58 = HEAP32[i5 >> 2] | 0;
    if ((i58 | 0) == 0) {
     i88 = 1019;
     break L1170;
    }
    if ((HEAP32[i58 + 12 >> 2] | 0) == (i7 | 0)) {
     i88 = 1008;
     break L1170;
    }
    i65 = HEAP32[HEAP32[i58 + 8 >> 2] >> 2] | 0;
    if ((HEAP32[i65 + 20 >> 2] | 0) <= (HEAP32[i45 >> 2] | 0)) {
     i88 = 1010;
     break L1170;
    }
    i58 = i65 + 12 | 0;
    i59 = HEAP32[i58 >> 2] | 0;
    i60 = HEAP32[i59 + 88 >> 2] | 0;
    i61 = i60 - i55 | 0;
    i63 = HEAP32[i59 + 92 >> 2] | 0;
    i83 = i63 - i52 | 0;
    i89 = HEAP32[i59 + 96 >> 2] | 0;
    i59 = i89 - i19 | 0;
    i90 = i61;
    i91 = (i61 | 0) < 0 ? -1 : 0;
    i92 = ___muldi3(i90, i91, i3, i34) | 0;
    i93 = tempRet0;
    i94 = i83;
    i95 = (i83 | 0) < 0 ? -1 : 0;
    i96 = ___muldi3(i94, i95, i33, i35) | 0;
    i97 = _i64Add(i96, tempRet0, i92, i93) | 0;
    i93 = tempRet0;
    i92 = i59;
    i96 = (i59 | 0) < 0 ? -1 : 0;
    i98 = ___muldi3(i92, i96, i72, i73) | 0;
    if (!((i97 | 0) == (i98 | 0) & (i93 | 0) == (tempRet0 | 0))) {
     i88 = 1004;
     break L1170;
    }
    i93 = ___muldi3(i90, i91, i41, i40) | 0;
    i91 = tempRet0;
    i90 = ___muldi3(i94, i95, i43, i42) | 0;
    i95 = _i64Add(i90, tempRet0, i93, i91) | 0;
    i91 = tempRet0;
    i93 = ___muldi3(i92, i96, i30, i38) | 0;
    i96 = _i64Add(i95, i91, i93, tempRet0) | 0;
    i93 = tempRet0;
    i91 = Math_imul(i61, i27) | 0;
    i61 = (Math_imul(i83, i29) | 0) + i91 | 0;
    i91 = i61 + (Math_imul(i59, i2) | 0) | 0;
    i59 = i91;
    i61 = (i91 | 0) < 0 ? -1 : 0;
    i83 = i60 - i54 | 0;
    i60 = i63 - i62 | 0;
    i63 = i89 - i53 | 0;
    i89 = ___muldi3(i83, (i83 | 0) < 0 ? -1 : 0, i41, i40) | 0;
    i83 = tempRet0;
    i95 = ___muldi3(i60, (i60 | 0) < 0 ? -1 : 0, i43, i42) | 0;
    i60 = _i64Add(i95, tempRet0, i89, i83) | 0;
    i83 = tempRet0;
    i89 = ___muldi3(i63, (i63 | 0) < 0 ? -1 : 0, i30, i38) | 0;
    i63 = _i64Add(i60, i83, i89, tempRet0) | 0;
    i89 = tempRet0;
    i83 = 0;
    if (!((i89 | 0) > (i83 | 0) | (i89 | 0) == (i83 | 0) & i63 >>> 0 > 0 >>> 0)) {
     i88 = 1005;
     break L1170;
    }
    if ((i96 | 0) == 0 & (i93 | 0) == 0) {
     if ((i91 | 0) >= 0) {
      i88 = 1011;
      break L1170;
     }
    } else {
     i83 = 0;
     if (!((i93 | 0) < (i83 | 0) | (i93 | 0) == (i83 | 0) & i96 >>> 0 < 0 >>> 0)) {
      i88 = 1009;
      break L1170;
     }
     do {
      if ((i91 | 0) > 0) {
       HEAP32[i28 >> 2] = 1;
       HEAP32[i49 >> 2] = i59;
       HEAP32[i49 + 4 >> 2] = i61;
       i99 = 1;
      } else {
       if ((i91 | 0) < 0) {
        HEAP32[i28 >> 2] = -1;
        i83 = _i64Subtract(0, 0, i59, i61) | 0;
        HEAP32[i49 >> 2] = i83;
        HEAP32[i49 + 4 >> 2] = tempRet0;
        i99 = -1;
        break;
       } else {
        HEAP32[i28 >> 2] = 0;
        HEAP32[i49 >> 2] = 0;
        HEAP32[i49 + 4 >> 2] = 0;
        i99 = 0;
        break;
       }
      }
     } while (0);
     i61 = 0;
     if ((i93 | 0) > (i61 | 0) | (i93 | 0) == (i61 | 0) & i96 >>> 0 > 0 >>> 0) {
      i100 = i93;
      i101 = i96;
     } else {
      HEAP32[i28 >> 2] = -i99;
      i61 = _i64Subtract(0, 0, i96, i93) | 0;
      i100 = tempRet0;
      i101 = i61;
     }
     HEAP32[i69 >> 2] = i101;
     HEAP32[i69 + 4 >> 2] = i100;
     do {
      if ((i57 | 0) > 0) {
       HEAP32[i67 >> 2] = 1;
       HEAP32[i20 >> 2] = i66;
       HEAP32[i20 + 4 >> 2] = i64;
       i102 = 1;
      } else {
       if ((i57 | 0) < 0) {
        HEAP32[i67 >> 2] = -1;
        i61 = _i64Subtract(0, 0, i66, i64) | 0;
        HEAP32[i20 >> 2] = i61;
        HEAP32[i20 + 4 >> 2] = tempRet0;
        i102 = -1;
        break;
       } else {
        HEAP32[i67 >> 2] = 0;
        HEAP32[i20 >> 2] = 0;
        HEAP32[i20 + 4 >> 2] = 0;
        i102 = 0;
        break;
       }
      }
     } while (0);
     i64 = 0;
     do {
      if ((i50 | 0) > (i64 | 0) | (i50 | 0) == (i64 | 0) & i51 >>> 0 > 0 >>> 0) {
       HEAP32[i25 >> 2] = i51;
       HEAP32[i25 + 4 >> 2] = i50;
      } else {
       i66 = 0;
       if ((i50 | 0) < (i66 | 0) | (i50 | 0) == (i66 | 0) & i51 >>> 0 < 0 >>> 0) {
        HEAP32[i67 >> 2] = -i102;
        i66 = _i64Subtract(0, 0, i51, i50) | 0;
        HEAP32[i25 >> 2] = i66;
        HEAP32[i25 + 4 >> 2] = tempRet0;
        break;
       } else {
        HEAP32[i25 >> 2] = 0;
        HEAP32[i25 + 4 >> 2] = 0;
        break;
       }
      }
     } while (0);
     if ((__ZNK20btConvexHullInternal10Rational647compareERKS0_(i11, i12) | 0) <= 0) {
      i88 = 1006;
      break L1170;
     }
    }
    HEAP32[i5 >> 2] = i65;
    i64 = HEAP32[i58 >> 2] | 0;
    i50 = i89;
    i51 = i63;
    i55 = HEAP32[i64 + 88 >> 2] | 0;
    i52 = HEAP32[i64 + 92 >> 2] | 0;
    i19 = HEAP32[i64 + 96 >> 2] | 0;
   }
   i51 = i55 - i80 | 0;
   i50 = i52 - i81 | 0;
   i64 = i19 - i82 | 0;
   i66 = ___muldi3(i51, (i51 | 0) < 0 ? -1 : 0, i41, i40) | 0;
   i51 = tempRet0;
   i57 = ___muldi3(i50, (i50 | 0) < 0 ? -1 : 0, i43, i42) | 0;
   i50 = _i64Add(i57, tempRet0, i66, i51) | 0;
   i51 = tempRet0;
   i66 = ___muldi3(i64, (i64 | 0) < 0 ? -1 : 0, i30, i38) | 0;
   i64 = _i64Add(i50, i51, i66, tempRet0) | 0;
   HEAP32[i4 >> 2] = (i78 | 0) == (i17 | 0) ? 0 : i79;
   i71 = tempRet0;
   i68 = i64;
   i23 = i55;
   i39 = i52;
   i56 = i19;
   i54 = i80;
   i62 = i81;
   i53 = i82;
  }
  if ((i88 | 0) == 1004) {
   STACKTOP = i8;
   return;
  } else if ((i88 | 0) == 1005) {
   STACKTOP = i8;
   return;
  } else if ((i88 | 0) == 1006) {
   STACKTOP = i8;
   return;
  } else if ((i88 | 0) == 1008) {
   STACKTOP = i8;
   return;
  } else if ((i88 | 0) == 1009) {
   STACKTOP = i8;
   return;
  } else if ((i88 | 0) == 1010) {
   STACKTOP = i8;
   return;
  } else if ((i88 | 0) == 1011) {
   STACKTOP = i8;
   return;
  } else if ((i88 | 0) == 1019) {
   STACKTOP = i8;
   return;
  }
 }
 i82 = 0;
 if (!((i44 | 0) < (i82 | 0) | (i44 | 0) == (i82 | 0) & i37 >>> 0 < 0 >>> 0)) {
  STACKTOP = i8;
  return;
 }
 i82 = i1 + 100 | 0;
 i1 = _i64Subtract(0, 0, i31, i32) | 0;
 i32 = tempRet0;
 i31 = i15 + 16 | 0;
 i53 = i15 | 0;
 i81 = i15 + 8 | 0;
 i62 = i16 + 16 | 0;
 i80 = i16 | 0;
 i54 = i16 + 8 | 0;
 i56 = i13 + 16 | 0;
 i39 = i13 | 0;
 i23 = i13 + 8 | 0;
 i68 = i14 + 16 | 0;
 i71 = i14 | 0;
 i79 = i14 + 8 | 0;
 i17 = i44;
 i44 = i37;
 i37 = i74;
 i74 = i75;
 i75 = i76;
 i76 = i46;
 i46 = i47;
 i47 = i48;
 i48 = i77;
 while (1) {
  i77 = Math_imul(i37 - i76 | 0, i27) | 0;
  i78 = Math_imul(i74 - i46 | 0, i29) | 0;
  i12 = i78 + (Math_imul(i75 - i47 | 0, i2) | 0) + i77 | 0;
  i77 = i12;
  i78 = (i12 | 0) < 0 ? -1 : 0;
  L1257 : do {
   if ((i48 | 0) == 0) {
    i103 = i75;
    i104 = i74;
    i105 = i37;
    i106 = i17;
    i107 = i44;
    i108 = i12;
    i109 = i78;
    i110 = i77;
   } else {
    i11 = i75;
    i25 = i74;
    i102 = i37;
    i67 = i17;
    i20 = i44;
    i100 = i12;
    i69 = i78;
    i101 = i77;
    i99 = i48;
    while (1) {
     if ((HEAP32[i99 + 12 >> 2] | 0) == (i7 | 0)) {
      i103 = i11;
      i104 = i25;
      i105 = i102;
      i106 = i67;
      i107 = i20;
      i108 = i100;
      i109 = i69;
      i110 = i101;
      break L1257;
     }
     i28 = HEAP32[(HEAP32[i99 + 4 >> 2] | 0) + 8 >> 2] | 0;
     if ((HEAP32[i28 + 20 >> 2] | 0) <= (HEAP32[i82 >> 2] | 0)) {
      i103 = i11;
      i104 = i25;
      i105 = i102;
      i106 = i67;
      i107 = i20;
      i108 = i100;
      i109 = i69;
      i110 = i101;
      break L1257;
     }
     i49 = HEAP32[i28 + 12 >> 2] | 0;
     i73 = HEAP32[i49 + 88 >> 2] | 0;
     i72 = i73 - i102 | 0;
     i45 = HEAP32[i49 + 92 >> 2] | 0;
     i10 = i45 - i25 | 0;
     i9 = HEAP32[i49 + 96 >> 2] | 0;
     i49 = i9 - i11 | 0;
     i70 = ___muldi3(i72, (i72 | 0) < 0 ? -1 : 0, i41, i40) | 0;
     i87 = tempRet0;
     i24 = ___muldi3(i10, (i10 | 0) < 0 ? -1 : 0, i43, i42) | 0;
     i36 = _i64Add(i24, tempRet0, i70, i87) | 0;
     i87 = tempRet0;
     i70 = ___muldi3(i49, (i49 | 0) < 0 ? -1 : 0, i30, i38) | 0;
     i24 = _i64Add(i36, i87, i70, tempRet0) | 0;
     i70 = tempRet0;
     i87 = Math_imul(i72, i27) | 0;
     i72 = (Math_imul(i10, i29) | 0) + i87 | 0;
     i87 = i72 + (Math_imul(i49, i2) | 0) | 0;
     i49 = i87;
     i72 = (i87 | 0) < 0 ? -1 : 0;
     if ((i24 | 0) == 0 & (i70 | 0) == 0) {
      if ((i87 | 0) <= 0) {
       i103 = i11;
       i104 = i25;
       i105 = i102;
       i106 = i67;
       i107 = i20;
       i108 = i100;
       i109 = i69;
       i110 = i101;
       break L1257;
      }
     } else {
      i10 = 0;
      if (!((i70 | 0) < (i10 | 0) | (i70 | 0) == (i10 | 0) & i24 >>> 0 < 0 >>> 0)) {
       i103 = i11;
       i104 = i25;
       i105 = i102;
       i106 = i67;
       i107 = i20;
       i108 = i100;
       i109 = i69;
       i110 = i101;
       break L1257;
      }
      do {
       if ((i87 | 0) > 0) {
        HEAP32[i56 >> 2] = 1;
        HEAP32[i39 >> 2] = i49;
        HEAP32[i39 + 4 >> 2] = i72;
        i111 = 1;
       } else {
        if ((i87 | 0) < 0) {
         HEAP32[i56 >> 2] = -1;
         i10 = _i64Subtract(0, 0, i49, i72) | 0;
         HEAP32[i39 >> 2] = i10;
         HEAP32[i39 + 4 >> 2] = tempRet0;
         i111 = -1;
         break;
        } else {
         HEAP32[i56 >> 2] = 0;
         HEAP32[i39 >> 2] = 0;
         HEAP32[i39 + 4 >> 2] = 0;
         i111 = 0;
         break;
        }
       }
      } while (0);
      i72 = 0;
      if ((i70 | 0) > (i72 | 0) | (i70 | 0) == (i72 | 0) & i24 >>> 0 > 0 >>> 0) {
       i112 = i70;
       i113 = i24;
      } else {
       HEAP32[i56 >> 2] = -i111;
       i72 = _i64Subtract(0, 0, i24, i70) | 0;
       i112 = tempRet0;
       i113 = i72;
      }
      HEAP32[i23 >> 2] = i113;
      HEAP32[i23 + 4 >> 2] = i112;
      do {
       if ((i100 | 0) > 0) {
        HEAP32[i68 >> 2] = 1;
        HEAP32[i71 >> 2] = i101;
        HEAP32[i71 + 4 >> 2] = i69;
        i114 = 1;
       } else {
        if ((i100 | 0) < 0) {
         HEAP32[i68 >> 2] = -1;
         i72 = _i64Subtract(0, 0, i101, i69) | 0;
         HEAP32[i71 >> 2] = i72;
         HEAP32[i71 + 4 >> 2] = tempRet0;
         i114 = -1;
         break;
        } else {
         HEAP32[i68 >> 2] = 0;
         HEAP32[i71 >> 2] = 0;
         HEAP32[i71 + 4 >> 2] = 0;
         i114 = 0;
         break;
        }
       }
      } while (0);
      i70 = 0;
      do {
       if ((i67 | 0) > (i70 | 0) | (i67 | 0) == (i70 | 0) & i20 >>> 0 > 0 >>> 0) {
        HEAP32[i79 >> 2] = i20;
        HEAP32[i79 + 4 >> 2] = i67;
       } else {
        i24 = 0;
        if ((i67 | 0) < (i24 | 0) | (i67 | 0) == (i24 | 0) & i20 >>> 0 < 0 >>> 0) {
         HEAP32[i68 >> 2] = -i114;
         i24 = _i64Subtract(0, 0, i20, i67) | 0;
         HEAP32[i79 >> 2] = i24;
         HEAP32[i79 + 4 >> 2] = tempRet0;
         break;
        } else {
         HEAP32[i79 >> 2] = 0;
         HEAP32[i79 + 4 >> 2] = 0;
         break;
        }
       }
      } while (0);
      if ((__ZNK20btConvexHullInternal10Rational647compareERKS0_(i13, i14) | 0) >= 1) {
       i103 = i11;
       i104 = i25;
       i105 = i102;
       i106 = i67;
       i107 = i20;
       i108 = i100;
       i109 = i69;
       i110 = i101;
       break L1257;
      }
     }
     i70 = i73 - i76 | 0;
     i24 = i45 - i46 | 0;
     i72 = i9 - i47 | 0;
     i49 = ___muldi3(i70, (i70 | 0) < 0 ? -1 : 0, i41, i40) | 0;
     i87 = tempRet0;
     i10 = ___muldi3(i24, (i24 | 0) < 0 ? -1 : 0, i43, i42) | 0;
     i36 = _i64Add(i10, tempRet0, i49, i87) | 0;
     i87 = tempRet0;
     i49 = ___muldi3(i72, (i72 | 0) < 0 ? -1 : 0, i30, i38) | 0;
     i10 = _i64Add(i36, i87, i49, tempRet0) | 0;
     i49 = tempRet0;
     i87 = (i99 | 0) == (i18 | 0) ? 0 : i28;
     HEAP32[i5 >> 2] = i87;
     i36 = Math_imul(i70, i27) | 0;
     i70 = Math_imul(i24, i29) | 0;
     i24 = i70 + i36 + (Math_imul(i72, i2) | 0) | 0;
     i72 = i24;
     i36 = (i24 | 0) < 0 ? -1 : 0;
     if ((i87 | 0) == 0) {
      i103 = i9;
      i104 = i45;
      i105 = i73;
      i106 = i49;
      i107 = i10;
      i108 = i24;
      i109 = i36;
      i110 = i72;
      break;
     } else {
      i11 = i9;
      i25 = i45;
      i102 = i73;
      i67 = i49;
      i20 = i10;
      i100 = i24;
      i69 = i36;
      i101 = i72;
      i99 = i87;
     }
    }
   }
  } while (0);
  i77 = HEAP32[i4 >> 2] | 0;
  if ((i77 | 0) == 0) {
   i88 = 1012;
   break;
  }
  if ((HEAP32[i77 + 12 >> 2] | 0) == (i6 | 0)) {
   i88 = 1013;
   break;
  }
  i78 = HEAP32[(HEAP32[i77 + 8 >> 2] | 0) + 4 >> 2] | 0;
  if ((HEAP32[i78 + 20 >> 2] | 0) <= (HEAP32[i82 >> 2] | 0)) {
   i88 = 1014;
   break;
  }
  i77 = i78 + 12 | 0;
  i12 = HEAP32[i77 >> 2] | 0;
  i19 = HEAP32[i12 + 88 >> 2] | 0;
  i52 = i19 - i76 | 0;
  i55 = HEAP32[i12 + 92 >> 2] | 0;
  i99 = i55 - i46 | 0;
  i101 = HEAP32[i12 + 96 >> 2] | 0;
  i12 = i101 - i47 | 0;
  i69 = i52;
  i100 = (i52 | 0) < 0 ? -1 : 0;
  i20 = ___muldi3(i69, i100, i3, i34) | 0;
  i67 = tempRet0;
  i102 = i99;
  i25 = (i99 | 0) < 0 ? -1 : 0;
  i11 = ___muldi3(i102, i25, i33, i35) | 0;
  i63 = _i64Add(i11, tempRet0, i20, i67) | 0;
  i67 = tempRet0;
  i20 = i12;
  i11 = (i12 | 0) < 0 ? -1 : 0;
  i89 = ___muldi3(i20, i11, i1, i32) | 0;
  if (!((i63 | 0) == (i89 | 0) & (i67 | 0) == (tempRet0 | 0))) {
   i88 = 1015;
   break;
  }
  i67 = ___muldi3(i69, i100, i41, i40) | 0;
  i100 = tempRet0;
  i69 = ___muldi3(i102, i25, i43, i42) | 0;
  i25 = _i64Add(i69, tempRet0, i67, i100) | 0;
  i100 = tempRet0;
  i67 = ___muldi3(i20, i11, i30, i38) | 0;
  i11 = _i64Add(i25, i100, i67, tempRet0) | 0;
  i67 = tempRet0;
  i100 = Math_imul(i52, i27) | 0;
  i52 = (Math_imul(i99, i29) | 0) + i100 | 0;
  i100 = i52 + (Math_imul(i12, i2) | 0) | 0;
  i12 = i100;
  i52 = (i100 | 0) < 0 ? -1 : 0;
  i99 = i105 - i19 | 0;
  i19 = i104 - i55 | 0;
  i55 = i103 - i101 | 0;
  i101 = ___muldi3(i99, (i99 | 0) < 0 ? -1 : 0, i41, i40) | 0;
  i99 = tempRet0;
  i25 = ___muldi3(i19, (i19 | 0) < 0 ? -1 : 0, i43, i42) | 0;
  i19 = _i64Add(i25, tempRet0, i101, i99) | 0;
  i99 = tempRet0;
  i101 = ___muldi3(i55, (i55 | 0) < 0 ? -1 : 0, i30, i38) | 0;
  i55 = _i64Add(i19, i99, i101, tempRet0) | 0;
  i101 = tempRet0;
  i99 = 0;
  if (!((i101 | 0) < (i99 | 0) | (i101 | 0) == (i99 | 0) & i55 >>> 0 < 0 >>> 0)) {
   i88 = 1016;
   break;
  }
  if ((i11 | 0) == 0 & (i67 | 0) == 0) {
   if ((i100 | 0) <= 0) {
    i88 = 1017;
    break;
   }
  } else {
   i99 = 0;
   if (!((i67 | 0) < (i99 | 0) | (i67 | 0) == (i99 | 0) & i11 >>> 0 < 0 >>> 0)) {
    i88 = 1018;
    break;
   }
   do {
    if ((i100 | 0) > 0) {
     HEAP32[i31 >> 2] = 1;
     HEAP32[i53 >> 2] = i12;
     HEAP32[i53 + 4 >> 2] = i52;
     i115 = 1;
    } else {
     if ((i100 | 0) < 0) {
      HEAP32[i31 >> 2] = -1;
      i99 = _i64Subtract(0, 0, i12, i52) | 0;
      HEAP32[i53 >> 2] = i99;
      HEAP32[i53 + 4 >> 2] = tempRet0;
      i115 = -1;
      break;
     } else {
      HEAP32[i31 >> 2] = 0;
      HEAP32[i53 >> 2] = 0;
      HEAP32[i53 + 4 >> 2] = 0;
      i115 = 0;
      break;
     }
    }
   } while (0);
   i52 = 0;
   if ((i67 | 0) > (i52 | 0) | (i67 | 0) == (i52 | 0) & i11 >>> 0 > 0 >>> 0) {
    i116 = i67;
    i117 = i11;
   } else {
    HEAP32[i31 >> 2] = -i115;
    i52 = _i64Subtract(0, 0, i11, i67) | 0;
    i116 = tempRet0;
    i117 = i52;
   }
   HEAP32[i81 >> 2] = i117;
   HEAP32[i81 + 4 >> 2] = i116;
   do {
    if ((i108 | 0) > 0) {
     HEAP32[i62 >> 2] = 1;
     HEAP32[i80 >> 2] = i110;
     HEAP32[i80 + 4 >> 2] = i109;
     i118 = 1;
    } else {
     if ((i108 | 0) < 0) {
      HEAP32[i62 >> 2] = -1;
      i52 = _i64Subtract(0, 0, i110, i109) | 0;
      HEAP32[i80 >> 2] = i52;
      HEAP32[i80 + 4 >> 2] = tempRet0;
      i118 = -1;
      break;
     } else {
      HEAP32[i62 >> 2] = 0;
      HEAP32[i80 >> 2] = 0;
      HEAP32[i80 + 4 >> 2] = 0;
      i118 = 0;
      break;
     }
    }
   } while (0);
   i67 = 0;
   do {
    if ((i106 | 0) > (i67 | 0) | (i106 | 0) == (i67 | 0) & i107 >>> 0 > 0 >>> 0) {
     HEAP32[i54 >> 2] = i107;
     HEAP32[i54 + 4 >> 2] = i106;
    } else {
     i11 = 0;
     if ((i106 | 0) < (i11 | 0) | (i106 | 0) == (i11 | 0) & i107 >>> 0 < 0 >>> 0) {
      HEAP32[i62 >> 2] = -i118;
      i11 = _i64Subtract(0, 0, i107, i106) | 0;
      HEAP32[i54 >> 2] = i11;
      HEAP32[i54 + 4 >> 2] = tempRet0;
      break;
     } else {
      HEAP32[i54 >> 2] = 0;
      HEAP32[i54 + 4 >> 2] = 0;
      break;
     }
    }
   } while (0);
   if ((__ZNK20btConvexHullInternal10Rational647compareERKS0_(i15, i16) | 0) >= 0) {
    i88 = 1020;
    break;
   }
  }
  HEAP32[i4 >> 2] = i78;
  i67 = HEAP32[i77 >> 2] | 0;
  i17 = i101;
  i44 = i55;
  i37 = i105;
  i74 = i104;
  i75 = i103;
  i76 = HEAP32[i67 + 88 >> 2] | 0;
  i46 = HEAP32[i67 + 92 >> 2] | 0;
  i47 = HEAP32[i67 + 96 >> 2] | 0;
  i48 = HEAP32[i5 >> 2] | 0;
 }
 if ((i88 | 0) == 1012) {
  STACKTOP = i8;
  return;
 } else if ((i88 | 0) == 1013) {
  STACKTOP = i8;
  return;
 } else if ((i88 | 0) == 1014) {
  STACKTOP = i8;
  return;
 } else if ((i88 | 0) == 1015) {
  STACKTOP = i8;
  return;
 } else if ((i88 | 0) == 1016) {
  STACKTOP = i8;
  return;
 } else if ((i88 | 0) == 1017) {
  STACKTOP = i8;
  return;
 } else if ((i88 | 0) == 1018) {
  STACKTOP = i8;
  return;
 } else if ((i88 | 0) == 1020) {
  STACKTOP = i8;
  return;
 }
}
function __ZN23btDiscreteDynamicsWorld19debugDrawConstraintEP17btTypedConstraint(i1, i2) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 var i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, d44 = 0.0, d45 = 0.0, d46 = 0.0, d47 = 0.0, d48 = 0.0, d49 = 0.0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0, i62 = 0, i63 = 0, i64 = 0, i65 = 0, i66 = 0, i67 = 0, i68 = 0, d69 = 0.0, d70 = 0.0, d71 = 0.0, d72 = 0.0, d73 = 0.0, d74 = 0.0, d75 = 0.0, d76 = 0.0, d77 = 0.0, d78 = 0.0, d79 = 0.0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 1008 | 0;
 i4 = i3 | 0;
 i5 = i3 + 64 | 0;
 i6 = i3 + 128 | 0;
 i7 = i3 + 192 | 0;
 i8 = i3 + 208 | 0;
 i9 = i3 + 224 | 0;
 i10 = i3 + 240 | 0;
 i11 = i3 + 304 | 0;
 i12 = i3 + 368 | 0;
 i13 = i3 + 384 | 0;
 i14 = i3 + 400 | 0;
 i15 = i3 + 416 | 0;
 i16 = i3 + 432 | 0;
 i17 = i3 + 496 | 0;
 i18 = i3 + 560 | 0;
 i19 = i3 + 576 | 0;
 i20 = i3 + 592 | 0;
 i21 = i3 + 608 | 0;
 i22 = i3 + 624 | 0;
 i23 = i3 + 688 | 0;
 i24 = i3 + 704 | 0;
 i25 = i3 + 720 | 0;
 i26 = i3 + 736 | 0;
 i27 = i3 + 752 | 0;
 i28 = i3 + 768 | 0;
 i29 = i3 + 784 | 0;
 i30 = i3 + 800 | 0;
 i31 = i3 + 816 | 0;
 i32 = i3 + 832 | 0;
 i33 = i3 + 848 | 0;
 i34 = i3 + 912 | 0;
 i35 = i3 + 928 | 0;
 i36 = i3 + 944 | 0;
 i37 = i3 + 960 | 0;
 i38 = i3 + 976 | 0;
 i39 = i3 + 992 | 0;
 i40 = i1 | 0;
 i41 = i1;
 i1 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
 i42 = (FUNCTION_TABLE_ii[HEAP32[(HEAP32[i1 >> 2] | 0) + 48 >> 2] & 127](i1) | 0) >>> 11;
 i1 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
 i43 = (FUNCTION_TABLE_ii[HEAP32[(HEAP32[i1 >> 2] | 0) + 48 >> 2] & 127](i1) | 0) >>> 12;
 d44 = +HEAPF32[i2 + 36 >> 2];
 if (d44 <= 0.0) {
  STACKTOP = i3;
  return;
 }
 switch (HEAP32[i2 + 4 >> 2] | 0) {
 case 3:
  {
   HEAPF32[i4 >> 2] = 1.0;
   _memset(i4 + 4 | 0, 0, 16);
   HEAPF32[i4 + 20 >> 2] = 1.0;
   _memset(i4 + 24 | 0, 0, 16);
   HEAPF32[i4 + 40 >> 2] = 1.0;
   _memset(i4 + 44 | 0, 0, 20);
   d45 = +HEAPF32[i2 + 292 >> 2];
   d46 = +HEAPF32[i2 + 296 >> 2];
   d47 = +HEAPF32[i2 + 300 >> 2];
   i1 = HEAP32[i2 + 24 >> 2] | 0;
   d48 = +HEAPF32[i1 + 56 >> 2] + (d45 * +HEAPF32[i1 + 20 >> 2] + d46 * +HEAPF32[i1 + 24 >> 2] + d47 * +HEAPF32[i1 + 28 >> 2]);
   d49 = +HEAPF32[i1 + 60 >> 2] + (d45 * +HEAPF32[i1 + 36 >> 2] + d46 * +HEAPF32[i1 + 40 >> 2] + d47 * +HEAPF32[i1 + 44 >> 2]);
   i50 = i4 + 48 | 0;
   HEAPF32[i50 >> 2] = +HEAPF32[i1 + 52 >> 2] + (d45 * +HEAPF32[i1 + 4 >> 2] + d46 * +HEAPF32[i1 + 8 >> 2] + d47 * +HEAPF32[i1 + 12 >> 2]);
   i1 = i4 + 52 | 0;
   HEAPF32[i1 >> 2] = d48;
   i51 = i4 + 56 | 0;
   HEAPF32[i51 >> 2] = d49;
   i52 = i4 + 60 | 0;
   HEAPF32[i52 >> 2] = 0.0;
   i53 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
   FUNCTION_TABLE_viif[HEAP32[(HEAP32[i53 >> 2] | 0) + 56 >> 2] & 3](i53, i4, d44);
   d49 = +HEAPF32[i2 + 308 >> 2];
   d48 = +HEAPF32[i2 + 312 >> 2];
   d47 = +HEAPF32[i2 + 316 >> 2];
   i53 = HEAP32[i2 + 28 >> 2] | 0;
   d46 = +HEAPF32[i53 + 56 >> 2] + (d49 * +HEAPF32[i53 + 20 >> 2] + d48 * +HEAPF32[i53 + 24 >> 2] + d47 * +HEAPF32[i53 + 28 >> 2]);
   d45 = +HEAPF32[i53 + 60 >> 2] + (d49 * +HEAPF32[i53 + 36 >> 2] + d48 * +HEAPF32[i53 + 40 >> 2] + d47 * +HEAPF32[i53 + 44 >> 2]);
   HEAPF32[i50 >> 2] = +HEAPF32[i53 + 52 >> 2] + (d49 * +HEAPF32[i53 + 4 >> 2] + d48 * +HEAPF32[i53 + 8 >> 2] + d47 * +HEAPF32[i53 + 12 >> 2]);
   HEAPF32[i1 >> 2] = d46;
   HEAPF32[i51 >> 2] = d45;
   HEAPF32[i52 >> 2] = 0.0;
   if ((i42 & 1 | 0) == 0) {
    STACKTOP = i3;
    return;
   }
   i52 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
   FUNCTION_TABLE_viif[HEAP32[(HEAP32[i52 >> 2] | 0) + 56 >> 2] & 3](i52, i4, d44);
   STACKTOP = i3;
   return;
  }
 case 4:
  {
   __ZNK11btTransformmlERKS_(i5, (HEAP32[i2 + 24 >> 2] | 0) + 4 | 0, i2 + 544 | 0);
   if ((i42 & 1 | 0) == 0) {
    __ZNK11btTransformmlERKS_(i6, (HEAP32[i2 + 28 >> 2] | 0) + 4 | 0, i2 + 608 | 0);
    i4 = i5;
    i52 = i6;
    HEAP32[i4 >> 2] = HEAP32[i52 >> 2];
    HEAP32[i4 + 4 >> 2] = HEAP32[i52 + 4 >> 2];
    HEAP32[i4 + 8 >> 2] = HEAP32[i52 + 8 >> 2];
    HEAP32[i4 + 12 >> 2] = HEAP32[i52 + 12 >> 2];
    i52 = i5 + 16 | 0;
    i4 = i6 + 16 | 0;
    HEAP32[i52 >> 2] = HEAP32[i4 >> 2];
    HEAP32[i52 + 4 >> 2] = HEAP32[i4 + 4 >> 2];
    HEAP32[i52 + 8 >> 2] = HEAP32[i4 + 8 >> 2];
    HEAP32[i52 + 12 >> 2] = HEAP32[i4 + 12 >> 2];
    i4 = i5 + 32 | 0;
    i52 = i6 + 32 | 0;
    HEAP32[i4 >> 2] = HEAP32[i52 >> 2];
    HEAP32[i4 + 4 >> 2] = HEAP32[i52 + 4 >> 2];
    HEAP32[i4 + 8 >> 2] = HEAP32[i52 + 8 >> 2];
    HEAP32[i4 + 12 >> 2] = HEAP32[i52 + 12 >> 2];
    i52 = i5 + 48 | 0;
    i4 = i6 + 48 | 0;
    HEAP32[i52 >> 2] = HEAP32[i4 >> 2];
    HEAP32[i52 + 4 >> 2] = HEAP32[i4 + 4 >> 2];
    HEAP32[i52 + 8 >> 2] = HEAP32[i4 + 8 >> 2];
    HEAP32[i52 + 12 >> 2] = HEAP32[i4 + 12 >> 2];
   } else {
    i4 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
    FUNCTION_TABLE_viif[HEAP32[(HEAP32[i4 >> 2] | 0) + 56 >> 2] & 3](i4, i5, d44);
    __ZNK11btTransformmlERKS_(i6, (HEAP32[i2 + 28 >> 2] | 0) + 4 | 0, i2 + 608 | 0);
    i4 = i5;
    i52 = i6;
    HEAP32[i4 >> 2] = HEAP32[i52 >> 2];
    HEAP32[i4 + 4 >> 2] = HEAP32[i52 + 4 >> 2];
    HEAP32[i4 + 8 >> 2] = HEAP32[i52 + 8 >> 2];
    HEAP32[i4 + 12 >> 2] = HEAP32[i52 + 12 >> 2];
    i52 = i5 + 16 | 0;
    i4 = i6 + 16 | 0;
    HEAP32[i52 >> 2] = HEAP32[i4 >> 2];
    HEAP32[i52 + 4 >> 2] = HEAP32[i4 + 4 >> 2];
    HEAP32[i52 + 8 >> 2] = HEAP32[i4 + 8 >> 2];
    HEAP32[i52 + 12 >> 2] = HEAP32[i4 + 12 >> 2];
    i4 = i5 + 32 | 0;
    i52 = i6 + 32 | 0;
    HEAP32[i4 >> 2] = HEAP32[i52 >> 2];
    HEAP32[i4 + 4 >> 2] = HEAP32[i52 + 4 >> 2];
    HEAP32[i4 + 8 >> 2] = HEAP32[i52 + 8 >> 2];
    HEAP32[i4 + 12 >> 2] = HEAP32[i52 + 12 >> 2];
    i52 = i5 + 48 | 0;
    i4 = i6 + 48 | 0;
    HEAP32[i52 >> 2] = HEAP32[i4 >> 2];
    HEAP32[i52 + 4 >> 2] = HEAP32[i4 + 4 >> 2];
    HEAP32[i52 + 8 >> 2] = HEAP32[i4 + 8 >> 2];
    HEAP32[i52 + 12 >> 2] = HEAP32[i4 + 12 >> 2];
    i4 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
    FUNCTION_TABLE_viif[HEAP32[(HEAP32[i4 >> 2] | 0) + 56 >> 2] & 3](i4, i5, d44);
   }
   i4 = i2 + 680 | 0;
   d45 = +__ZNK14btAngularLimit6getLowEv(i4);
   d46 = +__ZNK14btAngularLimit7getHighEv(i4);
   if (d45 == d46) {
    STACKTOP = i3;
    return;
   }
   i4 = d45 > d46;
   if ((i43 & 1 | 0) == 0) {
    STACKTOP = i3;
    return;
   }
   HEAPF32[i7 >> 2] = +HEAPF32[i5 + 8 >> 2];
   HEAPF32[i7 + 4 >> 2] = +HEAPF32[i5 + 24 >> 2];
   HEAPF32[i7 + 8 >> 2] = +HEAPF32[i5 + 40 >> 2];
   HEAPF32[i7 + 12 >> 2] = 0.0;
   HEAPF32[i8 >> 2] = +HEAPF32[i5 >> 2];
   HEAPF32[i8 + 4 >> 2] = +HEAPF32[i5 + 16 >> 2];
   HEAPF32[i8 + 8 >> 2] = +HEAPF32[i5 + 32 >> 2];
   HEAPF32[i8 + 12 >> 2] = 0.0;
   i52 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
   i6 = HEAP32[(HEAP32[i52 >> 2] | 0) + 60 >> 2] | 0;
   _memset(i9 | 0, 0, 16);
   FUNCTION_TABLE_viiiiffffiif[i6 & 1](i52, i5 + 48 | 0, i7, i8, d44, d44, i4 ? 0.0 : d45, i4 ? 6.2831854820251465 : d46, i9, i4 ^ 1, 10.0);
   STACKTOP = i3;
   return;
  }
 case 5:
  {
   i4 = i2;
   i9 = i2 + 24 | 0;
   i8 = i2 + 292 | 0;
   __ZNK11btTransformmlERKS_(i10, (HEAP32[i9 >> 2] | 0) + 4 | 0, i8);
   if ((i42 & 1 | 0) == 0) {
    __ZNK11btTransformmlERKS_(i11, (HEAP32[i2 + 28 >> 2] | 0) + 4 | 0, i2 + 356 | 0);
    i7 = i10;
    i5 = i11;
    HEAP32[i7 >> 2] = HEAP32[i5 >> 2];
    HEAP32[i7 + 4 >> 2] = HEAP32[i5 + 4 >> 2];
    HEAP32[i7 + 8 >> 2] = HEAP32[i5 + 8 >> 2];
    HEAP32[i7 + 12 >> 2] = HEAP32[i5 + 12 >> 2];
    i5 = i10 + 16 | 0;
    i7 = i11 + 16 | 0;
    HEAP32[i5 >> 2] = HEAP32[i7 >> 2];
    HEAP32[i5 + 4 >> 2] = HEAP32[i7 + 4 >> 2];
    HEAP32[i5 + 8 >> 2] = HEAP32[i7 + 8 >> 2];
    HEAP32[i5 + 12 >> 2] = HEAP32[i7 + 12 >> 2];
    i7 = i10 + 32 | 0;
    i5 = i11 + 32 | 0;
    HEAP32[i7 >> 2] = HEAP32[i5 >> 2];
    HEAP32[i7 + 4 >> 2] = HEAP32[i5 + 4 >> 2];
    HEAP32[i7 + 8 >> 2] = HEAP32[i5 + 8 >> 2];
    HEAP32[i7 + 12 >> 2] = HEAP32[i5 + 12 >> 2];
    i5 = i10 + 48 | 0;
    i7 = i11 + 48 | 0;
    HEAP32[i5 >> 2] = HEAP32[i7 >> 2];
    HEAP32[i5 + 4 >> 2] = HEAP32[i7 + 4 >> 2];
    HEAP32[i5 + 8 >> 2] = HEAP32[i7 + 8 >> 2];
    HEAP32[i5 + 12 >> 2] = HEAP32[i7 + 12 >> 2];
   } else {
    i7 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
    FUNCTION_TABLE_viif[HEAP32[(HEAP32[i7 >> 2] | 0) + 56 >> 2] & 3](i7, i10, d44);
    __ZNK11btTransformmlERKS_(i11, (HEAP32[i2 + 28 >> 2] | 0) + 4 | 0, i2 + 356 | 0);
    i7 = i10;
    i5 = i11;
    HEAP32[i7 >> 2] = HEAP32[i5 >> 2];
    HEAP32[i7 + 4 >> 2] = HEAP32[i5 + 4 >> 2];
    HEAP32[i7 + 8 >> 2] = HEAP32[i5 + 8 >> 2];
    HEAP32[i7 + 12 >> 2] = HEAP32[i5 + 12 >> 2];
    i5 = i10 + 16 | 0;
    i7 = i11 + 16 | 0;
    HEAP32[i5 >> 2] = HEAP32[i7 >> 2];
    HEAP32[i5 + 4 >> 2] = HEAP32[i7 + 4 >> 2];
    HEAP32[i5 + 8 >> 2] = HEAP32[i7 + 8 >> 2];
    HEAP32[i5 + 12 >> 2] = HEAP32[i7 + 12 >> 2];
    i7 = i10 + 32 | 0;
    i5 = i11 + 32 | 0;
    HEAP32[i7 >> 2] = HEAP32[i5 >> 2];
    HEAP32[i7 + 4 >> 2] = HEAP32[i5 + 4 >> 2];
    HEAP32[i7 + 8 >> 2] = HEAP32[i5 + 8 >> 2];
    HEAP32[i7 + 12 >> 2] = HEAP32[i5 + 12 >> 2];
    i5 = i10 + 48 | 0;
    i7 = i11 + 48 | 0;
    HEAP32[i5 >> 2] = HEAP32[i7 >> 2];
    HEAP32[i5 + 4 >> 2] = HEAP32[i7 + 4 >> 2];
    HEAP32[i5 + 8 >> 2] = HEAP32[i7 + 8 >> 2];
    HEAP32[i5 + 12 >> 2] = HEAP32[i7 + 12 >> 2];
    i7 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
    FUNCTION_TABLE_viif[HEAP32[(HEAP32[i7 >> 2] | 0) + 56 >> 2] & 3](i7, i10, d44);
   }
   if ((i43 & 1 | 0) == 0) {
    STACKTOP = i3;
    return;
   }
   __ZNK21btConeTwistConstraint16GetPointForAngleEff(i12, i4, 6.0868353843688965, d44);
   i7 = i10 | 0;
   i5 = i12 | 0;
   d46 = +HEAPF32[i5 >> 2];
   i11 = i10 + 4 | 0;
   i52 = i12 + 4 | 0;
   d45 = +HEAPF32[i52 >> 2];
   i6 = i10 + 8 | 0;
   i51 = i12 + 8 | 0;
   d47 = +HEAPF32[i51 >> 2];
   i1 = i10 + 48 | 0;
   i53 = i10 + 16 | 0;
   i50 = i10 + 20 | 0;
   i54 = i10 + 24 | 0;
   i55 = i10 + 52 | 0;
   d48 = +HEAPF32[i55 >> 2] + (d46 * +HEAPF32[i53 >> 2] + d45 * +HEAPF32[i50 >> 2] + d47 * +HEAPF32[i54 >> 2]);
   i56 = i10 + 32 | 0;
   i57 = i10 + 36 | 0;
   i58 = i10 + 40 | 0;
   i59 = i10 + 56 | 0;
   d49 = +HEAPF32[i59 >> 2] + (d46 * +HEAPF32[i56 >> 2] + d45 * +HEAPF32[i57 >> 2] + d47 * +HEAPF32[i58 >> 2]);
   i60 = i12;
   HEAPF32[i5 >> 2] = +HEAPF32[i1 >> 2] + (+HEAPF32[i7 >> 2] * d46 + +HEAPF32[i11 >> 2] * d45 + +HEAPF32[i6 >> 2] * d47);
   HEAPF32[i52 >> 2] = d48;
   HEAPF32[i51 >> 2] = d49;
   HEAPF32[i12 + 12 >> 2] = 0.0;
   i51 = i13 | 0;
   i52 = i13 + 4 | 0;
   i5 = i13 + 8 | 0;
   i61 = i13;
   i62 = i13 + 12 | 0;
   i63 = i10 + 48 | 0;
   i64 = i14;
   i65 = i15;
   i66 = 0;
   do {
    __ZNK21btConeTwistConstraint16GetPointForAngleEff(i13, i4, +(i66 | 0) * 6.283185005187988 * .03125, d44);
    d49 = +HEAPF32[i51 >> 2];
    d48 = +HEAPF32[i52 >> 2];
    d47 = +HEAPF32[i5 >> 2];
    d45 = +HEAPF32[i55 >> 2] + (d49 * +HEAPF32[i53 >> 2] + d48 * +HEAPF32[i50 >> 2] + d47 * +HEAPF32[i54 >> 2]);
    d46 = +HEAPF32[i59 >> 2] + (d49 * +HEAPF32[i56 >> 2] + d48 * +HEAPF32[i57 >> 2] + d47 * +HEAPF32[i58 >> 2]);
    HEAPF32[i51 >> 2] = +HEAPF32[i1 >> 2] + (+HEAPF32[i7 >> 2] * d49 + +HEAPF32[i11 >> 2] * d48 + +HEAPF32[i6 >> 2] * d47);
    HEAPF32[i52 >> 2] = d45;
    HEAPF32[i5 >> 2] = d46;
    HEAPF32[i62 >> 2] = 0.0;
    i67 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
    i68 = HEAP32[(HEAP32[i67 >> 2] | 0) + 8 >> 2] | 0;
    _memset(i64 | 0, 0, 16);
    FUNCTION_TABLE_viiii[i68 & 127](i67, i12, i13, i14);
    if ((i66 & 3 | 0) == 0) {
     i67 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
     i68 = HEAP32[(HEAP32[i67 >> 2] | 0) + 8 >> 2] | 0;
     _memset(i65 | 0, 0, 16);
     FUNCTION_TABLE_viiii[i68 & 127](i67, i63, i13, i15);
    }
    HEAP32[i60 >> 2] = HEAP32[i61 >> 2];
    HEAP32[i60 + 4 >> 2] = HEAP32[i61 + 4 >> 2];
    HEAP32[i60 + 8 >> 2] = HEAP32[i61 + 8 >> 2];
    HEAP32[i60 + 12 >> 2] = HEAP32[i61 + 12 >> 2];
    i66 = i66 + 1 | 0;
   } while ((i66 | 0) < 32);
   d46 = +HEAPF32[i2 + 444 >> 2];
   d45 = +HEAPF32[i2 + 504 >> 2];
   i66 = HEAP32[i2 + 28 >> 2] | 0;
   if (+HEAPF32[i66 + 336 >> 2] > 0.0) {
    __ZNK11btTransformmlERKS_(i16, i66 + 4 | 0, i2 + 356 | 0);
    i66 = i10;
    i61 = i16;
    HEAP32[i66 >> 2] = HEAP32[i61 >> 2];
    HEAP32[i66 + 4 >> 2] = HEAP32[i61 + 4 >> 2];
    HEAP32[i66 + 8 >> 2] = HEAP32[i61 + 8 >> 2];
    HEAP32[i66 + 12 >> 2] = HEAP32[i61 + 12 >> 2];
    i61 = i10 + 16 | 0;
    i66 = i16 + 16 | 0;
    HEAP32[i61 >> 2] = HEAP32[i66 >> 2];
    HEAP32[i61 + 4 >> 2] = HEAP32[i66 + 4 >> 2];
    HEAP32[i61 + 8 >> 2] = HEAP32[i66 + 8 >> 2];
    HEAP32[i61 + 12 >> 2] = HEAP32[i66 + 12 >> 2];
    i66 = i10 + 32 | 0;
    i61 = i16 + 32 | 0;
    HEAP32[i66 >> 2] = HEAP32[i61 >> 2];
    HEAP32[i66 + 4 >> 2] = HEAP32[i61 + 4 >> 2];
    HEAP32[i66 + 8 >> 2] = HEAP32[i61 + 8 >> 2];
    HEAP32[i66 + 12 >> 2] = HEAP32[i61 + 12 >> 2];
    i61 = i63;
    i66 = i16 + 48 | 0;
    HEAP32[i61 >> 2] = HEAP32[i66 >> 2];
    HEAP32[i61 + 4 >> 2] = HEAP32[i66 + 4 >> 2];
    HEAP32[i61 + 8 >> 2] = HEAP32[i66 + 8 >> 2];
    HEAP32[i61 + 12 >> 2] = HEAP32[i66 + 12 >> 2];
   } else {
    __ZNK11btTransformmlERKS_(i17, (HEAP32[i9 >> 2] | 0) + 4 | 0, i8);
    i8 = i10;
    i9 = i17;
    HEAP32[i8 >> 2] = HEAP32[i9 >> 2];
    HEAP32[i8 + 4 >> 2] = HEAP32[i9 + 4 >> 2];
    HEAP32[i8 + 8 >> 2] = HEAP32[i9 + 8 >> 2];
    HEAP32[i8 + 12 >> 2] = HEAP32[i9 + 12 >> 2];
    i9 = i10 + 16 | 0;
    i8 = i17 + 16 | 0;
    HEAP32[i9 >> 2] = HEAP32[i8 >> 2];
    HEAP32[i9 + 4 >> 2] = HEAP32[i8 + 4 >> 2];
    HEAP32[i9 + 8 >> 2] = HEAP32[i8 + 8 >> 2];
    HEAP32[i9 + 12 >> 2] = HEAP32[i8 + 12 >> 2];
    i8 = i10 + 32 | 0;
    i10 = i17 + 32 | 0;
    HEAP32[i8 >> 2] = HEAP32[i10 >> 2];
    HEAP32[i8 + 4 >> 2] = HEAP32[i10 + 4 >> 2];
    HEAP32[i8 + 8 >> 2] = HEAP32[i10 + 8 >> 2];
    HEAP32[i8 + 12 >> 2] = HEAP32[i10 + 12 >> 2];
    i10 = i63;
    i8 = i17 + 48 | 0;
    HEAP32[i10 >> 2] = HEAP32[i8 >> 2];
    HEAP32[i10 + 4 >> 2] = HEAP32[i8 + 4 >> 2];
    HEAP32[i10 + 8 >> 2] = HEAP32[i8 + 8 >> 2];
    HEAP32[i10 + 12 >> 2] = HEAP32[i8 + 12 >> 2];
   }
   i8 = i18;
   i10 = i63;
   HEAP32[i8 >> 2] = HEAP32[i10 >> 2];
   HEAP32[i8 + 4 >> 2] = HEAP32[i10 + 4 >> 2];
   HEAP32[i8 + 8 >> 2] = HEAP32[i10 + 8 >> 2];
   HEAP32[i8 + 12 >> 2] = HEAP32[i10 + 12 >> 2];
   HEAPF32[i19 >> 2] = +HEAPF32[i7 >> 2];
   HEAPF32[i19 + 4 >> 2] = +HEAPF32[i53 >> 2];
   HEAPF32[i19 + 8 >> 2] = +HEAPF32[i56 >> 2];
   HEAPF32[i19 + 12 >> 2] = 0.0;
   HEAPF32[i20 >> 2] = +HEAPF32[i11 >> 2];
   HEAPF32[i20 + 4 >> 2] = +HEAPF32[i50 >> 2];
   HEAPF32[i20 + 8 >> 2] = +HEAPF32[i57 >> 2];
   HEAPF32[i20 + 12 >> 2] = 0.0;
   i57 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
   i50 = HEAP32[(HEAP32[i57 >> 2] | 0) + 60 >> 2] | 0;
   _memset(i21 | 0, 0, 16);
   FUNCTION_TABLE_viiiiffffiif[i50 & 1](i57, i18, i19, i20, d44, d44, -0.0 - d45 - d46, d46 - d45, i21, 1, 10.0);
   STACKTOP = i3;
   return;
  }
 case 9:
 case 6:
  {
   i21 = i2;
   i20 = i2 + 1056 | 0;
   i19 = i22;
   i18 = i20;
   HEAP32[i19 >> 2] = HEAP32[i18 >> 2];
   HEAP32[i19 + 4 >> 2] = HEAP32[i18 + 4 >> 2];
   HEAP32[i19 + 8 >> 2] = HEAP32[i18 + 8 >> 2];
   HEAP32[i19 + 12 >> 2] = HEAP32[i18 + 12 >> 2];
   i57 = i22 + 16 | 0;
   i50 = i20 + 16 | 0;
   HEAP32[i57 >> 2] = HEAP32[i50 >> 2];
   HEAP32[i57 + 4 >> 2] = HEAP32[i50 + 4 >> 2];
   HEAP32[i57 + 8 >> 2] = HEAP32[i50 + 8 >> 2];
   HEAP32[i57 + 12 >> 2] = HEAP32[i50 + 12 >> 2];
   i11 = i22 + 32 | 0;
   i56 = i20 + 32 | 0;
   HEAP32[i11 >> 2] = HEAP32[i56 >> 2];
   HEAP32[i11 + 4 >> 2] = HEAP32[i56 + 4 >> 2];
   HEAP32[i11 + 8 >> 2] = HEAP32[i56 + 8 >> 2];
   HEAP32[i11 + 12 >> 2] = HEAP32[i56 + 12 >> 2];
   i53 = i22 + 48 | 0;
   i7 = i20 + 48 | 0;
   HEAP32[i53 >> 2] = HEAP32[i7 >> 2];
   HEAP32[i53 + 4 >> 2] = HEAP32[i7 + 4 >> 2];
   HEAP32[i53 + 8 >> 2] = HEAP32[i7 + 8 >> 2];
   HEAP32[i53 + 12 >> 2] = HEAP32[i7 + 12 >> 2];
   if ((i42 & 1 | 0) == 0) {
    i20 = i2 + 1120 | 0;
    HEAP32[i19 >> 2] = HEAP32[i20 >> 2];
    HEAP32[i19 + 4 >> 2] = HEAP32[i20 + 4 >> 2];
    HEAP32[i19 + 8 >> 2] = HEAP32[i20 + 8 >> 2];
    HEAP32[i19 + 12 >> 2] = HEAP32[i20 + 12 >> 2];
    i20 = i2 + 1136 | 0;
    HEAP32[i57 >> 2] = HEAP32[i20 >> 2];
    HEAP32[i57 + 4 >> 2] = HEAP32[i20 + 4 >> 2];
    HEAP32[i57 + 8 >> 2] = HEAP32[i20 + 8 >> 2];
    HEAP32[i57 + 12 >> 2] = HEAP32[i20 + 12 >> 2];
    i20 = i2 + 1152 | 0;
    HEAP32[i11 >> 2] = HEAP32[i20 >> 2];
    HEAP32[i11 + 4 >> 2] = HEAP32[i20 + 4 >> 2];
    HEAP32[i11 + 8 >> 2] = HEAP32[i20 + 8 >> 2];
    HEAP32[i11 + 12 >> 2] = HEAP32[i20 + 12 >> 2];
    i20 = i2 + 1168 | 0;
    HEAP32[i53 >> 2] = HEAP32[i20 >> 2];
    HEAP32[i53 + 4 >> 2] = HEAP32[i20 + 4 >> 2];
    HEAP32[i53 + 8 >> 2] = HEAP32[i20 + 8 >> 2];
    HEAP32[i53 + 12 >> 2] = HEAP32[i20 + 12 >> 2];
   } else {
    i20 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
    FUNCTION_TABLE_viif[HEAP32[(HEAP32[i20 >> 2] | 0) + 56 >> 2] & 3](i20, i22, d44);
    i20 = i2 + 1120 | 0;
    HEAP32[i19 >> 2] = HEAP32[i20 >> 2];
    HEAP32[i19 + 4 >> 2] = HEAP32[i20 + 4 >> 2];
    HEAP32[i19 + 8 >> 2] = HEAP32[i20 + 8 >> 2];
    HEAP32[i19 + 12 >> 2] = HEAP32[i20 + 12 >> 2];
    i20 = i2 + 1136 | 0;
    HEAP32[i57 >> 2] = HEAP32[i20 >> 2];
    HEAP32[i57 + 4 >> 2] = HEAP32[i20 + 4 >> 2];
    HEAP32[i57 + 8 >> 2] = HEAP32[i20 + 8 >> 2];
    HEAP32[i57 + 12 >> 2] = HEAP32[i20 + 12 >> 2];
    i20 = i2 + 1152 | 0;
    HEAP32[i11 >> 2] = HEAP32[i20 >> 2];
    HEAP32[i11 + 4 >> 2] = HEAP32[i20 + 4 >> 2];
    HEAP32[i11 + 8 >> 2] = HEAP32[i20 + 8 >> 2];
    HEAP32[i11 + 12 >> 2] = HEAP32[i20 + 12 >> 2];
    i20 = i2 + 1168 | 0;
    HEAP32[i53 >> 2] = HEAP32[i20 >> 2];
    HEAP32[i53 + 4 >> 2] = HEAP32[i20 + 4 >> 2];
    HEAP32[i53 + 8 >> 2] = HEAP32[i20 + 8 >> 2];
    HEAP32[i53 + 12 >> 2] = HEAP32[i20 + 12 >> 2];
    i20 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
    FUNCTION_TABLE_viif[HEAP32[(HEAP32[i20 >> 2] | 0) + 56 >> 2] & 3](i20, i22, d44);
   }
   if ((i43 & 1 | 0) == 0) {
    STACKTOP = i3;
    return;
   }
   HEAP32[i19 >> 2] = HEAP32[i18 >> 2];
   HEAP32[i19 + 4 >> 2] = HEAP32[i18 + 4 >> 2];
   HEAP32[i19 + 8 >> 2] = HEAP32[i18 + 8 >> 2];
   HEAP32[i19 + 12 >> 2] = HEAP32[i18 + 12 >> 2];
   HEAP32[i57 >> 2] = HEAP32[i50 >> 2];
   HEAP32[i57 + 4 >> 2] = HEAP32[i50 + 4 >> 2];
   HEAP32[i57 + 8 >> 2] = HEAP32[i50 + 8 >> 2];
   HEAP32[i57 + 12 >> 2] = HEAP32[i50 + 12 >> 2];
   HEAP32[i11 >> 2] = HEAP32[i56 >> 2];
   HEAP32[i11 + 4 >> 2] = HEAP32[i56 + 4 >> 2];
   HEAP32[i11 + 8 >> 2] = HEAP32[i56 + 8 >> 2];
   HEAP32[i11 + 12 >> 2] = HEAP32[i56 + 12 >> 2];
   HEAP32[i53 >> 2] = HEAP32[i7 >> 2];
   HEAP32[i53 + 4 >> 2] = HEAP32[i7 + 4 >> 2];
   HEAP32[i53 + 8 >> 2] = HEAP32[i7 + 8 >> 2];
   HEAP32[i53 + 12 >> 2] = HEAP32[i7 + 12 >> 2];
   i20 = i2 + 1168 | 0;
   i10 = i20;
   HEAPF32[i23 >> 2] = +HEAPF32[i22 + 8 >> 2];
   HEAPF32[i23 + 4 >> 2] = +HEAPF32[i22 + 24 >> 2];
   HEAPF32[i23 + 8 >> 2] = +HEAPF32[i22 + 40 >> 2];
   HEAPF32[i23 + 12 >> 2] = 0.0;
   i8 = i22 | 0;
   i63 = i22 + 16 | 0;
   i17 = i22 + 32 | 0;
   i9 = i24 | 0;
   HEAPF32[i9 >> 2] = +HEAPF32[i8 >> 2];
   i66 = i24 + 4 | 0;
   HEAPF32[i66 >> 2] = +HEAPF32[i63 >> 2];
   i61 = i24 + 8 | 0;
   HEAPF32[i61 >> 2] = +HEAPF32[i17 >> 2];
   i16 = i24 + 12 | 0;
   HEAPF32[i16 >> 2] = 0.0;
   i60 = i2 + 924 | 0;
   d45 = +HEAPF32[i60 >> 2];
   d46 = +HEAPF32[i60 + 4 >> 2];
   i60 = i2 + 988 | 0;
   d47 = +HEAPF32[i60 >> 2];
   d48 = +HEAPF32[i60 + 4 >> 2];
   i60 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
   i15 = HEAP32[(HEAP32[i60 >> 2] | 0) + 64 >> 2] | 0;
   _memset(i25 | 0, 0, 16);
   FUNCTION_TABLE_viiiifffffif[i15 & 1](i60, i10, i23, i24, d44 * .8999999761581421, d45, d46, d47, d48, i25, 10.0);
   d48 = +HEAPF32[i22 + 20 >> 2];
   d47 = +HEAPF32[i22 + 36 >> 2];
   HEAPF32[i9 >> 2] = +HEAPF32[i22 + 4 >> 2];
   HEAPF32[i66 >> 2] = d48;
   HEAPF32[i61 >> 2] = d47;
   HEAPF32[i16 >> 2] = 0.0;
   d47 = +__ZNK23btGeneric6DofConstraint8getAngleEi(i21, 1);
   d48 = +__ZNK23btGeneric6DofConstraint8getAngleEi(i21, 2);
   d46 = +Math_cos(+d47);
   d45 = +Math_sin(+d47);
   d47 = +Math_cos(+d48);
   d49 = +Math_sin(+d48);
   d48 = +HEAPF32[i9 >> 2];
   d69 = +HEAPF32[i66 >> 2];
   d70 = +HEAPF32[i61 >> 2];
   HEAPF32[i26 >> 2] = d46 * d47 * d48 + d46 * d49 * d69 - d45 * d70;
   HEAPF32[i26 + 4 >> 2] = d48 * (-0.0 - d49) + d47 * d69;
   HEAPF32[i26 + 8 >> 2] = d45 * d47 * d48 + d45 * d49 * d69 + d46 * d70;
   i61 = i2 + 1120 | 0;
   HEAP32[i19 >> 2] = HEAP32[i61 >> 2];
   HEAP32[i19 + 4 >> 2] = HEAP32[i61 + 4 >> 2];
   HEAP32[i19 + 8 >> 2] = HEAP32[i61 + 8 >> 2];
   HEAP32[i19 + 12 >> 2] = HEAP32[i61 + 12 >> 2];
   i61 = i2 + 1136 | 0;
   HEAP32[i57 >> 2] = HEAP32[i61 >> 2];
   HEAP32[i57 + 4 >> 2] = HEAP32[i61 + 4 >> 2];
   HEAP32[i57 + 8 >> 2] = HEAP32[i61 + 8 >> 2];
   HEAP32[i57 + 12 >> 2] = HEAP32[i61 + 12 >> 2];
   i61 = i2 + 1152 | 0;
   HEAP32[i11 >> 2] = HEAP32[i61 >> 2];
   HEAP32[i11 + 4 >> 2] = HEAP32[i61 + 4 >> 2];
   HEAP32[i11 + 8 >> 2] = HEAP32[i61 + 8 >> 2];
   HEAP32[i11 + 12 >> 2] = HEAP32[i61 + 12 >> 2];
   i61 = i20;
   HEAP32[i53 >> 2] = HEAP32[i61 >> 2];
   HEAP32[i53 + 4 >> 2] = HEAP32[i61 + 4 >> 2];
   HEAP32[i53 + 8 >> 2] = HEAP32[i61 + 8 >> 2];
   HEAP32[i53 + 12 >> 2] = HEAP32[i61 + 12 >> 2];
   d70 = -0.0 - +HEAPF32[i63 >> 2];
   d46 = -0.0 - +HEAPF32[i17 >> 2];
   HEAPF32[i27 >> 2] = -0.0 - +HEAPF32[i8 >> 2];
   HEAPF32[i27 + 4 >> 2] = d70;
   HEAPF32[i27 + 8 >> 2] = d46;
   HEAPF32[i27 + 12 >> 2] = 0.0;
   i8 = i2 + 860 | 0;
   d46 = +HEAPF32[i8 >> 2];
   d70 = +HEAPF32[i8 + 4 >> 2];
   do {
    if (d46 > d70) {
     i8 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
     i17 = HEAP32[(HEAP32[i8 >> 2] | 0) + 60 >> 2] | 0;
     _memset(i28 | 0, 0, 16);
     FUNCTION_TABLE_viiiiffffiif[i17 & 1](i8, i10, i27, i26, d44, d44, -3.1415927410125732, 3.1415927410125732, i28, 0, 10.0);
    } else {
     if (d46 >= d70) {
      break;
     }
     i8 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
     i17 = HEAP32[(HEAP32[i8 >> 2] | 0) + 60 >> 2] | 0;
     _memset(i29 | 0, 0, 16);
     FUNCTION_TABLE_viiiiffffiif[i17 & 1](i8, i10, i27, i26, d44, d44, d46, d70, i29, 1, 10.0);
    }
   } while (0);
   HEAP32[i19 >> 2] = HEAP32[i18 >> 2];
   HEAP32[i19 + 4 >> 2] = HEAP32[i18 + 4 >> 2];
   HEAP32[i19 + 8 >> 2] = HEAP32[i18 + 8 >> 2];
   HEAP32[i19 + 12 >> 2] = HEAP32[i18 + 12 >> 2];
   HEAP32[i57 >> 2] = HEAP32[i50 >> 2];
   HEAP32[i57 + 4 >> 2] = HEAP32[i50 + 4 >> 2];
   HEAP32[i57 + 8 >> 2] = HEAP32[i50 + 8 >> 2];
   HEAP32[i57 + 12 >> 2] = HEAP32[i50 + 12 >> 2];
   HEAP32[i11 >> 2] = HEAP32[i56 >> 2];
   HEAP32[i11 + 4 >> 2] = HEAP32[i56 + 4 >> 2];
   HEAP32[i11 + 8 >> 2] = HEAP32[i56 + 8 >> 2];
   HEAP32[i11 + 12 >> 2] = HEAP32[i56 + 12 >> 2];
   HEAP32[i53 >> 2] = HEAP32[i7 >> 2];
   HEAP32[i53 + 4 >> 2] = HEAP32[i7 + 4 >> 2];
   HEAP32[i53 + 8 >> 2] = HEAP32[i7 + 8 >> 2];
   HEAP32[i53 + 12 >> 2] = HEAP32[i7 + 12 >> 2];
   i7 = i2 + 672 | 0;
   i53 = i30;
   i56 = i7;
   HEAP32[i53 >> 2] = HEAP32[i56 >> 2];
   HEAP32[i53 + 4 >> 2] = HEAP32[i56 + 4 >> 2];
   HEAP32[i53 + 8 >> 2] = HEAP32[i56 + 8 >> 2];
   HEAP32[i53 + 12 >> 2] = HEAP32[i56 + 12 >> 2];
   i56 = i31;
   i53 = i7 + 16 | 0;
   HEAP32[i56 >> 2] = HEAP32[i53 >> 2];
   HEAP32[i56 + 4 >> 2] = HEAP32[i53 + 4 >> 2];
   HEAP32[i56 + 8 >> 2] = HEAP32[i53 + 8 >> 2];
   HEAP32[i56 + 12 >> 2] = HEAP32[i53 + 12 >> 2];
   i53 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
   i56 = HEAP32[(HEAP32[i53 >> 2] | 0) + 72 >> 2] | 0;
   _memset(i32 | 0, 0, 16);
   FUNCTION_TABLE_viiiii[i56 & 63](i53, i30, i31, i22, i32);
   STACKTOP = i3;
   return;
  }
 case 7:
  {
   i32 = i2 + 816 | 0;
   i22 = i33;
   i31 = i32;
   HEAP32[i22 >> 2] = HEAP32[i31 >> 2];
   HEAP32[i22 + 4 >> 2] = HEAP32[i31 + 4 >> 2];
   HEAP32[i22 + 8 >> 2] = HEAP32[i31 + 8 >> 2];
   HEAP32[i22 + 12 >> 2] = HEAP32[i31 + 12 >> 2];
   i31 = i33 + 16 | 0;
   i30 = i32 + 16 | 0;
   HEAP32[i31 >> 2] = HEAP32[i30 >> 2];
   HEAP32[i31 + 4 >> 2] = HEAP32[i30 + 4 >> 2];
   HEAP32[i31 + 8 >> 2] = HEAP32[i30 + 8 >> 2];
   HEAP32[i31 + 12 >> 2] = HEAP32[i30 + 12 >> 2];
   i30 = i33 + 32 | 0;
   i53 = i32 + 32 | 0;
   HEAP32[i30 >> 2] = HEAP32[i53 >> 2];
   HEAP32[i30 + 4 >> 2] = HEAP32[i53 + 4 >> 2];
   HEAP32[i30 + 8 >> 2] = HEAP32[i53 + 8 >> 2];
   HEAP32[i30 + 12 >> 2] = HEAP32[i53 + 12 >> 2];
   i53 = i33 + 48 | 0;
   i56 = i32 + 48 | 0;
   HEAP32[i53 >> 2] = HEAP32[i56 >> 2];
   HEAP32[i53 + 4 >> 2] = HEAP32[i56 + 4 >> 2];
   HEAP32[i53 + 8 >> 2] = HEAP32[i56 + 8 >> 2];
   HEAP32[i53 + 12 >> 2] = HEAP32[i56 + 12 >> 2];
   if ((i42 & 1 | 0) == 0) {
    i42 = i2 + 880 | 0;
    HEAP32[i22 >> 2] = HEAP32[i42 >> 2];
    HEAP32[i22 + 4 >> 2] = HEAP32[i42 + 4 >> 2];
    HEAP32[i22 + 8 >> 2] = HEAP32[i42 + 8 >> 2];
    HEAP32[i22 + 12 >> 2] = HEAP32[i42 + 12 >> 2];
    i42 = i2 + 896 | 0;
    HEAP32[i31 >> 2] = HEAP32[i42 >> 2];
    HEAP32[i31 + 4 >> 2] = HEAP32[i42 + 4 >> 2];
    HEAP32[i31 + 8 >> 2] = HEAP32[i42 + 8 >> 2];
    HEAP32[i31 + 12 >> 2] = HEAP32[i42 + 12 >> 2];
    i42 = i2 + 912 | 0;
    HEAP32[i30 >> 2] = HEAP32[i42 >> 2];
    HEAP32[i30 + 4 >> 2] = HEAP32[i42 + 4 >> 2];
    HEAP32[i30 + 8 >> 2] = HEAP32[i42 + 8 >> 2];
    HEAP32[i30 + 12 >> 2] = HEAP32[i42 + 12 >> 2];
    i42 = i2 + 928 | 0;
    HEAP32[i53 >> 2] = HEAP32[i42 >> 2];
    HEAP32[i53 + 4 >> 2] = HEAP32[i42 + 4 >> 2];
    HEAP32[i53 + 8 >> 2] = HEAP32[i42 + 8 >> 2];
    HEAP32[i53 + 12 >> 2] = HEAP32[i42 + 12 >> 2];
   } else {
    i42 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
    FUNCTION_TABLE_viif[HEAP32[(HEAP32[i42 >> 2] | 0) + 56 >> 2] & 3](i42, i33, d44);
    i42 = i2 + 880 | 0;
    HEAP32[i22 >> 2] = HEAP32[i42 >> 2];
    HEAP32[i22 + 4 >> 2] = HEAP32[i42 + 4 >> 2];
    HEAP32[i22 + 8 >> 2] = HEAP32[i42 + 8 >> 2];
    HEAP32[i22 + 12 >> 2] = HEAP32[i42 + 12 >> 2];
    i42 = i2 + 896 | 0;
    HEAP32[i31 >> 2] = HEAP32[i42 >> 2];
    HEAP32[i31 + 4 >> 2] = HEAP32[i42 + 4 >> 2];
    HEAP32[i31 + 8 >> 2] = HEAP32[i42 + 8 >> 2];
    HEAP32[i31 + 12 >> 2] = HEAP32[i42 + 12 >> 2];
    i42 = i2 + 912 | 0;
    HEAP32[i30 >> 2] = HEAP32[i42 >> 2];
    HEAP32[i30 + 4 >> 2] = HEAP32[i42 + 4 >> 2];
    HEAP32[i30 + 8 >> 2] = HEAP32[i42 + 8 >> 2];
    HEAP32[i30 + 12 >> 2] = HEAP32[i42 + 12 >> 2];
    i42 = i2 + 928 | 0;
    HEAP32[i53 >> 2] = HEAP32[i42 >> 2];
    HEAP32[i53 + 4 >> 2] = HEAP32[i42 + 4 >> 2];
    HEAP32[i53 + 8 >> 2] = HEAP32[i42 + 8 >> 2];
    HEAP32[i53 + 12 >> 2] = HEAP32[i42 + 12 >> 2];
    i42 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
    FUNCTION_TABLE_viif[HEAP32[(HEAP32[i42 >> 2] | 0) + 56 >> 2] & 3](i42, i33, d44);
   }
   if ((i43 & 1 | 0) == 0) {
    STACKTOP = i3;
    return;
   }
   i43 = (HEAP8[i2 + 172 | 0] | 0) != 0 ? i32 : i2 + 880 | 0;
   d70 = +HEAPF32[i43 >> 2];
   d46 = +HEAPF32[i43 + 4 >> 2];
   d69 = +HEAPF32[i43 + 16 >> 2];
   d49 = +HEAPF32[i43 + 20 >> 2];
   d45 = +HEAPF32[i43 + 32 >> 2];
   d48 = +HEAPF32[i43 + 36 >> 2];
   d47 = +HEAPF32[i43 + 48 >> 2];
   d71 = +HEAPF32[i43 + 52 >> 2];
   d72 = +HEAPF32[i43 + 56 >> 2];
   d73 = +HEAPF32[i2 + 176 >> 2];
   d74 = d46 * 0.0;
   d75 = +HEAPF32[i43 + 8 >> 2] * 0.0;
   d76 = d49 * 0.0;
   d77 = +HEAPF32[i43 + 24 >> 2] * 0.0;
   d78 = d48 * 0.0;
   d79 = +HEAPF32[i43 + 40 >> 2] * 0.0;
   HEAPF32[i34 >> 2] = d47 + (d75 + (d74 + d70 * d73));
   HEAPF32[i34 + 4 >> 2] = d71 + (d77 + (d76 + d69 * d73));
   HEAPF32[i34 + 8 >> 2] = d72 + (d79 + (d78 + d45 * d73));
   HEAPF32[i34 + 12 >> 2] = 0.0;
   d73 = +HEAPF32[i2 + 180 >> 2];
   HEAPF32[i35 >> 2] = d47 + (d75 + (d74 + d70 * d73));
   HEAPF32[i35 + 4 >> 2] = d71 + (d77 + (d76 + d69 * d73));
   HEAPF32[i35 + 8 >> 2] = d72 + (d79 + (d78 + d45 * d73));
   HEAPF32[i35 + 12 >> 2] = 0.0;
   i43 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
   i32 = HEAP32[(HEAP32[i43 >> 2] | 0) + 8 >> 2] | 0;
   _memset(i36 | 0, 0, 16);
   FUNCTION_TABLE_viiii[i32 & 127](i43, i34, i35, i36);
   HEAPF32[i37 >> 2] = d70;
   HEAPF32[i37 + 4 >> 2] = d69;
   HEAPF32[i37 + 8 >> 2] = d45;
   HEAPF32[i37 + 12 >> 2] = 0.0;
   HEAPF32[i38 >> 2] = d46;
   HEAPF32[i38 + 4 >> 2] = d49;
   HEAPF32[i38 + 8 >> 2] = d48;
   HEAPF32[i38 + 12 >> 2] = 0.0;
   d48 = +HEAPF32[i2 + 184 >> 2];
   d49 = +HEAPF32[i2 + 188 >> 2];
   i36 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i41 >> 2] | 0) + 16 >> 2] & 127](i40) | 0;
   i40 = HEAP32[(HEAP32[i36 >> 2] | 0) + 60 >> 2] | 0;
   _memset(i39 | 0, 0, 16);
   FUNCTION_TABLE_viiiiffffiif[i40 & 1](i36, i2 + 928 | 0, i37, i38, d44, d44, d48, d49, i39, 1, 10.0);
   STACKTOP = i3;
   return;
  }
 default:
  {
   STACKTOP = i3;
   return;
  }
 }
}
function __ZN20btConvexHullInternal5mergeERNS_16IntermediateHullES1_(i1, i2, i3) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 var i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0, i62 = 0, i63 = 0, i64 = 0, i65 = 0, i66 = 0, i67 = 0, i68 = 0, i69 = 0, i70 = 0, i71 = 0, i72 = 0, i73 = 0, i74 = 0, i75 = 0, i76 = 0, i77 = 0, i78 = 0, i79 = 0, i80 = 0, i81 = 0, i82 = 0, i83 = 0, i84 = 0, i85 = 0, i86 = 0, i87 = 0, i88 = 0, i89 = 0, i90 = 0, i91 = 0, i92 = 0, i93 = 0, i94 = 0, i95 = 0, i96 = 0, i97 = 0, i98 = 0, i99 = 0, i100 = 0, i101 = 0, i102 = 0, i103 = 0, i104 = 0, i105 = 0, i106 = 0, i107 = 0, i108 = 0, i109 = 0, i110 = 0, i111 = 0, i112 = 0, i113 = 0, i114 = 0, i115 = 0, i116 = 0, i117 = 0, i118 = 0;
 i4 = STACKTOP;
 STACKTOP = STACKTOP + 160 | 0;
 i5 = i4 | 0;
 i6 = i4 + 8 | 0;
 i7 = i4 + 16 | 0;
 i8 = i4 + 24 | 0;
 i9 = i4 + 32 | 0;
 i10 = i4 + 48 | 0;
 i11 = i4 + 72 | 0;
 i12 = i4 + 96 | 0;
 i13 = i4 + 120 | 0;
 i14 = i4 + 144 | 0;
 i15 = i4 + 152 | 0;
 if ((HEAP32[i3 + 4 >> 2] | 0) == 0) {
  STACKTOP = i4;
  return;
 }
 if ((HEAP32[i2 + 4 >> 2] | 0) == 0) {
  i16 = i2;
  i17 = i3;
  HEAP32[i16 >> 2] = HEAP32[i17 >> 2];
  HEAP32[i16 + 4 >> 2] = HEAP32[i17 + 4 >> 2];
  HEAP32[i16 + 8 >> 2] = HEAP32[i17 + 8 >> 2];
  HEAP32[i16 + 12 >> 2] = HEAP32[i17 + 12 >> 2];
  STACKTOP = i4;
  return;
 }
 i17 = i1 + 100 | 0;
 HEAP32[i17 >> 2] = (HEAP32[i17 >> 2] | 0) - 1;
 HEAP32[i5 >> 2] = 0;
 HEAP32[i6 >> 2] = 0;
 i16 = __ZN20btConvexHullInternal15mergeProjectionERNS_16IntermediateHullES1_RPNS_6VertexES4_(0, i2, i3, i5, i6) | 0;
 i3 = HEAP32[i6 >> 2] | 0;
 if (i16) {
  i16 = HEAP32[i5 >> 2] | 0;
  i2 = HEAP32[i3 + 88 >> 2] | 0;
  i18 = HEAP32[i16 + 88 >> 2] | 0;
  i19 = i2 - i18 | 0;
  i20 = HEAP32[i3 + 92 >> 2] | 0;
  i21 = HEAP32[i16 + 92 >> 2] | 0;
  i22 = i20 - i21 | 0;
  i23 = HEAP32[i3 + 96 >> 2] | 0;
  i24 = HEAP32[i16 + 96 >> 2] | 0;
  i25 = i23 - i24 | 0;
  i26 = i22;
  i27 = (i22 | 0) < 0 ? -1 : 0;
  i22 = -i19 | 0;
  i28 = i22;
  i29 = (i22 | 0) < 0 ? -1 : 0;
  i22 = i25;
  i30 = (i25 | 0) < 0 ? -1 : 0;
  i25 = _i64Subtract(0, 0, i28, i29) | 0;
  i31 = ___muldi3(i22, i30, i25, tempRet0) | 0;
  i25 = tempRet0;
  i32 = ___muldi3(i22, i30, i26, i27) | 0;
  i30 = tempRet0;
  i22 = ___muldi3(i19, (i19 | 0) < 0 ? -1 : 0, i28, i29) | 0;
  i19 = tempRet0;
  i33 = ___muldi3(i26, i27, i26, i27) | 0;
  i34 = _i64Subtract(i22, i19, i33, tempRet0) | 0;
  i33 = tempRet0;
  i19 = HEAP32[i16 + 8 >> 2] | 0;
  HEAP32[i7 >> 2] = 0;
  if ((i19 | 0) == 0) {
   i35 = 0;
  } else {
   i22 = _i64Subtract(0, 0, i26, i27) | 0;
   i36 = tempRet0;
   i37 = i19;
   i38 = 0;
   while (1) {
    i39 = HEAP32[i37 + 12 >> 2] | 0;
    i40 = HEAP32[i39 + 88 >> 2] | 0;
    i41 = i40 - i18 | 0;
    i42 = HEAP32[i39 + 92 >> 2] | 0;
    i43 = i42 - i21 | 0;
    i44 = i41;
    i45 = (i41 | 0) < 0 ? -1 : 0;
    i41 = i43;
    i46 = (i43 | 0) < 0 ? -1 : 0;
    i43 = ___muldi3(i41, i46, i28, i29) | 0;
    i47 = tempRet0;
    i48 = ___muldi3(i44, i45, i22, i36) | 0;
    do {
     if ((i43 | 0) == (i48 | 0) & (i47 | 0) == (tempRet0 | 0)) {
      i49 = HEAP32[i39 + 96 >> 2] | 0;
      i50 = i49 - i24 | 0;
      i51 = ___muldi3(i44, i45, i31, i25) | 0;
      i52 = tempRet0;
      i53 = ___muldi3(i41, i46, i32, i30) | 0;
      i54 = _i64Add(i53, tempRet0, i51, i52) | 0;
      i52 = tempRet0;
      i51 = ___muldi3(i50, (i50 | 0) < 0 ? -1 : 0, i34, i33) | 0;
      i50 = _i64Add(i54, i52, i51, tempRet0) | 0;
      i51 = tempRet0;
      i52 = 0;
      if (!((i51 | 0) > (i52 | 0) | (i51 | 0) == (i52 | 0) & i50 >>> 0 > 0 >>> 0)) {
       i55 = i38;
       break;
      }
      if ((i38 | 0) != 0) {
       i50 = (HEAP32[i38 + 4 >> 2] | 0) == (i37 | 0);
       if ((HEAP32[i38 >> 2] | 0) == (i37 | 0)) {
        if (!i50) {
         i55 = i38;
         break;
        }
        i52 = HEAP32[i38 + 12 >> 2] | 0;
        i51 = HEAP32[(HEAP32[i37 + 8 >> 2] | 0) + 12 >> 2] | 0;
        i54 = HEAP32[i51 + 88 >> 2] | 0;
        i53 = (HEAP32[i52 + 88 >> 2] | 0) - i54 | 0;
        i56 = HEAP32[i51 + 92 >> 2] | 0;
        i57 = HEAP32[i51 + 96 >> 2] | 0;
        i51 = (HEAP32[i52 + 96 >> 2] | 0) - i57 | 0;
        i58 = i49 - i57 | 0;
        i57 = Math_imul(i58, (HEAP32[i52 + 92 >> 2] | 0) - i56 | 0) | 0;
        i52 = i57 - (Math_imul(i51, i42 - i56 | 0) | 0) | 0;
        i56 = Math_imul(i51, i40 - i54 | 0) | 0;
        i54 = i56 - (Math_imul(i58, i53) | 0) | 0;
        i53 = ___muldi3(i52, (i52 | 0) < 0 ? -1 : 0, i26, i27) | 0;
        i52 = tempRet0;
        i58 = ___muldi3(i54, (i54 | 0) < 0 ? -1 : 0, i28, i29) | 0;
        i54 = _i64Add(i53, i52, i58, tempRet0) | 0;
        i58 = tempRet0;
        i52 = 0;
        i59 = (i58 | 0) > (i52 | 0) | (i58 | 0) == (i52 | 0) & i54 >>> 0 > 0 >>> 0 ? 2 : 1;
       } else {
        i59 = i50 & 1;
       }
       if ((i59 | 0) != 1) {
        i55 = i38;
        break;
       }
      }
      HEAP32[i7 >> 2] = i37;
      i55 = i37;
     } else {
      i55 = i38;
     }
    } while (0);
    i40 = HEAP32[i37 >> 2] | 0;
    if ((i40 | 0) == (i19 | 0)) {
     i35 = i55;
     break;
    } else {
     i37 = i40;
     i38 = i55;
    }
   }
  }
  i55 = HEAP32[i3 + 8 >> 2] | 0;
  HEAP32[i8 >> 2] = 0;
  if ((i55 | 0) == 0) {
   i60 = 0;
  } else {
   i38 = _i64Subtract(0, 0, i26, i27) | 0;
   i37 = tempRet0;
   i19 = i55;
   i59 = 0;
   while (1) {
    i24 = HEAP32[i19 + 12 >> 2] | 0;
    i36 = HEAP32[i24 + 88 >> 2] | 0;
    i22 = i36 - i2 | 0;
    i21 = HEAP32[i24 + 92 >> 2] | 0;
    i18 = i21 - i20 | 0;
    i40 = i22;
    i42 = (i22 | 0) < 0 ? -1 : 0;
    i22 = i18;
    i46 = (i18 | 0) < 0 ? -1 : 0;
    i18 = ___muldi3(i22, i46, i28, i29) | 0;
    i41 = tempRet0;
    i45 = ___muldi3(i40, i42, i38, i37) | 0;
    L958 : do {
     if ((i18 | 0) == (i45 | 0) & (i41 | 0) == (tempRet0 | 0)) {
      i44 = HEAP32[i24 + 96 >> 2] | 0;
      i39 = i44 - i23 | 0;
      i47 = ___muldi3(i40, i42, i31, i25) | 0;
      i48 = tempRet0;
      i43 = ___muldi3(i22, i46, i32, i30) | 0;
      i50 = _i64Add(i43, tempRet0, i47, i48) | 0;
      i48 = tempRet0;
      i47 = ___muldi3(i39, (i39 | 0) < 0 ? -1 : 0, i34, i33) | 0;
      i39 = _i64Add(i50, i48, i47, tempRet0) | 0;
      i47 = tempRet0;
      i48 = 0;
      if (!((i47 | 0) > (i48 | 0) | (i47 | 0) == (i48 | 0) & i39 >>> 0 > 0 >>> 0)) {
       i61 = i59;
       break;
      }
      do {
       if ((i59 | 0) != 0) {
        if ((HEAP32[i59 >> 2] | 0) != (i19 | 0)) {
         i61 = i59;
         break L958;
        }
        if ((HEAP32[i59 + 4 >> 2] | 0) != (i19 | 0)) {
         break;
        }
        i39 = HEAP32[i59 + 12 >> 2] | 0;
        i48 = HEAP32[(HEAP32[i19 + 8 >> 2] | 0) + 12 >> 2] | 0;
        i47 = HEAP32[i48 + 88 >> 2] | 0;
        i50 = (HEAP32[i39 + 88 >> 2] | 0) - i47 | 0;
        i43 = HEAP32[i48 + 92 >> 2] | 0;
        i54 = HEAP32[i48 + 96 >> 2] | 0;
        i48 = (HEAP32[i39 + 96 >> 2] | 0) - i54 | 0;
        i52 = i44 - i54 | 0;
        i54 = Math_imul(i52, (HEAP32[i39 + 92 >> 2] | 0) - i43 | 0) | 0;
        i39 = i54 - (Math_imul(i48, i21 - i43 | 0) | 0) | 0;
        i43 = Math_imul(i48, i36 - i47 | 0) | 0;
        i47 = i43 - (Math_imul(i52, i50) | 0) | 0;
        i50 = ___muldi3(i39, (i39 | 0) < 0 ? -1 : 0, i26, i27) | 0;
        i39 = tempRet0;
        i52 = ___muldi3(i47, (i47 | 0) < 0 ? -1 : 0, i28, i29) | 0;
        i47 = _i64Add(i50, i39, i52, tempRet0) | 0;
        i52 = tempRet0;
        i39 = 0;
        if (!((i52 | 0) > (i39 | 0) | (i52 | 0) == (i39 | 0) & i47 >>> 0 > 0 >>> 0)) {
         i61 = i59;
         break L958;
        }
       }
      } while (0);
      HEAP32[i8 >> 2] = i19;
      i61 = i19;
     } else {
      i61 = i59;
     }
    } while (0);
    i36 = HEAP32[i19 >> 2] | 0;
    if ((i36 | 0) == (i55 | 0)) {
     i60 = i61;
     break;
    } else {
     i19 = i36;
     i59 = i61;
    }
   }
  }
  do {
   if ((i35 | 0) == 0 & (i60 | 0) == 0) {
    i62 = i16;
    i63 = i3;
   } else {
    __ZN20btConvexHullInternal24findEdgeForCoplanarFacesEPNS_6VertexES1_RPNS_4EdgeES4_S1_S1_(i1, i16, i3, i7, i8, 0, 0);
    i61 = HEAP32[i7 >> 2] | 0;
    if ((i61 | 0) == 0) {
     i64 = i16;
    } else {
     i59 = HEAP32[i61 + 12 >> 2] | 0;
     HEAP32[i5 >> 2] = i59;
     i64 = i59;
    }
    i59 = HEAP32[i8 >> 2] | 0;
    if ((i59 | 0) == 0) {
     i62 = i64;
     i63 = i3;
     break;
    }
    i61 = HEAP32[i59 + 12 >> 2] | 0;
    HEAP32[i6 >> 2] = i61;
    i62 = i64;
    i63 = i61;
   }
  } while (0);
  i65 = HEAP32[i63 + 88 >> 2] | 0;
  i66 = (HEAP32[i63 + 96 >> 2] | 0) + 1 | 0;
  i67 = i62;
  i68 = i63;
 } else {
  i65 = (HEAP32[i3 + 88 >> 2] | 0) + 1 | 0;
  i66 = HEAP32[i3 + 96 >> 2] | 0;
  i67 = HEAP32[i5 >> 2] | 0;
  i68 = i3;
 }
 i3 = HEAP32[i68 + 92 >> 2] | 0;
 i63 = i9 | 0;
 i62 = i9 + 4 | 0;
 i64 = i9 + 8 | 0;
 i8 = i9 + 12 | 0;
 i16 = i10 | 0;
 i7 = i10 + 8 | 0;
 i60 = i10 + 16 | 0;
 i35 = i11 | 0;
 i61 = i11 + 8 | 0;
 i59 = i11 + 16 | 0;
 i19 = i12 + 16 | 0;
 i55 = i12 + 8 | 0;
 i29 = i13 + 16 | 0;
 i28 = i13 + 8 | 0;
 i27 = i1 + 48 | 0;
 i26 = i1 + 116 | 0;
 i33 = i1 + 120 | 0;
 i34 = i1 + 56 | 0;
 i30 = i12;
 i32 = i13;
 i25 = 0;
 i31 = 0;
 i23 = 0;
 i37 = 0;
 i38 = 1;
 i20 = 0;
 i2 = 0;
 i36 = 0;
 i21 = 0;
 i46 = i65;
 i65 = i3;
 i22 = i66;
 i66 = i68;
 i42 = i67;
 i40 = i3;
 while (1) {
  i3 = i42 + 88 | 0;
  i24 = (HEAP32[i66 + 88 >> 2] | 0) - (HEAP32[i3 >> 2] | 0) | 0;
  i41 = i42 + 92 | 0;
  i45 = i40 - (HEAP32[i41 >> 2] | 0) | 0;
  i18 = i42 + 96 | 0;
  i44 = (HEAP32[i66 + 96 >> 2] | 0) - (HEAP32[i18 >> 2] | 0) | 0;
  HEAP32[i63 >> 2] = i24;
  HEAP32[i62 >> 2] = i45;
  HEAP32[i64 >> 2] = i44;
  HEAP32[i8 >> 2] = -1;
  i47 = i46 - (HEAP32[i3 >> 2] | 0) | 0;
  i3 = i65 - (HEAP32[i41 >> 2] | 0) | 0;
  i41 = i22 - (HEAP32[i18 >> 2] | 0) | 0;
  i18 = Math_imul(i3, i44) | 0;
  i39 = i18 - (Math_imul(i41, i45) | 0) | 0;
  i18 = i39;
  i52 = (i39 | 0) < 0 ? -1 : 0;
  i39 = Math_imul(i41, i24) | 0;
  i41 = i39 - (Math_imul(i47, i44) | 0) | 0;
  i39 = i41;
  i50 = (i41 | 0) < 0 ? -1 : 0;
  i41 = Math_imul(i47, i45) | 0;
  i47 = i41 - (Math_imul(i3, i24) | 0) | 0;
  i3 = i47;
  i41 = (i47 | 0) < 0 ? -1 : 0;
  HEAP32[i16 >> 2] = i18;
  HEAP32[i16 + 4 >> 2] = i52;
  HEAP32[i7 >> 2] = i39;
  HEAP32[i7 + 4 >> 2] = i50;
  HEAP32[i60 >> 2] = i3;
  HEAP32[i60 + 4 >> 2] = i41;
  i47 = i45;
  i43 = (i45 | 0) < 0 ? -1 : 0;
  i45 = ___muldi3(i3, i41, i47, i43) | 0;
  i48 = tempRet0;
  i54 = i44;
  i58 = (i44 | 0) < 0 ? -1 : 0;
  i44 = ___muldi3(i39, i50, i54, i58) | 0;
  i53 = _i64Subtract(i45, i48, i44, tempRet0) | 0;
  i44 = tempRet0;
  i48 = ___muldi3(i18, i52, i54, i58) | 0;
  i58 = tempRet0;
  i54 = i24;
  i45 = (i24 | 0) < 0 ? -1 : 0;
  i24 = ___muldi3(i3, i41, i54, i45) | 0;
  i41 = _i64Subtract(i48, i58, i24, tempRet0) | 0;
  i24 = tempRet0;
  i58 = ___muldi3(i39, i50, i54, i45) | 0;
  i45 = tempRet0;
  i54 = ___muldi3(i18, i52, i47, i43) | 0;
  i43 = _i64Subtract(i58, i45, i54, tempRet0) | 0;
  HEAP32[i35 >> 2] = i53;
  HEAP32[i35 + 4 >> 2] = i44;
  HEAP32[i61 >> 2] = i41;
  HEAP32[i61 + 4 >> 2] = i24;
  HEAP32[i59 >> 2] = i43;
  HEAP32[i59 + 4 >> 2] = tempRet0;
  _memset(i30 | 0, 0, 20);
  i43 = __ZN20btConvexHullInternal12findMaxAngleEbPKNS_6VertexERKNS_7Point32ERKNS_7Point64ES8_RNS_10Rational64E(i1, 0, i42, i9, i10, i11, i12) | 0;
  _memset(i32 | 0, 0, 20);
  i69 = HEAP32[i6 >> 2] | 0;
  i24 = __ZN20btConvexHullInternal12findMaxAngleEbPKNS_6VertexERKNS_7Point32ERKNS_7Point64ES8_RNS_10Rational64E(i1, 1, i69, i9, i10, i11, i13) | 0;
  i41 = (i43 | 0) != 0;
  i44 = i41 ^ 1;
  i53 = (i24 | 0) == 0;
  if (i53 & i44) {
   i70 = 753;
   break;
  }
  if (i53 | i44) {
   i71 = i41 ? -1 : 1;
  } else {
   i71 = __ZNK20btConvexHullInternal10Rational647compareERKS0_(i12, i13) | 0;
  }
  do {
   if (i38) {
    i70 = 765;
   } else {
    if ((i71 | 0) > -1) {
     if ((HEAP32[i29 >> 2] | 0) >= 0) {
      i70 = 765;
      break;
     }
     if ((HEAP32[i28 >> 2] | 0) == 0 & (HEAP32[i28 + 4 >> 2] | 0) == 0) {
      i72 = i23;
      i73 = i37;
      i74 = i36;
      i75 = i21;
      i70 = 772;
      break;
     } else {
      i70 = 765;
      break;
     }
    }
    if ((HEAP32[i19 >> 2] | 0) >= 0) {
     i70 = 765;
     break;
    }
    if (!((HEAP32[i55 >> 2] | 0) == 0 & (HEAP32[i55 + 4 >> 2] | 0) == 0)) {
     i70 = 765;
     break;
    }
    HEAP32[i14 >> 2] = i43;
    HEAP32[i15 >> 2] = i24;
    i76 = i22;
    i77 = i65;
    i78 = i46;
    i79 = i21;
    i80 = i36;
    i81 = i2;
    i82 = i20;
    i83 = i43;
    i84 = i37;
    i85 = i23;
    i70 = 794;
   }
  } while (0);
  if ((i70 | 0) == 765) {
   i70 = 0;
   i41 = HEAP32[i5 >> 2] | 0;
   i44 = __ZN20btConvexHullInternal4PoolINS_4EdgeEE9newObjectEv(i27) | 0;
   i53 = __ZN20btConvexHullInternal4PoolINS_4EdgeEE9newObjectEv(i27) | 0;
   i54 = i44 + 8 | 0;
   HEAP32[i54 >> 2] = i53;
   HEAP32[i53 + 8 >> 2] = i44;
   HEAP32[i44 + 20 >> 2] = HEAP32[i17 >> 2];
   HEAP32[i53 + 20 >> 2] = HEAP32[i17 >> 2];
   HEAP32[i44 + 12 >> 2] = i69;
   HEAP32[i53 + 12 >> 2] = i41;
   HEAP32[i44 + 16 >> 2] = 0;
   HEAP32[i53 + 16 >> 2] = 0;
   i53 = (HEAP32[i26 >> 2] | 0) + 1 | 0;
   HEAP32[i26 >> 2] = i53;
   if ((i53 | 0) > (HEAP32[i33 >> 2] | 0)) {
    HEAP32[i33 >> 2] = i53;
   }
   if ((i37 | 0) == 0) {
    i86 = i44;
   } else {
    HEAP32[i37 + 4 >> 2] = i44;
    i86 = i23;
   }
   HEAP32[i44 >> 2] = i37;
   i53 = HEAP32[i54 >> 2] | 0;
   if ((i21 | 0) == 0) {
    i87 = i53;
   } else {
    HEAP32[i21 >> 2] = i53;
    i87 = i36;
   }
   HEAP32[i53 + 4 >> 2] = i21;
   i72 = i86;
   i73 = i44;
   i74 = i87;
   i75 = i53;
   i70 = 772;
  }
  do {
   if ((i70 | 0) == 772) {
    i70 = 0;
    HEAP32[i14 >> 2] = i43;
    HEAP32[i15 >> 2] = i24;
    if ((i71 | 0) == 0) {
     __ZN20btConvexHullInternal24findEdgeForCoplanarFacesEPNS_6VertexES1_RPNS_4EdgeES4_S1_S1_(i1, HEAP32[i5 >> 2] | 0, HEAP32[i6 >> 2] | 0, i14, i15, 0, 0);
     i88 = HEAP32[i15 >> 2] | 0;
    } else {
     if ((i71 | 0) > -1) {
      i88 = i24;
     } else {
      i76 = i22;
      i77 = i65;
      i78 = i46;
      i79 = i75;
      i80 = i74;
      i81 = i2;
      i82 = i20;
      i83 = i43;
      i84 = i73;
      i85 = i72;
      i70 = 794;
      break;
     }
    }
    if ((i88 | 0) == 0) {
     i89 = i20;
     i90 = i2;
     i91 = i74;
     i92 = i75;
     i93 = i46;
     i94 = i65;
     i95 = i22;
    } else {
     i53 = (i20 | 0) != 0;
     do {
      if (i53) {
       i44 = HEAP32[i20 >> 2] | 0;
       if ((i44 | 0) == (i24 | 0)) {
        break;
       } else {
        i96 = i44;
       }
       while (1) {
        i44 = i96 | 0;
        i54 = HEAP32[i44 >> 2] | 0;
        i41 = HEAP32[i96 + 8 >> 2] | 0;
        if ((i54 | 0) == (i96 | 0)) {
         HEAP32[(HEAP32[i41 + 12 >> 2] | 0) + 8 >> 2] = 0;
        } else {
         i45 = i96 + 4 | 0;
         HEAP32[i54 + 4 >> 2] = HEAP32[i45 >> 2];
         HEAP32[HEAP32[i45 >> 2] >> 2] = i54;
         HEAP32[(HEAP32[i41 + 12 >> 2] | 0) + 8 >> 2] = i54;
        }
        i45 = i41 | 0;
        i58 = HEAP32[i45 >> 2] | 0;
        if ((i58 | 0) == (i41 | 0)) {
         HEAP32[(HEAP32[i96 + 12 >> 2] | 0) + 8 >> 2] = 0;
        } else {
         i47 = i41 + 4 | 0;
         HEAP32[i58 + 4 >> 2] = HEAP32[i47 >> 2];
         HEAP32[HEAP32[i47 >> 2] >> 2] = i58;
         HEAP32[(HEAP32[i96 + 12 >> 2] | 0) + 8 >> 2] = i58;
        }
        _memset(i96 | 0, 0, 20);
        HEAP32[i44 >> 2] = HEAP32[i34 >> 2];
        HEAP32[i34 >> 2] = i96;
        _memset(i41 | 0, 0, 20);
        HEAP32[i45 >> 2] = HEAP32[i34 >> 2];
        HEAP32[i34 >> 2] = i41;
        HEAP32[i26 >> 2] = (HEAP32[i26 >> 2] | 0) - 1;
        if ((i54 | 0) == (i24 | 0)) {
         break;
        } else {
         i96 = i54;
        }
       }
      }
     } while (0);
     if ((i75 | 0) == 0) {
      i97 = i53 ? i2 : i24;
      i98 = i74;
      i99 = i88;
     } else {
      if (i53) {
       HEAP32[i20 >> 2] = i74;
       HEAP32[i74 + 4 >> 2] = i20;
       i100 = i2;
       i101 = i24 + 4 | 0;
      } else {
       i54 = i24 + 4 | 0;
       i41 = HEAP32[i54 >> 2] | 0;
       HEAP32[i41 >> 2] = i74;
       HEAP32[i74 + 4 >> 2] = i41;
       i100 = i74;
       i101 = i54;
      }
      HEAP32[i75 >> 2] = i24;
      HEAP32[i101 >> 2] = i75;
      i97 = i100;
      i98 = 0;
      i99 = HEAP32[i15 >> 2] | 0;
     }
     i54 = HEAP32[i6 >> 2] | 0;
     i41 = HEAP32[i54 + 88 >> 2] | 0;
     i45 = HEAP32[i54 + 92 >> 2] | 0;
     i44 = HEAP32[i54 + 96 >> 2] | 0;
     HEAP32[i6 >> 2] = HEAP32[i99 + 12 >> 2];
     i89 = HEAP32[i99 + 8 >> 2] | 0;
     i90 = i97;
     i91 = i98;
     i92 = 0;
     i93 = i41;
     i94 = i45;
     i95 = i44;
    }
    if ((i71 | 0) >= 1) {
     i102 = i25;
     i103 = i31;
     i104 = i72;
     i105 = i73;
     i106 = i93;
     i107 = i94;
     i108 = i95;
     i109 = i92;
     i110 = i91;
     i111 = i90;
     i112 = i89;
     break;
    }
    i76 = i95;
    i77 = i94;
    i78 = i93;
    i79 = i92;
    i80 = i91;
    i81 = i90;
    i82 = i89;
    i83 = HEAP32[i14 >> 2] | 0;
    i84 = i73;
    i85 = i72;
    i70 = 794;
   }
  } while (0);
  do {
   if ((i70 | 0) == 794) {
    i70 = 0;
    if ((i83 | 0) == 0) {
     i102 = i25;
     i103 = i31;
     i104 = i85;
     i105 = i84;
     i106 = i78;
     i107 = i77;
     i108 = i76;
     i109 = i79;
     i110 = i80;
     i111 = i81;
     i112 = i82;
     break;
    }
    i24 = (i25 | 0) != 0;
    do {
     if (i24) {
      i44 = HEAP32[i25 + 4 >> 2] | 0;
      if ((i44 | 0) == (i43 | 0)) {
       break;
      } else {
       i113 = i44;
      }
      while (1) {
       i44 = i113 + 4 | 0;
       i45 = HEAP32[i44 >> 2] | 0;
       i41 = i113 | 0;
       i54 = HEAP32[i41 >> 2] | 0;
       i58 = HEAP32[i113 + 8 >> 2] | 0;
       if ((i54 | 0) == (i113 | 0)) {
        HEAP32[(HEAP32[i58 + 12 >> 2] | 0) + 8 >> 2] = 0;
       } else {
        HEAP32[i54 + 4 >> 2] = i45;
        HEAP32[HEAP32[i44 >> 2] >> 2] = i54;
        HEAP32[(HEAP32[i58 + 12 >> 2] | 0) + 8 >> 2] = i54;
       }
       i54 = i58 | 0;
       i44 = HEAP32[i54 >> 2] | 0;
       if ((i44 | 0) == (i58 | 0)) {
        HEAP32[(HEAP32[i113 + 12 >> 2] | 0) + 8 >> 2] = 0;
       } else {
        i47 = i58 + 4 | 0;
        HEAP32[i44 + 4 >> 2] = HEAP32[i47 >> 2];
        HEAP32[HEAP32[i47 >> 2] >> 2] = i44;
        HEAP32[(HEAP32[i113 + 12 >> 2] | 0) + 8 >> 2] = i44;
       }
       _memset(i113 | 0, 0, 20);
       HEAP32[i41 >> 2] = HEAP32[i34 >> 2];
       HEAP32[i34 >> 2] = i113;
       _memset(i58 | 0, 0, 20);
       HEAP32[i54 >> 2] = HEAP32[i34 >> 2];
       HEAP32[i34 >> 2] = i58;
       HEAP32[i26 >> 2] = (HEAP32[i26 >> 2] | 0) - 1;
       if ((i45 | 0) == (i43 | 0)) {
        break;
       } else {
        i113 = i45;
       }
      }
     }
    } while (0);
    if ((i84 | 0) == 0) {
     i114 = i24 ? i31 : i43;
     i115 = i85;
     i116 = i83;
    } else {
     if (i24) {
      HEAP32[i85 >> 2] = i25;
      HEAP32[i25 + 4 >> 2] = i85;
      i117 = i31;
      i118 = i43 | 0;
     } else {
      i53 = i43 | 0;
      i45 = HEAP32[i53 >> 2] | 0;
      HEAP32[i85 >> 2] = i45;
      HEAP32[i45 + 4 >> 2] = i85;
      i117 = i85;
      i118 = i53;
     }
     HEAP32[i118 >> 2] = i84;
     HEAP32[i84 + 4 >> 2] = i43;
     i114 = i117;
     i115 = 0;
     i116 = HEAP32[i14 >> 2] | 0;
    }
    i53 = HEAP32[i5 >> 2] | 0;
    i45 = HEAP32[i53 + 88 >> 2] | 0;
    i58 = HEAP32[i53 + 92 >> 2] | 0;
    i54 = HEAP32[i53 + 96 >> 2] | 0;
    HEAP32[i5 >> 2] = HEAP32[i116 + 12 >> 2];
    i102 = HEAP32[i116 + 8 >> 2] | 0;
    i103 = i114;
    i104 = i115;
    i105 = 0;
    i106 = i45;
    i107 = i58;
    i108 = i54;
    i109 = i79;
    i110 = i80;
    i111 = i81;
    i112 = i82;
   }
  } while (0);
  i43 = HEAP32[i5 >> 2] | 0;
  i54 = HEAP32[i6 >> 2] | 0;
  if ((i43 | 0) == (i67 | 0) & (i54 | 0) == (i68 | 0)) {
   break;
  }
  i25 = i102;
  i31 = i103;
  i23 = i104;
  i37 = i105;
  i38 = 0;
  i20 = i112;
  i2 = i111;
  i36 = i110;
  i21 = i109;
  i46 = i106;
  i65 = i107;
  i22 = i108;
  i66 = i54;
  i42 = i43;
  i40 = HEAP32[i54 + 92 >> 2] | 0;
 }
 if ((i70 | 0) == 753) {
  i70 = HEAP32[i5 >> 2] | 0;
  i40 = __ZN20btConvexHullInternal4PoolINS_4EdgeEE9newObjectEv(i27) | 0;
  i42 = __ZN20btConvexHullInternal4PoolINS_4EdgeEE9newObjectEv(i27) | 0;
  i27 = i40 + 8 | 0;
  HEAP32[i27 >> 2] = i42;
  HEAP32[i42 + 8 >> 2] = i40;
  HEAP32[i40 + 20 >> 2] = HEAP32[i17 >> 2];
  HEAP32[i42 + 20 >> 2] = HEAP32[i17 >> 2];
  HEAP32[i40 + 12 >> 2] = i69;
  HEAP32[i42 + 12 >> 2] = i70;
  HEAP32[i40 + 16 >> 2] = 0;
  HEAP32[i42 + 16 >> 2] = 0;
  i42 = (HEAP32[i26 >> 2] | 0) + 1 | 0;
  HEAP32[i26 >> 2] = i42;
  if ((i42 | 0) > (HEAP32[i33 >> 2] | 0)) {
   HEAP32[i33 >> 2] = i42;
  }
  HEAP32[i40 >> 2] = i40;
  HEAP32[i40 + 4 >> 2] = i40;
  HEAP32[i70 + 8 >> 2] = i40;
  i40 = HEAP32[i27 >> 2] | 0;
  HEAP32[i40 >> 2] = i40;
  HEAP32[i40 + 4 >> 2] = i40;
  HEAP32[i69 + 8 >> 2] = i40;
  STACKTOP = i4;
  return;
 }
 do {
  if ((i102 | 0) == 0) {
   HEAP32[i104 >> 2] = i105;
   HEAP32[i105 + 4 >> 2] = i104;
   HEAP32[(HEAP32[i5 >> 2] | 0) + 8 >> 2] = i105;
  } else {
   i40 = i102 + 4 | 0;
   i69 = HEAP32[i40 >> 2] | 0;
   if ((i69 | 0) != (i103 | 0)) {
    i27 = i69;
    while (1) {
     i69 = i27 + 4 | 0;
     i70 = HEAP32[i69 >> 2] | 0;
     i42 = i27 | 0;
     i33 = HEAP32[i42 >> 2] | 0;
     i17 = HEAP32[i27 + 8 >> 2] | 0;
     if ((i33 | 0) == (i27 | 0)) {
      HEAP32[(HEAP32[i17 + 12 >> 2] | 0) + 8 >> 2] = 0;
     } else {
      HEAP32[i33 + 4 >> 2] = i70;
      HEAP32[HEAP32[i69 >> 2] >> 2] = i33;
      HEAP32[(HEAP32[i17 + 12 >> 2] | 0) + 8 >> 2] = i33;
     }
     i33 = i17 | 0;
     i69 = HEAP32[i33 >> 2] | 0;
     if ((i69 | 0) == (i17 | 0)) {
      HEAP32[(HEAP32[i27 + 12 >> 2] | 0) + 8 >> 2] = 0;
     } else {
      i66 = i17 + 4 | 0;
      HEAP32[i69 + 4 >> 2] = HEAP32[i66 >> 2];
      HEAP32[HEAP32[i66 >> 2] >> 2] = i69;
      HEAP32[(HEAP32[i27 + 12 >> 2] | 0) + 8 >> 2] = i69;
     }
     _memset(i27 | 0, 0, 20);
     HEAP32[i42 >> 2] = HEAP32[i34 >> 2];
     HEAP32[i34 >> 2] = i27;
     _memset(i17 | 0, 0, 20);
     HEAP32[i33 >> 2] = HEAP32[i34 >> 2];
     HEAP32[i34 >> 2] = i17;
     HEAP32[i26 >> 2] = (HEAP32[i26 >> 2] | 0) - 1;
     if ((i70 | 0) == (i103 | 0)) {
      break;
     } else {
      i27 = i70;
     }
    }
   }
   if ((i105 | 0) == 0) {
    break;
   }
   HEAP32[i104 >> 2] = i102;
   HEAP32[i40 >> 2] = i104;
   HEAP32[i103 >> 2] = i105;
   HEAP32[i105 + 4 >> 2] = i103;
  }
 } while (0);
 if ((i112 | 0) == 0) {
  HEAP32[i109 >> 2] = i110;
  HEAP32[i110 + 4 >> 2] = i109;
  HEAP32[(HEAP32[i6 >> 2] | 0) + 8 >> 2] = i109;
  STACKTOP = i4;
  return;
 }
 i6 = i112 | 0;
 i103 = HEAP32[i6 >> 2] | 0;
 if ((i103 | 0) != (i111 | 0)) {
  i105 = i103;
  while (1) {
   i103 = i105 | 0;
   i104 = HEAP32[i103 >> 2] | 0;
   i102 = HEAP32[i105 + 8 >> 2] | 0;
   if ((i104 | 0) == (i105 | 0)) {
    HEAP32[(HEAP32[i102 + 12 >> 2] | 0) + 8 >> 2] = 0;
   } else {
    i5 = i105 + 4 | 0;
    HEAP32[i104 + 4 >> 2] = HEAP32[i5 >> 2];
    HEAP32[HEAP32[i5 >> 2] >> 2] = i104;
    HEAP32[(HEAP32[i102 + 12 >> 2] | 0) + 8 >> 2] = i104;
   }
   i5 = i102 | 0;
   i27 = HEAP32[i5 >> 2] | 0;
   if ((i27 | 0) == (i102 | 0)) {
    HEAP32[(HEAP32[i105 + 12 >> 2] | 0) + 8 >> 2] = 0;
   } else {
    i70 = i102 + 4 | 0;
    HEAP32[i27 + 4 >> 2] = HEAP32[i70 >> 2];
    HEAP32[HEAP32[i70 >> 2] >> 2] = i27;
    HEAP32[(HEAP32[i105 + 12 >> 2] | 0) + 8 >> 2] = i27;
   }
   _memset(i105 | 0, 0, 20);
   HEAP32[i103 >> 2] = HEAP32[i34 >> 2];
   HEAP32[i34 >> 2] = i105;
   _memset(i102 | 0, 0, 20);
   HEAP32[i5 >> 2] = HEAP32[i34 >> 2];
   HEAP32[i34 >> 2] = i102;
   HEAP32[i26 >> 2] = (HEAP32[i26 >> 2] | 0) - 1;
   if ((i104 | 0) == (i111 | 0)) {
    break;
   } else {
    i105 = i104;
   }
  }
 }
 if ((i109 | 0) == 0) {
  STACKTOP = i4;
  return;
 }
 HEAP32[i6 >> 2] = i110;
 HEAP32[i110 + 4 >> 2] = i112;
 HEAP32[i109 >> 2] = i111;
 HEAP32[i111 + 4 >> 2] = i109;
 STACKTOP = i4;
 return;
}
function __ZN17btGjkPairDetector26getClosestPointsNonVirtualERKN36btDiscreteCollisionDetectorInterface17ClosestPointInputERNS0_6ResultEP12btIDebugDraw(i1, i2, i3, i4) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 var i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, d33 = 0.0, d34 = 0.0, d35 = 0.0, d36 = 0.0, i37 = 0, d38 = 0.0, i39 = 0, d40 = 0.0, d41 = 0.0, d42 = 0.0, d43 = 0.0, d44 = 0.0, i45 = 0, d46 = 0.0, i47 = 0, d48 = 0.0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0, i62 = 0, i63 = 0, i64 = 0, i65 = 0, i66 = 0, i67 = 0, i68 = 0, i69 = 0, i70 = 0, i71 = 0, i72 = 0, i73 = 0, i74 = 0, i75 = 0, i76 = 0, i77 = 0, i78 = 0, i79 = 0, i80 = 0, i81 = 0, i82 = 0, i83 = 0, i84 = 0, i85 = 0, i86 = 0, i87 = 0, i88 = 0, i89 = 0, i90 = 0, i91 = 0, i92 = 0, i93 = 0, i94 = 0, i95 = 0, i96 = 0, i97 = 0, i98 = 0, i99 = 0, i100 = 0, i101 = 0, i102 = 0, i103 = 0, i104 = 0, i105 = 0, i106 = 0, i107 = 0, i108 = 0, i109 = 0, i110 = 0, i111 = 0, i112 = 0, i113 = 0, i114 = 0, i115 = 0, i116 = 0, i117 = 0, i118 = 0, i119 = 0, i120 = 0, i121 = 0, i122 = 0, i123 = 0, i124 = 0, i125 = 0, d126 = 0.0, d127 = 0.0, d128 = 0.0, d129 = 0.0, d130 = 0.0, d131 = 0.0, d132 = 0.0, d133 = 0.0, d134 = 0.0, d135 = 0.0, d136 = 0.0, d137 = 0.0, d138 = 0.0, d139 = 0.0, i140 = 0, d141 = 0.0, d142 = 0.0, d143 = 0.0, d144 = 0.0, d145 = 0.0, d146 = 0.0, i147 = 0, d148 = 0.0, i149 = 0, d150 = 0.0, d151 = 0.0, d152 = 0.0, d153 = 0.0, i154 = 0, d155 = 0.0, d156 = 0.0, d157 = 0.0, d158 = 0.0, d159 = 0.0, d160 = 0.0;
 i5 = STACKTOP;
 STACKTOP = STACKTOP + 352 | 0;
 i6 = i5 | 0;
 i7 = i5 + 16 | 0;
 i8 = i5 + 32 | 0;
 i9 = i5 + 48 | 0;
 i10 = i5 + 112 | 0;
 i11 = i5 + 176 | 0;
 i12 = i5 + 192 | 0;
 i13 = i5 + 208 | 0;
 i14 = i5 + 224 | 0;
 i15 = i5 + 240 | 0;
 i16 = i5 + 256 | 0;
 i17 = i5 + 272 | 0;
 i18 = i5 + 288 | 0;
 i19 = i5 + 304 | 0;
 i20 = i5 + 320 | 0;
 i21 = i5 + 336 | 0;
 i22 = i1 + 56 | 0;
 HEAPF32[i22 >> 2] = 0.0;
 i23 = i6 | 0;
 i24 = i6 + 4 | 0;
 i25 = i6 + 8 | 0;
 i26 = i6 + 12 | 0;
 i27 = i9;
 i28 = i2;
 i29 = i6;
 _memset(i29 | 0, 0, 16);
 HEAP32[i27 >> 2] = HEAP32[i28 >> 2];
 HEAP32[i27 + 4 >> 2] = HEAP32[i28 + 4 >> 2];
 HEAP32[i27 + 8 >> 2] = HEAP32[i28 + 8 >> 2];
 HEAP32[i27 + 12 >> 2] = HEAP32[i28 + 12 >> 2];
 i28 = i9 + 16 | 0;
 i27 = i2 + 16 | 0;
 HEAP32[i28 >> 2] = HEAP32[i27 >> 2];
 HEAP32[i28 + 4 >> 2] = HEAP32[i27 + 4 >> 2];
 HEAP32[i28 + 8 >> 2] = HEAP32[i27 + 8 >> 2];
 HEAP32[i28 + 12 >> 2] = HEAP32[i27 + 12 >> 2];
 i27 = i9 + 32 | 0;
 i28 = i2 + 32 | 0;
 HEAP32[i27 >> 2] = HEAP32[i28 >> 2];
 HEAP32[i27 + 4 >> 2] = HEAP32[i28 + 4 >> 2];
 HEAP32[i27 + 8 >> 2] = HEAP32[i28 + 8 >> 2];
 HEAP32[i27 + 12 >> 2] = HEAP32[i28 + 12 >> 2];
 i28 = i9 + 48 | 0;
 i27 = i28;
 i30 = i2 + 48 | 0;
 HEAP32[i27 >> 2] = HEAP32[i30 >> 2];
 HEAP32[i27 + 4 >> 2] = HEAP32[i30 + 4 >> 2];
 HEAP32[i27 + 8 >> 2] = HEAP32[i30 + 8 >> 2];
 HEAP32[i27 + 12 >> 2] = HEAP32[i30 + 12 >> 2];
 i30 = i2 + 64 | 0;
 i27 = i10;
 i31 = i30;
 HEAP32[i27 >> 2] = HEAP32[i31 >> 2];
 HEAP32[i27 + 4 >> 2] = HEAP32[i31 + 4 >> 2];
 HEAP32[i27 + 8 >> 2] = HEAP32[i31 + 8 >> 2];
 HEAP32[i27 + 12 >> 2] = HEAP32[i31 + 12 >> 2];
 i31 = i10 + 16 | 0;
 i27 = i2 + 80 | 0;
 HEAP32[i31 >> 2] = HEAP32[i27 >> 2];
 HEAP32[i31 + 4 >> 2] = HEAP32[i27 + 4 >> 2];
 HEAP32[i31 + 8 >> 2] = HEAP32[i27 + 8 >> 2];
 HEAP32[i31 + 12 >> 2] = HEAP32[i27 + 12 >> 2];
 i27 = i10 + 32 | 0;
 i31 = i2 + 96 | 0;
 HEAP32[i27 >> 2] = HEAP32[i31 >> 2];
 HEAP32[i27 + 4 >> 2] = HEAP32[i31 + 4 >> 2];
 HEAP32[i27 + 8 >> 2] = HEAP32[i31 + 8 >> 2];
 HEAP32[i27 + 12 >> 2] = HEAP32[i31 + 12 >> 2];
 i31 = i10 + 48 | 0;
 i27 = i31;
 i32 = i2 + 112 | 0;
 HEAP32[i27 >> 2] = HEAP32[i32 >> 2];
 HEAP32[i27 + 4 >> 2] = HEAP32[i32 + 4 >> 2];
 HEAP32[i27 + 8 >> 2] = HEAP32[i32 + 8 >> 2];
 HEAP32[i27 + 12 >> 2] = HEAP32[i32 + 12 >> 2];
 i32 = i28 | 0;
 d33 = +HEAPF32[i32 >> 2];
 i28 = i31 | 0;
 d34 = +HEAPF32[i28 >> 2];
 i31 = i9 + 52 | 0;
 d35 = +HEAPF32[i31 >> 2];
 i27 = i10 + 52 | 0;
 d36 = +HEAPF32[i27 >> 2];
 i37 = i9 + 56 | 0;
 d38 = +HEAPF32[i37 >> 2];
 i39 = i10 + 56 | 0;
 d40 = +HEAPF32[i39 >> 2];
 d41 = (d33 + d34) * .5;
 d42 = (d35 + d36) * .5;
 d43 = (d38 + d40) * .5;
 d44 = d33 - d41;
 HEAPF32[i32 >> 2] = d44;
 d33 = d35 - d42;
 HEAPF32[i31 >> 2] = d33;
 d35 = d38 - d43;
 HEAPF32[i37 >> 2] = d35;
 d38 = d34 - d41;
 HEAPF32[i28 >> 2] = d38;
 d34 = d36 - d42;
 HEAPF32[i27 >> 2] = d34;
 d36 = d40 - d43;
 HEAPF32[i39 >> 2] = d36;
 i28 = i1 + 28 | 0;
 i32 = i1 + 32 | 0;
 if (((HEAP32[(HEAP32[i28 >> 2] | 0) + 4 >> 2] | 0) - 17 | 0) >>> 0 < 2) {
  i45 = ((HEAP32[(HEAP32[i32 >> 2] | 0) + 4 >> 2] | 0) - 17 | 0) >>> 0 < 2;
 } else {
  i45 = 0;
 }
 d40 = +HEAPF32[i1 + 44 >> 2];
 d46 = +HEAPF32[i1 + 48 >> 2];
 HEAP32[2992] = (HEAP32[2992] | 0) + 1;
 i47 = (HEAP8[i1 + 52 | 0] | 0) == 0;
 d48 = i47 ? d40 : 0.0;
 d40 = i47 ? d46 : 0.0;
 i47 = i1 + 64 | 0;
 HEAP32[i47 >> 2] = 0;
 i49 = i1 + 4 | 0;
 i50 = i49 | 0;
 HEAPF32[i50 >> 2] = 0.0;
 i51 = i1 + 8 | 0;
 HEAPF32[i51 >> 2] = 1.0;
 i52 = i1 + 12 | 0;
 HEAPF32[i52 >> 2] = 0.0;
 i53 = i1 + 16 | 0;
 HEAPF32[i53 >> 2] = 0.0;
 i54 = i1 + 68 | 0;
 HEAP32[i54 >> 2] = 0;
 i55 = i1 + 60 | 0;
 HEAP32[i55 >> 2] = -1;
 d46 = d48 + d40;
 i56 = i1 + 24 | 0;
 __ZN22btVoronoiSimplexSolver5resetEv(HEAP32[i56 >> 2] | 0);
 i57 = i2 | 0;
 i58 = i2 + 16 | 0;
 i59 = i2 + 32 | 0;
 i60 = i2 + 4 | 0;
 i61 = i2 + 20 | 0;
 i62 = i2 + 36 | 0;
 i63 = i2 + 8 | 0;
 i64 = i2 + 24 | 0;
 i65 = i2 + 40 | 0;
 i66 = i11 | 0;
 i67 = i11 + 4 | 0;
 i68 = i11 + 8 | 0;
 i69 = i11 + 12 | 0;
 i70 = i30 | 0;
 i30 = i2 + 80 | 0;
 i71 = i2 + 96 | 0;
 i72 = i2 + 68 | 0;
 i73 = i2 + 84 | 0;
 i74 = i2 + 100 | 0;
 i75 = i2 + 72 | 0;
 i76 = i2 + 88 | 0;
 i77 = i2 + 104 | 0;
 i78 = i12 | 0;
 i79 = i12 + 4 | 0;
 i80 = i12 + 8 | 0;
 i81 = i12 + 12 | 0;
 i82 = i9 | 0;
 i83 = i13 | 0;
 i84 = i9 + 4 | 0;
 i85 = i13 + 4 | 0;
 i86 = i9 + 8 | 0;
 i87 = i13 + 8 | 0;
 i88 = i9 + 48 | 0;
 i89 = i9 + 16 | 0;
 i90 = i9 + 20 | 0;
 i91 = i9 + 24 | 0;
 i92 = i9 + 32 | 0;
 i93 = i9 + 36 | 0;
 i94 = i9 + 40 | 0;
 i95 = i15 | 0;
 i96 = i15 + 4 | 0;
 i97 = i15 + 8 | 0;
 i98 = i15 + 12 | 0;
 i99 = i10 | 0;
 i100 = i14 | 0;
 i101 = i10 + 4 | 0;
 i102 = i14 + 4 | 0;
 i103 = i10 + 8 | 0;
 i104 = i14 + 8 | 0;
 i105 = i10 + 48 | 0;
 i106 = i10 + 16 | 0;
 i107 = i10 + 20 | 0;
 i108 = i10 + 24 | 0;
 i109 = i10 + 32 | 0;
 i110 = i10 + 36 | 0;
 i111 = i10 + 40 | 0;
 i112 = i16 | 0;
 i113 = i16 + 4 | 0;
 i114 = i16 + 8 | 0;
 i115 = i16 + 12 | 0;
 i116 = i17 | 0;
 i117 = i17 + 4 | 0;
 i118 = i17 + 8 | 0;
 i119 = i17 + 12 | 0;
 i120 = i2 + 128 | 0;
 i121 = i18 | 0;
 i122 = i18 + 4 | 0;
 i123 = i18 + 8 | 0;
 i124 = i49;
 i125 = i18;
 L1498 : do {
  if (i45) {
   d126 = 999999984306749400.0;
   d127 = d44;
   d128 = d33;
   d129 = d38;
   d130 = d34;
   while (1) {
    d131 = +HEAPF32[i50 >> 2];
    d132 = -0.0 - d131;
    d133 = +HEAPF32[i51 >> 2];
    d134 = -0.0 - d133;
    d135 = +HEAPF32[i52 >> 2];
    d136 = -0.0 - d135;
    d137 = +HEAPF32[i60 >> 2] * d132 + +HEAPF32[i61 >> 2] * d134 + +HEAPF32[i62 >> 2] * d136;
    d138 = +HEAPF32[i63 >> 2] * d132 + +HEAPF32[i64 >> 2] * d134 + +HEAPF32[i65 >> 2] * d136;
    HEAPF32[i66 >> 2] = +HEAPF32[i57 >> 2] * d132 + +HEAPF32[i58 >> 2] * d134 + +HEAPF32[i59 >> 2] * d136;
    HEAPF32[i67 >> 2] = d137;
    HEAPF32[i68 >> 2] = d138;
    HEAPF32[i69 >> 2] = 0.0;
    d138 = d131 * +HEAPF32[i72 >> 2] + d133 * +HEAPF32[i73 >> 2] + d135 * +HEAPF32[i74 >> 2];
    d137 = d131 * +HEAPF32[i75 >> 2] + d133 * +HEAPF32[i76 >> 2] + d135 * +HEAPF32[i77 >> 2];
    HEAPF32[i78 >> 2] = d131 * +HEAPF32[i70 >> 2] + d133 * +HEAPF32[i30 >> 2] + d135 * +HEAPF32[i71 >> 2];
    HEAPF32[i79 >> 2] = d138;
    HEAPF32[i80 >> 2] = d137;
    HEAPF32[i81 >> 2] = 0.0;
    __ZNK13btConvexShape44localGetSupportVertexWithoutMarginNonVirtualERK9btVector3(i13, HEAP32[i28 >> 2] | 0, i11);
    __ZNK13btConvexShape44localGetSupportVertexWithoutMarginNonVirtualERK9btVector3(i14, HEAP32[i32 >> 2] | 0, i12);
    d137 = +HEAPF32[i83 >> 2];
    d138 = +HEAPF32[i85 >> 2];
    d135 = +HEAPF32[i87 >> 2];
    d133 = d127 + (+HEAPF32[i82 >> 2] * d137 + +HEAPF32[i84 >> 2] * d138 + +HEAPF32[i86 >> 2] * d135);
    d131 = d128 + (d137 * +HEAPF32[i89 >> 2] + d138 * +HEAPF32[i90 >> 2] + d135 * +HEAPF32[i91 >> 2]);
    HEAPF32[i95 >> 2] = d133;
    HEAPF32[i96 >> 2] = d131;
    HEAPF32[i98 >> 2] = 0.0;
    d135 = +HEAPF32[i100 >> 2];
    d138 = +HEAPF32[i102 >> 2];
    d137 = +HEAPF32[i104 >> 2];
    d136 = d129 + (+HEAPF32[i99 >> 2] * d135 + +HEAPF32[i101 >> 2] * d138 + +HEAPF32[i103 >> 2] * d137);
    d134 = d130 + (d135 * +HEAPF32[i106 >> 2] + d138 * +HEAPF32[i107 >> 2] + d137 * +HEAPF32[i108 >> 2]);
    HEAPF32[i112 >> 2] = d136;
    HEAPF32[i113 >> 2] = d134;
    HEAPF32[i115 >> 2] = 0.0;
    HEAPF32[i97 >> 2] = 0.0;
    HEAPF32[i114 >> 2] = 0.0;
    d137 = d133 - d136;
    d136 = d131 - d134;
    HEAPF32[i116 >> 2] = d137;
    HEAPF32[i117 >> 2] = d136;
    HEAPF32[i118 >> 2] = 0.0;
    HEAPF32[i119 >> 2] = 0.0;
    d134 = d137 * +HEAPF32[i50 >> 2] + d136 * +HEAPF32[i51 >> 2] + +HEAPF32[i52 >> 2] * 0.0;
    if (d134 > 0.0) {
     if (d134 * d134 > d126 * +HEAPF32[i120 >> 2]) {
      d139 = d126;
      i140 = 1318;
      break L1498;
     }
    }
    if (__ZN22btVoronoiSimplexSolver9inSimplexERK9btVector3(HEAP32[i56 >> 2] | 0, i17) | 0) {
     d141 = d126;
     i140 = 1320;
     break L1498;
    }
    d136 = d126 - d134;
    if (d136 <= d126 * 9.999999974752427e-7) {
     d142 = d126;
     d143 = d136;
     i140 = 1322;
     break L1498;
    }
    __ZN22btVoronoiSimplexSolver9addVertexERK9btVector3S2_S2_(HEAP32[i56 >> 2] | 0, i17, i15, i16);
    if (!(__ZN22btVoronoiSimplexSolver7closestER9btVector3(HEAP32[i56 >> 2] | 0, i18) | 0)) {
     d144 = d126;
     i140 = 1324;
     break L1498;
    }
    d136 = +HEAPF32[i121 >> 2];
    d134 = +HEAPF32[i122 >> 2];
    d137 = +HEAPF32[i123 >> 2];
    d131 = d136 * d136 + d134 * d134 + d137 * d137;
    if (d131 < 9.999999974752427e-7) {
     d145 = d126;
     i140 = 1326;
     break L1498;
    }
    if (d126 - d131 <= d126 * 1.1920928955078125e-7) {
     d146 = d131;
     i140 = 1328;
     break L1498;
    }
    HEAP32[i124 >> 2] = HEAP32[i125 >> 2];
    HEAP32[i124 + 4 >> 2] = HEAP32[i125 + 4 >> 2];
    HEAP32[i124 + 8 >> 2] = HEAP32[i125 + 8 >> 2];
    HEAP32[i124 + 12 >> 2] = HEAP32[i125 + 12 >> 2];
    i147 = HEAP32[i47 >> 2] | 0;
    HEAP32[i47 >> 2] = i147 + 1;
    if ((i147 | 0) > 1e3) {
     d148 = 0.0;
     i149 = 0;
     break L1498;
    }
    if ((HEAP32[HEAP32[i56 >> 2] >> 2] | 0) == 4) {
     i140 = 1332;
     break L1498;
    }
    d126 = d131;
    d127 = +HEAPF32[i88 >> 2];
    d128 = +HEAPF32[i31 >> 2];
    d129 = +HEAPF32[i105 >> 2];
    d130 = +HEAPF32[i27 >> 2];
   }
  } else {
   d130 = 999999984306749400.0;
   d129 = d44;
   d128 = d33;
   d127 = d35;
   d126 = d38;
   d131 = d34;
   d137 = d36;
   while (1) {
    d134 = +HEAPF32[i50 >> 2];
    d136 = -0.0 - d134;
    d133 = +HEAPF32[i51 >> 2];
    d138 = -0.0 - d133;
    d135 = +HEAPF32[i52 >> 2];
    d132 = -0.0 - d135;
    d150 = +HEAPF32[i60 >> 2] * d136 + +HEAPF32[i61 >> 2] * d138 + +HEAPF32[i62 >> 2] * d132;
    d151 = +HEAPF32[i63 >> 2] * d136 + +HEAPF32[i64 >> 2] * d138 + +HEAPF32[i65 >> 2] * d132;
    HEAPF32[i66 >> 2] = +HEAPF32[i57 >> 2] * d136 + +HEAPF32[i58 >> 2] * d138 + +HEAPF32[i59 >> 2] * d132;
    HEAPF32[i67 >> 2] = d150;
    HEAPF32[i68 >> 2] = d151;
    HEAPF32[i69 >> 2] = 0.0;
    d151 = d134 * +HEAPF32[i72 >> 2] + d133 * +HEAPF32[i73 >> 2] + d135 * +HEAPF32[i74 >> 2];
    d150 = d134 * +HEAPF32[i75 >> 2] + d133 * +HEAPF32[i76 >> 2] + d135 * +HEAPF32[i77 >> 2];
    HEAPF32[i78 >> 2] = d134 * +HEAPF32[i70 >> 2] + d133 * +HEAPF32[i30 >> 2] + d135 * +HEAPF32[i71 >> 2];
    HEAPF32[i79 >> 2] = d151;
    HEAPF32[i80 >> 2] = d150;
    HEAPF32[i81 >> 2] = 0.0;
    __ZNK13btConvexShape44localGetSupportVertexWithoutMarginNonVirtualERK9btVector3(i13, HEAP32[i28 >> 2] | 0, i11);
    __ZNK13btConvexShape44localGetSupportVertexWithoutMarginNonVirtualERK9btVector3(i14, HEAP32[i32 >> 2] | 0, i12);
    d150 = +HEAPF32[i83 >> 2];
    d151 = +HEAPF32[i85 >> 2];
    d135 = +HEAPF32[i87 >> 2];
    d133 = d129 + (+HEAPF32[i82 >> 2] * d150 + +HEAPF32[i84 >> 2] * d151 + +HEAPF32[i86 >> 2] * d135);
    d134 = d128 + (d150 * +HEAPF32[i89 >> 2] + d151 * +HEAPF32[i90 >> 2] + d135 * +HEAPF32[i91 >> 2]);
    d132 = d127 + (d150 * +HEAPF32[i92 >> 2] + d151 * +HEAPF32[i93 >> 2] + d135 * +HEAPF32[i94 >> 2]);
    HEAPF32[i95 >> 2] = d133;
    HEAPF32[i96 >> 2] = d134;
    HEAPF32[i97 >> 2] = d132;
    HEAPF32[i98 >> 2] = 0.0;
    d135 = +HEAPF32[i100 >> 2];
    d151 = +HEAPF32[i102 >> 2];
    d150 = +HEAPF32[i104 >> 2];
    d138 = d126 + (+HEAPF32[i99 >> 2] * d135 + +HEAPF32[i101 >> 2] * d151 + +HEAPF32[i103 >> 2] * d150);
    d136 = d131 + (d135 * +HEAPF32[i106 >> 2] + d151 * +HEAPF32[i107 >> 2] + d150 * +HEAPF32[i108 >> 2]);
    d152 = d137 + (d135 * +HEAPF32[i109 >> 2] + d151 * +HEAPF32[i110 >> 2] + d150 * +HEAPF32[i111 >> 2]);
    HEAPF32[i112 >> 2] = d138;
    HEAPF32[i113 >> 2] = d136;
    HEAPF32[i114 >> 2] = d152;
    HEAPF32[i115 >> 2] = 0.0;
    d150 = d133 - d138;
    d138 = d134 - d136;
    d136 = d132 - d152;
    HEAPF32[i116 >> 2] = d150;
    HEAPF32[i117 >> 2] = d138;
    HEAPF32[i118 >> 2] = d136;
    HEAPF32[i119 >> 2] = 0.0;
    d152 = d150 * +HEAPF32[i50 >> 2] + d138 * +HEAPF32[i51 >> 2] + d136 * +HEAPF32[i52 >> 2];
    if (d152 > 0.0) {
     if (d152 * d152 > d130 * +HEAPF32[i120 >> 2]) {
      d139 = d130;
      i140 = 1318;
      break L1498;
     }
    }
    if (__ZN22btVoronoiSimplexSolver9inSimplexERK9btVector3(HEAP32[i56 >> 2] | 0, i17) | 0) {
     d141 = d130;
     i140 = 1320;
     break L1498;
    }
    d136 = d130 - d152;
    if (d136 <= d130 * 9.999999974752427e-7) {
     d142 = d130;
     d143 = d136;
     i140 = 1322;
     break L1498;
    }
    __ZN22btVoronoiSimplexSolver9addVertexERK9btVector3S2_S2_(HEAP32[i56 >> 2] | 0, i17, i15, i16);
    if (!(__ZN22btVoronoiSimplexSolver7closestER9btVector3(HEAP32[i56 >> 2] | 0, i18) | 0)) {
     d144 = d130;
     i140 = 1324;
     break L1498;
    }
    d136 = +HEAPF32[i121 >> 2];
    d152 = +HEAPF32[i122 >> 2];
    d138 = +HEAPF32[i123 >> 2];
    d150 = d136 * d136 + d152 * d152 + d138 * d138;
    if (d150 < 9.999999974752427e-7) {
     d145 = d130;
     i140 = 1326;
     break L1498;
    }
    if (d130 - d150 <= d130 * 1.1920928955078125e-7) {
     d146 = d150;
     i140 = 1328;
     break L1498;
    }
    HEAP32[i124 >> 2] = HEAP32[i125 >> 2];
    HEAP32[i124 + 4 >> 2] = HEAP32[i125 + 4 >> 2];
    HEAP32[i124 + 8 >> 2] = HEAP32[i125 + 8 >> 2];
    HEAP32[i124 + 12 >> 2] = HEAP32[i125 + 12 >> 2];
    i147 = HEAP32[i47 >> 2] | 0;
    HEAP32[i47 >> 2] = i147 + 1;
    if ((i147 | 0) > 1e3) {
     d148 = 0.0;
     i149 = 0;
     break L1498;
    }
    if ((HEAP32[HEAP32[i56 >> 2] >> 2] | 0) == 4) {
     i140 = 1332;
     break L1498;
    }
    d130 = d150;
    d129 = +HEAPF32[i88 >> 2];
    d128 = +HEAPF32[i31 >> 2];
    d127 = +HEAPF32[i37 >> 2];
    d126 = +HEAPF32[i105 >> 2];
    d131 = +HEAPF32[i27 >> 2];
    d137 = +HEAPF32[i39 >> 2];
   }
  }
 } while (0);
 if ((i140 | 0) == 1326) {
  HEAP32[i124 >> 2] = HEAP32[i125 >> 2];
  HEAP32[i124 + 4 >> 2] = HEAP32[i125 + 4 >> 2];
  HEAP32[i124 + 8 >> 2] = HEAP32[i125 + 8 >> 2];
  HEAP32[i124 + 12 >> 2] = HEAP32[i125 + 12 >> 2];
  HEAP32[i54 >> 2] = 6;
  d153 = d145;
  i140 = 1333;
 } else if ((i140 | 0) == 1328) {
  HEAP32[i54 >> 2] = 12;
  d153 = d146;
  i140 = 1333;
 } else if ((i140 | 0) == 1322) {
  HEAP32[i54 >> 2] = d143 > 0.0 ? 11 : 2;
  d153 = d142;
  i140 = 1333;
 } else if ((i140 | 0) == 1318) {
  HEAP32[i54 >> 2] = 10;
  d153 = d139;
  i140 = 1333;
 } else if ((i140 | 0) == 1320) {
  HEAP32[i54 >> 2] = 1;
  d153 = d141;
  i140 = 1333;
 } else if ((i140 | 0) == 1324) {
  HEAP32[i54 >> 2] = 3;
  d153 = d144;
  i140 = 1333;
 } else if ((i140 | 0) == 1332) {
  HEAP32[i54 >> 2] = 13;
  d148 = 0.0;
  i149 = 0;
 }
 do {
  if ((i140 | 0) == 1333) {
   __ZN22btVoronoiSimplexSolver14compute_pointsER9btVector3S1_(HEAP32[i56 >> 2] | 0, i7, i8);
   HEAP32[i29 >> 2] = HEAP32[i124 >> 2];
   HEAP32[i29 + 4 >> 2] = HEAP32[i124 + 4 >> 2];
   HEAP32[i29 + 8 >> 2] = HEAP32[i124 + 8 >> 2];
   HEAP32[i29 + 12 >> 2] = HEAP32[i124 + 12 >> 2];
   d144 = +HEAPF32[i50 >> 2];
   d141 = +HEAPF32[i51 >> 2];
   d139 = +HEAPF32[i52 >> 2];
   d142 = d144 * d144 + d141 * d141 + d139 * d139;
   if (d142 < 1.0e-4) {
    HEAP32[i54 >> 2] = 5;
   }
   if (d142 > 1.4210854715202004e-14) {
    d143 = 1.0 / +Math_sqrt(+d142);
    HEAPF32[i23 >> 2] = d143 * +HEAPF32[i23 >> 2];
    HEAPF32[i24 >> 2] = d143 * +HEAPF32[i24 >> 2];
    HEAPF32[i25 >> 2] = d143 * +HEAPF32[i25 >> 2];
    d142 = +Math_sqrt(+d153);
    d146 = d48 / d142;
    i125 = i7 | 0;
    HEAPF32[i125 >> 2] = +HEAPF32[i125 >> 2] - d144 * d146;
    i125 = i7 + 4 | 0;
    HEAPF32[i125 >> 2] = +HEAPF32[i125 >> 2] - d141 * d146;
    i125 = i7 + 8 | 0;
    HEAPF32[i125 >> 2] = +HEAPF32[i125 >> 2] - d139 * d146;
    d146 = d40 / d142;
    i125 = i8 | 0;
    HEAPF32[i125 >> 2] = d144 * d146 + +HEAPF32[i125 >> 2];
    i125 = i8 + 4 | 0;
    HEAPF32[i125 >> 2] = d141 * d146 + +HEAPF32[i125 >> 2];
    i125 = i8 + 8 | 0;
    HEAPF32[i125 >> 2] = d139 * d146 + +HEAPF32[i125 >> 2];
    HEAP32[i55 >> 2] = 1;
    d148 = 1.0 / d143 - d46;
    i149 = 1;
    break;
   } else {
    HEAP32[i55 >> 2] = 2;
    d148 = 0.0;
    i149 = 0;
    break;
   }
  }
 } while (0);
 do {
  if ((HEAP32[i1 + 72 >> 2] | 0) == 0) {
   i154 = 0;
  } else {
   if ((HEAP32[i1 + 20 >> 2] | 0) == 0) {
    i154 = 0;
    break;
   }
   if ((HEAP32[i54 >> 2] | 0) == 0) {
    i154 = 0;
    break;
   }
   i154 = d46 + d148 < .01;
  }
 } while (0);
 i54 = i149 ^ 1;
 do {
  if (i154 | i54) {
   i125 = HEAP32[i1 + 20 >> 2] | 0;
   if ((i125 | 0) == 0) {
    i140 = 1356;
    break;
   }
   HEAP32[2994] = (HEAP32[2994] | 0) + 1;
   _memset(i124 | 0, 0, 16);
   if (!(FUNCTION_TABLE_iiiiiiiiiiii[HEAP32[(HEAP32[i125 >> 2] | 0) + 8 >> 2] & 7](i125, HEAP32[i56 >> 2] | 0, HEAP32[i28 >> 2] | 0, HEAP32[i32 >> 2] | 0, i9, i10, i49, i19, i20, i4, HEAP32[i2 + 132 >> 2] | 0) | 0)) {
    d153 = +HEAPF32[i50 >> 2];
    d143 = +HEAPF32[i51 >> 2];
    d146 = +HEAPF32[i52 >> 2];
    if (d153 * d153 + d143 * d143 + d146 * d146 <= 0.0) {
     i140 = 1356;
     break;
    }
    d139 = +HEAPF32[i19 >> 2] - +HEAPF32[i20 >> 2];
    d141 = +HEAPF32[i19 + 4 >> 2] - +HEAPF32[i20 + 4 >> 2];
    d144 = +HEAPF32[i19 + 8 >> 2] - +HEAPF32[i20 + 8 >> 2];
    d142 = +Math_sqrt(+(d139 * d139 + d141 * d141 + d144 * d144)) - d46;
    if (d142 < d148 | i54) {
     i125 = i7;
     i39 = i19;
     HEAP32[i125 >> 2] = HEAP32[i39 >> 2];
     HEAP32[i125 + 4 >> 2] = HEAP32[i39 + 4 >> 2];
     HEAP32[i125 + 8 >> 2] = HEAP32[i39 + 8 >> 2];
     HEAP32[i125 + 12 >> 2] = HEAP32[i39 + 12 >> 2];
     i39 = i8;
     i125 = i20;
     HEAP32[i39 >> 2] = HEAP32[i125 >> 2];
     HEAP32[i39 + 4 >> 2] = HEAP32[i125 + 4 >> 2];
     HEAP32[i39 + 8 >> 2] = HEAP32[i125 + 8 >> 2];
     HEAP32[i39 + 12 >> 2] = HEAP32[i125 + 12 >> 2];
     i125 = i7 | 0;
     HEAPF32[i125 >> 2] = +HEAPF32[i125 >> 2] - d48 * d153;
     i125 = i7 + 4 | 0;
     HEAPF32[i125 >> 2] = +HEAPF32[i125 >> 2] - d48 * d143;
     i125 = i7 + 8 | 0;
     HEAPF32[i125 >> 2] = +HEAPF32[i125 >> 2] - d48 * d146;
     i125 = i8 | 0;
     HEAPF32[i125 >> 2] = d40 * d153 + +HEAPF32[i125 >> 2];
     i125 = i8 + 4 | 0;
     HEAPF32[i125 >> 2] = d40 * d143 + +HEAPF32[i125 >> 2];
     i125 = i8 + 8 | 0;
     HEAPF32[i125 >> 2] = d40 * d146 + +HEAPF32[i125 >> 2];
     HEAP32[i29 >> 2] = HEAP32[i124 >> 2];
     HEAP32[i29 + 4 >> 2] = HEAP32[i124 + 4 >> 2];
     HEAP32[i29 + 8 >> 2] = HEAP32[i124 + 8 >> 2];
     HEAP32[i29 + 12 >> 2] = HEAP32[i124 + 12 >> 2];
     d146 = +HEAPF32[i23 >> 2];
     d143 = +HEAPF32[i24 >> 2];
     d153 = +HEAPF32[i25 >> 2];
     d144 = 1.0 / +Math_sqrt(+(d146 * d146 + d143 * d143 + d153 * d153));
     HEAPF32[i23 >> 2] = d146 * d144;
     HEAPF32[i24 >> 2] = d143 * d144;
     HEAPF32[i25 >> 2] = d153 * d144;
     HEAP32[i55 >> 2] = 6;
     d155 = d142;
     break;
    }
    HEAP32[i55 >> 2] = 5;
    if (i149) {
     d155 = d148;
     break;
    }
    STACKTOP = i5;
    return;
   }
   d142 = +HEAPF32[i20 >> 2];
   d144 = +HEAPF32[i19 >> 2];
   d153 = d142 - d144;
   d143 = +HEAPF32[i20 + 4 >> 2];
   d146 = +HEAPF32[i19 + 4 >> 2];
   d141 = d143 - d146;
   d139 = +HEAPF32[i20 + 8 >> 2];
   d145 = +HEAPF32[i19 + 8 >> 2];
   d36 = d139 - d145;
   d34 = d153 * d153 + d141 * d141 + d36 * d36;
   if (d34 > 1.4210854715202004e-14) {
    d156 = d34;
    d157 = d153;
    d158 = d141;
    d159 = d36;
    d160 = 0.0;
   } else {
    d36 = +HEAPF32[i1 + 4 >> 2];
    d141 = +HEAPF32[i51 >> 2];
    d153 = +HEAPF32[i52 >> 2];
    d156 = d36 * d36 + d141 * d141 + d153 * d153;
    d157 = d36;
    d158 = d141;
    d159 = d153;
    d160 = +HEAPF32[i53 >> 2];
   }
   if (d156 <= 1.4210854715202004e-14) {
    HEAP32[i55 >> 2] = 9;
    if (i149) {
     d155 = d148;
     break;
    }
    STACKTOP = i5;
    return;
   }
   d153 = 1.0 / +Math_sqrt(+d156);
   d141 = d144 - d142;
   d142 = d146 - d143;
   d143 = d145 - d139;
   d139 = -0.0 - +Math_sqrt(+(d141 * d141 + d142 * d142 + d143 * d143));
   if (d148 > d139 | i54) {
    i125 = i7;
    i39 = i19;
    HEAP32[i125 >> 2] = HEAP32[i39 >> 2];
    HEAP32[i125 + 4 >> 2] = HEAP32[i39 + 4 >> 2];
    HEAP32[i125 + 8 >> 2] = HEAP32[i39 + 8 >> 2];
    HEAP32[i125 + 12 >> 2] = HEAP32[i39 + 12 >> 2];
    i39 = i8;
    i125 = i20;
    HEAP32[i39 >> 2] = HEAP32[i125 >> 2];
    HEAP32[i39 + 4 >> 2] = HEAP32[i125 + 4 >> 2];
    HEAP32[i39 + 8 >> 2] = HEAP32[i125 + 8 >> 2];
    HEAP32[i39 + 12 >> 2] = HEAP32[i125 + 12 >> 2];
    HEAPF32[i23 >> 2] = d157 * d153;
    HEAPF32[i24 >> 2] = d158 * d153;
    HEAPF32[i25 >> 2] = d159 * d153;
    HEAPF32[i26 >> 2] = d160;
    HEAP32[i55 >> 2] = 3;
    d155 = d139;
    break;
   }
   HEAP32[i55 >> 2] = 8;
   if (i149) {
    d155 = d148;
    break;
   }
   STACKTOP = i5;
   return;
  } else {
   i140 = 1356;
  }
 } while (0);
 do {
  if ((i140 | 0) == 1356) {
   if (i149) {
    d155 = d148;
    break;
   }
   STACKTOP = i5;
   return;
  }
 } while (0);
 do {
  if (d155 >= 0.0) {
   if (d155 * d155 < +HEAPF32[i120 >> 2]) {
    break;
   }
   STACKTOP = i5;
   return;
  }
 } while (0);
 HEAP32[i124 >> 2] = HEAP32[i29 >> 2];
 HEAP32[i124 + 4 >> 2] = HEAP32[i29 + 4 >> 2];
 HEAP32[i124 + 8 >> 2] = HEAP32[i29 + 8 >> 2];
 HEAP32[i124 + 12 >> 2] = HEAP32[i29 + 12 >> 2];
 HEAPF32[i22 >> 2] = d155;
 i22 = HEAP32[(HEAP32[i3 >> 2] | 0) + 16 >> 2] | 0;
 d148 = d42 + +HEAPF32[i8 + 4 >> 2];
 d42 = d43 + +HEAPF32[i8 + 8 >> 2];
 HEAPF32[i21 >> 2] = d41 + +HEAPF32[i8 >> 2];
 HEAPF32[i21 + 4 >> 2] = d148;
 HEAPF32[i21 + 8 >> 2] = d42;
 HEAPF32[i21 + 12 >> 2] = 0.0;
 FUNCTION_TABLE_viiif[i22 & 15](i3, i6, i21, d155);
 STACKTOP = i5;
 return;
}
function __ZN16btCollisionWorld15debugDrawObjectERK11btTransformPK16btCollisionShapeRK9btVector3(i1, i2, i3, i4) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 var i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, d61 = 0.0, d62 = 0.0, d63 = 0.0, d64 = 0.0, d65 = 0.0, d66 = 0.0, d67 = 0.0, d68 = 0.0, d69 = 0.0, d70 = 0.0, d71 = 0.0, d72 = 0.0, i73 = 0, d74 = 0.0, d75 = 0.0, d76 = 0.0, d77 = 0.0, d78 = 0.0, d79 = 0.0, d80 = 0.0, d81 = 0.0, d82 = 0.0, d83 = 0.0, d84 = 0.0, d85 = 0.0, d86 = 0.0, i87 = 0, i88 = 0, d89 = 0.0, d90 = 0.0, d91 = 0.0, i92 = 0;
 i5 = STACKTOP;
 STACKTOP = STACKTOP + 576 | 0;
 i6 = i5 | 0;
 i7 = i5 + 64 | 0;
 i8 = i5 + 80 | 0;
 i9 = i5 + 96 | 0;
 i10 = i5 + 160 | 0;
 i11 = i5 + 176 | 0;
 i12 = i5 + 192 | 0;
 i13 = i5 + 208 | 0;
 i14 = i5 + 304 | 0;
 i15 = i5 + 320 | 0;
 i16 = i5 + 336 | 0;
 i17 = i5 + 432 | 0;
 i18 = i5 + 448 | 0;
 i19 = i5 + 464 | 0;
 i20 = i5 + 480 | 0;
 i21 = i5 + 496 | 0;
 i22 = i5 + 512 | 0;
 i23 = i5 + 528 | 0;
 i24 = i5 + 544 | 0;
 i25 = i5 + 560 | 0;
 i26 = i1;
 i27 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i26 >> 2] | 0) + 16 >> 2] & 127](i1) | 0;
 FUNCTION_TABLE_viif[HEAP32[(HEAP32[i27 >> 2] | 0) + 56 >> 2] & 3](i27, i2, 1.0);
 i27 = i3 + 4 | 0;
 i28 = HEAP32[i27 >> 2] | 0;
 switch (i28 | 0) {
 case 31:
  {
   i29 = HEAP32[i3 + 16 >> 2] | 0;
   if ((i29 | 0) <= 0) {
    STACKTOP = i5;
    return;
   }
   i30 = i3 + 24 | 0;
   i31 = i1;
   i32 = i2 | 0;
   i33 = i2 + 4 | 0;
   i34 = i2 + 8 | 0;
   i35 = i2 + 16 | 0;
   i36 = i2 + 20 | 0;
   i37 = i2 + 24 | 0;
   i38 = i2 + 32 | 0;
   i39 = i2 + 36 | 0;
   i40 = i2 + 40 | 0;
   i41 = i2 + 48 | 0;
   i42 = i2 + 52 | 0;
   i43 = i2 + 56 | 0;
   i44 = i6 | 0;
   i45 = i6 + 4 | 0;
   i46 = i6 + 8 | 0;
   i47 = i6 + 12 | 0;
   i48 = i6 + 16 | 0;
   i49 = i6 + 20 | 0;
   i50 = i6 + 24 | 0;
   i51 = i6 + 28 | 0;
   i52 = i6 + 32 | 0;
   i53 = i6 + 36 | 0;
   i54 = i6 + 40 | 0;
   i55 = i6 + 44 | 0;
   i56 = i6 + 48 | 0;
   i57 = i6 + 52 | 0;
   i58 = i6 + 56 | 0;
   i59 = i6 + 60 | 0;
   i60 = i29;
   do {
    i60 = i60 - 1 | 0;
    i29 = HEAP32[i30 >> 2] | 0;
    d61 = +HEAPF32[i29 + (i60 * 80 | 0) >> 2];
    d62 = +HEAPF32[i29 + (i60 * 80 | 0) + 4 >> 2];
    d63 = +HEAPF32[i29 + (i60 * 80 | 0) + 8 >> 2];
    d64 = +HEAPF32[i29 + (i60 * 80 | 0) + 16 >> 2];
    d65 = +HEAPF32[i29 + (i60 * 80 | 0) + 20 >> 2];
    d66 = +HEAPF32[i29 + (i60 * 80 | 0) + 24 >> 2];
    d67 = +HEAPF32[i29 + (i60 * 80 | 0) + 32 >> 2];
    d68 = +HEAPF32[i29 + (i60 * 80 | 0) + 36 >> 2];
    d69 = +HEAPF32[i29 + (i60 * 80 | 0) + 40 >> 2];
    d70 = +HEAPF32[i29 + (i60 * 80 | 0) + 48 >> 2];
    d71 = +HEAPF32[i29 + (i60 * 80 | 0) + 52 >> 2];
    d72 = +HEAPF32[i29 + (i60 * 80 | 0) + 56 >> 2];
    i73 = HEAP32[i29 + (i60 * 80 | 0) + 64 >> 2] | 0;
    i29 = HEAP32[(HEAP32[i31 >> 2] | 0) + 24 >> 2] | 0;
    d74 = +HEAPF32[i32 >> 2];
    d75 = +HEAPF32[i33 >> 2];
    d76 = +HEAPF32[i34 >> 2];
    d77 = +HEAPF32[i35 >> 2];
    d78 = +HEAPF32[i36 >> 2];
    d79 = +HEAPF32[i37 >> 2];
    d80 = +HEAPF32[i38 >> 2];
    d81 = +HEAPF32[i39 >> 2];
    d82 = +HEAPF32[i40 >> 2];
    d83 = d70 * d74 + d71 * d75 + d72 * d76 + +HEAPF32[i41 >> 2];
    d84 = d70 * d77 + d71 * d78 + d72 * d79 + +HEAPF32[i42 >> 2];
    d85 = d70 * d80 + d71 * d81 + d72 * d82 + +HEAPF32[i43 >> 2];
    HEAPF32[i44 >> 2] = d61 * d74 + d64 * d75 + d67 * d76;
    HEAPF32[i45 >> 2] = d62 * d74 + d65 * d75 + d68 * d76;
    HEAPF32[i46 >> 2] = d63 * d74 + d66 * d75 + d69 * d76;
    HEAPF32[i47 >> 2] = 0.0;
    HEAPF32[i48 >> 2] = d61 * d77 + d64 * d78 + d67 * d79;
    HEAPF32[i49 >> 2] = d62 * d77 + d65 * d78 + d68 * d79;
    HEAPF32[i50 >> 2] = d63 * d77 + d66 * d78 + d69 * d79;
    HEAPF32[i51 >> 2] = 0.0;
    HEAPF32[i52 >> 2] = d61 * d80 + d64 * d81 + d67 * d82;
    HEAPF32[i53 >> 2] = d62 * d80 + d65 * d81 + d68 * d82;
    HEAPF32[i54 >> 2] = d63 * d80 + d66 * d81 + d69 * d82;
    HEAPF32[i55 >> 2] = 0.0;
    HEAPF32[i56 >> 2] = d83;
    HEAPF32[i57 >> 2] = d84;
    HEAPF32[i58 >> 2] = d85;
    HEAPF32[i59 >> 2] = 0.0;
    FUNCTION_TABLE_viiii[i29 & 127](i1, i6, i73, i4);
   } while ((i60 | 0) > 0);
   STACKTOP = i5;
   return;
  }
 case 0:
  {
   i60 = i7;
   i6 = i3 + 28 | 0;
   HEAP32[i60 >> 2] = HEAP32[i6 >> 2];
   HEAP32[i60 + 4 >> 2] = HEAP32[i6 + 4 >> 2];
   HEAP32[i60 + 8 >> 2] = HEAP32[i6 + 8 >> 2];
   HEAP32[i60 + 12 >> 2] = HEAP32[i6 + 12 >> 2];
   i6 = i3;
   i60 = i3;
   d85 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i60 >> 2] | 0) + 44 >> 2] & 7](i6);
   d84 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i60 >> 2] | 0) + 44 >> 2] & 7](i6);
   d83 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i60 >> 2] | 0) + 44 >> 2] & 7](i6);
   i6 = i7 | 0;
   d82 = d85 + +HEAPF32[i6 >> 2];
   HEAPF32[i6 >> 2] = d82;
   i6 = i7 + 4 | 0;
   d85 = d84 + +HEAPF32[i6 >> 2];
   HEAPF32[i6 >> 2] = d85;
   i6 = i7 + 8 | 0;
   d84 = d83 + +HEAPF32[i6 >> 2];
   HEAPF32[i6 >> 2] = d84;
   i6 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i26 >> 2] | 0) + 16 >> 2] & 127](i1) | 0;
   i60 = HEAP32[(HEAP32[i6 >> 2] | 0) + 72 >> 2] | 0;
   HEAPF32[i8 >> 2] = -0.0 - d82;
   HEAPF32[i8 + 4 >> 2] = -0.0 - d85;
   HEAPF32[i8 + 8 >> 2] = -0.0 - d84;
   HEAPF32[i8 + 12 >> 2] = 0.0;
   FUNCTION_TABLE_viiiii[i60 & 63](i6, i8, i7, i2, i4);
   STACKTOP = i5;
   return;
  }
 case 8:
  {
   d84 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i3 >> 2] | 0) + 44 >> 2] & 7](i3);
   i7 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i26 >> 2] | 0) + 16 >> 2] & 127](i1) | 0;
   FUNCTION_TABLE_vifii[HEAP32[(HEAP32[i7 >> 2] | 0) + 16 >> 2] & 1](i7, d84, i2, i4);
   STACKTOP = i5;
   return;
  }
 case 9:
  {
   i7 = HEAP32[i3 + 92 >> 2] | 0;
   if ((i7 | 0) <= 0) {
    STACKTOP = i5;
    return;
   }
   i8 = i3 + 100 | 0;
   i6 = i3 + 120 | 0;
   i60 = i2 | 0;
   i59 = i2 + 4 | 0;
   i58 = i2 + 8 | 0;
   i57 = i2 + 16 | 0;
   i56 = i2 + 20 | 0;
   i55 = i2 + 24 | 0;
   i54 = i2 + 32 | 0;
   i53 = i2 + 36 | 0;
   i52 = i2 + 40 | 0;
   i51 = i2 + 48 | 0;
   i50 = i2 + 52 | 0;
   i49 = i2 + 56 | 0;
   i48 = i9 | 0;
   i47 = i9 + 4 | 0;
   i46 = i9 + 8 | 0;
   i45 = i9 + 12 | 0;
   i44 = i9 + 16 | 0;
   i43 = i9 + 20 | 0;
   i42 = i9 + 24 | 0;
   i41 = i9 + 28 | 0;
   i40 = i9 + 32 | 0;
   i39 = i9 + 36 | 0;
   i38 = i9 + 40 | 0;
   i37 = i9 + 44 | 0;
   i36 = i9 + 48 | 0;
   i35 = i9 + 52 | 0;
   i34 = i9 + 56 | 0;
   i33 = i9 + 60 | 0;
   i32 = i7;
   do {
    i32 = i32 - 1 | 0;
    i7 = HEAP32[i8 >> 2] | 0;
    d84 = +HEAPF32[i7 + (i32 << 4) >> 2];
    d85 = +HEAPF32[i7 + (i32 << 4) + 4 >> 2];
    d82 = +HEAPF32[i7 + (i32 << 4) + 8 >> 2];
    i7 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i26 >> 2] | 0) + 16 >> 2] & 127](i1) | 0;
    i31 = HEAP32[(HEAP32[i7 >> 2] | 0) + 16 >> 2] | 0;
    d83 = +HEAPF32[(HEAP32[i6 >> 2] | 0) + (i32 << 2) >> 2];
    d69 = +HEAPF32[i60 >> 2];
    d81 = +HEAPF32[i59 >> 2];
    d66 = d81 * 0.0;
    d80 = +HEAPF32[i58 >> 2];
    d63 = d80 * 0.0;
    d68 = d69 * 0.0;
    d65 = +HEAPF32[i57 >> 2];
    d62 = +HEAPF32[i56 >> 2];
    d67 = d62 * 0.0;
    d64 = +HEAPF32[i55 >> 2];
    d61 = d64 * 0.0;
    d79 = d65 * 0.0;
    d78 = +HEAPF32[i54 >> 2];
    d77 = +HEAPF32[i53 >> 2];
    d76 = d77 * 0.0;
    d75 = +HEAPF32[i52 >> 2];
    d74 = d75 * 0.0;
    d72 = d78 * 0.0;
    d71 = d84 * d69 + d85 * d81 + d82 * d80 + +HEAPF32[i51 >> 2];
    d70 = d84 * d65 + d85 * d62 + d82 * d64 + +HEAPF32[i50 >> 2];
    d86 = d84 * d78 + d85 * d77 + d82 * d75 + +HEAPF32[i49 >> 2];
    HEAPF32[i48 >> 2] = d69 + d66 + d63;
    HEAPF32[i47 >> 2] = d68 + d81 + d63;
    HEAPF32[i46 >> 2] = d80 + (d68 + d66);
    HEAPF32[i45 >> 2] = 0.0;
    HEAPF32[i44 >> 2] = d65 + d67 + d61;
    HEAPF32[i43 >> 2] = d79 + d62 + d61;
    HEAPF32[i42 >> 2] = d64 + (d79 + d67);
    HEAPF32[i41 >> 2] = 0.0;
    HEAPF32[i40 >> 2] = d78 + d76 + d74;
    HEAPF32[i39 >> 2] = d72 + d77 + d74;
    HEAPF32[i38 >> 2] = d75 + (d72 + d76);
    HEAPF32[i37 >> 2] = 0.0;
    HEAPF32[i36 >> 2] = d71;
    HEAPF32[i35 >> 2] = d70;
    HEAPF32[i34 >> 2] = d86;
    HEAPF32[i33 >> 2] = 0.0;
    FUNCTION_TABLE_vifii[i31 & 1](i7, d83, i9, i4);
   } while ((i32 | 0) > 0);
   STACKTOP = i5;
   return;
  }
 case 11:
  {
   d83 = +HEAPF32[i3 + 56 >> 2];
   d86 = +HEAPF32[i3 + 60 >> 2];
   i32 = HEAP32[i3 + 68 >> 2] | 0;
   i9 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i26 >> 2] | 0) + 16 >> 2] & 127](i1) | 0;
   FUNCTION_TABLE_viffiii[HEAP32[(HEAP32[i9 >> 2] | 0) + 84 >> 2] & 1](i9, d83, d86, i32, i2, i4);
   STACKTOP = i5;
   return;
  }
 case 10:
  {
   i32 = i3;
   i9 = HEAP32[i3 + 52 >> 2] | 0;
   d86 = +HEAPF32[i32 + 28 + (((i9 + 2 | 0) % 3 | 0) << 2) >> 2];
   d83 = +HEAPF32[i32 + 28 + (i9 << 2) >> 2];
   i32 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i26 >> 2] | 0) + 16 >> 2] & 127](i1) | 0;
   FUNCTION_TABLE_viffiii[HEAP32[(HEAP32[i32 >> 2] | 0) + 76 >> 2] & 1](i32, d86, d83, i9, i2, i4);
   STACKTOP = i5;
   return;
  }
 case 13:
  {
   i9 = HEAP32[i3 + 52 >> 2] | 0;
   d83 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i3 >> 2] | 0) + 84 >> 2] & 7](i3);
   i32 = i10;
   i33 = i3 + 28 | 0;
   HEAP32[i32 >> 2] = HEAP32[i33 >> 2];
   HEAP32[i32 + 4 >> 2] = HEAP32[i33 + 4 >> 2];
   HEAP32[i32 + 8 >> 2] = HEAP32[i33 + 8 >> 2];
   HEAP32[i32 + 12 >> 2] = HEAP32[i33 + 12 >> 2];
   i33 = i3;
   i32 = i3;
   d86 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i32 >> 2] | 0) + 44 >> 2] & 7](i33);
   d70 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i32 >> 2] | 0) + 44 >> 2] & 7](i33);
   d71 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i32 >> 2] | 0) + 44 >> 2] & 7](i33);
   i33 = i10 | 0;
   HEAPF32[i33 >> 2] = d86 + +HEAPF32[i33 >> 2];
   i33 = i10 + 4 | 0;
   HEAPF32[i33 >> 2] = d70 + +HEAPF32[i33 >> 2];
   i33 = i10 + 8 | 0;
   HEAPF32[i33 >> 2] = d71 + +HEAPF32[i33 >> 2];
   d71 = +HEAPF32[i10 + (i9 << 2) >> 2];
   i10 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i26 >> 2] | 0) + 16 >> 2] & 127](i1) | 0;
   FUNCTION_TABLE_viffiii[HEAP32[(HEAP32[i10 >> 2] | 0) + 80 >> 2] & 1](i10, d83, d71, i9, i2, i4);
   STACKTOP = i5;
   return;
  }
 case 28:
  {
   d71 = +HEAPF32[i3 + 64 >> 2];
   i9 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i26 >> 2] | 0) + 16 >> 2] & 127](i1) | 0;
   FUNCTION_TABLE_viifii[HEAP32[(HEAP32[i9 >> 2] | 0) + 88 >> 2] & 1](i9, i3 + 48 | 0, d71, i2, i4);
   STACKTOP = i5;
   return;
  }
 default:
  {
   if ((i28 - 21 | 0) >>> 0 < 9) {
    HEAPF32[i11 >> 2] = 999999984306749400.0;
    HEAPF32[i11 + 4 >> 2] = 999999984306749400.0;
    HEAPF32[i11 + 8 >> 2] = 999999984306749400.0;
    HEAPF32[i11 + 12 >> 2] = 0.0;
    HEAPF32[i12 >> 2] = -999999984306749400.0;
    HEAPF32[i12 + 4 >> 2] = -999999984306749400.0;
    HEAPF32[i12 + 8 >> 2] = -999999984306749400.0;
    HEAPF32[i12 + 12 >> 2] = 0.0;
    i9 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i26 >> 2] | 0) + 16 >> 2] & 127](i1) | 0;
    HEAP32[i13 >> 2] = 4216;
    HEAP32[i13 + 4 >> 2] = 4240;
    HEAP32[i13 + 8 >> 2] = i9;
    i9 = i13 + 12 | 0;
    i10 = i4;
    HEAP32[i9 >> 2] = HEAP32[i10 >> 2];
    HEAP32[i9 + 4 >> 2] = HEAP32[i10 + 4 >> 2];
    HEAP32[i9 + 8 >> 2] = HEAP32[i10 + 8 >> 2];
    HEAP32[i9 + 12 >> 2] = HEAP32[i10 + 12 >> 2];
    i10 = i13 + 28 | 0;
    i9 = i2;
    HEAP32[i10 >> 2] = HEAP32[i9 >> 2];
    HEAP32[i10 + 4 >> 2] = HEAP32[i9 + 4 >> 2];
    HEAP32[i10 + 8 >> 2] = HEAP32[i9 + 8 >> 2];
    HEAP32[i10 + 12 >> 2] = HEAP32[i9 + 12 >> 2];
    i9 = i13 + 44 | 0;
    i10 = i2 + 16 | 0;
    HEAP32[i9 >> 2] = HEAP32[i10 >> 2];
    HEAP32[i9 + 4 >> 2] = HEAP32[i10 + 4 >> 2];
    HEAP32[i9 + 8 >> 2] = HEAP32[i10 + 8 >> 2];
    HEAP32[i9 + 12 >> 2] = HEAP32[i10 + 12 >> 2];
    i10 = i13 + 60 | 0;
    i9 = i2 + 32 | 0;
    HEAP32[i10 >> 2] = HEAP32[i9 >> 2];
    HEAP32[i10 + 4 >> 2] = HEAP32[i9 + 4 >> 2];
    HEAP32[i10 + 8 >> 2] = HEAP32[i9 + 8 >> 2];
    HEAP32[i10 + 12 >> 2] = HEAP32[i9 + 12 >> 2];
    i9 = i13 + 76 | 0;
    i10 = i2 + 48 | 0;
    HEAP32[i9 >> 2] = HEAP32[i10 >> 2];
    HEAP32[i9 + 4 >> 2] = HEAP32[i10 + 4 >> 2];
    HEAP32[i9 + 8 >> 2] = HEAP32[i10 + 8 >> 2];
    HEAP32[i9 + 12 >> 2] = HEAP32[i10 + 12 >> 2];
    i10 = i13 | 0;
    FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i3 >> 2] | 0) + 60 >> 2] & 127](i3, i10, i12, i11);
    __ZN31btInternalTriangleIndexCallbackD2Ev(i13 + 4 | 0);
    __ZN18btTriangleCallbackD2Ev(i10);
    i87 = HEAP32[i27 >> 2] | 0;
   } else {
    i87 = i28;
   }
   if ((i87 | 0) == 3) {
    HEAPF32[i14 >> 2] = 999999984306749400.0;
    HEAPF32[i14 + 4 >> 2] = 999999984306749400.0;
    HEAPF32[i14 + 8 >> 2] = 999999984306749400.0;
    HEAPF32[i14 + 12 >> 2] = 0.0;
    HEAPF32[i15 >> 2] = -999999984306749400.0;
    HEAPF32[i15 + 4 >> 2] = -999999984306749400.0;
    HEAPF32[i15 + 8 >> 2] = -999999984306749400.0;
    HEAPF32[i15 + 12 >> 2] = 0.0;
    i28 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i26 >> 2] | 0) + 16 >> 2] & 127](i1) | 0;
    HEAP32[i16 >> 2] = 4216;
    HEAP32[i16 + 4 >> 2] = 4240;
    HEAP32[i16 + 8 >> 2] = i28;
    i28 = i16 + 12 | 0;
    i10 = i4;
    HEAP32[i28 >> 2] = HEAP32[i10 >> 2];
    HEAP32[i28 + 4 >> 2] = HEAP32[i10 + 4 >> 2];
    HEAP32[i28 + 8 >> 2] = HEAP32[i10 + 8 >> 2];
    HEAP32[i28 + 12 >> 2] = HEAP32[i10 + 12 >> 2];
    i10 = i16 + 28 | 0;
    i28 = i2;
    HEAP32[i10 >> 2] = HEAP32[i28 >> 2];
    HEAP32[i10 + 4 >> 2] = HEAP32[i28 + 4 >> 2];
    HEAP32[i10 + 8 >> 2] = HEAP32[i28 + 8 >> 2];
    HEAP32[i10 + 12 >> 2] = HEAP32[i28 + 12 >> 2];
    i28 = i16 + 44 | 0;
    i10 = i2 + 16 | 0;
    HEAP32[i28 >> 2] = HEAP32[i10 >> 2];
    HEAP32[i28 + 4 >> 2] = HEAP32[i10 + 4 >> 2];
    HEAP32[i28 + 8 >> 2] = HEAP32[i10 + 8 >> 2];
    HEAP32[i28 + 12 >> 2] = HEAP32[i10 + 12 >> 2];
    i10 = i16 + 60 | 0;
    i28 = i2 + 32 | 0;
    HEAP32[i10 >> 2] = HEAP32[i28 >> 2];
    HEAP32[i10 + 4 >> 2] = HEAP32[i28 + 4 >> 2];
    HEAP32[i10 + 8 >> 2] = HEAP32[i28 + 8 >> 2];
    HEAP32[i10 + 12 >> 2] = HEAP32[i28 + 12 >> 2];
    i28 = i16 + 76 | 0;
    i10 = i2 + 48 | 0;
    HEAP32[i28 >> 2] = HEAP32[i10 >> 2];
    HEAP32[i28 + 4 >> 2] = HEAP32[i10 + 4 >> 2];
    HEAP32[i28 + 8 >> 2] = HEAP32[i10 + 8 >> 2];
    HEAP32[i28 + 12 >> 2] = HEAP32[i10 + 12 >> 2];
    i10 = HEAP32[i3 + 92 >> 2] | 0;
    i28 = i16 + 4 | 0;
    FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i10 >> 2] | 0) + 8 >> 2] & 127](i10, i28, i15, i14);
    __ZN31btInternalTriangleIndexCallbackD2Ev(i28);
    __ZN18btTriangleCallbackD2Ev(i16 | 0);
    i88 = HEAP32[i27 >> 2] | 0;
   } else {
    i88 = i87;
   }
   if ((i88 | 0) >= 7) {
    STACKTOP = i5;
    return;
   }
   i88 = i3;
   i87 = HEAP32[i3 + 52 >> 2] | 0;
   if ((i87 | 0) == 0) {
    i27 = i3;
    if ((FUNCTION_TABLE_ii[HEAP32[(HEAP32[i27 >> 2] | 0) + 92 >> 2] & 127](i88) | 0) <= 0) {
     STACKTOP = i5;
     return;
    }
    i16 = i3;
    i3 = i2 | 0;
    i28 = i22 | 0;
    i14 = i2 + 4 | 0;
    i15 = i22 + 4 | 0;
    i10 = i2 + 8 | 0;
    i13 = i22 + 8 | 0;
    i11 = i2 + 48 | 0;
    i12 = i2 + 16 | 0;
    i9 = i2 + 20 | 0;
    i33 = i2 + 24 | 0;
    i32 = i2 + 52 | 0;
    i34 = i2 + 32 | 0;
    i35 = i2 + 36 | 0;
    i36 = i2 + 40 | 0;
    i37 = i2 + 56 | 0;
    i38 = i24 | 0;
    i39 = i24 + 4 | 0;
    i40 = i24 + 8 | 0;
    i41 = i24 + 12 | 0;
    i42 = i23 | 0;
    i43 = i23 + 4 | 0;
    i44 = i23 + 8 | 0;
    i45 = i25 | 0;
    i46 = i25 + 4 | 0;
    i47 = i25 + 8 | 0;
    i48 = i25 + 12 | 0;
    i49 = 0;
    do {
     FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i16 >> 2] | 0) + 96 >> 2] & 127](i88, i49, i22, i23);
     d71 = +HEAPF32[i3 >> 2];
     d83 = +HEAPF32[i28 >> 2];
     d70 = +HEAPF32[i14 >> 2];
     d86 = +HEAPF32[i15 >> 2];
     d76 = +HEAPF32[i10 >> 2];
     d72 = +HEAPF32[i13 >> 2];
     d75 = +HEAPF32[i11 >> 2];
     d74 = +HEAPF32[i12 >> 2];
     d77 = +HEAPF32[i9 >> 2];
     d78 = +HEAPF32[i33 >> 2];
     d67 = +HEAPF32[i32 >> 2];
     d79 = +HEAPF32[i34 >> 2];
     d64 = +HEAPF32[i35 >> 2];
     d61 = +HEAPF32[i36 >> 2];
     d62 = +HEAPF32[i37 >> 2];
     HEAPF32[i38 >> 2] = d75 + (d71 * d83 + d70 * d86 + d76 * d72);
     HEAPF32[i39 >> 2] = d67 + (d83 * d74 + d86 * d77 + d72 * d78);
     HEAPF32[i40 >> 2] = d62 + (d83 * d79 + d86 * d64 + d72 * d61);
     HEAPF32[i41 >> 2] = 0.0;
     d72 = +HEAPF32[i42 >> 2];
     d86 = +HEAPF32[i43 >> 2];
     d83 = +HEAPF32[i44 >> 2];
     HEAPF32[i45 >> 2] = d75 + (d71 * d72 + d70 * d86 + d76 * d83);
     HEAPF32[i46 >> 2] = d67 + (d74 * d72 + d77 * d86 + d78 * d83);
     HEAPF32[i47 >> 2] = d62 + (d79 * d72 + d64 * d86 + d61 * d83);
     HEAPF32[i48 >> 2] = 0.0;
     i50 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i26 >> 2] | 0) + 16 >> 2] & 127](i1) | 0;
     FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i50 >> 2] | 0) + 8 >> 2] & 127](i50, i24, i25, i4);
     i49 = i49 + 1 | 0;
    } while ((i49 | 0) < (FUNCTION_TABLE_ii[HEAP32[(HEAP32[i27 >> 2] | 0) + 92 >> 2] & 127](i88) | 0));
    STACKTOP = i5;
    return;
   }
   i88 = i87 + 28 | 0;
   if ((HEAP32[i88 >> 2] | 0) <= 0) {
    STACKTOP = i5;
    return;
   }
   i27 = i87 + 36 | 0;
   i49 = i19 | 0;
   i25 = i19 + 4 | 0;
   i24 = i19 + 8 | 0;
   i48 = i19 + 12 | 0;
   i47 = i2 | 0;
   i46 = i2 + 4 | 0;
   i45 = i2 + 8 | 0;
   i44 = i2 + 48 | 0;
   i43 = i2 + 16 | 0;
   i42 = i2 + 20 | 0;
   i41 = i2 + 24 | 0;
   i40 = i2 + 52 | 0;
   i39 = i2 + 32 | 0;
   i38 = i2 + 36 | 0;
   i37 = i2 + 40 | 0;
   i36 = i2 + 56 | 0;
   i2 = i20 | 0;
   i35 = i20 + 4 | 0;
   i34 = i20 + 8 | 0;
   i32 = i20 + 12 | 0;
   i33 = i21 | 0;
   i9 = i21 + 4 | 0;
   i12 = i21 + 8 | 0;
   i11 = i21 + 12 | 0;
   i13 = i87 + 16 | 0;
   i87 = i17 | 0;
   i10 = i17 + 4 | 0;
   i15 = i17 + 8 | 0;
   i14 = i17 + 12 | 0;
   i28 = i18 | 0;
   i3 = i18 + 4 | 0;
   i23 = i18 + 8 | 0;
   i22 = i18 + 12 | 0;
   i16 = 0;
   do {
    i50 = HEAP32[i27 >> 2] | 0;
    i51 = HEAP32[i50 + (i16 * 56 | 0) + 4 >> 2] | 0;
    L252 : do {
     if ((i51 | 0) > 0) {
      i52 = HEAP32[i50 + (i16 * 56 | 0) + 12 >> 2] | 0;
      d83 = 0.0;
      d61 = 0.0;
      d86 = 0.0;
      i53 = HEAP32[i52 + (i51 - 1 << 2) >> 2] | 0;
      i54 = 0;
      i55 = i52;
      while (1) {
       i52 = HEAP32[i55 + (i54 << 2) >> 2] | 0;
       i56 = HEAP32[i13 >> 2] | 0;
       d64 = d86 + +HEAPF32[i56 + (i52 << 4) >> 2];
       d72 = d61 + +HEAPF32[i56 + (i52 << 4) + 4 >> 2];
       d79 = d83 + +HEAPF32[i56 + (i52 << 4) + 8 >> 2];
       i56 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i26 >> 2] | 0) + 16 >> 2] & 127](i1) | 0;
       i57 = HEAP32[(HEAP32[i56 >> 2] | 0) + 8 >> 2] | 0;
       i58 = HEAP32[i13 >> 2] | 0;
       d62 = +HEAPF32[i47 >> 2];
       d78 = +HEAPF32[i58 + (i53 << 4) >> 2];
       d77 = +HEAPF32[i46 >> 2];
       d74 = +HEAPF32[i58 + (i53 << 4) + 4 >> 2];
       d67 = +HEAPF32[i45 >> 2];
       d76 = +HEAPF32[i58 + (i53 << 4) + 8 >> 2];
       d70 = +HEAPF32[i44 >> 2];
       d71 = +HEAPF32[i43 >> 2];
       d75 = +HEAPF32[i42 >> 2];
       d65 = +HEAPF32[i41 >> 2];
       d66 = +HEAPF32[i40 >> 2];
       d68 = +HEAPF32[i39 >> 2];
       d80 = +HEAPF32[i38 >> 2];
       d63 = +HEAPF32[i37 >> 2];
       d81 = +HEAPF32[i36 >> 2];
       HEAPF32[i87 >> 2] = d70 + (d62 * d78 + d77 * d74 + d67 * d76);
       HEAPF32[i10 >> 2] = d66 + (d78 * d71 + d74 * d75 + d76 * d65);
       HEAPF32[i15 >> 2] = d81 + (d78 * d68 + d74 * d80 + d76 * d63);
       HEAPF32[i14 >> 2] = 0.0;
       d76 = +HEAPF32[i58 + (i52 << 4) >> 2];
       d74 = +HEAPF32[i58 + (i52 << 4) + 4 >> 2];
       d78 = +HEAPF32[i58 + (i52 << 4) + 8 >> 2];
       HEAPF32[i28 >> 2] = d70 + (d62 * d76 + d77 * d74 + d67 * d78);
       HEAPF32[i3 >> 2] = d66 + (d71 * d76 + d75 * d74 + d65 * d78);
       HEAPF32[i23 >> 2] = d81 + (d68 * d76 + d80 * d74 + d63 * d78);
       HEAPF32[i22 >> 2] = 0.0;
       FUNCTION_TABLE_viiii[i57 & 127](i56, i17, i18, i4);
       i56 = i54 + 1 | 0;
       i57 = HEAP32[i27 >> 2] | 0;
       if ((i56 | 0) >= (HEAP32[i57 + (i16 * 56 | 0) + 4 >> 2] | 0)) {
        d89 = d64;
        d90 = d72;
        d91 = d79;
        i92 = i57;
        break L252;
       }
       d83 = d79;
       d61 = d72;
       d86 = d64;
       i53 = i52;
       i54 = i56;
       i55 = HEAP32[i57 + (i16 * 56 | 0) + 12 >> 2] | 0;
      }
     } else {
      d89 = 0.0;
      d90 = 0.0;
      d91 = 0.0;
      i92 = i50;
     }
    } while (0);
    d86 = 1.0 / +(i51 | 0);
    d61 = d89 * d86;
    d83 = d90 * d86;
    d64 = d91 * d86;
    HEAPF32[i49 >> 2] = 1.0;
    HEAPF32[i25 >> 2] = 1.0;
    HEAPF32[i24 >> 2] = 0.0;
    HEAPF32[i48 >> 2] = 0.0;
    d86 = +HEAPF32[i92 + (i16 * 56 | 0) + 40 >> 2];
    d72 = +HEAPF32[i92 + (i16 * 56 | 0) + 44 >> 2];
    d79 = +HEAPF32[i92 + (i16 * 56 | 0) + 48 >> 2];
    i50 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i26 >> 2] | 0) + 16 >> 2] & 127](i1) | 0;
    i55 = HEAP32[(HEAP32[i50 >> 2] | 0) + 8 >> 2] | 0;
    d78 = +HEAPF32[i47 >> 2];
    d63 = +HEAPF32[i46 >> 2];
    d74 = +HEAPF32[i45 >> 2];
    d80 = +HEAPF32[i44 >> 2];
    d76 = +HEAPF32[i43 >> 2];
    d68 = +HEAPF32[i42 >> 2];
    d81 = +HEAPF32[i41 >> 2];
    d65 = +HEAPF32[i40 >> 2];
    d75 = +HEAPF32[i39 >> 2];
    d71 = +HEAPF32[i38 >> 2];
    d66 = +HEAPF32[i37 >> 2];
    d67 = +HEAPF32[i36 >> 2];
    HEAPF32[i2 >> 2] = d80 + (d61 * d78 + d83 * d63 + d64 * d74);
    HEAPF32[i35 >> 2] = d65 + (d61 * d76 + d83 * d68 + d64 * d81);
    HEAPF32[i34 >> 2] = d67 + (d61 * d75 + d83 * d71 + d64 * d66);
    HEAPF32[i32 >> 2] = 0.0;
    d77 = d61 + d86;
    d86 = d83 + d72;
    d72 = d64 + d79;
    HEAPF32[i33 >> 2] = d80 + (d77 * d78 + d86 * d63 + d72 * d74);
    HEAPF32[i9 >> 2] = d65 + (d77 * d76 + d86 * d68 + d72 * d81);
    HEAPF32[i12 >> 2] = d67 + (d77 * d75 + d86 * d71 + d72 * d66);
    HEAPF32[i11 >> 2] = 0.0;
    FUNCTION_TABLE_viiii[i55 & 127](i50, i20, i21, i19);
    i16 = i16 + 1 | 0;
   } while ((i16 | 0) < (HEAP32[i88 >> 2] | 0));
   STACKTOP = i5;
   return;
  }
 }
}
function __ZN20btConvexHullInternal6shrinkEff(i1, d2, d3) {
 i1 = i1 | 0;
 d2 = +d2;
 d3 = +d3;
 var i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, d15 = 0.0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0, i62 = 0, i63 = 0, i64 = 0, i65 = 0, i66 = 0, i67 = 0, i68 = 0, i69 = 0, i70 = 0, i71 = 0, i72 = 0, i73 = 0, i74 = 0, i75 = 0, i76 = 0, i77 = 0, i78 = 0, i79 = 0, i80 = 0, i81 = 0, i82 = 0, i83 = 0, i84 = 0, i85 = 0, i86 = 0, i87 = 0, i88 = 0, i89 = 0, i90 = 0, i91 = 0, i92 = 0, i93 = 0, i94 = 0, i95 = 0, i96 = 0, i97 = 0, i98 = 0, i99 = 0, i100 = 0, i101 = 0, i102 = 0, i103 = 0, i104 = 0, i105 = 0, i106 = 0, i107 = 0, i108 = 0, i109 = 0, i110 = 0, i111 = 0, i112 = 0, i113 = 0, i114 = 0, i115 = 0, i116 = 0, i117 = 0, i118 = 0, i119 = 0, i120 = 0, i121 = 0, i122 = 0, i123 = 0, i124 = 0, i125 = 0, i126 = 0, i127 = 0, i128 = 0, i129 = 0, i130 = 0, i131 = 0, i132 = 0, i133 = 0, i134 = 0, i135 = 0, i136 = 0, i137 = 0, i138 = 0, i139 = 0, i140 = 0, i141 = 0, i142 = 0, i143 = 0, i144 = 0, i145 = 0, i146 = 0, i147 = 0, i148 = 0, i149 = 0, i150 = 0, i151 = 0, i152 = 0, i153 = 0, i154 = 0, i155 = 0, i156 = 0, i157 = 0, i158 = 0, i159 = 0, i160 = 0, i161 = 0, i162 = 0, i163 = 0, i164 = 0, i165 = 0, i166 = 0, i167 = 0, i168 = 0, i169 = 0, i170 = 0, i171 = 0, i172 = 0, d173 = 0.0, d174 = 0.0, d175 = 0.0, d176 = 0.0, d177 = 0.0, d178 = 0.0, d179 = 0.0, d180 = 0.0;
 i4 = STACKTOP;
 STACKTOP = STACKTOP + 136 | 0;
 i5 = i4 | 0;
 i6 = i4 + 16 | 0;
 i7 = i4 + 32 | 0;
 i8 = i4 + 48 | 0;
 i9 = i4 + 64 | 0;
 i10 = i4 + 80 | 0;
 i11 = i4 + 96 | 0;
 i12 = i4 + 112 | 0;
 i13 = i1 + 124 | 0;
 i14 = HEAP32[i13 >> 2] | 0;
 if ((i14 | 0) == 0) {
  d15 = 0.0;
  STACKTOP = i4;
  return +d15;
 }
 i16 = i1 + 100 | 0;
 i17 = (HEAP32[i16 >> 2] | 0) - 1 | 0;
 HEAP32[i16 >> 2] = i17;
 HEAP32[i14 + 104 >> 2] = i17;
 i14 = __Z22btAlignedAllocInternalji(4, 16) | 0;
 i16 = i14;
 if ((i14 | 0) != 0) {
  HEAP32[i16 >> 2] = HEAP32[i13 >> 2];
 }
 i14 = HEAP32[i13 >> 2] | 0;
 i13 = HEAP32[i14 + 88 >> 2] | 0;
 i18 = HEAP32[i14 + 92 >> 2] | 0;
 i19 = HEAP32[i14 + 96 >> 2] | 0;
 i14 = i6 | 0;
 i20 = i6 + 8 | 0;
 i21 = i7 | 0;
 _memset(i6 | 0, 0, 16);
 i22 = i7 + 8 | 0;
 i23 = i8 | 0;
 _memset(i7 | 0, 0, 16);
 i24 = i8 + 8 | 0;
 i25 = i9 | 0;
 _memset(i8 | 0, 0, 16);
 i26 = i9 + 8 | 0;
 i27 = i1 + 64 | 0;
 _memset(i9 | 0, 0, 16);
 i28 = 0;
 i29 = 0;
 i30 = 0;
 i31 = 1;
 i32 = 1;
 i33 = i16;
 i16 = 0;
 i34 = 0;
 i35 = 0;
 i36 = 0;
 i37 = 0;
 i38 = 0;
 i39 = 0;
 i40 = 0;
 i41 = 0;
 i42 = 0;
 i43 = 0;
 i44 = 0;
 i45 = 0;
 i46 = 0;
 i47 = 0;
 i48 = 0;
 L1498 : while (1) {
  i49 = i31;
  while (1) {
   if ((i49 | 0) <= 0) {
    break L1498;
   }
   i50 = i49 - 1 | 0;
   i51 = HEAP32[i33 + (i50 << 2) >> 2] | 0;
   i52 = i51 + 8 | 0;
   i53 = HEAP32[i52 >> 2] | 0;
   if ((i53 | 0) == 0) {
    i49 = i50;
   } else {
    break;
   }
  }
  i54 = i51 + 88 | 0;
  i55 = i51 + 92 | 0;
  i56 = i51 + 96 | 0;
  i57 = i53;
  i58 = i28;
  i59 = i29;
  i60 = i30;
  i61 = i50;
  i62 = i32;
  i63 = i33;
  i64 = i16;
  i65 = i34;
  i66 = i35;
  i67 = i36;
  i68 = i37;
  i69 = i38;
  i70 = i39;
  i71 = i40;
  i72 = i41;
  i73 = i42;
  i74 = i43;
  i75 = i44;
  i76 = i45;
  i77 = i46;
  i78 = i47;
  i79 = i48;
  while (1) {
   i80 = i57 + 12 | 0;
   i81 = (HEAP32[i80 >> 2] | 0) + 104 | 0;
   if ((HEAP32[i81 >> 2] | 0) == (i17 | 0)) {
    i82 = i61;
    i83 = i62;
    i84 = i63;
   } else {
    HEAP32[i81 >> 2] = i17;
    do {
     if ((i61 | 0) == (i62 | 0)) {
      i81 = (i62 | 0) == 0 ? 1 : i62 << 1;
      if ((i62 | 0) >= (i81 | 0)) {
       i85 = i62;
       i86 = i63;
       break;
      }
      if ((i81 | 0) == 0) {
       i87 = 0;
      } else {
       i87 = __Z22btAlignedAllocInternalji(i81 << 2, 16) | 0;
      }
      if ((i62 | 0) > 0) {
       i88 = 0;
       do {
        i89 = i87 + (i88 << 2) | 0;
        if ((i89 | 0) != 0) {
         HEAP32[i89 >> 2] = HEAP32[i63 + (i88 << 2) >> 2];
        }
        i88 = i88 + 1 | 0;
       } while ((i88 | 0) < (i62 | 0));
      }
      if ((i63 | 0) == 0) {
       i85 = i81;
       i86 = i87;
       break;
      }
      __Z21btAlignedFreeInternalPv(i63);
      i85 = i81;
      i86 = i87;
     } else {
      i85 = i62;
      i86 = i63;
     }
    } while (0);
    i88 = i86 + (i61 << 2) | 0;
    if ((i88 | 0) != 0) {
     HEAP32[i88 >> 2] = HEAP32[i80 >> 2];
    }
    i82 = i61 + 1 | 0;
    i83 = i85;
    i84 = i86;
   }
   if ((HEAP32[i57 + 20 >> 2] | 0) == (i17 | 0)) {
    i90 = i58;
    i91 = i59;
    i92 = i60;
    i93 = i64;
    i94 = i65;
    i95 = i66;
    i96 = i67;
    i97 = i68;
    i98 = i69;
    i99 = i70;
    i100 = i71;
    i101 = i72;
    i102 = i73;
    i103 = i74;
    i104 = i75;
    i105 = i76;
    i106 = i77;
    i107 = i78;
    i108 = i79;
   } else {
    i88 = __ZN20btConvexHullInternal4PoolINS_4FaceEE9newObjectEv(i27) | 0;
    i89 = HEAP32[i80 >> 2] | 0;
    i109 = HEAP32[(HEAP32[(HEAP32[i57 + 8 >> 2] | 0) + 4 >> 2] | 0) + 12 >> 2] | 0;
    HEAP32[i88 + 4 >> 2] = i89;
    i110 = i88 + 12 | 0;
    i111 = i89 + 88 | 0;
    HEAP32[i110 >> 2] = HEAP32[i111 >> 2];
    HEAP32[i110 + 4 >> 2] = HEAP32[i111 + 4 >> 2];
    HEAP32[i110 + 8 >> 2] = HEAP32[i111 + 8 >> 2];
    HEAP32[i110 + 12 >> 2] = HEAP32[i111 + 12 >> 2];
    i111 = i89 + 88 | 0;
    i110 = i89 + 92 | 0;
    i112 = (HEAP32[i109 + 92 >> 2] | 0) - (HEAP32[i110 >> 2] | 0) | 0;
    i113 = i89 + 96 | 0;
    i114 = (HEAP32[i109 + 96 >> 2] | 0) - (HEAP32[i113 >> 2] | 0) | 0;
    HEAP32[i88 + 28 >> 2] = (HEAP32[i109 + 88 >> 2] | 0) - (HEAP32[i111 >> 2] | 0);
    HEAP32[i88 + 32 >> 2] = i112;
    HEAP32[i88 + 36 >> 2] = i114;
    HEAP32[i88 + 40 >> 2] = -1;
    i114 = (HEAP32[i55 >> 2] | 0) - (HEAP32[i110 >> 2] | 0) | 0;
    i110 = (HEAP32[i56 >> 2] | 0) - (HEAP32[i113 >> 2] | 0) | 0;
    HEAP32[i88 + 44 >> 2] = (HEAP32[i54 >> 2] | 0) - (HEAP32[i111 >> 2] | 0);
    HEAP32[i88 + 48 >> 2] = i114;
    HEAP32[i88 + 52 >> 2] = i110;
    HEAP32[i88 + 56 >> 2] = -1;
    i110 = i89 + 16 | 0;
    i114 = HEAP32[i110 >> 2] | 0;
    if ((i114 | 0) == 0) {
     HEAP32[i89 + 12 >> 2] = i88;
    } else {
     HEAP32[i114 + 8 >> 2] = i88;
    }
    HEAP32[i110 >> 2] = i88;
    do {
     if ((i58 | 0) == (i59 | 0)) {
      i110 = (i59 | 0) == 0 ? 1 : i59 << 1;
      if ((i59 | 0) >= (i110 | 0)) {
       i115 = i59;
       i116 = i60;
       break;
      }
      if ((i110 | 0) == 0) {
       i117 = 0;
      } else {
       i117 = __Z22btAlignedAllocInternalji(i110 << 2, 16) | 0;
      }
      if ((i59 | 0) > 0) {
       i114 = 0;
       do {
        i89 = i117 + (i114 << 2) | 0;
        if ((i89 | 0) != 0) {
         HEAP32[i89 >> 2] = HEAP32[i60 + (i114 << 2) >> 2];
        }
        i114 = i114 + 1 | 0;
       } while ((i114 | 0) < (i59 | 0));
      }
      if ((i60 | 0) == 0) {
       i115 = i110;
       i116 = i117;
       break;
      }
      __Z21btAlignedFreeInternalPv(i60);
      i115 = i110;
      i116 = i117;
     } else {
      i115 = i59;
      i116 = i60;
     }
    } while (0);
    i80 = i116 + (i58 << 2) | 0;
    if ((i80 | 0) == 0) {
     i118 = 0;
     i119 = 0;
     i120 = i57;
     i121 = i64;
     i122 = i65;
     i123 = i66;
     i124 = i67;
     i125 = i68;
     i126 = i69;
     i127 = i70;
     i128 = i71;
     i129 = i72;
     i130 = i73;
     i131 = i74;
     i132 = i75;
     i133 = i76;
     i134 = i77;
     i135 = i78;
     i136 = i79;
    } else {
     HEAP32[i80 >> 2] = i88;
     i118 = 0;
     i119 = 0;
     i120 = i57;
     i121 = i64;
     i122 = i65;
     i123 = i66;
     i124 = i67;
     i125 = i68;
     i126 = i69;
     i127 = i70;
     i128 = i71;
     i129 = i72;
     i130 = i73;
     i131 = i74;
     i132 = i75;
     i133 = i76;
     i134 = i77;
     i135 = i78;
     i136 = i79;
    }
    while (1) {
     if ((i119 | 0) == 0 | (i118 | 0) == 0) {
      i137 = i121;
      i138 = i122;
      i139 = i123;
      i140 = i124;
      i141 = i125;
      i142 = i126;
      i143 = i127;
      i144 = i128;
      i145 = i129;
      i146 = i130;
      i147 = i131;
      i148 = i132;
      i149 = i133;
      i150 = i134;
      i151 = i135;
      i152 = i136;
     } else {
      i80 = HEAP32[i54 >> 2] | 0;
      i114 = i80 - i13 | 0;
      i81 = HEAP32[i55 >> 2] | 0;
      i89 = i81 - i18 | 0;
      i111 = HEAP32[i56 >> 2] | 0;
      i113 = i111 - i19 | 0;
      i112 = HEAP32[i119 + 88 >> 2] | 0;
      i109 = i112 - i13 | 0;
      i153 = HEAP32[i119 + 92 >> 2] | 0;
      i154 = i153 - i18 | 0;
      i155 = HEAP32[i119 + 96 >> 2] | 0;
      i156 = i155 - i19 | 0;
      i157 = HEAP32[i118 + 88 >> 2] | 0;
      i158 = i157 - i13 | 0;
      i159 = HEAP32[i118 + 92 >> 2] | 0;
      i160 = i159 - i18 | 0;
      i161 = HEAP32[i118 + 96 >> 2] | 0;
      i162 = i161 - i19 | 0;
      i163 = Math_imul(i162, i154) | 0;
      i164 = i163 - (Math_imul(i160, i156) | 0) | 0;
      i163 = Math_imul(i158, i156) | 0;
      i156 = i163 - (Math_imul(i162, i109) | 0) | 0;
      i162 = Math_imul(i160, i109) | 0;
      i109 = i162 - (Math_imul(i158, i154) | 0) | 0;
      i154 = ___muldi3(i164, (i164 | 0) < 0 ? -1 : 0, i114, (i114 | 0) < 0 ? -1 : 0) | 0;
      i114 = tempRet0;
      i164 = ___muldi3(i156, (i156 | 0) < 0 ? -1 : 0, i89, (i89 | 0) < 0 ? -1 : 0) | 0;
      i89 = tempRet0;
      i156 = ___muldi3(i109, (i109 | 0) < 0 ? -1 : 0, i113, (i113 | 0) < 0 ? -1 : 0) | 0;
      i113 = _i64Add(i154, i114, i156, tempRet0) | 0;
      i156 = _i64Add(i113, tempRet0, i164, i89) | 0;
      i89 = tempRet0;
      i164 = i80 + i13 + i112 + i157 | 0;
      i157 = i81 + i18 + i153 + i159 | 0;
      i159 = i111 + i19 + i155 + i161 | 0;
      i161 = ___muldi3(i156, i89, i164, (i164 | 0) < 0 ? -1 : 0) | 0;
      i164 = tempRet0;
      i155 = _llvm_uadd_with_overflow_i64(i122 | 0, i121 | 0, i161 | 0, i164 | 0) | 0;
      i161 = i155;
      i155 = tempRet0;
      if (tempRet1) {
       i111 = _i64Add(i124, i123, 1, 0) | 0;
       i153 = tempRet0;
       HEAP32[i20 >> 2] = i111;
       HEAP32[i20 + 4 >> 2] = i153;
       i165 = i153;
       i166 = i111;
      } else {
       i165 = i123;
       i166 = i124;
      }
      HEAP32[i14 >> 2] = i161;
      HEAP32[i14 + 4 >> 2] = i155;
      i111 = _i64Add(i166, i165, i164 >> 31 | ((i164 | 0) < 0 ? -1 : 0) << 1, ((i164 | 0) < 0 ? -1 : 0) >> 31 | ((i164 | 0) < 0 ? -1 : 0) << 1) | 0;
      i164 = tempRet0;
      HEAP32[i20 >> 2] = i111;
      HEAP32[i20 + 4 >> 2] = i164;
      i153 = ___muldi3(i156, i89, i157, (i157 | 0) < 0 ? -1 : 0) | 0;
      i157 = tempRet0;
      i81 = _llvm_uadd_with_overflow_i64(i126 | 0, i125 | 0, i153 | 0, i157 | 0) | 0;
      i153 = i81;
      i81 = tempRet0;
      if (tempRet1) {
       i112 = _i64Add(i128, i127, 1, 0) | 0;
       i80 = tempRet0;
       HEAP32[i22 >> 2] = i112;
       HEAP32[i22 + 4 >> 2] = i80;
       i167 = i80;
       i168 = i112;
      } else {
       i167 = i127;
       i168 = i128;
      }
      HEAP32[i21 >> 2] = i153;
      HEAP32[i21 + 4 >> 2] = i81;
      i112 = _i64Add(i168, i167, i157 >> 31 | ((i157 | 0) < 0 ? -1 : 0) << 1, ((i157 | 0) < 0 ? -1 : 0) >> 31 | ((i157 | 0) < 0 ? -1 : 0) << 1) | 0;
      i157 = tempRet0;
      HEAP32[i22 >> 2] = i112;
      HEAP32[i22 + 4 >> 2] = i157;
      i80 = ___muldi3(i156, i89, i159, (i159 | 0) < 0 ? -1 : 0) | 0;
      i159 = tempRet0;
      i113 = _llvm_uadd_with_overflow_i64(i130 | 0, i129 | 0, i80 | 0, i159 | 0) | 0;
      i80 = i113;
      i113 = tempRet0;
      if (tempRet1) {
       i114 = _i64Add(i132, i131, 1, 0) | 0;
       i154 = tempRet0;
       HEAP32[i24 >> 2] = i114;
       HEAP32[i24 + 4 >> 2] = i154;
       i169 = i154;
       i170 = i114;
      } else {
       i169 = i131;
       i170 = i132;
      }
      HEAP32[i23 >> 2] = i80;
      HEAP32[i23 + 4 >> 2] = i113;
      i114 = _i64Add(i170, i169, i159 >> 31 | ((i159 | 0) < 0 ? -1 : 0) << 1, ((i159 | 0) < 0 ? -1 : 0) >> 31 | ((i159 | 0) < 0 ? -1 : 0) << 1) | 0;
      i159 = tempRet0;
      HEAP32[i24 >> 2] = i114;
      HEAP32[i24 + 4 >> 2] = i159;
      i154 = _llvm_uadd_with_overflow_i64(i134 | 0, i133 | 0, i156 | 0, i89 | 0) | 0;
      i156 = i154;
      i154 = tempRet0;
      if (tempRet1) {
       i109 = _i64Add(i136, i135, 1, 0) | 0;
       i158 = tempRet0;
       HEAP32[i26 >> 2] = i109;
       HEAP32[i26 + 4 >> 2] = i158;
       i171 = i158;
       i172 = i109;
      } else {
       i171 = i135;
       i172 = i136;
      }
      HEAP32[i25 >> 2] = i156;
      HEAP32[i25 + 4 >> 2] = i154;
      i109 = _i64Add(i172, i171, i89 >> 31 | ((i89 | 0) < 0 ? -1 : 0) << 1, ((i89 | 0) < 0 ? -1 : 0) >> 31 | ((i89 | 0) < 0 ? -1 : 0) << 1) | 0;
      i89 = tempRet0;
      HEAP32[i26 >> 2] = i109;
      HEAP32[i26 + 4 >> 2] = i89;
      i137 = i155;
      i138 = i161;
      i139 = i164;
      i140 = i111;
      i141 = i81;
      i142 = i153;
      i143 = i157;
      i144 = i112;
      i145 = i113;
      i146 = i80;
      i147 = i159;
      i148 = i114;
      i149 = i154;
      i150 = i156;
      i151 = i89;
      i152 = i109;
     }
     HEAP32[i120 + 20 >> 2] = i17;
     HEAP32[i120 + 16 >> 2] = i88;
     i109 = HEAP32[(HEAP32[i120 + 8 >> 2] | 0) + 4 >> 2] | 0;
     if ((i109 | 0) == (i57 | 0)) {
      break;
     } else {
      i119 = i118;
      i118 = HEAP32[i120 + 12 >> 2] | 0;
      i120 = i109;
      i121 = i137;
      i122 = i138;
      i123 = i139;
      i124 = i140;
      i125 = i141;
      i126 = i142;
      i127 = i143;
      i128 = i144;
      i129 = i145;
      i130 = i146;
      i131 = i147;
      i132 = i148;
      i133 = i149;
      i134 = i150;
      i135 = i151;
      i136 = i152;
     }
    }
    i90 = i58 + 1 | 0;
    i91 = i115;
    i92 = i116;
    i93 = i137;
    i94 = i138;
    i95 = i139;
    i96 = i140;
    i97 = i141;
    i98 = i142;
    i99 = i143;
    i100 = i144;
    i101 = i145;
    i102 = i146;
    i103 = i147;
    i104 = i148;
    i105 = i149;
    i106 = i150;
    i107 = i151;
    i108 = i152;
   }
   i88 = HEAP32[i57 >> 2] | 0;
   if ((i88 | 0) == (HEAP32[i52 >> 2] | 0)) {
    i28 = i90;
    i29 = i91;
    i30 = i92;
    i31 = i82;
    i32 = i83;
    i33 = i84;
    i16 = i93;
    i34 = i94;
    i35 = i95;
    i36 = i96;
    i37 = i97;
    i38 = i98;
    i39 = i99;
    i40 = i100;
    i41 = i101;
    i42 = i102;
    i43 = i103;
    i44 = i104;
    i45 = i105;
    i46 = i106;
    i47 = i107;
    i48 = i108;
    continue L1498;
   } else {
    i57 = i88;
    i58 = i90;
    i59 = i91;
    i60 = i92;
    i61 = i82;
    i62 = i83;
    i63 = i84;
    i64 = i93;
    i65 = i94;
    i66 = i95;
    i67 = i96;
    i68 = i97;
    i69 = i98;
    i70 = i99;
    i71 = i100;
    i72 = i101;
    i73 = i102;
    i74 = i103;
    i75 = i104;
    i76 = i105;
    i77 = i106;
    i78 = i107;
    i79 = i108;
   }
  }
 }
 i108 = 0;
 L1573 : do {
  if ((i47 | 0) < (i108 | 0) | (i47 | 0) == (i108 | 0) & i48 >>> 0 < 0 >>> 0) {
   d173 = 0.0;
  } else {
   if ((i46 | i48 | 0) == 0 & (i45 | i47 | 0) == 0) {
    d173 = 0.0;
    break;
   }
   d174 = +__ZNK20btConvexHullInternal6Int1288toScalarEv(i6);
   i107 = i1 + 108 | 0;
   i106 = i10 | 0;
   HEAPF32[i10 + (HEAP32[i107 >> 2] << 2) >> 2] = d174;
   d174 = +__ZNK20btConvexHullInternal6Int1288toScalarEv(i7);
   i105 = i1 + 112 | 0;
   HEAPF32[i10 + (HEAP32[i105 >> 2] << 2) >> 2] = d174;
   d174 = +__ZNK20btConvexHullInternal6Int1288toScalarEv(i8);
   i104 = i1 + 104 | 0;
   HEAPF32[i10 + (HEAP32[i104 >> 2] << 2) >> 2] = d174;
   d174 = 1.0 / (+__ZNK20btConvexHullInternal6Int1288toScalarEv(i9) * 4.0);
   i103 = i10 + 4 | 0;
   d175 = d174 * +HEAPF32[i103 >> 2];
   i102 = i10 + 8 | 0;
   d176 = d174 * +HEAPF32[i102 >> 2];
   i101 = i1 | 0;
   d177 = d174 * +HEAPF32[i106 >> 2] * +HEAPF32[i101 >> 2];
   HEAPF32[i106 >> 2] = d177;
   i106 = i1 + 4 | 0;
   d174 = d175 * +HEAPF32[i106 >> 2];
   HEAPF32[i103 >> 2] = d174;
   i103 = i1 + 8 | 0;
   d175 = d176 * +HEAPF32[i103 >> 2];
   HEAPF32[i102 >> 2] = d175;
   if (d3 > 0.0) {
    if ((i28 | 0) > 0) {
     i102 = i5 | 0;
     i100 = i5 + 4 | 0;
     i99 = i5 + 8 | 0;
     i98 = i11 | 0;
     i97 = i11 + 4 | 0;
     i96 = i11 + 8 | 0;
     d176 = 3.4028234663852886e+38;
     i95 = 0;
     do {
      i94 = i30 + (i95 << 2) | 0;
      __ZN20btConvexHullInternal11getBtNormalEPNS_4FaceE(i11, i1, HEAP32[i94 >> 2] | 0);
      i93 = HEAP32[i94 >> 2] | 0;
      HEAPF32[i5 + (HEAP32[i107 >> 2] << 2) >> 2] = +(HEAP32[i93 + 12 >> 2] | 0);
      HEAPF32[i5 + (HEAP32[i105 >> 2] << 2) >> 2] = +(HEAP32[i93 + 16 >> 2] | 0);
      HEAPF32[i5 + (HEAP32[i104 >> 2] << 2) >> 2] = +(HEAP32[i93 + 20 >> 2] | 0);
      d178 = (+HEAPF32[i102 >> 2] * +HEAPF32[i101 >> 2] - d177) * +HEAPF32[i98 >> 2] + (+HEAPF32[i100 >> 2] * +HEAPF32[i106 >> 2] - d174) * +HEAPF32[i97 >> 2] + (+HEAPF32[i99 >> 2] * +HEAPF32[i103 >> 2] - d175) * +HEAPF32[i96 >> 2];
      d176 = d178 < d176 ? d178 : d176;
      i95 = i95 + 1 | 0;
     } while ((i95 | 0) < (i28 | 0));
     if (d176 > 0.0) {
      d179 = d176;
     } else {
      d173 = 0.0;
      break;
     }
    } else {
     d179 = 3.4028234663852886e+38;
    }
    d175 = d179 * d3;
    d180 = d175 > d2 ? d2 : d175;
   } else {
    d180 = d2;
   }
   if ((i28 | 0) > 0) {
    i95 = 243703;
    i96 = 0;
    do {
     i103 = i30 + (i96 << 2) | 0;
     i99 = i30 + (((i95 >>> 0) % (i28 >>> 0) | 0) << 2) | 0;
     i97 = HEAP32[i103 >> 2] | 0;
     HEAP32[i103 >> 2] = HEAP32[i99 >> 2];
     HEAP32[i99 >> 2] = i97;
     i96 = i96 + 1 | 0;
     i95 = (Math_imul(i95, 1664525) | 0) + 1013904223 | 0;
    } while ((i96 | 0) < (i28 | 0));
   }
   i96 = i12 + 16 | 0;
   i95 = i12 + 12 | 0;
   i97 = i12 + 4 | 0;
   i99 = i12 + 8 | 0;
   i103 = 0;
   while (1) {
    if ((i103 | 0) >= (i28 | 0)) {
     d173 = d180;
     break L1573;
    }
    i106 = HEAP32[i30 + (i103 << 2) >> 2] | 0;
    HEAP8[i96] = 1;
    HEAP32[i95 >> 2] = 0;
    HEAP32[i99 >> 2] = 0;
    HEAP32[i97 >> 2] = i49;
    i100 = __ZN20btConvexHullInternal9shiftFaceEPNS_4FaceEf20btAlignedObjectArrayIPNS_6VertexEE(i1, i106, d180, i12) | 0;
    i106 = HEAP32[i95 >> 2] | 0;
    if ((i106 | 0) != 0) {
     if ((HEAP8[i96] | 0) != 0) {
      __Z21btAlignedFreeInternalPv(i106);
     }
     HEAP32[i95 >> 2] = 0;
    }
    HEAP8[i96] = 1;
    HEAP32[i95 >> 2] = 0;
    HEAP32[i97 >> 2] = 0;
    HEAP32[i99 >> 2] = 0;
    if (i100) {
     i103 = i103 + 1 | 0;
    } else {
     break;
    }
   }
   d173 = -0.0 - d180;
  }
 } while (0);
 if ((i30 | 0) != 0) {
  __Z21btAlignedFreeInternalPv(i30);
 }
 if ((i33 | 0) == 0) {
  d15 = d173;
  STACKTOP = i4;
  return +d15;
 }
 __Z21btAlignedFreeInternalPv(i33);
 d15 = d173;
 STACKTOP = i4;
 return +d15;
}
function __ZN20btConvexHullComputer7computeEPKvbiiff(i1, i2, i3, i4, i5, d6, d7) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 d6 = +d6;
 d7 = +d7;
 var i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, d19 = 0.0, d20 = 0.0, d21 = 0.0, i22 = 0, d23 = 0.0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0, i62 = 0, i63 = 0, i64 = 0, i65 = 0, i66 = 0, i67 = 0, i68 = 0, i69 = 0, i70 = 0, i71 = 0, i72 = 0, i73 = 0, i74 = 0, i75 = 0, i76 = 0, i77 = 0, i78 = 0, i79 = 0, i80 = 0, i81 = 0, i82 = 0, i83 = 0, i84 = 0, i85 = 0, i86 = 0, i87 = 0;
 i8 = STACKTOP;
 STACKTOP = STACKTOP + 208 | 0;
 i9 = i8 | 0;
 i10 = i8 + 128 | 0;
 i11 = i8 + 144 | 0;
 i12 = i8 + 160 | 0;
 i13 = i8 + 176 | 0;
 i14 = i8 + 192 | 0;
 if ((i5 | 0) < 1) {
  i15 = i1 + 4 | 0;
  i16 = i1 + 12 | 0;
  i17 = HEAP32[i16 >> 2] | 0;
  i18 = i1 + 16 | 0;
  if ((i17 | 0) != 0) {
   if ((HEAP8[i18] | 0) != 0) {
    __Z21btAlignedFreeInternalPv(i17);
   }
   HEAP32[i16 >> 2] = 0;
  }
  HEAP8[i18] = 1;
  HEAP32[i16 >> 2] = 0;
  HEAP32[i15 >> 2] = 0;
  HEAP32[i1 + 8 >> 2] = 0;
  i15 = i1 + 24 | 0;
  i16 = i1 + 32 | 0;
  i18 = HEAP32[i16 >> 2] | 0;
  i17 = i1 + 36 | 0;
  if ((i18 | 0) != 0) {
   if ((HEAP8[i17] | 0) != 0) {
    __Z21btAlignedFreeInternalPv(i18);
   }
   HEAP32[i16 >> 2] = 0;
  }
  HEAP8[i17] = 1;
  HEAP32[i16 >> 2] = 0;
  HEAP32[i15 >> 2] = 0;
  HEAP32[i1 + 28 >> 2] = 0;
  i15 = i1 + 44 | 0;
  i16 = i1 + 52 | 0;
  i17 = HEAP32[i16 >> 2] | 0;
  i18 = i1 + 56 | 0;
  if ((i17 | 0) != 0) {
   if ((HEAP8[i18] | 0) != 0) {
    __Z21btAlignedFreeInternalPv(i17);
   }
   HEAP32[i16 >> 2] = 0;
  }
  HEAP8[i18] = 1;
  HEAP32[i16 >> 2] = 0;
  HEAP32[i15 >> 2] = 0;
  HEAP32[i1 + 48 >> 2] = 0;
  d19 = 0.0;
  STACKTOP = i8;
  return +d19;
 }
 HEAP32[i9 + 32 >> 2] = 0;
 HEAP32[i9 + 36 >> 2] = 0;
 HEAP32[i9 + 40 >> 2] = 0;
 HEAP32[i9 + 44 >> 2] = 256;
 HEAP32[i9 + 48 >> 2] = 0;
 HEAP32[i9 + 52 >> 2] = 0;
 HEAP32[i9 + 56 >> 2] = 0;
 HEAP32[i9 + 60 >> 2] = 256;
 HEAP32[i9 + 64 >> 2] = 0;
 HEAP32[i9 + 68 >> 2] = 0;
 HEAP32[i9 + 72 >> 2] = 0;
 HEAP32[i9 + 76 >> 2] = 256;
 HEAP8[i9 + 96 | 0] = 1;
 HEAP32[i9 + 92 >> 2] = 0;
 HEAP32[i9 + 84 >> 2] = 0;
 HEAP32[i9 + 88 >> 2] = 0;
 __ZN20btConvexHullInternal7computeEPKvbii(i9, i2, i3, i4, i5);
 do {
  if (d6 > 0.0) {
   d20 = +__ZN20btConvexHullInternal6shrinkEff(i9, d6, d7);
   if (d20 >= 0.0) {
    d21 = d20;
    i22 = 1689;
    break;
   }
   i5 = i1 + 4 | 0;
   i4 = i1 + 12 | 0;
   i3 = HEAP32[i4 >> 2] | 0;
   i2 = i1 + 16 | 0;
   if ((i3 | 0) != 0) {
    if ((HEAP8[i2] | 0) != 0) {
     __Z21btAlignedFreeInternalPv(i3);
    }
    HEAP32[i4 >> 2] = 0;
   }
   HEAP8[i2] = 1;
   HEAP32[i4 >> 2] = 0;
   HEAP32[i5 >> 2] = 0;
   HEAP32[i1 + 8 >> 2] = 0;
   i5 = i1 + 24 | 0;
   i4 = i1 + 32 | 0;
   i2 = HEAP32[i4 >> 2] | 0;
   i3 = i1 + 36 | 0;
   if ((i2 | 0) != 0) {
    if ((HEAP8[i3] | 0) != 0) {
     __Z21btAlignedFreeInternalPv(i2);
    }
    HEAP32[i4 >> 2] = 0;
   }
   HEAP8[i3] = 1;
   HEAP32[i4 >> 2] = 0;
   HEAP32[i5 >> 2] = 0;
   HEAP32[i1 + 28 >> 2] = 0;
   i5 = i1 + 44 | 0;
   i4 = i1 + 52 | 0;
   i3 = HEAP32[i4 >> 2] | 0;
   i2 = i1 + 56 | 0;
   if ((i3 | 0) != 0) {
    if ((HEAP8[i2] | 0) != 0) {
     __Z21btAlignedFreeInternalPv(i3);
    }
    HEAP32[i4 >> 2] = 0;
   }
   HEAP8[i2] = 1;
   HEAP32[i4 >> 2] = 0;
   HEAP32[i5 >> 2] = 0;
   HEAP32[i1 + 48 >> 2] = 0;
   d23 = d20;
  } else {
   d21 = 0.0;
   i22 = 1689;
  }
 } while (0);
 do {
  if ((i22 | 0) == 1689) {
   i5 = i1 + 4 | 0;
   i4 = HEAP32[i5 >> 2] | 0;
   if ((i4 | 0) < 0) {
    i2 = i1 + 8 | 0;
    i3 = i1 + 12 | 0;
    if ((HEAP32[i2 >> 2] | 0) < 0) {
     i15 = HEAP32[i3 >> 2] | 0;
     i16 = i1 + 16 | 0;
     if ((i15 | 0) != 0) {
      if ((HEAP8[i16] | 0) != 0) {
       __Z21btAlignedFreeInternalPv(i15);
      }
      HEAP32[i3 >> 2] = 0;
     }
     HEAP8[i16] = 1;
     HEAP32[i3 >> 2] = 0;
     HEAP32[i2 >> 2] = 0;
    }
    i2 = i10;
    i16 = i4;
    do {
     i4 = (HEAP32[i3 >> 2] | 0) + (i16 << 4) | 0;
     if ((i4 | 0) != 0) {
      i15 = i4;
      HEAP32[i15 >> 2] = HEAP32[i2 >> 2];
      HEAP32[i15 + 4 >> 2] = HEAP32[i2 + 4 >> 2];
      HEAP32[i15 + 8 >> 2] = HEAP32[i2 + 8 >> 2];
      HEAP32[i15 + 12 >> 2] = HEAP32[i2 + 12 >> 2];
     }
     i16 = i16 + 1 | 0;
    } while ((i16 | 0) < 0);
   }
   HEAP32[i5 >> 2] = 0;
   i16 = i11;
   _memset(i16 | 0, 0, 12);
   i2 = i1 + 24 | 0;
   i3 = HEAP32[i2 >> 2] | 0;
   if ((i3 | 0) < 0) {
    i15 = i1 + 28 | 0;
    i4 = i1 + 32 | 0;
    if ((HEAP32[i15 >> 2] | 0) < 0) {
     i18 = HEAP32[i4 >> 2] | 0;
     i17 = i1 + 36 | 0;
     if ((i18 | 0) != 0) {
      if ((HEAP8[i17] | 0) != 0) {
       __Z21btAlignedFreeInternalPv(i18);
      }
      HEAP32[i4 >> 2] = 0;
     }
     HEAP8[i17] = 1;
     HEAP32[i4 >> 2] = 0;
     HEAP32[i15 >> 2] = 0;
     i24 = i3;
    } else {
     i24 = i3;
    }
    do {
     i3 = (HEAP32[i4 >> 2] | 0) + (i24 * 12 | 0) | 0;
     if ((i3 | 0) != 0) {
      i15 = i3;
      HEAP32[i15 >> 2] = HEAP32[i16 >> 2];
      HEAP32[i15 + 4 >> 2] = HEAP32[i16 + 4 >> 2];
      HEAP32[i15 + 8 >> 2] = HEAP32[i16 + 8 >> 2];
     }
     i24 = i24 + 1 | 0;
    } while ((i24 | 0) < 0);
   }
   HEAP32[i2 >> 2] = 0;
   i16 = i1 + 44 | 0;
   i4 = HEAP32[i16 >> 2] | 0;
   if ((i4 | 0) < 0) {
    i15 = i1 + 48 | 0;
    i3 = i1 + 52 | 0;
    i17 = HEAP32[i3 >> 2] | 0;
    if ((HEAP32[i15 >> 2] | 0) < 0) {
     i18 = i1 + 56 | 0;
     if ((i17 | 0) != 0) {
      if ((HEAP8[i18] | 0) != 0) {
       __Z21btAlignedFreeInternalPv(i17);
      }
      HEAP32[i3 >> 2] = 0;
     }
     HEAP8[i18] = 1;
     HEAP32[i3 >> 2] = 0;
     HEAP32[i15 >> 2] = 0;
     i25 = 0;
    } else {
     i25 = i17;
    }
    i17 = i4;
    do {
     i4 = i25 + (i17 << 2) | 0;
     if ((i4 | 0) != 0) {
      HEAP32[i4 >> 2] = 0;
     }
     i17 = i17 + 1 | 0;
    } while ((i17 | 0) < 0);
   }
   HEAP32[i16 >> 2] = 0;
   i17 = HEAP32[i9 + 124 >> 2] | 0;
   i4 = i17 + 104 | 0;
   if ((HEAP32[i4 >> 2] | 0) >= 0) {
    d23 = d21;
    break;
   }
   HEAP32[i4 >> 2] = 0;
   i4 = __Z22btAlignedAllocInternalji(4, 16) | 0;
   i15 = i4;
   if ((i4 | 0) != 0) {
    HEAP32[i15 >> 2] = i17;
   }
   i17 = i1 + 8 | 0;
   i4 = i1 + 12 | 0;
   i3 = i1 + 16 | 0;
   i18 = i13;
   i26 = i1 + 28 | 0;
   i27 = i1 + 32 | 0;
   i28 = i1 + 36 | 0;
   i29 = i14;
   i30 = i12;
   i31 = i15;
   i15 = 1;
   i32 = 1;
   i33 = 0;
   while (1) {
    i34 = HEAP32[i31 + (i33 << 2) >> 2] | 0;
    __ZN20btConvexHullInternal14getCoordinatesEPKNS_6VertexE(i12, i9, i34);
    i35 = HEAP32[i5 >> 2] | 0;
    do {
     if ((i35 | 0) == (HEAP32[i17 >> 2] | 0)) {
      i36 = (i35 | 0) == 0 ? 1 : i35 << 1;
      if ((i35 | 0) >= (i36 | 0)) {
       i37 = i35;
       break;
      }
      if ((i36 | 0) == 0) {
       i38 = 0;
       i39 = i35;
      } else {
       i40 = __Z22btAlignedAllocInternalji(i36 << 4, 16) | 0;
       i38 = i40;
       i39 = HEAP32[i5 >> 2] | 0;
      }
      if ((i39 | 0) > 0) {
       i40 = 0;
       do {
        i41 = i38 + (i40 << 4) | 0;
        if ((i41 | 0) != 0) {
         i42 = i41;
         i41 = (HEAP32[i4 >> 2] | 0) + (i40 << 4) | 0;
         HEAP32[i42 >> 2] = HEAP32[i41 >> 2];
         HEAP32[i42 + 4 >> 2] = HEAP32[i41 + 4 >> 2];
         HEAP32[i42 + 8 >> 2] = HEAP32[i41 + 8 >> 2];
         HEAP32[i42 + 12 >> 2] = HEAP32[i41 + 12 >> 2];
        }
        i40 = i40 + 1 | 0;
       } while ((i40 | 0) < (i39 | 0));
      }
      i40 = HEAP32[i4 >> 2] | 0;
      if ((i40 | 0) != 0) {
       if ((HEAP8[i3] | 0) != 0) {
        __Z21btAlignedFreeInternalPv(i40);
       }
       HEAP32[i4 >> 2] = 0;
      }
      HEAP8[i3] = 1;
      HEAP32[i4 >> 2] = i38;
      HEAP32[i17 >> 2] = i36;
      i37 = HEAP32[i5 >> 2] | 0;
     } else {
      i37 = i35;
     }
    } while (0);
    i35 = (HEAP32[i4 >> 2] | 0) + (i37 << 4) | 0;
    if ((i35 | 0) == 0) {
     i43 = i37;
    } else {
     i40 = i35;
     HEAP32[i40 >> 2] = HEAP32[i30 >> 2];
     HEAP32[i40 + 4 >> 2] = HEAP32[i30 + 4 >> 2];
     HEAP32[i40 + 8 >> 2] = HEAP32[i30 + 8 >> 2];
     HEAP32[i40 + 12 >> 2] = HEAP32[i30 + 12 >> 2];
     i43 = HEAP32[i5 >> 2] | 0;
    }
    HEAP32[i5 >> 2] = i43 + 1;
    i40 = HEAP32[i34 + 8 >> 2] | 0;
    if ((i40 | 0) == 0) {
     i44 = i32;
     i45 = i15;
     i46 = i31;
    } else {
     i35 = i40;
     i41 = -1;
     i42 = -1;
     i47 = i32;
     i48 = i15;
     i49 = i31;
     while (1) {
      i50 = i35 + 20 | 0;
      i51 = HEAP32[i50 >> 2] | 0;
      if ((i51 | 0) < 0) {
       i52 = HEAP32[i2 >> 2] | 0;
       _memset(i18 | 0, 0, 12);
       i53 = HEAP32[i26 >> 2] | 0;
       do {
        if ((i52 | 0) == (i53 | 0)) {
         i54 = (i52 | 0) == 0 ? 1 : i52 << 1;
         if ((i52 | 0) >= (i54 | 0)) {
          i55 = i52;
          i56 = i52;
          break;
         }
         if ((i54 | 0) == 0) {
          i57 = 0;
          i58 = i52;
         } else {
          i59 = __Z22btAlignedAllocInternalji(i54 * 12 | 0, 16) | 0;
          i57 = i59;
          i58 = HEAP32[i2 >> 2] | 0;
         }
         if ((i58 | 0) > 0) {
          i59 = 0;
          do {
           i60 = i57 + (i59 * 12 | 0) | 0;
           if ((i60 | 0) != 0) {
            i61 = i60;
            i60 = (HEAP32[i27 >> 2] | 0) + (i59 * 12 | 0) | 0;
            HEAP32[i61 >> 2] = HEAP32[i60 >> 2];
            HEAP32[i61 + 4 >> 2] = HEAP32[i60 + 4 >> 2];
            HEAP32[i61 + 8 >> 2] = HEAP32[i60 + 8 >> 2];
           }
           i59 = i59 + 1 | 0;
          } while ((i59 | 0) < (i58 | 0));
         }
         i59 = HEAP32[i27 >> 2] | 0;
         if ((i59 | 0) != 0) {
          if ((HEAP8[i28] | 0) != 0) {
           __Z21btAlignedFreeInternalPv(i59);
          }
          HEAP32[i27 >> 2] = 0;
         }
         HEAP8[i28] = 1;
         HEAP32[i27 >> 2] = i57;
         HEAP32[i26 >> 2] = i54;
         i55 = HEAP32[i2 >> 2] | 0;
         i56 = i54;
        } else {
         i55 = i52;
         i56 = i53;
        }
       } while (0);
       i53 = (HEAP32[i27 >> 2] | 0) + (i55 * 12 | 0) | 0;
       if ((i53 | 0) == 0) {
        i62 = i55;
        i63 = i56;
       } else {
        i36 = i53;
        HEAP32[i36 >> 2] = HEAP32[i18 >> 2];
        HEAP32[i36 + 4 >> 2] = HEAP32[i18 + 4 >> 2];
        HEAP32[i36 + 8 >> 2] = HEAP32[i18 + 8 >> 2];
        i62 = HEAP32[i2 >> 2] | 0;
        i63 = HEAP32[i26 >> 2] | 0;
       }
       i36 = i62 + 1 | 0;
       HEAP32[i2 >> 2] = i36;
       _memset(i29 | 0, 0, 12);
       do {
        if ((i36 | 0) == (i63 | 0)) {
         i53 = (i63 | 0) == 0 ? 1 : i63 << 1;
         if ((i63 | 0) >= (i53 | 0)) {
          i64 = i63;
          break;
         }
         if ((i53 | 0) == 0) {
          i65 = 0;
          i66 = i63;
         } else {
          i59 = __Z22btAlignedAllocInternalji(i53 * 12 | 0, 16) | 0;
          i65 = i59;
          i66 = HEAP32[i2 >> 2] | 0;
         }
         if ((i66 | 0) > 0) {
          i59 = 0;
          do {
           i60 = i65 + (i59 * 12 | 0) | 0;
           if ((i60 | 0) != 0) {
            i61 = i60;
            i60 = (HEAP32[i27 >> 2] | 0) + (i59 * 12 | 0) | 0;
            HEAP32[i61 >> 2] = HEAP32[i60 >> 2];
            HEAP32[i61 + 4 >> 2] = HEAP32[i60 + 4 >> 2];
            HEAP32[i61 + 8 >> 2] = HEAP32[i60 + 8 >> 2];
           }
           i59 = i59 + 1 | 0;
          } while ((i59 | 0) < (i66 | 0));
         }
         i59 = HEAP32[i27 >> 2] | 0;
         if ((i59 | 0) != 0) {
          if ((HEAP8[i28] | 0) != 0) {
           __Z21btAlignedFreeInternalPv(i59);
          }
          HEAP32[i27 >> 2] = 0;
         }
         HEAP8[i28] = 1;
         HEAP32[i27 >> 2] = i65;
         HEAP32[i26 >> 2] = i53;
         i64 = HEAP32[i2 >> 2] | 0;
        } else {
         i64 = i36;
        }
       } while (0);
       i36 = HEAP32[i27 >> 2] | 0;
       i59 = i36 + (i64 * 12 | 0) | 0;
       if ((i59 | 0) == 0) {
        i67 = i64;
        i68 = i36;
       } else {
        i36 = i59;
        HEAP32[i36 >> 2] = HEAP32[i29 >> 2];
        HEAP32[i36 + 4 >> 2] = HEAP32[i29 + 4 >> 2];
        HEAP32[i36 + 8 >> 2] = HEAP32[i29 + 8 >> 2];
        i67 = HEAP32[i2 >> 2] | 0;
        i68 = HEAP32[i27 >> 2] | 0;
       }
       HEAP32[i2 >> 2] = i67 + 1;
       i36 = i52 + 1 | 0;
       HEAP32[i50 >> 2] = i52;
       HEAP32[(HEAP32[i35 + 8 >> 2] | 0) + 20 >> 2] = i36;
       HEAP32[i68 + (i52 * 12 | 0) + 4 >> 2] = 1;
       HEAP32[i68 + (i36 * 12 | 0) + 4 >> 2] = -1;
       i59 = HEAP32[i35 + 12 >> 2] | 0;
       i54 = i59 + 104 | 0;
       i60 = HEAP32[i54 >> 2] | 0;
       if ((i60 | 0) < 0) {
        HEAP32[i54 >> 2] = i47;
        do {
         if ((i47 | 0) == (i48 | 0)) {
          i54 = (i48 | 0) == 0 ? 1 : i48 << 1;
          if ((i48 | 0) >= (i54 | 0)) {
           i69 = i48;
           i70 = i49;
           break;
          }
          if ((i54 | 0) == 0) {
           i71 = 0;
          } else {
           i71 = __Z22btAlignedAllocInternalji(i54 << 2, 16) | 0;
          }
          if ((i48 | 0) > 0) {
           i61 = 0;
           do {
            i72 = i71 + (i61 << 2) | 0;
            if ((i72 | 0) != 0) {
             HEAP32[i72 >> 2] = HEAP32[i49 + (i61 << 2) >> 2];
            }
            i61 = i61 + 1 | 0;
           } while ((i61 | 0) < (i48 | 0));
          }
          if ((i49 | 0) == 0) {
           i69 = i54;
           i70 = i71;
           break;
          }
          __Z21btAlignedFreeInternalPv(i49);
          i69 = i54;
          i70 = i71;
         } else {
          i69 = i48;
          i70 = i49;
         }
        } while (0);
        i61 = i70 + (i47 << 2) | 0;
        if ((i61 | 0) != 0) {
         HEAP32[i61 >> 2] = i59;
        }
        i73 = i47;
        i74 = i47 + 1 | 0;
        i75 = i69;
        i76 = i70;
       } else {
        i73 = i60;
        i74 = i47;
        i75 = i48;
        i76 = i49;
       }
       HEAP32[i68 + (i52 * 12 | 0) + 8 >> 2] = i73;
       HEAP32[i68 + (i36 * 12 | 0) + 8 >> 2] = i33;
       i77 = i74;
       i78 = i75;
       i79 = i76;
       i80 = HEAP32[i50 >> 2] | 0;
      } else {
       i77 = i47;
       i78 = i48;
       i79 = i49;
       i80 = i51;
      }
      if ((i41 | 0) > -1) {
       HEAP32[(HEAP32[i27 >> 2] | 0) + (i80 * 12 | 0) >> 2] = i41 - i80;
       i81 = i42;
       i82 = HEAP32[i50 >> 2] | 0;
      } else {
       i81 = i80;
       i82 = i80;
      }
      i61 = HEAP32[i35 >> 2] | 0;
      if ((i61 | 0) == (i40 | 0)) {
       break;
      } else {
       i35 = i61;
       i41 = i82;
       i42 = i81;
       i47 = i77;
       i48 = i78;
       i49 = i79;
      }
     }
     HEAP32[(HEAP32[i27 >> 2] | 0) + (i81 * 12 | 0) >> 2] = i82 - i81;
     i44 = i77;
     i45 = i78;
     i46 = i79;
    }
    i83 = i33 + 1 | 0;
    if ((i83 | 0) < (i44 | 0)) {
     i31 = i46;
     i15 = i45;
     i32 = i44;
     i33 = i83;
    } else {
     break;
    }
   }
   if ((i83 | 0) > 0) {
    i33 = i1 + 48 | 0;
    i32 = i1 + 52 | 0;
    i15 = i1 + 56 | 0;
    i31 = 0;
    do {
     i27 = HEAP32[(HEAP32[i46 + (i31 << 2) >> 2] | 0) + 8 >> 2] | 0;
     if ((i27 | 0) != 0) {
      i2 = i27;
      do {
       i29 = i2 + 20 | 0;
       if ((HEAP32[i29 >> 2] | 0) > -1) {
        i26 = HEAP32[i16 >> 2] | 0;
        do {
         if ((i26 | 0) == (HEAP32[i33 >> 2] | 0)) {
          i28 = (i26 | 0) == 0 ? 1 : i26 << 1;
          if ((i26 | 0) >= (i28 | 0)) {
           i84 = i26;
           break;
          }
          if ((i28 | 0) == 0) {
           i85 = 0;
           i86 = i26;
          } else {
           i18 = __Z22btAlignedAllocInternalji(i28 << 2, 16) | 0;
           i85 = i18;
           i86 = HEAP32[i16 >> 2] | 0;
          }
          if ((i86 | 0) > 0) {
           i18 = 0;
           do {
            i5 = i85 + (i18 << 2) | 0;
            if ((i5 | 0) != 0) {
             HEAP32[i5 >> 2] = HEAP32[(HEAP32[i32 >> 2] | 0) + (i18 << 2) >> 2];
            }
            i18 = i18 + 1 | 0;
           } while ((i18 | 0) < (i86 | 0));
          }
          i18 = HEAP32[i32 >> 2] | 0;
          if ((i18 | 0) != 0) {
           if ((HEAP8[i15] | 0) != 0) {
            __Z21btAlignedFreeInternalPv(i18);
           }
           HEAP32[i32 >> 2] = 0;
          }
          HEAP8[i15] = 1;
          HEAP32[i32 >> 2] = i85;
          HEAP32[i33 >> 2] = i28;
          i84 = HEAP32[i16 >> 2] | 0;
         } else {
          i84 = i26;
         }
        } while (0);
        i26 = (HEAP32[i32 >> 2] | 0) + (i84 << 2) | 0;
        if ((i26 | 0) == 0) {
         i87 = i84;
        } else {
         HEAP32[i26 >> 2] = HEAP32[i29 >> 2];
         i87 = HEAP32[i16 >> 2] | 0;
        }
        HEAP32[i16 >> 2] = i87 + 1;
        i26 = i2;
        do {
         HEAP32[i26 + 20 >> 2] = -1;
         i26 = HEAP32[(HEAP32[i26 + 8 >> 2] | 0) + 4 >> 2] | 0;
        } while ((i26 | 0) != (i2 | 0));
       }
       i2 = HEAP32[i2 >> 2] | 0;
      } while ((i2 | 0) != (i27 | 0));
     }
     i31 = i31 + 1 | 0;
    } while ((i31 | 0) < (i83 | 0));
   }
   if ((i46 | 0) == 0) {
    d23 = d21;
    break;
   }
   __Z21btAlignedFreeInternalPv(i46);
   d23 = d21;
  }
 } while (0);
 __ZN20btConvexHullInternalD2Ev(i9);
 d19 = d23;
 STACKTOP = i8;
 return +d19;
}
function __ZN16btCollisionWorld17objectQuerySingleEPK13btConvexShapeRK11btTransformS5_P17btCollisionObjectPK16btCollisionShapeS5_RNS_20ConvexResultCallbackEf(i1, i2, i3, i4, i5, i6, i7, d8) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 i7 = i7 | 0;
 d8 = +d8;
 var i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, d36 = 0.0, i37 = 0, d38 = 0.0, i39 = 0, d40 = 0.0, d41 = 0.0, d42 = 0.0, d43 = 0.0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0, i62 = 0, i63 = 0, i64 = 0, i65 = 0, i66 = 0, i67 = 0, i68 = 0, i69 = 0, i70 = 0, i71 = 0, i72 = 0, i73 = 0, i74 = 0, d75 = 0.0, d76 = 0.0, d77 = 0.0, d78 = 0.0, d79 = 0.0, d80 = 0.0, i81 = 0, d82 = 0.0, d83 = 0.0, d84 = 0.0, d85 = 0.0, d86 = 0.0, d87 = 0.0, d88 = 0.0, d89 = 0.0, d90 = 0.0, d91 = 0.0, d92 = 0.0, d93 = 0.0, d94 = 0.0, d95 = 0.0, d96 = 0.0, d97 = 0.0, d98 = 0.0, d99 = 0.0;
 i9 = STACKTOP;
 STACKTOP = STACKTOP + 1656 | 0;
 i10 = i9 | 0;
 i11 = i9 + 176 | 0;
 i12 = i9 + 536 | 0;
 i13 = i9 + 544 | 0;
 i14 = i9 + 568 | 0;
 i15 = i9 + 616 | 0;
 i16 = i9 + 632 | 0;
 i17 = i9 + 648 | 0;
 i18 = i9 + 712 | 0;
 i19 = i9 + 936 | 0;
 i20 = i9 + 952 | 0;
 i21 = i9 + 968 | 0;
 i22 = i9 + 1144 | 0;
 i23 = i9 + 1168 | 0;
 i24 = i9 + 1216 | 0;
 i25 = i9 + 1280 | 0;
 i26 = i9 + 1504 | 0;
 i27 = i9 + 1520 | 0;
 i28 = i9 + 1536 | 0;
 i29 = i9 + 1552 | 0;
 i30 = i9 + 1568 | 0;
 i31 = i9 + 1632 | 0;
 i32 = HEAP32[i5 + 4 >> 2] | 0;
 if ((i32 | 0) < 20) {
  HEAP32[i10 >> 2] = 2280;
  i33 = i10 + 164 | 0;
  HEAP32[i10 + 168 >> 2] = 0;
  HEAPF32[i10 + 172 >> 2] = d8;
  i34 = i7 + 4 | 0;
  HEAPF32[i33 >> 2] = +HEAPF32[i34 >> 2];
  HEAPF32[i11 + 308 >> 2] = 9999999747378752.0e-20;
  HEAP16[i11 + 332 >> 1] = 0;
  HEAP32[i12 >> 2] = 2696;
  __ZN27btContinuousConvexCollisionC2EPK13btConvexShapeS2_P22btVoronoiSimplexSolverP30btConvexPenetrationDepthSolver(i13, i1, i5, i11, i12 | 0);
  i12 = i13 | 0;
  do {
   if (FUNCTION_TABLE_iiiiiii[HEAP32[(HEAP32[i13 >> 2] | 0) + 8 >> 2] & 7](i12, i2, i3, i6, i6, i10) | 0) {
    i11 = i10 + 132 | 0;
    i35 = i11 | 0;
    d36 = +HEAPF32[i35 >> 2];
    i37 = i10 + 136 | 0;
    d38 = +HEAPF32[i37 >> 2];
    i39 = i10 + 140 | 0;
    d40 = +HEAPF32[i39 >> 2];
    d41 = d36 * d36 + d38 * d38 + d40 * d40;
    if (d41 <= 9999999747378752.0e-20) {
     break;
    }
    d42 = +HEAPF32[i33 >> 2];
    if (d42 >= +HEAPF32[i34 >> 2]) {
     break;
    }
    d43 = 1.0 / +Math_sqrt(+d41);
    HEAPF32[i35 >> 2] = d36 * d43;
    HEAPF32[i37 >> 2] = d38 * d43;
    HEAPF32[i39 >> 2] = d40 * d43;
    HEAP32[i14 >> 2] = i4;
    HEAP32[i14 + 4 >> 2] = 0;
    i39 = i14 + 8 | 0;
    i37 = i11;
    HEAP32[i39 >> 2] = HEAP32[i37 >> 2];
    HEAP32[i39 + 4 >> 2] = HEAP32[i37 + 4 >> 2];
    HEAP32[i39 + 8 >> 2] = HEAP32[i37 + 8 >> 2];
    HEAP32[i39 + 12 >> 2] = HEAP32[i37 + 12 >> 2];
    i37 = i14 + 24 | 0;
    i39 = i10 + 148 | 0;
    HEAP32[i37 >> 2] = HEAP32[i39 >> 2];
    HEAP32[i37 + 4 >> 2] = HEAP32[i39 + 4 >> 2];
    HEAP32[i37 + 8 >> 2] = HEAP32[i39 + 8 >> 2];
    HEAP32[i37 + 12 >> 2] = HEAP32[i39 + 12 >> 2];
    HEAPF32[i14 + 40 >> 2] = d42;
    i39 = HEAP32[(HEAP32[i7 >> 2] | 0) + 12 >> 2] | 0;
    +FUNCTION_TABLE_fiii[i39 & 15](i7, i14, 1);
   }
  } while (0);
  __ZN12btConvexCastD2Ev(i12);
  STACKTOP = i9;
  return;
 }
 if ((i32 - 21 | 0) >>> 0 >= 9) {
  if ((i32 | 0) != 31) {
   STACKTOP = i9;
   return;
  }
  __ZN15CProfileManager13Start_ProfileEPKc(96);
  i12 = i5 + 16 | 0;
  if ((HEAP32[i12 >> 2] | 0) > 0) {
   i14 = i5 + 24 | 0;
   i10 = i6 | 0;
   i34 = i6 + 4 | 0;
   i33 = i6 + 8 | 0;
   i13 = i6 + 16 | 0;
   i39 = i6 + 20 | 0;
   i37 = i6 + 24 | 0;
   i11 = i6 + 32 | 0;
   i35 = i6 + 36 | 0;
   i44 = i6 + 40 | 0;
   i45 = i6 + 48 | 0;
   i46 = i6 + 52 | 0;
   i47 = i6 + 56 | 0;
   i48 = i30 | 0;
   i49 = i30 + 4 | 0;
   i50 = i30 + 8 | 0;
   i51 = i30 + 12 | 0;
   i52 = i30 + 16 | 0;
   i53 = i30 + 20 | 0;
   i54 = i30 + 24 | 0;
   i55 = i30 + 28 | 0;
   i56 = i30 + 32 | 0;
   i57 = i30 + 36 | 0;
   i58 = i30 + 40 | 0;
   i59 = i30 + 44 | 0;
   i60 = i30 + 48 | 0;
   i61 = i30 + 52 | 0;
   i62 = i30 + 56 | 0;
   i63 = i30 + 60 | 0;
   i64 = i4 + 192 | 0;
   i65 = i31 | 0;
   i66 = i31 + 4 | 0;
   i67 = i31 + 8 | 0;
   i68 = i31 + 10 | 0;
   i69 = i31 + 12 | 0;
   i70 = i31 + 16 | 0;
   i71 = i7 + 4 | 0;
   i72 = i31 | 0;
   i31 = HEAP32[i64 >> 2] | 0;
   i73 = 0;
   do {
    i74 = HEAP32[i14 >> 2] | 0;
    d42 = +HEAPF32[i74 + (i73 * 80 | 0) >> 2];
    d43 = +HEAPF32[i74 + (i73 * 80 | 0) + 4 >> 2];
    d40 = +HEAPF32[i74 + (i73 * 80 | 0) + 8 >> 2];
    d38 = +HEAPF32[i74 + (i73 * 80 | 0) + 16 >> 2];
    d36 = +HEAPF32[i74 + (i73 * 80 | 0) + 20 >> 2];
    d41 = +HEAPF32[i74 + (i73 * 80 | 0) + 24 >> 2];
    d75 = +HEAPF32[i74 + (i73 * 80 | 0) + 32 >> 2];
    d76 = +HEAPF32[i74 + (i73 * 80 | 0) + 36 >> 2];
    d77 = +HEAPF32[i74 + (i73 * 80 | 0) + 40 >> 2];
    d78 = +HEAPF32[i74 + (i73 * 80 | 0) + 48 >> 2];
    d79 = +HEAPF32[i74 + (i73 * 80 | 0) + 52 >> 2];
    d80 = +HEAPF32[i74 + (i73 * 80 | 0) + 56 >> 2];
    i81 = HEAP32[i74 + (i73 * 80 | 0) + 64 >> 2] | 0;
    d82 = +HEAPF32[i10 >> 2];
    d83 = +HEAPF32[i34 >> 2];
    d84 = +HEAPF32[i33 >> 2];
    d85 = +HEAPF32[i13 >> 2];
    d86 = +HEAPF32[i39 >> 2];
    d87 = +HEAPF32[i37 >> 2];
    d88 = +HEAPF32[i11 >> 2];
    d89 = +HEAPF32[i35 >> 2];
    d90 = +HEAPF32[i44 >> 2];
    d91 = d78 * d82 + d79 * d83 + d80 * d84 + +HEAPF32[i45 >> 2];
    d92 = d78 * d85 + d79 * d86 + d80 * d87 + +HEAPF32[i46 >> 2];
    d93 = d78 * d88 + d79 * d89 + d80 * d90 + +HEAPF32[i47 >> 2];
    HEAPF32[i48 >> 2] = d42 * d82 + d38 * d83 + d75 * d84;
    HEAPF32[i49 >> 2] = d43 * d82 + d36 * d83 + d76 * d84;
    HEAPF32[i50 >> 2] = d40 * d82 + d41 * d83 + d77 * d84;
    HEAPF32[i51 >> 2] = 0.0;
    HEAPF32[i52 >> 2] = d42 * d85 + d38 * d86 + d75 * d87;
    HEAPF32[i53 >> 2] = d43 * d85 + d36 * d86 + d76 * d87;
    HEAPF32[i54 >> 2] = d40 * d85 + d41 * d86 + d77 * d87;
    HEAPF32[i55 >> 2] = 0.0;
    HEAPF32[i56 >> 2] = d42 * d88 + d38 * d89 + d75 * d90;
    HEAPF32[i57 >> 2] = d43 * d88 + d36 * d89 + d76 * d90;
    HEAPF32[i58 >> 2] = d40 * d88 + d41 * d89 + d77 * d90;
    HEAPF32[i59 >> 2] = 0.0;
    HEAPF32[i60 >> 2] = d91;
    HEAPF32[i61 >> 2] = d92;
    HEAPF32[i62 >> 2] = d93;
    HEAPF32[i63 >> 2] = 0.0;
    HEAP32[i64 >> 2] = i81;
    HEAP16[i67 >> 1] = 1;
    HEAP16[i68 >> 1] = -1;
    HEAP32[i65 >> 2] = 1720;
    HEAP32[i69 >> 2] = i7;
    HEAP32[i70 >> 2] = i73;
    HEAPF32[i66 >> 2] = +HEAPF32[i71 >> 2];
    __ZN16btCollisionWorld17objectQuerySingleEPK13btConvexShapeRK11btTransformS5_P17btCollisionObjectPK16btCollisionShapeS5_RNS_20ConvexResultCallbackEf(i1, i2, i3, i4, i81, i30, i72, d8);
    HEAP32[i64 >> 2] = i31;
    i73 = i73 + 1 | 0;
   } while ((i73 | 0) < (HEAP32[i12 >> 2] | 0));
  }
  __ZN15CProfileManager12Stop_ProfileEv();
  STACKTOP = i9;
  return;
 }
 if ((i32 | 0) == 21) {
  d93 = +HEAPF32[i6 >> 2];
  d92 = +HEAPF32[i6 + 16 >> 2];
  d91 = +HEAPF32[i6 + 32 >> 2];
  d90 = +HEAPF32[i6 + 4 >> 2];
  d77 = +HEAPF32[i6 + 20 >> 2];
  d89 = +HEAPF32[i6 + 36 >> 2];
  d41 = +HEAPF32[i6 + 8 >> 2];
  d88 = +HEAPF32[i6 + 24 >> 2];
  d40 = +HEAPF32[i6 + 40 >> 2];
  d76 = -0.0 - +HEAPF32[i6 + 48 >> 2];
  d36 = -0.0 - +HEAPF32[i6 + 52 >> 2];
  d43 = -0.0 - +HEAPF32[i6 + 56 >> 2];
  d75 = d93 * d76 + d92 * d36 + d91 * d43;
  d38 = d90 * d76 + d77 * d36 + d89 * d43;
  d42 = d41 * d76 + d88 * d36 + d40 * d43;
  d43 = +HEAPF32[i2 + 48 >> 2];
  d36 = +HEAPF32[i2 + 52 >> 2];
  d76 = +HEAPF32[i2 + 56 >> 2];
  HEAPF32[i15 >> 2] = d75 + (d93 * d43 + d92 * d36 + d91 * d76);
  HEAPF32[i15 + 4 >> 2] = d38 + (d90 * d43 + d77 * d36 + d89 * d76);
  HEAPF32[i15 + 8 >> 2] = d42 + (d41 * d43 + d88 * d36 + d40 * d76);
  HEAPF32[i15 + 12 >> 2] = 0.0;
  d76 = +HEAPF32[i3 + 48 >> 2];
  d36 = +HEAPF32[i3 + 52 >> 2];
  d43 = +HEAPF32[i3 + 56 >> 2];
  HEAPF32[i16 >> 2] = d75 + (d93 * d76 + d92 * d36 + d91 * d43);
  HEAPF32[i16 + 4 >> 2] = d38 + (d90 * d76 + d77 * d36 + d89 * d43);
  HEAPF32[i16 + 8 >> 2] = d42 + (d41 * d76 + d88 * d36 + d40 * d43);
  HEAPF32[i16 + 12 >> 2] = 0.0;
  d43 = +HEAPF32[i3 >> 2];
  d36 = +HEAPF32[i3 + 16 >> 2];
  d76 = +HEAPF32[i3 + 32 >> 2];
  d42 = +HEAPF32[i3 + 4 >> 2];
  d38 = +HEAPF32[i3 + 20 >> 2];
  d75 = +HEAPF32[i3 + 36 >> 2];
  d87 = +HEAPF32[i3 + 8 >> 2];
  d86 = +HEAPF32[i3 + 24 >> 2];
  d85 = +HEAPF32[i3 + 40 >> 2];
  HEAPF32[i17 >> 2] = d93 * d43 + d92 * d36 + d91 * d76;
  HEAPF32[i17 + 4 >> 2] = d93 * d42 + d92 * d38 + d91 * d75;
  HEAPF32[i17 + 8 >> 2] = d93 * d87 + d92 * d86 + d91 * d85;
  HEAPF32[i17 + 12 >> 2] = 0.0;
  HEAPF32[i17 + 16 >> 2] = d90 * d43 + d77 * d36 + d89 * d76;
  HEAPF32[i17 + 20 >> 2] = d90 * d42 + d77 * d38 + d89 * d75;
  HEAPF32[i17 + 24 >> 2] = d90 * d87 + d77 * d86 + d89 * d85;
  HEAPF32[i17 + 28 >> 2] = 0.0;
  HEAPF32[i17 + 32 >> 2] = d41 * d43 + d88 * d36 + d40 * d76;
  HEAPF32[i17 + 36 >> 2] = d41 * d42 + d88 * d38 + d40 * d75;
  HEAPF32[i17 + 40 >> 2] = d41 * d87 + d88 * d86 + d40 * d85;
  _memset(i17 + 44 | 0, 0, 20);
  __ZN28btTriangleConvexcastCallbackC2EPK13btConvexShapeRK11btTransformS5_S5_f(i18 | 0, i1, i2, i3, i6, +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i5 >> 2] | 0) + 44 >> 2] & 7](i5));
  HEAP32[i18 >> 2] = 1688;
  HEAP32[i18 + 212 >> 2] = i7;
  HEAP32[i18 + 216 >> 2] = i4;
  HEAP32[i18 + 220 >> 2] = i5;
  HEAPF32[i18 + 200 >> 2] = +HEAPF32[i7 + 4 >> 2];
  HEAPF32[i18 + 208 >> 2] = d8;
  FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i1 >> 2] | 0) + 8 >> 2] & 127](i1, i17, i19, i20);
  i17 = i18 | 0;
  __ZN22btBvhTriangleMeshShape17performConvexcastEP18btTriangleCallbackRK9btVector3S4_S4_S4_(i5, i17, i15, i16, i19, i20);
  __ZN18btTriangleCallbackD2Ev(i17);
  STACKTOP = i9;
  return;
 } else if ((i32 | 0) == 28) {
  HEAP32[i21 >> 2] = 2280;
  i32 = i21 + 164 | 0;
  HEAP32[i21 + 168 >> 2] = 0;
  HEAPF32[i21 + 172 >> 2] = d8;
  i17 = i7 + 4 | 0;
  HEAPF32[i32 >> 2] = +HEAPF32[i17 >> 2];
  __ZN27btContinuousConvexCollisionC2EPK13btConvexShapePK18btStaticPlaneShape(i22, i1, i5);
  i20 = i22 | 0;
  do {
   if (FUNCTION_TABLE_iiiiiii[HEAP32[(HEAP32[i22 >> 2] | 0) + 8 >> 2] & 7](i20, i2, i3, i6, i6, i21) | 0) {
    i19 = i21 + 132 | 0;
    i16 = i19 | 0;
    d85 = +HEAPF32[i16 >> 2];
    i15 = i21 + 136 | 0;
    d40 = +HEAPF32[i15 >> 2];
    i18 = i21 + 140 | 0;
    d86 = +HEAPF32[i18 >> 2];
    d88 = d85 * d85 + d40 * d40 + d86 * d86;
    if (d88 <= 9999999747378752.0e-20) {
     break;
    }
    d87 = +HEAPF32[i32 >> 2];
    if (d87 >= +HEAPF32[i17 >> 2]) {
     break;
    }
    d41 = 1.0 / +Math_sqrt(+d88);
    HEAPF32[i16 >> 2] = d85 * d41;
    HEAPF32[i15 >> 2] = d40 * d41;
    HEAPF32[i18 >> 2] = d86 * d41;
    HEAP32[i23 >> 2] = i4;
    HEAP32[i23 + 4 >> 2] = 0;
    i18 = i23 + 8 | 0;
    i15 = i19;
    HEAP32[i18 >> 2] = HEAP32[i15 >> 2];
    HEAP32[i18 + 4 >> 2] = HEAP32[i15 + 4 >> 2];
    HEAP32[i18 + 8 >> 2] = HEAP32[i15 + 8 >> 2];
    HEAP32[i18 + 12 >> 2] = HEAP32[i15 + 12 >> 2];
    i15 = i23 + 24 | 0;
    i18 = i21 + 148 | 0;
    HEAP32[i15 >> 2] = HEAP32[i18 >> 2];
    HEAP32[i15 + 4 >> 2] = HEAP32[i18 + 4 >> 2];
    HEAP32[i15 + 8 >> 2] = HEAP32[i18 + 8 >> 2];
    HEAP32[i15 + 12 >> 2] = HEAP32[i18 + 12 >> 2];
    HEAPF32[i23 + 40 >> 2] = d87;
    i18 = HEAP32[(HEAP32[i7 >> 2] | 0) + 12 >> 2] | 0;
    +FUNCTION_TABLE_fiii[i18 & 15](i7, i23, 1);
   }
  } while (0);
  __ZN12btConvexCastD2Ev(i20);
  STACKTOP = i9;
  return;
 } else {
  i20 = i5;
  d87 = +HEAPF32[i6 >> 2];
  d41 = +HEAPF32[i6 + 16 >> 2];
  d86 = +HEAPF32[i6 + 32 >> 2];
  d40 = +HEAPF32[i6 + 4 >> 2];
  d85 = +HEAPF32[i6 + 20 >> 2];
  d88 = +HEAPF32[i6 + 36 >> 2];
  d75 = +HEAPF32[i6 + 8 >> 2];
  d38 = +HEAPF32[i6 + 24 >> 2];
  d42 = +HEAPF32[i6 + 40 >> 2];
  d76 = -0.0 - +HEAPF32[i6 + 48 >> 2];
  d36 = -0.0 - +HEAPF32[i6 + 52 >> 2];
  d43 = -0.0 - +HEAPF32[i6 + 56 >> 2];
  d89 = d87 * d76 + d41 * d36 + d86 * d43;
  d77 = d40 * d76 + d85 * d36 + d88 * d43;
  d90 = d75 * d76 + d38 * d36 + d42 * d43;
  d43 = +HEAPF32[i2 + 48 >> 2];
  d36 = +HEAPF32[i2 + 52 >> 2];
  d76 = +HEAPF32[i2 + 56 >> 2];
  d91 = d89 + (d87 * d43 + d41 * d36 + d86 * d76);
  d92 = d77 + (d40 * d43 + d85 * d36 + d88 * d76);
  d93 = d90 + (d75 * d43 + d38 * d36 + d42 * d76);
  d76 = +HEAPF32[i3 + 48 >> 2];
  d36 = +HEAPF32[i3 + 52 >> 2];
  d43 = +HEAPF32[i3 + 56 >> 2];
  d84 = d89 + (d87 * d76 + d41 * d36 + d86 * d43);
  d89 = d77 + (d40 * d76 + d85 * d36 + d88 * d43);
  d77 = d90 + (d75 * d76 + d38 * d36 + d42 * d43);
  d43 = +HEAPF32[i3 >> 2];
  d36 = +HEAPF32[i3 + 16 >> 2];
  d76 = +HEAPF32[i3 + 32 >> 2];
  d90 = +HEAPF32[i3 + 4 >> 2];
  d83 = +HEAPF32[i3 + 20 >> 2];
  d82 = +HEAPF32[i3 + 36 >> 2];
  d80 = +HEAPF32[i3 + 8 >> 2];
  d79 = +HEAPF32[i3 + 24 >> 2];
  d78 = +HEAPF32[i3 + 40 >> 2];
  HEAPF32[i24 >> 2] = d87 * d43 + d41 * d36 + d86 * d76;
  HEAPF32[i24 + 4 >> 2] = d87 * d90 + d41 * d83 + d86 * d82;
  HEAPF32[i24 + 8 >> 2] = d87 * d80 + d41 * d79 + d86 * d78;
  HEAPF32[i24 + 12 >> 2] = 0.0;
  HEAPF32[i24 + 16 >> 2] = d40 * d43 + d85 * d36 + d88 * d76;
  HEAPF32[i24 + 20 >> 2] = d40 * d90 + d85 * d83 + d88 * d82;
  HEAPF32[i24 + 24 >> 2] = d40 * d80 + d85 * d79 + d88 * d78;
  HEAPF32[i24 + 28 >> 2] = 0.0;
  HEAPF32[i24 + 32 >> 2] = d75 * d43 + d38 * d36 + d42 * d76;
  HEAPF32[i24 + 36 >> 2] = d75 * d90 + d38 * d83 + d42 * d82;
  HEAPF32[i24 + 40 >> 2] = d75 * d80 + d38 * d79 + d42 * d78;
  _memset(i24 + 44 | 0, 0, 20);
  __ZN28btTriangleConvexcastCallbackC2EPK13btConvexShapeRK11btTransformS5_S5_f(i25 | 0, i1, i2, i3, i6, +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i5 >> 2] | 0) + 44 >> 2] & 7](i20));
  HEAP32[i25 >> 2] = 1656;
  HEAP32[i25 + 212 >> 2] = i7;
  HEAP32[i25 + 216 >> 2] = i4;
  HEAP32[i25 + 220 >> 2] = i20;
  HEAPF32[i25 + 200 >> 2] = +HEAPF32[i7 + 4 >> 2];
  HEAPF32[i25 + 208 >> 2] = d8;
  FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i1 >> 2] | 0) + 8 >> 2] & 127](i1, i24, i26, i27);
  i24 = i28 | 0;
  HEAPF32[i24 >> 2] = d91;
  i1 = i28 + 4 | 0;
  HEAPF32[i1 >> 2] = d92;
  i7 = i28 + 8 | 0;
  HEAPF32[i7 >> 2] = d93;
  HEAPF32[i28 + 12 >> 2] = 0.0;
  if (d84 < d91) {
   HEAPF32[i24 >> 2] = d84;
   d94 = d84;
  } else {
   d94 = d91;
  }
  if (d89 < d92) {
   HEAPF32[i1 >> 2] = d89;
   d95 = d89;
  } else {
   d95 = d92;
  }
  if (d77 < d93) {
   HEAPF32[i7 >> 2] = d77;
   d96 = d77;
  } else {
   d96 = d93;
  }
  i4 = i29 | 0;
  HEAPF32[i4 >> 2] = d91;
  i6 = i29 + 4 | 0;
  HEAPF32[i6 >> 2] = d92;
  i3 = i29 + 8 | 0;
  HEAPF32[i3 >> 2] = d93;
  HEAPF32[i29 + 12 >> 2] = 0.0;
  if (d91 < d84) {
   HEAPF32[i4 >> 2] = d84;
   d97 = d84;
  } else {
   d97 = d91;
  }
  if (d92 < d89) {
   HEAPF32[i6 >> 2] = d89;
   d98 = d89;
  } else {
   d98 = d92;
  }
  if (d93 < d77) {
   HEAPF32[i3 >> 2] = d77;
   d99 = d77;
  } else {
   d99 = d93;
  }
  HEAPF32[i24 >> 2] = d94 + +HEAPF32[i26 >> 2];
  HEAPF32[i1 >> 2] = d95 + +HEAPF32[i26 + 4 >> 2];
  HEAPF32[i7 >> 2] = d96 + +HEAPF32[i26 + 8 >> 2];
  HEAPF32[i4 >> 2] = d97 + +HEAPF32[i27 >> 2];
  HEAPF32[i6 >> 2] = d98 + +HEAPF32[i27 + 4 >> 2];
  HEAPF32[i3 >> 2] = d99 + +HEAPF32[i27 + 8 >> 2];
  i27 = i25 | 0;
  FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i5 >> 2] | 0) + 60 >> 2] & 127](i20, i27, i28, i29);
  __ZN18btTriangleCallbackD2Ev(i27);
  STACKTOP = i9;
  return;
 }
}
function __ZN35btSequentialImpulseConstraintSolver28solveGroupCacheFriendlySetupEPP17btCollisionObjectiPP20btPersistentManifoldiPP17btTypedConstraintiRK19btContactSolverInfoP12btIDebugDrawP12btStackAlloc(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 i7 = i7 | 0;
 i8 = i8 | 0;
 i9 = i9 | 0;
 i10 = i10 | 0;
 var i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, d46 = 0.0, d47 = 0.0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0, i62 = 0, i63 = 0, i64 = 0, i65 = 0, i66 = 0, i67 = 0, i68 = 0, i69 = 0, i70 = 0, i71 = 0, i72 = 0, i73 = 0, i74 = 0, i75 = 0, i76 = 0, i77 = 0, i78 = 0, i79 = 0, i80 = 0, d81 = 0.0, d82 = 0.0, d83 = 0.0, d84 = 0.0, d85 = 0.0, d86 = 0.0, d87 = 0.0, d88 = 0.0, d89 = 0.0, d90 = 0.0, d91 = 0.0, i92 = 0, i93 = 0, i94 = 0, i95 = 0, i96 = 0, i97 = 0;
 i10 = STACKTOP;
 STACKTOP = STACKTOP + 192 | 0;
 i9 = i10 | 0;
 i11 = i10 + 136 | 0;
 __ZN15CProfileManager13Start_ProfileEPKc(408);
 if ((i7 | 0) == (-i5 | 0)) {
  __ZN15CProfileManager12Stop_ProfileEv();
  STACKTOP = i10;
  return +0.0;
 }
 i12 = (i3 | 0) > 0;
 do {
  if ((HEAP32[i8 + 44 >> 2] | 0) == 0) {
   if (i12) {
    i13 = 0;
   } else {
    break;
   }
   do {
    i14 = HEAP32[i2 + (i13 << 2) >> 2] | 0;
    if (!((HEAP32[i14 + 232 >> 2] & 2 | 0) == 0 | (i14 | 0) == 0)) {
     _memset(i14 + 504 | 0, 0, 32);
    }
    i13 = i13 + 1 | 0;
   } while ((i13 | 0) < (i3 | 0));
  } else {
   if (i12) {
    i15 = 0;
   } else {
    break;
   }
   do {
    i14 = HEAP32[i2 + (i15 << 2) >> 2] | 0;
    if (!((HEAP32[i14 + 232 >> 2] & 2 | 0) == 0 | (i14 | 0) == 0)) {
     _memset(i14 + 504 | 0, 0, 32);
     _memset(i14 + 568 | 0, 0, 32);
    }
    i15 = i15 + 1 | 0;
   } while ((i15 | 0) < (i3 | 0));
  }
 } while (0);
 i3 = (i7 | 0) > 0;
 if (i3) {
  i15 = 0;
  do {
   i2 = HEAP32[i6 + (i15 << 2) >> 2] | 0;
   FUNCTION_TABLE_vi[HEAP32[(HEAP32[i2 >> 2] | 0) + 8 >> 2] & 511](i2);
   HEAPF32[i2 + 32 >> 2] = 0.0;
   i15 = i15 + 1 | 0;
  } while ((i15 | 0) < (i7 | 0));
 }
 i15 = i1 + 108 | 0;
 i2 = HEAP32[i15 >> 2] | 0;
 if ((i2 | 0) < (i7 | 0)) {
  i12 = i1 + 112 | 0;
  if ((HEAP32[i12 >> 2] | 0) < (i7 | 0)) {
   if ((i7 | 0) == 0) {
    i16 = 0;
    i17 = i2;
   } else {
    i13 = __Z22btAlignedAllocInternalji(i7 << 3, 16) | 0;
    i16 = i13;
    i17 = HEAP32[i15 >> 2] | 0;
   }
   i13 = i1 + 116 | 0;
   if ((i17 | 0) > 0) {
    i14 = 0;
    do {
     i18 = i16 + (i14 << 3) | 0;
     if ((i18 | 0) != 0) {
      i19 = (HEAP32[i13 >> 2] | 0) + (i14 << 3) | 0;
      i20 = i18;
      i18 = HEAP32[i19 + 4 >> 2] | 0;
      HEAP32[i20 >> 2] = HEAP32[i19 >> 2];
      HEAP32[i20 + 4 >> 2] = i18;
     }
     i14 = i14 + 1 | 0;
    } while ((i14 | 0) < (i17 | 0));
   }
   i17 = HEAP32[i13 >> 2] | 0;
   i14 = i1 + 120 | 0;
   if ((i17 | 0) != 0) {
    if ((HEAP8[i14] | 0) != 0) {
     __Z21btAlignedFreeInternalPv(i17);
    }
    HEAP32[i13 >> 2] = 0;
   }
   HEAP8[i14] = 1;
   HEAP32[i13 >> 2] = i16;
   HEAP32[i12 >> 2] = i7;
   i21 = i13;
  } else {
   i21 = i1 + 116 | 0;
  }
  i13 = i2;
  do {
   i2 = (HEAP32[i21 >> 2] | 0) + (i13 << 3) | 0;
   if ((i2 | 0) != 0) {
    i12 = i2;
    HEAP32[i12 >> 2] = 0;
    HEAP32[i12 + 4 >> 2] = 0;
   }
   i13 = i13 + 1 | 0;
  } while ((i13 | 0) < (i7 | 0));
 }
 HEAP32[i15 >> 2] = i7;
 if (i3) {
  i15 = i1 + 116 | 0;
  i13 = 0;
  i21 = 0;
  while (1) {
   i12 = HEAP32[i15 >> 2] | 0;
   i2 = i12 + (i13 << 3) | 0;
   i16 = HEAP32[i6 + (i13 << 2) >> 2] | 0;
   if ((HEAP8[i16 + 20 | 0] | 0) == 0) {
    HEAP32[i2 >> 2] = 0;
    HEAP32[i12 + (i13 << 3) + 4 >> 2] = 0;
    i22 = 0;
   } else {
    FUNCTION_TABLE_vii[HEAP32[(HEAP32[i16 >> 2] | 0) + 16 >> 2] & 127](i16, i2);
    i22 = HEAP32[i2 >> 2] | 0;
   }
   i2 = i22 + i21 | 0;
   i16 = i13 + 1 | 0;
   if ((i16 | 0) < (i7 | 0)) {
    i13 = i16;
    i21 = i2;
   } else {
    i23 = i2;
    break;
   }
  }
 } else {
  i23 = 0;
 }
 i21 = i9;
 _memset(i21 | 0, 0, 136);
 i9 = i1 + 28 | 0;
 i13 = HEAP32[i9 >> 2] | 0;
 if ((i13 | 0) < (i23 | 0)) {
  i22 = i1 + 32 | 0;
  if ((HEAP32[i22 >> 2] | 0) < (i23 | 0)) {
   if ((i23 | 0) == 0) {
    i24 = 0;
    i25 = i13;
   } else {
    i15 = __Z22btAlignedAllocInternalji(i23 * 136 | 0, 16) | 0;
    i24 = i15;
    i25 = HEAP32[i9 >> 2] | 0;
   }
   i15 = i1 + 36 | 0;
   if ((i25 | 0) > 0) {
    i2 = 0;
    do {
     i16 = i24 + (i2 * 136 | 0) | 0;
     i12 = (HEAP32[i15 >> 2] | 0) + (i2 * 136 | 0) | 0;
     _memcpy(i16 | 0, i12 | 0, 136) | 0;
     i2 = i2 + 1 | 0;
    } while ((i2 | 0) < (i25 | 0));
   }
   i25 = HEAP32[i15 >> 2] | 0;
   i2 = i1 + 40 | 0;
   if ((i25 | 0) != 0) {
    if ((HEAP8[i2] | 0) != 0) {
     __Z21btAlignedFreeInternalPv(i25);
    }
    HEAP32[i15 >> 2] = 0;
   }
   HEAP8[i2] = 1;
   HEAP32[i15 >> 2] = i24;
   HEAP32[i22 >> 2] = i23;
   i26 = i15;
  } else {
   i26 = i1 + 36 | 0;
  }
  i15 = i13;
  do {
   i13 = (HEAP32[i26 >> 2] | 0) + (i15 * 136 | 0) | 0;
   _memcpy(i13 | 0, i21 | 0, 136) | 0;
   i15 = i15 + 1 | 0;
  } while ((i15 | 0) < (i23 | 0));
 }
 HEAP32[i9 >> 2] = i23;
 if (i3) {
  i3 = i1 + 116 | 0;
  i23 = i1 + 36 | 0;
  i9 = i8 + 12 | 0;
  i15 = i11 | 0;
  i21 = i8 + 32 | 0;
  i26 = i11 + 4 | 0;
  i13 = i11 + 8 | 0;
  i22 = i11 + 12 | 0;
  i24 = i11 + 16 | 0;
  i2 = i11 + 20 | 0;
  i25 = i11 + 24 | 0;
  i12 = i11 + 28 | 0;
  i16 = i8 + 40 | 0;
  i14 = i8 + 4 | 0;
  i17 = i11 + 52 | 0;
  i18 = i11 + 32 | 0;
  i20 = i11 + 36 | 0;
  i19 = i11 + 40 | 0;
  i27 = i8 + 20 | 0;
  i28 = i11 + 48 | 0;
  i29 = 0;
  i30 = 0;
  i31 = HEAP32[i3 >> 2] | 0;
  while (1) {
   i32 = i31 + (i30 << 3) | 0;
   i33 = HEAP32[i32 >> 2] | 0;
   if ((i33 | 0) == 0) {
    i34 = i31;
    i35 = 0;
   } else {
    i36 = HEAP32[i23 >> 2] | 0;
    i37 = i6 + (i30 << 2) | 0;
    i38 = HEAP32[i37 >> 2] | 0;
    i39 = i38 + 24 | 0;
    i40 = HEAP32[i39 >> 2] | 0;
    i41 = i38 + 28 | 0;
    i42 = HEAP32[i41 >> 2] | 0;
    if ((i33 | 0) > 0) {
     i33 = 0;
     do {
      i43 = i33 + i29 | 0;
      _memset(i36 + (i43 * 136 | 0) | 0, 0, 136);
      HEAPF32[i36 + (i43 * 136 | 0) + 124 >> 2] = -3.4028234663852886e+38;
      HEAPF32[i36 + (i43 * 136 | 0) + 128 >> 2] = 3.4028234663852886e+38;
      HEAPF32[i36 + (i43 * 136 | 0) + 84 >> 2] = 0.0;
      HEAPF32[i36 + (i43 * 136 | 0) + 80 >> 2] = 0.0;
      HEAP32[i36 + (i43 * 136 | 0) + 104 >> 2] = i40;
      HEAP32[i36 + (i43 * 136 | 0) + 108 >> 2] = i42;
      i33 = i33 + 1 | 0;
     } while ((i33 | 0) < (HEAP32[i32 >> 2] | 0));
     i44 = HEAP32[i37 >> 2] | 0;
    } else {
     i44 = i38;
    }
    _memset(i40 + 504 | 0, 0, 32);
    _memset(i42 + 504 | 0, 0, 32);
    HEAPF32[i15 >> 2] = 1.0 / +HEAPF32[i9 >> 2];
    HEAPF32[i26 >> 2] = +HEAPF32[i21 >> 2];
    HEAP32[i13 >> 2] = i36 + (i29 * 136 | 0) + 16;
    HEAP32[i22 >> 2] = i36 + (i29 * 136 | 0);
    HEAP32[i24 >> 2] = 0;
    HEAP32[i2 >> 2] = i36 + (i29 * 136 | 0) + 32;
    HEAP32[i25 >> 2] = 34;
    HEAP32[i12 >> 2] = i36 + (i29 * 136 | 0) + 116;
    i33 = i36 + (i29 * 136 | 0) + 120 | 0;
    HEAPF32[i33 >> 2] = +HEAPF32[i16 >> 2];
    HEAPF32[i17 >> 2] = +HEAPF32[i14 >> 2];
    HEAP32[i18 >> 2] = i33;
    i33 = i36 + (i29 * 136 | 0) + 124 | 0;
    HEAP32[i20 >> 2] = i33;
    i43 = i36 + (i29 * 136 | 0) + 128 | 0;
    HEAP32[i19 >> 2] = i43;
    HEAP32[i28 >> 2] = HEAP32[i27 >> 2];
    FUNCTION_TABLE_vii[HEAP32[(HEAP32[i44 >> 2] | 0) + 20 >> 2] & 127](i44, i11);
    i45 = (HEAP32[i37 >> 2] | 0) + 16 | 0;
    d46 = +HEAPF32[i45 >> 2];
    if (+HEAPF32[i43 >> 2] > d46) {
     HEAPF32[i43 >> 2] = d46;
     d47 = +HEAPF32[i45 >> 2];
    } else {
     d47 = d46;
    }
    d46 = -0.0 - d47;
    if (+HEAPF32[i33 >> 2] < d46) {
     HEAPF32[i33 >> 2] = d46;
    }
    if ((HEAP32[i32 >> 2] | 0) > 0) {
     i33 = i38;
     i45 = i40 + 336 | 0;
     i43 = i40 + 256 | 0;
     i48 = i40 + 260 | 0;
     i49 = i40 + 264 | 0;
     i50 = i40 + 272 | 0;
     i51 = i40 + 276 | 0;
     i52 = i40 + 280 | 0;
     i53 = i40 + 288 | 0;
     i54 = i40 + 292 | 0;
     i55 = i40 + 296 | 0;
     i56 = i42 + 336 | 0;
     i57 = i42 + 256 | 0;
     i58 = i42 + 260 | 0;
     i59 = i42 + 264 | 0;
     i60 = i42 + 272 | 0;
     i61 = i42 + 276 | 0;
     i62 = i42 + 280 | 0;
     i63 = i42 + 288 | 0;
     i64 = i42 + 292 | 0;
     i65 = i42 + 296 | 0;
     i66 = i40 + 304 | 0;
     i67 = i40 + 308 | 0;
     i68 = i40 + 312 | 0;
     i69 = i40 + 320 | 0;
     i70 = i40 + 324 | 0;
     i71 = i40 + 328 | 0;
     i72 = i42 + 304 | 0;
     i73 = i42 + 308 | 0;
     i74 = i42 + 312 | 0;
     i75 = i42 + 320 | 0;
     i76 = i42 + 324 | 0;
     i77 = i42 + 328 | 0;
     i78 = 0;
     do {
      i79 = i78 + i29 | 0;
      HEAP32[i36 + (i79 * 136 | 0) + 112 >> 2] = i33;
      i80 = HEAP32[i39 >> 2] | 0;
      d46 = +HEAPF32[i36 + (i79 * 136 | 0) >> 2];
      d81 = +HEAPF32[i36 + (i79 * 136 | 0) + 4 >> 2];
      d82 = +HEAPF32[i36 + (i79 * 136 | 0) + 8 >> 2];
      d83 = (d46 * +HEAPF32[i80 + 272 >> 2] + d81 * +HEAPF32[i80 + 276 >> 2] + d82 * +HEAPF32[i80 + 280 >> 2]) * +HEAPF32[i80 + 540 >> 2];
      d84 = (d46 * +HEAPF32[i80 + 288 >> 2] + d81 * +HEAPF32[i80 + 292 >> 2] + d82 * +HEAPF32[i80 + 296 >> 2]) * +HEAPF32[i80 + 544 >> 2];
      HEAPF32[i36 + (i79 * 136 | 0) + 48 >> 2] = (+HEAPF32[i80 + 256 >> 2] * d46 + +HEAPF32[i80 + 260 >> 2] * d81 + +HEAPF32[i80 + 264 >> 2] * d82) * +HEAPF32[i80 + 536 >> 2];
      HEAPF32[i36 + (i79 * 136 | 0) + 52 >> 2] = d83;
      HEAPF32[i36 + (i79 * 136 | 0) + 56 >> 2] = d84;
      HEAPF32[i36 + (i79 * 136 | 0) + 60 >> 2] = 0.0;
      i80 = HEAP32[i41 >> 2] | 0;
      d84 = +HEAPF32[i36 + (i79 * 136 | 0) + 32 >> 2];
      d83 = +HEAPF32[i36 + (i79 * 136 | 0) + 36 >> 2];
      d85 = +HEAPF32[i36 + (i79 * 136 | 0) + 40 >> 2];
      d86 = (d84 * +HEAPF32[i80 + 272 >> 2] + d83 * +HEAPF32[i80 + 276 >> 2] + d85 * +HEAPF32[i80 + 280 >> 2]) * +HEAPF32[i80 + 540 >> 2];
      d87 = (d84 * +HEAPF32[i80 + 288 >> 2] + d83 * +HEAPF32[i80 + 292 >> 2] + d85 * +HEAPF32[i80 + 296 >> 2]) * +HEAPF32[i80 + 544 >> 2];
      HEAPF32[i36 + (i79 * 136 | 0) + 64 >> 2] = (+HEAPF32[i80 + 256 >> 2] * d84 + +HEAPF32[i80 + 260 >> 2] * d83 + +HEAPF32[i80 + 264 >> 2] * d85) * +HEAPF32[i80 + 536 >> 2];
      HEAPF32[i36 + (i79 * 136 | 0) + 68 >> 2] = d86;
      HEAPF32[i36 + (i79 * 136 | 0) + 72 >> 2] = d87;
      HEAPF32[i36 + (i79 * 136 | 0) + 76 >> 2] = 0.0;
      d87 = +HEAPF32[i45 >> 2];
      d86 = +HEAPF32[i36 + (i79 * 136 | 0) + 16 >> 2];
      d88 = +HEAPF32[i36 + (i79 * 136 | 0) + 20 >> 2];
      d89 = +HEAPF32[i36 + (i79 * 136 | 0) + 24 >> 2];
      d90 = +HEAPF32[i56 >> 2];
      d91 = 1.0 / (d86 * d87 * d86 + d88 * d87 * d88 + d89 * d87 * d89 + (d46 * (d46 * +HEAPF32[i43 >> 2] + d81 * +HEAPF32[i48 >> 2] + d82 * +HEAPF32[i49 >> 2]) + d81 * (d46 * +HEAPF32[i50 >> 2] + d81 * +HEAPF32[i51 >> 2] + d82 * +HEAPF32[i52 >> 2]) + d82 * (d46 * +HEAPF32[i53 >> 2] + d81 * +HEAPF32[i54 >> 2] + d82 * +HEAPF32[i55 >> 2])) + (d89 * d89 * d90 + (d86 * d86 * d90 + d88 * d88 * d90)) + (d84 * (d84 * +HEAPF32[i57 >> 2] + d83 * +HEAPF32[i58 >> 2] + d85 * +HEAPF32[i59 >> 2]) + d83 * (d84 * +HEAPF32[i60 >> 2] + d83 * +HEAPF32[i61 >> 2] + d85 * +HEAPF32[i62 >> 2]) + d85 * (d84 * +HEAPF32[i63 >> 2] + d83 * +HEAPF32[i64 >> 2] + d85 * +HEAPF32[i65 >> 2])));
      HEAPF32[i36 + (i79 * 136 | 0) + 92 >> 2] = d91;
      i80 = i36 + (i79 * 136 | 0) + 116 | 0;
      HEAPF32[i80 >> 2] = d91 * +HEAPF32[i80 >> 2] + d91 * (0.0 - +HEAPF32[i17 >> 2] * (d86 * +HEAPF32[i66 >> 2] + d88 * +HEAPF32[i67 >> 2] + d89 * +HEAPF32[i68 >> 2] + (d46 * +HEAPF32[i69 >> 2] + d81 * +HEAPF32[i70 >> 2] + d82 * +HEAPF32[i71 >> 2]) + (d84 * +HEAPF32[i75 >> 2] + d83 * +HEAPF32[i76 >> 2] + d85 * +HEAPF32[i77 >> 2] - (d86 * +HEAPF32[i72 >> 2] + d88 * +HEAPF32[i73 >> 2] + d89 * +HEAPF32[i74 >> 2]))));
      HEAPF32[i36 + (i79 * 136 | 0) + 84 >> 2] = 0.0;
      i78 = i78 + 1 | 0;
     } while ((i78 | 0) < (HEAP32[i32 >> 2] | 0));
    }
    i32 = HEAP32[i3 >> 2] | 0;
    i34 = i32;
    i35 = HEAP32[i32 + (i30 << 3) >> 2] | 0;
   }
   i32 = i30 + 1 | 0;
   if ((i32 | 0) < (i7 | 0)) {
    i29 = i35 + i29 | 0;
    i30 = i32;
    i31 = i34;
   } else {
    break;
   }
  }
 }
 if ((i5 | 0) > 0) {
  i34 = 0;
  do {
   __ZN35btSequentialImpulseConstraintSolver14convertContactEP20btPersistentManifoldRK19btContactSolverInfo(i1, HEAP32[i4 + (i34 << 2) >> 2] | 0, i8);
   i34 = i34 + 1 | 0;
  } while ((i34 | 0) < (i5 | 0));
 }
 i5 = HEAP32[i1 + 8 >> 2] | 0;
 i34 = HEAP32[i1 + 48 >> 2] | 0;
 i8 = i1 + 68 | 0;
 i4 = HEAP32[i8 >> 2] | 0;
 if ((i4 | 0) < (i5 | 0)) {
  i31 = i1 + 72 | 0;
  if ((HEAP32[i31 >> 2] | 0) < (i5 | 0)) {
   if ((i5 | 0) == 0) {
    i92 = 0;
    i93 = i4;
   } else {
    i30 = __Z22btAlignedAllocInternalji(i5 << 2, 16) | 0;
    i92 = i30;
    i93 = HEAP32[i8 >> 2] | 0;
   }
   i30 = i1 + 76 | 0;
   if ((i93 | 0) > 0) {
    i29 = 0;
    do {
     i35 = i92 + (i29 << 2) | 0;
     if ((i35 | 0) != 0) {
      HEAP32[i35 >> 2] = HEAP32[(HEAP32[i30 >> 2] | 0) + (i29 << 2) >> 2];
     }
     i29 = i29 + 1 | 0;
    } while ((i29 | 0) < (i93 | 0));
   }
   i93 = HEAP32[i30 >> 2] | 0;
   i29 = i1 + 80 | 0;
   if ((i93 | 0) != 0) {
    if ((HEAP8[i29] | 0) != 0) {
     __Z21btAlignedFreeInternalPv(i93);
    }
    HEAP32[i30 >> 2] = 0;
   }
   HEAP8[i29] = 1;
   HEAP32[i30 >> 2] = i92;
   HEAP32[i31 >> 2] = i5;
   i94 = i92;
  } else {
   i94 = HEAP32[i1 + 76 >> 2] | 0;
  }
  i92 = i4;
  do {
   i4 = i94 + (i92 << 2) | 0;
   if ((i4 | 0) != 0) {
    HEAP32[i4 >> 2] = 0;
   }
   i92 = i92 + 1 | 0;
  } while ((i92 | 0) < (i5 | 0));
 }
 HEAP32[i8 >> 2] = i5;
 i8 = i1 + 88 | 0;
 i92 = HEAP32[i8 >> 2] | 0;
 if ((i92 | 0) < (i34 | 0)) {
  i94 = i1 + 92 | 0;
  if ((HEAP32[i94 >> 2] | 0) < (i34 | 0)) {
   if ((i34 | 0) == 0) {
    i95 = 0;
    i96 = i92;
   } else {
    i4 = __Z22btAlignedAllocInternalji(i34 << 2, 16) | 0;
    i95 = i4;
    i96 = HEAP32[i8 >> 2] | 0;
   }
   i4 = i1 + 96 | 0;
   if ((i96 | 0) > 0) {
    i31 = 0;
    do {
     i30 = i95 + (i31 << 2) | 0;
     if ((i30 | 0) != 0) {
      HEAP32[i30 >> 2] = HEAP32[(HEAP32[i4 >> 2] | 0) + (i31 << 2) >> 2];
     }
     i31 = i31 + 1 | 0;
    } while ((i31 | 0) < (i96 | 0));
   }
   i96 = HEAP32[i4 >> 2] | 0;
   i31 = i1 + 100 | 0;
   if ((i96 | 0) != 0) {
    if ((HEAP8[i31] | 0) != 0) {
     __Z21btAlignedFreeInternalPv(i96);
    }
    HEAP32[i4 >> 2] = 0;
   }
   HEAP8[i31] = 1;
   HEAP32[i4 >> 2] = i95;
   HEAP32[i94 >> 2] = i34;
   i97 = i95;
  } else {
   i97 = HEAP32[i1 + 96 >> 2] | 0;
  }
  i95 = i92;
  do {
   i92 = i97 + (i95 << 2) | 0;
   if ((i92 | 0) != 0) {
    HEAP32[i92 >> 2] = 0;
   }
   i95 = i95 + 1 | 0;
  } while ((i95 | 0) < (i34 | 0));
 }
 HEAP32[i8 >> 2] = i34;
 if ((i5 | 0) > 0) {
  i8 = HEAP32[i1 + 76 >> 2] | 0;
  i95 = 0;
  do {
   HEAP32[i8 + (i95 << 2) >> 2] = i95;
   i95 = i95 + 1 | 0;
  } while ((i95 | 0) < (i5 | 0));
 }
 if ((i34 | 0) <= 0) {
  __ZN15CProfileManager12Stop_ProfileEv();
  STACKTOP = i10;
  return +0.0;
 }
 i5 = HEAP32[i1 + 96 >> 2] | 0;
 i1 = 0;
 do {
  HEAP32[i5 + (i1 << 2) >> 2] = i1;
  i1 = i1 + 1 | 0;
 } while ((i1 | 0) < (i34 | 0));
 __ZN15CProfileManager12Stop_ProfileEv();
 STACKTOP = i10;
 return +0.0;
}
function __ZN33btMinkowskiPenetrationDepthSolver12calcPenDepthER22btVoronoiSimplexSolverPK13btConvexShapeS4_RK11btTransformS7_R9btVector3S9_S9_P12btIDebugDrawP12btStackAlloc(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 i7 = i7 | 0;
 i8 = i8 | 0;
 i9 = i9 | 0;
 i10 = i10 | 0;
 i11 = i11 | 0;
 var i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, d42 = 0.0, d43 = 0.0, d44 = 0.0, d45 = 0.0, d46 = 0.0, d47 = 0.0, d48 = 0.0, d49 = 0.0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0, i62 = 0, d63 = 0.0, d64 = 0.0, d65 = 0.0, d66 = 0.0, d67 = 0.0, d68 = 0.0, d69 = 0.0, d70 = 0.0, d71 = 0.0, d72 = 0.0, d73 = 0.0, d74 = 0.0, d75 = 0.0, d76 = 0.0, d77 = 0.0, d78 = 0.0, d79 = 0.0, d80 = 0.0, d81 = 0.0, d82 = 0.0, i83 = 0;
 i11 = STACKTOP;
 STACKTOP = STACKTOP + 4264 | 0;
 i1 = i11 | 0;
 i12 = i11 + 992 | 0;
 i13 = i11 + 1984 | 0;
 i14 = i11 + 2976 | 0;
 i15 = i11 + 3968 | 0;
 i16 = i11 + 3984 | 0;
 i17 = i11 + 4e3 | 0;
 i18 = i11 + 4080 | 0;
 i19 = i11 + 4216 | 0;
 if (((HEAP32[i3 + 4 >> 2] | 0) - 17 | 0) >>> 0 < 2) {
  i20 = ((HEAP32[i4 + 4 >> 2] | 0) - 17 | 0) >>> 0 < 2;
 } else {
  i20 = 0;
 }
 i21 = i1 | 0;
 i22 = i13 | 0;
 i23 = i5 | 0;
 i24 = i5 + 16 | 0;
 i25 = i5 + 32 | 0;
 i26 = i5 + 4 | 0;
 i27 = i5 + 20 | 0;
 i28 = i5 + 36 | 0;
 i29 = i5 + 8 | 0;
 i30 = i5 + 24 | 0;
 i31 = i5 + 40 | 0;
 i32 = i6 | 0;
 i33 = i6 + 16 | 0;
 i34 = i6 + 32 | 0;
 i35 = i6 + 4 | 0;
 i36 = i6 + 20 | 0;
 i37 = i6 + 36 | 0;
 i38 = i6 + 8 | 0;
 i39 = i6 + 24 | 0;
 i40 = i6 + 40 | 0;
 i41 = 0;
 do {
  __ZN33btMinkowskiPenetrationDepthSolver24getPenetrationDirectionsEv() | 0;
  d42 = +HEAPF32[13144 + (i41 << 4) >> 2];
  d43 = +HEAPF32[13148 + (i41 << 4) >> 2];
  d44 = +HEAPF32[13152 + (i41 << 4) >> 2];
  d45 = -0.0 - d42;
  d46 = -0.0 - d43;
  d47 = -0.0 - d44;
  d48 = +HEAPF32[i26 >> 2] * d45 + +HEAPF32[i27 >> 2] * d46 + +HEAPF32[i28 >> 2] * d47;
  d49 = +HEAPF32[i29 >> 2] * d45 + +HEAPF32[i30 >> 2] * d46 + +HEAPF32[i31 >> 2] * d47;
  HEAPF32[i13 + (i41 << 4) >> 2] = +HEAPF32[i23 >> 2] * d45 + +HEAPF32[i24 >> 2] * d46 + +HEAPF32[i25 >> 2] * d47;
  HEAPF32[i13 + (i41 << 4) + 4 >> 2] = d48;
  HEAPF32[i13 + (i41 << 4) + 8 >> 2] = d49;
  HEAPF32[i13 + (i41 << 4) + 12 >> 2] = 0.0;
  d49 = d42 * +HEAPF32[i35 >> 2] + d43 * +HEAPF32[i36 >> 2] + d44 * +HEAPF32[i37 >> 2];
  d48 = d42 * +HEAPF32[i38 >> 2] + d43 * +HEAPF32[i39 >> 2] + d44 * +HEAPF32[i40 >> 2];
  HEAPF32[i14 + (i41 << 4) >> 2] = d42 * +HEAPF32[i32 >> 2] + d43 * +HEAPF32[i33 >> 2] + d44 * +HEAPF32[i34 >> 2];
  HEAPF32[i14 + (i41 << 4) + 4 >> 2] = d49;
  HEAPF32[i14 + (i41 << 4) + 8 >> 2] = d48;
  HEAPF32[i14 + (i41 << 4) + 12 >> 2] = 0.0;
  i41 = i41 + 1 | 0;
 } while ((i41 | 0) < 42);
 i41 = i12 | 0;
 i50 = i14 | 0;
 i51 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i3 >> 2] | 0) + 76 >> 2] & 127](i3) | 0;
 if ((i51 | 0) > 0) {
  i52 = i3;
  i53 = i15 | 0;
  i54 = i15 + 4 | 0;
  i55 = i15 + 8 | 0;
  i56 = i15;
  i57 = i15 + 12 | 0;
  i58 = 0;
  i59 = 42;
  while (1) {
   FUNCTION_TABLE_viii[HEAP32[(HEAP32[i52 >> 2] | 0) + 80 >> 2] & 127](i3, i58, i15);
   d48 = +HEAPF32[i53 >> 2];
   d49 = +HEAPF32[i54 >> 2];
   d44 = +HEAPF32[i55 >> 2];
   d43 = d48 * +HEAPF32[i24 >> 2] + d49 * +HEAPF32[i27 >> 2] + d44 * +HEAPF32[i30 >> 2];
   d42 = d48 * +HEAPF32[i25 >> 2] + d49 * +HEAPF32[i28 >> 2] + d44 * +HEAPF32[i31 >> 2];
   HEAPF32[i53 >> 2] = +HEAPF32[i23 >> 2] * d48 + +HEAPF32[i26 >> 2] * d49 + +HEAPF32[i29 >> 2] * d44;
   HEAPF32[i54 >> 2] = d43;
   HEAPF32[i55 >> 2] = d42;
   HEAPF32[i57 >> 2] = 0.0;
   __ZN33btMinkowskiPenetrationDepthSolver24getPenetrationDirectionsEv() | 0;
   i60 = 13144 + (i59 << 4) | 0;
   HEAP32[i60 >> 2] = HEAP32[i56 >> 2];
   HEAP32[i60 + 4 >> 2] = HEAP32[i56 + 4 >> 2];
   HEAP32[i60 + 8 >> 2] = HEAP32[i56 + 8 >> 2];
   HEAP32[i60 + 12 >> 2] = HEAP32[i56 + 12 >> 2];
   d42 = +HEAPF32[i53 >> 2];
   d43 = -0.0 - d42;
   d44 = +HEAPF32[i54 >> 2];
   d49 = -0.0 - d44;
   d48 = +HEAPF32[i55 >> 2];
   d47 = -0.0 - d48;
   d46 = +HEAPF32[i26 >> 2] * d43 + +HEAPF32[i27 >> 2] * d49 + +HEAPF32[i28 >> 2] * d47;
   d45 = +HEAPF32[i29 >> 2] * d43 + +HEAPF32[i30 >> 2] * d49 + +HEAPF32[i31 >> 2] * d47;
   HEAPF32[i13 + (i59 << 4) >> 2] = +HEAPF32[i23 >> 2] * d43 + +HEAPF32[i24 >> 2] * d49 + +HEAPF32[i25 >> 2] * d47;
   HEAPF32[i13 + (i59 << 4) + 4 >> 2] = d46;
   HEAPF32[i13 + (i59 << 4) + 8 >> 2] = d45;
   HEAPF32[i13 + (i59 << 4) + 12 >> 2] = 0.0;
   d45 = d42 * +HEAPF32[i35 >> 2] + d44 * +HEAPF32[i36 >> 2] + d48 * +HEAPF32[i37 >> 2];
   d46 = d42 * +HEAPF32[i38 >> 2] + d44 * +HEAPF32[i39 >> 2] + d48 * +HEAPF32[i40 >> 2];
   HEAPF32[i14 + (i59 << 4) >> 2] = d42 * +HEAPF32[i32 >> 2] + d44 * +HEAPF32[i33 >> 2] + d48 * +HEAPF32[i34 >> 2];
   HEAPF32[i14 + (i59 << 4) + 4 >> 2] = d45;
   HEAPF32[i14 + (i59 << 4) + 8 >> 2] = d46;
   HEAPF32[i14 + (i59 << 4) + 12 >> 2] = 0.0;
   i60 = i58 + 1 | 0;
   if ((i60 | 0) < (i51 | 0)) {
    i58 = i60;
    i59 = i59 + 1 | 0;
   } else {
    break;
   }
  }
  i61 = i51 + 42 | 0;
 } else {
  i61 = 42;
 }
 i51 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i4 >> 2] | 0) + 76 >> 2] & 127](i4) | 0;
 if ((i51 | 0) > 0) {
  i59 = i4;
  i58 = i16 | 0;
  i55 = i16 + 4 | 0;
  i54 = i16 + 8 | 0;
  i53 = i16;
  i56 = i16 + 12 | 0;
  i57 = i61;
  i15 = 0;
  while (1) {
   FUNCTION_TABLE_viii[HEAP32[(HEAP32[i59 >> 2] | 0) + 80 >> 2] & 127](i4, i15, i16);
   d46 = +HEAPF32[i58 >> 2];
   d45 = +HEAPF32[i55 >> 2];
   d48 = +HEAPF32[i54 >> 2];
   d44 = d46 * +HEAPF32[i33 >> 2] + d45 * +HEAPF32[i36 >> 2] + d48 * +HEAPF32[i39 >> 2];
   d42 = d46 * +HEAPF32[i34 >> 2] + d45 * +HEAPF32[i37 >> 2] + d48 * +HEAPF32[i40 >> 2];
   HEAPF32[i58 >> 2] = +HEAPF32[i32 >> 2] * d46 + +HEAPF32[i35 >> 2] * d45 + +HEAPF32[i38 >> 2] * d48;
   HEAPF32[i55 >> 2] = d44;
   HEAPF32[i54 >> 2] = d42;
   HEAPF32[i56 >> 2] = 0.0;
   __ZN33btMinkowskiPenetrationDepthSolver24getPenetrationDirectionsEv() | 0;
   i52 = 13144 + (i57 << 4) | 0;
   HEAP32[i52 >> 2] = HEAP32[i53 >> 2];
   HEAP32[i52 + 4 >> 2] = HEAP32[i53 + 4 >> 2];
   HEAP32[i52 + 8 >> 2] = HEAP32[i53 + 8 >> 2];
   HEAP32[i52 + 12 >> 2] = HEAP32[i53 + 12 >> 2];
   d42 = +HEAPF32[i58 >> 2];
   d44 = -0.0 - d42;
   d48 = +HEAPF32[i55 >> 2];
   d45 = -0.0 - d48;
   d46 = +HEAPF32[i54 >> 2];
   d47 = -0.0 - d46;
   d49 = +HEAPF32[i26 >> 2] * d44 + +HEAPF32[i27 >> 2] * d45 + +HEAPF32[i28 >> 2] * d47;
   d43 = +HEAPF32[i29 >> 2] * d44 + +HEAPF32[i30 >> 2] * d45 + +HEAPF32[i31 >> 2] * d47;
   HEAPF32[i13 + (i57 << 4) >> 2] = +HEAPF32[i23 >> 2] * d44 + +HEAPF32[i24 >> 2] * d45 + +HEAPF32[i25 >> 2] * d47;
   HEAPF32[i13 + (i57 << 4) + 4 >> 2] = d49;
   HEAPF32[i13 + (i57 << 4) + 8 >> 2] = d43;
   HEAPF32[i13 + (i57 << 4) + 12 >> 2] = 0.0;
   d43 = d42 * +HEAPF32[i35 >> 2] + d48 * +HEAPF32[i36 >> 2] + d46 * +HEAPF32[i37 >> 2];
   d49 = d42 * +HEAPF32[i38 >> 2] + d48 * +HEAPF32[i39 >> 2] + d46 * +HEAPF32[i40 >> 2];
   HEAPF32[i14 + (i57 << 4) >> 2] = d42 * +HEAPF32[i32 >> 2] + d48 * +HEAPF32[i33 >> 2] + d46 * +HEAPF32[i34 >> 2];
   HEAPF32[i14 + (i57 << 4) + 4 >> 2] = d43;
   HEAPF32[i14 + (i57 << 4) + 8 >> 2] = d49;
   HEAPF32[i14 + (i57 << 4) + 12 >> 2] = 0.0;
   i52 = i15 + 1 | 0;
   if ((i52 | 0) < (i51 | 0)) {
    i57 = i57 + 1 | 0;
    i15 = i52;
   } else {
    break;
   }
  }
  i62 = i51 + i61 | 0;
 } else {
  i62 = i61;
 }
 FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i3 >> 2] | 0) + 68 >> 2] & 127](i3, i22, i21, i62);
 FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i4 >> 2] | 0) + 68 >> 2] & 127](i4, i50, i41, i62);
 if ((i62 | 0) > 0) {
  i41 = i5 + 48 | 0;
  i50 = i5 + 52 | 0;
  i21 = i5 + 56 | 0;
  i22 = i6 + 48 | 0;
  i61 = i6 + 52 | 0;
  i51 = i6 + 56 | 0;
  if (i20) {
   d49 = 0.0;
   d43 = 0.0;
   d46 = 0.0;
   i20 = 0;
   d48 = 999999984306749400.0;
   while (1) {
    __ZN33btMinkowskiPenetrationDepthSolver24getPenetrationDirectionsEv() | 0;
    d42 = +HEAPF32[13144 + (i20 << 4) >> 2];
    d47 = +HEAPF32[13148 + (i20 << 4) >> 2];
    d45 = +HEAPF32[13156 + (i20 << 4) >> 2];
    do {
     if (d42 * d42 + d47 * d47 + 0.0 > .01) {
      d44 = +HEAPF32[i1 + (i20 << 4) >> 2];
      d63 = +HEAPF32[i1 + (i20 << 4) + 4 >> 2];
      d64 = +HEAPF32[i1 + (i20 << 4) + 8 >> 2];
      d65 = +HEAPF32[i12 + (i20 << 4) >> 2];
      d66 = +HEAPF32[i12 + (i20 << 4) + 4 >> 2];
      d67 = +HEAPF32[i12 + (i20 << 4) + 8 >> 2];
      d68 = d42 * (+HEAPF32[i22 >> 2] + (d65 * +HEAPF32[i32 >> 2] + d66 * +HEAPF32[i35 >> 2] + d67 * +HEAPF32[i38 >> 2]) - (+HEAPF32[i41 >> 2] + (d44 * +HEAPF32[i23 >> 2] + d63 * +HEAPF32[i26 >> 2] + d64 * +HEAPF32[i29 >> 2]))) + d47 * (+HEAPF32[i61 >> 2] + (d65 * +HEAPF32[i33 >> 2] + d66 * +HEAPF32[i36 >> 2] + d67 * +HEAPF32[i39 >> 2]) - (+HEAPF32[i50 >> 2] + (d44 * +HEAPF32[i24 >> 2] + d63 * +HEAPF32[i27 >> 2] + d64 * +HEAPF32[i30 >> 2]))) + 0.0;
      if (d68 >= d48) {
       d69 = d48;
       d70 = d46;
       d71 = d43;
       d72 = d49;
       break;
      }
      d69 = d68;
      d70 = d42;
      d71 = d47;
      d72 = d45;
     } else {
      d69 = d48;
      d70 = d46;
      d71 = d43;
      d72 = d49;
     }
    } while (0);
    i15 = i20 + 1 | 0;
    if ((i15 | 0) < (i62 | 0)) {
     d49 = d72;
     d43 = d71;
     d46 = d70;
     i20 = i15;
     d48 = d69;
    } else {
     d73 = d72;
     d74 = 0.0;
     d75 = d71;
     d76 = d70;
     d77 = d69;
     break;
    }
   }
  } else {
   d69 = 0.0;
   d70 = 0.0;
   d71 = 0.0;
   d72 = 0.0;
   i20 = 0;
   d48 = 999999984306749400.0;
   while (1) {
    __ZN33btMinkowskiPenetrationDepthSolver24getPenetrationDirectionsEv() | 0;
    d46 = +HEAPF32[13144 + (i20 << 4) >> 2];
    d43 = +HEAPF32[13148 + (i20 << 4) >> 2];
    d49 = +HEAPF32[13152 + (i20 << 4) >> 2];
    d45 = +HEAPF32[13156 + (i20 << 4) >> 2];
    do {
     if (d46 * d46 + d43 * d43 + d49 * d49 > .01) {
      d47 = +HEAPF32[i1 + (i20 << 4) >> 2];
      d42 = +HEAPF32[i1 + (i20 << 4) + 4 >> 2];
      d68 = +HEAPF32[i1 + (i20 << 4) + 8 >> 2];
      d64 = +HEAPF32[i12 + (i20 << 4) >> 2];
      d63 = +HEAPF32[i12 + (i20 << 4) + 4 >> 2];
      d44 = +HEAPF32[i12 + (i20 << 4) + 8 >> 2];
      d67 = d46 * (+HEAPF32[i22 >> 2] + (d64 * +HEAPF32[i32 >> 2] + d63 * +HEAPF32[i35 >> 2] + d44 * +HEAPF32[i38 >> 2]) - (+HEAPF32[i41 >> 2] + (d47 * +HEAPF32[i23 >> 2] + d42 * +HEAPF32[i26 >> 2] + d68 * +HEAPF32[i29 >> 2]))) + d43 * (+HEAPF32[i61 >> 2] + (d64 * +HEAPF32[i33 >> 2] + d63 * +HEAPF32[i36 >> 2] + d44 * +HEAPF32[i39 >> 2]) - (+HEAPF32[i50 >> 2] + (d47 * +HEAPF32[i24 >> 2] + d42 * +HEAPF32[i27 >> 2] + d68 * +HEAPF32[i30 >> 2]))) + d49 * (+HEAPF32[i51 >> 2] + (d64 * +HEAPF32[i34 >> 2] + d63 * +HEAPF32[i37 >> 2] + d44 * +HEAPF32[i40 >> 2]) - (+HEAPF32[i21 >> 2] + (d47 * +HEAPF32[i25 >> 2] + d42 * +HEAPF32[i28 >> 2] + d68 * +HEAPF32[i31 >> 2])));
      if (d67 >= d48) {
       d78 = d48;
       d79 = d72;
       d80 = d71;
       d81 = d70;
       d82 = d69;
       break;
      }
      d78 = d67;
      d79 = d46;
      d80 = d43;
      d81 = d49;
      d82 = d45;
     } else {
      d78 = d48;
      d79 = d72;
      d80 = d71;
      d81 = d70;
      d82 = d69;
     }
    } while (0);
    i15 = i20 + 1 | 0;
    if ((i15 | 0) < (i62 | 0)) {
     d69 = d82;
     d70 = d81;
     d71 = d80;
     d72 = d79;
     i20 = i15;
     d48 = d78;
    } else {
     d73 = d82;
     d74 = d81;
     d75 = d80;
     d76 = d79;
     d77 = d78;
     break;
    }
   }
  }
 } else {
  d73 = 0.0;
  d74 = 0.0;
  d75 = 0.0;
  d76 = 0.0;
  d77 = 999999984306749400.0;
 }
 +__ZNK13btConvexShape19getMarginNonVirtualEv(i3);
 +__ZNK13btConvexShape19getMarginNonVirtualEv(i4);
 if (d77 < 0.0) {
  i83 = 0;
  STACKTOP = i11;
  return i83 | 0;
 }
 d78 = +__ZNK13btConvexShape19getMarginNonVirtualEv(i3);
 d79 = d77 + (d78 + +__ZNK13btConvexShape19getMarginNonVirtualEv(i4) + .5);
 __ZN17btGjkPairDetectorC2EPK13btConvexShapeS2_P22btVoronoiSimplexSolverP30btConvexPenetrationDepthSolver(i17, i3, i4, i2, 0);
 HEAP32[i18 + 132 >> 2] = 0;
 d78 = +HEAPF32[i5 + 48 >> 2] + d76 * d79;
 d77 = +HEAPF32[i5 + 52 >> 2] + d75 * d79;
 d80 = +HEAPF32[i5 + 56 >> 2] + d74 * d79;
 i2 = i5;
 i4 = i18;
 HEAP32[i4 >> 2] = HEAP32[i2 >> 2];
 HEAP32[i4 + 4 >> 2] = HEAP32[i2 + 4 >> 2];
 HEAP32[i4 + 8 >> 2] = HEAP32[i2 + 8 >> 2];
 HEAP32[i4 + 12 >> 2] = HEAP32[i2 + 12 >> 2];
 i2 = i5 + 16 | 0;
 i4 = i5 + 32 | 0;
 i5 = i18 + 16 | 0;
 HEAP32[i5 >> 2] = HEAP32[i2 >> 2];
 HEAP32[i5 + 4 >> 2] = HEAP32[i2 + 4 >> 2];
 HEAP32[i5 + 8 >> 2] = HEAP32[i2 + 8 >> 2];
 HEAP32[i5 + 12 >> 2] = HEAP32[i2 + 12 >> 2];
 i2 = i18 + 32 | 0;
 HEAP32[i2 >> 2] = HEAP32[i4 >> 2];
 HEAP32[i2 + 4 >> 2] = HEAP32[i4 + 4 >> 2];
 HEAP32[i2 + 8 >> 2] = HEAP32[i4 + 8 >> 2];
 HEAP32[i2 + 12 >> 2] = HEAP32[i4 + 12 >> 2];
 HEAPF32[i18 + 48 >> 2] = d78;
 HEAPF32[i18 + 52 >> 2] = d77;
 HEAPF32[i18 + 56 >> 2] = d80;
 HEAPF32[i18 + 60 >> 2] = 0.0;
 i4 = i18 + 64 | 0;
 i2 = i6;
 HEAP32[i4 >> 2] = HEAP32[i2 >> 2];
 HEAP32[i4 + 4 >> 2] = HEAP32[i2 + 4 >> 2];
 HEAP32[i4 + 8 >> 2] = HEAP32[i2 + 8 >> 2];
 HEAP32[i4 + 12 >> 2] = HEAP32[i2 + 12 >> 2];
 i2 = i18 + 80 | 0;
 i4 = i6 + 16 | 0;
 HEAP32[i2 >> 2] = HEAP32[i4 >> 2];
 HEAP32[i2 + 4 >> 2] = HEAP32[i4 + 4 >> 2];
 HEAP32[i2 + 8 >> 2] = HEAP32[i4 + 8 >> 2];
 HEAP32[i2 + 12 >> 2] = HEAP32[i4 + 12 >> 2];
 i4 = i18 + 96 | 0;
 i2 = i6 + 32 | 0;
 HEAP32[i4 >> 2] = HEAP32[i2 >> 2];
 HEAP32[i4 + 4 >> 2] = HEAP32[i2 + 4 >> 2];
 HEAP32[i4 + 8 >> 2] = HEAP32[i2 + 8 >> 2];
 HEAP32[i4 + 12 >> 2] = HEAP32[i2 + 12 >> 2];
 i2 = i18 + 112 | 0;
 i4 = i6 + 48 | 0;
 HEAP32[i2 >> 2] = HEAP32[i4 >> 2];
 HEAP32[i2 + 4 >> 2] = HEAP32[i4 + 4 >> 2];
 HEAP32[i2 + 8 >> 2] = HEAP32[i4 + 8 >> 2];
 HEAP32[i2 + 12 >> 2] = HEAP32[i4 + 12 >> 2];
 HEAPF32[i18 + 128 >> 2] = 999999984306749400.0;
 HEAP32[i19 >> 2] = 1384;
 i4 = i19 + 40 | 0;
 HEAP8[i4] = 0;
 HEAPF32[i17 + 4 >> 2] = -0.0 - d76;
 HEAPF32[i17 + 8 >> 2] = -0.0 - d75;
 HEAPF32[i17 + 12 >> 2] = -0.0 - d74;
 HEAPF32[i17 + 16 >> 2] = 0.0;
 __ZN17btGjkPairDetector16getClosestPointsERKN36btDiscreteCollisionDetectorInterface17ClosestPointInputERNS0_6ResultEP12btIDebugDrawb(i17, i18, i19 | 0, i10, 0);
 d80 = d79 - +HEAPF32[i19 + 36 >> 2];
 i10 = HEAP8[i4] | 0;
 if (i10 << 24 >> 24 != 0) {
  i4 = i19 + 20 | 0;
  d79 = +HEAPF32[i19 + 24 >> 2] - d75 * d80;
  d77 = +HEAPF32[i19 + 28 >> 2] - d74 * d80;
  HEAPF32[i8 >> 2] = +HEAPF32[i4 >> 2] - d76 * d80;
  HEAPF32[i8 + 4 >> 2] = d79;
  HEAPF32[i8 + 8 >> 2] = d77;
  HEAPF32[i8 + 12 >> 2] = 0.0;
  i8 = i9;
  i9 = i4;
  HEAP32[i8 >> 2] = HEAP32[i9 >> 2];
  HEAP32[i8 + 4 >> 2] = HEAP32[i9 + 4 >> 2];
  HEAP32[i8 + 8 >> 2] = HEAP32[i9 + 8 >> 2];
  HEAP32[i8 + 12 >> 2] = HEAP32[i9 + 12 >> 2];
  HEAPF32[i7 >> 2] = d76;
  HEAPF32[i7 + 4 >> 2] = d75;
  HEAPF32[i7 + 8 >> 2] = d74;
  HEAPF32[i7 + 12 >> 2] = d73;
 }
 i83 = i10 << 24 >> 24 != 0;
 STACKTOP = i11;
 return i83 | 0;
}
function _main(i1, i2) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 var i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, d25 = 0.0, d26 = 0.0, d27 = 0.0, d28 = 0.0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 80 | 0;
 i1 = i2 | 0;
 i3 = i2 + 32 | 0;
 i4 = i2 + 48 | 0;
 i5 = i2 + 64 | 0;
 i6 = i5 | 0;
 i7 = STACKTOP;
 STACKTOP = STACKTOP + 136 | 0;
 i8 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i9 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i10 = i9 | 0;
 i11 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i12 = STACKTOP;
 STACKTOP = STACKTOP + 136 | 0;
 i13 = STACKTOP;
 STACKTOP = STACKTOP + 64 | 0;
 i14 = __Znwj(88) | 0;
 i15 = i14;
 HEAP32[i1 >> 2] = 0;
 HEAP32[i1 + 4 >> 2] = 0;
 HEAP32[i1 + 8 >> 2] = 0;
 HEAP32[i1 + 12 >> 2] = 4096;
 HEAP32[i1 + 16 >> 2] = 4096;
 HEAP32[i1 + 20 >> 2] = 0;
 HEAP32[i1 + 24 >> 2] = 0;
 HEAP32[i1 + 28 >> 2] = 1;
 __ZN31btDefaultCollisionConfigurationC2ERK34btDefaultCollisionConstructionInfo(i15, i1);
 i1 = __Znwj(5388) | 0;
 i16 = i1;
 i17 = i14;
 __ZN21btCollisionDispatcherC2EP24btCollisionConfiguration(i16, i17);
 i18 = __Znwj(156) | 0;
 __ZN16btDbvtBroadphaseC2EP22btOverlappingPairCache(i18, 0);
 i19 = i18;
 i20 = __Znwj(128) | 0;
 i21 = i20;
 __ZN35btSequentialImpulseConstraintSolverC2Ev(i21);
 i22 = __Znwj(268) | 0;
 i23 = i22;
 __ZN23btDiscreteDynamicsWorldC2EP12btDispatcherP21btBroadphaseInterfaceP18btConstraintSolverP24btCollisionConfiguration(i23, i1, i19, i20, i17);
 i17 = HEAP32[(HEAP32[i22 >> 2] | 0) + 68 >> 2] | 0;
 HEAPF32[i3 >> 2] = 0.0;
 HEAPF32[i3 + 4 >> 2] = -10.0;
 HEAPF32[i3 + 8 >> 2] = 0.0;
 HEAPF32[i3 + 12 >> 2] = 0.0;
 FUNCTION_TABLE_vii[i17 & 127](i23, i3);
 i3 = __Z22btAlignedAllocInternalji(56, 16) | 0;
 __ZN23btPolyhedralConvexShapeC2Ev(i3);
 HEAP32[i3 >> 2] = 4984;
 HEAP32[i3 + 4 >> 2] = 0;
 i17 = i3;
 i24 = i3;
 d25 = +FUNCTION_TABLE_fi[HEAP32[1257] & 7](i17);
 d26 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i24 >> 2] | 0) + 44 >> 2] & 7](i17);
 d27 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i24 >> 2] | 0) + 44 >> 2] & 7](i17);
 d28 = +HEAPF32[i3 + 16 >> 2] * 50.0 - d26;
 d26 = +HEAPF32[i3 + 20 >> 2] * 50.0 - d27;
 HEAPF32[i3 + 28 >> 2] = +HEAPF32[i3 + 12 >> 2] * 50.0 - d25;
 HEAPF32[i3 + 32 >> 2] = d28;
 HEAPF32[i3 + 36 >> 2] = d26;
 HEAPF32[i3 + 40 >> 2] = 0.0;
 i17 = i3;
 i3 = __Z22btAlignedAllocInternalji(4, 16) | 0;
 i24 = i3;
 i29 = (i3 | 0) == 0;
 if (!i29) {
  HEAP32[i24 >> 2] = i17;
 }
 i30 = i4 | 0;
 _memset(i30 | 0, 0, 16);
 _memset(i5 | 0, 0, 16);
 i31 = __Znwj(200) | 0;
 do {
  if ((HEAP8[14344] | 0) == 0) {
   if ((___cxa_guard_acquire(14344) | 0) == 0) {
    break;
   }
   do {
    if ((HEAP8[14352] | 0) == 0) {
     if ((___cxa_guard_acquire(14352) | 0) == 0) {
      break;
     }
     HEAPF32[3550] = 1.0;
     _memset(14204, 0, 16);
     HEAPF32[3555] = 1.0;
     _memset(14224, 0, 16);
     HEAPF32[3560] = 1.0;
     HEAPF32[3561] = 0.0;
    }
   } while (0);
   HEAP32[3534] = HEAP32[3550];
   HEAP32[3535] = HEAP32[3551];
   HEAP32[3536] = HEAP32[3552];
   HEAP32[3537] = HEAP32[3553];
   HEAP32[3538] = HEAP32[3554];
   HEAP32[14156 >> 2] = HEAP32[14220 >> 2];
   HEAP32[14160 >> 2] = HEAP32[14224 >> 2];
   HEAP32[14164 >> 2] = HEAP32[14228 >> 2];
   HEAP32[3542] = HEAP32[3558];
   HEAP32[14172 >> 2] = HEAP32[14236 >> 2];
   HEAP32[14176 >> 2] = HEAP32[14240 >> 2];
   HEAP32[14180 >> 2] = HEAP32[14244 >> 2];
   _memset(14184, 0, 16);
  }
 } while (0);
 HEAP32[i31 >> 2] = 3864;
 HEAPF32[i31 + 4 >> 2] = 1.0;
 i32 = i31 + 8 | 0;
 HEAP32[i32 >> 2] = HEAP32[i30 >> 2];
 HEAP32[i32 + 4 >> 2] = HEAP32[i30 + 4 >> 2];
 HEAP32[i32 + 8 >> 2] = HEAP32[i30 + 8 >> 2];
 i32 = HEAP32[i4 + 12 >> 2] | 0;
 HEAP32[i31 + 20 >> 2] = i32;
 HEAPF32[i31 + 24 >> 2] = 1.0;
 i4 = i31 + 28 | 0;
 i33 = HEAP32[i6 >> 2] | 0;
 i34 = HEAP32[i6 + 4 >> 2] | 0;
 HEAP32[i4 >> 2] = i33;
 HEAP32[i4 + 4 >> 2] = i34;
 i4 = i5 + 8 | 0;
 i5 = i31 + 36 | 0;
 i6 = HEAP32[i4 >> 2] | 0;
 i35 = HEAP32[i4 + 4 >> 2] | 0;
 HEAP32[i5 >> 2] = i6;
 HEAP32[i5 + 4 >> 2] = i35;
 HEAPF32[i31 + 44 >> 2] = 1.0;
 HEAPF32[i31 + 48 >> 2] = 0.0;
 HEAPF32[i31 + 52 >> 2] = 0.0;
 HEAPF32[i31 + 56 >> 2] = -56.0;
 HEAPF32[i31 + 60 >> 2] = 0.0;
 HEAPF32[i31 + 64 >> 2] = 0.0;
 i5 = i31 + 68 | 0;
 HEAP32[i5 >> 2] = HEAP32[3534];
 HEAP32[i5 + 4 >> 2] = HEAP32[3535];
 HEAP32[i5 + 8 >> 2] = HEAP32[3536];
 HEAP32[i5 + 12 >> 2] = HEAP32[3537];
 i5 = i31 + 84 | 0;
 HEAP32[i5 >> 2] = HEAP32[3538];
 HEAP32[i5 + 4 >> 2] = HEAP32[14156 >> 2];
 HEAP32[i5 + 8 >> 2] = HEAP32[14160 >> 2];
 HEAP32[i5 + 12 >> 2] = HEAP32[14164 >> 2];
 i5 = i31 + 100 | 0;
 HEAP32[i5 >> 2] = HEAP32[3542];
 HEAP32[i5 + 4 >> 2] = HEAP32[14172 >> 2];
 HEAP32[i5 + 8 >> 2] = HEAP32[14176 >> 2];
 HEAP32[i5 + 12 >> 2] = HEAP32[14180 >> 2];
 i5 = i31 + 116 | 0;
 HEAP32[i5 >> 2] = HEAP32[3546];
 HEAP32[i5 + 4 >> 2] = HEAP32[14188 >> 2];
 HEAP32[i5 + 8 >> 2] = HEAP32[14192 >> 2];
 HEAP32[i5 + 12 >> 2] = HEAP32[14196 >> 2];
 HEAPF32[i31 + 132 >> 2] = 1.0;
 i5 = i31 + 136 | 0;
 HEAP32[i5 >> 2] = HEAP32[i30 >> 2];
 HEAP32[i5 + 4 >> 2] = HEAP32[i30 + 4 >> 2];
 HEAP32[i5 + 8 >> 2] = HEAP32[i30 + 8 >> 2];
 HEAP32[i31 + 148 >> 2] = i32;
 HEAPF32[i31 + 152 >> 2] = 1.0;
 i32 = i31 + 156 | 0;
 HEAP32[i32 >> 2] = i33;
 HEAP32[i32 + 4 >> 2] = i34;
 i34 = i31 + 164 | 0;
 HEAP32[i34 >> 2] = i6;
 HEAP32[i34 + 4 >> 2] = i35;
 HEAPF32[i31 + 172 >> 2] = 1.0;
 HEAPF32[i31 + 176 >> 2] = 0.0;
 HEAPF32[i31 + 180 >> 2] = 0.0;
 HEAPF32[i31 + 184 >> 2] = -56.0;
 HEAPF32[i31 + 188 >> 2] = 0.0;
 HEAPF32[i31 + 192 >> 2] = 0.0;
 HEAP32[i31 + 196 >> 2] = 0;
 HEAPF32[i7 >> 2] = 0.0;
 HEAP32[i7 + 4 >> 2] = i31;
 HEAP32[i7 + 72 >> 2] = i17;
 _memset(i7 + 76 | 0, 0, 24);
 HEAPF32[i7 + 100 >> 2] = .5;
 HEAPF32[i7 + 104 >> 2] = 0.0;
 HEAPF32[i7 + 108 >> 2] = .800000011920929;
 HEAPF32[i7 + 112 >> 2] = 1.0;
 HEAP8[i7 + 116 | 0] = 0;
 HEAPF32[i7 + 120 >> 2] = .004999999888241291;
 HEAPF32[i7 + 124 >> 2] = .009999999776482582;
 HEAPF32[i7 + 128 >> 2] = .009999999776482582;
 HEAPF32[i7 + 132 >> 2] = .009999999776482582;
 HEAPF32[i7 + 8 >> 2] = 1.0;
 _memset(i7 + 12 | 0, 0, 16);
 HEAPF32[i7 + 28 >> 2] = 1.0;
 _memset(i7 + 32 | 0, 0, 16);
 HEAPF32[i7 + 48 >> 2] = 1.0;
 _memset(i7 + 52 | 0, 0, 20);
 i17 = __Z22btAlignedAllocInternalji(608, 16) | 0;
 __ZN11btRigidBodyC2ERKNS_27btRigidBodyConstructionInfoE(i17, i7);
 i7 = i22;
 FUNCTION_TABLE_vii[HEAP32[(HEAP32[i7 >> 2] | 0) + 80 >> 2] & 127](i23, i17);
 i17 = __Z22btAlignedAllocInternalji(52, 16) | 0;
 __ZN21btConvexInternalShapeC2Ev(i17);
 HEAP32[i17 >> 2] = 4728;
 HEAP32[i17 + 4 >> 2] = 8;
 HEAPF32[i17 + 28 >> 2] = 1.0;
 HEAPF32[i17 + 44 >> 2] = 1.0;
 i31 = i17;
 i35 = __Z22btAlignedAllocInternalji(8, 16) | 0;
 i34 = i35;
 if ((i35 | 0) != 0) {
  HEAP32[i34 >> 2] = HEAP32[i24 >> 2];
 }
 if (!i29) {
  __Z21btAlignedFreeInternalPv(i3);
 }
 i3 = i35 + 4 | 0;
 if ((i3 | 0) != 0) {
  HEAP32[i3 >> 2] = i31;
 }
 i3 = i8 | 0;
 _memset(i3 | 0, 0, 16);
 _memset(i9 | 0, 0, 16);
 _memset(i11 | 0, 0, 16);
 FUNCTION_TABLE_vifi[HEAP32[(HEAP32[i17 >> 2] | 0) + 32 >> 2] & 15](i31, 1.0, i11);
 i17 = __Znwj(200) | 0;
 do {
  if ((HEAP8[14344] | 0) == 0) {
   if ((___cxa_guard_acquire(14344) | 0) == 0) {
    break;
   }
   do {
    if ((HEAP8[14352] | 0) == 0) {
     if ((___cxa_guard_acquire(14352) | 0) == 0) {
      break;
     }
     HEAPF32[3550] = 1.0;
     _memset(14204, 0, 16);
     HEAPF32[3555] = 1.0;
     _memset(14224, 0, 16);
     HEAPF32[3560] = 1.0;
     HEAPF32[3561] = 0.0;
    }
   } while (0);
   HEAP32[3534] = HEAP32[3550];
   HEAP32[3535] = HEAP32[3551];
   HEAP32[3536] = HEAP32[3552];
   HEAP32[3537] = HEAP32[3553];
   HEAP32[3538] = HEAP32[3554];
   HEAP32[14156 >> 2] = HEAP32[14220 >> 2];
   HEAP32[14160 >> 2] = HEAP32[14224 >> 2];
   HEAP32[14164 >> 2] = HEAP32[14228 >> 2];
   HEAP32[3542] = HEAP32[3558];
   HEAP32[14172 >> 2] = HEAP32[14236 >> 2];
   HEAP32[14176 >> 2] = HEAP32[14240 >> 2];
   HEAP32[14180 >> 2] = HEAP32[14244 >> 2];
   _memset(14184, 0, 16);
  }
 } while (0);
 HEAP32[i17 >> 2] = 3864;
 HEAPF32[i17 + 4 >> 2] = 1.0;
 i29 = i17 + 8 | 0;
 HEAP32[i29 >> 2] = HEAP32[i3 >> 2];
 HEAP32[i29 + 4 >> 2] = HEAP32[i3 + 4 >> 2];
 HEAP32[i29 + 8 >> 2] = HEAP32[i3 + 8 >> 2];
 i29 = HEAP32[i8 + 12 >> 2] | 0;
 HEAP32[i17 + 20 >> 2] = i29;
 HEAPF32[i17 + 24 >> 2] = 1.0;
 i8 = i17 + 28 | 0;
 i24 = HEAP32[i10 >> 2] | 0;
 i6 = HEAP32[i10 + 4 >> 2] | 0;
 HEAP32[i8 >> 2] = i24;
 HEAP32[i8 + 4 >> 2] = i6;
 i8 = i9 + 8 | 0;
 i9 = i17 + 36 | 0;
 i10 = HEAP32[i8 >> 2] | 0;
 i32 = HEAP32[i8 + 4 >> 2] | 0;
 HEAP32[i9 >> 2] = i10;
 HEAP32[i9 + 4 >> 2] = i32;
 HEAPF32[i17 + 44 >> 2] = 1.0;
 HEAPF32[i17 + 48 >> 2] = 0.0;
 HEAPF32[i17 + 52 >> 2] = 2.0;
 HEAPF32[i17 + 56 >> 2] = 10.0;
 HEAPF32[i17 + 60 >> 2] = 0.0;
 HEAPF32[i17 + 64 >> 2] = 0.0;
 i9 = i17 + 68 | 0;
 HEAP32[i9 >> 2] = HEAP32[3534];
 HEAP32[i9 + 4 >> 2] = HEAP32[3535];
 HEAP32[i9 + 8 >> 2] = HEAP32[3536];
 HEAP32[i9 + 12 >> 2] = HEAP32[3537];
 i9 = i17 + 84 | 0;
 HEAP32[i9 >> 2] = HEAP32[3538];
 HEAP32[i9 + 4 >> 2] = HEAP32[14156 >> 2];
 HEAP32[i9 + 8 >> 2] = HEAP32[14160 >> 2];
 HEAP32[i9 + 12 >> 2] = HEAP32[14164 >> 2];
 i9 = i17 + 100 | 0;
 HEAP32[i9 >> 2] = HEAP32[3542];
 HEAP32[i9 + 4 >> 2] = HEAP32[14172 >> 2];
 HEAP32[i9 + 8 >> 2] = HEAP32[14176 >> 2];
 HEAP32[i9 + 12 >> 2] = HEAP32[14180 >> 2];
 i9 = i17 + 116 | 0;
 HEAP32[i9 >> 2] = HEAP32[3546];
 HEAP32[i9 + 4 >> 2] = HEAP32[14188 >> 2];
 HEAP32[i9 + 8 >> 2] = HEAP32[14192 >> 2];
 HEAP32[i9 + 12 >> 2] = HEAP32[14196 >> 2];
 HEAPF32[i17 + 132 >> 2] = 1.0;
 i9 = i17 + 136 | 0;
 HEAP32[i9 >> 2] = HEAP32[i3 >> 2];
 HEAP32[i9 + 4 >> 2] = HEAP32[i3 + 4 >> 2];
 HEAP32[i9 + 8 >> 2] = HEAP32[i3 + 8 >> 2];
 HEAP32[i17 + 148 >> 2] = i29;
 HEAPF32[i17 + 152 >> 2] = 1.0;
 i29 = i17 + 156 | 0;
 HEAP32[i29 >> 2] = i24;
 HEAP32[i29 + 4 >> 2] = i6;
 i6 = i17 + 164 | 0;
 HEAP32[i6 >> 2] = i10;
 HEAP32[i6 + 4 >> 2] = i32;
 HEAPF32[i17 + 172 >> 2] = 1.0;
 HEAPF32[i17 + 176 >> 2] = 0.0;
 HEAPF32[i17 + 180 >> 2] = 2.0;
 HEAPF32[i17 + 184 >> 2] = 10.0;
 HEAPF32[i17 + 188 >> 2] = 0.0;
 HEAPF32[i17 + 192 >> 2] = 0.0;
 HEAP32[i17 + 196 >> 2] = 0;
 HEAPF32[i12 >> 2] = 1.0;
 HEAP32[i12 + 4 >> 2] = i17;
 HEAP32[i12 + 72 >> 2] = i31;
 i31 = i12 + 76 | 0;
 i17 = i11;
 HEAP32[i31 >> 2] = HEAP32[i17 >> 2];
 HEAP32[i31 + 4 >> 2] = HEAP32[i17 + 4 >> 2];
 HEAP32[i31 + 8 >> 2] = HEAP32[i17 + 8 >> 2];
 HEAP32[i31 + 12 >> 2] = HEAP32[i17 + 12 >> 2];
 HEAPF32[i12 + 92 >> 2] = 0.0;
 HEAPF32[i12 + 96 >> 2] = 0.0;
 HEAPF32[i12 + 100 >> 2] = .5;
 HEAPF32[i12 + 104 >> 2] = 0.0;
 HEAPF32[i12 + 108 >> 2] = .800000011920929;
 HEAPF32[i12 + 112 >> 2] = 1.0;
 HEAP8[i12 + 116 | 0] = 0;
 HEAPF32[i12 + 120 >> 2] = .004999999888241291;
 HEAPF32[i12 + 124 >> 2] = .009999999776482582;
 HEAPF32[i12 + 128 >> 2] = .009999999776482582;
 HEAPF32[i12 + 132 >> 2] = .009999999776482582;
 HEAPF32[i12 + 8 >> 2] = 1.0;
 _memset(i12 + 12 | 0, 0, 16);
 HEAPF32[i12 + 28 >> 2] = 1.0;
 _memset(i12 + 32 | 0, 0, 16);
 HEAPF32[i12 + 48 >> 2] = 1.0;
 _memset(i12 + 52 | 0, 0, 20);
 i17 = __Z22btAlignedAllocInternalji(608, 16) | 0;
 __ZN11btRigidBodyC2ERKNS_27btRigidBodyConstructionInfoE(i17, i12);
 FUNCTION_TABLE_vii[HEAP32[(HEAP32[i7 >> 2] | 0) + 80 >> 2] & 127](i23, i17);
 i17 = i22;
 i7 = i22 + 8 | 0;
 i12 = i22 + 16 | 0;
 i31 = i13 + 48 | 0;
 i11 = i13 + 52 | 0;
 i32 = i13 + 56 | 0;
 i6 = 0;
 do {
  FUNCTION_TABLE_iifif[HEAP32[(HEAP32[i17 >> 2] | 0) + 48 >> 2] & 3](i23, .01666666753590107, 10, .01666666753590107) | 0;
  i10 = HEAP32[i7 >> 2] | 0;
  if ((i10 | 0) > 0) {
   i29 = i10;
   do {
    i29 = i29 - 1 | 0;
    i10 = HEAP32[(HEAP32[i12 >> 2] | 0) + (i29 << 2) >> 2] | 0;
    do {
     if (!((HEAP32[i10 + 232 >> 2] & 2 | 0) == 0 | (i10 | 0) == 0)) {
      i24 = HEAP32[i10 + 472 >> 2] | 0;
      if ((i24 | 0) == 0) {
       break;
      }
      FUNCTION_TABLE_vii[HEAP32[(HEAP32[i24 >> 2] | 0) + 8 >> 2] & 127](i24, i13);
      d26 = +HEAPF32[i31 >> 2];
      d28 = +HEAPF32[i11 >> 2];
      d25 = +HEAPF32[i32 >> 2];
      _printf(1128, (i24 = STACKTOP, STACKTOP = STACKTOP + 24 | 0, HEAPF64[i24 >> 3] = d26, HEAPF64[i24 + 8 >> 3] = d28, HEAPF64[i24 + 16 >> 3] = d25, i24) | 0) | 0;
      STACKTOP = i24;
     }
    } while (0);
   } while ((i29 | 0) > 0);
  }
  i6 = i6 + 1 | 0;
 } while ((i6 | 0) < 135);
 i6 = HEAP32[i7 >> 2] | 0;
 if ((i6 | 0) > 0) {
  i7 = i22;
  i32 = i6;
  do {
   i32 = i32 - 1 | 0;
   i6 = HEAP32[(HEAP32[i12 >> 2] | 0) + (i32 << 2) >> 2] | 0;
   i11 = (i6 | 0) == 0;
   do {
    if (!((HEAP32[i6 + 232 >> 2] & 2 | 0) == 0 | i11)) {
     i31 = HEAP32[i6 + 472 >> 2] | 0;
     if ((i31 | 0) == 0) {
      break;
     }
     FUNCTION_TABLE_vi[HEAP32[(HEAP32[i31 >> 2] | 0) + 4 >> 2] & 511](i31);
    }
   } while (0);
   FUNCTION_TABLE_vii[HEAP32[(HEAP32[i7 >> 2] | 0) + 36 >> 2] & 127](i23, i6);
   if (!i11) {
    FUNCTION_TABLE_vi[HEAP32[(HEAP32[i6 >> 2] | 0) + 8 >> 2] & 511](i6);
   }
  } while ((i32 | 0) > 0);
 }
 i32 = HEAP32[i34 >> 2] | 0;
 HEAP32[i34 >> 2] = 0;
 if ((i32 | 0) != 0) {
  FUNCTION_TABLE_vi[HEAP32[(HEAP32[i32 >> 2] | 0) + 4 >> 2] & 511](i32);
 }
 i32 = i35 + 4 | 0;
 i34 = HEAP32[i32 >> 2] | 0;
 HEAP32[i32 >> 2] = 0;
 if ((i34 | 0) != 0) {
  FUNCTION_TABLE_vi[HEAP32[(HEAP32[i34 >> 2] | 0) + 4 >> 2] & 511](i34);
 }
 if ((i22 | 0) != 0) {
  FUNCTION_TABLE_vi[HEAP32[(HEAP32[i22 >> 2] | 0) + 4 >> 2] & 511](i23);
 }
 if ((i20 | 0) != 0) {
  FUNCTION_TABLE_vi[HEAP32[(HEAP32[i20 >> 2] | 0) + 4 >> 2] & 511](i21);
 }
 if ((i18 | 0) != 0) {
  FUNCTION_TABLE_vi[HEAP32[(HEAP32[i18 >> 2] | 0) + 4 >> 2] & 511](i19);
 }
 if ((i1 | 0) != 0) {
  FUNCTION_TABLE_vi[HEAP32[(HEAP32[i1 >> 2] | 0) + 4 >> 2] & 511](i16);
 }
 if ((i14 | 0) != 0) {
  FUNCTION_TABLE_vi[HEAP32[(HEAP32[i14 >> 2] | 0) + 4 >> 2] & 511](i15);
 }
 if ((i35 | 0) == 0) {
  STACKTOP = i2;
  return 0;
 }
 __Z21btAlignedFreeInternalPv(i35);
 STACKTOP = i2;
 return 0;
}
function __ZN23btPolyhedralConvexShape28initializePolyhedralFeaturesEv(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, d41 = 0.0, d42 = 0.0, d43 = 0.0, d44 = 0.0, i45 = 0, d46 = 0.0, d47 = 0.0, d48 = 0.0, d49 = 0.0, i50 = 0, i51 = 0, d52 = 0.0, i53 = 0, i54 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 248 | 0;
 i3 = i2 + 16 | 0;
 i4 = i2 + 80 | 0;
 i5 = i2 + 96 | 0;
 i6 = i2 + 152 | 0;
 i7 = i2 + 168 | 0;
 i8 = i2 + 216 | 0;
 i9 = i2 + 232 | 0;
 i10 = i1 + 52 | 0;
 i11 = HEAP32[i10 >> 2] | 0;
 if ((i11 | 0) != 0) {
  __Z21btAlignedFreeInternalPv(i11);
 }
 i11 = __Z22btAlignedAllocInternalji(80, 16) | 0;
 if ((i11 | 0) == 0) {
  i12 = 0;
 } else {
  i13 = i11;
  __ZN18btConvexPolyhedronC2Ev(i13);
  i12 = i13;
 }
 HEAP32[i10 >> 2] = i12;
 i12 = i1;
 i13 = i1;
 i11 = i2 | 0;
 i14 = 0;
 i15 = 0;
 i16 = 0;
 while (1) {
  if ((i14 | 0) >= (FUNCTION_TABLE_ii[HEAP32[(HEAP32[i12 >> 2] | 0) + 88 >> 2] & 127](i1) | 0)) {
   break;
  }
  do {
   if ((i14 | 0) == (i15 | 0)) {
    i17 = (i15 | 0) == 0 ? 1 : i15 << 1;
    if ((i15 | 0) >= (i17 | 0)) {
     i18 = i15;
     i19 = i16;
     break;
    }
    if ((i17 | 0) == 0) {
     i20 = 0;
    } else {
     i20 = __Z22btAlignedAllocInternalji(i17 << 4, 16) | 0;
    }
    if ((i15 | 0) > 0) {
     i21 = 0;
     do {
      i22 = i20 + (i21 << 4) | 0;
      if ((i22 | 0) != 0) {
       i23 = i22;
       i22 = i16 + (i21 << 4) | 0;
       HEAP32[i23 >> 2] = HEAP32[i22 >> 2];
       HEAP32[i23 + 4 >> 2] = HEAP32[i22 + 4 >> 2];
       HEAP32[i23 + 8 >> 2] = HEAP32[i22 + 8 >> 2];
       HEAP32[i23 + 12 >> 2] = HEAP32[i22 + 12 >> 2];
      }
      i21 = i21 + 1 | 0;
     } while ((i21 | 0) < (i15 | 0));
    }
    if ((i16 | 0) == 0) {
     i18 = i17;
     i19 = i20;
     break;
    }
    __Z21btAlignedFreeInternalPv(i16);
    i18 = i17;
    i19 = i20;
   } else {
    i18 = i15;
    i19 = i16;
   }
  } while (0);
  i21 = i19 + (i14 << 4) | 0;
  if ((i21 | 0) != 0) {
   i22 = i21;
   HEAP32[i22 >> 2] = HEAP32[i11 >> 2];
   HEAP32[i22 + 4 >> 2] = HEAP32[i11 + 4 >> 2];
   HEAP32[i22 + 8 >> 2] = HEAP32[i11 + 8 >> 2];
   HEAP32[i22 + 12 >> 2] = HEAP32[i11 + 12 >> 2];
  }
  FUNCTION_TABLE_viii[HEAP32[(HEAP32[i13 >> 2] | 0) + 100 >> 2] & 127](i1, i14, i21);
  i14 = i14 + 1 | 0;
  i15 = i18;
  i16 = i19;
 }
 HEAP8[i3 + 16 | 0] = 1;
 i19 = i3 + 12 | 0;
 HEAP32[i19 >> 2] = 0;
 i18 = i3 + 4 | 0;
 HEAP32[i18 >> 2] = 0;
 HEAP32[i3 + 8 >> 2] = 0;
 HEAP8[i3 + 36 | 0] = 1;
 i15 = i3 + 32 | 0;
 HEAP32[i15 >> 2] = 0;
 HEAP32[i3 + 24 >> 2] = 0;
 HEAP32[i3 + 28 >> 2] = 0;
 HEAP8[i3 + 56 | 0] = 1;
 i13 = i3 + 52 | 0;
 HEAP32[i13 >> 2] = 0;
 i11 = i3 + 44 | 0;
 HEAP32[i11 >> 2] = 0;
 HEAP32[i3 + 48 >> 2] = 0;
 i20 = i16;
 +__ZN20btConvexHullComputer7computeEPKvbiiff(i3, i20, 0, 16, i14, 0.0, 0.0);
 i14 = HEAP32[i11 >> 2] | 0;
 i11 = (i14 | 0) > 0;
 if (i11) {
  i12 = __Z22btAlignedAllocInternalji(i14 << 4, 16) | 0;
  i21 = i4;
  i4 = 0;
  while (1) {
   i22 = i12 + (i4 << 4) | 0;
   if ((i22 | 0) != 0) {
    i23 = i22;
    HEAP32[i23 >> 2] = HEAP32[i21 >> 2];
    HEAP32[i23 + 4 >> 2] = HEAP32[i21 + 4 >> 2];
    HEAP32[i23 + 8 >> 2] = HEAP32[i21 + 8 >> 2];
    HEAP32[i23 + 12 >> 2] = HEAP32[i21 + 12 >> 2];
   }
   i23 = i4 + 1 | 0;
   if ((i23 | 0) < (i14 | 0)) {
    i4 = i23;
   } else {
    i24 = i12;
    break;
   }
  }
 } else {
  i24 = 0;
 }
 i12 = HEAP32[i10 >> 2] | 0;
 _memset(i5 | 0, 0, 56);
 i4 = i5 + 16 | 0;
 HEAP8[i4] = 1;
 i21 = i5 + 12 | 0;
 HEAP32[i21 >> 2] = 0;
 i23 = i5 + 4 | 0;
 HEAP32[i23 >> 2] = 0;
 i22 = i5 + 8 | 0;
 HEAP32[i22 >> 2] = 0;
 i25 = i5 + 36 | 0;
 HEAP8[i25] = 1;
 i26 = i5 + 32 | 0;
 HEAP32[i26 >> 2] = 0;
 i27 = i5 + 24 | 0;
 HEAP32[i27 >> 2] = 0;
 i28 = i5 + 28 | 0;
 HEAP32[i28 >> 2] = 0;
 __ZN20btAlignedObjectArrayI6btFaceE6resizeEiRKS0_(i12 + 24 | 0, i14, i5);
 i5 = HEAP32[i26 >> 2] | 0;
 if ((i5 | 0) != 0) {
  if ((HEAP8[i25] | 0) != 0) {
   __Z21btAlignedFreeInternalPv(i5);
  }
  HEAP32[i26 >> 2] = 0;
 }
 HEAP8[i25] = 1;
 HEAP32[i26 >> 2] = 0;
 HEAP32[i27 >> 2] = 0;
 HEAP32[i28 >> 2] = 0;
 i28 = HEAP32[i21 >> 2] | 0;
 if ((i28 | 0) != 0) {
  if ((HEAP8[i4] | 0) != 0) {
   __Z21btAlignedFreeInternalPv(i28);
  }
  HEAP32[i21 >> 2] = 0;
 }
 HEAP8[i4] = 1;
 HEAP32[i21 >> 2] = 0;
 HEAP32[i23 >> 2] = 0;
 HEAP32[i22 >> 2] = 0;
 i22 = HEAP32[i18 >> 2] | 0;
 i23 = HEAP32[i10 >> 2] | 0;
 i21 = i23 + 8 | 0;
 i4 = HEAP32[i21 >> 2] | 0;
 if ((i4 | 0) < (i22 | 0)) {
  i28 = i23 + 12 | 0;
  if ((HEAP32[i28 >> 2] | 0) < (i22 | 0)) {
   if ((i22 | 0) == 0) {
    i29 = 0;
    i30 = i4;
   } else {
    i27 = __Z22btAlignedAllocInternalji(i22 << 4, 16) | 0;
    i29 = i27;
    i30 = HEAP32[i21 >> 2] | 0;
   }
   i27 = i23 + 16 | 0;
   if ((i30 | 0) > 0) {
    i26 = 0;
    do {
     i25 = i29 + (i26 << 4) | 0;
     if ((i25 | 0) != 0) {
      i5 = i25;
      i25 = (HEAP32[i27 >> 2] | 0) + (i26 << 4) | 0;
      HEAP32[i5 >> 2] = HEAP32[i25 >> 2];
      HEAP32[i5 + 4 >> 2] = HEAP32[i25 + 4 >> 2];
      HEAP32[i5 + 8 >> 2] = HEAP32[i25 + 8 >> 2];
      HEAP32[i5 + 12 >> 2] = HEAP32[i25 + 12 >> 2];
     }
     i26 = i26 + 1 | 0;
    } while ((i26 | 0) < (i30 | 0));
   }
   i30 = HEAP32[i27 >> 2] | 0;
   i26 = i23 + 20 | 0;
   if ((i30 | 0) != 0) {
    if ((HEAP8[i26] | 0) != 0) {
     __Z21btAlignedFreeInternalPv(i30);
    }
    HEAP32[i27 >> 2] = 0;
   }
   HEAP8[i26] = 1;
   HEAP32[i27 >> 2] = i29;
   HEAP32[i28 >> 2] = i22;
   i31 = i27;
  } else {
   i31 = i23 + 16 | 0;
  }
  i23 = i6;
  i6 = i4;
  do {
   i4 = (HEAP32[i31 >> 2] | 0) + (i6 << 4) | 0;
   if ((i4 | 0) != 0) {
    i27 = i4;
    HEAP32[i27 >> 2] = HEAP32[i23 >> 2];
    HEAP32[i27 + 4 >> 2] = HEAP32[i23 + 4 >> 2];
    HEAP32[i27 + 8 >> 2] = HEAP32[i23 + 8 >> 2];
    HEAP32[i27 + 12 >> 2] = HEAP32[i23 + 12 >> 2];
   }
   i6 = i6 + 1 | 0;
  } while ((i6 | 0) < (i22 | 0));
 }
 HEAP32[i21 >> 2] = i22;
 if ((i22 | 0) > 0) {
  i21 = 0;
  do {
   i6 = (HEAP32[(HEAP32[i10 >> 2] | 0) + 16 >> 2] | 0) + (i21 << 4) | 0;
   i23 = (HEAP32[i19 >> 2] | 0) + (i21 << 4) | 0;
   HEAP32[i6 >> 2] = HEAP32[i23 >> 2];
   HEAP32[i6 + 4 >> 2] = HEAP32[i23 + 4 >> 2];
   HEAP32[i6 + 8 >> 2] = HEAP32[i23 + 8 >> 2];
   HEAP32[i6 + 12 >> 2] = HEAP32[i23 + 12 >> 2];
   i21 = i21 + 1 | 0;
  } while ((i21 | 0) < (i22 | 0));
 }
 if (i11) {
  i11 = i7 + 4 | 0;
  i22 = i7 + 24 | 0;
  i21 = i7 + 8 | 0;
  i23 = i7 + 20 | 0;
  i6 = i7 + 16 | 0;
  i31 = i7 | 0;
  i27 = 0;
  while (1) {
   i4 = (HEAP32[i15 >> 2] | 0) + ((HEAP32[(HEAP32[i13 >> 2] | 0) + (i27 << 2) >> 2] | 0) * 12 | 0) | 0;
   i28 = i4;
   i29 = 0;
   while (1) {
    i26 = i28 + 4 | 0;
    i30 = HEAP32[i28 + ((HEAP32[i26 >> 2] | 0) * 12 | 0) + 8 >> 2] | 0;
    i25 = HEAP32[(HEAP32[i10 >> 2] | 0) + 36 >> 2] | 0;
    i5 = i25 + (i27 * 56 | 0) + 4 | 0;
    i12 = HEAP32[i5 >> 2] | 0;
    i32 = i25 + (i27 * 56 | 0) + 8 | 0;
    do {
     if ((i12 | 0) == (HEAP32[i32 >> 2] | 0)) {
      i33 = (i12 | 0) == 0 ? 1 : i12 << 1;
      if ((i12 | 0) >= (i33 | 0)) {
       i34 = i12;
       break;
      }
      if ((i33 | 0) == 0) {
       i35 = 0;
       i36 = i12;
      } else {
       i37 = __Z22btAlignedAllocInternalji(i33 << 2, 16) | 0;
       i35 = i37;
       i36 = HEAP32[i5 >> 2] | 0;
      }
      i37 = i25 + (i27 * 56 | 0) + 12 | 0;
      if ((i36 | 0) > 0) {
       i38 = 0;
       do {
        i39 = i35 + (i38 << 2) | 0;
        if ((i39 | 0) != 0) {
         HEAP32[i39 >> 2] = HEAP32[(HEAP32[i37 >> 2] | 0) + (i38 << 2) >> 2];
        }
        i38 = i38 + 1 | 0;
       } while ((i38 | 0) < (i36 | 0));
      }
      i38 = HEAP32[i37 >> 2] | 0;
      i39 = i25 + (i27 * 56 | 0) + 16 | 0;
      if ((i38 | 0) != 0) {
       if ((HEAP8[i39] | 0) != 0) {
        __Z21btAlignedFreeInternalPv(i38);
       }
       HEAP32[i37 >> 2] = 0;
      }
      HEAP8[i39] = 1;
      HEAP32[i37 >> 2] = i35;
      HEAP32[i32 >> 2] = i33;
      i34 = HEAP32[i5 >> 2] | 0;
     } else {
      i34 = i12;
     }
    } while (0);
    i12 = (HEAP32[i25 + (i27 * 56 | 0) + 12 >> 2] | 0) + (i34 << 2) | 0;
    if ((i12 | 0) == 0) {
     i40 = i34;
    } else {
     HEAP32[i12 >> 2] = i30;
     i40 = HEAP32[i5 >> 2] | 0;
    }
    HEAP32[i5 >> 2] = i40 + 1;
    i12 = HEAP32[i28 + 8 >> 2] | 0;
    i32 = HEAP32[i19 >> 2] | 0;
    d41 = +HEAPF32[i32 + (i12 << 4) >> 2] - +HEAPF32[i32 + (i30 << 4) >> 2];
    d42 = +HEAPF32[i32 + (i12 << 4) + 4 >> 2] - +HEAPF32[i32 + (i30 << 4) + 4 >> 2];
    d43 = +HEAPF32[i32 + (i12 << 4) + 8 >> 2] - +HEAPF32[i32 + (i30 << 4) + 8 >> 2];
    d44 = 1.0 / +Math_sqrt(+(d41 * d41 + d42 * d42 + d43 * d43));
    if ((i29 | 0) < 2) {
     HEAPF32[i7 + (i29 << 4) >> 2] = d41 * d44;
     HEAPF32[i7 + (i29 << 4) + 4 >> 2] = d42 * d44;
     HEAPF32[i7 + (i29 << 4) + 8 >> 2] = d43 * d44;
     HEAPF32[i7 + (i29 << 4) + 12 >> 2] = 0.0;
     i45 = i29 + 1 | 0;
    } else {
     i45 = i29;
    }
    i32 = HEAP32[i26 >> 2] | 0;
    i12 = i28 + (((HEAP32[i28 + (i32 * 12 | 0) >> 2] | 0) + i32 | 0) * 12 | 0) | 0;
    if ((i12 | 0) == (i4 | 0)) {
     break;
    } else {
     i28 = i12;
     i29 = i45;
    }
   }
   i29 = i24 + (i27 << 4) | 0;
   if ((i45 | 0) == 2) {
    d44 = +HEAPF32[i11 >> 2];
    d43 = +HEAPF32[i22 >> 2];
    d42 = +HEAPF32[i21 >> 2];
    d41 = +HEAPF32[i23 >> 2];
    d46 = d44 * d43 - d42 * d41;
    d47 = +HEAPF32[i6 >> 2];
    d48 = +HEAPF32[i31 >> 2];
    d49 = d42 * d47 - d43 * d48;
    d43 = d41 * d48 - d44 * d47;
    i28 = i24 + (i27 << 4) + 4 | 0;
    i4 = i24 + (i27 << 4) + 8 | 0;
    HEAPF32[i24 + (i27 << 4) + 12 >> 2] = 0.0;
    d47 = 1.0 / +Math_sqrt(+(d43 * d43 + (d46 * d46 + d49 * d49)));
    d44 = d46 * d47;
    HEAPF32[i29 >> 2] = d44;
    HEAPF32[i28 >> 2] = d49 * d47;
    HEAPF32[i4 >> 2] = d43 * d47;
    i12 = HEAP32[i10 >> 2] | 0;
    i32 = HEAP32[i12 + 36 >> 2] | 0;
    HEAPF32[i32 + (i27 * 56 | 0) + 40 >> 2] = -0.0 - d44;
    HEAPF32[i32 + (i27 * 56 | 0) + 44 >> 2] = -0.0 - +HEAPF32[i28 >> 2];
    HEAPF32[i32 + (i27 * 56 | 0) + 48 >> 2] = -0.0 - +HEAPF32[i4 >> 2];
    HEAPF32[i32 + (i27 * 56 | 0) + 52 >> 2] = 1.0000000150474662e+30;
    i50 = i12;
    i51 = i32;
   } else {
    _memset(i29 | 0, 0, 16);
    i32 = HEAP32[i10 >> 2] | 0;
    i50 = i32;
    i51 = HEAP32[i32 + 36 >> 2] | 0;
   }
   i32 = HEAP32[i51 + (i27 * 56 | 0) + 4 >> 2] | 0;
   if ((i32 | 0) > 0) {
    d44 = +HEAPF32[i29 >> 2];
    d47 = +HEAPF32[i24 + (i27 << 4) + 4 >> 2];
    d43 = +HEAPF32[i24 + (i27 << 4) + 8 >> 2];
    i29 = HEAP32[i51 + (i27 * 56 | 0) + 12 >> 2] | 0;
    i12 = HEAP32[i50 + 16 >> 2] | 0;
    d49 = 1.0000000150474662e+30;
    i4 = 0;
    while (1) {
     i28 = HEAP32[i29 + (i4 << 2) >> 2] | 0;
     d46 = d44 * +HEAPF32[i12 + (i28 << 4) >> 2] + d47 * +HEAPF32[i12 + (i28 << 4) + 4 >> 2] + d43 * +HEAPF32[i12 + (i28 << 4) + 8 >> 2];
     d48 = d49 > d46 ? d46 : d49;
     i28 = i4 + 1 | 0;
     if ((i28 | 0) < (i32 | 0)) {
      d49 = d48;
      i4 = i28;
     } else {
      d52 = d48;
      break;
     }
    }
   } else {
    d52 = 1.0000000150474662e+30;
   }
   HEAPF32[i51 + (i27 * 56 | 0) + 52 >> 2] = d52;
   i4 = i27 + 1 | 0;
   if ((i4 | 0) < (i14 | 0)) {
    i27 = i4;
   } else {
    i53 = i50;
    break;
   }
  }
 } else {
  i53 = HEAP32[i10 >> 2] | 0;
 }
 i50 = HEAP32[i53 + 28 >> 2] | 0;
 do {
  if ((i50 | 0) == 0) {
   i54 = i53;
  } else {
   if (!((HEAP32[i18 >> 2] | 0) != 0 & (i50 | 0) > 0)) {
    i54 = i53;
    break;
   }
   i27 = i1;
   i14 = i9 | 0;
   i51 = i9 + 4 | 0;
   i31 = i9 + 8 | 0;
   i6 = i9 + 12 | 0;
   i23 = i1 | 0;
   i21 = i8 | 0;
   i22 = i8 + 4 | 0;
   i11 = i8 + 8 | 0;
   i45 = 0;
   i7 = i53;
   while (1) {
    i19 = HEAP32[i7 + 36 >> 2] | 0;
    d52 = +HEAPF32[i19 + (i45 * 56 | 0) + 40 >> 2];
    d49 = +HEAPF32[i19 + (i45 * 56 | 0) + 44 >> 2];
    d43 = +HEAPF32[i19 + (i45 * 56 | 0) + 48 >> 2];
    d47 = +HEAPF32[i19 + (i45 * 56 | 0) + 52 >> 2];
    i19 = HEAP32[(HEAP32[i27 >> 2] | 0) + 60 >> 2] | 0;
    HEAPF32[i14 >> 2] = -0.0 - d52;
    HEAPF32[i51 >> 2] = -0.0 - d49;
    HEAPF32[i31 >> 2] = -0.0 - d43;
    HEAPF32[i6 >> 2] = 0.0;
    FUNCTION_TABLE_viii[i19 & 127](i8, i23, i9);
    i19 = HEAP32[i10 >> 2] | 0;
    do {
     if (d52 * +HEAPF32[i21 >> 2] + d49 * +HEAPF32[i22 >> 2] + d43 * +HEAPF32[i11 >> 2] < d47) {
      i40 = HEAP32[i19 + 36 >> 2] | 0;
      i34 = i40 + (i45 * 56 | 0) + 40 | 0;
      HEAPF32[i34 >> 2] = +HEAPF32[i34 >> 2] * -1.0;
      i34 = i40 + (i45 * 56 | 0) + 44 | 0;
      HEAPF32[i34 >> 2] = +HEAPF32[i34 >> 2] * -1.0;
      i34 = i40 + (i45 * 56 | 0) + 48 | 0;
      HEAPF32[i34 >> 2] = +HEAPF32[i34 >> 2] * -1.0;
      i34 = i40 + (i45 * 56 | 0) + 52 | 0;
      HEAPF32[i34 >> 2] = +HEAPF32[i34 >> 2] * -1.0;
      i34 = HEAP32[i40 + (i45 * 56 | 0) + 4 >> 2] | 0;
      i35 = (i34 | 0) / 2 | 0;
      if ((i34 | 0) <= 1) {
       break;
      }
      i36 = HEAP32[i40 + (i45 * 56 | 0) + 12 >> 2] | 0;
      i40 = i34 - 1 | 0;
      i34 = 0;
      do {
       i13 = i36 + (i34 << 2) | 0;
       i15 = i36 + (i40 - i34 << 2) | 0;
       i4 = HEAP32[i13 >> 2] | 0;
       HEAP32[i13 >> 2] = HEAP32[i15 >> 2];
       HEAP32[i15 >> 2] = i4;
       i34 = i34 + 1 | 0;
      } while ((i34 | 0) < (i35 | 0));
     }
    } while (0);
    i26 = i45 + 1 | 0;
    if ((i26 | 0) < (HEAP32[i19 + 28 >> 2] | 0)) {
     i45 = i26;
     i7 = i19;
    } else {
     i54 = i19;
     break;
    }
   }
  }
 } while (0);
 __ZN18btConvexPolyhedron10initializeEv(i54);
 if ((i24 | 0) != 0) {
  __Z21btAlignedFreeInternalPv(i24);
 }
 __ZN20btConvexHullComputerD2Ev(i3);
 if ((i16 | 0) == 0) {
  STACKTOP = i2;
  return 1;
 }
 __Z21btAlignedFreeInternalPv(i20);
 STACKTOP = i2;
 return 1;
}
function __ZN18btConvexPolyhedron10initializeEv(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, d17 = 0.0, d18 = 0.0, d19 = 0.0, d20 = 0.0, d21 = 0.0, d22 = 0.0, d23 = 0.0, d24 = 0.0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, d49 = 0.0, d50 = 0.0, d51 = 0.0, d52 = 0.0, d53 = 0.0, d54 = 0.0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0, i62 = 0, i63 = 0, i64 = 0, i65 = 0, i66 = 0, i67 = 0, d68 = 0.0, d69 = 0.0, d70 = 0.0, d71 = 0.0, d72 = 0.0, d73 = 0.0, d74 = 0.0, d75 = 0.0, d76 = 0.0, d77 = 0.0, d78 = 0.0, d79 = 0.0, d80 = 0.0, d81 = 0.0, d82 = 0.0, d83 = 0.0, d84 = 0.0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 96 | 0;
 i3 = i2 | 0;
 i4 = i2 + 80 | 0;
 i5 = i2 + 88 | 0;
 HEAP8[i3 + 16 | 0] = 1;
 i6 = i3 + 12 | 0;
 HEAP32[i6 >> 2] = 0;
 i7 = i3 + 4 | 0;
 HEAP32[i7 >> 2] = 0;
 HEAP32[i3 + 8 >> 2] = 0;
 HEAP8[i3 + 36 | 0] = 1;
 i8 = i3 + 32 | 0;
 HEAP32[i8 >> 2] = 0;
 HEAP32[i3 + 24 >> 2] = 0;
 HEAP32[i3 + 28 >> 2] = 0;
 HEAP8[i3 + 56 | 0] = 1;
 i9 = i3 + 52 | 0;
 HEAP32[i9 >> 2] = 0;
 HEAP32[i3 + 44 >> 2] = 0;
 i10 = i3 + 48 | 0;
 HEAP32[i10 >> 2] = 0;
 HEAP8[i3 + 76 | 0] = 1;
 i11 = i3 + 72 | 0;
 HEAP32[i11 >> 2] = 0;
 HEAP32[i3 + 64 >> 2] = 0;
 HEAP32[i3 + 68 >> 2] = 0;
 i12 = i1 + 64 | 0;
 i13 = i1 + 68 | 0;
 i14 = i1 + 72 | 0;
 i15 = i1 + 28 | 0;
 _memset(i12 | 0, 0, 16);
 i16 = HEAP32[i15 >> 2] | 0;
 if ((i16 | 0) <= 0) {
  d17 = 0.0;
  d18 = 1.0 / d17;
  d19 = +HEAPF32[i12 >> 2];
  d20 = d18 * d19;
  HEAPF32[i12 >> 2] = d20;
  d21 = +HEAPF32[i13 >> 2];
  d22 = d18 * d21;
  HEAPF32[i13 >> 2] = d22;
  d23 = +HEAPF32[i14 >> 2];
  d24 = d18 * d23;
  HEAPF32[i14 >> 2] = d24;
  __ZN9btHashMapI20btInternalVertexPair14btInternalEdgeED2Ev(i3);
  STACKTOP = i2;
  return;
 }
 i25 = i1 + 36 | 0;
 i26 = i4 | 0;
 i27 = i4 + 2 | 0;
 i28 = i1 + 16 | 0;
 i29 = i1 + 48 | 0;
 i30 = i5 | 0;
 i31 = i5 + 2 | 0;
 i32 = i1 + 52 | 0;
 i33 = i1 + 56 | 0;
 i34 = i1 + 60 | 0;
 i1 = 0;
 i35 = i16;
 while (1) {
  i16 = HEAP32[i25 >> 2] | 0;
  i36 = HEAP32[i16 + (i1 * 56 | 0) + 4 >> 2] | 0;
  if ((i36 | 0) > 0) {
   i37 = i1 & 65535;
   i38 = 0;
   i39 = i16;
   while (1) {
    i16 = i38 + 1 | 0;
    i40 = HEAP32[i39 + (i1 * 56 | 0) + 12 >> 2] | 0;
    i41 = HEAP32[i40 + (i38 << 2) >> 2] & 65535;
    i42 = HEAP32[i40 + (((i16 | 0) == (i36 | 0) ? 0 : i16) << 2) >> 2] & 65535;
    HEAP16[i26 >> 1] = i41;
    HEAP16[i27 >> 1] = i42;
    if (i41 << 16 >> 16 < i42 << 16 >> 16) {
     HEAP16[i26 >> 1] = i42;
     HEAP16[i27 >> 1] = i41;
     i43 = i42;
     i44 = i41;
    } else {
     i43 = i41;
     i44 = i42;
    }
    i42 = i43 << 16 >> 16;
    i41 = ((i44 & 65535) << 16) + i42 & (HEAP32[i10 >> 2] | 0) - 1;
    L1973 : do {
     if (i41 >>> 0 < (HEAP32[i7 >> 2] | 0) >>> 0) {
      i40 = HEAP32[(HEAP32[i6 >> 2] | 0) + (i41 << 2) >> 2] | 0;
      if ((i40 | 0) == -1) {
       i45 = 0;
       break;
      }
      i46 = HEAP32[i11 >> 2] | 0;
      i47 = HEAP32[i8 >> 2] | 0;
      i48 = i40;
      while (1) {
       if (i43 << 16 >> 16 == (HEAP16[i46 + (i48 << 2) >> 1] | 0)) {
        if (i44 << 16 >> 16 == (HEAP16[i46 + (i48 << 2) + 2 >> 1] | 0)) {
         break;
        }
       }
       i40 = HEAP32[i47 + (i48 << 2) >> 2] | 0;
       if ((i40 | 0) == -1) {
        i45 = 0;
        break L1973;
       } else {
        i48 = i40;
       }
      }
      if ((i48 | 0) == -1) {
       i45 = 0;
       break;
      }
      i45 = (HEAP32[i9 >> 2] | 0) + (i48 << 2) | 0;
     } else {
      i45 = 0;
     }
    } while (0);
    i41 = i44 << 16 >> 16;
    i47 = HEAP32[i28 >> 2] | 0;
    d49 = +HEAPF32[i47 + (i41 << 4) >> 2] - +HEAPF32[i47 + (i42 << 4) >> 2];
    d50 = +HEAPF32[i47 + (i41 << 4) + 4 >> 2] - +HEAPF32[i47 + (i42 << 4) + 4 >> 2];
    d51 = +HEAPF32[i47 + (i41 << 4) + 8 >> 2] - +HEAPF32[i47 + (i42 << 4) + 8 >> 2];
    d52 = 1.0 / +Math_sqrt(+(d49 * d49 + d50 * d50 + d51 * d51));
    d53 = d49 * d52;
    d49 = d50 * d52;
    d50 = d51 * d52;
    i47 = HEAP32[i29 >> 2] | 0;
    L1984 : do {
     if ((i47 | 0) > 0) {
      i41 = HEAP32[i33 >> 2] | 0;
      i46 = 0;
      while (1) {
       d52 = +HEAPF32[i41 + (i46 << 4) >> 2];
       d51 = +HEAPF32[i41 + (i46 << 4) + 8 >> 2];
       d54 = d51 - d50;
       do {
        if (+Math_abs(+(d52 - d53)) <= 1.0e-6) {
         if (+Math_abs(+(+HEAPF32[i41 + (i46 << 4) + 4 >> 2] - d49)) > 1.0e-6) {
          break;
         }
         if (+Math_abs(+d54) <= 1.0e-6) {
          break L1984;
         }
        }
       } while (0);
       d54 = d50 + d51;
       do {
        if (+Math_abs(+(d53 + d52)) <= 1.0e-6) {
         if (+Math_abs(+(d49 + +HEAPF32[i41 + (i46 << 4) + 4 >> 2])) > 1.0e-6) {
          break;
         }
         if (+Math_abs(+d54) <= 1.0e-6) {
          break L1984;
         }
        }
       } while (0);
       i40 = i46 + 1 | 0;
       if ((i40 | 0) < (i47 | 0)) {
        i46 = i40;
       } else {
        i55 = 1714;
        break;
       }
      }
     } else {
      i55 = 1714;
     }
    } while (0);
    if ((i55 | 0) == 1714) {
     i55 = 0;
     do {
      if ((i47 | 0) == (HEAP32[i32 >> 2] | 0)) {
       i42 = (i47 | 0) == 0 ? 1 : i47 << 1;
       if ((i47 | 0) >= (i42 | 0)) {
        i56 = i47;
        break;
       }
       if ((i42 | 0) == 0) {
        i57 = 0;
        i58 = i47;
       } else {
        i46 = __Z22btAlignedAllocInternalji(i42 << 4, 16) | 0;
        i57 = i46;
        i58 = HEAP32[i29 >> 2] | 0;
       }
       if ((i58 | 0) > 0) {
        i46 = 0;
        do {
         i41 = i57 + (i46 << 4) | 0;
         if ((i41 | 0) != 0) {
          i48 = i41;
          i41 = (HEAP32[i33 >> 2] | 0) + (i46 << 4) | 0;
          HEAP32[i48 >> 2] = HEAP32[i41 >> 2];
          HEAP32[i48 + 4 >> 2] = HEAP32[i41 + 4 >> 2];
          HEAP32[i48 + 8 >> 2] = HEAP32[i41 + 8 >> 2];
          HEAP32[i48 + 12 >> 2] = HEAP32[i41 + 12 >> 2];
         }
         i46 = i46 + 1 | 0;
        } while ((i46 | 0) < (i58 | 0));
       }
       i46 = HEAP32[i33 >> 2] | 0;
       if ((i46 | 0) != 0) {
        if ((HEAP8[i34] | 0) != 0) {
         __Z21btAlignedFreeInternalPv(i46);
        }
        HEAP32[i33 >> 2] = 0;
       }
       HEAP8[i34] = 1;
       HEAP32[i33 >> 2] = i57;
       HEAP32[i32 >> 2] = i42;
       i56 = HEAP32[i29 >> 2] | 0;
      } else {
       i56 = i47;
      }
     } while (0);
     i47 = HEAP32[i33 >> 2] | 0;
     i46 = i47 + (i56 << 4) | 0;
     if ((i46 | 0) == 0) {
      i59 = i56;
     } else {
      HEAPF32[i46 >> 2] = d53;
      HEAPF32[i47 + (i56 << 4) + 4 >> 2] = d49;
      HEAPF32[i47 + (i56 << 4) + 8 >> 2] = d50;
      HEAPF32[i47 + (i56 << 4) + 12 >> 2] = 0.0;
      i59 = HEAP32[i29 >> 2] | 0;
     }
     HEAP32[i29 >> 2] = i59 + 1;
    }
    if ((i45 | 0) == 0) {
     HEAP16[i31 >> 1] = -1;
     HEAP16[i30 >> 1] = i37;
     __ZN9btHashMapI20btInternalVertexPair14btInternalEdgeE6insertERKS0_RKS1_(i3, i4, i5);
    } else {
     HEAP16[i45 + 2 >> 1] = i37;
    }
    if ((i16 | 0) >= (i36 | 0)) {
     break;
    }
    i38 = i16;
    i39 = HEAP32[i25 >> 2] | 0;
   }
   i60 = HEAP32[i15 >> 2] | 0;
  } else {
   i60 = i35;
  }
  i39 = i1 + 1 | 0;
  if ((i39 | 0) < (i60 | 0)) {
   i1 = i39;
   i35 = i60;
  } else {
   break;
  }
 }
 if ((i60 | 0) <= 0) {
  d17 = 0.0;
  d18 = 1.0 / d17;
  d19 = +HEAPF32[i12 >> 2];
  d20 = d18 * d19;
  HEAPF32[i12 >> 2] = d20;
  d21 = +HEAPF32[i13 >> 2];
  d22 = d18 * d21;
  HEAPF32[i13 >> 2] = d22;
  d23 = +HEAPF32[i14 >> 2];
  d24 = d18 * d23;
  HEAPF32[i14 >> 2] = d24;
  __ZN9btHashMapI20btInternalVertexPair14btInternalEdgeED2Ev(i3);
  STACKTOP = i2;
  return;
 }
 i60 = (HEAP32[i10 >> 2] | 0) - 1 | 0;
 i10 = HEAP32[i7 >> 2] | 0;
 i7 = HEAP32[i6 >> 2] | 0;
 i6 = HEAP32[i11 >> 2] | 0;
 i11 = HEAP32[i8 >> 2] | 0;
 i8 = HEAP32[i9 >> 2] | 0;
 i9 = 0;
 do {
  i35 = HEAP32[i25 >> 2] | 0;
  i1 = HEAP32[i35 + (i9 * 56 | 0) + 4 >> 2] | 0;
  i45 = i35 + (i9 * 56 | 0) + 24 | 0;
  i5 = HEAP32[i45 >> 2] | 0;
  if ((i5 | 0) < (i1 | 0)) {
   i4 = i35 + (i9 * 56 | 0) + 28 | 0;
   if ((HEAP32[i4 >> 2] | 0) < (i1 | 0)) {
    if ((i1 | 0) == 0) {
     i61 = 0;
     i62 = i5;
    } else {
     i30 = __Z22btAlignedAllocInternalji(i1 << 2, 16) | 0;
     i61 = i30;
     i62 = HEAP32[i45 >> 2] | 0;
    }
    i30 = i35 + (i9 * 56 | 0) + 32 | 0;
    if ((i62 | 0) > 0) {
     i31 = 0;
     do {
      i59 = i61 + (i31 << 2) | 0;
      if ((i59 | 0) != 0) {
       HEAP32[i59 >> 2] = HEAP32[(HEAP32[i30 >> 2] | 0) + (i31 << 2) >> 2];
      }
      i31 = i31 + 1 | 0;
     } while ((i31 | 0) < (i62 | 0));
    }
    i31 = HEAP32[i30 >> 2] | 0;
    i59 = i35 + (i9 * 56 | 0) + 36 | 0;
    if ((i31 | 0) != 0) {
     if ((HEAP8[i59] | 0) != 0) {
      __Z21btAlignedFreeInternalPv(i31);
     }
     HEAP32[i30 >> 2] = 0;
    }
    HEAP8[i59] = 1;
    HEAP32[i30 >> 2] = i61;
    HEAP32[i4 >> 2] = i1;
    i63 = i61;
   } else {
    i63 = HEAP32[i35 + (i9 * 56 | 0) + 32 >> 2] | 0;
   }
   i59 = i5;
   do {
    i31 = i63 + (i59 << 2) | 0;
    if ((i31 | 0) != 0) {
     HEAP32[i31 >> 2] = 0;
    }
    i59 = i59 + 1 | 0;
   } while ((i59 | 0) < (i1 | 0));
  }
  HEAP32[i45 >> 2] = i1;
  if ((i1 | 0) > 0) {
   i59 = HEAP32[i25 >> 2] | 0;
   i5 = HEAP32[i59 + (i9 * 56 | 0) + 12 >> 2] | 0;
   i35 = i59 + (i9 * 56 | 0) + 32 | 0;
   i59 = 0;
   while (1) {
    i4 = i59 + 1 | 0;
    i30 = HEAP32[i5 + (i59 << 2) >> 2] & 65535;
    i31 = HEAP32[i5 + (((i4 | 0) == (i1 | 0) ? 0 : i4) << 2) >> 2] & 65535;
    i29 = i30 << 16 >> 16 < i31 << 16 >> 16;
    i56 = i29 ? i30 : i31;
    i33 = i29 ? i31 : i30;
    i30 = ((i56 & 65535) << 16) + (i33 << 16 >> 16) & i60;
    L2069 : do {
     if (i30 >>> 0 < i10 >>> 0) {
      i31 = HEAP32[i7 + (i30 << 2) >> 2] | 0;
      if ((i31 | 0) == -1) {
       i64 = 0;
       break;
      } else {
       i65 = i31;
      }
      while (1) {
       if (i33 << 16 >> 16 == (HEAP16[i6 + (i65 << 2) >> 1] | 0)) {
        if (i56 << 16 >> 16 == (HEAP16[i6 + (i65 << 2) + 2 >> 1] | 0)) {
         break;
        }
       }
       i31 = HEAP32[i11 + (i65 << 2) >> 2] | 0;
       if ((i31 | 0) == -1) {
        i64 = 0;
        break L2069;
       } else {
        i65 = i31;
       }
      }
      if ((i65 | 0) == -1) {
       i64 = 0;
       break;
      }
      i64 = i8 + (i65 << 2) | 0;
     } else {
      i64 = 0;
     }
    } while (0);
    i56 = HEAP16[i64 >> 1] | 0;
    if ((i56 << 16 >> 16 | 0) == (i9 | 0)) {
     i66 = HEAP16[i64 + 2 >> 1] | 0;
    } else {
     i66 = i56;
    }
    HEAP32[(HEAP32[i35 >> 2] | 0) + (i59 << 2) >> 2] = i66 << 16 >> 16;
    if ((i4 | 0) < (i1 | 0)) {
     i59 = i4;
    } else {
     break;
    }
   }
  }
  i9 = i9 + 1 | 0;
  i67 = HEAP32[i15 >> 2] | 0;
 } while ((i9 | 0) < (i67 | 0));
 if ((i67 | 0) <= 0) {
  d17 = 0.0;
  d18 = 1.0 / d17;
  d19 = +HEAPF32[i12 >> 2];
  d20 = d18 * d19;
  HEAPF32[i12 >> 2] = d20;
  d21 = +HEAPF32[i13 >> 2];
  d22 = d18 * d21;
  HEAPF32[i13 >> 2] = d22;
  d23 = +HEAPF32[i14 >> 2];
  d24 = d18 * d23;
  HEAPF32[i14 >> 2] = d24;
  __ZN9btHashMapI20btInternalVertexPair14btInternalEdgeED2Ev(i3);
  STACKTOP = i2;
  return;
 }
 i9 = HEAP32[i25 >> 2] | 0;
 i25 = HEAP32[i28 >> 2] | 0;
 d50 = 0.0;
 i28 = 0;
 while (1) {
  i15 = HEAP32[i9 + (i28 * 56 | 0) + 4 >> 2] | 0;
  i66 = i15 - 2 | 0;
  i64 = HEAP32[i9 + (i28 * 56 | 0) + 12 >> 2] | 0;
  i65 = HEAP32[i64 >> 2] | 0;
  if ((i66 | 0) < 1) {
   d68 = d50;
  } else {
   i8 = i25 + (i65 << 4) | 0;
   i11 = i25 + (i65 << 4) + 4 | 0;
   i6 = i25 + (i65 << 4) + 8 | 0;
   d49 = d50;
   i65 = 1;
   d53 = +HEAPF32[i12 >> 2];
   d54 = +HEAPF32[i13 >> 2];
   d52 = +HEAPF32[i14 >> 2];
   while (1) {
    i7 = i65 + 1 | 0;
    i10 = HEAP32[i64 + (i65 << 2) >> 2] | 0;
    i60 = HEAP32[i64 + (((i7 | 0) % (i15 | 0) | 0) << 2) >> 2] | 0;
    d51 = +HEAPF32[i8 >> 2];
    d69 = +HEAPF32[i25 + (i10 << 4) >> 2];
    d70 = d51 - d69;
    d71 = +HEAPF32[i11 >> 2];
    d72 = +HEAPF32[i25 + (i10 << 4) + 4 >> 2];
    d73 = d71 - d72;
    d74 = +HEAPF32[i6 >> 2];
    d75 = +HEAPF32[i25 + (i10 << 4) + 8 >> 2];
    d76 = d74 - d75;
    d77 = +HEAPF32[i25 + (i60 << 4) >> 2];
    d78 = d51 - d77;
    d79 = +HEAPF32[i25 + (i60 << 4) + 4 >> 2];
    d80 = d71 - d79;
    d81 = +HEAPF32[i25 + (i60 << 4) + 8 >> 2];
    d82 = d74 - d81;
    d83 = d73 * d82 - d76 * d80;
    d84 = d76 * d78 - d70 * d82;
    d82 = d70 * d80 - d73 * d78;
    d78 = +Math_sqrt(+(d82 * d82 + (d83 * d83 + d84 * d84))) * .5;
    d84 = d53 + (d51 + d69 + d77) * .3333333432674408 * d78;
    HEAPF32[i12 >> 2] = d84;
    d77 = d54 + (d71 + d72 + d79) * .3333333432674408 * d78;
    HEAPF32[i13 >> 2] = d77;
    d79 = d52 + d78 * (d74 + d75 + d81) * .3333333432674408;
    HEAPF32[i14 >> 2] = d79;
    d81 = d49 + d78;
    if ((i7 | 0) > (i66 | 0)) {
     d68 = d81;
     break;
    } else {
     d49 = d81;
     i65 = i7;
     d53 = d84;
     d54 = d77;
     d52 = d79;
    }
   }
  }
  i65 = i28 + 1 | 0;
  if ((i65 | 0) < (i67 | 0)) {
   d50 = d68;
   i28 = i65;
  } else {
   d17 = d68;
   break;
  }
 }
 d18 = 1.0 / d17;
 d19 = +HEAPF32[i12 >> 2];
 d20 = d18 * d19;
 HEAPF32[i12 >> 2] = d20;
 d21 = +HEAPF32[i13 >> 2];
 d22 = d18 * d21;
 HEAPF32[i13 >> 2] = d22;
 d23 = +HEAPF32[i14 >> 2];
 d24 = d18 * d23;
 HEAPF32[i14 >> 2] = d24;
 __ZN9btHashMapI20btInternalVertexPair14btInternalEdgeED2Ev(i3);
 STACKTOP = i2;
 return;
}
function __ZN12gjkepa2_impl3EPA8EvaluateERNS_3GJKERK9btVector3(i1, i2, i3) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 var i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, d18 = 0.0, d19 = 0.0, d20 = 0.0, d21 = 0.0, d22 = 0.0, d23 = 0.0, i24 = 0, d25 = 0.0, d26 = 0.0, d27 = 0.0, i28 = 0, i29 = 0, d30 = 0.0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, d36 = 0.0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, d50 = 0.0, d51 = 0.0, d52 = 0.0, d53 = 0.0, d54 = 0.0, d55 = 0.0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0, d62 = 0.0, d63 = 0.0, d64 = 0.0, d65 = 0.0, d66 = 0.0, i67 = 0, d68 = 0.0, d69 = 0.0, d70 = 0.0, d71 = 0.0, d72 = 0.0, d73 = 0.0, d74 = 0.0, i75 = 0, d76 = 0.0, d77 = 0.0, d78 = 0.0;
 i4 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i5 = i4 | 0;
 i6 = HEAP32[i2 + 372 >> 2] | 0;
 do {
  if ((HEAP32[i6 + 32 >> 2] | 0) >>> 0 > 1) {
   if (!(__ZN12gjkepa2_impl3GJK13EncloseOriginEv(i2) | 0)) {
    break;
   }
   i7 = i1 + 9792 | 0;
   i8 = HEAP32[i7 >> 2] | 0;
   if ((i8 | 0) != 0) {
    i9 = i1 + 9796 | 0;
    i10 = i1 + 9800 | 0;
    i11 = i1 + 9804 | 0;
    i12 = i8;
    i8 = HEAP32[i9 >> 2] | 0;
    i13 = HEAP32[i11 >> 2] | 0;
    do {
     i14 = i12 + 52 | 0;
     i15 = HEAP32[i14 >> 2] | 0;
     i16 = i12 + 48 | 0;
     if ((i15 | 0) != 0) {
      HEAP32[i15 + 48 >> 2] = HEAP32[i16 >> 2];
     }
     i15 = HEAP32[i16 >> 2] | 0;
     if ((i15 | 0) != 0) {
      HEAP32[i15 + 52 >> 2] = HEAP32[i14 >> 2];
     }
     if ((HEAP32[i7 >> 2] | 0) == (i12 | 0)) {
      HEAP32[i7 >> 2] = HEAP32[i14 >> 2];
     }
     i8 = i8 - 1 | 0;
     HEAP32[i16 >> 2] = 0;
     HEAP32[i14 >> 2] = HEAP32[i10 >> 2];
     i14 = HEAP32[i10 >> 2] | 0;
     if ((i14 | 0) != 0) {
      HEAP32[i14 + 48 >> 2] = i12;
     }
     HEAP32[i10 >> 2] = i12;
     i13 = i13 + 1 | 0;
     i12 = HEAP32[i7 >> 2] | 0;
    } while ((i12 | 0) != 0);
    HEAP32[i9 >> 2] = i8;
    HEAP32[i11 >> 2] = i13;
   }
   i12 = i1 | 0;
   HEAP32[i12 >> 2] = 0;
   i10 = i1 + 9788 | 0;
   HEAP32[i10 >> 2] = 0;
   i14 = i6 | 0;
   i16 = HEAP32[i14 >> 2] | 0;
   i15 = i6 + 12 | 0;
   i17 = HEAP32[i15 >> 2] | 0;
   d18 = +HEAPF32[i17 + 16 >> 2];
   d19 = +HEAPF32[i16 + 16 >> 2] - d18;
   d20 = +HEAPF32[i17 + 20 >> 2];
   d21 = +HEAPF32[i16 + 20 >> 2] - d20;
   d22 = +HEAPF32[i17 + 24 >> 2];
   d23 = +HEAPF32[i16 + 24 >> 2] - d22;
   i17 = i6 + 4 | 0;
   i24 = HEAP32[i17 >> 2] | 0;
   d25 = +HEAPF32[i24 + 16 >> 2] - d18;
   d26 = +HEAPF32[i24 + 20 >> 2] - d20;
   d27 = +HEAPF32[i24 + 24 >> 2] - d22;
   i28 = i6 + 8 | 0;
   i29 = HEAP32[i28 >> 2] | 0;
   d30 = +HEAPF32[i29 + 16 >> 2] - d18;
   d18 = +HEAPF32[i29 + 20 >> 2] - d20;
   d20 = +HEAPF32[i29 + 24 >> 2] - d22;
   if (d19 * d26 * d20 + (d21 * d27 * d30 + d23 * d25 * d18 - d19 * d27 * d18 - d21 * d25 * d20) - d23 * d26 * d30 < 0.0) {
    HEAP32[i14 >> 2] = i24;
    HEAP32[i17 >> 2] = i16;
    i31 = i6 + 16 | 0;
    i32 = i6 + 20 | 0;
    d30 = +HEAPF32[i31 >> 2];
    HEAPF32[i31 >> 2] = +HEAPF32[i32 >> 2];
    HEAPF32[i32 >> 2] = d30;
    i33 = i24;
    i34 = i16;
   } else {
    i33 = i16;
    i34 = i24;
   }
   i24 = __ZN12gjkepa2_impl3EPA7newfaceEPNS_3GJK3sSVES3_S3_b(i1, i33, i34, i29, 1) | 0;
   i29 = __ZN12gjkepa2_impl3EPA7newfaceEPNS_3GJK3sSVES3_S3_b(i1, HEAP32[i17 >> 2] | 0, HEAP32[i14 >> 2] | 0, HEAP32[i15 >> 2] | 0, 1) | 0;
   i16 = __ZN12gjkepa2_impl3EPA7newfaceEPNS_3GJK3sSVES3_S3_b(i1, HEAP32[i28 >> 2] | 0, HEAP32[i17 >> 2] | 0, HEAP32[i15 >> 2] | 0, 1) | 0;
   i17 = __ZN12gjkepa2_impl3EPA7newfaceEPNS_3GJK3sSVES3_S3_b(i1, HEAP32[i14 >> 2] | 0, HEAP32[i28 >> 2] | 0, HEAP32[i15 >> 2] | 0, 1) | 0;
   i15 = i1 + 9796 | 0;
   if ((HEAP32[i15 >> 2] | 0) != 4) {
    break;
   }
   i28 = HEAP32[i7 >> 2] | 0;
   d30 = +HEAPF32[i28 + 16 >> 2];
   i14 = HEAP32[i28 + 52 >> 2] | 0;
   if ((i14 | 0) == 0) {
    i35 = i28;
    d36 = d30;
   } else {
    d26 = d30 * d30;
    d30 = +HEAPF32[i28 + 20 >> 2];
    i32 = i28;
    i28 = i14;
    while (1) {
     d23 = +HEAPF32[i28 + 16 >> 2];
     d20 = d23 * d23;
     d23 = +HEAPF32[i28 + 20 >> 2];
     i14 = d23 >= d30 & d20 < d26;
     i37 = i14 ? i28 : i32;
     i31 = HEAP32[i28 + 52 >> 2] | 0;
     if ((i31 | 0) == 0) {
      break;
     } else {
      d26 = i14 ? d20 : d26;
      d30 = i14 ? d23 : d30;
      i32 = i37;
      i28 = i31;
     }
    }
    i35 = i37;
    d36 = +HEAPF32[i37 + 16 >> 2];
   }
   d30 = +HEAPF32[i35 >> 2];
   d26 = +HEAPF32[i35 + 4 >> 2];
   d23 = +HEAPF32[i35 + 8 >> 2];
   d20 = +HEAPF32[i35 + 12 >> 2];
   d25 = +HEAPF32[i35 + 20 >> 2];
   i28 = HEAP32[i35 + 24 >> 2] | 0;
   i32 = HEAP32[i35 + 28 >> 2] | 0;
   i13 = HEAP32[i35 + 32 >> 2] | 0;
   HEAP8[i24 + 56 | 0] = 0;
   HEAP32[i24 + 36 >> 2] = i29;
   HEAP8[i29 + 56 | 0] = 0;
   HEAP32[i29 + 36 >> 2] = i24;
   HEAP8[i24 + 57 | 0] = 0;
   HEAP32[i24 + 40 >> 2] = i16;
   HEAP8[i16 + 56 | 0] = 1;
   HEAP32[i16 + 36 >> 2] = i24;
   HEAP8[i24 + 58 | 0] = 0;
   HEAP32[i24 + 44 >> 2] = i17;
   HEAP8[i17 + 56 | 0] = 2;
   HEAP32[i17 + 36 >> 2] = i24;
   HEAP8[i29 + 57 | 0] = 2;
   HEAP32[i29 + 40 >> 2] = i17;
   HEAP8[i17 + 58 | 0] = 1;
   HEAP32[i17 + 44 >> 2] = i29;
   HEAP8[i29 + 58 | 0] = 1;
   HEAP32[i29 + 44 >> 2] = i16;
   HEAP8[i16 + 57 | 0] = 2;
   HEAP32[i16 + 40 >> 2] = i29;
   HEAP8[i16 + 58 | 0] = 1;
   HEAP32[i16 + 44 >> 2] = i17;
   HEAP8[i17 + 57 | 0] = 2;
   HEAP32[i17 + 40 >> 2] = i16;
   HEAP32[i12 >> 2] = 0;
   i11 = i5 | 0;
   i8 = i5 + 4 | 0;
   i9 = i5 + 8 | 0;
   i31 = i1 + 9800 | 0;
   i14 = i1 + 9804 | 0;
   i38 = i13;
   i13 = i32;
   i32 = i28;
   d21 = d25;
   d25 = d36;
   d18 = d20;
   d20 = d23;
   d23 = d26;
   d26 = d30;
   i28 = 0;
   i39 = 1;
   i40 = i35;
   while (1) {
    i41 = HEAP32[i10 >> 2] | 0;
    if (i41 >>> 0 >= 64) {
     i42 = 114;
     break;
    }
    HEAP32[i11 >> 2] = 0;
    HEAP32[i8 >> 2] = 0;
    HEAP32[i9 >> 2] = 0;
    HEAP32[i10 >> 2] = i41 + 1;
    i43 = i1 + 60 + (i41 << 5) | 0;
    HEAP8[i40 + 59 | 0] = i39 & 255;
    __ZNK12gjkepa2_impl3GJK10getsupportERK9btVector3RNS0_3sSVE(i2, i40 | 0, i43);
    if (+HEAPF32[i40 >> 2] * +HEAPF32[i1 + 60 + (i41 << 5) + 16 >> 2] + +HEAPF32[i40 + 4 >> 2] * +HEAPF32[i1 + 60 + (i41 << 5) + 20 >> 2] + +HEAPF32[i40 + 8 >> 2] * +HEAPF32[i1 + 60 + (i41 << 5) + 24 >> 2] - +HEAPF32[i40 + 16 >> 2] > 9999999747378752.0e-20) {
     i44 = 1;
     i45 = 0;
    } else {
     i42 = 113;
     break;
    }
    do {
     i44 = i44 & (__ZN12gjkepa2_impl3EPA6expandEjPNS_3GJK3sSVEPNS0_5sFaceEjRNS0_8sHorizonE(i1, i39, i43, HEAP32[i40 + 36 + (i45 << 2) >> 2] | 0, HEAPU8[i40 + 56 + i45 | 0] | 0, i5) | 0);
     i45 = i45 + 1 | 0;
    } while (!(i45 >>> 0 > 2 | i44 ^ 1));
    if (!i44) {
     i42 = 112;
     break;
    }
    if ((HEAP32[i9 >> 2] | 0) >>> 0 <= 2) {
     i42 = 112;
     break;
    }
    i43 = HEAP32[i11 >> 2] | 0;
    i41 = HEAP32[i8 >> 2] | 0;
    HEAP8[i43 + 57 | 0] = 2;
    HEAP32[i43 + 40 >> 2] = i41;
    HEAP8[i41 + 58 | 0] = 1;
    HEAP32[i41 + 44 >> 2] = i43;
    i43 = i40 + 52 | 0;
    i41 = HEAP32[i43 >> 2] | 0;
    i46 = i40 + 48 | 0;
    if ((i41 | 0) != 0) {
     HEAP32[i41 + 48 >> 2] = HEAP32[i46 >> 2];
    }
    i41 = HEAP32[i46 >> 2] | 0;
    if ((i41 | 0) != 0) {
     HEAP32[i41 + 52 >> 2] = HEAP32[i43 >> 2];
    }
    if ((HEAP32[i7 >> 2] | 0) == (i40 | 0)) {
     HEAP32[i7 >> 2] = HEAP32[i43 >> 2];
    }
    HEAP32[i15 >> 2] = (HEAP32[i15 >> 2] | 0) - 1;
    HEAP32[i46 >> 2] = 0;
    HEAP32[i43 >> 2] = HEAP32[i31 >> 2];
    i43 = HEAP32[i31 >> 2] | 0;
    if ((i43 | 0) != 0) {
     HEAP32[i43 + 48 >> 2] = i40;
    }
    HEAP32[i31 >> 2] = i40;
    HEAP32[i14 >> 2] = (HEAP32[i14 >> 2] | 0) + 1;
    i43 = HEAP32[i7 >> 2] | 0;
    d30 = +HEAPF32[i43 + 16 >> 2];
    i46 = HEAP32[i43 + 52 >> 2] | 0;
    if ((i46 | 0) == 0) {
     i47 = i43;
    } else {
     d27 = d30 * d30;
     d30 = +HEAPF32[i43 + 20 >> 2];
     i41 = i43;
     i43 = i46;
     while (1) {
      d19 = +HEAPF32[i43 + 16 >> 2];
      d22 = d19 * d19;
      d19 = +HEAPF32[i43 + 20 >> 2];
      i46 = d19 >= d30 & d22 < d27;
      i48 = i46 ? i43 : i41;
      i49 = HEAP32[i43 + 52 >> 2] | 0;
      if ((i49 | 0) == 0) {
       i47 = i48;
       break;
      } else {
       d27 = i46 ? d22 : d27;
       d30 = i46 ? d19 : d30;
       i41 = i48;
       i43 = i49;
      }
     }
    }
    d30 = +HEAPF32[i47 + 20 >> 2];
    if (d30 < d21) {
     d50 = d26;
     d51 = d23;
     d52 = d20;
     d53 = d18;
     d54 = d25;
     d55 = d21;
     i56 = i32;
     i57 = i13;
     i58 = i38;
    } else {
     d50 = +HEAPF32[i47 >> 2];
     d51 = +HEAPF32[i47 + 4 >> 2];
     d52 = +HEAPF32[i47 + 8 >> 2];
     d53 = +HEAPF32[i47 + 12 >> 2];
     d54 = +HEAPF32[i47 + 16 >> 2];
     d55 = d30;
     i56 = HEAP32[i47 + 24 >> 2] | 0;
     i57 = HEAP32[i47 + 28 >> 2] | 0;
     i58 = HEAP32[i47 + 32 >> 2] | 0;
    }
    i43 = i28 + 1 | 0;
    if (i43 >>> 0 < 255) {
     i38 = i58;
     i13 = i57;
     i32 = i56;
     d21 = d55;
     d25 = d54;
     d18 = d53;
     d20 = d52;
     d23 = d51;
     d26 = d50;
     i28 = i43;
     i39 = i39 + 1 | 0;
     i40 = i47;
    } else {
     i42 = 116;
     break;
    }
   }
   if ((i42 | 0) == 112) {
    HEAP32[i12 >> 2] = 4;
    i59 = i38;
    i60 = i13;
    i61 = i32;
    d62 = d25;
    d63 = d18;
    d64 = d20;
    d65 = d23;
    d66 = d26;
    i67 = 4;
   } else if ((i42 | 0) == 113) {
    HEAP32[i12 >> 2] = 7;
    i59 = i38;
    i60 = i13;
    i61 = i32;
    d62 = d25;
    d63 = d18;
    d64 = d20;
    d65 = d23;
    d66 = d26;
    i67 = 7;
   } else if ((i42 | 0) == 114) {
    HEAP32[i12 >> 2] = 6;
    i59 = i38;
    i60 = i13;
    i61 = i32;
    d62 = d25;
    d63 = d18;
    d64 = d20;
    d65 = d23;
    d66 = d26;
    i67 = 6;
   } else if ((i42 | 0) == 116) {
    i59 = i58;
    i60 = i57;
    i61 = i56;
    d62 = d54;
    d63 = d53;
    d64 = d52;
    d65 = d51;
    d66 = d50;
    i67 = HEAP32[i12 >> 2] | 0;
   }
   d21 = d66 * d62;
   d30 = d65 * d62;
   d27 = d64 * d62;
   HEAPF32[i1 + 40 >> 2] = d66;
   HEAPF32[i1 + 44 >> 2] = d65;
   HEAPF32[i1 + 48 >> 2] = d64;
   HEAPF32[i1 + 52 >> 2] = d63;
   HEAPF32[i1 + 56 >> 2] = d62;
   HEAP32[i1 + 36 >> 2] = 3;
   HEAP32[i1 + 4 >> 2] = i61;
   HEAP32[i1 + 8 >> 2] = i60;
   HEAP32[i1 + 12 >> 2] = i59;
   i40 = i60 + 16 | 0;
   d19 = +HEAPF32[i40 >> 2] - d21;
   i39 = i60 + 20 | 0;
   d22 = +HEAPF32[i39 >> 2] - d30;
   i28 = i60 + 24 | 0;
   d68 = +HEAPF32[i28 >> 2] - d27;
   i7 = i59 + 16 | 0;
   d69 = +HEAPF32[i7 >> 2] - d21;
   i14 = i59 + 20 | 0;
   d70 = +HEAPF32[i14 >> 2] - d30;
   i31 = i59 + 24 | 0;
   d71 = +HEAPF32[i31 >> 2] - d27;
   d72 = d22 * d71 - d68 * d70;
   d73 = d68 * d69 - d19 * d71;
   d71 = d19 * d70 - d22 * d69;
   d69 = +Math_sqrt(+(d71 * d71 + (d72 * d72 + d73 * d73)));
   i15 = i1 + 20 | 0;
   HEAPF32[i15 >> 2] = d69;
   d73 = +HEAPF32[i7 >> 2] - d21;
   d72 = +HEAPF32[i14 >> 2] - d30;
   d71 = +HEAPF32[i31 >> 2] - d27;
   i31 = i61 + 16 | 0;
   d22 = +HEAPF32[i31 >> 2] - d21;
   i14 = i61 + 20 | 0;
   d70 = +HEAPF32[i14 >> 2] - d30;
   i7 = i61 + 24 | 0;
   d19 = +HEAPF32[i7 >> 2] - d27;
   d68 = d72 * d19 - d71 * d70;
   d74 = d71 * d22 - d73 * d19;
   d19 = d73 * d70 - d72 * d22;
   d22 = +Math_sqrt(+(d19 * d19 + (d68 * d68 + d74 * d74)));
   i8 = i1 + 24 | 0;
   HEAPF32[i8 >> 2] = d22;
   d74 = +HEAPF32[i31 >> 2] - d21;
   d68 = +HEAPF32[i14 >> 2] - d30;
   d19 = +HEAPF32[i7 >> 2] - d27;
   d72 = +HEAPF32[i40 >> 2] - d21;
   d21 = +HEAPF32[i39 >> 2] - d30;
   d30 = +HEAPF32[i28 >> 2] - d27;
   d27 = d68 * d30 - d19 * d21;
   d70 = d19 * d72 - d74 * d30;
   d30 = d74 * d21 - d68 * d72;
   d72 = +Math_sqrt(+(d30 * d30 + (d27 * d27 + d70 * d70)));
   d70 = d69 + d22 + d72;
   HEAPF32[i15 >> 2] = d69 / d70;
   HEAPF32[i8 >> 2] = d22 / d70;
   HEAPF32[i1 + 28 >> 2] = d72 / d70;
   i75 = i67;
   STACKTOP = i4;
   return i75 | 0;
  }
 } while (0);
 HEAP32[i1 >> 2] = 8;
 d62 = +HEAPF32[i3 >> 2];
 d63 = -0.0 - d62;
 d64 = +HEAPF32[i3 + 4 >> 2];
 d65 = -0.0 - d64;
 d66 = +HEAPF32[i3 + 8 >> 2];
 d50 = -0.0 - d66;
 i3 = i1 + 40 | 0;
 HEAPF32[i3 >> 2] = d63;
 i67 = i1 + 44 | 0;
 HEAPF32[i67 >> 2] = d65;
 i61 = i1 + 48 | 0;
 HEAPF32[i61 >> 2] = d50;
 i59 = i1 + 52 | 0;
 HEAPF32[i59 >> 2] = 0.0;
 d51 = +Math_sqrt(+(d62 * d62 + d64 * d64 + d66 * d66));
 if (d51 > 0.0) {
  d66 = 1.0 / d51;
  d76 = d66 * d50;
  d77 = d66 * d65;
  d78 = d66 * d63;
 } else {
  d76 = 0.0;
  d77 = 0.0;
  d78 = 1.0;
 }
 HEAPF32[i3 >> 2] = d78;
 HEAPF32[i67 >> 2] = d77;
 HEAPF32[i61 >> 2] = d76;
 HEAPF32[i59 >> 2] = 0.0;
 HEAPF32[i1 + 56 >> 2] = 0.0;
 HEAP32[i1 + 36 >> 2] = 1;
 HEAP32[i1 + 4 >> 2] = HEAP32[i6 >> 2];
 HEAPF32[i1 + 20 >> 2] = 1.0;
 i75 = 8;
 STACKTOP = i4;
 return i75 | 0;
}
function _free(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0;
 if ((i1 | 0) == 0) {
  return;
 }
 i2 = i1 - 8 | 0;
 i3 = i2;
 i4 = HEAP32[3020] | 0;
 if (i2 >>> 0 < i4 >>> 0) {
  _abort();
 }
 i5 = HEAP32[i1 - 4 >> 2] | 0;
 i6 = i5 & 3;
 if ((i6 | 0) == 1) {
  _abort();
 }
 i7 = i5 & -8;
 i8 = i1 + (i7 - 8) | 0;
 i9 = i8;
 L527 : do {
  if ((i5 & 1 | 0) == 0) {
   i10 = HEAP32[i2 >> 2] | 0;
   if ((i6 | 0) == 0) {
    return;
   }
   i11 = -8 - i10 | 0;
   i12 = i1 + i11 | 0;
   i13 = i12;
   i14 = i10 + i7 | 0;
   if (i12 >>> 0 < i4 >>> 0) {
    _abort();
   }
   if ((i13 | 0) == (HEAP32[3021] | 0)) {
    i15 = i1 + (i7 - 4) | 0;
    if ((HEAP32[i15 >> 2] & 3 | 0) != 3) {
     i16 = i13;
     i17 = i14;
     break;
    }
    HEAP32[3018] = i14;
    HEAP32[i15 >> 2] = HEAP32[i15 >> 2] & -2;
    HEAP32[i1 + (i11 + 4) >> 2] = i14 | 1;
    HEAP32[i8 >> 2] = i14;
    return;
   }
   i15 = i10 >>> 3;
   if (i10 >>> 0 < 256) {
    i10 = HEAP32[i1 + (i11 + 8) >> 2] | 0;
    i18 = HEAP32[i1 + (i11 + 12) >> 2] | 0;
    i19 = 12104 + (i15 << 1 << 2) | 0;
    do {
     if ((i10 | 0) != (i19 | 0)) {
      if (i10 >>> 0 < i4 >>> 0) {
       _abort();
      }
      if ((HEAP32[i10 + 12 >> 2] | 0) == (i13 | 0)) {
       break;
      }
      _abort();
     }
    } while (0);
    if ((i18 | 0) == (i10 | 0)) {
     HEAP32[3016] = HEAP32[3016] & ~(1 << i15);
     i16 = i13;
     i17 = i14;
     break;
    }
    do {
     if ((i18 | 0) == (i19 | 0)) {
      i20 = i18 + 8 | 0;
     } else {
      if (i18 >>> 0 < i4 >>> 0) {
       _abort();
      }
      i21 = i18 + 8 | 0;
      if ((HEAP32[i21 >> 2] | 0) == (i13 | 0)) {
       i20 = i21;
       break;
      }
      _abort();
     }
    } while (0);
    HEAP32[i10 + 12 >> 2] = i18;
    HEAP32[i20 >> 2] = i10;
    i16 = i13;
    i17 = i14;
    break;
   }
   i19 = i12;
   i15 = HEAP32[i1 + (i11 + 24) >> 2] | 0;
   i21 = HEAP32[i1 + (i11 + 12) >> 2] | 0;
   do {
    if ((i21 | 0) == (i19 | 0)) {
     i22 = i1 + (i11 + 20) | 0;
     i23 = HEAP32[i22 >> 2] | 0;
     if ((i23 | 0) == 0) {
      i24 = i1 + (i11 + 16) | 0;
      i25 = HEAP32[i24 >> 2] | 0;
      if ((i25 | 0) == 0) {
       i26 = 0;
       break;
      } else {
       i27 = i25;
       i28 = i24;
      }
     } else {
      i27 = i23;
      i28 = i22;
     }
     while (1) {
      i22 = i27 + 20 | 0;
      i23 = HEAP32[i22 >> 2] | 0;
      if ((i23 | 0) != 0) {
       i27 = i23;
       i28 = i22;
       continue;
      }
      i22 = i27 + 16 | 0;
      i23 = HEAP32[i22 >> 2] | 0;
      if ((i23 | 0) == 0) {
       break;
      } else {
       i27 = i23;
       i28 = i22;
      }
     }
     if (i28 >>> 0 < i4 >>> 0) {
      _abort();
     } else {
      HEAP32[i28 >> 2] = 0;
      i26 = i27;
      break;
     }
    } else {
     i22 = HEAP32[i1 + (i11 + 8) >> 2] | 0;
     if (i22 >>> 0 < i4 >>> 0) {
      _abort();
     }
     i23 = i22 + 12 | 0;
     if ((HEAP32[i23 >> 2] | 0) != (i19 | 0)) {
      _abort();
     }
     i24 = i21 + 8 | 0;
     if ((HEAP32[i24 >> 2] | 0) == (i19 | 0)) {
      HEAP32[i23 >> 2] = i21;
      HEAP32[i24 >> 2] = i22;
      i26 = i21;
      break;
     } else {
      _abort();
     }
    }
   } while (0);
   if ((i15 | 0) == 0) {
    i16 = i13;
    i17 = i14;
    break;
   }
   i21 = i1 + (i11 + 28) | 0;
   i12 = 12368 + (HEAP32[i21 >> 2] << 2) | 0;
   do {
    if ((i19 | 0) == (HEAP32[i12 >> 2] | 0)) {
     HEAP32[i12 >> 2] = i26;
     if ((i26 | 0) != 0) {
      break;
     }
     HEAP32[3017] = HEAP32[3017] & ~(1 << HEAP32[i21 >> 2]);
     i16 = i13;
     i17 = i14;
     break L527;
    } else {
     if (i15 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
      _abort();
     }
     i10 = i15 + 16 | 0;
     if ((HEAP32[i10 >> 2] | 0) == (i19 | 0)) {
      HEAP32[i10 >> 2] = i26;
     } else {
      HEAP32[i15 + 20 >> 2] = i26;
     }
     if ((i26 | 0) == 0) {
      i16 = i13;
      i17 = i14;
      break L527;
     }
    }
   } while (0);
   if (i26 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
    _abort();
   }
   HEAP32[i26 + 24 >> 2] = i15;
   i19 = HEAP32[i1 + (i11 + 16) >> 2] | 0;
   do {
    if ((i19 | 0) != 0) {
     if (i19 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
      _abort();
     } else {
      HEAP32[i26 + 16 >> 2] = i19;
      HEAP32[i19 + 24 >> 2] = i26;
      break;
     }
    }
   } while (0);
   i19 = HEAP32[i1 + (i11 + 20) >> 2] | 0;
   if ((i19 | 0) == 0) {
    i16 = i13;
    i17 = i14;
    break;
   }
   if (i19 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
    _abort();
   } else {
    HEAP32[i26 + 20 >> 2] = i19;
    HEAP32[i19 + 24 >> 2] = i26;
    i16 = i13;
    i17 = i14;
    break;
   }
  } else {
   i16 = i3;
   i17 = i7;
  }
 } while (0);
 i3 = i16;
 if (i3 >>> 0 >= i8 >>> 0) {
  _abort();
 }
 i26 = i1 + (i7 - 4) | 0;
 i4 = HEAP32[i26 >> 2] | 0;
 if ((i4 & 1 | 0) == 0) {
  _abort();
 }
 do {
  if ((i4 & 2 | 0) == 0) {
   if ((i9 | 0) == (HEAP32[3022] | 0)) {
    i27 = (HEAP32[3019] | 0) + i17 | 0;
    HEAP32[3019] = i27;
    HEAP32[3022] = i16;
    HEAP32[i16 + 4 >> 2] = i27 | 1;
    if ((i16 | 0) != (HEAP32[3021] | 0)) {
     return;
    }
    HEAP32[3021] = 0;
    HEAP32[3018] = 0;
    return;
   }
   if ((i9 | 0) == (HEAP32[3021] | 0)) {
    i27 = (HEAP32[3018] | 0) + i17 | 0;
    HEAP32[3018] = i27;
    HEAP32[3021] = i16;
    HEAP32[i16 + 4 >> 2] = i27 | 1;
    HEAP32[i3 + i27 >> 2] = i27;
    return;
   }
   i27 = (i4 & -8) + i17 | 0;
   i28 = i4 >>> 3;
   L630 : do {
    if (i4 >>> 0 < 256) {
     i20 = HEAP32[i1 + i7 >> 2] | 0;
     i6 = HEAP32[i1 + (i7 | 4) >> 2] | 0;
     i2 = 12104 + (i28 << 1 << 2) | 0;
     do {
      if ((i20 | 0) != (i2 | 0)) {
       if (i20 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
        _abort();
       }
       if ((HEAP32[i20 + 12 >> 2] | 0) == (i9 | 0)) {
        break;
       }
       _abort();
      }
     } while (0);
     if ((i6 | 0) == (i20 | 0)) {
      HEAP32[3016] = HEAP32[3016] & ~(1 << i28);
      break;
     }
     do {
      if ((i6 | 0) == (i2 | 0)) {
       i29 = i6 + 8 | 0;
      } else {
       if (i6 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
        _abort();
       }
       i5 = i6 + 8 | 0;
       if ((HEAP32[i5 >> 2] | 0) == (i9 | 0)) {
        i29 = i5;
        break;
       }
       _abort();
      }
     } while (0);
     HEAP32[i20 + 12 >> 2] = i6;
     HEAP32[i29 >> 2] = i20;
    } else {
     i2 = i8;
     i5 = HEAP32[i1 + (i7 + 16) >> 2] | 0;
     i19 = HEAP32[i1 + (i7 | 4) >> 2] | 0;
     do {
      if ((i19 | 0) == (i2 | 0)) {
       i15 = i1 + (i7 + 12) | 0;
       i21 = HEAP32[i15 >> 2] | 0;
       if ((i21 | 0) == 0) {
        i12 = i1 + (i7 + 8) | 0;
        i10 = HEAP32[i12 >> 2] | 0;
        if ((i10 | 0) == 0) {
         i30 = 0;
         break;
        } else {
         i31 = i10;
         i32 = i12;
        }
       } else {
        i31 = i21;
        i32 = i15;
       }
       while (1) {
        i15 = i31 + 20 | 0;
        i21 = HEAP32[i15 >> 2] | 0;
        if ((i21 | 0) != 0) {
         i31 = i21;
         i32 = i15;
         continue;
        }
        i15 = i31 + 16 | 0;
        i21 = HEAP32[i15 >> 2] | 0;
        if ((i21 | 0) == 0) {
         break;
        } else {
         i31 = i21;
         i32 = i15;
        }
       }
       if (i32 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
        _abort();
       } else {
        HEAP32[i32 >> 2] = 0;
        i30 = i31;
        break;
       }
      } else {
       i15 = HEAP32[i1 + i7 >> 2] | 0;
       if (i15 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
        _abort();
       }
       i21 = i15 + 12 | 0;
       if ((HEAP32[i21 >> 2] | 0) != (i2 | 0)) {
        _abort();
       }
       i12 = i19 + 8 | 0;
       if ((HEAP32[i12 >> 2] | 0) == (i2 | 0)) {
        HEAP32[i21 >> 2] = i19;
        HEAP32[i12 >> 2] = i15;
        i30 = i19;
        break;
       } else {
        _abort();
       }
      }
     } while (0);
     if ((i5 | 0) == 0) {
      break;
     }
     i19 = i1 + (i7 + 20) | 0;
     i20 = 12368 + (HEAP32[i19 >> 2] << 2) | 0;
     do {
      if ((i2 | 0) == (HEAP32[i20 >> 2] | 0)) {
       HEAP32[i20 >> 2] = i30;
       if ((i30 | 0) != 0) {
        break;
       }
       HEAP32[3017] = HEAP32[3017] & ~(1 << HEAP32[i19 >> 2]);
       break L630;
      } else {
       if (i5 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
        _abort();
       }
       i6 = i5 + 16 | 0;
       if ((HEAP32[i6 >> 2] | 0) == (i2 | 0)) {
        HEAP32[i6 >> 2] = i30;
       } else {
        HEAP32[i5 + 20 >> 2] = i30;
       }
       if ((i30 | 0) == 0) {
        break L630;
       }
      }
     } while (0);
     if (i30 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
      _abort();
     }
     HEAP32[i30 + 24 >> 2] = i5;
     i2 = HEAP32[i1 + (i7 + 8) >> 2] | 0;
     do {
      if ((i2 | 0) != 0) {
       if (i2 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
        _abort();
       } else {
        HEAP32[i30 + 16 >> 2] = i2;
        HEAP32[i2 + 24 >> 2] = i30;
        break;
       }
      }
     } while (0);
     i2 = HEAP32[i1 + (i7 + 12) >> 2] | 0;
     if ((i2 | 0) == 0) {
      break;
     }
     if (i2 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
      _abort();
     } else {
      HEAP32[i30 + 20 >> 2] = i2;
      HEAP32[i2 + 24 >> 2] = i30;
      break;
     }
    }
   } while (0);
   HEAP32[i16 + 4 >> 2] = i27 | 1;
   HEAP32[i3 + i27 >> 2] = i27;
   if ((i16 | 0) != (HEAP32[3021] | 0)) {
    i33 = i27;
    break;
   }
   HEAP32[3018] = i27;
   return;
  } else {
   HEAP32[i26 >> 2] = i4 & -2;
   HEAP32[i16 + 4 >> 2] = i17 | 1;
   HEAP32[i3 + i17 >> 2] = i17;
   i33 = i17;
  }
 } while (0);
 i17 = i33 >>> 3;
 if (i33 >>> 0 < 256) {
  i3 = i17 << 1;
  i4 = 12104 + (i3 << 2) | 0;
  i26 = HEAP32[3016] | 0;
  i30 = 1 << i17;
  do {
   if ((i26 & i30 | 0) == 0) {
    HEAP32[3016] = i26 | i30;
    i34 = i4;
    i35 = 12104 + (i3 + 2 << 2) | 0;
   } else {
    i17 = 12104 + (i3 + 2 << 2) | 0;
    i7 = HEAP32[i17 >> 2] | 0;
    if (i7 >>> 0 >= (HEAP32[3020] | 0) >>> 0) {
     i34 = i7;
     i35 = i17;
     break;
    }
    _abort();
   }
  } while (0);
  HEAP32[i35 >> 2] = i16;
  HEAP32[i34 + 12 >> 2] = i16;
  HEAP32[i16 + 8 >> 2] = i34;
  HEAP32[i16 + 12 >> 2] = i4;
  return;
 }
 i4 = i16;
 i34 = i33 >>> 8;
 do {
  if ((i34 | 0) == 0) {
   i36 = 0;
  } else {
   if (i33 >>> 0 > 16777215) {
    i36 = 31;
    break;
   }
   i35 = (i34 + 1048320 | 0) >>> 16 & 8;
   i3 = i34 << i35;
   i30 = (i3 + 520192 | 0) >>> 16 & 4;
   i26 = i3 << i30;
   i3 = (i26 + 245760 | 0) >>> 16 & 2;
   i17 = 14 - (i30 | i35 | i3) + (i26 << i3 >>> 15) | 0;
   i36 = i33 >>> ((i17 + 7 | 0) >>> 0) & 1 | i17 << 1;
  }
 } while (0);
 i34 = 12368 + (i36 << 2) | 0;
 HEAP32[i16 + 28 >> 2] = i36;
 HEAP32[i16 + 20 >> 2] = 0;
 HEAP32[i16 + 16 >> 2] = 0;
 i17 = HEAP32[3017] | 0;
 i3 = 1 << i36;
 do {
  if ((i17 & i3 | 0) == 0) {
   HEAP32[3017] = i17 | i3;
   HEAP32[i34 >> 2] = i4;
   HEAP32[i16 + 24 >> 2] = i34;
   HEAP32[i16 + 12 >> 2] = i16;
   HEAP32[i16 + 8 >> 2] = i16;
  } else {
   if ((i36 | 0) == 31) {
    i37 = 0;
   } else {
    i37 = 25 - (i36 >>> 1) | 0;
   }
   i26 = i33 << i37;
   i35 = HEAP32[i34 >> 2] | 0;
   while (1) {
    if ((HEAP32[i35 + 4 >> 2] & -8 | 0) == (i33 | 0)) {
     break;
    }
    i38 = i35 + 16 + (i26 >>> 31 << 2) | 0;
    i30 = HEAP32[i38 >> 2] | 0;
    if ((i30 | 0) == 0) {
     i39 = 508;
     break;
    } else {
     i26 = i26 << 1;
     i35 = i30;
    }
   }
   if ((i39 | 0) == 508) {
    if (i38 >>> 0 < (HEAP32[3020] | 0) >>> 0) {
     _abort();
    } else {
     HEAP32[i38 >> 2] = i4;
     HEAP32[i16 + 24 >> 2] = i35;
     HEAP32[i16 + 12 >> 2] = i16;
     HEAP32[i16 + 8 >> 2] = i16;
     break;
    }
   }
   i26 = i35 + 8 | 0;
   i27 = HEAP32[i26 >> 2] | 0;
   i30 = HEAP32[3020] | 0;
   if (i35 >>> 0 < i30 >>> 0) {
    _abort();
   }
   if (i27 >>> 0 < i30 >>> 0) {
    _abort();
   } else {
    HEAP32[i27 + 12 >> 2] = i4;
    HEAP32[i26 >> 2] = i4;
    HEAP32[i16 + 8 >> 2] = i27;
    HEAP32[i16 + 12 >> 2] = i35;
    HEAP32[i16 + 24 >> 2] = 0;
    break;
   }
  }
 } while (0);
 i16 = (HEAP32[3024] | 0) - 1 | 0;
 HEAP32[3024] = i16;
 if ((i16 | 0) == 0) {
  i40 = 12520;
 } else {
  return;
 }
 while (1) {
  i16 = HEAP32[i40 >> 2] | 0;
  if ((i16 | 0) == 0) {
   break;
  } else {
   i40 = i16 + 8 | 0;
  }
 }
 HEAP32[3024] = -1;
 return;
}
function __ZN16btCollisionWorld13rayTestSingleERK11btTransformS2_P17btCollisionObjectPK16btCollisionShapeS2_RNS_17RayResultCallbackE(i1, i2, i3, i4, i5, i6) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 var i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, d32 = 0.0, i33 = 0, d34 = 0.0, i35 = 0, d36 = 0.0, d37 = 0.0, d38 = 0.0, d39 = 0.0, d40 = 0.0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, d48 = 0.0, d49 = 0.0, d50 = 0.0, d51 = 0.0, d52 = 0.0, d53 = 0.0, d54 = 0.0, d55 = 0.0;
 i7 = STACKTOP;
 STACKTOP = STACKTOP + 1264 | 0;
 i8 = i7 | 0;
 i9 = i7 + 64 | 0;
 i10 = i7 + 96 | 0;
 i11 = i7 + 152 | 0;
 i12 = i7 + 328 | 0;
 i13 = i7 + 688 | 0;
 i14 = i7 + 704 | 0;
 i15 = i7 + 736 | 0;
 i16 = i7 + 752 | 0;
 i17 = i7 + 768 | 0;
 i18 = i7 + 888 | 0;
 i19 = i7 + 904 | 0;
 i20 = i7 + 920 | 0;
 i21 = i7 + 1040 | 0;
 i22 = i7 + 1056 | 0;
 i23 = i7 + 1072 | 0;
 i24 = i7 + 1104 | 0;
 i25 = i7 + 1120 | 0;
 i26 = i7 + 1184 | 0;
 i27 = i7 + 1200 | 0;
 __ZN21btConvexInternalShapeC2Ev(i10 | 0);
 HEAP32[i10 >> 2] = 4728;
 HEAP32[i10 + 4 >> 2] = 8;
 HEAPF32[i10 + 28 >> 2] = 0.0;
 HEAPF32[i10 + 44 >> 2] = 0.0;
 i28 = i10 | 0;
 i10 = HEAP32[i4 + 4 >> 2] | 0;
 if ((i10 | 0) < 20) {
  HEAP32[i11 >> 2] = 2280;
  i29 = i11 + 164 | 0;
  HEAP32[i11 + 168 >> 2] = 0;
  HEAPF32[i11 + 172 >> 2] = 0.0;
  i30 = i6 + 4 | 0;
  HEAPF32[i29 >> 2] = +HEAPF32[i30 >> 2];
  HEAPF32[i12 + 308 >> 2] = 9999999747378752.0e-20;
  HEAP16[i12 + 332 >> 1] = 0;
  __ZN22btSubsimplexConvexCastC2EPK13btConvexShapeS2_P22btVoronoiSimplexSolver(i13, i28, i4, i12);
  do {
   if (__ZN22btSubsimplexConvexCast16calcTimeOfImpactERK11btTransformS2_S2_S2_RN12btConvexCast10CastResultE(i13, i1, i2, i5, i5, i11) | 0) {
    i12 = i11 + 132 | 0;
    i31 = i12 | 0;
    d32 = +HEAPF32[i31 >> 2];
    i33 = i11 + 136 | 0;
    d34 = +HEAPF32[i33 >> 2];
    i35 = i11 + 140 | 0;
    d36 = +HEAPF32[i35 >> 2];
    if (d32 * d32 + d34 * d34 + d36 * d36 <= 9999999747378752.0e-20) {
     break;
    }
    d37 = +HEAPF32[i29 >> 2];
    if (d37 >= +HEAPF32[i30 >> 2]) {
     break;
    }
    d38 = d32 * +HEAPF32[i1 >> 2] + d34 * +HEAPF32[i1 + 4 >> 2] + d36 * +HEAPF32[i1 + 8 >> 2];
    d39 = d32 * +HEAPF32[i1 + 16 >> 2] + d34 * +HEAPF32[i1 + 20 >> 2] + d36 * +HEAPF32[i1 + 24 >> 2];
    d40 = d32 * +HEAPF32[i1 + 32 >> 2] + d34 * +HEAPF32[i1 + 36 >> 2] + d36 * +HEAPF32[i1 + 40 >> 2];
    HEAPF32[i11 + 144 >> 2] = 0.0;
    d36 = 1.0 / +Math_sqrt(+(d38 * d38 + d39 * d39 + d40 * d40));
    HEAPF32[i31 >> 2] = d38 * d36;
    HEAPF32[i33 >> 2] = d39 * d36;
    HEAPF32[i35 >> 2] = d40 * d36;
    HEAP32[i14 >> 2] = i3;
    HEAP32[i14 + 4 >> 2] = 0;
    i35 = i14 + 8 | 0;
    i33 = i12;
    HEAP32[i35 >> 2] = HEAP32[i33 >> 2];
    HEAP32[i35 + 4 >> 2] = HEAP32[i33 + 4 >> 2];
    HEAP32[i35 + 8 >> 2] = HEAP32[i33 + 8 >> 2];
    HEAP32[i35 + 12 >> 2] = HEAP32[i33 + 12 >> 2];
    HEAPF32[i14 + 24 >> 2] = d37;
    i33 = HEAP32[(HEAP32[i6 >> 2] | 0) + 12 >> 2] | 0;
    +FUNCTION_TABLE_fiii[i33 & 15](i6, i14, 1);
   }
  } while (0);
  __ZN12btConvexCastD2Ev(i13 | 0);
  __ZN13btConvexShapeD2Ev(i28);
  STACKTOP = i7;
  return;
 }
 if ((i10 - 21 | 0) >>> 0 >= 9) {
  if ((i10 | 0) != 31) {
   __ZN13btConvexShapeD2Ev(i28);
   STACKTOP = i7;
   return;
  }
  i13 = i4;
  i14 = HEAP32[i4 + 64 >> 2] | 0;
  HEAP32[i23 >> 2] = 1752;
  i11 = i23 + 4 | 0;
  HEAP32[i11 >> 2] = i3;
  i30 = i23 + 8 | 0;
  HEAP32[i30 >> 2] = i13;
  i29 = i23 + 12 | 0;
  HEAP32[i29 >> 2] = i5;
  i33 = i23 + 16 | 0;
  HEAP32[i33 >> 2] = i1;
  i35 = i23 + 20 | 0;
  HEAP32[i35 >> 2] = i2;
  i12 = i23 + 24 | 0;
  HEAP32[i12 >> 2] = i6;
  if ((i14 | 0) != 0) {
   __ZNK11btTransform12inverseTimesERKS_(i25, i5, i1);
   i31 = i24;
   i41 = i25 + 48 | 0;
   HEAP32[i31 >> 2] = HEAP32[i41 >> 2];
   HEAP32[i31 + 4 >> 2] = HEAP32[i41 + 4 >> 2];
   HEAP32[i31 + 8 >> 2] = HEAP32[i41 + 8 >> 2];
   HEAP32[i31 + 12 >> 2] = HEAP32[i41 + 12 >> 2];
   __ZNK11btTransform12inverseTimesERKS_(i27, i5, i2);
   i41 = i26;
   i31 = i27 + 48 | 0;
   HEAP32[i41 >> 2] = HEAP32[i31 >> 2];
   HEAP32[i41 + 4 >> 2] = HEAP32[i31 + 4 >> 2];
   HEAP32[i41 + 8 >> 2] = HEAP32[i31 + 8 >> 2];
   HEAP32[i41 + 12 >> 2] = HEAP32[i31 + 12 >> 2];
   __ZN6btDbvt7rayTestEPK10btDbvtNodeRK9btVector3S5_RNS_8ICollideE(HEAP32[i14 >> 2] | 0, i24, i26, i23 | 0);
   __ZN13btConvexShapeD2Ev(i28);
   STACKTOP = i7;
   return;
  }
  i23 = HEAP32[i4 + 16 >> 2] | 0;
  if ((i23 | 0) <= 0) {
   __ZN13btConvexShapeD2Ev(i28);
   STACKTOP = i7;
   return;
  }
  i26 = i9 | 0;
  i24 = i9 + 4 | 0;
  i14 = i9 + 8 | 0;
  i31 = i9 + 12 | 0;
  i41 = i9 + 14 | 0;
  i27 = i9 + 16 | 0;
  i25 = i9 + 20 | 0;
  i42 = i9 + 24 | 0;
  i43 = i9 | 0;
  i9 = 0;
  i44 = i13;
  i13 = i5;
  while (1) {
   i45 = HEAP32[i44 + 24 >> 2] | 0;
   i46 = HEAP32[i45 + (i9 * 80 | 0) + 64 >> 2] | 0;
   __ZNK11btTransformmlERKS_(i8, i13, i45 + (i9 * 80 | 0) | 0);
   i45 = (HEAP32[i11 >> 2] | 0) + 192 | 0;
   i47 = HEAP32[i45 >> 2] | 0;
   HEAP32[i45 >> 2] = i46;
   i45 = HEAP32[i12 >> 2] | 0;
   HEAPF32[i24 >> 2] = 1.0;
   HEAP32[i14 >> 2] = 0;
   HEAP16[i31 >> 1] = 1;
   HEAP16[i41 >> 1] = -1;
   HEAP32[i27 >> 2] = 0;
   HEAP32[i26 >> 2] = 1864;
   HEAP32[i25 >> 2] = i45;
   HEAP32[i42 >> 2] = i9;
   HEAPF32[i24 >> 2] = +HEAPF32[i45 + 4 >> 2];
   __ZN16btCollisionWorld13rayTestSingleERK11btTransformS2_P17btCollisionObjectPK16btCollisionShapeS2_RNS_17RayResultCallbackE(HEAP32[i33 >> 2] | 0, HEAP32[i35 >> 2] | 0, HEAP32[i11 >> 2] | 0, i46, i8, i43);
   HEAP32[(HEAP32[i11 >> 2] | 0) + 192 >> 2] = i47;
   i47 = i9 + 1 | 0;
   if ((i47 | 0) >= (i23 | 0)) {
    break;
   }
   i9 = i47;
   i44 = HEAP32[i30 >> 2] | 0;
   i13 = HEAP32[i29 >> 2] | 0;
  }
  __ZN13btConvexShapeD2Ev(i28);
  STACKTOP = i7;
  return;
 }
 if ((i10 | 0) == 21) {
  d37 = +HEAPF32[i5 >> 2];
  d36 = +HEAPF32[i5 + 16 >> 2];
  d40 = +HEAPF32[i5 + 32 >> 2];
  d39 = +HEAPF32[i5 + 4 >> 2];
  d38 = +HEAPF32[i5 + 20 >> 2];
  d34 = +HEAPF32[i5 + 36 >> 2];
  d32 = +HEAPF32[i5 + 8 >> 2];
  d48 = +HEAPF32[i5 + 24 >> 2];
  d49 = +HEAPF32[i5 + 40 >> 2];
  d50 = -0.0 - +HEAPF32[i5 + 48 >> 2];
  d51 = -0.0 - +HEAPF32[i5 + 52 >> 2];
  d52 = -0.0 - +HEAPF32[i5 + 56 >> 2];
  d53 = d37 * d50 + d36 * d51 + d40 * d52;
  d54 = d39 * d50 + d38 * d51 + d34 * d52;
  d55 = d32 * d50 + d48 * d51 + d49 * d52;
  d52 = +HEAPF32[i1 + 48 >> 2];
  d51 = +HEAPF32[i1 + 52 >> 2];
  d50 = +HEAPF32[i1 + 56 >> 2];
  HEAPF32[i15 >> 2] = d53 + (d37 * d52 + d36 * d51 + d40 * d50);
  HEAPF32[i15 + 4 >> 2] = d54 + (d39 * d52 + d38 * d51 + d34 * d50);
  HEAPF32[i15 + 8 >> 2] = d55 + (d32 * d52 + d48 * d51 + d49 * d50);
  HEAPF32[i15 + 12 >> 2] = 0.0;
  d50 = +HEAPF32[i2 + 48 >> 2];
  d51 = +HEAPF32[i2 + 52 >> 2];
  d52 = +HEAPF32[i2 + 56 >> 2];
  HEAPF32[i16 >> 2] = d53 + (d37 * d50 + d36 * d51 + d40 * d52);
  HEAPF32[i16 + 4 >> 2] = d54 + (d39 * d50 + d38 * d51 + d34 * d52);
  HEAPF32[i16 + 8 >> 2] = d55 + (d32 * d50 + d48 * d51 + d49 * d52);
  HEAPF32[i16 + 12 >> 2] = 0.0;
  __ZN25btTriangleRaycastCallbackC2ERK9btVector3S2_j(i17 | 0, i15, i16, HEAP32[i6 + 16 >> 2] | 0);
  HEAP32[i17 >> 2] = 1832;
  HEAP32[i17 + 44 >> 2] = i6;
  HEAP32[i17 + 48 >> 2] = i3;
  HEAP32[i17 + 52 >> 2] = i4;
  i10 = i17 + 56 | 0;
  i29 = i5;
  HEAP32[i10 >> 2] = HEAP32[i29 >> 2];
  HEAP32[i10 + 4 >> 2] = HEAP32[i29 + 4 >> 2];
  HEAP32[i10 + 8 >> 2] = HEAP32[i29 + 8 >> 2];
  HEAP32[i10 + 12 >> 2] = HEAP32[i29 + 12 >> 2];
  i29 = i17 + 72 | 0;
  i10 = i5 + 16 | 0;
  HEAP32[i29 >> 2] = HEAP32[i10 >> 2];
  HEAP32[i29 + 4 >> 2] = HEAP32[i10 + 4 >> 2];
  HEAP32[i29 + 8 >> 2] = HEAP32[i10 + 8 >> 2];
  HEAP32[i29 + 12 >> 2] = HEAP32[i10 + 12 >> 2];
  i10 = i17 + 88 | 0;
  i29 = i5 + 32 | 0;
  HEAP32[i10 >> 2] = HEAP32[i29 >> 2];
  HEAP32[i10 + 4 >> 2] = HEAP32[i29 + 4 >> 2];
  HEAP32[i10 + 8 >> 2] = HEAP32[i29 + 8 >> 2];
  HEAP32[i10 + 12 >> 2] = HEAP32[i29 + 12 >> 2];
  i29 = i17 + 104 | 0;
  i10 = i5 + 48 | 0;
  HEAP32[i29 >> 2] = HEAP32[i10 >> 2];
  HEAP32[i29 + 4 >> 2] = HEAP32[i10 + 4 >> 2];
  HEAP32[i29 + 8 >> 2] = HEAP32[i10 + 8 >> 2];
  HEAP32[i29 + 12 >> 2] = HEAP32[i10 + 12 >> 2];
  HEAPF32[i17 + 40 >> 2] = +HEAPF32[i6 + 4 >> 2];
  i10 = i17 | 0;
  __ZN22btBvhTriangleMeshShape14performRaycastEP18btTriangleCallbackRK9btVector3S4_(i4, i10, i15, i16);
  __ZN18btTriangleCallbackD2Ev(i10);
  __ZN13btConvexShapeD2Ev(i28);
  STACKTOP = i7;
  return;
 }
 i10 = i4;
 d52 = +HEAPF32[i5 >> 2];
 d49 = +HEAPF32[i5 + 16 >> 2];
 d51 = +HEAPF32[i5 + 32 >> 2];
 d48 = +HEAPF32[i5 + 4 >> 2];
 d50 = +HEAPF32[i5 + 20 >> 2];
 d32 = +HEAPF32[i5 + 36 >> 2];
 d55 = +HEAPF32[i5 + 8 >> 2];
 d34 = +HEAPF32[i5 + 24 >> 2];
 d38 = +HEAPF32[i5 + 40 >> 2];
 d39 = -0.0 - +HEAPF32[i5 + 48 >> 2];
 d54 = -0.0 - +HEAPF32[i5 + 52 >> 2];
 d40 = -0.0 - +HEAPF32[i5 + 56 >> 2];
 d36 = d52 * d39 + d49 * d54 + d51 * d40;
 d37 = d48 * d39 + d50 * d54 + d32 * d40;
 d53 = d55 * d39 + d34 * d54 + d38 * d40;
 d40 = +HEAPF32[i1 + 48 >> 2];
 d54 = +HEAPF32[i1 + 52 >> 2];
 d39 = +HEAPF32[i1 + 56 >> 2];
 HEAPF32[i18 >> 2] = d36 + (d52 * d40 + d49 * d54 + d51 * d39);
 HEAPF32[i18 + 4 >> 2] = d37 + (d48 * d40 + d50 * d54 + d32 * d39);
 HEAPF32[i18 + 8 >> 2] = d53 + (d55 * d40 + d34 * d54 + d38 * d39);
 HEAPF32[i18 + 12 >> 2] = 0.0;
 d39 = +HEAPF32[i2 + 48 >> 2];
 d54 = +HEAPF32[i2 + 52 >> 2];
 d40 = +HEAPF32[i2 + 56 >> 2];
 i2 = i19 | 0;
 HEAPF32[i2 >> 2] = d36 + (d52 * d39 + d49 * d54 + d51 * d40);
 i1 = i19 + 4 | 0;
 HEAPF32[i1 >> 2] = d37 + (d48 * d39 + d50 * d54 + d32 * d40);
 i16 = i19 + 8 | 0;
 HEAPF32[i16 >> 2] = d53 + (d55 * d39 + d34 * d54 + d38 * d40);
 i15 = i19 + 12 | 0;
 HEAPF32[i15 >> 2] = 0.0;
 __ZN25btTriangleRaycastCallbackC2ERK9btVector3S2_j(i20 | 0, i18, i19, HEAP32[i6 + 16 >> 2] | 0);
 HEAP32[i20 >> 2] = 1800;
 HEAP32[i20 + 44 >> 2] = i6;
 HEAP32[i20 + 48 >> 2] = i3;
 HEAP32[i20 + 52 >> 2] = i10;
 i3 = i20 + 56 | 0;
 i19 = i5;
 HEAP32[i3 >> 2] = HEAP32[i19 >> 2];
 HEAP32[i3 + 4 >> 2] = HEAP32[i19 + 4 >> 2];
 HEAP32[i3 + 8 >> 2] = HEAP32[i19 + 8 >> 2];
 HEAP32[i3 + 12 >> 2] = HEAP32[i19 + 12 >> 2];
 i19 = i20 + 72 | 0;
 i3 = i5 + 16 | 0;
 HEAP32[i19 >> 2] = HEAP32[i3 >> 2];
 HEAP32[i19 + 4 >> 2] = HEAP32[i3 + 4 >> 2];
 HEAP32[i19 + 8 >> 2] = HEAP32[i3 + 8 >> 2];
 HEAP32[i19 + 12 >> 2] = HEAP32[i3 + 12 >> 2];
 i3 = i20 + 88 | 0;
 i19 = i5 + 32 | 0;
 HEAP32[i3 >> 2] = HEAP32[i19 >> 2];
 HEAP32[i3 + 4 >> 2] = HEAP32[i19 + 4 >> 2];
 HEAP32[i3 + 8 >> 2] = HEAP32[i19 + 8 >> 2];
 HEAP32[i3 + 12 >> 2] = HEAP32[i19 + 12 >> 2];
 i19 = i20 + 104 | 0;
 i3 = i5 + 48 | 0;
 HEAP32[i19 >> 2] = HEAP32[i3 >> 2];
 HEAP32[i19 + 4 >> 2] = HEAP32[i3 + 4 >> 2];
 HEAP32[i19 + 8 >> 2] = HEAP32[i3 + 8 >> 2];
 HEAP32[i19 + 12 >> 2] = HEAP32[i3 + 12 >> 2];
 HEAPF32[i20 + 40 >> 2] = +HEAPF32[i6 + 4 >> 2];
 i6 = i21;
 i3 = i18;
 HEAP32[i6 >> 2] = HEAP32[i3 >> 2];
 HEAP32[i6 + 4 >> 2] = HEAP32[i3 + 4 >> 2];
 HEAP32[i6 + 8 >> 2] = HEAP32[i3 + 8 >> 2];
 HEAP32[i6 + 12 >> 2] = HEAP32[i3 + 12 >> 2];
 i6 = i21 | 0;
 d40 = +HEAPF32[i2 >> 2];
 if (d40 < +HEAPF32[i6 >> 2]) {
  HEAPF32[i6 >> 2] = d40;
 }
 i6 = i21 + 4 | 0;
 d38 = +HEAPF32[i1 >> 2];
 if (d38 < +HEAPF32[i6 >> 2]) {
  HEAPF32[i6 >> 2] = d38;
 }
 i6 = i21 + 8 | 0;
 d54 = +HEAPF32[i16 >> 2];
 if (d54 < +HEAPF32[i6 >> 2]) {
  HEAPF32[i6 >> 2] = d54;
 }
 i6 = i21 + 12 | 0;
 d34 = +HEAPF32[i15 >> 2];
 if (d34 < +HEAPF32[i6 >> 2]) {
  HEAPF32[i6 >> 2] = d34;
 }
 i6 = i22;
 HEAP32[i6 >> 2] = HEAP32[i3 >> 2];
 HEAP32[i6 + 4 >> 2] = HEAP32[i3 + 4 >> 2];
 HEAP32[i6 + 8 >> 2] = HEAP32[i3 + 8 >> 2];
 HEAP32[i6 + 12 >> 2] = HEAP32[i3 + 12 >> 2];
 i3 = i22 | 0;
 if (+HEAPF32[i3 >> 2] < d40) {
  HEAPF32[i3 >> 2] = d40;
 }
 i3 = i22 + 4 | 0;
 if (+HEAPF32[i3 >> 2] < d38) {
  HEAPF32[i3 >> 2] = d38;
 }
 i3 = i22 + 8 | 0;
 if (+HEAPF32[i3 >> 2] < d54) {
  HEAPF32[i3 >> 2] = d54;
 }
 i3 = i22 + 12 | 0;
 if (+HEAPF32[i3 >> 2] < d34) {
  HEAPF32[i3 >> 2] = d34;
 }
 i3 = i20 | 0;
 FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i4 >> 2] | 0) + 60 >> 2] & 127](i10, i3, i21, i22);
 __ZN18btTriangleCallbackD2Ev(i3);
 __ZN13btConvexShapeD2Ev(i28);
 STACKTOP = i7;
 return;
}
function __ZN28btCompoundCollisionAlgorithm16processCollisionEP17btCollisionObjectS1_RK16btDispatcherInfoP16btManifoldResult(i1, i2, i3, i4, i5) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 var i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, d42 = 0.0, d43 = 0.0, d44 = 0.0, d45 = 0.0, d46 = 0.0, d47 = 0.0, d48 = 0.0, d49 = 0.0, d50 = 0.0, d51 = 0.0, d52 = 0.0, d53 = 0.0, d54 = 0.0, d55 = 0.0, d56 = 0.0, d57 = 0.0, d58 = 0.0, d59 = 0.0, d60 = 0.0, d61 = 0.0, d62 = 0.0, d63 = 0.0, d64 = 0.0, d65 = 0.0, i66 = 0, i67 = 0, i68 = 0, i69 = 0, i70 = 0, i71 = 0, i72 = 0, i73 = 0, i74 = 0, i75 = 0, i76 = 0, i77 = 0, i78 = 0, i79 = 0, i80 = 0, i81 = 0;
 i6 = STACKTOP;
 STACKTOP = STACKTOP + 312 | 0;
 i7 = i6 | 0;
 i8 = i6 + 32 | 0;
 i9 = i6 + 56 | 0;
 i10 = i6 + 72 | 0;
 i11 = i6 + 88 | 0;
 i12 = i6 + 152 | 0;
 i13 = i6 + 184 | 0;
 i14 = i6 + 248 | 0;
 i15 = i6 + 264 | 0;
 i16 = i6 + 280 | 0;
 i17 = i6 + 296 | 0;
 i18 = (HEAP8[i1 + 28 | 0] | 0) != 0;
 i19 = i18 ? i3 : i2;
 i20 = i18 ? i2 : i3;
 i18 = HEAP32[i19 + 192 >> 2] | 0;
 i21 = i1 + 12 | 0;
 if ((HEAP32[i18 + 68 >> 2] | 0) != (HEAP32[i1 + 40 >> 2] | 0)) {
  i22 = HEAP32[i21 >> 2] | 0;
  if ((i22 | 0) > 0) {
   i23 = i1 + 20 | 0;
   i24 = i1 + 4 | 0;
   i25 = 0;
   do {
    i26 = HEAP32[(HEAP32[i23 >> 2] | 0) + (i25 << 2) >> 2] | 0;
    if ((i26 | 0) != 0) {
     FUNCTION_TABLE_vi[HEAP32[HEAP32[i26 >> 2] >> 2] & 511](i26);
     i26 = HEAP32[i24 >> 2] | 0;
     FUNCTION_TABLE_vii[HEAP32[(HEAP32[i26 >> 2] | 0) + 60 >> 2] & 127](i26, HEAP32[(HEAP32[i23 >> 2] | 0) + (i25 << 2) >> 2] | 0);
    }
    i25 = i25 + 1 | 0;
   } while ((i25 | 0) < (i22 | 0));
  }
  __ZN28btCompoundCollisionAlgorithm26preallocateChildAlgorithmsEP17btCollisionObjectS1_(i1, i2, i3);
 }
 i3 = HEAP32[i18 + 64 >> 2] | 0;
 i2 = i1 + 4 | 0;
 i22 = HEAP32[i2 >> 2] | 0;
 i25 = i1 + 20 | 0;
 i23 = HEAP32[i25 >> 2] | 0;
 i24 = HEAP32[i1 + 32 >> 2] | 0;
 HEAP32[i7 >> 2] = 3568;
 HEAP32[i7 + 4 >> 2] = i19;
 HEAP32[i7 + 8 >> 2] = i20;
 HEAP32[i7 + 12 >> 2] = i22;
 HEAP32[i7 + 16 >> 2] = i4;
 HEAP32[i7 + 20 >> 2] = i5;
 HEAP32[i7 + 24 >> 2] = i23;
 HEAP32[i7 + 28 >> 2] = i24;
 i24 = i8 + 16 | 0;
 HEAP8[i24] = 1;
 i4 = i8 + 12 | 0;
 HEAP32[i4 >> 2] = 0;
 i22 = i8 + 4 | 0;
 HEAP32[i22 >> 2] = 0;
 i1 = i8 + 8 | 0;
 HEAP32[i1 >> 2] = 0;
 i26 = HEAP32[i21 >> 2] | 0;
 do {
  if ((i26 | 0) > 0) {
   i27 = i5 + 4 | 0;
   i28 = i5 + 136 | 0;
   i29 = i5 + 8 | 0;
   i30 = i5 + 72 | 0;
   i31 = 0;
   i32 = i26;
   i33 = i23;
   while (1) {
    i34 = HEAP32[i33 + (i31 << 2) >> 2] | 0;
    if ((i34 | 0) == 0) {
     i35 = i32;
    } else {
     FUNCTION_TABLE_vii[HEAP32[(HEAP32[i34 >> 2] | 0) + 16 >> 2] & 127](i34, i8);
     i34 = HEAP32[i22 >> 2] | 0;
     if ((i34 | 0) > 0) {
      i36 = 0;
      i37 = i34;
      while (1) {
       i38 = HEAP32[(HEAP32[i4 >> 2] | 0) + (i36 << 2) >> 2] | 0;
       if ((HEAP32[i38 + 1116 >> 2] | 0) == 0) {
        i39 = i37;
       } else {
        HEAP32[i27 >> 2] = i38;
        if ((HEAP32[i38 + 1108 >> 2] | 0) == (HEAP32[i28 >> 2] | 0)) {
         __ZN20btPersistentManifold20refreshContactPointsERK11btTransformS2_(i38, i29, i30);
        } else {
         __ZN20btPersistentManifold20refreshContactPointsERK11btTransformS2_(i38, i30, i29);
        }
        HEAP32[i27 >> 2] = 0;
        i39 = HEAP32[i22 >> 2] | 0;
       }
       i38 = i36 + 1 | 0;
       if ((i38 | 0) < (i39 | 0)) {
        i36 = i38;
        i37 = i39;
       } else {
        i40 = i39;
        break;
       }
      }
     } else {
      i40 = i34;
     }
     if ((i40 | 0) < 0) {
      if ((HEAP32[i1 >> 2] | 0) < 0) {
       i37 = HEAP32[i4 >> 2] | 0;
       if ((i40 | 0) > 0) {
        i36 = 0;
        do {
         if ((i36 | 0) != 0) {
          HEAP32[i36 << 2 >> 2] = HEAP32[i37 + (i36 << 2) >> 2];
         }
         i36 = i36 + 1 | 0;
        } while ((i36 | 0) < (i40 | 0));
       }
       if ((i37 | 0) != 0) {
        if ((HEAP8[i24] | 0) != 0) {
         __Z21btAlignedFreeInternalPv(i37);
        }
        HEAP32[i4 >> 2] = 0;
       }
       HEAP8[i24] = 1;
       HEAP32[i4 >> 2] = 0;
       HEAP32[i1 >> 2] = 0;
       i41 = i40;
      } else {
       i41 = i40;
      }
      do {
       i36 = (HEAP32[i4 >> 2] | 0) + (i41 << 2) | 0;
       if ((i36 | 0) != 0) {
        HEAP32[i36 >> 2] = 0;
       }
       i41 = i41 + 1 | 0;
      } while ((i41 | 0) < 0);
     }
     HEAP32[i22 >> 2] = 0;
     i35 = HEAP32[i21 >> 2] | 0;
    }
    i37 = i31 + 1 | 0;
    if ((i37 | 0) >= (i35 | 0)) {
     break;
    }
    i31 = i37;
    i32 = i35;
    i33 = HEAP32[i25 >> 2] | 0;
   }
   i33 = HEAP32[i4 >> 2] | 0;
   if ((i33 | 0) == 0) {
    break;
   }
   if ((HEAP8[i24] | 0) != 0) {
    __Z21btAlignedFreeInternalPv(i33);
   }
   HEAP32[i4 >> 2] = 0;
  }
 } while (0);
 HEAP8[i24] = 1;
 HEAP32[i4 >> 2] = 0;
 HEAP32[i22 >> 2] = 0;
 HEAP32[i1 >> 2] = 0;
 if ((i3 | 0) == 0) {
  i1 = HEAP32[i21 >> 2] | 0;
  if ((i1 | 0) <= 0) {
   STACKTOP = i6;
   return;
  }
  i22 = i18 + 24 | 0;
  i4 = 0;
  do {
   __ZN22btCompoundLeafCallback17ProcessChildShapeEP16btCollisionShapei(i7, HEAP32[(HEAP32[i22 >> 2] | 0) + (i4 * 80 | 0) + 64 >> 2] | 0, i4);
   i4 = i4 + 1 | 0;
  } while ((i4 | 0) < (i1 | 0));
 } else {
  d42 = +HEAPF32[i19 + 4 >> 2];
  d43 = +HEAPF32[i19 + 20 >> 2];
  d44 = +HEAPF32[i19 + 36 >> 2];
  d45 = +HEAPF32[i19 + 8 >> 2];
  d46 = +HEAPF32[i19 + 24 >> 2];
  d47 = +HEAPF32[i19 + 40 >> 2];
  d48 = +HEAPF32[i19 + 12 >> 2];
  d49 = +HEAPF32[i19 + 28 >> 2];
  d50 = +HEAPF32[i19 + 44 >> 2];
  d51 = -0.0 - +HEAPF32[i19 + 52 >> 2];
  d52 = -0.0 - +HEAPF32[i19 + 56 >> 2];
  d53 = -0.0 - +HEAPF32[i19 + 60 >> 2];
  d54 = +HEAPF32[i20 + 4 >> 2];
  d55 = +HEAPF32[i20 + 20 >> 2];
  d56 = +HEAPF32[i20 + 36 >> 2];
  d57 = +HEAPF32[i20 + 8 >> 2];
  d58 = +HEAPF32[i20 + 24 >> 2];
  d59 = +HEAPF32[i20 + 40 >> 2];
  d60 = +HEAPF32[i20 + 12 >> 2];
  d61 = +HEAPF32[i20 + 28 >> 2];
  d62 = +HEAPF32[i20 + 44 >> 2];
  d63 = +HEAPF32[i20 + 52 >> 2];
  d64 = +HEAPF32[i20 + 56 >> 2];
  d65 = +HEAPF32[i20 + 60 >> 2];
  HEAPF32[i11 >> 2] = d42 * d54 + d43 * d55 + d44 * d56;
  HEAPF32[i11 + 4 >> 2] = d42 * d57 + d43 * d58 + d44 * d59;
  HEAPF32[i11 + 8 >> 2] = d42 * d60 + d43 * d61 + d44 * d62;
  HEAPF32[i11 + 12 >> 2] = 0.0;
  HEAPF32[i11 + 16 >> 2] = d45 * d54 + d46 * d55 + d47 * d56;
  HEAPF32[i11 + 20 >> 2] = d45 * d57 + d46 * d58 + d47 * d59;
  HEAPF32[i11 + 24 >> 2] = d45 * d60 + d46 * d61 + d47 * d62;
  HEAPF32[i11 + 28 >> 2] = 0.0;
  HEAPF32[i11 + 32 >> 2] = d48 * d54 + d49 * d55 + d50 * d56;
  HEAPF32[i11 + 36 >> 2] = d48 * d57 + d49 * d58 + d50 * d59;
  HEAPF32[i11 + 40 >> 2] = d48 * d60 + d49 * d61 + d50 * d62;
  HEAPF32[i11 + 44 >> 2] = 0.0;
  HEAPF32[i11 + 48 >> 2] = d42 * d51 + d43 * d52 + d44 * d53 + (d42 * d63 + d43 * d64 + d44 * d65);
  HEAPF32[i11 + 52 >> 2] = d45 * d51 + d46 * d52 + d47 * d53 + (d45 * d63 + d46 * d64 + d47 * d65);
  HEAPF32[i11 + 56 >> 2] = d48 * d51 + d49 * d52 + d50 * d53 + (d48 * d63 + d49 * d64 + d50 * d65);
  HEAPF32[i11 + 60 >> 2] = 0.0;
  i1 = HEAP32[i20 + 192 >> 2] | 0;
  FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i1 >> 2] | 0) + 8 >> 2] & 127](i1, i11, i9, i10);
  i11 = i12;
  i1 = i9;
  HEAP32[i11 >> 2] = HEAP32[i1 >> 2];
  HEAP32[i11 + 4 >> 2] = HEAP32[i1 + 4 >> 2];
  HEAP32[i11 + 8 >> 2] = HEAP32[i1 + 8 >> 2];
  HEAP32[i11 + 12 >> 2] = HEAP32[i1 + 12 >> 2];
  i1 = i12 + 16 | 0;
  i11 = i10;
  HEAP32[i1 >> 2] = HEAP32[i11 >> 2];
  HEAP32[i1 + 4 >> 2] = HEAP32[i11 + 4 >> 2];
  HEAP32[i1 + 8 >> 2] = HEAP32[i11 + 8 >> 2];
  HEAP32[i1 + 12 >> 2] = HEAP32[i11 + 12 >> 2];
  __ZN6btDbvt9collideTVEPK10btDbvtNodeRK12btDbvtAabbMmRNS_8ICollideE(0, HEAP32[i3 >> 2] | 0, i12, i7 | 0);
 }
 i7 = HEAP32[i21 >> 2] | 0;
 if ((i7 | 0) <= 0) {
  STACKTOP = i6;
  return;
 }
 i21 = i18 + 24 | 0;
 i18 = i19 + 4 | 0;
 i12 = i19 + 8 | 0;
 i3 = i19 + 12 | 0;
 i11 = i19 + 20 | 0;
 i1 = i19 + 24 | 0;
 i10 = i19 + 28 | 0;
 i9 = i19 + 36 | 0;
 i4 = i19 + 40 | 0;
 i22 = i19 + 44 | 0;
 i24 = i19 + 52 | 0;
 i35 = i19 + 56 | 0;
 i41 = i19 + 60 | 0;
 i19 = i13 | 0;
 i40 = i13 + 4 | 0;
 i39 = i13 + 8 | 0;
 i8 = i13 + 12 | 0;
 i23 = i13 + 16 | 0;
 i26 = i13 + 20 | 0;
 i5 = i13 + 24 | 0;
 i33 = i13 + 28 | 0;
 i32 = i13 + 32 | 0;
 i31 = i13 + 36 | 0;
 i27 = i13 + 40 | 0;
 i29 = i13 + 44 | 0;
 i30 = i13 + 48 | 0;
 i28 = i13 + 52 | 0;
 i37 = i13 + 56 | 0;
 i36 = i13 + 60 | 0;
 i34 = i20 + 192 | 0;
 i38 = i20 + 4 | 0;
 i20 = i14 | 0;
 i66 = i17 | 0;
 i67 = i14 + 8 | 0;
 i68 = i17 + 8 | 0;
 i69 = i14 + 4 | 0;
 i70 = i17 + 4 | 0;
 i71 = i15 + 4 | 0;
 i72 = i16 + 4 | 0;
 i73 = i15 + 8 | 0;
 i74 = i16 + 8 | 0;
 i75 = i15 | 0;
 i76 = i16 | 0;
 i77 = 0;
 do {
  do {
   if ((HEAP32[(HEAP32[i25 >> 2] | 0) + (i77 << 2) >> 2] | 0) != 0) {
    i78 = HEAP32[i21 >> 2] | 0;
    i79 = HEAP32[i78 + (i77 * 80 | 0) + 64 >> 2] | 0;
    d65 = +HEAPF32[i18 >> 2];
    d50 = +HEAPF32[i12 >> 2];
    d64 = +HEAPF32[i3 >> 2];
    d49 = +HEAPF32[i11 >> 2];
    d63 = +HEAPF32[i1 >> 2];
    d48 = +HEAPF32[i10 >> 2];
    d53 = +HEAPF32[i9 >> 2];
    d52 = +HEAPF32[i4 >> 2];
    d51 = +HEAPF32[i22 >> 2];
    d47 = +HEAPF32[i78 + (i77 * 80 | 0) >> 2];
    d46 = +HEAPF32[i78 + (i77 * 80 | 0) + 16 >> 2];
    d45 = +HEAPF32[i78 + (i77 * 80 | 0) + 32 >> 2];
    d44 = +HEAPF32[i78 + (i77 * 80 | 0) + 4 >> 2];
    d43 = +HEAPF32[i78 + (i77 * 80 | 0) + 20 >> 2];
    d42 = +HEAPF32[i78 + (i77 * 80 | 0) + 36 >> 2];
    d62 = +HEAPF32[i78 + (i77 * 80 | 0) + 8 >> 2];
    d61 = +HEAPF32[i78 + (i77 * 80 | 0) + 24 >> 2];
    d60 = +HEAPF32[i78 + (i77 * 80 | 0) + 40 >> 2];
    d59 = +HEAPF32[i78 + (i77 * 80 | 0) + 48 >> 2];
    d58 = +HEAPF32[i78 + (i77 * 80 | 0) + 52 >> 2];
    d57 = +HEAPF32[i78 + (i77 * 80 | 0) + 56 >> 2];
    d56 = +HEAPF32[i24 >> 2] + (d65 * d59 + d50 * d58 + d64 * d57);
    d55 = +HEAPF32[i35 >> 2] + (d49 * d59 + d63 * d58 + d48 * d57);
    d54 = +HEAPF32[i41 >> 2] + (d53 * d59 + d52 * d58 + d51 * d57);
    HEAPF32[i19 >> 2] = d65 * d47 + d50 * d46 + d64 * d45;
    HEAPF32[i40 >> 2] = d65 * d44 + d50 * d43 + d64 * d42;
    HEAPF32[i39 >> 2] = d65 * d62 + d50 * d61 + d64 * d60;
    HEAPF32[i8 >> 2] = 0.0;
    HEAPF32[i23 >> 2] = d49 * d47 + d63 * d46 + d48 * d45;
    HEAPF32[i26 >> 2] = d49 * d44 + d63 * d43 + d48 * d42;
    HEAPF32[i5 >> 2] = d49 * d62 + d63 * d61 + d48 * d60;
    HEAPF32[i33 >> 2] = 0.0;
    HEAPF32[i32 >> 2] = d53 * d47 + d52 * d46 + d51 * d45;
    HEAPF32[i31 >> 2] = d53 * d44 + d52 * d43 + d51 * d42;
    HEAPF32[i27 >> 2] = d53 * d62 + d52 * d61 + d51 * d60;
    HEAPF32[i29 >> 2] = 0.0;
    HEAPF32[i30 >> 2] = d56;
    HEAPF32[i28 >> 2] = d55;
    HEAPF32[i37 >> 2] = d54;
    HEAPF32[i36 >> 2] = 0.0;
    FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i79 >> 2] | 0) + 8 >> 2] & 127](i79, i13, i14, i15);
    i79 = HEAP32[i34 >> 2] | 0;
    FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i79 >> 2] | 0) + 8 >> 2] & 127](i79, i38, i16, i17);
    do {
     if (+HEAPF32[i20 >> 2] > +HEAPF32[i66 >> 2]) {
      i80 = 0;
     } else {
      if (+HEAPF32[i75 >> 2] < +HEAPF32[i76 >> 2]) {
       i80 = 0;
       break;
      }
      i80 = 1;
     }
    } while (0);
    do {
     if (+HEAPF32[i67 >> 2] > +HEAPF32[i68 >> 2]) {
      i81 = 0;
     } else {
      if (+HEAPF32[i73 >> 2] < +HEAPF32[i74 >> 2]) {
       i81 = 0;
       break;
      }
      i81 = i80;
     }
    } while (0);
    if (+HEAPF32[i69 >> 2] <= +HEAPF32[i70 >> 2]) {
     if (!(+HEAPF32[i71 >> 2] < +HEAPF32[i72 >> 2] | i81 ^ 1)) {
      break;
     }
    }
    i79 = HEAP32[(HEAP32[i25 >> 2] | 0) + (i77 << 2) >> 2] | 0;
    FUNCTION_TABLE_vi[HEAP32[HEAP32[i79 >> 2] >> 2] & 511](i79);
    i79 = HEAP32[i2 >> 2] | 0;
    FUNCTION_TABLE_vii[HEAP32[(HEAP32[i79 >> 2] | 0) + 60 >> 2] & 127](i79, HEAP32[(HEAP32[i25 >> 2] | 0) + (i77 << 2) >> 2] | 0);
    HEAP32[(HEAP32[i25 >> 2] | 0) + (i77 << 2) >> 2] = 0;
   }
  } while (0);
  i77 = i77 + 1 | 0;
 } while ((i77 | 0) < (i7 | 0));
 STACKTOP = i6;
 return;
}
function __ZN22btSubsimplexConvexCast16calcTimeOfImpactERK11btTransformS2_S2_S2_RN12btConvexCast10CastResultE(i1, i2, i3, i4, i5, i6) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 var i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, d25 = 0.0, i26 = 0, i27 = 0, d28 = 0.0, i29 = 0, d30 = 0.0, i31 = 0, i32 = 0, d33 = 0.0, i34 = 0, i35 = 0, d36 = 0.0, i37 = 0, d38 = 0.0, i39 = 0, d40 = 0.0, i41 = 0, d42 = 0.0, i43 = 0, d44 = 0.0, i45 = 0, d46 = 0.0, i47 = 0, d48 = 0.0, i49 = 0, d50 = 0.0, i51 = 0, d52 = 0.0, i53 = 0, d54 = 0.0, i55 = 0, d56 = 0.0, d57 = 0.0, i58 = 0, d59 = 0.0, i60 = 0, d61 = 0.0, i62 = 0, d63 = 0.0, i64 = 0, d65 = 0.0, i66 = 0, d67 = 0.0, i68 = 0, d69 = 0.0, i70 = 0, d71 = 0.0, i72 = 0, d73 = 0.0, d74 = 0.0, d75 = 0.0, d76 = 0.0, i77 = 0, i78 = 0, d79 = 0.0, d80 = 0.0, d81 = 0.0, d82 = 0.0, d83 = 0.0, d84 = 0.0, d85 = 0.0, d86 = 0.0, d87 = 0.0, i88 = 0, i89 = 0, i90 = 0, i91 = 0, i92 = 0, d93 = 0.0, d94 = 0.0, d95 = 0.0, i96 = 0, d97 = 0.0, d98 = 0.0, d99 = 0.0, d100 = 0.0, i101 = 0, d102 = 0.0, d103 = 0.0, d104 = 0.0, d105 = 0.0, i106 = 0, i107 = 0, d108 = 0.0, d109 = 0.0, d110 = 0.0, d111 = 0.0, d112 = 0.0, d113 = 0.0, d114 = 0.0, d115 = 0.0, d116 = 0.0, i117 = 0, i118 = 0, d119 = 0.0, d120 = 0.0, d121 = 0.0, d122 = 0.0, d123 = 0.0, d124 = 0.0, d125 = 0.0, d126 = 0.0, d127 = 0.0, d128 = 0.0, d129 = 0.0, d130 = 0.0, d131 = 0.0, d132 = 0.0, d133 = 0.0;
 i7 = STACKTOP;
 STACKTOP = STACKTOP + 224 | 0;
 i8 = i7 | 0;
 i9 = i7 + 16 | 0;
 i10 = i7 + 32 | 0;
 i11 = i7 + 48 | 0;
 i12 = i7 + 64 | 0;
 i13 = i7 + 80 | 0;
 i14 = i7 + 96 | 0;
 i15 = i7 + 112 | 0;
 i16 = i7 + 128 | 0;
 i17 = i7 + 144 | 0;
 i18 = i7 + 160 | 0;
 i19 = i7 + 176 | 0;
 i20 = i7 + 192 | 0;
 i21 = i7 + 208 | 0;
 i22 = i1 + 4 | 0;
 __ZN22btVoronoiSimplexSolver5resetEv(HEAP32[i22 >> 2] | 0);
 i23 = i3 + 48 | 0;
 i24 = i2 + 48 | 0;
 d25 = +HEAPF32[i24 >> 2];
 i26 = i3 + 52 | 0;
 i27 = i2 + 52 | 0;
 d28 = +HEAPF32[i27 >> 2];
 i29 = i3 + 56 | 0;
 i3 = i2 + 56 | 0;
 d30 = +HEAPF32[i3 >> 2];
 i31 = i5 + 48 | 0;
 i32 = i4 + 48 | 0;
 d33 = +HEAPF32[i32 >> 2];
 i34 = i5 + 52 | 0;
 i35 = i4 + 52 | 0;
 d36 = +HEAPF32[i35 >> 2];
 i37 = i5 + 56 | 0;
 i5 = i4 + 56 | 0;
 d38 = +HEAPF32[i5 >> 2];
 i39 = i2 | 0;
 d40 = +HEAPF32[i39 >> 2];
 i41 = i2 + 4 | 0;
 d42 = +HEAPF32[i41 >> 2];
 i43 = i2 + 8 | 0;
 d44 = +HEAPF32[i43 >> 2];
 i45 = i2 + 16 | 0;
 d46 = +HEAPF32[i45 >> 2];
 i47 = i2 + 20 | 0;
 d48 = +HEAPF32[i47 >> 2];
 i49 = i2 + 24 | 0;
 d50 = +HEAPF32[i49 >> 2];
 i51 = i2 + 32 | 0;
 d52 = +HEAPF32[i51 >> 2];
 i53 = i2 + 36 | 0;
 d54 = +HEAPF32[i53 >> 2];
 i55 = i2 + 40 | 0;
 d56 = +HEAPF32[i55 >> 2];
 i2 = i4 | 0;
 d57 = +HEAPF32[i2 >> 2];
 i58 = i4 + 4 | 0;
 d59 = +HEAPF32[i58 >> 2];
 i60 = i4 + 8 | 0;
 d61 = +HEAPF32[i60 >> 2];
 i62 = i4 + 16 | 0;
 d63 = +HEAPF32[i62 >> 2];
 i64 = i4 + 20 | 0;
 d65 = +HEAPF32[i64 >> 2];
 i66 = i4 + 24 | 0;
 d67 = +HEAPF32[i66 >> 2];
 i68 = i4 + 32 | 0;
 d69 = +HEAPF32[i68 >> 2];
 i70 = i4 + 36 | 0;
 d71 = +HEAPF32[i70 >> 2];
 i72 = i4 + 40 | 0;
 d73 = +HEAPF32[i72 >> 2];
 d74 = +HEAPF32[i23 >> 2] - d25 - (+HEAPF32[i31 >> 2] - d33);
 d75 = +HEAPF32[i26 >> 2] - d28 - (+HEAPF32[i34 >> 2] - d36);
 d76 = +HEAPF32[i29 >> 2] - d30 - (+HEAPF32[i37 >> 2] - d38);
 i4 = i1 + 8 | 0;
 i77 = HEAP32[i4 >> 2] | 0;
 i78 = HEAP32[(HEAP32[i77 >> 2] | 0) + 60 >> 2] | 0;
 d79 = -0.0 - d74;
 d80 = -0.0 - d75;
 d81 = -0.0 - d76;
 HEAPF32[i11 >> 2] = d40 * d79 + d46 * d80 + d52 * d81;
 HEAPF32[i11 + 4 >> 2] = d42 * d79 + d48 * d80 + d54 * d81;
 HEAPF32[i11 + 8 >> 2] = d44 * d79 + d50 * d80 + d56 * d81;
 HEAPF32[i11 + 12 >> 2] = 0.0;
 FUNCTION_TABLE_viii[i78 & 127](i10, i77, i11);
 d81 = +HEAPF32[i10 >> 2];
 d80 = +HEAPF32[i10 + 4 >> 2];
 d79 = +HEAPF32[i10 + 8 >> 2];
 d82 = +HEAPF32[i24 >> 2] + (+HEAPF32[i39 >> 2] * d81 + +HEAPF32[i41 >> 2] * d80 + +HEAPF32[i43 >> 2] * d79);
 d83 = +HEAPF32[i27 >> 2] + (d81 * +HEAPF32[i45 >> 2] + d80 * +HEAPF32[i47 >> 2] + d79 * +HEAPF32[i49 >> 2]);
 d84 = +HEAPF32[i3 >> 2] + (d81 * +HEAPF32[i51 >> 2] + d80 * +HEAPF32[i53 >> 2] + d79 * +HEAPF32[i55 >> 2]);
 i55 = i9 | 0;
 HEAPF32[i55 >> 2] = d82;
 i53 = i9 + 4 | 0;
 HEAPF32[i53 >> 2] = d83;
 i51 = i9 + 8 | 0;
 HEAPF32[i51 >> 2] = d84;
 i49 = i9 + 12 | 0;
 HEAPF32[i49 >> 2] = 0.0;
 i47 = i1 + 12 | 0;
 i1 = HEAP32[i47 >> 2] | 0;
 i45 = HEAP32[(HEAP32[i1 >> 2] | 0) + 60 >> 2] | 0;
 d79 = d74 * +HEAPF32[i58 >> 2] + d75 * +HEAPF32[i64 >> 2] + d76 * +HEAPF32[i70 >> 2];
 d80 = d74 * +HEAPF32[i60 >> 2] + d75 * +HEAPF32[i66 >> 2] + d76 * +HEAPF32[i72 >> 2];
 HEAPF32[i14 >> 2] = d74 * +HEAPF32[i2 >> 2] + d75 * +HEAPF32[i62 >> 2] + d76 * +HEAPF32[i68 >> 2];
 HEAPF32[i14 + 4 >> 2] = d79;
 HEAPF32[i14 + 8 >> 2] = d80;
 HEAPF32[i14 + 12 >> 2] = 0.0;
 FUNCTION_TABLE_viii[i45 & 127](i13, i1, i14);
 d80 = +HEAPF32[i13 >> 2];
 d79 = +HEAPF32[i13 + 4 >> 2];
 d81 = +HEAPF32[i13 + 8 >> 2];
 d85 = +HEAPF32[i32 >> 2] + (+HEAPF32[i2 >> 2] * d80 + +HEAPF32[i58 >> 2] * d79 + +HEAPF32[i60 >> 2] * d81);
 d86 = +HEAPF32[i35 >> 2] + (d80 * +HEAPF32[i62 >> 2] + d79 * +HEAPF32[i64 >> 2] + d81 * +HEAPF32[i66 >> 2]);
 d87 = +HEAPF32[i5 >> 2] + (d80 * +HEAPF32[i68 >> 2] + d79 * +HEAPF32[i70 >> 2] + d81 * +HEAPF32[i72 >> 2]);
 i72 = i12 | 0;
 HEAPF32[i72 >> 2] = d85;
 i70 = i12 + 4 | 0;
 HEAPF32[i70 >> 2] = d86;
 i68 = i12 + 8 | 0;
 HEAPF32[i68 >> 2] = d87;
 i66 = i12 + 12 | 0;
 HEAPF32[i66 >> 2] = 0.0;
 d81 = d82 - d85;
 d85 = d83 - d86;
 d86 = d84 - d87;
 i64 = i8 | 0;
 HEAPF32[i64 >> 2] = d81;
 i62 = i8 + 4 | 0;
 HEAPF32[i62 >> 2] = d85;
 i60 = i8 + 8 | 0;
 HEAPF32[i60 >> 2] = d86;
 HEAPF32[i8 + 12 >> 2] = 0.0;
 L561 : do {
  if (d81 * d81 + d85 * d85 + d86 * d86 > 9999999747378752.0e-20) {
   i58 = i17 | 0;
   i2 = i17 + 4 | 0;
   i13 = i17 + 8 | 0;
   i14 = i17 + 12 | 0;
   i1 = i16 | 0;
   i45 = i16 + 4 | 0;
   i43 = i16 + 8 | 0;
   i41 = i19 | 0;
   i39 = i19 + 4 | 0;
   i10 = i19 + 8 | 0;
   i11 = i19 + 12 | 0;
   i77 = i18 | 0;
   i78 = i18 + 4 | 0;
   i88 = i18 + 8 | 0;
   i89 = i15 | 0;
   i90 = i15 + 4 | 0;
   i91 = i15 + 8 | 0;
   i92 = i15 + 12 | 0;
   d87 = d30;
   d84 = d28;
   d83 = d25;
   d82 = d38;
   d79 = d36;
   d80 = d33;
   d93 = 0.0;
   d94 = 0.0;
   d95 = 0.0;
   i96 = 32;
   d97 = 0.0;
   d98 = d81;
   d99 = d85;
   d100 = d86;
   while (1) {
    i101 = i96 - 1 | 0;
    if ((i96 | 0) == 0) {
     d102 = d93;
     d103 = d94;
     d104 = d95;
     d105 = d97;
     break L561;
    }
    i106 = HEAP32[i4 >> 2] | 0;
    i107 = HEAP32[(HEAP32[i106 >> 2] | 0) + 60 >> 2] | 0;
    d108 = -0.0 - d98;
    d109 = -0.0 - d99;
    d110 = -0.0 - d100;
    HEAPF32[i58 >> 2] = d40 * d108 + d46 * d109 + d52 * d110;
    HEAPF32[i2 >> 2] = d42 * d108 + d48 * d109 + d54 * d110;
    HEAPF32[i13 >> 2] = d44 * d108 + d50 * d109 + d56 * d110;
    HEAPF32[i14 >> 2] = 0.0;
    FUNCTION_TABLE_viii[i107 & 127](i16, i106, i17);
    d110 = +HEAPF32[i1 >> 2];
    d109 = +HEAPF32[i45 >> 2];
    d108 = +HEAPF32[i43 >> 2];
    d111 = d83 + (d40 * d110 + d42 * d109 + d44 * d108);
    d112 = d84 + (d46 * d110 + d48 * d109 + d50 * d108);
    d113 = d87 + (d52 * d110 + d54 * d109 + d56 * d108);
    HEAPF32[i55 >> 2] = d111;
    HEAPF32[i53 >> 2] = d112;
    HEAPF32[i51 >> 2] = d113;
    HEAPF32[i49 >> 2] = 0.0;
    i106 = HEAP32[i47 >> 2] | 0;
    i107 = HEAP32[(HEAP32[i106 >> 2] | 0) + 60 >> 2] | 0;
    HEAPF32[i41 >> 2] = d57 * d98 + d63 * d99 + d69 * d100;
    HEAPF32[i39 >> 2] = d59 * d98 + d65 * d99 + d71 * d100;
    HEAPF32[i10 >> 2] = d61 * d98 + d67 * d99 + d73 * d100;
    HEAPF32[i11 >> 2] = 0.0;
    FUNCTION_TABLE_viii[i107 & 127](i18, i106, i19);
    d108 = +HEAPF32[i77 >> 2];
    d109 = +HEAPF32[i78 >> 2];
    d110 = +HEAPF32[i88 >> 2];
    d114 = d80 + (d57 * d108 + d59 * d109 + d61 * d110);
    d115 = d79 + (d63 * d108 + d65 * d109 + d67 * d110);
    d116 = d82 + (d69 * d108 + d71 * d109 + d73 * d110);
    HEAPF32[i72 >> 2] = d114;
    HEAPF32[i70 >> 2] = d115;
    HEAPF32[i68 >> 2] = d116;
    HEAPF32[i66 >> 2] = 0.0;
    d110 = d111 - d114;
    d114 = d112 - d115;
    d115 = d113 - d116;
    HEAPF32[i89 >> 2] = d110;
    HEAPF32[i90 >> 2] = d114;
    HEAPF32[i91 >> 2] = d115;
    HEAPF32[i92 >> 2] = 0.0;
    d116 = d100 * d115 + (d98 * d110 + d99 * d114);
    if (d97 > 1.0) {
     i117 = 0;
     i118 = 511;
     break;
    }
    if (d116 > 0.0) {
     d113 = d74 * d98 + d75 * d99 + d76 * d100;
     if (d113 >= -1.4210854715202004e-14) {
      i117 = 0;
      i118 = 513;
      break;
     }
     d112 = d97 - d116 / d113;
     d113 = 1.0 - d112;
     d116 = +HEAPF32[i24 >> 2] * d113 + d112 * +HEAPF32[i23 >> 2];
     d111 = d113 * +HEAPF32[i27 >> 2] + d112 * +HEAPF32[i26 >> 2];
     d109 = d113 * +HEAPF32[i3 >> 2] + d112 * +HEAPF32[i29 >> 2];
     d108 = d113 * +HEAPF32[i32 >> 2] + d112 * +HEAPF32[i31 >> 2];
     d119 = d113 * +HEAPF32[i35 >> 2] + d112 * +HEAPF32[i34 >> 2];
     d120 = d113 * +HEAPF32[i5 >> 2] + d112 * +HEAPF32[i37 >> 2];
     HEAPF32[i89 >> 2] = d110;
     HEAPF32[i90 >> 2] = d114;
     HEAPF32[i91 >> 2] = d115;
     HEAPF32[i92 >> 2] = 0.0;
     d121 = d112;
     d122 = d98;
     d123 = d99;
     d124 = d100;
     d125 = d108;
     d126 = d119;
     d127 = d120;
     d128 = d116;
     d129 = d111;
     d130 = d109;
    } else {
     d121 = d97;
     d122 = d95;
     d123 = d94;
     d124 = d93;
     d125 = d80;
     d126 = d79;
     d127 = d82;
     d128 = d83;
     d129 = d84;
     d130 = d87;
    }
    if (!(__ZN22btVoronoiSimplexSolver9inSimplexERK9btVector3(HEAP32[i22 >> 2] | 0, i15) | 0)) {
     __ZN22btVoronoiSimplexSolver9addVertexERK9btVector3S2_S2_(HEAP32[i22 >> 2] | 0, i15, i9, i12);
    }
    if (!(__ZN22btVoronoiSimplexSolver7closestER9btVector3(HEAP32[i22 >> 2] | 0, i8) | 0)) {
     d102 = d124;
     d103 = d123;
     d104 = d122;
     d105 = d121;
     break L561;
    }
    d109 = +HEAPF32[i64 >> 2];
    d111 = +HEAPF32[i62 >> 2];
    d116 = +HEAPF32[i60 >> 2];
    if (d109 * d109 + d111 * d111 + d116 * d116 > 9999999747378752.0e-20) {
     d87 = d130;
     d84 = d129;
     d83 = d128;
     d82 = d127;
     d79 = d126;
     d80 = d125;
     d93 = d124;
     d94 = d123;
     d95 = d122;
     i96 = i101;
     d97 = d121;
     d98 = d109;
     d99 = d111;
     d100 = d116;
    } else {
     d102 = d124;
     d103 = d123;
     d104 = d122;
     d105 = d121;
     break L561;
    }
   }
   if ((i118 | 0) == 511) {
    STACKTOP = i7;
    return i117 | 0;
   } else if ((i118 | 0) == 513) {
    STACKTOP = i7;
    return i117 | 0;
   }
  } else {
   d102 = 0.0;
   d103 = 0.0;
   d104 = 0.0;
   d105 = 0.0;
  }
 } while (0);
 HEAPF32[i6 + 164 >> 2] = d105;
 d105 = d102 * d102 + (d104 * d104 + d103 * d103);
 if (d105 < 1.4210854715202004e-14) {
  _memset(i6 + 132 | 0, 0, 16);
  d131 = 0.0;
  d132 = 0.0;
  d133 = 0.0;
 } else {
  d121 = 1.0 / +Math_sqrt(+d105);
  d105 = d104 * d121;
  d104 = d103 * d121;
  d103 = d102 * d121;
  HEAPF32[i6 + 132 >> 2] = d105;
  HEAPF32[i6 + 136 >> 2] = d104;
  HEAPF32[i6 + 140 >> 2] = d103;
  HEAPF32[i6 + 144 >> 2] = 0.0;
  d131 = d105;
  d132 = d104;
  d133 = d103;
 }
 if (d76 * d133 + (d75 * d132 + d74 * d131) >= -0.0 - +HEAPF32[i6 + 172 >> 2]) {
  i117 = 0;
  STACKTOP = i7;
  return i117 | 0;
 }
 __ZN22btVoronoiSimplexSolver14compute_pointsER9btVector3S1_(HEAP32[i22 >> 2] | 0, i20, i21);
 i20 = i6 + 148 | 0;
 i6 = i21;
 HEAP32[i20 >> 2] = HEAP32[i6 >> 2];
 HEAP32[i20 + 4 >> 2] = HEAP32[i6 + 4 >> 2];
 HEAP32[i20 + 8 >> 2] = HEAP32[i6 + 8 >> 2];
 HEAP32[i20 + 12 >> 2] = HEAP32[i6 + 12 >> 2];
 i117 = 1;
 STACKTOP = i7;
 return i117 | 0;
}
function __ZN12gjkepa2_impl3GJK8EvaluateERKNS_13MinkowskiDiffERK9btVector3(i1, i2, i3) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 var i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, d18 = 0.0, d19 = 0.0, d20 = 0.0, d21 = 0.0, i22 = 0, i23 = 0, d24 = 0.0, i25 = 0, d26 = 0.0, i27 = 0, d28 = 0.0, i29 = 0, d30 = 0.0, d31 = 0.0, d32 = 0.0, d33 = 0.0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, d44 = 0.0, d45 = 0.0, d46 = 0.0, i47 = 0, d48 = 0.0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, d54 = 0.0, d55 = 0.0;
 i4 = STACKTOP;
 STACKTOP = STACKTOP + 120 | 0;
 i5 = i4 | 0;
 i6 = i4 + 64 | 0;
 i7 = i4 + 80 | 0;
 i8 = i4 + 96 | 0;
 i9 = i4 + 112 | 0;
 HEAP32[i1 + 348 >> 2] = i1 + 220;
 HEAP32[i1 + 352 >> 2] = i1 + 252;
 HEAP32[i1 + 356 >> 2] = i1 + 284;
 i10 = i1 + 316 | 0;
 HEAP32[i1 + 360 >> 2] = i10;
 i11 = i1 + 364 | 0;
 HEAP32[i11 >> 2] = 4;
 i12 = i1 + 368 | 0;
 HEAP32[i12 >> 2] = 0;
 i13 = i1 + 376 | 0;
 HEAP32[i13 >> 2] = 0;
 i14 = i2;
 i15 = i1;
 i16 = HEAP32[i14 + 4 >> 2] | 0;
 HEAP32[i15 >> 2] = HEAP32[i14 >> 2];
 HEAP32[i15 + 4 >> 2] = i16;
 i16 = i1 + 8 | 0;
 i15 = i2 + 8 | 0;
 HEAP32[i16 >> 2] = HEAP32[i15 >> 2];
 HEAP32[i16 + 4 >> 2] = HEAP32[i15 + 4 >> 2];
 HEAP32[i16 + 8 >> 2] = HEAP32[i15 + 8 >> 2];
 HEAP32[i16 + 12 >> 2] = HEAP32[i15 + 12 >> 2];
 i15 = i1 + 24 | 0;
 i16 = i2 + 24 | 0;
 HEAP32[i15 >> 2] = HEAP32[i16 >> 2];
 HEAP32[i15 + 4 >> 2] = HEAP32[i16 + 4 >> 2];
 HEAP32[i15 + 8 >> 2] = HEAP32[i16 + 8 >> 2];
 HEAP32[i15 + 12 >> 2] = HEAP32[i16 + 12 >> 2];
 i16 = i1 + 40 | 0;
 i15 = i2 + 40 | 0;
 HEAP32[i16 >> 2] = HEAP32[i15 >> 2];
 HEAP32[i16 + 4 >> 2] = HEAP32[i15 + 4 >> 2];
 HEAP32[i16 + 8 >> 2] = HEAP32[i15 + 8 >> 2];
 HEAP32[i16 + 12 >> 2] = HEAP32[i15 + 12 >> 2];
 i15 = i1 + 56 | 0;
 i16 = i2 + 56 | 0;
 HEAP32[i15 >> 2] = HEAP32[i16 >> 2];
 HEAP32[i15 + 4 >> 2] = HEAP32[i16 + 4 >> 2];
 HEAP32[i15 + 8 >> 2] = HEAP32[i16 + 8 >> 2];
 HEAP32[i15 + 12 >> 2] = HEAP32[i16 + 12 >> 2];
 i16 = i1 + 72 | 0;
 i15 = i2 + 72 | 0;
 HEAP32[i16 >> 2] = HEAP32[i15 >> 2];
 HEAP32[i16 + 4 >> 2] = HEAP32[i15 + 4 >> 2];
 HEAP32[i16 + 8 >> 2] = HEAP32[i15 + 8 >> 2];
 HEAP32[i16 + 12 >> 2] = HEAP32[i15 + 12 >> 2];
 i15 = i1 + 88 | 0;
 i16 = i2 + 88 | 0;
 HEAP32[i15 >> 2] = HEAP32[i16 >> 2];
 HEAP32[i15 + 4 >> 2] = HEAP32[i16 + 4 >> 2];
 HEAP32[i15 + 8 >> 2] = HEAP32[i16 + 8 >> 2];
 HEAP32[i15 + 12 >> 2] = HEAP32[i16 + 12 >> 2];
 i16 = i1 + 104 | 0;
 i15 = i2 + 104 | 0;
 HEAP32[i16 >> 2] = HEAP32[i15 >> 2];
 HEAP32[i16 + 4 >> 2] = HEAP32[i15 + 4 >> 2];
 HEAP32[i16 + 8 >> 2] = HEAP32[i15 + 8 >> 2];
 HEAP32[i16 + 12 >> 2] = HEAP32[i15 + 12 >> 2];
 i15 = i2 + 120 | 0;
 i2 = HEAP32[i15 + 4 >> 2] | 0;
 i16 = i1 + 120 | 0;
 HEAP32[i16 >> 2] = HEAP32[i15 >> 2];
 HEAP32[i16 + 4 >> 2] = i2;
 i2 = i1 + 144 | 0;
 HEAPF32[i2 >> 2] = 0.0;
 i16 = i1 + 180 | 0;
 HEAP32[i16 >> 2] = 0;
 i15 = i1 + 128 | 0;
 i14 = i15;
 i17 = i3;
 HEAP32[i14 >> 2] = HEAP32[i17 >> 2];
 HEAP32[i14 + 4 >> 2] = HEAP32[i17 + 4 >> 2];
 HEAP32[i14 + 8 >> 2] = HEAP32[i17 + 8 >> 2];
 HEAP32[i14 + 12 >> 2] = HEAP32[i17 + 12 >> 2];
 i17 = i15 | 0;
 d18 = +HEAPF32[i17 >> 2];
 i15 = i1 + 132 | 0;
 d19 = +HEAPF32[i15 >> 2];
 i3 = i1 + 136 | 0;
 d20 = +HEAPF32[i3 >> 2];
 d21 = d18 * d18 + d19 * d19 + d20 * d20;
 if (d21 > 0.0) {
  HEAPF32[i6 >> 2] = -0.0 - d18;
  HEAPF32[i6 + 4 >> 2] = -0.0 - d19;
  HEAPF32[i6 + 8 >> 2] = -0.0 - d20;
  HEAPF32[i6 + 12 >> 2] = 0.0;
 } else {
  HEAPF32[i6 >> 2] = 1.0;
  HEAPF32[i6 + 4 >> 2] = 0.0;
  HEAPF32[i6 + 8 >> 2] = 0.0;
  HEAPF32[i6 + 12 >> 2] = 0.0;
 }
 i22 = i1 + 164 | 0;
 HEAPF32[i22 >> 2] = 0.0;
 HEAP32[i11 >> 2] = 3;
 i23 = i1 + 148 | 0;
 HEAP32[i23 >> 2] = i10;
 HEAP32[i16 >> 2] = 1;
 __ZNK12gjkepa2_impl3GJK10getsupportERK9btVector3RNS0_3sSVE(i1, i6, i10);
 HEAPF32[i22 >> 2] = 1.0;
 i22 = (HEAP32[i23 >> 2] | 0) + 16 | 0;
 HEAP32[i14 >> 2] = HEAP32[i22 >> 2];
 HEAP32[i14 + 4 >> 2] = HEAP32[i22 + 4 >> 2];
 HEAP32[i14 + 8 >> 2] = HEAP32[i22 + 8 >> 2];
 HEAP32[i14 + 12 >> 2] = HEAP32[i22 + 12 >> 2];
 i14 = i5 + 48 | 0;
 HEAP32[i14 >> 2] = HEAP32[i22 >> 2];
 HEAP32[i14 + 4 >> 2] = HEAP32[i22 + 4 >> 2];
 HEAP32[i14 + 8 >> 2] = HEAP32[i22 + 8 >> 2];
 HEAP32[i14 + 12 >> 2] = HEAP32[i22 + 12 >> 2];
 i14 = i5 + 32 | 0;
 HEAP32[i14 >> 2] = HEAP32[i22 >> 2];
 HEAP32[i14 + 4 >> 2] = HEAP32[i22 + 4 >> 2];
 HEAP32[i14 + 8 >> 2] = HEAP32[i22 + 8 >> 2];
 HEAP32[i14 + 12 >> 2] = HEAP32[i22 + 12 >> 2];
 i14 = i5 + 16 | 0;
 HEAP32[i14 >> 2] = HEAP32[i22 >> 2];
 HEAP32[i14 + 4 >> 2] = HEAP32[i22 + 4 >> 2];
 HEAP32[i14 + 8 >> 2] = HEAP32[i22 + 8 >> 2];
 HEAP32[i14 + 12 >> 2] = HEAP32[i22 + 12 >> 2];
 i14 = i5;
 HEAP32[i14 >> 2] = HEAP32[i22 >> 2];
 HEAP32[i14 + 4 >> 2] = HEAP32[i22 + 4 >> 2];
 HEAP32[i14 + 8 >> 2] = HEAP32[i22 + 8 >> 2];
 HEAP32[i14 + 12 >> 2] = HEAP32[i22 + 12 >> 2];
 i22 = i7 | 0;
 i14 = i7 + 4 | 0;
 i23 = i7 + 8 | 0;
 i10 = i7 + 12 | 0;
 i6 = i8 | 0;
 d20 = +HEAPF32[i17 >> 2];
 d19 = +HEAPF32[i15 >> 2];
 d18 = +HEAPF32[i3 >> 2];
 d24 = +Math_sqrt(+(d20 * d20 + d19 * d19 + d18 * d18));
 L24 : do {
  if (d24 < 9999999747378752.0e-20) {
   i25 = 21;
  } else {
   i16 = i1 + 128 | 0;
   d26 = 0.0;
   i27 = 1;
   d28 = d21;
   i29 = 1;
   d30 = d20;
   d31 = d19;
   d32 = d18;
   d33 = d24;
   L26 : while (1) {
    i34 = HEAP32[i12 >> 2] | 0;
    i35 = 1 - i34 | 0;
    i36 = i1 + 148 + (i34 * 36 | 0) | 0;
    HEAPF32[i22 >> 2] = -0.0 - d30;
    HEAPF32[i14 >> 2] = -0.0 - d31;
    HEAPF32[i23 >> 2] = -0.0 - d32;
    HEAPF32[i10 >> 2] = 0.0;
    i37 = i1 + 148 + (i34 * 36 | 0) + 32 | 0;
    HEAPF32[i1 + 148 + (i34 * 36 | 0) + 16 + (HEAP32[i37 >> 2] << 2) >> 2] = 0.0;
    i38 = (HEAP32[i11 >> 2] | 0) - 1 | 0;
    HEAP32[i11 >> 2] = i38;
    HEAP32[i1 + 148 + (i34 * 36 | 0) + (HEAP32[i37 >> 2] << 2) >> 2] = HEAP32[i1 + 348 + (i38 << 2) >> 2];
    i38 = HEAP32[i37 >> 2] | 0;
    HEAP32[i37 >> 2] = i38 + 1;
    __ZNK12gjkepa2_impl3GJK10getsupportERK9btVector3RNS0_3sSVE(i1, i7, HEAP32[i1 + 148 + (i34 * 36 | 0) + (i38 << 2) >> 2] | 0);
    i38 = HEAP32[i37 >> 2] | 0;
    i39 = HEAP32[i1 + 148 + (i34 * 36 | 0) + (i38 - 1 << 2) >> 2] | 0;
    i40 = i39 + 16 | 0;
    i41 = i40 | 0;
    i42 = i39 + 20 | 0;
    i43 = i39 + 24 | 0;
    i39 = 0;
    while (1) {
     if (i39 >>> 0 >= 4) {
      break;
     }
     d44 = +HEAPF32[i41 >> 2] - +HEAPF32[i5 + (i39 << 4) >> 2];
     d45 = +HEAPF32[i42 >> 2] - +HEAPF32[i5 + (i39 << 4) + 4 >> 2];
     d46 = +HEAPF32[i43 >> 2] - +HEAPF32[i5 + (i39 << 4) + 8 >> 2];
     if (d44 * d44 + d45 * d45 + d46 * d46 < 9999999747378752.0e-20) {
      i25 = 25;
      break L26;
     } else {
      i39 = i39 + 1 | 0;
     }
    }
    i39 = i5 + (i27 << 4) | 0;
    i47 = i40;
    HEAP32[i39 >> 2] = HEAP32[i47 >> 2];
    HEAP32[i39 + 4 >> 2] = HEAP32[i47 + 4 >> 2];
    HEAP32[i39 + 8 >> 2] = HEAP32[i47 + 8 >> 2];
    HEAP32[i39 + 12 >> 2] = HEAP32[i47 + 12 >> 2];
    d46 = (+HEAPF32[i17 >> 2] * +HEAPF32[i41 >> 2] + +HEAPF32[i15 >> 2] * +HEAPF32[i42 >> 2] + +HEAPF32[i3 >> 2] * +HEAPF32[i43 >> 2]) / d33;
    d45 = d46 > d26 ? d46 : d26;
    if (d33 - d45 - d33 * 9999999747378752.0e-20 <= 0.0) {
     i25 = 27;
     break;
    }
    HEAP32[i9 >> 2] = 0;
    if ((i38 | 0) == 2) {
     d48 = +__ZN12gjkepa2_impl3GJK13projectoriginERK9btVector3S3_PfRj((HEAP32[i36 >> 2] | 0) + 16 | 0, (HEAP32[i1 + 148 + (i34 * 36 | 0) + 4 >> 2] | 0) + 16 | 0, i6, i9);
    } else if ((i38 | 0) == 3) {
     d48 = +__ZN12gjkepa2_impl3GJK13projectoriginERK9btVector3S3_S3_PfRj((HEAP32[i36 >> 2] | 0) + 16 | 0, (HEAP32[i1 + 148 + (i34 * 36 | 0) + 4 >> 2] | 0) + 16 | 0, (HEAP32[i1 + 148 + (i34 * 36 | 0) + 8 >> 2] | 0) + 16 | 0, i6, i9);
    } else if ((i38 | 0) == 4) {
     d48 = +__ZN12gjkepa2_impl3GJK13projectoriginERK9btVector3S3_S3_S3_PfRj((HEAP32[i36 >> 2] | 0) + 16 | 0, (HEAP32[i1 + 148 + (i34 * 36 | 0) + 4 >> 2] | 0) + 16 | 0, (HEAP32[i1 + 148 + (i34 * 36 | 0) + 8 >> 2] | 0) + 16 | 0, (HEAP32[i1 + 148 + (i34 * 36 | 0) + 12 >> 2] | 0) + 16 | 0, i6, i9);
    } else {
     d48 = d28;
    }
    if (d48 < 0.0) {
     i25 = 40;
     break;
    }
    i47 = i1 + 148 + (i35 * 36 | 0) + 32 | 0;
    HEAP32[i47 >> 2] = 0;
    _memset(i16 | 0, 0, 16);
    HEAP32[i12 >> 2] = i35;
    i39 = HEAP32[i37 >> 2] | 0;
    i49 = HEAP32[i9 >> 2] | 0;
    if ((i39 | 0) != 0) {
     i50 = 0;
     do {
      i51 = i1 + 148 + (i34 * 36 | 0) + (i50 << 2) | 0;
      i52 = HEAP32[i51 >> 2] | 0;
      if ((1 << i50 & i49 | 0) == 0) {
       i53 = HEAP32[i11 >> 2] | 0;
       HEAP32[i11 >> 2] = i53 + 1;
       HEAP32[i1 + 348 + (i53 << 2) >> 2] = i52;
      } else {
       HEAP32[i1 + 148 + (i35 * 36 | 0) + (HEAP32[i47 >> 2] << 2) >> 2] = i52;
       d46 = +HEAPF32[i8 + (i50 << 2) >> 2];
       i52 = HEAP32[i47 >> 2] | 0;
       HEAP32[i47 >> 2] = i52 + 1;
       HEAPF32[i1 + 148 + (i35 * 36 | 0) + 16 + (i52 << 2) >> 2] = d46;
       i52 = HEAP32[i51 >> 2] | 0;
       d44 = d46 * +HEAPF32[i52 + 20 >> 2];
       d54 = d46 * +HEAPF32[i52 + 24 >> 2];
       HEAPF32[i17 >> 2] = d46 * +HEAPF32[i52 + 16 >> 2] + +HEAPF32[i17 >> 2];
       HEAPF32[i15 >> 2] = d44 + +HEAPF32[i15 >> 2];
       HEAPF32[i3 >> 2] = d54 + +HEAPF32[i3 >> 2];
      }
      i50 = i50 + 1 | 0;
     } while (i50 >>> 0 < i39 >>> 0);
    }
    if ((i49 | 0) == 15) {
     HEAP32[i13 >> 2] = 1;
    }
    if (i29 >>> 0 >= 128) {
     i25 = 42;
     break;
    }
    if ((HEAP32[i13 >> 2] | 0) != 0) {
     break L24;
    }
    d54 = +HEAPF32[i17 >> 2];
    d44 = +HEAPF32[i15 >> 2];
    d46 = +HEAPF32[i3 >> 2];
    d55 = +Math_sqrt(+(d54 * d54 + d44 * d44 + d46 * d46));
    if (d55 < 9999999747378752.0e-20) {
     i25 = 21;
     break L24;
    } else {
     d26 = d45;
     i27 = i27 + 1 & 3;
     d28 = d48;
     i29 = i29 + 1 | 0;
     d30 = d54;
     d31 = d44;
     d32 = d46;
     d33 = d55;
    }
   }
   if ((i25 | 0) == 25) {
    i29 = HEAP32[i12 >> 2] | 0;
    i27 = i1 + 148 + (i29 * 36 | 0) + 32 | 0;
    i16 = (HEAP32[i27 >> 2] | 0) - 1 | 0;
    HEAP32[i27 >> 2] = i16;
    i27 = HEAP32[i1 + 148 + (i29 * 36 | 0) + (i16 << 2) >> 2] | 0;
    i16 = HEAP32[i11 >> 2] | 0;
    HEAP32[i11 >> 2] = i16 + 1;
    HEAP32[i1 + 348 + (i16 << 2) >> 2] = i27;
    break;
   } else if ((i25 | 0) == 27) {
    i27 = HEAP32[i12 >> 2] | 0;
    i16 = i1 + 148 + (i27 * 36 | 0) + 32 | 0;
    i29 = (HEAP32[i16 >> 2] | 0) - 1 | 0;
    HEAP32[i16 >> 2] = i29;
    i16 = HEAP32[i1 + 148 + (i27 * 36 | 0) + (i29 << 2) >> 2] | 0;
    i29 = HEAP32[i11 >> 2] | 0;
    HEAP32[i11 >> 2] = i29 + 1;
    HEAP32[i1 + 348 + (i29 << 2) >> 2] = i16;
    break;
   } else if ((i25 | 0) == 40) {
    i16 = HEAP32[i12 >> 2] | 0;
    i29 = i1 + 148 + (i16 * 36 | 0) + 32 | 0;
    i27 = (HEAP32[i29 >> 2] | 0) - 1 | 0;
    HEAP32[i29 >> 2] = i27;
    i29 = HEAP32[i1 + 148 + (i16 * 36 | 0) + (i27 << 2) >> 2] | 0;
    i27 = HEAP32[i11 >> 2] | 0;
    HEAP32[i11 >> 2] = i27 + 1;
    HEAP32[i1 + 348 + (i27 << 2) >> 2] = i29;
    break;
   } else if ((i25 | 0) == 42) {
    HEAP32[i13 >> 2] = 2;
    break;
   }
  }
 } while (0);
 if ((i25 | 0) == 21) {
  HEAP32[i13 >> 2] = 1;
 }
 HEAP32[i1 + 372 >> 2] = i1 + 148 + ((HEAP32[i12 >> 2] | 0) * 36 | 0);
 i12 = HEAP32[i13 >> 2] | 0;
 if ((i12 | 0) == 0) {
  d48 = +HEAPF32[i17 >> 2];
  d24 = +HEAPF32[i15 >> 2];
  d18 = +HEAPF32[i3 >> 2];
  HEAPF32[i2 >> 2] = +Math_sqrt(+(d48 * d48 + d24 * d24 + d18 * d18));
  STACKTOP = i4;
  return i12 | 0;
 } else if ((i12 | 0) == 1) {
  HEAPF32[i2 >> 2] = 0.0;
  STACKTOP = i4;
  return i12 | 0;
 } else {
  STACKTOP = i4;
  return i12 | 0;
 }
 return 0;
}
function __ZN35btSequentialImpulseConstraintSolver22setupContactConstraintER18btSolverConstraintP17btCollisionObjectS3_R15btManifoldPointRK19btContactSolverInfoR9btVector3RfSB_SA_SA_(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 i7 = i7 | 0;
 i8 = i8 | 0;
 i9 = i9 | 0;
 i10 = i10 | 0;
 i11 = i11 | 0;
 var i12 = 0, i13 = 0, d14 = 0.0, d15 = 0.0, i16 = 0, i17 = 0, i18 = 0, d19 = 0.0, i20 = 0, d21 = 0.0, d22 = 0.0, i23 = 0, d24 = 0.0, d25 = 0.0, d26 = 0.0, i27 = 0, d28 = 0.0, d29 = 0.0, d30 = 0.0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, d35 = 0.0, d36 = 0.0, d37 = 0.0, i38 = 0, i39 = 0, i40 = 0, d41 = 0.0, d42 = 0.0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, d49 = 0.0, d50 = 0.0, d51 = 0.0, d52 = 0.0, d53 = 0.0, d54 = 0.0, d55 = 0.0, d56 = 0.0, d57 = 0.0, d58 = 0.0, d59 = 0.0, d60 = 0.0, d61 = 0.0, d62 = 0.0, d63 = 0.0, d64 = 0.0, d65 = 0.0, d66 = 0.0, d67 = 0.0, i68 = 0, i69 = 0, i70 = 0;
 if ((HEAP32[i3 + 232 >> 2] & 2 | 0) == 0) {
  i12 = 0;
 } else {
  i12 = i3;
 }
 if ((HEAP32[i4 + 232 >> 2] & 2 | 0) == 0) {
  i13 = 0;
 } else {
  i13 = i4;
 }
 d14 = +HEAPF32[i5 + 52 >> 2] - +HEAPF32[i3 + 56 >> 2];
 d15 = +HEAPF32[i5 + 56 >> 2] - +HEAPF32[i3 + 60 >> 2];
 i1 = i10 | 0;
 HEAPF32[i1 >> 2] = +HEAPF32[i5 + 48 >> 2] - +HEAPF32[i3 + 52 >> 2];
 i3 = i10 + 4 | 0;
 HEAPF32[i3 >> 2] = d14;
 i16 = i10 + 8 | 0;
 HEAPF32[i16 >> 2] = d15;
 HEAPF32[i10 + 12 >> 2] = 0.0;
 d15 = +HEAPF32[i5 + 36 >> 2] - +HEAPF32[i4 + 56 >> 2];
 d14 = +HEAPF32[i5 + 40 >> 2] - +HEAPF32[i4 + 60 >> 2];
 i10 = i11 | 0;
 HEAPF32[i10 >> 2] = +HEAPF32[i5 + 32 >> 2] - +HEAPF32[i4 + 52 >> 2];
 i4 = i11 + 4 | 0;
 HEAPF32[i4 >> 2] = d15;
 i17 = i11 + 8 | 0;
 HEAPF32[i17 >> 2] = d14;
 HEAPF32[i11 + 12 >> 2] = 0.0;
 HEAPF32[i9 >> 2] = 1.0;
 i11 = i5 + 64 | 0;
 d14 = +HEAPF32[i3 >> 2];
 i18 = i5 + 72 | 0;
 d15 = +HEAPF32[i18 >> 2];
 d19 = +HEAPF32[i16 >> 2];
 i20 = i5 + 68 | 0;
 d21 = +HEAPF32[i20 >> 2];
 d22 = d14 * d15 - d19 * d21;
 i23 = i11 | 0;
 d24 = +HEAPF32[i23 >> 2];
 d25 = +HEAPF32[i1 >> 2];
 d26 = d19 * d24 - d15 * d25;
 d15 = d21 * d25 - d14 * d24;
 i27 = (i12 | 0) != 0;
 if (i27) {
  d28 = (d22 * +HEAPF32[i12 + 256 >> 2] + d26 * +HEAPF32[i12 + 260 >> 2] + d15 * +HEAPF32[i12 + 264 >> 2]) * +HEAPF32[i12 + 536 >> 2];
  d29 = (d22 * +HEAPF32[i12 + 272 >> 2] + d26 * +HEAPF32[i12 + 276 >> 2] + d15 * +HEAPF32[i12 + 280 >> 2]) * +HEAPF32[i12 + 540 >> 2];
  d30 = (d22 * +HEAPF32[i12 + 288 >> 2] + d26 * +HEAPF32[i12 + 292 >> 2] + d15 * +HEAPF32[i12 + 296 >> 2]) * +HEAPF32[i12 + 544 >> 2];
 } else {
  d28 = 0.0;
  d29 = 0.0;
  d30 = 0.0;
 }
 i31 = i2 + 48 | 0;
 HEAPF32[i31 >> 2] = d28;
 i32 = i2 + 52 | 0;
 HEAPF32[i32 >> 2] = d29;
 i33 = i2 + 56 | 0;
 HEAPF32[i33 >> 2] = d30;
 HEAPF32[i2 + 60 >> 2] = 0.0;
 d15 = +HEAPF32[i4 >> 2];
 d26 = +HEAPF32[i18 >> 2];
 d22 = +HEAPF32[i17 >> 2];
 d24 = +HEAPF32[i20 >> 2];
 d14 = +HEAPF32[i23 >> 2];
 d25 = +HEAPF32[i10 >> 2];
 i34 = (i13 | 0) != 0;
 if (i34) {
  d21 = -0.0 - (d15 * d26 - d22 * d24);
  d19 = -0.0 - (d22 * d14 - d26 * d25);
  d26 = -0.0 - (d24 * d25 - d15 * d14);
  d35 = (+HEAPF32[i13 + 256 >> 2] * d21 + +HEAPF32[i13 + 260 >> 2] * d19 + +HEAPF32[i13 + 264 >> 2] * d26) * +HEAPF32[i13 + 536 >> 2];
  d36 = (+HEAPF32[i13 + 272 >> 2] * d21 + +HEAPF32[i13 + 276 >> 2] * d19 + +HEAPF32[i13 + 280 >> 2] * d26) * +HEAPF32[i13 + 540 >> 2];
  d37 = (+HEAPF32[i13 + 288 >> 2] * d21 + +HEAPF32[i13 + 292 >> 2] * d19 + +HEAPF32[i13 + 296 >> 2] * d26) * +HEAPF32[i13 + 544 >> 2];
 } else {
  d35 = 0.0;
  d36 = 0.0;
  d37 = 0.0;
 }
 i38 = i2 + 64 | 0;
 HEAPF32[i38 >> 2] = d35;
 i39 = i2 + 68 | 0;
 HEAPF32[i39 >> 2] = d36;
 i40 = i2 + 72 | 0;
 HEAPF32[i40 >> 2] = d37;
 HEAPF32[i2 + 76 >> 2] = 0.0;
 if (i27) {
  d26 = +HEAPF32[i16 >> 2];
  d19 = +HEAPF32[i3 >> 2];
  d21 = +HEAPF32[i1 >> 2];
  d41 = +HEAPF32[i12 + 336 >> 2] + ((d29 * d26 - d30 * d19) * +HEAPF32[i23 >> 2] + (d30 * d21 - d28 * d26) * +HEAPF32[i20 >> 2] + (d28 * d19 - d29 * d21) * +HEAPF32[i18 >> 2]);
 } else {
  d41 = 0.0;
 }
 if (i34) {
  d21 = -0.0 - d35;
  d35 = -0.0 - d36;
  d36 = -0.0 - d37;
  d37 = +HEAPF32[i17 >> 2];
  d29 = +HEAPF32[i4 >> 2];
  d19 = +HEAPF32[i10 >> 2];
  d42 = +HEAPF32[i13 + 336 >> 2] + ((d37 * d35 - d29 * d36) * +HEAPF32[i23 >> 2] + (d19 * d36 - d37 * d21) * +HEAPF32[i20 >> 2] + (d29 * d21 - d19 * d35) * +HEAPF32[i18 >> 2]);
 } else {
  d42 = 0.0;
 }
 i43 = i2 + 92 | 0;
 HEAPF32[i43 >> 2] = +HEAPF32[i9 >> 2] / (d41 + d42);
 i9 = i2 + 16 | 0;
 i44 = i9;
 i45 = i11;
 HEAP32[i44 >> 2] = HEAP32[i45 >> 2];
 HEAP32[i44 + 4 >> 2] = HEAP32[i45 + 4 >> 2];
 HEAP32[i44 + 8 >> 2] = HEAP32[i45 + 8 >> 2];
 HEAP32[i44 + 12 >> 2] = HEAP32[i45 + 12 >> 2];
 d42 = +HEAPF32[i3 >> 2];
 d41 = +HEAPF32[i18 >> 2];
 d35 = +HEAPF32[i16 >> 2];
 d19 = +HEAPF32[i20 >> 2];
 d21 = +HEAPF32[i23 >> 2];
 d29 = +HEAPF32[i1 >> 2];
 i45 = i2 | 0;
 HEAPF32[i45 >> 2] = d42 * d41 - d35 * d19;
 i44 = i2 + 4 | 0;
 HEAPF32[i44 >> 2] = d35 * d21 - d41 * d29;
 i11 = i2 + 8 | 0;
 HEAPF32[i11 >> 2] = d19 * d29 - d42 * d21;
 HEAPF32[i2 + 12 >> 2] = 0.0;
 d21 = -0.0 - +HEAPF32[i23 >> 2];
 d42 = -0.0 - +HEAPF32[i20 >> 2];
 d29 = -0.0 - +HEAPF32[i18 >> 2];
 d19 = +HEAPF32[i4 >> 2];
 d41 = +HEAPF32[i17 >> 2];
 d35 = +HEAPF32[i10 >> 2];
 i46 = i2 + 32 | 0;
 HEAPF32[i46 >> 2] = d19 * d29 - d41 * d42;
 i47 = i2 + 36 | 0;
 HEAPF32[i47 >> 2] = d41 * d21 - d35 * d29;
 i48 = i2 + 40 | 0;
 HEAPF32[i48 >> 2] = d35 * d42 - d19 * d21;
 HEAPF32[i2 + 44 >> 2] = 0.0;
 if (i27) {
  d21 = +HEAPF32[i12 + 324 >> 2];
  d19 = +HEAPF32[i16 >> 2];
  d42 = +HEAPF32[i12 + 328 >> 2];
  d35 = +HEAPF32[i3 >> 2];
  d29 = +HEAPF32[i1 >> 2];
  d41 = +HEAPF32[i12 + 320 >> 2];
  d49 = d21 * d19 - d42 * d35 + +HEAPF32[i12 + 304 >> 2];
  d50 = +HEAPF32[i12 + 308 >> 2] + (d42 * d29 - d19 * d41);
  d51 = d35 * d41 - d21 * d29 + +HEAPF32[i12 + 312 >> 2];
 } else {
  d49 = 0.0;
  d50 = 0.0;
  d51 = 0.0;
 }
 if (i34) {
  d29 = +HEAPF32[i13 + 324 >> 2];
  d21 = +HEAPF32[i17 >> 2];
  d41 = +HEAPF32[i13 + 328 >> 2];
  d35 = +HEAPF32[i4 >> 2];
  d19 = +HEAPF32[i10 >> 2];
  d42 = +HEAPF32[i13 + 320 >> 2];
  d52 = d29 * d21 - d41 * d35 + +HEAPF32[i13 + 304 >> 2];
  d53 = +HEAPF32[i13 + 308 >> 2] + (d41 * d19 - d21 * d42);
  d54 = d35 * d42 - d29 * d19 + +HEAPF32[i13 + 312 >> 2];
 } else {
  d52 = 0.0;
  d53 = 0.0;
  d54 = 0.0;
 }
 d19 = d49 - d52;
 d52 = d50 - d53;
 d53 = d51 - d54;
 HEAPF32[i7 >> 2] = d19;
 HEAPF32[i7 + 4 >> 2] = d52;
 HEAPF32[i7 + 8 >> 2] = d53;
 HEAPF32[i7 + 12 >> 2] = 0.0;
 HEAPF32[i8 >> 2] = +HEAPF32[i23 >> 2] * d19 + d52 * +HEAPF32[i20 >> 2] + d53 * +HEAPF32[i18 >> 2];
 d53 = +HEAPF32[i5 + 80 >> 2] + +HEAPF32[i6 + 52 >> 2];
 HEAPF32[i2 + 88 >> 2] = +HEAPF32[i5 + 84 >> 2];
 do {
  if ((HEAP32[i5 + 144 >> 2] | 0) > (HEAP32[i6 + 64 >> 2] | 0)) {
   d55 = 0.0;
  } else {
   d52 = +HEAPF32[i5 + 88 >> 2] * (-0.0 - +HEAPF32[i8 >> 2]);
   if (d52 > 0.0) {
    d55 = d52;
    break;
   }
   d55 = 0.0;
  }
 } while (0);
 do {
  if ((HEAP32[i6 + 60 >> 2] & 4 | 0) == 0) {
   HEAPF32[i2 + 84 >> 2] = 0.0;
  } else {
   d52 = +HEAPF32[i5 + 112 >> 2] * +HEAPF32[i6 + 56 >> 2];
   i8 = i2 + 84 | 0;
   HEAPF32[i8 >> 2] = d52;
   do {
    if (i27) {
     d19 = +HEAPF32[i12 + 336 >> 2];
     if (d19 == 0.0) {
      break;
     }
     d54 = d52 * d19 * +HEAPF32[i2 + 20 >> 2] * +HEAPF32[i12 + 344 >> 2];
     d51 = d52 * d19 * +HEAPF32[i2 + 24 >> 2] * +HEAPF32[i12 + 348 >> 2];
     i18 = i12 + 504 | 0;
     HEAPF32[i18 >> 2] = +HEAPF32[i18 >> 2] + d52 * d19 * +HEAPF32[i9 >> 2] * +HEAPF32[i12 + 340 >> 2];
     i18 = i12 + 508 | 0;
     HEAPF32[i18 >> 2] = d54 + +HEAPF32[i18 >> 2];
     i18 = i12 + 512 | 0;
     HEAPF32[i18 >> 2] = d51 + +HEAPF32[i18 >> 2];
     d51 = d52 * +HEAPF32[i12 + 540 >> 2] * +HEAPF32[i32 >> 2];
     d54 = d52 * +HEAPF32[i12 + 544 >> 2] * +HEAPF32[i33 >> 2];
     i18 = i12 + 520 | 0;
     HEAPF32[i18 >> 2] = d52 * +HEAPF32[i12 + 536 >> 2] * +HEAPF32[i31 >> 2] + +HEAPF32[i18 >> 2];
     i18 = i12 + 524 | 0;
     HEAPF32[i18 >> 2] = d51 + +HEAPF32[i18 >> 2];
     i18 = i12 + 528 | 0;
     HEAPF32[i18 >> 2] = d54 + +HEAPF32[i18 >> 2];
    }
   } while (0);
   if (!i34) {
    break;
   }
   d52 = +HEAPF32[i13 + 336 >> 2];
   d54 = -0.0 - +HEAPF32[i8 >> 2];
   if (d52 == 0.0) {
    break;
   }
   d51 = -0.0 - +HEAPF32[i40 >> 2];
   d19 = -0.0 - +HEAPF32[i39 >> 2];
   d50 = -0.0 - +HEAPF32[i38 >> 2];
   d49 = d52 * +HEAPF32[i2 + 20 >> 2] * +HEAPF32[i13 + 344 >> 2] * d54;
   d29 = d52 * +HEAPF32[i2 + 24 >> 2] * +HEAPF32[i13 + 348 >> 2] * d54;
   i18 = i13 + 504 | 0;
   HEAPF32[i18 >> 2] = +HEAPF32[i18 >> 2] + d52 * +HEAPF32[i9 >> 2] * +HEAPF32[i13 + 340 >> 2] * d54;
   i18 = i13 + 508 | 0;
   HEAPF32[i18 >> 2] = d49 + +HEAPF32[i18 >> 2];
   i18 = i13 + 512 | 0;
   HEAPF32[i18 >> 2] = d29 + +HEAPF32[i18 >> 2];
   d29 = +HEAPF32[i13 + 540 >> 2] * d54 * d19;
   d19 = +HEAPF32[i13 + 544 >> 2] * d54 * d51;
   i18 = i13 + 520 | 0;
   HEAPF32[i18 >> 2] = +HEAPF32[i13 + 536 >> 2] * d54 * d50 + +HEAPF32[i18 >> 2];
   i18 = i13 + 524 | 0;
   HEAPF32[i18 >> 2] = d29 + +HEAPF32[i18 >> 2];
   i18 = i13 + 528 | 0;
   HEAPF32[i18 >> 2] = d19 + +HEAPF32[i18 >> 2];
  }
 } while (0);
 HEAPF32[i2 + 80 >> 2] = 0.0;
 if (i27) {
  d56 = +HEAPF32[i12 + 304 >> 2];
  d57 = +HEAPF32[i12 + 308 >> 2];
  d58 = +HEAPF32[i12 + 312 >> 2];
 } else {
  d56 = 0.0;
  d57 = 0.0;
  d58 = 0.0;
 }
 d19 = +HEAPF32[i9 >> 2];
 d29 = +HEAPF32[i2 + 20 >> 2];
 d50 = +HEAPF32[i2 + 24 >> 2];
 if (i27) {
  d59 = +HEAPF32[i12 + 320 >> 2];
  d60 = +HEAPF32[i12 + 324 >> 2];
  d61 = +HEAPF32[i12 + 328 >> 2];
 } else {
  d59 = 0.0;
  d60 = 0.0;
  d61 = 0.0;
 }
 if (i34) {
  d62 = +HEAPF32[i13 + 320 >> 2];
  d63 = +HEAPF32[i13 + 324 >> 2];
  d64 = +HEAPF32[i13 + 328 >> 2];
  d65 = d19 * +HEAPF32[i13 + 304 >> 2] + d29 * +HEAPF32[i13 + 308 >> 2] + d50 * +HEAPF32[i13 + 312 >> 2];
 } else {
  d62 = 0.0;
  d63 = 0.0;
  d64 = 0.0;
  d65 = d19 * 0.0 + d29 * 0.0 + d50 * 0.0;
 }
 d54 = d55 - (d56 * d19 + d57 * d29 + d58 * d50 + (d59 * +HEAPF32[i45 >> 2] + d60 * +HEAPF32[i44 >> 2] + d61 * +HEAPF32[i11 >> 2]) + (d62 * +HEAPF32[i46 >> 2] + d63 * +HEAPF32[i47 >> 2] + d64 * +HEAPF32[i48 >> 2] - d65));
 if (d53 > 0.0) {
  d66 = d54 - d53 / +HEAPF32[i6 + 12 >> 2];
  d67 = 0.0;
 } else {
  d66 = d54;
  d67 = +HEAPF32[i6 + 32 >> 2] * (-0.0 - d53) / +HEAPF32[i6 + 12 >> 2];
 }
 d54 = +HEAPF32[i43 >> 2];
 d65 = d67 * d54;
 d67 = d66 * d54;
 do {
  if ((HEAP32[i6 + 44 >> 2] | 0) != 0) {
   if (d53 > +HEAPF32[i6 + 48 >> 2]) {
    break;
   }
   HEAPF32[i2 + 116 >> 2] = d67;
   HEAPF32[i2 + 132 >> 2] = d65;
   i68 = i2 + 120 | 0;
   HEAPF32[i68 >> 2] = 0.0;
   i69 = i2 + 124 | 0;
   HEAPF32[i69 >> 2] = 0.0;
   i70 = i2 + 128 | 0;
   HEAPF32[i70 >> 2] = 1.0e10;
   return;
  }
 } while (0);
 HEAPF32[i2 + 116 >> 2] = d65 + d67;
 HEAPF32[i2 + 132 >> 2] = 0.0;
 i68 = i2 + 120 | 0;
 HEAPF32[i68 >> 2] = 0.0;
 i69 = i2 + 124 | 0;
 HEAPF32[i69 >> 2] = 0.0;
 i70 = i2 + 128 | 0;
 HEAPF32[i70 >> 2] = 1.0e10;
 return;
}
function __ZN20btConvexHullInternal15mergeProjectionERNS_16IntermediateHullES1_RPNS_6VertexES4_(i1, i2, i3, i4, i5) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 var i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0;
 i1 = i2 + 12 | 0;
 i6 = HEAP32[i1 >> 2] | 0;
 i7 = HEAP32[i3 + 8 >> 2] | 0;
 L791 : do {
  if ((HEAP32[i6 + 88 >> 2] | 0) == (HEAP32[i7 + 88 >> 2] | 0)) {
   if ((HEAP32[i6 + 92 >> 2] | 0) != (HEAP32[i7 + 92 >> 2] | 0)) {
    break;
   }
   i8 = HEAP32[i7 + 4 >> 2] | 0;
   if ((i8 | 0) == (i7 | 0)) {
    HEAP32[i4 >> 2] = i6;
    i9 = HEAP32[i7 + 8 >> 2] | 0;
    if ((i9 | 0) == 0) {
     i10 = 0;
     i11 = i7;
     HEAP32[i5 >> 2] = i11;
     return i10 | 0;
    }
    i10 = 0;
    i11 = HEAP32[i9 + 12 >> 2] | 0;
    HEAP32[i5 >> 2] = i11;
    return i10 | 0;
   }
   i9 = HEAP32[i7 >> 2] | 0;
   HEAP32[i8 >> 2] = i9;
   HEAP32[i9 + 4 >> 2] = i8;
   i12 = i3 | 0;
   L801 : do {
    if ((i7 | 0) == (HEAP32[i12 >> 2] | 0)) {
     i13 = HEAP32[i9 + 88 >> 2] | 0;
     i14 = HEAP32[i8 + 88 >> 2] | 0;
     do {
      if ((i13 | 0) >= (i14 | 0)) {
       if ((i13 | 0) == (i14 | 0)) {
        if ((HEAP32[i9 + 92 >> 2] | 0) < (HEAP32[i8 + 92 >> 2] | 0)) {
         break;
        }
       }
       HEAP32[i12 >> 2] = i8;
       break L801;
      }
     } while (0);
     HEAP32[i12 >> 2] = i9;
    }
   } while (0);
   i12 = i3 + 4 | 0;
   if ((i7 | 0) != (HEAP32[i12 >> 2] | 0)) {
    break;
   }
   i14 = HEAP32[i9 + 88 >> 2] | 0;
   i13 = HEAP32[i8 + 88 >> 2] | 0;
   do {
    if ((i14 | 0) <= (i13 | 0)) {
     if ((i14 | 0) == (i13 | 0)) {
      if ((HEAP32[i9 + 92 >> 2] | 0) > (HEAP32[i8 + 92 >> 2] | 0)) {
       break;
      }
     }
     HEAP32[i12 >> 2] = i8;
     break L791;
    }
   } while (0);
   HEAP32[i12 >> 2] = i9;
  }
 } while (0);
 i7 = i2 + 4 | 0;
 i6 = i3 + 4 | 0;
 i8 = i2 | 0;
 i2 = i3 | 0;
 i13 = 0;
 i14 = 1;
 i15 = 0;
 i16 = 0;
 i17 = i6;
 i18 = i7;
 L818 : while (1) {
  i19 = i13;
  i20 = HEAP32[i17 >> 2] | 0;
  i21 = HEAP32[i18 >> 2] | 0;
  while (1) {
   i22 = HEAP32[i21 + 88 >> 2] | 0;
   i23 = Math_imul((HEAP32[i20 + 88 >> 2] | 0) - i22 | 0, i14) | 0;
   L822 : do {
    if ((i23 | 0) > 0) {
     i24 = (i19 | 0) != 0;
     i25 = i21;
     i26 = i20;
     i27 = i23;
     i28 = HEAP32[i20 + 92 >> 2] | 0;
     while (1) {
      i29 = i26 + 88 | 0;
      i30 = i25 + 88 | 0;
      i31 = HEAP32[i25 + 92 >> 2] | 0;
      i32 = i28 - i31 | 0;
      i33 = HEAP32[(i24 ? i25 | 0 : i25 + 4 | 0) >> 2] | 0;
      L864 : do {
       if ((i33 | 0) == (i25 | 0)) {
        i34 = i27;
        i35 = i25;
        i36 = i30;
        i37 = i32;
       } else {
        i38 = i29 | 0;
        i39 = i27;
        i40 = i25;
        i41 = i30;
        i42 = i31;
        i43 = i32;
        i44 = i33;
        while (1) {
         i45 = HEAP32[i44 + 88 >> 2] | 0;
         i46 = Math_imul(i45 - (HEAP32[i41 >> 2] | 0) | 0, i14) | 0;
         i47 = HEAP32[i44 + 92 >> 2] | 0;
         i48 = i47 - i42 | 0;
         if ((i48 | 0) >= 1) {
          i34 = i39;
          i35 = i40;
          i36 = i41;
          i37 = i43;
          break L864;
         }
         if ((i46 | 0) != 0) {
          if ((i46 | 0) >= 0) {
           i34 = i39;
           i35 = i40;
           i36 = i41;
           i37 = i43;
           break L864;
          }
          i49 = Math_imul(i48, i39) | 0;
          if ((i49 | 0) > (Math_imul(i46, i43) | 0)) {
           i34 = i39;
           i35 = i40;
           i36 = i41;
           i37 = i43;
           break L864;
          }
         }
         i46 = Math_imul((HEAP32[i38 >> 2] | 0) - i45 | 0, i14) | 0;
         i45 = i44 + 88 | 0;
         i49 = i28 - i47 | 0;
         i48 = HEAP32[(i24 ? i44 | 0 : i44 + 4 | 0) >> 2] | 0;
         if ((i48 | 0) == (i44 | 0)) {
          i34 = i46;
          i35 = i44;
          i36 = i45;
          i37 = i49;
          break;
         } else {
          i39 = i46;
          i40 = i44;
          i41 = i45;
          i42 = i47;
          i43 = i49;
          i44 = i48;
         }
        }
       }
      } while (0);
      i33 = HEAP32[(i24 ? i26 | 0 : i26 + 4 | 0) >> 2] | 0;
      if ((i33 | 0) == (i26 | 0)) {
       i50 = i35;
       i51 = i26;
       break L822;
      }
      i32 = HEAP32[i33 + 88 >> 2] | 0;
      i31 = Math_imul(i32 - (HEAP32[i29 >> 2] | 0) | 0, i14) | 0;
      i30 = HEAP32[i33 + 92 >> 2] | 0;
      i44 = i30 - i28 | 0;
      i43 = Math_imul(i32 - (HEAP32[i36 >> 2] | 0) | 0, i14) | 0;
      if (!((i43 | 0) > 0 & (i44 | 0) < 0)) {
       i50 = i35;
       i51 = i26;
       break L822;
      }
      if ((i31 | 0) == 0) {
       i25 = i35;
       i26 = i33;
       i27 = i43;
       i28 = i30;
       continue;
      }
      if ((i31 | 0) >= 0) {
       i50 = i35;
       i51 = i26;
       break L822;
      }
      i32 = Math_imul(i44, i34) | 0;
      if ((i32 | 0) < (Math_imul(i31, i37) | 0)) {
       i25 = i35;
       i26 = i33;
       i27 = i43;
       i28 = i30;
      } else {
       i50 = i35;
       i51 = i26;
       break;
      }
     }
    } else {
     if ((i23 | 0) < 0) {
      i26 = (i19 | 0) != 0;
      i28 = i21;
      i27 = i20;
      i25 = i23;
      i24 = HEAP32[i20 + 92 >> 2] | 0;
      i30 = HEAP32[i21 + 92 >> 2] | 0;
      while (1) {
       i43 = HEAP32[(i26 ? i27 + 4 | 0 : i27 | 0) >> 2] | 0;
       i33 = (i43 | 0) == (i27 | 0);
       i31 = i27 + 88 | 0;
       i32 = i43 + 88 | 0;
       i44 = i43 + 92 | 0;
       i42 = i28;
       i41 = i25;
       i40 = i30;
       L828 : while (1) {
        i52 = i42 + 88 | 0;
        i39 = i24 - i40 | 0;
        do {
         if (!i33) {
          i53 = HEAP32[i32 >> 2] | 0;
          i38 = Math_imul(i53 - (HEAP32[i31 >> 2] | 0) | 0, i14) | 0;
          i54 = HEAP32[i44 >> 2] | 0;
          i48 = i54 - i24 | 0;
          if ((i48 | 0) <= -1) {
           break;
          }
          if ((i38 | 0) == 0) {
           break L828;
          }
          if ((i38 | 0) >= 0) {
           break;
          }
          i49 = Math_imul(i48, i41) | 0;
          if ((i49 | 0) <= (Math_imul(i38, i39) | 0)) {
           break L828;
          }
         }
        } while (0);
        i38 = HEAP32[(i26 ? i42 + 4 | 0 : i42 | 0) >> 2] | 0;
        if ((i38 | 0) == (i42 | 0)) {
         i50 = i42;
         i51 = i27;
         break L822;
        }
        i49 = HEAP32[i38 + 88 >> 2] | 0;
        i48 = Math_imul(i49 - (HEAP32[i52 >> 2] | 0) | 0, i14) | 0;
        i47 = HEAP32[i38 + 92 >> 2] | 0;
        i45 = i47 - i40 | 0;
        i46 = Math_imul((HEAP32[i31 >> 2] | 0) - i49 | 0, i14) | 0;
        if (!((i46 | 0) < 0 & (i45 | 0) > 0)) {
         i50 = i42;
         i51 = i27;
         break L822;
        }
        if ((i48 | 0) == 0) {
         i42 = i38;
         i41 = i46;
         i40 = i47;
         continue;
        }
        if ((i48 | 0) >= 0) {
         i50 = i42;
         i51 = i27;
         break L822;
        }
        i49 = Math_imul(i45, i41) | 0;
        if ((i49 | 0) < (Math_imul(i48, i39) | 0)) {
         i42 = i38;
         i41 = i46;
         i40 = i47;
        } else {
         i50 = i42;
         i51 = i27;
         break L822;
        }
       }
       i28 = i42;
       i27 = i43;
       i25 = Math_imul(i53 - (HEAP32[i52 >> 2] | 0) | 0, i14) | 0;
       i24 = i54;
       i30 = i40;
      }
     }
     i30 = HEAP32[i21 + 92 >> 2] | 0;
     i24 = (i19 | 0) != 0;
     L842 : do {
      if (i24) {
       i25 = i21;
       i27 = i30;
       while (1) {
        i28 = HEAP32[i25 >> 2] | 0;
        if ((i28 | 0) == (i21 | 0)) {
         i55 = i25;
         break L842;
        }
        if ((HEAP32[i28 + 88 >> 2] | 0) != (i22 | 0)) {
         i55 = i25;
         break L842;
        }
        i26 = HEAP32[i28 + 92 >> 2] | 0;
        if ((i26 | 0) > (i27 | 0)) {
         i55 = i25;
         break;
        } else {
         i25 = i28;
         i27 = i26;
        }
       }
      } else {
       i27 = i21;
       i25 = i30;
       while (1) {
        i40 = HEAP32[i27 + 4 >> 2] | 0;
        if ((i40 | 0) == (i21 | 0)) {
         i55 = i27;
         break L842;
        }
        if ((HEAP32[i40 + 88 >> 2] | 0) != (i22 | 0)) {
         i55 = i27;
         break L842;
        }
        i43 = HEAP32[i40 + 92 >> 2] | 0;
        if ((i43 | 0) > (i25 | 0)) {
         i55 = i27;
         break;
        } else {
         i27 = i40;
         i25 = i43;
        }
       }
      }
     } while (0);
     i30 = HEAP32[i20 + 92 >> 2] | 0;
     if (i24) {
      i25 = i20;
      i27 = i30;
      while (1) {
       i43 = HEAP32[i25 + 4 >> 2] | 0;
       if ((i43 | 0) == (i20 | 0)) {
        i50 = i55;
        i51 = i25;
        break L822;
       }
       if ((HEAP32[i43 + 88 >> 2] | 0) != (i22 | 0)) {
        i50 = i55;
        i51 = i25;
        break L822;
       }
       i40 = HEAP32[i43 + 92 >> 2] | 0;
       if ((i40 | 0) < (i27 | 0)) {
        i50 = i55;
        i51 = i25;
        break;
       } else {
        i25 = i43;
        i27 = i40;
       }
      }
     } else {
      i27 = i20;
      i25 = i30;
      while (1) {
       i24 = HEAP32[i27 >> 2] | 0;
       if ((i24 | 0) == (i20 | 0)) {
        i50 = i55;
        i51 = i27;
        break L822;
       }
       if ((HEAP32[i24 + 88 >> 2] | 0) != (i22 | 0)) {
        i50 = i55;
        i51 = i27;
        break L822;
       }
       i40 = HEAP32[i24 + 92 >> 2] | 0;
       if ((i40 | 0) < (i25 | 0)) {
        i50 = i55;
        i51 = i27;
        break;
       } else {
        i27 = i24;
        i25 = i40;
       }
      }
     }
    }
   } while (0);
   if ((i19 | 0) == 0) {
    i13 = 1;
    i14 = -1;
    i15 = i51;
    i16 = i50;
    i17 = i2;
    i18 = i8;
    continue L818;
   }
   i22 = i19 + 1 | 0;
   if ((i22 | 0) < 2) {
    i19 = i22;
    i20 = i51;
    i21 = i50;
   } else {
    break L818;
   }
  }
 }
 HEAP32[i50 + 4 >> 2] = i51;
 HEAP32[i51 >> 2] = i50;
 HEAP32[i16 >> 2] = i15;
 HEAP32[i15 + 4 >> 2] = i16;
 i50 = HEAP32[i2 >> 2] | 0;
 if ((HEAP32[i50 + 88 >> 2] | 0) < (HEAP32[(HEAP32[i8 >> 2] | 0) + 88 >> 2] | 0)) {
  HEAP32[i8 >> 2] = i50;
 }
 i50 = HEAP32[i6 >> 2] | 0;
 if ((HEAP32[i50 + 88 >> 2] | 0) >= (HEAP32[(HEAP32[i7 >> 2] | 0) + 88 >> 2] | 0)) {
  HEAP32[i7 >> 2] = i50;
 }
 HEAP32[i1 >> 2] = HEAP32[i3 + 12 >> 2];
 HEAP32[i4 >> 2] = i16;
 i10 = 1;
 i11 = i15;
 HEAP32[i5 >> 2] = i11;
 return i10 | 0;
}
function __ZN20btConvexHullInternal7computeEPKvbii(i1, i2, i3, i4, i5) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 var i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, d13 = 0.0, d14 = 0.0, d15 = 0.0, d16 = 0.0, d17 = 0.0, d18 = 0.0, i19 = 0, i20 = 0, d21 = 0.0, d22 = 0.0, d23 = 0.0, d24 = 0.0, d25 = 0.0, d26 = 0.0, d27 = 0.0, d28 = 0.0, d29 = 0.0, d30 = 0.0, d31 = 0.0, d32 = 0.0, d33 = 0.0, i34 = 0, d35 = 0.0, d36 = 0.0, d37 = 0.0, d38 = 0.0, d39 = 0.0, d40 = 0.0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, d47 = 0.0, d48 = 0.0, d49 = 0.0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0;
 i6 = STACKTOP;
 STACKTOP = STACKTOP + 88 | 0;
 i7 = i6 | 0;
 i8 = i6 + 24 | 0;
 i9 = i6 + 40 | 0;
 i10 = i6 + 56 | 0;
 i11 = i6 + 72 | 0;
 i12 = (i5 | 0) > 0;
 do {
  if (i3) {
   if (i12) {
    d13 = 1.0000000150474662e+30;
    d14 = 1.0000000150474662e+30;
    d15 = 1.0000000150474662e+30;
    d16 = -1.0000000150474662e+30;
    d17 = -1.0000000150474662e+30;
    d18 = -1.0000000150474662e+30;
    i19 = 0;
    i20 = i2;
   } else {
    d21 = -1.0000000150474662e+30;
    d22 = -1.0000000150474662e+30;
    d23 = -1.0000000150474662e+30;
    d24 = 1.0000000150474662e+30;
    d25 = 1.0000000150474662e+30;
    d26 = 1.0000000150474662e+30;
    break;
   }
   while (1) {
    d27 = +HEAPF64[i20 >> 3];
    d28 = +HEAPF64[i20 + 8 >> 3];
    d29 = +HEAPF64[i20 + 16 >> 3];
    d30 = d27 < d15 ? d27 : d15;
    d31 = d28 < d14 ? d28 : d14;
    d32 = d29 < d13 ? d29 : d13;
    d33 = d18 < d27 ? d27 : d18;
    d27 = d17 < d28 ? d28 : d17;
    d28 = d16 < d29 ? d29 : d16;
    i34 = i19 + 1 | 0;
    if ((i34 | 0) < (i5 | 0)) {
     d13 = d32;
     d14 = d31;
     d15 = d30;
     d16 = d28;
     d17 = d27;
     d18 = d33;
     i19 = i34;
     i20 = i20 + i4 | 0;
    } else {
     d21 = d33;
     d22 = d27;
     d23 = d28;
     d24 = d30;
     d25 = d31;
     d26 = d32;
     break;
    }
   }
  } else {
   if (i12) {
    d35 = 1.0000000150474662e+30;
    d36 = 1.0000000150474662e+30;
    d37 = 1.0000000150474662e+30;
    d38 = -1.0000000150474662e+30;
    d39 = -1.0000000150474662e+30;
    d40 = -1.0000000150474662e+30;
    i41 = 0;
    i42 = i2;
   } else {
    d21 = -1.0000000150474662e+30;
    d22 = -1.0000000150474662e+30;
    d23 = -1.0000000150474662e+30;
    d24 = 1.0000000150474662e+30;
    d25 = 1.0000000150474662e+30;
    d26 = 1.0000000150474662e+30;
    break;
   }
   while (1) {
    d32 = +HEAPF32[i42 >> 2];
    d31 = +HEAPF32[i42 + 4 >> 2];
    d30 = +HEAPF32[i42 + 8 >> 2];
    d28 = d32 < d37 ? d32 : d37;
    d27 = d31 < d36 ? d31 : d36;
    d33 = d30 < d35 ? d30 : d35;
    d29 = d40 < d32 ? d32 : d40;
    d32 = d39 < d31 ? d31 : d39;
    d31 = d38 < d30 ? d30 : d38;
    i34 = i41 + 1 | 0;
    if ((i34 | 0) < (i5 | 0)) {
     d35 = d33;
     d36 = d27;
     d37 = d28;
     d38 = d31;
     d39 = d32;
     d40 = d29;
     i41 = i34;
     i42 = i42 + i4 | 0;
    } else {
     d21 = d29;
     d22 = d32;
     d23 = d31;
     d24 = d28;
     d25 = d27;
     d26 = d33;
     break;
    }
   }
  }
 } while (0);
 d40 = d21 - d24;
 d39 = d22 - d25;
 d38 = d23 - d26;
 if (d40 < d39) {
  i42 = i1 + 112 | 0;
  HEAP32[i42 >> 2] = d39 < d38 ? 2 : 1;
  i43 = d40 < d38 ? 0 : 2;
  i44 = i42;
 } else {
  i42 = i1 + 112 | 0;
  HEAP32[i42 >> 2] = d40 < d38 ? 2 : 0;
  i43 = d39 < d38 ? 1 : 2;
  i44 = i42;
 }
 i42 = i1 + 104 | 0;
 HEAP32[i42 >> 2] = i43;
 i41 = HEAP32[i44 >> 2] | 0;
 if ((i43 | 0) == (i41 | 0)) {
  i20 = ((i43 + 1 | 0) >>> 0) % 3 | 0;
  HEAP32[i42 >> 2] = i20;
  i45 = HEAP32[i44 >> 2] | 0;
  i46 = i20;
 } else {
  i45 = i41;
  i46 = i43;
 }
 i43 = i1 + 108 | 0;
 HEAP32[i43 >> 2] = 3 - i46 - i45;
 d37 = d40 * 9788566967472434.0e-20;
 d40 = d39 * 9788566967472434.0e-20;
 d39 = d38 * 9788566967472434.0e-20;
 HEAPF32[i1 >> 2] = d37;
 HEAPF32[i1 + 4 >> 2] = d40;
 HEAPF32[i1 + 8 >> 2] = d39;
 HEAPF32[i1 + 12 >> 2] = 0.0;
 if (d37 > 0.0) {
  d47 = 1.0 / d37;
 } else {
  d47 = d37;
 }
 if (d40 > 0.0) {
  d48 = 1.0 / d40;
 } else {
  d48 = d40;
 }
 if (d39 > 0.0) {
  d49 = 1.0 / d39;
 } else {
  d49 = d39;
 }
 i45 = i1 + 16 | 0;
 HEAPF32[i1 + 16 >> 2] = (d24 + d21) * .5;
 i46 = i1 + 20 | 0;
 HEAPF32[i46 >> 2] = (d25 + d22) * .5;
 i41 = i1 + 24 | 0;
 HEAPF32[i41 >> 2] = (d26 + d23) * .5;
 HEAPF32[i1 + 28 >> 2] = 0.0;
 i20 = i7 + 16 | 0;
 HEAP8[i20] = 1;
 i19 = i7 + 12 | 0;
 HEAP32[i19 >> 2] = 0;
 i34 = i7 + 4 | 0;
 HEAP32[i34 >> 2] = 0;
 i50 = i7 + 8 | 0;
 HEAP32[i50 >> 2] = 0;
 L1398 : do {
  if (i12) {
   i51 = __Z22btAlignedAllocInternalji(i5 << 4, 16) | 0;
   i52 = HEAP32[i34 >> 2] | 0;
   if ((i52 | 0) > 0) {
    i53 = 0;
    do {
     i54 = i51 + (i53 << 4) | 0;
     if ((i54 | 0) != 0) {
      i55 = i54;
      i54 = (HEAP32[i19 >> 2] | 0) + (i53 << 4) | 0;
      HEAP32[i55 >> 2] = HEAP32[i54 >> 2];
      HEAP32[i55 + 4 >> 2] = HEAP32[i54 + 4 >> 2];
      HEAP32[i55 + 8 >> 2] = HEAP32[i54 + 8 >> 2];
      HEAP32[i55 + 12 >> 2] = HEAP32[i54 + 12 >> 2];
     }
     i53 = i53 + 1 | 0;
    } while ((i53 | 0) < (i52 | 0));
   }
   i52 = HEAP32[i19 >> 2] | 0;
   if ((i52 | 0) != 0) {
    if ((HEAP8[i20] | 0) != 0) {
     __Z21btAlignedFreeInternalPv(i52);
    }
    HEAP32[i19 >> 2] = 0;
   }
   HEAP8[i20] = 1;
   HEAP32[i19 >> 2] = i51;
   HEAP32[i50 >> 2] = i5;
   i52 = i8;
   i53 = 0;
   i54 = i51;
   while (1) {
    i55 = i54 + (i53 << 4) | 0;
    if ((i55 | 0) != 0) {
     i56 = i55;
     HEAP32[i56 >> 2] = HEAP32[i52 >> 2];
     HEAP32[i56 + 4 >> 2] = HEAP32[i52 + 4 >> 2];
     HEAP32[i56 + 8 >> 2] = HEAP32[i52 + 8 >> 2];
     HEAP32[i56 + 12 >> 2] = HEAP32[i52 + 12 >> 2];
    }
    i56 = i53 + 1 | 0;
    if ((i56 | 0) >= (i5 | 0)) {
     break L1398;
    }
    i53 = i56;
    i54 = HEAP32[i19 >> 2] | 0;
   }
  }
 } while (0);
 HEAP32[i34 >> 2] = i5;
 L1421 : do {
  if (i3) {
   if (!i12) {
    break;
   }
   i8 = i9 | 0;
   i54 = i9 + 4 | 0;
   i53 = i9 + 8 | 0;
   i52 = i9 + 12 | 0;
   i51 = HEAP32[i19 >> 2] | 0;
   d23 = +HEAPF32[i45 >> 2];
   d26 = +HEAPF32[i46 >> 2];
   d22 = +HEAPF32[i41 >> 2];
   i56 = 0;
   i55 = i2;
   while (1) {
    d25 = d48 * (+HEAPF64[i55 + 8 >> 3] - d26);
    d21 = d49 * (+HEAPF64[i55 + 16 >> 3] - d22);
    HEAPF32[i8 >> 2] = d47 * (+HEAPF64[i55 >> 3] - d23);
    HEAPF32[i54 >> 2] = d25;
    HEAPF32[i53 >> 2] = d21;
    HEAPF32[i52 >> 2] = 0.0;
    HEAP32[i51 + (i56 << 4) >> 2] = ~~+HEAPF32[i9 + (HEAP32[i43 >> 2] << 2) >> 2];
    HEAP32[i51 + (i56 << 4) + 4 >> 2] = ~~+HEAPF32[i9 + (HEAP32[i44 >> 2] << 2) >> 2];
    HEAP32[i51 + (i56 << 4) + 8 >> 2] = ~~+HEAPF32[i9 + (HEAP32[i42 >> 2] << 2) >> 2];
    HEAP32[i51 + (i56 << 4) + 12 >> 2] = i56;
    i57 = i56 + 1 | 0;
    if ((i57 | 0) >= (i5 | 0)) {
     break L1421;
    }
    i56 = i57;
    i55 = i55 + i4 | 0;
   }
  } else {
   if (!i12) {
    break;
   }
   i55 = i10 | 0;
   i56 = i10 + 4 | 0;
   i51 = i10 + 8 | 0;
   i52 = i10 + 12 | 0;
   i53 = HEAP32[i19 >> 2] | 0;
   d23 = +HEAPF32[i45 >> 2];
   d22 = +HEAPF32[i46 >> 2];
   d26 = +HEAPF32[i41 >> 2];
   i54 = 0;
   i8 = i2;
   while (1) {
    d21 = +HEAPF32[i8 >> 2];
    HEAPF32[i55 >> 2] = d21;
    d25 = +HEAPF32[i8 + 4 >> 2];
    HEAPF32[i56 >> 2] = d25;
    d24 = d49 * (+HEAPF32[i8 + 8 >> 2] - d26);
    HEAPF32[i55 >> 2] = d47 * (d21 - d23);
    HEAPF32[i56 >> 2] = d48 * (d25 - d22);
    HEAPF32[i51 >> 2] = d24;
    HEAPF32[i52 >> 2] = 0.0;
    HEAP32[i53 + (i54 << 4) >> 2] = ~~+HEAPF32[i10 + (HEAP32[i43 >> 2] << 2) >> 2];
    HEAP32[i53 + (i54 << 4) + 4 >> 2] = ~~+HEAPF32[i10 + (HEAP32[i44 >> 2] << 2) >> 2];
    HEAP32[i53 + (i54 << 4) + 8 >> 2] = ~~+HEAPF32[i10 + (HEAP32[i42 >> 2] << 2) >> 2];
    HEAP32[i53 + (i54 << 4) + 12 >> 2] = i54;
    i57 = i54 + 1 | 0;
    if ((i57 | 0) >= (i5 | 0)) {
     break L1421;
    }
    i54 = i57;
    i8 = i8 + i4 | 0;
   }
  }
 } while (0);
 i4 = HEAP32[i34 >> 2] | 0;
 if ((i4 | 0) > 1) {
  __ZN20btAlignedObjectArrayIN20btConvexHullInternal7Point32EE17quickSortInternalIPFbRKS1_S5_EEEvT_ii(i7, 14, 0, i4 - 1 | 0);
 }
 i4 = i1 + 32 | 0;
 HEAP32[i1 + 36 >> 2] = HEAP32[i4 >> 2];
 HEAP32[i1 + 40 >> 2] = 0;
 HEAP32[i1 + 44 >> 2] = i5;
 i7 = i1 + 84 | 0;
 i42 = HEAP32[i7 >> 2] | 0;
 if ((i42 | 0) < (i5 | 0)) {
  i10 = i1 + 88 | 0;
  if ((HEAP32[i10 >> 2] | 0) < (i5 | 0)) {
   if ((i5 | 0) == 0) {
    i58 = 0;
    i59 = i42;
   } else {
    i44 = __Z22btAlignedAllocInternalji(i5 << 2, 16) | 0;
    i58 = i44;
    i59 = HEAP32[i7 >> 2] | 0;
   }
   i44 = i1 + 92 | 0;
   if ((i59 | 0) > 0) {
    i43 = 0;
    do {
     i2 = i58 + (i43 << 2) | 0;
     if ((i2 | 0) != 0) {
      HEAP32[i2 >> 2] = HEAP32[(HEAP32[i44 >> 2] | 0) + (i43 << 2) >> 2];
     }
     i43 = i43 + 1 | 0;
    } while ((i43 | 0) < (i59 | 0));
   }
   i59 = HEAP32[i44 >> 2] | 0;
   i43 = i1 + 96 | 0;
   if ((i59 | 0) != 0) {
    if ((HEAP8[i43] | 0) != 0) {
     __Z21btAlignedFreeInternalPv(i59);
    }
    HEAP32[i44 >> 2] = 0;
   }
   HEAP8[i43] = 1;
   HEAP32[i44 >> 2] = i58;
   HEAP32[i10 >> 2] = i5;
   i60 = i44;
  } else {
   i60 = i1 + 92 | 0;
  }
  i44 = i42;
  do {
   i42 = (HEAP32[i60 >> 2] | 0) + (i44 << 2) | 0;
   if ((i42 | 0) != 0) {
    HEAP32[i42 >> 2] = 0;
   }
   i44 = i44 + 1 | 0;
  } while ((i44 | 0) < (i5 | 0));
 }
 HEAP32[i7 >> 2] = i5;
 if (i12) {
  i12 = i1 + 92 | 0;
  i7 = 0;
  do {
   i44 = __ZN20btConvexHullInternal4PoolINS_6VertexEE9newObjectEv(i4) | 0;
   HEAP32[i44 + 8 >> 2] = 0;
   i60 = i44 + 88 | 0;
   i42 = (HEAP32[i19 >> 2] | 0) + (i7 << 4) | 0;
   HEAP32[i60 >> 2] = HEAP32[i42 >> 2];
   HEAP32[i60 + 4 >> 2] = HEAP32[i42 + 4 >> 2];
   HEAP32[i60 + 8 >> 2] = HEAP32[i42 + 8 >> 2];
   HEAP32[i60 + 12 >> 2] = HEAP32[i42 + 12 >> 2];
   HEAP32[i44 + 104 >> 2] = -1;
   HEAP32[(HEAP32[i12 >> 2] | 0) + (i7 << 2) >> 2] = i44;
   i7 = i7 + 1 | 0;
  } while ((i7 | 0) < (i5 | 0));
 }
 i7 = HEAP32[i19 >> 2] | 0;
 if ((i7 | 0) != 0) {
  if ((HEAP8[i20] | 0) != 0) {
   __Z21btAlignedFreeInternalPv(i7);
  }
  HEAP32[i19 >> 2] = 0;
 }
 HEAP8[i20] = 1;
 HEAP32[i19 >> 2] = 0;
 HEAP32[i34 >> 2] = 0;
 HEAP32[i50 >> 2] = 0;
 HEAP32[i1 + 52 >> 2] = HEAP32[i1 + 48 >> 2];
 HEAP32[i1 + 56 >> 2] = 0;
 HEAP32[i1 + 60 >> 2] = i5 * 6 | 0;
 HEAP32[i1 + 116 >> 2] = 0;
 HEAP32[i1 + 120 >> 2] = 0;
 HEAP32[i1 + 100 >> 2] = -3;
 _memset(i11 | 0, 0, 16);
 __ZN20btConvexHullInternal15computeInternalEiiRNS_16IntermediateHullE(i1, 0, i5, i11);
 HEAP32[i1 + 124 >> 2] = HEAP32[i11 >> 2];
 i11 = HEAP32[i19 >> 2] | 0;
 if ((i11 | 0) == 0) {
  STACKTOP = i6;
  return;
 }
 if ((HEAP8[i20] | 0) != 0) {
  __Z21btAlignedFreeInternalPv(i11);
 }
 HEAP32[i19 >> 2] = 0;
 STACKTOP = i6;
 return;
}
function __ZN35btSequentialImpulseConstraintSolver14convertContactEP20btPersistentManifoldRK19btContactSolverInfo(i1, i2, i3) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 var i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, d52 = 0.0, d53 = 0.0, d54 = 0.0, d55 = 0.0, d56 = 0.0, d57 = 0.0, d58 = 0.0, i59 = 0, i60 = 0, i61 = 0, d62 = 0.0, d63 = 0.0, i64 = 0, d65 = 0.0;
 i4 = STACKTOP;
 STACKTOP = STACKTOP + 128 | 0;
 i5 = i4 | 0;
 i6 = i4 + 16 | 0;
 i7 = i4 + 32 | 0;
 i8 = i4 + 48 | 0;
 i9 = i4 + 64 | 0;
 i10 = i4 + 80 | 0;
 i11 = i4 + 96 | 0;
 i12 = i4 + 104 | 0;
 i13 = i4 + 112 | 0;
 i14 = HEAP32[i2 + 1108 >> 2] | 0;
 i15 = i14;
 i16 = HEAP32[i2 + 1112 >> 2] | 0;
 i17 = i16;
 i18 = i14 + 232 | 0;
 if ((HEAP32[i18 >> 2] & 2 | 0) == 0) {
  i19 = 0;
 } else {
  i19 = i14;
 }
 i20 = i16 + 232 | 0;
 if ((HEAP32[i20 >> 2] & 2 | 0) == 0) {
  i21 = 0;
 } else {
  i21 = i16;
 }
 if ((i19 | 0) == 0) {
  i22 = 1360;
 } else {
  if (+HEAPF32[i19 + 336 >> 2] == 0.0) {
   i22 = 1360;
  }
 }
 do {
  if ((i22 | 0) == 1360) {
   if ((i21 | 0) == 0) {
    STACKTOP = i4;
    return;
   }
   if (+HEAPF32[i21 + 336 >> 2] != 0.0) {
    break;
   }
   STACKTOP = i4;
   return;
  }
 } while (0);
 i21 = i2 + 1116 | 0;
 i19 = HEAP32[i21 >> 2] | 0;
 if ((i19 | 0) <= 0) {
  STACKTOP = i4;
  return;
 }
 i23 = i2 + 1124 | 0;
 i24 = i1 + 8 | 0;
 i25 = i1 + 12 | 0;
 i26 = i1 + 16 | 0;
 i27 = i1 + 20 | 0;
 i28 = i1 + 48 | 0;
 i29 = i3 + 60 | 0;
 i30 = i13 | 0;
 i31 = i13 + 4 | 0;
 i32 = i13 + 8 | 0;
 i33 = i16;
 i16 = i14;
 i14 = i7;
 i34 = i8;
 i35 = i5;
 i36 = i6;
 i37 = 0;
 i38 = i19;
 while (1) {
  i19 = i2 + 4 + (i37 * 276 | 0) | 0;
  if (+HEAPF32[i2 + 4 + (i37 * 276 | 0) + 80 >> 2] > +HEAPF32[i23 >> 2]) {
   i39 = i38;
  } else {
   i40 = HEAP32[i24 >> 2] | 0;
   do {
    if ((i40 | 0) == (HEAP32[i25 >> 2] | 0)) {
     i41 = (i40 | 0) == 0 ? 1 : i40 << 1;
     if ((i40 | 0) >= (i41 | 0)) {
      i42 = i40;
      break;
     }
     if ((i41 | 0) == 0) {
      i43 = 0;
      i44 = i40;
     } else {
      i45 = __Z22btAlignedAllocInternalji(i41 * 136 | 0, 16) | 0;
      i43 = i45;
      i44 = HEAP32[i24 >> 2] | 0;
     }
     if ((i44 | 0) > 0) {
      i45 = 0;
      do {
       i46 = i43 + (i45 * 136 | 0) | 0;
       i47 = (HEAP32[i26 >> 2] | 0) + (i45 * 136 | 0) | 0;
       _memcpy(i46 | 0, i47 | 0, 136) | 0;
       i45 = i45 + 1 | 0;
      } while ((i45 | 0) < (i44 | 0));
     }
     i45 = HEAP32[i26 >> 2] | 0;
     if ((i45 | 0) != 0) {
      if ((HEAP8[i27] | 0) != 0) {
       __Z21btAlignedFreeInternalPv(i45);
      }
      HEAP32[i26 >> 2] = 0;
     }
     HEAP8[i27] = 1;
     HEAP32[i26 >> 2] = i43;
     HEAP32[i25 >> 2] = i41;
     i42 = HEAP32[i24 >> 2] | 0;
    } else {
     i42 = i40;
    }
   } while (0);
   HEAP32[i24 >> 2] = i42 + 1;
   i45 = HEAP32[i26 >> 2] | 0;
   i47 = i45 + (i40 * 136 | 0) | 0;
   i46 = (HEAP32[i18 >> 2] & 2 | 0) == 0 ? 0 : i16;
   i48 = (HEAP32[i20 >> 2] & 2 | 0) == 0 ? 0 : i33;
   if ((i46 | 0) == 0) {
    do {
     if ((HEAP8[14328] | 0) == 0) {
      if ((___cxa_guard_acquire(14328) | 0) == 0) {
       break;
      }
      _memset(i14 | 0, 0, 16);
      __ZN11btRigidBodyC2EfP13btMotionStateP16btCollisionShapeRK9btVector3(12536, 0.0, 0, 0, i7);
      _atexit(268, 12536, ___dso_handle | 0) | 0;
     }
    } while (0);
    _memset(i34 | 0, 0, 16);
    __ZN11btRigidBody12setMassPropsEfRK9btVector3(12536, 0.0, i8);
    i49 = 12536;
   } else {
    i49 = i46;
   }
   HEAP32[i45 + (i40 * 136 | 0) + 104 >> 2] = i49;
   if ((i48 | 0) == 0) {
    do {
     if ((HEAP8[14328] | 0) == 0) {
      if ((___cxa_guard_acquire(14328) | 0) == 0) {
       break;
      }
      _memset(i35 | 0, 0, 16);
      __ZN11btRigidBodyC2EfP13btMotionStateP16btCollisionShapeRK9btVector3(12536, 0.0, 0, 0, i5);
      _atexit(268, 12536, ___dso_handle | 0) | 0;
     }
    } while (0);
    _memset(i36 | 0, 0, 16);
    __ZN11btRigidBody12setMassPropsEfRK9btVector3(12536, 0.0, i6);
    i50 = 12536;
   } else {
    i50 = i48;
   }
   HEAP32[i45 + (i40 * 136 | 0) + 108 >> 2] = i50;
   HEAP32[i45 + (i40 * 136 | 0) + 112 >> 2] = i19;
   __ZN35btSequentialImpulseConstraintSolver22setupContactConstraintER18btSolverConstraintP17btCollisionObjectS3_R15btManifoldPointRK19btContactSolverInfoR9btVector3RfSB_SA_SA_(0, i47, i15, i17, i19, i3, i13, i12, i11, i9, i10);
   HEAP32[i45 + (i40 * 136 | 0) + 100 >> 2] = HEAP32[i28 >> 2];
   do {
    if ((HEAP32[i29 >> 2] & 32 | 0) == 0) {
     i22 = 1392;
    } else {
     if ((HEAP8[i2 + 4 + (i37 * 276 | 0) + 116 | 0] | 0) == 0) {
      i22 = 1392;
      break;
     }
     i51 = i2 + 4 + (i37 * 276 | 0) + 148 | 0;
     d52 = +HEAPF32[i11 >> 2];
     d53 = +HEAPF32[i2 + 4 + (i37 * 276 | 0) + 128 >> 2];
     d54 = +HEAPF32[i2 + 4 + (i37 * 276 | 0) + 136 >> 2];
     __ZN35btSequentialImpulseConstraintSolver21addFrictionConstraintERK9btVector3P11btRigidBodyS4_iR15btManifoldPointS2_S2_P17btCollisionObjectS8_fff(i1, i51, 0, 0, i40, i19, i9, i10, i15, i17, d52, d53, d54) | 0;
     if ((HEAP32[i29 >> 2] & 16 | 0) == 0) {
      break;
     }
     i51 = i2 + 4 + (i37 * 276 | 0) + 164 | 0;
     d54 = +HEAPF32[i2 + 4 + (i37 * 276 | 0) + 132 >> 2];
     d53 = +HEAPF32[i2 + 4 + (i37 * 276 | 0) + 140 >> 2];
     __ZN35btSequentialImpulseConstraintSolver21addFrictionConstraintERK9btVector3P11btRigidBodyS4_iR15btManifoldPointS2_S2_P17btCollisionObjectS8_fff(i1, i51, 0, 0, i40, i19, i9, i10, i15, i17, d52, d54, d53) | 0;
    }
   } while (0);
   do {
    if ((i22 | 0) == 1392) {
     i22 = 0;
     i45 = i2 + 4 + (i37 * 276 | 0) + 148 | 0;
     d53 = +HEAPF32[i2 + 4 + (i37 * 276 | 0) + 64 >> 2];
     d54 = +HEAPF32[i12 >> 2];
     d52 = +HEAPF32[i2 + 4 + (i37 * 276 | 0) + 68 >> 2];
     d55 = +HEAPF32[i2 + 4 + (i37 * 276 | 0) + 72 >> 2];
     d56 = +HEAPF32[i30 >> 2] - d53 * d54;
     d57 = +HEAPF32[i31 >> 2] - d54 * d52;
     d58 = +HEAPF32[i32 >> 2] - d54 * d55;
     HEAPF32[i2 + 4 + (i37 * 276 | 0) + 148 >> 2] = d56;
     i51 = i2 + 4 + (i37 * 276 | 0) + 152 | 0;
     HEAPF32[i51 >> 2] = d57;
     i59 = i2 + 4 + (i37 * 276 | 0) + 156 | 0;
     HEAPF32[i59 >> 2] = d58;
     HEAPF32[i2 + 4 + (i37 * 276 | 0) + 160 >> 2] = 0.0;
     i60 = i45 | 0;
     d54 = d56 * d56 + d57 * d57 + d58 * d58;
     i61 = HEAP32[i29 >> 2] | 0;
     if ((i61 & 64 | 0) == 0 & d54 > 1.1920928955078125e-7) {
      d62 = 1.0 / +Math_sqrt(+d54);
      d54 = d56 * d62;
      HEAPF32[i60 >> 2] = d54;
      d56 = d57 * d62;
      HEAPF32[i51 >> 2] = d56;
      d57 = d58 * d62;
      HEAPF32[i59 >> 2] = d57;
      if ((i61 & 16 | 0) == 0) {
       d63 = +HEAPF32[i11 >> 2];
      } else {
       i64 = i2 + 4 + (i37 * 276 | 0) + 164 | 0;
       d62 = d55 * d56 - d52 * d57;
       d58 = d53 * d57 - d55 * d54;
       d57 = d52 * d54 - d53 * d56;
       HEAPF32[i2 + 4 + (i37 * 276 | 0) + 164 >> 2] = d62;
       HEAPF32[i2 + 4 + (i37 * 276 | 0) + 176 >> 2] = 0.0;
       d56 = 1.0 / +Math_sqrt(+(d57 * d57 + (d62 * d62 + d58 * d58)));
       HEAPF32[i64 >> 2] = d62 * d56;
       HEAPF32[i2 + 4 + (i37 * 276 | 0) + 168 >> 2] = d58 * d56;
       HEAPF32[i2 + 4 + (i37 * 276 | 0) + 172 >> 2] = d57 * d56;
       __Z24applyAnisotropicFrictionP17btCollisionObjectR9btVector3(i15, i64);
       __Z24applyAnisotropicFrictionP17btCollisionObjectR9btVector3(i17, i64);
       d56 = +HEAPF32[i11 >> 2];
       __ZN35btSequentialImpulseConstraintSolver21addFrictionConstraintERK9btVector3P11btRigidBodyS4_iR15btManifoldPointS2_S2_P17btCollisionObjectS8_fff(i1, i64, 0, 0, i40, i19, i9, i10, i15, i17, d56, 0.0, 0.0) | 0;
       d63 = d56;
      }
      __Z24applyAnisotropicFrictionP17btCollisionObjectR9btVector3(i15, i45);
      __Z24applyAnisotropicFrictionP17btCollisionObjectR9btVector3(i17, i45);
      __ZN35btSequentialImpulseConstraintSolver21addFrictionConstraintERK9btVector3P11btRigidBodyS4_iR15btManifoldPointS2_S2_P17btCollisionObjectS8_fff(i1, i45, 0, 0, i40, i19, i9, i10, i15, i17, d63, 0.0, 0.0) | 0;
      HEAP8[i2 + 4 + (i37 * 276 | 0) + 116 | 0] = 1;
      break;
     }
     i64 = i2 + 4 + (i37 * 276 | 0) + 164 | 0;
     if (+Math_abs(+d55) > .7071067690849304) {
      d56 = d52 * d52 + d55 * d55;
      d57 = 1.0 / +Math_sqrt(+d56);
      HEAPF32[i60 >> 2] = 0.0;
      d58 = d57 * (-0.0 - d55);
      HEAPF32[i51 >> 2] = d58;
      d62 = d52 * d57;
      HEAPF32[i59 >> 2] = d62;
      HEAPF32[i64 >> 2] = d56 * d57;
      HEAPF32[i2 + 4 + (i37 * 276 | 0) + 168 >> 2] = d62 * (-0.0 - d53);
      HEAPF32[i2 + 4 + (i37 * 276 | 0) + 172 >> 2] = d53 * d58;
     } else {
      d58 = d53 * d53 + d52 * d52;
      d62 = 1.0 / +Math_sqrt(+d58);
      d57 = d62 * (-0.0 - d52);
      HEAPF32[i60 >> 2] = d57;
      d52 = d53 * d62;
      HEAPF32[i51 >> 2] = d52;
      HEAPF32[i59 >> 2] = 0.0;
      HEAPF32[i64 >> 2] = d52 * (-0.0 - d55);
      HEAPF32[i2 + 4 + (i37 * 276 | 0) + 168 >> 2] = d55 * d57;
      HEAPF32[i2 + 4 + (i37 * 276 | 0) + 172 >> 2] = d58 * d62;
     }
     if ((i61 & 16 | 0) == 0) {
      d65 = +HEAPF32[i11 >> 2];
     } else {
      __Z24applyAnisotropicFrictionP17btCollisionObjectR9btVector3(i15, i64);
      __Z24applyAnisotropicFrictionP17btCollisionObjectR9btVector3(i17, i64);
      d62 = +HEAPF32[i11 >> 2];
      __ZN35btSequentialImpulseConstraintSolver21addFrictionConstraintERK9btVector3P11btRigidBodyS4_iR15btManifoldPointS2_S2_P17btCollisionObjectS8_fff(i1, i64, 0, 0, i40, i19, i9, i10, i15, i17, d62, 0.0, 0.0) | 0;
      d65 = d62;
     }
     __Z24applyAnisotropicFrictionP17btCollisionObjectR9btVector3(i15, i45);
     __Z24applyAnisotropicFrictionP17btCollisionObjectR9btVector3(i17, i45);
     __ZN35btSequentialImpulseConstraintSolver21addFrictionConstraintERK9btVector3P11btRigidBodyS4_iR15btManifoldPointS2_S2_P17btCollisionObjectS8_fff(i1, i45, 0, 0, i40, i19, i9, i10, i15, i17, d65, 0.0, 0.0) | 0;
     HEAP8[i2 + 4 + (i37 * 276 | 0) + 116 | 0] = 1;
    }
   } while (0);
   __ZN35btSequentialImpulseConstraintSolver28setFrictionConstraintImpulseER18btSolverConstraintP11btRigidBodyS3_R15btManifoldPointRK19btContactSolverInfo(i1, i47, i46, i48, i19, i3);
   i39 = HEAP32[i21 >> 2] | 0;
  }
  i40 = i37 + 1 | 0;
  if ((i40 | 0) < (i39 | 0)) {
   i37 = i40;
   i38 = i39;
  } else {
   break;
  }
 }
 STACKTOP = i4;
 return;
}
function __ZNK20btConvexHullInternal6Vertex3dotERKNS_7Point64E(i1, i2, i3) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 var i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0;
 if ((HEAP32[i2 + 100 >> 2] | 0) > -1) {
  i4 = HEAP32[i2 + 88 >> 2] | 0;
  i5 = i3 | 0;
  i6 = ___muldi3(i4, (i4 | 0) < 0 ? -1 : 0, HEAP32[i5 >> 2] | 0, HEAP32[i5 + 4 >> 2] | 0) | 0;
  i5 = tempRet0;
  i4 = HEAP32[i2 + 92 >> 2] | 0;
  i7 = i3 + 8 | 0;
  i8 = ___muldi3(i4, (i4 | 0) < 0 ? -1 : 0, HEAP32[i7 >> 2] | 0, HEAP32[i7 + 4 >> 2] | 0) | 0;
  i7 = _i64Add(i8, tempRet0, i6, i5) | 0;
  i5 = tempRet0;
  i6 = HEAP32[i2 + 96 >> 2] | 0;
  i8 = i3 + 16 | 0;
  i4 = ___muldi3(i6, (i6 | 0) < 0 ? -1 : 0, HEAP32[i8 >> 2] | 0, HEAP32[i8 + 4 >> 2] | 0) | 0;
  i8 = _i64Add(i7, i5, i4, tempRet0) | 0;
  i4 = tempRet0;
  i5 = 0;
  do {
   if ((i4 | 0) > (i5 | 0) | (i4 | 0) == (i5 | 0) & i8 >>> 0 > 0 >>> 0) {
    HEAP32[i1 + 32 >> 2] = 1;
    i7 = i1 | 0;
    HEAP32[i7 >> 2] = i8;
    HEAP32[i7 + 4 >> 2] = i4;
    i7 = i1 + 8 | 0;
    HEAP32[i7 >> 2] = i4 >> 31 | ((i4 | 0) < 0 ? -1 : 0) << 1;
    HEAP32[i7 + 4 >> 2] = ((i4 | 0) < 0 ? -1 : 0) >> 31 | ((i4 | 0) < 0 ? -1 : 0) << 1;
   } else {
    i7 = 0;
    i6 = i1 + 32 | 0;
    if ((i4 | 0) < (i7 | 0) | (i4 | 0) == (i7 | 0) & i8 >>> 0 < 0 >>> 0) {
     HEAP32[i6 >> 2] = -1;
     i7 = _i64Subtract(0, 0, i8, i4) | 0;
     i9 = tempRet0;
     i10 = i1 | 0;
     HEAP32[i10 >> 2] = i7;
     HEAP32[i10 + 4 >> 2] = i9;
     i10 = i1 + 8 | 0;
     HEAP32[i10 >> 2] = i9 >> 31 | ((i9 | 0) < 0 ? -1 : 0) << 1;
     HEAP32[i10 + 4 >> 2] = ((i9 | 0) < 0 ? -1 : 0) >> 31 | ((i9 | 0) < 0 ? -1 : 0) << 1;
     break;
    } else {
     HEAP32[i6 >> 2] = 0;
     _memset(i1 | 0, 0, 16);
     break;
    }
   }
  } while (0);
  i4 = i1 + 16 | 0;
  HEAP32[i4 >> 2] = 1;
  HEAP32[i4 + 4 >> 2] = 0;
  i4 = i1 + 24 | 0;
  HEAP32[i4 >> 2] = 0;
  HEAP32[i4 + 4 >> 2] = 0;
  HEAP8[i1 + 36 | 0] = 1;
  return;
 }
 i4 = i3 | 0;
 i8 = HEAP32[i4 >> 2] | 0;
 i5 = HEAP32[i4 + 4 >> 2] | 0;
 i4 = i2 + 32 | 0;
 i6 = HEAP32[i4 >> 2] | 0;
 i9 = HEAP32[i4 + 4 >> 2] | 0;
 i4 = 0;
 i10 = (i9 | 0) < (i4 | 0) | (i9 | 0) == (i4 | 0) & i6 >>> 0 < 0 >>> 0;
 i4 = i2 + 24 | 0;
 i7 = HEAP32[i4 >> 2] | 0;
 i11 = HEAP32[i4 + 4 >> 2] | 0;
 if (i10) {
  i4 = _i64Subtract(0, 0, i7, i11) | 0;
  i12 = tempRet0;
  i13 = _i64Add((i7 | 0) == 0 & (i11 | 0) == 0 & 1, 0, ~i6, ~i9) | 0;
  i14 = i12;
  i15 = i4;
  i16 = tempRet0;
  i17 = i13;
 } else {
  i14 = i11;
  i15 = i7;
  i16 = i9;
  i17 = i6;
 }
 i6 = 0;
 if ((i5 | 0) < (i6 | 0) | (i5 | 0) == (i6 | 0) & i8 >>> 0 < 0 >>> 0) {
  i6 = _i64Subtract(0, 0, i8, i5) | 0;
  i18 = i10 ^ 1;
  i19 = tempRet0;
  i20 = i6;
 } else {
  i18 = i10;
  i19 = i5;
  i20 = i8;
 }
 i8 = i15 | 0;
 i15 = i14 & 0;
 i5 = i20 | 0;
 i10 = i19 & 0;
 i6 = ___muldi3(i5, i10, i8, i15) | 0;
 i9 = tempRet0;
 i7 = i19;
 i11 = 0;
 i13 = ___muldi3(i7, i11, i8, i15) | 0;
 i15 = tempRet0;
 i8 = i14;
 i14 = 0;
 i4 = ___muldi3(i5, i10, i8, i14) | 0;
 i10 = tempRet0;
 i5 = ___muldi3(i7, i11, i8, i14) | 0;
 i14 = tempRet0;
 i8 = _i64Add(i13 | 0, i15 & 0, i4 | 0, i10 & 0) | 0;
 i4 = tempRet0;
 i13 = _llvm_uadd_with_overflow_i64(i6 | 0, i9 | 0, 0, i8 | 0) | 0;
 i8 = i13;
 i13 = tempRet0;
 i9 = tempRet1 & 1;
 i6 = ___muldi3(i20, i19, i17, i16) | 0;
 i16 = _i64Add(i5, i14, i6, tempRet0) | 0;
 i6 = _i64Add(i16, tempRet0, i15, 0) | 0;
 i15 = _i64Add(i6, tempRet0, i10, 0) | 0;
 i10 = _i64Add(i15, tempRet0, i9, 0) | 0;
 i9 = _i64Add(i10, tempRet0, i4, 0) | 0;
 i4 = tempRet0;
 if (i18) {
  i18 = _i64Subtract(0, 0, i8, i13) | 0;
  i10 = tempRet0;
  i15 = _i64Add((i8 | 0) == 0 & (i13 | 0) == 0 & 1, 0, ~i9, ~i4) | 0;
  i21 = i10;
  i22 = i18;
  i23 = tempRet0;
  i24 = i15;
 } else {
  i21 = i13;
  i22 = i8;
  i23 = i4;
  i24 = i9;
 }
 i9 = i3 + 8 | 0;
 i4 = HEAP32[i9 >> 2] | 0;
 i8 = HEAP32[i9 + 4 >> 2] | 0;
 i9 = i2 + 48 | 0;
 i13 = HEAP32[i9 >> 2] | 0;
 i15 = HEAP32[i9 + 4 >> 2] | 0;
 i9 = 0;
 i18 = (i15 | 0) < (i9 | 0) | (i15 | 0) == (i9 | 0) & i13 >>> 0 < 0 >>> 0;
 i9 = i2 + 40 | 0;
 i10 = HEAP32[i9 >> 2] | 0;
 i6 = HEAP32[i9 + 4 >> 2] | 0;
 if (i18) {
  i9 = _i64Subtract(0, 0, i10, i6) | 0;
  i16 = tempRet0;
  i14 = _i64Add((i10 | 0) == 0 & (i6 | 0) == 0 & 1, 0, ~i13, ~i15) | 0;
  i25 = i16;
  i26 = i9;
  i27 = tempRet0;
  i28 = i14;
 } else {
  i25 = i6;
  i26 = i10;
  i27 = i15;
  i28 = i13;
 }
 i13 = 0;
 if ((i8 | 0) < (i13 | 0) | (i8 | 0) == (i13 | 0) & i4 >>> 0 < 0 >>> 0) {
  i13 = _i64Subtract(0, 0, i4, i8) | 0;
  i29 = i18 ^ 1;
  i30 = tempRet0;
  i31 = i13;
 } else {
  i29 = i18;
  i30 = i8;
  i31 = i4;
 }
 i4 = i26 | 0;
 i26 = i25 & 0;
 i8 = i31 | 0;
 i18 = i30 & 0;
 i13 = ___muldi3(i8, i18, i4, i26) | 0;
 i15 = tempRet0;
 i10 = i30;
 i6 = 0;
 i14 = ___muldi3(i10, i6, i4, i26) | 0;
 i26 = tempRet0;
 i4 = i25;
 i25 = 0;
 i9 = ___muldi3(i8, i18, i4, i25) | 0;
 i18 = tempRet0;
 i8 = ___muldi3(i10, i6, i4, i25) | 0;
 i25 = tempRet0;
 i4 = _i64Add(i14 | 0, i26 & 0, i9 | 0, i18 & 0) | 0;
 i9 = tempRet0;
 i14 = _llvm_uadd_with_overflow_i64(i13 | 0, i15 | 0, 0, i4 | 0) | 0;
 i4 = i14;
 i14 = tempRet0;
 i15 = tempRet1 & 1;
 i13 = ___muldi3(i31, i30, i28, i27) | 0;
 i27 = _i64Add(i8, i25, i13, tempRet0) | 0;
 i13 = _i64Add(i27, tempRet0, i26, 0) | 0;
 i26 = _i64Add(i13, tempRet0, i18, 0) | 0;
 i18 = _i64Add(i26, tempRet0, i15, 0) | 0;
 i15 = _i64Add(i18, tempRet0, i9, 0) | 0;
 i9 = tempRet0;
 if (i29) {
  i29 = _i64Subtract(0, 0, i4, i14) | 0;
  i18 = tempRet0;
  i26 = _i64Add((i4 | 0) == 0 & (i14 | 0) == 0 & 1, 0, ~i15, ~i9) | 0;
  i32 = i18;
  i33 = i29;
  i34 = tempRet0;
  i35 = i26;
 } else {
  i32 = i14;
  i33 = i4;
  i34 = i9;
  i35 = i15;
 }
 i15 = _llvm_uadd_with_overflow_i64(i22 | 0, i21 | 0, i33 | 0, i32 | 0) | 0;
 i32 = tempRet1;
 i33 = tempRet0;
 i21 = _i64Add(i35, i34, i24, i23) | 0;
 i23 = _i64Add(i21, tempRet0, i32 & 1, 0) | 0;
 i32 = tempRet0;
 i21 = i3 + 16 | 0;
 i3 = HEAP32[i21 >> 2] | 0;
 i24 = HEAP32[i21 + 4 >> 2] | 0;
 i21 = i2 + 64 | 0;
 i34 = HEAP32[i21 >> 2] | 0;
 i35 = HEAP32[i21 + 4 >> 2] | 0;
 i21 = 0;
 i22 = (i35 | 0) < (i21 | 0) | (i35 | 0) == (i21 | 0) & i34 >>> 0 < 0 >>> 0;
 i21 = i2 + 56 | 0;
 i9 = HEAP32[i21 >> 2] | 0;
 i4 = HEAP32[i21 + 4 >> 2] | 0;
 if (i22) {
  i21 = _i64Subtract(0, 0, i9, i4) | 0;
  i14 = tempRet0;
  i26 = _i64Add((i9 | 0) == 0 & (i4 | 0) == 0 & 1, 0, ~i34, ~i35) | 0;
  i36 = i14;
  i37 = i21;
  i38 = tempRet0;
  i39 = i26;
 } else {
  i36 = i4;
  i37 = i9;
  i38 = i35;
  i39 = i34;
 }
 i34 = 0;
 if ((i24 | 0) < (i34 | 0) | (i24 | 0) == (i34 | 0) & i3 >>> 0 < 0 >>> 0) {
  i34 = _i64Subtract(0, 0, i3, i24) | 0;
  i40 = i22 ^ 1;
  i41 = tempRet0;
  i42 = i34;
 } else {
  i40 = i22;
  i41 = i24;
  i42 = i3;
 }
 i3 = i37 | 0;
 i37 = i36 & 0;
 i24 = i42 | 0;
 i22 = i41 & 0;
 i34 = ___muldi3(i24, i22, i3, i37) | 0;
 i35 = tempRet0;
 i9 = i41;
 i4 = 0;
 i26 = ___muldi3(i9, i4, i3, i37) | 0;
 i37 = tempRet0;
 i3 = i36;
 i36 = 0;
 i21 = ___muldi3(i24, i22, i3, i36) | 0;
 i22 = tempRet0;
 i24 = ___muldi3(i9, i4, i3, i36) | 0;
 i36 = tempRet0;
 i3 = _i64Add(i26 | 0, i37 & 0, i21 | 0, i22 & 0) | 0;
 i21 = tempRet0;
 i26 = _llvm_uadd_with_overflow_i64(i34 | 0, i35 | 0, 0, i3 | 0) | 0;
 i3 = i26;
 i26 = tempRet0;
 i35 = tempRet1 & 1;
 i34 = ___muldi3(i42, i41, i39, i38) | 0;
 i38 = _i64Add(i24, i36, i34, tempRet0) | 0;
 i34 = _i64Add(i38, tempRet0, i37, 0) | 0;
 i37 = _i64Add(i34, tempRet0, i22, 0) | 0;
 i22 = _i64Add(i37, tempRet0, i35, 0) | 0;
 i35 = _i64Add(i22, tempRet0, i21, 0) | 0;
 i21 = tempRet0;
 if (i40) {
  i40 = _i64Subtract(0, 0, i3, i26) | 0;
  i22 = tempRet0;
  i37 = _i64Add((i3 | 0) == 0 & (i26 | 0) == 0 & 1, 0, ~i35, ~i21) | 0;
  i43 = i22;
  i44 = i40;
  i45 = tempRet0;
  i46 = i37;
 } else {
  i43 = i26;
  i44 = i3;
  i45 = i21;
  i46 = i35;
 }
 i35 = _llvm_uadd_with_overflow_i64(i15 | 0, i33 | 0, i44 | 0, i43 | 0) | 0;
 i43 = tempRet1;
 i44 = i35;
 i35 = tempRet0;
 i33 = _i64Add(i23, i32, i46, i45) | 0;
 i45 = _i64Add(i33, tempRet0, i43 & 1, 0) | 0;
 i43 = tempRet0;
 i33 = i2 + 72 | 0;
 i46 = i1 + 16 | 0;
 i32 = 0;
 if ((i43 | 0) < (i32 | 0) | (i43 | 0) == (i32 | 0) & i45 >>> 0 < 0 >>> 0) {
  i32 = i1 + 32 | 0;
  HEAP32[i32 >> 2] = -1;
  i23 = _i64Subtract(0, 0, i44, i35) | 0;
  i15 = tempRet0;
  i21 = _i64Add((i44 | 0) == 0 & (i35 | 0) == 0 & 1, 0, ~i45, ~i43) | 0;
  i3 = i1 | 0;
  HEAP32[i3 >> 2] = i23;
  HEAP32[i3 + 4 >> 2] = i15;
  i15 = i1 + 8 | 0;
  HEAP32[i15 >> 2] = i21;
  HEAP32[i15 + 4 >> 2] = tempRet0;
  i47 = i32;
  i48 = -1;
 } else {
  if ((i45 | 0) == 0 & (i43 | 0) == 0) {
   i49 = ((i44 | 0) != 0 | (i35 | 0) != 0) & 1;
  } else {
   i49 = 1;
  }
  i32 = i1 + 32 | 0;
  HEAP32[i32 >> 2] = i49;
  i15 = i1 | 0;
  HEAP32[i15 >> 2] = i44;
  HEAP32[i15 + 4 >> 2] = i35;
  i35 = i1 + 8 | 0;
  HEAP32[i35 >> 2] = i45;
  HEAP32[i35 + 4 >> 2] = i43;
  i47 = i32;
  i48 = i49;
 }
 i49 = i2 + 80 | 0;
 i2 = HEAP32[i49 >> 2] | 0;
 i32 = HEAP32[i49 + 4 >> 2] | 0;
 i49 = 0;
 if ((i32 | 0) < (i49 | 0) | (i32 | 0) == (i49 | 0) & i2 >>> 0 < 0 >>> 0) {
  HEAP32[i47 >> 2] = -i48;
  i48 = i33 | 0;
  i47 = HEAP32[i48 >> 2] | 0;
  i49 = HEAP32[i48 + 4 >> 2] | 0;
  i48 = _i64Subtract(0, 0, i47, i49) | 0;
  i43 = tempRet0;
  i35 = _i64Add((i47 | 0) == 0 & (i49 | 0) == 0 & 1, 0, ~i2, ~i32) | 0;
  i32 = i1 + 16 | 0;
  HEAP32[i32 >> 2] = i48;
  HEAP32[i32 + 4 >> 2] = i43;
  i43 = i1 + 24 | 0;
  HEAP32[i43 >> 2] = i35;
  HEAP32[i43 + 4 >> 2] = tempRet0;
 } else {
  i43 = i46;
  i46 = i33;
  HEAP32[i43 >> 2] = HEAP32[i46 >> 2];
  HEAP32[i43 + 4 >> 2] = HEAP32[i46 + 4 >> 2];
  HEAP32[i43 + 8 >> 2] = HEAP32[i46 + 8 >> 2];
  HEAP32[i43 + 12 >> 2] = HEAP32[i46 + 12 >> 2];
 }
 HEAP8[i1 + 36 | 0] = 0;
 return;
}
function __ZN12gjkepa2_impl3GJK13EncloseOriginEv(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, d16 = 0.0, d17 = 0.0, d18 = 0.0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, d31 = 0.0, d32 = 0.0, d33 = 0.0, d34 = 0.0, d35 = 0.0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, d41 = 0.0, d42 = 0.0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 112 | 0;
 i3 = i2 | 0;
 i4 = i2 + 16 | 0;
 i5 = i2 + 32 | 0;
 i6 = i2 + 48 | 0;
 i7 = i2 + 64 | 0;
 i8 = i2 + 80 | 0;
 i9 = i2 + 96 | 0;
 i10 = i1 + 372 | 0;
 i11 = HEAP32[i10 >> 2] | 0;
 i12 = i11 + 32 | 0;
 i13 = HEAP32[i12 >> 2] | 0;
 L165 : do {
  if ((i13 | 0) == 2) {
   i14 = HEAP32[i11 + 4 >> 2] | 0;
   i15 = HEAP32[i11 >> 2] | 0;
   d16 = +HEAPF32[i14 + 16 >> 2] - +HEAPF32[i15 + 16 >> 2];
   d17 = +HEAPF32[i14 + 20 >> 2] - +HEAPF32[i15 + 20 >> 2];
   d18 = +HEAPF32[i14 + 24 >> 2] - +HEAPF32[i15 + 24 >> 2];
   i15 = i5 | 0;
   i14 = i5 + 4 | 0;
   i19 = i5 + 8 | 0;
   i20 = i6 | 0;
   i21 = i6 + 4 | 0;
   i22 = i6 + 8 | 0;
   i23 = i6 + 12 | 0;
   i24 = i1 + 364 | 0;
   i25 = i7 | 0;
   i26 = i7 + 4 | 0;
   i27 = i7 + 8 | 0;
   i28 = i7 + 12 | 0;
   i29 = i5;
   i30 = 0;
   while (1) {
    _memset(i29 | 0, 0, 16);
    HEAPF32[i5 + (i30 << 2) >> 2] = 1.0;
    d31 = +HEAPF32[i19 >> 2];
    d32 = +HEAPF32[i14 >> 2];
    d33 = d17 * d31 - d18 * d32;
    d34 = +HEAPF32[i15 >> 2];
    d35 = d18 * d34 - d16 * d31;
    d31 = d16 * d32 - d17 * d34;
    HEAPF32[i20 >> 2] = d33;
    HEAPF32[i21 >> 2] = d35;
    HEAPF32[i22 >> 2] = d31;
    HEAPF32[i23 >> 2] = 0.0;
    if (d31 * d31 + (d33 * d33 + d35 * d35) > 0.0) {
     i36 = HEAP32[i10 >> 2] | 0;
     i37 = i36 + 32 | 0;
     HEAPF32[i36 + 16 + (HEAP32[i37 >> 2] << 2) >> 2] = 0.0;
     i38 = (HEAP32[i24 >> 2] | 0) - 1 | 0;
     HEAP32[i24 >> 2] = i38;
     HEAP32[i36 + (HEAP32[i37 >> 2] << 2) >> 2] = HEAP32[i1 + 348 + (i38 << 2) >> 2];
     i38 = HEAP32[i37 >> 2] | 0;
     HEAP32[i37 >> 2] = i38 + 1;
     __ZNK12gjkepa2_impl3GJK10getsupportERK9btVector3RNS0_3sSVE(i1, i6, HEAP32[i36 + (i38 << 2) >> 2] | 0);
     if (__ZN12gjkepa2_impl3GJK13EncloseOriginEv(i1) | 0) {
      i39 = 1;
      i40 = 143;
      break;
     }
     i38 = HEAP32[i10 >> 2] | 0;
     i36 = i38 + 32 | 0;
     i37 = (HEAP32[i36 >> 2] | 0) - 1 | 0;
     HEAP32[i36 >> 2] = i37;
     i36 = HEAP32[i38 + (i37 << 2) >> 2] | 0;
     i37 = HEAP32[i24 >> 2] | 0;
     HEAP32[i24 >> 2] = i37 + 1;
     HEAP32[i1 + 348 + (i37 << 2) >> 2] = i36;
     i36 = HEAP32[i10 >> 2] | 0;
     d35 = -0.0 - +HEAPF32[i21 >> 2];
     d33 = -0.0 - +HEAPF32[i22 >> 2];
     HEAPF32[i25 >> 2] = -0.0 - +HEAPF32[i20 >> 2];
     HEAPF32[i26 >> 2] = d35;
     HEAPF32[i27 >> 2] = d33;
     HEAPF32[i28 >> 2] = 0.0;
     i37 = i36 + 32 | 0;
     HEAPF32[i36 + 16 + (HEAP32[i37 >> 2] << 2) >> 2] = 0.0;
     i38 = (HEAP32[i24 >> 2] | 0) - 1 | 0;
     HEAP32[i24 >> 2] = i38;
     HEAP32[i36 + (HEAP32[i37 >> 2] << 2) >> 2] = HEAP32[i1 + 348 + (i38 << 2) >> 2];
     i38 = HEAP32[i37 >> 2] | 0;
     HEAP32[i37 >> 2] = i38 + 1;
     __ZNK12gjkepa2_impl3GJK10getsupportERK9btVector3RNS0_3sSVE(i1, i7, HEAP32[i36 + (i38 << 2) >> 2] | 0);
     if (__ZN12gjkepa2_impl3GJK13EncloseOriginEv(i1) | 0) {
      i39 = 1;
      i40 = 144;
      break;
     }
     i38 = HEAP32[i10 >> 2] | 0;
     i36 = i38 + 32 | 0;
     i37 = (HEAP32[i36 >> 2] | 0) - 1 | 0;
     HEAP32[i36 >> 2] = i37;
     i36 = HEAP32[i38 + (i37 << 2) >> 2] | 0;
     i37 = HEAP32[i24 >> 2] | 0;
     HEAP32[i24 >> 2] = i37 + 1;
     HEAP32[i1 + 348 + (i37 << 2) >> 2] = i36;
    }
    i30 = i30 + 1 | 0;
    if (i30 >>> 0 >= 3) {
     break L165;
    }
   }
   if ((i40 | 0) == 143) {
    STACKTOP = i2;
    return i39 | 0;
   } else if ((i40 | 0) == 144) {
    STACKTOP = i2;
    return i39 | 0;
   }
  } else if ((i13 | 0) == 3) {
   i30 = HEAP32[i11 + 4 >> 2] | 0;
   i24 = HEAP32[i11 >> 2] | 0;
   d17 = +HEAPF32[i24 + 16 >> 2];
   d16 = +HEAPF32[i30 + 16 >> 2] - d17;
   d18 = +HEAPF32[i24 + 20 >> 2];
   d33 = +HEAPF32[i30 + 20 >> 2] - d18;
   d35 = +HEAPF32[i24 + 24 >> 2];
   d31 = +HEAPF32[i30 + 24 >> 2] - d35;
   i30 = HEAP32[i11 + 8 >> 2] | 0;
   d34 = +HEAPF32[i30 + 16 >> 2] - d17;
   d17 = +HEAPF32[i30 + 20 >> 2] - d18;
   d18 = +HEAPF32[i30 + 24 >> 2] - d35;
   d35 = d33 * d18 - d31 * d17;
   d32 = d31 * d34 - d16 * d18;
   d18 = d16 * d17 - d33 * d34;
   i30 = i8 | 0;
   HEAPF32[i30 >> 2] = d35;
   i24 = i8 + 4 | 0;
   HEAPF32[i24 >> 2] = d32;
   i28 = i8 + 8 | 0;
   HEAPF32[i28 >> 2] = d18;
   HEAPF32[i8 + 12 >> 2] = 0.0;
   if (d18 * d18 + (d35 * d35 + d32 * d32) <= 0.0) {
    break;
   }
   HEAPF32[i11 + 28 >> 2] = 0.0;
   i27 = i1 + 364 | 0;
   i26 = (HEAP32[i27 >> 2] | 0) - 1 | 0;
   HEAP32[i27 >> 2] = i26;
   HEAP32[i11 + (HEAP32[i12 >> 2] << 2) >> 2] = HEAP32[i1 + 348 + (i26 << 2) >> 2];
   i26 = HEAP32[i12 >> 2] | 0;
   HEAP32[i12 >> 2] = i26 + 1;
   __ZNK12gjkepa2_impl3GJK10getsupportERK9btVector3RNS0_3sSVE(i1, i8, HEAP32[i11 + (i26 << 2) >> 2] | 0);
   if (__ZN12gjkepa2_impl3GJK13EncloseOriginEv(i1) | 0) {
    i39 = 1;
    STACKTOP = i2;
    return i39 | 0;
   }
   i26 = HEAP32[i10 >> 2] | 0;
   i20 = i26 + 32 | 0;
   i25 = (HEAP32[i20 >> 2] | 0) - 1 | 0;
   HEAP32[i20 >> 2] = i25;
   i20 = HEAP32[i26 + (i25 << 2) >> 2] | 0;
   i25 = HEAP32[i27 >> 2] | 0;
   HEAP32[i27 >> 2] = i25 + 1;
   HEAP32[i1 + 348 + (i25 << 2) >> 2] = i20;
   i20 = HEAP32[i10 >> 2] | 0;
   d32 = -0.0 - +HEAPF32[i24 >> 2];
   d35 = -0.0 - +HEAPF32[i28 >> 2];
   HEAPF32[i9 >> 2] = -0.0 - +HEAPF32[i30 >> 2];
   HEAPF32[i9 + 4 >> 2] = d32;
   HEAPF32[i9 + 8 >> 2] = d35;
   HEAPF32[i9 + 12 >> 2] = 0.0;
   i30 = i20 + 32 | 0;
   HEAPF32[i20 + 16 + (HEAP32[i30 >> 2] << 2) >> 2] = 0.0;
   i28 = (HEAP32[i27 >> 2] | 0) - 1 | 0;
   HEAP32[i27 >> 2] = i28;
   HEAP32[i20 + (HEAP32[i30 >> 2] << 2) >> 2] = HEAP32[i1 + 348 + (i28 << 2) >> 2];
   i28 = HEAP32[i30 >> 2] | 0;
   HEAP32[i30 >> 2] = i28 + 1;
   __ZNK12gjkepa2_impl3GJK10getsupportERK9btVector3RNS0_3sSVE(i1, i9, HEAP32[i20 + (i28 << 2) >> 2] | 0);
   if (__ZN12gjkepa2_impl3GJK13EncloseOriginEv(i1) | 0) {
    i39 = 1;
    STACKTOP = i2;
    return i39 | 0;
   } else {
    i28 = HEAP32[i10 >> 2] | 0;
    i20 = i28 + 32 | 0;
    i30 = (HEAP32[i20 >> 2] | 0) - 1 | 0;
    HEAP32[i20 >> 2] = i30;
    i20 = HEAP32[i28 + (i30 << 2) >> 2] | 0;
    i30 = HEAP32[i27 >> 2] | 0;
    HEAP32[i27 >> 2] = i30 + 1;
    HEAP32[i1 + 348 + (i30 << 2) >> 2] = i20;
    break;
   }
  } else if ((i13 | 0) == 4) {
   i20 = HEAP32[i11 >> 2] | 0;
   i30 = HEAP32[i11 + 12 >> 2] | 0;
   d35 = +HEAPF32[i30 + 16 >> 2];
   d32 = +HEAPF32[i20 + 16 >> 2] - d35;
   d18 = +HEAPF32[i30 + 20 >> 2];
   d34 = +HEAPF32[i20 + 20 >> 2] - d18;
   d33 = +HEAPF32[i30 + 24 >> 2];
   d17 = +HEAPF32[i20 + 24 >> 2] - d33;
   i20 = HEAP32[i11 + 4 >> 2] | 0;
   d16 = +HEAPF32[i20 + 16 >> 2] - d35;
   d31 = +HEAPF32[i20 + 20 >> 2] - d18;
   d41 = +HEAPF32[i20 + 24 >> 2] - d33;
   i20 = HEAP32[i11 + 8 >> 2] | 0;
   d42 = +HEAPF32[i20 + 16 >> 2] - d35;
   d35 = +HEAPF32[i20 + 20 >> 2] - d18;
   d18 = +HEAPF32[i20 + 24 >> 2] - d33;
   if (d32 * d31 * d18 + (d34 * d41 * d42 + d17 * d16 * d35 - d32 * d41 * d35 - d34 * d16 * d18) - d17 * d31 * d42 == 0.0) {
    break;
   } else {
    i39 = 1;
   }
   STACKTOP = i2;
   return i39 | 0;
  } else if ((i13 | 0) == 1) {
   i20 = i3 | 0;
   i30 = i3 + 4 | 0;
   i27 = i3 + 8 | 0;
   i28 = i1 + 364 | 0;
   i24 = i4 | 0;
   i25 = i4 + 4 | 0;
   i26 = i4 + 8 | 0;
   i22 = i4 + 12 | 0;
   i21 = i3;
   i23 = 0;
   i15 = i11;
   i14 = 1;
   while (1) {
    _memset(i21 | 0, 0, 16);
    HEAPF32[i3 + (i23 << 2) >> 2] = 1.0;
    i19 = i15 + 32 | 0;
    HEAPF32[i15 + 16 + (i14 << 2) >> 2] = 0.0;
    i29 = (HEAP32[i28 >> 2] | 0) - 1 | 0;
    HEAP32[i28 >> 2] = i29;
    HEAP32[i15 + (HEAP32[i19 >> 2] << 2) >> 2] = HEAP32[i1 + 348 + (i29 << 2) >> 2];
    i29 = HEAP32[i19 >> 2] | 0;
    HEAP32[i19 >> 2] = i29 + 1;
    __ZNK12gjkepa2_impl3GJK10getsupportERK9btVector3RNS0_3sSVE(i1, i3, HEAP32[i15 + (i29 << 2) >> 2] | 0);
    if (__ZN12gjkepa2_impl3GJK13EncloseOriginEv(i1) | 0) {
     i39 = 1;
     i40 = 149;
     break;
    }
    i29 = HEAP32[i10 >> 2] | 0;
    i19 = i29 + 32 | 0;
    i36 = (HEAP32[i19 >> 2] | 0) - 1 | 0;
    HEAP32[i19 >> 2] = i36;
    i19 = HEAP32[i29 + (i36 << 2) >> 2] | 0;
    i36 = HEAP32[i28 >> 2] | 0;
    HEAP32[i28 >> 2] = i36 + 1;
    HEAP32[i1 + 348 + (i36 << 2) >> 2] = i19;
    i19 = HEAP32[i10 >> 2] | 0;
    d42 = -0.0 - +HEAPF32[i30 >> 2];
    d31 = -0.0 - +HEAPF32[i27 >> 2];
    HEAPF32[i24 >> 2] = -0.0 - +HEAPF32[i20 >> 2];
    HEAPF32[i25 >> 2] = d42;
    HEAPF32[i26 >> 2] = d31;
    HEAPF32[i22 >> 2] = 0.0;
    i36 = i19 + 32 | 0;
    HEAPF32[i19 + 16 + (HEAP32[i36 >> 2] << 2) >> 2] = 0.0;
    i29 = (HEAP32[i28 >> 2] | 0) - 1 | 0;
    HEAP32[i28 >> 2] = i29;
    HEAP32[i19 + (HEAP32[i36 >> 2] << 2) >> 2] = HEAP32[i1 + 348 + (i29 << 2) >> 2];
    i29 = HEAP32[i36 >> 2] | 0;
    HEAP32[i36 >> 2] = i29 + 1;
    __ZNK12gjkepa2_impl3GJK10getsupportERK9btVector3RNS0_3sSVE(i1, i4, HEAP32[i19 + (i29 << 2) >> 2] | 0);
    if (__ZN12gjkepa2_impl3GJK13EncloseOriginEv(i1) | 0) {
     i39 = 1;
     i40 = 150;
     break;
    }
    i29 = HEAP32[i10 >> 2] | 0;
    i19 = i29 + 32 | 0;
    i36 = (HEAP32[i19 >> 2] | 0) - 1 | 0;
    HEAP32[i19 >> 2] = i36;
    i19 = HEAP32[i29 + (i36 << 2) >> 2] | 0;
    i36 = HEAP32[i28 >> 2] | 0;
    HEAP32[i28 >> 2] = i36 + 1;
    HEAP32[i1 + 348 + (i36 << 2) >> 2] = i19;
    i19 = i23 + 1 | 0;
    if (i19 >>> 0 >= 3) {
     break L165;
    }
    i36 = HEAP32[i10 >> 2] | 0;
    i23 = i19;
    i15 = i36;
    i14 = HEAP32[i36 + 32 >> 2] | 0;
   }
   if ((i40 | 0) == 149) {
    STACKTOP = i2;
    return i39 | 0;
   } else if ((i40 | 0) == 150) {
    STACKTOP = i2;
    return i39 | 0;
   }
  }
 } while (0);
 i39 = 0;
 STACKTOP = i2;
 return i39 | 0;
}
function __ZN22btCompoundLeafCallback17ProcessChildShapeEP16btCollisionShapei(i1, i2, i3) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 var i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, d15 = 0.0, d16 = 0.0, d17 = 0.0, d18 = 0.0, d19 = 0.0, d20 = 0.0, d21 = 0.0, d22 = 0.0, d23 = 0.0, d24 = 0.0, d25 = 0.0, d26 = 0.0, d27 = 0.0, d28 = 0.0, d29 = 0.0, d30 = 0.0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, d35 = 0.0, d36 = 0.0, d37 = 0.0, d38 = 0.0, d39 = 0.0, d40 = 0.0, d41 = 0.0, d42 = 0.0, d43 = 0.0, d44 = 0.0, d45 = 0.0, d46 = 0.0, i47 = 0, i48 = 0, i49 = 0, i50 = 0;
 i4 = STACKTOP;
 STACKTOP = STACKTOP + 224 | 0;
 i5 = i4 + 64 | 0;
 i6 = i4 + 128 | 0;
 i7 = i4 + 144 | 0;
 i8 = i4 + 160 | 0;
 i9 = i4 + 176 | 0;
 i10 = i4 + 192 | 0;
 i11 = i4 + 208 | 0;
 i12 = i1 + 4 | 0;
 i13 = HEAP32[i12 >> 2] | 0;
 i14 = HEAP32[i13 + 192 >> 2] | 0;
 d15 = +HEAPF32[i13 + 4 >> 2];
 d16 = +HEAPF32[i13 + 8 >> 2];
 d17 = +HEAPF32[i13 + 12 >> 2];
 d18 = +HEAPF32[i13 + 16 >> 2];
 d19 = +HEAPF32[i13 + 20 >> 2];
 d20 = +HEAPF32[i13 + 24 >> 2];
 d21 = +HEAPF32[i13 + 28 >> 2];
 d22 = +HEAPF32[i13 + 32 >> 2];
 d23 = +HEAPF32[i13 + 36 >> 2];
 d24 = +HEAPF32[i13 + 40 >> 2];
 d25 = +HEAPF32[i13 + 44 >> 2];
 d26 = +HEAPF32[i13 + 48 >> 2];
 d27 = +HEAPF32[i13 + 52 >> 2];
 d28 = +HEAPF32[i13 + 56 >> 2];
 d29 = +HEAPF32[i13 + 60 >> 2];
 d30 = +HEAPF32[i13 + 64 >> 2];
 i31 = i13 + 68 | 0;
 i32 = i4 | 0;
 HEAP32[i32 >> 2] = HEAP32[i31 >> 2];
 HEAP32[i32 + 4 >> 2] = HEAP32[i31 + 4 >> 2];
 HEAP32[i32 + 8 >> 2] = HEAP32[i31 + 8 >> 2];
 HEAP32[i32 + 12 >> 2] = HEAP32[i31 + 12 >> 2];
 i31 = i13 + 84 | 0;
 i33 = i4 + 16 | 0;
 HEAP32[i33 >> 2] = HEAP32[i31 >> 2];
 HEAP32[i33 + 4 >> 2] = HEAP32[i31 + 4 >> 2];
 HEAP32[i33 + 8 >> 2] = HEAP32[i31 + 8 >> 2];
 HEAP32[i33 + 12 >> 2] = HEAP32[i31 + 12 >> 2];
 i31 = i13 + 100 | 0;
 i34 = i4 + 32 | 0;
 HEAP32[i34 >> 2] = HEAP32[i31 >> 2];
 HEAP32[i34 + 4 >> 2] = HEAP32[i31 + 4 >> 2];
 HEAP32[i34 + 8 >> 2] = HEAP32[i31 + 8 >> 2];
 HEAP32[i34 + 12 >> 2] = HEAP32[i31 + 12 >> 2];
 i31 = i13 + 116 | 0;
 i13 = i4 + 48 | 0;
 HEAP32[i13 >> 2] = HEAP32[i31 >> 2];
 HEAP32[i13 + 4 >> 2] = HEAP32[i31 + 4 >> 2];
 HEAP32[i13 + 8 >> 2] = HEAP32[i31 + 8 >> 2];
 HEAP32[i13 + 12 >> 2] = HEAP32[i31 + 12 >> 2];
 i31 = HEAP32[i14 + 24 >> 2] | 0;
 d35 = +HEAPF32[i31 + (i3 * 80 | 0) >> 2];
 d36 = +HEAPF32[i31 + (i3 * 80 | 0) + 16 >> 2];
 d37 = +HEAPF32[i31 + (i3 * 80 | 0) + 32 >> 2];
 d38 = +HEAPF32[i31 + (i3 * 80 | 0) + 4 >> 2];
 d39 = +HEAPF32[i31 + (i3 * 80 | 0) + 20 >> 2];
 d40 = +HEAPF32[i31 + (i3 * 80 | 0) + 36 >> 2];
 d41 = +HEAPF32[i31 + (i3 * 80 | 0) + 8 >> 2];
 d42 = +HEAPF32[i31 + (i3 * 80 | 0) + 24 >> 2];
 d43 = +HEAPF32[i31 + (i3 * 80 | 0) + 40 >> 2];
 d44 = +HEAPF32[i31 + (i3 * 80 | 0) + 48 >> 2];
 d45 = +HEAPF32[i31 + (i3 * 80 | 0) + 52 >> 2];
 d46 = +HEAPF32[i31 + (i3 * 80 | 0) + 56 >> 2];
 HEAPF32[i5 >> 2] = d15 * d35 + d16 * d36 + d17 * d37;
 HEAPF32[i5 + 4 >> 2] = d15 * d38 + d16 * d39 + d17 * d40;
 HEAPF32[i5 + 8 >> 2] = d15 * d41 + d16 * d42 + d17 * d43;
 HEAPF32[i5 + 12 >> 2] = 0.0;
 HEAPF32[i5 + 16 >> 2] = d19 * d35 + d20 * d36 + d21 * d37;
 HEAPF32[i5 + 20 >> 2] = d19 * d38 + d20 * d39 + d21 * d40;
 HEAPF32[i5 + 24 >> 2] = d19 * d41 + d20 * d42 + d21 * d43;
 HEAPF32[i5 + 28 >> 2] = 0.0;
 HEAPF32[i5 + 32 >> 2] = d23 * d35 + d24 * d36 + d25 * d37;
 HEAPF32[i5 + 36 >> 2] = d23 * d38 + d24 * d39 + d25 * d40;
 HEAPF32[i5 + 40 >> 2] = d23 * d41 + d24 * d42 + d25 * d43;
 HEAPF32[i5 + 44 >> 2] = 0.0;
 HEAPF32[i5 + 48 >> 2] = d27 + (d15 * d44 + d16 * d45 + d17 * d46);
 HEAPF32[i5 + 52 >> 2] = d28 + (d19 * d44 + d20 * d45 + d21 * d46);
 HEAPF32[i5 + 56 >> 2] = d29 + (d23 * d44 + d24 * d45 + d25 * d46);
 HEAPF32[i5 + 60 >> 2] = 0.0;
 FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i2 >> 2] | 0) + 8 >> 2] & 127](i2, i5, i6, i7);
 i31 = i1 + 8 | 0;
 i14 = HEAP32[i31 >> 2] | 0;
 i47 = HEAP32[i14 + 192 >> 2] | 0;
 FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i47 >> 2] | 0) + 8 >> 2] & 127](i47, i14 + 4 | 0, i8, i9);
 do {
  if (+HEAPF32[i6 >> 2] > +HEAPF32[i9 >> 2]) {
   i48 = 0;
  } else {
   if (+HEAPF32[i7 >> 2] < +HEAPF32[i8 >> 2]) {
    i48 = 0;
    break;
   }
   i48 = 1;
  }
 } while (0);
 do {
  if (+HEAPF32[i6 + 8 >> 2] > +HEAPF32[i9 + 8 >> 2]) {
   i49 = 0;
  } else {
   if (+HEAPF32[i7 + 8 >> 2] < +HEAPF32[i8 + 8 >> 2]) {
    i49 = 0;
    break;
   }
   i49 = i48;
  }
 } while (0);
 if (+HEAPF32[i6 + 4 >> 2] > +HEAPF32[i9 + 4 >> 2]) {
  STACKTOP = i4;
  return;
 }
 if (+HEAPF32[i7 + 4 >> 2] < +HEAPF32[i8 + 4 >> 2] | i49 ^ 1) {
  STACKTOP = i4;
  return;
 }
 i49 = HEAP32[i12 >> 2] | 0;
 i48 = i49 + 4 | 0;
 i14 = i5;
 HEAP32[i48 >> 2] = HEAP32[i14 >> 2];
 HEAP32[i48 + 4 >> 2] = HEAP32[i14 + 4 >> 2];
 HEAP32[i48 + 8 >> 2] = HEAP32[i14 + 8 >> 2];
 HEAP32[i48 + 12 >> 2] = HEAP32[i14 + 12 >> 2];
 i48 = i49 + 20 | 0;
 i47 = i5 + 16 | 0;
 HEAP32[i48 >> 2] = HEAP32[i47 >> 2];
 HEAP32[i48 + 4 >> 2] = HEAP32[i47 + 4 >> 2];
 HEAP32[i48 + 8 >> 2] = HEAP32[i47 + 8 >> 2];
 HEAP32[i48 + 12 >> 2] = HEAP32[i47 + 12 >> 2];
 i48 = i49 + 36 | 0;
 i50 = i5 + 32 | 0;
 HEAP32[i48 >> 2] = HEAP32[i50 >> 2];
 HEAP32[i48 + 4 >> 2] = HEAP32[i50 + 4 >> 2];
 HEAP32[i48 + 8 >> 2] = HEAP32[i50 + 8 >> 2];
 HEAP32[i48 + 12 >> 2] = HEAP32[i50 + 12 >> 2];
 i48 = i49 + 52 | 0;
 i49 = i5 + 48 | 0;
 HEAP32[i48 >> 2] = HEAP32[i49 >> 2];
 HEAP32[i48 + 4 >> 2] = HEAP32[i49 + 4 >> 2];
 HEAP32[i48 + 8 >> 2] = HEAP32[i49 + 8 >> 2];
 HEAP32[i48 + 12 >> 2] = HEAP32[i49 + 12 >> 2];
 i48 = HEAP32[i12 >> 2] | 0;
 i5 = i48 + 68 | 0;
 HEAP32[i5 >> 2] = HEAP32[i14 >> 2];
 HEAP32[i5 + 4 >> 2] = HEAP32[i14 + 4 >> 2];
 HEAP32[i5 + 8 >> 2] = HEAP32[i14 + 8 >> 2];
 HEAP32[i5 + 12 >> 2] = HEAP32[i14 + 12 >> 2];
 i14 = i48 + 84 | 0;
 HEAP32[i14 >> 2] = HEAP32[i47 >> 2];
 HEAP32[i14 + 4 >> 2] = HEAP32[i47 + 4 >> 2];
 HEAP32[i14 + 8 >> 2] = HEAP32[i47 + 8 >> 2];
 HEAP32[i14 + 12 >> 2] = HEAP32[i47 + 12 >> 2];
 i47 = i48 + 100 | 0;
 HEAP32[i47 >> 2] = HEAP32[i50 >> 2];
 HEAP32[i47 + 4 >> 2] = HEAP32[i50 + 4 >> 2];
 HEAP32[i47 + 8 >> 2] = HEAP32[i50 + 8 >> 2];
 HEAP32[i47 + 12 >> 2] = HEAP32[i50 + 12 >> 2];
 i50 = i48 + 116 | 0;
 HEAP32[i50 >> 2] = HEAP32[i49 >> 2];
 HEAP32[i50 + 4 >> 2] = HEAP32[i49 + 4 >> 2];
 HEAP32[i50 + 8 >> 2] = HEAP32[i49 + 8 >> 2];
 HEAP32[i50 + 12 >> 2] = HEAP32[i49 + 12 >> 2];
 i49 = (HEAP32[i12 >> 2] | 0) + 192 | 0;
 i50 = HEAP32[i49 >> 2] | 0;
 HEAP32[i49 >> 2] = i2;
 i2 = i1 + 24 | 0;
 if ((HEAP32[(HEAP32[i2 >> 2] | 0) + (i3 << 2) >> 2] | 0) == 0) {
  i49 = HEAP32[i1 + 12 >> 2] | 0;
  i48 = FUNCTION_TABLE_iiiii[HEAP32[(HEAP32[i49 >> 2] | 0) + 8 >> 2] & 31](i49, HEAP32[i12 >> 2] | 0, HEAP32[i31 >> 2] | 0, HEAP32[i1 + 28 >> 2] | 0) | 0;
  HEAP32[(HEAP32[i2 >> 2] | 0) + (i3 << 2) >> 2] = i48;
 }
 i48 = i1 + 20 | 0;
 i49 = HEAP32[i48 >> 2] | 0;
 i47 = HEAP32[i49 >> 2] | 0;
 if ((HEAP32[i49 + 136 >> 2] | 0) == (HEAP32[i12 >> 2] | 0)) {
  FUNCTION_TABLE_viii[HEAP32[i47 + 8 >> 2] & 127](i49, -1, i3);
 } else {
  FUNCTION_TABLE_viii[HEAP32[i47 + 12 >> 2] & 127](i49, -1, i3);
 }
 i49 = HEAP32[(HEAP32[i2 >> 2] | 0) + (i3 << 2) >> 2] | 0;
 i3 = i1 + 16 | 0;
 FUNCTION_TABLE_viiiii[HEAP32[(HEAP32[i49 >> 2] | 0) + 8 >> 2] & 63](i49, HEAP32[i12 >> 2] | 0, HEAP32[i31 >> 2] | 0, HEAP32[i3 >> 2] | 0, HEAP32[i48 >> 2] | 0);
 i48 = HEAP32[(HEAP32[i3 >> 2] | 0) + 20 >> 2] | 0;
 do {
  if ((i48 | 0) != 0) {
   if (((FUNCTION_TABLE_ii[HEAP32[(HEAP32[i48 >> 2] | 0) + 48 >> 2] & 127](i48) | 0) & 2 | 0) == 0) {
    break;
   }
   i31 = HEAP32[(HEAP32[i3 >> 2] | 0) + 20 >> 2] | 0;
   i49 = HEAP32[(HEAP32[i31 >> 2] | 0) + 52 >> 2] | 0;
   HEAPF32[i10 >> 2] = 1.0;
   HEAPF32[i10 + 4 >> 2] = 1.0;
   HEAPF32[i10 + 8 >> 2] = 1.0;
   HEAPF32[i10 + 12 >> 2] = 0.0;
   FUNCTION_TABLE_viiii[i49 & 127](i31, i6, i7, i10);
   i31 = HEAP32[(HEAP32[i3 >> 2] | 0) + 20 >> 2] | 0;
   i49 = HEAP32[(HEAP32[i31 >> 2] | 0) + 52 >> 2] | 0;
   HEAPF32[i11 >> 2] = 1.0;
   HEAPF32[i11 + 4 >> 2] = 1.0;
   HEAPF32[i11 + 8 >> 2] = 1.0;
   HEAPF32[i11 + 12 >> 2] = 0.0;
   FUNCTION_TABLE_viiii[i49 & 127](i31, i8, i9, i11);
  }
 } while (0);
 HEAP32[(HEAP32[i12 >> 2] | 0) + 192 >> 2] = i50;
 i50 = HEAP32[i12 >> 2] | 0;
 HEAPF32[i50 + 4 >> 2] = d15;
 HEAPF32[i50 + 8 >> 2] = d16;
 HEAPF32[i50 + 12 >> 2] = d17;
 HEAPF32[i50 + 16 >> 2] = d18;
 HEAPF32[i50 + 20 >> 2] = d19;
 HEAPF32[i50 + 24 >> 2] = d20;
 HEAPF32[i50 + 28 >> 2] = d21;
 HEAPF32[i50 + 32 >> 2] = d22;
 HEAPF32[i50 + 36 >> 2] = d23;
 HEAPF32[i50 + 40 >> 2] = d24;
 HEAPF32[i50 + 44 >> 2] = d25;
 HEAPF32[i50 + 48 >> 2] = d26;
 HEAPF32[i50 + 52 >> 2] = d27;
 HEAPF32[i50 + 56 >> 2] = d28;
 HEAPF32[i50 + 60 >> 2] = d29;
 HEAPF32[i50 + 64 >> 2] = d30;
 i50 = HEAP32[i12 >> 2] | 0;
 i12 = i50 + 68 | 0;
 HEAP32[i12 >> 2] = HEAP32[i32 >> 2];
 HEAP32[i12 + 4 >> 2] = HEAP32[i32 + 4 >> 2];
 HEAP32[i12 + 8 >> 2] = HEAP32[i32 + 8 >> 2];
 HEAP32[i12 + 12 >> 2] = HEAP32[i32 + 12 >> 2];
 i32 = i50 + 84 | 0;
 HEAP32[i32 >> 2] = HEAP32[i33 >> 2];
 HEAP32[i32 + 4 >> 2] = HEAP32[i33 + 4 >> 2];
 HEAP32[i32 + 8 >> 2] = HEAP32[i33 + 8 >> 2];
 HEAP32[i32 + 12 >> 2] = HEAP32[i33 + 12 >> 2];
 i33 = i50 + 100 | 0;
 HEAP32[i33 >> 2] = HEAP32[i34 >> 2];
 HEAP32[i33 + 4 >> 2] = HEAP32[i34 + 4 >> 2];
 HEAP32[i33 + 8 >> 2] = HEAP32[i34 + 8 >> 2];
 HEAP32[i33 + 12 >> 2] = HEAP32[i34 + 12 >> 2];
 i34 = i50 + 116 | 0;
 HEAP32[i34 >> 2] = HEAP32[i13 >> 2];
 HEAP32[i34 + 4 >> 2] = HEAP32[i13 + 4 >> 2];
 HEAP32[i34 + 8 >> 2] = HEAP32[i13 + 8 >> 2];
 HEAP32[i34 + 12 >> 2] = HEAP32[i13 + 12 >> 2];
 STACKTOP = i4;
 return;
}
function __ZN27btPolyhedralContactClipping8clipFaceERK20btAlignedObjectArrayI9btVector3ERS2_RKS1_f(i1, i2, i3, d4) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 d4 = +d4;
 var i5 = 0, i6 = 0, i7 = 0, d8 = 0.0, d9 = 0.0, d10 = 0.0, i11 = 0, i12 = 0, d13 = 0.0, d14 = 0.0, d15 = 0.0, i16 = 0, i17 = 0, i18 = 0, d19 = 0.0, d20 = 0.0, d21 = 0.0, d22 = 0.0, i23 = 0, d24 = 0.0, d25 = 0.0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, d35 = 0.0, d36 = 0.0, d37 = 0.0, d38 = 0.0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, d44 = 0.0, d45 = 0.0, d46 = 0.0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0;
 i5 = HEAP32[i1 + 4 >> 2] | 0;
 if ((i5 | 0) < 2) {
  return;
 }
 i6 = i5 - 1 | 0;
 i7 = i1 + 12 | 0;
 i1 = HEAP32[i7 >> 2] | 0;
 d8 = +HEAPF32[i1 + (i6 << 4) >> 2];
 d9 = +HEAPF32[i1 + (i6 << 4) + 4 >> 2];
 d10 = +HEAPF32[i1 + (i6 << 4) + 8 >> 2];
 i6 = i3 | 0;
 i11 = i3 + 4 | 0;
 i12 = i3 + 8 | 0;
 d13 = +HEAPF32[i11 >> 2];
 d14 = +HEAPF32[i6 >> 2];
 d15 = +HEAPF32[i12 >> 2];
 i3 = i2 + 4 | 0;
 i16 = i2 + 8 | 0;
 i17 = i2 + 12 | 0;
 i18 = i2 + 16 | 0;
 d19 = d10;
 d20 = d9;
 d21 = d8;
 d22 = d9 * d13 + d8 * d14 + d10 * d15 + d4;
 i2 = 0;
 i23 = i1;
 d10 = d14;
 d14 = d13;
 d13 = d15;
 while (1) {
  d15 = +HEAPF32[i23 + (i2 << 4) >> 2];
  d8 = +HEAPF32[i23 + (i2 << 4) + 4 >> 2];
  d9 = +HEAPF32[i23 + (i2 << 4) + 8 >> 2];
  d24 = +HEAPF32[i23 + (i2 << 4) + 12 >> 2];
  d25 = d10 * d15 + d14 * d8 + d13 * d9 + d4;
  i1 = d25 < 0.0;
  do {
   if (d22 < 0.0) {
    if (i1) {
     i26 = HEAP32[i3 >> 2] | 0;
     do {
      if ((i26 | 0) == (HEAP32[i16 >> 2] | 0)) {
       i27 = (i26 | 0) == 0 ? 1 : i26 << 1;
       if ((i26 | 0) >= (i27 | 0)) {
        i28 = i26;
        break;
       }
       if ((i27 | 0) == 0) {
        i29 = 0;
        i30 = i26;
       } else {
        i31 = __Z22btAlignedAllocInternalji(i27 << 4, 16) | 0;
        i29 = i31;
        i30 = HEAP32[i3 >> 2] | 0;
       }
       if ((i30 | 0) > 0) {
        i31 = 0;
        do {
         i32 = i29 + (i31 << 4) | 0;
         if ((i32 | 0) != 0) {
          i33 = i32;
          i32 = (HEAP32[i17 >> 2] | 0) + (i31 << 4) | 0;
          HEAP32[i33 >> 2] = HEAP32[i32 >> 2];
          HEAP32[i33 + 4 >> 2] = HEAP32[i32 + 4 >> 2];
          HEAP32[i33 + 8 >> 2] = HEAP32[i32 + 8 >> 2];
          HEAP32[i33 + 12 >> 2] = HEAP32[i32 + 12 >> 2];
         }
         i31 = i31 + 1 | 0;
        } while ((i31 | 0) < (i30 | 0));
       }
       i31 = HEAP32[i17 >> 2] | 0;
       if ((i31 | 0) != 0) {
        if ((HEAP8[i18] | 0) != 0) {
         __Z21btAlignedFreeInternalPv(i31);
        }
        HEAP32[i17 >> 2] = 0;
       }
       HEAP8[i18] = 1;
       HEAP32[i17 >> 2] = i29;
       HEAP32[i16 >> 2] = i27;
       i28 = HEAP32[i3 >> 2] | 0;
      } else {
       i28 = i26;
      }
     } while (0);
     i26 = HEAP32[i17 >> 2] | 0;
     i31 = i26 + (i28 << 4) | 0;
     if ((i31 | 0) == 0) {
      i34 = i28;
     } else {
      HEAPF32[i31 >> 2] = d15;
      HEAPF32[i26 + (i28 << 4) + 4 >> 2] = d8;
      HEAPF32[i26 + (i28 << 4) + 8 >> 2] = d9;
      HEAPF32[i26 + (i28 << 4) + 12 >> 2] = d24;
      i34 = HEAP32[i3 >> 2] | 0;
     }
     HEAP32[i3 >> 2] = i34 + 1;
     break;
    } else {
     d35 = d22 / (d22 - d25);
     d36 = d21 + (d15 - d21) * d35;
     d37 = d20 + (d8 - d20) * d35;
     d38 = d19 + (d9 - d19) * d35;
     i26 = HEAP32[i3 >> 2] | 0;
     do {
      if ((i26 | 0) == (HEAP32[i16 >> 2] | 0)) {
       i31 = (i26 | 0) == 0 ? 1 : i26 << 1;
       if ((i26 | 0) >= (i31 | 0)) {
        i39 = i26;
        break;
       }
       if ((i31 | 0) == 0) {
        i40 = 0;
        i41 = i26;
       } else {
        i32 = __Z22btAlignedAllocInternalji(i31 << 4, 16) | 0;
        i40 = i32;
        i41 = HEAP32[i3 >> 2] | 0;
       }
       if ((i41 | 0) > 0) {
        i32 = 0;
        do {
         i33 = i40 + (i32 << 4) | 0;
         if ((i33 | 0) != 0) {
          i42 = i33;
          i33 = (HEAP32[i17 >> 2] | 0) + (i32 << 4) | 0;
          HEAP32[i42 >> 2] = HEAP32[i33 >> 2];
          HEAP32[i42 + 4 >> 2] = HEAP32[i33 + 4 >> 2];
          HEAP32[i42 + 8 >> 2] = HEAP32[i33 + 8 >> 2];
          HEAP32[i42 + 12 >> 2] = HEAP32[i33 + 12 >> 2];
         }
         i32 = i32 + 1 | 0;
        } while ((i32 | 0) < (i41 | 0));
       }
       i32 = HEAP32[i17 >> 2] | 0;
       if ((i32 | 0) != 0) {
        if ((HEAP8[i18] | 0) != 0) {
         __Z21btAlignedFreeInternalPv(i32);
        }
        HEAP32[i17 >> 2] = 0;
       }
       HEAP8[i18] = 1;
       HEAP32[i17 >> 2] = i40;
       HEAP32[i16 >> 2] = i31;
       i39 = HEAP32[i3 >> 2] | 0;
      } else {
       i39 = i26;
      }
     } while (0);
     i26 = HEAP32[i17 >> 2] | 0;
     i32 = i26 + (i39 << 4) | 0;
     if ((i32 | 0) == 0) {
      i43 = i39;
     } else {
      HEAPF32[i32 >> 2] = d36;
      HEAPF32[i26 + (i39 << 4) + 4 >> 2] = d37;
      HEAPF32[i26 + (i39 << 4) + 8 >> 2] = d38;
      HEAPF32[i26 + (i39 << 4) + 12 >> 2] = 0.0;
      i43 = HEAP32[i3 >> 2] | 0;
     }
     HEAP32[i3 >> 2] = i43 + 1;
     break;
    }
   } else {
    if (!i1) {
     break;
    }
    d35 = d22 / (d22 - d25);
    d44 = d21 + (d15 - d21) * d35;
    d45 = d20 + (d8 - d20) * d35;
    d46 = d19 + (d9 - d19) * d35;
    i26 = HEAP32[i3 >> 2] | 0;
    i32 = HEAP32[i16 >> 2] | 0;
    do {
     if ((i26 | 0) == (i32 | 0)) {
      i27 = (i26 | 0) == 0 ? 1 : i26 << 1;
      if ((i26 | 0) >= (i27 | 0)) {
       i47 = i26;
       i48 = i26;
       break;
      }
      if ((i27 | 0) == 0) {
       i49 = 0;
       i50 = i26;
      } else {
       i33 = __Z22btAlignedAllocInternalji(i27 << 4, 16) | 0;
       i49 = i33;
       i50 = HEAP32[i3 >> 2] | 0;
      }
      if ((i50 | 0) > 0) {
       i33 = 0;
       do {
        i42 = i49 + (i33 << 4) | 0;
        if ((i42 | 0) != 0) {
         i51 = i42;
         i42 = (HEAP32[i17 >> 2] | 0) + (i33 << 4) | 0;
         HEAP32[i51 >> 2] = HEAP32[i42 >> 2];
         HEAP32[i51 + 4 >> 2] = HEAP32[i42 + 4 >> 2];
         HEAP32[i51 + 8 >> 2] = HEAP32[i42 + 8 >> 2];
         HEAP32[i51 + 12 >> 2] = HEAP32[i42 + 12 >> 2];
        }
        i33 = i33 + 1 | 0;
       } while ((i33 | 0) < (i50 | 0));
      }
      i33 = HEAP32[i17 >> 2] | 0;
      if ((i33 | 0) != 0) {
       if ((HEAP8[i18] | 0) != 0) {
        __Z21btAlignedFreeInternalPv(i33);
       }
       HEAP32[i17 >> 2] = 0;
      }
      HEAP8[i18] = 1;
      HEAP32[i17 >> 2] = i49;
      HEAP32[i16 >> 2] = i27;
      i47 = HEAP32[i3 >> 2] | 0;
      i48 = i27;
     } else {
      i47 = i26;
      i48 = i32;
     }
    } while (0);
    i32 = HEAP32[i17 >> 2] | 0;
    i26 = i32 + (i47 << 4) | 0;
    if ((i26 | 0) == 0) {
     i52 = i47;
     i53 = i48;
    } else {
     HEAPF32[i26 >> 2] = d44;
     HEAPF32[i32 + (i47 << 4) + 4 >> 2] = d45;
     HEAPF32[i32 + (i47 << 4) + 8 >> 2] = d46;
     HEAPF32[i32 + (i47 << 4) + 12 >> 2] = 0.0;
     i52 = HEAP32[i3 >> 2] | 0;
     i53 = HEAP32[i16 >> 2] | 0;
    }
    i32 = i52 + 1 | 0;
    HEAP32[i3 >> 2] = i32;
    do {
     if ((i32 | 0) == (i53 | 0)) {
      i26 = (i53 | 0) == 0 ? 1 : i53 << 1;
      if ((i53 | 0) >= (i26 | 0)) {
       i54 = i53;
       break;
      }
      if ((i26 | 0) == 0) {
       i55 = 0;
       i56 = i53;
      } else {
       i33 = __Z22btAlignedAllocInternalji(i26 << 4, 16) | 0;
       i55 = i33;
       i56 = HEAP32[i3 >> 2] | 0;
      }
      if ((i56 | 0) > 0) {
       i33 = 0;
       do {
        i31 = i55 + (i33 << 4) | 0;
        if ((i31 | 0) != 0) {
         i42 = i31;
         i31 = (HEAP32[i17 >> 2] | 0) + (i33 << 4) | 0;
         HEAP32[i42 >> 2] = HEAP32[i31 >> 2];
         HEAP32[i42 + 4 >> 2] = HEAP32[i31 + 4 >> 2];
         HEAP32[i42 + 8 >> 2] = HEAP32[i31 + 8 >> 2];
         HEAP32[i42 + 12 >> 2] = HEAP32[i31 + 12 >> 2];
        }
        i33 = i33 + 1 | 0;
       } while ((i33 | 0) < (i56 | 0));
      }
      i33 = HEAP32[i17 >> 2] | 0;
      if ((i33 | 0) != 0) {
       if ((HEAP8[i18] | 0) != 0) {
        __Z21btAlignedFreeInternalPv(i33);
       }
       HEAP32[i17 >> 2] = 0;
      }
      HEAP8[i18] = 1;
      HEAP32[i17 >> 2] = i55;
      HEAP32[i16 >> 2] = i26;
      i54 = HEAP32[i3 >> 2] | 0;
     } else {
      i54 = i32;
     }
    } while (0);
    i32 = HEAP32[i17 >> 2] | 0;
    i33 = i32 + (i54 << 4) | 0;
    if ((i33 | 0) == 0) {
     i57 = i54;
    } else {
     HEAPF32[i33 >> 2] = d15;
     HEAPF32[i32 + (i54 << 4) + 4 >> 2] = d8;
     HEAPF32[i32 + (i54 << 4) + 8 >> 2] = d9;
     HEAPF32[i32 + (i54 << 4) + 12 >> 2] = d24;
     i57 = HEAP32[i3 >> 2] | 0;
    }
    HEAP32[i3 >> 2] = i57 + 1;
   }
  } while (0);
  i1 = i2 + 1 | 0;
  if ((i1 | 0) >= (i5 | 0)) {
   break;
  }
  d19 = d9;
  d20 = d8;
  d21 = d15;
  d22 = d25;
  i2 = i1;
  i23 = HEAP32[i7 >> 2] | 0;
  d10 = +HEAPF32[i6 >> 2];
  d14 = +HEAPF32[i11 >> 2];
  d13 = +HEAPF32[i12 >> 2];
 }
 return;
}
function __ZN23btDiscreteDynamicsWorld22addSpeculativeContactsEf(i1, d2) {
 i1 = i1 | 0;
 d2 = +d2;
 var i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0, i62 = 0, i63 = 0, i64 = 0, i65 = 0, i66 = 0, i67 = 0, i68 = 0, i69 = 0, i70 = 0, d71 = 0.0, i72 = 0, d73 = 0.0, i74 = 0, d75 = 0.0, d76 = 0.0, d77 = 0.0, i78 = 0, i79 = 0, i80 = 0, d81 = 0.0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 496 | 0;
 i4 = i3 | 0;
 i5 = i3 + 64 | 0;
 i6 = i3 + 160 | 0;
 i7 = i3 + 216 | 0;
 i8 = i3 + 280 | 0;
 i9 = i3 + 304 | 0;
 i10 = i3 + 464 | 0;
 i11 = i3 + 480 | 0;
 __ZN15CProfileManager13Start_ProfileEPKc(1088);
 i12 = i1 + 204 | 0;
 if ((HEAP32[i12 >> 2] | 0) <= 0) {
  __ZN15CProfileManager12Stop_ProfileEv();
  STACKTOP = i3;
  return;
 }
 i13 = i1 + 212 | 0;
 i14 = i4 + 48 | 0;
 i15 = i14 | 0;
 i16 = i4 + 52 | 0;
 i17 = i4 + 56 | 0;
 i18 = i1 | 0;
 i19 = i1 + 76 | 0;
 i20 = i1 + 24 | 0;
 i1 = i5 | 0;
 i21 = i5 + 4 | 0;
 i22 = i5 + 8 | 0;
 i23 = i5 + 10 | 0;
 i24 = i5 + 12 | 0;
 i25 = i5 + 28 | 0;
 i26 = i14;
 i14 = i5 + 76 | 0;
 i27 = i5 + 80 | 0;
 i28 = i5 + 84 | 0;
 i29 = i5 + 88 | 0;
 i30 = i5 + 92 | 0;
 i31 = i6 | 0;
 i32 = i6 | 0;
 i33 = i6 + 4 | 0;
 i34 = i6 + 28 | 0;
 i35 = i6 + 44 | 0;
 i36 = i5 | 0;
 i37 = i7;
 i38 = i4;
 i39 = i7 + 16 | 0;
 i40 = i4 + 16 | 0;
 i41 = i7 + 32 | 0;
 i42 = i4 + 32 | 0;
 i43 = i7 + 48 | 0;
 i44 = i43;
 i45 = i6 | 0;
 i6 = i8 + 16 | 0;
 i46 = i8 + 12 | 0;
 i47 = i8 + 4 | 0;
 i48 = i8 + 8 | 0;
 i49 = i9 + 4 | 0;
 i50 = i43 | 0;
 i43 = i7 + 52 | 0;
 i51 = i7 + 56 | 0;
 i52 = i10;
 i53 = i5 + 60 | 0;
 i54 = i10 | 0;
 i55 = i10 + 4 | 0;
 i56 = i10 + 8 | 0;
 i57 = i5 + 44 | 0;
 i58 = i57 | 0;
 i59 = i5 + 48 | 0;
 i60 = i5 + 52 | 0;
 i5 = i11 | 0;
 i61 = i11 + 4 | 0;
 i62 = i11 + 8 | 0;
 i63 = i11 + 12 | 0;
 i64 = 0;
 do {
  i65 = HEAP32[(HEAP32[i13 >> 2] | 0) + (i64 << 2) >> 2] | 0;
  i66 = i65 | 0;
  HEAPF32[i65 + 240 >> 2] = 1.0;
  i67 = HEAP32[i65 + 216 >> 2] | 0;
  do {
   if (!((i67 | 0) == 5 | (i67 | 0) == 2)) {
    if ((HEAP32[i65 + 204 >> 2] & 3 | 0) != 0) {
     break;
    }
    __ZN11btRigidBody26predictIntegratedTransformEfR11btTransform(i65, d2, i4);
    i68 = i65 + 4 | 0;
    i69 = i65 + 52 | 0;
    i70 = i69 | 0;
    d71 = +HEAPF32[i15 >> 2] - +HEAPF32[i70 >> 2];
    i72 = i65 + 56 | 0;
    d73 = +HEAPF32[i16 >> 2] - +HEAPF32[i72 >> 2];
    i74 = i65 + 60 | 0;
    d75 = +HEAPF32[i17 >> 2] - +HEAPF32[i74 >> 2];
    d76 = +HEAPF32[i65 + 248 >> 2];
    d77 = d76 * d76;
    if (!(d77 != 0.0 & d77 < d71 * d71 + d73 * d73 + d75 * d75)) {
     break;
    }
    __ZN15CProfileManager13Start_ProfileEPKc(1032);
    if ((HEAP32[(HEAP32[i65 + 192 >> 2] | 0) + 4 >> 2] | 0) < 20) {
     HEAP32[2996] = (HEAP32[2996] | 0) + 1;
     i78 = HEAP32[i19 >> 2] | 0;
     i79 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i78 >> 2] | 0) + 36 >> 2] & 127](i78) | 0;
     i78 = HEAP32[i20 >> 2] | 0;
     HEAPF32[i21 >> 2] = 1.0;
     HEAP16[i22 >> 1] = 1;
     HEAP16[i23 >> 1] = -1;
     HEAP32[i1 >> 2] = 2248;
     i80 = i69;
     HEAP32[i24 >> 2] = HEAP32[i80 >> 2];
     HEAP32[i24 + 4 >> 2] = HEAP32[i80 + 4 >> 2];
     HEAP32[i24 + 8 >> 2] = HEAP32[i80 + 8 >> 2];
     HEAP32[i24 + 12 >> 2] = HEAP32[i80 + 12 >> 2];
     HEAP32[i25 >> 2] = HEAP32[i26 >> 2];
     HEAP32[i25 + 4 >> 2] = HEAP32[i26 + 4 >> 2];
     HEAP32[i25 + 8 >> 2] = HEAP32[i26 + 8 >> 2];
     HEAP32[i25 + 12 >> 2] = HEAP32[i26 + 12 >> 2];
     HEAP32[i14 >> 2] = 0;
     HEAP32[i1 >> 2] = 2464;
     HEAP32[i27 >> 2] = i66;
     HEAPF32[i28 >> 2] = 0.0;
     HEAP32[i29 >> 2] = i79;
     HEAP32[i30 >> 2] = i78;
     d75 = +HEAPF32[i65 + 244 >> 2];
     __ZN21btConvexInternalShapeC2Ev(i31);
     HEAP32[i32 >> 2] = 4728;
     HEAP32[i33 >> 2] = 8;
     HEAPF32[i34 >> 2] = d75;
     HEAPF32[i35 >> 2] = d75;
     i78 = i65 + 188 | 0;
     i79 = HEAP32[i78 >> 2] | 0;
     HEAP16[i22 >> 1] = HEAP16[i79 + 4 >> 1] | 0;
     HEAP16[i23 >> 1] = HEAP16[i79 + 6 >> 1] | 0;
     HEAP32[i37 >> 2] = HEAP32[i38 >> 2];
     HEAP32[i37 + 4 >> 2] = HEAP32[i38 + 4 >> 2];
     HEAP32[i37 + 8 >> 2] = HEAP32[i38 + 8 >> 2];
     HEAP32[i37 + 12 >> 2] = HEAP32[i38 + 12 >> 2];
     HEAP32[i39 >> 2] = HEAP32[i40 >> 2];
     HEAP32[i39 + 4 >> 2] = HEAP32[i40 + 4 >> 2];
     HEAP32[i39 + 8 >> 2] = HEAP32[i40 + 8 >> 2];
     HEAP32[i39 + 12 >> 2] = HEAP32[i40 + 12 >> 2];
     HEAP32[i41 >> 2] = HEAP32[i42 >> 2];
     HEAP32[i41 + 4 >> 2] = HEAP32[i42 + 4 >> 2];
     HEAP32[i41 + 8 >> 2] = HEAP32[i42 + 8 >> 2];
     HEAP32[i41 + 12 >> 2] = HEAP32[i42 + 12 >> 2];
     HEAP32[i44 >> 2] = HEAP32[i26 >> 2];
     HEAP32[i44 + 4 >> 2] = HEAP32[i26 + 4 >> 2];
     HEAP32[i44 + 8 >> 2] = HEAP32[i26 + 8 >> 2];
     HEAP32[i44 + 12 >> 2] = HEAP32[i26 + 12 >> 2];
     i79 = i68;
     HEAP32[i37 >> 2] = HEAP32[i79 >> 2];
     HEAP32[i37 + 4 >> 2] = HEAP32[i79 + 4 >> 2];
     HEAP32[i37 + 8 >> 2] = HEAP32[i79 + 8 >> 2];
     HEAP32[i37 + 12 >> 2] = HEAP32[i79 + 12 >> 2];
     i79 = i65 + 20 | 0;
     HEAP32[i39 >> 2] = HEAP32[i79 >> 2];
     HEAP32[i39 + 4 >> 2] = HEAP32[i79 + 4 >> 2];
     HEAP32[i39 + 8 >> 2] = HEAP32[i79 + 8 >> 2];
     HEAP32[i39 + 12 >> 2] = HEAP32[i79 + 12 >> 2];
     i79 = i65 + 36 | 0;
     HEAP32[i41 >> 2] = HEAP32[i79 >> 2];
     HEAP32[i41 + 4 >> 2] = HEAP32[i79 + 4 >> 2];
     HEAP32[i41 + 8 >> 2] = HEAP32[i79 + 8 >> 2];
     HEAP32[i41 + 12 >> 2] = HEAP32[i79 + 12 >> 2];
     __ZNK16btCollisionWorld15convexSweepTestEPK13btConvexShapeRK11btTransformS5_RNS_20ConvexResultCallbackEf(i18, i45, i68, i7, i36, 0.0);
     do {
      if (+HEAPF32[i21 >> 2] < 1.0) {
       i68 = HEAP32[i29 >> 2] | 0;
       i79 = FUNCTION_TABLE_iiii[HEAP32[(HEAP32[i68 >> 2] | 0) + 52 >> 2] & 31](i68, HEAP32[i78 >> 2] | 0, HEAP32[(HEAP32[i14 >> 2] | 0) + 188 >> 2] | 0) | 0;
       if ((i79 | 0) == 0) {
        break;
       }
       i68 = i79 + 8 | 0;
       if ((HEAP32[i68 >> 2] | 0) == 0) {
        break;
       }
       HEAP8[i6] = 1;
       HEAP32[i46 >> 2] = 0;
       HEAP32[i47 >> 2] = 0;
       HEAP32[i48 >> 2] = 0;
       i79 = HEAP32[i68 >> 2] | 0;
       FUNCTION_TABLE_vii[HEAP32[(HEAP32[i79 >> 2] | 0) + 16 >> 2] & 127](i79, i8);
       do {
        if ((HEAP32[i47 >> 2] | 0) != 0) {
         __ZN16btManifoldResultC2EP17btCollisionObjectS1_(i9, i66, HEAP32[i14 >> 2] | 0);
         i79 = HEAP32[i46 >> 2] | 0;
         HEAP32[i49 >> 2] = HEAP32[i79 >> 2];
         d75 = +HEAPF32[i21 >> 2];
         d73 = (+HEAPF32[i50 >> 2] - +HEAPF32[i70 >> 2]) * d75;
         d71 = (+HEAPF32[i43 >> 2] - +HEAPF32[i72 >> 2]) * d75;
         d77 = d75 * (+HEAPF32[i51 >> 2] - +HEAPF32[i74 >> 2]);
         d75 = d77 * d77 + (d73 * d73 + d71 * d71);
         HEAP32[i52 >> 2] = HEAP32[i53 >> 2];
         HEAP32[i52 + 4 >> 2] = HEAP32[i53 + 4 >> 2];
         HEAP32[i52 + 8 >> 2] = HEAP32[i53 + 8 >> 2];
         HEAP32[i52 + 12 >> 2] = HEAP32[i53 + 12 >> 2];
         if (d75 > 1.1920928955078125e-7) {
          d76 = +Math_sqrt(+d75);
          HEAPF32[i54 >> 2] = +HEAPF32[i54 >> 2] - d73;
          HEAPF32[i55 >> 2] = +HEAPF32[i55 >> 2] - d71;
          HEAPF32[i56 >> 2] = +HEAPF32[i56 >> 2] - d77;
          d81 = d76;
         } else {
          d81 = 0.0;
         }
         if ((HEAP32[(HEAP32[i79 >> 2] | 0) + 1108 >> 2] | 0) == (i65 | 0)) {
          __ZN16btManifoldResult15addContactPointERK9btVector3S2_f(i9, i57, i10, d81);
          break;
         } else {
          d76 = -0.0 - +HEAPF32[i59 >> 2];
          d77 = -0.0 - +HEAPF32[i60 >> 2];
          HEAPF32[i5 >> 2] = -0.0 - +HEAPF32[i58 >> 2];
          HEAPF32[i61 >> 2] = d76;
          HEAPF32[i62 >> 2] = d77;
          HEAPF32[i63 >> 2] = 0.0;
          __ZN16btManifoldResult15addContactPointERK9btVector3S2_f(i9, i11, i10, d81);
          break;
         }
        }
       } while (0);
       i79 = HEAP32[i46 >> 2] | 0;
       if ((i79 | 0) != 0) {
        if ((HEAP8[i6] | 0) != 0) {
         __Z21btAlignedFreeInternalPv(i79);
        }
        HEAP32[i46 >> 2] = 0;
       }
       HEAP8[i6] = 1;
       HEAP32[i46 >> 2] = 0;
       HEAP32[i47 >> 2] = 0;
       HEAP32[i48 >> 2] = 0;
      }
     } while (0);
     __ZN13btConvexShapeD2Ev(i45);
    }
    __ZN15CProfileManager12Stop_ProfileEv();
   }
  } while (0);
  i64 = i64 + 1 | 0;
 } while ((i64 | 0) < (HEAP32[i12 >> 2] | 0));
 __ZN15CProfileManager12Stop_ProfileEv();
 STACKTOP = i3;
 return;
}
function __ZN22btVoronoiSimplexSolver28updateClosestVectorAndPointsEv(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, d14 = 0.0, d15 = 0.0, d16 = 0.0, i17 = 0, d18 = 0.0, d19 = 0.0, d20 = 0.0, d21 = 0.0, d22 = 0.0, d23 = 0.0, d24 = 0.0, i25 = 0, d26 = 0.0, i27 = 0, i28 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i3 = i2 | 0;
 i4 = i2 + 16 | 0;
 i5 = i1 + 356 | 0;
 if ((HEAP8[i5] | 0) == 0) {
  i6 = HEAP8[i1 + 312 | 0] | 0;
  i7 = i6 << 24 >> 24 != 0;
  STACKTOP = i2;
  return i7 | 0;
 }
 i8 = i1 + 316 | 0;
 i9 = i1 + 336 | 0;
 i10 = i1 + 332 | 0;
 i11 = i10;
 i12 = i9;
 _memset(i12 | 0, 0, 17);
 i13 = HEAP16[i11 >> 1] & -16;
 HEAP16[i11 >> 1] = i13;
 HEAP8[i5] = 0;
 switch (HEAP32[i1 >> 2] | 0) {
 case 4:
  {
   _memset(i4 | 0, 0, 16);
   if (!(__ZN22btVoronoiSimplexSolver25closestPtPointTetrahedronERK9btVector3S2_S2_S2_S2_R25btSubSimplexClosestResult(0, i4, i1 + 4 | 0, i1 + 20 | 0, i1 + 36 | 0, i1 + 52 | 0, i8) | 0)) {
    i4 = i1 + 312 | 0;
    if ((HEAP8[i1 + 352 | 0] | 0) == 0) {
     HEAP8[i4] = 1;
     _memset(i1 + 276 | 0, 0, 16);
     i6 = 1;
     i7 = i6 << 24 >> 24 != 0;
     STACKTOP = i2;
     return i7 | 0;
    } else {
     HEAP8[i4] = 0;
     i6 = 0;
     i7 = i6 << 24 >> 24 != 0;
     STACKTOP = i2;
     return i7 | 0;
    }
   }
   d14 = +HEAPF32[i9 >> 2];
   i4 = i1 + 340 | 0;
   d15 = +HEAPF32[i4 >> 2];
   i5 = i1 + 344 | 0;
   d16 = +HEAPF32[i5 >> 2];
   i17 = i1 + 348 | 0;
   d18 = +HEAPF32[i17 >> 2];
   d19 = +HEAPF32[i1 + 84 >> 2] * d14 + +HEAPF32[i1 + 100 >> 2] * d15 + +HEAPF32[i1 + 116 >> 2] * d16 + +HEAPF32[i1 + 132 >> 2] * d18;
   d20 = d14 * +HEAPF32[i1 + 88 >> 2] + d15 * +HEAPF32[i1 + 104 >> 2] + d16 * +HEAPF32[i1 + 120 >> 2] + d18 * +HEAPF32[i1 + 136 >> 2];
   d21 = d14 * +HEAPF32[i1 + 92 >> 2] + d15 * +HEAPF32[i1 + 108 >> 2] + d16 * +HEAPF32[i1 + 124 >> 2] + d18 * +HEAPF32[i1 + 140 >> 2];
   HEAPF32[i1 + 244 >> 2] = d19;
   HEAPF32[i1 + 248 >> 2] = d20;
   HEAPF32[i1 + 252 >> 2] = d21;
   HEAPF32[i1 + 256 >> 2] = 0.0;
   d22 = d14 * +HEAPF32[i1 + 164 >> 2] + d15 * +HEAPF32[i1 + 180 >> 2] + d16 * +HEAPF32[i1 + 196 >> 2] + d18 * +HEAPF32[i1 + 212 >> 2];
   d23 = d14 * +HEAPF32[i1 + 168 >> 2] + d15 * +HEAPF32[i1 + 184 >> 2] + d16 * +HEAPF32[i1 + 200 >> 2] + d18 * +HEAPF32[i1 + 216 >> 2];
   d24 = d14 * +HEAPF32[i1 + 172 >> 2] + d15 * +HEAPF32[i1 + 188 >> 2] + d16 * +HEAPF32[i1 + 204 >> 2] + d18 * +HEAPF32[i1 + 220 >> 2];
   HEAPF32[i1 + 260 >> 2] = d22;
   HEAPF32[i1 + 264 >> 2] = d23;
   HEAPF32[i1 + 268 >> 2] = d24;
   HEAPF32[i1 + 272 >> 2] = 0.0;
   HEAPF32[i1 + 276 >> 2] = d19 - d22;
   HEAPF32[i1 + 280 >> 2] = d20 - d23;
   HEAPF32[i1 + 284 >> 2] = d21 - d24;
   HEAPF32[i1 + 288 >> 2] = 0.0;
   __ZN22btVoronoiSimplexSolver14reduceVerticesERK15btUsageBitfield(i1, i10);
   do {
    if (+HEAPF32[i9 >> 2] < 0.0) {
     i25 = 0;
    } else {
     if (+HEAPF32[i4 >> 2] < 0.0) {
      i25 = 0;
      break;
     }
     if (+HEAPF32[i5 >> 2] < 0.0) {
      i25 = 0;
      break;
     }
     i25 = +HEAPF32[i17 >> 2] >= 0.0 | 0;
    }
   } while (0);
   HEAP8[i1 + 312 | 0] = i25;
   i6 = i25;
   i7 = i6 << 24 >> 24 != 0;
   STACKTOP = i2;
   return i7 | 0;
  }
 case 0:
  {
   HEAP8[i1 + 312 | 0] = 0;
   i6 = 0;
   i7 = i6 << 24 >> 24 != 0;
   STACKTOP = i2;
   return i7 | 0;
  }
 case 1:
  {
   i25 = i1 + 244 | 0;
   i17 = i25;
   i5 = i1 + 84 | 0;
   HEAP32[i17 >> 2] = HEAP32[i5 >> 2];
   HEAP32[i17 + 4 >> 2] = HEAP32[i5 + 4 >> 2];
   HEAP32[i17 + 8 >> 2] = HEAP32[i5 + 8 >> 2];
   HEAP32[i17 + 12 >> 2] = HEAP32[i5 + 12 >> 2];
   i5 = i1 + 260 | 0;
   i17 = i5;
   i4 = i1 + 164 | 0;
   HEAP32[i17 >> 2] = HEAP32[i4 >> 2];
   HEAP32[i17 + 4 >> 2] = HEAP32[i4 + 4 >> 2];
   HEAP32[i17 + 8 >> 2] = HEAP32[i4 + 8 >> 2];
   HEAP32[i17 + 12 >> 2] = HEAP32[i4 + 12 >> 2];
   d24 = +HEAPF32[i1 + 248 >> 2] - +HEAPF32[i1 + 264 >> 2];
   d21 = +HEAPF32[i1 + 252 >> 2] - +HEAPF32[i1 + 268 >> 2];
   HEAPF32[i1 + 276 >> 2] = +HEAPF32[i25 >> 2] - +HEAPF32[i5 >> 2];
   HEAPF32[i1 + 280 >> 2] = d24;
   HEAPF32[i1 + 284 >> 2] = d21;
   HEAPF32[i1 + 288 >> 2] = 0.0;
   _memset(i12 | 0, 0, 17);
   HEAP16[i11 >> 1] = i13;
   HEAPF32[i9 >> 2] = 1.0;
   HEAPF32[i1 + 340 >> 2] = 0.0;
   HEAPF32[i1 + 344 >> 2] = 0.0;
   HEAPF32[i1 + 348 >> 2] = 0.0;
   HEAP8[i1 + 312 | 0] = 1;
   i6 = 1;
   i7 = i6 << 24 >> 24 != 0;
   STACKTOP = i2;
   return i7 | 0;
  }
 case 2:
  {
   d21 = +HEAPF32[i1 + 4 >> 2];
   d24 = +HEAPF32[i1 + 8 >> 2];
   d23 = +HEAPF32[i1 + 12 >> 2];
   d20 = +HEAPF32[i1 + 20 >> 2] - d21;
   d22 = +HEAPF32[i1 + 24 >> 2] - d24;
   d19 = +HEAPF32[i1 + 28 >> 2] - d23;
   d18 = (0.0 - d21) * d20 + (0.0 - d24) * d22 + (0.0 - d23) * d19;
   do {
    if (d18 > 0.0) {
     d23 = d20 * d20 + d22 * d22 + d19 * d19;
     if (d18 < d23) {
      HEAP16[i11 >> 1] = i13 | 3;
      d26 = d18 / d23;
      break;
     } else {
      HEAP16[i11 >> 1] = i13 | 2;
      d26 = 1.0;
      break;
     }
    } else {
     HEAP16[i11 >> 1] = i13 | 1;
     d26 = 0.0;
    }
   } while (0);
   HEAPF32[i9 >> 2] = 1.0 - d26;
   i13 = i1 + 340 | 0;
   HEAPF32[i13 >> 2] = d26;
   i11 = i1 + 344 | 0;
   HEAPF32[i11 >> 2] = 0.0;
   i12 = i1 + 348 | 0;
   HEAPF32[i12 >> 2] = 0.0;
   d18 = +HEAPF32[i1 + 84 >> 2];
   d19 = +HEAPF32[i1 + 88 >> 2];
   d22 = +HEAPF32[i1 + 92 >> 2];
   d20 = d18 + d26 * (+HEAPF32[i1 + 100 >> 2] - d18);
   d18 = d19 + d26 * (+HEAPF32[i1 + 104 >> 2] - d19);
   d19 = d22 + d26 * (+HEAPF32[i1 + 108 >> 2] - d22);
   HEAPF32[i1 + 244 >> 2] = d20;
   HEAPF32[i1 + 248 >> 2] = d18;
   HEAPF32[i1 + 252 >> 2] = d19;
   HEAPF32[i1 + 256 >> 2] = 0.0;
   d22 = +HEAPF32[i1 + 164 >> 2];
   d23 = +HEAPF32[i1 + 168 >> 2];
   d24 = +HEAPF32[i1 + 172 >> 2];
   d21 = d22 + d26 * (+HEAPF32[i1 + 180 >> 2] - d22);
   d22 = d23 + d26 * (+HEAPF32[i1 + 184 >> 2] - d23);
   d23 = d24 + d26 * (+HEAPF32[i1 + 188 >> 2] - d24);
   HEAPF32[i1 + 260 >> 2] = d21;
   HEAPF32[i1 + 264 >> 2] = d22;
   HEAPF32[i1 + 268 >> 2] = d23;
   HEAPF32[i1 + 272 >> 2] = 0.0;
   HEAPF32[i1 + 276 >> 2] = d20 - d21;
   HEAPF32[i1 + 280 >> 2] = d18 - d22;
   HEAPF32[i1 + 284 >> 2] = d19 - d23;
   HEAPF32[i1 + 288 >> 2] = 0.0;
   __ZN22btVoronoiSimplexSolver14reduceVerticesERK15btUsageBitfield(i1, i10);
   do {
    if (+HEAPF32[i9 >> 2] < 0.0) {
     i27 = 0;
    } else {
     if (+HEAPF32[i13 >> 2] < 0.0) {
      i27 = 0;
      break;
     }
     if (+HEAPF32[i11 >> 2] < 0.0) {
      i27 = 0;
      break;
     }
     i27 = +HEAPF32[i12 >> 2] >= 0.0 | 0;
    }
   } while (0);
   HEAP8[i1 + 312 | 0] = i27;
   i6 = i27;
   i7 = i6 << 24 >> 24 != 0;
   STACKTOP = i2;
   return i7 | 0;
  }
 case 3:
  {
   _memset(i3 | 0, 0, 16);
   __ZN22btVoronoiSimplexSolver22closestPtPointTriangleERK9btVector3S2_S2_S2_R25btSubSimplexClosestResult(0, i3, i1 + 4 | 0, i1 + 20 | 0, i1 + 36 | 0, i8) | 0;
   d23 = +HEAPF32[i9 >> 2];
   i8 = i1 + 340 | 0;
   d19 = +HEAPF32[i8 >> 2];
   i3 = i1 + 344 | 0;
   d22 = +HEAPF32[i3 >> 2];
   d18 = +HEAPF32[i1 + 84 >> 2] * d23 + +HEAPF32[i1 + 100 >> 2] * d19 + +HEAPF32[i1 + 116 >> 2] * d22;
   d21 = d23 * +HEAPF32[i1 + 88 >> 2] + d19 * +HEAPF32[i1 + 104 >> 2] + d22 * +HEAPF32[i1 + 120 >> 2];
   d20 = d23 * +HEAPF32[i1 + 92 >> 2] + d19 * +HEAPF32[i1 + 108 >> 2] + d22 * +HEAPF32[i1 + 124 >> 2];
   HEAPF32[i1 + 244 >> 2] = d18;
   HEAPF32[i1 + 248 >> 2] = d21;
   HEAPF32[i1 + 252 >> 2] = d20;
   HEAPF32[i1 + 256 >> 2] = 0.0;
   d24 = d23 * +HEAPF32[i1 + 164 >> 2] + d19 * +HEAPF32[i1 + 180 >> 2] + d22 * +HEAPF32[i1 + 196 >> 2];
   d26 = d23 * +HEAPF32[i1 + 168 >> 2] + d19 * +HEAPF32[i1 + 184 >> 2] + d22 * +HEAPF32[i1 + 200 >> 2];
   d16 = d23 * +HEAPF32[i1 + 172 >> 2] + d19 * +HEAPF32[i1 + 188 >> 2] + d22 * +HEAPF32[i1 + 204 >> 2];
   HEAPF32[i1 + 260 >> 2] = d24;
   HEAPF32[i1 + 264 >> 2] = d26;
   HEAPF32[i1 + 268 >> 2] = d16;
   HEAPF32[i1 + 272 >> 2] = 0.0;
   HEAPF32[i1 + 276 >> 2] = d18 - d24;
   HEAPF32[i1 + 280 >> 2] = d21 - d26;
   HEAPF32[i1 + 284 >> 2] = d20 - d16;
   HEAPF32[i1 + 288 >> 2] = 0.0;
   __ZN22btVoronoiSimplexSolver14reduceVerticesERK15btUsageBitfield(i1, i10);
   do {
    if (+HEAPF32[i9 >> 2] < 0.0) {
     i28 = 0;
    } else {
     if (+HEAPF32[i8 >> 2] < 0.0) {
      i28 = 0;
      break;
     }
     if (+HEAPF32[i3 >> 2] < 0.0) {
      i28 = 0;
      break;
     }
     i28 = +HEAPF32[i1 + 348 >> 2] >= 0.0 | 0;
    }
   } while (0);
   HEAP8[i1 + 312 | 0] = i28;
   i6 = i28;
   i7 = i6 << 24 >> 24 != 0;
   STACKTOP = i2;
   return i7 | 0;
  }
 default:
  {
   HEAP8[i1 + 312 | 0] = 0;
   i6 = 0;
   i7 = i6 << 24 >> 24 != 0;
   STACKTOP = i2;
   return i7 | 0;
  }
 }
 return 0;
}
function __ZN15btGjkEpaSolver28DistanceEPK13btConvexShapeRK11btTransformS2_S5_RK9btVector3RNS_8sResultsE(i1, i2, i3, i4, i5, i6) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 var i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, d16 = 0.0, d17 = 0.0, d18 = 0.0, i19 = 0, d20 = 0.0, d21 = 0.0, i22 = 0, d23 = 0.0, d24 = 0.0, i25 = 0, d26 = 0.0, i27 = 0, d28 = 0.0, i29 = 0, d30 = 0.0, d31 = 0.0, i32 = 0, d33 = 0.0, i34 = 0, d35 = 0.0, i36 = 0, d37 = 0.0, d38 = 0.0, d39 = 0.0, d40 = 0.0, d41 = 0.0, d42 = 0.0, d43 = 0.0, d44 = 0.0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0, i62 = 0, i63 = 0, i64 = 0, i65 = 0, i66 = 0, i67 = 0, i68 = 0, i69 = 0, i70 = 0, d71 = 0.0, d72 = 0.0, d73 = 0.0, d74 = 0.0, d75 = 0.0, d76 = 0.0, i77 = 0, i78 = 0, i79 = 0, i80 = 0, i81 = 0, i82 = 0, i83 = 0, i84 = 0, i85 = 0, i86 = 0, i87 = 0, i88 = 0;
 i7 = STACKTOP;
 STACKTOP = STACKTOP + 560 | 0;
 i8 = i7 | 0;
 i9 = i7 + 16 | 0;
 i10 = i7 + 32 | 0;
 i11 = i7 + 160 | 0;
 i12 = i7 + 544 | 0;
 i13 = i6 + 20 | 0;
 i14 = i6 + 20 | 0;
 i15 = i6 + 4 | 0;
 _memset(i14 | 0, 0, 16);
 HEAP32[i15 >> 2] = HEAP32[i13 >> 2];
 HEAP32[i15 + 4 >> 2] = HEAP32[i13 + 4 >> 2];
 HEAP32[i15 + 8 >> 2] = HEAP32[i13 + 8 >> 2];
 HEAP32[i15 + 12 >> 2] = HEAP32[i13 + 12 >> 2];
 i13 = i6 | 0;
 HEAP32[i13 >> 2] = 0;
 i15 = i10 | 0;
 HEAP32[i15 >> 2] = i1;
 i1 = i10 + 4 | 0;
 HEAP32[i1 >> 2] = i3;
 d16 = +HEAPF32[i4 >> 2];
 i3 = i2 | 0;
 d17 = +HEAPF32[i3 >> 2];
 d18 = +HEAPF32[i4 + 16 >> 2];
 i19 = i2 + 16 | 0;
 d20 = +HEAPF32[i19 >> 2];
 d21 = +HEAPF32[i4 + 32 >> 2];
 i22 = i2 + 32 | 0;
 d23 = +HEAPF32[i22 >> 2];
 d24 = d16 * d17 + d18 * d20 + d21 * d23;
 i25 = i2 + 4 | 0;
 d26 = +HEAPF32[i25 >> 2];
 i27 = i2 + 20 | 0;
 d28 = +HEAPF32[i27 >> 2];
 i29 = i2 + 36 | 0;
 d30 = +HEAPF32[i29 >> 2];
 d31 = d16 * d26 + d18 * d28 + d21 * d30;
 i32 = i2 + 8 | 0;
 d33 = +HEAPF32[i32 >> 2];
 i34 = i2 + 24 | 0;
 d35 = +HEAPF32[i34 >> 2];
 i36 = i2 + 40 | 0;
 d37 = +HEAPF32[i36 >> 2];
 d38 = d16 * d33 + d18 * d35 + d21 * d37;
 d21 = +HEAPF32[i4 + 4 >> 2];
 d18 = +HEAPF32[i4 + 20 >> 2];
 d16 = +HEAPF32[i4 + 36 >> 2];
 d39 = d17 * d21 + d20 * d18 + d23 * d16;
 d40 = d26 * d21 + d28 * d18 + d30 * d16;
 d41 = d33 * d21 + d35 * d18 + d37 * d16;
 d16 = +HEAPF32[i4 + 8 >> 2];
 d18 = +HEAPF32[i4 + 24 >> 2];
 d21 = +HEAPF32[i4 + 40 >> 2];
 d42 = d17 * d16 + d20 * d18 + d23 * d21;
 d43 = d26 * d16 + d28 * d18 + d30 * d21;
 d44 = d33 * d16 + d35 * d18 + d37 * d21;
 i45 = i10 + 8 | 0;
 HEAPF32[i45 >> 2] = d24;
 i46 = i10 + 12 | 0;
 HEAPF32[i46 >> 2] = d31;
 i47 = i10 + 16 | 0;
 HEAPF32[i47 >> 2] = d38;
 HEAPF32[i10 + 20 >> 2] = 0.0;
 i48 = i10 + 24 | 0;
 HEAPF32[i48 >> 2] = d39;
 i49 = i10 + 28 | 0;
 HEAPF32[i49 >> 2] = d40;
 i50 = i10 + 32 | 0;
 HEAPF32[i50 >> 2] = d41;
 HEAPF32[i10 + 36 >> 2] = 0.0;
 i51 = i10 + 40 | 0;
 HEAPF32[i51 >> 2] = d42;
 i52 = i10 + 44 | 0;
 HEAPF32[i52 >> 2] = d43;
 i53 = i10 + 48 | 0;
 HEAPF32[i53 >> 2] = d44;
 HEAPF32[i10 + 52 >> 2] = 0.0;
 i54 = i2 + 48 | 0;
 d21 = +HEAPF32[i4 + 48 >> 2] - +HEAPF32[i54 >> 2];
 i55 = i2 + 52 | 0;
 d18 = +HEAPF32[i4 + 52 >> 2] - +HEAPF32[i55 >> 2];
 i56 = i2 + 56 | 0;
 d16 = +HEAPF32[i4 + 56 >> 2] - +HEAPF32[i56 >> 2];
 i4 = i10 + 56 | 0;
 HEAPF32[i4 >> 2] = d24;
 i2 = i10 + 60 | 0;
 HEAPF32[i2 >> 2] = d39;
 i57 = i10 + 64 | 0;
 HEAPF32[i57 >> 2] = d42;
 HEAPF32[i10 + 68 >> 2] = 0.0;
 i58 = i10 + 72 | 0;
 HEAPF32[i58 >> 2] = d31;
 i59 = i10 + 76 | 0;
 HEAPF32[i59 >> 2] = d40;
 i60 = i10 + 80 | 0;
 HEAPF32[i60 >> 2] = d43;
 HEAPF32[i10 + 84 >> 2] = 0.0;
 i61 = i10 + 88 | 0;
 HEAPF32[i61 >> 2] = d38;
 i62 = i10 + 92 | 0;
 HEAPF32[i62 >> 2] = d41;
 i63 = i10 + 96 | 0;
 HEAPF32[i63 >> 2] = d44;
 HEAPF32[i10 + 100 >> 2] = 0.0;
 i64 = i10 + 104 | 0;
 HEAPF32[i64 >> 2] = d17 * d21 + d20 * d18 + d23 * d16;
 i65 = i10 + 108 | 0;
 HEAPF32[i65 >> 2] = d26 * d21 + d28 * d18 + d30 * d16;
 i66 = i10 + 112 | 0;
 HEAPF32[i66 >> 2] = d33 * d21 + d35 * d18 + d37 * d16;
 HEAPF32[i10 + 116 >> 2] = 0.0;
 i67 = i10 + 120 | 0;
 HEAP32[i67 >> 2] = 82;
 i68 = i10 + 124 | 0;
 HEAP32[i68 >> 2] = 0;
 HEAP32[i11 + 364 >> 2] = 0;
 _memset(i11 + 128 | 0, 0, 16);
 HEAP32[i11 + 376 >> 2] = 2;
 HEAP32[i11 + 368 >> 2] = 0;
 HEAPF32[i11 + 144 >> 2] = 0.0;
 i69 = __ZN12gjkepa2_impl3GJK8EvaluateERKNS_13MinkowskiDiffERK9btVector3(i11, i10, i5) | 0;
 if ((i69 | 0) != 0) {
  HEAP32[i13 >> 2] = (i69 | 0) == 1 ? 1 : 2;
  i70 = 0;
  STACKTOP = i7;
  return i70 | 0;
 }
 i69 = i11 + 372 | 0;
 i11 = HEAP32[i69 >> 2] | 0;
 if ((HEAP32[i11 + 32 >> 2] | 0) == 0) {
  d71 = 0.0;
  d72 = 0.0;
  d73 = 0.0;
  d74 = 0.0;
  d75 = 0.0;
  d76 = 0.0;
 } else {
  i13 = i12 | 0;
  i5 = i12 + 4 | 0;
  i10 = i12 + 8 | 0;
  i77 = i9 | 0;
  i78 = i9 + 4 | 0;
  i79 = i9 + 8 | 0;
  i80 = i9 + 12 | 0;
  i81 = i8 | 0;
  i82 = i8 + 4 | 0;
  i83 = i8 + 8 | 0;
  d16 = 0.0;
  d37 = 0.0;
  d18 = 0.0;
  d35 = 0.0;
  d21 = 0.0;
  d33 = 0.0;
  i84 = 0;
  i85 = i11;
  while (1) {
   d30 = +HEAPF32[i85 + 16 + (i84 << 2) >> 2];
   i11 = HEAP32[i67 >> 2] | 0;
   i86 = (HEAP32[i15 >> 2] | 0) + (HEAP32[i68 >> 2] | 0) | 0;
   if ((i11 & 1 | 0) == 0) {
    i87 = i11;
   } else {
    i87 = HEAP32[(HEAP32[i86 >> 2] | 0) + (i11 - 1) >> 2] | 0;
   }
   FUNCTION_TABLE_viii[i87 & 127](i12, i86, HEAP32[i85 + (i84 << 2) >> 2] | 0);
   d28 = d18 + d30 * +HEAPF32[i13 >> 2];
   d26 = d37 + d30 * +HEAPF32[i5 >> 2];
   d23 = d16 + d30 * +HEAPF32[i10 >> 2];
   i86 = HEAP32[(HEAP32[i69 >> 2] | 0) + (i84 << 2) >> 2] | 0;
   d20 = -0.0 - +HEAPF32[i86 >> 2];
   d17 = -0.0 - +HEAPF32[i86 + 4 >> 2];
   d44 = -0.0 - +HEAPF32[i86 + 8 >> 2];
   i86 = HEAP32[i67 >> 2] | 0;
   i11 = (HEAP32[i1 >> 2] | 0) + (HEAP32[i68 >> 2] | 0) | 0;
   if ((i86 & 1 | 0) == 0) {
    i88 = i86;
   } else {
    i88 = HEAP32[(HEAP32[i11 >> 2] | 0) + (i86 - 1) >> 2] | 0;
   }
   d41 = +HEAPF32[i48 >> 2] * d20 + +HEAPF32[i49 >> 2] * d17 + +HEAPF32[i50 >> 2] * d44;
   d38 = +HEAPF32[i51 >> 2] * d20 + +HEAPF32[i52 >> 2] * d17 + +HEAPF32[i53 >> 2] * d44;
   HEAPF32[i77 >> 2] = +HEAPF32[i45 >> 2] * d20 + +HEAPF32[i46 >> 2] * d17 + +HEAPF32[i47 >> 2] * d44;
   HEAPF32[i78 >> 2] = d41;
   HEAPF32[i79 >> 2] = d38;
   HEAPF32[i80 >> 2] = 0.0;
   FUNCTION_TABLE_viii[i88 & 127](i8, i11, i9);
   d38 = +HEAPF32[i81 >> 2];
   d41 = +HEAPF32[i82 >> 2];
   d44 = +HEAPF32[i83 >> 2];
   d17 = d33 + d30 * (+HEAPF32[i64 >> 2] + (+HEAPF32[i4 >> 2] * d38 + +HEAPF32[i2 >> 2] * d41 + +HEAPF32[i57 >> 2] * d44));
   d20 = d21 + d30 * (+HEAPF32[i65 >> 2] + (d38 * +HEAPF32[i58 >> 2] + d41 * +HEAPF32[i59 >> 2] + d44 * +HEAPF32[i60 >> 2]));
   d43 = d35 + d30 * (+HEAPF32[i66 >> 2] + (d38 * +HEAPF32[i61 >> 2] + d41 * +HEAPF32[i62 >> 2] + d44 * +HEAPF32[i63 >> 2]));
   i11 = i84 + 1 | 0;
   i86 = HEAP32[i69 >> 2] | 0;
   if (i11 >>> 0 < (HEAP32[i86 + 32 >> 2] | 0) >>> 0) {
    d16 = d23;
    d37 = d26;
    d18 = d28;
    d35 = d43;
    d21 = d20;
    d33 = d17;
    i84 = i11;
    i85 = i86;
   } else {
    d71 = d23;
    d72 = d26;
    d73 = d28;
    d74 = d43;
    d75 = d20;
    d76 = d17;
    break;
   }
  }
 }
 d33 = +HEAPF32[i55 >> 2] + (d73 * +HEAPF32[i19 >> 2] + d72 * +HEAPF32[i27 >> 2] + d71 * +HEAPF32[i34 >> 2]);
 d21 = +HEAPF32[i56 >> 2] + (d73 * +HEAPF32[i22 >> 2] + d72 * +HEAPF32[i29 >> 2] + d71 * +HEAPF32[i36 >> 2]);
 HEAPF32[i6 + 4 >> 2] = +HEAPF32[i54 >> 2] + (d73 * +HEAPF32[i3 >> 2] + d72 * +HEAPF32[i25 >> 2] + d71 * +HEAPF32[i32 >> 2]);
 HEAPF32[i6 + 8 >> 2] = d33;
 HEAPF32[i6 + 12 >> 2] = d21;
 HEAPF32[i6 + 16 >> 2] = 0.0;
 d21 = +HEAPF32[i55 >> 2] + (d76 * +HEAPF32[i19 >> 2] + d75 * +HEAPF32[i27 >> 2] + d74 * +HEAPF32[i34 >> 2]);
 d33 = +HEAPF32[i56 >> 2] + (d76 * +HEAPF32[i22 >> 2] + d75 * +HEAPF32[i29 >> 2] + d74 * +HEAPF32[i36 >> 2]);
 HEAPF32[i14 >> 2] = +HEAPF32[i54 >> 2] + (d76 * +HEAPF32[i3 >> 2] + d75 * +HEAPF32[i25 >> 2] + d74 * +HEAPF32[i32 >> 2]);
 HEAPF32[i6 + 24 >> 2] = d21;
 HEAPF32[i6 + 28 >> 2] = d33;
 HEAPF32[i6 + 32 >> 2] = 0.0;
 d33 = d73 - d76;
 d76 = d72 - d75;
 d75 = d71 - d74;
 HEAPF32[i6 + 48 >> 2] = 0.0;
 d74 = +Math_sqrt(+(d33 * d33 + d76 * d76 + d75 * d75));
 HEAPF32[i6 + 52 >> 2] = d74;
 d71 = 1.0 / (d74 > 9999999747378752.0e-20 ? d74 : 1.0);
 HEAPF32[i6 + 36 >> 2] = d33 * d71;
 HEAPF32[i6 + 40 >> 2] = d76 * d71;
 HEAPF32[i6 + 44 >> 2] = d75 * d71;
 i70 = 1;
 STACKTOP = i7;
 return i70 | 0;
}
function __ZN27btPolyhedralContactClipping18findSeparatingAxisERK18btConvexPolyhedronS2_RK11btTransformS5_R9btVector3(i1, i2, i3, i4, i5) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 var i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, d30 = 0.0, i31 = 0, i32 = 0, d33 = 0.0, d34 = 0.0, d35 = 0.0, d36 = 0.0, d37 = 0.0, i38 = 0, d39 = 0.0, d40 = 0.0, d41 = 0.0, d42 = 0.0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, d54 = 0.0, d55 = 0.0, i56 = 0, d57 = 0.0, i58 = 0, d59 = 0.0, i60 = 0, i61 = 0;
 i6 = STACKTOP;
 STACKTOP = STACKTOP + 72 | 0;
 i7 = i6 | 0;
 i8 = i6 + 16 | 0;
 i9 = i6 + 24 | 0;
 i10 = i6 + 40 | 0;
 i11 = i6 + 48 | 0;
 i12 = i6 + 64 | 0;
 HEAP32[3576] = (HEAP32[3576] | 0) + 1;
 i13 = HEAP32[i1 + 28 >> 2] | 0;
 L433 : do {
  if ((i13 | 0) > 0) {
   i14 = i1 + 36 | 0;
   i15 = i3 | 0;
   i16 = i3 + 4 | 0;
   i17 = i3 + 8 | 0;
   i18 = i3 + 16 | 0;
   i19 = i3 + 20 | 0;
   i20 = i3 + 24 | 0;
   i21 = i3 + 32 | 0;
   i22 = i3 + 36 | 0;
   i23 = i3 + 40 | 0;
   i24 = i7 | 0;
   i25 = i7 + 4 | 0;
   i26 = i7 + 8 | 0;
   i27 = i7 + 12 | 0;
   i28 = i5;
   i29 = i7;
   d30 = 3.4028234663852886e+38;
   i31 = 0;
   while (1) {
    i32 = HEAP32[i14 >> 2] | 0;
    d33 = +HEAPF32[i32 + (i31 * 56 | 0) + 40 >> 2];
    d34 = +HEAPF32[i32 + (i31 * 56 | 0) + 44 >> 2];
    d35 = +HEAPF32[i32 + (i31 * 56 | 0) + 48 >> 2];
    d36 = d33 * +HEAPF32[i18 >> 2] + d34 * +HEAPF32[i19 >> 2] + d35 * +HEAPF32[i20 >> 2];
    d37 = d33 * +HEAPF32[i21 >> 2] + d34 * +HEAPF32[i22 >> 2] + d35 * +HEAPF32[i23 >> 2];
    HEAPF32[i24 >> 2] = d33 * +HEAPF32[i15 >> 2] + d34 * +HEAPF32[i16 >> 2] + d35 * +HEAPF32[i17 >> 2];
    HEAPF32[i25 >> 2] = d36;
    HEAPF32[i26 >> 2] = d37;
    HEAPF32[i27 >> 2] = 0.0;
    if (!(__ZL11TestSepAxisRK18btConvexPolyhedronS1_RK11btTransformS4_RK9btVector3Rf(i1, i2, i3, i4, i7, i8) | 0)) {
     i38 = 0;
     break;
    }
    d37 = +HEAPF32[i8 >> 2];
    if (d37 < d30) {
     HEAP32[i28 >> 2] = HEAP32[i29 >> 2];
     HEAP32[i28 + 4 >> 2] = HEAP32[i29 + 4 >> 2];
     HEAP32[i28 + 8 >> 2] = HEAP32[i29 + 8 >> 2];
     HEAP32[i28 + 12 >> 2] = HEAP32[i29 + 12 >> 2];
     d39 = d37;
    } else {
     d39 = d30;
    }
    i32 = i31 + 1 | 0;
    if ((i32 | 0) < (i13 | 0)) {
     d30 = d39;
     i31 = i32;
    } else {
     d40 = d39;
     break L433;
    }
   }
   STACKTOP = i6;
   return i38 | 0;
  } else {
   d40 = 3.4028234663852886e+38;
  }
 } while (0);
 i13 = HEAP32[i2 + 28 >> 2] | 0;
 L443 : do {
  if ((i13 | 0) > 0) {
   i8 = i2 + 36 | 0;
   i7 = i4 | 0;
   i31 = i4 + 4 | 0;
   i29 = i4 + 8 | 0;
   i28 = i4 + 16 | 0;
   i27 = i4 + 20 | 0;
   i26 = i4 + 24 | 0;
   i25 = i4 + 32 | 0;
   i17 = i4 + 36 | 0;
   i16 = i4 + 40 | 0;
   i15 = i9 | 0;
   i24 = i9 + 4 | 0;
   i23 = i9 + 8 | 0;
   i22 = i9 + 12 | 0;
   i21 = i5;
   i20 = i9;
   d39 = d40;
   i19 = 0;
   while (1) {
    i18 = HEAP32[i8 >> 2] | 0;
    d30 = +HEAPF32[i18 + (i19 * 56 | 0) + 40 >> 2];
    d37 = +HEAPF32[i18 + (i19 * 56 | 0) + 44 >> 2];
    d36 = +HEAPF32[i18 + (i19 * 56 | 0) + 48 >> 2];
    d35 = d30 * +HEAPF32[i28 >> 2] + d37 * +HEAPF32[i27 >> 2] + d36 * +HEAPF32[i26 >> 2];
    d34 = d30 * +HEAPF32[i25 >> 2] + d37 * +HEAPF32[i17 >> 2] + d36 * +HEAPF32[i16 >> 2];
    HEAPF32[i15 >> 2] = d30 * +HEAPF32[i7 >> 2] + d37 * +HEAPF32[i31 >> 2] + d36 * +HEAPF32[i29 >> 2];
    HEAPF32[i24 >> 2] = d35;
    HEAPF32[i23 >> 2] = d34;
    HEAPF32[i22 >> 2] = 0.0;
    if (!(__ZL11TestSepAxisRK18btConvexPolyhedronS1_RK11btTransformS4_RK9btVector3Rf(i1, i2, i3, i4, i9, i10) | 0)) {
     i38 = 0;
     break;
    }
    d34 = +HEAPF32[i10 >> 2];
    if (d34 < d39) {
     HEAP32[i21 >> 2] = HEAP32[i20 >> 2];
     HEAP32[i21 + 4 >> 2] = HEAP32[i20 + 4 >> 2];
     HEAP32[i21 + 8 >> 2] = HEAP32[i20 + 8 >> 2];
     HEAP32[i21 + 12 >> 2] = HEAP32[i20 + 12 >> 2];
     d41 = d34;
    } else {
     d41 = d39;
    }
    i18 = i19 + 1 | 0;
    if ((i18 | 0) < (i13 | 0)) {
     d39 = d41;
     i19 = i18;
    } else {
     d42 = d41;
     break L443;
    }
   }
   STACKTOP = i6;
   return i38 | 0;
  } else {
   d42 = d40;
  }
 } while (0);
 i13 = i1 + 48 | 0;
 i10 = HEAP32[i13 >> 2] | 0;
 L453 : do {
  if ((i10 | 0) > 0) {
   i9 = i1 + 56 | 0;
   i19 = i3 | 0;
   i20 = i3 + 4 | 0;
   i21 = i3 + 8 | 0;
   i22 = i3 + 16 | 0;
   i23 = i3 + 20 | 0;
   i24 = i3 + 24 | 0;
   i29 = i3 + 32 | 0;
   i31 = i3 + 36 | 0;
   i7 = i3 + 40 | 0;
   i15 = i2 + 48 | 0;
   i16 = i2 + 56 | 0;
   i17 = i4 | 0;
   i25 = i4 + 4 | 0;
   i26 = i4 + 8 | 0;
   i27 = i4 + 16 | 0;
   i28 = i4 + 20 | 0;
   i8 = i4 + 24 | 0;
   i18 = i4 + 32 | 0;
   i14 = i4 + 36 | 0;
   i32 = i4 + 40 | 0;
   i43 = i11 | 0;
   i44 = i11 + 4 | 0;
   i45 = i11 + 8 | 0;
   i46 = i11 + 12 | 0;
   i47 = i11;
   i48 = i5;
   d40 = d42;
   i49 = 0;
   i50 = HEAP32[i15 >> 2] | 0;
   i51 = i10;
   L455 : while (1) {
    i52 = HEAP32[i9 >> 2] | 0;
    d41 = +HEAPF32[i52 + (i49 << 4) >> 2];
    d39 = +HEAPF32[i52 + (i49 << 4) + 4 >> 2];
    d34 = +HEAPF32[i52 + (i49 << 4) + 8 >> 2];
    d35 = d41 * +HEAPF32[i19 >> 2] + d39 * +HEAPF32[i20 >> 2] + d34 * +HEAPF32[i21 >> 2];
    d36 = d41 * +HEAPF32[i22 >> 2] + d39 * +HEAPF32[i23 >> 2] + d34 * +HEAPF32[i24 >> 2];
    d37 = d41 * +HEAPF32[i29 >> 2] + d39 * +HEAPF32[i31 >> 2] + d34 * +HEAPF32[i7 >> 2];
    if ((i50 | 0) > 0) {
     d34 = d40;
     i52 = 0;
     while (1) {
      i53 = HEAP32[i16 >> 2] | 0;
      d39 = +HEAPF32[i53 + (i52 << 4) >> 2];
      d41 = +HEAPF32[i53 + (i52 << 4) + 4 >> 2];
      d30 = +HEAPF32[i53 + (i52 << 4) + 8 >> 2];
      d33 = d39 * +HEAPF32[i17 >> 2] + d41 * +HEAPF32[i25 >> 2] + d30 * +HEAPF32[i26 >> 2];
      d54 = d39 * +HEAPF32[i27 >> 2] + d41 * +HEAPF32[i28 >> 2] + d30 * +HEAPF32[i8 >> 2];
      d55 = d39 * +HEAPF32[i18 >> 2] + d41 * +HEAPF32[i14 >> 2] + d30 * +HEAPF32[i32 >> 2];
      d30 = d36 * d55 - d37 * d54;
      d41 = d37 * d33 - d35 * d55;
      d55 = d35 * d54 - d36 * d33;
      HEAPF32[i43 >> 2] = d30;
      HEAPF32[i44 >> 2] = d41;
      HEAPF32[i45 >> 2] = d55;
      HEAPF32[i46 >> 2] = 0.0;
      do {
       if (+Math_abs(+d30) > 1.0e-6) {
        i56 = 339;
       } else {
        if (+Math_abs(+d41) > 1.0e-6) {
         i56 = 339;
         break;
        }
        if (+Math_abs(+d55) > 1.0e-6) {
         i56 = 339;
        } else {
         d57 = d34;
        }
       }
      } while (0);
      do {
       if ((i56 | 0) == 339) {
        i56 = 0;
        d33 = 1.0 / +Math_sqrt(+(d55 * d55 + (d30 * d30 + d41 * d41)));
        HEAPF32[i43 >> 2] = d30 * d33;
        HEAPF32[i44 >> 2] = d41 * d33;
        HEAPF32[i45 >> 2] = d55 * d33;
        if (!(__ZL11TestSepAxisRK18btConvexPolyhedronS1_RK11btTransformS4_RK9btVector3Rf(i1, i2, i3, i4, i11, i12) | 0)) {
         i38 = 0;
         break L455;
        }
        d33 = +HEAPF32[i12 >> 2];
        if (d33 >= d34) {
         d57 = d34;
         break;
        }
        HEAP32[i48 >> 2] = HEAP32[i47 >> 2];
        HEAP32[i48 + 4 >> 2] = HEAP32[i47 + 4 >> 2];
        HEAP32[i48 + 8 >> 2] = HEAP32[i47 + 8 >> 2];
        HEAP32[i48 + 12 >> 2] = HEAP32[i47 + 12 >> 2];
        d57 = d33;
       }
      } while (0);
      i53 = i52 + 1 | 0;
      i58 = HEAP32[i15 >> 2] | 0;
      if ((i53 | 0) < (i58 | 0)) {
       d34 = d57;
       i52 = i53;
      } else {
       break;
      }
     }
     d59 = d57;
     i60 = i58;
     i61 = HEAP32[i13 >> 2] | 0;
    } else {
     d59 = d40;
     i60 = i50;
     i61 = i51;
    }
    i52 = i49 + 1 | 0;
    if ((i52 | 0) < (i61 | 0)) {
     d40 = d59;
     i49 = i52;
     i50 = i60;
     i51 = i61;
    } else {
     break L453;
    }
   }
   STACKTOP = i6;
   return i38 | 0;
  }
 } while (0);
 i61 = i5 | 0;
 d59 = +HEAPF32[i61 >> 2];
 i60 = i5 + 4 | 0;
 d57 = +HEAPF32[i60 >> 2];
 i13 = i5 + 8 | 0;
 d42 = +HEAPF32[i13 >> 2];
 if ((+HEAPF32[i4 + 48 >> 2] - +HEAPF32[i3 + 48 >> 2]) * d59 + (+HEAPF32[i4 + 52 >> 2] - +HEAPF32[i3 + 52 >> 2]) * d57 + (+HEAPF32[i4 + 56 >> 2] - +HEAPF32[i3 + 56 >> 2]) * d42 <= 0.0) {
  i38 = 1;
  STACKTOP = i6;
  return i38 | 0;
 }
 HEAPF32[i61 >> 2] = -0.0 - d59;
 HEAPF32[i60 >> 2] = -0.0 - d57;
 HEAPF32[i13 >> 2] = -0.0 - d42;
 HEAPF32[i5 + 12 >> 2] = 0.0;
 i38 = 1;
 STACKTOP = i6;
 return i38 | 0;
}
function runPostSets() {
 HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE + 8 >> 2] = 6;
 HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE + 12 >> 2] = 192;
 HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE + 16 >> 2] = 74;
 HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE + 20 >> 2] = 214;
 HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE + 24 >> 2] = 4;
 HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE + 28 >> 2] = 4;
 HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE + 32 >> 2] = 10;
 HEAP32[__ZTVN10__cxxabiv120__si_class_type_infoE + 36 >> 2] = 22;
 HEAP32[__ZTVN10__cxxabiv117__class_type_infoE + 8 >> 2] = 6;
 HEAP32[__ZTVN10__cxxabiv117__class_type_infoE + 12 >> 2] = 348;
 HEAP32[__ZTVN10__cxxabiv117__class_type_infoE + 16 >> 2] = 74;
 HEAP32[__ZTVN10__cxxabiv117__class_type_infoE + 20 >> 2] = 214;
 HEAP32[__ZTVN10__cxxabiv117__class_type_infoE + 24 >> 2] = 4;
 HEAP32[__ZTVN10__cxxabiv117__class_type_infoE + 28 >> 2] = 10;
 HEAP32[__ZTVN10__cxxabiv117__class_type_infoE + 32 >> 2] = 8;
 HEAP32[__ZTVN10__cxxabiv117__class_type_infoE + 36 >> 2] = 42;
 HEAP32[2584] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2588] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2592] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2596] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2600] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2604] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2608] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2612] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2616] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2620] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2624] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2628] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2632] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2636] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2640] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2644] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2646] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2648] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2652] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2654] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2656] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2660] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2664] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2668] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2672] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2676] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2680] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2684] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2688] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2690] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2694] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2698] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2702] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2704] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2706] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2708] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2712] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2716] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2720] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2724] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2726] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2730] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2734] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2738] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2742] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2746] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2750] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2752] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2756] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2760] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2764] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2766] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2768] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2772] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2776] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2780] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2784] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2788] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2792] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2796] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2798] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2800] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2804] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2808] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2810] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2812] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2816] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2820] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2824] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2828] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2832] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2836] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2840] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2844] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2848] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2852] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2854] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2858] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2862] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2864] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2868] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2870] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2874] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2878] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2882] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2884] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2888] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2890] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2892] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2894] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2898] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2908] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2912] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2916] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2920] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2924] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2926] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2928] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2932] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2936] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2940] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2944] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2948] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2950] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2954] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2956] = __ZTVN10__cxxabiv117__class_type_infoE + 8;
 HEAP32[2958] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
 HEAP32[2962] = __ZTVN10__cxxabiv120__si_class_type_infoE + 8;
}
function __ZN27btPolyhedralContactClipping19clipFaceAgainstHullERK9btVector3RK18btConvexPolyhedronRK11btTransformR20btAlignedObjectArrayIS0_EffRN36btDiscreteCollisionDetectorInterface6ResultE(i1, i2, i3, i4, d5, d6, i7) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 d5 = +d5;
 d6 = +d6;
 i7 = i7 | 0;
 var i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, d20 = 0.0, i21 = 0, d22 = 0.0, i23 = 0, d24 = 0.0, i25 = 0, d26 = 0.0, i27 = 0, d28 = 0.0, i29 = 0, d30 = 0.0, i31 = 0, d32 = 0.0, i33 = 0, d34 = 0.0, i35 = 0, d36 = 0.0, d37 = 0.0, d38 = 0.0, d39 = 0.0, i40 = 0, d41 = 0.0, i42 = 0, d43 = 0.0, d44 = 0.0, d45 = 0.0, d46 = 0.0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, d61 = 0.0, i62 = 0, d63 = 0.0, d64 = 0.0, d65 = 0.0, d66 = 0.0, d67 = 0.0, d68 = 0.0, d69 = 0.0, i70 = 0, i71 = 0, i72 = 0, i73 = 0, i74 = 0, i75 = 0, i76 = 0, i77 = 0, i78 = 0, i79 = 0, d80 = 0.0, d81 = 0.0, d82 = 0.0, d83 = 0.0, d84 = 0.0, d85 = 0.0, d86 = 0.0, d87 = 0.0, d88 = 0.0, i89 = 0;
 i8 = STACKTOP;
 STACKTOP = STACKTOP + 72 | 0;
 i9 = i8 | 0;
 i10 = i8 + 24 | 0;
 i11 = i8 + 40 | 0;
 i12 = i8 + 56 | 0;
 i13 = i9 + 16 | 0;
 HEAP8[i13] = 1;
 i14 = i9 + 12 | 0;
 HEAP32[i14 >> 2] = 0;
 HEAP32[i9 + 4 >> 2] = 0;
 i15 = i9 + 8 | 0;
 HEAP32[i15 >> 2] = 0;
 i16 = HEAP32[i4 + 4 >> 2] | 0;
 if ((i16 | 0) > 0) {
  i17 = __Z22btAlignedAllocInternalji(i16 << 4, 16) | 0;
  HEAP8[i13] = 1;
  HEAP32[i14 >> 2] = i17;
  HEAP32[i15 >> 2] = i16;
  i18 = i17;
 } else {
  i18 = 0;
 }
 i17 = HEAP32[i2 + 28 >> 2] | 0;
 do {
  if ((i17 | 0) > 0) {
   i16 = i2 + 36 | 0;
   i15 = HEAP32[i16 >> 2] | 0;
   i19 = i3 | 0;
   d20 = +HEAPF32[i19 >> 2];
   i21 = i3 + 4 | 0;
   d22 = +HEAPF32[i21 >> 2];
   i23 = i3 + 8 | 0;
   d24 = +HEAPF32[i23 >> 2];
   i25 = i3 + 16 | 0;
   d26 = +HEAPF32[i25 >> 2];
   i27 = i3 + 20 | 0;
   d28 = +HEAPF32[i27 >> 2];
   i29 = i3 + 24 | 0;
   d30 = +HEAPF32[i29 >> 2];
   i31 = i3 + 32 | 0;
   d32 = +HEAPF32[i31 >> 2];
   i33 = i3 + 36 | 0;
   d34 = +HEAPF32[i33 >> 2];
   i35 = i3 + 40 | 0;
   d36 = +HEAPF32[i35 >> 2];
   d37 = +HEAPF32[i1 >> 2];
   d38 = +HEAPF32[i1 + 4 >> 2];
   d39 = +HEAPF32[i1 + 8 >> 2];
   i40 = 0;
   d41 = 3.4028234663852886e+38;
   i42 = -1;
   while (1) {
    d43 = +HEAPF32[i15 + (i40 * 56 | 0) + 40 >> 2];
    d44 = +HEAPF32[i15 + (i40 * 56 | 0) + 44 >> 2];
    d45 = +HEAPF32[i15 + (i40 * 56 | 0) + 48 >> 2];
    d46 = d39 * (d32 * d43 + d34 * d44 + d36 * d45) + (d37 * (d20 * d43 + d22 * d44 + d24 * d45) + d38 * (d26 * d43 + d28 * d44 + d30 * d45));
    i47 = d46 < d41;
    i48 = i47 ? i40 : i42;
    i49 = i40 + 1 | 0;
    if ((i49 | 0) < (i17 | 0)) {
     i40 = i49;
     d41 = i47 ? d46 : d41;
     i42 = i48;
    } else {
     break;
    }
   }
   if ((i48 | 0) < 0) {
    i50 = i18;
    break;
   }
   i42 = HEAP32[i15 + (i48 * 56 | 0) + 4 >> 2] | 0;
   if ((i42 | 0) > 0) {
    i40 = i15 + (i48 * 56 | 0) + 32 | 0;
    i47 = i10 | 0;
    i49 = i10 + 4 | 0;
    i51 = i10 + 8 | 0;
    i52 = i10 + 12 | 0;
    i53 = i3 + 48 | 0;
    i54 = i3 + 52 | 0;
    i55 = i3 + 56 | 0;
    i56 = i11;
    i57 = i4;
    i58 = i9;
    i59 = 0;
    i60 = i15;
    d41 = d20;
    d38 = d22;
    d37 = d24;
    d39 = d26;
    d46 = d28;
    d45 = d30;
    d44 = d32;
    d43 = d34;
    d61 = d36;
    while (1) {
     i62 = HEAP32[(HEAP32[i40 >> 2] | 0) + (i59 << 2) >> 2] | 0;
     d63 = +HEAPF32[i60 + (i62 * 56 | 0) + 40 >> 2];
     d64 = +HEAPF32[i60 + (i62 * 56 | 0) + 44 >> 2];
     d65 = +HEAPF32[i60 + (i62 * 56 | 0) + 48 >> 2];
     d66 = +HEAPF32[i60 + (i62 * 56 | 0) + 52 >> 2];
     d67 = d63 * d41 + d64 * d38 + d65 * d37;
     d68 = d63 * d39 + d64 * d46 + d65 * d45;
     d69 = d63 * d44 + d64 * d43 + d65 * d61;
     HEAPF32[i47 >> 2] = d67;
     HEAPF32[i49 >> 2] = d68;
     HEAPF32[i51 >> 2] = d69;
     HEAPF32[i52 >> 2] = 0.0;
     __ZN27btPolyhedralContactClipping8clipFaceERK20btAlignedObjectArrayI9btVector3ERS2_RKS1_f(i57, i58, i10, d66 - (d67 * +HEAPF32[i53 >> 2] + d68 * +HEAPF32[i54 >> 2] + d69 * +HEAPF32[i55 >> 2]));
     i62 = i57 + 4 | 0;
     i70 = HEAP32[i62 >> 2] | 0;
     if ((i70 | 0) < 0) {
      i71 = i57 + 8 | 0;
      i72 = i57 + 12 | 0;
      if ((HEAP32[i71 >> 2] | 0) < 0) {
       i73 = HEAP32[i72 >> 2] | 0;
       i74 = i57 + 16 | 0;
       if ((i73 | 0) != 0) {
        if ((HEAP8[i74] | 0) != 0) {
         __Z21btAlignedFreeInternalPv(i73);
        }
        HEAP32[i72 >> 2] = 0;
       }
       HEAP8[i74] = 1;
       HEAP32[i72 >> 2] = 0;
       HEAP32[i71 >> 2] = 0;
       i75 = i70;
      } else {
       i75 = i70;
      }
      do {
       i70 = (HEAP32[i72 >> 2] | 0) + (i75 << 4) | 0;
       if ((i70 | 0) != 0) {
        i71 = i70;
        HEAP32[i71 >> 2] = HEAP32[i56 >> 2];
        HEAP32[i71 + 4 >> 2] = HEAP32[i56 + 4 >> 2];
        HEAP32[i71 + 8 >> 2] = HEAP32[i56 + 8 >> 2];
        HEAP32[i71 + 12 >> 2] = HEAP32[i56 + 12 >> 2];
       }
       i75 = i75 + 1 | 0;
      } while ((i75 | 0) < 0);
     }
     HEAP32[i62 >> 2] = 0;
     i72 = i59 + 1 | 0;
     if ((i72 | 0) >= (i42 | 0)) {
      break;
     }
     i71 = i57;
     i57 = i58;
     i59 = i72;
     i60 = HEAP32[i16 >> 2] | 0;
     d41 = +HEAPF32[i19 >> 2];
     d38 = +HEAPF32[i21 >> 2];
     d37 = +HEAPF32[i23 >> 2];
     d39 = +HEAPF32[i25 >> 2];
     d46 = +HEAPF32[i27 >> 2];
     d45 = +HEAPF32[i29 >> 2];
     d44 = +HEAPF32[i31 >> 2];
     d43 = +HEAPF32[i33 >> 2];
     d61 = +HEAPF32[i35 >> 2];
     i58 = i71;
    }
    i76 = i58;
    i77 = i53;
    i78 = i54;
    i79 = i55;
    d80 = +HEAPF32[i19 >> 2];
    d81 = +HEAPF32[i21 >> 2];
    d82 = +HEAPF32[i23 >> 2];
    d83 = +HEAPF32[i25 >> 2];
    d84 = +HEAPF32[i27 >> 2];
    d85 = +HEAPF32[i29 >> 2];
    d86 = +HEAPF32[i31 >> 2];
    d87 = +HEAPF32[i33 >> 2];
    d88 = +HEAPF32[i35 >> 2];
   } else {
    i76 = i4;
    i77 = i3 + 48 | 0;
    i78 = i3 + 52 | 0;
    i79 = i3 + 56 | 0;
    d80 = d20;
    d81 = d22;
    d82 = d24;
    d83 = d26;
    d84 = d28;
    d85 = d30;
    d86 = d32;
    d87 = d34;
    d88 = d36;
   }
   d61 = +HEAPF32[i15 + (i48 * 56 | 0) + 40 >> 2];
   d43 = +HEAPF32[i15 + (i48 * 56 | 0) + 44 >> 2];
   d44 = +HEAPF32[i15 + (i48 * 56 | 0) + 48 >> 2];
   d45 = d61 * d80 + d43 * d81 + d44 * d82;
   d46 = d61 * d83 + d43 * d84 + d44 * d85;
   d39 = d61 * d86 + d43 * d87 + d44 * d88;
   d44 = +HEAPF32[i15 + (i48 * 56 | 0) + 52 >> 2] - (d45 * +HEAPF32[i77 >> 2] + d46 * +HEAPF32[i78 >> 2] + d39 * +HEAPF32[i79 >> 2]);
   i16 = i76 + 4 | 0;
   i60 = HEAP32[i16 >> 2] | 0;
   if ((i60 | 0) > 0) {
    i59 = i76 + 12 | 0;
    i57 = i12;
    i42 = i7;
    i56 = 0;
    i52 = i60;
    while (1) {
     i60 = HEAP32[i59 >> 2] | 0;
     i51 = i60 + (i56 << 4) | 0;
     d43 = d44 + (d45 * +HEAPF32[i51 >> 2] + d46 * +HEAPF32[i60 + (i56 << 4) + 4 >> 2] + d39 * +HEAPF32[i60 + (i56 << 4) + 8 >> 2]);
     if (d43 > d6 | d43 < d5) {
      i89 = i52;
     } else {
      i60 = i51;
      HEAP32[i57 >> 2] = HEAP32[i60 >> 2];
      HEAP32[i57 + 4 >> 2] = HEAP32[i60 + 4 >> 2];
      HEAP32[i57 + 8 >> 2] = HEAP32[i60 + 8 >> 2];
      HEAP32[i57 + 12 >> 2] = HEAP32[i60 + 12 >> 2];
      FUNCTION_TABLE_viiif[HEAP32[(HEAP32[i42 >> 2] | 0) + 16 >> 2] & 15](i7, i1, i12, d43);
      i89 = HEAP32[i16 >> 2] | 0;
     }
     i60 = i56 + 1 | 0;
     if ((i60 | 0) < (i89 | 0)) {
      i56 = i60;
      i52 = i89;
     } else {
      break;
     }
    }
   }
   i50 = HEAP32[i14 >> 2] | 0;
  } else {
   i50 = i18;
  }
 } while (0);
 if ((i50 | 0) == 0) {
  STACKTOP = i8;
  return;
 }
 if ((HEAP8[i13] | 0) != 0) {
  __Z21btAlignedFreeInternalPv(i50);
 }
 HEAP32[i14 >> 2] = 0;
 STACKTOP = i8;
 return;
}
function __ZNK13btConvexShape44localGetSupportVertexWithoutMarginNonVirtualERK9btVector3(i1, i2, i3) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 var i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, d11 = 0.0, d12 = 0.0, d13 = 0.0, d14 = 0.0, i15 = 0, d16 = 0.0, d17 = 0.0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, d22 = 0.0, d23 = 0.0, d24 = 0.0, i25 = 0, d26 = 0.0, d27 = 0.0, d28 = 0.0, d29 = 0.0, d30 = 0.0, d31 = 0.0, d32 = 0.0, d33 = 0.0, d34 = 0.0, i35 = 0;
 i4 = STACKTOP;
 STACKTOP = STACKTOP + 80 | 0;
 i5 = i4 | 0;
 i6 = i4 + 16 | 0;
 i7 = i4 + 32 | 0;
 i8 = i4 + 48 | 0;
 i9 = i4 + 64 | 0;
 switch (HEAP32[i2 + 4 >> 2] | 0) {
 case 8:
  {
   _memset(i1 | 0, 0, 16);
   STACKTOP = i4;
   return;
  }
 case 0:
  {
   i10 = i2 + 28 | 0;
   d11 = +HEAPF32[i10 >> 2];
   d12 = +HEAPF32[i10 + 4 >> 2];
   d13 = +HEAPF32[i3 + 4 >> 2] >= 0.0 ? d12 : -0.0 - d12;
   d12 = +HEAPF32[i10 + 8 >> 2];
   d14 = +HEAPF32[i3 + 8 >> 2] >= 0.0 ? d12 : -0.0 - d12;
   HEAPF32[i1 >> 2] = +HEAPF32[i3 >> 2] >= 0.0 ? d11 : -0.0 - d11;
   HEAPF32[i1 + 4 >> 2] = d13;
   HEAPF32[i1 + 8 >> 2] = d14;
   HEAPF32[i1 + 12 >> 2] = 0.0;
   STACKTOP = i4;
   return;
  }
 case 1:
  {
   d14 = +HEAPF32[i3 >> 2];
   d13 = +HEAPF32[i3 + 4 >> 2];
   d11 = +HEAPF32[i3 + 8 >> 2];
   i10 = i2 + 56 | 0;
   i15 = i10;
   d12 = d14 * +HEAPF32[i10 >> 2] + d13 * +HEAPF32[i10 + 4 >> 2] + d11 * +HEAPF32[i10 + 8 >> 2];
   d16 = d14 * +HEAPF32[i10 + 16 >> 2] + d13 * +HEAPF32[i10 + 20 >> 2] + d11 * +HEAPF32[i10 + 24 >> 2];
   d17 = d14 * +HEAPF32[i10 + 32 >> 2] + d13 * +HEAPF32[i10 + 36 >> 2] + d11 * +HEAPF32[i10 + 40 >> 2];
   if (d12 < d16) {
    i18 = d16 < d17 ? 2 : 1;
   } else {
    i18 = d12 < d17 ? 2 : 0;
   }
   d17 = +HEAPF32[i15 + (i18 << 4) + 4 >> 2];
   d12 = +HEAPF32[i15 + (i18 << 4) + 8 >> 2];
   HEAPF32[i1 >> 2] = +HEAPF32[i15 + (i18 << 4) >> 2];
   HEAPF32[i1 + 4 >> 2] = d17;
   HEAPF32[i1 + 8 >> 2] = d12;
   HEAPF32[i1 + 12 >> 2] = 0.0;
   STACKTOP = i4;
   return;
  }
 case 13:
  {
   i18 = i5;
   i15 = i2 + 28 | 0;
   HEAP32[i18 >> 2] = HEAP32[i15 >> 2];
   HEAP32[i18 + 4 >> 2] = HEAP32[i15 + 4 >> 2];
   HEAP32[i18 + 8 >> 2] = HEAP32[i15 + 8 >> 2];
   HEAP32[i18 + 12 >> 2] = HEAP32[i15 + 12 >> 2];
   HEAPF32[i6 >> 2] = +HEAPF32[i3 >> 2];
   d12 = +HEAPF32[i3 + 4 >> 2];
   HEAPF32[i6 + 4 >> 2] = d12;
   d17 = +HEAPF32[i3 + 8 >> 2];
   HEAPF32[i6 + 8 >> 2] = d17;
   HEAPF32[i6 + 12 >> 2] = 0.0;
   i15 = HEAP32[i2 + 52 >> 2] | 0;
   if ((i15 | 0) == 1) {
    i19 = 0;
    i20 = i15;
    i21 = 2;
    d22 = d17;
   } else if ((i15 | 0) == 2) {
    i19 = 0;
    i20 = i15;
    i21 = 1;
    d22 = d12;
   } else {
    i19 = 1;
    i20 = 0;
    i21 = 2;
    d22 = d17;
   }
   d17 = +HEAPF32[i5 + (i19 << 2) >> 2];
   d12 = +HEAPF32[i5 + (i15 << 2) >> 2];
   d16 = +HEAPF32[i6 + (i19 << 2) >> 2];
   d11 = +Math_sqrt(+(d22 * d22 + d16 * d16));
   if (d11 != 0.0) {
    d13 = d17 / d11;
    HEAPF32[i7 + (i19 << 2) >> 2] = d16 * d13;
    if (+HEAPF32[i6 + (i20 << 2) >> 2] < 0.0) {
     d23 = -0.0 - d12;
    } else {
     d23 = d12;
    }
    HEAPF32[i7 + (i20 << 2) >> 2] = d23;
    HEAPF32[i7 + (i21 << 2) >> 2] = d22 * d13;
    HEAPF32[i1 >> 2] = +HEAPF32[i7 >> 2];
    HEAPF32[i1 + 4 >> 2] = +HEAPF32[i7 + 4 >> 2];
    HEAPF32[i1 + 8 >> 2] = +HEAPF32[i7 + 8 >> 2];
    HEAPF32[i1 + 12 >> 2] = 0.0;
    STACKTOP = i4;
    return;
   } else {
    HEAPF32[i7 + (i19 << 2) >> 2] = d17;
    if (+HEAPF32[i6 + (i20 << 2) >> 2] < 0.0) {
     d24 = -0.0 - d12;
    } else {
     d24 = d12;
    }
    HEAPF32[i7 + (i20 << 2) >> 2] = d24;
    HEAPF32[i7 + (i21 << 2) >> 2] = 0.0;
    HEAPF32[i1 >> 2] = +HEAPF32[i7 >> 2];
    HEAPF32[i1 + 4 >> 2] = +HEAPF32[i7 + 4 >> 2];
    HEAPF32[i1 + 8 >> 2] = +HEAPF32[i7 + 8 >> 2];
    HEAPF32[i1 + 12 >> 2] = 0.0;
    STACKTOP = i4;
    return;
   }
   break;
  }
 case 5:
  {
   i7 = HEAP32[i2 + 92 >> 2] | 0;
   i21 = HEAP32[i2 + 96 >> 2] | 0;
   d24 = +HEAPF32[i2 + 12 >> 2];
   d12 = +HEAPF32[i3 >> 2] * d24;
   d17 = +HEAPF32[i2 + 16 >> 2];
   d13 = +HEAPF32[i3 + 4 >> 2] * d17;
   d22 = +HEAPF32[i2 + 20 >> 2];
   d23 = +HEAPF32[i3 + 8 >> 2] * d22;
   if ((i21 | 0) > 0) {
    d16 = -999999984306749400.0;
    i20 = -1;
    i6 = 0;
    while (1) {
     d11 = d12 * +HEAPF32[i7 + (i6 << 4) >> 2] + d13 * +HEAPF32[i7 + (i6 << 4) + 4 >> 2] + d23 * +HEAPF32[i7 + (i6 << 4) + 8 >> 2];
     i19 = d11 > d16;
     i15 = i19 ? i6 : i20;
     i5 = i6 + 1 | 0;
     if ((i5 | 0) < (i21 | 0)) {
      d16 = i19 ? d11 : d16;
      i20 = i15;
      i6 = i5;
     } else {
      i25 = i15;
      break;
     }
    }
   } else {
    i25 = -1;
   }
   d16 = d17 * +HEAPF32[i7 + (i25 << 4) + 4 >> 2];
   d17 = d22 * +HEAPF32[i7 + (i25 << 4) + 8 >> 2];
   HEAPF32[i1 >> 2] = d24 * +HEAPF32[i7 + (i25 << 4) >> 2];
   HEAPF32[i1 + 4 >> 2] = d16;
   HEAPF32[i1 + 8 >> 2] = d17;
   HEAPF32[i1 + 12 >> 2] = 0.0;
   STACKTOP = i4;
   return;
  }
 case 10:
  {
   d17 = +HEAPF32[i3 >> 2];
   d16 = +HEAPF32[i3 + 4 >> 2];
   d24 = +HEAPF32[i3 + 8 >> 2];
   i25 = i2;
   i7 = HEAP32[i2 + 52 >> 2] | 0;
   d22 = +HEAPF32[i25 + 28 + (i7 << 2) >> 2];
   d23 = +HEAPF32[i25 + 28 + (((i7 + 2 | 0) % 3 | 0) << 2) >> 2];
   d13 = d17 * d17 + d16 * d16 + d24 * d24;
   if (d13 < 9999999747378752.0e-20) {
    d26 = 1.0;
    d27 = 0.0;
    d28 = 0.0;
   } else {
    d12 = 1.0 / +Math_sqrt(+d13);
    d26 = d17 * d12;
    d27 = d16 * d12;
    d28 = d24 * d12;
   }
   _memset(i8 | 0, 0, 16);
   HEAPF32[i8 + (i7 << 2) >> 2] = d22;
   d12 = d23 * d26 * +HEAPF32[i2 + 12 >> 2];
   d24 = d23 * d27 * +HEAPF32[i2 + 16 >> 2];
   d16 = d23 * d28 * +HEAPF32[i2 + 20 >> 2];
   d23 = +HEAPF32[i2 + 44 >> 2];
   d17 = d26 * d23;
   d13 = d27 * d23;
   d11 = d28 * d23;
   d23 = d12 + +HEAPF32[i8 >> 2] - d17;
   d14 = d24 + +HEAPF32[i8 + 4 >> 2] - d13;
   d29 = d16 + +HEAPF32[i8 + 8 >> 2] - d11;
   d30 = d28 * d29 + (d26 * d23 + d27 * d14);
   if (d30 > -999999984306749400.0) {
    d31 = d30;
    d32 = d23;
    d33 = d14;
    d34 = d29;
   } else {
    d31 = -999999984306749400.0;
    d32 = 0.0;
    d33 = 0.0;
    d34 = 0.0;
   }
   _memset(i9 | 0, 0, 16);
   HEAPF32[i9 + (i7 << 2) >> 2] = -0.0 - d22;
   d22 = d12 + +HEAPF32[i9 >> 2] - d17;
   d17 = d24 + +HEAPF32[i9 + 4 >> 2] - d13;
   d13 = d16 + +HEAPF32[i9 + 8 >> 2] - d11;
   i9 = d28 * d13 + (d26 * d22 + d27 * d17) > d31;
   HEAPF32[i1 >> 2] = i9 ? d22 : d32;
   HEAPF32[i1 + 4 >> 2] = i9 ? d17 : d33;
   HEAPF32[i1 + 8 >> 2] = i9 ? d13 : d34;
   HEAPF32[i1 + 12 >> 2] = 0.0;
   STACKTOP = i4;
   return;
  }
 case 4:
  {
   i9 = HEAP32[i2 + 104 >> 2] | 0;
   i7 = HEAP32[i2 + 96 >> 2] | 0;
   d34 = +HEAPF32[i2 + 12 >> 2];
   d13 = +HEAPF32[i3 >> 2] * d34;
   d33 = +HEAPF32[i2 + 16 >> 2];
   d17 = +HEAPF32[i3 + 4 >> 2] * d33;
   d32 = +HEAPF32[i2 + 20 >> 2];
   d22 = +HEAPF32[i3 + 8 >> 2] * d32;
   if ((i7 | 0) > 0) {
    d31 = -999999984306749400.0;
    i8 = -1;
    i25 = 0;
    while (1) {
     d27 = d13 * +HEAPF32[i9 + (i25 << 4) >> 2] + d17 * +HEAPF32[i9 + (i25 << 4) + 4 >> 2] + d22 * +HEAPF32[i9 + (i25 << 4) + 8 >> 2];
     i6 = d27 > d31;
     i20 = i6 ? i25 : i8;
     i21 = i25 + 1 | 0;
     if ((i21 | 0) < (i7 | 0)) {
      d31 = i6 ? d27 : d31;
      i8 = i20;
      i25 = i21;
     } else {
      i35 = i20;
      break;
     }
    }
   } else {
    i35 = -1;
   }
   d31 = d33 * +HEAPF32[i9 + (i35 << 4) + 4 >> 2];
   d33 = d32 * +HEAPF32[i9 + (i35 << 4) + 8 >> 2];
   HEAPF32[i1 >> 2] = d34 * +HEAPF32[i9 + (i35 << 4) >> 2];
   HEAPF32[i1 + 4 >> 2] = d31;
   HEAPF32[i1 + 8 >> 2] = d33;
   HEAPF32[i1 + 12 >> 2] = 0.0;
   STACKTOP = i4;
   return;
  }
 default:
  {
   FUNCTION_TABLE_viii[HEAP32[(HEAP32[i2 >> 2] | 0) + 64 >> 2] & 127](i1, i2, i3);
   STACKTOP = i4;
   return;
  }
 }
}
function __ZN15btGjkConvexCast16calcTimeOfImpactERK11btTransformS2_S2_S2_RN12btConvexCast10CastResultE(i1, i2, i3, i4, i5, i6) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 var i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, d24 = 0.0, d25 = 0.0, d26 = 0.0, i27 = 0, i28 = 0, i29 = 0, d30 = 0.0, d31 = 0.0, i32 = 0, d33 = 0.0, i34 = 0, d35 = 0.0, i36 = 0, d37 = 0.0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, d44 = 0.0, d45 = 0.0, d46 = 0.0, d47 = 0.0, i48 = 0, d49 = 0.0, i50 = 0, d51 = 0.0, d52 = 0.0, d53 = 0.0, d54 = 0.0, d55 = 0.0, d56 = 0.0, d57 = 0.0, d58 = 0.0, d59 = 0.0, d60 = 0.0;
 i7 = STACKTOP;
 STACKTOP = STACKTOP + 280 | 0;
 i8 = i7 + 16 | 0;
 i9 = i7 + 64 | 0;
 i10 = i7 + 144 | 0;
 i11 = i1 + 4 | 0;
 __ZN22btVoronoiSimplexSolver5resetEv(HEAP32[i11 >> 2] | 0);
 i12 = i2 + 48 | 0;
 i13 = i3 + 48 | 0;
 i14 = i12 | 0;
 i15 = i3 + 52 | 0;
 i16 = i2 + 52 | 0;
 i17 = i3 + 56 | 0;
 i3 = i2 + 56 | 0;
 i18 = i4 + 48 | 0;
 i19 = i5 + 48 | 0;
 i20 = i18 | 0;
 i21 = i5 + 52 | 0;
 i22 = i4 + 52 | 0;
 i23 = i5 + 56 | 0;
 i5 = i4 + 56 | 0;
 d24 = +HEAPF32[i13 >> 2] - +HEAPF32[i14 >> 2] - (+HEAPF32[i19 >> 2] - +HEAPF32[i20 >> 2]);
 d25 = +HEAPF32[i15 >> 2] - +HEAPF32[i16 >> 2] - (+HEAPF32[i21 >> 2] - +HEAPF32[i22 >> 2]);
 d26 = +HEAPF32[i17 >> 2] - +HEAPF32[i3 >> 2] - (+HEAPF32[i23 >> 2] - +HEAPF32[i5 >> 2]);
 HEAP32[i8 >> 2] = 4272;
 i27 = i8 + 36 | 0;
 HEAPF32[i27 >> 2] = 999999984306749400.0;
 i28 = i8 + 40 | 0;
 HEAP8[i28] = 0;
 __ZN17btGjkPairDetectorC2EPK13btConvexShapeS2_P22btVoronoiSimplexSolverP30btConvexPenetrationDepthSolver(i9, HEAP32[i1 + 8 >> 2] | 0, HEAP32[i1 + 12 >> 2] | 0, HEAP32[i11 >> 2] | 0, 0);
 HEAPF32[i10 + 128 >> 2] = 999999984306749400.0;
 HEAP32[i10 + 132 >> 2] = 0;
 i11 = i10;
 i1 = i2;
 HEAP32[i11 >> 2] = HEAP32[i1 >> 2];
 HEAP32[i11 + 4 >> 2] = HEAP32[i1 + 4 >> 2];
 HEAP32[i11 + 8 >> 2] = HEAP32[i1 + 8 >> 2];
 HEAP32[i11 + 12 >> 2] = HEAP32[i1 + 12 >> 2];
 i1 = i10 + 16 | 0;
 i11 = i2 + 16 | 0;
 HEAP32[i1 >> 2] = HEAP32[i11 >> 2];
 HEAP32[i1 + 4 >> 2] = HEAP32[i11 + 4 >> 2];
 HEAP32[i1 + 8 >> 2] = HEAP32[i11 + 8 >> 2];
 HEAP32[i1 + 12 >> 2] = HEAP32[i11 + 12 >> 2];
 i11 = i10 + 32 | 0;
 i1 = i2 + 32 | 0;
 HEAP32[i11 >> 2] = HEAP32[i1 >> 2];
 HEAP32[i11 + 4 >> 2] = HEAP32[i1 + 4 >> 2];
 HEAP32[i11 + 8 >> 2] = HEAP32[i1 + 8 >> 2];
 HEAP32[i11 + 12 >> 2] = HEAP32[i1 + 12 >> 2];
 i1 = i10 + 48 | 0;
 i11 = i1;
 i2 = i12;
 HEAP32[i11 >> 2] = HEAP32[i2 >> 2];
 HEAP32[i11 + 4 >> 2] = HEAP32[i2 + 4 >> 2];
 HEAP32[i11 + 8 >> 2] = HEAP32[i2 + 8 >> 2];
 HEAP32[i11 + 12 >> 2] = HEAP32[i2 + 12 >> 2];
 i2 = i10 + 64 | 0;
 i11 = i4;
 HEAP32[i2 >> 2] = HEAP32[i11 >> 2];
 HEAP32[i2 + 4 >> 2] = HEAP32[i11 + 4 >> 2];
 HEAP32[i2 + 8 >> 2] = HEAP32[i11 + 8 >> 2];
 HEAP32[i2 + 12 >> 2] = HEAP32[i11 + 12 >> 2];
 i11 = i10 + 80 | 0;
 i2 = i4 + 16 | 0;
 HEAP32[i11 >> 2] = HEAP32[i2 >> 2];
 HEAP32[i11 + 4 >> 2] = HEAP32[i2 + 4 >> 2];
 HEAP32[i11 + 8 >> 2] = HEAP32[i2 + 8 >> 2];
 HEAP32[i11 + 12 >> 2] = HEAP32[i2 + 12 >> 2];
 i2 = i10 + 96 | 0;
 i11 = i4 + 32 | 0;
 HEAP32[i2 >> 2] = HEAP32[i11 >> 2];
 HEAP32[i2 + 4 >> 2] = HEAP32[i11 + 4 >> 2];
 HEAP32[i2 + 8 >> 2] = HEAP32[i11 + 8 >> 2];
 HEAP32[i2 + 12 >> 2] = HEAP32[i11 + 12 >> 2];
 i11 = i10 + 112 | 0;
 i2 = i11;
 i4 = i18;
 HEAP32[i2 >> 2] = HEAP32[i4 >> 2];
 HEAP32[i2 + 4 >> 2] = HEAP32[i4 + 4 >> 2];
 HEAP32[i2 + 8 >> 2] = HEAP32[i4 + 8 >> 2];
 HEAP32[i2 + 12 >> 2] = HEAP32[i4 + 12 >> 2];
 i4 = i8 | 0;
 __ZN17btGjkPairDetector16getClosestPointsERKN36btDiscreteCollisionDetectorInterface17ClosestPointInputERNS0_6ResultEP12btIDebugDrawb(i9, i10, i4, 0, 0);
 i2 = (HEAP8[i28] | 0) == 0;
 i18 = i8 + 20 | 0;
 i12 = i7 | 0;
 HEAP32[i12 >> 2] = HEAP32[i18 >> 2];
 HEAP32[i12 + 4 >> 2] = HEAP32[i18 + 4 >> 2];
 HEAP32[i12 + 8 >> 2] = HEAP32[i18 + 8 >> 2];
 HEAP32[i12 + 12 >> 2] = HEAP32[i18 + 12 >> 2];
 if (i2) {
  i29 = 0;
  STACKTOP = i7;
  return i29 | 0;
 }
 d30 = +HEAPF32[i27 >> 2];
 i2 = i8 + 4 | 0;
 d31 = +HEAPF32[i2 >> 2];
 i32 = i8 + 8 | 0;
 d33 = +HEAPF32[i32 >> 2];
 i34 = i8 + 12 | 0;
 d35 = +HEAPF32[i34 >> 2];
 i36 = i8 + 16 | 0;
 d37 = +HEAPF32[i36 >> 2];
 do {
  if (d30 > .0010000000474974513) {
   i8 = i6;
   i38 = i1 | 0;
   i39 = i10 + 52 | 0;
   i40 = i10 + 56 | 0;
   i41 = i11 | 0;
   i42 = i10 + 116 | 0;
   i43 = i10 + 120 | 0;
   d44 = d35;
   d45 = d33;
   d46 = d31;
   d47 = 0.0;
   i48 = 1;
   d49 = d30;
   while (1) {
    if ((i48 | 0) > 32) {
     i29 = 0;
     i50 = 2068;
     break;
    }
    d51 = d47 - d49 / (d26 * d44 + (d24 * d46 + d25 * d45));
    if (!(d51 >= 0.0 & d51 <= 1.0 & d51 > d47)) {
     i29 = 0;
     i50 = 2067;
     break;
    }
    FUNCTION_TABLE_vif[HEAP32[HEAP32[i8 >> 2] >> 2] & 31](i6, d51);
    d52 = 1.0 - d51;
    HEAPF32[i38 >> 2] = d52 * +HEAPF32[i14 >> 2] + d51 * +HEAPF32[i13 >> 2];
    HEAPF32[i39 >> 2] = d52 * +HEAPF32[i16 >> 2] + d51 * +HEAPF32[i15 >> 2];
    HEAPF32[i40 >> 2] = d52 * +HEAPF32[i3 >> 2] + d51 * +HEAPF32[i17 >> 2];
    HEAPF32[i41 >> 2] = d52 * +HEAPF32[i20 >> 2] + d51 * +HEAPF32[i19 >> 2];
    HEAPF32[i42 >> 2] = d52 * +HEAPF32[i22 >> 2] + d51 * +HEAPF32[i21 >> 2];
    HEAPF32[i43 >> 2] = d52 * +HEAPF32[i5 >> 2] + d51 * +HEAPF32[i23 >> 2];
    __ZN17btGjkPairDetector16getClosestPointsERKN36btDiscreteCollisionDetectorInterface17ClosestPointInputERNS0_6ResultEP12btIDebugDrawb(i9, i10, i4, 0, 0);
    if ((HEAP8[i28] | 0) == 0) {
     i29 = 0;
     i50 = 2070;
     break;
    }
    d52 = +HEAPF32[i27 >> 2];
    if (d52 < 0.0) {
     i50 = 2059;
     break;
    }
    HEAP32[i12 >> 2] = HEAP32[i18 >> 2];
    HEAP32[i12 + 4 >> 2] = HEAP32[i18 + 4 >> 2];
    HEAP32[i12 + 8 >> 2] = HEAP32[i18 + 8 >> 2];
    HEAP32[i12 + 12 >> 2] = HEAP32[i18 + 12 >> 2];
    d53 = +HEAPF32[i2 >> 2];
    d54 = +HEAPF32[i32 >> 2];
    d55 = +HEAPF32[i34 >> 2];
    if (d52 > .0010000000474974513) {
     d44 = d55;
     d45 = d54;
     d46 = d53;
     d47 = d51;
     i48 = i48 + 1 | 0;
     d49 = d52;
    } else {
     i50 = 2061;
     break;
    }
   }
   if ((i50 | 0) == 2059) {
    HEAPF32[i6 + 164 >> 2] = d51;
    d49 = +HEAPF32[i32 >> 2];
    d47 = +HEAPF32[i34 >> 2];
    d46 = +HEAPF32[i36 >> 2];
    HEAPF32[i6 + 132 >> 2] = +HEAPF32[i2 >> 2];
    HEAPF32[i6 + 136 >> 2] = d49;
    HEAPF32[i6 + 140 >> 2] = d47;
    HEAPF32[i6 + 144 >> 2] = d46;
    i48 = i6 + 148 | 0;
    HEAP32[i48 >> 2] = HEAP32[i18 >> 2];
    HEAP32[i48 + 4 >> 2] = HEAP32[i18 + 4 >> 2];
    HEAP32[i48 + 8 >> 2] = HEAP32[i18 + 8 >> 2];
    HEAP32[i48 + 12 >> 2] = HEAP32[i18 + 12 >> 2];
    i29 = 1;
    STACKTOP = i7;
    return i29 | 0;
   } else if ((i50 | 0) == 2068) {
    STACKTOP = i7;
    return i29 | 0;
   } else if ((i50 | 0) == 2061) {
    d56 = +HEAPF32[i36 >> 2];
    d57 = d55;
    d58 = d54;
    d59 = d53;
    d60 = d51;
    break;
   } else if ((i50 | 0) == 2067) {
    STACKTOP = i7;
    return i29 | 0;
   } else if ((i50 | 0) == 2070) {
    STACKTOP = i7;
    return i29 | 0;
   }
  } else {
   d56 = d37;
   d57 = d35;
   d58 = d33;
   d59 = d31;
   d60 = 0.0;
  }
 } while (0);
 if (d26 * d57 + (d24 * d59 + d25 * d58) >= -0.0 - +HEAPF32[i6 + 172 >> 2]) {
  i29 = 0;
  STACKTOP = i7;
  return i29 | 0;
 }
 HEAPF32[i6 + 164 >> 2] = d60;
 HEAPF32[i6 + 132 >> 2] = d59;
 HEAPF32[i6 + 136 >> 2] = d58;
 HEAPF32[i6 + 140 >> 2] = d57;
 HEAPF32[i6 + 144 >> 2] = d56;
 i50 = i6 + 148 | 0;
 HEAP32[i50 >> 2] = HEAP32[i12 >> 2];
 HEAP32[i50 + 4 >> 2] = HEAP32[i12 + 4 >> 2];
 HEAP32[i50 + 8 >> 2] = HEAP32[i12 + 8 >> 2];
 HEAP32[i50 + 12 >> 2] = HEAP32[i12 + 12 >> 2];
 i29 = 1;
 STACKTOP = i7;
 return i29 | 0;
}
function __ZZN23btDiscreteDynamicsWorld16solveConstraintsER19btContactSolverInfoEN27InplaceSolverIslandCallback13ProcessIslandEPP17btCollisionObjectiPP20btPersistentManifoldii(i1, i2, i3, i4, i5, i6) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 var i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0;
 i7 = HEAP32[i1 + 16 >> 2] | 0;
 if ((i6 | 0) < 0) {
  if ((i7 | 0) == (-i5 | 0)) {
   return;
  }
  i8 = HEAP32[i1 + 8 >> 2] | 0;
  i9 = HEAP32[(HEAP32[i8 >> 2] | 0) + 12 >> 2] | 0;
  i10 = HEAP32[i1 + 12 >> 2] | 0;
  i11 = HEAP32[i1 + 4 >> 2] | 0;
  i12 = HEAP32[i1 + 20 >> 2] | 0;
  i13 = HEAP32[i1 + 24 >> 2] | 0;
  i14 = HEAP32[i1 + 28 >> 2] | 0;
  +FUNCTION_TABLE_fiiiiiiiiiii[i9 & 3](i8, i2, i3, i4, i5, i10, i7, i11, i12, i13, i14);
  return;
 }
 i14 = i1 + 12 | 0;
 i13 = 0;
 while (1) {
  if ((i13 | 0) >= (i7 | 0)) {
   i15 = 0;
   i16 = 0;
   break;
  }
  i17 = HEAP32[i14 >> 2] | 0;
  i18 = i17 + (i13 << 2) | 0;
  i12 = HEAP32[i18 >> 2] | 0;
  i11 = HEAP32[(HEAP32[i12 + 24 >> 2] | 0) + 208 >> 2] | 0;
  if ((i11 | 0) > -1) {
   i19 = i11;
  } else {
   i19 = HEAP32[(HEAP32[i12 + 28 >> 2] | 0) + 208 >> 2] | 0;
  }
  if ((i19 | 0) == (i6 | 0)) {
   i20 = 0;
   i21 = i13;
   i22 = 889;
   break;
  } else {
   i13 = i13 + 1 | 0;
  }
 }
 if ((i22 | 0) == 889) {
  while (1) {
   i22 = 0;
   i13 = HEAP32[i17 + (i21 << 2) >> 2] | 0;
   i19 = HEAP32[(HEAP32[i13 + 24 >> 2] | 0) + 208 >> 2] | 0;
   if ((i19 | 0) > -1) {
    i23 = i19;
   } else {
    i23 = HEAP32[(HEAP32[i13 + 28 >> 2] | 0) + 208 >> 2] | 0;
   }
   i13 = ((i23 | 0) == (i6 | 0)) + i20 | 0;
   i19 = i21 + 1 | 0;
   if ((i19 | 0) < (i7 | 0)) {
    i20 = i13;
    i21 = i19;
    i22 = 889;
   } else {
    i15 = i13;
    i16 = i18;
    break;
   }
  }
 }
 i18 = i1 + 4 | 0;
 i22 = HEAP32[i18 >> 2] | 0;
 if ((HEAP32[i22 + 68 >> 2] | 0) < 2) {
  if ((i15 | 0) == (-i5 | 0)) {
   return;
  }
  i21 = HEAP32[i1 + 8 >> 2] | 0;
  i20 = HEAP32[(HEAP32[i21 >> 2] | 0) + 12 >> 2] | 0;
  i7 = HEAP32[i1 + 20 >> 2] | 0;
  i6 = HEAP32[i1 + 24 >> 2] | 0;
  i23 = HEAP32[i1 + 28 >> 2] | 0;
  +FUNCTION_TABLE_fiiiiiiiiiii[i20 & 3](i21, i2, i3, i4, i5, i16, i15, i22, i7, i6, i23);
  return;
 }
 if ((i3 | 0) > 0) {
  i23 = i1 + 36 | 0;
  i6 = i1 + 40 | 0;
  i7 = i1 + 44 | 0;
  i22 = i1 + 48 | 0;
  i21 = 0;
  i20 = HEAP32[i23 >> 2] | 0;
  i17 = HEAP32[i6 >> 2] | 0;
  while (1) {
   i13 = i2 + (i21 << 2) | 0;
   do {
    if ((i20 | 0) == (i17 | 0)) {
     i19 = (i17 | 0) == 0 ? 1 : i17 << 1;
     if ((i17 | 0) >= (i19 | 0)) {
      i24 = i17;
      i25 = i17;
      break;
     }
     if ((i19 | 0) == 0) {
      i26 = 0;
      i27 = i17;
     } else {
      i14 = __Z22btAlignedAllocInternalji(i19 << 2, 16) | 0;
      i26 = i14;
      i27 = HEAP32[i23 >> 2] | 0;
     }
     if ((i27 | 0) > 0) {
      i14 = 0;
      do {
       i12 = i26 + (i14 << 2) | 0;
       if ((i12 | 0) != 0) {
        HEAP32[i12 >> 2] = HEAP32[(HEAP32[i7 >> 2] | 0) + (i14 << 2) >> 2];
       }
       i14 = i14 + 1 | 0;
      } while ((i14 | 0) < (i27 | 0));
     }
     i14 = HEAP32[i7 >> 2] | 0;
     if ((i14 | 0) == 0) {
      i28 = i27;
     } else {
      if ((HEAP8[i22] | 0) == 0) {
       i29 = i27;
      } else {
       __Z21btAlignedFreeInternalPv(i14);
       i29 = HEAP32[i23 >> 2] | 0;
      }
      HEAP32[i7 >> 2] = 0;
      i28 = i29;
     }
     HEAP8[i22] = 1;
     HEAP32[i7 >> 2] = i26;
     HEAP32[i6 >> 2] = i19;
     i24 = i28;
     i25 = i19;
    } else {
     i24 = i20;
     i25 = i17;
    }
   } while (0);
   i14 = (HEAP32[i7 >> 2] | 0) + (i24 << 2) | 0;
   if ((i14 | 0) != 0) {
    HEAP32[i14 >> 2] = HEAP32[i13 >> 2];
   }
   i14 = i24 + 1 | 0;
   HEAP32[i23 >> 2] = i14;
   i12 = i21 + 1 | 0;
   if ((i12 | 0) < (i3 | 0)) {
    i21 = i12;
    i20 = i14;
    i17 = i25;
   } else {
    break;
   }
  }
 }
 if ((i5 | 0) > 0) {
  i25 = i1 + 56 | 0;
  i17 = i1 + 60 | 0;
  i20 = i1 + 64 | 0;
  i21 = i1 + 68 | 0;
  i3 = 0;
  i23 = HEAP32[i25 >> 2] | 0;
  i24 = HEAP32[i17 >> 2] | 0;
  while (1) {
   i7 = i4 + (i3 << 2) | 0;
   do {
    if ((i23 | 0) == (i24 | 0)) {
     i28 = (i24 | 0) == 0 ? 1 : i24 << 1;
     if ((i24 | 0) >= (i28 | 0)) {
      i30 = i24;
      i31 = i24;
      break;
     }
     if ((i28 | 0) == 0) {
      i32 = 0;
      i33 = i24;
     } else {
      i6 = __Z22btAlignedAllocInternalji(i28 << 2, 16) | 0;
      i32 = i6;
      i33 = HEAP32[i25 >> 2] | 0;
     }
     if ((i33 | 0) > 0) {
      i6 = 0;
      do {
       i26 = i32 + (i6 << 2) | 0;
       if ((i26 | 0) != 0) {
        HEAP32[i26 >> 2] = HEAP32[(HEAP32[i20 >> 2] | 0) + (i6 << 2) >> 2];
       }
       i6 = i6 + 1 | 0;
      } while ((i6 | 0) < (i33 | 0));
     }
     i6 = HEAP32[i20 >> 2] | 0;
     if ((i6 | 0) == 0) {
      i34 = i33;
     } else {
      if ((HEAP8[i21] | 0) == 0) {
       i35 = i33;
      } else {
       __Z21btAlignedFreeInternalPv(i6);
       i35 = HEAP32[i25 >> 2] | 0;
      }
      HEAP32[i20 >> 2] = 0;
      i34 = i35;
     }
     HEAP8[i21] = 1;
     HEAP32[i20 >> 2] = i32;
     HEAP32[i17 >> 2] = i28;
     i30 = i34;
     i31 = i28;
    } else {
     i30 = i23;
     i31 = i24;
    }
   } while (0);
   i13 = (HEAP32[i20 >> 2] | 0) + (i30 << 2) | 0;
   if ((i13 | 0) != 0) {
    HEAP32[i13 >> 2] = HEAP32[i7 >> 2];
   }
   i13 = i30 + 1 | 0;
   HEAP32[i25 >> 2] = i13;
   i6 = i3 + 1 | 0;
   if ((i6 | 0) < (i5 | 0)) {
    i3 = i6;
    i23 = i13;
    i24 = i31;
   } else {
    break;
   }
  }
 }
 i31 = i1 + 76 | 0;
 if ((i15 | 0) > 0) {
  i24 = i1 + 80 | 0;
  i23 = i1 + 84 | 0;
  i3 = i1 + 88 | 0;
  i5 = 0;
  i25 = HEAP32[i31 >> 2] | 0;
  i30 = HEAP32[i24 >> 2] | 0;
  while (1) {
   i20 = i16 + (i5 << 2) | 0;
   do {
    if ((i25 | 0) == (i30 | 0)) {
     i34 = (i30 | 0) == 0 ? 1 : i30 << 1;
     if ((i30 | 0) >= (i34 | 0)) {
      i36 = i30;
      i37 = i30;
      break;
     }
     if ((i34 | 0) == 0) {
      i38 = 0;
      i39 = i30;
     } else {
      i17 = __Z22btAlignedAllocInternalji(i34 << 2, 16) | 0;
      i38 = i17;
      i39 = HEAP32[i31 >> 2] | 0;
     }
     if ((i39 | 0) > 0) {
      i17 = 0;
      do {
       i32 = i38 + (i17 << 2) | 0;
       if ((i32 | 0) != 0) {
        HEAP32[i32 >> 2] = HEAP32[(HEAP32[i23 >> 2] | 0) + (i17 << 2) >> 2];
       }
       i17 = i17 + 1 | 0;
      } while ((i17 | 0) < (i39 | 0));
     }
     i17 = HEAP32[i23 >> 2] | 0;
     if ((i17 | 0) == 0) {
      i40 = i39;
     } else {
      if ((HEAP8[i3] | 0) == 0) {
       i41 = i39;
      } else {
       __Z21btAlignedFreeInternalPv(i17);
       i41 = HEAP32[i31 >> 2] | 0;
      }
      HEAP32[i23 >> 2] = 0;
      i40 = i41;
     }
     HEAP8[i3] = 1;
     HEAP32[i23 >> 2] = i38;
     HEAP32[i24 >> 2] = i34;
     i36 = i40;
     i37 = i34;
    } else {
     i36 = i25;
     i37 = i30;
    }
   } while (0);
   i7 = (HEAP32[i23 >> 2] | 0) + (i36 << 2) | 0;
   if ((i7 | 0) != 0) {
    HEAP32[i7 >> 2] = HEAP32[i20 >> 2];
   }
   i7 = i36 + 1 | 0;
   HEAP32[i31 >> 2] = i7;
   i17 = i5 + 1 | 0;
   if ((i17 | 0) < (i15 | 0)) {
    i5 = i17;
    i25 = i7;
    i30 = i37;
   } else {
    i42 = i7;
    break;
   }
  }
 } else {
  i42 = HEAP32[i31 >> 2] | 0;
 }
 if (((HEAP32[i1 + 56 >> 2] | 0) + i42 | 0) <= (HEAP32[(HEAP32[i18 >> 2] | 0) + 68 >> 2] | 0)) {
  return;
 }
 __ZZN23btDiscreteDynamicsWorld16solveConstraintsER19btContactSolverInfoEN27InplaceSolverIslandCallback18processConstraintsEv(i1);
 return;
}
function __ZN15btGjkEpaSolver211PenetrationEPK13btConvexShapeRK11btTransformS2_S5_RK9btVector3RNS_8sResultsEb(i1, i2, i3, i4, i5, i6, i7) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 i7 = i7 | 0;
 var i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, d18 = 0.0, d19 = 0.0, d20 = 0.0, d21 = 0.0, d22 = 0.0, i23 = 0, d24 = 0.0, d25 = 0.0, i26 = 0, d27 = 0.0, i28 = 0, d29 = 0.0, i30 = 0, d31 = 0.0, d32 = 0.0, i33 = 0, d34 = 0.0, i35 = 0, d36 = 0.0, i37 = 0, d38 = 0.0, d39 = 0.0, d40 = 0.0, d41 = 0.0, d42 = 0.0, d43 = 0.0, d44 = 0.0, d45 = 0.0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, d55 = 0.0, d56 = 0.0, d57 = 0.0, i58 = 0;
 i8 = STACKTOP;
 STACKTOP = STACKTOP + 10368 | 0;
 i9 = i8 | 0;
 i10 = i8 + 128 | 0;
 i11 = i8 + 512 | 0;
 i12 = i8 + 528 | 0;
 i13 = i8 + 10336 | 0;
 i14 = i8 + 10352 | 0;
 i15 = i6 + 20 | 0;
 i16 = i6 + 20 | 0;
 i17 = i6 + 4 | 0;
 _memset(i16 | 0, 0, 16);
 HEAP32[i17 >> 2] = HEAP32[i15 >> 2];
 HEAP32[i17 + 4 >> 2] = HEAP32[i15 + 4 >> 2];
 HEAP32[i17 + 8 >> 2] = HEAP32[i15 + 8 >> 2];
 HEAP32[i17 + 12 >> 2] = HEAP32[i15 + 12 >> 2];
 i15 = i6 | 0;
 HEAP32[i15 >> 2] = 0;
 i17 = i9 | 0;
 HEAP32[i17 >> 2] = i1;
 HEAP32[i9 + 4 >> 2] = i3;
 d18 = +HEAPF32[i4 >> 2];
 i3 = i2 | 0;
 d19 = +HEAPF32[i3 >> 2];
 d20 = +HEAPF32[i4 + 16 >> 2];
 i1 = i2 + 16 | 0;
 d21 = +HEAPF32[i1 >> 2];
 d22 = +HEAPF32[i4 + 32 >> 2];
 i23 = i2 + 32 | 0;
 d24 = +HEAPF32[i23 >> 2];
 d25 = d18 * d19 + d20 * d21 + d22 * d24;
 i26 = i2 + 4 | 0;
 d27 = +HEAPF32[i26 >> 2];
 i28 = i2 + 20 | 0;
 d29 = +HEAPF32[i28 >> 2];
 i30 = i2 + 36 | 0;
 d31 = +HEAPF32[i30 >> 2];
 d32 = d18 * d27 + d20 * d29 + d22 * d31;
 i33 = i2 + 8 | 0;
 d34 = +HEAPF32[i33 >> 2];
 i35 = i2 + 24 | 0;
 d36 = +HEAPF32[i35 >> 2];
 i37 = i2 + 40 | 0;
 d38 = +HEAPF32[i37 >> 2];
 d39 = d18 * d34 + d20 * d36 + d22 * d38;
 d22 = +HEAPF32[i4 + 4 >> 2];
 d20 = +HEAPF32[i4 + 20 >> 2];
 d18 = +HEAPF32[i4 + 36 >> 2];
 d40 = d19 * d22 + d21 * d20 + d24 * d18;
 d41 = d27 * d22 + d29 * d20 + d31 * d18;
 d42 = d34 * d22 + d36 * d20 + d38 * d18;
 d18 = +HEAPF32[i4 + 8 >> 2];
 d20 = +HEAPF32[i4 + 24 >> 2];
 d22 = +HEAPF32[i4 + 40 >> 2];
 d43 = d19 * d18 + d21 * d20 + d24 * d22;
 d44 = d27 * d18 + d29 * d20 + d31 * d22;
 d45 = d34 * d18 + d36 * d20 + d38 * d22;
 HEAPF32[i9 + 8 >> 2] = d25;
 HEAPF32[i9 + 12 >> 2] = d32;
 HEAPF32[i9 + 16 >> 2] = d39;
 HEAPF32[i9 + 20 >> 2] = 0.0;
 HEAPF32[i9 + 24 >> 2] = d40;
 HEAPF32[i9 + 28 >> 2] = d41;
 HEAPF32[i9 + 32 >> 2] = d42;
 HEAPF32[i9 + 36 >> 2] = 0.0;
 HEAPF32[i9 + 40 >> 2] = d43;
 HEAPF32[i9 + 44 >> 2] = d44;
 HEAPF32[i9 + 48 >> 2] = d45;
 HEAPF32[i9 + 52 >> 2] = 0.0;
 i46 = i2 + 48 | 0;
 d22 = +HEAPF32[i4 + 48 >> 2] - +HEAPF32[i46 >> 2];
 i47 = i2 + 52 | 0;
 d20 = +HEAPF32[i4 + 52 >> 2] - +HEAPF32[i47 >> 2];
 i48 = i2 + 56 | 0;
 d18 = +HEAPF32[i4 + 56 >> 2] - +HEAPF32[i48 >> 2];
 HEAPF32[i9 + 56 >> 2] = d25;
 HEAPF32[i9 + 60 >> 2] = d40;
 HEAPF32[i9 + 64 >> 2] = d43;
 HEAPF32[i9 + 68 >> 2] = 0.0;
 HEAPF32[i9 + 72 >> 2] = d32;
 HEAPF32[i9 + 76 >> 2] = d41;
 HEAPF32[i9 + 80 >> 2] = d44;
 HEAPF32[i9 + 84 >> 2] = 0.0;
 HEAPF32[i9 + 88 >> 2] = d39;
 HEAPF32[i9 + 92 >> 2] = d42;
 HEAPF32[i9 + 96 >> 2] = d45;
 HEAPF32[i9 + 100 >> 2] = 0.0;
 HEAPF32[i9 + 104 >> 2] = d19 * d22 + d21 * d20 + d24 * d18;
 HEAPF32[i9 + 108 >> 2] = d27 * d22 + d29 * d20 + d31 * d18;
 HEAPF32[i9 + 112 >> 2] = d34 * d22 + d36 * d20 + d38 * d18;
 HEAPF32[i9 + 116 >> 2] = 0.0;
 i4 = i9 + 120 | 0;
 HEAP32[i4 >> 2] = i7 ? 36 : 82;
 i2 = i9 + 124 | 0;
 HEAP32[i2 >> 2] = i7 ? 0 : 0;
 HEAP32[i10 + 364 >> 2] = 0;
 _memset(i10 + 128 | 0, 0, 16);
 HEAP32[i10 + 376 >> 2] = 2;
 HEAP32[i10 + 368 >> 2] = 0;
 HEAPF32[i10 + 144 >> 2] = 0.0;
 i7 = i5 | 0;
 i49 = i5 + 4 | 0;
 d18 = -0.0 - +HEAPF32[i49 >> 2];
 i50 = i5 + 8 | 0;
 d38 = -0.0 - +HEAPF32[i50 >> 2];
 HEAPF32[i11 >> 2] = -0.0 - +HEAPF32[i7 >> 2];
 HEAPF32[i11 + 4 >> 2] = d18;
 HEAPF32[i11 + 8 >> 2] = d38;
 HEAPF32[i11 + 12 >> 2] = 0.0;
 i5 = __ZN12gjkepa2_impl3GJK8EvaluateERKNS_13MinkowskiDiffERK9btVector3(i10, i9, i11) | 0;
 if ((i5 | 0) == 2) {
  HEAP32[i15 >> 2] = 2;
  i51 = 0;
  STACKTOP = i8;
  return i51 | 0;
 } else if ((i5 | 0) == 1) {
  i5 = i12 + 9800 | 0;
  i11 = i12 + 9804 | 0;
  _memset(i12 + 9792 | 0, 0, 16);
  HEAP32[i12 >> 2] = 9;
  i9 = i12 + 40 | 0;
  HEAP32[i12 + 9788 >> 2] = 0;
  _memset(i9 | 0, 0, 20);
  i52 = 0;
  do {
   i53 = 128 - i52 - 1 | 0;
   i54 = i12 + 2108 + (i53 * 60 | 0) | 0;
   HEAP32[i12 + 2108 + (i53 * 60 | 0) + 48 >> 2] = 0;
   HEAP32[i12 + 2108 + (i53 * 60 | 0) + 52 >> 2] = HEAP32[i5 >> 2];
   i53 = HEAP32[i5 >> 2] | 0;
   if ((i53 | 0) != 0) {
    HEAP32[i53 + 48 >> 2] = i54;
   }
   HEAP32[i5 >> 2] = i54;
   HEAP32[i11 >> 2] = (HEAP32[i11 >> 2] | 0) + 1;
   i52 = i52 + 1 | 0;
  } while (i52 >>> 0 < 128);
  d38 = -0.0 - +HEAPF32[i49 >> 2];
  d18 = -0.0 - +HEAPF32[i50 >> 2];
  HEAPF32[i13 >> 2] = -0.0 - +HEAPF32[i7 >> 2];
  HEAPF32[i13 + 4 >> 2] = d38;
  HEAPF32[i13 + 8 >> 2] = d18;
  HEAPF32[i13 + 12 >> 2] = 0.0;
  if ((__ZN12gjkepa2_impl3EPA8EvaluateERNS_3GJKERK9btVector3(i12, i10, i13) | 0) == 9) {
   HEAP32[i15 >> 2] = 3;
   i51 = 0;
   STACKTOP = i8;
   return i51 | 0;
  }
  i13 = i12 + 36 | 0;
  if ((HEAP32[i13 >> 2] | 0) == 0) {
   d55 = 0.0;
   d56 = 0.0;
   d57 = 0.0;
  } else {
   i10 = i14 | 0;
   i7 = i14 + 4 | 0;
   i50 = i14 + 8 | 0;
   d18 = 0.0;
   d38 = 0.0;
   d20 = 0.0;
   i49 = 0;
   while (1) {
    i52 = HEAP32[i4 >> 2] | 0;
    i11 = (HEAP32[i17 >> 2] | 0) + (HEAP32[i2 >> 2] | 0) | 0;
    if ((i52 & 1 | 0) == 0) {
     i58 = i52;
    } else {
     i58 = HEAP32[(HEAP32[i11 >> 2] | 0) + (i52 - 1) >> 2] | 0;
    }
    FUNCTION_TABLE_viii[i58 & 127](i14, i11, HEAP32[i12 + 4 + (i49 << 2) >> 2] | 0);
    d36 = +HEAPF32[i12 + 20 + (i49 << 2) >> 2];
    d22 = d20 + +HEAPF32[i10 >> 2] * d36;
    d34 = d38 + d36 * +HEAPF32[i7 >> 2];
    d31 = d18 + d36 * +HEAPF32[i50 >> 2];
    i11 = i49 + 1 | 0;
    if (i11 >>> 0 < (HEAP32[i13 >> 2] | 0) >>> 0) {
     d18 = d31;
     d38 = d34;
     d20 = d22;
     i49 = i11;
    } else {
     d55 = d31;
     d56 = d34;
     d57 = d22;
     break;
    }
   }
  }
  HEAP32[i15 >> 2] = 1;
  d20 = +HEAPF32[i47 >> 2] + (d57 * +HEAPF32[i1 >> 2] + d56 * +HEAPF32[i28 >> 2] + d55 * +HEAPF32[i35 >> 2]);
  d38 = +HEAPF32[i48 >> 2] + (d57 * +HEAPF32[i23 >> 2] + d56 * +HEAPF32[i30 >> 2] + d55 * +HEAPF32[i37 >> 2]);
  HEAPF32[i6 + 4 >> 2] = +HEAPF32[i46 >> 2] + (d57 * +HEAPF32[i3 >> 2] + d56 * +HEAPF32[i26 >> 2] + d55 * +HEAPF32[i33 >> 2]);
  HEAPF32[i6 + 8 >> 2] = d20;
  HEAPF32[i6 + 12 >> 2] = d38;
  HEAPF32[i6 + 16 >> 2] = 0.0;
  d38 = +HEAPF32[i9 >> 2];
  d20 = +HEAPF32[i12 + 56 >> 2];
  d18 = +HEAPF32[i12 + 44 >> 2];
  d22 = +HEAPF32[i12 + 48 >> 2];
  d34 = d57 - d38 * d20;
  d57 = d56 - d20 * d18;
  d56 = d55 - d20 * d22;
  d55 = +HEAPF32[i47 >> 2] + (d34 * +HEAPF32[i1 >> 2] + d57 * +HEAPF32[i28 >> 2] + d56 * +HEAPF32[i35 >> 2]);
  d31 = +HEAPF32[i48 >> 2] + (d34 * +HEAPF32[i23 >> 2] + d57 * +HEAPF32[i30 >> 2] + d56 * +HEAPF32[i37 >> 2]);
  HEAPF32[i16 >> 2] = +HEAPF32[i46 >> 2] + (d34 * +HEAPF32[i3 >> 2] + d57 * +HEAPF32[i26 >> 2] + d56 * +HEAPF32[i33 >> 2]);
  HEAPF32[i6 + 24 >> 2] = d55;
  HEAPF32[i6 + 28 >> 2] = d31;
  HEAPF32[i6 + 32 >> 2] = 0.0;
  HEAPF32[i6 + 36 >> 2] = -0.0 - d38;
  HEAPF32[i6 + 40 >> 2] = -0.0 - d18;
  HEAPF32[i6 + 44 >> 2] = -0.0 - d22;
  HEAPF32[i6 + 48 >> 2] = 0.0;
  HEAPF32[i6 + 52 >> 2] = -0.0 - d20;
  i51 = 1;
  STACKTOP = i8;
  return i51 | 0;
 } else {
  i51 = 0;
  STACKTOP = i8;
  return i51 | 0;
 }
 return 0;
}
function __ZN22btVoronoiSimplexSolver25closestPtPointTetrahedronERK9btVector3S2_S2_S2_S2_R25btSubSimplexClosestResult(i1, i2, i3, i4, i5, i6, i7) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 i7 = i7 | 0;
 var i8 = 0, i9 = 0, i10 = 0, i11 = 0, d12 = 0.0, d13 = 0.0, d14 = 0.0, d15 = 0.0, d16 = 0.0, d17 = 0.0, d18 = 0.0, d19 = 0.0, d20 = 0.0, d21 = 0.0, d22 = 0.0, d23 = 0.0, d24 = 0.0, d25 = 0.0, d26 = 0.0, d27 = 0.0, d28 = 0.0, d29 = 0.0, d30 = 0.0, d31 = 0.0, d32 = 0.0, d33 = 0.0, d34 = 0.0, d35 = 0.0, d36 = 0.0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, d42 = 0.0, d43 = 0.0, d44 = 0.0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 40 | 0;
 i8 = i1 | 0;
 i9 = i8 + 16 | 0;
 HEAP16[i9 >> 1] = 0;
 i10 = i7;
 i11 = i2;
 HEAP32[i10 >> 2] = HEAP32[i11 >> 2];
 HEAP32[i10 + 4 >> 2] = HEAP32[i11 + 4 >> 2];
 HEAP32[i10 + 8 >> 2] = HEAP32[i11 + 8 >> 2];
 HEAP32[i10 + 12 >> 2] = HEAP32[i11 + 12 >> 2];
 i11 = i7 + 16 | 0;
 HEAP16[i11 >> 1] = HEAP16[i11 >> 1] | 15;
 d12 = +HEAPF32[i4 >> 2];
 d13 = +HEAPF32[i3 >> 2];
 d14 = d12 - d13;
 d15 = +HEAPF32[i4 + 4 >> 2];
 d16 = +HEAPF32[i3 + 4 >> 2];
 d17 = d15 - d16;
 d18 = +HEAPF32[i4 + 8 >> 2];
 d19 = +HEAPF32[i3 + 8 >> 2];
 d20 = d18 - d19;
 d21 = +HEAPF32[i5 >> 2];
 d22 = d21 - d13;
 d23 = +HEAPF32[i5 + 4 >> 2];
 d24 = d23 - d16;
 d25 = +HEAPF32[i5 + 8 >> 2];
 d26 = d25 - d19;
 d27 = d17 * d26 - d20 * d24;
 d28 = d20 * d22 - d14 * d26;
 d29 = d14 * d24 - d17 * d22;
 d30 = +HEAPF32[i6 >> 2];
 d31 = d30 - d13;
 d32 = +HEAPF32[i6 + 4 >> 2];
 d33 = d32 - d16;
 d34 = +HEAPF32[i6 + 8 >> 2];
 d35 = d34 - d19;
 d36 = d31 * d27 + d33 * d28 + d29 * d35;
 if (d36 * d36 < 9.99999905104687e-9) {
  i37 = -1;
 } else {
  i37 = d36 * (d28 * (+HEAPF32[i2 + 4 >> 2] - d16) + d27 * (+HEAPF32[i2 >> 2] - d13) + d29 * (+HEAPF32[i2 + 8 >> 2] - d19)) < 0.0 | 0;
 }
 d29 = d24 * d35 - d26 * d33;
 d27 = d26 * d31 - d22 * d35;
 d28 = d22 * d33 - d24 * d31;
 d36 = d14 * d29 + d17 * d27 + d28 * d20;
 if (d36 * d36 < 9.99999905104687e-9) {
  i38 = -1;
 } else {
  i38 = d36 * (d27 * (+HEAPF32[i2 + 4 >> 2] - d16) + d29 * (+HEAPF32[i2 >> 2] - d13) + d28 * (+HEAPF32[i2 + 8 >> 2] - d19)) < 0.0 | 0;
 }
 d28 = d33 * d20 - d35 * d17;
 d29 = d35 * d14 - d31 * d20;
 d20 = d31 * d17 - d33 * d14;
 d14 = d22 * d28 + d24 * d29 + d20 * d26;
 if (d14 * d14 < 9.99999905104687e-9) {
  i39 = -1;
 } else {
  i39 = d14 * (d29 * (+HEAPF32[i2 + 4 >> 2] - d16) + d28 * (+HEAPF32[i2 >> 2] - d13) + d20 * (+HEAPF32[i2 + 8 >> 2] - d19)) < 0.0 | 0;
 }
 d20 = d30 - d12;
 d30 = d32 - d15;
 d32 = d34 - d18;
 d34 = d21 - d12;
 d21 = d23 - d15;
 d23 = d25 - d18;
 d25 = d30 * d23 - d32 * d21;
 d28 = d32 * d34 - d20 * d23;
 d23 = d20 * d21 - d30 * d34;
 d34 = (d13 - d12) * d25 + (d16 - d15) * d28 + d23 * (d19 - d18);
 if (d34 * d34 < 9.99999905104687e-9) {
  i40 = -1;
 } else {
  i40 = d34 * (d28 * (+HEAPF32[i2 + 4 >> 2] - d15) + d25 * (+HEAPF32[i2 >> 2] - d12) + d23 * (+HEAPF32[i2 + 8 >> 2] - d18)) < 0.0 | 0;
 }
 if ((i38 | i37 | i39 | i40 | 0) < 0) {
  HEAP8[i7 + 36 | 0] = 1;
  i41 = 0;
  STACKTOP = i1;
  return i41 | 0;
 }
 i10 = (i37 | 0) != 0;
 i37 = (i38 | 0) == 0;
 i38 = (i39 | 0) == 0;
 i39 = (i40 | 0) == 0;
 if (i37 & (i10 ^ 1) & i38 & i39) {
  i41 = 0;
  STACKTOP = i1;
  return i41 | 0;
 }
 do {
  if (i10) {
   __ZN22btVoronoiSimplexSolver22closestPtPointTriangleERK9btVector3S2_S2_S2_R25btSubSimplexClosestResult(0, i2, i3, i4, i5, i8) | 0;
   d18 = +HEAPF32[i8 >> 2];
   d23 = +HEAPF32[i8 + 4 >> 2];
   d12 = +HEAPF32[i8 + 8 >> 2];
   d25 = d18 - +HEAPF32[i2 >> 2];
   d15 = d23 - +HEAPF32[i2 + 4 >> 2];
   d28 = d12 - +HEAPF32[i2 + 8 >> 2];
   d34 = d25 * d25 + d15 * d15 + d28 * d28;
   if (d34 >= 3.4028234663852886e+38) {
    d42 = 3.4028234663852886e+38;
    break;
   }
   d28 = +HEAPF32[i8 + 12 >> 2];
   HEAPF32[i7 >> 2] = d18;
   HEAPF32[i7 + 4 >> 2] = d23;
   HEAPF32[i7 + 8 >> 2] = d12;
   HEAPF32[i7 + 12 >> 2] = d28;
   i40 = HEAP16[i9 >> 1] | 0;
   HEAP16[i11 >> 1] = i40 & 1 | HEAP16[i11 >> 1] & -16 | i40 & 2 | i40 & 4;
   d28 = +HEAPF32[i8 + 24 >> 2];
   d12 = +HEAPF32[i8 + 28 >> 2];
   HEAPF32[i7 + 20 >> 2] = +HEAPF32[i8 + 20 >> 2];
   HEAPF32[i7 + 24 >> 2] = d28;
   HEAPF32[i7 + 28 >> 2] = d12;
   HEAPF32[i7 + 32 >> 2] = 0.0;
   d42 = d34;
  } else {
   d42 = 3.4028234663852886e+38;
  }
 } while (0);
 do {
  if (i37) {
   d43 = d42;
  } else {
   __ZN22btVoronoiSimplexSolver22closestPtPointTriangleERK9btVector3S2_S2_S2_R25btSubSimplexClosestResult(0, i2, i3, i5, i6, i8) | 0;
   d34 = +HEAPF32[i8 >> 2];
   d12 = +HEAPF32[i8 + 4 >> 2];
   d28 = +HEAPF32[i8 + 8 >> 2];
   d23 = d34 - +HEAPF32[i2 >> 2];
   d18 = d12 - +HEAPF32[i2 + 4 >> 2];
   d15 = d28 - +HEAPF32[i2 + 8 >> 2];
   d25 = d23 * d23 + d18 * d18 + d15 * d15;
   if (d25 >= d42) {
    d43 = d42;
    break;
   }
   d15 = +HEAPF32[i8 + 12 >> 2];
   HEAPF32[i7 >> 2] = d34;
   HEAPF32[i7 + 4 >> 2] = d12;
   HEAPF32[i7 + 8 >> 2] = d28;
   HEAPF32[i7 + 12 >> 2] = d15;
   i10 = HEAP16[i9 >> 1] | 0;
   HEAP16[i11 >> 1] = i10 & 1 | HEAP16[i11 >> 1] & -16 | (i10 & 65535) >>> 1 << 2 & 4 | (i10 & 65535) >>> 2 << 3 & 8;
   d15 = +HEAPF32[i8 + 24 >> 2];
   d28 = +HEAPF32[i8 + 28 >> 2];
   HEAPF32[i7 + 20 >> 2] = +HEAPF32[i8 + 20 >> 2];
   HEAPF32[i7 + 24 >> 2] = 0.0;
   HEAPF32[i7 + 28 >> 2] = d15;
   HEAPF32[i7 + 32 >> 2] = d28;
   d43 = d25;
  }
 } while (0);
 do {
  if (i38) {
   d44 = d43;
  } else {
   __ZN22btVoronoiSimplexSolver22closestPtPointTriangleERK9btVector3S2_S2_S2_R25btSubSimplexClosestResult(0, i2, i3, i6, i4, i8) | 0;
   d42 = +HEAPF32[i8 >> 2];
   d25 = +HEAPF32[i8 + 4 >> 2];
   d28 = +HEAPF32[i8 + 8 >> 2];
   d15 = d42 - +HEAPF32[i2 >> 2];
   d12 = d25 - +HEAPF32[i2 + 4 >> 2];
   d34 = d28 - +HEAPF32[i2 + 8 >> 2];
   d18 = d15 * d15 + d12 * d12 + d34 * d34;
   if (d18 >= d43) {
    d44 = d43;
    break;
   }
   d34 = +HEAPF32[i8 + 12 >> 2];
   HEAPF32[i7 >> 2] = d42;
   HEAPF32[i7 + 4 >> 2] = d25;
   HEAPF32[i7 + 8 >> 2] = d28;
   HEAPF32[i7 + 12 >> 2] = d34;
   i37 = HEAP16[i9 >> 1] | 0;
   HEAP16[i11 >> 1] = i37 & 1 | HEAP16[i11 >> 1] & -16 | (i37 & 65535) >>> 2 << 1 & 2 | (i37 & 65535) >>> 1 << 3 & 8;
   d34 = +HEAPF32[i8 + 28 >> 2];
   d28 = +HEAPF32[i8 + 24 >> 2];
   HEAPF32[i7 + 20 >> 2] = +HEAPF32[i8 + 20 >> 2];
   HEAPF32[i7 + 24 >> 2] = d34;
   HEAPF32[i7 + 28 >> 2] = 0.0;
   HEAPF32[i7 + 32 >> 2] = d28;
   d44 = d18;
  }
 } while (0);
 if (i39) {
  i41 = 1;
  STACKTOP = i1;
  return i41 | 0;
 }
 __ZN22btVoronoiSimplexSolver22closestPtPointTriangleERK9btVector3S2_S2_S2_R25btSubSimplexClosestResult(0, i2, i4, i6, i5, i8) | 0;
 d43 = +HEAPF32[i8 >> 2];
 d18 = +HEAPF32[i8 + 4 >> 2];
 d28 = +HEAPF32[i8 + 8 >> 2];
 d34 = d43 - +HEAPF32[i2 >> 2];
 d25 = d18 - +HEAPF32[i2 + 4 >> 2];
 d42 = d28 - +HEAPF32[i2 + 8 >> 2];
 if (d34 * d34 + d25 * d25 + d42 * d42 >= d44) {
  i41 = 1;
  STACKTOP = i1;
  return i41 | 0;
 }
 d44 = +HEAPF32[i8 + 12 >> 2];
 HEAPF32[i7 >> 2] = d43;
 HEAPF32[i7 + 4 >> 2] = d18;
 HEAPF32[i7 + 8 >> 2] = d28;
 HEAPF32[i7 + 12 >> 2] = d44;
 i2 = HEAP16[i9 >> 1] | 0;
 HEAP16[i11 >> 1] = i2 & 4 | HEAP16[i11 >> 1] & -16 | i2 << 1 & 2 | (i2 & 65535) >>> 1 << 3 & 8;
 d44 = +HEAPF32[i8 + 20 >> 2];
 d28 = +HEAPF32[i8 + 28 >> 2];
 d18 = +HEAPF32[i8 + 24 >> 2];
 HEAPF32[i7 + 20 >> 2] = 0.0;
 HEAPF32[i7 + 24 >> 2] = d44;
 HEAPF32[i7 + 28 >> 2] = d28;
 HEAPF32[i7 + 32 >> 2] = d18;
 i41 = 1;
 STACKTOP = i1;
 return i41 | 0;
}
function __ZN35btSequentialImpulseConstraintSolver20solveSingleIterationEiPP17btCollisionObjectiPP20btPersistentManifoldiPP17btTypedConstraintiRK19btContactSolverInfoP12btIDebugDrawP12btStackAlloc(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 i7 = i7 | 0;
 i8 = i8 | 0;
 i9 = i9 | 0;
 i10 = i10 | 0;
 i11 = i11 | 0;
 var i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, d27 = 0.0, d28 = 0.0;
 i11 = i1 + 8 | 0;
 i10 = HEAP32[i11 >> 2] | 0;
 i6 = i1 + 48 | 0;
 i5 = HEAP32[i6 >> 2] | 0;
 i4 = i9 + 60 | 0;
 i3 = HEAP32[i4 >> 2] | 0;
 do {
  if ((i3 & 1 | 0) == 0) {
   i12 = i3;
  } else {
   if ((i2 & 7 | 0) != 0) {
    i12 = i3;
    break;
   }
   if ((i10 | 0) > 0) {
    i13 = HEAP32[i1 + 76 >> 2] | 0;
    i14 = i1 + 124 | 0;
    i15 = 0;
    i16 = HEAP32[i14 >> 2] | 0;
    do {
     i17 = i13 + (i15 << 2) | 0;
     i18 = HEAP32[i17 >> 2] | 0;
     i15 = i15 + 1 | 0;
     i16 = (Math_imul(i16, 1664525) | 0) + 1013904223 | 0;
     do {
      if (i15 >>> 0 < 65537) {
       i19 = i16 >>> 16 ^ i16;
       if (i15 >>> 0 >= 257) {
        i20 = i19;
        break;
       }
       i21 = i19 >>> 8 ^ i19;
       if (i15 >>> 0 >= 17) {
        i20 = i21;
        break;
       }
       i19 = i21 >>> 4 ^ i21;
       if (i15 >>> 0 >= 5) {
        i20 = i19;
        break;
       }
       i21 = i19 >>> 2 ^ i19;
       if (i15 >>> 0 >= 3) {
        i20 = i21;
        break;
       }
       i20 = i21 >>> 1 ^ i21;
      } else {
       i20 = i16;
      }
     } while (0);
     i21 = i13 + (((i20 >>> 0) % (i15 >>> 0) | 0) << 2) | 0;
     HEAP32[i17 >> 2] = HEAP32[i21 >> 2];
     HEAP32[i21 >> 2] = i18;
    } while ((i15 | 0) < (i10 | 0));
    HEAP32[i14 >> 2] = i16;
   }
   if ((i5 | 0) > 0) {
    i15 = HEAP32[i1 + 96 >> 2] | 0;
    i13 = i1 + 124 | 0;
    i21 = 0;
    i19 = HEAP32[i13 >> 2] | 0;
    do {
     i22 = i15 + (i21 << 2) | 0;
     i23 = HEAP32[i22 >> 2] | 0;
     i21 = i21 + 1 | 0;
     i19 = (Math_imul(i19, 1664525) | 0) + 1013904223 | 0;
     do {
      if (i21 >>> 0 < 65537) {
       i24 = i19 >>> 16 ^ i19;
       if (i21 >>> 0 >= 257) {
        i25 = i24;
        break;
       }
       i26 = i24 >>> 8 ^ i24;
       if (i21 >>> 0 >= 17) {
        i25 = i26;
        break;
       }
       i24 = i26 >>> 4 ^ i26;
       if (i21 >>> 0 >= 5) {
        i25 = i24;
        break;
       }
       i26 = i24 >>> 2 ^ i24;
       if (i21 >>> 0 >= 3) {
        i25 = i26;
        break;
       }
       i25 = i26 >>> 1 ^ i26;
      } else {
       i25 = i19;
      }
     } while (0);
     i18 = i15 + (((i25 >>> 0) % (i21 >>> 0) | 0) << 2) | 0;
     HEAP32[i22 >> 2] = HEAP32[i18 >> 2];
     HEAP32[i18 >> 2] = i23;
    } while ((i21 | 0) < (i5 | 0));
    HEAP32[i13 >> 2] = i19;
   }
   i12 = HEAP32[i4 >> 2] | 0;
  }
 } while (0);
 i4 = i1 + 28 | 0;
 i5 = (HEAP32[i4 >> 2] | 0) > 0;
 if ((i12 & 256 | 0) == 0) {
  if (i5) {
   i12 = i1 + 36 | 0;
   i25 = 0;
   do {
    i10 = HEAP32[i12 >> 2] | 0;
    __ZN35btSequentialImpulseConstraintSolver33resolveSingleConstraintRowGenericER11btRigidBodyS1_RK18btSolverConstraint(0, HEAP32[i10 + (i25 * 136 | 0) + 104 >> 2] | 0, HEAP32[i10 + (i25 * 136 | 0) + 108 >> 2] | 0, i10 + (i25 * 136 | 0) | 0);
    i25 = i25 + 1 | 0;
   } while ((i25 | 0) < (HEAP32[i4 >> 2] | 0));
  }
  if ((i8 | 0) > 0) {
   i25 = i9 + 12 | 0;
   i12 = 0;
   do {
    i10 = HEAP32[i7 + (i12 << 2) >> 2] | 0;
    FUNCTION_TABLE_viiif[HEAP32[(HEAP32[i10 >> 2] | 0) + 24 >> 2] & 15](i10, HEAP32[i10 + 24 >> 2] | 0, HEAP32[i10 + 28 >> 2] | 0, +HEAPF32[i25 >> 2]);
    i12 = i12 + 1 | 0;
   } while ((i12 | 0) < (i8 | 0));
  }
  i12 = HEAP32[i11 >> 2] | 0;
  if ((i12 | 0) > 0) {
   i25 = i1 + 76 | 0;
   i10 = i1 + 16 | 0;
   i20 = 0;
   do {
    i3 = HEAP32[(HEAP32[i25 >> 2] | 0) + (i20 << 2) >> 2] | 0;
    i2 = HEAP32[i10 >> 2] | 0;
    __ZN35btSequentialImpulseConstraintSolver36resolveSingleConstraintRowLowerLimitER11btRigidBodyS1_RK18btSolverConstraint(0, HEAP32[i2 + (i3 * 136 | 0) + 104 >> 2] | 0, HEAP32[i2 + (i3 * 136 | 0) + 108 >> 2] | 0, i2 + (i3 * 136 | 0) | 0);
    i20 = i20 + 1 | 0;
   } while ((i20 | 0) < (i12 | 0));
  }
  i12 = HEAP32[i6 >> 2] | 0;
  if ((i12 | 0) <= 0) {
   return +0.0;
  }
  i20 = i1 + 96 | 0;
  i10 = i1 + 56 | 0;
  i25 = i1 + 16 | 0;
  i3 = 0;
  do {
   i2 = HEAP32[(HEAP32[i20 >> 2] | 0) + (i3 << 2) >> 2] | 0;
   i21 = HEAP32[i10 >> 2] | 0;
   d27 = +HEAPF32[(HEAP32[i25 >> 2] | 0) + ((HEAP32[i21 + (i2 * 136 | 0) + 100 >> 2] | 0) * 136 | 0) + 84 >> 2];
   if (d27 > 0.0) {
    d28 = d27 * +HEAPF32[i21 + (i2 * 136 | 0) + 88 >> 2];
    HEAPF32[i21 + (i2 * 136 | 0) + 124 >> 2] = -0.0 - d28;
    HEAPF32[i21 + (i2 * 136 | 0) + 128 >> 2] = d28;
    __ZN35btSequentialImpulseConstraintSolver33resolveSingleConstraintRowGenericER11btRigidBodyS1_RK18btSolverConstraint(0, HEAP32[i21 + (i2 * 136 | 0) + 104 >> 2] | 0, HEAP32[i21 + (i2 * 136 | 0) + 108 >> 2] | 0, i21 + (i2 * 136 | 0) | 0);
   }
   i3 = i3 + 1 | 0;
  } while ((i3 | 0) < (i12 | 0));
  return +0.0;
 } else {
  if (i5) {
   i5 = i1 + 36 | 0;
   i12 = 0;
   do {
    i3 = HEAP32[i5 >> 2] | 0;
    __ZN35btSequentialImpulseConstraintSolver33resolveSingleConstraintRowGenericER11btRigidBodyS1_RK18btSolverConstraint(0, HEAP32[i3 + (i12 * 136 | 0) + 104 >> 2] | 0, HEAP32[i3 + (i12 * 136 | 0) + 108 >> 2] | 0, i3 + (i12 * 136 | 0) | 0);
    i12 = i12 + 1 | 0;
   } while ((i12 | 0) < (HEAP32[i4 >> 2] | 0));
  }
  if ((i8 | 0) > 0) {
   i4 = i9 + 12 | 0;
   i9 = 0;
   do {
    i12 = HEAP32[i7 + (i9 << 2) >> 2] | 0;
    FUNCTION_TABLE_viiif[HEAP32[(HEAP32[i12 >> 2] | 0) + 24 >> 2] & 15](i12, HEAP32[i12 + 24 >> 2] | 0, HEAP32[i12 + 28 >> 2] | 0, +HEAPF32[i4 >> 2]);
    i9 = i9 + 1 | 0;
   } while ((i9 | 0) < (i8 | 0));
  }
  i8 = HEAP32[i11 >> 2] | 0;
  if ((i8 | 0) > 0) {
   i11 = i1 + 76 | 0;
   i9 = i1 + 16 | 0;
   i4 = 0;
   do {
    i7 = HEAP32[(HEAP32[i11 >> 2] | 0) + (i4 << 2) >> 2] | 0;
    i12 = HEAP32[i9 >> 2] | 0;
    __ZN35btSequentialImpulseConstraintSolver36resolveSingleConstraintRowLowerLimitER11btRigidBodyS1_RK18btSolverConstraint(0, HEAP32[i12 + (i7 * 136 | 0) + 104 >> 2] | 0, HEAP32[i12 + (i7 * 136 | 0) + 108 >> 2] | 0, i12 + (i7 * 136 | 0) | 0);
    i4 = i4 + 1 | 0;
   } while ((i4 | 0) < (i8 | 0));
  }
  i8 = HEAP32[i6 >> 2] | 0;
  if ((i8 | 0) <= 0) {
   return +0.0;
  }
  i6 = i1 + 96 | 0;
  i4 = i1 + 56 | 0;
  i9 = i1 + 16 | 0;
  i1 = 0;
  do {
   i11 = HEAP32[(HEAP32[i6 >> 2] | 0) + (i1 << 2) >> 2] | 0;
   i7 = HEAP32[i4 >> 2] | 0;
   d28 = +HEAPF32[(HEAP32[i9 >> 2] | 0) + ((HEAP32[i7 + (i11 * 136 | 0) + 100 >> 2] | 0) * 136 | 0) + 84 >> 2];
   if (d28 > 0.0) {
    d27 = d28 * +HEAPF32[i7 + (i11 * 136 | 0) + 88 >> 2];
    HEAPF32[i7 + (i11 * 136 | 0) + 124 >> 2] = -0.0 - d27;
    HEAPF32[i7 + (i11 * 136 | 0) + 128 >> 2] = d27;
    __ZN35btSequentialImpulseConstraintSolver33resolveSingleConstraintRowGenericER11btRigidBodyS1_RK18btSolverConstraint(0, HEAP32[i7 + (i11 * 136 | 0) + 104 >> 2] | 0, HEAP32[i7 + (i11 * 136 | 0) + 108 >> 2] | 0, i7 + (i11 * 136 | 0) | 0);
   }
   i1 = i1 + 1 | 0;
  } while ((i1 | 0) < (i8 | 0));
  return +0.0;
 }
 return 0.0;
}
function __ZN27btContinuousConvexCollision20computeClosestPointsERK11btTransformS2_R16btPointCollector(i1, i2, i3, i4) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 var i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, d15 = 0.0, d16 = 0.0, d17 = 0.0, d18 = 0.0, d19 = 0.0, d20 = 0.0, d21 = 0.0, d22 = 0.0, d23 = 0.0, d24 = 0.0, d25 = 0.0, d26 = 0.0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, d36 = 0.0, d37 = 0.0, d38 = 0.0, d39 = 0.0, d40 = 0.0, d41 = 0.0, d42 = 0.0, d43 = 0.0, d44 = 0.0, i45 = 0, d46 = 0.0, i47 = 0, d48 = 0.0, i49 = 0, d50 = 0.0, d51 = 0.0, d52 = 0.0, d53 = 0.0, d54 = 0.0, d55 = 0.0, d56 = 0.0, d57 = 0.0, i58 = 0, i59 = 0, i60 = 0, i61 = 0;
 i5 = STACKTOP;
 STACKTOP = STACKTOP + 280 | 0;
 i6 = i5 | 0;
 i7 = i5 + 80 | 0;
 i8 = i5 + 216 | 0;
 i9 = i5 + 232 | 0;
 i10 = i5 + 248 | 0;
 i11 = i5 + 264 | 0;
 i12 = i1 + 16 | 0;
 if ((HEAP32[i12 >> 2] | 0) == 0) {
  i13 = HEAP32[i1 + 12 >> 2] | 0;
  i14 = HEAP32[i1 + 20 >> 2] | 0;
  d15 = +HEAPF32[i2 >> 2];
  d16 = +HEAPF32[i2 + 4 >> 2];
  d17 = +HEAPF32[i2 + 8 >> 2];
  d18 = +HEAPF32[i2 + 16 >> 2];
  d19 = +HEAPF32[i2 + 20 >> 2];
  d20 = +HEAPF32[i2 + 24 >> 2];
  d21 = +HEAPF32[i2 + 32 >> 2];
  d22 = +HEAPF32[i2 + 36 >> 2];
  d23 = +HEAPF32[i2 + 40 >> 2];
  d24 = +HEAPF32[i2 + 48 >> 2];
  d25 = +HEAPF32[i2 + 52 >> 2];
  d26 = +HEAPF32[i2 + 56 >> 2];
  i27 = i3 | 0;
  i28 = i3 + 16 | 0;
  i29 = i3 + 32 | 0;
  i30 = i3 + 4 | 0;
  i31 = i3 + 20 | 0;
  i32 = i3 + 36 | 0;
  i33 = i3 + 8 | 0;
  i34 = i3 + 24 | 0;
  i35 = i3 + 40 | 0;
  d36 = +HEAPF32[i27 >> 2];
  d37 = +HEAPF32[i28 >> 2];
  d38 = +HEAPF32[i29 >> 2];
  d39 = +HEAPF32[i30 >> 2];
  d40 = +HEAPF32[i31 >> 2];
  d41 = +HEAPF32[i32 >> 2];
  d42 = +HEAPF32[i33 >> 2];
  d43 = +HEAPF32[i34 >> 2];
  d44 = +HEAPF32[i35 >> 2];
  i45 = i3 + 48 | 0;
  d46 = -0.0 - +HEAPF32[i45 >> 2];
  i47 = i3 + 52 | 0;
  d48 = -0.0 - +HEAPF32[i47 >> 2];
  i49 = i3 + 56 | 0;
  d50 = -0.0 - +HEAPF32[i49 >> 2];
  d51 = d15 * d36 + d18 * d37 + d21 * d38;
  d52 = d16 * d36 + d19 * d37 + d22 * d38;
  d53 = d17 * d36 + d20 * d37 + d23 * d38;
  d54 = d15 * d39 + d18 * d40 + d21 * d41;
  d55 = d16 * d39 + d19 * d40 + d22 * d41;
  d56 = d17 * d39 + d20 * d40 + d23 * d41;
  d57 = d15 * d42 + d18 * d43 + d21 * d44;
  d21 = d16 * d42 + d19 * d43 + d22 * d44;
  d22 = d17 * d42 + d20 * d43 + d23 * d44;
  i58 = HEAP32[(HEAP32[i13 >> 2] | 0) + 60 >> 2] | 0;
  i59 = i14 + 48 | 0;
  d23 = -0.0 - +HEAPF32[i59 >> 2];
  i60 = i14 + 52 | 0;
  d20 = -0.0 - +HEAPF32[i60 >> 2];
  i61 = i14 + 56 | 0;
  d17 = -0.0 - +HEAPF32[i61 >> 2];
  HEAPF32[i9 >> 2] = d51 * d23 + d54 * d20 + d57 * d17;
  HEAPF32[i9 + 4 >> 2] = d52 * d23 + d55 * d20 + d21 * d17;
  HEAPF32[i9 + 8 >> 2] = d53 * d23 + d56 * d20 + d22 * d17;
  HEAPF32[i9 + 12 >> 2] = 0.0;
  FUNCTION_TABLE_viii[i58 & 127](i8, i13, i9);
  d17 = +HEAPF32[i8 >> 2];
  d20 = +HEAPF32[i8 + 4 >> 2];
  d23 = +HEAPF32[i8 + 8 >> 2];
  d19 = d24 * d36 + d25 * d37 + d26 * d38 + (d36 * d46 + d37 * d48 + d38 * d50) + (d51 * d17 + d52 * d20 + d53 * d23);
  d53 = d24 * d39 + d25 * d40 + d26 * d41 + (d39 * d46 + d40 * d48 + d41 * d50) + (d54 * d17 + d55 * d20 + d56 * d23);
  d56 = d24 * d42 + d25 * d43 + d26 * d44 + (d42 * d46 + d43 * d48 + d44 * d50) + (d57 * d17 + d21 * d20 + d22 * d23);
  d23 = +HEAPF32[i59 >> 2];
  d22 = +HEAPF32[i60 >> 2];
  d20 = +HEAPF32[i61 >> 2];
  d21 = d20 * d56 + (d23 * d19 + d22 * d53) - +HEAPF32[i14 + 64 >> 2];
  d17 = d19 - d23 * d21;
  d23 = d53 - d22 * d21;
  d22 = d56 - d20 * d21;
  d20 = +HEAPF32[i27 >> 2];
  d56 = +HEAPF32[i30 >> 2];
  d53 = +HEAPF32[i33 >> 2];
  d19 = +HEAPF32[i28 >> 2];
  d57 = +HEAPF32[i31 >> 2];
  d50 = +HEAPF32[i34 >> 2];
  d44 = +HEAPF32[i47 >> 2] + (d17 * d19 + d23 * d57 + d22 * d50);
  d48 = +HEAPF32[i29 >> 2];
  d43 = +HEAPF32[i32 >> 2];
  d46 = +HEAPF32[i35 >> 2];
  d42 = +HEAPF32[i49 >> 2] + (d17 * d48 + d23 * d43 + d22 * d46);
  HEAPF32[i10 >> 2] = +HEAPF32[i45 >> 2] + (d53 * d22 + (d20 * d17 + d56 * d23));
  HEAPF32[i10 + 4 >> 2] = d44;
  HEAPF32[i10 + 8 >> 2] = d42;
  HEAPF32[i10 + 12 >> 2] = 0.0;
  d42 = +HEAPF32[i59 >> 2];
  d44 = +HEAPF32[i60 >> 2];
  d23 = +HEAPF32[i61 >> 2];
  HEAPF32[i11 >> 2] = d20 * d42 + d56 * d44 + d53 * d23;
  HEAPF32[i11 + 4 >> 2] = d19 * d42 + d57 * d44 + d50 * d23;
  HEAPF32[i11 + 8 >> 2] = d48 * d42 + d43 * d44 + d46 * d23;
  HEAPF32[i11 + 12 >> 2] = 0.0;
  FUNCTION_TABLE_viiif[HEAP32[(HEAP32[i4 >> 2] | 0) + 16 >> 2] & 15](i4, i11, i10, d21);
  STACKTOP = i5;
  return;
 } else {
  i10 = i1 + 4 | 0;
  __ZN22btVoronoiSimplexSolver5resetEv(HEAP32[i10 >> 2] | 0);
  i11 = HEAP32[i1 + 12 >> 2] | 0;
  i61 = HEAP32[i12 >> 2] | 0;
  i60 = HEAP32[i11 + 4 >> 2] | 0;
  i59 = HEAP32[i61 + 4 >> 2] | 0;
  d21 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i11 >> 2] | 0) + 44 >> 2] & 7](i11);
  i45 = HEAP32[i12 >> 2] | 0;
  d23 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i45 >> 2] | 0) + 44 >> 2] & 7](i45);
  __ZN17btGjkPairDetectorC2EPK13btConvexShapeS2_iiffP22btVoronoiSimplexSolverP30btConvexPenetrationDepthSolver(i6, i11, i61, i60, i59, d21, d23, HEAP32[i10 >> 2] | 0, HEAP32[i1 + 8 >> 2] | 0);
  HEAPF32[i7 + 128 >> 2] = 999999984306749400.0;
  HEAP32[i7 + 132 >> 2] = 0;
  i1 = i7;
  i10 = i2;
  HEAP32[i1 >> 2] = HEAP32[i10 >> 2];
  HEAP32[i1 + 4 >> 2] = HEAP32[i10 + 4 >> 2];
  HEAP32[i1 + 8 >> 2] = HEAP32[i10 + 8 >> 2];
  HEAP32[i1 + 12 >> 2] = HEAP32[i10 + 12 >> 2];
  i10 = i7 + 16 | 0;
  i1 = i2 + 16 | 0;
  HEAP32[i10 >> 2] = HEAP32[i1 >> 2];
  HEAP32[i10 + 4 >> 2] = HEAP32[i1 + 4 >> 2];
  HEAP32[i10 + 8 >> 2] = HEAP32[i1 + 8 >> 2];
  HEAP32[i10 + 12 >> 2] = HEAP32[i1 + 12 >> 2];
  i1 = i7 + 32 | 0;
  i10 = i2 + 32 | 0;
  HEAP32[i1 >> 2] = HEAP32[i10 >> 2];
  HEAP32[i1 + 4 >> 2] = HEAP32[i10 + 4 >> 2];
  HEAP32[i1 + 8 >> 2] = HEAP32[i10 + 8 >> 2];
  HEAP32[i1 + 12 >> 2] = HEAP32[i10 + 12 >> 2];
  i10 = i7 + 48 | 0;
  i1 = i2 + 48 | 0;
  HEAP32[i10 >> 2] = HEAP32[i1 >> 2];
  HEAP32[i10 + 4 >> 2] = HEAP32[i1 + 4 >> 2];
  HEAP32[i10 + 8 >> 2] = HEAP32[i1 + 8 >> 2];
  HEAP32[i10 + 12 >> 2] = HEAP32[i1 + 12 >> 2];
  i1 = i7 + 64 | 0;
  i10 = i3;
  HEAP32[i1 >> 2] = HEAP32[i10 >> 2];
  HEAP32[i1 + 4 >> 2] = HEAP32[i10 + 4 >> 2];
  HEAP32[i1 + 8 >> 2] = HEAP32[i10 + 8 >> 2];
  HEAP32[i1 + 12 >> 2] = HEAP32[i10 + 12 >> 2];
  i10 = i7 + 80 | 0;
  i1 = i3 + 16 | 0;
  HEAP32[i10 >> 2] = HEAP32[i1 >> 2];
  HEAP32[i10 + 4 >> 2] = HEAP32[i1 + 4 >> 2];
  HEAP32[i10 + 8 >> 2] = HEAP32[i1 + 8 >> 2];
  HEAP32[i10 + 12 >> 2] = HEAP32[i1 + 12 >> 2];
  i1 = i7 + 96 | 0;
  i10 = i3 + 32 | 0;
  HEAP32[i1 >> 2] = HEAP32[i10 >> 2];
  HEAP32[i1 + 4 >> 2] = HEAP32[i10 + 4 >> 2];
  HEAP32[i1 + 8 >> 2] = HEAP32[i10 + 8 >> 2];
  HEAP32[i1 + 12 >> 2] = HEAP32[i10 + 12 >> 2];
  i10 = i7 + 112 | 0;
  i1 = i3 + 48 | 0;
  HEAP32[i10 >> 2] = HEAP32[i1 >> 2];
  HEAP32[i10 + 4 >> 2] = HEAP32[i1 + 4 >> 2];
  HEAP32[i10 + 8 >> 2] = HEAP32[i1 + 8 >> 2];
  HEAP32[i10 + 12 >> 2] = HEAP32[i1 + 12 >> 2];
  __ZN17btGjkPairDetector16getClosestPointsERKN36btDiscreteCollisionDetectorInterface17ClosestPointInputERNS0_6ResultEP12btIDebugDrawb(i6, i7, i4 | 0, 0, 0);
  STACKTOP = i5;
  return;
 }
}
function __ZN16btCollisionWorld14debugDrawWorldEv(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, d42 = 0.0, d43 = 0.0, d44 = 0.0, d45 = 0.0, d46 = 0.0, d47 = 0.0, d48 = 0.0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 112 | 0;
 i3 = i2 | 0;
 i4 = i2 + 16 | 0;
 i5 = i2 + 32 | 0;
 i6 = i2 + 48 | 0;
 i7 = i2 + 64 | 0;
 i8 = i2 + 80 | 0;
 i9 = i2 + 96 | 0;
 i10 = i1;
 do {
  if ((FUNCTION_TABLE_ii[HEAP32[(HEAP32[i10 >> 2] | 0) + 16 >> 2] & 127](i1) | 0) != 0) {
   i11 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i10 >> 2] | 0) + 16 >> 2] & 127](i1) | 0;
   if (((FUNCTION_TABLE_ii[HEAP32[(HEAP32[i11 >> 2] | 0) + 48 >> 2] & 127](i11) | 0) & 8 | 0) == 0) {
    break;
   }
   i11 = i1 + 24 | 0;
   i12 = HEAP32[i11 >> 2] | 0;
   i13 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i12 >> 2] | 0) + 36 >> 2] & 127](i12) | 0;
   _memset(i3 | 0, 0, 16);
   if ((i13 | 0) > 0) {
    i14 = 0;
   } else {
    break;
   }
   do {
    i12 = HEAP32[i11 >> 2] | 0;
    i15 = FUNCTION_TABLE_iii[HEAP32[(HEAP32[i12 >> 2] | 0) + 40 >> 2] & 63](i12, i14) | 0;
    i12 = HEAP32[i15 + 1116 >> 2] | 0;
    if ((i12 | 0) > 0) {
     i16 = 0;
     do {
      i17 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i10 >> 2] | 0) + 16 >> 2] & 127](i1) | 0;
      FUNCTION_TABLE_viiifii[HEAP32[(HEAP32[i17 >> 2] | 0) + 32 >> 2] & 1](i17, i15 + 4 + (i16 * 276 | 0) + 32 | 0, i15 + 4 + (i16 * 276 | 0) + 64 | 0, +HEAPF32[i15 + 4 + (i16 * 276 | 0) + 80 >> 2], HEAP32[i15 + 4 + (i16 * 276 | 0) + 144 >> 2] | 0, i3);
      i16 = i16 + 1 | 0;
     } while ((i16 | 0) < (i12 | 0));
    }
    i14 = i14 + 1 | 0;
   } while ((i14 | 0) < (i13 | 0));
  }
 } while (0);
 if ((FUNCTION_TABLE_ii[HEAP32[(HEAP32[i10 >> 2] | 0) + 16 >> 2] & 127](i1) | 0) == 0) {
  STACKTOP = i2;
  return;
 }
 i14 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i10 >> 2] | 0) + 16 >> 2] & 127](i1) | 0;
 if (((FUNCTION_TABLE_ii[HEAP32[(HEAP32[i14 >> 2] | 0) + 48 >> 2] & 127](i14) | 0) & 3 | 0) == 0) {
  STACKTOP = i2;
  return;
 }
 i14 = i1 + 8 | 0;
 if ((HEAP32[i14 >> 2] | 0) <= 0) {
  STACKTOP = i2;
  return;
 }
 i3 = i1 + 16 | 0;
 i13 = i1 + 80 | 0;
 i11 = i7 | 0;
 i12 = i7 + 4 | 0;
 i16 = i7 + 8 | 0;
 i15 = i7 + 12 | 0;
 i17 = i5 | 0;
 i18 = i5 + 4 | 0;
 i19 = i5 + 8 | 0;
 i20 = i6 | 0;
 i21 = i6 + 4 | 0;
 i22 = i6 + 8 | 0;
 i23 = i8 | 0;
 i24 = i8 + 4 | 0;
 i25 = i8 + 8 | 0;
 i26 = i9 | 0;
 i27 = i9 + 4 | 0;
 i28 = i9 + 8 | 0;
 i29 = i5 + 12 | 0;
 i30 = i8 + 12 | 0;
 i31 = i6 + 12 | 0;
 i32 = i9 + 12 | 0;
 i33 = i4 | 0;
 i34 = i4 + 4 | 0;
 i35 = i4 + 8 | 0;
 i36 = i4 + 12 | 0;
 i37 = i1;
 i38 = 0;
 do {
  i39 = HEAP32[(HEAP32[i3 >> 2] | 0) + (i38 << 2) >> 2] | 0;
  do {
   if ((HEAP32[i39 + 204 >> 2] & 32 | 0) == 0) {
    do {
     if ((FUNCTION_TABLE_ii[HEAP32[(HEAP32[i10 >> 2] | 0) + 16 >> 2] & 127](i1) | 0) != 0) {
      i40 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i10 >> 2] | 0) + 16 >> 2] & 127](i1) | 0;
      if (((FUNCTION_TABLE_ii[HEAP32[(HEAP32[i40 >> 2] | 0) + 48 >> 2] & 127](i40) | 0) & 1 | 0) == 0) {
       break;
      }
      HEAPF32[i33 >> 2] = 1.0;
      HEAPF32[i34 >> 2] = 1.0;
      HEAPF32[i35 >> 2] = 1.0;
      HEAPF32[i36 >> 2] = 0.0;
      switch (HEAP32[i39 + 216 >> 2] | 0) {
      case 5:
       {
        HEAPF32[i33 >> 2] = 1.0;
        HEAPF32[i34 >> 2] = 1.0;
        HEAPF32[i35 >> 2] = 0.0;
        HEAPF32[i36 >> 2] = 0.0;
        break;
       }
      case 1:
       {
        HEAPF32[i33 >> 2] = 1.0;
        HEAPF32[i34 >> 2] = 1.0;
        HEAPF32[i35 >> 2] = 1.0;
        HEAPF32[i36 >> 2] = 0.0;
        break;
       }
      case 2:
       {
        HEAPF32[i33 >> 2] = 0.0;
        HEAPF32[i34 >> 2] = 1.0;
        HEAPF32[i35 >> 2] = 0.0;
        HEAPF32[i36 >> 2] = 0.0;
        break;
       }
      case 3:
       {
        HEAPF32[i33 >> 2] = 0.0;
        HEAPF32[i34 >> 2] = 1.0;
        HEAPF32[i35 >> 2] = 1.0;
        HEAPF32[i36 >> 2] = 0.0;
        break;
       }
      case 4:
       {
        HEAPF32[i33 >> 2] = 1.0;
        HEAPF32[i34 >> 2] = 0.0;
        HEAPF32[i35 >> 2] = 0.0;
        HEAPF32[i36 >> 2] = 0.0;
        break;
       }
      default:
       {
        HEAPF32[i33 >> 2] = 1.0;
        HEAPF32[i34 >> 2] = 0.0;
        HEAPF32[i35 >> 2] = 0.0;
        HEAPF32[i36 >> 2] = 0.0;
       }
      }
      FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i37 >> 2] | 0) + 24 >> 2] & 127](i1, i39 + 4 | 0, HEAP32[i39 + 192 >> 2] | 0, i4);
     }
    } while (0);
    i40 = HEAP32[i13 >> 2] | 0;
    if ((i40 | 0) == 0) {
     break;
    }
    if (((FUNCTION_TABLE_ii[HEAP32[(HEAP32[i40 >> 2] | 0) + 48 >> 2] & 127](i40) | 0) & 2 | 0) == 0) {
     break;
    }
    HEAPF32[i11 >> 2] = 1.0;
    HEAPF32[i12 >> 2] = 0.0;
    HEAPF32[i16 >> 2] = 0.0;
    HEAPF32[i15 >> 2] = 0.0;
    i40 = i39 + 192 | 0;
    i41 = HEAP32[i40 >> 2] | 0;
    FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i41 >> 2] | 0) + 8 >> 2] & 127](i41, i39 + 4 | 0, i5, i6);
    d42 = +HEAPF32[4];
    HEAPF32[i17 >> 2] = +HEAPF32[i17 >> 2] - d42;
    HEAPF32[i18 >> 2] = +HEAPF32[i18 >> 2] - d42;
    HEAPF32[i19 >> 2] = +HEAPF32[i19 >> 2] - d42;
    HEAPF32[i20 >> 2] = d42 + +HEAPF32[i20 >> 2];
    HEAPF32[i21 >> 2] = d42 + +HEAPF32[i21 >> 2];
    HEAPF32[i22 >> 2] = d42 + +HEAPF32[i22 >> 2];
    do {
     if ((HEAP32[i39 + 232 >> 2] | 0) == 2) {
      i41 = HEAP32[i40 >> 2] | 0;
      FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i41 >> 2] | 0) + 8 >> 2] & 127](i41, i39 + 68 | 0, i8, i9);
      d43 = +HEAPF32[i23 >> 2] - d42;
      HEAPF32[i23 >> 2] = d43;
      d44 = +HEAPF32[i24 >> 2] - d42;
      HEAPF32[i24 >> 2] = d44;
      d45 = +HEAPF32[i25 >> 2] - d42;
      HEAPF32[i25 >> 2] = d45;
      d46 = d42 + +HEAPF32[i26 >> 2];
      HEAPF32[i26 >> 2] = d46;
      d47 = d42 + +HEAPF32[i27 >> 2];
      HEAPF32[i27 >> 2] = d47;
      d48 = d42 + +HEAPF32[i28 >> 2];
      HEAPF32[i28 >> 2] = d48;
      if (d43 < +HEAPF32[i17 >> 2]) {
       HEAPF32[i17 >> 2] = d43;
      }
      if (d44 < +HEAPF32[i18 >> 2]) {
       HEAPF32[i18 >> 2] = d44;
      }
      if (d45 < +HEAPF32[i19 >> 2]) {
       HEAPF32[i19 >> 2] = d45;
      }
      d45 = +HEAPF32[i30 >> 2];
      if (d45 < +HEAPF32[i29 >> 2]) {
       HEAPF32[i29 >> 2] = d45;
      }
      if (+HEAPF32[i20 >> 2] < d46) {
       HEAPF32[i20 >> 2] = d46;
      }
      if (+HEAPF32[i21 >> 2] < d47) {
       HEAPF32[i21 >> 2] = d47;
      }
      if (+HEAPF32[i22 >> 2] < d48) {
       HEAPF32[i22 >> 2] = d48;
      }
      d48 = +HEAPF32[i32 >> 2];
      if (+HEAPF32[i31 >> 2] >= d48) {
       break;
      }
      HEAPF32[i31 >> 2] = d48;
     }
    } while (0);
    i40 = HEAP32[i13 >> 2] | 0;
    FUNCTION_TABLE_viiii[HEAP32[(HEAP32[i40 >> 2] | 0) + 52 >> 2] & 127](i40, i5, i6, i7);
   }
  } while (0);
  i38 = i38 + 1 | 0;
 } while ((i38 | 0) < (HEAP32[i14 >> 2] | 0));
 STACKTOP = i2;
 return;
}
function __ZN27btContinuousConvexCollision16calcTimeOfImpactERK11btTransformS2_S2_S2_RN12btConvexCast10CastResultE(i1, i2, i3, i4, i5, i6) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 var i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, d23 = 0.0, d24 = 0.0, d25 = 0.0, d26 = 0.0, d27 = 0.0, d28 = 0.0, d29 = 0.0, d30 = 0.0, d31 = 0.0, d32 = 0.0, d33 = 0.0, d34 = 0.0, d35 = 0.0, d36 = 0.0, d37 = 0.0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0;
 i7 = STACKTOP;
 STACKTOP = STACKTOP + 384 | 0;
 i8 = i7 | 0;
 i9 = i7 + 16 | 0;
 i10 = i7 + 24 | 0;
 i11 = i7 + 40 | 0;
 i12 = i7 + 48 | 0;
 i13 = i7 + 64 | 0;
 i14 = i7 + 80 | 0;
 i15 = i7 + 96 | 0;
 i16 = i7 + 112 | 0;
 i17 = i7 + 128 | 0;
 i18 = i7 + 176 | 0;
 i19 = i7 + 192 | 0;
 i20 = i7 + 256 | 0;
 i21 = i7 + 320 | 0;
 i22 = i7 + 336 | 0;
 d23 = +HEAPF32[i3 + 48 >> 2] - +HEAPF32[i2 + 48 >> 2];
 d24 = +HEAPF32[i3 + 52 >> 2] - +HEAPF32[i2 + 52 >> 2];
 d25 = +HEAPF32[i3 + 56 >> 2] - +HEAPF32[i2 + 56 >> 2];
 HEAPF32[i12 >> 2] = d23;
 HEAPF32[i12 + 4 >> 2] = d24;
 HEAPF32[i12 + 8 >> 2] = d25;
 HEAPF32[i12 + 12 >> 2] = 0.0;
 __ZN15btTransformUtil22calculateDiffAxisAngleERK11btTransformS2_R9btVector3Rf(i2, i3, i10, i11);
 d26 = +HEAPF32[i11 >> 2];
 d27 = +HEAPF32[i10 >> 2] * d26;
 d28 = d26 * +HEAPF32[i10 + 4 >> 2];
 d29 = d26 * +HEAPF32[i10 + 8 >> 2];
 HEAPF32[i13 >> 2] = d27;
 HEAPF32[i13 + 4 >> 2] = d28;
 HEAPF32[i13 + 8 >> 2] = d29;
 HEAPF32[i13 + 12 >> 2] = 0.0;
 d26 = +HEAPF32[i5 + 48 >> 2] - +HEAPF32[i4 + 48 >> 2];
 d30 = +HEAPF32[i5 + 52 >> 2] - +HEAPF32[i4 + 52 >> 2];
 d31 = +HEAPF32[i5 + 56 >> 2] - +HEAPF32[i4 + 56 >> 2];
 HEAPF32[i14 >> 2] = d26;
 HEAPF32[i14 + 4 >> 2] = d30;
 HEAPF32[i14 + 8 >> 2] = d31;
 HEAPF32[i14 + 12 >> 2] = 0.0;
 __ZN15btTransformUtil22calculateDiffAxisAngleERK11btTransformS2_R9btVector3Rf(i4, i5, i8, i9);
 d32 = +HEAPF32[i9 >> 2];
 d33 = +HEAPF32[i8 >> 2] * d32;
 d34 = d32 * +HEAPF32[i8 + 4 >> 2];
 d35 = d32 * +HEAPF32[i8 + 8 >> 2];
 HEAPF32[i15 >> 2] = d33;
 HEAPF32[i15 + 4 >> 2] = d34;
 HEAPF32[i15 + 8 >> 2] = d35;
 HEAPF32[i15 + 12 >> 2] = 0.0;
 i8 = HEAP32[i1 + 12 >> 2] | 0;
 d32 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i8 >> 2] | 0) + 16 >> 2] & 7](i8 | 0);
 i8 = HEAP32[i1 + 16 >> 2] | 0;
 if ((i8 | 0) == 0) {
  d36 = 0.0;
 } else {
  d36 = +FUNCTION_TABLE_fi[HEAP32[(HEAP32[i8 >> 2] | 0) + 16 >> 2] & 7](i8 | 0);
 }
 d37 = d32 * +Math_sqrt(+(d27 * d27 + d28 * d28 + d29 * d29));
 d29 = d37 + d36 * +Math_sqrt(+(d33 * d33 + d34 * d34 + d35 * d35));
 d35 = d26 - d23;
 d23 = d30 - d24;
 d24 = d31 - d25;
 if (+Math_sqrt(+(d35 * d35 + d23 * d23 + d24 * d24)) + d29 == 0.0) {
  i38 = 0;
  STACKTOP = i7;
  return i38 | 0;
 }
 HEAP32[i17 >> 2] = 4272;
 i8 = i17 + 36 | 0;
 HEAPF32[i8 >> 2] = 999999984306749400.0;
 i9 = i17 + 40 | 0;
 HEAP8[i9] = 0;
 __ZN27btContinuousConvexCollision20computeClosestPointsERK11btTransformS2_R16btPointCollector(i1, i2, i4, i17);
 i5 = (HEAP8[i9] | 0) == 0;
 i9 = i16;
 i10 = i17 + 20 | 0;
 HEAP32[i9 >> 2] = HEAP32[i10 >> 2];
 HEAP32[i9 + 4 >> 2] = HEAP32[i10 + 4 >> 2];
 HEAP32[i9 + 8 >> 2] = HEAP32[i10 + 8 >> 2];
 HEAP32[i9 + 12 >> 2] = HEAP32[i10 + 12 >> 2];
 if (i5) {
  i38 = 0;
  STACKTOP = i7;
  return i38 | 0;
 }
 i5 = i6 + 172 | 0;
 d25 = +HEAPF32[i17 + 4 >> 2];
 d31 = +HEAPF32[i17 + 8 >> 2];
 d30 = +HEAPF32[i17 + 12 >> 2];
 if (d29 + (d35 * d25 + d23 * d31 + d24 * d30) <= 1.1920928955078125e-7) {
  i38 = 0;
  STACKTOP = i7;
  return i38 | 0;
 }
 i10 = i6 + 168 | 0;
 i11 = i6;
 i3 = i22 | 0;
 i39 = i22 + 36 | 0;
 i40 = i22 + 40 | 0;
 i41 = i22 + 20 | 0;
 i42 = i22 + 4 | 0;
 i43 = i22 + 8 | 0;
 i44 = i22 + 12 | 0;
 i45 = i22 + 16 | 0;
 i46 = i19 + 48 | 0;
 i47 = i21 | 0;
 i48 = i21 + 4 | 0;
 i49 = i21 + 8 | 0;
 i50 = i21 + 12 | 0;
 i51 = i18 | 0;
 i52 = i18 + 4 | 0;
 i53 = i18 + 8 | 0;
 i54 = i18 + 12 | 0;
 d26 = +HEAPF32[i5 >> 2] + +HEAPF32[i8 >> 2];
 i8 = 0;
 d34 = 0.0;
 d33 = d25;
 d25 = d31;
 d31 = d30;
 d30 = +HEAPF32[i17 + 16 >> 2];
 while (1) {
  if (d26 <= .0010000000474974513) {
   i55 = 593;
   break;
  }
  i17 = HEAP32[i10 >> 2] | 0;
  if ((i17 | 0) != 0) {
   i56 = HEAP32[(HEAP32[i17 >> 2] | 0) + 20 >> 2] | 0;
   HEAPF32[i51 >> 2] = 1.0;
   HEAPF32[i52 >> 2] = 1.0;
   HEAPF32[i53 >> 2] = 1.0;
   HEAPF32[i54 >> 2] = 0.0;
   FUNCTION_TABLE_viifi[i56 & 1](i17, i16, .20000000298023224, i18);
  }
  d36 = d29 + (d24 * d31 + (d23 * d25 + d35 * d33));
  if (d36 <= 1.1920928955078125e-7) {
   i38 = 0;
   i55 = 598;
   break;
  }
  d37 = d34 + d26 / d36;
  if (!(d37 >= 0.0 & d37 <= 1.0 & d37 > d34)) {
   i38 = 0;
   i55 = 599;
   break;
  }
  __ZN15btTransformUtil18integrateTransformERK11btTransformRK9btVector3S5_fRS0_(i2, i12, i13, d37, i19);
  __ZN15btTransformUtil18integrateTransformERK11btTransformRK9btVector3S5_fRS0_(i4, i14, i15, d37, i20);
  i17 = HEAP32[i10 >> 2] | 0;
  if ((i17 | 0) != 0) {
   i56 = HEAP32[(HEAP32[i17 >> 2] | 0) + 20 >> 2] | 0;
   HEAPF32[i47 >> 2] = 1.0;
   HEAPF32[i48 >> 2] = 0.0;
   HEAPF32[i49 >> 2] = 0.0;
   HEAPF32[i50 >> 2] = 0.0;
   FUNCTION_TABLE_viifi[i56 & 1](i17, i46, .20000000298023224, i21);
  }
  FUNCTION_TABLE_vif[HEAP32[HEAP32[i11 >> 2] >> 2] & 31](i6, d37);
  HEAP32[i3 >> 2] = 4272;
  HEAPF32[i39 >> 2] = 999999984306749400.0;
  HEAP8[i40] = 0;
  __ZN27btContinuousConvexCollision20computeClosestPointsERK11btTransformS2_R16btPointCollector(i1, i19, i20, i22);
  if ((HEAP8[i40] | 0) == 0) {
   i55 = 591;
   break;
  }
  d36 = +HEAPF32[i39 >> 2] + +HEAPF32[i5 >> 2];
  HEAP32[i9 >> 2] = HEAP32[i41 >> 2];
  HEAP32[i9 + 4 >> 2] = HEAP32[i41 + 4 >> 2];
  HEAP32[i9 + 8 >> 2] = HEAP32[i41 + 8 >> 2];
  HEAP32[i9 + 12 >> 2] = HEAP32[i41 + 12 >> 2];
  i57 = i8 + 1 | 0;
  if ((i57 | 0) > 64) {
   i55 = 592;
   break;
  } else {
   d26 = d36;
   i8 = i57;
   d34 = d37;
   d33 = +HEAPF32[i42 >> 2];
   d25 = +HEAPF32[i43 >> 2];
   d31 = +HEAPF32[i44 >> 2];
   d30 = +HEAPF32[i45 >> 2];
  }
 }
 if ((i55 | 0) == 598) {
  STACKTOP = i7;
  return i38 | 0;
 } else if ((i55 | 0) == 599) {
  STACKTOP = i7;
  return i38 | 0;
 } else if ((i55 | 0) == 591) {
  FUNCTION_TABLE_viii[HEAP32[(HEAP32[i6 >> 2] | 0) + 8 >> 2] & 127](i6, -1, i8);
  i38 = 0;
  STACKTOP = i7;
  return i38 | 0;
 } else if ((i55 | 0) == 592) {
  FUNCTION_TABLE_viii[HEAP32[(HEAP32[i6 >> 2] | 0) + 8 >> 2] & 127](i6, -2, i57);
  i38 = 0;
  STACKTOP = i7;
  return i38 | 0;
 } else if ((i55 | 0) == 593) {
  HEAPF32[i6 + 164 >> 2] = d34;
  HEAPF32[i6 + 132 >> 2] = d33;
  HEAPF32[i6 + 136 >> 2] = d25;
  HEAPF32[i6 + 140 >> 2] = d31;
  HEAPF32[i6 + 144 >> 2] = d30;
  i55 = i6 + 148 | 0;
  HEAP32[i55 >> 2] = HEAP32[i9 >> 2];
  HEAP32[i55 + 4 >> 2] = HEAP32[i9 + 4 >> 2];
  HEAP32[i55 + 8 >> 2] = HEAP32[i9 + 8 >> 2];
  HEAP32[i55 + 12 >> 2] = HEAP32[i9 + 12 >> 2];
  i38 = 1;
  STACKTOP = i7;
  return i38 | 0;
 }
 return 0;
}
function __ZNK16btCollisionWorld15convexSweepTestEPK13btConvexShapeRK11btTransformS5_RNS_20ConvexResultCallbackEf(i1, i2, i3, i4, i5, d6) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 d6 = +d6;
 var i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, d29 = 0.0, d30 = 0.0, d31 = 0.0, d32 = 0.0, d33 = 0.0, d34 = 0.0, d35 = 0.0, d36 = 0.0, d37 = 0.0, d38 = 0.0, d39 = 0.0, d40 = 0.0, d41 = 0.0, d42 = 0.0;
 i7 = STACKTOP;
 STACKTOP = STACKTOP + 496 | 0;
 i8 = i7 | 0;
 i9 = i7 + 16 | 0;
 i10 = i7 + 24 | 0;
 i11 = i7 + 88 | 0;
 i12 = i7 + 152 | 0;
 i13 = i7 + 168 | 0;
 i14 = i7 + 184 | 0;
 i15 = i7 + 200 | 0;
 i16 = i7 + 216 | 0;
 i17 = i7 + 280 | 0;
 i18 = i7 + 296 | 0;
 __ZN15CProfileManager13Start_ProfileEPKc(56);
 i19 = i10;
 i20 = i3;
 HEAP32[i19 >> 2] = HEAP32[i20 >> 2];
 HEAP32[i19 + 4 >> 2] = HEAP32[i20 + 4 >> 2];
 HEAP32[i19 + 8 >> 2] = HEAP32[i20 + 8 >> 2];
 HEAP32[i19 + 12 >> 2] = HEAP32[i20 + 12 >> 2];
 i19 = i10 + 16 | 0;
 i21 = i3 + 16 | 0;
 HEAP32[i19 >> 2] = HEAP32[i21 >> 2];
 HEAP32[i19 + 4 >> 2] = HEAP32[i21 + 4 >> 2];
 HEAP32[i19 + 8 >> 2] = HEAP32[i21 + 8 >> 2];
 HEAP32[i19 + 12 >> 2] = HEAP32[i21 + 12 >> 2];
 i19 = i10 + 32 | 0;
 i22 = i3 + 32 | 0;
 HEAP32[i19 >> 2] = HEAP32[i22 >> 2];
 HEAP32[i19 + 4 >> 2] = HEAP32[i22 + 4 >> 2];
 HEAP32[i19 + 8 >> 2] = HEAP32[i22 + 8 >> 2];
 HEAP32[i19 + 12 >> 2] = HEAP32[i22 + 12 >> 2];
 i19 = i10 + 48 | 0;
 i23 = i19;
 i24 = i3 + 48 | 0;
 HEAP32[i23 >> 2] = HEAP32[i24 >> 2];
 HEAP32[i23 + 4 >> 2] = HEAP32[i24 + 4 >> 2];
 HEAP32[i23 + 8 >> 2] = HEAP32[i24 + 8 >> 2];
 HEAP32[i23 + 12 >> 2] = HEAP32[i24 + 12 >> 2];
 i23 = i11;
 i3 = i4;
 HEAP32[i23 >> 2] = HEAP32[i3 >> 2];
 HEAP32[i23 + 4 >> 2] = HEAP32[i3 + 4 >> 2];
 HEAP32[i23 + 8 >> 2] = HEAP32[i3 + 8 >> 2];
 HEAP32[i23 + 12 >> 2] = HEAP32[i3 + 12 >> 2];
 i23 = i11 + 16 | 0;
 i25 = i4 + 16 | 0;
 HEAP32[i23 >> 2] = HEAP32[i25 >> 2];
 HEAP32[i23 + 4 >> 2] = HEAP32[i25 + 4 >> 2];
 HEAP32[i23 + 8 >> 2] = HEAP32[i25 + 8 >> 2];
 HEAP32[i23 + 12 >> 2] = HEAP32[i25 + 12 >> 2];
 i23 = i11 + 32 | 0;
 i26 = i4 + 32 | 0;
 HEAP32[i23 >> 2] = HEAP32[i26 >> 2];
 HEAP32[i23 + 4 >> 2] = HEAP32[i26 + 4 >> 2];
 HEAP32[i23 + 8 >> 2] = HEAP32[i26 + 8 >> 2];
 HEAP32[i23 + 12 >> 2] = HEAP32[i26 + 12 >> 2];
 i23 = i11 + 48 | 0;
 i27 = i23;
 i28 = i4 + 48 | 0;
 HEAP32[i27 >> 2] = HEAP32[i28 >> 2];
 HEAP32[i27 + 4 >> 2] = HEAP32[i28 + 4 >> 2];
 HEAP32[i27 + 8 >> 2] = HEAP32[i28 + 8 >> 2];
 HEAP32[i27 + 12 >> 2] = HEAP32[i28 + 12 >> 2];
 __ZN15btTransformUtil22calculateDiffAxisAngleERK11btTransformS2_R9btVector3Rf(i10, i11, i8, i9);
 d29 = +HEAPF32[i9 >> 2];
 d30 = d29 * +HEAPF32[i8 + 4 >> 2];
 d31 = d29 * +HEAPF32[i8 + 8 >> 2];
 HEAPF32[i14 >> 2] = +HEAPF32[i8 >> 2] * d29;
 HEAPF32[i14 + 4 >> 2] = d30;
 HEAPF32[i14 + 8 >> 2] = d31;
 HEAPF32[i14 + 12 >> 2] = 0.0;
 _memset(i15 | 0, 0, 16);
 i8 = i16 + 4 | 0;
 i9 = i8;
 HEAP32[i9 >> 2] = 0;
 HEAP32[i9 + 4 >> 2] = 0;
 i9 = i16 + 24 | 0;
 i11 = i9;
 HEAP32[i11 >> 2] = 0;
 HEAP32[i11 + 4 >> 2] = 0;
 i11 = i16 + 44 | 0;
 _memset(i11 | 0, 0, 20);
 __ZNK11btMatrix3x311getRotationER12btQuaternion(i10 | 0, i17);
 d31 = +HEAPF32[i17 >> 2];
 d30 = +HEAPF32[i17 + 4 >> 2];
 d29 = +HEAPF32[i17 + 8 >> 2];
 d32 = +HEAPF32[i17 + 12 >> 2];
 d33 = 2.0 / (d31 * d31 + d30 * d30 + d29 * d29 + d32 * d32);
 d34 = d31 * d33;
 d35 = d30 * d33;
 d36 = d29 * d33;
 d33 = d32 * d34;
 d37 = d32 * d35;
 d38 = d32 * d36;
 d32 = d31 * d34;
 d34 = d31 * d35;
 d39 = d31 * d36;
 d31 = d30 * d35;
 d35 = d30 * d36;
 d30 = d29 * d36;
 HEAPF32[i16 >> 2] = 1.0 - (d31 + d30);
 HEAPF32[i8 >> 2] = d34 - d38;
 HEAPF32[i16 + 8 >> 2] = d39 + d37;
 HEAPF32[i16 + 12 >> 2] = 0.0;
 HEAPF32[i16 + 16 >> 2] = d34 + d38;
 HEAPF32[i16 + 20 >> 2] = 1.0 - (d32 + d30);
 HEAPF32[i9 >> 2] = d35 - d33;
 HEAPF32[i16 + 28 >> 2] = 0.0;
 HEAPF32[i16 + 32 >> 2] = d39 - d37;
 HEAPF32[i16 + 36 >> 2] = d35 + d33;
 HEAPF32[i16 + 40 >> 2] = 1.0 - (d32 + d31);
 HEAPF32[i11 >> 2] = 0.0;
 __ZNK16btCollisionShape21calculateTemporalAabbERK11btTransformRK9btVector3S5_fRS3_S6_(i2 | 0, i16, i15, i14, 1.0, i12, i13);
 HEAP32[i18 >> 2] = 3648;
 i14 = i18 + 36 | 0;
 HEAP32[i14 >> 2] = HEAP32[i20 >> 2];
 HEAP32[i14 + 4 >> 2] = HEAP32[i20 + 4 >> 2];
 HEAP32[i14 + 8 >> 2] = HEAP32[i20 + 8 >> 2];
 HEAP32[i14 + 12 >> 2] = HEAP32[i20 + 12 >> 2];
 i20 = i18 + 52 | 0;
 HEAP32[i20 >> 2] = HEAP32[i21 >> 2];
 HEAP32[i20 + 4 >> 2] = HEAP32[i21 + 4 >> 2];
 HEAP32[i20 + 8 >> 2] = HEAP32[i21 + 8 >> 2];
 HEAP32[i20 + 12 >> 2] = HEAP32[i21 + 12 >> 2];
 i21 = i18 + 68 | 0;
 HEAP32[i21 >> 2] = HEAP32[i22 >> 2];
 HEAP32[i21 + 4 >> 2] = HEAP32[i22 + 4 >> 2];
 HEAP32[i21 + 8 >> 2] = HEAP32[i22 + 8 >> 2];
 HEAP32[i21 + 12 >> 2] = HEAP32[i22 + 12 >> 2];
 i22 = i18 + 84 | 0;
 i21 = i22;
 HEAP32[i21 >> 2] = HEAP32[i24 >> 2];
 HEAP32[i21 + 4 >> 2] = HEAP32[i24 + 4 >> 2];
 HEAP32[i21 + 8 >> 2] = HEAP32[i24 + 8 >> 2];
 HEAP32[i21 + 12 >> 2] = HEAP32[i24 + 12 >> 2];
 i24 = i18 + 100 | 0;
 HEAP32[i24 >> 2] = HEAP32[i3 >> 2];
 HEAP32[i24 + 4 >> 2] = HEAP32[i3 + 4 >> 2];
 HEAP32[i24 + 8 >> 2] = HEAP32[i3 + 8 >> 2];
 HEAP32[i24 + 12 >> 2] = HEAP32[i3 + 12 >> 2];
 i3 = i18 + 116 | 0;
 HEAP32[i3 >> 2] = HEAP32[i25 >> 2];
 HEAP32[i3 + 4 >> 2] = HEAP32[i25 + 4 >> 2];
 HEAP32[i3 + 8 >> 2] = HEAP32[i25 + 8 >> 2];
 HEAP32[i3 + 12 >> 2] = HEAP32[i25 + 12 >> 2];
 i25 = i18 + 132 | 0;
 HEAP32[i25 >> 2] = HEAP32[i26 >> 2];
 HEAP32[i25 + 4 >> 2] = HEAP32[i26 + 4 >> 2];
 HEAP32[i25 + 8 >> 2] = HEAP32[i26 + 8 >> 2];
 HEAP32[i25 + 12 >> 2] = HEAP32[i26 + 12 >> 2];
 i26 = i18 + 148 | 0;
 i25 = i26;
 HEAP32[i25 >> 2] = HEAP32[i28 >> 2];
 HEAP32[i25 + 4 >> 2] = HEAP32[i28 + 4 >> 2];
 HEAP32[i25 + 8 >> 2] = HEAP32[i28 + 8 >> 2];
 HEAP32[i25 + 12 >> 2] = HEAP32[i28 + 12 >> 2];
 HEAP32[i18 + 180 >> 2] = i1;
 HEAP32[i18 + 184 >> 2] = i5;
 HEAPF32[i18 + 188 >> 2] = d6;
 HEAP32[i18 + 192 >> 2] = i2;
 d6 = +HEAPF32[i26 >> 2] - +HEAPF32[i22 >> 2];
 d31 = +HEAPF32[i18 + 152 >> 2] - +HEAPF32[i18 + 88 >> 2];
 d32 = +HEAPF32[i18 + 156 >> 2] - +HEAPF32[i18 + 92 >> 2];
 d33 = 1.0 / +Math_sqrt(+(d6 * d6 + d31 * d31 + d32 * d32));
 d35 = d6 * d33;
 d37 = d31 * d33;
 d39 = d32 * d33;
 if (d35 == 0.0) {
  d40 = 999999984306749400.0;
 } else {
  d40 = 1.0 / d35;
 }
 HEAPF32[i18 + 4 >> 2] = d40;
 if (d37 == 0.0) {
  d41 = 999999984306749400.0;
 } else {
  d41 = 1.0 / d37;
 }
 HEAPF32[i18 + 8 >> 2] = d41;
 if (d39 == 0.0) {
  d42 = 999999984306749400.0;
 } else {
  d42 = 1.0 / d39;
 }
 HEAPF32[i18 + 12 >> 2] = d42;
 HEAP32[i18 + 20 >> 2] = d40 < 0.0;
 HEAP32[i18 + 24 >> 2] = d41 < 0.0;
 HEAP32[i18 + 28 >> 2] = d42 < 0.0;
 HEAPF32[i18 + 32 >> 2] = d32 * d39 + (d6 * d35 + d31 * d37);
 i22 = HEAP32[i1 + 76 >> 2] | 0;
 FUNCTION_TABLE_viiiiii[HEAP32[(HEAP32[i22 >> 2] | 0) + 24 >> 2] & 15](i22, i19, i23, i18 | 0, i12, i13);
 __ZN15CProfileManager12Stop_ProfileEv();
 STACKTOP = i7;
 return;
}
function __ZN35btSequentialImpulseConstraintSolver23setupFrictionConstraintER18btSolverConstraintRK9btVector3P11btRigidBodyS6_R15btManifoldPointS4_S4_P17btCollisionObjectSA_fff(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, d11, d12, d13) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 i7 = i7 | 0;
 i8 = i8 | 0;
 i9 = i9 | 0;
 i10 = i10 | 0;
 d11 = +d11;
 d12 = +d12;
 d13 = +d13;
 var i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, d22 = 0.0, d23 = 0.0, d24 = 0.0, d25 = 0.0, d26 = 0.0, d27 = 0.0, d28 = 0.0, d29 = 0.0, d30 = 0.0, d31 = 0.0, d32 = 0.0, d33 = 0.0, d34 = 0.0, d35 = 0.0, d36 = 0.0, d37 = 0.0, d38 = 0.0, d39 = 0.0, d40 = 0.0, d41 = 0.0, d42 = 0.0, d43 = 0.0, d44 = 0.0, d45 = 0.0, d46 = 0.0, d47 = 0.0, d48 = 0.0, d49 = 0.0, d50 = 0.0, d51 = 0.0, d52 = 0.0, d53 = 0.0, d54 = 0.0, d55 = 0.0, d56 = 0.0, d57 = 0.0, d58 = 0.0, d59 = 0.0, d60 = 0.0, i61 = 0, i62 = 0, i63 = 0, i64 = 0;
 i5 = STACKTOP;
 STACKTOP = STACKTOP + 64 | 0;
 i4 = i5 | 0;
 i1 = i5 + 16 | 0;
 i14 = i5 + 32 | 0;
 i15 = i5 + 48 | 0;
 if ((HEAP32[i9 + 232 >> 2] & 2 | 0) == 0) {
  i16 = 0;
 } else {
  i16 = i9;
 }
 if ((HEAP32[i10 + 232 >> 2] & 2 | 0) == 0) {
  i17 = 0;
 } else {
  i17 = i10;
 }
 i10 = i2 + 16 | 0;
 i9 = i10;
 i18 = i3;
 HEAP32[i9 >> 2] = HEAP32[i18 >> 2];
 HEAP32[i9 + 4 >> 2] = HEAP32[i18 + 4 >> 2];
 HEAP32[i9 + 8 >> 2] = HEAP32[i18 + 8 >> 2];
 HEAP32[i9 + 12 >> 2] = HEAP32[i18 + 12 >> 2];
 i18 = (i16 | 0) != 0;
 if (i18) {
  i19 = i16;
 } else {
  i9 = i14;
  i20 = i15;
  do {
   if ((HEAP8[14328] | 0) == 0) {
    if ((___cxa_guard_acquire(14328) | 0) == 0) {
     break;
    }
    _memset(i9 | 0, 0, 16);
    __ZN11btRigidBodyC2EfP13btMotionStateP16btCollisionShapeRK9btVector3(12536, 0.0, 0, 0, i14);
    _atexit(268, 12536, ___dso_handle | 0) | 0;
   }
  } while (0);
  _memset(i20 | 0, 0, 16);
  __ZN11btRigidBody12setMassPropsEfRK9btVector3(12536, 0.0, i15);
  i19 = 12536;
 }
 HEAP32[i2 + 104 >> 2] = i19;
 i19 = (i17 | 0) != 0;
 if (i19) {
  i21 = i17;
 } else {
  i15 = i4;
  i20 = i1;
  do {
   if ((HEAP8[14328] | 0) == 0) {
    if ((___cxa_guard_acquire(14328) | 0) == 0) {
     break;
    }
    _memset(i15 | 0, 0, 16);
    __ZN11btRigidBodyC2EfP13btMotionStateP16btCollisionShapeRK9btVector3(12536, 0.0, 0, 0, i4);
    _atexit(268, 12536, ___dso_handle | 0) | 0;
   }
  } while (0);
  _memset(i20 | 0, 0, 16);
  __ZN11btRigidBody12setMassPropsEfRK9btVector3(12536, 0.0, i1);
  i21 = 12536;
 }
 HEAP32[i2 + 108 >> 2] = i21;
 HEAPF32[i2 + 88 >> 2] = +HEAPF32[i6 + 84 >> 2];
 HEAP32[i2 + 112 >> 2] = 0;
 HEAPF32[i2 + 84 >> 2] = 0.0;
 HEAPF32[i2 + 80 >> 2] = 0.0;
 i6 = i7 + 4 | 0;
 d22 = +HEAPF32[i6 >> 2];
 d23 = +HEAPF32[i2 + 24 >> 2];
 i21 = i7 + 8 | 0;
 d24 = +HEAPF32[i21 >> 2];
 d25 = +HEAPF32[i2 + 20 >> 2];
 d26 = d22 * d23 - d24 * d25;
 d27 = +HEAPF32[i10 >> 2];
 i10 = i7 | 0;
 d28 = +HEAPF32[i10 >> 2];
 d29 = d24 * d27 - d23 * d28;
 d24 = d25 * d28 - d22 * d27;
 HEAPF32[i2 >> 2] = d26;
 HEAPF32[i2 + 4 >> 2] = d29;
 HEAPF32[i2 + 8 >> 2] = d24;
 HEAPF32[i2 + 12 >> 2] = 0.0;
 if (i18) {
  d30 = (d26 * +HEAPF32[i16 + 256 >> 2] + d29 * +HEAPF32[i16 + 260 >> 2] + d24 * +HEAPF32[i16 + 264 >> 2]) * +HEAPF32[i16 + 536 >> 2];
  d31 = (d26 * +HEAPF32[i16 + 272 >> 2] + d29 * +HEAPF32[i16 + 276 >> 2] + d24 * +HEAPF32[i16 + 280 >> 2]) * +HEAPF32[i16 + 540 >> 2];
  d32 = (d26 * +HEAPF32[i16 + 288 >> 2] + d29 * +HEAPF32[i16 + 292 >> 2] + d24 * +HEAPF32[i16 + 296 >> 2]) * +HEAPF32[i16 + 544 >> 2];
 } else {
  d30 = 0.0;
  d31 = 0.0;
  d32 = 0.0;
 }
 HEAPF32[i2 + 48 >> 2] = d30;
 HEAPF32[i2 + 52 >> 2] = d31;
 HEAPF32[i2 + 56 >> 2] = d32;
 HEAPF32[i2 + 60 >> 2] = 0.0;
 d22 = -0.0 - d27;
 d28 = -0.0 - d25;
 d33 = -0.0 - d23;
 i7 = i8 + 4 | 0;
 d34 = +HEAPF32[i7 >> 2];
 i1 = i8 + 8 | 0;
 d35 = +HEAPF32[i1 >> 2];
 d36 = d34 * d33 - d35 * d28;
 i20 = i8 | 0;
 d37 = +HEAPF32[i20 >> 2];
 d38 = d35 * d22 - d37 * d33;
 d33 = d37 * d28 - d34 * d22;
 HEAPF32[i2 + 32 >> 2] = d36;
 HEAPF32[i2 + 36 >> 2] = d38;
 HEAPF32[i2 + 40 >> 2] = d33;
 HEAPF32[i2 + 44 >> 2] = 0.0;
 if (i19) {
  d39 = (d36 * +HEAPF32[i17 + 256 >> 2] + d38 * +HEAPF32[i17 + 260 >> 2] + d33 * +HEAPF32[i17 + 264 >> 2]) * +HEAPF32[i17 + 536 >> 2];
  d40 = (d36 * +HEAPF32[i17 + 272 >> 2] + d38 * +HEAPF32[i17 + 276 >> 2] + d33 * +HEAPF32[i17 + 280 >> 2]) * +HEAPF32[i17 + 540 >> 2];
  d41 = (d36 * +HEAPF32[i17 + 288 >> 2] + d38 * +HEAPF32[i17 + 292 >> 2] + d33 * +HEAPF32[i17 + 296 >> 2]) * +HEAPF32[i17 + 544 >> 2];
 } else {
  d39 = 0.0;
  d40 = 0.0;
  d41 = 0.0;
 }
 HEAPF32[i2 + 64 >> 2] = d39;
 HEAPF32[i2 + 68 >> 2] = d40;
 HEAPF32[i2 + 72 >> 2] = d41;
 HEAPF32[i2 + 76 >> 2] = 0.0;
 if (i18) {
  d22 = +HEAPF32[i21 >> 2];
  d34 = +HEAPF32[i6 >> 2];
  d28 = +HEAPF32[i10 >> 2];
  d42 = +HEAPF32[i16 + 336 >> 2] + ((d31 * d22 - d32 * d34) * +HEAPF32[i3 >> 2] + (d32 * d28 - d30 * d22) * +HEAPF32[i3 + 4 >> 2] + (d30 * d34 - d31 * d28) * +HEAPF32[i3 + 8 >> 2]);
 } else {
  d42 = 0.0;
 }
 if (i19) {
  d28 = -0.0 - d39;
  d39 = -0.0 - d40;
  d40 = -0.0 - d41;
  d41 = +HEAPF32[i1 >> 2];
  d31 = +HEAPF32[i7 >> 2];
  d34 = +HEAPF32[i20 >> 2];
  d43 = +HEAPF32[i17 + 336 >> 2] + ((d41 * d39 - d31 * d40) * +HEAPF32[i3 >> 2] + (d34 * d40 - d41 * d28) * +HEAPF32[i3 + 4 >> 2] + (d31 * d28 - d34 * d39) * +HEAPF32[i3 + 8 >> 2]);
 } else {
  d43 = 0.0;
 }
 d39 = d11 / (d42 + d43);
 HEAPF32[i2 + 92 >> 2] = d39;
 if (i18) {
  d44 = +HEAPF32[i16 + 320 >> 2];
  d45 = +HEAPF32[i16 + 324 >> 2];
  d46 = +HEAPF32[i16 + 328 >> 2];
  d47 = d27 * +HEAPF32[i16 + 304 >> 2] + d25 * +HEAPF32[i16 + 308 >> 2] + d23 * +HEAPF32[i16 + 312 >> 2];
 } else {
  d44 = 0.0;
  d45 = 0.0;
  d46 = 0.0;
  d47 = d23 * 0.0 + (d25 * 0.0 + d27 * 0.0);
 }
 d43 = d47 + (d24 * d46 + (d29 * d45 + d26 * d44));
 if (i19) {
  d48 = +HEAPF32[i17 + 320 >> 2];
  d49 = +HEAPF32[i17 + 324 >> 2];
  d50 = +HEAPF32[i17 + 328 >> 2];
  d51 = d27 * +HEAPF32[i17 + 304 >> 2] + d25 * +HEAPF32[i17 + 308 >> 2] + d23 * +HEAPF32[i17 + 312 >> 2];
  d52 = d36 * d48;
  d53 = d38 * d49;
  d54 = d53 + d52;
  d55 = d33 * d50;
  d56 = d55 + d54;
  d57 = d56 - d51;
  d58 = d43 + d57;
  d59 = d12 - d58;
  d60 = d39 * d59;
  i61 = i2 + 116 | 0;
  HEAPF32[i61 >> 2] = d60;
  i62 = i2 + 120 | 0;
  HEAPF32[i62 >> 2] = d13;
  i63 = i2 + 124 | 0;
  HEAPF32[i63 >> 2] = 0.0;
  i64 = i2 + 128 | 0;
  HEAPF32[i64 >> 2] = 1.0e10;
  STACKTOP = i5;
  return;
 } else {
  d48 = 0.0;
  d49 = 0.0;
  d50 = 0.0;
  d51 = d23 * 0.0 + (d25 * 0.0 + d27 * 0.0);
  d52 = d36 * d48;
  d53 = d38 * d49;
  d54 = d53 + d52;
  d55 = d33 * d50;
  d56 = d55 + d54;
  d57 = d56 - d51;
  d58 = d43 + d57;
  d59 = d12 - d58;
  d60 = d39 * d59;
  i61 = i2 + 116 | 0;
  HEAPF32[i61 >> 2] = d60;
  i62 = i2 + 120 | 0;
  HEAPF32[i62 >> 2] = d13;
  i63 = i2 + 124 | 0;
  HEAPF32[i63 >> 2] = 0.0;
  i64 = i2 + 128 | 0;
  HEAPF32[i64 >> 2] = 1.0e10;
  STACKTOP = i5;
  return;
 }
}
function __ZNK10__cxxabiv121__vmi_class_type_info16search_below_dstEPNS_19__dynamic_cast_infoEPKvib(i1, i2, i3, i4, i5) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 var i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0;
 i6 = i1 | 0;
 if ((i6 | 0) == (HEAP32[i2 + 8 >> 2] | 0)) {
  if ((HEAP32[i2 + 4 >> 2] | 0) != (i3 | 0)) {
   return;
  }
  i7 = i2 + 28 | 0;
  if ((HEAP32[i7 >> 2] | 0) == 1) {
   return;
  }
  HEAP32[i7 >> 2] = i4;
  return;
 }
 if ((i6 | 0) == (HEAP32[i2 >> 2] | 0)) {
  do {
   if ((HEAP32[i2 + 16 >> 2] | 0) != (i3 | 0)) {
    i6 = i2 + 20 | 0;
    if ((HEAP32[i6 >> 2] | 0) == (i3 | 0)) {
     break;
    }
    HEAP32[i2 + 32 >> 2] = i4;
    i7 = i2 + 44 | 0;
    if ((HEAP32[i7 >> 2] | 0) == 4) {
     return;
    }
    i8 = HEAP32[i1 + 12 >> 2] | 0;
    i9 = i1 + 16 + (i8 << 3) | 0;
    L2740 : do {
     if ((i8 | 0) > 0) {
      i10 = i2 + 52 | 0;
      i11 = i2 + 53 | 0;
      i12 = i2 + 54 | 0;
      i13 = i1 + 8 | 0;
      i14 = i2 + 24 | 0;
      i15 = i3;
      i16 = 0;
      i17 = i1 + 16 | 0;
      i18 = 0;
      L2742 : while (1) {
       HEAP8[i10] = 0;
       HEAP8[i11] = 0;
       i19 = HEAP32[i17 + 4 >> 2] | 0;
       i20 = i19 >> 8;
       if ((i19 & 1 | 0) == 0) {
        i21 = i20;
       } else {
        i21 = HEAP32[(HEAP32[i15 >> 2] | 0) + i20 >> 2] | 0;
       }
       i20 = HEAP32[i17 >> 2] | 0;
       FUNCTION_TABLE_viiiiii[HEAP32[(HEAP32[i20 >> 2] | 0) + 20 >> 2] & 15](i20, i2, i3, i3 + i21 | 0, 2 - (i19 >>> 1 & 1) | 0, i5);
       if ((HEAP8[i12] & 1) != 0) {
        i22 = i18;
        i23 = i16;
        break;
       }
       do {
        if ((HEAP8[i11] & 1) == 0) {
         i24 = i18;
         i25 = i16;
        } else {
         if ((HEAP8[i10] & 1) == 0) {
          if ((HEAP32[i13 >> 2] & 1 | 0) == 0) {
           i22 = 1;
           i23 = i16;
           break L2742;
          } else {
           i24 = 1;
           i25 = i16;
           break;
          }
         }
         if ((HEAP32[i14 >> 2] | 0) == 1) {
          i26 = 2075;
          break L2740;
         }
         if ((HEAP32[i13 >> 2] & 2 | 0) == 0) {
          i26 = 2075;
          break L2740;
         } else {
          i24 = 1;
          i25 = 1;
         }
        }
       } while (0);
       i19 = i17 + 8 | 0;
       if (i19 >>> 0 < i9 >>> 0) {
        i16 = i25;
        i17 = i19;
        i18 = i24;
       } else {
        i22 = i24;
        i23 = i25;
        break;
       }
      }
      if (i23) {
       i27 = i22;
       i26 = 2074;
      } else {
       i28 = i22;
       i26 = 2071;
      }
     } else {
      i28 = 0;
      i26 = 2071;
     }
    } while (0);
    do {
     if ((i26 | 0) == 2071) {
      HEAP32[i6 >> 2] = i3;
      i9 = i2 + 40 | 0;
      HEAP32[i9 >> 2] = (HEAP32[i9 >> 2] | 0) + 1;
      if ((HEAP32[i2 + 36 >> 2] | 0) != 1) {
       i27 = i28;
       i26 = 2074;
       break;
      }
      if ((HEAP32[i2 + 24 >> 2] | 0) != 2) {
       i27 = i28;
       i26 = 2074;
       break;
      }
      HEAP8[i2 + 54 | 0] = 1;
      if (i28) {
       i26 = 2075;
      } else {
       i26 = 2076;
      }
     }
    } while (0);
    if ((i26 | 0) == 2074) {
     if (i27) {
      i26 = 2075;
     } else {
      i26 = 2076;
     }
    }
    if ((i26 | 0) == 2075) {
     HEAP32[i7 >> 2] = 3;
     return;
    } else if ((i26 | 0) == 2076) {
     HEAP32[i7 >> 2] = 4;
     return;
    }
   }
  } while (0);
  if ((i4 | 0) != 1) {
   return;
  }
  HEAP32[i2 + 32 >> 2] = 1;
  return;
 }
 i27 = HEAP32[i1 + 12 >> 2] | 0;
 i28 = i1 + 16 + (i27 << 3) | 0;
 i22 = HEAP32[i1 + 20 >> 2] | 0;
 i23 = i22 >> 8;
 if ((i22 & 1 | 0) == 0) {
  i29 = i23;
 } else {
  i29 = HEAP32[(HEAP32[i3 >> 2] | 0) + i23 >> 2] | 0;
 }
 i23 = HEAP32[i1 + 16 >> 2] | 0;
 FUNCTION_TABLE_viiiii[HEAP32[(HEAP32[i23 >> 2] | 0) + 24 >> 2] & 63](i23, i2, i3 + i29 | 0, (i22 & 2 | 0) != 0 ? i4 : 2, i5);
 i22 = i1 + 24 | 0;
 if ((i27 | 0) <= 1) {
  return;
 }
 i27 = HEAP32[i1 + 8 >> 2] | 0;
 do {
  if ((i27 & 2 | 0) == 0) {
   i1 = i2 + 36 | 0;
   if ((HEAP32[i1 >> 2] | 0) == 1) {
    break;
   }
   if ((i27 & 1 | 0) == 0) {
    i29 = i2 + 54 | 0;
    i23 = i3;
    i25 = i22;
    while (1) {
     if ((HEAP8[i29] & 1) != 0) {
      i26 = 2116;
      break;
     }
     if ((HEAP32[i1 >> 2] | 0) == 1) {
      i26 = 2117;
      break;
     }
     i24 = HEAP32[i25 + 4 >> 2] | 0;
     i21 = i24 >> 8;
     if ((i24 & 1 | 0) == 0) {
      i30 = i21;
     } else {
      i30 = HEAP32[(HEAP32[i23 >> 2] | 0) + i21 >> 2] | 0;
     }
     i21 = HEAP32[i25 >> 2] | 0;
     FUNCTION_TABLE_viiiii[HEAP32[(HEAP32[i21 >> 2] | 0) + 24 >> 2] & 63](i21, i2, i3 + i30 | 0, (i24 & 2 | 0) != 0 ? i4 : 2, i5);
     i24 = i25 + 8 | 0;
     if (i24 >>> 0 < i28 >>> 0) {
      i25 = i24;
     } else {
      i26 = 2118;
      break;
     }
    }
    if ((i26 | 0) == 2116) {
     return;
    } else if ((i26 | 0) == 2117) {
     return;
    } else if ((i26 | 0) == 2118) {
     return;
    }
   }
   i25 = i2 + 24 | 0;
   i23 = i2 + 54 | 0;
   i29 = i3;
   i7 = i22;
   while (1) {
    if ((HEAP8[i23] & 1) != 0) {
     i26 = 2113;
     break;
    }
    if ((HEAP32[i1 >> 2] | 0) == 1) {
     if ((HEAP32[i25 >> 2] | 0) == 1) {
      i26 = 2114;
      break;
     }
    }
    i24 = HEAP32[i7 + 4 >> 2] | 0;
    i21 = i24 >> 8;
    if ((i24 & 1 | 0) == 0) {
     i31 = i21;
    } else {
     i31 = HEAP32[(HEAP32[i29 >> 2] | 0) + i21 >> 2] | 0;
    }
    i21 = HEAP32[i7 >> 2] | 0;
    FUNCTION_TABLE_viiiii[HEAP32[(HEAP32[i21 >> 2] | 0) + 24 >> 2] & 63](i21, i2, i3 + i31 | 0, (i24 & 2 | 0) != 0 ? i4 : 2, i5);
    i24 = i7 + 8 | 0;
    if (i24 >>> 0 < i28 >>> 0) {
     i7 = i24;
    } else {
     i26 = 2115;
     break;
    }
   }
   if ((i26 | 0) == 2113) {
    return;
   } else if ((i26 | 0) == 2114) {
    return;
   } else if ((i26 | 0) == 2115) {
    return;
   }
  }
 } while (0);
 i31 = i2 + 54 | 0;
 i30 = i3;
 i27 = i22;
 while (1) {
  if ((HEAP8[i31] & 1) != 0) {
   i26 = 2111;
   break;
  }
  i22 = HEAP32[i27 + 4 >> 2] | 0;
  i7 = i22 >> 8;
  if ((i22 & 1 | 0) == 0) {
   i32 = i7;
  } else {
   i32 = HEAP32[(HEAP32[i30 >> 2] | 0) + i7 >> 2] | 0;
  }
  i7 = HEAP32[i27 >> 2] | 0;
  FUNCTION_TABLE_viiiii[HEAP32[(HEAP32[i7 >> 2] | 0) + 24 >> 2] & 63](i7, i2, i3 + i32 | 0, (i22 & 2 | 0) != 0 ? i4 : 2, i5);
  i22 = i27 + 8 | 0;
  if (i22 >>> 0 < i28 >>> 0) {
   i27 = i22;
  } else {
   i26 = 2112;
   break;
  }
 }
 if ((i26 | 0) == 2111) {
  return;
 } else if ((i26 | 0) == 2112) {
  return;
 }
}
function __ZN23btDiscreteDynamicsWorld19integrateTransformsEf(i1, d2) {
 i1 = i1 | 0;
 d2 = +d2;
 var i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, d51 = 0.0, d52 = 0.0, d53 = 0.0, d54 = 0.0, d55 = 0.0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 280 | 0;
 i4 = i3 | 0;
 i5 = i3 + 64 | 0;
 i6 = i3 + 160 | 0;
 i7 = i3 + 216 | 0;
 __ZN15CProfileManager13Start_ProfileEPKc(120);
 i8 = i1 + 204 | 0;
 if ((HEAP32[i8 >> 2] | 0) <= 0) {
  __ZN15CProfileManager12Stop_ProfileEv();
  STACKTOP = i3;
  return;
 }
 i9 = i1 + 212 | 0;
 i10 = i4 + 48 | 0;
 i11 = i10 | 0;
 i12 = i4 + 52 | 0;
 i13 = i4 + 56 | 0;
 i14 = i1 | 0;
 i15 = i1 + 44 | 0;
 i16 = i1 + 76 | 0;
 i17 = i1 + 24 | 0;
 i18 = i5 | 0;
 i19 = i5 + 4 | 0;
 i20 = i5 + 8 | 0;
 i21 = i5 + 10 | 0;
 i22 = i5 + 12 | 0;
 i23 = i5 + 28 | 0;
 i24 = i10;
 i10 = i5 + 76 | 0;
 i25 = i5 + 80 | 0;
 i26 = i5 + 84 | 0;
 i27 = i5 + 88 | 0;
 i28 = i5 + 92 | 0;
 i29 = i6 | 0;
 i30 = i6 | 0;
 i31 = i6 + 4 | 0;
 i32 = i6 + 28 | 0;
 i33 = i6 + 44 | 0;
 i34 = i1 + 56 | 0;
 i35 = i5 | 0;
 i36 = i7;
 i37 = i4;
 i38 = i7 + 16 | 0;
 i39 = i4 + 16 | 0;
 i40 = i7 + 32 | 0;
 i41 = i4 + 32 | 0;
 i42 = i7 + 48 | 0;
 i43 = i6 | 0;
 i6 = i5 + 60 | 0;
 i44 = i5 + 44 | 0;
 i5 = i1 + 100 | 0;
 i1 = 0;
 do {
  i45 = HEAP32[(HEAP32[i9 >> 2] | 0) + (i1 << 2) >> 2] | 0;
  i46 = i45 | 0;
  i47 = i45 + 240 | 0;
  HEAPF32[i47 >> 2] = 1.0;
  i48 = HEAP32[i45 + 216 >> 2] | 0;
  L734 : do {
   if (!((i48 | 0) == 5 | (i48 | 0) == 2)) {
    if ((HEAP32[i45 + 204 >> 2] & 3 | 0) != 0) {
     break;
    }
    __ZN11btRigidBody26predictIntegratedTransformEfR11btTransform(i45, d2, i4);
    i49 = i45 + 4 | 0;
    i50 = i45 + 52 | 0;
    d51 = +HEAPF32[i11 >> 2] - +HEAPF32[i50 >> 2];
    d52 = +HEAPF32[i12 >> 2] - +HEAPF32[i45 + 56 >> 2];
    d53 = +HEAPF32[i13 >> 2] - +HEAPF32[i45 + 60 >> 2];
    do {
     if ((HEAP8[i15] | 0) != 0) {
      d54 = +HEAPF32[i45 + 248 >> 2];
      d55 = d54 * d54;
      if (!(d55 != 0.0 & d55 < d51 * d51 + d52 * d52 + d53 * d53)) {
       break;
      }
      __ZN15CProfileManager13Start_ProfileEPKc(72);
      if ((HEAP32[(HEAP32[i45 + 192 >> 2] | 0) + 4 >> 2] | 0) < 20) {
       HEAP32[2996] = (HEAP32[2996] | 0) + 1;
       i56 = HEAP32[i16 >> 2] | 0;
       i57 = FUNCTION_TABLE_ii[HEAP32[(HEAP32[i56 >> 2] | 0) + 36 >> 2] & 127](i56) | 0;
       i56 = HEAP32[i17 >> 2] | 0;
       HEAPF32[i19 >> 2] = 1.0;
       HEAP16[i20 >> 1] = 1;
       HEAP16[i21 >> 1] = -1;
       HEAP32[i18 >> 2] = 2248;
       i58 = i50;
       HEAP32[i22 >> 2] = HEAP32[i58 >> 2];
       HEAP32[i22 + 4 >> 2] = HEAP32[i58 + 4 >> 2];
       HEAP32[i22 + 8 >> 2] = HEAP32[i58 + 8 >> 2];
       HEAP32[i22 + 12 >> 2] = HEAP32[i58 + 12 >> 2];
       HEAP32[i23 >> 2] = HEAP32[i24 >> 2];
       HEAP32[i23 + 4 >> 2] = HEAP32[i24 + 4 >> 2];
       HEAP32[i23 + 8 >> 2] = HEAP32[i24 + 8 >> 2];
       HEAP32[i23 + 12 >> 2] = HEAP32[i24 + 12 >> 2];
       HEAP32[i10 >> 2] = 0;
       HEAP32[i18 >> 2] = 2464;
       HEAP32[i25 >> 2] = i46;
       HEAPF32[i26 >> 2] = 0.0;
       HEAP32[i27 >> 2] = i57;
       HEAP32[i28 >> 2] = i56;
       d55 = +HEAPF32[i45 + 244 >> 2];
       __ZN21btConvexInternalShapeC2Ev(i29);
       HEAP32[i30 >> 2] = 4728;
       HEAP32[i31 >> 2] = 8;
       HEAPF32[i32 >> 2] = d55;
       HEAPF32[i33 >> 2] = d55;
       HEAPF32[i26 >> 2] = +HEAPF32[i34 >> 2];
       i56 = HEAP32[i45 + 188 >> 2] | 0;
       HEAP16[i20 >> 1] = HEAP16[i56 + 4 >> 1] | 0;
       HEAP16[i21 >> 1] = HEAP16[i56 + 6 >> 1] | 0;
       HEAP32[i36 >> 2] = HEAP32[i37 >> 2];
       HEAP32[i36 + 4 >> 2] = HEAP32[i37 + 4 >> 2];
       HEAP32[i36 + 8 >> 2] = HEAP32[i37 + 8 >> 2];
       HEAP32[i36 + 12 >> 2] = HEAP32[i37 + 12 >> 2];
       HEAP32[i38 >> 2] = HEAP32[i39 >> 2];
       HEAP32[i38 + 4 >> 2] = HEAP32[i39 + 4 >> 2];
       HEAP32[i38 + 8 >> 2] = HEAP32[i39 + 8 >> 2];
       HEAP32[i38 + 12 >> 2] = HEAP32[i39 + 12 >> 2];
       HEAP32[i40 >> 2] = HEAP32[i41 >> 2];
       HEAP32[i40 + 4 >> 2] = HEAP32[i41 + 4 >> 2];
       HEAP32[i40 + 8 >> 2] = HEAP32[i41 + 8 >> 2];
       HEAP32[i40 + 12 >> 2] = HEAP32[i41 + 12 >> 2];
       HEAP32[i42 >> 2] = HEAP32[i24 >> 2];
       HEAP32[i42 + 4 >> 2] = HEAP32[i24 + 4 >> 2];
       HEAP32[i42 + 8 >> 2] = HEAP32[i24 + 8 >> 2];
       HEAP32[i42 + 12 >> 2] = HEAP32[i24 + 12 >> 2];
       i56 = i49;
       HEAP32[i36 >> 2] = HEAP32[i56 >> 2];
       HEAP32[i36 + 4 >> 2] = HEAP32[i56 + 4 >> 2];
       HEAP32[i36 + 8 >> 2] = HEAP32[i56 + 8 >> 2];
       HEAP32[i36 + 12 >> 2] = HEAP32[i56 + 12 >> 2];
       i56 = i45 + 20 | 0;
       HEAP32[i38 >> 2] = HEAP32[i56 >> 2];
       HEAP32[i38 + 4 >> 2] = HEAP32[i56 + 4 >> 2];
       HEAP32[i38 + 8 >> 2] = HEAP32[i56 + 8 >> 2];
       HEAP32[i38 + 12 >> 2] = HEAP32[i56 + 12 >> 2];
       i56 = i45 + 36 | 0;
       HEAP32[i40 >> 2] = HEAP32[i56 >> 2];
       HEAP32[i40 + 4 >> 2] = HEAP32[i56 + 4 >> 2];
       HEAP32[i40 + 8 >> 2] = HEAP32[i56 + 8 >> 2];
       HEAP32[i40 + 12 >> 2] = HEAP32[i56 + 12 >> 2];
       __ZNK16btCollisionWorld15convexSweepTestEPK13btConvexShapeRK11btTransformS5_RNS_20ConvexResultCallbackEf(i14, i43, i49, i7, i35, 0.0);
       d55 = +HEAPF32[i19 >> 2];
       if (d55 < 1.0) {
        HEAPF32[i47 >> 2] = d55;
        __ZN11btRigidBody26predictIntegratedTransformEfR11btTransform(i45, d55 * d2, i4);
        HEAPF32[i47 >> 2] = 0.0;
        __ZN11btRigidBody18proceedToTransformERK11btTransform(i45, i4);
        i56 = HEAP32[i10 >> 2] | 0;
        +__Z22resolveSingleCollisionP11btRigidBodyP17btCollisionObjectRK9btVector3S5_RK19btContactSolverInfof(i45, i56, i6, i44, i5, 0.0);
        i59 = 4;
       } else {
        i59 = 0;
       }
       __ZN13btConvexShapeD2Ev(i43);
       if ((i59 | 0) == 0) {
        i60 = 684;
       } else {
        i61 = i59;
       }
      } else {
       i60 = 684;
      }
      if ((i60 | 0) == 684) {
       i60 = 0;
       i61 = 0;
      }
      __ZN15CProfileManager12Stop_ProfileEv();
      if ((i61 | 0) == 4) {
       break L734;
      }
     }
    } while (0);
    __ZN11btRigidBody18proceedToTransformERK11btTransform(i45, i4);
   }
  } while (0);
  i1 = i1 + 1 | 0;
 } while ((i1 | 0) < (HEAP32[i8 >> 2] | 0));
 __ZN15CProfileManager12Stop_ProfileEv();
 STACKTOP = i3;
 return;
}
function __ZNK14btQuantizedBvh36walkStacklessQuantizedTreeAgainstRayEP21btNodeOverlapCallbackRK9btVector3S4_S4_S4_ii(i1, i2, i3, i4, i5, i6, i7, i8) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 i7 = i7 | 0;
 i8 = i8 | 0;
 var i9 = 0, i10 = 0, i11 = 0, d12 = 0.0, i13 = 0, d14 = 0.0, d15 = 0.0, d16 = 0.0, i17 = 0, d18 = 0.0, d19 = 0.0, d20 = 0.0, d21 = 0.0, d22 = 0.0, d23 = 0.0, d24 = 0.0, d25 = 0.0, d26 = 0.0, d27 = 0.0, d28 = 0.0, d29 = 0.0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0, d40 = 0.0, i41 = 0, d42 = 0.0, i43 = 0, d44 = 0.0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0, i62 = 0, i63 = 0, i64 = 0, i65 = 0, i66 = 0, i67 = 0, i68 = 0, i69 = 0, i70 = 0, i71 = 0, i72 = 0, i73 = 0, i74 = 0, i75 = 0, i76 = 0;
 i9 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i10 = i9 | 0;
 i11 = (HEAP32[i1 + 136 >> 2] | 0) + (i7 << 4) | 0;
 d12 = +HEAPF32[i4 >> 2];
 i13 = i3 | 0;
 d14 = +HEAPF32[i13 >> 2];
 d15 = d12 - d14;
 d16 = +HEAPF32[i4 + 4 >> 2];
 i17 = i3 + 4 | 0;
 d18 = +HEAPF32[i17 >> 2];
 d19 = d16 - d18;
 d20 = +HEAPF32[i4 + 8 >> 2];
 i4 = i3 + 8 | 0;
 d21 = +HEAPF32[i4 >> 2];
 d22 = d20 - d21;
 d23 = 1.0 / +Math_sqrt(+(d15 * d15 + d19 * d19 + d22 * d22));
 d24 = d15 * d23;
 d25 = d19 * d23;
 d26 = d22 * d23;
 d23 = d22 * d26 + (d15 * d24 + d19 * d25);
 if (d24 == 0.0) {
  d27 = 999999984306749400.0;
 } else {
  d27 = 1.0 / d24;
 }
 if (d25 == 0.0) {
  d28 = 999999984306749400.0;
 } else {
  d28 = 1.0 / d25;
 }
 if (d26 == 0.0) {
  d29 = 999999984306749400.0;
 } else {
  d29 = 1.0 / d26;
 }
 i3 = d27 < 0.0 | 0;
 i30 = d28 < 0.0 | 0;
 i31 = d29 < 0.0 | 0;
 i32 = i5 | 0;
 d26 = (d12 < d14 ? d12 : d14) + +HEAPF32[i32 >> 2];
 i33 = i5 + 4 | 0;
 d25 = (d16 < d18 ? d16 : d18) + +HEAPF32[i33 >> 2];
 i34 = i5 + 8 | 0;
 d24 = (d20 < d21 ? d20 : d21) + +HEAPF32[i34 >> 2];
 i5 = i6 | 0;
 d19 = (d14 < d12 ? d12 : d14) + +HEAPF32[i5 >> 2];
 i35 = i6 + 4 | 0;
 d14 = (d18 < d16 ? d16 : d18) + +HEAPF32[i35 >> 2];
 i36 = i6 + 8 | 0;
 d18 = (d21 < d20 ? d20 : d21) + +HEAPF32[i36 >> 2];
 i6 = i1 + 4 | 0;
 d21 = +HEAPF32[i6 >> 2];
 d20 = d26 < d21 ? d21 : d26;
 i37 = i1 + 8 | 0;
 d26 = +HEAPF32[i37 >> 2];
 d16 = d25 < d26 ? d26 : d25;
 i38 = i1 + 12 | 0;
 d25 = +HEAPF32[i38 >> 2];
 d12 = d24 < d25 ? d25 : d24;
 d24 = +HEAPF32[i1 + 20 >> 2];
 d15 = +HEAPF32[i1 + 24 >> 2];
 d22 = +HEAPF32[i1 + 28 >> 2];
 i39 = i1 + 36 | 0;
 d40 = +HEAPF32[i39 >> 2];
 i41 = i1 + 40 | 0;
 d42 = +HEAPF32[i41 >> 2];
 i43 = i1 + 44 | 0;
 d44 = +HEAPF32[i43 >> 2];
 i1 = ~~(((d24 < d20 ? d24 : d20) - d21) * d40) & -2;
 i45 = ~~(((d15 < d16 ? d15 : d16) - d26) * d42) & -2;
 i46 = ~~(((d22 < d12 ? d22 : d12) - d25) * d44) & -2;
 d12 = d19 < d21 ? d21 : d19;
 d19 = d14 < d26 ? d26 : d14;
 d14 = d18 < d25 ? d25 : d18;
 i47 = ~~(((d24 < d12 ? d24 : d12) - d21) * d40 + 1.0) | 1;
 i48 = ~~(((d15 < d19 ? d15 : d19) - d26) * d42 + 1.0) | 1;
 i49 = ~~(((d22 < d14 ? d22 : d14) - d25) * d44 + 1.0) | 1;
 if ((i7 | 0) < (i8 | 0)) {
  i50 = i10 | 0;
  i51 = i10 + 4 | 0;
  i52 = i10 + 8 | 0;
  i53 = i10 + 12 | 0;
  i54 = i10 + 16 | 0;
  i55 = i10 + 20 | 0;
  i56 = i10 + 24 | 0;
  i57 = i10 + 28 | 0;
  i58 = i10 + (i3 << 4) | 0;
  i59 = i10 + ((i3 ^ 1) << 4) | 0;
  i3 = i10 + (i30 << 4) + 4 | 0;
  i60 = i10 + ((i30 ^ 1) << 4) + 4 | 0;
  i30 = i2;
  i61 = i10 + (i31 << 4) + 8 | 0;
  i62 = i10 + ((i31 ^ 1) << 4) + 8 | 0;
  i31 = i11;
  i11 = 0;
  i10 = i7;
  while (1) {
   i7 = i11 + 1 | 0;
   i63 = i31 + 6 | 0;
   i64 = HEAP16[i31 >> 1] | 0;
   i65 = i31 + 10 | 0;
   i66 = HEAP16[i31 + 4 >> 1] | 0;
   i67 = i31 + 8 | 0;
   i68 = HEAP16[i31 + 2 >> 1] | 0;
   i69 = i31 + 12 | 0;
   i70 = (HEAP32[i69 >> 2] | 0) > -1;
   do {
    if ((-((i1 & 65535) <= (HEAPU16[i63 >> 1] | 0) & (i47 & 65535) >= (i64 & 65535) & (i46 & 65535) <= (HEAPU16[i65 >> 1] | 0) & (i49 & 65535) >= (i66 & 65535) & (i45 & 65535) <= (HEAPU16[i67 >> 1] | 0) & (i48 & 65535) >= (i68 & 65535) & 1) & 1 | 0) == 0) {
     i71 = 1;
     i72 = 498;
    } else {
     d44 = +HEAPF32[i39 >> 2];
     d25 = +HEAPF32[i41 >> 2];
     d14 = +HEAPF32[i43 >> 2];
     d22 = +HEAPF32[i6 >> 2];
     d42 = +HEAPF32[i37 >> 2];
     d26 = +HEAPF32[i38 >> 2];
     HEAPF32[i53 >> 2] = 0.0;
     d19 = d22 + +((HEAPU16[i63 >> 1] | 0) >>> 0) / d44;
     d15 = d42 + +((HEAPU16[i67 >> 1] | 0) >>> 0) / d25;
     d40 = d26 + +((HEAPU16[i65 >> 1] | 0) >>> 0) / d14;
     HEAPF32[i57 >> 2] = 0.0;
     HEAPF32[i50 >> 2] = +((i64 & 65535) >>> 0) / d44 + d22 - +HEAPF32[i5 >> 2];
     HEAPF32[i51 >> 2] = +((i68 & 65535) >>> 0) / d25 + d42 - +HEAPF32[i35 >> 2];
     HEAPF32[i52 >> 2] = +((i66 & 65535) >>> 0) / d14 + d26 - +HEAPF32[i36 >> 2];
     HEAPF32[i54 >> 2] = d19 - +HEAPF32[i32 >> 2];
     HEAPF32[i55 >> 2] = d15 - +HEAPF32[i33 >> 2];
     HEAPF32[i56 >> 2] = d40 - +HEAPF32[i34 >> 2];
     d40 = +HEAPF32[i13 >> 2];
     d15 = d27 * (+HEAPF32[i58 >> 2] - d40);
     d19 = d27 * (+HEAPF32[i59 >> 2] - d40);
     d40 = +HEAPF32[i17 >> 2];
     d26 = d28 * (+HEAPF32[i3 >> 2] - d40);
     d14 = d28 * (+HEAPF32[i60 >> 2] - d40);
     if (d15 > d14 | d26 > d19) {
      i71 = 1;
      i72 = 498;
      break;
     }
     d40 = d26 > d15 ? d26 : d15;
     d15 = d14 < d19 ? d14 : d19;
     d19 = +HEAPF32[i4 >> 2];
     d14 = d29 * (+HEAPF32[i61 >> 2] - d19);
     d26 = d29 * (+HEAPF32[i62 >> 2] - d19);
     if (d40 > d26 | d14 > d15) {
      i71 = 1;
      i72 = 498;
      break;
     }
     if ((d14 > d40 ? d14 : d40) >= d23) {
      i71 = 1;
      i72 = 498;
      break;
     }
     i73 = (d26 < d15 ? d26 : d15) <= 0.0;
     if (i73 | i70 ^ 1) {
      i71 = i73;
      i72 = 498;
      break;
     }
     i73 = HEAP32[i69 >> 2] | 0;
     FUNCTION_TABLE_viii[HEAP32[(HEAP32[i30 >> 2] | 0) + 8 >> 2] & 127](i2, i73 >> 21, i73 & 2097151);
     i72 = 499;
    }
   } while (0);
   do {
    if ((i72 | 0) == 498) {
     i72 = 0;
     if (i70 | i71 ^ 1) {
      i72 = 499;
      break;
     }
     i66 = HEAP32[i69 >> 2] | 0;
     i74 = i10 - i66 | 0;
     i75 = i31 + (-i66 << 4) | 0;
    }
   } while (0);
   if ((i72 | 0) == 499) {
    i72 = 0;
    i74 = i10 + 1 | 0;
    i75 = i31 + 16 | 0;
   }
   if ((i74 | 0) < (i8 | 0)) {
    i31 = i75;
    i11 = i7;
    i10 = i74;
   } else {
    i76 = i7;
    break;
   }
  }
 } else {
  i76 = 0;
 }
 if ((HEAP32[2982] | 0) >= (i76 | 0)) {
  STACKTOP = i9;
  return;
 }
 HEAP32[2982] = i76;
 STACKTOP = i9;
 return;
}
function __ZNK14btQuantizedBvh27walkStacklessTreeAgainstRayEP21btNodeOverlapCallbackRK9btVector3S4_S4_S4_ii(i1, i2, i3, i4, i5, i6, i7, i8) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 i7 = i7 | 0;
 i8 = i8 | 0;
 var i9 = 0, i10 = 0, d11 = 0.0, i12 = 0, d13 = 0.0, i14 = 0, d15 = 0.0, d16 = 0.0, d17 = 0.0, d18 = 0.0, d19 = 0.0, d20 = 0.0, d21 = 0.0, d22 = 0.0, i23 = 0, d24 = 0.0, d25 = 0.0, d26 = 0.0, d27 = 0.0, i28 = 0, d29 = 0.0, d30 = 0.0, i31 = 0, d32 = 0.0, d33 = 0.0, d34 = 0.0, d35 = 0.0, d36 = 0.0, d37 = 0.0, i38 = 0, i39 = 0, i40 = 0, i41 = 0, i42 = 0, i43 = 0, i44 = 0, i45 = 0, i46 = 0, i47 = 0, i48 = 0, i49 = 0, i50 = 0, i51 = 0, i52 = 0, i53 = 0, i54 = 0, i55 = 0, i56 = 0, i57 = 0, i58 = 0, i59 = 0, i60 = 0, i61 = 0, i62 = 0, i63 = 0, i64 = 0, d65 = 0.0, d66 = 0.0, d67 = 0.0, d68 = 0.0, d69 = 0.0, i70 = 0, i71 = 0, i72 = 0, i73 = 0, i74 = 0, i75 = 0, i76 = 0, i77 = 0, i78 = 0;
 i8 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i7 = i8 | 0;
 i9 = HEAP32[i1 + 96 >> 2] | 0;
 i10 = i3 | 0;
 d11 = +HEAPF32[i10 >> 2];
 i12 = i3 + 4 | 0;
 d13 = +HEAPF32[i12 >> 2];
 i14 = i3 + 8 | 0;
 d15 = +HEAPF32[i14 >> 2];
 d16 = +HEAPF32[i4 >> 2];
 d17 = +HEAPF32[i4 + 4 >> 2];
 d18 = +HEAPF32[i4 + 8 >> 2];
 i4 = i5 | 0;
 d19 = +HEAPF32[i4 >> 2];
 d20 = (d16 < d11 ? d16 : d11) + d19;
 i3 = i5 + 4 | 0;
 d21 = +HEAPF32[i3 >> 2];
 d22 = (d17 < d13 ? d17 : d13) + d21;
 i23 = i5 + 8 | 0;
 d24 = +HEAPF32[i23 >> 2];
 d25 = (d18 < d15 ? d18 : d15) + d24;
 i5 = i6 | 0;
 d26 = +HEAPF32[i5 >> 2];
 d27 = (d11 < d16 ? d16 : d11) + d26;
 i28 = i6 + 4 | 0;
 d29 = +HEAPF32[i28 >> 2];
 d30 = (d13 < d17 ? d17 : d13) + d29;
 i31 = i6 + 8 | 0;
 d32 = +HEAPF32[i31 >> 2];
 d33 = (d15 < d18 ? d18 : d15) + d32;
 d34 = d16 - d11;
 d11 = d17 - d13;
 d13 = d18 - d15;
 d15 = 1.0 / +Math_sqrt(+(d34 * d34 + d11 * d11 + d13 * d13));
 d18 = d34 * d15;
 d17 = d11 * d15;
 d16 = d13 * d15;
 d15 = d13 * d16 + (d34 * d18 + d11 * d17);
 if (d18 == 0.0) {
  d35 = 999999984306749400.0;
 } else {
  d35 = 1.0 / d18;
 }
 if (d17 == 0.0) {
  d36 = 999999984306749400.0;
 } else {
  d36 = 1.0 / d17;
 }
 if (d16 == 0.0) {
  d37 = 999999984306749400.0;
 } else {
  d37 = 1.0 / d16;
 }
 i6 = d35 < 0.0 | 0;
 i38 = d36 < 0.0 | 0;
 i39 = d37 < 0.0 | 0;
 i40 = i1 + 56 | 0;
 i1 = HEAP32[i40 >> 2] | 0;
 L599 : do {
  if ((i1 | 0) > 0) {
   i41 = i7;
   i42 = i7 + 16 | 0;
   i43 = i42;
   i44 = i7 | 0;
   i45 = i7 + 4 | 0;
   i46 = i7 + 8 | 0;
   i47 = i42 | 0;
   i42 = i7 + 20 | 0;
   i48 = i7 + 24 | 0;
   i49 = i7 + (i6 << 4) | 0;
   i50 = i7 + ((i6 ^ 1) << 4) | 0;
   i51 = i7 + (i38 << 4) + 4 | 0;
   i52 = i7 + ((i38 ^ 1) << 4) + 4 | 0;
   i53 = i7 + (i39 << 4) + 8 | 0;
   i54 = i7 + ((i39 ^ 1) << 4) + 8 | 0;
   i55 = i2;
   i56 = 0;
   i57 = 1;
   i58 = i9;
   d16 = d26;
   d17 = d29;
   d18 = d32;
   d11 = d19;
   d34 = d21;
   d13 = d24;
   i59 = i1;
   while (1) {
    i60 = i58;
    HEAP32[i41 >> 2] = HEAP32[i60 >> 2];
    HEAP32[i41 + 4 >> 2] = HEAP32[i60 + 4 >> 2];
    HEAP32[i41 + 8 >> 2] = HEAP32[i60 + 8 >> 2];
    HEAP32[i41 + 12 >> 2] = HEAP32[i60 + 12 >> 2];
    i60 = i58 + 16 | 0;
    i61 = i60;
    HEAP32[i43 >> 2] = HEAP32[i61 >> 2];
    HEAP32[i43 + 4 >> 2] = HEAP32[i61 + 4 >> 2];
    HEAP32[i43 + 8 >> 2] = HEAP32[i61 + 8 >> 2];
    HEAP32[i43 + 12 >> 2] = HEAP32[i61 + 12 >> 2];
    HEAPF32[i44 >> 2] = +HEAPF32[i44 >> 2] - d16;
    HEAPF32[i45 >> 2] = +HEAPF32[i45 >> 2] - d17;
    HEAPF32[i46 >> 2] = +HEAPF32[i46 >> 2] - d18;
    HEAPF32[i47 >> 2] = +HEAPF32[i47 >> 2] - d11;
    HEAPF32[i42 >> 2] = +HEAPF32[i42 >> 2] - d34;
    HEAPF32[i48 >> 2] = +HEAPF32[i48 >> 2] - d13;
    do {
     if (d20 > +HEAPF32[i60 >> 2]) {
      i62 = 0;
     } else {
      if (d27 < +HEAPF32[i58 >> 2]) {
       i62 = 0;
       break;
      }
      i62 = 1;
     }
    } while (0);
    do {
     if (d25 > +HEAPF32[i58 + 24 >> 2]) {
      i63 = 0;
     } else {
      if (d33 < +HEAPF32[i58 + 8 >> 2]) {
       i63 = 0;
       break;
      }
      i63 = i62;
     }
    } while (0);
    do {
     if (d22 > +HEAPF32[i58 + 20 >> 2]) {
      i64 = 471;
     } else {
      if (d30 < +HEAPF32[i58 + 4 >> 2] | i63 ^ 1) {
       i64 = 471;
       break;
      }
      d65 = +HEAPF32[i10 >> 2];
      d66 = d35 * (+HEAPF32[i49 >> 2] - d65);
      d67 = d35 * (+HEAPF32[i50 >> 2] - d65);
      d65 = +HEAPF32[i12 >> 2];
      d68 = d36 * (+HEAPF32[i51 >> 2] - d65);
      d69 = d36 * (+HEAPF32[i52 >> 2] - d65);
      if (d66 > d69 | d68 > d67) {
       i64 = 471;
       break;
      }
      d65 = d68 > d66 ? d68 : d66;
      d66 = d69 < d67 ? d69 : d67;
      d67 = +HEAPF32[i14 >> 2];
      d69 = d37 * (+HEAPF32[i53 >> 2] - d67);
      d68 = d37 * (+HEAPF32[i54 >> 2] - d67);
      if (d65 > d68 | d69 > d66) {
       i64 = 471;
       break;
      }
      if ((d69 > d65 ? d69 : d65) >= d15) {
       i64 = 471;
       break;
      }
      i60 = (d68 < d66 ? d68 : d66) > 0.0;
      i61 = HEAP32[i58 + 32 >> 2] | 0;
      i70 = (i61 | 0) == -1;
      if (!(i70 & i60)) {
       i71 = i60;
       i72 = i70;
       i73 = i61;
       i64 = 474;
       break;
      }
      FUNCTION_TABLE_viii[HEAP32[(HEAP32[i55 >> 2] | 0) + 8 >> 2] & 127](i2, HEAP32[i58 + 36 >> 2] | 0, HEAP32[i58 + 40 >> 2] | 0);
      i74 = HEAP32[i40 >> 2] | 0;
      i64 = 475;
     }
    } while (0);
    if ((i64 | 0) == 471) {
     i64 = 0;
     i61 = HEAP32[i58 + 32 >> 2] | 0;
     i71 = 0;
     i72 = (i61 | 0) == -1;
     i73 = i61;
     i64 = 474;
    }
    do {
     if ((i64 | 0) == 474) {
      i64 = 0;
      if (i71 | i72) {
       i74 = i59;
       i64 = 475;
       break;
      }
      i75 = i58 + (i73 << 6) | 0;
      i76 = i73 + i56 | 0;
      i77 = i59;
     }
    } while (0);
    if ((i64 | 0) == 475) {
     i64 = 0;
     i75 = i58 + 64 | 0;
     i76 = i56 + 1 | 0;
     i77 = i74;
    }
    if ((i76 | 0) >= (i77 | 0)) {
     i78 = i57;
     break L599;
    }
    i56 = i76;
    i57 = i57 + 1 | 0;
    i58 = i75;
    d16 = +HEAPF32[i5 >> 2];
    d17 = +HEAPF32[i28 >> 2];
    d18 = +HEAPF32[i31 >> 2];
    d11 = +HEAPF32[i4 >> 2];
    d34 = +HEAPF32[i3 >> 2];
    d13 = +HEAPF32[i23 >> 2];
    i59 = i77;
   }
  } else {
   i78 = 0;
  }
 } while (0);
 if ((HEAP32[2982] | 0) >= (i78 | 0)) {
  STACKTOP = i8;
  return;
 }
 HEAP32[2982] = i78;
 STACKTOP = i8;
 return;
}
function __ZN20btAlignedObjectArrayI16btBroadphasePairE17quickSortInternalI29btBroadphasePairSortPredicateEEvT_ii(i1, i2, i3, i4) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 var i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, i37 = 0, i38 = 0, i39 = 0;
 i5 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i6 = i2;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 1 | 0;
 STACKTOP = STACKTOP + 7 >> 3 << 3;
 HEAP8[i2] = HEAP8[i6] | 0;
 i6 = i5 | 0;
 i2 = i5 + 8 | 0;
 i7 = (i4 + i3 | 0) / 2 | 0;
 i8 = i1 + 12 | 0;
 i9 = HEAP32[i8 >> 2] | 0;
 i10 = HEAP32[i9 + (i7 << 4) >> 2] | 0;
 i11 = HEAP32[i9 + (i7 << 4) + 4 >> 2] | 0;
 i12 = HEAP32[i9 + (i7 << 4) + 8 >> 2] | 0;
 i7 = (i10 | 0) == 0;
 i13 = (i11 | 0) == 0;
 i14 = i11 + 12 | 0;
 i15 = i10 + 12 | 0;
 i16 = i4;
 i17 = i3;
 i18 = i9;
 while (1) {
  L1160 : do {
   if (i7) {
    i9 = i17;
    while (1) {
     i19 = HEAP32[i18 + (i9 << 4) >> 2] | 0;
     i20 = (i19 | 0) == 0;
     if (i20) {
      i21 = -1;
     } else {
      i21 = HEAP32[i19 + 12 >> 2] | 0;
     }
     i22 = HEAP32[i18 + (i9 << 4) + 4 >> 2] | 0;
     if ((i22 | 0) == 0) {
      i23 = -1;
     } else {
      i23 = HEAP32[i22 + 12 >> 2] | 0;
     }
     if (i13) {
      i24 = -1;
     } else {
      i24 = HEAP32[i14 >> 2] | 0;
     }
     do {
      if ((i21 | 0) <= -1) {
       i25 = i20 & (i23 | 0) > (i24 | 0);
       if (i25 | i20 ^ 1) {
        if (i25) {
         break;
        } else {
         i26 = i9;
         i27 = i19;
         i28 = i22;
         break L1160;
        }
       }
       if ((i22 | 0) != (i11 | 0)) {
        i26 = i9;
        i27 = i19;
        i28 = i22;
        break L1160;
       }
       if ((HEAP32[i18 + (i9 << 4) + 8 >> 2] | 0) >>> 0 <= i12 >>> 0) {
        i26 = i9;
        i27 = i19;
        i28 = i22;
        break L1160;
       }
      }
     } while (0);
     i9 = i9 + 1 | 0;
    }
   } else {
    if (i13) {
     i9 = i17;
     while (1) {
      i22 = HEAP32[i18 + (i9 << 4) >> 2] | 0;
      if ((i22 | 0) == 0) {
       i29 = -1;
      } else {
       i29 = HEAP32[i22 + 12 >> 2] | 0;
      }
      i19 = HEAP32[i18 + (i9 << 4) + 4 >> 2] | 0;
      i20 = (i19 | 0) == 0;
      if (i20) {
       i30 = -1;
      } else {
       i30 = HEAP32[i19 + 12 >> 2] | 0;
      }
      do {
       if ((i29 | 0) <= (HEAP32[i15 >> 2] | 0)) {
        i25 = (i22 | 0) == (i10 | 0);
        i31 = i25 & (i30 | 0) > -1;
        if (i31 | i25 ^ 1) {
         if (i31) {
          break;
         } else {
          i26 = i9;
          i27 = i22;
          i28 = i19;
          break L1160;
         }
        }
        if (!i20) {
         i26 = i9;
         i27 = i22;
         i28 = i19;
         break L1160;
        }
        if ((HEAP32[i18 + (i9 << 4) + 8 >> 2] | 0) >>> 0 <= i12 >>> 0) {
         i26 = i9;
         i27 = i22;
         i28 = 0;
         break L1160;
        }
       }
      } while (0);
      i9 = i9 + 1 | 0;
     }
    } else {
     i9 = i17;
     while (1) {
      i22 = HEAP32[i18 + (i9 << 4) >> 2] | 0;
      if ((i22 | 0) == 0) {
       i32 = -1;
      } else {
       i32 = HEAP32[i22 + 12 >> 2] | 0;
      }
      i19 = HEAP32[i18 + (i9 << 4) + 4 >> 2] | 0;
      if ((i19 | 0) == 0) {
       i33 = -1;
      } else {
       i33 = HEAP32[i19 + 12 >> 2] | 0;
      }
      do {
       if ((i32 | 0) <= (HEAP32[i15 >> 2] | 0)) {
        i20 = (i22 | 0) == (i10 | 0);
        i31 = i20 & (i33 | 0) > (HEAP32[i14 >> 2] | 0);
        if (i31 | i20 ^ 1) {
         if (i31) {
          break;
         } else {
          i26 = i9;
          i27 = i22;
          i28 = i19;
          break L1160;
         }
        }
        if ((i19 | 0) != (i11 | 0)) {
         i26 = i9;
         i27 = i22;
         i28 = i19;
         break L1160;
        }
        if ((HEAP32[i18 + (i9 << 4) + 8 >> 2] | 0) >>> 0 <= i12 >>> 0) {
         i26 = i9;
         i27 = i22;
         i28 = i19;
         break L1160;
        }
       }
      } while (0);
      i9 = i9 + 1 | 0;
     }
    }
   }
  } while (0);
  i9 = i16;
  L1212 : while (1) {
   if (i7) {
    i34 = -1;
   } else {
    i34 = HEAP32[i15 >> 2] | 0;
   }
   i19 = HEAP32[i18 + (i9 << 4) >> 2] | 0;
   if ((i19 | 0) == 0) {
    i35 = -1;
   } else {
    i35 = HEAP32[i19 + 12 >> 2] | 0;
   }
   if (i13) {
    i36 = -1;
   } else {
    i36 = HEAP32[i14 >> 2] | 0;
   }
   i22 = HEAP32[i18 + (i9 << 4) + 4 >> 2] | 0;
   if ((i22 | 0) == 0) {
    i37 = -1;
   } else {
    i37 = HEAP32[i22 + 12 >> 2] | 0;
   }
   do {
    if ((i34 | 0) <= (i35 | 0)) {
     i31 = (i10 | 0) == (i19 | 0);
     i20 = i31 & (i36 | 0) > (i37 | 0);
     if (i20 | i31 ^ 1) {
      if (i20) {
       break;
      } else {
       break L1212;
      }
     }
     if ((i11 | 0) != (i22 | 0)) {
      break L1212;
     }
     if (i12 >>> 0 <= (HEAP32[i18 + (i9 << 4) + 8 >> 2] | 0) >>> 0) {
      break L1212;
     }
    }
   } while (0);
   i9 = i9 - 1 | 0;
  }
  if ((i26 | 0) > (i9 | 0)) {
   i38 = i9;
   i39 = i26;
  } else {
   i22 = HEAP32[i18 + (i26 << 4) + 8 >> 2] | 0;
   i19 = HEAP32[i18 + (i26 << 4) + 12 >> 2] | 0;
   i20 = i18 + (i26 << 4) | 0;
   i31 = i18 + (i9 << 4) | 0;
   HEAP32[i20 >> 2] = HEAP32[i31 >> 2];
   HEAP32[i20 + 4 >> 2] = HEAP32[i31 + 4 >> 2];
   HEAP32[i20 + 8 >> 2] = HEAP32[i31 + 8 >> 2];
   HEAP32[i20 + 12 >> 2] = HEAP32[i31 + 12 >> 2];
   i31 = HEAP32[i8 >> 2] | 0;
   HEAP32[i31 + (i9 << 4) >> 2] = i27;
   HEAP32[i31 + (i9 << 4) + 4 >> 2] = i28;
   HEAP32[i31 + (i9 << 4) + 8 >> 2] = i22;
   HEAP32[i31 + (i9 << 4) + 12 >> 2] = i19;
   i38 = i9 - 1 | 0;
   i39 = i26 + 1 | 0;
  }
  if ((i39 | 0) > (i38 | 0)) {
   break;
  }
  i16 = i38;
  i17 = i39;
  i18 = HEAP32[i8 >> 2] | 0;
 }
 if ((i38 | 0) > (i3 | 0)) {
  __ZN20btAlignedObjectArrayI16btBroadphasePairE17quickSortInternalI29btBroadphasePairSortPredicateEEvT_ii(i1, i6, i3, i38);
 }
 if ((i39 | 0) >= (i4 | 0)) {
  STACKTOP = i5;
  return;
 }
 __ZN20btAlignedObjectArrayI16btBroadphasePairE17quickSortInternalI29btBroadphasePairSortPredicateEEvT_ii(i1, i2, i39, i4);
 STACKTOP = i5;
 return;
}
function __ZN31btDefaultCollisionConfigurationC2ERK34btDefaultCollisionConstructionInfo(i1, i2) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 var i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0;
 HEAP32[i1 >> 2] = 2608;
 i3 = __Z22btAlignedAllocInternalji(360, 16) | 0;
 if ((i3 | 0) == 0) {
  i4 = 0;
 } else {
  HEAPF32[i3 + 308 >> 2] = 9999999747378752.0e-20;
  i5 = i3 + 332 | 0;
  HEAP16[i5 >> 1] = HEAP16[i5 >> 1] & -16;
  i4 = i3;
 }
 i3 = i1 + 32 | 0;
 HEAP32[i3 >> 2] = i4;
 i4 = (HEAP32[i2 + 28 >> 2] | 0) == 0;
 i5 = __Z22btAlignedAllocInternalji(4, 16) | 0;
 i6 = (i5 | 0) == 0;
 if (i4) {
  if (i6) {
   i7 = 0;
  } else {
   HEAP32[i5 >> 2] = 2496;
   i7 = i5;
  }
  HEAP32[i1 + 36 >> 2] = i7;
 } else {
  if (i6) {
   i8 = 0;
  } else {
   HEAP32[i5 >> 2] = 2696;
   i8 = i5;
  }
  HEAP32[i1 + 36 >> 2] = i8;
 }
 i8 = __Z22btAlignedAllocInternalji(24, 16) | 0;
 if ((i8 | 0) == 0) {
  i9 = 0;
 } else {
  i5 = i8;
  __ZN23btConvexConvexAlgorithm10CreateFuncC2EP22btVoronoiSimplexSolverP30btConvexPenetrationDepthSolver(i5, HEAP32[i3 >> 2] | 0, HEAP32[i1 + 36 >> 2] | 0);
  i9 = i5;
 }
 HEAP32[i1 + 40 >> 2] = i9;
 i9 = __Z22btAlignedAllocInternalji(8, 16) | 0;
 if ((i9 | 0) == 0) {
  i10 = 0;
 } else {
  HEAP8[i9 + 4 | 0] = 0;
  HEAP32[i9 >> 2] = 1992;
  i10 = i9;
 }
 HEAP32[i1 + 44 >> 2] = i10;
 i10 = __Z22btAlignedAllocInternalji(8, 16) | 0;
 if ((i10 | 0) == 0) {
  i11 = 0;
 } else {
  HEAP8[i10 + 4 | 0] = 0;
  HEAP32[i10 >> 2] = 1960;
  i11 = i10;
 }
 HEAP32[i1 + 48 >> 2] = i11;
 i11 = __Z22btAlignedAllocInternalji(8, 16) | 0;
 if ((i11 | 0) == 0) {
  i12 = 0;
 } else {
  HEAP8[i11 + 4 | 0] = 0;
  HEAP32[i11 >> 2] = 2120;
  i12 = i11;
 }
 HEAP32[i1 + 52 >> 2] = i12;
 i12 = __Z22btAlignedAllocInternalji(8, 16) | 0;
 if ((i12 | 0) == 0) {
  i13 = 0;
 } else {
  HEAP8[i12 + 4 | 0] = 0;
  HEAP32[i12 >> 2] = 2088;
  i13 = i12;
 }
 HEAP32[i1 + 56 >> 2] = i13;
 i13 = __Z22btAlignedAllocInternalji(8, 16) | 0;
 if ((i13 | 0) == 0) {
  i14 = 0;
 } else {
  HEAP8[i13 + 4 | 0] = 0;
  HEAP32[i13 >> 2] = 2216;
  i14 = i13;
 }
 HEAP32[i1 + 60 >> 2] = i14;
 i14 = __Z22btAlignedAllocInternalji(8, 16) | 0;
 if ((i14 | 0) == 0) {
  i15 = 0;
 } else {
  HEAP8[i14 + 4 | 0] = 0;
  HEAP32[i14 >> 2] = 2024;
  i15 = i14;
 }
 HEAP32[i1 + 64 >> 2] = i15;
 i15 = __Z22btAlignedAllocInternalji(8, 16) | 0;
 if ((i15 | 0) == 0) {
  i16 = 0;
 } else {
  HEAP8[i15 + 4 | 0] = 0;
  HEAP32[i15 >> 2] = 1928;
  i16 = i15;
 }
 HEAP32[i1 + 72 >> 2] = i16;
 i16 = __Z22btAlignedAllocInternalji(8, 16) | 0;
 if ((i16 | 0) == 0) {
  i17 = 0;
 } else {
  HEAP8[i16 + 4 | 0] = 0;
  HEAP32[i16 >> 2] = 1928;
  i17 = i16;
 }
 HEAP32[i1 + 76 >> 2] = i17;
 HEAP8[i17 + 4 | 0] = 1;
 i17 = __Z22btAlignedAllocInternalji(8, 16) | 0;
 if ((i17 | 0) == 0) {
  i18 = 0;
 } else {
  HEAP8[i17 + 4 | 0] = 0;
  HEAP32[i17 >> 2] = 2152;
  i18 = i17;
 }
 HEAP32[i1 + 68 >> 2] = i18;
 i18 = __Z22btAlignedAllocInternalji(16, 16) | 0;
 if ((i18 | 0) == 0) {
  i19 = 0;
 } else {
  HEAP8[i18 + 4 | 0] = 0;
  HEAP32[i18 >> 2] = 2056;
  HEAP32[i18 + 8 >> 2] = 1;
  HEAP32[i18 + 12 >> 2] = 1;
  i19 = i18;
 }
 HEAP32[i1 + 84 >> 2] = i19;
 i19 = __Z22btAlignedAllocInternalji(16, 16) | 0;
 if ((i19 | 0) == 0) {
  i20 = 0;
 } else {
  HEAP8[i19 + 4 | 0] = 0;
  HEAP32[i19 >> 2] = 2056;
  HEAP32[i19 + 8 >> 2] = 1;
  HEAP32[i19 + 12 >> 2] = 1;
  i20 = i19;
 }
 HEAP32[i1 + 80 >> 2] = i20;
 HEAP8[i20 + 4 | 0] = 1;
 i20 = HEAP32[i2 + 20 >> 2] | 0;
 i19 = (i20 | 0) < 36 ? 36 : i20;
 i20 = (i19 | 0) > 80 ? i19 : 80;
 i19 = (i20 | 0) > 44 ? i20 : 44;
 i20 = HEAP32[i2 >> 2] | 0;
 i18 = i1 + 12 | 0;
 if ((i20 | 0) == 0) {
  HEAP8[i18] = 1;
  i17 = __Z22btAlignedAllocInternalji(20, 16) | 0;
  if ((i17 | 0) == 0) {
   i21 = 0;
  } else {
   i16 = HEAP32[i2 + 24 >> 2] | 0;
   _memset(i17 | 0, 0, 17);
   i15 = i17;
   HEAP32[i15 >> 2] = 0;
   HEAP32[i17 + 8 >> 2] = 0;
   HEAP32[i15 >> 2] = __Z22btAlignedAllocInternalji(i16, 16) | 0;
   HEAP32[i17 + 4 >> 2] = i16;
   i21 = i17;
  }
  HEAP32[i1 + 8 >> 2] = i21;
 } else {
  HEAP8[i18] = 0;
  HEAP32[i1 + 8 >> 2] = i20;
 }
 i20 = HEAP32[i2 + 4 >> 2] | 0;
 i18 = i1 + 20 | 0;
 if ((i20 | 0) == 0) {
  HEAP8[i18] = 1;
  i21 = __Z22btAlignedAllocInternalji(20, 16) | 0;
  if ((i21 | 0) == 0) {
   i22 = 0;
  } else {
   i17 = i21;
   i16 = HEAP32[i2 + 12 >> 2] | 0;
   i15 = i21;
   HEAP32[i15 >> 2] = 1140;
   i14 = i21 + 4 | 0;
   HEAP32[i14 >> 2] = i16;
   i13 = __Z22btAlignedAllocInternalji(i16 * 1140 | 0, 16) | 0;
   HEAP32[i21 + 16 >> 2] = i13;
   HEAP32[i21 + 12 >> 2] = i13;
   i16 = HEAP32[i14 >> 2] | 0;
   HEAP32[i21 + 8 >> 2] = i16;
   i21 = i16 - 1 | 0;
   if ((i21 | 0) == 0) {
    i23 = i13;
   } else {
    i16 = HEAP32[i15 >> 2] | 0;
    i15 = i13;
    i14 = i21;
    while (1) {
     i12 = i15 + i16 | 0;
     HEAP32[i15 >> 2] = i12;
     i11 = i14 - 1 | 0;
     if ((i11 | 0) == 0) {
      break;
     } else {
      i15 = i12;
      i14 = i11;
     }
    }
    i23 = i13 + (Math_imul(i16, i21) | 0) | 0;
   }
   HEAP32[i23 >> 2] = 0;
   i22 = i17;
  }
  HEAP32[i1 + 16 >> 2] = i22;
 } else {
  HEAP8[i18] = 0;
  HEAP32[i1 + 16 >> 2] = i20;
 }
 i20 = HEAP32[i2 + 8 >> 2] | 0;
 i18 = i1 + 28 | 0;
 if ((i20 | 0) != 0) {
  HEAP8[i18] = 0;
  HEAP32[i1 + 24 >> 2] = i20;
  return;
 }
 HEAP8[i18] = 1;
 i18 = __Z22btAlignedAllocInternalji(20, 16) | 0;
 if ((i18 | 0) == 0) {
  i24 = 0;
 } else {
  i20 = i18;
  i22 = HEAP32[i2 + 16 >> 2] | 0;
  i2 = i18;
  HEAP32[i2 >> 2] = i19;
  i17 = i18 + 4 | 0;
  HEAP32[i17 >> 2] = i22;
  i23 = __Z22btAlignedAllocInternalji(Math_imul(i22, i19) | 0, 16) | 0;
  HEAP32[i18 + 16 >> 2] = i23;
  HEAP32[i18 + 12 >> 2] = i23;
  i19 = HEAP32[i17 >> 2] | 0;
  HEAP32[i18 + 8 >> 2] = i19;
  i18 = i19 - 1 | 0;
  if ((i18 | 0) == 0) {
   i25 = i23;
  } else {
   i19 = HEAP32[i2 >> 2] | 0;
   i2 = i23;
   i17 = i18;
   while (1) {
    i22 = i2 + i19 | 0;
    HEAP32[i2 >> 2] = i22;
    i21 = i17 - 1 | 0;
    if ((i21 | 0) == 0) {
     break;
    } else {
     i2 = i22;
     i17 = i21;
    }
   }
   i25 = i23 + (Math_imul(i19, i18) | 0) | 0;
  }
  HEAP32[i25 >> 2] = 0;
  i24 = i20;
 }
 HEAP32[i1 + 24 >> 2] = i24;
 return;
}
function __ZN20btPersistentManifold20refreshContactPointsERK11btTransformS2_(i1, i2, i3) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 var i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, d29 = 0.0, d30 = 0.0, d31 = 0.0, d32 = 0.0, d33 = 0.0, d34 = 0.0, d35 = 0.0, d36 = 0.0, d37 = 0.0, i38 = 0, i39 = 0;
 i4 = i1 + 1116 | 0;
 i5 = HEAP32[i4 >> 2] | 0;
 if ((i5 | 0) <= 0) {
  return;
 }
 i6 = i2 | 0;
 i7 = i2 + 4 | 0;
 i8 = i2 + 8 | 0;
 i9 = i2 + 48 | 0;
 i10 = i2 + 16 | 0;
 i11 = i2 + 20 | 0;
 i12 = i2 + 24 | 0;
 i13 = i2 + 52 | 0;
 i14 = i2 + 32 | 0;
 i15 = i2 + 36 | 0;
 i16 = i2 + 40 | 0;
 i17 = i2 + 56 | 0;
 i2 = i3 | 0;
 i18 = i3 + 4 | 0;
 i19 = i3 + 8 | 0;
 i20 = i3 + 48 | 0;
 i21 = i3 + 16 | 0;
 i22 = i3 + 20 | 0;
 i23 = i3 + 24 | 0;
 i24 = i3 + 52 | 0;
 i25 = i3 + 32 | 0;
 i26 = i3 + 36 | 0;
 i27 = i3 + 40 | 0;
 i28 = i3 + 56 | 0;
 i3 = i5;
 do {
  i3 = i3 - 1 | 0;
  d29 = +HEAPF32[i1 + 4 + (i3 * 276 | 0) >> 2];
  d30 = +HEAPF32[i1 + 4 + (i3 * 276 | 0) + 4 >> 2];
  d31 = +HEAPF32[i1 + 4 + (i3 * 276 | 0) + 8 >> 2];
  d32 = +HEAPF32[i9 >> 2] + (+HEAPF32[i6 >> 2] * d29 + +HEAPF32[i7 >> 2] * d30 + +HEAPF32[i8 >> 2] * d31);
  d33 = +HEAPF32[i13 >> 2] + (d29 * +HEAPF32[i10 >> 2] + d30 * +HEAPF32[i11 >> 2] + d31 * +HEAPF32[i12 >> 2]);
  d34 = +HEAPF32[i17 >> 2] + (d29 * +HEAPF32[i14 >> 2] + d30 * +HEAPF32[i15 >> 2] + d31 * +HEAPF32[i16 >> 2]);
  HEAPF32[i1 + 4 + (i3 * 276 | 0) + 48 >> 2] = d32;
  HEAPF32[i1 + 4 + (i3 * 276 | 0) + 52 >> 2] = d33;
  HEAPF32[i1 + 4 + (i3 * 276 | 0) + 56 >> 2] = d34;
  HEAPF32[i1 + 4 + (i3 * 276 | 0) + 60 >> 2] = 0.0;
  d31 = +HEAPF32[i1 + 4 + (i3 * 276 | 0) + 16 >> 2];
  d30 = +HEAPF32[i1 + 4 + (i3 * 276 | 0) + 20 >> 2];
  d29 = +HEAPF32[i1 + 4 + (i3 * 276 | 0) + 24 >> 2];
  d35 = +HEAPF32[i20 >> 2] + (+HEAPF32[i2 >> 2] * d31 + +HEAPF32[i18 >> 2] * d30 + +HEAPF32[i19 >> 2] * d29);
  d36 = +HEAPF32[i24 >> 2] + (d31 * +HEAPF32[i21 >> 2] + d30 * +HEAPF32[i22 >> 2] + d29 * +HEAPF32[i23 >> 2]);
  d37 = +HEAPF32[i28 >> 2] + (d31 * +HEAPF32[i25 >> 2] + d30 * +HEAPF32[i26 >> 2] + d29 * +HEAPF32[i27 >> 2]);
  HEAPF32[i1 + 4 + (i3 * 276 | 0) + 32 >> 2] = d35;
  HEAPF32[i1 + 4 + (i3 * 276 | 0) + 36 >> 2] = d36;
  HEAPF32[i1 + 4 + (i3 * 276 | 0) + 40 >> 2] = d37;
  HEAPF32[i1 + 4 + (i3 * 276 | 0) + 44 >> 2] = 0.0;
  HEAPF32[i1 + 4 + (i3 * 276 | 0) + 80 >> 2] = (d32 - d35) * +HEAPF32[i1 + 4 + (i3 * 276 | 0) + 64 >> 2] + (d33 - d36) * +HEAPF32[i1 + 4 + (i3 * 276 | 0) + 68 >> 2] + (d34 - d37) * +HEAPF32[i1 + 4 + (i3 * 276 | 0) + 72 >> 2];
  i5 = i1 + 4 + (i3 * 276 | 0) + 144 | 0;
  HEAP32[i5 >> 2] = (HEAP32[i5 >> 2] | 0) + 1;
 } while ((i3 | 0) > 0);
 i3 = HEAP32[i4 >> 2] | 0;
 if ((i3 | 0) <= 0) {
  return;
 }
 i27 = i1 + 1120 | 0;
 i26 = i1 + 1124 | 0;
 i25 = i1 + 1108 | 0;
 i28 = i1 + 1112 | 0;
 i23 = i3;
 do {
  i23 = i23 - 1 | 0;
  i3 = i1 + 4 + (i23 * 276 | 0) | 0;
  d37 = +HEAPF32[i1 + 4 + (i23 * 276 | 0) + 80 >> 2];
  do {
   if (d37 > +HEAPF32[((HEAP32[i1 + 4 + (i23 * 276 | 0) + 144 >> 2] | 0) > 1 ? i27 : i26) >> 2]) {
    i22 = i1 + 4 + (i23 * 276 | 0) + 108 | 0;
    i21 = HEAP32[i22 >> 2] | 0;
    do {
     if ((i21 | 0) != 0) {
      i24 = HEAP32[3008] | 0;
      if ((i24 | 0) == 0) {
       break;
      }
      FUNCTION_TABLE_ii[i24 & 127](i21) | 0;
      HEAP32[i22 >> 2] = 0;
     }
    } while (0);
    i22 = HEAP32[i4 >> 2] | 0;
    i21 = i22 - 1 | 0;
    if ((i21 | 0) == (i23 | 0)) {
     i38 = i22;
    } else {
     i22 = i3;
     i24 = i1 + 4 + (i21 * 276 | 0) | 0;
     _memcpy(i22 | 0, i24 | 0, 276) | 0;
     HEAP32[i1 + 4 + (i21 * 276 | 0) + 108 >> 2] = 0;
     HEAPF32[i1 + 4 + (i21 * 276 | 0) + 208 >> 2] = 0.0;
     HEAPF32[i1 + 4 + (i21 * 276 | 0) + 240 >> 2] = 0.0;
     HEAPF32[i1 + 4 + (i21 * 276 | 0) + 272 >> 2] = 0.0;
     HEAPF32[i1 + 4 + (i21 * 276 | 0) + 112 >> 2] = 0.0;
     HEAP8[i1 + 4 + (i21 * 276 | 0) + 116 | 0] = 0;
     HEAPF32[i1 + 4 + (i21 * 276 | 0) + 120 >> 2] = 0.0;
     HEAPF32[i1 + 4 + (i21 * 276 | 0) + 124 >> 2] = 0.0;
     HEAP32[i1 + 4 + (i21 * 276 | 0) + 144 >> 2] = 0;
     i38 = HEAP32[i4 >> 2] | 0;
    }
    HEAP32[i4 >> 2] = i38 - 1;
   } else {
    d34 = +HEAPF32[i1 + 4 + (i23 * 276 | 0) + 32 >> 2] - (+HEAPF32[i1 + 4 + (i23 * 276 | 0) + 48 >> 2] - d37 * +HEAPF32[i1 + 4 + (i23 * 276 | 0) + 64 >> 2]);
    d36 = +HEAPF32[i1 + 4 + (i23 * 276 | 0) + 36 >> 2] - (+HEAPF32[i1 + 4 + (i23 * 276 | 0) + 52 >> 2] - d37 * +HEAPF32[i1 + 4 + (i23 * 276 | 0) + 68 >> 2]);
    d33 = +HEAPF32[i1 + 4 + (i23 * 276 | 0) + 40 >> 2] - (+HEAPF32[i1 + 4 + (i23 * 276 | 0) + 56 >> 2] - d37 * +HEAPF32[i1 + 4 + (i23 * 276 | 0) + 72 >> 2]);
    d35 = +HEAPF32[i27 >> 2];
    if (d34 * d34 + d36 * d36 + d33 * d33 <= d35 * d35) {
     i21 = HEAP32[3006] | 0;
     if ((i21 | 0) == 0) {
      break;
     }
     i24 = HEAP32[i25 >> 2] | 0;
     i22 = HEAP32[i28 >> 2] | 0;
     FUNCTION_TABLE_iiii[i21 & 31](i3, i24, i22) | 0;
     break;
    }
    i22 = i1 + 4 + (i23 * 276 | 0) + 108 | 0;
    i24 = HEAP32[i22 >> 2] | 0;
    do {
     if ((i24 | 0) != 0) {
      i21 = HEAP32[3008] | 0;
      if ((i21 | 0) == 0) {
       break;
      }
      FUNCTION_TABLE_ii[i21 & 127](i24) | 0;
      HEAP32[i22 >> 2] = 0;
     }
    } while (0);
    i22 = HEAP32[i4 >> 2] | 0;
    i24 = i22 - 1 | 0;
    if ((i24 | 0) == (i23 | 0)) {
     i39 = i22;
    } else {
     i22 = i3;
     i21 = i1 + 4 + (i24 * 276 | 0) | 0;
     _memcpy(i22 | 0, i21 | 0, 276) | 0;
     HEAP32[i1 + 4 + (i24 * 276 | 0) + 108 >> 2] = 0;
     HEAPF32[i1 + 4 + (i24 * 276 | 0) + 208 >> 2] = 0.0;
     HEAPF32[i1 + 4 + (i24 * 276 | 0) + 240 >> 2] = 0.0;
     HEAPF32[i1 + 4 + (i24 * 276 | 0) + 272 >> 2] = 0.0;
     HEAPF32[i1 + 4 + (i24 * 276 | 0) + 112 >> 2] = 0.0;
     HEAP8[i1 + 4 + (i24 * 276 | 0) + 116 | 0] = 0;
     HEAPF32[i1 + 4 + (i24 * 276 | 0) + 120 >> 2] = 0.0;
     HEAPF32[i1 + 4 + (i24 * 276 | 0) + 124 >> 2] = 0.0;
     HEAP32[i1 + 4 + (i24 * 276 | 0) + 144 >> 2] = 0;
     i39 = HEAP32[i4 >> 2] | 0;
    }
    HEAP32[i4 >> 2] = i39 - 1;
   }
  } while (0);
 } while ((i23 | 0) > 0);
 return;
}
function __ZN31btConvexPlaneCollisionAlgorithm20collideSingleContactERK12btQuaternionP17btCollisionObjectS4_RK16btDispatcherInfoP16btManifoldResult(i1, i2, i3, i4, i5, i6) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 var i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, d14 = 0.0, d15 = 0.0, d16 = 0.0, d17 = 0.0, d18 = 0.0, d19 = 0.0, d20 = 0.0, d21 = 0.0, d22 = 0.0, d23 = 0.0, d24 = 0.0, d25 = 0.0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, d33 = 0.0, d34 = 0.0, d35 = 0.0, d36 = 0.0, d37 = 0.0, d38 = 0.0, d39 = 0.0, d40 = 0.0, d41 = 0.0, i42 = 0, d43 = 0.0, i44 = 0, d45 = 0.0, i46 = 0, d47 = 0.0, d48 = 0.0, d49 = 0.0, d50 = 0.0, d51 = 0.0, d52 = 0.0, d53 = 0.0, d54 = 0.0, d55 = 0.0, d56 = 0.0, d57 = 0.0, d58 = 0.0, d59 = 0.0, d60 = 0.0, d61 = 0.0, d62 = 0.0, d63 = 0.0, i64 = 0, i65 = 0;
 i5 = STACKTOP;
 STACKTOP = STACKTOP + 64 | 0;
 i7 = i5 | 0;
 i8 = i5 + 16 | 0;
 i9 = i5 + 32 | 0;
 i10 = i5 + 48 | 0;
 i11 = (HEAP8[i1 + 16 | 0] | 0) != 0;
 i12 = i11 ? i4 : i3;
 i13 = i11 ? i3 : i4;
 i4 = HEAP32[i12 + 192 >> 2] | 0;
 i3 = HEAP32[i13 + 192 >> 2] | 0;
 d14 = +HEAPF32[i12 + 4 >> 2];
 d15 = +HEAPF32[i12 + 8 >> 2];
 d16 = +HEAPF32[i12 + 12 >> 2];
 d17 = +HEAPF32[i12 + 20 >> 2];
 d18 = +HEAPF32[i12 + 24 >> 2];
 d19 = +HEAPF32[i12 + 28 >> 2];
 d20 = +HEAPF32[i12 + 36 >> 2];
 d21 = +HEAPF32[i12 + 40 >> 2];
 d22 = +HEAPF32[i12 + 44 >> 2];
 d23 = +HEAPF32[i12 + 52 >> 2];
 d24 = +HEAPF32[i12 + 56 >> 2];
 d25 = +HEAPF32[i12 + 60 >> 2];
 i12 = i13 + 4 | 0;
 i11 = i13 + 20 | 0;
 i26 = i13 + 36 | 0;
 i27 = i13 + 8 | 0;
 i28 = i13 + 24 | 0;
 i29 = i13 + 40 | 0;
 i30 = i13 + 12 | 0;
 i31 = i13 + 28 | 0;
 i32 = i13 + 44 | 0;
 d33 = +HEAPF32[i12 >> 2];
 d34 = +HEAPF32[i11 >> 2];
 d35 = +HEAPF32[i26 >> 2];
 d36 = +HEAPF32[i27 >> 2];
 d37 = +HEAPF32[i28 >> 2];
 d38 = +HEAPF32[i29 >> 2];
 d39 = +HEAPF32[i30 >> 2];
 d40 = +HEAPF32[i31 >> 2];
 d41 = +HEAPF32[i32 >> 2];
 i42 = i13 + 52 | 0;
 d43 = -0.0 - +HEAPF32[i42 >> 2];
 i44 = i13 + 56 | 0;
 d45 = -0.0 - +HEAPF32[i44 >> 2];
 i46 = i13 + 60 | 0;
 d47 = -0.0 - +HEAPF32[i46 >> 2];
 d48 = +HEAPF32[i2 >> 2];
 d49 = +HEAPF32[i2 + 4 >> 2];
 d50 = +HEAPF32[i2 + 8 >> 2];
 d51 = +HEAPF32[i2 + 12 >> 2];
 d52 = 2.0 / (d48 * d48 + d49 * d49 + d50 * d50 + d51 * d51);
 d53 = d48 * d52;
 d54 = d49 * d52;
 d55 = d50 * d52;
 d52 = d51 * d53;
 d56 = d51 * d54;
 d57 = d51 * d55;
 d51 = d48 * d53;
 d53 = d48 * d54;
 d58 = d48 * d55;
 d48 = d49 * d54;
 d54 = d49 * d55;
 d49 = d50 * d55;
 d55 = 1.0 - (d48 + d49);
 d50 = d53 - d57;
 d59 = d58 + d56;
 d60 = d53 + d57;
 d57 = 1.0 - (d51 + d49);
 d49 = d54 - d52;
 d53 = d58 - d56;
 d56 = d54 + d52;
 d52 = 1.0 - (d51 + d48);
 d48 = d16 * d53 + (d15 * d60 + d14 * d55);
 d51 = d16 * d56 + (d14 * d50 + d15 * d57);
 d54 = d14 * d59 + d15 * d49 + d16 * d52;
 d58 = d19 * d53 + (d18 * d60 + d17 * d55);
 d61 = d19 * d56 + (d17 * d50 + d18 * d57);
 d62 = d17 * d59 + d18 * d49 + d19 * d52;
 d63 = d22 * d53 + (d21 * d60 + d20 * d55);
 d55 = d22 * d56 + (d20 * d50 + d21 * d57);
 d57 = d20 * d59 + d21 * d49 + d22 * d52;
 i2 = HEAP32[(HEAP32[i4 >> 2] | 0) + 60 >> 2] | 0;
 i13 = i3 + 48 | 0;
 d52 = -0.0 - +HEAPF32[i13 >> 2];
 i64 = i3 + 52 | 0;
 d49 = -0.0 - +HEAPF32[i64 >> 2];
 i65 = i3 + 56 | 0;
 d59 = -0.0 - +HEAPF32[i65 >> 2];
 HEAPF32[i8 >> 2] = (d41 * d63 + (d39 * d48 + d40 * d58)) * d59 + ((d35 * d63 + (d33 * d48 + d34 * d58)) * d52 + (d38 * d63 + (d36 * d48 + d37 * d58)) * d49);
 HEAPF32[i8 + 4 >> 2] = (d41 * d55 + (d39 * d51 + d40 * d61)) * d59 + ((d35 * d55 + (d33 * d51 + d34 * d61)) * d52 + (d38 * d55 + (d36 * d51 + d37 * d61)) * d49);
 HEAPF32[i8 + 8 >> 2] = (d41 * d57 + (d39 * d54 + d40 * d62)) * d59 + ((d35 * d57 + (d33 * d54 + d34 * d62)) * d52 + (d38 * d57 + (d36 * d54 + d37 * d62)) * d49);
 HEAPF32[i8 + 12 >> 2] = 0.0;
 FUNCTION_TABLE_viii[i2 & 127](i7, i4, i8);
 d49 = +HEAPF32[i7 >> 2];
 d62 = +HEAPF32[i7 + 4 >> 2];
 d54 = +HEAPF32[i7 + 8 >> 2];
 d57 = d23 * d33 + d24 * d34 + d25 * d35 + (d33 * d43 + d34 * d45 + d35 * d47) + ((d14 * d33 + d17 * d34 + d20 * d35) * d49 + (d15 * d33 + d18 * d34 + d21 * d35) * d62 + (d16 * d33 + d19 * d34 + d22 * d35) * d54);
 d35 = d23 * d36 + d24 * d37 + d25 * d38 + (d36 * d43 + d37 * d45 + d38 * d47) + ((d14 * d36 + d17 * d37 + d20 * d38) * d49 + (d15 * d36 + d18 * d37 + d21 * d38) * d62 + (d16 * d36 + d19 * d37 + d22 * d38) * d54);
 d38 = d23 * d39 + d24 * d40 + d25 * d41 + (d39 * d43 + d40 * d45 + d41 * d47) + ((d14 * d39 + d17 * d40 + d20 * d41) * d49 + (d15 * d39 + d18 * d40 + d21 * d41) * d62 + (d16 * d39 + d19 * d40 + d22 * d41) * d54);
 d54 = +HEAPF32[i13 >> 2];
 d41 = +HEAPF32[i64 >> 2];
 d22 = +HEAPF32[i65 >> 2];
 d40 = d22 * d38 + (d54 * d57 + d41 * d35) - +HEAPF32[i3 + 64 >> 2];
 d19 = d57 - d54 * d40;
 d54 = d35 - d41 * d40;
 d41 = d38 - d22 * d40;
 d22 = +HEAPF32[i12 >> 2];
 d38 = +HEAPF32[i27 >> 2];
 d35 = +HEAPF32[i30 >> 2];
 d57 = +HEAPF32[i42 >> 2];
 d39 = +HEAPF32[i11 >> 2];
 d16 = +HEAPF32[i28 >> 2];
 d62 = +HEAPF32[i31 >> 2];
 d21 = +HEAPF32[i44 >> 2];
 d18 = +HEAPF32[i26 >> 2];
 d15 = +HEAPF32[i29 >> 2];
 d49 = +HEAPF32[i32 >> 2];
 d20 = +HEAPF32[i46 >> 2];
 i46 = i1 + 12 | 0;
 i1 = d40 < +__ZNK20btPersistentManifold27getContactBreakingThresholdEv(HEAP32[i46 >> 2] | 0);
 HEAP32[i6 + 4 >> 2] = HEAP32[i46 >> 2];
 if (!i1) {
  STACKTOP = i5;
  return;
 }
 d17 = +HEAPF32[i13 >> 2];
 d14 = +HEAPF32[i64 >> 2];
 d47 = +HEAPF32[i65 >> 2];
 d45 = d17 * +HEAPF32[i11 >> 2] + d14 * +HEAPF32[i28 >> 2] + d47 * +HEAPF32[i31 >> 2];
 d43 = d17 * +HEAPF32[i26 >> 2] + d14 * +HEAPF32[i29 >> 2] + d47 * +HEAPF32[i32 >> 2];
 HEAPF32[i9 >> 2] = +HEAPF32[i12 >> 2] * d17 + +HEAPF32[i27 >> 2] * d14 + +HEAPF32[i30 >> 2] * d47;
 HEAPF32[i9 + 4 >> 2] = d45;
 HEAPF32[i9 + 8 >> 2] = d43;
 HEAPF32[i9 + 12 >> 2] = 0.0;
 HEAPF32[i10 >> 2] = d57 + (d35 * d41 + (d22 * d19 + d38 * d54));
 