/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file was automatically generated by getCTKnownLogs.py. */

#ifndef CTKnownLogs_h
#define CTKnownLogs_h

#include "CTLog.h"

#include <stddef.h>

struct CTLogInfo {
  // See bug 1338873 about making these fields const.
  const char* name;
  // Index within kCTLogOperatorList.
  mozilla::ct::CTLogStatus status;
  // 0 for qualified logs, disqualification time for disqualified logs
  // (in milliseconds, measured since the epoch, ignoring leap seconds).
  uint64_t disqualificationTime;
  size_t operatorIndex;
  const char* key;
  size_t keyLength;
};

struct CTLogOperatorInfo {
  // See bug 1338873 about making these fields const.
  const char* name;
  mozilla::ct::CTLogOperatorId id;
};

const CTLogInfo kCTLogList[] = {
    {"Google 'Pilot' log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     0,  // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x7d\xa8\x4b\x12\x29\x80\xa3\x3d\xad"
     "\xd3\x5a\x77\xb8\xcc\xe2\x88\xb3\xa5\xfd\xf1\xd3\x0c\xcd\x18\x0c\xe8\x41"
     "\x46\xe8\x81\x01\x1b\x15\xe1\x4b\xf1\x1b\x62\xdd\x36\x0a\x08\x18\xba\xed"
     "\x0b\x35\x84\xd0\x9e\x40\x3c\x2d\x9e\x9b\x82\x65\xbd\x1f\x04\x10\x41\x4c"
     "\xa0",
     91},
    {"Google 'Aviator' log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     0,  // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xd7\xf4\xcc\x69\xb2\xe4\x0e\x90\xa3"
     "\x8a\xea\x5a\x70\x09\x4f\xef\x13\x62\xd0\x8d\x49\x60\xff\x1b\x40\x50\x07"
     "\x0c\x6d\x71\x86\xda\x25\x49\x8d\x65\xe1\x08\x0d\x47\x34\x6b\xbd\x27\xbc"
     "\x96\x21\x3e\x34\xf5\x87\x76\x31\xb1\x7f\x1d\xc9\x85\x3b\x0d\xf7\x1f\x3f"
     "\xe9",
     91},
    {"DigiCert Log Server", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     1,  // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x02\x46\xc5\xbe\x1b\xbb\x82\x40\x16"
     "\xe8\xc1\xd2\xac\x19\x69\x13\x59\xf8\xf8\x70\x85\x46\x40\xb9\x38\xb0\x23"
     "\x82\xa8\x64\x4c\x7f\xbf\xbb\x34\x9f\x4a\x5f\x28\x8a\xcf\x19\xc4\x00\xf6"
     "\x36\x06\x93\x65\xed\x4c\xf5\xa9\x21\x62\x5a\xd8\x91\xeb\x38\x24\x40\xac"
     "\xe8",
     91},
    {"Google 'Rocketeer' log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     0,  // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x20\x5b\x18\xc8\x3c\xc1\x8b\xb3\x31"
     "\x08\x00\xbf\xa0\x90\x57\x2b\xb7\x47\x8c\x6f\xb5\x68\xb0\x8e\x90\x78\xe9"
     "\xa0\x73\xea\x4f\x28\x21\x2e\x9c\xc0\xf4\x16\x1b\xaa\xf9\xd5\xd7\xa9\x80"
     "\xc3\x4e\x2f\x52\x3c\x98\x01\x25\x46\x24\x25\x28\x23\x77\x2d\x05\xc2\x40"
     "\x7a",
     91},
    {"Certly.IO log", mozilla::ct::CTLogStatus::Disqualified,
     1460678400000,  // Date.parse("2016-04-15T00:00:00Z")
     2,              // operated by Certly
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x0b\x23\xcb\x85\x62\x98\x61\x48\x04"
     "\x73\xeb\x54\x5d\xf3\xd0\x07\x8c\x2d\x19\x2d\x8c\x36\xf5\xeb\x8f\x01\x42"
     "\x0a\x7c\x98\x26\x27\xc1\xb5\xdd\x92\x93\xb0\xae\xf8\x9b\x3d\x0c\xd8\x4c"
     "\x4e\x1d\xf9\x15\xfb\x47\x68\x7b\xba\x66\xb7\x25\x9c\xd0\x4a\xc2\x66\xdb"
     "\x48",
     91},
    {"Izenpe log", mozilla::ct::CTLogStatus::Disqualified,
     1464566400000,  // Date.parse("2016-05-30T00:00:00Z")
     3,              // operated by Izenpe
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x27\x64\x39\x0c\x2d\xdc\x50\x18\xf8"
     "\x21\x00\xa2\x0e\xed\x2c\xea\x3e\x75\xba\x9f\x93\x64\x09\x00\x11\xc4\x11"
     "\x17\xab\x5c\xcf\x0f\x74\xac\xb5\x97\x90\x93\x00\x5b\xb8\xeb\xf7\x27\x3d"
     "\xd9\xb2\x0a\x81\x5f\x2f\x0d\x75\x38\x94\x37\x99\x1e\xf6\x07\x76\xe0\xee"
     "\xbe",
     91},
    {"Symantec log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     4,  // operated by Symantec
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x96\xea\xac\x1c\x46\x0c\x1b\x55\xdc"
     "\x0d\xfc\xb5\x94\x27\x46\x57\x42\x70\x3a\x69\x18\xe2\xbf\x3b\xc4\xdb\xab"
     "\xa0\xf4\xb6\x6c\xc0\x53\x3f\x4d\x42\x10\x33\xf0\x58\x97\x8f\x6b\xbe\x72"
     "\xf4\x2a\xec\x1c\x42\xaa\x03\x2f\x1a\x7e\x28\x35\x76\x99\x08\x3d\x21\x14"
     "\x86",
     91},
    {"Venafi log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     5,  // operated by Venafi
     "\x30\x82\x01\x22\x30\x0d\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x01\x05"
     "\x00\x03\x82\x01\x0f\x00\x30\x82\x01\x0a\x02\x82\x01\x01\x00\xa2\x5a\x48"
     "\x1f\x17\x52\x95\x35\xcb\xa3\x5b\x3a\x1f\x53\x82\x76\x94\xa3\xff\x80\xf2"
     "\x1c\x37\x3c\xc0\xb1\xbd\xc1\x59\x8b\xab\x2d\x65\x93\xd7\xf3\xe0\x04\xd5"
     "\x9a\x6f\xbf\xd6\x23\x76\x36\x4f\x23\x99\xcb\x54\x28\xad\x8c\x15\x4b\x65"
     "\x59\x76\x41\x4a\x9c\xa6\xf7\xb3\x3b\x7e\xb1\xa5\x49\xa4\x17\x51\x6c\x80"
     "\xdc\x2a\x90\x50\x4b\x88\x24\xe9\xa5\x12\x32\x93\x04\x48\x90\x02\xfa\x5f"
     "\x0e\x30\x87\x8e\x55\x76\x05\xee\x2a\x4c\xce\xa3\x6a\x69\x09\x6e\x25\xad"
     "\x82\x76\x0f\x84\x92\xfa\x38\xd6\x86\x4e\x24\x8f\x9b\xb0\x72\xcb\x9e\xe2"
     "\x6b\x3f\xe1\x6d\xc9\x25\x75\x23\x88\xa1\x18\x58\x06\x23\x33\x78\xda\x00"
     "\xd0\x38\x91\x67\xd2\xa6\x7d\x27\x97\x67\x5a\xc1\xf3\x2f\x17\xe6\xea\xd2"
     "\x5b\xe8\x81\xcd\xfd\x92\x68\xe7\xf3\x06\xf0\xe9\x72\x84\xee\x01\xa5\xb1"
     "\xd8\x33\xda\xce\x83\xa5\xdb\xc7\xcf\xd6\x16\x7e\x90\x75\x18\xbf\x16\xdc"
     "\x32\x3b\x6d\x8d\xab\x82\x17\x1f\x89\x20\x8d\x1d\x9a\xe6\x4d\x23\x08\xdf"
     "\x78\x6f\xc6\x05\xbf\x5f\xae\x94\x97\xdb\x5f\x64\xd4\xee\x16\x8b\xa3\x84"
     "\x6c\x71\x2b\xf1\xab\x7f\x5d\x0d\x32\xee\x04\xe2\x90\xec\x41\x9f\xfb\x39"
     "\xc1\x02\x03\x01\x00\x01",
     294},
    {"Symantec 'Vega' log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     4,  // operated by Symantec
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xea\x95\x9e\x02\xff\xee\xf1\x33\x6d"
     "\x4b\x87\xbc\xcd\xfd\x19\x17\x62\xff\x94\xd3\xd0\x59\x07\x3f\x02\x2d\x1c"
     "\x90\xfe\xc8\x47\x30\x3b\xf1\xdd\x0d\xb8\x11\x0c\x5d\x1d\x86\xdd\xab\xd3"
     "\x2b\x46\x66\xfb\x6e\x65\xb7\x3b\xfd\x59\x68\xac\xdf\xa6\xf8\xce\xd2\x18"
     "\x4d",
     91},
    {"CNNIC CT log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     6,  // operated by CNNIC
     "\x30\x82\x01\x22\x30\x0d\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x01\x05"
     "\x00\x03\x82\x01\x0f\x00\x30\x82\x01\x0a\x02\x82\x01\x01\x00\xbf\xb5\x08"
     "\x61\x9a\x29\x32\x04\xd3\x25\x63\xe9\xd8\x85\xe1\x86\xe0\x1f\xd6\x5e\x9a"
     "\xf7\x33\x3b\x80\x1b\xe7\xb6\x3e\x5f\x2d\xa1\x66\xf6\x95\x4a\x84\xa6\x21"
     "\x56\x79\xe8\xf7\x85\xee\x5d\xe3\x7c\x12\xc0\xe0\x89\x22\x09\x22\x3e\xba"
     "\x16\x95\x06\xbd\xa8\xb9\xb1\xa9\xb2\x7a\xd6\x61\x2e\x87\x11\xb9\x78\x40"
     "\x89\x75\xdb\x0c\xdc\x90\xe0\xa4\x79\xd6\xd5\x5e\x6e\xd1\x2a\xdb\x34\xf4"
     "\x99\x3f\x65\x89\x3b\x46\xc2\x29\x2c\x15\x07\x1c\xc9\x4b\x1a\x54\xf8\x6c"
     "\x1e\xaf\x60\x27\x62\x0a\x65\xd5\x9a\xb9\x50\x36\x16\x6e\x71\xf6\x1f\x01"
     "\xf7\x12\xa7\xfc\xbf\xf6\x21\xa3\x29\x90\x86\x2d\x77\xde\xbb\x4c\xd4\xcf"
     "\xfd\xd2\xcf\x82\x2c\x4d\xd4\xf2\xc2\x2d\xac\xa9\xbe\xea\xc3\x19\x25\x43"
     "\xb2\xe5\x9a\x6c\x0d\xc5\x1c\xa5\x8b\xf7\x3f\x30\xaf\xb9\x01\x91\xb7\x69"
     "\x12\x12\xe5\x83\x61\xfe\x34\x00\xbe\xf6\x71\x8a\xc7\xeb\x50\x92\xe8\x59"
     "\xfe\x15\x91\xeb\x96\x97\xf8\x23\x54\x3f\x2d\x8e\x07\xdf\xee\xda\xb3\x4f"
     "\xc8\x3c\x9d\x6f\xdf\x3c\x2c\x43\x57\xa1\x47\x0c\x91\x04\xf4\x75\x4d\xda"
     "\x89\x81\xa4\x14\x06\x34\xb9\x98\xc3\xda\xf1\xfd\xed\x33\x36\xd3\x16\x2d"
     "\x35\x02\x03\x01\x00\x01",
     294},
    {"WoSign log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     7,  // operated by WoSign
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xcc\x11\x88\x7b\x2d\x66\xcb\xae\x8f"
     "\x4d\x30\x66\x27\x19\x25\x22\x93\x21\x46\xb4\x2f\x01\xd3\xc6\xf9\x2b\xd5"
     "\xc8\xba\x73\x9b\x06\xa2\xf0\x8a\x02\x9c\xd0\x6b\x46\x18\x30\x85\xba\xe9"
     "\x24\x8b\x0e\xd1\x5b\x70\x28\x0c\x7e\xf1\x3a\x45\x7f\x5a\xf3\x82\x42\x60"
     "\x31",
     91},
    {"StartCom log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     8,  // operated by StartCom
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x48\xf3\x59\xf3\xf6\x05\x18\xd3\xdb"
     "\xb2\xed\x46\x7e\xcf\xc8\x11\xb5\x57\xb1\xa8\xd6\x4c\xe6\x9f\xb7\x4a\x1a"
     "\x14\x86\x43\xa9\x48\xb0\xcb\x5a\x3f\x3c\x4a\xca\xdf\xc4\x82\x14\x55\x9a"
     "\xf8\xf7\x8e\x40\x55\xdc\xf4\xd2\xaf\xea\x75\x74\xfb\x4e\x7f\x60\x86\x2e"
     "\x51",
     91},
#ifdef DEBUG
    {"Mozilla Test RSA Log 1", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     9,  // operated by GNU Test Org 1
     "\x30\x82\x01\x22\x30\x0d\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x01\x05"
     "\x00\x03\x82\x01\x0f\x00\x30\x82\x01\x0a\x02\x82\x01\x01\x00\xba\x88\x51"
     "\xa8\x44\x8e\x16\xd6\x41\xfd\x6e\xb6\x88\x06\x36\x10\x3d\x3c\x13\xd9\xea"
     "\xe4\x35\x4a\xb4\xec\xf5\x68\x57\x6c\x24\x7b\xc1\xc7\x25\xa8\xe0\xd8\x1f"
     "\xbd\xb1\x9c\x06\x9b\x6e\x1a\x86\xf2\x6b\xe2\xaf\x5a\x75\x6b\x6a\x64\x71"
     "\x08\x7a\xa5\x5a\xa7\x45\x87\xf7\x1c\xd5\x24\x9c\x02\x7e\xcd\x43\xfc\x1e"
     "\x69\xd0\x38\x20\x29\x93\xab\x20\xc3\x49\xe4\xdb\xb9\x4c\xc2\x6b\x6c\x0e"
     "\xed\x15\x82\x0f\xf1\x7e\xad\x69\x1a\xb1\xd3\x02\x3a\x8b\x2a\x41\xee\xa7"
     "\x70\xe0\x0f\x0d\x8d\xfd\x66\x0b\x2b\xb0\x24\x92\xa4\x7d\xb9\x88\x61\x79"
     "\x90\xb1\x57\x90\x3d\xd2\x3b\xc5\xe0\xb8\x48\x1f\xa8\x37\xd3\x88\x43\xef"
     "\x27\x16\xd8\x55\xb7\x66\x5a\xaa\x7e\x02\x90\x2f\x3a\x7b\x10\x80\x06\x24"
     "\xcc\x1c\x6c\x97\xad\x96\x61\x5b\xb7\xe2\x96\x12\xc0\x75\x31\xa3\x0c\x91"
     "\xdd\xb4\xca\xf7\xfc\xad\x1d\x25\xd3\x09\xef\xb9\x17\x0e\xa7\x68\xe1\xb3"
     "\x7b\x2f\x22\x6f\x69\xe3\xb4\x8a\x95\x61\x1d\xee\x26\xd6\x25\x9d\xab\x91"
     "\x08\x4e\x36\xcb\x1c\x24\x04\x2c\xbf\x16\x8b\x2f\xe5\xf1\x8f\x99\x17\x31"
     "\xb8\xb3\xfe\x49\x23\xfa\x72\x51\xc4\x31\xd5\x03\xac\xda\x18\x0a\x35\xed"
     "\x8d\x02\x03\x01\x00\x01",
     294},
#endif  // DEBUG
#ifdef DEBUG
    {"Mozilla Test RSA Log 2", mozilla::ct::CTLogStatus::Included,
     0,   // no disqualification time
     10,  // operated by GNU Test Org 2
     "\x30\x82\x01\x22\x30\x0d\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x01\x05"
     "\x00\x03\x82\x01\x0f\x00\x30\x82\x01\x0a\x02\x82\x01\x01\x00\xc1\x75\xc6"
     "\x52\x66\x09\x9f\x77\x08\x2a\x67\x91\xf1\xb8\x76\xc3\x7f\x5c\xe5\x38\xb0"
     "\x6c\x4a\xcd\x22\xb1\xcb\xd4\x6f\xa6\x5a\xda\x2a\xdd\x41\xc8\xc2\x49\x8a"
     "\xc4\xa3\xb3\xc1\xf6\x14\x87\xf4\x1b\x69\x89\x41\xbd\x80\xa5\x1c\x3c\x12"
     "\x02\x44\xc5\x84\xa4\xc4\x48\x33\x05\xe5\x13\x8c\x01\x06\xcf\x08\xbe\x9a"
     "\x86\x27\x60\xba\xe6\xa2\xe8\xf3\x6f\x23\xc5\xd9\x83\x13\xb9\xdf\xaf\x37"
     "\x83\x45\xda\xce\x51\xd4\xd6\xdc\xd2\xa6\xcb\x3c\xc7\x06\xeb\xcd\x30\x70"
     "\xec\x98\xcc\xe4\x0a\xa5\x91\xd7\x29\x5a\x7f\x71\xc5\xbe\x66\x69\x1d\x2b"
     "\x2d\xfe\xc8\x49\x44\x59\x0b\xc5\xa3\xea\x49\xfd\x93\xb1\xd7\x53\x40\x5f"
     "\x17\x73\x76\x99\x95\x86\x66\x25\x47\x97\xed\x42\x69\x08\x88\x08\x11\x42"
     "\x20\x69\x98\x8a\x43\xfe\xe4\x8c\xe6\x87\x81\xdd\x22\xb6\xa6\x9c\xd2\x83"
     "\x75\x13\x1f\x93\x2b\x12\x8c\xe2\x86\xfa\x7d\x25\x1c\x06\x2a\xd2\x7e\xf0"
     "\x16\xf1\x87\xcd\xd5\x4e\x83\x2b\x35\xb8\x93\x0f\x74\xba\x90\xaa\x8b\xc7"
     "\x61\x67\x24\x2a\xb1\xfd\x6d\x62\x14\x0d\x18\xc4\xc0\xb8\xc6\x8f\xc3\x74"
     "\x84\x57\x32\x4a\xd7\xde\x86\xe6\x55\x2f\x1d\x1e\x19\x1d\x71\x21\x68\xd3"
     "\xbb\x02\x03\x01\x00\x01",
     294},
#endif  // DEBUG
#ifdef DEBUG
    {"Mozilla Test EC Log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     9,  // operated by GNU Test Org 1
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x4f\xbf\xbb\xbb\x61\xe0\xf8\xf9\xb1"
     "\xa6\x0a\x59\xac\x87\x04\xe2\xec\x05\x0b\x42\x3e\x3c\xf7\x2e\x92\x3f\x2c"
     "\x4f\x79\x4b\x45\x5c\x2a\x69\xd2\x33\x45\x6c\x36\xc4\x11\x9d\x07\x06\xe0"
     "\x0e\xed\xc8\xd1\x93\x90\xd7\x99\x1b\x7b\x2d\x07\xa3\x04\xea\xa0\x4a\xa6"
     "\xc0",
     91},
#endif  // DEBUG
};

const CTLogOperatorInfo kCTLogOperatorList[] = {
    {"Google", 0},
    {"DigiCert", 1},
    {"Certly", 2},
    {"Izenpe", 3},
    {"Symantec", 4},
    {"Venafi", 5},
    {"CNNIC", 7},
    {"WoSign", 8},
    {"StartCom", 9},
#ifdef DEBUG
    {"Mozilla Test Org 1", 10},
#endif  // DEBUG
#ifdef DEBUG
    {"Mozilla Test Org 2", 11},
#endif  // DEBUG
};

#endif  // CTKnownLogs_h
