/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.redisplay;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.tool.user.redisplay.ERaster;
import com.sun.electric.tool.user.redisplay.TransparentRaster;

class OpaqueRaster
implements ERaster {
    int[] opaqueData;
    int width;
    int col;

    OpaqueRaster(int[] opaqueData, int width, int col) {
        this.opaqueData = opaqueData;
        this.width = width;
        this.col = col;
    }

    @Override
    public void fillBox(int lX, int hX, int lY, int hY) {
        int baseIndex = lY * this.width;
        for (int y = lY; y <= hY; ++y) {
            for (int x = lX; x <= hX; ++x) {
                this.opaqueData[baseIndex + x] = this.col;
            }
            baseIndex += this.width;
        }
    }

    @Override
    public void fillHorLine(int y, int lX, int hX) {
        int baseIndex = y * this.width + lX;
        for (int x = lX; x <= hX; ++x) {
            this.opaqueData[baseIndex++] = this.col;
        }
    }

    @Override
    public void fillVerLine(int x, int lY, int hY) {
        int baseIndex = lY * this.width + x;
        for (int y = lY; y <= hY; ++y) {
            this.opaqueData[baseIndex] = this.col;
            baseIndex += this.width;
        }
    }

    @Override
    public void fillPoint(int x, int y) {
        this.opaqueData[y * this.width + x] = this.col;
    }

    @Override
    public void drawHorLine(int y, int lX, int hX) {
        int baseIndex = y * this.width + lX;
        for (int x = lX; x <= hX; ++x) {
            this.opaqueData[baseIndex++] = this.col;
        }
    }

    @Override
    public void drawVerLine(int x, int lY, int hY) {
        int baseIndex = lY * this.width + x;
        for (int y = lY; y <= hY; ++y) {
            this.opaqueData[baseIndex] = this.col;
            baseIndex += this.width;
        }
    }

    @Override
    public void drawPoint(int x, int y) {
        this.opaqueData[y * this.width + x] = this.col;
    }

    @Override
    public EGraphics.Outline getOutline() {
        return null;
    }

    @Override
    public void copyBits(TransparentRaster src, int minSrcX, int maxSrcX, int minSrcY, int maxSrcY, int dx, int dy) {
        int[] srcLayerBitMap = src.layerBitMap;
        for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
            int destY = srcY + dy;
            int destBase = destY * this.width;
            int srcBaseIndex = srcY * src.intsPerRow;
            for (int srcX = minSrcX; srcX <= maxSrcX; ++srcX) {
                int destX = srcX + dx;
                if ((srcLayerBitMap[srcBaseIndex + (srcX >> 5)] & 1 << (srcX & 0x1F)) == 0) continue;
                this.opaqueData[destBase + destX] = this.col;
            }
        }
    }
}

